{"vars":[{"name":"base","containerName":"","line":95,"kind":2},{"kind":12,"children":[{"kind":13,"line":114,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"name":"$width","definition":"my","containerName":"_initialize","localvar":"my","kind":13,"line":115},{"kind":13,"line":115,"containerName":"_initialize","name":"$height"},{"kind":13,"line":115,"containerName":"_initialize","name":"$margin"},{"name":"$stroke","containerName":"_initialize","kind":13,"line":115},{"line":116,"kind":13,"containerName":"_initialize","name":"$stroke_width"},{"name":"$font_size","containerName":"_initialize","kind":13,"line":116},{"line":117,"kind":13,"containerName":"_initialize","name":"$normalize"},{"name":"$self","containerName":"_initialize","kind":13,"line":117},{"kind":12,"line":117,"name":"_rearrange","containerName":"_initialize"},{"kind":13,"line":126,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"$width","line":126,"kind":13},{"kind":13,"line":127,"name":"$self","containerName":"_initialize"},{"name":"$height","containerName":"_initialize","line":127,"kind":13},{"containerName":"_initialize","name":"$self","kind":13,"line":128},{"kind":13,"line":128,"containerName":"_initialize","name":"$margin"},{"line":128,"kind":13,"name":"$margin","containerName":"_initialize"},{"line":129,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":13,"line":129,"containerName":"_initialize","name":"$stroke"},{"line":130,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":13,"line":130,"name":"$stroke_width","containerName":"_initialize"},{"line":131,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":13,"line":131,"name":"$font_size","containerName":"_initialize"},{"line":132,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":13,"line":132,"containerName":"_initialize","name":"$normalize"},{"containerName":"_initialize","name":"$self","line":133,"kind":13}],"line":113,"name":"_initialize","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":113},"end":{"line":134,"character":9999}}},{"name":"_width","kind":12,"line":126},{"name":"_height","kind":12,"line":127},{"kind":12,"line":128,"name":"_margin"},{"line":129,"kind":12,"name":"_stroke"},{"name":"_stroke_width","kind":12,"line":130},{"name":"_font_size","kind":12,"line":131},{"kind":12,"line":132,"name":"_normalize"},{"kind":12,"line":133,"name":"SUPER","containerName":"_initialize"},{"containerName":"main::","definition":"sub","detail":"($self,$tree)","signature":{"documentation":"1;\n#\n# BioPerl module for Bio::TreeIO::svg-graph\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Brian O'Connor\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::svggraph - A simple output format that converts a Tree object to an SVG output\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 'input', -format => 'newick');\n  my $out = Bio::TreeIO->new(-file => '>output', -format => 'svggraph');\n\n  while( my $tree = $in->next_tree ) {\n      my $svg_xml = $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis outputs a tree as an SVG graphic using the SVG::Graph API\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Brian OConnor\n\nEmail brian.oconnor-at-excite.com\n\n=head1 CONTRIBUTORS\n\nAllen Day\nGuillaume Rousse, Guillaume-dot-Rousse-at-inria-dot-fr\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::svggraph;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse SVG::Graph;\nuse SVG::Graph::Data;\nuse SVG::Graph::Data::Tree;\nuse SVG::Graph::Data::Node;\nuse Bio::Tree::TreeI;\nuse Bio::Tree::Node;\nuse Tree::DAG_Node;\n\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::svggraph->new();\n Function: Builds a new Bio::TreeIO::svggraph object \n Returns : Bio::TreeIO::svggraph\n Args    :-width    => image width (default 1600)\n          -height   => image height (default 1000)\n          -margin   => margin (default 30)\n          -stroke   => stroke color (default 'black')\n          -stroke_width=> stroke width (default 2)\n          -font_size=> font size (default '10px')\n          -nomalize => undef or 'log' (default is undef)\n\n\nsub _initialize {\n    my $self = shift;\n    my ($width,$height,$margin,$stroke,\n\t$stroke_width,$font_size,\n\t$normalize) = $self->_rearrange([qw\n\t\t\t\t\t (WIDTH\n\t\t\t\t\t  HEIGHT\n\t\t\t\t\t  MARGIN\n\t\t\t\t\t  STROKE\n\t\t\t\t\t  STROKE_WIDTH\n\t\t\t\t\t  FONT_SIZE\n\t\t\t\t\t  NORMALIZE)],\n\t\t\t\t\t@_);\n    $self->{_width}        = $width || 1600;\n    $self->{_height}       = $height || 1000;\n    $self->{_margin}       = defined $margin ? $margin : 30;\n    $self->{_stroke}       = $stroke || 'black';\n    $self->{_stroke_width} = $stroke_width || 2;\n    $self->{_font_size}    = $font_size || '10px';\n    $self->{_normalize}    = $normalize || '';\n    $self->SUPER::_initialize(@_);\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Write a tree out to data stream in newick/phylip format\n Returns : none\n Args    : Bio::Tree::TreeI object","parameters":[{"label":"$self"},{"label":"$tree"}],"label":"write_tree($self,$tree)"},"kind":12,"line":146,"children":[{"line":147,"kind":13,"localvar":"my","containerName":"write_tree","definition":"my","name":"$self"},{"containerName":"write_tree","name":"$tree","kind":13,"line":147},{"kind":13,"line":148,"definition":"my","name":"$line","containerName":"write_tree","localvar":"my"},{"line":148,"kind":13,"name":"$self","containerName":"write_tree"},{"line":148,"kind":12,"containerName":"write_tree","name":"_write_tree_Helper"},{"kind":13,"line":148,"name":"$tree","containerName":"write_tree"},{"name":"get_root_node","containerName":"write_tree","kind":12,"line":148},{"name":"$self","containerName":"write_tree","kind":13,"line":149},{"line":149,"kind":12,"name":"_print","containerName":"write_tree"},{"containerName":"write_tree","name":"$line","kind":13,"line":149},{"name":"$self","containerName":"write_tree","kind":13,"line":150},{"containerName":"write_tree","name":"flush","line":150,"kind":12},{"kind":13,"line":150,"containerName":"write_tree","name":"$self"},{"line":150,"kind":12,"containerName":"write_tree","name":"_flush_on_write"},{"name":"$self","containerName":"write_tree","kind":13,"line":150},{"line":150,"kind":12,"name":"_fh","containerName":"write_tree"}],"name":"write_tree","range":{"end":{"line":152,"character":9999},"start":{"line":146,"character":0}}},{"kind":12,"children":[{"containerName":"_write_tree_Helper","definition":"my","name":"$self","localvar":"my","kind":13,"line":155},{"line":155,"kind":13,"containerName":"_write_tree_Helper","name":"$node"},{"containerName":"_write_tree_Helper","name":"$graph","definition":"my","localvar":"my","kind":13,"line":157},{"containerName":"_write_tree_Helper","name":"new","kind":12,"line":158},{"name":"$self","containerName":"_write_tree_Helper","kind":13,"line":158},{"kind":13,"line":159,"containerName":"_write_tree_Helper","name":"$self"},{"kind":13,"line":160,"name":"$self","containerName":"_write_tree_Helper"},{"line":162,"kind":13,"localvar":"my","name":"$group0","definition":"my","containerName":"_write_tree_Helper"},{"name":"$graph","containerName":"_write_tree_Helper","kind":13,"line":162},{"line":162,"kind":12,"containerName":"_write_tree_Helper","name":"add_frame"},{"line":163,"kind":13,"localvar":"my","definition":"my","name":"$tree","containerName":"_write_tree_Helper"},{"name":"new","containerName":"_write_tree_Helper","kind":12,"line":163},{"containerName":"_write_tree_Helper","definition":"my","name":"$root","localvar":"my","kind":13,"line":164},{"line":164,"kind":12,"containerName":"_write_tree_Helper","name":"new"},{"containerName":"_write_tree_Helper","name":"$root","line":165,"kind":13},{"kind":12,"line":165,"name":"name","containerName":"_write_tree_Helper"},{"name":"$node","containerName":"_write_tree_Helper","line":165,"kind":13},{"line":165,"kind":12,"containerName":"_write_tree_Helper","name":"id"},{"kind":13,"line":166,"containerName":"_write_tree_Helper","name":"$self"},{"name":"_decorateRoot","containerName":"_write_tree_Helper","kind":12,"line":166},{"name":"$root","containerName":"_write_tree_Helper","kind":13,"line":166},{"containerName":"_write_tree_Helper","name":"$node","kind":13,"line":166},{"line":166,"kind":12,"containerName":"_write_tree_Helper","name":"each_Descendent"},{"kind":13,"line":167,"containerName":"_write_tree_Helper","name":"$tree"},{"containerName":"_write_tree_Helper","name":"root","kind":12,"line":167},{"kind":13,"line":167,"containerName":"_write_tree_Helper","name":"$root"},{"name":"$group0","containerName":"_write_tree_Helper","line":168,"kind":13},{"line":168,"kind":12,"containerName":"_write_tree_Helper","name":"add_data"},{"kind":13,"line":168,"name":"$tree","containerName":"_write_tree_Helper"},{"kind":13,"line":170,"name":"$group0","containerName":"_write_tree_Helper"},{"line":170,"kind":12,"name":"add_glyph","containerName":"_write_tree_Helper"},{"name":"$self","containerName":"_write_tree_Helper","line":171,"kind":13},{"containerName":"_write_tree_Helper","name":"$self","kind":13,"line":172},{"line":173,"kind":13,"name":"$self","containerName":"_write_tree_Helper"},{"containerName":"_write_tree_Helper","name":"$graph","kind":13,"line":175},{"line":175,"kind":12,"containerName":"_write_tree_Helper","name":"draw"}],"line":154,"definition":"sub","containerName":"main::","signature":{"label":"_write_tree_Helper($self,$node)","parameters":[{"label":"$self"},{"label":"$node"}],"documentation":""},"detail":"($self,$node)","name":"_write_tree_Helper","range":{"end":{"line":176,"character":9999},"start":{"character":0,"line":154}}},{"name":"SVG","containerName":"Graph","kind":12,"line":157},{"line":163,"kind":12,"containerName":"Graph::Data::Tree","name":"SVG"},{"name":"SVG","containerName":"Graph::Data::Node","line":164,"kind":12},{"range":{"start":{"line":191,"character":0},"end":{"line":208,"character":9999}},"name":"_decorateRoot","detail":"($self,$previousNode,@children)","signature":{"label":"_decorateRoot($self,$previousNode,@children)","documentation":"1;\n#\n# BioPerl module for Bio::TreeIO::svg-graph\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Allen Day <allenday@ucla.edu>\n#\n# Copyright Brian O'Connor\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::TreeIO::svggraph - A simple output format that converts a Tree object to an SVG output\n\n=head1 SYNOPSIS\n\n  use Bio::TreeIO;\n  my $in = Bio::TreeIO->new(-file => 'input', -format => 'newick');\n  my $out = Bio::TreeIO->new(-file => '>output', -format => 'svggraph');\n\n  while( my $tree = $in->next_tree ) {\n      my $svg_xml = $out->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis outputs a tree as an SVG graphic using the SVG::Graph API\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Brian OConnor\n\nEmail brian.oconnor-at-excite.com\n\n=head1 CONTRIBUTORS\n\nAllen Day\nGuillaume Rousse, Guillaume-dot-Rousse-at-inria-dot-fr\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::TreeIO::svggraph;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse SVG::Graph;\nuse SVG::Graph::Data;\nuse SVG::Graph::Data::Tree;\nuse SVG::Graph::Data::Node;\nuse Bio::Tree::TreeI;\nuse Bio::Tree::Node;\nuse Tree::DAG_Node;\n\n\nuse base qw(Bio::TreeIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::TreeIO::svggraph->new();\n Function: Builds a new Bio::TreeIO::svggraph object \n Returns : Bio::TreeIO::svggraph\n Args    :-width    => image width (default 1600)\n          -height   => image height (default 1000)\n          -margin   => margin (default 30)\n          -stroke   => stroke color (default 'black')\n          -stroke_width=> stroke width (default 2)\n          -font_size=> font size (default '10px')\n          -nomalize => undef or 'log' (default is undef)\n\n\nsub _initialize {\n    my $self = shift;\n    my ($width,$height,$margin,$stroke,\n\t$stroke_width,$font_size,\n\t$normalize) = $self->_rearrange([qw\n\t\t\t\t\t (WIDTH\n\t\t\t\t\t  HEIGHT\n\t\t\t\t\t  MARGIN\n\t\t\t\t\t  STROKE\n\t\t\t\t\t  STROKE_WIDTH\n\t\t\t\t\t  FONT_SIZE\n\t\t\t\t\t  NORMALIZE)],\n\t\t\t\t\t@_);\n    $self->{_width}        = $width || 1600;\n    $self->{_height}       = $height || 1000;\n    $self->{_margin}       = defined $margin ? $margin : 30;\n    $self->{_stroke}       = $stroke || 'black';\n    $self->{_stroke_width} = $stroke_width || 2;\n    $self->{_font_size}    = $font_size || '10px';\n    $self->{_normalize}    = $normalize || '';\n    $self->SUPER::_initialize(@_);\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Write a tree out to data stream in newick/phylip format\n Returns : none\n Args    : Bio::Tree::TreeI object\n\n\nsub write_tree{\n   my ($self,$tree) = @_;\n   my $line = $self->_write_tree_Helper($tree->get_root_node);\n   $self->_print($line. \"\\n\");\n   $self->flush if $self->_flush_on_write && defined $self->_fh;\n   return;\n}\n\nsub _write_tree_Helper {\n   my ($self,$node) = @_;\n\n   my $graph = SVG::Graph->new\n       ('width'   => $self->{'_width'},\n\t'height'  => $self->{'_height'},\n\t'margin'  => $self->{'_margin'});\n   \n   my $group0 = $graph->add_frame;\n   my $tree = SVG::Graph::Data::Tree->new;\n   my $root = SVG::Graph::Data::Node->new;\n   $root->name($node->id);\n   $self->_decorateRoot($root, $node->each_Descendent());\n   $tree->root($root);\n   $group0->add_data($tree);\n\n   $group0->add_glyph('tree', \n\t\t      'stroke'      =>$self->{'_stroke'},\n\t\t      'stroke-width'=>$self->{'_stroke_width'},\n\t\t      'font-size'   =>$self->{'_font_size'});\n\n   return($graph->draw);\n}\n\n\n=head2 decorateRoot\n\n Title   : _decorateRoot\n Usage   : internal methods\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$previousNode"},{"label":"@children"}]},"containerName":"main::","definition":"sub","line":191,"children":[{"line":192,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_decorateRoot"},{"kind":13,"line":192,"name":"$previousNode","containerName":"_decorateRoot"},{"kind":13,"line":192,"containerName":"_decorateRoot","name":"@children"},{"name":"$child","definition":"my","containerName":"_decorateRoot","localvar":"my","kind":13,"line":193},{"containerName":"_decorateRoot","name":"@children","kind":13,"line":193},{"kind":13,"line":194,"containerName":"_decorateRoot","name":"$currNode","definition":"my","localvar":"my"},{"line":194,"kind":12,"containerName":"_decorateRoot","name":"new"},{"line":195,"kind":13,"name":"$currNode","containerName":"_decorateRoot"},{"line":195,"kind":12,"containerName":"_decorateRoot","name":"branch_label"},{"name":"$child","containerName":"_decorateRoot","kind":13,"line":195},{"name":"id","containerName":"_decorateRoot","kind":12,"line":195},{"kind":13,"line":196,"containerName":"_decorateRoot","definition":"my","name":"$length","localvar":"my"},{"line":196,"kind":13,"name":"$child","containerName":"_decorateRoot"},{"line":196,"kind":12,"containerName":"_decorateRoot","name":"branch_length"},{"containerName":"_decorateRoot","name":"$self","kind":13,"line":199},{"line":200,"kind":13,"containerName":"_decorateRoot","name":"$length"},{"kind":13,"line":200,"name":"$length","containerName":"_decorateRoot"},{"name":"$currNode","containerName":"_decorateRoot","kind":13,"line":204},{"containerName":"_decorateRoot","name":"branch_length","line":204,"kind":12},{"kind":13,"line":204,"containerName":"_decorateRoot","name":"$length"},{"kind":13,"line":205,"containerName":"_decorateRoot","name":"$previousNode"},{"containerName":"_decorateRoot","name":"add_daughter","line":205,"kind":12},{"name":"$currNode","containerName":"_decorateRoot","kind":13,"line":205},{"containerName":"_decorateRoot","name":"$self","line":206,"kind":13},{"name":"_decorateRoot","containerName":"_decorateRoot","line":206,"kind":12},{"name":"$currNode","containerName":"_decorateRoot","line":206,"kind":13},{"containerName":"_decorateRoot","name":"$child","line":206,"kind":13},{"kind":12,"line":206,"name":"each_Descendent","containerName":"_decorateRoot"}],"kind":12},{"name":"SVG","containerName":"Graph::Data::Node","line":194,"kind":12},{"name":"CASE","line":197,"kind":12},{"line":199,"kind":12,"name":"_normalize"},{"name":"CASE","kind":12,"line":201},{"definition":"sub","name":"next_tree","containerName":"main::","range":{"start":{"character":0,"line":222},"end":{"line":224,"character":9999}},"kind":12,"children":[{"name":"throw","containerName":"next_tree","line":223,"kind":12}],"line":222}],"version":5}