{"vars":[{"name":"vars","kind":2,"containerName":"","line":95},{"line":101,"name":"base","kind":2,"containerName":""},{"name":"@EXPORT","containerName":null,"kind":13,"line":103},{"line":104,"containerName":null,"kind":13,"name":"@EXPORT_OK"},{"line":105,"name":"%EXPORT_TAGS","containerName":null,"kind":13},{"name":"all","kind":12,"line":105},{"line":105,"name":"@EXPORT","containerName":null,"kind":13},{"line":105,"name":"@EXPORT_OK","containerName":null,"kind":13},{"definition":1,"line":107,"name":"CODONSIZE","kind":14,"containerName":"main::"},{"containerName":null,"kind":13,"name":"$GAP","line":108},{"kind":13,"containerName":null,"name":"$CODONGAP","line":109},{"line":109,"kind":13,"containerName":null,"name":"$GAP"},{"line":109,"name":"CODONSIZE","kind":12},{"kind":12,"range":{"end":{"line":179,"character":9999},"start":{"character":0,"line":136}},"line":136,"signature":{"label":"aa_to_dna_aln($aln,$dnaseqs)","documentation":"1;\n# $Id: Utilities.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::Utilities\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::Utilities - A collection of utilities regarding converting\nand manipulating alignment objects\n\n=head1 SYNOPSIS\n\n  use Bio::Align::Utilities qw(:all);\n  # %dnaseqs is a hash of CDS sequences (spliced)\n\n\n  # Even if the protein alignments are local make sure the start/end\n  # stored in the LocatableSeq objects are to the full length protein.\n  # The CoDing Sequence that is passed in should still be the full \n  # length CDS as the nt alignment will be generated.\n  #\n  my $dna_aln = &aa_to_dna_aln($aa_aln,\\%dnaseqs);\n\n\n  # generate bootstraps\n  my $replicates = &bootstrap_replicates($aln,$count);\n\n\n=head1 DESCRIPTION\n\nThis module contains utility methods for manipulating sequence\nalignments ( L<Bio::Align::AlignI>) objects.\n\nThe B<aa_to_dna_aln> utility is essentially the same as the B<mrtrans>\nprogram by Bill Pearson available at\nftp://ftp.virginia.edu/pub/fasta/other/mrtrans.shar.  Of course this\nis a pure-perl implementation, but just to mention that if anything\nseems odd you can check the alignments generated against Bill's\nprogram.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#' keep my emacs happy\n# Let the code begin...\n\n\npackage Bio::Align::Utilities;\nuse vars qw(@EXPORT @EXPORT_OK $GAP $CODONGAP %EXPORT_TAGS);\nuse strict;\nuse Carp;\nuse Bio::Root::Version;\nrequire Exporter;\n\nuse base qw(Exporter);\n\n@EXPORT = qw();\n@EXPORT_OK = qw(aa_to_dna_aln bootstrap_replicates cat);\n%EXPORT_TAGS = (all =>[@EXPORT, @EXPORT_OK]);\nBEGIN {\n    use constant CODONSIZE => 3;\n    $GAP = '-';\n    $CODONGAP = $GAP x CODONSIZE;\n}\n\n=head2 aa_to_dna_aln\n\n Title   : aa_to_dna_aln\n Usage   : my $dnaaln = aa_to_dna_aln($aa_aln, \\%seqs);\n Function: Will convert an AA alignment to DNA space given the \n           corresponding DNA sequences.  Note that this method expects \n           the DNA sequences to be in frame +1 (GFF frame 0) as it will\n           start to project into coordinates starting at the first base of \n           the DNA sequence, if this alignment represents a different \n           frame for the cDNA you will need to edit the DNA sequences\n           to remove the 1st or 2nd bases (and revcom if things should be).\n Returns : Bio::Align::AlignI object \n Args    : 2 arguments, the alignment and a hashref.\n           Alignment is a Bio::Align::AlignI of amino acid sequences. \n           The hash reference should have keys which are \n           the display_ids for the aa \n           sequences in the alignment and the values are a \n           Bio::PrimarySeqI object for the corresponding \n           spliced cDNA sequence. \n\nSee also: L<Bio::Align::AlignI>, L<Bio::SimpleAlign>, L<Bio::PrimarySeq>","parameters":[{"label":"$aln"},{"label":"$dnaseqs"}]},"name":"aa_to_dna_aln","containerName":"main::","children":[{"containerName":"aa_to_dna_aln","localvar":"my","kind":13,"name":"$aln","line":137,"definition":"my"},{"containerName":"aa_to_dna_aln","kind":13,"name":"$dnaseqs","line":137},{"line":138,"containerName":"aa_to_dna_aln","kind":13,"name":"$aln"},{"line":139,"containerName":"aa_to_dna_aln","kind":13,"name":"$aln"},{"line":140,"name":"$aln","kind":13,"containerName":"aa_to_dna_aln"},{"kind":12,"containerName":"aa_to_dna_aln","name":"isa","line":140},{"line":143,"name":"$alnlen","localvar":"my","containerName":"aa_to_dna_aln","kind":13,"definition":"my"},{"line":143,"name":"$aln","containerName":"aa_to_dna_aln","kind":13},{"kind":12,"containerName":"aa_to_dna_aln","name":"length","line":143},{"name":"$dnaalign","kind":13,"localvar":"my","containerName":"aa_to_dna_aln","line":144,"definition":"my"},{"line":144,"containerName":"aa_to_dna_aln","kind":12,"name":"new"},{"kind":13,"containerName":"aa_to_dna_aln","name":"$aln","line":145},{"containerName":"aa_to_dna_aln","kind":12,"name":"map_chars","line":145},{"name":"$GAP","containerName":"aa_to_dna_aln","kind":13,"line":145},{"line":147,"kind":13,"localvar":"my","containerName":"aa_to_dna_aln","name":"$seq","definition":"my"},{"line":147,"name":"$aln","containerName":"aa_to_dna_aln","kind":13},{"name":"each_seq","kind":12,"containerName":"aa_to_dna_aln","line":147},{"localvar":"my","containerName":"aa_to_dna_aln","kind":13,"name":"$aa_seqstr","line":148,"definition":"my"},{"kind":13,"containerName":"aa_to_dna_aln","name":"$seq","line":148},{"line":148,"containerName":"aa_to_dna_aln","kind":12,"name":"seq"},{"line":149,"containerName":"aa_to_dna_aln","localvar":"my","kind":13,"name":"$id","definition":"my"},{"line":149,"containerName":"aa_to_dna_aln","kind":13,"name":"$seq"},{"containerName":"aa_to_dna_aln","kind":12,"name":"display_id","line":149},{"definition":"my","line":150,"localvar":"my","containerName":"aa_to_dna_aln","kind":13,"name":"$dnaseq"},{"line":150,"containerName":"aa_to_dna_aln","kind":13,"name":"$dnaseqs"},{"line":150,"containerName":"aa_to_dna_aln","kind":13,"name":"$id"},{"name":"$aln","kind":13,"containerName":"aa_to_dna_aln","line":150},{"line":150,"name":"throw","kind":12,"containerName":"aa_to_dna_aln"},{"kind":13,"containerName":"aa_to_dna_aln","name":"$seq","line":151},{"kind":12,"containerName":"aa_to_dna_aln","name":"display_id","line":151},{"definition":"my","line":152,"containerName":"aa_to_dna_aln","localvar":"my","kind":13,"name":"$start_offset"},{"name":"$seq","containerName":"aa_to_dna_aln","kind":13,"line":152},{"line":152,"name":"start","kind":12,"containerName":"aa_to_dna_aln"},{"name":"$dnaseq","kind":13,"containerName":"aa_to_dna_aln","line":154},{"line":154,"name":"$dnaseq","containerName":"aa_to_dna_aln","kind":13},{"line":154,"kind":12,"containerName":"aa_to_dna_aln","name":"seq"},{"definition":"my","containerName":"aa_to_dna_aln","localvar":"my","kind":13,"name":"$dnalen","line":155},{"line":155,"name":"$dnaseqs","containerName":"aa_to_dna_aln","kind":13},{"line":155,"name":"$id","containerName":"aa_to_dna_aln","kind":13},{"name":"length","containerName":"aa_to_dna_aln","kind":12,"line":155},{"line":156,"localvar":"my","containerName":"aa_to_dna_aln","kind":13,"name":"$nt_seqstr","definition":"my"},{"containerName":"aa_to_dna_aln","localvar":"my","kind":13,"name":"$j","line":157,"definition":"my"},{"definition":"my","name":"$i","localvar":"my","kind":13,"containerName":"aa_to_dna_aln","line":158},{"kind":13,"containerName":"aa_to_dna_aln","name":"$i","line":158},{"line":158,"name":"$alnlen","containerName":"aa_to_dna_aln","kind":13},{"name":"$i","containerName":"aa_to_dna_aln","kind":13,"line":158},{"definition":"my","name":"$char","localvar":"my","kind":13,"containerName":"aa_to_dna_aln","line":159},{"name":"$aa_seqstr","kind":13,"containerName":"aa_to_dna_aln","line":159},{"kind":13,"containerName":"aa_to_dna_aln","name":"$i","line":159},{"line":159,"containerName":"aa_to_dna_aln","kind":13,"name":"$start_offset"},{"name":"$char","containerName":"aa_to_dna_aln","kind":13,"line":160},{"line":160,"name":"$GAP","containerName":"aa_to_dna_aln","kind":13},{"name":"$j","kind":13,"containerName":"aa_to_dna_aln","line":160},{"name":"$dnalen","containerName":"aa_to_dna_aln","kind":13,"line":160},{"name":"$nt_seqstr","containerName":"aa_to_dna_aln","kind":13,"line":161},{"line":161,"kind":13,"containerName":"aa_to_dna_aln","name":"$CODONGAP"},{"line":163,"name":"$nt_seqstr","kind":13,"containerName":"aa_to_dna_aln"},{"containerName":"aa_to_dna_aln","kind":13,"name":"$dnaseq","line":163},{"line":163,"name":"$j","containerName":"aa_to_dna_aln","kind":13},{"name":"$j","containerName":"aa_to_dna_aln","kind":13,"line":164},{"name":"$nt_seqstr","kind":13,"containerName":"aa_to_dna_aln","line":167},{"name":"$GAP","kind":13,"containerName":"aa_to_dna_aln","line":167},{"line":167,"kind":13,"containerName":"aa_to_dna_aln","name":"$alnlen"},{"name":"$nt_seqstr","kind":13,"containerName":"aa_to_dna_aln","line":167},{"definition":"my","line":169,"containerName":"aa_to_dna_aln","localvar":"my","kind":13,"name":"$newdna"},{"name":"new","containerName":"aa_to_dna_aln","kind":12,"line":169},{"line":169,"kind":13,"containerName":"aa_to_dna_aln","name":"$id"},{"line":171,"name":"$start_offset","kind":13,"containerName":"aa_to_dna_aln"},{"line":172,"name":"$seq","containerName":"aa_to_dna_aln","kind":13},{"name":"end","kind":12,"containerName":"aa_to_dna_aln","line":172},{"containerName":"aa_to_dna_aln","kind":13,"name":"$nt_seqstr","line":175},{"name":"$dnaalign","containerName":"aa_to_dna_aln","kind":13,"line":176},{"line":176,"name":"add_seq","kind":12,"containerName":"aa_to_dna_aln"},{"name":"$newdna","containerName":"aa_to_dna_aln","kind":13,"line":176},{"name":"$dnaalign","containerName":"aa_to_dna_aln","kind":13,"line":178}],"detail":"($aln,$dnaseqs)","definition":"sub"},{"line":141,"kind":12,"name":"croak"},{"line":144,"name":"Bio","kind":12,"containerName":"SimpleAlign"},{"line":152,"kind":12,"name":"CODONSIZE"},{"line":163,"kind":12,"name":"CODONSIZE"},{"line":164,"kind":12,"name":"CODONSIZE"},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":169},{"line":173,"name":"CODONSIZE","kind":12},{"signature":{"label":"bootstrap_replicates($aln,$count)","documentation":"1;\n# $Id: Utilities.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::Utilities\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::Utilities - A collection of utilities regarding converting\nand manipulating alignment objects\n\n=head1 SYNOPSIS\n\n  use Bio::Align::Utilities qw(:all);\n  # %dnaseqs is a hash of CDS sequences (spliced)\n\n\n  # Even if the protein alignments are local make sure the start/end\n  # stored in the LocatableSeq objects are to the full length protein.\n  # The CoDing Sequence that is passed in should still be the full \n  # length CDS as the nt alignment will be generated.\n  #\n  my $dna_aln = &aa_to_dna_aln($aa_aln,\\%dnaseqs);\n\n\n  # generate bootstraps\n  my $replicates = &bootstrap_replicates($aln,$count);\n\n\n=head1 DESCRIPTION\n\nThis module contains utility methods for manipulating sequence\nalignments ( L<Bio::Align::AlignI>) objects.\n\nThe B<aa_to_dna_aln> utility is essentially the same as the B<mrtrans>\nprogram by Bill Pearson available at\nftp://ftp.virginia.edu/pub/fasta/other/mrtrans.shar.  Of course this\nis a pure-perl implementation, but just to mention that if anything\nseems odd you can check the alignments generated against Bill's\nprogram.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#' keep my emacs happy\n# Let the code begin...\n\n\npackage Bio::Align::Utilities;\nuse vars qw(@EXPORT @EXPORT_OK $GAP $CODONGAP %EXPORT_TAGS);\nuse strict;\nuse Carp;\nuse Bio::Root::Version;\nrequire Exporter;\n\nuse base qw(Exporter);\n\n@EXPORT = qw();\n@EXPORT_OK = qw(aa_to_dna_aln bootstrap_replicates cat);\n%EXPORT_TAGS = (all =>[@EXPORT, @EXPORT_OK]);\nBEGIN {\n    use constant CODONSIZE => 3;\n    $GAP = '-';\n    $CODONGAP = $GAP x CODONSIZE;\n}\n\n=head2 aa_to_dna_aln\n\n Title   : aa_to_dna_aln\n Usage   : my $dnaaln = aa_to_dna_aln($aa_aln, \\%seqs);\n Function: Will convert an AA alignment to DNA space given the \n           corresponding DNA sequences.  Note that this method expects \n           the DNA sequences to be in frame +1 (GFF frame 0) as it will\n           start to project into coordinates starting at the first base of \n           the DNA sequence, if this alignment represents a different \n           frame for the cDNA you will need to edit the DNA sequences\n           to remove the 1st or 2nd bases (and revcom if things should be).\n Returns : Bio::Align::AlignI object \n Args    : 2 arguments, the alignment and a hashref.\n           Alignment is a Bio::Align::AlignI of amino acid sequences. \n           The hash reference should have keys which are \n           the display_ids for the aa \n           sequences in the alignment and the values are a \n           Bio::PrimarySeqI object for the corresponding \n           spliced cDNA sequence. \n\nSee also: L<Bio::Align::AlignI>, L<Bio::SimpleAlign>, L<Bio::PrimarySeq>\n\n\nsub aa_to_dna_aln {\n    my ($aln,$dnaseqs) = @_;\n    unless( defined $aln && \n\t    ref($aln) &&\n\t    $aln->isa('Bio::Align::AlignI') ) { \n\tcroak('Must provide a valid Bio::Align::AlignI object as the first argument to aa_to_dna_aln, see the documentation for proper usage and the method signature');\n    }\n    my $alnlen = $aln->length;\n    my $dnaalign = Bio::SimpleAlign->new();\n    $aln->map_chars('\\.',$GAP);\n\n    foreach my $seq ( $aln->each_seq ) {    \n\tmy $aa_seqstr = $seq->seq();\n\tmy $id = $seq->display_id;\n\tmy $dnaseq = $dnaseqs->{$id} || $aln->throw(\"cannot find \".\n\t\t\t\t\t\t     $seq->display_id);\n\tmy $start_offset = ($seq->start - 1) * CODONSIZE;\n\n\t$dnaseq = $dnaseq->seq();\n\tmy $dnalen = $dnaseqs->{$id}->length;\n\tmy $nt_seqstr;\n\tmy $j = 0;\n\tfor( my $i = 0; $i < $alnlen; $i++ ) {\n\t    my $char = substr($aa_seqstr,$i + $start_offset,1);\t    \n\t    if ( $char eq $GAP || $j >= $dnalen )  { \n\t\t$nt_seqstr .= $CODONGAP;\n\t    } else {\n\t\t$nt_seqstr .= substr($dnaseq,$j,CODONSIZE);\n\t\t$j += CODONSIZE;\n\t    }\n\t}\n\t$nt_seqstr .= $GAP x (($alnlen * 3) - length($nt_seqstr));\n\n\tmy $newdna = Bio::LocatableSeq->new(-display_id  => $id,\n\t\t\t\t\t   -alphabet    => 'dna',\n\t\t\t\t\t   -start       => $start_offset+1,\n\t\t\t\t\t   -end         => ($seq->end * \n\t\t\t\t\t\t\t    CODONSIZE),\n\t\t\t\t\t   -strand      => 1,\n\t\t\t\t\t   -seq         => $nt_seqstr);    \n\t$dnaalign->add_seq($newdna);\n    }\n    return $dnaalign;\n}\n\n=head2 bootstrap_replicates\n\n Title   : bootstrap_replicates\n Usage   : my $alns = &bootstrap_replicates($aln,100);\n Function: Generate a pseudo-replicate of the data by randomly\n           sampling, with replacement, the columns from an alignment for\n           the non-parametric bootstrap.\n Returns : Arrayref of L<Bio::SimpleAlign> objects\n Args    : L<Bio::SimpleAlign> object\n           Number of replicates to generate","parameters":[{"label":"$aln"},{"label":"$count"}]},"line":194,"range":{"end":{"character":9999,"line":227},"start":{"character":0,"line":194}},"kind":12,"definition":"sub","detail":"($aln,$count)","children":[{"definition":"my","line":195,"name":"$aln","localvar":"my","containerName":"bootstrap_replicates","kind":13},{"line":195,"name":"$count","containerName":"bootstrap_replicates","kind":13},{"line":196,"kind":13,"containerName":"bootstrap_replicates","name":"$count"},{"definition":"my","line":197,"localvar":"my","kind":13,"containerName":"bootstrap_replicates","name":"$alen"},{"name":"$aln","kind":13,"containerName":"bootstrap_replicates","line":197},{"containerName":"bootstrap_replicates","kind":12,"name":"length","line":197},{"kind":13,"localvar":"my","containerName":"bootstrap_replicates","name":"@seqs","line":198,"definition":"my"},{"line":198,"name":"@nm","containerName":"bootstrap_replicates","kind":13},{"line":199,"name":"$aln","kind":13,"containerName":"bootstrap_replicates"},{"containerName":"bootstrap_replicates","kind":12,"name":"set_displayname_flat","line":199},{"localvar":"my","kind":13,"containerName":"bootstrap_replicates","name":"$s","line":200,"definition":"my"},{"line":200,"name":"$aln","containerName":"bootstrap_replicates","kind":13},{"name":"each_seq","containerName":"bootstrap_replicates","kind":12,"line":200},{"line":201,"name":"@seqs","containerName":"bootstrap_replicates","kind":13},{"containerName":"bootstrap_replicates","kind":13,"name":"$s","line":201},{"line":201,"name":"seq","containerName":"bootstrap_replicates","kind":12},{"line":202,"name":"@nm","kind":13,"containerName":"bootstrap_replicates"},{"kind":13,"containerName":"bootstrap_replicates","name":"$s","line":202},{"name":"id","containerName":"bootstrap_replicates","kind":12,"line":202},{"line":204,"localvar":"my","kind":13,"containerName":"bootstrap_replicates","name":"@alns","definition":"my"},{"line":204,"containerName":"bootstrap_replicates","kind":13,"name":"$i"},{"line":205,"kind":13,"containerName":"bootstrap_replicates","name":"$count"},{"name":"@newseqs","containerName":"bootstrap_replicates","localvar":"my","kind":13,"line":206,"definition":"my"},{"line":207,"name":"$i","kind":13,"containerName":"bootstrap_replicates"},{"containerName":"bootstrap_replicates","kind":13,"name":"$i","line":207},{"line":207,"kind":13,"containerName":"bootstrap_replicates","name":"$alen"},{"line":207,"name":"$i","containerName":"bootstrap_replicates","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"bootstrap_replicates","name":"$index","line":208},{"containerName":"bootstrap_replicates","kind":13,"name":"$alen","line":208},{"definition":"my","line":209,"kind":13,"localvar":"my","containerName":"bootstrap_replicates","name":"$c"},{"line":210,"name":"@seqs","kind":13,"containerName":"bootstrap_replicates"},{"containerName":"bootstrap_replicates","kind":13,"name":"$newseqs","line":211},{"line":211,"containerName":"bootstrap_replicates","kind":13,"name":"$c"},{"line":211,"name":"$index","containerName":"bootstrap_replicates","kind":13},{"definition":"my","name":"$newaln","containerName":"bootstrap_replicates","localvar":"my","kind":13,"line":214},{"containerName":"bootstrap_replicates","kind":12,"name":"new","line":214},{"definition":"my","line":215,"name":"$i","localvar":"my","containerName":"bootstrap_replicates","kind":13},{"definition":"my","name":"$s","kind":13,"localvar":"my","containerName":"bootstrap_replicates","line":216},{"line":216,"name":"@newseqs","containerName":"bootstrap_replicates","kind":13},{"definition":"my","name":"$tmp","localvar":"my","kind":13,"containerName":"bootstrap_replicates","line":217},{"line":217,"name":"$s","kind":13,"containerName":"bootstrap_replicates"},{"name":"$newaln","containerName":"bootstrap_replicates","kind":13,"line":218},{"name":"add_seq","containerName":"bootstrap_replicates","kind":12,"line":218},{"kind":12,"containerName":"bootstrap_replicates","name":"new","line":219},{"containerName":"bootstrap_replicates","kind":13,"name":"$tmp","line":220},{"containerName":"bootstrap_replicates","kind":13,"name":"$nm","line":221},{"line":221,"name":"$i","kind":13,"containerName":"bootstrap_replicates"},{"line":222,"containerName":"bootstrap_replicates","kind":13,"name":"$s"},{"name":"@alns","containerName":"bootstrap_replicates","kind":13,"line":224},{"name":"$newaln","kind":13,"containerName":"bootstrap_replicates","line":224},{"line":226,"name":"@alns","kind":13,"containerName":"bootstrap_replicates"}],"name":"bootstrap_replicates","containerName":"main::"},{"line":214,"containerName":"SimpleAlign","kind":12,"name":"Bio"},{"kind":12,"containerName":"LocatableSeq","name":"Bio","line":218},{"definition":"sub","detail":"($self,@aln)","children":[{"line":247,"kind":13,"localvar":"my","containerName":"cat","name":"$self","definition":"my"},{"containerName":"cat","kind":13,"name":"@aln","line":247},{"name":"$self","containerName":"cat","kind":13,"line":248},{"line":248,"kind":12,"containerName":"cat","name":"throw"},{"name":"$self","containerName":"cat","kind":13,"line":248},{"line":249,"name":"$self","kind":13,"containerName":"cat"},{"line":249,"containerName":"cat","kind":13,"name":"@aln"},{"line":250,"containerName":"cat","kind":13,"name":"$self"},{"line":250,"containerName":"cat","kind":12,"name":"throw"},{"line":250,"name":"id","containerName":"cat","kind":12},{"name":"isa","containerName":"cat","kind":12,"line":250},{"line":251,"name":"$self","containerName":"cat","kind":13},{"name":"throw","kind":12,"containerName":"cat","line":251},{"name":"id","kind":12,"containerName":"cat","line":251},{"line":251,"containerName":"cat","kind":12,"name":"is_flush"},{"name":"$aln","localvar":"my","kind":13,"containerName":"cat","line":253,"definition":"my"},{"containerName":"cat","kind":13,"name":"$self","line":253},{"line":253,"name":"new","kind":12,"containerName":"cat"},{"containerName":"cat","kind":13,"name":"$aln","line":254},{"line":254,"kind":12,"containerName":"cat","name":"id"},{"kind":13,"containerName":"cat","name":"$self","line":254},{"line":254,"containerName":"cat","kind":12,"name":"id"},{"kind":13,"containerName":"cat","name":"$aln","line":255},{"name":"annotation","containerName":"cat","kind":12,"line":255},{"kind":13,"containerName":"cat","name":"$self","line":255},{"kind":12,"containerName":"cat","name":"annotation","line":255},{"localvar":"my","kind":13,"containerName":"cat","name":"%unique","line":256,"definition":"my"},{"name":"$seq","localvar":"my","containerName":"cat","kind":13,"line":257,"definition":"my"},{"line":257,"name":"$self","containerName":"cat","kind":13},{"name":"each_seq","containerName":"cat","kind":12,"line":257},{"kind":13,"containerName":"cat","name":"$seq","line":258},{"line":258,"containerName":"cat","kind":12,"name":"id"},{"name":"$unique","containerName":"cat","kind":13,"line":258},{"containerName":"cat","kind":13,"name":"$seq","line":258},{"name":"id","containerName":"cat","kind":12,"line":258},{"line":259,"name":"$unique","containerName":"cat","kind":13},{"kind":13,"containerName":"cat","name":"$seq","line":259},{"line":259,"name":"id","kind":12,"containerName":"cat"},{"definition":"my","line":262,"localvar":"my","kind":13,"containerName":"cat","name":"$new_seq"},{"name":"$seq","containerName":"cat","kind":13,"line":262},{"kind":12,"containerName":"cat","name":"new","line":262},{"line":262,"kind":13,"containerName":"cat","name":"$seq"},{"line":262,"kind":12,"containerName":"cat","name":"id"},{"name":"$seq","kind":13,"containerName":"cat","line":263},{"name":"strand","kind":12,"containerName":"cat","line":263},{"line":264,"containerName":"cat","kind":13,"name":"$self"},{"line":264,"kind":12,"containerName":"cat","name":"verbose"},{"name":"$new_seq","kind":13,"containerName":"cat","line":265},{"name":"seq","kind":12,"containerName":"cat","line":265},{"kind":13,"containerName":"cat","name":"$seq","line":265},{"name":"seq","containerName":"cat","kind":12,"line":265},{"line":266,"kind":13,"containerName":"cat","name":"$new_seq"},{"containerName":"cat","kind":12,"name":"start","line":266},{"name":"$seq","containerName":"cat","kind":13,"line":266},{"line":266,"name":"start","kind":12,"containerName":"cat"},{"name":"$new_seq","containerName":"cat","kind":13,"line":267},{"containerName":"cat","kind":12,"name":"end","line":267},{"name":"$seq","containerName":"cat","kind":13,"line":267},{"kind":12,"containerName":"cat","name":"end","line":267},{"line":268,"kind":13,"containerName":"cat","name":"$new_seq"},{"name":"isa","kind":12,"containerName":"cat","line":268},{"definition":"my","name":"$meta_name","localvar":"my","kind":13,"containerName":"cat","line":269},{"line":269,"name":"$seq","kind":13,"containerName":"cat"},{"line":269,"containerName":"cat","kind":12,"name":"meta_names"},{"name":"$new_seq","kind":13,"containerName":"cat","line":270},{"line":270,"containerName":"cat","kind":12,"name":"named_submeta"},{"containerName":"cat","kind":13,"name":"$meta_name","line":270},{"line":270,"name":"$new_seq","containerName":"cat","kind":13},{"name":"start","containerName":"cat","kind":12,"line":270},{"name":"$new_seq","containerName":"cat","kind":13,"line":270},{"line":270,"containerName":"cat","kind":12,"name":"end"},{"line":270,"kind":13,"containerName":"cat","name":"$seq"},{"line":270,"kind":12,"containerName":"cat","name":"named_meta"},{"containerName":"cat","kind":13,"name":"$meta_name","line":270},{"definition":"my","line":273,"localvar":"my","kind":13,"containerName":"cat","name":"$cat_aln"},{"line":273,"name":"@aln","containerName":"cat","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"cat","name":"@cat_seq","line":274},{"line":274,"name":"$cat_aln","kind":13,"containerName":"cat"},{"kind":12,"containerName":"cat","name":"each_seq_with_id","line":274},{"name":"$seq","containerName":"cat","kind":13,"line":274},{"line":274,"name":"id","kind":12,"containerName":"cat"},{"line":275,"name":"@cat_seq","containerName":"cat","kind":13},{"line":276,"kind":13,"containerName":"cat","name":"$self"},{"kind":12,"containerName":"cat","name":"warn","line":276},{"line":276,"name":"$seq","kind":13,"containerName":"cat"},{"name":"id","containerName":"cat","kind":12,"line":276},{"name":"$cat_aln","containerName":"cat","kind":13,"line":276},{"line":276,"name":"id","containerName":"cat","kind":12},{"name":"@cat_seq","containerName":"cat","kind":13,"line":279},{"name":"$self","containerName":"cat","kind":13,"line":280},{"kind":12,"containerName":"cat","name":"warn","line":280},{"containerName":"cat","kind":13,"name":"$seq","line":280},{"name":"id","containerName":"cat","kind":12,"line":280},{"line":280,"name":"$cat_aln","containerName":"cat","kind":13},{"containerName":"cat","kind":12,"name":"id","line":280},{"line":283,"name":"$cat_seq","containerName":"cat","localvar":"my","kind":13,"definition":"my"},{"name":"$cat_seq","kind":13,"containerName":"cat","line":283},{"localvar":"my","kind":13,"containerName":"cat","name":"$old_end","line":284,"definition":"my"},{"name":"$new_seq","containerName":"cat","kind":13,"line":284},{"name":"end","kind":12,"containerName":"cat","line":284},{"kind":13,"containerName":"cat","name":"$new_seq","line":285},{"line":285,"name":"seq","kind":12,"containerName":"cat"},{"line":285,"kind":13,"containerName":"cat","name":"$new_seq"},{"kind":12,"containerName":"cat","name":"seq","line":285},{"containerName":"cat","kind":13,"name":"$cat_seq","line":285},{"name":"seq","kind":12,"containerName":"cat","line":285},{"name":"$new_seq","kind":13,"containerName":"cat","line":288},{"kind":12,"containerName":"cat","name":"end","line":288},{"name":"$new_seq","kind":13,"containerName":"cat","line":288},{"line":288,"name":"end","containerName":"cat","kind":12},{"kind":13,"containerName":"cat","name":"$cat_seq","line":288},{"line":288,"containerName":"cat","kind":12,"name":"end"},{"name":"$cat_seq","containerName":"cat","kind":13,"line":288},{"kind":12,"containerName":"cat","name":"start","line":288},{"line":290,"name":"$cat_seq","containerName":"cat","kind":13},{"containerName":"cat","kind":12,"name":"isa","line":290},{"containerName":"cat","kind":13,"name":"$new_seq","line":291},{"name":"isa","kind":12,"containerName":"cat","line":291},{"definition":"my","line":292,"name":"$meta_seq","kind":13,"localvar":"my","containerName":"cat"},{"containerName":"cat","kind":12,"name":"new","line":292},{"line":293,"name":"$meta_seq","kind":13,"containerName":"cat"},{"line":293,"name":"seq","containerName":"cat","kind":12},{"kind":13,"containerName":"cat","name":"$new_seq","line":293},{"line":293,"name":"seq","containerName":"cat","kind":12},{"line":294,"containerName":"cat","kind":13,"name":"$meta_seq"},{"containerName":"cat","kind":12,"name":"start","line":294},{"name":"$new_seq","containerName":"cat","kind":13,"line":294},{"line":294,"name":"start","containerName":"cat","kind":12},{"line":295,"containerName":"cat","kind":13,"name":"$meta_seq"},{"kind":12,"containerName":"cat","name":"end","line":295},{"line":295,"kind":13,"containerName":"cat","name":"$new_seq"},{"line":295,"containerName":"cat","kind":12,"name":"end"},{"kind":13,"containerName":"cat","name":"$new_seq","line":296},{"name":"isa","containerName":"cat","kind":12,"line":296},{"definition":"my","line":297,"name":"$meta_name","containerName":"cat","localvar":"my","kind":13},{"name":"$new_seq","containerName":"cat","kind":13,"line":297},{"line":297,"name":"meta_names","kind":12,"containerName":"cat"},{"name":"$meta_seq","kind":13,"containerName":"cat","line":298},{"line":298,"name":"named_submeta","containerName":"cat","kind":12},{"kind":13,"containerName":"cat","name":"$meta_name","line":298},{"name":"$new_seq","containerName":"cat","kind":13,"line":299},{"line":299,"name":"start","kind":12,"containerName":"cat"},{"kind":13,"containerName":"cat","name":"$old_end","line":300},{"kind":13,"containerName":"cat","name":"$new_seq","line":301},{"line":301,"name":"named_meta","containerName":"cat","kind":12},{"name":"$meta_name","containerName":"cat","kind":13,"line":301},{"line":305,"name":"$new_seq","containerName":"cat","kind":13},{"name":"$meta_seq","containerName":"cat","kind":13,"line":305},{"definition":"my","line":307,"name":"$meta_name","containerName":"cat","localvar":"my","kind":13},{"line":307,"name":"$cat_seq","containerName":"cat","kind":13},{"name":"meta_names","containerName":"cat","kind":12,"line":307},{"containerName":"cat","kind":13,"name":"$new_seq","line":308},{"line":308,"containerName":"cat","kind":12,"name":"named_submeta"},{"line":308,"name":"$meta_name","containerName":"cat","kind":13},{"name":"$old_end","kind":13,"containerName":"cat","line":309},{"kind":13,"containerName":"cat","name":"$new_seq","line":310},{"line":310,"name":"end","kind":12,"containerName":"cat"},{"containerName":"cat","kind":13,"name":"$cat_seq","line":311},{"line":311,"containerName":"cat","kind":12,"name":"named_meta"},{"line":311,"name":"$meta_name","kind":13,"containerName":"cat"},{"kind":13,"containerName":"cat","name":"$cat_seq","line":314},{"kind":12,"containerName":"cat","name":"isa","line":314},{"kind":13,"containerName":"cat","name":"$new_seq","line":315},{"kind":12,"containerName":"cat","name":"isa","line":315},{"definition":"my","name":"$meta_name","containerName":"cat","localvar":"my","kind":13,"line":316},{"line":316,"kind":13,"containerName":"cat","name":"$cat_seq"},{"name":"meta_names","kind":12,"containerName":"cat","line":316},{"kind":13,"containerName":"cat","name":"$new_seq","line":317},{"line":317,"containerName":"cat","kind":12,"name":"named_submeta"},{"line":317,"kind":13,"containerName":"cat","name":"$meta_name"},{"line":318,"containerName":"cat","kind":13,"name":"$old_end"},{"line":319,"name":"$new_seq","containerName":"cat","kind":13},{"name":"end","kind":12,"containerName":"cat","line":319},{"line":320,"name":"$cat_seq","containerName":"cat","kind":13},{"line":320,"name":"named_meta","containerName":"cat","kind":12},{"containerName":"cat","kind":13,"name":"$meta_name","line":320},{"kind":13,"containerName":"cat","name":"$new_seq","line":324},{"kind":12,"containerName":"cat","name":"isa","line":324},{"definition":"my","line":325,"kind":13,"localvar":"my","containerName":"cat","name":"$meta_seq"},{"line":325,"kind":12,"containerName":"cat","name":"new"},{"line":326,"containerName":"cat","kind":13,"name":"$meta_seq"},{"kind":12,"containerName":"cat","name":"seq","line":326},{"name":"$new_seq","containerName":"cat","kind":13,"line":326},{"line":326,"name":"seq","containerName":"cat","kind":12},{"containerName":"cat","kind":13,"name":"$meta_seq","line":327},{"containerName":"cat","kind":12,"name":"start","line":327},{"containerName":"cat","kind":13,"name":"$new_seq","line":327},{"name":"start","containerName":"cat","kind":12,"line":327},{"kind":13,"containerName":"cat","name":"$meta_seq","line":328},{"name":"end","kind":12,"containerName":"cat","line":328},{"line":328,"containerName":"cat","kind":13,"name":"$new_seq"},{"kind":12,"containerName":"cat","name":"end","line":328},{"containerName":"cat","kind":13,"name":"$new_seq","line":329},{"line":329,"containerName":"cat","kind":13,"name":"$meta_seq"},{"localvar":"my","kind":13,"containerName":"cat","name":"$meta_name","line":331,"definition":"my"},{"kind":13,"containerName":"cat","name":"$cat_seq","line":331},{"line":331,"name":"meta_names","kind":12,"containerName":"cat"},{"containerName":"cat","kind":13,"name":"$new_seq","line":332},{"line":332,"kind":12,"containerName":"cat","name":"named_submeta"},{"containerName":"cat","kind":13,"name":"$meta_name","line":332},{"name":"$old_end","kind":13,"containerName":"cat","line":333},{"name":"$new_seq","kind":13,"containerName":"cat","line":334},{"kind":12,"containerName":"cat","name":"end","line":334},{"line":335,"containerName":"cat","kind":13,"name":"$cat_seq"},{"line":335,"name":"named_meta","containerName":"cat","kind":12},{"line":335,"containerName":"cat","kind":13,"name":"$meta_name"},{"containerName":"cat","kind":13,"name":"$aln","line":341},{"line":341,"containerName":"cat","kind":12,"name":"add_seq"},{"name":"$new_seq","kind":13,"containerName":"cat","line":341},{"line":343,"name":"$cons_meta","localvar":"my","containerName":"cat","kind":13,"definition":"my"},{"containerName":"cat","kind":13,"name":"$self","line":343},{"line":343,"name":"consensus_meta","containerName":"cat","kind":12},{"definition":"my","line":344,"containerName":"cat","localvar":"my","kind":13,"name":"$new_cons_meta"},{"name":"$cons_meta","kind":13,"containerName":"cat","line":345},{"kind":13,"containerName":"cat","name":"$new_cons_meta","line":346},{"name":"new","containerName":"cat","kind":12,"line":346},{"definition":"my","kind":13,"localvar":"my","containerName":"cat","name":"$meta_name","line":347},{"line":347,"name":"$cons_meta","kind":13,"containerName":"cat"},{"kind":12,"containerName":"cat","name":"meta_names","line":347},{"kind":13,"containerName":"cat","name":"$new_cons_meta","line":348},{"name":"named_submeta","containerName":"cat","kind":12,"line":348},{"line":348,"kind":13,"containerName":"cat","name":"$meta_name"},{"line":348,"kind":13,"containerName":"cat","name":"$self"},{"line":348,"kind":12,"containerName":"cat","name":"length"},{"line":348,"name":"$cons_meta","kind":13,"containerName":"cat"},{"name":"$meta_name","containerName":"cat","kind":13,"line":348},{"definition":"my","line":351,"name":"$end","localvar":"my","kind":13,"containerName":"cat"},{"containerName":"cat","kind":13,"name":"$self","line":351},{"line":351,"kind":12,"containerName":"cat","name":"length"},{"definition":"my","line":352,"localvar":"my","containerName":"cat","kind":13,"name":"$cat_aln"},{"line":352,"containerName":"cat","kind":13,"name":"@aln"},{"definition":"my","name":"$cat_cons_meta","kind":13,"localvar":"my","containerName":"cat","line":353},{"line":353,"name":"$cat_aln","kind":13,"containerName":"cat"},{"line":353,"kind":12,"containerName":"cat","name":"consensus_meta"},{"name":"$cat_cons_meta","containerName":"cat","kind":13,"line":354},{"line":355,"kind":13,"containerName":"cat","name":"$new_cons_meta"},{"name":"new","kind":12,"containerName":"cat","line":355},{"line":355,"containerName":"cat","kind":13,"name":"$new_cons_meta"},{"definition":"my","name":"$meta_name","localvar":"my","containerName":"cat","kind":13,"line":356},{"containerName":"cat","kind":13,"name":"$cat_cons_meta","line":356},{"containerName":"cat","kind":12,"name":"meta_names","line":356},{"line":357,"containerName":"cat","kind":13,"name":"$new_cons_meta"},{"line":357,"name":"named_submeta","kind":12,"containerName":"cat"},{"line":357,"kind":13,"containerName":"cat","name":"$meta_name"},{"line":357,"name":"$end","containerName":"cat","kind":13},{"line":357,"kind":13,"containerName":"cat","name":"$end"},{"containerName":"cat","kind":13,"name":"$cat_aln","line":357},{"name":"length","containerName":"cat","kind":12,"line":357},{"line":357,"kind":13,"containerName":"cat","name":"$cat_cons_meta"},{"containerName":"cat","kind":13,"name":"$meta_name","line":357},{"line":360,"kind":13,"containerName":"cat","name":"$end"},{"name":"$cat_aln","kind":13,"containerName":"cat","line":360},{"line":360,"containerName":"cat","kind":12,"name":"length"},{"line":362,"kind":13,"containerName":"cat","name":"$aln"},{"line":362,"containerName":"cat","kind":12,"name":"consensus_meta"},{"line":362,"name":"$new_cons_meta","kind":13,"containerName":"cat"},{"line":362,"name":"$new_cons_meta","kind":13,"containerName":"cat"},{"line":363,"kind":13,"containerName":"cat","name":"$aln"}],"name":"cat","containerName":"main::","signature":{"documentation":"1;\n# $Id: Utilities.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Align::Utilities\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Align::Utilities - A collection of utilities regarding converting\nand manipulating alignment objects\n\n=head1 SYNOPSIS\n\n  use Bio::Align::Utilities qw(:all);\n  # %dnaseqs is a hash of CDS sequences (spliced)\n\n\n  # Even if the protein alignments are local make sure the start/end\n  # stored in the LocatableSeq objects are to the full length protein.\n  # The CoDing Sequence that is passed in should still be the full \n  # length CDS as the nt alignment will be generated.\n  #\n  my $dna_aln = &aa_to_dna_aln($aa_aln,\\%dnaseqs);\n\n\n  # generate bootstraps\n  my $replicates = &bootstrap_replicates($aln,$count);\n\n\n=head1 DESCRIPTION\n\nThis module contains utility methods for manipulating sequence\nalignments ( L<Bio::Align::AlignI>) objects.\n\nThe B<aa_to_dna_aln> utility is essentially the same as the B<mrtrans>\nprogram by Bill Pearson available at\nftp://ftp.virginia.edu/pub/fasta/other/mrtrans.shar.  Of course this\nis a pure-perl implementation, but just to mention that if anything\nseems odd you can check the alignments generated against Bill's\nprogram.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#' keep my emacs happy\n# Let the code begin...\n\n\npackage Bio::Align::Utilities;\nuse vars qw(@EXPORT @EXPORT_OK $GAP $CODONGAP %EXPORT_TAGS);\nuse strict;\nuse Carp;\nuse Bio::Root::Version;\nrequire Exporter;\n\nuse base qw(Exporter);\n\n@EXPORT = qw();\n@EXPORT_OK = qw(aa_to_dna_aln bootstrap_replicates cat);\n%EXPORT_TAGS = (all =>[@EXPORT, @EXPORT_OK]);\nBEGIN {\n    use constant CODONSIZE => 3;\n    $GAP = '-';\n    $CODONGAP = $GAP x CODONSIZE;\n}\n\n=head2 aa_to_dna_aln\n\n Title   : aa_to_dna_aln\n Usage   : my $dnaaln = aa_to_dna_aln($aa_aln, \\%seqs);\n Function: Will convert an AA alignment to DNA space given the \n           corresponding DNA sequences.  Note that this method expects \n           the DNA sequences to be in frame +1 (GFF frame 0) as it will\n           start to project into coordinates starting at the first base of \n           the DNA sequence, if this alignment represents a different \n           frame for the cDNA you will need to edit the DNA sequences\n           to remove the 1st or 2nd bases (and revcom if things should be).\n Returns : Bio::Align::AlignI object \n Args    : 2 arguments, the alignment and a hashref.\n           Alignment is a Bio::Align::AlignI of amino acid sequences. \n           The hash reference should have keys which are \n           the display_ids for the aa \n           sequences in the alignment and the values are a \n           Bio::PrimarySeqI object for the corresponding \n           spliced cDNA sequence. \n\nSee also: L<Bio::Align::AlignI>, L<Bio::SimpleAlign>, L<Bio::PrimarySeq>\n\n\nsub aa_to_dna_aln {\n    my ($aln,$dnaseqs) = @_;\n    unless( defined $aln && \n\t    ref($aln) &&\n\t    $aln->isa('Bio::Align::AlignI') ) { \n\tcroak('Must provide a valid Bio::Align::AlignI object as the first argument to aa_to_dna_aln, see the documentation for proper usage and the method signature');\n    }\n    my $alnlen = $aln->length;\n    my $dnaalign = Bio::SimpleAlign->new();\n    $aln->map_chars('\\.',$GAP);\n\n    foreach my $seq ( $aln->each_seq ) {    \n\tmy $aa_seqstr = $seq->seq();\n\tmy $id = $seq->display_id;\n\tmy $dnaseq = $dnaseqs->{$id} || $aln->throw(\"cannot find \".\n\t\t\t\t\t\t     $seq->display_id);\n\tmy $start_offset = ($seq->start - 1) * CODONSIZE;\n\n\t$dnaseq = $dnaseq->seq();\n\tmy $dnalen = $dnaseqs->{$id}->length;\n\tmy $nt_seqstr;\n\tmy $j = 0;\n\tfor( my $i = 0; $i < $alnlen; $i++ ) {\n\t    my $char = substr($aa_seqstr,$i + $start_offset,1);\t    \n\t    if ( $char eq $GAP || $j >= $dnalen )  { \n\t\t$nt_seqstr .= $CODONGAP;\n\t    } else {\n\t\t$nt_seqstr .= substr($dnaseq,$j,CODONSIZE);\n\t\t$j += CODONSIZE;\n\t    }\n\t}\n\t$nt_seqstr .= $GAP x (($alnlen * 3) - length($nt_seqstr));\n\n\tmy $newdna = Bio::LocatableSeq->new(-display_id  => $id,\n\t\t\t\t\t   -alphabet    => 'dna',\n\t\t\t\t\t   -start       => $start_offset+1,\n\t\t\t\t\t   -end         => ($seq->end * \n\t\t\t\t\t\t\t    CODONSIZE),\n\t\t\t\t\t   -strand      => 1,\n\t\t\t\t\t   -seq         => $nt_seqstr);    \n\t$dnaalign->add_seq($newdna);\n    }\n    return $dnaalign;\n}\n\n=head2 bootstrap_replicates\n\n Title   : bootstrap_replicates\n Usage   : my $alns = &bootstrap_replicates($aln,100);\n Function: Generate a pseudo-replicate of the data by randomly\n           sampling, with replacement, the columns from an alignment for\n           the non-parametric bootstrap.\n Returns : Arrayref of L<Bio::SimpleAlign> objects\n Args    : L<Bio::SimpleAlign> object\n           Number of replicates to generate\n\n\nsub bootstrap_replicates {\n   my ($aln,$count) = @_;\n   $count ||= 1;\n   my $alen = $aln->length;\n   my (@seqs,@nm);\n   $aln->set_displayname_flat(1);\n   for my $s ( $aln->each_seq ) {\n       push @seqs, $s->seq();\n       push @nm, $s->id;\n   }\n   my (@alns,$i);\n   while( $count-- > 0 ) {\n       my @newseqs;\n       for($i =0; $i < $alen; $i++ ) {\n\t   my $index = int(rand($alen));\n\t   my $c = 0;\n\t   for ( @seqs ) {\n\t       $newseqs[$c++] .= substr($_,$index,1);\n\t   }\n       }\n       my $newaln = Bio::SimpleAlign->new();\n       my $i = 0;\n       for my $s ( @newseqs ) {\n       (my $tmp = $s) =~ s{[$Bio::LocatableSeq::GAP_SYMBOLS]+}{}g;\n\t   $newaln->add_seq( Bio::LocatableSeq->new\n\t\t\t     (-start         => 1,\n\t\t\t      -end           => length($tmp),\n\t\t\t      -display_id    => $nm[$i++],\n\t\t\t      -seq           => $s));\n       }\n       push @alns, $newaln;\n   }\n   return \\@alns;\n}\n\n=head2 cat\n\n Title     : cat\n Usage     : $aln123 = cat($aln1, $aln2, $aln3)\n Function  : Concatenates alignment objects. Sequences are identified by id.\n             An error will be thrown if the sequence ids are not unique in the\n             first alignment. If any ids are not present or not unique in any\n             of the additional alignments then those sequences are omitted from\n             the concatenated alignment, and a warning is issued. An error will\n             be thrown if any of the alignments are not flush, since\n             concatenating such alignments is unlikely to make biological\n             sense.\n Returns   : A new Bio::SimpleAlign object\n Args      : A list of Bio::SimpleAlign objects","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"cat($self,@aln)"},"line":246,"kind":12,"range":{"start":{"line":246,"character":0},"end":{"character":9999,"line":364}}},{"line":257,"kind":12,"name":"SEQ"},{"line":258,"name":"throw","kind":12},{"line":277,"name":"SEQ","kind":12},{"line":281,"name":"SEQ","kind":12},{"line":292,"kind":12,"containerName":"Seq::Meta::Array","name":"Bio"},{"line":325,"containerName":"Seq::Meta::Array","kind":12,"name":"Bio"},{"line":346,"containerName":"Seq::Meta","kind":12,"name":"Bio"},{"containerName":"Seq::Meta","kind":12,"name":"Bio","line":355}],"version":5}