{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":284},{"containerName":"main::","name":"new","children":[{"line":304,"localvar":"my","kind":13,"containerName":"new","name":"$caller","definition":"my"},{"line":304,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":305,"name":"$class","localvar":"my","containerName":"new","kind":13},{"name":"$caller","kind":13,"containerName":"new","line":305},{"line":305,"name":"$caller","containerName":"new","kind":13},{"line":309,"kind":13,"containerName":"new","name":"$class"},{"line":310,"localvar":"my","kind":13,"containerName":"new","name":"$self","definition":"my"},{"kind":13,"containerName":"new","name":"$class","line":310},{"line":310,"name":"@args","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":311},{"line":311,"containerName":"new","kind":12,"name":"_initialize"},{"kind":13,"containerName":"new","name":"@args","line":311},{"line":312,"containerName":"new","kind":13,"name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"%param","line":315},{"line":315,"name":"@args","kind":13,"containerName":"new"},{"line":316,"containerName":"new","kind":13,"name":"@param"},{"name":"%param","containerName":"new","kind":13,"line":316},{"name":"%param","kind":13,"containerName":"new","line":316},{"definition":"my","name":"$format","localvar":"my","containerName":"new","kind":13,"line":317},{"line":317,"name":"$param","containerName":"new","kind":13},{"line":318,"kind":13,"containerName":"new","name":"$class"},{"name":"_guess_format","kind":12,"containerName":"new","line":318},{"line":318,"name":"$param","kind":13,"containerName":"new"},{"name":"$ARGV","containerName":"new","kind":13,"line":318},{"name":"$format","containerName":"new","kind":13,"line":319},{"line":320,"kind":13,"containerName":"new","name":"$param"},{"line":321,"name":"$format","containerName":"new","kind":13},{"name":"new","containerName":"new","kind":12,"line":321},{"name":"$param","containerName":"new","kind":13,"line":321},{"line":321,"name":"$ARGV","containerName":"new","kind":13},{"line":321,"name":"guess","kind":12,"containerName":"new"},{"name":"$param","kind":13,"containerName":"new","line":323},{"name":"$format","containerName":"new","kind":13,"line":324},{"kind":12,"containerName":"new","name":"new","line":324},{"containerName":"new","kind":13,"name":"$param","line":324},{"line":324,"containerName":"new","kind":13,"name":"$ARGV"},{"name":"guess","kind":12,"containerName":"new","line":324},{"name":"$format","containerName":"new","kind":13,"line":327},{"line":328,"name":"$class","containerName":"new","kind":13},{"line":328,"containerName":"new","kind":12,"name":"throw"},{"line":329,"name":"$format","containerName":"new","kind":13},{"line":331,"name":"$class","kind":13,"containerName":"new"},{"line":331,"kind":12,"containerName":"new","name":"_load_format_module"},{"line":331,"name":"$format","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"new","line":332},{"line":332,"name":"@args","kind":13,"containerName":"new"}],"detail":"($caller,@args)","definition":"sub","kind":12,"range":{"start":{"line":303,"character":0},"end":{"line":334,"character":9999}},"line":303,"signature":{"label":"new($caller,@args)","parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: AlignIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO\n#\n#\tbased on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n#\n# History\n# September, 2000 AlignIO written by Peter Schattner\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO - Handler for AlignIO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::AlignIO;\n\n    $inputfilename = \"testaln.fasta\";\n    $in  = Bio::AlignIO->new(-file   => $inputfilename ,\n                             -format => 'fasta');\n    $out = Bio::AlignIO->new(-file   => \">out.aln.pfam\" ,\n                             -format => 'pfam');\n\n    while ( my $aln = $in->next_aln() ) {\n        $out->write_aln($aln);\n    }\n\n    # OR\n\n    use Bio::AlignIO;\n\n    open MYIN,\"testaln.fasta\";\n    $in  = Bio::AlignIO->newFh(-fh     => \\*MYIN,\n                               -format => 'fasta');\n    open my $MYOUT, '>', 'testaln.pfam';\n    $out = Bio::AlignIO->newFh(-fh     =>  $MYOUT,\n                               -format => 'pfam');\n\n    # World's smallest Fasta<->pfam format converter:\n    print $out $_ while <$in>;\n\n=head1 DESCRIPTION\n\nL<Bio::AlignIO> is a handler module for the formats in the AlignIO set,\nfor example, L<Bio::AlignIO::fasta>. It is the officially sanctioned way \nof getting at the alignment objects. The resulting alignment is a\nL<Bio::Align::AlignI>-compliant object. \n\nThe idea is that you request an object for a particular format.\nAll the objects have a notion of an internal file that is read\nfrom or written to. A particular AlignIO object instance is configured\nfor either input or output, you can think of it as a stream object.\n\nEach object has functions:\n\n   $stream->next_aln();\n\nAnd:\n\n   $stream->write_aln($aln);\n\nAlso:\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nAlignIO object, allowing you to use the standard E<lt>E<gt> and print\noperations to read and write alignment objects:\n\n    use Bio::AlignIO;\n\n    # read from standard input\n    $stream = Bio::AlignIO->newFh(-format => 'Fasta');\n\n    while ( $aln = <$stream> ) {\n\t     # do something with $aln\n    }\n\nAnd:\n\n    print $stream $aln; # when stream is in output mode\n\nL<Bio::AlignIO> is patterned on the L<Bio::SeqIO> module and shares\nmost of its features.  One significant difference is that\nL<Bio::AlignIO> usually handles IO for only a single alignment at a time,\nwhereas L<Bio::SeqIO> handles IO for multiple sequences in a single stream.  \nThe principal reason for this is that whereas simultaneously handling\nmultiple sequences is a common requirement, simultaneous handling of\nmultiple alignments is not. The only current exception is format\nC<bl2seq> which parses results of the BLAST C<bl2seq> program and which\nmay produce several alignment pairs.  This set of alignment pairs can\nbe read using multiple calls to L<next_aln>.\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::AlignIO-E<gt>new()\n\n   $seqIO = Bio::AlignIO->new(-file => 'filename',   -format=>$format);\n   $seqIO = Bio::AlignIO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $seqIO = Bio::AlignIO->new(-format => $format);\n   $seqIO = Bio::AlignIO->new(-fh => \\*STDOUT, -format => $format);\n\nThe L<new> class method constructs a new L<Bio::AlignIO> object.  \nThe returned object can be used to retrieve or print alignment\nobjects. L<new> accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $seqIO = Bio::AlignIO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   bl2seq      Bl2seq Blast output\n   clustalw    clustalw (.aln) format\n   emboss      EMBOSS water and needle format\n   fasta       FASTA format\n   maf         Multiple Alignment Format\n   mase        mase (seaview) format\n   mega        MEGA format\n   meme        MEME format\n   msf         msf (GCG) format\n   nexus       Swofford et al NEXUS format\n   pfam        Pfam sequence alignment format\n   phylip      Felsenstein PHYLIP format\n   prodom      prodom (protein domain) format\n   psi         PSI-BLAST format\n   selex       selex (hmmer) format\n   stockholm   stockholm format\n\nCurrently only those formats which were implemented in L<Bio::SimpleAlign>\nhave been incorporated into L<Bio::AlignIO>.  Specifically, C<mase>, C<stockholm>\nand C<prodom> have only been implemented for input. See the specific module\n(e.g. L<Bio::AlignIO::prodom>) for notes on supported versions.\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename suffix.  If this is unsuccessful,\nC<fasta> format is assumed.\n\nThe format name is case insensitive; C<FASTA>, C<Fasta> and C<fasta> are\nall treated equivalently.\n\n\n=head2 Bio::AlignIO-E<gt>newFh()\n\n   $fh = Bio::AlignIO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   # read from STDIN or use @ARGV:\n   $fh = Bio::AlignIO->newFh(-format => $format);\n\nThis constructor behaves like L<new>, but returns a tied filehandle\nrather than a L<Bio::AlignIO> object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nL<print>. The usual array and $_ semantics work.  For example, you can\nread all sequence objects into an array like this:\n\n  @sequences = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=over 1\n\n* -flush\n\nBy default, all files (or filehandles) opened for writing alignments\nwill be flushed after each write_aln() making the file immediately\nusable.  If you do not need this facility and would like to marginally\nimprove the efficiency of writing multiple sequences to the same file\n(or filehandle), pass the -flush option '0' or any other value that\nevaluates as defined but false:\n\n  my $clustal = Bio::AlignIO->new( -file   => \"<prot.aln\",\n                                   -format => \"clustalw\" );\n  my $msf = Bio::AlignIO->new(-file   => \">prot.msf\",\n                              -format => \"msf\",\n                              -flush  => 0 ); # go as fast as we can!\n  while($seq = $clustal->next_aln) { $msf->write_aln($seq) }\n\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $alignment = $AlignIO-E<gt>next_aln()\n\nFetch an alignment from a formatted file.\n\n=head2 $AlignIO-E<gt>write_aln($aln)\n\nWrite the specified alignment to a file..\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# 'Let the code begin...\n\npackage Bio::AlignIO;\n\nuse strict;\n\nuse Bio::Seq;\nuse Bio::LocatableSeq;\nuse Bio::SimpleAlign;\nuse Bio::Tools::GuessSeqFormat;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::AlignIO->new(-file => $filename,\n                                       -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::AlignIO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n           -displayname_flat => 1 [optional]\n                                to force the displayname to not show start/end\n                                information"}},{"line":310,"name":"SUPER","kind":12,"containerName":"new"},{"line":321,"name":"Bio","kind":12,"containerName":"Tools::GuessSeqFormat"},{"line":324,"name":"Bio","containerName":"Tools::GuessSeqFormat","kind":12},{"kind":12,"range":{"start":{"line":350,"character":0},"end":{"character":9999,"line":354}},"line":350,"name":"newFh","containerName":"main::","children":[{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"newFh","line":351},{"line":352,"name":"$self","localvar":"my","kind":13,"containerName":"newFh","definition":"my"},{"line":352,"kind":13,"containerName":"newFh","name":"$class"},{"line":352,"name":"new","containerName":"newFh","kind":12},{"line":353,"containerName":"newFh","kind":13,"name":"$self"},{"containerName":"newFh","kind":12,"name":"fh","line":353}],"definition":"sub"},{"children":[{"definition":"my","line":371,"localvar":"my","kind":13,"containerName":"fh","name":"$self"},{"kind":13,"localvar":"my","containerName":"fh","name":"$class","line":372,"definition":"my"},{"name":"$self","containerName":"fh","kind":13,"line":372},{"line":372,"kind":13,"containerName":"fh","name":"$self"},{"line":373,"localvar":"my","kind":13,"containerName":"fh","name":"$s","definition":"my"},{"line":374,"containerName":"fh","kind":13,"name":"$class"},{"name":"$self","kind":13,"containerName":"fh","line":374},{"line":375,"name":"$s","containerName":"fh","kind":13}],"containerName":"main::","name":"fh","definition":"sub","line":370,"range":{"end":{"character":9999,"line":376},"start":{"character":0,"line":370}},"kind":12},{"name":"Symbol","kind":12,"containerName":"gensym","line":374},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_initialize","line":381},{"line":381,"containerName":"_initialize","kind":13,"name":"@args"},{"definition":"my","name":"$flat","localvar":"my","containerName":"_initialize","kind":13,"line":382},{"name":"$self","kind":13,"containerName":"_initialize","line":382},{"kind":12,"containerName":"_initialize","name":"_rearrange","line":382},{"line":383,"name":"@args","kind":13,"containerName":"_initialize"},{"name":"$self","containerName":"_initialize","kind":13,"line":384},{"line":384,"name":"force_displayname_flat","containerName":"_initialize","kind":12},{"line":384,"name":"$flat","kind":13,"containerName":"_initialize"},{"line":384,"kind":13,"containerName":"_initialize","name":"$flat"},{"line":385,"containerName":"_initialize","kind":13,"name":"$self"},{"line":385,"containerName":"_initialize","kind":12,"name":"_initialize_io"},{"line":385,"containerName":"_initialize","kind":13,"name":"@args"}],"name":"_initialize","containerName":"main::","signature":{"label":"_initialize($self,@args)","documentation":" _initialize is where the heavy stuff will happen when new is called","parameters":[{"label":"$self"},{"label":"@args"}]},"line":380,"range":{"end":{"line":387,"character":9999},"start":{"character":0,"line":380}},"kind":12},{"children":[{"line":401,"kind":13,"localvar":"my","containerName":"_load_format_module","name":"$self","definition":"my"},{"kind":13,"containerName":"_load_format_module","name":"$format","line":401},{"line":402,"kind":13,"localvar":"my","containerName":"_load_format_module","name":"$module","definition":"my"},{"kind":13,"containerName":"_load_format_module","name":"$format","line":402},{"definition":"my","name":"$ok","localvar":"my","kind":13,"containerName":"_load_format_module","line":403},{"line":406,"containerName":"_load_format_module","kind":13,"name":"$ok"},{"line":406,"name":"$self","kind":13,"containerName":"_load_format_module"},{"line":406,"name":"_load_module","containerName":"_load_format_module","kind":12},{"line":406,"containerName":"_load_format_module","kind":13,"name":"$module"}],"name":"_load_format_module","containerName":"main::","definition":"sub","detail":"($self,$format)","line":400,"range":{"end":{"character":9999,"line":419},"start":{"line":400,"character":0}},"kind":12,"signature":{"label":"_load_format_module($self,$format)","documentation":"1;\n# $Id: AlignIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO\n#\n#\tbased on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n#\n# History\n# September, 2000 AlignIO written by Peter Schattner\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO - Handler for AlignIO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::AlignIO;\n\n    $inputfilename = \"testaln.fasta\";\n    $in  = Bio::AlignIO->new(-file   => $inputfilename ,\n                             -format => 'fasta');\n    $out = Bio::AlignIO->new(-file   => \">out.aln.pfam\" ,\n                             -format => 'pfam');\n\n    while ( my $aln = $in->next_aln() ) {\n        $out->write_aln($aln);\n    }\n\n    # OR\n\n    use Bio::AlignIO;\n\n    open MYIN,\"testaln.fasta\";\n    $in  = Bio::AlignIO->newFh(-fh     => \\*MYIN,\n                               -format => 'fasta');\n    open my $MYOUT, '>', 'testaln.pfam';\n    $out = Bio::AlignIO->newFh(-fh     =>  $MYOUT,\n                               -format => 'pfam');\n\n    # World's smallest Fasta<->pfam format converter:\n    print $out $_ while <$in>;\n\n=head1 DESCRIPTION\n\nL<Bio::AlignIO> is a handler module for the formats in the AlignIO set,\nfor example, L<Bio::AlignIO::fasta>. It is the officially sanctioned way \nof getting at the alignment objects. The resulting alignment is a\nL<Bio::Align::AlignI>-compliant object. \n\nThe idea is that you request an object for a particular format.\nAll the objects have a notion of an internal file that is read\nfrom or written to. A particular AlignIO object instance is configured\nfor either input or output, you can think of it as a stream object.\n\nEach object has functions:\n\n   $stream->next_aln();\n\nAnd:\n\n   $stream->write_aln($aln);\n\nAlso:\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nAlignIO object, allowing you to use the standard E<lt>E<gt> and print\noperations to read and write alignment objects:\n\n    use Bio::AlignIO;\n\n    # read from standard input\n    $stream = Bio::AlignIO->newFh(-format => 'Fasta');\n\n    while ( $aln = <$stream> ) {\n\t     # do something with $aln\n    }\n\nAnd:\n\n    print $stream $aln; # when stream is in output mode\n\nL<Bio::AlignIO> is patterned on the L<Bio::SeqIO> module and shares\nmost of its features.  One significant difference is that\nL<Bio::AlignIO> usually handles IO for only a single alignment at a time,\nwhereas L<Bio::SeqIO> handles IO for multiple sequences in a single stream.  \nThe principal reason for this is that whereas simultaneously handling\nmultiple sequences is a common requirement, simultaneous handling of\nmultiple alignments is not. The only current exception is format\nC<bl2seq> which parses results of the BLAST C<bl2seq> program and which\nmay produce several alignment pairs.  This set of alignment pairs can\nbe read using multiple calls to L<next_aln>.\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::AlignIO-E<gt>new()\n\n   $seqIO = Bio::AlignIO->new(-file => 'filename',   -format=>$format);\n   $seqIO = Bio::AlignIO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $seqIO = Bio::AlignIO->new(-format => $format);\n   $seqIO = Bio::AlignIO->new(-fh => \\*STDOUT, -format => $format);\n\nThe L<new> class method constructs a new L<Bio::AlignIO> object.  \nThe returned object can be used to retrieve or print alignment\nobjects. L<new> accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $seqIO = Bio::AlignIO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   bl2seq      Bl2seq Blast output\n   clustalw    clustalw (.aln) format\n   emboss      EMBOSS water and needle format\n   fasta       FASTA format\n   maf         Multiple Alignment Format\n   mase        mase (seaview) format\n   mega        MEGA format\n   meme        MEME format\n   msf         msf (GCG) format\n   nexus       Swofford et al NEXUS format\n   pfam        Pfam sequence alignment format\n   phylip      Felsenstein PHYLIP format\n   prodom      prodom (protein domain) format\n   psi         PSI-BLAST format\n   selex       selex (hmmer) format\n   stockholm   stockholm format\n\nCurrently only those formats which were implemented in L<Bio::SimpleAlign>\nhave been incorporated into L<Bio::AlignIO>.  Specifically, C<mase>, C<stockholm>\nand C<prodom> have only been implemented for input. See the specific module\n(e.g. L<Bio::AlignIO::prodom>) for notes on supported versions.\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename suffix.  If this is unsuccessful,\nC<fasta> format is assumed.\n\nThe format name is case insensitive; C<FASTA>, C<Fasta> and C<fasta> are\nall treated equivalently.\n\n\n=head2 Bio::AlignIO-E<gt>newFh()\n\n   $fh = Bio::AlignIO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   # read from STDIN or use @ARGV:\n   $fh = Bio::AlignIO->newFh(-format => $format);\n\nThis constructor behaves like L<new>, but returns a tied filehandle\nrather than a L<Bio::AlignIO> object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nL<print>. The usual array and $_ semantics work.  For example, you can\nread all sequence objects into an array like this:\n\n  @sequences = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=over 1\n\n* -flush\n\nBy default, all files (or filehandles) opened for writing alignments\nwill be flushed after each write_aln() making the file immediately\nusable.  If you do not need this facility and would like to marginally\nimprove the efficiency of writing multiple sequences to the same file\n(or filehandle), pass the -flush option '0' or any other value that\nevaluates as defined but false:\n\n  my $clustal = Bio::AlignIO->new( -file   => \"<prot.aln\",\n                                   -format => \"clustalw\" );\n  my $msf = Bio::AlignIO->new(-file   => \">prot.msf\",\n                              -format => \"msf\",\n                              -flush  => 0 ); # go as fast as we can!\n  while($seq = $clustal->next_aln) { $msf->write_aln($seq) }\n\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $alignment = $AlignIO-E<gt>next_aln()\n\nFetch an alignment from a formatted file.\n\n=head2 $AlignIO-E<gt>write_aln($aln)\n\nWrite the specified alignment to a file..\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# 'Let the code begin...\n\npackage Bio::AlignIO;\n\nuse strict;\n\nuse Bio::Seq;\nuse Bio::LocatableSeq;\nuse Bio::SimpleAlign;\nuse Bio::Tools::GuessSeqFormat;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::AlignIO->new(-file => $filename,\n                                       -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::AlignIO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n           -displayname_flat => 1 [optional]\n                                to force the displayname to not show start/end\n                                information\n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::AlignIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] );\n        unless ($format) {\n            if ($param{-file}) {\n                $format = Bio::Tools::GuessSeqFormat->new(-file => $param{-file}||$ARGV[0] )->guess;\n            }\n            elsif ($param{-fh}) {\n                $format = Bio::Tools::GuessSeqFormat->new(-fh => $param{-fh}||$ARGV[0] )->guess;\n            }\n        }\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n        $class->throw(\"Unknown format given or could not determine it [$format]\")\n            unless $format;\n\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::AlignIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::AlignIO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::AlignIO->newFh(-file=>$filename,-format=>'Format')\n           $sequence = <$fh>;   # read a sequence object\n           print $fh $sequence; # write a sequence object\n Returns : filehandle tied to the Bio::AlignIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $sequence = <$fh>;   # read a sequence object\n           print $fh $sequence; # write a sequence object\n Returns : filehandle tied to the Bio::AlignIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n# _initialize is where the heavy stuff will happen when new is called\n\nsub _initialize {\n  my($self,@args) = @_;\n  my ($flat) = $self->_rearrange([qw(DISPLAYNAME_FLAT)],\n\t\t\t\t @args);\n  $self->force_displayname_flat($flat) if defined $flat;\n  $self->_initialize_io(@args);\n  1;\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL AlignIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$format"}]}},{"definition":"sub","detail":"($self,$aln)","children":[{"line":432,"name":"$self","localvar":"my","containerName":"next_aln","kind":13,"definition":"my"},{"line":432,"name":"$aln","containerName":"next_aln","kind":13},{"line":433,"name":"$self","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":12,"name":"throw","line":433}],"containerName":"main::","name":"next_aln","signature":{"label":"next_aln($self,$aln)","parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: AlignIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO\n#\n#\tbased on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n#\n# History\n# September, 2000 AlignIO written by Peter Schattner\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO - Handler for AlignIO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::AlignIO;\n\n    $inputfilename = \"testaln.fasta\";\n    $in  = Bio::AlignIO->new(-file   => $inputfilename ,\n                             -format => 'fasta');\n    $out = Bio::AlignIO->new(-file   => \">out.aln.pfam\" ,\n                             -format => 'pfam');\n\n    while ( my $aln = $in->next_aln() ) {\n        $out->write_aln($aln);\n    }\n\n    # OR\n\n    use Bio::AlignIO;\n\n    open MYIN,\"testaln.fasta\";\n    $in  = Bio::AlignIO->newFh(-fh     => \\*MYIN,\n                               -format => 'fasta');\n    open my $MYOUT, '>', 'testaln.pfam';\n    $out = Bio::AlignIO->newFh(-fh     =>  $MYOUT,\n                               -format => 'pfam');\n\n    # World's smallest Fasta<->pfam format converter:\n    print $out $_ while <$in>;\n\n=head1 DESCRIPTION\n\nL<Bio::AlignIO> is a handler module for the formats in the AlignIO set,\nfor example, L<Bio::AlignIO::fasta>. It is the officially sanctioned way \nof getting at the alignment objects. The resulting alignment is a\nL<Bio::Align::AlignI>-compliant object. \n\nThe idea is that you request an object for a particular format.\nAll the objects have a notion of an internal file that is read\nfrom or written to. A particular AlignIO object instance is configured\nfor either input or output, you can think of it as a stream object.\n\nEach object has functions:\n\n   $stream->next_aln();\n\nAnd:\n\n   $stream->write_aln($aln);\n\nAlso:\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nAlignIO object, allowing you to use the standard E<lt>E<gt> and print\noperations to read and write alignment objects:\n\n    use Bio::AlignIO;\n\n    # read from standard input\n    $stream = Bio::AlignIO->newFh(-format => 'Fasta');\n\n    while ( $aln = <$stream> ) {\n\t     # do something with $aln\n    }\n\nAnd:\n\n    print $stream $aln; # when stream is in output mode\n\nL<Bio::AlignIO> is patterned on the L<Bio::SeqIO> module and shares\nmost of its features.  One significant difference is that\nL<Bio::AlignIO> usually handles IO for only a single alignment at a time,\nwhereas L<Bio::SeqIO> handles IO for multiple sequences in a single stream.  \nThe principal reason for this is that whereas simultaneously handling\nmultiple sequences is a common requirement, simultaneous handling of\nmultiple alignments is not. The only current exception is format\nC<bl2seq> which parses results of the BLAST C<bl2seq> program and which\nmay produce several alignment pairs.  This set of alignment pairs can\nbe read using multiple calls to L<next_aln>.\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::AlignIO-E<gt>new()\n\n   $seqIO = Bio::AlignIO->new(-file => 'filename',   -format=>$format);\n   $seqIO = Bio::AlignIO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $seqIO = Bio::AlignIO->new(-format => $format);\n   $seqIO = Bio::AlignIO->new(-fh => \\*STDOUT, -format => $format);\n\nThe L<new> class method constructs a new L<Bio::AlignIO> object.  \nThe returned object can be used to retrieve or print alignment\nobjects. L<new> accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $seqIO = Bio::AlignIO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   bl2seq      Bl2seq Blast output\n   clustalw    clustalw (.aln) format\n   emboss      EMBOSS water and needle format\n   fasta       FASTA format\n   maf         Multiple Alignment Format\n   mase        mase (seaview) format\n   mega        MEGA format\n   meme        MEME format\n   msf         msf (GCG) format\n   nexus       Swofford et al NEXUS format\n   pfam        Pfam sequence alignment format\n   phylip      Felsenstein PHYLIP format\n   prodom      prodom (protein domain) format\n   psi         PSI-BLAST format\n   selex       selex (hmmer) format\n   stockholm   stockholm format\n\nCurrently only those formats which were implemented in L<Bio::SimpleAlign>\nhave been incorporated into L<Bio::AlignIO>.  Specifically, C<mase>, C<stockholm>\nand C<prodom> have only been implemented for input. See the specific module\n(e.g. L<Bio::AlignIO::prodom>) for notes on supported versions.\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename suffix.  If this is unsuccessful,\nC<fasta> format is assumed.\n\nThe format name is case insensitive; C<FASTA>, C<Fasta> and C<fasta> are\nall treated equivalently.\n\n\n=head2 Bio::AlignIO-E<gt>newFh()\n\n   $fh = Bio::AlignIO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   # read from STDIN or use @ARGV:\n   $fh = Bio::AlignIO->newFh(-format => $format);\n\nThis constructor behaves like L<new>, but returns a tied filehandle\nrather than a L<Bio::AlignIO> object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nL<print>. The usual array and $_ semantics work.  For example, you can\nread all sequence objects into an array like this:\n\n  @sequences = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=over 1\n\n* -flush\n\nBy default, all files (or filehandles) opened for writing alignments\nwill be flushed after each write_aln() making the file immediately\nusable.  If you do not need this facility and would like to marginally\nimprove the efficiency of writing multiple sequences to the same file\n(or filehandle), pass the -flush option '0' or any other value that\nevaluates as defined but false:\n\n  my $clustal = Bio::AlignIO->new( -file   => \"<prot.aln\",\n                                   -format => \"clustalw\" );\n  my $msf = Bio::AlignIO->new(-file   => \">prot.msf\",\n                              -format => \"msf\",\n                              -flush  => 0 ); # go as fast as we can!\n  while($seq = $clustal->next_aln) { $msf->write_aln($seq) }\n\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $alignment = $AlignIO-E<gt>next_aln()\n\nFetch an alignment from a formatted file.\n\n=head2 $AlignIO-E<gt>write_aln($aln)\n\nWrite the specified alignment to a file..\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# 'Let the code begin...\n\npackage Bio::AlignIO;\n\nuse strict;\n\nuse Bio::Seq;\nuse Bio::LocatableSeq;\nuse Bio::SimpleAlign;\nuse Bio::Tools::GuessSeqFormat;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::AlignIO->new(-file => $filename,\n                                       -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::AlignIO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n           -displayname_flat => 1 [optional]\n                                to force the displayname to not show start/end\n                                information\n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::AlignIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] );\n        unless ($format) {\n            if ($param{-file}) {\n                $format = Bio::Tools::GuessSeqFormat->new(-file => $param{-file}||$ARGV[0] )->guess;\n            }\n            elsif ($param{-fh}) {\n                $format = Bio::Tools::GuessSeqFormat->new(-fh => $param{-fh}||$ARGV[0] )->guess;\n            }\n        }\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n        $class->throw(\"Unknown format given or could not determine it [$format]\")\n            unless $format;\n\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::AlignIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::AlignIO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::AlignIO->newFh(-file=>$filename,-format=>'Format')\n           $sequence = <$fh>;   # read a sequence object\n           print $fh $sequence; # write a sequence object\n Returns : filehandle tied to the Bio::AlignIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $sequence = <$fh>;   # read a sequence object\n           print $fh $sequence; # write a sequence object\n Returns : filehandle tied to the Bio::AlignIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n# _initialize is where the heavy stuff will happen when new is called\n\nsub _initialize {\n  my($self,@args) = @_;\n  my ($flat) = $self->_rearrange([qw(DISPLAYNAME_FLAT)],\n\t\t\t\t @args);\n  $self->force_displayname_flat($flat) if defined $flat;\n  $self->_initialize_io(@args);\n  1;\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL AlignIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :\n\n\nsub _load_format_module {\n  my ($self,$format) = @_;\n  my $module = \"Bio::AlignIO::\" . $format;\n  my $ok;\n\n  eval {\n      $ok = $self->_load_module($module);\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$self: $format cannot be found\nException $@\nFor more information about the AlignIO system please see the AlignIO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n    return;\n  }\n  return 1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = stream->next_aln\n Function: reads the next $aln object from the stream\n Returns : a Bio::Align::AlignI compliant object\n Args    :"},"line":431,"kind":12,"range":{"end":{"line":434,"character":9999},"start":{"line":431,"character":0}}},{"line":446,"range":{"end":{"line":449,"character":9999},"start":{"character":0,"line":446}},"kind":12,"signature":{"label":"write_aln($self,$aln)","parameters":[{"label":"$self"},{"label":"$aln"}],"documentation":"1;\n# $Id: AlignIO.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO\n#\n#\tbased on the Bio::SeqIO module\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n#\n# History\n# September, 2000 AlignIO written by Peter Schattner\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO - Handler for AlignIO Formats\n\n=head1 SYNOPSIS\n\n    use Bio::AlignIO;\n\n    $inputfilename = \"testaln.fasta\";\n    $in  = Bio::AlignIO->new(-file   => $inputfilename ,\n                             -format => 'fasta');\n    $out = Bio::AlignIO->new(-file   => \">out.aln.pfam\" ,\n                             -format => 'pfam');\n\n    while ( my $aln = $in->next_aln() ) {\n        $out->write_aln($aln);\n    }\n\n    # OR\n\n    use Bio::AlignIO;\n\n    open MYIN,\"testaln.fasta\";\n    $in  = Bio::AlignIO->newFh(-fh     => \\*MYIN,\n                               -format => 'fasta');\n    open my $MYOUT, '>', 'testaln.pfam';\n    $out = Bio::AlignIO->newFh(-fh     =>  $MYOUT,\n                               -format => 'pfam');\n\n    # World's smallest Fasta<->pfam format converter:\n    print $out $_ while <$in>;\n\n=head1 DESCRIPTION\n\nL<Bio::AlignIO> is a handler module for the formats in the AlignIO set,\nfor example, L<Bio::AlignIO::fasta>. It is the officially sanctioned way \nof getting at the alignment objects. The resulting alignment is a\nL<Bio::Align::AlignI>-compliant object. \n\nThe idea is that you request an object for a particular format.\nAll the objects have a notion of an internal file that is read\nfrom or written to. A particular AlignIO object instance is configured\nfor either input or output, you can think of it as a stream object.\n\nEach object has functions:\n\n   $stream->next_aln();\n\nAnd:\n\n   $stream->write_aln($aln);\n\nAlso:\n\n   $stream->type() # returns 'INPUT' or 'OUTPUT'\n\nAs an added bonus, you can recover a filehandle that is tied to the\nAlignIO object, allowing you to use the standard E<lt>E<gt> and print\noperations to read and write alignment objects:\n\n    use Bio::AlignIO;\n\n    # read from standard input\n    $stream = Bio::AlignIO->newFh(-format => 'Fasta');\n\n    while ( $aln = <$stream> ) {\n\t     # do something with $aln\n    }\n\nAnd:\n\n    print $stream $aln; # when stream is in output mode\n\nL<Bio::AlignIO> is patterned on the L<Bio::SeqIO> module and shares\nmost of its features.  One significant difference is that\nL<Bio::AlignIO> usually handles IO for only a single alignment at a time,\nwhereas L<Bio::SeqIO> handles IO for multiple sequences in a single stream.  \nThe principal reason for this is that whereas simultaneously handling\nmultiple sequences is a common requirement, simultaneous handling of\nmultiple alignments is not. The only current exception is format\nC<bl2seq> which parses results of the BLAST C<bl2seq> program and which\nmay produce several alignment pairs.  This set of alignment pairs can\nbe read using multiple calls to L<next_aln>.\n\n=head1 CONSTRUCTORS\n\n=head2 Bio::AlignIO-E<gt>new()\n\n   $seqIO = Bio::AlignIO->new(-file => 'filename',   -format=>$format);\n   $seqIO = Bio::AlignIO->new(-fh   => \\*FILEHANDLE, -format=>$format);\n   $seqIO = Bio::AlignIO->new(-format => $format);\n   $seqIO = Bio::AlignIO->new(-fh => \\*STDOUT, -format => $format);\n\nThe L<new> class method constructs a new L<Bio::AlignIO> object.  \nThe returned object can be used to retrieve or print alignment\nobjects. L<new> accepts the following parameters:\n\n=over 4\n\n* -file\n\nA file path to be opened for reading or writing.  The usual Perl\nconventions apply:\n\n   'file'       # open file for reading\n   '>file'      # open file for writing\n   '>>file'     # open file for appending\n   '+<file'     # open file read/write\n   'command |'  # open a pipe from the command\n   '| command'  # open a pipe to the command\n\n* -fh\n\nYou may provide new() with a previously-opened filehandle.  For\nexample, to read from STDIN:\n\n   $seqIO = Bio::AlignIO->new(-fh => \\*STDIN);\n\nNote that you must pass filehandles as references to globs.\n\nIf neither a filehandle nor a filename is specified, then the module\nwill read from the @ARGV array or STDIN, using the familiar E<lt>E<gt>\nsemantics.\n\n* -format\n\nSpecify the format of the file.  Supported formats include:\n\n   bl2seq      Bl2seq Blast output\n   clustalw    clustalw (.aln) format\n   emboss      EMBOSS water and needle format\n   fasta       FASTA format\n   maf         Multiple Alignment Format\n   mase        mase (seaview) format\n   mega        MEGA format\n   meme        MEME format\n   msf         msf (GCG) format\n   nexus       Swofford et al NEXUS format\n   pfam        Pfam sequence alignment format\n   phylip      Felsenstein PHYLIP format\n   prodom      prodom (protein domain) format\n   psi         PSI-BLAST format\n   selex       selex (hmmer) format\n   stockholm   stockholm format\n\nCurrently only those formats which were implemented in L<Bio::SimpleAlign>\nhave been incorporated into L<Bio::AlignIO>.  Specifically, C<mase>, C<stockholm>\nand C<prodom> have only been implemented for input. See the specific module\n(e.g. L<Bio::AlignIO::prodom>) for notes on supported versions.\n\nIf no format is specified and a filename is given, then the module\nwill attempt to deduce it from the filename suffix.  If this is unsuccessful,\nC<fasta> format is assumed.\n\nThe format name is case insensitive; C<FASTA>, C<Fasta> and C<fasta> are\nall treated equivalently.\n\n\n=head2 Bio::AlignIO-E<gt>newFh()\n\n   $fh = Bio::AlignIO->newFh(-fh   => \\*FILEHANDLE, -format=>$format);\n   # read from STDIN or use @ARGV:\n   $fh = Bio::AlignIO->newFh(-format => $format);\n\nThis constructor behaves like L<new>, but returns a tied filehandle\nrather than a L<Bio::AlignIO> object.  You can read sequences from this\nobject using the familiar E<lt>E<gt> operator, and write to it using\nL<print>. The usual array and $_ semantics work.  For example, you can\nread all sequence objects into an array like this:\n\n  @sequences = <$fh>;\n\nOther operations, such as read(), sysread(), write(), close(), and printf()\nare not supported.\n\n=over 1\n\n* -flush\n\nBy default, all files (or filehandles) opened for writing alignments\nwill be flushed after each write_aln() making the file immediately\nusable.  If you do not need this facility and would like to marginally\nimprove the efficiency of writing multiple sequences to the same file\n(or filehandle), pass the -flush option '0' or any other value that\nevaluates as defined but false:\n\n  my $clustal = Bio::AlignIO->new( -file   => \"<prot.aln\",\n                                   -format => \"clustalw\" );\n  my $msf = Bio::AlignIO->new(-file   => \">prot.msf\",\n                              -format => \"msf\",\n                              -flush  => 0 ); # go as fast as we can!\n  while($seq = $clustal->next_aln) { $msf->write_aln($seq) }\n\n\n=head1 OBJECT METHODS\n\nSee below for more detailed summaries.  The main methods are:\n\n=head2 $alignment = $AlignIO-E<gt>next_aln()\n\nFetch an alignment from a formatted file.\n\n=head2 $AlignIO-E<gt>write_aln($aln)\n\nWrite the specified alignment to a file..\n\n=head2 TIEHANDLE(), READLINE(), PRINT()\n\nThese provide the tie interface.  See L<perltie> for more details.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# 'Let the code begin...\n\npackage Bio::AlignIO;\n\nuse strict;\n\nuse Bio::Seq;\nuse Bio::LocatableSeq;\nuse Bio::SimpleAlign;\nuse Bio::Tools::GuessSeqFormat;\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : $stream = Bio::AlignIO->new(-file => $filename,\n                                       -format => 'Format')\n Function: Returns a new seqstream\n Returns : A Bio::AlignIO::Handler initialised with\n           the appropriate format\n Args    : -file => $filename\n           -format => format\n           -fh => filehandle to attach to\n           -displayname_flat => 1 [optional]\n                                to force the displayname to not show start/end\n                                information\n\n\nsub new {\n    my ($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::AlignIO::(\\S+)/ ) {\n\tmy ($self) = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{-file} || $ARGV[0] );\n        unless ($format) {\n            if ($param{-file}) {\n                $format = Bio::Tools::GuessSeqFormat->new(-file => $param{-file}||$ARGV[0] )->guess;\n            }\n            elsif ($param{-fh}) {\n                $format = Bio::Tools::GuessSeqFormat->new(-fh => $param{-fh}||$ARGV[0] )->guess;\n            }\n        }\n\t$format = \"\\L$format\";\t# normalize capitalization to lower case\n        $class->throw(\"Unknown format given or could not determine it [$format]\")\n            unless $format;\n\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::AlignIO::$format\"->new(@args);\n    }\n}\n\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::AlignIO->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::AlignIO->newFh(-file=>$filename,-format=>'Format')\n           $sequence = <$fh>;   # read a sequence object\n           print $fh $sequence; # write a sequence object\n Returns : filehandle tied to the Bio::AlignIO::Fh class\n Args    :\n\n\nsub newFh {\n  my $class = shift;\n  return unless my $self = $class->new(@_);\n  return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $sequence = <$fh>;   # read a sequence object\n           print $fh $sequence; # write a sequence object\n Returns : filehandle tied to the Bio::AlignIO::Fh class\n Args    :\n\n\n\nsub fh {\n  my $self = shift;\n  my $class = ref($self) || $self;\n  my $s = Symbol::gensym;\n  tie $$s,$class,$self;\n  return $s;\n}\n\n# _initialize is where the heavy stuff will happen when new is called\n\nsub _initialize {\n  my($self,@args) = @_;\n  my ($flat) = $self->_rearrange([qw(DISPLAYNAME_FLAT)],\n\t\t\t\t @args);\n  $self->force_displayname_flat($flat) if defined $flat;\n  $self->_initialize_io(@args);\n  1;\n}\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL AlignIO stuff*\n Function: Loads up (like use) a module at run time on demand\n Example :\n Returns :\n Args    :\n\n\nsub _load_format_module {\n  my ($self,$format) = @_;\n  my $module = \"Bio::AlignIO::\" . $format;\n  my $ok;\n\n  eval {\n      $ok = $self->_load_module($module);\n  };\n  if ( $@ ) {\n    print STDERR <<END;\n$self: $format cannot be found\nException $@\nFor more information about the AlignIO system please see the AlignIO docs.\nThis includes ways of checking for formats at compile time, not run time\nEND\n  ;\n    return;\n  }\n  return 1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = stream->next_aln\n Function: reads the next $aln object from the stream\n Returns : a Bio::Align::AlignI compliant object\n Args    :\n\n\nsub next_aln {\n   my ($self,$aln) = @_;\n   $self->throw(\"Sorry, you cannot read from a generic Bio::AlignIO object.\");\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln($aln)\n Function: writes the $aln object into the stream\n Returns : 1 for success and 0 for error\n Args    : Bio::Seq object"},"children":[{"line":447,"containerName":"write_aln","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":447,"name":"$aln","kind":13,"containerName":"write_aln"},{"line":448,"name":"$self","kind":13,"containerName":"write_aln"},{"line":448,"name":"throw","containerName":"write_aln","kind":12}],"containerName":"main::","name":"write_aln","definition":"sub","detail":"($self,$aln)"},{"kind":12,"range":{"end":{"line":480,"character":9999},"start":{"line":462,"character":0}},"line":462,"definition":"sub","name":"_guess_format","containerName":"main::","children":[{"definition":"my","line":463,"localvar":"my","kind":13,"containerName":"_guess_format","name":"$class"}]},{"kind":12,"range":{"end":{"line":485,"character":9999},"start":{"line":482,"character":0}},"line":482,"definition":"sub","containerName":"main::","name":"DESTROY","children":[{"line":483,"name":"$self","containerName":"DESTROY","localvar":"my","kind":13,"definition":"my"},{"name":"$self","containerName":"DESTROY","kind":13,"line":484},{"kind":12,"containerName":"DESTROY","name":"close","line":484}]},{"definition":"sub","children":[{"definition":"my","name":"$class","localvar":"my","containerName":"TIEHANDLE","kind":13,"line":488},{"line":489,"containerName":"TIEHANDLE","kind":13,"name":"$class"}],"name":"TIEHANDLE","containerName":"main::","line":487,"kind":12,"range":{"start":{"character":0,"line":487},"end":{"character":9999,"line":490}}},{"kind":12,"range":{"end":{"character":9999,"line":498},"start":{"character":0,"line":492}},"line":492,"definition":"sub","containerName":"main::","name":"READLINE","children":[{"definition":"my","line":493,"localvar":"my","containerName":"READLINE","kind":13,"name":"$self"},{"line":494,"kind":13,"containerName":"READLINE","name":"$self"},{"line":494,"name":"next_aln","containerName":"READLINE","kind":12},{"line":495,"name":"@list","localvar":"my","kind":13,"containerName":"READLINE","definition":"my"},{"name":"$obj","kind":13,"containerName":"READLINE","line":495},{"line":496,"containerName":"READLINE","kind":13,"name":"@list"},{"containerName":"READLINE","kind":13,"name":"$obj","line":496},{"name":"$obj","kind":13,"containerName":"READLINE","line":496},{"line":496,"name":"$self","containerName":"READLINE","kind":13},{"name":"next_aln","kind":12,"containerName":"READLINE","line":496},{"line":497,"containerName":"READLINE","kind":13,"name":"@list"}]},{"kind":12,"range":{"end":{"line":503,"character":9999},"start":{"character":0,"line":500}},"line":500,"definition":"sub","name":"PRINT","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"PRINT","name":"$self","line":501,"definition":"my"},{"name":"$self","containerName":"PRINT","kind":13,"line":502},{"name":"write_aln","kind":12,"containerName":"PRINT","line":502}]},{"definition":"sub","name":"force_displayname_flat","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"force_displayname_flat","line":519},{"line":520,"containerName":"force_displayname_flat","kind":13,"name":"$self"},{"line":521,"name":"$self","kind":13,"containerName":"force_displayname_flat"}],"kind":12,"range":{"start":{"line":518,"character":0},"end":{"character":9999,"line":522}},"line":518}]}