{"vars":[{"containerName":"","kind":2,"name":"base","line":110},{"kind":12,"range":{"end":{"character":9999,"line":129},"start":{"character":0,"line":124}},"line":124,"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: bl2seq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::bl2seq\n\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#   the Bio::Tools::BPlite modules by\n#   Ian Korf (ifkorf at ucdavis.edu, http://www.bioperl.org/wiki/Ian_Korf),\n#   Lorenz Pollak (lorenz@ist.org, bioperl port)\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::bl2seq - bl2seq sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class, as in:\n\n    use Bio::AlignIO;\n\n    $in  = Bio::AlignIO->new(-file   => \"inputfilename\" ,\n                             -format => \"bl2seq\",\n                             -report_type => \"blastn\");\n    $aln = $in->next_aln();\n\n\n=head1 DESCRIPTION\n\nThis object can create L<Bio::SimpleAlign> sequence alignment objects (of\ntwo sequences) from C<bl2seq> BLAST reports.\n\nA nice feature of this module is that - in combination with\nL<Bio::Tools::Run::StandAloneBlast.pm> or a remote BLAST - it can be used to\nalign two sequences and make a L<Bio::SimpleAlign> object from them which\ncan then be manipulated using any L<Bio::SimpleAlign> methods, eg:\n\n   # Get two sequences\n   $str = Bio::SeqIO->new(-file=>'t/amino.fa' , '-format' => 'Fasta', );\n   my $seq3 = $str->next_seq();\n   my $seq4 = $str->next_seq();\n\n   # Run bl2seq on them\n   $factory = Bio::Tools::StandAloneBlast->new('program' => 'blastp',\n                                               'outfile' => 'bl2seq.out');\n   my $bl2seq_report = $factory->bl2seq($seq3, $seq4);\n   # Note that report is a Bio::SearchIO object\n\n   # Use AlignIO.pm to create a SimpleAlign object from the bl2seq report\n   $str = Bio::AlignIO->new(-file=> 'bl2seq.out','-format' => 'bl2seq');\n   $aln = $str->next_aln();\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::bl2seq;\nuse strict;\n\nuse Bio::SearchIO;\n\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::SimpleAlign->new(-format => 'bl2seq',\n                                               -file   => 'filename',\n                                               -report_type => 'blastx');\n Function: Get a L<Bio::SimpleAlign>\n Returns : L<Bio::SimpleAlign> object\n Args    : -report_type => report type (blastn,blastx,tblastx,tblastn,blastp)"},"name":"_initialize","containerName":"main::","children":[{"line":125,"name":"$self","kind":13,"localvar":"my","containerName":"_initialize","definition":"my"},{"line":125,"containerName":"_initialize","kind":13,"name":"@args"},{"kind":13,"containerName":"_initialize","name":"$self","line":126},{"containerName":"_initialize","kind":13,"name":"@args","line":126},{"definition":"my","line":127,"name":"$rt","containerName":"_initialize","localvar":"my","kind":13},{"kind":13,"containerName":"_initialize","name":"$self","line":127},{"name":"_rearrange","containerName":"_initialize","kind":12,"line":127},{"line":127,"kind":13,"containerName":"_initialize","name":"@args"},{"line":128,"containerName":"_initialize","kind":13,"name":"$rt"},{"line":128,"name":"$self","containerName":"_initialize","kind":13},{"kind":12,"containerName":"_initialize","name":"report_type","line":128},{"name":"$rt","containerName":"_initialize","kind":13,"line":128}],"detail":"($self,@args)","definition":"sub"},{"kind":12,"containerName":"_initialize","name":"SUPER","line":126},{"children":[{"line":143,"kind":13,"localvar":"my","containerName":"next_aln","name":"$self","definition":"my"},{"line":144,"name":"$self","containerName":"next_aln","kind":13},{"name":"$self","kind":13,"containerName":"next_aln","line":145},{"line":145,"containerName":"next_aln","kind":12,"name":"new"},{"kind":13,"containerName":"next_aln","name":"$self","line":145},{"line":145,"containerName":"next_aln","kind":12,"name":"_fh"},{"line":147,"kind":13,"containerName":"next_aln","name":"$self"},{"line":147,"containerName":"next_aln","kind":12,"name":"report_type"},{"line":150,"name":"$self","kind":13,"containerName":"next_aln"},{"line":151,"name":"$self","containerName":"next_aln","kind":13},{"line":151,"name":"$self","containerName":"next_aln","kind":13},{"line":151,"kind":12,"containerName":"next_aln","name":"next_result"},{"line":153,"containerName":"next_aln","kind":13,"name":"$self"},{"name":"$self","containerName":"next_aln","kind":13,"line":154},{"kind":13,"containerName":"next_aln","name":"$self","line":155},{"name":"$self","containerName":"next_aln","kind":13,"line":155},{"line":155,"kind":12,"containerName":"next_aln","name":"next_hit"},{"name":"$self","containerName":"next_aln","kind":13,"line":158},{"containerName":"next_aln","kind":13,"name":"$self","line":159},{"definition":"my","line":162,"name":"$hsp","localvar":"my","kind":13,"containerName":"next_aln"},{"line":162,"containerName":"next_aln","kind":13,"name":"$self"},{"containerName":"next_aln","kind":12,"name":"next_hsp","line":162},{"line":164,"name":"$hsp","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$self","line":165},{"line":168,"name":"$hsp","kind":13,"containerName":"next_aln"},{"name":"$hsp","kind":13,"containerName":"next_aln","line":168},{"name":"get_aln","containerName":"next_aln","kind":12,"line":168}],"name":"next_aln","containerName":"main::","definition":"sub","line":142,"range":{"start":{"character":0,"line":142},"end":{"line":170,"character":9999}},"kind":12},{"containerName":"SearchIO","kind":12,"name":"Bio","line":145},{"detail":"($self,@aln)","definition":"sub","containerName":"main::","name":"write_aln","children":[{"definition":"my","line":185,"localvar":"my","kind":13,"containerName":"write_aln","name":"$self"},{"name":"@aln","containerName":"write_aln","kind":13,"line":185},{"line":186,"kind":13,"containerName":"write_aln","name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"write_aln","line":186}],"signature":{"documentation":"1;\n# $Id: bl2seq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::bl2seq\n\n#   based on the Bio::SeqIO modules\n#       by Ewan Birney <birney@ebi.ac.uk>\n#       and Lincoln Stein  <lstein@cshl.org>\n#\n#   the Bio::Tools::BPlite modules by\n#   Ian Korf (ifkorf at ucdavis.edu, http://www.bioperl.org/wiki/Ian_Korf),\n#   Lorenz Pollak (lorenz@ist.org, bioperl port)\n#\n#       and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Peter Schattner\n#\n# You may distribute this module under the same terms as perl itself\n# _history\n# September 5, 2000\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::bl2seq - bl2seq sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the L<Bio::AlignIO> class, as in:\n\n    use Bio::AlignIO;\n\n    $in  = Bio::AlignIO->new(-file   => \"inputfilename\" ,\n                             -format => \"bl2seq\",\n                             -report_type => \"blastn\");\n    $aln = $in->next_aln();\n\n\n=head1 DESCRIPTION\n\nThis object can create L<Bio::SimpleAlign> sequence alignment objects (of\ntwo sequences) from C<bl2seq> BLAST reports.\n\nA nice feature of this module is that - in combination with\nL<Bio::Tools::Run::StandAloneBlast.pm> or a remote BLAST - it can be used to\nalign two sequences and make a L<Bio::SimpleAlign> object from them which\ncan then be manipulated using any L<Bio::SimpleAlign> methods, eg:\n\n   # Get two sequences\n   $str = Bio::SeqIO->new(-file=>'t/amino.fa' , '-format' => 'Fasta', );\n   my $seq3 = $str->next_seq();\n   my $seq4 = $str->next_seq();\n\n   # Run bl2seq on them\n   $factory = Bio::Tools::StandAloneBlast->new('program' => 'blastp',\n                                               'outfile' => 'bl2seq.out');\n   my $bl2seq_report = $factory->bl2seq($seq3, $seq4);\n   # Note that report is a Bio::SearchIO object\n\n   # Use AlignIO.pm to create a SimpleAlign object from the bl2seq report\n   $str = Bio::AlignIO->new(-file=> 'bl2seq.out','-format' => 'bl2seq');\n   $aln = $str->next_aln();\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Peter Schattner\n\nEmail: schattner@alum.mit.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::bl2seq;\nuse strict;\n\nuse Bio::SearchIO;\n\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::SimpleAlign->new(-format => 'bl2seq',\n                                               -file   => 'filename',\n                                               -report_type => 'blastx');\n Function: Get a L<Bio::SimpleAlign>\n Returns : L<Bio::SimpleAlign> object\n Args    : -report_type => report type (blastn,blastx,tblastx,tblastn,blastp)\n\n\nsub _initialize {\n    my ($self, @args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($rt) = $self->_rearrange([qw(REPORT_TYPE)],@args);\n    defined $rt && $self->report_type($rt);\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n Returns : L<Bio::Align::AlignI> object on success,\n           undef on error or end of file\n Args    : none\n\n\nsub next_aln {\n    my $self = shift;\n    unless (exists $self->{'_searchio'}) {\n        $self->{'_searchio'} = Bio::SearchIO->new(-fh => $self->_fh,\n                   -format => 'blast',\n                   -report_type => $self->report_type);\n    }\n    while (1) {\n        if (!exists $self->{'_result'}) {\n            $self->{'_result'} = $self->{'_searchio'}->next_result;\n        }\n        return if !defined $self->{'_result'};\n        if (!exists $self->{'_hit'}) {\n            $self->{'_hit'} = $self->{'_result'}->next_hit;\n        }\n        # out of hits for this result?\n        if (!defined $self->{'_hit'}) {\n            delete $self->{'_result'};\n            next;\n        }\n        my $hsp = $self->{'_hit'}->next_hsp;\n        # out of hsps for this hit?\n        if (!defined $hsp) {\n            delete $self->{'_hit'};\n            next;\n        }\n        $hsp ? return $hsp->get_aln: return;\n    }\n}\n\n\n=head2 write_aln (NOT IMPLEMENTED)\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in bl2seq format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"write_aln($self,@aln)"},"range":{"start":{"line":184,"character":0},"end":{"line":187,"character":9999}},"kind":12,"line":184},{"kind":12,"range":{"end":{"line":204,"character":9999},"start":{"line":200,"character":0}},"line":200,"definition":"sub","name":"report_type","containerName":"main::","children":[{"definition":"my","line":201,"name":"$self","localvar":"my","containerName":"report_type","kind":13},{"line":202,"name":"$self","containerName":"report_type","kind":13},{"line":203,"name":"$self","containerName":"report_type","kind":13}]}],"version":5}