{"vars":[{"containerName":"","kind":2,"name":"vars","line":80},{"name":"$MEGANAMELEN","containerName":null,"kind":13,"line":89},{"line":89,"kind":2,"containerName":"strict::Bio::SimpleAlign::Bio","name":"LocatableSeq"},{"line":90,"kind":13,"containerName":null,"name":"$LINELEN"},{"line":91,"kind":13,"containerName":null,"name":"$BLOCKLEN"},{"line":92,"name":"%VALID_TYPES","kind":13,"containerName":null},{"name":"base","containerName":"","kind":2,"line":94},{"signature":{"label":"next_aln($self)","documentation":"1;\n# $Id: mega.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::mega\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::mega - Parse and Create MEGA format data files\n\n=head1 SYNOPSIS\n\n    use Bio::AlignIO;\n    my $alignio = Bio::AlignIO->new(-format => 'mega',\n                                   -file   => 't/data/hemoglobinA.meg');\n\n    while( my $aln = $alignio->next_aln ) {\n    # process each alignment or convert to another format like NEXUS\n    }\n\n=head1 DESCRIPTION\n\nThis object handles reading and writing data streams in the MEGA\nformat (Kumar and Nei).\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::mega;\nuse vars qw($MEGANAMELEN %VALID_TYPES $LINELEN $BLOCKLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\n\n# symbols are changed due to MEGA's use of '.' for redundant sequences\n\nBEGIN {\n  $MEGANAMELEN = 10;\n  $LINELEN = 60;\n  $BLOCKLEN = 10;\n  %VALID_TYPES =  map {$_, 1} qw( dna rna protein standard);\n}\nuse base qw(Bio::AlignIO);\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Supports the following MEGA format features:\n           - The file has to start with '#mega'\n           - Reads in the name of the alignment from a comment\n             (anything after '!TITLE: ') .\n           - Reads in the format parameters datatype\n\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE","parameters":[{"label":"$self"}]},"line":115,"range":{"start":{"line":115,"character":0},"end":{"line":176,"character":9999}},"kind":12,"definition":"sub","detail":"($self)","children":[{"localvar":"my","containerName":"next_aln","kind":13,"name":"$self","line":116,"definition":"my"},{"line":117,"name":"$entry","containerName":"next_aln","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":118,"name":"$alphabet","containerName":"next_aln","localvar":"my","kind":13},{"name":"%seqs","kind":13,"containerName":"next_aln","line":118},{"line":119,"name":"$Bio","kind":13,"containerName":"next_aln"},{"line":120,"name":"$Bio","kind":13,"containerName":"next_aln"},{"line":121,"name":"$aln","localvar":"my","kind":13,"containerName":"next_aln","definition":"my"},{"containerName":"next_aln","kind":12,"name":"new","line":121},{"line":123,"name":"$entry","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$self","line":123},{"name":"_readline","containerName":"next_aln","kind":12,"line":123},{"line":123,"name":"$entry","containerName":"next_aln","kind":13},{"name":"$self","containerName":"next_aln","kind":13,"line":125},{"line":125,"containerName":"next_aln","kind":12,"name":"throw"},{"line":126,"kind":13,"containerName":"next_aln","name":"$entry"},{"line":128,"kind":13,"containerName":"next_aln","name":"$entry"},{"line":128,"name":"$self","containerName":"next_aln","kind":13},{"name":"_readline","containerName":"next_aln","kind":12,"line":128},{"line":129,"name":"$entry","kind":13,"containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"$aln","line":130},{"line":130,"kind":12,"containerName":"next_aln","name":"id"},{"name":"@fields","kind":13,"localvar":"my","containerName":"next_aln","line":132,"definition":"my"},{"line":133,"containerName":"next_aln","localvar":"my","kind":13,"name":"$f","definition":"my"},{"line":133,"kind":13,"containerName":"next_aln","name":"@fields"},{"line":134,"name":"$name","kind":13,"localvar":"my","containerName":"next_aln","definition":"my"},{"name":"$value","containerName":"next_aln","kind":13,"line":134},{"name":"$f","kind":13,"containerName":"next_aln","line":134},{"kind":13,"containerName":"next_aln","name":"$name","line":135},{"containerName":"next_aln","kind":13,"name":"$alphabet","line":136},{"name":"$value","kind":13,"containerName":"next_aln","line":136},{"line":137,"kind":13,"containerName":"next_aln","name":"$name"},{"line":138,"containerName":"next_aln","kind":13,"name":"$aln"},{"line":138,"name":"match_char","kind":12,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"$value","line":138},{"line":139,"containerName":"next_aln","kind":13,"name":"$name"},{"kind":13,"containerName":"next_aln","name":"$aln","line":140},{"line":140,"name":"gap_char","kind":12,"containerName":"next_aln"},{"line":140,"name":"$value","kind":13,"containerName":"next_aln"},{"line":147,"localvar":"my","containerName":"next_aln","kind":13,"name":"@order","definition":"my"},{"line":148,"containerName":"next_aln","kind":13,"name":"$entry"},{"line":149,"name":"$entry","containerName":"next_aln","kind":13},{"line":151,"name":"$seqname","containerName":"next_aln","localvar":"my","kind":13,"definition":"my"},{"name":"$entry","containerName":"next_aln","kind":13,"line":151},{"kind":13,"containerName":"next_aln","name":"$MEGANAMELEN","line":151},{"line":152,"containerName":"next_aln","kind":13,"name":"$seqname"},{"line":153,"localvar":"my","containerName":"next_aln","kind":13,"name":"$line","definition":"my"},{"line":153,"containerName":"next_aln","kind":13,"name":"$entry"},{"name":"$MEGANAMELEN","kind":13,"containerName":"next_aln","line":153},{"containerName":"next_aln","kind":13,"name":"$line","line":154},{"line":155,"containerName":"next_aln","kind":13,"name":"$seqs"},{"line":155,"name":"$seqname","kind":13,"containerName":"next_aln"},{"kind":13,"containerName":"next_aln","name":"@order","line":155},{"name":"$seqname","kind":13,"containerName":"next_aln","line":155},{"name":"$seqs","containerName":"next_aln","kind":13,"line":156},{"kind":13,"containerName":"next_aln","name":"$seqname","line":156},{"line":156,"containerName":"next_aln","kind":13,"name":"$line"},{"line":158,"name":"$entry","kind":13,"containerName":"next_aln"},{"name":"$self","kind":13,"containerName":"next_aln","line":158},{"name":"_readline","kind":12,"containerName":"next_aln","line":158},{"definition":"my","line":161,"containerName":"next_aln","localvar":"my","kind":13,"name":"$seqname"},{"kind":13,"containerName":"next_aln","name":"@order","line":161},{"line":162,"name":"$s","localvar":"my","kind":13,"containerName":"next_aln","definition":"my"},{"line":162,"kind":13,"containerName":"next_aln","name":"$seqs"},{"line":162,"containerName":"next_aln","kind":13,"name":"$seqname"},{"kind":13,"containerName":"next_aln","name":"$s","line":163},{"definition":"my","line":164,"name":"$end","localvar":"my","kind":13,"containerName":"next_aln"},{"line":164,"containerName":"next_aln","kind":13,"name":"$s"},{"localvar":"my","containerName":"next_aln","kind":13,"name":"$seq","line":165,"definition":"my"},{"line":165,"name":"new","kind":12,"containerName":"next_aln"},{"line":165,"name":"$alphabet","containerName":"next_aln","kind":13},{"containerName":"next_aln","kind":13,"name":"$seqname","line":166},{"line":167,"name":"$seqs","kind":13,"containerName":"next_aln"},{"containerName":"next_aln","kind":13,"name":"$seqname","line":167},{"line":169,"kind":13,"containerName":"next_aln","name":"$end"},{"line":171,"kind":13,"containerName":"next_aln","name":"$aln"},{"kind":12,"containerName":"next_aln","name":"add_seq","line":171},{"name":"$seq","containerName":"next_aln","kind":13,"line":171},{"name":"$aln","kind":13,"containerName":"next_aln","line":173},{"name":"unmatch","kind":12,"containerName":"next_aln","line":173},{"name":"$aln","kind":13,"containerName":"next_aln","line":174},{"kind":13,"containerName":"next_aln","name":"$aln","line":174},{"line":174,"containerName":"next_aln","kind":12,"name":"num_sequences"}],"name":"next_aln","containerName":"main::"},{"line":119,"name":"LocatableSeq","containerName":"OTHER_SYMBOLS","kind":12},{"name":"LocatableSeq","kind":12,"containerName":"GAP_SYMBOLS","line":120},{"line":121,"name":"Bio","kind":12,"containerName":"SimpleAlign"},{"kind":12,"containerName":"LocatableSeq","name":"Bio","line":165},{"children":[{"containerName":"write_aln","localvar":"my","kind":13,"name":"$self","line":189,"definition":"my"},{"kind":13,"containerName":"write_aln","name":"@aln","line":189},{"definition":"my","kind":13,"localvar":"my","containerName":"write_aln","name":"$count","line":190},{"definition":"my","line":191,"localvar":"my","kind":13,"containerName":"write_aln","name":"$wrapped"},{"line":192,"localvar":"my","containerName":"write_aln","kind":13,"name":"$maxname","definition":"my"},{"definition":"my","localvar":"my","containerName":"write_aln","kind":13,"name":"$aln","line":194},{"kind":13,"containerName":"write_aln","name":"@aln","line":194},{"name":"$aln","containerName":"write_aln","kind":13,"line":195},{"name":"$aln","kind":13,"containerName":"write_aln","line":195},{"line":195,"containerName":"write_aln","kind":12,"name":"isa"},{"line":196,"containerName":"write_aln","kind":13,"name":"$self"},{"line":196,"containerName":"write_aln","kind":12,"name":"warn"},{"containerName":"write_aln","kind":13,"name":"$aln","line":198},{"kind":12,"containerName":"write_aln","name":"is_flush","line":198},{"line":198,"containerName":"write_aln","kind":13,"name":"$self"},{"line":198,"containerName":"write_aln","kind":12,"name":"verbose"},{"line":199,"name":"$self","kind":13,"containerName":"write_aln"},{"name":"warn","kind":12,"containerName":"write_aln","line":199},{"line":202,"name":"$aln","kind":13,"containerName":"write_aln"},{"name":"match","containerName":"write_aln","kind":12,"line":202},{"line":203,"name":"$len","localvar":"my","kind":13,"containerName":"write_aln","definition":"my"},{"kind":13,"containerName":"write_aln","name":"$aln","line":203},{"kind":12,"containerName":"write_aln","name":"length","line":203},{"definition":"my","name":"$format","kind":13,"localvar":"my","containerName":"write_aln","line":204},{"line":205,"containerName":"write_aln","kind":13,"name":"$aln"},{"containerName":"write_aln","kind":12,"name":"get_seq_by_pos","line":205},{"line":205,"containerName":"write_aln","kind":12,"name":"alphabet"},{"name":"$aln","kind":13,"containerName":"write_aln","line":206},{"line":206,"containerName":"write_aln","kind":12,"name":"match_char"},{"line":206,"name":"$aln","kind":13,"containerName":"write_aln"},{"line":206,"name":"gap_char","kind":12,"containerName":"write_aln"},{"line":208,"name":"$self","kind":13,"containerName":"write_aln"},{"containerName":"write_aln","kind":12,"name":"_print","line":208},{"line":209,"name":"$aln","containerName":"write_aln","kind":13},{"line":209,"containerName":"write_aln","kind":12,"name":"id"},{"containerName":"write_aln","kind":13,"name":"$format","line":209},{"line":211,"localvar":"my","containerName":"write_aln","kind":13,"name":"$count","definition":"my"},{"kind":13,"containerName":"write_aln","name":"$blockcount","line":211},{"line":211,"kind":13,"containerName":"write_aln","name":"$length"},{"kind":13,"containerName":"write_aln","name":"$aln","line":211},{"line":211,"name":"length","containerName":"write_aln","kind":12},{"name":"$aln","containerName":"write_aln","kind":13,"line":212},{"line":212,"containerName":"write_aln","kind":12,"name":"set_displayname_flat"},{"line":213,"name":"$count","containerName":"write_aln","kind":13},{"line":213,"name":"$length","containerName":"write_aln","kind":13},{"definition":"my","line":214,"name":"$seq","containerName":"write_aln","localvar":"my","kind":13},{"name":"$aln","containerName":"write_aln","kind":13,"line":214},{"kind":12,"containerName":"write_aln","name":"each_seq","line":214},{"definition":"my","name":"$seqchars","localvar":"my","containerName":"write_aln","kind":13,"line":215},{"line":215,"containerName":"write_aln","kind":13,"name":"$seq"},{"name":"seq","kind":12,"containerName":"write_aln","line":215},{"kind":13,"containerName":"write_aln","name":"$blockcount","line":216},{"definition":"my","line":217,"name":"$substring","containerName":"write_aln","localvar":"my","kind":13},{"line":217,"name":"$seqchars","containerName":"write_aln","kind":13},{"line":217,"name":"$count","kind":13,"containerName":"write_aln"},{"line":217,"containerName":"write_aln","kind":13,"name":"$LINELEN"},{"definition":"my","kind":13,"localvar":"my","containerName":"write_aln","name":"@blocks","line":218},{"line":219,"kind":13,"containerName":"write_aln","name":"$blockcount"},{"line":219,"containerName":"write_aln","kind":13,"name":"$substring"},{"line":220,"name":"@blocks","containerName":"write_aln","kind":13},{"line":220,"name":"$substring","containerName":"write_aln","kind":13},{"line":220,"containerName":"write_aln","kind":13,"name":"$blockcount"},{"line":220,"containerName":"write_aln","kind":13,"name":"$BLOCKLEN"},{"line":221,"kind":13,"containerName":"write_aln","name":"$blockcount"},{"line":221,"containerName":"write_aln","kind":13,"name":"$BLOCKLEN"},{"line":223,"kind":13,"containerName":"write_aln","name":"$self"},{"line":223,"containerName":"write_aln","kind":12,"name":"_print"},{"line":223,"containerName":"write_aln","kind":13,"name":"$MEGANAMELEN"},{"containerName":"write_aln","kind":13,"name":"$aln","line":224},{"name":"displayname","containerName":"write_aln","kind":12,"line":224},{"line":224,"name":"$seq","kind":13,"containerName":"write_aln"},{"containerName":"write_aln","kind":12,"name":"get_nse","line":224},{"containerName":"write_aln","kind":13,"name":"$MEGANAMELEN","line":225},{"kind":13,"containerName":"write_aln","name":"@blocks","line":226},{"line":228,"kind":13,"containerName":"write_aln","name":"$self"},{"kind":12,"containerName":"write_aln","name":"_print","line":228},{"name":"$count","containerName":"write_aln","kind":13,"line":229},{"kind":13,"containerName":"write_aln","name":"$LINELEN","line":229},{"name":"$self","containerName":"write_aln","kind":13,"line":232},{"line":232,"name":"flush","kind":12,"containerName":"write_aln"},{"line":232,"kind":13,"containerName":"write_aln","name":"$self"},{"line":232,"name":"_flush_on_write","kind":12,"containerName":"write_aln"},{"line":232,"kind":13,"containerName":"write_aln","name":"$self"},{"name":"_fh","containerName":"write_aln","kind":12,"line":232}],"name":"write_aln","containerName":"main::","definition":"sub","detail":"($self,@aln)","line":188,"range":{"end":{"line":234,"character":9999},"start":{"character":0,"line":188}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@aln"}],"documentation":"1;\n# $Id: mega.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::mega\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::mega - Parse and Create MEGA format data files\n\n=head1 SYNOPSIS\n\n    use Bio::AlignIO;\n    my $alignio = Bio::AlignIO->new(-format => 'mega',\n                                   -file   => 't/data/hemoglobinA.meg');\n\n    while( my $aln = $alignio->next_aln ) {\n    # process each alignment or convert to another format like NEXUS\n    }\n\n=head1 DESCRIPTION\n\nThis object handles reading and writing data streams in the MEGA\nformat (Kumar and Nei).\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::mega;\nuse vars qw($MEGANAMELEN %VALID_TYPES $LINELEN $BLOCKLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\n\n# symbols are changed due to MEGA's use of '.' for redundant sequences\n\nBEGIN {\n  $MEGANAMELEN = 10;\n  $LINELEN = 60;\n  $BLOCKLEN = 10;\n  %VALID_TYPES =  map {$_, 1} qw( dna rna protein standard);\n}\nuse base qw(Bio::AlignIO);\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Supports the following MEGA format features:\n           - The file has to start with '#mega'\n           - Reads in the name of the alignment from a comment\n             (anything after '!TITLE: ') .\n           - Reads in the format parameters datatype\n\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE\n\n\n\nsub next_aln{\n   my ($self) = @_;\n   my $entry;\n   my ($alphabet,%seqs);\n   local $Bio::LocatableSeq::OTHER_SYMBOLS = '\\*\\?\\.';\n   local $Bio::LocatableSeq::GAP_SYMBOLS = '\\-';\n   my $aln = Bio::SimpleAlign->new(-source => 'mega');\n\n   while( defined($entry = $self->_readline()) && ($entry =~ /^\\s+$/) ) {}\n\n   $self->throw(\"Not a valid MEGA file! [#mega] not starting the file!\")\n       unless $entry =~ /^#mega/i;\n\n   while( defined($entry = $self->_readline() ) ) {\n       local($_) = $entry;\n       if(/\\!Title:\\s*([^\\;]+)\\s*/i) { $aln->id($1)}\n       elsif( s/\\!Format\\s+([^\\;]+)\\s*/$1/ ) {\n\t   my (@fields) = split(/\\s+/,$1);\n\t   foreach my $f ( @fields ) {\n\t       my ($name,$value) = split(/\\=/,$f);\n\t       if( $name eq 'datatype' ) {\n\t\t   $alphabet = $value;\n\t       } elsif( $name eq 'identical' ) {\n\t\t   $aln->match_char($value);\n\t       } elsif( $name eq 'indel' ) {\n\t\t   $aln->gap_char($value);\n\t       }\n\t   }\n       } elsif( /^\\#/ ) {\n\t   last;\n       }\n   }\n   my @order;\n   while( defined($entry) ) {\n       if( $entry !~ /^\\s+$/ ) {\n\t   # this is to skip the leading '#'\n\t   my $seqname = substr($entry,1,$MEGANAMELEN-1);\n\t   $seqname =~ s/(\\S+)\\s+$/$1/g;\n\t   my $line = substr($entry,$MEGANAMELEN);\n\t   $line =~ s/\\s+//g;\n\t   if( ! defined $seqs{$seqname} ) {push @order, $seqname; }\n\t   $seqs{$seqname} .= $line;\n       }\n       $entry = $self->_readline();\n   }\n\n   foreach my $seqname ( @order ) {\n       my $s = $seqs{$seqname};\n       $s =~ s/[$Bio::LocatableSeq::GAP_SYMBOLS]+//g;\n       my $end = length($s);\n       my $seq = Bio::LocatableSeq->new(-alphabet => $alphabet,\n\t\t\t\t       -id => $seqname,\n\t\t\t\t       -seq => $seqs{$seqname},\n\t\t\t\t       -start => 1,\n\t\t\t\t       -end   => $end);\n\n       $aln->add_seq($seq);\n   }\n   $aln->unmatch;\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MEGA format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","label":"write_aln($self,@aln)"}}],"version":5}