{"vars":[{"containerName":"","kind":2,"name":"base","line":83},{"definition":"my","line":86,"containerName":null,"localvar":"my","kind":13,"name":"$MEME_VERS_ERR"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$MEME_NO_HEADER_ERR","line":88},{"name":"$HTML_VERS_ERR","containerName":null,"localvar":"my","kind":13,"line":90,"definition":"my"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: meme.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n#  BioPerl module for Bio::AlignIO::meme\n#   Based on the Bio::SeqIO modules\n#  by Ewan Birney <birney@ebi.ac.uk>\n#  and Lincoln Stein  <lstein@cshl.org>\n#  and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Benjamin Berman\n#\n# You may distribute this module under the same terms as perl itself\n\n=head1 NAME\n\nBio::AlignIO::meme - meme sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n  use Bio::AlignIO;\n  # read in an alignment from meme\n  my $in = Bio::AlignIO->new(-format => 'meme',\n                             -file   => 'meme.out');\n  while( my $aln = $in->next_aln ) {\n     # do something with the alignment\n  }\n\n=head1 DESCRIPTION\n\nThis object transforms the \"sites sorted by position p-value\" sections\nof a meme (text) output file into a series of Bio::SimpleAlign\nobjects.  Each SimpleAlign object contains Bio::LocatableSeq\nobjects which represent the individual aligned sites as defined by\nthe central portion of the \"site\" field in the meme file.  The start\nand end coordinates are derived from the \"Start\" field. See\nL<Bio::SimpleAlign> and L<Bio::LocatableSeq> for more information.\n\nThis module can only parse MEME version 3.0 and greater.  Previous\nversions have output formats that are more difficult to parse\ncorrectly.  If the meme output file is not version 3.0 or greater,\nwe signal an error.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Benjamin Berman\n\n Bbased on the Bio::SeqIO modules by Ewan Birney and others\n Email: benb@fruitfly.berkeley.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with an\nunderscore.\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::meme;\nuse strict;\nuse Bio::LocatableSeq;\n\nuse base qw(Bio::AlignIO);\n\n# Constants\nmy $MEME_VERS_ERR =\n\"MEME output file must be generated by version 3.0 or higher\";\nmy $MEME_NO_HEADER_ERR =\n\"MEME output file contains no header line (ex: MEME version 3.0)\";\nmy $HTML_VERS_ERR =\n\"MEME output file must be generated with the -text option\";\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::SimpleAlign object with the score() set to the evalue of the\n           motif.\n Args    : NONE","label":"next_aln($self)"},"kind":12,"range":{"start":{"line":104,"character":0},"end":{"character":9999,"line":184}},"line":104,"detail":"($self)","definition":"sub","name":"next_aln","containerName":"main::","children":[{"definition":"my","line":105,"name":"$self","containerName":"next_aln","localvar":"my","kind":13},{"name":"$aln","kind":13,"localvar":"my","containerName":"next_aln","line":106,"definition":"my"},{"kind":12,"containerName":"next_aln","name":"new","line":106},{"line":107,"name":"$line","localvar":"my","containerName":"next_aln","kind":13,"definition":"my"},{"definition":"my","line":108,"localvar":"my","kind":13,"containerName":"next_aln","name":"$good_align_sec"},{"definition":"my","line":109,"containerName":"next_aln","localvar":"my","kind":13,"name":"$in_align_sec"},{"definition":"my","line":110,"name":"$evalue","localvar":"my","kind":13,"containerName":"next_aln"},{"line":111,"name":"$good_align_sec","containerName":"next_aln","kind":13},{"name":"$line","containerName":"next_aln","kind":13,"line":111},{"name":"$self","containerName":"next_aln","kind":13,"line":111},{"kind":12,"containerName":"next_aln","name":"_readline","line":111},{"line":112,"name":"$in_align_sec","containerName":"next_aln","kind":13},{"kind":13,"containerName":"next_aln","name":"$line","line":114},{"kind":13,"containerName":"next_aln","name":"$self","line":115},{"localvar":"my","kind":13,"containerName":"next_aln","name":"$vers","line":116,"definition":"my"},{"containerName":"next_aln","kind":13,"name":"$self","line":116},{"line":117,"kind":13,"containerName":"next_aln","name":"$self"},{"kind":12,"containerName":"next_aln","name":"throw","line":117},{"containerName":"next_aln","kind":13,"name":"$MEME_VERS_ERR","line":117},{"kind":13,"containerName":"next_aln","name":"$vers","line":117},{"name":"$self","kind":13,"containerName":"next_aln","line":118},{"name":"$line","containerName":"next_aln","kind":13,"line":121},{"line":122,"containerName":"next_aln","kind":13,"name":"$self"},{"containerName":"next_aln","kind":12,"name":"throw","line":122},{"line":122,"kind":13,"containerName":"next_aln","name":"$HTML_VERS_ERR"},{"line":125,"name":"$line","kind":13,"containerName":"next_aln"},{"name":"$self","containerName":"next_aln","kind":13,"line":126},{"name":"throw","containerName":"next_aln","kind":12,"line":126},{"kind":13,"containerName":"next_aln","name":"$MEME_NO_HEADER_ERR","line":126},{"line":126,"name":"$self","containerName":"next_aln","kind":13},{"line":127,"name":"$evalue","kind":13,"containerName":"next_aln"},{"line":130,"kind":13,"containerName":"next_aln","name":"$line"},{"kind":13,"containerName":"next_aln","name":"$self","line":131},{"containerName":"next_aln","kind":12,"name":"throw","line":131},{"line":131,"containerName":"next_aln","kind":13,"name":"$MEME_NO_HEADER_ERR"},{"line":131,"kind":13,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","kind":13,"name":"$in_align_sec","line":132},{"line":134,"name":"$line","containerName":"next_aln","kind":13},{"definition":"my","line":138,"localvar":"my","containerName":"next_aln","kind":13,"name":"$seq_name"},{"definition":"my","name":"$strand","kind":13,"localvar":"my","containerName":"next_aln","line":139},{"definition":"my","localvar":"my","kind":13,"containerName":"next_aln","name":"$start_pos","line":140},{"definition":"my","line":141,"name":"$central","localvar":"my","containerName":"next_aln","kind":13},{"definition":"my","localvar":"my","containerName":"next_aln","kind":13,"name":"$end_pos","line":155},{"containerName":"next_aln","kind":13,"name":"$start_pos","line":155},{"kind":13,"containerName":"next_aln","name":"$central","line":155},{"definition":"my","localvar":"my","containerName":"next_aln","kind":13,"name":"$seq","line":156},{"containerName":"next_aln","kind":12,"name":"new","line":156},{"name":"$central","containerName":"next_aln","kind":13,"line":156},{"name":"$seq_name","containerName":"next_aln","kind":13,"line":157},{"name":"$start_pos","kind":13,"containerName":"next_aln","line":158},{"line":159,"name":"$end_pos","containerName":"next_aln","kind":13},{"line":161,"kind":13,"containerName":"next_aln","name":"$strand"},{"line":163,"kind":13,"containerName":"next_aln","name":"$aln"},{"line":163,"kind":12,"containerName":"next_aln","name":"add_seq"},{"kind":13,"containerName":"next_aln","name":"$seq","line":163},{"name":"$line","containerName":"next_aln","kind":13,"line":164},{"line":164,"name":"$line","containerName":"next_aln","kind":13},{"line":166,"name":"$line","kind":13,"containerName":"next_aln"},{"name":"$in_align_sec","containerName":"next_aln","kind":13,"line":168},{"containerName":"next_aln","kind":13,"name":"$good_align_sec","line":169},{"kind":13,"containerName":"next_aln","name":"$self","line":171},{"line":171,"name":"warn","kind":12,"containerName":"next_aln"},{"line":176,"name":"$self","containerName":"next_aln","kind":13},{"name":"throw","containerName":"next_aln","kind":12,"line":176},{"name":"$MEME_NO_HEADER_ERR","containerName":"next_aln","kind":13,"line":176},{"containerName":"next_aln","kind":13,"name":"$self","line":176},{"line":178,"name":"$good_align_sec","kind":13,"containerName":"next_aln"},{"name":"$aln","containerName":"next_aln","kind":13,"line":179},{"kind":12,"containerName":"next_aln","name":"score","line":179},{"kind":13,"containerName":"next_aln","name":"$evalue","line":179},{"line":180,"name":"$aln","kind":13,"containerName":"next_aln"}]},{"name":"Bio","kind":12,"containerName":"SimpleAlign","line":106},{"line":156,"containerName":"LocatableSeq","kind":12,"name":"Bio"},{"detail":"($self,@aln)","definition":"sub","name":"write_aln","containerName":"main::","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"write_aln","line":197},{"line":197,"containerName":"write_aln","kind":13,"name":"@aln"},{"line":198,"containerName":"write_aln","kind":13,"name":"$self"},{"name":"throw_not_implemented","kind":12,"containerName":"write_aln","line":198}],"signature":{"parameters":[{"label":"$self"},{"label":"@aln"}],"documentation":"1;\n# $Id: meme.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n#  BioPerl module for Bio::AlignIO::meme\n#   Based on the Bio::SeqIO modules\n#  by Ewan Birney <birney@ebi.ac.uk>\n#  and Lincoln Stein  <lstein@cshl.org>\n#  and the SimpleAlign.pm module of Ewan Birney\n#\n# Copyright Benjamin Berman\n#\n# You may distribute this module under the same terms as perl itself\n\n=head1 NAME\n\nBio::AlignIO::meme - meme sequence input/output stream\n\n=head1 SYNOPSIS\n\nDo not use this module directly.  Use it via the Bio::AlignIO class.\n\n  use Bio::AlignIO;\n  # read in an alignment from meme\n  my $in = Bio::AlignIO->new(-format => 'meme',\n                             -file   => 'meme.out');\n  while( my $aln = $in->next_aln ) {\n     # do something with the alignment\n  }\n\n=head1 DESCRIPTION\n\nThis object transforms the \"sites sorted by position p-value\" sections\nof a meme (text) output file into a series of Bio::SimpleAlign\nobjects.  Each SimpleAlign object contains Bio::LocatableSeq\nobjects which represent the individual aligned sites as defined by\nthe central portion of the \"site\" field in the meme file.  The start\nand end coordinates are derived from the \"Start\" field. See\nL<Bio::SimpleAlign> and L<Bio::LocatableSeq> for more information.\n\nThis module can only parse MEME version 3.0 and greater.  Previous\nversions have output formats that are more difficult to parse\ncorrectly.  If the meme output file is not version 3.0 or greater,\nwe signal an error.\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Benjamin Berman\n\n Bbased on the Bio::SeqIO modules by Ewan Birney and others\n Email: benb@fruitfly.berkeley.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with an\nunderscore.\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::meme;\nuse strict;\nuse Bio::LocatableSeq;\n\nuse base qw(Bio::AlignIO);\n\n# Constants\nmy $MEME_VERS_ERR =\n\"MEME output file must be generated by version 3.0 or higher\";\nmy $MEME_NO_HEADER_ERR =\n\"MEME output file contains no header line (ex: MEME version 3.0)\";\nmy $HTML_VERS_ERR =\n\"MEME output file must be generated with the -text option\";\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream\n Returns : Bio::SimpleAlign object with the score() set to the evalue of the\n           motif.\n Args    : NONE\n\n\nsub next_aln {\n\tmy ($self) = @_;\n\tmy $aln = Bio::SimpleAlign->new(-source => 'meme');\n\tmy $line;\n\tmy $good_align_sec = 0;\n\tmy $in_align_sec = 0;\n\tmy $evalue;\n\twhile (!$good_align_sec && defined($line = $self->_readline())) {\n\t\tif (!$in_align_sec) {\n\t\t\t# Check for the meme header\n\t\t\tif ($line =~ /^\\s*MEME\\s+version\\s+(\\S+)/ ){\n\t\t\t\t$self->{'meme_vers'} = $1;\n                my ($vers) = $self->{'meme_vers'} =~ /^(\\d)/;\n\t\t\t\t$self->throw($MEME_VERS_ERR) unless ($vers >= 3);\n\t\t\t\t$self->{'seen_header'} = 1;\n\t      }\n\t\t\t# Check if they've output the HTML version\n\t\t\tif ($line =~ /\\<TITLE\\>/i){\n\t\t\t\t$self->throw($HTML_VERS_ERR);\n\t      }\n\t\t\t# Grab the evalue\n\t\t\tif ($line =~ /MOTIF\\s+\\d+\\s+width.+E-value = (\\S+)/) {\n\t\t\t\t$self->throw($MEME_NO_HEADER_ERR) unless ($self->{'seen_header'});\n\t\t\t\t$evalue = $1;\n\t\t\t}\n\t\t\t# Check if we're going into an alignment section\n\t\t\tif ($line =~ /sites sorted by position/) {\n\t\t\t\t$self->throw($MEME_NO_HEADER_ERR) unless ($self->{'seen_header'});\n\t\t\t\t$in_align_sec = 1;\n\t\t\t}\n\t\t} elsif ($line =~ /^(\\S+)\\s+([+-]?)\\s+(\\d+)\\s+\n                       (\\S+)\\s+([.ACTGNX\\-]*)\\s+([ACTGNX\\-]+)\\s+\n                       ([.ACTGNX\\-]*)/xi ) {\n\t\t\t# Got a sequence line\n\t\t\tmy $seq_name = $1;\n\t\t\tmy $strand = ($2 eq '-') ? -1 : 1;\n\t\t\tmy $start_pos = $3;\n\t\t\tmy $central = uc($6);\n\n\t\t\t# my $p_val = $4;\n\t\t\t# my $left_flank = uc($5);\n\t\t\t# my $right_flank = uc($7);\n\n\t\t\t# Info about the flanking sequence\n\t\t\t# my $start_len = ($strand > 0) ? length($left_flank) :\n\t\t\t# length($right_flank);\n\t\t\t# my $end_len = ($strand > 0) ? length($right_flank) :\n\t\t\t# length($left_flank);\n\n\t\t\t# Make the sequence.  Meme gives the start coordinate at the left\n\t\t\t# hand side of the motif relative to the INPUT sequence.\n\t\t\tmy $end_pos = $start_pos + length($central) - 1;\n\t\t\tmy $seq = Bio::LocatableSeq->new(-seq    => $central,\n\t\t\t\t\t\t\t\t\t\t\t\t\t  -id     => $seq_name,\n\t\t\t\t\t\t\t\t\t\t\t\t\t  -start  => $start_pos,\n\t\t\t\t\t\t\t\t\t\t\t\t\t  -end    => $end_pos,\n\t\t\t\t\t\t\t\t\t\t\t\t\t  -strand => $strand\n\t\t\t\t\t\t\t\t\t\t\t\t\t );\n\t\t\t# Add the sequence motif to the alignment\n\t\t\t$aln->add_seq($seq);\n\t\t} elsif (($line =~ /^\\-/) || ($line =~ /Sequence name/)){\n\t\t\t# These are acceptable things to be in the site section\n\t\t} elsif ($line =~ /^\\s*$/){\n\t\t\t# This ends the site section\n\t\t\t$in_align_sec = 0;\n\t\t\t$good_align_sec = 1;\n\t\t} else{\n\t\t\t$self->warn(\"Unrecognized format:\\n$line\");\n\t\t\treturn 0;\n\t\t}\n\t}\n\t# Signal an error if we didn't find a header section\n\t$self->throw($MEME_NO_HEADER_ERR) unless ($self->{'seen_header'});\n\t\n\tif ($good_align_sec) {\n\t\t$aln->score($evalue);\n\t\treturn $aln;\n\t}\n\t\n\treturn;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: Not implemented\n Returns : 1 for success and 0 for error\n Args    : Bio::SimpleAlign object","label":"write_aln($self,@aln)"},"kind":12,"range":{"end":{"character":9999,"line":199},"start":{"character":0,"line":196}},"line":196},{"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":" -   Private methods"},"kind":12,"range":{"start":{"character":0,"line":205},"end":{"line":213,"character":9999}},"line":205,"detail":"($self,@args)","definition":"sub","name":"_initialize","containerName":"main::","children":[{"definition":"my","containerName":"_initialize","localvar":"my","kind":13,"name":"$self","line":206},{"line":206,"containerName":"_initialize","kind":13,"name":"@args"},{"line":209,"name":"$self","containerName":"_initialize","kind":13},{"line":209,"containerName":"_initialize","kind":13,"name":"@args"},{"line":212,"name":"$self","containerName":"_initialize","kind":13}]},{"line":209,"kind":12,"containerName":"_initialize","name":"SUPER"}],"version":5}