{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":103},{"name":"new","containerName":"main::","children":[{"definition":"my","name":"$class","localvar":"my","containerName":"new","kind":13,"line":119},{"containerName":"new","kind":13,"name":"@args","line":119},{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"new","line":121},{"line":121,"kind":13,"containerName":"new","name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":121},{"localvar":"my","kind":13,"containerName":"new","name":"$type","line":123,"definition":"my"},{"name":"$self","kind":13,"containerName":"new","line":123},{"line":123,"name":"_rearrange","kind":12,"containerName":"new"},{"line":123,"name":"@args","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":125},{"name":"$self","kind":13,"containerName":"new","line":126},{"line":126,"containerName":"new","kind":12,"name":"type"},{"kind":13,"containerName":"new","name":"$type","line":126},{"line":126,"name":"$type","kind":13,"containerName":"new"},{"line":128,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,@args)","definition":"sub","range":{"start":{"character":0,"line":118},"end":{"character":9999,"line":129}},"kind":12,"line":118,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: AnnotationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::AnnotationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::AnnotationFactory - Instantiates a new \nBio::AnnotationI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Annotation::AnnotationFactory;\n    # \n    my $factory = Bio::Annotation::AnnotationFactory->new(\n                    -type => 'Bio::Annotation::SimpleValue');\n    my $ann = $factory->create_object(-value => 'peroxisome',\n                                      -tagname => 'cellular component');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::AnnotationI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 CONTRIBUTORS\n\nThis is mostly copy-and-paste with subsequent adaptation from\nBio::Seq::SeqFactory by Jason Stajich. Most credits should in fact go\nto him.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::AnnotationFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Annotation::AnnotationFactory->new();\n Function: Builds a new Bio::Annotation::AnnotationFactory object \n Returns : Bio::Annotation::AnnotationFactory\n Args    : -type => string, name of a L<Bio::AnnotationI> derived class.\n\nIf type is not set the module guesses it based on arguments passed to\nmethod L<create_object>.","label":"new($class,@args)"}},{"line":121,"name":"SUPER","containerName":"new","kind":12},{"kind":12,"range":{"start":{"line":148,"character":0},"end":{"line":171,"character":9999}},"line":148,"signature":{"label":"create_object($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: AnnotationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::AnnotationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::AnnotationFactory - Instantiates a new \nBio::AnnotationI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Annotation::AnnotationFactory;\n    # \n    my $factory = Bio::Annotation::AnnotationFactory->new(\n                    -type => 'Bio::Annotation::SimpleValue');\n    my $ann = $factory->create_object(-value => 'peroxisome',\n                                      -tagname => 'cellular component');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::AnnotationI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 CONTRIBUTORS\n\nThis is mostly copy-and-paste with subsequent adaptation from\nBio::Seq::SeqFactory by Jason Stajich. Most credits should in fact go\nto him.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::AnnotationFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Annotation::AnnotationFactory->new();\n Function: Builds a new Bio::Annotation::AnnotationFactory object \n Returns : Bio::Annotation::AnnotationFactory\n Args    : -type => string, name of a L<Bio::AnnotationI> derived class.\n\nIf type is not set the module guesses it based on arguments passed to\nmethod L<create_object>.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n  \n    my ($type) = $self->_rearrange([qw(TYPE)], @args);\n\n    $self->{'_loaded_types'} = {};\n    $self->type($type) if $type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates new Bio::AnnotationI (or one of its child classes)\n\n           This object allows us to genericize the instantiation of\n           cluster objects.\n\n Returns : L<Bio::AnnotationI> compliant object\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of annotation\n           object we want."},"name":"create_object","containerName":"main::","children":[{"definition":"my","line":149,"localvar":"my","kind":13,"containerName":"create_object","name":"$self"},{"kind":13,"containerName":"create_object","name":"@args","line":149},{"localvar":"my","containerName":"create_object","kind":13,"name":"$type","line":151,"definition":"my"},{"containerName":"create_object","kind":13,"name":"$self","line":151},{"kind":12,"containerName":"create_object","name":"type","line":151},{"line":152,"name":"$type","containerName":"create_object","kind":13},{"line":154,"kind":13,"containerName":"create_object","name":"$type"},{"kind":13,"containerName":"create_object","name":"$self","line":154},{"line":154,"containerName":"create_object","kind":12,"name":"_guess_type"},{"line":154,"containerName":"create_object","kind":13,"name":"@args"},{"name":"$type","containerName":"create_object","kind":13,"line":155},{"kind":13,"containerName":"create_object","name":"$self","line":156},{"name":"throw","containerName":"create_object","kind":12,"line":156},{"line":159,"containerName":"create_object","kind":13,"name":"$self"},{"name":"$type","containerName":"create_object","kind":13,"line":159},{"line":161,"containerName":"create_object","kind":13,"name":"$self"},{"containerName":"create_object","kind":12,"name":"_load_module","line":161},{"line":161,"containerName":"create_object","kind":13,"name":"$type"},{"line":162,"containerName":"create_object","kind":13,"name":"$self"},{"line":162,"name":"$type","containerName":"create_object","kind":13},{"line":165,"name":"$self","containerName":"create_object","kind":13},{"name":"throw","kind":12,"containerName":"create_object","line":165},{"line":170,"name":"$type","containerName":"create_object","kind":13},{"line":170,"containerName":"create_object","kind":12,"name":"new"},{"containerName":"create_object","kind":13,"name":"$self","line":170},{"name":"verbose","kind":12,"containerName":"create_object","line":170},{"line":170,"name":"@args","containerName":"create_object","kind":13}],"detail":"($self,@args)","definition":"sub"},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"type","line":189,"definition":"my"},{"definition":"my","line":192,"containerName":"type","localvar":"my","kind":13,"name":"$type"},{"line":193,"kind":13,"containerName":"type","name":"$type"},{"kind":13,"containerName":"type","name":"$self","line":193},{"kind":13,"containerName":"type","name":"$type","line":193},{"containerName":"type","kind":13,"name":"$self","line":195},{"name":"_load_module","containerName":"type","kind":12,"line":195},{"line":195,"kind":13,"containerName":"type","name":"$type"},{"name":"$self","kind":13,"containerName":"type","line":198},{"line":198,"name":"throw","containerName":"type","kind":12},{"definition":"my","line":201,"localvar":"my","kind":13,"containerName":"type","name":"$a"},{"line":201,"name":"$type","containerName":"type","kind":13},{"line":202,"name":"$a","containerName":"type","kind":13},{"kind":12,"containerName":"type","name":"isa","line":202},{"line":203,"kind":13,"containerName":"type","name":"$self"},{"line":203,"name":"throw","containerName":"type","kind":12},{"name":"$self","containerName":"type","kind":13,"line":206},{"name":"$type","kind":13,"containerName":"type","line":206},{"name":"$self","containerName":"type","kind":13,"line":208},{"line":208,"containerName":"type","kind":13,"name":"$type"},{"line":210,"name":"$self","containerName":"type","kind":13}],"containerName":"main::","name":"type","definition":"sub","line":188,"kind":12,"range":{"start":{"line":188,"character":0},"end":{"line":211,"character":9999}}},{"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_guess_type","line":229},{"line":229,"kind":13,"containerName":"_guess_type","name":"@args"},{"definition":"my","localvar":"my","containerName":"_guess_type","kind":13,"name":"$type","line":230},{"name":"$val","containerName":"_guess_type","localvar":"my","kind":13,"line":233,"definition":"my"},{"name":"$db","containerName":"_guess_type","kind":13,"line":233},{"kind":13,"containerName":"_guess_type","name":"$text","line":233},{"line":233,"kind":13,"containerName":"_guess_type","name":"$name"},{"containerName":"_guess_type","kind":13,"name":"$authors","line":233},{"line":233,"containerName":"_guess_type","kind":13,"name":"$start"},{"name":"$tree","containerName":"_guess_type","kind":13,"line":233},{"kind":13,"containerName":"_guess_type","name":"$node","line":233},{"line":234,"containerName":"_guess_type","kind":13,"name":"$self"},{"name":"_rearrange","containerName":"_guess_type","kind":12,"line":234},{"line":242,"containerName":"_guess_type","kind":13,"name":"@args"},{"line":244,"containerName":"_guess_type","kind":13,"name":"$val"},{"name":"$type","containerName":"_guess_type","kind":13,"line":244},{"line":244,"name":"$val","containerName":"_guess_type","kind":13},{"containerName":"_guess_type","kind":13,"name":"$authors","line":245},{"name":"$type","containerName":"_guess_type","kind":13,"line":245},{"line":246,"name":"$db","containerName":"_guess_type","kind":13},{"kind":13,"containerName":"_guess_type","name":"$type","line":246},{"line":247,"name":"$text","containerName":"_guess_type","kind":13},{"line":247,"kind":13,"containerName":"_guess_type","name":"$type"},{"line":248,"kind":13,"containerName":"_guess_type","name":"$name"},{"line":248,"kind":13,"containerName":"_guess_type","name":"$type"},{"line":249,"name":"$start","containerName":"_guess_type","kind":13},{"containerName":"_guess_type","kind":13,"name":"$type","line":249},{"containerName":"_guess_type","kind":13,"name":"$tree","line":250},{"kind":13,"containerName":"_guess_type","name":"$type","line":250},{"line":251,"name":"$node","containerName":"_guess_type","kind":13},{"line":251,"name":"$type","kind":13,"containerName":"_guess_type"},{"kind":13,"containerName":"_guess_type","name":"$type","line":254},{"name":"$type","kind":13,"containerName":"_guess_type","line":254},{"containerName":"_guess_type","kind":13,"name":"$type","line":256}],"name":"_guess_type","containerName":"main::","definition":"sub","detail":"($self,@args)","line":228,"kind":12,"range":{"start":{"character":0,"line":228},"end":{"character":9999,"line":257}},"signature":{"label":"_guess_type($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: AnnotationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::AnnotationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::AnnotationFactory - Instantiates a new \nBio::AnnotationI (or derived class) through a factory\n\n=head1 SYNOPSIS\n\n    use Bio::Annotation::AnnotationFactory;\n    # \n    my $factory = Bio::Annotation::AnnotationFactory->new(\n                    -type => 'Bio::Annotation::SimpleValue');\n    my $ann = $factory->create_object(-value => 'peroxisome',\n                                      -tagname => 'cellular component');\n\n\n=head1 DESCRIPTION\n\nThis object will build L<Bio::AnnotationI> objects generically.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n\n=head1 CONTRIBUTORS\n\nThis is mostly copy-and-paste with subsequent adaptation from\nBio::Seq::SeqFactory by Jason Stajich. Most credits should in fact go\nto him.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::AnnotationFactory;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::ObjectFactoryI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Annotation::AnnotationFactory->new();\n Function: Builds a new Bio::Annotation::AnnotationFactory object \n Returns : Bio::Annotation::AnnotationFactory\n Args    : -type => string, name of a L<Bio::AnnotationI> derived class.\n\nIf type is not set the module guesses it based on arguments passed to\nmethod L<create_object>.\n\n\nsub new {\n    my($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n  \n    my ($type) = $self->_rearrange([qw(TYPE)], @args);\n\n    $self->{'_loaded_types'} = {};\n    $self->type($type) if $type;\n\n    return $self;\n}\n\n\n=head2 create_object\n\n Title   : create_object\n Usage   : my $seq = $factory->create_object(<named parameters>);\n Function: Instantiates new Bio::AnnotationI (or one of its child classes)\n\n           This object allows us to genericize the instantiation of\n           cluster objects.\n\n Returns : L<Bio::AnnotationI> compliant object\n           The return type is configurable using new(-type =>\"...\").\n Args    : initialization parameters specific to the type of annotation\n           object we want.\n\n\nsub create_object {\n   my ($self,@args) = @_;\n\n   my $type = $self->type; \n   if(! $type) {\n       # we need to guess this\n       $type = $self->_guess_type(@args);\n       if(! $type) {\n       $self->throw(\"No annotation type set and unable to guess.\");\n       }\n       # load dynamically if it hasn't been loaded yet\n       if(! $self->{'_loaded_types'}->{$type}) {\n       eval {\n           $self->_load_module($type);\n           $self->{'_loaded_types'}->{$type} = 1;\n       };\n       if($@) {\n           $self->throw(\"Bio::AnnotationI implementation $type \".\n                \"failed to load: \".$@);\n       }\n       }\n   }\n   return $type->new(-verbose => $self->verbose, @args);\n}\n\n=head2 type\n\n Title   : type\n Usage   : $obj->type($newval)\n Function: Get/set the type of L<Bio::AnnotationI> object to be created.\n\n           This may be changed at any time during the lifetime of this\n           factory.\n\n Returns : value of type\n Args    : newvalue (optional)\n\n\n\nsub type{\n    my $self = shift;\n\n    if(@_) {\n    my $type = shift;\n    if($type && (! $self->{'_loaded_types'}->{$type})) {\n        eval {\n        $self->_load_module($type);\n        };\n        if( $@ ) {\n        $self->throw(\"Annotation class '$type' failed to load: \".\n                 $@);\n        }\n        my $a = bless {},$type;\n        if( ! $a->isa('Bio::AnnotationI') ) {\n        $self->throw(\"'$type' does not implement Bio::AnnotationI. \".\n                 \"Too bad.\");\n        }\n        $self->{'_loaded_types'}->{$type} = 1;\n    }\n    return $self->{'type'} = $type;\n    }\n    return $self->{'type'};\n}\n\n=head2 _guess_type\n\n Title   : _guess_type\n Usage   :\n Function: Guesses the right type of L<Bio::AnnotationI> implementation\n           based on initialization parameters for the prospective\n           object.\n Example :\n Returns : the type (a string, the module name)\n Args    : initialization parameters to be passed to the prospective\n           cluster object"}},{"kind":12,"name":"SWITCH","line":243},{"line":244,"kind":12,"name":"SWITCH"},{"kind":12,"name":"SWITCH","line":245},{"name":"SWITCH","kind":12,"line":246},{"line":247,"kind":12,"name":"SWITCH"},{"line":248,"kind":12,"name":"SWITCH"},{"kind":12,"name":"SWITCH","line":249},{"kind":12,"name":"SWITCH","line":250},{"line":251,"name":"SWITCH","kind":12}]}