{"vars":[{"line":82,"name":"base","containerName":"","kind":2},{"range":{"end":{"character":9999,"line":110},"start":{"character":0,"line":96}},"kind":12,"line":96,"signature":{"documentation":"1;\n# $Id: SimpleValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::SimpleValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::SimpleValue - A simple scalar\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::SimpleValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::SimpleValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::SimpleValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n#use Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::SimpleValue->new();\n Function: Instantiate a new SimpleValue object\n Returns : Bio::Annotation::SimpleValue object\n Args    : -value    => $value to initialize the object data field [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"line":97,"name":"$class","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":97},{"line":99,"name":"$self","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":99,"name":"$class","kind":13,"containerName":"new"},{"line":99,"name":"@args","containerName":"new","kind":13},{"line":101,"containerName":"new","localvar":"my","kind":13,"name":"$value","definition":"my"},{"line":101,"kind":13,"containerName":"new","name":"$tag"},{"kind":13,"containerName":"new","name":"$term","line":101},{"line":102,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"_rearrange","line":102},{"kind":13,"containerName":"new","name":"@args","line":102},{"line":105,"kind":13,"containerName":"new","name":"$term"},{"kind":13,"containerName":"new","name":"$self","line":105},{"containerName":"new","kind":12,"name":"tag_term","line":105},{"name":"$term","containerName":"new","kind":13,"line":105},{"containerName":"new","kind":13,"name":"$value","line":106},{"line":106,"kind":13,"containerName":"new","name":"$self"},{"name":"value","kind":12,"containerName":"new","line":106},{"name":"$value","containerName":"new","kind":13,"line":106},{"kind":13,"containerName":"new","name":"$tag","line":107},{"containerName":"new","kind":13,"name":"$self","line":107},{"line":107,"name":"tagname","containerName":"new","kind":12},{"line":107,"kind":13,"containerName":"new","name":"$tag"},{"line":109,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,@args)","definition":"sub"},{"line":99,"name":"SUPER","containerName":"new","kind":12},{"children":[{"definition":"my","line":129,"name":"$self","containerName":"as_text","localvar":"my","kind":13},{"line":131,"name":"$self","kind":13,"containerName":"as_text"},{"line":131,"containerName":"as_text","kind":12,"name":"value"}],"name":"as_text","containerName":"main::","definition":"sub","detail":"($self)","line":128,"kind":12,"range":{"end":{"line":132,"character":9999},"start":{"character":0,"line":128}},"signature":{"label":"as_text($self)","documentation":"1;\n# $Id: SimpleValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::SimpleValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::SimpleValue - A simple scalar\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::SimpleValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::SimpleValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::SimpleValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n#use Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::SimpleValue->new();\n Function: Instantiate a new SimpleValue object\n Returns : Bio::Annotation::SimpleValue object\n Args    : -value    => $value to initialize the object data field [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($value,$tag,$term) =\n       $self->_rearrange([qw(VALUE TAGNAME TAG_TERM)], @args);\n\n   # set the term first\n   defined $term   && $self->tag_term($term);\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none","parameters":[{"label":"$self"}]}},{"line":151,"localvar":"my","kind":13,"containerName":null,"name":"%DEFAULT_CB","definition":"my"},{"name":"value","kind":12,"containerName":"main::","line":151},{"containerName":"main::","name":"display_text","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"display_text","kind":13,"line":154},{"line":154,"containerName":"display_text","kind":13,"name":"$cb"},{"name":"$cb","containerName":"display_text","kind":13,"line":155},{"line":155,"name":"$DEFAULT_CB","kind":13,"containerName":"display_text"},{"kind":13,"containerName":"display_text","name":"$self","line":156},{"name":"throw","kind":12,"containerName":"display_text","line":156},{"kind":13,"containerName":"display_text","name":"$cb","line":156},{"line":157,"containerName":"display_text","kind":13,"name":"$cb"},{"name":"$self","kind":13,"containerName":"display_text","line":157}],"detail":"($self,$cb)","definition":"sub","range":{"start":{"line":153,"character":0},"end":{"character":9999,"line":158}},"kind":12,"line":153,"signature":{"label":"display_text($self,$cb)","documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}]}},{"name":"hash_tree","containerName":"main::","children":[{"line":175,"containerName":"hash_tree","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","line":177,"localvar":"my","containerName":"hash_tree","kind":13,"name":"$h"},{"containerName":"hash_tree","kind":13,"name":"$h","line":178},{"line":178,"kind":13,"containerName":"hash_tree","name":"$self"},{"containerName":"hash_tree","kind":12,"name":"value","line":178},{"name":"$h","kind":13,"containerName":"hash_tree","line":179}],"definition":"sub","kind":12,"range":{"end":{"line":180,"character":9999},"start":{"character":0,"line":174}},"line":174},{"definition":"sub","children":[{"localvar":"my","containerName":"tagname","kind":13,"name":"$self","line":200,"definition":"my"},{"line":203,"containerName":"tagname","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"tagname","line":205},{"line":207,"kind":13,"containerName":"tagname","name":"$self"},{"kind":12,"containerName":"tagname","name":"tag_term","line":207},{"name":"name","kind":12,"containerName":"tagname","line":207},{"line":209,"name":"$self","containerName":"tagname","kind":13},{"line":210,"containerName":"tagname","kind":13,"name":"$self"}],"containerName":"main::","name":"tagname","line":199,"range":{"start":{"line":199,"character":0},"end":{"character":9999,"line":211}},"kind":12},{"line":229,"range":{"end":{"line":236,"character":9999},"start":{"line":229,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: SimpleValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::SimpleValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::SimpleValue - A simple scalar\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::SimpleValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::SimpleValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::SimpleValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n#use Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::SimpleValue->new();\n Function: Instantiate a new SimpleValue object\n Returns : Bio::Annotation::SimpleValue object\n Args    : -value    => $value to initialize the object data field [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($value,$tag,$term) =\n       $self->_rearrange([qw(VALUE TAGNAME TAG_TERM)], @args);\n\n   # set the term first\n   defined $term   && $self->tag_term($term);\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Value: \".$self->value;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->value};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n\n    my $h = {};\n    $h->{'value'} = $self->value;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to AnnotationCollection when adding this\n           object.\n\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    # check for presence of an ontology term\n    if($self->{'_tag_term'}) {\n\t# keep a copy in case the term is removed later\n\t$self->{'tagname'} = $_[0] if @_;\n\t# delegate to the ontology term object\n\treturn $self->tag_term->name(@_);\n    }\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Specific accessors for SimpleValue\n\n\n=head2 value\n\n Title   : value\n Usage   : $obj->value($newval)\n Function: Get/Set the value for simplevalue\n Returns : value of value\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"value($self,$value)"},"children":[{"definition":"my","line":230,"name":"$self","containerName":"value","localvar":"my","kind":13},{"kind":13,"containerName":"value","name":"$value","line":230},{"line":232,"kind":13,"containerName":"value","name":"$value"},{"kind":13,"containerName":"value","name":"$self","line":233},{"name":"$value","kind":13,"containerName":"value","line":233},{"kind":13,"containerName":"value","name":"$self","line":235}],"name":"value","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"definition":"sub","name":"tag_term","containerName":"main::","children":[{"definition":"my","line":266,"containerName":"tag_term","localvar":"my","kind":13,"name":"$self"},{"name":"$self","containerName":"tag_term","kind":13,"line":268},{"line":269,"kind":13,"containerName":"tag_term","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":265},"end":{"character":9999,"line":270}},"line":265}],"version":5}