{"version":5,"vars":[{"containerName":"","kind":2,"name":"base","line":81},{"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","line":101,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"line":101,"containerName":"new","kind":13,"name":"@args"},{"localvar":"my","containerName":"new","kind":13,"name":"$self","line":102,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":102},{"line":102,"containerName":"new","kind":13,"name":"@args"},{"containerName":"new","localvar":"my","kind":13,"name":"$id","line":103,"definition":"my"},{"name":"$src","kind":13,"containerName":"new","line":103},{"line":103,"kind":13,"containerName":"new","name":"$contigs"},{"line":103,"name":"$singlets","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":103},{"line":103,"kind":12,"containerName":"new","name":"_rearrange"},{"line":104,"kind":13,"containerName":"new","name":"@args"},{"line":107,"name":"$self","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":108},{"containerName":"new","kind":13,"name":"$self","line":109},{"line":110,"kind":13,"containerName":"new","name":"$self"},{"line":111,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":13,"name":"$self","line":112},{"name":"new","kind":12,"containerName":"new","line":112},{"line":115,"kind":13,"containerName":"new","name":"$self"},{"line":115,"name":"$id","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$id","line":115},{"containerName":"new","kind":13,"name":"$self","line":116},{"line":116,"kind":13,"containerName":"new","name":"$src"},{"name":"$src","kind":13,"containerName":"new","line":116},{"line":119,"containerName":"new","kind":13,"name":"$contigs"},{"name":"$contigs","containerName":"new","kind":13,"line":119},{"line":120,"name":"$contig","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":120,"name":"$contigs","kind":13,"containerName":"new"},{"line":121,"containerName":"new","kind":13,"name":"$contig"},{"containerName":"new","kind":13,"name":"$contig","line":121},{"kind":12,"containerName":"new","name":"isa","line":121},{"line":122,"name":"$self","kind":13,"containerName":"new"},{"line":122,"kind":12,"containerName":"new","name":"throw"},{"kind":13,"containerName":"new","name":"$contig","line":123},{"line":125,"name":"$self","containerName":"new","kind":13},{"kind":12,"containerName":"new","name":"add_contig","line":125},{"line":125,"containerName":"new","kind":13,"name":"$contig"}],"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects","label":"new($class,@args)"},"kind":12,"range":{"end":{"line":127,"character":9999},"start":{"character":0,"line":100}},"line":100},{"kind":12,"containerName":"new","name":"SUPER","line":102},{"line":112,"kind":12,"containerName":"Annotation::Collection","name":"Bio"},{"line":128,"name":"$singlets","containerName":null,"kind":13},{"line":128,"name":"%singlets","containerName":null,"kind":13},{"line":129,"name":"$singlet","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"containerName":null,"kind":13,"name":"%singlets","line":129},{"line":130,"name":"$singlet","containerName":null,"kind":13},{"line":130,"containerName":null,"kind":13,"name":"$singlet"},{"line":130,"name":"isa","kind":12,"containerName":"main::"},{"name":"$self","kind":13,"containerName":null,"line":131},{"kind":12,"containerName":"main::","name":"throw","line":131},{"line":132,"containerName":null,"kind":13,"name":"$singlet"},{"line":134,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","kind":12,"name":"add_singlet","line":134},{"line":134,"name":"$singlet","kind":13,"containerName":null},{"line":138,"name":"$self","kind":13,"containerName":null},{"name":"id","containerName":"main::","children":[{"definition":"my","line":156,"localvar":"my","containerName":"id","kind":13,"name":"$self"},{"line":156,"name":"$id","containerName":"id","kind":13},{"line":157,"name":"$self","containerName":"id","kind":13},{"kind":13,"containerName":"id","name":"$id","line":157},{"line":157,"kind":13,"containerName":"id","name":"$id"},{"line":158,"containerName":"id","kind":13,"name":"$self"}],"detail":"($self,$id)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":159},"start":{"line":155,"character":0}},"line":155,"signature":{"label":"id($self,$id)","parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string"}},{"range":{"start":{"character":0,"line":171},"end":{"character":9999,"line":175}},"kind":12,"line":171,"containerName":"main::","name":"annotation","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"annotation","name":"$self","line":172},{"containerName":"annotation","kind":13,"name":"$ref","line":172},{"line":173,"containerName":"annotation","kind":13,"name":"$self"},{"name":"$ref","kind":13,"containerName":"annotation","line":173},{"line":173,"kind":13,"containerName":"annotation","name":"$ref"},{"containerName":"annotation","kind":13,"name":"$self","line":174}],"definition":"sub"},{"kind":12,"range":{"start":{"character":0,"line":187},"end":{"character":9999,"line":190}},"line":187,"definition":"sub","containerName":"main::","name":"get_nof_contigs","children":[{"line":188,"name":"$self","kind":13,"localvar":"my","containerName":"get_nof_contigs","definition":"my"},{"line":189,"kind":13,"containerName":"get_nof_contigs","name":"$self"},{"kind":12,"containerName":"get_nof_contigs","name":"get_contig_ids","line":189}]},{"definition":"sub","containerName":"main::","name":"get_nof_contig_seqs","children":[{"definition":"my","line":204,"name":"$self","localvar":"my","kind":13,"containerName":"get_nof_contig_seqs"},{"definition":"my","line":206,"name":"$nof_seqs","kind":13,"localvar":"my","containerName":"get_nof_contig_seqs"},{"definition":"my","line":207,"name":"$contig","localvar":"my","containerName":"get_nof_contig_seqs","kind":13},{"name":"$self","containerName":"get_nof_contig_seqs","kind":13,"line":207},{"name":"all_contigs","kind":12,"containerName":"get_nof_contig_seqs","line":207},{"line":208,"name":"$nof_seqs","containerName":"get_nof_contig_seqs","kind":13},{"name":"$contig","containerName":"get_nof_contig_seqs","kind":13,"line":208},{"line":208,"containerName":"get_nof_contig_seqs","kind":12,"name":"get_seq_ids"},{"line":211,"name":"$nof_seqs","containerName":"get_nof_contig_seqs","kind":13}],"range":{"start":{"character":0,"line":203},"end":{"line":212,"character":9999}},"kind":12,"line":203},{"name":"get_nof_singlets","containerName":"main::","children":[{"containerName":"get_nof_singlets","localvar":"my","kind":13,"name":"$self","line":228,"definition":"my"},{"name":"$self","containerName":"get_nof_singlets","kind":13,"line":229},{"kind":12,"containerName":"get_nof_singlets","name":"get_singlet_ids","line":229}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":230},"start":{"character":0,"line":227}},"line":227},{"definition":"sub","children":[{"definition":"my","line":245,"localvar":"my","kind":13,"containerName":"get_all_seq_ids","name":"$self"},{"line":246,"name":"$self","kind":13,"containerName":"get_all_seq_ids"}],"name":"get_all_seq_ids","containerName":"main::","line":244,"kind":12,"range":{"start":{"line":244,"character":0},"end":{"line":246,"character":9999}}},{"containerName":"main::","name":"get_nof_seqs","children":[{"definition":"my","line":261,"localvar":"my","containerName":"get_nof_seqs","kind":13,"name":"$self"},{"line":262,"name":"$self","containerName":"get_nof_seqs","kind":13},{"containerName":"get_nof_seqs","kind":12,"name":"get_all_seq_ids","line":262}],"definition":"sub","range":{"start":{"line":260,"character":0},"end":{"line":263,"character":9999}},"kind":12,"line":260},{"line":275,"kind":12,"range":{"end":{"character":9999,"line":282},"start":{"character":0,"line":275}},"definition":"sub","children":[{"line":276,"localvar":"my","containerName":"get_contig_seq_ids","kind":13,"name":"$self","definition":"my"},{"definition":"my","localvar":"my","containerName":"get_contig_seq_ids","kind":13,"name":"@ids","line":277},{"definition":"my","line":278,"kind":13,"localvar":"my","containerName":"get_contig_seq_ids","name":"$contig"},{"name":"$self","kind":13,"containerName":"get_contig_seq_ids","line":278},{"containerName":"get_contig_seq_ids","kind":12,"name":"all_contigs","line":278},{"line":279,"kind":13,"containerName":"get_contig_seq_ids","name":"@ids"},{"name":"$contig","containerName":"get_contig_seq_ids","kind":13,"line":279},{"line":279,"name":"get_seq_ids","kind":12,"containerName":"get_contig_seq_ids"},{"kind":13,"containerName":"get_contig_seq_ids","name":"@ids","line":281}],"containerName":"main::","name":"get_contig_seq_ids"},{"definition":"sub","children":[{"name":"$self","containerName":"get_contig_ids","localvar":"my","kind":13,"line":298,"definition":"my"},{"line":301,"name":"$self","kind":13,"containerName":"get_contig_ids"}],"containerName":"main::","name":"get_contig_ids","line":297,"kind":12,"range":{"start":{"character":0,"line":297},"end":{"line":301,"character":9999}}},{"kind":13,"containerName":null,"name":"%self","line":302},{"line":316,"range":{"start":{"character":0,"line":316},"end":{"character":9999,"line":320}},"kind":12,"definition":"sub","children":[{"containerName":"get_singlet_ids","localvar":"my","kind":13,"name":"$self","line":317,"definition":"my"},{"line":320,"name":"$self","containerName":"get_singlet_ids","kind":13}],"containerName":"main::","name":"get_singlet_ids"},{"name":"%self","kind":13,"containerName":null,"line":321},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"get_seq_by_id","line":338},{"kind":13,"localvar":"my","containerName":"get_seq_by_id","name":"$seqID","line":339,"definition":"my"},{"line":341,"name":"$self","kind":13,"containerName":"get_seq_by_id"},{"containerName":"get_seq_by_id","kind":13,"name":"$seqID","line":341},{"name":"$self","kind":13,"containerName":"get_seq_by_id","line":343},{"containerName":"get_seq_by_id","kind":13,"name":"$seqID","line":343},{"containerName":"get_seq_by_id","kind":12,"name":"get_seq_by_name","line":343},{"kind":13,"containerName":"get_seq_by_id","name":"$seqID","line":343}],"name":"get_seq_by_id","containerName":"main::","line":337,"range":{"end":{"character":9999,"line":344},"start":{"character":0,"line":337}},"kind":12},{"children":[{"name":"$self","containerName":"get_contig_by_id","localvar":"my","kind":13,"line":357,"definition":"my"},{"definition":"my","name":"$contigID","kind":13,"localvar":"my","containerName":"get_contig_by_id","line":358},{"kind":13,"containerName":"get_contig_by_id","name":"$self","line":360},{"line":360,"kind":13,"containerName":"get_contig_by_id","name":"$contigID"},{"name":"$self","kind":13,"containerName":"get_contig_by_id","line":362},{"line":362,"name":"$contigID","kind":13,"containerName":"get_contig_by_id"}],"name":"get_contig_by_id","containerName":"main::","definition":"sub","line":356,"range":{"start":{"character":0,"line":356},"end":{"character":9999,"line":363}},"kind":12},{"line":375,"kind":12,"range":{"start":{"character":0,"line":375},"end":{"line":383,"character":9999}},"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"get_singlet_by_id","line":376},{"definition":"my","name":"$singletID","kind":13,"localvar":"my","containerName":"get_singlet_by_id","line":378},{"line":380,"name":"$self","containerName":"get_singlet_by_id","kind":13},{"line":380,"kind":13,"containerName":"get_singlet_by_id","name":"$singletID"},{"containerName":"get_singlet_by_id","kind":13,"name":"$self","line":382},{"containerName":"get_singlet_by_id","kind":13,"name":"$singletID","line":382}],"name":"get_singlet_by_id","containerName":"main::"},{"detail":"($self,$contig)","definition":"sub","containerName":"main::","name":"add_contig","children":[{"line":401,"localvar":"my","kind":13,"containerName":"add_contig","name":"$self","definition":"my"},{"line":401,"containerName":"add_contig","kind":13,"name":"$contig"},{"line":404,"containerName":"add_contig","kind":13,"name":"$contig"},{"name":"$contig","kind":13,"containerName":"add_contig","line":404},{"line":404,"name":"isa","containerName":"add_contig","kind":12},{"line":405,"name":"$self","containerName":"add_contig","kind":13},{"line":405,"containerName":"add_contig","kind":12,"name":"throw"},{"line":406,"containerName":"add_contig","kind":13,"name":"$contig"},{"line":410,"name":"$contigID","localvar":"my","kind":13,"containerName":"add_contig","definition":"my"},{"name":"$contig","containerName":"add_contig","kind":13,"line":410},{"line":410,"containerName":"add_contig","kind":12,"name":"id"},{"kind":13,"containerName":"add_contig","name":"$contigID","line":411},{"kind":13,"containerName":"add_contig","name":"$contigID","line":412},{"name":"$self","containerName":"add_contig","kind":13,"line":412},{"containerName":"add_contig","kind":12,"name":"get_nof_contigs","line":412},{"kind":13,"containerName":"add_contig","name":"$contig","line":413},{"line":413,"containerName":"add_contig","kind":12,"name":"id"},{"name":"$contigID","kind":13,"containerName":"add_contig","line":413},{"name":"$self","kind":13,"containerName":"add_contig","line":414},{"line":414,"name":"warn","kind":12,"containerName":"add_contig"},{"line":419,"name":"$self","kind":13,"containerName":"add_contig"},{"line":419,"kind":12,"containerName":"add_contig","name":"warn"},{"name":"$self","kind":13,"containerName":"add_contig","line":420},{"line":420,"name":"$contigID","kind":13,"containerName":"add_contig"},{"containerName":"add_contig","kind":13,"name":"$self","line":421},{"name":"$contigID","containerName":"add_contig","kind":13,"line":421},{"line":421,"name":"$contig","containerName":"add_contig","kind":13},{"line":422,"kind":13,"containerName":"add_contig","name":"$contig"},{"kind":12,"containerName":"add_contig","name":"assembly","line":422},{"kind":13,"containerName":"add_contig","name":"$self","line":422},{"localvar":"my","kind":13,"containerName":"add_contig","name":"$seqID","line":425,"definition":"my"},{"containerName":"add_contig","kind":13,"name":"$contig","line":425},{"line":425,"containerName":"add_contig","kind":12,"name":"get_seq_ids"},{"line":426,"name":"$self","kind":13,"containerName":"add_contig"},{"kind":13,"containerName":"add_contig","name":"$seqID","line":426},{"line":427,"name":"$self","containerName":"add_contig","kind":13},{"line":427,"kind":13,"containerName":"add_contig","name":"$seqID"},{"line":427,"name":"$contig","containerName":"add_contig","kind":13},{"line":428,"name":"$self","containerName":"add_contig","kind":13},{"line":428,"kind":12,"containerName":"add_contig","name":"warn"},{"name":"$self","kind":13,"containerName":"add_contig","line":429},{"line":429,"containerName":"add_contig","kind":13,"name":"$seqID"},{"name":"id","kind":12,"containerName":"add_contig","line":429},{"name":"$self","containerName":"add_contig","kind":13,"line":431},{"line":431,"name":"$seqID","kind":13,"containerName":"add_contig"},{"line":431,"kind":13,"containerName":"add_contig","name":"$contig"}],"signature":{"parameters":[{"label":"$self"},{"label":"$contig"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)","label":"add_contig($self,$contig)"},"kind":12,"range":{"end":{"character":9999,"line":435},"start":{"character":0,"line":400}},"line":400},{"line":448,"kind":12,"range":{"end":{"line":481,"character":9999},"start":{"line":448,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"$singlet"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)","label":"add_singlet($self,$singlet)"},"children":[{"definition":"my","name":"$self","containerName":"add_singlet","localvar":"my","kind":13,"line":449},{"line":449,"name":"$singlet","containerName":"add_singlet","kind":13},{"line":452,"containerName":"add_singlet","kind":13,"name":"$singlet"},{"line":452,"kind":13,"containerName":"add_singlet","name":"$singlet"},{"line":452,"name":"isa","kind":12,"containerName":"add_singlet"},{"name":"$self","containerName":"add_singlet","kind":13,"line":453},{"containerName":"add_singlet","kind":12,"name":"throw","line":453},{"line":454,"name":"$singlet","containerName":"add_singlet","kind":13},{"definition":"my","name":"$singletID","localvar":"my","kind":13,"containerName":"add_singlet","line":458},{"name":"$singlet","containerName":"add_singlet","kind":13,"line":458},{"line":458,"name":"id","containerName":"add_singlet","kind":12},{"line":459,"kind":13,"containerName":"add_singlet","name":"$singletID"},{"name":"$singletID","containerName":"add_singlet","kind":13,"line":460},{"line":460,"containerName":"add_singlet","kind":13,"name":"$self"},{"line":460,"name":"get_nof_singlets","containerName":"add_singlet","kind":12},{"line":461,"name":"$singlet","containerName":"add_singlet","kind":13},{"line":461,"name":"id","kind":12,"containerName":"add_singlet"},{"line":461,"containerName":"add_singlet","kind":13,"name":"$singletID"},{"line":462,"name":"$self","containerName":"add_singlet","kind":13},{"name":"warn","containerName":"add_singlet","kind":12,"line":462},{"name":"$self","kind":13,"containerName":"add_singlet","line":467},{"name":"warn","kind":12,"containerName":"add_singlet","line":467},{"name":"$self","containerName":"add_singlet","kind":13,"line":468},{"containerName":"add_singlet","kind":13,"name":"$singletID","line":468},{"kind":13,"containerName":"add_singlet","name":"$self","line":469},{"kind":13,"containerName":"add_singlet","name":"$singletID","line":469},{"containerName":"add_singlet","kind":13,"name":"$singlet","line":469},{"containerName":"add_singlet","kind":13,"name":"$singlet","line":470},{"line":470,"containerName":"add_singlet","kind":12,"name":"assembly"},{"name":"$self","containerName":"add_singlet","kind":13,"line":470},{"line":473,"name":"$seqID","containerName":"add_singlet","localvar":"my","kind":13,"definition":"my"},{"line":473,"kind":13,"containerName":"add_singlet","name":"$singlet"},{"name":"id","kind":12,"containerName":"add_singlet","line":473},{"line":474,"name":"$self","containerName":"add_singlet","kind":13},{"name":"$seqID","kind":13,"containerName":"add_singlet","line":474},{"line":475,"name":"$self","containerName":"add_singlet","kind":13},{"name":"$seqID","containerName":"add_singlet","kind":13,"line":475},{"name":"$singlet","containerName":"add_singlet","kind":13,"line":475},{"name":"$self","containerName":"add_singlet","kind":13,"line":476},{"containerName":"add_singlet","kind":12,"name":"warn","line":476},{"line":477,"kind":13,"containerName":"add_singlet","name":"$self"},{"line":477,"containerName":"add_singlet","kind":13,"name":"$seqID"},{"line":477,"kind":12,"containerName":"add_singlet","name":"id"},{"line":479,"name":"$self","containerName":"add_singlet","kind":13},{"containerName":"add_singlet","kind":13,"name":"$seqID","line":479},{"line":479,"name":"$singlet","containerName":"add_singlet","kind":13}],"name":"add_singlet","containerName":"main::","definition":"sub","detail":"($self,$singlet)"},{"kind":12,"range":{"end":{"line":530,"character":9999},"start":{"line":499,"character":0}},"line":499,"definition":"sub","containerName":"main::","name":"update_seq_list","children":[{"definition":"my","line":500,"localvar":"my","kind":13,"containerName":"update_seq_list","name":"$self"},{"kind":13,"containerName":"update_seq_list","name":"$self","line":502},{"name":"$contig","localvar":"my","kind":13,"containerName":"update_seq_list","line":505,"definition":"my"},{"line":505,"name":"$self","kind":13,"containerName":"update_seq_list"},{"line":505,"name":"all_contigs","containerName":"update_seq_list","kind":12},{"line":506,"containerName":"update_seq_list","localvar":"my","kind":13,"name":"$contigID","definition":"my"},{"name":"$contig","containerName":"update_seq_list","kind":13,"line":506},{"containerName":"update_seq_list","kind":12,"name":"id","line":506},{"line":507,"containerName":"update_seq_list","localvar":"my","kind":13,"name":"$seqID","definition":"my"},{"kind":13,"containerName":"update_seq_list","name":"$contig","line":507},{"containerName":"update_seq_list","kind":12,"name":"get_seq_ids","line":507},{"containerName":"update_seq_list","kind":13,"name":"$self","line":508},{"name":"$seqID","containerName":"update_seq_list","kind":13,"line":508},{"line":509,"kind":13,"containerName":"update_seq_list","name":"$self"},{"line":509,"kind":13,"containerName":"update_seq_list","name":"$seqID"},{"containerName":"update_seq_list","kind":13,"name":"$contig","line":509},{"line":510,"containerName":"update_seq_list","kind":13,"name":"$self"},{"line":510,"name":"warn","containerName":"update_seq_list","kind":12},{"name":"$self","kind":13,"containerName":"update_seq_list","line":511},{"containerName":"update_seq_list","kind":13,"name":"$seqID","line":511},{"line":511,"containerName":"update_seq_list","kind":12,"name":"id"},{"containerName":"update_seq_list","kind":13,"name":"$self","line":513},{"line":513,"kind":13,"containerName":"update_seq_list","name":"$seqID"},{"line":513,"containerName":"update_seq_list","kind":13,"name":"$contig"},{"localvar":"my","containerName":"update_seq_list","kind":13,"name":"$singlet","line":518,"definition":"my"},{"containerName":"update_seq_list","kind":13,"name":"$self","line":518},{"kind":12,"containerName":"update_seq_list","name":"all_singlets","line":518},{"definition":"my","line":519,"name":"$seqID","localvar":"my","containerName":"update_seq_list","kind":13},{"line":519,"containerName":"update_seq_list","kind":13,"name":"$singlet"},{"kind":12,"containerName":"update_seq_list","name":"id","line":519},{"definition":"my","localvar":"my","kind":13,"containerName":"update_seq_list","name":"$singletID","line":520},{"line":520,"name":"$singlet","containerName":"update_seq_list","kind":13},{"line":520,"kind":12,"containerName":"update_seq_list","name":"id"},{"name":"$self","kind":13,"containerName":"update_seq_list","line":521},{"line":521,"name":"$seqID","containerName":"update_seq_list","kind":13},{"line":522,"name":"$self","containerName":"update_seq_list","kind":13},{"name":"$seqID","containerName":"update_seq_list","kind":13,"line":522},{"line":522,"containerName":"update_seq_list","kind":13,"name":"$singlet"},{"containerName":"update_seq_list","kind":13,"name":"$self","line":523},{"line":523,"name":"warn","kind":12,"containerName":"update_seq_list"},{"line":524,"name":"$self","kind":13,"containerName":"update_seq_list"},{"kind":13,"containerName":"update_seq_list","name":"$seqID","line":524},{"line":524,"name":"id","containerName":"update_seq_list","kind":12},{"name":"$self","kind":13,"containerName":"update_seq_list","line":526},{"line":526,"name":"$seqID","containerName":"update_seq_list","kind":13},{"containerName":"update_seq_list","kind":13,"name":"$singlet","line":526}]},{"line":545,"range":{"start":{"line":545,"character":0},"end":{"line":558,"character":9999}},"kind":12,"signature":{"label":"remove_contigs($self,@args)","documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above","parameters":[{"label":"$self"},{"label":"@args"}]},"children":[{"definition":"my","line":546,"localvar":"my","kind":13,"containerName":"remove_contigs","name":"$self"},{"name":"@args","containerName":"remove_contigs","kind":13,"line":546},{"name":"@ret","containerName":"remove_contigs","localvar":"my","kind":13,"line":548,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"remove_contigs","name":"$contigID","line":549},{"line":549,"name":"@args","kind":13,"containerName":"remove_contigs"},{"localvar":"my","containerName":"remove_contigs","kind":13,"name":"$seqID","line":550,"definition":"my"},{"kind":13,"containerName":"remove_contigs","name":"$self","line":550},{"name":"get_contig_by_id","containerName":"remove_contigs","kind":12,"line":550},{"line":550,"name":"$contigID","containerName":"remove_contigs","kind":13},{"line":550,"name":"get_seq_ids","containerName":"remove_contigs","kind":12},{"line":551,"kind":13,"containerName":"remove_contigs","name":"$self"},{"line":551,"name":"$seqID","kind":13,"containerName":"remove_contigs"},{"name":"@ret","containerName":"remove_contigs","kind":13,"line":553},{"name":"$self","containerName":"remove_contigs","kind":13,"line":553},{"name":"$contigID","containerName":"remove_contigs","kind":13,"line":553},{"kind":13,"containerName":"remove_contigs","name":"$self","line":554},{"line":554,"name":"$contigID","kind":13,"containerName":"remove_contigs"},{"containerName":"remove_contigs","kind":13,"name":"@ret","line":557}],"containerName":"main::","name":"remove_contigs","definition":"sub","detail":"($self,@args)"},{"detail":"($self,@args)","definition":"sub","name":"remove_singlets","containerName":"main::","children":[{"definition":"my","line":573,"name":"$self","localvar":"my","containerName":"remove_singlets","kind":13},{"line":573,"name":"@args","kind":13,"containerName":"remove_singlets"},{"localvar":"my","containerName":"remove_singlets","kind":13,"name":"@ret","line":575,"definition":"my"},{"containerName":"remove_singlets","localvar":"my","kind":13,"name":"$singletID","line":576,"definition":"my"},{"line":576,"name":"@args","containerName":"remove_singlets","kind":13},{"containerName":"remove_singlets","kind":13,"name":"@ret","line":577},{"name":"$self","containerName":"remove_singlets","kind":13,"line":577},{"kind":13,"containerName":"remove_singlets","name":"$singletID","line":577},{"line":578,"name":"$self","kind":13,"containerName":"remove_singlets"},{"line":578,"kind":13,"containerName":"remove_singlets","name":"$singletID"},{"line":581,"name":"@ret","containerName":"remove_singlets","kind":13}],"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above","label":"remove_singlets($self,@args)"},"kind":12,"range":{"end":{"character":9999,"line":582},"start":{"character":0,"line":572}},"line":572},{"containerName":"main::","name":"remove_features_collection","children":[{"containerName":"remove_features_collection","localvar":"my","kind":13,"name":"$self","line":598,"definition":"my"},{"definition":"my","line":599,"name":"$obj","kind":13,"localvar":"my","containerName":"remove_features_collection"},{"line":599,"kind":13,"containerName":"remove_features_collection","name":"$self"},{"line":599,"kind":12,"containerName":"remove_features_collection","name":"all_contigs"},{"containerName":"remove_features_collection","kind":13,"name":"$self","line":599},{"name":"all_singlets","kind":12,"containerName":"remove_features_collection","line":599},{"line":600,"name":"$obj","containerName":"remove_features_collection","kind":13},{"line":600,"name":"remove_features_collection","kind":12,"containerName":"remove_features_collection"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":603},"start":{"line":597,"character":0}},"line":597,"signature":{"label":"remove_features_collection($self)","documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none","parameters":[{"label":"$self"}]}},{"children":[{"line":623,"name":"$self","localvar":"my","kind":13,"containerName":"select_contigs","definition":"my"},{"name":"@args","kind":13,"containerName":"select_contigs","line":623},{"definition":"my","line":625,"containerName":"select_contigs","localvar":"my","kind":13,"name":"@contigs"},{"localvar":"my","containerName":"select_contigs","kind":13,"name":"$contig","line":626,"definition":"my"},{"containerName":"select_contigs","kind":13,"name":"@args","line":626},{"name":"$self","kind":13,"containerName":"select_contigs","line":627},{"line":627,"name":"$contig","kind":13,"containerName":"select_contigs"},{"name":"$self","kind":13,"containerName":"select_contigs","line":628},{"name":"warn","kind":12,"containerName":"select_contigs","line":628},{"line":631,"kind":13,"containerName":"select_contigs","name":"@contigs"},{"containerName":"select_contigs","kind":13,"name":"$self","line":631},{"containerName":"select_contigs","kind":13,"name":"$contig","line":631},{"line":634,"name":"@contigs","containerName":"select_contigs","kind":13}],"containerName":"main::","name":"select_contigs","definition":"sub","detail":"($self,@args)","line":622,"range":{"start":{"line":622,"character":0},"end":{"line":635,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none\n\n\nsub remove_features_collection {\n    my ($self) = @_;\n    for my $obj ( $self->all_contigs, $self->all_singlets ) {\n        $obj->remove_features_collection;\n    }\n    return;\n}\n\n\n=head1 Contig and singlet selection methods\n\n\n=head2 select_contigs\n\n    Title   : select_contigs\n    Usage   : $assembly->select_contigs(@list)\n    Function: Select an array of contigs from the assembly\n    Returns : an array of Bio::Assembly::Contig objects\n    Args    : an array of contig ids\n\n    See function get_contig_ids() above","label":"select_contigs($self,@args)"}},{"definition":"sub","detail":"($self,@args)","children":[{"line":650,"name":"$self","localvar":"my","kind":13,"containerName":"select_singlets","definition":"my"},{"line":650,"name":"@args","containerName":"select_singlets","kind":13},{"name":"@singlets","containerName":"select_singlets","localvar":"my","kind":13,"line":652,"definition":"my"},{"definition":"my","localvar":"my","containerName":"select_singlets","kind":13,"name":"$singlet","line":653},{"line":653,"kind":13,"containerName":"select_singlets","name":"@args"},{"kind":13,"containerName":"select_singlets","name":"$self","line":654},{"kind":13,"containerName":"select_singlets","name":"$singlet","line":654},{"containerName":"select_singlets","kind":13,"name":"$self","line":655},{"line":655,"name":"warn","containerName":"select_singlets","kind":12},{"line":658,"name":"@singlets","kind":13,"containerName":"select_singlets"},{"line":658,"containerName":"select_singlets","kind":13,"name":"$self"},{"line":658,"name":"$singlet","containerName":"select_singlets","kind":13},{"name":"@singlets","containerName":"select_singlets","kind":13,"line":661}],"containerName":"main::","name":"select_singlets","signature":{"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none\n\n\nsub remove_features_collection {\n    my ($self) = @_;\n    for my $obj ( $self->all_contigs, $self->all_singlets ) {\n        $obj->remove_features_collection;\n    }\n    return;\n}\n\n\n=head1 Contig and singlet selection methods\n\n\n=head2 select_contigs\n\n    Title   : select_contigs\n    Usage   : $assembly->select_contigs(@list)\n    Function: Select an array of contigs from the assembly\n    Returns : an array of Bio::Assembly::Contig objects\n    Args    : an array of contig ids\n\n    See function get_contig_ids() above\n\n\nsub select_contigs {\n    my ($self,@args) = @_;\n\n    my @contigs = ();\n    foreach my $contig (@args) {\n    unless (exists $self->{'_contigs'}{$contig}) {\n        $self->warn(\"$contig contig not found. Ignoring...\");\n        next;\n    }\n    push(@contigs, $self->{'_contigs'}{$contig});\n    }\n\n    return @contigs;\n}\n\n=head2 select_singlets\n\n    Title   : select_singlets\n    Usage   : $assembly->select_singlets(@list)\n    Function: Selects an array of singlets from the assembly\n    Returns : an array of Bio::Assembly::Singlet objects\n    Args    : an array of singlet ids\n\n    See function get_singlet_ids() above","parameters":[{"label":"$self"},{"label":"@args"}],"label":"select_singlets($self,@args)"},"line":649,"kind":12,"range":{"end":{"character":9999,"line":662},"start":{"line":649,"character":0}}},{"definition":"sub","detail":"($self)","children":[{"line":680,"name":"$self","kind":13,"localvar":"my","containerName":"all_contigs","definition":"my"},{"containerName":"all_contigs","localvar":"my","kind":13,"name":"@contigs","line":682,"definition":"my"},{"line":683,"name":"$contig","kind":13,"localvar":"my","containerName":"all_contigs","definition":"my"},{"line":683,"containerName":"all_contigs","kind":13,"name":"$a"},{"line":683,"name":"$b","kind":13,"containerName":"all_contigs"},{"kind":13,"containerName":"all_contigs","name":"$self","line":683}],"name":"all_contigs","containerName":"main::","signature":{"label":"all_contigs($self)","documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none\n\n\nsub remove_features_collection {\n    my ($self) = @_;\n    for my $obj ( $self->all_contigs, $self->all_singlets ) {\n        $obj->remove_features_collection;\n    }\n    return;\n}\n\n\n=head1 Contig and singlet selection methods\n\n\n=head2 select_contigs\n\n    Title   : select_contigs\n    Usage   : $assembly->select_contigs(@list)\n    Function: Select an array of contigs from the assembly\n    Returns : an array of Bio::Assembly::Contig objects\n    Args    : an array of contig ids\n\n    See function get_contig_ids() above\n\n\nsub select_contigs {\n    my ($self,@args) = @_;\n\n    my @contigs = ();\n    foreach my $contig (@args) {\n    unless (exists $self->{'_contigs'}{$contig}) {\n        $self->warn(\"$contig contig not found. Ignoring...\");\n        next;\n    }\n    push(@contigs, $self->{'_contigs'}{$contig});\n    }\n\n    return @contigs;\n}\n\n=head2 select_singlets\n\n    Title   : select_singlets\n    Usage   : $assembly->select_singlets(@list)\n    Function: Selects an array of singlets from the assembly\n    Returns : an array of Bio::Assembly::Singlet objects\n    Args    : an array of singlet ids\n\n    See function get_singlet_ids() above\n\n\nsub select_singlets {\n    my ($self,@args) = @_;\n\n    my @singlets = ();\n    foreach my $singlet (@args) {\n    unless (exists $self->{'_singlets'}{$singlet}) {\n        $self->warn(\"$singlet singlet not found. Ignoring...\");\n        next;\n    }\n    push(@singlets, $self->{'_singlets'}{$singlet});\n    }\n\n    return @singlets;\n}\n\n=head2 all_contigs\n\n    Title   : all_contigs\n    Usage   : my @contigs = $assembly->all_contigs\n    Function: \n\n              Returns a list of all contigs in this assembly.  Contigs\n              are both clusters and alignments of one or more reads,\n              with an associated consensus sequence.\n\n    Returns : array of Bio::Assembly::Contig (in lexical id order)\n    Args    : none","parameters":[{"label":"$self"}]},"line":679,"range":{"end":{"character":9999,"line":683},"start":{"line":679,"character":0}},"kind":12},{"containerName":null,"kind":13,"name":"@contigs","line":684},{"name":"%self","containerName":null,"kind":13,"line":684},{"kind":13,"containerName":null,"name":"$contig","line":684},{"containerName":null,"kind":13,"name":"@contigs","line":687},{"detail":"($self)","definition":"sub","containerName":"main::","name":"all_singlets","children":[{"localvar":"my","kind":13,"containerName":"all_singlets","name":"$self","line":706,"definition":"my"},{"definition":"my","line":708,"localvar":"my","kind":13,"containerName":"all_singlets","name":"@singlets"},{"definition":"my","line":709,"kind":13,"localvar":"my","containerName":"all_singlets","name":"$singlet"},{"line":709,"name":"$a","containerName":"all_singlets","kind":13},{"name":"$b","containerName":"all_singlets","kind":13,"line":709},{"name":"$self","kind":13,"containerName":"all_singlets","line":709}],"signature":{"documentation":"1;\n# $Id: Scaffold.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Assembly::Scaffold\n#\n# Copyright by Robson F. de Souza\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Assembly::Scaffold - Perl module to hold and manipulate sequence assembly\ndata.\n\n=head1 SYNOPSIS\n\n    # Module loading\n    use Bio::Assembly::IO;\n\n    # Assembly loading methods\n    my $aio = Bio::Assembly::IO->new(-file=>\"test.ace.1\", -format=>'phrap');\n    my $assembly = $aio->next_assembly;\n\n    foreach my $contig ($assembly->all_contigs) {\n        # do something... (see Bio::Assembly::Contig)\n    }\n\n=head1 DESCRIPTION\n\nBio::Assembly::Scaffold was developed to store and manipulate data\nfrom sequence assembly programs like Phrap. It implements the\nScaffoldI interface and intends to be generic enough to be used by\nBio::Assembly::IO drivers written to programs other than Phrap.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Robson Francisco de Souza\n\nrfsouza@citri.iq.usp.br\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Assembly::Scaffold;\n\nuse strict;\nuse Bio::Annotation::Collection;\n\nuse base qw(Bio::Root::Root Bio::Assembly::ScaffoldI);\n\n=head2 new ()\n\n    Title   : new\n    Usage   : $scaffold = new ( -id       => \"assembly 1\",\n                                -source   => 'program_name',\n                                -contigs  => \\@contigs,\n                                -singlets => \\@singlets );\n    Function: creates a new scaffold object\n    Returns : Bio::Assembly::Scaffold\n    Args    : -id       : [string] scaffold name\n              -source   : [string] sequence assembly program\n              -contigs  : reference to array of Bio::Assembly::Contig objects\n              -singlets : reference to array of Bio::Assembly::Singlet objects\n\n\n\nsub new {\n  my($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id, $src, $contigs, $singlets) = $self->_rearrange(\n      [qw(ID SOURCE CONTIGS SINGLETS)], @args);\n\n  # Scaffold defaults\n  $self->{'_id'} = 'NoName';\n  $self->{'_source'} = 'Unknown';\n  $self->{'_contigs'} = {};\n  $self->{'_singlets'} = {};\n  $self->{'_seqs'} = {};\n  $self->{'_annotation'} = Bio::Annotation::Collection->new();\n\n  # Import manual info\n  $self->{'_id'} = $id if (defined $id);\n  $self->{'_source'} = $src if (defined $src);\n  \n  # Add contigs and singlets to scaffold\n  if (defined $contigs && ref($contigs = 'ARRAY')) {\n    for my $contig (@{$contigs}) {\n      if( ! ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Contig object [\", ref($contig), \"]\");\n      }\n      $self->add_contig($contig);\n    }\n  }\n  if (defined $singlets && ref($singlets = 'ARRAY')) {\n    for my $singlet (@{$singlets}) {\n      if( ! ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::new is unable to process non\".\n          \"Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n      }\n      $self->add_singlet($singlet);\n    }\n  }\n  \n  return $self;\n}\n\n=head1 Accessing general assembly data\n\n\n=head2 id\n\n    Title   : id\n    Usage   : $assembly->id()\n    Function: Get/Set assembly ID\n    Returns : string or undef\n    Args    : string\n\n\nsub id {\n    my ($self, $id) = @_;\n    return $self->{'_id'} = $id if (defined $id);\n    return $self->{'_id'};\n}\n\n=head2 annotation\n\n    Title   : annotation\n    Usage   : $assembly->annotation()\n    Function: Get/Set assembly annotation object\n    Returns : Bio::Annotation::Collection\n    Args    : none\n\n\nsub annotation {\n    my ($self, $ref) = shift;\n    $self->{'_annotation'} = $ref if (defined $ref);\n    return $self->{'_annotation'};\n}\n\n=head2 get_nof_contigs\n\n    Title   : get_nof_contigs\n    Usage   : $assembly->get_nof_contigs()\n    Function: Get the number of contigs included in the scaffold\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contigs {\n    my $self = shift;\n    return scalar( $self->get_contig_ids() );\n}\n\n=head2 get_nof_contig_seqs\n\n    Title   : get_nof_contig_seqs\n    Usage   : $assembly->get_nof_contig_seqs()\n    Function: Get the number of sequences included in contigs of the \n              scaffold (no consensus sequences or singlets)\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_contig_seqs {\n    my $self = shift;\n\n    my $nof_seqs = 0;\n    foreach my $contig ($self->all_contigs) {\n        $nof_seqs += scalar( $contig->get_seq_ids() );\n    }\n\n    return $nof_seqs;\n}\n# function alias for backward compatibility\n*get_nof_sequences_in_contigs = \\&get_nof_contig_seqs;\n\n\n=head2 get_nof_singlets (get_nof_singlet_seqs)\n\n    Title   : nof_singlets\n    Usage   : $assembly->nof_singlets()\n    Function: Get the number of singlets included in the assembly\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_singlets {\n    my $self = shift;\n    return scalar( $self->get_singlet_ids() );\n}\n*get_nof_singlet_seqs = \\&get_nof_singlets;\n\n=head2 get_all_seq_ids\n\n    Title   : get_all_seq_ids\n    Usage   : $assembly->get_all_seq_ids()\n    Function: Get the ID of all sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : array of strings\n    Args    : none\n\n\nsub get_all_seq_ids {\n    my $self = shift;\n    return keys %{ $self->{'_seqs'} };\n}\n\n=head2 get_nof_seqs\n\n    Title   : get_nof_seqs\n    Usage   : $assembly->get_nof_seqs()\n    Function: Get total number of sequences making up the scaffold\n              (sequences from contigs and singlets, not consensus).\n    Returns : integer\n    Args    : none\n\n\nsub get_nof_seqs {\n    my $self = shift;\n    return scalar $self->get_all_seq_ids;\n}\n\n=head2 get_contig_seq_ids\n\n    Title   : get_contig_seq_ids\n    Usage   : $assembly->get_contig_seq_ids()\n    Function: Get the ID of all sequences in contigs\n    Returns : array of strings\n    Args    : none\n\n\nsub get_contig_seq_ids {\n    my $self = shift;\n    my @ids;\n    for my $contig ( $self->all_contigs ) {\n        push @ids, $contig->get_seq_ids;\n    }\n    return @ids;\n}\n# function alias for backward compatibility\n*get_seq_ids = \\&get_contig_seq_ids; \n\n=head2 get_contig_ids\n\n    Title   : get_contig_ids\n    Usage   : $assembly->get_contig_ids()\n    Function: Access list of contig IDs from assembly\n    Returns : an array, if there are any contigs in the\n              assembly. An empty array otherwise\n    Args    : none\n\n\nsub get_contig_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_contigs'}}\n        : scalar keys %{$self->{'_contigs'}};\n}\n\n=head2 get_singlet_ids (get_singlet_seq_ids)\n\n    Title   : get_singlet_ids\n    Usage   : $assembly->get_singlet_ids()\n    Function: Access list of singlet IDs from assembly\n    Returns : array of strings if there are any singlets\n              otherwise an empty array\n    Args    : none\n\n\nsub get_singlet_ids {\n    my $self = shift;\n\n    return wantarray\n        ? sort keys %{$self->{'_singlets'}}\n        : scalar keys %{$self->{'_singlets'}};\n}\n*get_singlet_seq_ids = \\&get_singlet_ids;\n\n=head2 get_seq_by_id\n\n    Title   : get_seq_by_id\n    Usage   : $assembly->get_seq_by_id($id)\n    Function: Get a reference for an sequence making up the scaffold \n              (from a contig or singlet, not consensus)\n    Returns : a Bio::LocatableSeq object\n              undef if sequence $id is not found in the scaffold\n    Args    : [string] sequence identifier (id)\n\n\nsub get_seq_by_id {\n    my $self = shift;\n    my $seqID = shift;\n\n    return unless (exists $self->{'_seqs'}{$seqID});\n\n    return $self->{'_seqs'}{$seqID}->get_seq_by_name($seqID);\n}\n\n=head2 get_contig_by_id\n\n    Title   : get_contig_by_id\n    Usage   : $assembly->get_contig_by_id($id)\n    Function: Get a reference for a contig\n    Returns : a Bio::Assembly::Contig object or undef\n    Args    : [string] contig unique identifier (ID)\n\n\nsub get_contig_by_id {\n    my $self = shift;\n    my $contigID = shift;\n\n    return unless (exists $self->{'_contigs'}{$contigID});\n\n    return $self->{'_contigs'}{$contigID};\n}\n\n=head2 get_singlet_by_id\n\n    Title   : get_singlet_by_id\n    Usage   : $assembly->get_singlet_by_id()\n    Function: Get a reference for a singlet\n    Returns : Bio::Assembly::Singlet object or undef\n    Args    : [string] a singlet ID\n\n\nsub get_singlet_by_id {\n    my $self = shift;\n\n    my $singletID = shift;\n\n    return unless (exists $self->{'_singlets'}{$singletID});\n\n    return $self->{'_singlets'}{$singletID};\n}\n\n=head1 Modifier methods\n\n\n=head2 add_contig\n\n    Title   : add_contig\n    Usage   : $assembly->add_contig($contig)\n    Function: Add a contig to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Contig object\n          order (optional)\n\n\nsub add_contig {\n    my ($self, $contig) = @_;\n\n    # Input check\n    if( !ref $contig || ! $contig->isa('Bio::Assembly::Contig') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_contig is unable to process\".\n            \" non Bio::Assembly::Contig object [\", ref($contig), \"]\");\n    }\n    \n    # Create and attribute contig ID\n    my $contigID  = $contig->id();\n    if( !defined $contigID ) {\n        $contigID = 'Unknown_' . ($self->get_nof_contigs() + 1);\n        $contig->id($contigID);\n        $self->warn(\"Attributing ID $contigID to unnamed Bio::Assembly::Contig\".\n            \" object.\");\n    }\n\n    # Adding contig to scaffold\n    $self->warn(\"Replacing contig $contigID with a new contig object\")\n        if (exists $self->{'_contigs'}{$contigID});\n    $self->{'_contigs'}{$contigID} = $contig;\n    $contig->assembly($self); # weak circular reference\n\n    # Put contig sequences in the list of sequences belonging to the scaffold\n    foreach my $seqID ($contig->get_seq_ids()) {\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $contig) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n        }\n        $self->{'_seqs'}{$seqID} = $contig;\n    }\n    \n    return 1;\n}\n\n=head2 add_singlet\n\n    Title   : add_singlet\n    Usage   : $assembly->add_singlet($seq)\n    Function: Add a singlet to the assembly\n    Returns : 1 on success\n    Args    : a Bio::Assembly::Singlet object\n              order (optional)\n\n\nsub add_singlet {\n    my ($self, $singlet) = @_;\n\n    # Input check\n    if ( !ref $singlet || ! $singlet->isa('Bio::Assembly::Singlet') ) {\n        $self->throw(\"Bio::Assembly::Scaffold::add_singlet is unable to process\".\n            \" non Bio::Assembly::Singlet object [\", ref($singlet), \"]\");\n    }\n    \n    # Create and attribute singlet ID\n    my $singletID = $singlet->id();\n    if( !defined $singletID ) {\n        $singletID = 'Unknown_' . ($self->get_nof_singlets() + 1);\n        $singlet->id($singletID);\n        $self->warn(\"Attributing ID $singletID to unnamed Bio::Assembly::\".\n            \"Singlet object.\");\n    }\n    \n    # Adding singlet to scaffold\n    $self->warn(\"Replacing singlet $singletID with a new singlet object\")\n        if (exists $self->{'_singlets'}{$singletID});\n    $self->{'_singlets'}{$singletID} = $singlet;\n    $singlet->assembly($self); # weak circular reference\n\n    # Put singlet sequence in the list of sequences belonging to the scaffold\n    my $seqID = $singlet->id();\n    if (exists $self->{'_seqs'}{$seqID} &&\n        not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n        $self->warn( \"Sequence $seqID already assigned to object \".\n            $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n    }\n    $self->{'_seqs'}{$seqID} = $singlet;\n    return 1;\n}\n\n=head2 update_seq_list\n\n    Title   : update_seq_list\n    Usage   : $assembly->update_seq_list()\n    Function: \n\n              Synchronizes the assembly registry for sequences in\n              contigs and contig actual aligned sequences content. You\n              probably want to run this after you remove/add a\n              sequence from/to a contig in the assembly.\n\n    Returns : 1 for success\n    Args    : none \n\n\nsub update_seq_list {\n    my $self = shift;\n    \n    $self->{'_seqs'} = {};\n\n    # Put sequences in contigs in list of sequences belonging to the scaffold\n    foreach my $contig ($self->all_contigs) {\n        my $contigID = $contig->id();\n        foreach my $seqID ($contig->get_seq_ids) {\n            if (exists $self->{'_seqs'}{$seqID} &&\n                not($self->{'_seqs'}{$seqID} eq $contig) ) {\n                $self->warn( \"Sequence $seqID already assigned to object \".\n                    $self->{'_seqs'}{$seqID}->id().\". Moving to contig $contigID\");\n            }\n            $self->{'_seqs'}{$seqID} = $contig;\n        }\n    }\n    \n    # Put singlet sequences in the list of sequences belonging to the scaffold\n    foreach my $singlet ($self->all_singlets) {\n        my $seqID = $singlet->id();\n        my $singletID = $singlet->id();\n        if (exists $self->{'_seqs'}{$seqID} &&\n            not($self->{'_seqs'}{$seqID} eq $singlet) ) {\n            $self->warn( \"Sequence $seqID already assigned to object \".\n                $self->{'_seqs'}{$seqID}->id().\". Moving to singlet $singletID\");\n        }\n        $self->{'_seqs'}{$seqID} = $singlet;\n    }\n\n    return 1;\n}\n\n=head2 remove_contigs\n\n    Title   : remove_contigs\n    Usage   : $assembly->remove_contigs(1..4)\n    Function: Remove contig from assembly object\n    Returns : an array of removed Bio::Assembly::Contig\n              objects\n    Args    : an array of contig IDs \n\n    See function get_contig_ids() above\n\n\nsub remove_contigs {\n    my ($self, @args) = @_;\n\n    my @ret = ();\n    foreach my $contigID (@args) {\n        foreach my $seqID ($self->get_contig_by_id($contigID)->get_seq_ids()) {\n            delete $self->{'_seqs'}{$seqID};\n        }\n        push(@ret, $self->{'_contigs'}{$contigID});\n        delete $self->{'_contigs'}{$contigID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_singlets\n\n    Title   : remove_singlets\n    Usage   : $assembly->remove_singlets(@singlet_ids)\n    Function: Remove singlet from assembly object\n    Returns : the Bio::Assembly::Singlet objects removed\n    Args    : a list of singlet IDs\n\n    See function get_singlet_ids() above\n\n\nsub remove_singlets {\n    my ($self,@args) = @_;\n\n    my @ret = ();\n    foreach my $singletID (@args) {\n        push(@ret,$self->{'_singlets'}{$singletID});\n        delete $self->{'_singlets'}{$singletID};\n    }\n\n    return @ret;\n}\n\n=head2 remove_features_collection\n\n    Title   : remove_features_collection\n    Usage   : $assembly->remove_features_collection()\n    Function: Removes the collection of features associated to every\n              contig and singlet of the scaffold. This can be useful\n              to save some memory (when contig and singlet features are\n              not needed).\n    Returns   : none\n    Argument  : none\n\n\nsub remove_features_collection {\n    my ($self) = @_;\n    for my $obj ( $self->all_contigs, $self->all_singlets ) {\n        $obj->remove_features_collection;\n    }\n    return;\n}\n\n\n=head1 Contig and singlet selection methods\n\n\n=head2 select_contigs\n\n    Title   : select_contigs\n    Usage   : $assembly->select_contigs(@list)\n    Function: Select an array of contigs from the assembly\n    Returns : an array of Bio::Assembly::Contig objects\n    Args    : an array of contig ids\n\n    See function get_contig_ids() above\n\n\nsub select_contigs {\n    my ($self,@args) = @_;\n\n    my @contigs = ();\n    foreach my $contig (@args) {\n    unless (exists $self->{'_contigs'}{$contig}) {\n        $self->warn(\"$contig contig not found. Ignoring...\");\n        next;\n    }\n    push(@contigs, $self->{'_contigs'}{$contig});\n    }\n\n    return @contigs;\n}\n\n=head2 select_singlets\n\n    Title   : select_singlets\n    Usage   : $assembly->select_singlets(@list)\n    Function: Selects an array of singlets from the assembly\n    Returns : an array of Bio::Assembly::Singlet objects\n    Args    : an array of singlet ids\n\n    See function get_singlet_ids() above\n\n\nsub select_singlets {\n    my ($self,@args) = @_;\n\n    my @singlets = ();\n    foreach my $singlet (@args) {\n    unless (exists $self->{'_singlets'}{$singlet}) {\n        $self->warn(\"$singlet singlet not found. Ignoring...\");\n        next;\n    }\n    push(@singlets, $self->{'_singlets'}{$singlet});\n    }\n\n    return @singlets;\n}\n\n=head2 all_contigs\n\n    Title   : all_contigs\n    Usage   : my @contigs = $assembly->all_contigs\n    Function: \n\n              Returns a list of all contigs in this assembly.  Contigs\n              are both clusters and alignments of one or more reads,\n              with an associated consensus sequence.\n\n    Returns : array of Bio::Assembly::Contig (in lexical id order)\n    Args    : none\n\n\nsub all_contigs {\n    my ($self) = @_;\n\n    my @contigs = ();\n    foreach my $contig (sort { $a cmp $b } keys %{ $self->{'_contigs'} }) {\n        push(@contigs, $self->{'_contigs'}{$contig});\n    }\n\n    return @contigs;\n}\n\n=head2 all_singlets\n\n    Title   : all_singlets\n    Usage   : my @singlets = $assembly->all_singlets\n    Function: \n\n              Returns a list of all singlets in this assembly.\n          Singlets are isolated reads, without non-vector\n          matches to any other read in the assembly.\n\n    Returns : array of Bio::Assembly::Singlet objects (in lexical order by id)\n    Args    : none","parameters":[{"label":"$self"}],"label":"all_singlets($self)"},"range":{"start":{"line":705,"character":0},"end":{"line":709,"character":9999}},"kind":12,"line":705},{"name":"@singlets","kind":13,"containerName":null,"line":710},{"line":710,"kind":13,"containerName":null,"name":"%self"},{"line":710,"name":"$singlet","containerName":null,"kind":13},{"name":"@singlets","containerName":null,"kind":13,"line":713}]}