{"vars":[{"line":108,"name":"base","kind":2,"containerName":""},{"children":[{"definition":"my","name":"$class","localvar":"my","containerName":"new","kind":13,"line":127},{"name":"@args","containerName":"new","kind":13,"line":127},{"definition":"my","line":128,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"kind":13,"containerName":"new","name":"$class","line":128},{"line":128,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":129,"name":"$id","localvar":"my","containerName":"new","kind":13},{"line":129,"name":"$description","kind":13,"containerName":"new"},{"line":129,"containerName":"new","kind":13,"name":"$version"},{"line":129,"kind":13,"containerName":"new","name":"$annot_score"},{"line":130,"name":"$family_score","containerName":"new","kind":13},{"line":130,"containerName":"new","kind":13,"name":"$members"},{"line":130,"name":"$self","containerName":"new","kind":13},{"line":130,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","kind":13,"containerName":"new","line":132},{"name":"$self","kind":13,"containerName":"new","line":133},{"name":"$id","containerName":"new","kind":13,"line":134},{"containerName":"new","kind":13,"name":"$self","line":134},{"line":134,"kind":12,"containerName":"new","name":"family_id"},{"line":134,"name":"$id","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$description","line":135},{"line":135,"containerName":"new","kind":13,"name":"$self"},{"line":135,"name":"description","kind":12,"containerName":"new"},{"name":"$description","containerName":"new","kind":13,"line":135},{"containerName":"new","kind":13,"name":"$version","line":136},{"line":136,"containerName":"new","kind":13,"name":"$self"},{"line":136,"name":"version","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"$version","line":136},{"containerName":"new","kind":13,"name":"$annot_score","line":137},{"line":137,"name":"$self","kind":13,"containerName":"new"},{"line":137,"containerName":"new","kind":12,"name":"annotation_score"},{"line":137,"name":"$annot_score","kind":13,"containerName":"new"},{"name":"$family_score","kind":13,"containerName":"new","line":138},{"line":138,"kind":13,"containerName":"new","name":"$self"},{"name":"family_score","kind":12,"containerName":"new","line":138},{"line":138,"containerName":"new","kind":13,"name":"$family_score"},{"line":139,"name":"$members","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":139},{"name":"add_members","kind":12,"containerName":"new","line":139},{"line":139,"kind":13,"containerName":"new","name":"$members"},{"name":"$self","kind":13,"containerName":"new","line":141}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)","line":126,"range":{"start":{"character":0,"line":126},"end":{"line":143,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.","label":"new($class,@args)"}},{"line":128,"name":"SUPER","containerName":"new","kind":12},{"signature":{"label":"version($self,$value)","documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. ","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"end":{"character":9999,"line":160},"start":{"line":154,"character":0}},"line":154,"detail":"($self,$value)","definition":"sub","name":"version","containerName":"main::","children":[{"line":155,"kind":13,"localvar":"my","containerName":"version","name":"$self","definition":"my"},{"name":"$value","containerName":"version","kind":13,"line":155},{"line":156,"kind":13,"containerName":"version","name":"$value"},{"name":"$self","containerName":"version","kind":13,"line":157},{"kind":13,"containerName":"version","name":"$value","line":157},{"kind":13,"containerName":"version","name":"$self","line":159}]},{"definition":"sub","detail":"($self,$score)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"annotation_score","line":177},{"name":"$score","containerName":"annotation_score","kind":13,"line":177},{"line":178,"name":"$score","containerName":"annotation_score","kind":13},{"line":179,"kind":13,"containerName":"annotation_score","name":"$self"},{"name":"$score","kind":13,"containerName":"annotation_score","line":179},{"kind":13,"containerName":"annotation_score","name":"$self","line":181}],"name":"annotation_score","containerName":"main::","signature":{"label":"annotation_score($self,$score)","documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>","parameters":[{"label":"$self"},{"label":"$score"}]},"line":176,"range":{"end":{"character":9999,"line":182},"start":{"character":0,"line":176}},"kind":12},{"kind":12,"range":{"end":{"line":202,"character":9999},"start":{"character":0,"line":196}},"line":196,"signature":{"label":"alignment($self,$align)","parameters":[{"label":"$self"},{"label":"$align"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>"},"containerName":"main::","name":"alignment","children":[{"line":197,"localvar":"my","containerName":"alignment","kind":13,"name":"$self","definition":"my"},{"line":197,"kind":13,"containerName":"alignment","name":"$align"},{"line":198,"kind":13,"containerName":"alignment","name":"$align"},{"containerName":"alignment","kind":13,"name":"$self","line":199},{"line":199,"name":"$align","containerName":"alignment","kind":13},{"name":"$self","containerName":"alignment","kind":13,"line":201}],"detail":"($self,$align)","definition":"sub"},{"definition":"sub","detail":"($self,$tree)","children":[{"line":217,"name":"$self","localvar":"my","kind":13,"containerName":"tree","definition":"my"},{"containerName":"tree","kind":13,"name":"$tree","line":217},{"kind":13,"containerName":"tree","name":"$tree","line":218},{"containerName":"tree","kind":13,"name":"$self","line":219},{"name":"$tree","containerName":"tree","kind":13,"line":219},{"line":221,"kind":13,"containerName":"tree","name":"$self"}],"name":"tree","containerName":"main::","signature":{"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>","parameters":[{"label":"$self"},{"label":"$tree"}],"label":"tree($self,$tree)"},"line":216,"range":{"end":{"line":222,"character":9999},"start":{"line":216,"character":0}},"kind":12},{"kind":12,"range":{"end":{"character":9999,"line":244},"start":{"line":242,"character":0}},"line":242,"definition":"sub","name":"family_score","containerName":"main::","children":[{"line":243,"name":"cluster_score","kind":12,"containerName":"family_score"}]},{"range":{"start":{"character":0,"line":259},"end":{"character":9999,"line":261}},"kind":12,"line":259,"name":"family_id","containerName":"main::","children":[{"name":"display_id","kind":12,"containerName":"family_id","line":260}],"definition":"sub"},{"detail":"($self,$id)","definition":"sub","containerName":"main::","name":"display_id","children":[{"definition":"my","line":278,"name":"$self","localvar":"my","kind":13,"containerName":"display_id"},{"line":278,"kind":13,"containerName":"display_id","name":"$id"},{"line":279,"containerName":"display_id","kind":13,"name":"$id"},{"containerName":"display_id","kind":13,"name":"$self","line":280},{"line":280,"containerName":"display_id","kind":13,"name":"$id"},{"name":"$self","kind":13,"containerName":"display_id","line":282}],"signature":{"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)","parameters":[{"label":"$self"},{"label":"$id"}],"label":"display_id($self,$id)"},"range":{"end":{"character":9999,"line":283},"start":{"character":0,"line":277}},"kind":12,"line":277},{"line":295,"kind":12,"range":{"end":{"line":301,"character":9999},"start":{"line":295,"character":0}},"signature":{"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string ","parameters":[{"label":"$self"},{"label":"$desc"}],"label":"description($self,$desc)"},"children":[{"definition":"my","localvar":"my","containerName":"description","kind":13,"name":"$self","line":296},{"line":296,"containerName":"description","kind":13,"name":"$desc"},{"line":297,"containerName":"description","kind":13,"name":"$desc"},{"name":"$self","containerName":"description","kind":13,"line":298},{"name":"$desc","kind":13,"containerName":"description","line":298},{"name":"$self","kind":13,"containerName":"description","line":300}],"containerName":"main::","name":"description","definition":"sub","detail":"($self,$desc)"},{"kind":12,"range":{"start":{"character":0,"line":325},"end":{"line":346,"character":9999}},"line":325,"name":"get_members","containerName":"main::","children":[{"line":326,"localvar":"my","kind":13,"containerName":"get_members","name":"$self","definition":"my"},{"definition":"my","name":"@ret","localvar":"my","containerName":"get_members","kind":13,"line":327},{"definition":"my","name":"%hash","containerName":"get_members","localvar":"my","kind":13,"line":330},{"line":331,"name":"$mem","localvar":"my","kind":13,"containerName":"get_members","definition":"my"},{"line":331,"kind":13,"containerName":"get_members","name":"$self"},{"definition":"my","localvar":"my","containerName":"get_members","kind":13,"name":"$key","line":332},{"line":332,"name":"%hash","kind":13,"containerName":"get_members"},{"definition":"my","line":333,"localvar":"my","containerName":"get_members","kind":13,"name":"$method"},{"containerName":"get_members","kind":13,"name":"$key","line":333},{"containerName":"get_members","kind":13,"name":"$method","line":334},{"name":"$mem","containerName":"get_members","kind":13,"line":335},{"name":"can","containerName":"get_members","kind":12,"line":335},{"name":"$species","kind":13,"localvar":"my","containerName":"get_members","line":336,"definition":"my"},{"line":336,"kind":13,"containerName":"get_members","name":"$mem"},{"line":336,"kind":12,"containerName":"get_members","name":"species"},{"kind":13,"containerName":"get_members","name":"$species","line":337},{"kind":12,"containerName":"get_members","name":"can","line":337},{"containerName":"get_members","kind":13,"name":"$method","line":337},{"line":338,"containerName":"get_members","kind":13,"name":"$self"},{"line":338,"name":"throw","kind":12,"containerName":"get_members"},{"line":339,"containerName":"get_members","kind":13,"name":"$species"},{"kind":13,"containerName":"get_members","name":"$method","line":339},{"kind":13,"containerName":"get_members","name":"$hash","line":339},{"line":339,"kind":13,"containerName":"get_members","name":"$key"},{"line":340,"kind":13,"containerName":"get_members","name":"@ret"},{"kind":13,"containerName":"get_members","name":"$mem","line":340},{"name":"@ret","kind":13,"containerName":"get_members","line":345}],"definition":"sub"},{"name":"%self","containerName":null,"kind":13,"line":347},{"definition":"sub","detail":"($self)","children":[{"definition":"my","line":362,"localvar":"my","kind":13,"containerName":"size","name":"$self"},{"line":364,"kind":13,"containerName":"size","name":"$self"}],"containerName":"main::","name":"size","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n\tmy ($self,$desc) = @_;\n\tif($desc){\n\t\t$self->{'_description'} = $desc;\n\t}\n\treturn $self->{'_description'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Valid criteria:\n           -common_name\n           -binomial\n           -ncbi_taxid\n           -organelle\n           -genus\n           $family->get_members(-common_name =>\"human\");\n           $family->get_members(-species     =>\"homo sapiens\");\n           $family->get_members(-ncbi_taxid  => 9606);\n           For now, multiple critieria are ORed.\n\n           Will return all members if no criteria are provided.\n\n Function: get members using methods from L<Bio::Species>\n           the phylogenetic tree of the family.\n Returns : an array of objects that are member of this family. \n\n\nsub get_members {\n\tmy $self = shift;\n\tmy @ret;\n\n\tif(@_) {\n\t\tmy %hash = @_;\n\t\tforeach my $mem ( @{$self->{'_members'}} ) {\n\t\t\tforeach my $key ( keys %hash){\n\t\t\t\tmy $method = $key;\n\t\t\t\t$method=~s/-//g;\n\t\t\t\tif($mem->can('species')){\n\t\t\t\t\tmy $species = $mem->species;\n\t\t\t\t\t$species->can($method) ||\n\t\t\t\t\t  $self->throw(\"$method is an invalid criteria\");\n\t\t\t\t\tif($species->$method() eq $hash{$key} ){\n\t\t\t\t\t\tpush @ret, $mem;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn @ret;\n\t}\n\treturn @{$self->{'_members'}};\n}\n\n=head2 size\n\n Title   : size\n Usage   : $fam->size();\n Function: get/set for the size of the family, \n           calculated from the number of members\n Returns : the size of the family \n Args    : ","label":"size($self)"},"line":361,"kind":12,"range":{"end":{"character":9999,"line":364},"start":{"line":361,"character":0}}},{"definition":"sub","detail":"($self,$score)","children":[{"line":380,"name":"$self","localvar":"my","containerName":"cluster_score","kind":13,"definition":"my"},{"line":380,"containerName":"cluster_score","kind":13,"name":"$score"},{"name":"$score","containerName":"cluster_score","kind":13,"line":381},{"line":382,"kind":13,"containerName":"cluster_score","name":"$self"},{"line":382,"containerName":"cluster_score","kind":13,"name":"$score"},{"containerName":"cluster_score","kind":13,"name":"$self","line":384}],"containerName":"main::","name":"cluster_score","signature":{"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n\tmy ($self,$desc) = @_;\n\tif($desc){\n\t\t$self->{'_description'} = $desc;\n\t}\n\treturn $self->{'_description'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Valid criteria:\n           -common_name\n           -binomial\n           -ncbi_taxid\n           -organelle\n           -genus\n           $family->get_members(-common_name =>\"human\");\n           $family->get_members(-species     =>\"homo sapiens\");\n           $family->get_members(-ncbi_taxid  => 9606);\n           For now, multiple critieria are ORed.\n\n           Will return all members if no criteria are provided.\n\n Function: get members using methods from L<Bio::Species>\n           the phylogenetic tree of the family.\n Returns : an array of objects that are member of this family. \n\n\nsub get_members {\n\tmy $self = shift;\n\tmy @ret;\n\n\tif(@_) {\n\t\tmy %hash = @_;\n\t\tforeach my $mem ( @{$self->{'_members'}} ) {\n\t\t\tforeach my $key ( keys %hash){\n\t\t\t\tmy $method = $key;\n\t\t\t\t$method=~s/-//g;\n\t\t\t\tif($mem->can('species')){\n\t\t\t\t\tmy $species = $mem->species;\n\t\t\t\t\t$species->can($method) ||\n\t\t\t\t\t  $self->throw(\"$method is an invalid criteria\");\n\t\t\t\t\tif($species->$method() eq $hash{$key} ){\n\t\t\t\t\t\tpush @ret, $mem;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn @ret;\n\t}\n\treturn @{$self->{'_members'}};\n}\n\n=head2 size\n\n Title   : size\n Usage   : $fam->size();\n Function: get/set for the size of the family, \n           calculated from the number of members\n Returns : the size of the family \n Args    : \n\n\nsub size {\n  my ($self) = @_;\n\n  return scalar(@{$self->{'_members'}});\n\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $fam->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n Returns : a number","parameters":[{"label":"$self"},{"label":"$score"}],"label":"cluster_score($self,$score)"},"line":379,"kind":12,"range":{"start":{"character":0,"line":379},"end":{"character":9999,"line":385}}},{"signature":{"label":"add_members($self,@mems)","parameters":[{"label":"$self"},{"label":"@mems"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n\tmy ($self,$desc) = @_;\n\tif($desc){\n\t\t$self->{'_description'} = $desc;\n\t}\n\treturn $self->{'_description'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Valid criteria:\n           -common_name\n           -binomial\n           -ncbi_taxid\n           -organelle\n           -genus\n           $family->get_members(-common_name =>\"human\");\n           $family->get_members(-species     =>\"homo sapiens\");\n           $family->get_members(-ncbi_taxid  => 9606);\n           For now, multiple critieria are ORed.\n\n           Will return all members if no criteria are provided.\n\n Function: get members using methods from L<Bio::Species>\n           the phylogenetic tree of the family.\n Returns : an array of objects that are member of this family. \n\n\nsub get_members {\n\tmy $self = shift;\n\tmy @ret;\n\n\tif(@_) {\n\t\tmy %hash = @_;\n\t\tforeach my $mem ( @{$self->{'_members'}} ) {\n\t\t\tforeach my $key ( keys %hash){\n\t\t\t\tmy $method = $key;\n\t\t\t\t$method=~s/-//g;\n\t\t\t\tif($mem->can('species')){\n\t\t\t\t\tmy $species = $mem->species;\n\t\t\t\t\t$species->can($method) ||\n\t\t\t\t\t  $self->throw(\"$method is an invalid criteria\");\n\t\t\t\t\tif($species->$method() eq $hash{$key} ){\n\t\t\t\t\t\tpush @ret, $mem;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn @ret;\n\t}\n\treturn @{$self->{'_members'}};\n}\n\n=head2 size\n\n Title   : size\n Usage   : $fam->size();\n Function: get/set for the size of the family, \n           calculated from the number of members\n Returns : the size of the family \n Args    : \n\n\nsub size {\n  my ($self) = @_;\n\n  return scalar(@{$self->{'_members'}});\n\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $fam->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n Returns : a number\n\n\nsub cluster_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_cluster_score'} = $score;\n  }\n  return $self->{'_cluster_score'};\n}\n\n\n=head1 Implementation specific methods\n\n  These are mostly for adding/removing/changing.\n\n\n=head2 add_members\n\n Title   : add_members\n Usage   : $fam->add_member([$seq1,$seq1]);\n Function: add members to a family\n Returns : \n Args    : the member(s) to add, as an array or arrayref"},"kind":12,"range":{"end":{"character":9999,"line":411},"start":{"character":0,"line":404}},"line":404,"detail":"($self,@mems)","definition":"sub","containerName":"main::","name":"add_members","children":[{"localvar":"my","kind":13,"containerName":"add_members","name":"$self","line":405,"definition":"my"},{"line":405,"name":"@mems","kind":13,"containerName":"add_members"},{"line":407,"kind":13,"containerName":"add_members","name":"@mems"},{"definition":"my","line":408,"kind":13,"localvar":"my","containerName":"add_members","name":"$mem"},{"kind":13,"containerName":"add_members","name":"@mems","line":408},{"name":"$mem","containerName":"add_members","kind":13,"line":409},{"line":410,"containerName":"add_members","kind":13,"name":"$self"},{"line":410,"containerName":"add_members","kind":13,"name":"$mem"}]},{"name":"%self","containerName":null,"kind":13,"line":412},{"line":412,"containerName":null,"kind":13,"name":"$mem"},{"line":414,"containerName":null,"kind":13,"name":"%self"},{"line":414,"containerName":null,"kind":13,"name":"@mems"},{"containerName":"main::","name":"remove_members","children":[{"definition":"my","line":430,"containerName":"remove_members","localvar":"my","kind":13,"name":"$self"},{"definition":"my","line":431,"name":"$mems","localvar":"my","containerName":"remove_members","kind":13},{"line":431,"containerName":"remove_members","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"remove_members","line":432},{"name":"$mems","containerName":"remove_members","kind":13,"line":433}],"detail":"($self)","definition":"sub","range":{"start":{"character":0,"line":429},"end":{"character":9999,"line":434}},"kind":12,"line":429,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SequenceFamily.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Cluster::SequenceFamily\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::SequenceFamily - Sequence Family object\n\n=head1 SYNOPSIS\n\n  use Bio::SeqIO;\n  use Bio::Cluster::SequenceFamily;\n  use File::Spec;\n\n  my $file =  File::Spec->catfile('t','data','swiss.dat');\n  my $seqio= Bio::SeqIO->new(-format => 'swiss',\n                            -file => $file);\n  my @mem;\n  while(my $seq = $seqio->next_seq){\n    push @mem, $seq;\n  }\n\n  #create the family\n  my $family = Bio::Cluster::SequenceFamily->new(\n          -family_id=>\"Family_1\",\n          -description=>\"Family Description Here\",\n          -annotation_score=>\"100\",\n          -members=>\\@mem);\n\n  #access the family\n\n  foreach my $mem ($family->get_members){\n    print $mem->display_id.\"\\t\".$mem->desc.\"\\n\";\n  }\n\n  #select members if members have a Bio::Species Object\n\n  my @mem = $family->get_members(-binomial=>\"Homo sapiens\");\n  @mem = $family->get_members(-ncbi_taxid => 9606);\n  @mem = $family->get_members(-common_name=>\"Human\");\n  @mem = $family->get_members(-species=>\"sapiens\");\n  @mem = $family->get_members(-genus=>\"Homo\");\n\n=head1 DESCRIPTION\n\nThis is a simple Family object that may hold any group of object. For more\nspecific families, one should derive from FamilyI.\n\n=head1 FEEDBACK\n\nEmail bioperl-l@bioperl.org for support and feedback.\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::SequenceFamily;\n\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::Cluster::FamilyI);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Cluster::SequenceFamily->new(\n                             -family_id=>\"Family_1\",\n                             -description=>\"Family Description Here\",\n                             -annotation_score=>\"100\",\n                             -members=>\\@mem);\n Function: Constructor for SequenceFamily object\n Returns : Bio::Cluster::SequenceFamily object\n\nSee L<Bio::Cluster::SequenceFamily>.\n\n\nsub new {\n\tmy ($class,@args) = @_;\n  my $self = $class->SUPER::new(@args);\n  my ($id,$description,$version,$annot_score,\n  $family_score,$members) = $self->_rearrange([qw(FAMILY_ID DESCRIPTION VERSION \n                                                   ANNOTATION_SCORE \n                                                   FAMILY_SCORE MEMBERS)],@args);\n  $self->{'_members'} = [];\n  $id && $self->family_id($id);\n  $description && $self->description($description);\n  $version && $self->version($version);\n  $annot_score && $self->annotation_score($annot_score);\n  $family_score && $self->family_score($family_score);\n  $members && $self->add_members($members);\n\n  return $self;\n\n}\n\n=head2 version\n\n Title   : version\n Usage   : $family->version(\"1.0\");\n Function: get/set for version\n Returns : a string version of the family generated. \n\n\nsub version{\n  my ($self,$value) = @_;\n  if($value){\n    $self->{'_version'} =$value;\n  }\n  return $self->{'_version'};\n}\n\n=head2 annotation_score\n\n Title   : annotation_score\n Usage   : $family->annotation_score(100);\n Function: get/set for annotation_score which\n           represent the confidence in which the \n           consensus description has been assigned\n           to the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub annotation_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_annotation_score'} = $score;\n  }\n  return $self->{'_annotation_score'};\n}\n\n=head2 alignment\n\n Title   : alignment\n Usage   : $family->alignment($align);\n Function: get/set for an alignment object representing\n           the multiple alignment of the members of the family.\n Returns : Bio::SimpleAlign\n\nSee L<Bio::SimpleAlign>\n\n\nsub alignment {\n\tmy ($self,$align) = @_;\n  if($align){\n    $self->{'_alignment'} = $align;\n  }\n    return $self->{'_alignment'};\n}\n\n=head2 tree\n\n Title   : tree\n Usage   : $family->tree($tree);\n Function: get/set for an tree object representing\n           the phylogenetic tree of the family. \n Returns : Bio::Tree\n\nSee L<Bio::Tree>\n\n\nsub tree {\n  my ($self,$tree) = @_;\n  if($tree) {\n    $self->{'_tree'} = $tree;\n  }\n  return $self->{'_tree'};\n}\n\n=head1 L<Bio::Cluster::FamilyI> methods\n\n\n=head2 family_score\n\n Title   : family_score\n Usage   : Bio::Cluster::FamilyI->family_score(95);\n Function: get/set for the score of algorithm used to generate\n           the family if present\n\n           This is aliased to cluster_score().\n\n Returns : the score\n Args    : the score\n\n\nsub family_score {\n    return shift->cluster_score(@_);\n}\n\n\n=head2 family_id\n\n Title   : family_id\n Usage   : $family->family_id(\"Family_1\"); \n Function: get/set for family id \n\n           This is aliased to display_id().\n\n Returns : a string specifying identifier of the family \n\n\nsub family_id{\n\treturn shift->display_id(@_);\n}\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n\tmy ($self,$id) = @_;\n\tif($id){\n\t\t$self->{'_cluster_id'} = $id;\n\t}\n\treturn $self->{'_cluster_id'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : $fam->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n\tmy ($self,$desc) = @_;\n\tif($desc){\n\t\t$self->{'_description'} = $desc;\n\t}\n\treturn $self->{'_description'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Valid criteria:\n           -common_name\n           -binomial\n           -ncbi_taxid\n           -organelle\n           -genus\n           $family->get_members(-common_name =>\"human\");\n           $family->get_members(-species     =>\"homo sapiens\");\n           $family->get_members(-ncbi_taxid  => 9606);\n           For now, multiple critieria are ORed.\n\n           Will return all members if no criteria are provided.\n\n Function: get members using methods from L<Bio::Species>\n           the phylogenetic tree of the family.\n Returns : an array of objects that are member of this family. \n\n\nsub get_members {\n\tmy $self = shift;\n\tmy @ret;\n\n\tif(@_) {\n\t\tmy %hash = @_;\n\t\tforeach my $mem ( @{$self->{'_members'}} ) {\n\t\t\tforeach my $key ( keys %hash){\n\t\t\t\tmy $method = $key;\n\t\t\t\t$method=~s/-//g;\n\t\t\t\tif($mem->can('species')){\n\t\t\t\t\tmy $species = $mem->species;\n\t\t\t\t\t$species->can($method) ||\n\t\t\t\t\t  $self->throw(\"$method is an invalid criteria\");\n\t\t\t\t\tif($species->$method() eq $hash{$key} ){\n\t\t\t\t\t\tpush @ret, $mem;\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t\treturn @ret;\n\t}\n\treturn @{$self->{'_members'}};\n}\n\n=head2 size\n\n Title   : size\n Usage   : $fam->size();\n Function: get/set for the size of the family, \n           calculated from the number of members\n Returns : the size of the family \n Args    : \n\n\nsub size {\n  my ($self) = @_;\n\n  return scalar(@{$self->{'_members'}});\n\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $fam->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n Returns : a number\n\n\nsub cluster_score{\n  my ($self,$score) = @_;\n  if($score){\n    $self->{'_cluster_score'} = $score;\n  }\n  return $self->{'_cluster_score'};\n}\n\n\n=head1 Implementation specific methods\n\n  These are mostly for adding/removing/changing.\n\n\n=head2 add_members\n\n Title   : add_members\n Usage   : $fam->add_member([$seq1,$seq1]);\n Function: add members to a family\n Returns : \n Args    : the member(s) to add, as an array or arrayref\n\n\nsub add_members{\n    my ($self,@mems) = @_;\n\n    if (@mems) {\n        my $mem = shift(@mems);\n        if(ref($mem) eq \"ARRAY\"){\n            push @{$self->{'_members'}},@{$mem};\n        } else {\n            push @{$self->{'_members'}},$mem;\n        }\n        push @{$self->{'_members'}}, @mems;\n    }\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   : $fam->remove_members();\n Function: remove all members from a family \n Returns : the previous array of members\n Args    : none","label":"remove_members($self)"}},{"kind":12,"range":{"end":{"line":464,"character":9999},"start":{"character":0,"line":451}},"line":451,"containerName":"main::","name":"members","children":[{"definition":"my","line":452,"localvar":"my","containerName":"members","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"members","line":455},{"name":"warn","kind":12,"containerName":"members","line":455},{"containerName":"members","kind":13,"name":"$self","line":455},{"line":457,"name":"$self","kind":13,"containerName":"members"},{"line":457,"containerName":"members","kind":12,"name":"add_members"},{"kind":13,"containerName":"members","name":"$self","line":460},{"name":"warn","containerName":"members","kind":12,"line":460},{"name":"$self","containerName":"members","kind":13,"line":460},{"containerName":"members","kind":13,"name":"$self","line":462},{"line":462,"name":"get_members","kind":12,"containerName":"members"}],"definition":"sub"}],"version":5}