{"vars":[{"line":74,"name":"vars","containerName":"","kind":2},{"name":"base","kind":2,"containerName":"","line":76},{"line":79,"name":"%DRIVERS","containerName":null,"kind":13},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"new","name":"$class","line":83,"definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":83},{"name":"$self","localvar":"my","kind":13,"containerName":"new","line":84,"definition":"my"},{"line":84,"kind":13,"containerName":"new","name":"$class"},{"containerName":"new","kind":13,"name":"@args","line":84},{"name":"$self","containerName":"new","kind":13,"line":85}],"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"kind":12,"range":{"start":{"line":82,"character":0},"end":{"character":9999,"line":86}},"line":82},{"name":"SUPER","kind":12,"containerName":"new","line":84},{"containerName":"main::","name":"register_driver","children":[{"definition":"my","name":"$self","containerName":"register_driver","localvar":"my","kind":13,"line":104},{"line":104,"kind":13,"containerName":"register_driver","name":"@args"},{"name":"%drivers","localvar":"my","containerName":"register_driver","kind":13,"line":105,"definition":"my"},{"line":105,"name":"@args","kind":13,"containerName":"register_driver"},{"definition":"my","line":107,"name":"$drv","kind":13,"localvar":"my","containerName":"register_driver"},{"name":"%drivers","containerName":"register_driver","kind":13,"line":107},{"name":"$self","kind":13,"containerName":"register_driver","line":109},{"line":109,"kind":12,"containerName":"register_driver","name":"driver_table"},{"name":"$drv","kind":13,"containerName":"register_driver","line":109},{"kind":13,"containerName":"register_driver","name":"$drivers","line":109},{"line":109,"containerName":"register_driver","kind":13,"name":"$drv"}],"detail":"($self,@args)","definition":"sub","range":{"end":{"line":111,"character":9999},"start":{"character":0,"line":103}},"kind":12,"line":103,"signature":{"label":"register_driver($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: DriverFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::DriverFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org> and\n#              Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Jason Stajich, Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::DriverFactory - Base class for factory classes loading drivers\n\n=head1 SYNOPSIS\n\n #this class is not instantiable\n\n=head1 DESCRIPTION\n\nThis a base class for factory classes that load drivers. Normally, you don't\ninstantiate this class directly.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Factory::DriverFactory;\nuse strict;\nuse File::Spec;\n\nuse vars qw(%DRIVERS);\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    %DRIVERS = ();\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n=head2 register_driver\n\n Title   : register_driver\n Usage   : $factory->register_driver(\"genscan\", \"Bio::Tools::Genscan\");\n Function: Registers a driver a factory class should be able to instantiate.\n\n           This method can be called both as an instance and as a class\n           method.\n\n Returns : \n Args    : Key of the driver (string) and the module implementing the driver\n           (string)."}},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","localvar":"my","containerName":"driver_table","kind":13,"name":"$self","line":140},{"name":"@args","kind":13,"containerName":"driver_table","line":140},{"name":"%DRIVERS","containerName":"driver_table","kind":13,"line":142}],"containerName":"main::","name":"driver_table","signature":{"documentation":"1;\n# $Id: DriverFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::DriverFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org> and\n#              Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Jason Stajich, Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::DriverFactory - Base class for factory classes loading drivers\n\n=head1 SYNOPSIS\n\n #this class is not instantiable\n\n=head1 DESCRIPTION\n\nThis a base class for factory classes that load drivers. Normally, you don't\ninstantiate this class directly.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Factory::DriverFactory;\nuse strict;\nuse File::Spec;\n\nuse vars qw(%DRIVERS);\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    %DRIVERS = ();\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n=head2 register_driver\n\n Title   : register_driver\n Usage   : $factory->register_driver(\"genscan\", \"Bio::Tools::Genscan\");\n Function: Registers a driver a factory class should be able to instantiate.\n\n           This method can be called both as an instance and as a class\n           method.\n\n Returns : \n Args    : Key of the driver (string) and the module implementing the driver\n           (string).\n\n\nsub register_driver {\n    my ($self, @args) = @_;\n    my %drivers = @args;\n\n    foreach my $drv (keys(%drivers)) {\n\t# note that this doesn't care whether $self is the class or the object\n\t$self->driver_table()->{$drv} = $drivers{$drv};\n    }\n}\n\n=head2 driver_table\n\n Title   : driver_table\n Usage   : $table = $factory->driver_table();\n Function: Returns a reference to the hash table storing associations of\n           methods with drivers.\n\n           You use this table to look up registered methods (keys) and\n           drivers (values).\n\n           In this implementation the table is class-specific and therefore\n           shared by all instances. You can override this in a derived class,\n           but note that this method can be called both as an instance and a\n           class method.\n\n           This will be the table used by the object internally. You should\n           definitely know what you're doing if you modify the table's\n           contents. Modifications are shared by _all_ instances, those present\n           and those yet to be created.\n\n Returns : A reference to a hash table.\n Args    : ","parameters":[{"label":"$self"},{"label":"@args"}],"label":"driver_table($self,@args)"},"line":139,"range":{"start":{"line":139,"character":0},"end":{"line":143,"character":9999}},"kind":12},{"children":[{"definition":"my","line":158,"containerName":"get_driver","localvar":"my","kind":13,"name":"$self"},{"line":158,"name":"$key","containerName":"get_driver","kind":13},{"line":160,"name":"$self","kind":13,"containerName":"get_driver"},{"line":160,"name":"driver_table","containerName":"get_driver","kind":12},{"line":160,"name":"$key","containerName":"get_driver","kind":13},{"kind":13,"containerName":"get_driver","name":"$self","line":161},{"line":161,"name":"driver_table","kind":12,"containerName":"get_driver"},{"kind":13,"containerName":"get_driver","name":"$key","line":161}],"containerName":"main::","name":"get_driver","definition":"sub","detail":"($self,$key)","line":157,"kind":12,"range":{"start":{"line":157,"character":0},"end":{"character":9999,"line":164}},"signature":{"documentation":"1;\n# $Id: DriverFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::DriverFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org> and\n#              Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Jason Stajich, Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::DriverFactory - Base class for factory classes loading drivers\n\n=head1 SYNOPSIS\n\n #this class is not instantiable\n\n=head1 DESCRIPTION\n\nThis a base class for factory classes that load drivers. Normally, you don't\ninstantiate this class directly.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Factory::DriverFactory;\nuse strict;\nuse File::Spec;\n\nuse vars qw(%DRIVERS);\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    %DRIVERS = ();\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n=head2 register_driver\n\n Title   : register_driver\n Usage   : $factory->register_driver(\"genscan\", \"Bio::Tools::Genscan\");\n Function: Registers a driver a factory class should be able to instantiate.\n\n           This method can be called both as an instance and as a class\n           method.\n\n Returns : \n Args    : Key of the driver (string) and the module implementing the driver\n           (string).\n\n\nsub register_driver {\n    my ($self, @args) = @_;\n    my %drivers = @args;\n\n    foreach my $drv (keys(%drivers)) {\n\t# note that this doesn't care whether $self is the class or the object\n\t$self->driver_table()->{$drv} = $drivers{$drv};\n    }\n}\n\n=head2 driver_table\n\n Title   : driver_table\n Usage   : $table = $factory->driver_table();\n Function: Returns a reference to the hash table storing associations of\n           methods with drivers.\n\n           You use this table to look up registered methods (keys) and\n           drivers (values).\n\n           In this implementation the table is class-specific and therefore\n           shared by all instances. You can override this in a derived class,\n           but note that this method can be called both as an instance and a\n           class method.\n\n           This will be the table used by the object internally. You should\n           definitely know what you're doing if you modify the table's\n           contents. Modifications are shared by _all_ instances, those present\n           and those yet to be created.\n\n Returns : A reference to a hash table.\n Args    : \n\n\n\nsub driver_table {\n    my ($self, @args) = @_;\n\n    return \\%DRIVERS;\n}\n\n=head2 get_driver\n\n Title   : get_driver\n Usage   : $module = $factory->get_driver(\"genscan\");\n Function: Returns the module implementing a driver registered under the\n           given key.\n Example : \n Returns : A string.\n Args    : Key of the driver (string).","parameters":[{"label":"$self"},{"label":"$key"}],"label":"get_driver($self,$key)"}},{"detail":"($self,$name)","definition":"sub","name":"_load_module","containerName":"main::","children":[{"definition":"my","line":178,"localvar":"my","containerName":"_load_module","kind":13,"name":"$self"},{"name":"$name","containerName":"_load_module","kind":13,"line":178},{"localvar":"my","kind":13,"containerName":"_load_module","name":"$module","line":179,"definition":"my"},{"line":179,"name":"$load","kind":13,"containerName":"_load_module"},{"line":179,"name":"$m","kind":13,"containerName":"_load_module"},{"line":180,"name":"$module","kind":13,"containerName":"_load_module"},{"line":181,"name":"$main","kind":13,"containerName":"_load_module"},{"line":181,"name":"$module","kind":13,"containerName":"_load_module"},{"line":182,"kind":13,"containerName":"_load_module","name":"$load"},{"kind":13,"containerName":"_load_module","name":"$load","line":184},{"containerName":"_load_module","kind":12,"name":"catfile","line":184},{"kind":13,"containerName":"_load_module","name":"$load","line":184},{"name":"$load","containerName":"_load_module","kind":13,"line":186},{"name":"$self","containerName":"_load_module","kind":13,"line":189},{"kind":12,"containerName":"_load_module","name":"throw","line":189}],"signature":{"label":"_load_module($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: DriverFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::DriverFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org> and\n#              Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Jason Stajich, Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::DriverFactory - Base class for factory classes loading drivers\n\n=head1 SYNOPSIS\n\n #this class is not instantiable\n\n=head1 DESCRIPTION\n\nThis a base class for factory classes that load drivers. Normally, you don't\ninstantiate this class directly.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail Jason Stajich E<lt>jason@bioperl.orgE<gt>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n#'\npackage Bio::Factory::DriverFactory;\nuse strict;\nuse File::Spec;\n\nuse vars qw(%DRIVERS);\n\nuse base qw(Bio::Root::Root);\n\nBEGIN {\n    %DRIVERS = ();\n}\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    return $self;\n}\n\n=head2 register_driver\n\n Title   : register_driver\n Usage   : $factory->register_driver(\"genscan\", \"Bio::Tools::Genscan\");\n Function: Registers a driver a factory class should be able to instantiate.\n\n           This method can be called both as an instance and as a class\n           method.\n\n Returns : \n Args    : Key of the driver (string) and the module implementing the driver\n           (string).\n\n\nsub register_driver {\n    my ($self, @args) = @_;\n    my %drivers = @args;\n\n    foreach my $drv (keys(%drivers)) {\n\t# note that this doesn't care whether $self is the class or the object\n\t$self->driver_table()->{$drv} = $drivers{$drv};\n    }\n}\n\n=head2 driver_table\n\n Title   : driver_table\n Usage   : $table = $factory->driver_table();\n Function: Returns a reference to the hash table storing associations of\n           methods with drivers.\n\n           You use this table to look up registered methods (keys) and\n           drivers (values).\n\n           In this implementation the table is class-specific and therefore\n           shared by all instances. You can override this in a derived class,\n           but note that this method can be called both as an instance and a\n           class method.\n\n           This will be the table used by the object internally. You should\n           definitely know what you're doing if you modify the table's\n           contents. Modifications are shared by _all_ instances, those present\n           and those yet to be created.\n\n Returns : A reference to a hash table.\n Args    : \n\n\n\nsub driver_table {\n    my ($self, @args) = @_;\n\n    return \\%DRIVERS;\n}\n\n=head2 get_driver\n\n Title   : get_driver\n Usage   : $module = $factory->get_driver(\"genscan\");\n Function: Returns the module implementing a driver registered under the\n           given key.\n Example : \n Returns : A string.\n Args    : Key of the driver (string).\n\n\nsub get_driver {\n    my ($self, $key) = @_;\n\n    if(exists($self->driver_table()->{$key})) {\n\treturn $self->driver_table()->{$key};\n    }\n    return;\n}\n\n=head2 _load_module\n\n Title   : _load_module\n Usage   : $self->_load_module(\"Bio::Tools::Genscan\");\n Function: Loads up (like use) a module at run time on demand.\n Example : \n Returns : TRUE on success\n Args    :"},"kind":12,"range":{"end":{"character":9999,"line":192},"start":{"line":177,"character":0}},"line":177},{"name":"File","kind":12,"containerName":"Spec","line":184}],"version":5}