{"version":5,"vars":[{"containerName":"","kind":2,"name":"Carp","line":77},{"range":{"start":{"line":98,"character":0},"end":{"line":113,"character":9999}},"kind":12,"line":98,"signature":{"documentation":"1;\n# $Id: ChainI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::ChainI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::ChainI - Double linked chain data structure\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis class generates and manipulates generic double linked list, chain,\nthat can be used to manage biological sequences.\n\nThe advantages over strings or plain arrays is the ease of tracking\nchanges (mutations) in the elements (sequence). The other side of the\ncoin is that these structures need consideraly more memory, but that\nis cheap and constantly inceasing resource in computers.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::ChainI;\n\nuse Carp qw(croak);\nuse strict; # this will be moved before when strict enforced in Chain.pm\n\nuse Bio::LiveSeq::Chain; # package where all the subroutines are defined\n\n\n=head2 new\n\n  Title   : new\n  Usage   : $chain = Bio::LiveSeq::ChainI->new(-string => \"thequickbrownfoxjumpsoverthelazydog\",\n\t\t\t\t\t     -offset => 3 );\n         OR $chain = Bio::LiveSeq::ChainI->new(-array => \\@array,\n\t\t\t\t\t     -offset => 3 );\n  Function: generates a new Bio::LiveSeq:ChainI\n  Returns : a new Chain\n  Args    : string\n         OR arrayreference\n        AND optional offset to create element labels","parameters":[{"label":"$thing"},{"label":"%args"}],"label":"new($thing,%args)"},"containerName":"main::","name":"new","children":[{"name":"$thing","localvar":"my","containerName":"new","kind":13,"line":99,"definition":"my"},{"line":99,"name":"%args","kind":13,"containerName":"new"},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$class","line":100},{"containerName":"new","kind":13,"name":"$thing","line":100},{"line":100,"name":"$thing","kind":13,"containerName":"new"},{"definition":"my","name":"$obj","localvar":"my","kind":13,"containerName":"new","line":101},{"line":103,"name":"$args","containerName":"new","kind":13},{"name":"$obj","kind":13,"containerName":"new","line":104},{"line":104,"kind":13,"containerName":"new","name":"$thing"},{"line":104,"name":"string2chain","containerName":"new","kind":12},{"line":104,"name":"$args","containerName":"new","kind":13},{"line":104,"kind":13,"containerName":"new","name":"$args"},{"line":105,"name":"$args","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$obj","line":106},{"line":106,"name":"$thing","containerName":"new","kind":13},{"line":106,"name":"array2chain","containerName":"new","kind":12},{"name":"$args","containerName":"new","kind":13,"line":106},{"line":106,"name":"$args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$obj","line":111},{"name":"$obj","kind":13,"containerName":"new","line":111},{"name":"$class","containerName":"new","kind":13,"line":111},{"line":112,"name":"$obj","containerName":"new","kind":13}],"detail":"($thing,%args)","definition":"sub"},{"line":99,"name":"Chain","containerName":"strict::Bio::LiveSeq","kind":2},{"kind":12,"name":"croak","line":108},{"children":[],"containerName":"main::","name":"string2chain","definition":"sub","line":116,"kind":12,"range":{"start":{"line":116,"character":0},"end":{"character":9999,"line":119}}},{"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::string2chain","line":118},{"kind":12,"range":{"start":{"line":120,"character":0},"end":{"character":9999,"line":123}},"line":120,"containerName":"main::","name":"array2chain","children":[],"definition":"sub"},{"containerName":"LiveSeq::Chain::array2chain","kind":12,"name":"Bio","line":122},{"line":125,"kind":12,"range":{"end":{"character":9999,"line":127},"start":{"line":125,"character":0}},"children":[],"containerName":"main::","name":"chain2string","definition":"sub"},{"kind":12,"name":"croak","line":126},{"kind":12,"range":{"end":{"character":9999,"line":130},"start":{"character":0,"line":128}},"line":128,"definition":"sub","containerName":"main::","name":"down_chain2string","children":[]},{"line":129,"containerName":"LiveSeq::Chain::down_chain2string","kind":12,"name":"Bio"},{"containerName":"main::","name":"up_chain2string","children":[],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":133},"start":{"character":0,"line":131}},"line":131},{"line":132,"kind":12,"containerName":"LiveSeq::Chain::up_chain2string","name":"Bio"},{"kind":12,"range":{"end":{"line":136,"character":9999},"start":{"line":134,"character":0}},"line":134,"definition":"sub","name":"chain2string_verbose","containerName":"main::","children":[]},{"line":135,"kind":12,"name":"croak"},{"line":137,"kind":12,"range":{"start":{"line":137,"character":0},"end":{"line":139,"character":9999}},"children":[],"containerName":"main::","name":"down_chain2string_verbose","definition":"sub"},{"containerName":"LiveSeq::Chain::down_chain2string_verbose","kind":12,"name":"Bio","line":138},{"containerName":"main::","name":"up_chain2string_verbose","children":[],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":142},"start":{"line":140,"character":0}},"line":140},{"containerName":"LiveSeq::Chain::up_chain2string_verbose","kind":12,"name":"Bio","line":141},{"line":143,"kind":12,"range":{"end":{"character":9999,"line":145},"start":{"character":0,"line":143}},"definition":"sub","children":[],"containerName":"main::","name":"invert_chain"},{"containerName":"LiveSeq::Chain::invert_chain","kind":12,"name":"Bio","line":144},{"containerName":"main::","name":"mutate_element","children":[],"definition":"sub","kind":12,"range":{"end":{"line":148,"character":9999},"start":{"line":146,"character":0}},"line":146},{"line":147,"name":"croak","kind":12},{"line":151,"kind":12,"range":{"start":{"character":0,"line":151},"end":{"character":9999,"line":153}},"children":[],"name":"down_labels","containerName":"main::","definition":"sub"},{"line":152,"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::down_labels"},{"line":154,"kind":12,"range":{"end":{"character":9999,"line":156},"start":{"character":0,"line":154}},"definition":"sub","children":[],"name":"up_labels","containerName":"main::"},{"line":155,"kind":12,"containerName":"LiveSeq::Chain::up_labels","name":"Bio"},{"definition":"sub","name":"start","containerName":"main::","children":[],"range":{"end":{"line":160,"character":9999},"start":{"character":0,"line":158}},"kind":12,"line":158},{"line":159,"name":"Bio","containerName":"LiveSeq::Chain::start","kind":12},{"kind":12,"range":{"start":{"line":161,"character":0},"end":{"line":163,"character":9999}},"line":161,"definition":"sub","name":"end","containerName":"main::","children":[]},{"containerName":"LiveSeq::Chain::end","kind":12,"name":"Bio","line":162},{"definition":"sub","children":[],"containerName":"main::","name":"label_exists","line":164,"range":{"start":{"character":0,"line":164},"end":{"line":166,"character":9999}},"kind":12},{"line":165,"name":"Bio","containerName":"LiveSeq::Chain::label_exists","kind":12},{"children":[],"containerName":"main::","name":"get_value_at_pos","definition":"sub","line":168,"range":{"end":{"line":170,"character":9999},"start":{"line":168,"character":0}},"kind":12},{"name":"croak","kind":12,"line":169},{"name":"down_get_value_at_pos","containerName":"main::","children":[],"definition":"sub","kind":12,"range":{"start":{"line":171,"character":0},"end":{"line":173,"character":9999}},"line":171},{"name":"Bio","containerName":"LiveSeq::Chain::down_get_value_at_pos","kind":12,"line":172},{"line":174,"kind":12,"range":{"end":{"line":176,"character":9999},"start":{"line":174,"character":0}},"children":[],"name":"up_get_value_at_pos","containerName":"main::","definition":"sub"},{"line":175,"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::up_get_value_at_pos"},{"definition":"sub","children":[],"name":"set_value_at_pos","containerName":"main::","line":177,"kind":12,"range":{"start":{"character":0,"line":177},"end":{"line":179,"character":9999}}},{"kind":12,"name":"croak","line":178},{"line":180,"range":{"end":{"line":182,"character":9999},"start":{"character":0,"line":180}},"kind":12,"definition":"sub","children":[],"containerName":"main::","name":"down_set_value_at_pos"},{"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::down_set_value_at_pos","line":181},{"range":{"start":{"character":0,"line":183},"end":{"line":185,"character":9999}},"kind":12,"line":183,"containerName":"main::","name":"up_set_value_at_pos","children":[],"definition":"sub"},{"kind":12,"containerName":"LiveSeq::Chain::up_set_value_at_pos","name":"Bio","line":184},{"definition":"sub","children":[],"name":"get_value_at_label","containerName":"main::","line":186,"range":{"start":{"character":0,"line":186},"end":{"line":188,"character":9999}},"kind":12},{"kind":12,"containerName":"LiveSeq::Chain::get_value_at_label","name":"Bio","line":187},{"kind":12,"range":{"end":{"line":191,"character":9999},"start":{"character":0,"line":189}},"line":189,"definition":"sub","containerName":"main::","name":"set_value_at_label","children":[]},{"line":190,"name":"Bio","containerName":"LiveSeq::Chain::set_value_at_label","kind":12},{"children":[],"name":"get_label_at_pos","containerName":"main::","definition":"sub","line":192,"kind":12,"range":{"end":{"line":194,"character":9999},"start":{"line":192,"character":0}}},{"kind":12,"name":"croak","line":193},{"children":[],"containerName":"main::","name":"up_get_label_at_pos","definition":"sub","line":195,"range":{"start":{"line":195,"character":0},"end":{"character":9999,"line":197}},"kind":12},{"line":196,"name":"Bio","containerName":"LiveSeq::Chain::up_get_label_at_pos","kind":12},{"containerName":"main::","name":"down_get_label_at_pos","children":[],"definition":"sub","range":{"start":{"character":0,"line":198},"end":{"line":200,"character":9999}},"kind":12,"line":198},{"containerName":"LiveSeq::Chain::down_get_label_at_pos","kind":12,"name":"Bio","line":199},{"range":{"end":{"character":9999,"line":203},"start":{"character":0,"line":201}},"kind":12,"line":201,"containerName":"main::","name":"get_pos_of_label","children":[],"definition":"sub"},{"name":"croak","kind":12,"line":202},{"line":204,"kind":12,"range":{"end":{"line":206,"character":9999},"start":{"line":204,"character":0}},"children":[],"containerName":"main::","name":"up_get_pos_of_label","definition":"sub"},{"line":205,"kind":12,"containerName":"LiveSeq::Chain::up_get_pos_of_label","name":"Bio"},{"definition":"sub","name":"down_get_pos_of_label","containerName":"main::","children":[],"range":{"start":{"line":207,"character":0},"end":{"character":9999,"line":209}},"kind":12,"line":207},{"line":208,"containerName":"LiveSeq::Chain::down_get_pos_of_label","kind":12,"name":"Bio"},{"definition":"sub","name":"preinsert_string","containerName":"main::","children":[],"kind":12,"range":{"start":{"character":0,"line":212},"end":{"character":9999,"line":214}},"line":212},{"kind":12,"containerName":"LiveSeq::Chain::praeinsert_string","name":"Bio","line":213},{"line":215,"range":{"end":{"character":9999,"line":217},"start":{"character":0,"line":215}},"kind":12,"children":[],"name":"preinsert_array","containerName":"main::","definition":"sub"},{"containerName":"LiveSeq::Chain::praeinsert_array","kind":12,"name":"Bio","line":216},{"line":218,"range":{"start":{"character":0,"line":218},"end":{"character":9999,"line":220}},"kind":12,"definition":"sub","children":[],"containerName":"main::","name":"praeinsert_string"},{"line":219,"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::praeinsert_string"},{"children":[],"containerName":"main::","name":"postinsert_string","definition":"sub","line":221,"kind":12,"range":{"end":{"character":9999,"line":223},"start":{"line":221,"character":0}}},{"kind":12,"containerName":"LiveSeq::Chain::postinsert_string","name":"Bio","line":222},{"kind":12,"range":{"start":{"line":224,"character":0},"end":{"line":226,"character":9999}},"line":224,"containerName":"main::","name":"praeinsert_array","children":[],"definition":"sub"},{"containerName":"LiveSeq::Chain::praeinsert_array","kind":12,"name":"Bio","line":225},{"range":{"start":{"line":227,"character":0},"end":{"character":9999,"line":229}},"kind":12,"line":227,"definition":"sub","name":"postinsert_array","containerName":"main::","children":[]},{"kind":12,"containerName":"LiveSeq::Chain::postinsert_array","name":"Bio","line":228},{"definition":"sub","containerName":"main::","name":"down_element","children":[],"range":{"start":{"line":230,"character":0},"end":{"character":9999,"line":232}},"kind":12,"line":230},{"name":"Bio","containerName":"LiveSeq::Chain::down_element","kind":12,"line":231},{"line":233,"range":{"end":{"character":9999,"line":235},"start":{"line":233,"character":0}},"kind":12,"definition":"sub","children":[],"name":"up_element","containerName":"main::"},{"line":234,"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::up_element"},{"kind":12,"range":{"start":{"character":0,"line":236},"end":{"character":9999,"line":238}},"line":236,"name":"is_downstream","containerName":"main::","children":[],"definition":"sub"},{"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::is_downstream","line":237},{"line":239,"kind":12,"range":{"end":{"character":9999,"line":241},"start":{"line":239,"character":0}},"definition":"sub","children":[],"containerName":"main::","name":"is_upstream"},{"kind":12,"containerName":"LiveSeq::Chain::is_upstream","name":"Bio","line":240},{"definition":"sub","children":[],"containerName":"main::","name":"check_chain","line":242,"range":{"end":{"line":244,"character":9999},"start":{"character":0,"line":242}},"kind":12},{"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::check_chain","line":243},{"range":{"start":{"line":245,"character":0},"end":{"character":9999,"line":247}},"kind":12,"line":245,"containerName":"main::","name":"chain_length","children":[],"definition":"sub"},{"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::chain_length","line":246},{"name":"splice_chain","containerName":"main::","children":[],"definition":"sub","range":{"start":{"character":0,"line":248},"end":{"line":250,"character":9999}},"kind":12,"line":248},{"line":249,"containerName":"LiveSeq::Chain::splice_chain","kind":12,"name":"Bio"},{"name":"pos_of_element","containerName":"main::","children":[],"definition":"sub","range":{"start":{"line":251,"character":0},"end":{"character":9999,"line":253}},"kind":12,"line":251},{"kind":12,"name":"croak","line":252},{"definition":"sub","containerName":"main::","name":"up_pos_of_element","children":[],"kind":12,"range":{"start":{"character":0,"line":254},"end":{"character":9999,"line":257}},"line":254},{"line":255,"name":"croak","kind":12},{"containerName":"LiveSeq::Chain::up_pos_of_element","kind":12,"name":"Bio","line":256},{"line":258,"kind":12,"range":{"end":{"character":9999,"line":261},"start":{"line":258,"character":0}},"children":[],"containerName":"main::","name":"down_pos_of_element","definition":"sub"},{"line":259,"name":"croak","kind":12},{"containerName":"LiveSeq::Chain::down_pos_of_element","kind":12,"name":"Bio","line":260},{"line":262,"range":{"start":{"line":262,"character":0},"end":{"character":9999,"line":264}},"kind":12,"definition":"sub","children":[],"containerName":"main::","name":"subchain_length"},{"line":263,"kind":12,"name":"croak"},{"containerName":"main::","name":"down_subchain_length","children":[],"definition":"sub","range":{"start":{"line":265,"character":0},"end":{"character":9999,"line":267}},"kind":12,"line":265},{"name":"Bio","containerName":"LiveSeq::Chain::down_subchain_length","kind":12,"line":266},{"line":268,"range":{"start":{"character":0,"line":268},"end":{"character":9999,"line":270}},"kind":12,"children":[],"name":"up_subchain_length","containerName":"main::","definition":"sub"},{"line":269,"name":"Bio","kind":12,"containerName":"LiveSeq::Chain::up_subchain_length"},{"kind":12,"range":{"start":{"line":273,"character":0},"end":{"character":9999,"line":275}},"line":273,"definition":"sub","containerName":"main::","name":"elements","children":[]},{"line":274,"name":"Bio","containerName":"LiveSeq::Chain::down_elements","kind":12},{"name":"up_elements","containerName":"main::","children":[],"definition":"sub","range":{"start":{"character":0,"line":276},"end":{"line":278,"character":9999}},"kind":12,"line":276},{"name":"Bio","containerName":"LiveSeq::Chain::up_elements","kind":12,"line":277},{"definition":"sub","containerName":"main::","name":"down_elements","children":[],"kind":12,"range":{"end":{"character":9999,"line":281},"start":{"line":279,"character":0}},"line":279},{"containerName":"LiveSeq::Chain::down_elements","kind":12,"name":"Bio","line":280}]}