{"vars":[{"line":84,"containerName":"","kind":2,"name":"base"},{"line":86,"name":"%RANGEENCODE","containerName":"main::","kind":13,"definition":"our"},{"definition":"our","line":89,"name":"%RANGEDECODE","containerName":"main::","kind":13},{"line":92,"kind":12,"range":{"start":{"line":92,"character":0},"end":{"character":9999,"line":101}},"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":""},"children":[{"definition":"my","name":"$class","kind":13,"localvar":"my","containerName":"new","line":93},{"line":93,"name":"@args","containerName":"new","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":94},{"line":94,"name":"$class","containerName":"new","kind":13},{"line":94,"name":"@args","containerName":"new","kind":13},{"line":96,"kind":13,"localvar":"my","containerName":"new","name":"$locationtype","definition":"my"},{"line":96,"containerName":"new","kind":13,"name":"$self"},{"line":96,"kind":12,"containerName":"new","name":"_rearrange"},{"line":96,"name":"@args","containerName":"new","kind":13},{"line":98,"name":"$locationtype","kind":13,"containerName":"new"},{"line":98,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"location_type","line":98},{"kind":13,"containerName":"new","name":"$locationtype","line":98},{"line":100,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"line":94,"name":"SUPER","kind":12,"containerName":"new"},{"name":"start","containerName":"main::","children":[{"line":115,"name":"$self","kind":13,"localvar":"my","containerName":"start","definition":"my"},{"line":115,"name":"$value","containerName":"start","kind":13},{"kind":13,"containerName":"start","name":"$self","line":116},{"line":116,"containerName":"start","kind":13,"name":"$value"},{"name":"$value","kind":13,"containerName":"start","line":116},{"line":118,"containerName":"start","kind":13,"name":"$self"},{"containerName":"start","kind":12,"name":"throw","line":118},{"name":"$self","containerName":"start","kind":13,"line":119},{"line":120,"containerName":"start","kind":13,"name":"$self"},{"line":121,"name":"$self","kind":13,"containerName":"start"},{"containerName":"start","kind":13,"name":"$self","line":121},{"name":"$self","kind":13,"containerName":"start","line":122},{"line":122,"kind":12,"containerName":"start","name":"location_type"},{"name":"$self","kind":13,"containerName":"start","line":123},{"name":"$self","kind":13,"containerName":"start","line":123},{"line":124,"name":"$self","containerName":"start","kind":13}],"detail":"($self,$value)","definition":"sub","range":{"start":{"character":0,"line":114},"end":{"character":9999,"line":125}},"kind":12,"line":114,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Simple.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Simple\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Simple - Implementation of a Simple Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Simple;\n\n    my $location = Bio::Location::Simple->new(-start => 1, -end => 100,\n                         -strand => 1 );\n\n    if( $location->strand == -1 ) {\n    printf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n    printf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage exact location\ninformation on a Sequence: '22' or '12..15' or '16^17'.\n\nYou can test the type of the location using length() function () or\ndirectly location_type() which can one of two values: 'EXACT' or\n'IN-BETWEEN'.\n\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Simple;\nuse strict;\n\nuse base qw(Bio::Location::Atomic);\n\nour %RANGEENCODE  = ('\\.\\.' => 'EXACT',\n             '\\^'   => 'IN-BETWEEN' );\n\nour %RANGEDECODE  = ('EXACT'      => '..',\n             'IN-BETWEEN' => '^' );\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($locationtype) = $self->_rearrange([qw(LOCATION_TYPE)],@args);\n\n    $locationtype && $self->location_type($locationtype);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)","label":"start($self,$value)"}},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"end","name":"$self","line":144},{"name":"$value","kind":13,"containerName":"end","line":144},{"name":"$self","containerName":"end","kind":13,"line":146},{"line":146,"kind":13,"containerName":"end","name":"$value"},{"containerName":"end","kind":13,"name":"$value","line":146},{"name":"$self","containerName":"end","kind":13,"line":149},{"name":"$self","kind":13,"containerName":"end","line":150},{"kind":13,"containerName":"end","name":"$self","line":151},{"line":151,"kind":12,"containerName":"end","name":"warn"},{"line":154,"name":"$self","containerName":"end","kind":13},{"line":154,"name":"warn","kind":12,"containerName":"end"},{"kind":13,"containerName":"end","name":"$self","line":155},{"name":"$self","containerName":"end","kind":13,"line":155},{"line":157,"name":"$self","kind":13,"containerName":"end"},{"line":157,"containerName":"end","kind":12,"name":"throw"},{"containerName":"end","kind":13,"name":"$self","line":158},{"line":159,"name":"$self","kind":13,"containerName":"end"},{"line":160,"name":"$self","containerName":"end","kind":13},{"name":"$self","containerName":"end","kind":13,"line":160},{"containerName":"end","kind":13,"name":"$self","line":161},{"line":161,"kind":12,"containerName":"end","name":"location_type"},{"line":162,"name":"$self","containerName":"end","kind":13},{"line":162,"name":"$self","containerName":"end","kind":13},{"line":164,"name":"$self","containerName":"end","kind":13}],"containerName":"main::","name":"end","signature":{"label":"end($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Simple.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Simple\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Simple - Implementation of a Simple Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Simple;\n\n    my $location = Bio::Location::Simple->new(-start => 1, -end => 100,\n                         -strand => 1 );\n\n    if( $location->strand == -1 ) {\n    printf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n    printf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage exact location\ninformation on a Sequence: '22' or '12..15' or '16^17'.\n\nYou can test the type of the location using length() function () or\ndirectly location_type() which can one of two values: 'EXACT' or\n'IN-BETWEEN'.\n\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Simple;\nuse strict;\n\nuse base qw(Bio::Location::Atomic);\n\nour %RANGEENCODE  = ('\\.\\.' => 'EXACT',\n             '\\^'   => 'IN-BETWEEN' );\n\nour %RANGEDECODE  = ('EXACT'      => '..',\n             'IN-BETWEEN' => '^' );\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($locationtype) = $self->_rearrange([qw(LOCATION_TYPE)],@args);\n\n    $locationtype && $self->location_type($locationtype);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n    $self->{'_start'} = $value if defined $value ;\n  \n    $self->throw(\"Only adjacent residues when location type \".\n             \"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n             $self->{'_end'}. \"]\" )\n        if defined $self->{'_start'} && defined $self->{'_end'} && \n        $self->location_type eq 'IN-BETWEEN' &&\n        ($self->{'_end'} - 1 != $self->{'_start'});\n    return $self->{'_start'};\n}\n\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n  Note    : If start is set but end is undefined, this now assumes that start\n\t\t    is the same as end but throws a warning (i.e. it assumes this is\n\t\t\ta possible error). If start is undefined, this now throws an\n\t\t\texception."},"line":143,"range":{"start":{"character":0,"line":143},"end":{"line":165,"character":9999}},"kind":12},{"name":"length","containerName":"main::","children":[{"definition":"my","containerName":"length","localvar":"my","kind":13,"name":"$self","line":190},{"line":191,"containerName":"length","kind":13,"name":"$self"},{"line":191,"name":"location_type","containerName":"length","kind":12},{"line":194,"name":"$self","kind":13,"containerName":"length"},{"name":"end","containerName":"length","kind":12,"line":194},{"line":194,"name":"$self","containerName":"length","kind":13},{"line":194,"name":"start","kind":12,"containerName":"length"}],"detail":"($self)","definition":"sub","range":{"start":{"character":0,"line":189},"end":{"character":9999,"line":197}},"kind":12,"line":189,"signature":{"label":"length($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Simple.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Simple\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Simple - Implementation of a Simple Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Simple;\n\n    my $location = Bio::Location::Simple->new(-start => 1, -end => 100,\n                         -strand => 1 );\n\n    if( $location->strand == -1 ) {\n    printf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n    printf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage exact location\ninformation on a Sequence: '22' or '12..15' or '16^17'.\n\nYou can test the type of the location using length() function () or\ndirectly location_type() which can one of two values: 'EXACT' or\n'IN-BETWEEN'.\n\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Simple;\nuse strict;\n\nuse base qw(Bio::Location::Atomic);\n\nour %RANGEENCODE  = ('\\.\\.' => 'EXACT',\n             '\\^'   => 'IN-BETWEEN' );\n\nour %RANGEDECODE  = ('EXACT'      => '..',\n             'IN-BETWEEN' => '^' );\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($locationtype) = $self->_rearrange([qw(LOCATION_TYPE)],@args);\n\n    $locationtype && $self->location_type($locationtype);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n    $self->{'_start'} = $value if defined $value ;\n  \n    $self->throw(\"Only adjacent residues when location type \".\n             \"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n             $self->{'_end'}. \"]\" )\n        if defined $self->{'_start'} && defined $self->{'_end'} && \n        $self->location_type eq 'IN-BETWEEN' &&\n        ($self->{'_end'} - 1 != $self->{'_start'});\n    return $self->{'_start'};\n}\n\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n  Note    : If start is set but end is undefined, this now assumes that start\n\t\t    is the same as end but throws a warning (i.e. it assumes this is\n\t\t\ta possible error). If start is undefined, this now throws an\n\t\t\texception.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n  \n\t$self->{'_end'} = $value if defined $value ;\n\t\n\t#assume end is the same as start if not defined\n\tif (!defined $self->{'_end'}) {\n\t\tif (!defined $self->{'_start'}) {\n\t\t\t$self->warn('Calling end without a defined start position');\n\t\t\treturn;\n\t\t}\n\t\t$self->warn('Setting start equal to end');\n\t\t$self->{'_end'} = $self->{'_start'};\n\t}\n\t$self->throw(\"Only adjacent residues when location type \".\n\t\t\t\"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n\t\t\t $self->{'_end'}. \"]\" )\n\t\tif defined $self->{'_start'} && defined $self->{'_end'} && \n\t\t$self->location_type eq 'IN-BETWEEN' &&\n\t\t($self->{'_end'} - 1 != $self->{'_start'});\n  \n\treturn $self->{'_end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none"}},{"kind":12,"range":{"start":{"line":280,"character":0},"end":{"line":304,"character":9999}},"line":280,"signature":{"label":"location_type($self,$value)","documentation":"1;\n# $Id: Simple.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Simple\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Simple - Implementation of a Simple Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Simple;\n\n    my $location = Bio::Location::Simple->new(-start => 1, -end => 100,\n                         -strand => 1 );\n\n    if( $location->strand == -1 ) {\n    printf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n    printf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage exact location\ninformation on a Sequence: '22' or '12..15' or '16^17'.\n\nYou can test the type of the location using length() function () or\ndirectly location_type() which can one of two values: 'EXACT' or\n'IN-BETWEEN'.\n\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Simple;\nuse strict;\n\nuse base qw(Bio::Location::Atomic);\n\nour %RANGEENCODE  = ('\\.\\.' => 'EXACT',\n             '\\^'   => 'IN-BETWEEN' );\n\nour %RANGEDECODE  = ('EXACT'      => '..',\n             'IN-BETWEEN' => '^' );\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($locationtype) = $self->_rearrange([qw(LOCATION_TYPE)],@args);\n\n    $locationtype && $self->location_type($locationtype);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n    $self->{'_start'} = $value if defined $value ;\n  \n    $self->throw(\"Only adjacent residues when location type \".\n             \"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n             $self->{'_end'}. \"]\" )\n        if defined $self->{'_start'} && defined $self->{'_end'} && \n        $self->location_type eq 'IN-BETWEEN' &&\n        ($self->{'_end'} - 1 != $self->{'_start'});\n    return $self->{'_start'};\n}\n\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n  Note    : If start is set but end is undefined, this now assumes that start\n\t\t    is the same as end but throws a warning (i.e. it assumes this is\n\t\t\ta possible error). If start is undefined, this now throws an\n\t\t\texception.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n  \n\t$self->{'_end'} = $value if defined $value ;\n\t\n\t#assume end is the same as start if not defined\n\tif (!defined $self->{'_end'}) {\n\t\tif (!defined $self->{'_start'}) {\n\t\t\t$self->warn('Calling end without a defined start position');\n\t\t\treturn;\n\t\t}\n\t\t$self->warn('Setting start equal to end');\n\t\t$self->{'_end'} = $self->{'_start'};\n\t}\n\t$self->throw(\"Only adjacent residues when location type \".\n\t\t\t\"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n\t\t\t $self->{'_end'}. \"]\" )\n\t\tif defined $self->{'_start'} && defined $self->{'_end'} && \n\t\t$self->location_type eq 'IN-BETWEEN' &&\n\t\t($self->{'_end'} - 1 != $self->{'_start'});\n  \n\treturn $self->{'_end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\nsub length {\n   my ($self) = @_;\n   if ($self->location_type eq 'IN-BETWEEN' ) {\n       return 0;\n   } else {\n       return abs($self->end - $self->start) + 1;\n   }\n\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT' or 'IN-BETWEEN')\n  Args    : 'EXACT' or '..' or 'IN-BETWEEN' or '^'","parameters":[{"label":"$self"},{"label":"$value"}]},"name":"location_type","containerName":"main::","children":[{"line":281,"name":"$self","localvar":"my","containerName":"location_type","kind":13,"definition":"my"},{"line":281,"name":"$value","containerName":"location_type","kind":13},{"line":283,"name":"$value","kind":13,"containerName":"location_type"},{"containerName":"location_type","kind":13,"name":"$self","line":283},{"line":284,"name":"$value","kind":13,"containerName":"location_type"},{"kind":13,"containerName":"location_type","name":"$value","line":284},{"line":285,"name":"$value","containerName":"location_type","kind":13},{"kind":13,"containerName":"location_type","name":"$value","line":285},{"line":286,"name":"$RANGEDECODE","containerName":"location_type","kind":13},{"name":"$value","containerName":"location_type","kind":13,"line":286},{"line":287,"name":"$value","containerName":"location_type","kind":13},{"kind":13,"containerName":"location_type","name":"$value","line":287},{"line":288,"name":"$value","kind":13,"containerName":"location_type"},{"kind":13,"containerName":"location_type","name":"$value","line":288},{"containerName":"location_type","kind":13,"name":"$value","line":289},{"line":289,"kind":13,"containerName":"location_type","name":"$RANGEENCODE"},{"line":289,"name":"$value","kind":13,"containerName":"location_type"},{"line":291,"kind":13,"containerName":"location_type","name":"$self"},{"line":291,"name":"throw","containerName":"location_type","kind":12},{"line":292,"name":"$value","kind":13,"containerName":"location_type"},{"line":293,"name":"$self","kind":13,"containerName":"location_type"},{"name":"$value","containerName":"location_type","kind":13,"line":293},{"kind":13,"containerName":"location_type","name":"$self","line":295},{"line":295,"name":"throw","kind":12,"containerName":"location_type"},{"line":296,"name":"$self","kind":13,"containerName":"location_type"},{"name":"$self","containerName":"location_type","kind":13,"line":297},{"line":298,"containerName":"location_type","kind":13,"name":"$self"},{"kind":13,"containerName":"location_type","name":"$self","line":299},{"line":300,"name":"$self","containerName":"location_type","kind":13},{"line":301,"containerName":"location_type","kind":13,"name":"$self"},{"line":301,"name":"$self","kind":13,"containerName":"location_type"},{"containerName":"location_type","kind":13,"name":"$self","line":303}],"detail":"($self,$value)","definition":"sub"},{"line":327,"range":{"end":{"character":9999,"line":344},"start":{"character":0,"line":327}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Simple.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Simple\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Simple - Implementation of a Simple Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Simple;\n\n    my $location = Bio::Location::Simple->new(-start => 1, -end => 100,\n                         -strand => 1 );\n\n    if( $location->strand == -1 ) {\n    printf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n    printf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage exact location\ninformation on a Sequence: '22' or '12..15' or '16^17'.\n\nYou can test the type of the location using length() function () or\ndirectly location_type() which can one of two values: 'EXACT' or\n'IN-BETWEEN'.\n\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Simple;\nuse strict;\n\nuse base qw(Bio::Location::Atomic);\n\nour %RANGEENCODE  = ('\\.\\.' => 'EXACT',\n             '\\^'   => 'IN-BETWEEN' );\n\nour %RANGEDECODE  = ('EXACT'      => '..',\n             'IN-BETWEEN' => '^' );\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($locationtype) = $self->_rearrange([qw(LOCATION_TYPE)],@args);\n\n    $locationtype && $self->location_type($locationtype);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n    $self->{'_start'} = $value if defined $value ;\n  \n    $self->throw(\"Only adjacent residues when location type \".\n             \"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n             $self->{'_end'}. \"]\" )\n        if defined $self->{'_start'} && defined $self->{'_end'} && \n        $self->location_type eq 'IN-BETWEEN' &&\n        ($self->{'_end'} - 1 != $self->{'_start'});\n    return $self->{'_start'};\n}\n\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n  Note    : If start is set but end is undefined, this now assumes that start\n\t\t    is the same as end but throws a warning (i.e. it assumes this is\n\t\t\ta possible error). If start is undefined, this now throws an\n\t\t\texception.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n  \n\t$self->{'_end'} = $value if defined $value ;\n\t\n\t#assume end is the same as start if not defined\n\tif (!defined $self->{'_end'}) {\n\t\tif (!defined $self->{'_start'}) {\n\t\t\t$self->warn('Calling end without a defined start position');\n\t\t\treturn;\n\t\t}\n\t\t$self->warn('Setting start equal to end');\n\t\t$self->{'_end'} = $self->{'_start'};\n\t}\n\t$self->throw(\"Only adjacent residues when location type \".\n\t\t\t\"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n\t\t\t $self->{'_end'}. \"]\" )\n\t\tif defined $self->{'_start'} && defined $self->{'_end'} && \n\t\t$self->location_type eq 'IN-BETWEEN' &&\n\t\t($self->{'_end'} - 1 != $self->{'_start'});\n  \n\treturn $self->{'_end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\nsub length {\n   my ($self) = @_;\n   if ($self->location_type eq 'IN-BETWEEN' ) {\n       return 0;\n   } else {\n       return abs($self->end - $self->start) + 1;\n   }\n\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT' or 'IN-BETWEEN')\n  Args    : 'EXACT' or '..' or 'IN-BETWEEN' or '^'\n\n\nsub location_type {\n    my ($self, $value) = @_;\n\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n    $value = 'EXACT' unless defined $value;\n    $value = uc $value;\n    if (! defined $RANGEDECODE{$value}) {\n        $value = '\\^' if $value eq '^';\n        $value = '\\.\\.' if $value eq '..';\n        $value = $RANGEENCODE{$value};\n    }\n    $self->throw(\"Did not specify a valid location type. [$value] is no good\")\n        unless defined $value;\n    $self->{'_location_type'} = $value;\n    }\n    $self->throw(\"Only adjacent residues when location type \".\n         \"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n         $self->{'_end'}. \"]\" )\n    if $self->{'_location_type'} eq 'IN-BETWEEN' &&\n        defined $self->{'_start'} &&\n        defined $self->{'_end'} &&\n            ($self->{'_end'} - 1 != $self->{'_start'});\n\n    return $self->{'_location_type'};\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $self->is_remote($newval)\n Function: Getset for is_remote value\n Returns : value of is_remote\n Args    : newvalue (optional)\n\n\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none","label":"to_FTstring($self)"},"children":[{"definition":"my","containerName":"to_FTstring","localvar":"my","kind":13,"name":"$self","line":328},{"line":330,"name":"$str","localvar":"my","containerName":"to_FTstring","kind":13,"definition":"my"},{"line":331,"name":"$self","kind":13,"containerName":"to_FTstring"},{"line":331,"name":"start","containerName":"to_FTstring","kind":12},{"kind":13,"containerName":"to_FTstring","name":"$self","line":331},{"line":331,"kind":12,"containerName":"to_FTstring","name":"end"},{"line":332,"containerName":"to_FTstring","kind":13,"name":"$str"},{"line":332,"name":"$self","containerName":"to_FTstring","kind":13},{"name":"start","containerName":"to_FTstring","kind":12,"line":332},{"kind":13,"containerName":"to_FTstring","name":"$str","line":334},{"kind":13,"containerName":"to_FTstring","name":"$self","line":334},{"line":334,"kind":12,"containerName":"to_FTstring","name":"start"},{"line":334,"name":"$RANGEDECODE","containerName":"to_FTstring","kind":13},{"name":"$self","containerName":"to_FTstring","kind":13,"line":334},{"line":334,"name":"location_type","containerName":"to_FTstring","kind":12},{"kind":13,"containerName":"to_FTstring","name":"$self","line":334},{"name":"end","kind":12,"containerName":"to_FTstring","line":334},{"line":336,"containerName":"to_FTstring","kind":13,"name":"$self"},{"line":336,"kind":12,"containerName":"to_FTstring","name":"is_remote"},{"line":336,"kind":13,"containerName":"to_FTstring","name":"$self"},{"line":336,"containerName":"to_FTstring","kind":12,"name":"seq_id"},{"kind":13,"containerName":"to_FTstring","name":"$str","line":337},{"line":337,"kind":13,"containerName":"to_FTstring","name":"$self"},{"kind":12,"containerName":"to_FTstring","name":"seq_id","line":337},{"name":"$str","kind":13,"containerName":"to_FTstring","line":337},{"line":339,"kind":13,"containerName":"to_FTstring","name":"$self"},{"line":339,"kind":12,"containerName":"to_FTstring","name":"strand"},{"kind":13,"containerName":"to_FTstring","name":"$self","line":340},{"line":340,"name":"strand","containerName":"to_FTstring","kind":12},{"name":"$str","containerName":"to_FTstring","kind":13,"line":341},{"line":341,"name":"$str","containerName":"to_FTstring","kind":13},{"line":343,"name":"$str","kind":13,"containerName":"to_FTstring"}],"name":"to_FTstring","containerName":"main::","definition":"sub","detail":"($self)"},{"children":[{"definition":"my","localvar":"my","containerName":"trunc","kind":13,"name":"$self","line":370},{"kind":13,"containerName":"trunc","name":"$start","line":370},{"line":370,"kind":13,"containerName":"trunc","name":"$end"},{"name":"$relative_ori","kind":13,"containerName":"trunc","line":370},{"definition":"my","line":371,"name":"$newstart","kind":13,"localvar":"my","containerName":"trunc"},{"name":"$self","kind":13,"containerName":"trunc","line":371},{"containerName":"trunc","kind":12,"name":"start","line":371},{"containerName":"trunc","kind":13,"name":"$start","line":371},{"definition":"my","name":"$newend","localvar":"my","containerName":"trunc","kind":13,"line":372},{"kind":13,"containerName":"trunc","name":"$self","line":372},{"containerName":"trunc","kind":12,"name":"end","line":372},{"name":"$start","containerName":"trunc","kind":13,"line":372},{"line":373,"kind":13,"localvar":"my","containerName":"trunc","name":"$newstrand","definition":"my"},{"line":373,"kind":13,"containerName":"trunc","name":"$relative_ori"},{"name":"$self","containerName":"trunc","kind":13,"line":373},{"containerName":"trunc","kind":12,"name":"strand","line":373},{"name":"$out","kind":13,"localvar":"my","containerName":"trunc","line":375,"definition":"my"},{"line":376,"name":"$newstart","kind":13,"containerName":"trunc"},{"line":376,"kind":13,"containerName":"trunc","name":"$newend"},{"line":376,"name":"$end","containerName":"trunc","kind":13},{"line":376,"containerName":"trunc","kind":13,"name":"$start"},{"line":377,"containerName":"trunc","kind":13,"name":"$out"},{"name":"new","kind":12,"containerName":"trunc","line":377},{"line":378,"name":"$out","containerName":"trunc","kind":13},{"line":378,"kind":12,"containerName":"trunc","name":"start"},{"line":378,"name":"$self","kind":13,"containerName":"trunc"},{"line":378,"name":"start","containerName":"trunc","kind":12},{"line":379,"containerName":"trunc","kind":13,"name":"$out"},{"line":379,"name":"end","kind":12,"containerName":"trunc"},{"name":"$self","kind":13,"containerName":"trunc","line":379},{"name":"end","containerName":"trunc","kind":12,"line":379},{"line":380,"name":"$out","containerName":"trunc","kind":13},{"line":380,"containerName":"trunc","kind":12,"name":"strand"},{"name":"$self","containerName":"trunc","kind":13,"line":380},{"containerName":"trunc","kind":12,"name":"strand","line":380},{"containerName":"trunc","kind":13,"name":"$out","line":381},{"line":381,"name":"seq_id","containerName":"trunc","kind":12},{"line":381,"kind":13,"containerName":"trunc","name":"$self"},{"line":381,"name":"seqid","containerName":"trunc","kind":12},{"kind":13,"containerName":"trunc","name":"$out","line":382},{"line":382,"kind":12,"containerName":"trunc","name":"is_remote"},{"line":384,"name":"$out","kind":13,"containerName":"trunc"},{"kind":12,"containerName":"trunc","name":"new","line":384},{"line":385,"containerName":"trunc","kind":13,"name":"$out"},{"name":"start","containerName":"trunc","kind":12,"line":385},{"containerName":"trunc","kind":13,"name":"$newstart","line":385},{"line":386,"name":"$out","containerName":"trunc","kind":13},{"line":386,"kind":12,"containerName":"trunc","name":"end"},{"containerName":"trunc","kind":13,"name":"$newend","line":386},{"line":387,"name":"$out","containerName":"trunc","kind":13},{"line":387,"name":"strand","containerName":"trunc","kind":12},{"kind":13,"containerName":"trunc","name":"$newstrand","line":387},{"containerName":"trunc","kind":13,"name":"$out","line":388},{"name":"seq_id","containerName":"trunc","kind":12,"line":388},{"containerName":"trunc","kind":13,"name":"$out","line":391}],"containerName":"main::","name":"trunc","definition":"sub","detail":"($self,$start,$end,$relative_ori)","line":369,"kind":12,"range":{"start":{"line":369,"character":0},"end":{"character":9999,"line":392}},"signature":{"label":"trunc($self,$start,$end,$relative_ori)","parameters":[{"label":"$self"},{"label":"$start"},{"label":"$end"},{"label":"$relative_ori"}],"documentation":"1;\n# $Id: Simple.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::Simple\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::Simple - Implementation of a Simple Location on a Sequence\n\n=head1 SYNOPSIS\n\n    use Bio::Location::Simple;\n\n    my $location = Bio::Location::Simple->new(-start => 1, -end => 100,\n                         -strand => 1 );\n\n    if( $location->strand == -1 ) {\n    printf \"complement(%d..%d)\\n\", $location->start, $location->end;\n    } else {\n    printf \"%d..%d\\n\", $location->start, $location->end;\n    }\n\n=head1 DESCRIPTION\n\nThis is an implementation of Bio::LocationI to manage exact location\ninformation on a Sequence: '22' or '12..15' or '16^17'.\n\nYou can test the type of the location using length() function () or\ndirectly location_type() which can one of two values: 'EXACT' or\n'IN-BETWEEN'.\n\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::Simple;\nuse strict;\n\nuse base qw(Bio::Location::Atomic);\n\nour %RANGEENCODE  = ('\\.\\.' => 'EXACT',\n             '\\^'   => 'IN-BETWEEN' );\n\nour %RANGEDECODE  = ('EXACT'      => '..',\n             'IN-BETWEEN' => '^' );\n\nsub new { \n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my ($locationtype) = $self->_rearrange([qw(LOCATION_TYPE)],@args);\n\n    $locationtype && $self->location_type($locationtype);\n\n    return $self;\n}\n\n=head2 start\n\n  Title   : start\n  Usage   : $start = $loc->start();\n  Function: get/set the start of this range\n  Returns : the start of this range\n  Args    : optionaly allows the start to be set\n          : using $loc->start($start)\n\n\nsub start {\n  my ($self, $value) = @_;\n    $self->{'_start'} = $value if defined $value ;\n  \n    $self->throw(\"Only adjacent residues when location type \".\n             \"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n             $self->{'_end'}. \"]\" )\n        if defined $self->{'_start'} && defined $self->{'_end'} && \n        $self->location_type eq 'IN-BETWEEN' &&\n        ($self->{'_end'} - 1 != $self->{'_start'});\n    return $self->{'_start'};\n}\n\n\n=head2 end\n\n  Title   : end\n  Usage   : $end = $loc->end();\n  Function: get/set the end of this range\n  Returns : the end of this range\n  Args    : optionaly allows the end to be set\n          : using $loc->end($start)\n  Note    : If start is set but end is undefined, this now assumes that start\n\t\t    is the same as end but throws a warning (i.e. it assumes this is\n\t\t\ta possible error). If start is undefined, this now throws an\n\t\t\texception.\n\n\nsub end {\n\tmy ($self, $value) = @_;\n  \n\t$self->{'_end'} = $value if defined $value ;\n\t\n\t#assume end is the same as start if not defined\n\tif (!defined $self->{'_end'}) {\n\t\tif (!defined $self->{'_start'}) {\n\t\t\t$self->warn('Calling end without a defined start position');\n\t\t\treturn;\n\t\t}\n\t\t$self->warn('Setting start equal to end');\n\t\t$self->{'_end'} = $self->{'_start'};\n\t}\n\t$self->throw(\"Only adjacent residues when location type \".\n\t\t\t\"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n\t\t\t $self->{'_end'}. \"]\" )\n\t\tif defined $self->{'_start'} && defined $self->{'_end'} && \n\t\t$self->location_type eq 'IN-BETWEEN' &&\n\t\t($self->{'_end'} - 1 != $self->{'_start'});\n  \n\treturn $self->{'_end'};\n}\n\n=head2 strand\n\n  Title   : strand\n  Usage   : $strand = $loc->strand();\n  Function: get/set the strand of this range\n  Returns : the strandedness (-1, 0, +1)\n  Args    : optionaly allows the strand to be set\n          : using $loc->strand($strand)\n\n\n=head2 length\n\n Title   : length\n Usage   : $len = $loc->length();\n Function: get the length in the coordinate space this location spans\n Example :\n Returns : an integer\n Args    : none\n\n\nsub length {\n   my ($self) = @_;\n   if ($self->location_type eq 'IN-BETWEEN' ) {\n       return 0;\n   } else {\n       return abs($self->end - $self->start) + 1;\n   }\n\n}\n\n=head2 min_start\n\n  Title   : min_start\n  Usage   : my $minstart = $location->min_start();\n  Function: Get minimum starting location of feature startpoint\n  Returns : integer or undef if no minimum starting point.\n  Args    : none\n\n\n=head2 max_start\n\n  Title   : max_start\n  Usage   : my $maxstart = $location->max_start();\n  Function: Get maximum starting location of feature startpoint.\n\n            In this implementation this is exactly the same as min_start().\n\n  Returns : integer or undef if no maximum starting point.\n  Args    : none\n\n\n=head2 start_pos_type\n\n  Title   : start_pos_type\n  Usage   : my $start_pos_type = $location->start_pos_type();\n  Function: Get start position type (ie <,>, ^).\n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\n=head2 min_end\n\n  Title   : min_end\n  Usage   : my $minend = $location->min_end();\n  Function: Get minimum ending location of feature endpoint \n  Returns : integer or undef if no minimum ending point.\n  Args    : none\n\n\n\n=head2 max_end\n\n  Title   : max_end\n  Usage   : my $maxend = $location->max_end();\n  Function: Get maximum ending location of feature endpoint \n\n            In this implementation this is exactly the same as min_end().\n\n  Returns : integer or undef if no maximum ending point.\n  Args    : none\n\n\n=head2 end_pos_type\n\n  Title   : end_pos_type\n  Usage   : my $end_pos_type = $location->end_pos_type();\n  Function: Get end position type (ie <,>, ^) \n\n  Returns : type of position coded as text \n            ('BEFORE', 'AFTER', 'EXACT','WITHIN', 'BETWEEN')\n  Args    : none\n\n\n=head2 location_type\n\n  Title   : location_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT' or 'IN-BETWEEN')\n  Args    : 'EXACT' or '..' or 'IN-BETWEEN' or '^'\n\n\nsub location_type {\n    my ($self, $value) = @_;\n\n    if( defined $value || ! defined $self->{'_location_type'} ) {\n    $value = 'EXACT' unless defined $value;\n    $value = uc $value;\n    if (! defined $RANGEDECODE{$value}) {\n        $value = '\\^' if $value eq '^';\n        $value = '\\.\\.' if $value eq '..';\n        $value = $RANGEENCODE{$value};\n    }\n    $self->throw(\"Did not specify a valid location type. [$value] is no good\")\n        unless defined $value;\n    $self->{'_location_type'} = $value;\n    }\n    $self->throw(\"Only adjacent residues when location type \".\n         \"is IN-BETWEEN. Not [\". $self->{'_start'}. \"] and [\".\n         $self->{'_end'}. \"]\" )\n    if $self->{'_location_type'} eq 'IN-BETWEEN' &&\n        defined $self->{'_start'} &&\n        defined $self->{'_end'} &&\n            ($self->{'_end'} - 1 != $self->{'_start'});\n\n    return $self->{'_location_type'};\n}\n\n=head2 is_remote\n\n Title   : is_remote\n Usage   : $self->is_remote($newval)\n Function: Getset for is_remote value\n Returns : value of is_remote\n Args    : newvalue (optional)\n\n\n\n=head2 to_FTstring\n\n  Title   : to_FTstring\n  Usage   : my $locstr = $location->to_FTstring()\n  Function: returns the FeatureTable string of this location\n  Returns : string\n  Args    : none\n\n\nsub to_FTstring { \n    my($self) = @_;\n\n    my $str;\n    if( $self->start == $self->end ) {\n    $str =  $self->start;\n    } else {\n        $str = $self->start . $RANGEDECODE{$self->location_type} . $self->end;\n    }\n    if($self->is_remote() && $self->seq_id()) {\n    $str = $self->seq_id() . \":\" . $str;\n    }\n    if( defined $self->strand &&\n    $self->strand == -1 ) {\n    $str = \"complement(\".$str.\")\";\n    }\n    return $str;\n}\n\n=head2 valid_Location\n\n Title   : valid_Location\n Usage   : if ($location->valid_location) {...};\n Function: boolean method to determine whether location is considered valid\n           (has minimum requirements for Simple implementation)\n Returns : Boolean value: true if location is valid, false otherwise\n Args    : none\n\n comments, not function added by jason\n\n trunc is untested, and as of now unannounced method for truncating a\n location.  This is to eventually be part of the procedure to\n truncate a sequence with annotatioin and properly remap the location\n of all the features contained within the truncated segment.\n presumably this might do things a little differently for the case\n where the truncation splits the location in half\n in short- you probably don't want to use  this method."}},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":377},{"containerName":"Location::Simple","kind":12,"name":"Bio","line":384}],"version":5}