{"version":5,"vars":[{"line":99,"name":"base","kind":2,"containerName":""},{"definition":"our","name":"%TFS","kind":13,"containerName":"main::","line":101},{"children":[{"line":117,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":117},{"definition":"my","line":118,"containerName":"new","localvar":"my","kind":13,"name":"$self"},{"name":"$class","containerName":"new","kind":13,"line":118},{"name":"@args","kind":13,"containerName":"new","line":118},{"name":"$u_name","localvar":"my","containerName":"new","kind":13,"line":120,"definition":"my"},{"name":"$desc","containerName":"new","kind":13,"line":120},{"kind":13,"containerName":"new","name":"$self","line":120},{"containerName":"new","kind":12,"name":"_rearrange","line":120},{"line":120,"kind":13,"containerName":"new","name":"@args"},{"name":"$u_name","containerName":"new","kind":13,"line":121},{"line":121,"containerName":"new","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"new","line":121},{"line":122,"name":"$self","kind":13,"containerName":"new"},{"line":122,"kind":12,"containerName":"new","name":"universal_name"},{"line":122,"name":"$u_name","kind":13,"containerName":"new"},{"line":124,"kind":13,"containerName":"new","name":"$desc"},{"name":"$self","containerName":"new","kind":13,"line":124},{"line":124,"name":"description","kind":12,"containerName":"new"},{"name":"$desc","containerName":"new","kind":13,"line":124},{"line":126,"kind":13,"containerName":"new","name":"$self"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":116,"range":{"end":{"character":9999,"line":127},"start":{"character":0,"line":116}},"kind":12,"signature":{"documentation":"1;\n# $Id: TranscriptionFactor.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::TranscriptionFactor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::TranscriptionFactor - A transcription factor modelled as a mappable\nelement\n\n=head1 SYNOPSIS\n\n  use Bio::Map::TranscriptionFactor;\n  use Bio::Map::GeneMap;\n  use Bio::Map::Position;\n\n  # model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n  # 250bp upstream of BRCA2 in mice\n  my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => \"BRCA2\",\n                                    -species => \"human\");\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => \"BRCA2\",\n                                    -species => \"mouse\");\n  Bio::Map::Position->new(-map => $map1,\n                          -element => $tf,\n                          -start => -500,\n                          -length => 10);\n  Bio::Map::Position->new(-map => $map2,\n                          -element => $tf,\n                          -start => -250,\n                          -length => 10);\n\n  # Find out where the transcription factor binds\n  foreach $pos ($tf->get_positions) {\n    print $tf->universal_name, \" binds at position \" $pos->value, \" relative to \",\n          $pos->relative->description, \" of gene \",\n          $pos->map->universal_name, \" in species \", $pos->map->species, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nA transcription factor modelled as a mappable element. It can have mulitple\nbinding sites (positions) near multiple genes (maps).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::TranscriptionFactor;\nuse strict;\n\nuse base qw(Bio::Map::Mappable);\n\nour $TFS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $tf = Bio::Map::TranscriptionFactor->new();\n Function: Builds a new Bio::Map::TranscriptionFactor object\n Returns : Bio::Map::TranscriptionFactor\n Args    : -universal_name => string name of the TF (in a form common to all\n                              species that have the TF, but unique amongst\n                              non-orthologous TFs), REQUIRED\n           -description    => string, free text description of the TF","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"name":"SUPER","containerName":"new","kind":12,"line":118},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":144,"kind":13,"localvar":"my","containerName":"get","name":"$class"},{"name":"@args","containerName":"get","kind":13,"line":144},{"definition":"my","line":145,"containerName":"get","localvar":"my","kind":13,"name":"$u_name"},{"line":145,"kind":12,"containerName":"get","name":"_rearrange"},{"line":145,"kind":13,"containerName":"get","name":"@args"},{"name":"$u_name","containerName":"get","kind":13,"line":147},{"line":147,"kind":13,"containerName":"get","name":"$TFS"},{"line":147,"name":"$u_name","containerName":"get","kind":13},{"line":148,"name":"$TFS","kind":13,"containerName":"get"},{"kind":13,"containerName":"get","name":"$u_name","line":148},{"name":"$class","kind":13,"containerName":"get","line":151},{"line":151,"containerName":"get","kind":12,"name":"new"},{"name":"@args","containerName":"get","kind":13,"line":151}],"name":"get","containerName":"main::","signature":{"label":"get($class,@args)","documentation":"1;\n# $Id: TranscriptionFactor.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::TranscriptionFactor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::TranscriptionFactor - A transcription factor modelled as a mappable\nelement\n\n=head1 SYNOPSIS\n\n  use Bio::Map::TranscriptionFactor;\n  use Bio::Map::GeneMap;\n  use Bio::Map::Position;\n\n  # model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n  # 250bp upstream of BRCA2 in mice\n  my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => \"BRCA2\",\n                                    -species => \"human\");\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => \"BRCA2\",\n                                    -species => \"mouse\");\n  Bio::Map::Position->new(-map => $map1,\n                          -element => $tf,\n                          -start => -500,\n                          -length => 10);\n  Bio::Map::Position->new(-map => $map2,\n                          -element => $tf,\n                          -start => -250,\n                          -length => 10);\n\n  # Find out where the transcription factor binds\n  foreach $pos ($tf->get_positions) {\n    print $tf->universal_name, \" binds at position \" $pos->value, \" relative to \",\n          $pos->relative->description, \" of gene \",\n          $pos->map->universal_name, \" in species \", $pos->map->species, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nA transcription factor modelled as a mappable element. It can have mulitple\nbinding sites (positions) near multiple genes (maps).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::TranscriptionFactor;\nuse strict;\n\nuse base qw(Bio::Map::Mappable);\n\nour $TFS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $tf = Bio::Map::TranscriptionFactor->new();\n Function: Builds a new Bio::Map::TranscriptionFactor object\n Returns : Bio::Map::TranscriptionFactor\n Args    : -universal_name => string name of the TF (in a form common to all\n                              species that have the TF, but unique amongst\n                              non-orthologous TFs), REQUIRED\n           -description    => string, free text description of the TF\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $obj = Bio::Map::TranscriptionFactor->get();\n Function: Builds a new Bio::Map::TranscriptionFactor object (like new()), or\n           gets a pre-existing one that shares the same universal_name.\n Returns : Bio::Map::TranscriptionFactor\n Args    : -universal_name => string name of the TF (in a form common to all\n                              species that have the TF, but unique amongst\n                              non-orthologous TFs), REQUIRED\n           -description    => string, free text description of the TF","parameters":[{"label":"$class"},{"label":"@args"}]},"line":143,"kind":12,"range":{"end":{"line":152,"character":9999},"start":{"line":143,"character":0}}},{"line":145,"containerName":"Root::Root","kind":12,"name":"Bio"},{"line":166,"range":{"end":{"line":174,"character":9999},"start":{"line":166,"character":0}},"kind":12,"signature":{"label":"universal_name($self,$value)","documentation":"1;\n# $Id: TranscriptionFactor.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::TranscriptionFactor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::TranscriptionFactor - A transcription factor modelled as a mappable\nelement\n\n=head1 SYNOPSIS\n\n  use Bio::Map::TranscriptionFactor;\n  use Bio::Map::GeneMap;\n  use Bio::Map::Position;\n\n  # model a TF that binds 500bp upstream of the BRCA2 gene in humans and\n  # 250bp upstream of BRCA2 in mice\n  my $tf = Bio::Map::TranscriptionFactor->get(-universal_name => 'tf1');\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => \"BRCA2\",\n                                    -species => \"human\");\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => \"BRCA2\",\n                                    -species => \"mouse\");\n  Bio::Map::Position->new(-map => $map1,\n                          -element => $tf,\n                          -start => -500,\n                          -length => 10);\n  Bio::Map::Position->new(-map => $map2,\n                          -element => $tf,\n                          -start => -250,\n                          -length => 10);\n\n  # Find out where the transcription factor binds\n  foreach $pos ($tf->get_positions) {\n    print $tf->universal_name, \" binds at position \" $pos->value, \" relative to \",\n          $pos->relative->description, \" of gene \",\n          $pos->map->universal_name, \" in species \", $pos->map->species, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nA transcription factor modelled as a mappable element. It can have mulitple\nbinding sites (positions) near multiple genes (maps).\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::TranscriptionFactor;\nuse strict;\n\nuse base qw(Bio::Map::Mappable);\n\nour $TFS = {};\n\n=head2 new\n\n Title   : new\n Usage   : my $tf = Bio::Map::TranscriptionFactor->new();\n Function: Builds a new Bio::Map::TranscriptionFactor object\n Returns : Bio::Map::TranscriptionFactor\n Args    : -universal_name => string name of the TF (in a form common to all\n                              species that have the TF, but unique amongst\n                              non-orthologous TFs), REQUIRED\n           -description    => string, free text description of the TF\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $obj = Bio::Map::TranscriptionFactor->get();\n Function: Builds a new Bio::Map::TranscriptionFactor object (like new()), or\n           gets a pre-existing one that shares the same universal_name.\n Returns : Bio::Map::TranscriptionFactor\n Args    : -universal_name => string name of the TF (in a form common to all\n                              species that have the TF, but unique amongst\n                              non-orthologous TFs), REQUIRED\n           -description    => string, free text description of the TF\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME)], @args);\n    \n    if ($u_name && defined $TFS->{$u_name}) {\n        return $TFS->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $obj->universal_name\n Function: Get/Set TF name, corresponding to the name of the TF in a form shared\n           by orthologous versions of the TF in different species, but otherwise\n           unique.\n Returns : string\n Args    : none to get, OR string to set","parameters":[{"label":"$self"},{"label":"$value"}]},"children":[{"name":"$self","localvar":"my","containerName":"universal_name","kind":13,"line":167,"definition":"my"},{"containerName":"universal_name","kind":13,"name":"$value","line":167},{"name":"$value","kind":13,"containerName":"universal_name","line":168},{"line":169,"name":"$TFS","containerName":"universal_name","kind":13},{"name":"$self","containerName":"universal_name","kind":13,"line":169},{"containerName":"universal_name","kind":13,"name":"$self","line":169},{"name":"$self","containerName":"universal_name","kind":13,"line":170},{"name":"$value","containerName":"universal_name","kind":13,"line":170},{"line":171,"name":"$TFS","containerName":"universal_name","kind":13},{"line":171,"name":"$value","kind":13,"containerName":"universal_name"},{"kind":13,"containerName":"universal_name","name":"$self","line":171},{"name":"$self","kind":13,"containerName":"universal_name","line":173}],"name":"universal_name","containerName":"main::","definition":"sub","detail":"($self,$value)"},{"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"description","line":187},{"name":"$self","kind":13,"containerName":"description","line":188},{"kind":13,"containerName":"description","name":"$self","line":189}],"containerName":"main::","name":"description","definition":"sub","line":186,"kind":12,"range":{"start":{"character":0,"line":186},"end":{"character":9999,"line":190}}},{"line":188,"kind":12,"name":"desc"},{"kind":12,"name":"desc","line":189}]}