{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":78},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: scoring.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::scoring\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::scoring - A parser for PAM/BLOSUM matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUM50');\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO::scoring;\nuse strict;\n\nuse Bio::Matrix::Scoring;\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::scoring->new();\n Function: Builds a new Bio::Matrix::IO::scoring object \n Returns : an instance of Bio::Matrix::IO::scoring\n Args    :\n\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrux = $parser->next_matrix\n Function: parses a scoring matrix (BLOSUM,PAM styles) \n Returns : L<Bio::Matrix::Scoring>\n Args    : none","label":"next_matrix($self)"},"range":{"start":{"character":0,"line":102},"end":{"character":9999,"line":159}},"kind":12,"line":102,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_matrix","children":[{"localvar":"my","containerName":"next_matrix","kind":13,"name":"$self","line":103,"definition":"my"},{"definition":"my","name":"@matrix","localvar":"my","kind":13,"containerName":"next_matrix","line":105},{"name":"@cols","kind":13,"containerName":"next_matrix","line":105},{"line":105,"name":"@rows","containerName":"next_matrix","kind":13},{"line":105,"name":"%extras","containerName":"next_matrix","kind":13},{"line":105,"name":"$inmatrix","containerName":"next_matrix","kind":13},{"containerName":"next_matrix","kind":13,"name":"$self","line":106},{"name":"_readline","containerName":"next_matrix","kind":12,"line":106},{"kind":13,"containerName":"next_matrix","name":"$inmatrix","line":109},{"name":"$self","containerName":"next_matrix","kind":13,"line":110},{"kind":12,"containerName":"next_matrix","name":"_pushback","line":110},{"name":"$extras","containerName":"next_matrix","kind":13,"line":115},{"name":"$extras","kind":13,"containerName":"next_matrix","line":116},{"line":119,"containerName":"next_matrix","kind":13,"name":"$extras"},{"line":120,"containerName":"next_matrix","kind":13,"name":"$extras"},{"kind":13,"containerName":"next_matrix","name":"$extras","line":123},{"line":124,"kind":13,"containerName":"next_matrix","name":"$extras"},{"line":125,"kind":13,"containerName":"next_matrix","name":"$extras"},{"name":"$extras","kind":13,"containerName":"next_matrix","line":127},{"containerName":"next_matrix","kind":13,"name":"$extras","line":129},{"containerName":"next_matrix","kind":13,"name":"$extras","line":132},{"line":133,"name":"$extras","kind":13,"containerName":"next_matrix"},{"kind":13,"containerName":"next_matrix","name":"$extras","line":137},{"name":"$extras","kind":13,"containerName":"next_matrix","line":138},{"name":"@cols","containerName":"next_matrix","kind":13,"line":141},{"line":142,"name":"$cols","kind":13,"containerName":"next_matrix"},{"line":143,"name":"$self","kind":13,"containerName":"next_matrix"},{"containerName":"next_matrix","kind":12,"name":"warn","line":143},{"line":145,"name":"$inmatrix","containerName":"next_matrix","kind":13},{"line":146,"kind":13,"containerName":"next_matrix","name":"$inmatrix"},{"containerName":"next_matrix","kind":13,"name":"$inmatrix","line":147},{"name":"$rowname","localvar":"my","containerName":"next_matrix","kind":13,"line":148,"definition":"my"},{"name":"@row","containerName":"next_matrix","kind":13,"line":148},{"line":149,"name":"@rows","containerName":"next_matrix","kind":13},{"kind":13,"containerName":"next_matrix","name":"$rowname","line":149},{"name":"@matrix","containerName":"next_matrix","kind":13,"line":150},{"name":"@row","containerName":"next_matrix","kind":13,"line":150},{"definition":"my","localvar":"my","containerName":"next_matrix","kind":13,"name":"$matrix","line":155},{"containerName":"next_matrix","kind":12,"name":"new","line":155},{"line":155,"name":"@matrix","kind":13,"containerName":"next_matrix"},{"line":156,"kind":13,"containerName":"next_matrix","name":"@rows"},{"line":157,"name":"@cols","containerName":"next_matrix","kind":13},{"name":"%extras","containerName":"next_matrix","kind":13,"line":158}]},{"kind":12,"containerName":"Matrix::Scoring","name":"Bio","line":155},{"children":[{"localvar":"my","containerName":"write_matrix","kind":13,"name":"$self","line":173,"definition":"my"},{"containerName":"write_matrix","kind":13,"name":"@args","line":173},{"line":174,"name":"$self","containerName":"write_matrix","kind":13},{"kind":12,"containerName":"write_matrix","name":"warn","line":174}],"name":"write_matrix","containerName":"main::","definition":"sub","detail":"($self,@args)","line":172,"range":{"start":{"character":0,"line":172},"end":{"line":176,"character":9999}},"kind":12,"signature":{"label":"write_matrix($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: scoring.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::scoring\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot-org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::scoring - A parser for PAM/BLOSUM matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format => 'scoring',\n                                   -file   => 'BLOSUM50');\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO::scoring;\nuse strict;\n\nuse Bio::Matrix::Scoring;\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::scoring->new();\n Function: Builds a new Bio::Matrix::IO::scoring object \n Returns : an instance of Bio::Matrix::IO::scoring\n Args    :\n\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrux = $parser->next_matrix\n Function: parses a scoring matrix (BLOSUM,PAM styles) \n Returns : L<Bio::Matrix::Scoring>\n Args    : none\n\n\n\nsub next_matrix{\n   my ($self) = @_;\n   local ($_);\n   my (@matrix,@cols,@rows,%extras,$inmatrix);\n   while( defined ( $_ = $self->_readline ) ) {\n       next if ( /^\\s*$/);\n       if( /^\\#/ ) {\n\t   if( $inmatrix ) { \n\t       $self->_pushback($_);\n\t       last;\n\t   }\n\t   if( m/Entropy\\s+\\=\\s+(\\S+)\\,\\s+\n\t       Expected\\s+\\=\\s+(\\S+)/ox ) {\n\t       $extras{'-entropy'} = $1;\n\t       $extras{'-expected'} = $2;\n\t   } elsif ( m/Expected\\s+score\\s+\\=\\s+(\\S+)\\,\n\t\t     \\s+Entropy\\s+\\=\\s+(\\S+)/xo ){\n\t       $extras{'-entropy'} = $2;\n\t       $extras{'-expected'} = $1;\n\t   } elsif( m/(PAM\\s+\\d+)\\s+substitution.+\n\t\t    scale\\s+\\=\\s+(\\S+)\\s+\\=\\s+(\\S+)/ox ) {\n\t       $extras{'-matrix_name'} = $1;\n\t       $extras{'-scale'}       = $2;\t       \n\t       $extras{'-scale_value'} = $3;\n\t   } elsif( /Blocks Database\\s+\\=\\s+(\\S+)/o ) {\n\t       $extras{'-database'} = $1;\n\t   } elsif( m/(\\S+)\\s+Bit\\s+Units/ox ) {\n\t       $extras{'-scale'} = $1;\n\t   } elsif( m/Lowest score\\s+\\=\\s+(\\S+)\\,\\s+\n\t\t    Highest score\\s+\\=\\s+(\\S+)/ox ) {\n\t       $extras{'-lowest_score'} = $1;\n\t       $extras{'-highest_score'} = $2;\n\t   } elsif( m/(Lambda)\\s+\\=\\s+(\\S+)\\s+bits\\,\n\t\t    \\s+(H)\\s+\\=\\s+(\\S+)/ox ) {\n\t       # This is a DNA matrix\n\t       $extras{$1} = $2;\n\t       $extras{$3} = $4;\n\t   }\t       \n       } elsif( s/^\\s+(\\S+)/$1/ ) {\n\t   @cols = split;\n\t   if( $cols[0] ne 'A' ) {\n\t       $self->warn(\"Unrecognized first line of matrix, we might not have parsed it correctly\");\n\t   }\n\t   $inmatrix = 1;\n       } elsif( $inmatrix ) {\n\t   if( ! /^(\\S+)/ ) { $inmatrix = 0; next }\n\t   my ($rowname,@row) = split;\n\t   push @rows, $rowname;\n\t   push @matrix, [@row];\n       } else { \n\t   print;\n       }\n   }\n   my $matrix = Bio::Matrix::Scoring->new(-values     => \\@matrix,\n\t\t\t\t\t -rownames   => \\@rows,\n\t\t\t\t\t -colnames   => \\@cols,\n\t\t\t\t\t %extras);\n}\n\n=head2 write_matrix\n\n Title   : write_matrix\n Usage   : $matio->write_matrix($matrix)\n Function: Write out a matrix in the BLOSUM/PAM format\n Returns : none\n Args    : L<Bio::Matrix::Scoring>"}}]}