{"vars":[{"name":"vars","containerName":"","kind":2,"line":60},{"name":"base","containerName":"","kind":2,"line":63},{"line":65,"containerName":null,"kind":13,"name":"@Bio"},{"line":65,"containerName":"PSM::IO::meme::HEADER","kind":12,"name":"Matrix"},{"children":[{"definition":"my","line":82,"name":"$class","localvar":"my","containerName":"new","kind":13},{"line":82,"name":"@args","containerName":"new","kind":13},{"line":83,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"containerName":"new","kind":13,"name":"$class","line":83},{"line":83,"kind":13,"containerName":"new","name":"@args"},{"definition":"my","line":84,"localvar":"my","containerName":"new","kind":13,"name":"$file"},{"line":84,"name":"$self","containerName":"new","kind":13},{"line":84,"name":"_rearrange","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":84},{"definition":"my","name":"$query","kind":13,"localvar":"my","containerName":"new","line":85},{"containerName":"new","kind":13,"name":"$tr1","line":85},{"line":85,"name":"$file","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":86},{"name":"$file","kind":13,"containerName":"new","line":86},{"kind":13,"containerName":"new","name":"$self","line":87},{"kind":13,"containerName":"new","name":"$query","line":87},{"line":88,"name":"$self","containerName":"new","kind":13},{"line":89,"name":"$self","containerName":"new","kind":13},{"line":90,"containerName":"new","kind":13,"name":"$self"},{"line":90,"kind":12,"containerName":"new","name":"_initialize_io"},{"line":90,"name":"@args","containerName":"new","kind":13},{"line":92,"name":"$line","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"definition":"my","line":93,"name":"$line","containerName":"new","localvar":"my","kind":13},{"line":93,"containerName":"new","kind":13,"name":"$self"},{"line":93,"name":"_readline","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$self","line":94},{"line":94,"name":"throw","containerName":"new","kind":12},{"line":94,"kind":13,"containerName":"new","name":"$line"},{"line":95,"name":"$line","containerName":"new","kind":13},{"line":96,"kind":13,"containerName":"new","name":"$line"},{"line":97,"kind":13,"containerName":"new","name":"$self"},{"line":97,"kind":13,"containerName":"new","name":"$self"},{"kind":13,"containerName":"new","name":"$self","line":100},{"kind":13,"containerName":"new","name":"$line","line":100},{"line":100,"containerName":"new","kind":13,"name":"$line"},{"line":100,"kind":13,"containerName":"new","name":"$line"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":81,"kind":12,"range":{"start":{"character":0,"line":81},"end":{"line":101,"character":9999}},"signature":{"label":"new($class,@args)","documentation":"1;\n#---------------------------------------------------------\n# $Id: meme.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::meme - PSM meme parser implementation\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to use PSM parsers\n\n=head1 DESCRIPTION\n\nParser for meme.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::meme;\nuse Bio::Matrix::PSM::InstanceSite;\nuse Bio::Matrix::PSM::SiteMatrix;\nuse Bio::Matrix::PSM::Psm;\nuse vars qw(@HEADER);\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n@Bio::Matrix::PSM::IO::meme::HEADER = qw(e_val sites IC width);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or \n           if the MEME header cannot be found.\n Example :\n Args    : hash\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);","parameters":[{"label":"$class"},{"label":"@args"}]}},{"line":83,"containerName":"new","kind":12,"name":"SUPER"},{"line":86,"name":"file","kind":12},{"name":"query","kind":12,"line":87},{"line":88,"kind":12,"name":"end"},{"name":"_strand","kind":12,"line":89},{"kind":12,"name":"_parse_coordinates","line":97},{"name":"unstructured","kind":12,"line":100},{"name":"$self","containerName":null,"kind":13,"line":102},{"kind":12,"containerName":"main::","name":"_initialize","line":102},{"line":103,"containerName":null,"kind":13,"name":"$self"},{"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_parse_coordinates","line":119,"definition":"my"},{"line":120,"kind":13,"containerName":"_parse_coordinates","name":"$self"},{"line":120,"name":"_readline","kind":12,"containerName":"_parse_coordinates"},{"line":121,"kind":13,"containerName":"_parse_coordinates","name":"$self"},{"name":"_readline","containerName":"_parse_coordinates","kind":12,"line":121},{"definition":"my","localvar":"my","kind":13,"containerName":"_parse_coordinates","name":"$line","line":122},{"line":122,"name":"$self","containerName":"_parse_coordinates","kind":13},{"line":122,"name":"_readline","containerName":"_parse_coordinates","kind":12},{"line":123,"containerName":"_parse_coordinates","kind":13,"name":"$line"},{"line":124,"kind":13,"containerName":"_parse_coordinates","name":"$line"},{"line":125,"name":"$line","containerName":"_parse_coordinates","kind":13},{"localvar":"my","containerName":"_parse_coordinates","kind":13,"name":"$id1","line":126,"definition":"my"},{"line":126,"name":"$w1","kind":13,"containerName":"_parse_coordinates"},{"kind":13,"containerName":"_parse_coordinates","name":"$l1","line":126},{"name":"$id2","containerName":"_parse_coordinates","kind":13,"line":126},{"name":"$w2","kind":13,"containerName":"_parse_coordinates","line":126},{"line":126,"kind":13,"containerName":"_parse_coordinates","name":"$l2"},{"line":126,"name":"$line","kind":13,"containerName":"_parse_coordinates"},{"containerName":"_parse_coordinates","kind":13,"name":"$self","line":127},{"containerName":"_parse_coordinates","kind":13,"name":"$id1","line":127},{"kind":13,"containerName":"_parse_coordinates","name":"$self","line":128},{"containerName":"_parse_coordinates","kind":13,"name":"$id1","line":128},{"containerName":"_parse_coordinates","kind":13,"name":"$w1","line":128},{"line":129,"containerName":"_parse_coordinates","kind":13,"name":"$self"},{"line":129,"kind":13,"containerName":"_parse_coordinates","name":"$id1"},{"name":"$l1","kind":13,"containerName":"_parse_coordinates","line":129},{"kind":13,"containerName":"_parse_coordinates","name":"$id2","line":130},{"name":"$self","kind":13,"containerName":"_parse_coordinates","line":131},{"containerName":"_parse_coordinates","kind":13,"name":"$id2","line":131},{"line":132,"name":"$self","kind":13,"containerName":"_parse_coordinates"},{"line":132,"name":"$id2","containerName":"_parse_coordinates","kind":13},{"kind":13,"containerName":"_parse_coordinates","name":"$w2","line":132},{"name":"$self","kind":13,"containerName":"_parse_coordinates","line":133},{"line":133,"kind":13,"containerName":"_parse_coordinates","name":"$id2"},{"line":133,"name":"$l2","containerName":"_parse_coordinates","kind":13}],"containerName":"main::","name":"_parse_coordinates","line":118,"range":{"end":{"line":134,"character":9999},"start":{"character":0,"line":118}},"kind":12},{"line":127,"name":"hid","kind":12},{"line":128,"name":"weight","kind":12},{"name":"length","kind":12,"line":129},{"line":131,"name":"hid","kind":12},{"name":"weight","kind":12,"line":132},{"kind":12,"name":"length","line":133},{"line":135,"name":"$line","containerName":null,"kind":13},{"line":135,"name":"$self","containerName":null,"kind":13},{"line":135,"containerName":"main::","kind":12,"name":"_readline"},{"containerName":null,"kind":13,"name":"$self","line":137},{"definition":"sub","children":[{"containerName":"header","localvar":"my","kind":13,"name":"$self","line":166,"definition":"my"},{"containerName":"header","localvar":"my","kind":13,"name":"@instances","line":167,"definition":"my"},{"containerName":"header","kind":13,"name":"$self","line":167}],"name":"header","containerName":"main::","line":165,"kind":12,"range":{"end":{"character":9999,"line":167},"start":{"character":0,"line":165}}},{"name":"_inst_name","kind":12,"line":167},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@weights","line":168},{"name":"%self","containerName":null,"kind":13,"line":168},{"kind":12,"name":"_inst_weight","line":168},{"definition":"my","line":169,"name":"@lengths","localvar":"my","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%self","line":169},{"name":"_inst_coord","kind":12,"line":169},{"line":170,"kind":12,"name":"instances"},{"containerName":null,"kind":13,"name":"@instances","line":170},{"name":"weights","kind":12,"line":170},{"line":170,"kind":13,"containerName":null,"name":"@weights"},{"line":170,"kind":12,"name":"lengths"},{"containerName":null,"kind":13,"name":"@lengths","line":170},{"range":{"end":{"line":244,"character":9999},"start":{"line":186,"character":0}},"kind":12,"line":186,"name":"next_psm","containerName":"main::","children":[{"definition":"my","line":188,"kind":13,"localvar":"my","containerName":"next_psm","name":"$self"},{"kind":13,"containerName":"next_psm","name":"$self","line":189},{"definition":"my","line":190,"containerName":"next_psm","localvar":"my","kind":13,"name":"$endm"},{"kind":13,"containerName":"next_psm","name":"$line","line":190},{"line":190,"name":"$instances","kind":13,"containerName":"next_psm"},{"line":190,"name":"$tr","kind":13,"containerName":"next_psm"},{"line":190,"name":"$width","containerName":"next_psm","kind":13},{"name":"$motif_id","kind":13,"containerName":"next_psm","line":190},{"line":190,"name":"$sites","kind":13,"containerName":"next_psm"},{"kind":13,"containerName":"next_psm","name":"$e_val","line":190},{"line":190,"name":"$id","containerName":"next_psm","kind":13},{"name":"$ic","kind":13,"containerName":"next_psm","line":190},{"line":190,"name":"$lA","containerName":"next_psm","kind":13},{"name":"$lC","containerName":"next_psm","kind":13,"line":190},{"name":"$lG","containerName":"next_psm","kind":13,"line":190},{"line":190,"containerName":"next_psm","kind":13,"name":"$lT"},{"kind":13,"containerName":"next_psm","name":"$line","line":191},{"kind":13,"containerName":"next_psm","name":"$self","line":191},{"name":"_readline","containerName":"next_psm","kind":12,"line":191},{"line":193,"name":"$self","containerName":"next_psm","kind":13},{"line":193,"kind":13,"containerName":"next_psm","name":"$line"},{"kind":13,"containerName":"next_psm","name":"$line","line":193},{"line":194,"name":"$line","kind":13,"containerName":"next_psm"},{"line":195,"kind":13,"containerName":"next_psm","name":"$instances"},{"name":"$self","kind":13,"containerName":"next_psm","line":195},{"line":195,"name":"_parseInstance","containerName":"next_psm","kind":12},{"name":"$line","containerName":"next_psm","kind":13,"line":198},{"line":198,"name":"$line","kind":13,"containerName":"next_psm"},{"line":199,"kind":13,"containerName":"next_psm","name":"$line"},{"line":200,"name":"$line","containerName":"next_psm","kind":13},{"containerName":"next_psm","kind":13,"name":"$line","line":201},{"line":203,"kind":13,"containerName":"next_psm","name":"$tr"},{"line":203,"name":"$motif_id","containerName":"next_psm","kind":13},{"line":203,"containerName":"next_psm","kind":13,"name":"$tr"},{"line":203,"kind":13,"containerName":"next_psm","name":"$width"},{"line":203,"kind":13,"containerName":"next_psm","name":"$tr"},{"name":"$sites","containerName":"next_psm","kind":13,"line":203},{"containerName":"next_psm","kind":13,"name":"$tr","line":204},{"name":"$tr","kind":13,"containerName":"next_psm","line":204},{"line":204,"name":"$tr","containerName":"next_psm","kind":13},{"name":"$e_val","kind":13,"containerName":"next_psm","line":204},{"line":204,"kind":13,"containerName":"next_psm","name":"$line"},{"name":"$self","kind":13,"containerName":"next_psm","line":205},{"name":"$self","kind":13,"containerName":"next_psm","line":205},{"line":205,"name":"$motif_id","containerName":"next_psm","kind":13},{"line":207,"name":"$line","containerName":"next_psm","kind":13},{"kind":13,"containerName":"next_psm","name":"$line","line":208},{"name":"$self","kind":13,"containerName":"next_psm","line":208},{"line":208,"kind":12,"containerName":"next_psm","name":"_readline"},{"line":209,"containerName":"next_psm","kind":13,"name":"$line"},{"kind":13,"containerName":"next_psm","name":"$line","line":210},{"name":"$ic","kind":13,"containerName":"next_psm","line":211},{"kind":13,"containerName":"next_psm","name":"$line","line":211},{"line":214,"containerName":"next_psm","kind":13,"name":"$line"},{"name":"$lA","kind":13,"containerName":"next_psm","line":215},{"line":215,"name":"$lC","containerName":"next_psm","kind":13},{"name":"$lG","kind":13,"containerName":"next_psm","line":215},{"line":215,"containerName":"next_psm","kind":13,"name":"$lT"},{"line":215,"kind":13,"containerName":"next_psm","name":"$self"},{"line":217,"name":"$line","containerName":"next_psm","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"next_psm","name":"%matrix_dat","line":218},{"line":218,"kind":13,"containerName":"next_psm","name":"$self"},{"name":"_parseMatrix","kind":12,"containerName":"next_psm","line":218},{"kind":13,"containerName":"next_psm","name":"$motif_id","line":218},{"definition":"my","line":219,"name":"$psm","containerName":"next_psm","localvar":"my","kind":13},{"line":219,"kind":12,"containerName":"next_psm","name":"new"},{"name":"%matrix_dat","kind":13,"containerName":"next_psm","line":219},{"line":220,"name":"$instances","containerName":"next_psm","kind":13},{"kind":13,"containerName":"next_psm","name":"$e_val","line":221},{"name":"$ic","kind":13,"containerName":"next_psm","line":222},{"kind":13,"containerName":"next_psm","name":"$width","line":223},{"containerName":"next_psm","kind":13,"name":"$sites","line":224},{"line":225,"kind":13,"containerName":"next_psm","name":"$lA"},{"name":"$lC","containerName":"next_psm","kind":13,"line":226},{"line":227,"name":"$lG","containerName":"next_psm","kind":13},{"name":"$lT","containerName":"next_psm","kind":13,"line":228},{"containerName":"next_psm","kind":13,"name":"$psm","line":230},{"name":"$line","kind":13,"containerName":"next_psm","line":232},{"line":233,"kind":13,"containerName":"next_psm","name":"$self"},{"containerName":"next_psm","kind":13,"name":"$endm","line":236},{"line":236,"name":"$line","containerName":"next_psm","kind":13},{"kind":13,"containerName":"next_psm","name":"$endm","line":238},{"line":239,"name":"$self","kind":13,"containerName":"next_psm"},{"name":"$self","kind":13,"containerName":"next_psm","line":243},{"kind":12,"containerName":"next_psm","name":"throw","line":243}],"definition":"sub"},{"line":189,"name":"end","kind":12},{"name":"_strand","kind":12,"line":193},{"name":"id","kind":12,"line":205},{"line":205,"name":"query","kind":12},{"kind":12,"name":"_parse_logs","line":215},{"line":219,"name":"Bio","kind":12,"containerName":"Matrix::PSM::Psm"},{"line":233,"kind":12,"name":"end"},{"kind":12,"name":"end","line":239},{"children":[{"localvar":"my","containerName":"_parseMatrix","kind":13,"name":"$self","line":259,"definition":"my"},{"line":259,"kind":13,"containerName":"_parseMatrix","name":"$id"},{"definition":"my","localvar":"my","containerName":"_parseMatrix","kind":13,"name":"@pA","line":260},{"name":"@pC","kind":13,"containerName":"_parseMatrix","line":260},{"containerName":"_parseMatrix","kind":13,"name":"@pG","line":260},{"kind":13,"containerName":"_parseMatrix","name":"@pT","line":260},{"line":261,"name":"$i","kind":13,"localvar":"my","containerName":"_parseMatrix","definition":"my"},{"definition":"my","name":"$line","localvar":"my","kind":13,"containerName":"_parseMatrix","line":262},{"containerName":"_parseMatrix","kind":13,"name":"$self","line":262},{"line":262,"kind":12,"containerName":"_parseMatrix","name":"_readline"},{"kind":13,"containerName":"_parseMatrix","name":"$line","line":265},{"line":266,"kind":13,"containerName":"_parseMatrix","name":"$line"},{"line":267,"name":"$line","containerName":"_parseMatrix","kind":13},{"name":"$line","kind":13,"containerName":"_parseMatrix","line":268},{"line":269,"kind":13,"containerName":"_parseMatrix","name":"$pA"},{"name":"$i","kind":13,"containerName":"_parseMatrix","line":269},{"name":"$pC","containerName":"_parseMatrix","kind":13,"line":269},{"name":"$i","kind":13,"containerName":"_parseMatrix","line":269},{"containerName":"_parseMatrix","kind":13,"name":"$pG","line":269},{"kind":13,"containerName":"_parseMatrix","name":"$i","line":269},{"line":269,"name":"$pT","kind":13,"containerName":"_parseMatrix"},{"name":"$i","kind":13,"containerName":"_parseMatrix","line":269},{"line":269,"containerName":"_parseMatrix","kind":13,"name":"$line"},{"kind":13,"containerName":"_parseMatrix","name":"$i","line":270},{"name":"$line","containerName":"_parseMatrix","kind":13,"line":271},{"line":271,"name":"$self","containerName":"_parseMatrix","kind":13},{"name":"_readline","containerName":"_parseMatrix","kind":12,"line":271},{"containerName":"_parseMatrix","kind":13,"name":"$line","line":272},{"containerName":"_parseMatrix","kind":13,"name":"@pA","line":273},{"line":273,"kind":13,"containerName":"_parseMatrix","name":"@pC"},{"line":273,"name":"@pG","kind":13,"containerName":"_parseMatrix"},{"containerName":"_parseMatrix","kind":13,"name":"@pT","line":273},{"containerName":"_parseMatrix","kind":13,"name":"$id","line":273}],"name":"_parseMatrix","containerName":"main::","definition":"sub","detail":"($self,$id)","line":258,"range":{"start":{"character":0,"line":258},"end":{"line":274,"character":9999}},"kind":12,"signature":{"documentation":"1;\n#---------------------------------------------------------\n# $Id: meme.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO::meme - PSM meme parser implementation\n\n=head1 SYNOPSIS\n\nSee Bio::Matrix::PSM::IO for detailed documentation on how to use PSM parsers\n\n=head1 DESCRIPTION\n\nParser for meme.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO::meme;\nuse Bio::Matrix::PSM::InstanceSite;\nuse Bio::Matrix::PSM::SiteMatrix;\nuse Bio::Matrix::PSM::Psm;\nuse vars qw(@HEADER);\nuse strict;\n\nuse base qw(Bio::Matrix::PSM::PsmHeader Bio::Matrix::PSM::IO);\n\n@Bio::Matrix::PSM::IO::meme::HEADER = qw(e_val sites IC width);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or \n           if the MEME header cannot be found.\n Example :\n Args    : hash\n Returns : \"Bio::Matrix::PSM::$format\"->new(@args);\n\n\nsub new {\n    my($class, @args)=@_;\n    my $self = $class->SUPER::new(@args);\n    my ($file)=$self->_rearrange(['FILE'], @args);\n    my ($query,$tr1)=split(/\\./,$file,2);\n    $self->{file} = $file;\n    $self->{query}= $query;\n    $self->{end}  = 0;\n    $self->{_strand}=0; #This we'll need to see if revcom option is used\n    $self->_initialize_io(@args) || warn \"Did you intend to use STDIN?\"; #Read only for now\n    #Skip header\n    my $line;\n    while (my $line=$self->_readline) {\n\t$self->throw('Cannot parse HTML, please use text output\\n') if ($line=~/<HEAD>/); #Should start parsing HTML output, not a bug deal\n\tchomp($line);\n\tif ($line=~\"^ALPHABET\") {\n\t    $self=_parse_coordinates($self);\n\t    last;\n\t}\n\tpush @{$self->{unstructured}},$line unless (($line=~/\\*{10,}/) || ($line eq ''));\n    }\n    $self->_initialize;\n    return $self;\n}\n\n=head2 _parse_coordinates\n\n Title   : _parse_coordinates\n Usage   :\n Function:\n Throws  :\n Example : Internal stuff\n Returns :\n Args    :\n\n\nsub _parse_coordinates {\n    my $self=shift;\n    $self->_readline;\n    $self->_readline;\n    my $line=$self->_readline;\n    while ($line !~ /^\\*{10,}/ ) {\n\tchomp $line;\n\t$line =~ s/\\s+/,/g;\n\tmy ($id1,$w1,$l1,$id2,$w2,$l2)=split(/,/,$line);\n\tpush @{$self->{hid}},$id1;\n\t$self->{weight}->{$id1}=$w1;\n\t$self->{length}->{$id1}=$l1;\n\tif ($id2) {\n\t    push @{$self->{hid}},$id2;\n\t    $self->{weight}->{$id2}=$w2;\n\t    $self->{length}->{$id2}=$l2;\n\t}\n\t$line=$self->_readline;\n    }\n    return $self;\n}\n\n=head2 header\n\n Title   : header\n Usage   :  my %header=$psmIO->header;\n Function:  Returns the header for the MEME file\n Throws  :\n Example : Fetching all the sequences included in the MEME analysis, \n           being parsed\n           my %header=$psmIO->header;\n            foreach my $seqid (@{$header{instances}}) {\n               my $seq=$db->get_Seq_by_acc($id);\n               #Do something with the sequence\n            }\n            where $db might be Bio::DB:GenBank object, see\n Returns : Hash with three keys: instances, weights and lengths, which\n           should be self-explenatory. Each value is an array\n           reference. Each array element corresponds to the same\n           element in the other two arrays. So $header{instances}->[$i]\n           will refer to the same sequence in the motif file as\n           $header{weights}->[$i] and $header{lengths}->[$i]\n Args    :  none\n Notes   :  OBSOLETE!\n\n\nsub header {\n    my $self=shift;\n    my @instances=@{$self->{_inst_name}};\n    my @weights=@{$self->{_inst_weight}};\n    my @lengths=@{$self->{_inst_coord}};\n    return (instances=>\\@instances,weights=>\\@weights,lengths=>\\@lengths);\n}\n\n=head2 next_psm\n\n Title   : next_psm\n Usage   : my $psm=$psmIO->next_psm();\n Function: Reads the next PSM from the input file, associated with this object\n Throws  : Throws if the format is inconsistent with the rules for MEME 3.0.4:\n            no SUMMARY Section present or some keywords are missing/altered.\n Example :\n Returns : Bio::Matrix::PSM::Psm object\n Args    : none\n\n\nsub next_psm {\n    #Parses the next prediction and returns a psm objects\n    my $self=shift;\n    return if ($self->{end});\n    my ($endm,$line,$instances,$tr,$width,$motif_id,$sites,$e_val,$id,$ic,$lA,$lC,$lG,$lT);\n    while (defined( $line = $self->_readline) ) {\n#Check if revcom is enabled, not very original check....\n  $self->{_strand}=1 if (($line=~/^Sequence name/) && ($line=~/Strand/));\n\tif ($line=~ m/\\sSite\\s/) {\n\t    $instances= $self->_parseInstance;\n\t}\n\t#Here starts the next motif\n\tif ( ($line=~/width/) && ($line=~/sites/)) {\n\t    chomp($line);\n\t    $line=~s/[\\t\\s=]+/,/g;\n\t    $line=~s/\\t/,/g;\n\t    #Parsing the general information for this prediction\n\t    ($tr,$motif_id,$tr,$width,$tr,$sites,\n\t     $tr,$tr,$tr,$e_val)=split(/,/,$line);\n\t    $self->{id}=$self->{query} . $motif_id;\n\t}\n\tif ($line =~ /content/i) {\n\t    $line=$self->_readline;\n\t    chomp($line);\n\t    $line=~s/[\\)\\(]//g;\n\t    ($ic)=split(/\\s/,$line);\n\t}\n        #Last info-prob matrix data\n\tif ($line=~/position-specific\\s+scoring matrix/) {\n\t\t($lA,$lC,$lG,$lT)=_parse_logs($self);\n\t}\n\tif ($line=~/^letter-probability\\smatrix/) {\n\t    my %matrix_dat=$self->_parseMatrix($motif_id);\n\t    my $psm= Bio::Matrix::PSM::Psm->new(%matrix_dat, \n\t\t\t\t\t       -instances=>$instances, \n\t\t\t\t\t       -e_val=>$e_val,\n\t\t\t\t\t       -IC=>$ic, \n\t\t\t\t\t       -width=>$width, \n\t\t\t\t\t       -sites=>$sites,\n\t\t\t\t\t\t   -lA=>$lA,\n\t\t\t\t\t\t   -lC=>$lC,\n\t\t\t\t\t\t   -lG=>$lG,\n\t\t\t\t\t\t   -lT=>$lT,\n\t\t\t\t\t\t   );\n\t    return $psm;\n\t}\n\tif ($line=~\"SUMMARY OF MOTIFS\") {\n\t    $self->{end}=1;\n\t    return;\n\t}\n\t$endm=1 if ($line=~/^Time\\s/); \n    }\n\tif ($endm) { #End of file found, end of current motif too, but not all predictions were made as requested (No summary)\n\t    $self->{end}=1;\n            warn \"This MEME analysis was terminated prematurely, you may have less motifs than you requested\\n\";\n\t    return;\n\t}\n    $self->throw(\"Wrong format\\n\"); # Multiple keywords not found, probably wrong format\n}\n\n=head2 _parseMatrix\n\n Title   : _parseMatrix\n Usage   :\n Function: Parses the next site matrix information in the meme file\n Throws  :\n Example :  Internal stuff\n Returns :  hash as for constructing a SiteMatrix object (see SiteMatrixI)\n Args    :  string","parameters":[{"label":"$self"},{"label":"$id"}],"label":"_parseMatrix($self,$id)"}},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_parse_logs","name":"$self","line":289},{"definition":"my","line":290,"localvar":"my","kind":13,"containerName":"_parse_logs","name":"@lA"},{"name":"@lC","containerName":"_parse_logs","kind":13,"line":290},{"kind":13,"containerName":"_parse_logs","name":"@lG","line":290},{"name":"@lT","containerName":"_parse_logs","kind":13,"line":290},{"definition":"my","name":"$i","localvar":"my","containerName":"_parse_logs","kind":13,"line":291},{"line":292,"name":"$self","kind":13,"containerName":"_parse_logs"},{"name":"_readline","kind":12,"containerName":"_parse_logs","line":292},{"name":"$self","containerName":"_parse_logs","kind":13,"line":292},{"name":"_readline","kind":12,"containerName":"_parse_logs","line":292},{"containerName":"_parse_logs","localvar":"my","kind":13,"name":"$line","line":293,"definition":"my"},{"name":"$self","containerName":"_parse_logs","kind":13,"line":293},{"name":"_readline","containerName":"_parse_logs","kind":12,"line":293},{"kind":13,"containerName":"_parse_logs","name":"$line","line":296},{"line":297,"name":"$line","containerName":"_parse_logs","kind":13},{"containerName":"_parse_logs","kind":13,"name":"$line","line":298},{"name":"$line","kind":13,"containerName":"_parse_logs","line":299},{"name":"$lA","containerName":"_parse_logs","kind":13,"line":300},{"name":"$i","containerName":"_parse_logs","kind":13,"line":300},{"line":300,"kind":13,"containerName":"_parse_logs","name":"$lC"},{"line":300,"name":"$i","containerName":"_parse_logs","kind":13},{"name":"$lG","kind":13,"containerName":"_parse_logs","line":300},{"line":300,"name":"$i","kind":13,"containerName":"_parse_logs"},{"name":"$lT","kind":13,"containerName":"_parse_logs","line":300},{"line":300,"containerName":"_parse_logs","kind":13,"name":"$i"},{"containerName":"_parse_logs","kind":13,"name":"$line","line":300},{"name":"$i","kind":13,"containerName":"_parse_logs","line":301},{"containerName":"_parse_logs","kind":13,"name":"$line","line":302},{"line":302,"kind":13,"containerName":"_parse_logs","name":"$self"},{"name":"_readline","kind":12,"containerName":"_parse_logs","line":302},{"name":"$line","kind":13,"containerName":"_parse_logs","line":303},{"line":305,"name":"@lA","kind":13,"containerName":"_parse_logs"},{"name":"@lC","containerName":"_parse_logs","kind":13,"line":305},{"line":305,"containerName":"_parse_logs","kind":13,"name":"@lG"},{"name":"@lT","kind":13,"containerName":"_parse_logs","line":305}],"name":"_parse_logs","containerName":"main::","line":288,"kind":12,"range":{"end":{"character":9999,"line":306},"start":{"line":288,"character":0}}},{"definition":"sub","children":[{"definition":"my","line":321,"localvar":"my","kind":13,"containerName":"_parseInstance","name":"$self"},{"definition":"my","line":322,"name":"$i","localvar":"my","kind":13,"containerName":"_parseInstance"},{"line":323,"name":"$self","kind":13,"containerName":"_parseInstance"},{"name":"_readline","kind":12,"containerName":"_parseInstance","line":323},{"localvar":"my","kind":13,"containerName":"_parseInstance","name":"$line","line":324,"definition":"my"},{"line":324,"name":"@instance","kind":13,"containerName":"_parseInstance"},{"line":325,"containerName":"_parseInstance","kind":13,"name":"$line"},{"line":325,"name":"$self","containerName":"_parseInstance","kind":13},{"line":325,"name":"_readline","containerName":"_parseInstance","kind":12},{"line":326,"name":"$line","containerName":"_parseInstance","kind":13},{"line":327,"name":"$line","containerName":"_parseInstance","kind":13},{"line":328,"name":"@comp","kind":13,"localvar":"my","containerName":"_parseInstance","definition":"my"},{"line":328,"name":"$line","containerName":"_parseInstance","kind":13},{"line":329,"name":"$id","localvar":"my","containerName":"_parseInstance","kind":13,"definition":"my"},{"kind":13,"containerName":"_parseInstance","name":"$start","line":329},{"name":"$score","kind":13,"containerName":"_parseInstance","line":329},{"line":329,"kind":13,"containerName":"_parseInstance","name":"$strand"},{"line":329,"kind":13,"containerName":"_parseInstance","name":"$s1"},{"line":329,"containerName":"_parseInstance","kind":13,"name":"$s2"},{"line":329,"containerName":"_parseInstance","kind":13,"name":"$s3"},{"name":"$self","kind":13,"containerName":"_parseInstance","line":330},{"name":"$id","containerName":"_parseInstance","kind":13,"line":331},{"kind":13,"containerName":"_parseInstance","name":"$strand","line":331},{"name":"$start","containerName":"_parseInstance","kind":13,"line":331},{"name":"$score","kind":13,"containerName":"_parseInstance","line":331},{"line":331,"name":"$s1","containerName":"_parseInstance","kind":13},{"kind":13,"containerName":"_parseInstance","name":"$s2","line":331},{"name":"$s3","kind":13,"containerName":"_parseInstance","line":331},{"line":331,"name":"@comp","containerName":"_parseInstance","kind":13},{"line":333,"containerName":"_parseInstance","kind":13,"name":"$id"},{"line":333,"kind":13,"containerName":"_parseInstance","name":"$start"},{"containerName":"_parseInstance","kind":13,"name":"$score","line":333},{"kind":13,"containerName":"_parseInstance","name":"$s1","line":333},{"line":333,"kind":13,"containerName":"_parseInstance","name":"$s2"},{"line":333,"name":"$s3","kind":13,"containerName":"_parseInstance"},{"kind":13,"containerName":"_parseInstance","name":"@comp","line":333},{"line":334,"name":"$strand","containerName":"_parseInstance","kind":13},{"name":"$seq","localvar":"my","containerName":"_parseInstance","kind":13,"line":336,"definition":"my"},{"kind":13,"containerName":"_parseInstance","name":"$s1","line":336},{"kind":13,"containerName":"_parseInstance","name":"$s2","line":336},{"line":336,"kind":13,"containerName":"_parseInstance","name":"$s3"},{"kind":13,"containerName":"_parseInstance","name":"$seq","line":337},{"line":338,"localvar":"my","containerName":"_parseInstance","kind":13,"name":"$col","definition":"my"},{"kind":13,"containerName":"_parseInstance","name":"$self","line":339},{"line":339,"name":"throw","containerName":"_parseInstance","kind":12},{"definition":"my","line":341,"localvar":"my","kind":13,"containerName":"_parseInstance","name":"$sid"},{"line":341,"name":"$self","kind":13,"containerName":"_parseInstance"},{"kind":13,"containerName":"_parseInstance","name":"$id","line":341},{"line":342,"name":"$instance","containerName":"_parseInstance","kind":13},{"kind":13,"containerName":"_parseInstance","name":"$i","line":342},{"kind":12,"containerName":"_parseInstance","name":"new","line":343},{"name":"$self","containerName":"_parseInstance","kind":13,"line":343},{"line":344,"containerName":"_parseInstance","kind":13,"name":"$start"},{"line":345,"kind":13,"containerName":"_parseInstance","name":"$score"},{"line":346,"name":"$seq","kind":13,"containerName":"_parseInstance"},{"kind":13,"containerName":"_parseInstance","name":"$strand","line":347},{"line":348,"containerName":"_parseInstance","kind":13,"name":"$id"},{"line":349,"name":"$sid","kind":13,"containerName":"_parseInstance"},{"name":"$i","containerName":"_parseInstance","kind":13,"line":351},{"line":353,"name":"$self","kind":13,"containerName":"_parseInstance"},{"name":"@instance","kind":13,"containerName":"_parseInstance","line":353},{"kind":13,"containerName":"_parseInstance","name":"@instance","line":354}],"containerName":"main::","name":"_parseInstance","line":320,"kind":12,"range":{"start":{"character":0,"line":320},"end":{"line":355,"character":9999}}},{"line":330,"name":"_strand","kind":12},{"line":338,"name":"comp","kind":12},{"name":"id","kind":12,"line":341},{"containerName":"Matrix::PSM::InstanceSite","kind":12,"name":"Bio","line":342},{"name":"id","kind":12,"line":343},{"name":"instances","kind":12,"line":353}],"version":5}