{"version":5,"vars":[{"kind":2,"containerName":"","name":"base","line":109},{"children":[{"name":"$class","localvar":"my","kind":13,"containerName":"new","line":122,"definition":"my"},{"name":"@args","kind":13,"containerName":"new","line":122},{"line":123,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":123},{"line":123,"name":"@args","containerName":"new","kind":13},{"name":"$matrix","kind":13,"localvar":"my","containerName":"new","line":124,"definition":"my"},{"name":"$values","containerName":"new","kind":13,"line":124},{"name":"$names","containerName":"new","kind":13,"line":124},{"line":125,"name":"$program","containerName":"new","kind":13},{"line":125,"name":"$matname","containerName":"new","kind":13},{"name":"$matid","kind":13,"containerName":"new","line":126},{"name":"$self","containerName":"new","kind":13,"line":126},{"line":126,"kind":12,"containerName":"new","name":"_rearrange"},{"name":"@args","kind":13,"containerName":"new","line":132},{"line":134,"kind":13,"containerName":"new","name":"$matrix"},{"name":"$values","containerName":"new","kind":13,"line":134},{"line":134,"name":"$names","containerName":"new","kind":13},{"line":135,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"throw","line":135},{"kind":13,"containerName":"new","name":"$program","line":137},{"containerName":"new","kind":13,"name":"$self","line":137},{"line":137,"name":"matrix_name","kind":12,"containerName":"new"},{"kind":13,"containerName":"new","name":"$program","line":137},{"name":"$program","containerName":"new","kind":13,"line":137},{"containerName":"new","kind":13,"name":"$self","line":139},{"kind":12,"containerName":"new","name":"_matrix","line":139},{"name":"$matrix","kind":13,"containerName":"new","line":139},{"line":139,"kind":13,"containerName":"new","name":"$matrix"},{"name":"$self","kind":13,"containerName":"new","line":140},{"containerName":"new","kind":12,"name":"_values","line":140},{"name":"$values","containerName":"new","kind":13,"line":140},{"kind":13,"containerName":"new","name":"$values","line":140},{"name":"$self","kind":13,"containerName":"new","line":141},{"line":141,"name":"names","containerName":"new","kind":12},{"line":141,"kind":13,"containerName":"new","name":"$names"},{"line":141,"containerName":"new","kind":13,"name":"$names"},{"line":143,"kind":13,"containerName":"new","name":"$self"},{"line":143,"name":"matrix_name","kind":12,"containerName":"new"},{"name":"$matname","containerName":"new","kind":13,"line":143},{"line":143,"kind":13,"containerName":"new","name":"$matname"},{"line":144,"containerName":"new","kind":13,"name":"$self"},{"name":"matrix_id","kind":12,"containerName":"new","line":144},{"line":144,"name":"$matid","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$matid","line":144},{"line":146,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":121,"kind":12,"range":{"start":{"character":0,"line":121},"end":{"character":9999,"line":147}},"signature":{"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"line":123,"name":"SUPER","kind":12,"containerName":"new"},{"definition":"sub","detail":"($self,$row,$column)","children":[{"name":"$self","containerName":"get_entry","localvar":"my","kind":13,"line":160,"definition":"my"},{"containerName":"get_entry","kind":13,"name":"$row","line":160},{"name":"$column","containerName":"get_entry","kind":13,"line":160},{"name":"$row","kind":13,"containerName":"get_entry","line":161},{"line":161,"name":"$column","containerName":"get_entry","kind":13},{"kind":13,"containerName":"get_entry","name":"$self","line":161},{"line":161,"name":"throw","containerName":"get_entry","kind":12},{"definition":"my","name":"%matrix","containerName":"get_entry","localvar":"my","kind":13,"line":162},{"containerName":"get_entry","kind":13,"name":"$self","line":162},{"name":"_matrix","kind":12,"containerName":"get_entry","line":162}],"name":"get_entry","containerName":"main::","signature":{"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2","parameters":[{"label":"$self"},{"label":"$row"},{"label":"$column"}],"label":"get_entry($self,$row,$column)"},"line":159,"range":{"end":{"character":9999,"line":162},"start":{"character":0,"line":159}},"kind":12},{"kind":13,"localvar":"my","containerName":null,"name":"@values","line":163,"definition":"my"},{"name":"$self","kind":13,"containerName":null,"line":163},{"name":"_values","kind":12,"containerName":"main::","line":163},{"name":"%matrix","containerName":null,"kind":13,"line":164},{"name":"%row","kind":13,"containerName":null,"line":164},{"line":164,"name":"%column","kind":13,"containerName":null},{"definition":"my","line":165,"localvar":"my","containerName":null,"kind":13,"name":"$i"},{"line":165,"containerName":null,"kind":13,"name":"$j"},{"containerName":null,"kind":13,"name":"%matrix","line":165},{"line":165,"name":"%row","kind":13,"containerName":null},{"line":165,"name":"$column","containerName":null,"kind":13},{"line":166,"kind":13,"containerName":null,"name":"@values"},{"line":166,"name":"@i","kind":13,"containerName":null},{"line":166,"name":"$j","kind":13,"containerName":null},{"containerName":"main::","name":"get_row","children":[{"line":183,"localvar":"my","kind":13,"containerName":"get_row","name":"$self","definition":"my"},{"kind":13,"containerName":"get_row","name":"$row","line":183},{"name":"$row","kind":13,"containerName":"get_row","line":184},{"containerName":"get_row","kind":13,"name":"$self","line":184},{"containerName":"get_row","kind":12,"name":"throw","line":184},{"definition":"my","line":186,"name":"%matrix","localvar":"my","kind":13,"containerName":"get_row"},{"containerName":"get_row","kind":13,"name":"$self","line":186},{"kind":12,"containerName":"get_row","name":"_matrix","line":186}],"detail":"($self,$row)","definition":"sub","range":{"start":{"character":0,"line":182},"end":{"character":9999,"line":186}},"kind":12,"line":182,"signature":{"parameters":[{"label":"$self"},{"label":"$row"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1","label":"get_row($self,$row)"}},{"line":187,"containerName":null,"localvar":"my","kind":13,"name":"@values","definition":"my"},{"kind":13,"containerName":null,"name":"$self","line":187},{"line":187,"containerName":"main::","kind":12,"name":"_values"},{"definition":"my","name":"@names","kind":13,"localvar":"my","containerName":null,"line":188},{"containerName":null,"kind":13,"name":"$self","line":188},{"line":188,"containerName":"main::","kind":12,"name":"names"},{"line":189,"name":"%matrix","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$row","line":189},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$val","line":190},{"line":190,"name":"%matrix","containerName":null,"kind":13},{"line":190,"kind":13,"containerName":null,"name":"$row"},{"definition":"my","line":191,"kind":13,"localvar":"my","containerName":null,"name":"$row_pointer"},{"name":"@val","kind":13,"containerName":null,"line":191},{"definition":"my","line":192,"kind":13,"localvar":"my","containerName":null,"name":"$index"},{"line":192,"name":"@names","kind":13,"containerName":null},{"name":"@values","kind":13,"containerName":null,"line":193},{"kind":13,"containerName":null,"name":"@row_pointer","line":193},{"name":"$index","kind":13,"containerName":null,"line":193},{"definition":"sub","detail":"($self,$column)","children":[{"line":207,"name":"$self","kind":13,"localvar":"my","containerName":"get_column","definition":"my"},{"name":"$column","containerName":"get_column","kind":13,"line":207},{"line":208,"name":"$column","containerName":"get_column","kind":13},{"name":"$self","containerName":"get_column","kind":13,"line":208},{"kind":12,"containerName":"get_column","name":"throw","line":208},{"localvar":"my","containerName":"get_column","kind":13,"name":"%matrix","line":210,"definition":"my"},{"name":"$self","containerName":"get_column","kind":13,"line":210},{"line":210,"name":"_matrix","kind":12,"containerName":"get_column"}],"containerName":"main::","name":"get_column","signature":{"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1","parameters":[{"label":"$self"},{"label":"$column"}],"label":"get_column($self,$column)"},"line":206,"kind":12,"range":{"start":{"line":206,"character":0},"end":{"character":9999,"line":210}}},{"containerName":null,"localvar":"my","kind":13,"name":"@values","line":211,"definition":"my"},{"line":211,"name":"$self","containerName":null,"kind":13},{"kind":12,"containerName":"main::","name":"_values","line":211},{"localvar":"my","kind":13,"containerName":null,"name":"@names","line":212,"definition":"my"},{"line":212,"containerName":null,"kind":13,"name":"$self"},{"kind":12,"containerName":"main::","name":"names","line":212},{"name":"%matrix","kind":13,"containerName":null,"line":213},{"containerName":null,"kind":13,"name":"$column","line":213},{"line":214,"kind":13,"localvar":"my","containerName":null,"name":"$val","definition":"my"},{"containerName":null,"kind":13,"name":"%matrix","line":214},{"kind":13,"containerName":null,"name":"$column","line":214},{"line":215,"containerName":null,"localvar":"my","kind":13,"name":"$row_pointer","definition":"my"},{"line":215,"name":"@val","kind":13,"containerName":null},{"line":216,"containerName":null,"localvar":"my","kind":13,"name":"@ret","definition":"my"},{"line":217,"localvar":"my","containerName":null,"kind":13,"name":"$i","definition":"my"},{"name":"$i","kind":13,"containerName":null,"line":217},{"line":217,"kind":13,"containerName":null,"name":"@names"},{"name":"%i","kind":13,"containerName":null,"line":217},{"line":218,"kind":13,"containerName":null,"name":"@ret"},{"line":218,"name":"@values","kind":13,"containerName":null},{"line":218,"containerName":null,"kind":13,"name":"@i"},{"line":218,"containerName":null,"kind":13,"name":"$row_pointer"},{"name":"@ret","containerName":null,"kind":13,"line":220},{"signature":{"label":"get_diagonal($self)","documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":235},"start":{"line":233,"character":0}},"kind":12,"line":233,"detail":"($self)","definition":"sub","name":"get_diagonal","containerName":"main::","children":[{"definition":"my","line":234,"containerName":"get_diagonal","localvar":"my","kind":13,"name":"$self"},{"definition":"my","line":235,"containerName":"get_diagonal","localvar":"my","kind":13,"name":"%matrix"},{"kind":13,"containerName":"get_diagonal","name":"$self","line":235},{"name":"_matrix","containerName":"get_diagonal","kind":12,"line":235}]},{"definition":"my","line":236,"name":"@values","kind":13,"localvar":"my","containerName":null},{"line":236,"name":"$self","containerName":null,"kind":13},{"name":"_values","kind":12,"containerName":"main::","line":236},{"name":"@return","kind":13,"localvar":"my","containerName":null,"line":237,"definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":null,"name":"$name","line":238},{"name":"$self","containerName":null,"kind":13,"line":238},{"kind":12,"containerName":"main::","name":"names","line":238},{"localvar":"my","kind":13,"containerName":null,"name":"$i","line":239,"definition":"my"},{"containerName":null,"kind":13,"name":"$j","line":239},{"line":239,"kind":13,"containerName":null,"name":"%matrix"},{"containerName":null,"kind":13,"name":"%name","line":239},{"line":239,"kind":13,"containerName":null,"name":"$name"},{"line":240,"name":"@return","containerName":null,"kind":13},{"line":240,"name":"@values","containerName":null,"kind":13},{"line":240,"name":"@i","kind":13,"containerName":null},{"line":240,"name":"$j","containerName":null,"kind":13},{"line":242,"containerName":null,"kind":13,"name":"@return"},{"signature":{"label":"print_matrix($self)","documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  ","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":257,"character":9999},"start":{"character":0,"line":255}},"line":255,"detail":"($self)","definition":"sub","name":"print_matrix","containerName":"main::","children":[{"definition":"my","line":256,"localvar":"my","kind":13,"containerName":"print_matrix","name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"print_matrix","name":"@names","line":257},{"line":257,"kind":13,"containerName":"print_matrix","name":"$self"},{"kind":12,"containerName":"print_matrix","name":"names","line":257}]},{"definition":"my","line":258,"localvar":"my","kind":13,"containerName":null,"name":"@values"},{"containerName":null,"kind":13,"name":"$self","line":258},{"line":258,"name":"_values","containerName":"main::","kind":12},{"definition":"my","name":"%matrix","containerName":null,"localvar":"my","kind":13,"line":259},{"containerName":null,"kind":13,"name":"$self","line":259},{"line":259,"kind":12,"containerName":"main::","name":"_matrix"},{"kind":13,"localvar":"my","containerName":null,"name":"$str","line":260,"definition":"my"},{"name":"$str","kind":13,"containerName":null,"line":261},{"line":261,"name":"@names","containerName":null,"kind":13},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$name","line":262},{"name":"@names","containerName":null,"kind":13,"line":262},{"line":263,"localvar":"my","kind":13,"containerName":null,"name":"$newname","definition":"my"},{"line":263,"name":"$name","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$name","line":263},{"kind":13,"containerName":null,"name":"%name","line":264},{"line":264,"kind":13,"containerName":null,"name":"$newname"},{"line":265,"name":"$str","kind":13,"containerName":null},{"line":265,"containerName":null,"kind":13,"name":"$newname"},{"name":"$count","containerName":null,"localvar":"my","kind":13,"line":266,"definition":"my"},{"definition":"my","line":267,"name":"$n","containerName":null,"localvar":"my","kind":13},{"line":267,"name":"@names","kind":13,"containerName":null},{"localvar":"my","containerName":null,"kind":13,"name":"$i","line":268,"definition":"my"},{"line":268,"name":"$j","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%matrix","line":268},{"line":268,"kind":13,"containerName":null,"name":"%name"},{"name":"$n","kind":13,"containerName":null,"line":268},{"line":269,"name":"$count","containerName":null,"kind":13},{"line":269,"kind":12,"name":"names"},{"line":270,"name":"$str","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@values","line":270},{"line":270,"containerName":null,"kind":13,"name":"@i"},{"line":270,"name":"%j","containerName":null,"kind":13},{"line":273,"containerName":null,"kind":13,"name":"@values"},{"containerName":null,"kind":13,"name":"@i","line":273},{"name":"%j","containerName":null,"kind":13,"line":273},{"line":274,"name":"$self","kind":13,"containerName":null},{"containerName":"main::","kind":12,"name":"debug","line":274},{"line":276,"containerName":null,"kind":13,"name":"$str"},{"name":"@values","kind":13,"containerName":null,"line":276},{"line":276,"kind":13,"containerName":null,"name":"@i"},{"line":276,"kind":13,"containerName":null,"name":"$j"},{"line":279,"kind":13,"containerName":null,"name":"$count"},{"containerName":null,"kind":13,"name":"$str","line":281},{"line":283,"name":"$str","kind":13,"containerName":null},{"definition":"sub","detail":"($self,$val)","children":[{"line":298,"containerName":"_matrix","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":298,"name":"$val","containerName":"_matrix","kind":13},{"name":"$val","kind":13,"containerName":"_matrix","line":299},{"line":300,"containerName":"_matrix","kind":13,"name":"$self"},{"line":300,"name":"$val","kind":13,"containerName":"_matrix"},{"name":"$self","kind":13,"containerName":"_matrix","line":302}],"name":"_matrix","containerName":"main::","signature":{"label":"_matrix($self,$val)","documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference","parameters":[{"label":"$self"},{"label":"$val"}]},"line":297,"range":{"end":{"character":9999,"line":303},"start":{"line":297,"character":0}},"kind":12},{"signature":{"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference","parameters":[{"label":"$self"},{"label":"$val"}],"label":"names($self,$val)"},"line":316,"kind":12,"range":{"start":{"line":316,"character":0},"end":{"line":322,"character":9999}},"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"names","kind":13,"line":317},{"containerName":"names","kind":13,"name":"$val","line":317},{"line":318,"kind":13,"containerName":"names","name":"$val"},{"line":319,"name":"$self","kind":13,"containerName":"names"},{"line":319,"name":"$val","containerName":"names","kind":13},{"containerName":"names","kind":13,"name":"$self","line":321}],"name":"names","containerName":"main::"},{"line":335,"range":{"start":{"character":0,"line":335},"end":{"character":9999,"line":338}},"kind":12,"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"program","line":336,"definition":"my"},{"containerName":"program","kind":13,"name":"$self","line":337},{"kind":12,"containerName":"program","name":"matrix_name","line":337}],"name":"program","containerName":"main::"},{"line":351,"range":{"start":{"line":351,"character":0},"end":{"line":357,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference","parameters":[{"label":"$self"},{"label":"$val"}],"label":"_values($self,$val)"},"children":[{"definition":"my","localvar":"my","containerName":"_values","kind":13,"name":"$self","line":352},{"kind":13,"containerName":"_values","name":"$val","line":352},{"name":"$val","containerName":"_values","kind":13,"line":353},{"line":354,"name":"$self","containerName":"_values","kind":13},{"line":354,"containerName":"_values","kind":13,"name":"$val"},{"line":356,"kind":13,"containerName":"_values","name":"$self"}],"name":"_values","containerName":"main::","definition":"sub","detail":"($self,$val)"},{"definition":"sub","children":[{"line":375,"localvar":"my","containerName":"matrix_id","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"matrix_id","name":"$self","line":376},{"line":377,"name":"$self","containerName":"matrix_id","kind":13}],"name":"matrix_id","containerName":"main::","line":374,"range":{"start":{"line":374,"character":0},"end":{"character":9999,"line":380}},"kind":12},{"children":[{"containerName":"matrix_name","localvar":"my","kind":13,"name":"$self","line":394,"definition":"my"},{"name":"$self","containerName":"matrix_name","kind":13,"line":395},{"line":396,"containerName":"matrix_name","kind":13,"name":"$self"}],"containerName":"main::","name":"matrix_name","definition":"sub","line":393,"kind":12,"range":{"end":{"character":9999,"line":397},"start":{"line":393,"character":0}}},{"detail":"($self,$num)","definition":"sub","name":"column_header","containerName":"main::","children":[{"line":411,"localvar":"my","containerName":"column_header","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"column_header","name":"$num","line":411},{"definition":"my","name":"@coln","containerName":"column_header","localvar":"my","kind":13,"line":412},{"kind":13,"containerName":"column_header","name":"$self","line":412},{"line":412,"kind":12,"containerName":"column_header","name":"column_names"},{"containerName":"column_header","kind":13,"name":"$coln","line":413},{"kind":13,"containerName":"column_header","name":"$num","line":413}],"signature":{"label":"column_header($self,$num)","documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference\n\n\nsub _values {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_values'} = $val;\n  }\n  return $self->{'_values'};\n}\n\n\n=head1 L<Bio::Matrix::MatrixI> implementation\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$num"}]},"range":{"end":{"character":9999,"line":414},"start":{"character":0,"line":410}},"kind":12,"line":410},{"children":[{"definition":"my","line":429,"name":"$self","localvar":"my","kind":13,"containerName":"row_header"},{"name":"$num","containerName":"row_header","kind":13,"line":429},{"definition":"my","line":430,"name":"@rown","kind":13,"localvar":"my","containerName":"row_header"},{"line":430,"name":"$self","kind":13,"containerName":"row_header"},{"containerName":"row_header","kind":12,"name":"row_names","line":430},{"line":431,"containerName":"row_header","kind":13,"name":"$rown"},{"line":431,"containerName":"row_header","kind":13,"name":"$num"}],"name":"row_header","containerName":"main::","definition":"sub","detail":"($self,$num)","line":428,"kind":12,"range":{"start":{"character":0,"line":428},"end":{"line":432,"character":9999}},"signature":{"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference\n\n\nsub _values {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_values'} = $val;\n  }\n  return $self->{'_values'};\n}\n\n\n=head1 L<Bio::Matrix::MatrixI> implementation\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n    my ($self,$num) = @_;\n    my @coln = $self->column_names;\n    return $coln[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer","parameters":[{"label":"$self"},{"label":"$num"}],"label":"row_header($self,$num)"}},{"containerName":"main::","name":"column_num_for_name","children":[{"definition":"my","containerName":"column_num_for_name","localvar":"my","kind":13,"name":"$self","line":445},{"containerName":"column_num_for_name","kind":13,"name":"$name","line":445},{"definition":"my","line":446,"name":"$ct","localvar":"my","containerName":"column_num_for_name","kind":13},{"definition":"my","name":"$n","localvar":"my","containerName":"column_num_for_name","kind":13,"line":447},{"line":447,"containerName":"column_num_for_name","kind":13,"name":"$self"},{"line":447,"name":"column_names","containerName":"column_num_for_name","kind":12},{"line":448,"name":"$ct","containerName":"column_num_for_name","kind":13},{"line":448,"containerName":"column_num_for_name","kind":13,"name":"$n"},{"line":448,"containerName":"column_num_for_name","kind":13,"name":"$name"},{"containerName":"column_num_for_name","kind":13,"name":"$ct","line":449}],"detail":"($self,$name)","definition":"sub","range":{"end":{"line":452,"character":9999},"start":{"line":444,"character":0}},"kind":12,"line":444,"signature":{"label":"column_num_for_name($self,$name)","documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference\n\n\nsub _values {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_values'} = $val;\n  }\n  return $self->{'_values'};\n}\n\n\n=head1 L<Bio::Matrix::MatrixI> implementation\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n    my ($self,$num) = @_;\n    my @coln = $self->column_names;\n    return $coln[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n    my ($self,$num) = @_;\n    my @rown = $self->row_names;\n   return $rown[$num];\n}\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string","parameters":[{"label":"$self"},{"label":"$name"}]}},{"children":[{"name":"$self","kind":13,"localvar":"my","containerName":"row_num_for_name","line":466,"definition":"my"},{"kind":13,"containerName":"row_num_for_name","name":"$name","line":466},{"definition":"my","name":"$ct","localvar":"my","containerName":"row_num_for_name","kind":13,"line":467},{"definition":"my","localvar":"my","kind":13,"containerName":"row_num_for_name","name":"$n","line":468},{"containerName":"row_num_for_name","kind":13,"name":"$self","line":468},{"name":"row_names","kind":12,"containerName":"row_num_for_name","line":468},{"name":"$ct","kind":13,"containerName":"row_num_for_name","line":469},{"containerName":"row_num_for_name","kind":13,"name":"$n","line":469},{"name":"$name","kind":13,"containerName":"row_num_for_name","line":469},{"line":470,"containerName":"row_num_for_name","kind":13,"name":"$ct"}],"name":"row_num_for_name","containerName":"main::","definition":"sub","detail":"($self,$name)","line":465,"range":{"end":{"character":9999,"line":472},"start":{"line":465,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# BioPerl module for Bio::Matrix::PhylipDist\n#\n# $Id: PhylipDist.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Shawn Hoon <shawnh@fugu-sg.org>\n#\n# Copyright Shawn Hoon\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::PhylipDist - A Phylip Distance Matrix object \n\n=head1 SYNOPSIS\n\n  use Bio::Tools::Phylo::Phylip::ProtDist;\n  my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -file=>\"protdist.out\",\n    -program=>\"ProtDist\");\n  #or\n   my $dist = Bio::Tools::Phylo::Phylip::ProtDist->new(\n    -fh=>\"protdist.out\",\n    -program=>\"ProtDist\");\n\n\n  #get specific entries\n  my $distance_value = $dist->get_entry('ALPHA','BETA');\n  my @columns        = $dist->get_column('ALPHA');\n  my @rows           = $dist->get_row('BETA');\n  my @diagonal       = $dist->get_diagonal();\n\n  #print the matrix in phylip numerical format\n  print $dist->print_matrix;\n\n=head1 DESCRIPTION\n\nSimple object for holding Distance Matrices generated by the following Phylip programs:\n\n1) dnadist\n2) protdist\n3) restdist\n\nIt currently handles parsing of the matrix without the data output option.\n\n    5\nAlpha          0.00000  4.23419  3.63330  6.20865  3.45431\nBeta           4.23419  0.00000  3.49289  3.36540  4.29179\nGamma          3.63330  3.49289  0.00000  3.68733  5.84929\nDelta          6.20865  3.36540  3.68733  0.00000  4.43345\nEpsilon        3.45431  4.29179  5.84929  4.43345  0.00000\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Shawn Hoon\n\nEmail shawnh@fugu-sg.org\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\npackage Bio::Matrix::PhylipDist;\nuse strict;\n\n\nuse base qw(Bio::Root::Root Bio::Matrix::MatrixI);\n\n=head2 new\n\n Title   : new\n Usage   : my $family = Bio::Matrix::PhylipDist->new(-file=>\"protdist.out\",\n                                                     -program=>\"protdist\");\n Function: Constructor for PhylipDist Object\n Returns : L<Bio::Matrix::PhylipDist>\n\n\nsub new {\n    my ($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($matrix,$values, $names,\n\t$program,$matname,\n\t$matid) = $self->_rearrange([qw(MATRIX \n\t\t\t\t\tVALUES \n\t\t\t\t\tNAMES \n\t\t\t\t\tPROGRAM\n\t\t\t\t\tMATRIX_NAME\n\t\t\t\t\tMATRIX_ID\n\t\t\t\t\t)],@args);\n    \n    ($matrix && $values && $names) || \n\t$self->throw(\"Need matrix, values, and names fields all provided!\");\n\n    $program && $self->matrix_name($program) if defined $program;\n    \n    $self->_matrix($matrix) if ref($matrix) =~ /HASH/i;\n    $self->_values($values) if ref($values) =~ /ARRAY/i;\n    $self->names($names) if ref($names) =~ /ARRAY/i;\n\n    $self->matrix_name($matname) if defined $matname;\n    $self->matrix_id  ($matid)   if defined $matid;\n\n    return $self;\n}\n\n=head2 get_entry\n\n Title   : get_entry\n Usage   : $matrix->get_entry();\n Function: returns a particular entry \n Returns : a float\n Arguments:  string id1, string id2\n\n\nsub get_entry {\n  my ($self,$row,$column) = @_;\n  $row && $column || $self->throw(\"Need at least 2 ids\");\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  if(ref $matrix{$row}{$column}){\n      my ($i,$j) = @{$matrix{$row}{$column}};\n      return $values[$i][$j];\n  }\n  return;\n\n}\n\n=head2 get_row\n\n Title   : get_row\n Usage   : $matrix->get_row('ALPHA');\n Function: returns a particular row \n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_row {\n    my ($self,$row) = @_;\n    $row || $self->throw(\"Need at least a row id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names};\n    $matrix{$row} || return;\n    my ($val) = values %{$matrix{$row}};\n    my $row_pointer = $val->[0];\n    my $index = scalar(@names)-1;\n    return @{$values[$row_pointer]}[0..$index];\n}\n\n=head2 get_column\n\n Title   : get_column\n Usage   : $matrix->get_column('ALPHA');\n Function: returns a particular column \n Returns : an array of floats \n Arguments:  string id1\n\n\nsub get_column {\n    my ($self,$column) = @_;\n    $column || $self->throw(\"Need at least a column id\");\n\n    my %matrix = %{$self->_matrix};\n    my @values = @{$self->_values};\n    my @names = @{$self->names}; \n    $matrix{$column} || return ();\n    my ($val) = values %{$matrix{$column}};\n    my $row_pointer = $val->[0];\n    my @ret;\n    for(my $i=0; $i < scalar(@names); $i++) {\n\tpush @ret, $values[$i][$row_pointer];\n    }\n    return @ret;\n} \n\n=head2 get_diagonal\n\n Title   : get_diagonal\n Usage   : $matrix->get_diagonal();\n Function: returns the diagonal of the matrix\n Returns : an array of float\n Arguments:  string id1\n\n\nsub get_diagonal {\n  my ($self) = @_;\n  my %matrix = %{$self->_matrix};\n  my @values = @{$self->_values};\n  my @return;\n  foreach my $name (@{$self->names}){\n    my ($i,$j) = @{$matrix{$name}{$name}};\n    push @return,$values[$i][$j];\n  }\n  return @return;\n}\n\n=head2 print_matrix\n\n Title   : print_matrix\n Usage   : $matrix->print_matrix();\n Function: returns a string of the matrix in phylip format \n Returns : a string\n Arguments:  \n\n\nsub print_matrix {\n  my ($self) = @_;\n  my @names = @{$self->names};\n  my @values = @{$self->_values};\n  my %matrix = %{$self->_matrix};\n  my $str;\n  $str.= (\" \"x 4). scalar(@names).\"\\n\";\n  foreach my $name (@names){\n    my $newname = $name. (\" \" x (15-length($name)));\n    if( length($name) >= 15 ) { $newname .= \" \" }\n    $str.=$newname;\n    my $count = 0;\n    foreach my $n (@names) {\n      my ($i,$j) = @{$matrix{$name}{$n}};\n      if($count < $#names){\n        $str .= $values[$i][$j]. \"  \";\n      }\n      else {\n\t  if( ! defined $values[$i][$j] ) { \n\t      $self->debug(\"no value for $i,$j cell\\n\");\n\t  } else { \n\t      $str .= $values[$i][$j];\n\t  }\n      }\n      $count++;\n    }\n    $str.=\"\\n\";\n  }\n  return $str;\n}\n\n=head2 _matrix\n\n Title   : _matrix\n Usage   : $matrix->_matrix();\n Function: get/set for hash reference of the pointers\n           to the value matrix \n Returns : hash reference \n Arguments: hash reference\n\n\nsub _matrix {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_matrix'} = $val;\n  }\n  return $self->{'_matrix'};\n}\n\n\n=head2 names\n\n Title   : names\n Usage   : $matrix->names();\n Function: get/set for array ref of names of sequences\n Returns : an array reference \n Arguments: an array reference\n\n\nsub names {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_names'} = $val;\n  }\n  return $self->{'_names'};\n}\n\n=head2 program\n\n Title   : program\n Usage   : $matrix->program();\n Function: get/set for the program name generating this \n           matrix\n Returns : string\n Arguments: string\n\n\nsub program {\n  my ($self) = shift;\n  return $self->matrix_name(@_);\n}\n\n=head2 _values\n\n Title   : _values\n Usage   : $matrix->_values();\n Function: get/set for array ref of the matrix containing\n           distance values \n Returns : an array reference \n Arguments: an array reference\n\n\nsub _values {\n  my ($self,$val) = @_;\n  if($val){\n    $self->{'_values'} = $val;\n  }\n  return $self->{'_values'};\n}\n\n\n=head1 L<Bio::Matrix::MatrixI> implementation\n\n\n=head2 matrix_id\n\n Title   : matrix_id\n Usage   : my $id = $matrix->matrix_id\n Function: Get/Set the matrix ID\n Returns : scalar value\n Args    : [optional] new id value to store\n\n\n\nsub matrix_id{\n   my $self = shift;\n   return $self->{'_matid'} = shift if @_;\n   return $self->{'_matid'};\n\n   \n}\n\n=head2 matrix_name\n\n Title   : matrix_name\n Usage   : my $name = $matrix->matrix_name();\n Function: Get/Set the matrix name\n Returns : scalar value\n Args    : [optional] new matrix name value\n\n\n\nsub matrix_name{\n   my $self = shift;\n   return $self->{'_matname'} = shift if @_;\n   return $self->{'_matname'};\n}\n\n=head2 column_header\n\n Title   : column_header\n Usage   : my $name = $matrix->column_header(0)\n Function: Gets the column header for a particular column number\n Returns : string\n Args    : integer\n\n\n\nsub column_header{\n    my ($self,$num) = @_;\n    my @coln = $self->column_names;\n    return $coln[$num];\n}\n\n\n=head2 row_header\n\n Title   : row_header\n Usage   : my $name = $matrix->row_header(0)\n Function: Gets the row header for a particular row number\n Returns : string\n Args    : integer\n\n\n\nsub row_header{\n    my ($self,$num) = @_;\n    my @rown = $self->row_names;\n   return $rown[$num];\n}\n=head2 column_num_for_name\n\n Title   : column_num_for_name\n Usage   : my $num = $matrix->column_num_for_name($name)\n Function: Gets the column number for a particular column name\n Returns : integer\n Args    : string\n\n\n\nsub column_num_for_name{\n   my ($self,$name) = @_;\n   my $ct = 0;\n   foreach my $n ( $self->column_names ) {\n       return $ct if $n eq $name;\n       $ct++;\n   }\n   return;\n}\n\n=head2 row_num_for_name\n\n Title   : row_num_for_name\n Usage   : my $num = $matrix->row_num_for_name($name)\n Function: Gets the row number for a particular row name\n Returns : integer\n Args    : string","label":"row_num_for_name($self,$name)"}},{"definition":"sub","containerName":"main::","name":"num_rows","children":[{"line":485,"name":"names","containerName":"num_rows","kind":12}],"kind":12,"range":{"end":{"line":485,"character":9999},"start":{"character":0,"line":485}},"line":485},{"name":"shift","kind":12,"line":485},{"definition":"sub","containerName":"main::","name":"num_columns","children":[{"name":"names","kind":12,"containerName":"num_columns","line":499}],"kind":12,"range":{"start":{"line":498,"character":0},"end":{"line":499,"character":9999}},"line":498},{"line":499,"name":"shift","kind":12},{"definition":"sub","children":[{"line":513,"name":"names","containerName":"row_names","kind":12}],"containerName":"main::","name":"row_names","line":513,"range":{"start":{"character":0,"line":513},"end":{"character":9999,"line":513}},"kind":12},{"line":513,"name":"shift","kind":12},{"definition":"sub","children":[{"line":526,"name":"names","containerName":"column_names","kind":12}],"containerName":"main::","name":"column_names","line":526,"kind":12,"range":{"end":{"character":9999,"line":526},"start":{"line":526,"character":0}}},{"name":"shift","kind":12,"line":526}]}