{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":91},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Path.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Path\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net> \n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Path - a path for an ontology term graph\n\n=head1 SYNOPSIS\n\n  $path = Bio::Ontology::Path->new( -identifier     => \"16847\",\n                                    -subject_term   => $subj,\n                                    -object_term    => $obj,\n                                    -predicate_term => $pred,\n                                    -distance       => 3 );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::PathI.\n\nEssiantially this is a very thin extension of\nL<Bio::Ontology::Relationship>. It basically adds a method distance().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Hilmar Lapp <hlapp@gmx.net>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Path;\nuse strict;\n\nuse base qw(Bio::Ontology::Relationship Bio::Ontology::PathI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Path->new(-identifier   => \"16847\",\n                                           -subject_term => $subject,\n                                           -object_term  => $object,\n                                           -predicate_term => $type );\n                                           -distance     => 3 );\n Function: Creates a new Bio::Ontology::Path.\n Returns : A new Bio::Ontology::Path object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n           -distance       => the distance between subject and object"},"line":114,"range":{"start":{"line":114,"character":0},"end":{"character":9999,"line":128}},"kind":12,"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":116,"name":"$class","containerName":"new","localvar":"my","kind":13},{"line":116,"containerName":"new","kind":13,"name":"@args"},{"localvar":"my","kind":13,"containerName":"new","name":"$self","line":118,"definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":118},{"kind":13,"containerName":"new","name":"@args","line":118},{"containerName":"new","localvar":"my","kind":13,"name":"$distance","line":120,"definition":"my"},{"name":"$self","containerName":"new","kind":13,"line":121},{"kind":12,"containerName":"new","name":"_rearrange","line":121},{"line":122,"kind":13,"containerName":"new","name":"@args"},{"line":124,"name":"$distance","kind":13,"containerName":"new"},{"line":124,"name":"$self","kind":13,"containerName":"new"},{"line":124,"name":"distance","kind":12,"containerName":"new"},{"line":124,"name":"$distance","containerName":"new","kind":13},{"line":126,"kind":13,"containerName":"new","name":"$self"}],"name":"new","containerName":"main::"},{"containerName":"new","kind":12,"name":"SUPER","line":118},{"kind":12,"range":{"end":{"character":9999,"line":148},"start":{"line":142,"character":0}},"line":142,"containerName":"main::","name":"init","children":[{"definition":"my","line":143,"localvar":"my","containerName":"init","kind":13,"name":"$self"},{"name":"$self","containerName":"init","kind":13,"line":145},{"kind":13,"containerName":"init","name":"$self","line":146}],"definition":"sub"},{"line":145,"kind":12,"containerName":"init","name":"SUPER"},{"line":169,"kind":12,"range":{"end":{"character":9999,"line":174},"start":{"character":0,"line":169}},"definition":"sub","children":[{"definition":"my","line":170,"containerName":"distance","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"distance","line":172},{"line":173,"kind":13,"containerName":"distance","name":"$self"}],"containerName":"main::","name":"distance"},{"children":[{"localvar":"my","kind":13,"containerName":"to_string","name":"$self","line":187,"definition":"my"},{"definition":"my","line":189,"localvar":"my","kind":13,"containerName":"to_string","name":"$s"},{"kind":13,"containerName":"to_string","name":"$self","line":189},{"kind":13,"containerName":"to_string","name":"$s","line":190},{"name":"$s","kind":13,"containerName":"to_string","line":191},{"kind":13,"containerName":"to_string","name":"$self","line":191},{"name":"distance","kind":12,"containerName":"to_string","line":191},{"line":191,"name":"$self","containerName":"to_string","kind":13},{"line":191,"name":"distance","kind":12,"containerName":"to_string"},{"line":192,"name":"$s","kind":13,"containerName":"to_string"},{"line":194,"name":"$s","kind":13,"containerName":"to_string"}],"name":"to_string","containerName":"main::","definition":"sub","detail":"($self)","line":186,"kind":12,"range":{"start":{"character":0,"line":186},"end":{"line":196,"character":9999}},"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Path.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Path\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net> \n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2003.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2003.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Path - a path for an ontology term graph\n\n=head1 SYNOPSIS\n\n  $path = Bio::Ontology::Path->new( -identifier     => \"16847\",\n                                    -subject_term   => $subj,\n                                    -object_term    => $obj,\n                                    -predicate_term => $pred,\n                                    -distance       => 3 );\n\n=head1 DESCRIPTION\n\nThis is a basic implementation of Bio::Ontology::PathI.\n\nEssiantially this is a very thin extension of\nL<Bio::Ontology::Relationship>. It basically adds a method distance().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Hilmar Lapp <hlapp@gmx.net>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Ontology::Path;\nuse strict;\n\nuse base qw(Bio::Ontology::Relationship Bio::Ontology::PathI);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $rel = Bio::Ontology::Path->new(-identifier   => \"16847\",\n                                           -subject_term => $subject,\n                                           -object_term  => $object,\n                                           -predicate_term => $type );\n                                           -distance     => 3 );\n Function: Creates a new Bio::Ontology::Path.\n Returns : A new Bio::Ontology::Path object.\n Args    : -identifier     => the identifier of this relationship [scalar]\n           -subject_term   => the subject term [Bio::Ontology::TermI]\n           -object_term    => the object term [Bio::Ontology::TermI]  \n           -predicate_term => the predicate term [Bio::Ontology::TermI]\n           -distance       => the distance between subject and object\n\n\nsub new {\n\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $distance ) = \n\t$self->_rearrange( [qw( DISTANCE)\n\t\t\t    ], @args );\n   \n    $distance      && $self->distance($distance);\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $rel->init();   \n Function: Initializes this Path to all undef.\n Returns : \n Args    :\n\n\nsub init {\n    my $self = shift;\n    \n    $self->SUPER::init(@_);\n    $self->{ \"_distance\" } = undef;\n   \n} # init\n\n\n=head2 distance\n\n Title   : distance\n Usage   : $obj->distance($newval)\n Function: Get/set the distance between the two terms connected\n           by this path.\n\n           Note that modifying the distance may not be meaningful. The\n           implementation here is not connected to any graph engine,\n           so changing an existing value may simply render the\n           attribute's value wrong.\n\n Example : \n Returns : value of distance (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub distance{\n    my $self = shift;\n\n    return $self->{'_distance'} = shift if @_;\n    return $self->{'_distance'};\n}\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $rel->to_string();\n Function: to_string method for Path.\n Returns : A string representation of this Path.\n Args    :","label":"to_string($self)"}},{"line":189,"name":"SUPER","kind":12,"containerName":"to_string"}]}