{"vars":[{"kind":14,"containerName":"main::","name":"PART_OF","line":99,"definition":1},{"line":99,"name":"strict","kind":12,"containerName":""},{"name":"RELATED_TO","containerName":"main::","kind":14,"line":100,"definition":1},{"definition":1,"line":101,"kind":14,"containerName":"main::","name":"IS_A"},{"containerName":"main::","kind":14,"name":"CONTAINS","line":102,"definition":1},{"line":103,"name":"FOUND_IN","kind":14,"containerName":"main::","definition":1},{"definition":1,"containerName":"main::","kind":14,"name":"REGULATES","line":104},{"name":"POSITIVELY_REGULATES","kind":14,"containerName":"main::","line":105,"definition":1},{"line":106,"name":"NEGATIVELY_REGULATES","containerName":"main::","kind":14,"definition":1},{"line":109,"kind":2,"containerName":"","name":"base"},{"definition":"my","line":115,"name":"%term_name_map","localvar":"my","kind":13,"containerName":null},{"kind":12,"range":{"start":{"line":134,"character":0},"end":{"line":167,"character":9999}},"line":134,"signature":{"label":"get_instance($class,$name,$ont)","parameters":[{"label":"$class"},{"label":"$name"},{"label":"$ont"}],"documentation":"1;\n# $Id: RelationshipType.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::RelationshipType  \n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::RelationshipType  - a relationship type for an ontology\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis class can be used to model various types of relationships\n(such as \"IS_A\", \"PART_OF\", \"CONTAINS\", \"FOUND_IN\", \"RELATED_TO\").\n\nThis class extends L<Bio::Ontology::Term>, so it essentially is-a\nL<Bio::Ontology::TermI>. In addition, all methods are overridden such\nas to make the object immutable.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::RelationshipType;\nuse strict;\n\n\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant IS_A       => \"IS_A\";\nuse constant CONTAINS   => \"CONTAINS\";\nuse constant FOUND_IN   => \"FOUND_IN\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Ontology::Term);\n\n\n#\n# cache for terms\n#\nmy %term_name_map = ();\n\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   : $IS_A       = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n           $PART_OF    = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n           $RELATED_TO = Bio::Ontology::RelationshipType->get_instance( \"RELATED_TO\" );\n           $CONTAINS   = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n           $FOUND_IN   = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n Function: Factory method to create instances of RelationshipType\n Returns : [Bio::Ontology::RelationshipType]\n Args    : \"IS_A\" or \"PART_OF\" or \"CONTAINS\" or \"FOUND_IN\" or \n           \"RELATED_TO\" [scalar]\n           the ontology [Bio::Ontology::OntologyI] (optional)"},"name":"get_instance","containerName":"main::","children":[{"line":135,"containerName":"get_instance","localvar":"my","kind":13,"name":"$class","definition":"my"},{"line":135,"name":"$name","containerName":"get_instance","kind":13},{"line":135,"containerName":"get_instance","kind":13,"name":"$ont"},{"line":137,"containerName":"get_instance","kind":13,"name":"$class"},{"containerName":"get_instance","kind":12,"name":"throw","line":137},{"line":137,"containerName":"get_instance","kind":13,"name":"$name"},{"definition":"my","line":140,"localvar":"my","kind":13,"containerName":"get_instance","name":"$reltype"},{"name":"$term_name_map","containerName":"get_instance","kind":13,"line":140},{"line":140,"name":"$name","kind":13,"containerName":"get_instance"},{"line":142,"name":"$reltype","kind":13,"containerName":"get_instance"},{"name":"$ont","kind":13,"containerName":"get_instance","line":144},{"line":144,"name":"$reltype","containerName":"get_instance","kind":13},{"line":144,"kind":12,"containerName":"get_instance","name":"ontology"},{"line":145,"name":"$ont","containerName":"get_instance","kind":13},{"line":145,"kind":12,"containerName":"get_instance","name":"name"},{"kind":13,"containerName":"get_instance","name":"$reltype","line":145},{"line":145,"name":"ontology","containerName":"get_instance","kind":12},{"name":"name","containerName":"get_instance","kind":12,"line":145},{"name":"$reltype","kind":13,"containerName":"get_instance","line":146},{"line":146,"name":"ontology","kind":12,"containerName":"get_instance"},{"containerName":"get_instance","kind":13,"name":"$ont","line":146},{"name":"$reltype","kind":13,"containerName":"get_instance","line":148},{"kind":13,"containerName":"get_instance","name":"$reltype","line":162},{"containerName":"get_instance","kind":13,"name":"$class","line":162},{"containerName":"get_instance","kind":12,"name":"new","line":162},{"line":162,"containerName":"get_instance","kind":13,"name":"$name"},{"line":163,"kind":13,"containerName":"get_instance","name":"$ont"},{"line":165,"kind":13,"containerName":"get_instance","name":"$term_name_map"},{"containerName":"get_instance","kind":13,"name":"$name","line":165},{"name":"$reltype","containerName":"get_instance","kind":13,"line":165},{"line":166,"name":"$reltype","containerName":"get_instance","kind":13}],"detail":"($class,$name,$ont)","definition":"sub"},{"name":"init","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"init","line":181,"definition":"my"},{"line":183,"containerName":"init","kind":13,"name":"$self"}],"definition":"sub","kind":12,"range":{"end":{"line":186,"character":9999},"start":{"character":0,"line":180}},"line":180},{"line":183,"name":"SUPER","containerName":"init","kind":12},{"signature":{"label":"equals($self,$type)","documentation":"1;\n# $Id: RelationshipType.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::RelationshipType  \n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::RelationshipType  - a relationship type for an ontology\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis class can be used to model various types of relationships\n(such as \"IS_A\", \"PART_OF\", \"CONTAINS\", \"FOUND_IN\", \"RELATED_TO\").\n\nThis class extends L<Bio::Ontology::Term>, so it essentially is-a\nL<Bio::Ontology::TermI>. In addition, all methods are overridden such\nas to make the object immutable.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::RelationshipType;\nuse strict;\n\n\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant IS_A       => \"IS_A\";\nuse constant CONTAINS   => \"CONTAINS\";\nuse constant FOUND_IN   => \"FOUND_IN\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Ontology::Term);\n\n\n#\n# cache for terms\n#\nmy %term_name_map = ();\n\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   : $IS_A       = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n           $PART_OF    = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n           $RELATED_TO = Bio::Ontology::RelationshipType->get_instance( \"RELATED_TO\" );\n           $CONTAINS   = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n           $FOUND_IN   = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n Function: Factory method to create instances of RelationshipType\n Returns : [Bio::Ontology::RelationshipType]\n Args    : \"IS_A\" or \"PART_OF\" or \"CONTAINS\" or \"FOUND_IN\" or \n           \"RELATED_TO\" [scalar]\n           the ontology [Bio::Ontology::OntologyI] (optional)\n\n\nsub get_instance {\n    my ( $class, $name, $ont ) = @_;\n\n    $class->throw(\"must provide predicate name\") unless $name;\n\n    # is one in the cache?\n    my $reltype = $term_name_map{$name};\n\n    if($reltype &&\n       # check whether ontologies match\n       (($ont && $reltype->ontology() &&\n\t ($ont->name() eq $reltype->ontology->name())) ||\n\t(! ($reltype->ontology() || $ont)))) {\n\t# we're done, return cached type\n\treturn $reltype;\n    }\n    # valid relationship type?\n\n#\n#see the cell ontology.  this code is too strict, even for dag-edit files. -allen\n#\n#    if ( ! (($name eq IS_A) || ($name eq PART_OF) ||\n#\t    ($name eq CONTAINS) || ( $name eq FOUND_IN ))) {\n#        my $msg = \"Found unknown type of relationship: [\" . $name . \"]\\n\";\n#        $msg .= \"Known types are: [\" . IS_A . \"], [\" . PART_OF . \"], [\" . CONTAINS . \"], [\" . FOUND_IN . \"]\";\n#        $class->throw( $msg );\n#    }\n    # if we get here we need to create the rel.type\n    $reltype = $class->new(-name     => $name,\n\t\t\t   -ontology => $ont);\n    # cache it (FIXME possibly overrides one from another ontology)\n    $term_name_map{$name} = $reltype;\n    return $reltype;\n} # get_instance\n\n\n=head2 init\n\n Title   : init()\n Usage   : $type->init();\n Function: Initializes this to all undef and empty lists.\n Returns :\n Args    :\n\n\nsub init {\n    my $self = shift;\n\n    $self->SUPER::init();\n\n    # at this point we don't really need to do anything special for us\n} # init\n\n\n=head2 equals\n\n Title   : equals\n Usage   : if ( $type->equals( $other_type ) ) { ...\n Function: Compares this type to another one, based on string \"eq\" of\n           the \"identifier\" field, if at least one of the two types has\n           the identifier set, or string eq of the name otherwise.\n Returns : true or false\n Args    : [Bio::Ontology::RelationshipType]","parameters":[{"label":"$self"},{"label":"$type"}]},"range":{"start":{"line":201,"character":0},"end":{"line":216,"character":9999}},"kind":12,"line":201,"detail":"($self,$type)","definition":"sub","containerName":"main::","name":"equals","children":[{"definition":"my","line":202,"name":"$self","localvar":"my","containerName":"equals","kind":13},{"containerName":"equals","kind":13,"name":"$type","line":202},{"kind":13,"containerName":"equals","name":"$self","line":204},{"containerName":"equals","kind":12,"name":"_check_class","line":204},{"line":204,"containerName":"equals","kind":13,"name":"$type"},{"line":206,"name":"$self","containerName":"equals","kind":13},{"line":206,"containerName":"equals","kind":12,"name":"identifier"},{"line":206,"name":"$type","kind":13,"containerName":"equals"},{"line":206,"name":"identifier","kind":12,"containerName":"equals"},{"line":207,"name":"$self","kind":13,"containerName":"equals"},{"line":207,"name":"warn","containerName":"equals","kind":12},{"kind":13,"containerName":"equals","name":"$self","line":212},{"line":212,"kind":12,"containerName":"equals","name":"identifier"},{"line":212,"name":"$type","containerName":"equals","kind":13},{"line":212,"kind":12,"containerName":"equals","name":"identifier"},{"line":213,"kind":13,"containerName":"equals","name":"$self"},{"name":"identifier","kind":12,"containerName":"equals","line":213},{"name":"$type","kind":13,"containerName":"equals","line":213},{"line":213,"containerName":"equals","kind":12,"name":"identifier"},{"containerName":"equals","kind":13,"name":"$self","line":214},{"name":"name","containerName":"equals","kind":12,"line":214},{"line":214,"kind":13,"containerName":"equals","name":"$type"},{"containerName":"equals","kind":12,"name":"name","line":214}]},{"children":[{"definition":"my","line":232,"localvar":"my","kind":13,"containerName":"identifier","name":"$self"},{"definition":"my","line":233,"containerName":"identifier","localvar":"my","kind":13,"name":"$ret"},{"containerName":"identifier","kind":13,"name":"$self","line":233},{"kind":13,"containerName":"identifier","name":"$self","line":235},{"line":235,"name":"throw","kind":12,"containerName":"identifier"},{"containerName":"identifier","kind":13,"name":"$self","line":235},{"line":235,"containerName":"identifier","kind":12,"name":"veto_change"},{"kind":13,"containerName":"identifier","name":"$ret","line":235},{"containerName":"identifier","kind":13,"name":"$ret","line":236},{"name":"$ret","kind":13,"containerName":"identifier","line":236},{"name":"$ret","kind":13,"containerName":"identifier","line":237},{"line":237,"kind":13,"containerName":"identifier","name":"$self"},{"line":239,"name":"$ret","containerName":"identifier","kind":13}],"containerName":"main::","name":"identifier","definition":"sub","line":231,"kind":12,"range":{"end":{"line":240,"character":9999},"start":{"line":231,"character":0}}},{"line":233,"name":"SUPER","kind":12,"containerName":"identifier"},{"name":"SUPER","containerName":"identifier","kind":12,"line":237},{"range":{"start":{"line":255,"character":0},"end":{"line":264,"character":9999}},"kind":12,"line":255,"definition":"sub","containerName":"main::","name":"name","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"name","name":"$self","line":256},{"name":"$ret","localvar":"my","containerName":"name","kind":13,"line":257,"definition":"my"},{"line":257,"containerName":"name","kind":13,"name":"$self"},{"name":"$self","containerName":"name","kind":13,"line":259},{"name":"throw","containerName":"name","kind":12,"line":259},{"line":259,"kind":13,"containerName":"name","name":"$self"},{"name":"veto_change","containerName":"name","kind":12,"line":259},{"line":259,"containerName":"name","kind":13,"name":"$ret"},{"kind":13,"containerName":"name","name":"$ret","line":260},{"line":260,"containerName":"name","kind":13,"name":"$ret"},{"line":261,"name":"$ret","kind":13,"containerName":"name"},{"line":261,"containerName":"name","kind":13,"name":"$self"},{"kind":13,"containerName":"name","name":"$ret","line":263}]},{"line":257,"name":"SUPER","containerName":"name","kind":12},{"containerName":"name","kind":12,"name":"SUPER","line":261},{"kind":12,"range":{"start":{"character":0,"line":282},"end":{"character":9999,"line":293}},"line":282,"containerName":"main::","name":"definition","children":[{"definition":"my","localvar":"my","containerName":"definition","kind":13,"name":"$self","line":283},{"kind":13,"localvar":"my","containerName":"definition","name":"$ret","line":284,"definition":"my"},{"name":"$self","kind":13,"containerName":"definition","line":284},{"line":286,"containerName":"definition","kind":13,"name":"$self"},{"line":286,"name":"veto_change","kind":12,"containerName":"definition"},{"line":286,"name":"$ret","kind":13,"containerName":"definition"},{"line":287,"name":"$ret","kind":13,"containerName":"definition"},{"line":287,"containerName":"definition","kind":13,"name":"$ret"},{"line":288,"name":"$ret","containerName":"definition","kind":13},{"name":"$self","kind":13,"containerName":"definition","line":288},{"line":291,"containerName":"definition","kind":13,"name":"$ret"},{"kind":13,"containerName":"definition","name":"$ret","line":291},{"name":"$self","containerName":"definition","kind":13,"line":292},{"name":"name","containerName":"definition","kind":12,"line":292},{"name":"$self","kind":13,"containerName":"definition","line":292},{"line":292,"name":"name","kind":12,"containerName":"definition"}],"definition":"sub"},{"kind":12,"containerName":"definition","name":"SUPER","line":284},{"line":288,"kind":12,"containerName":"definition","name":"SUPER"},{"line":309,"range":{"start":{"line":309,"character":0},"end":{"character":9999,"line":322}},"kind":12,"children":[{"definition":"my","line":310,"localvar":"my","containerName":"ontology","kind":13,"name":"$self"},{"definition":"my","line":311,"name":"$ret","localvar":"my","containerName":"ontology","kind":13},{"kind":13,"containerName":"ontology","name":"$self","line":311},{"definition":"my","localvar":"my","containerName":"ontology","kind":13,"name":"$ont","line":313},{"line":314,"name":"$ret","containerName":"ontology","kind":13},{"containerName":"ontology","kind":13,"name":"$self","line":315},{"line":315,"name":"throw","kind":12,"containerName":"ontology"},{"line":315,"name":"$self","containerName":"ontology","kind":13},{"kind":12,"containerName":"ontology","name":"veto_change","line":315},{"line":315,"name":"$ret","kind":13,"containerName":"ontology"},{"containerName":"ontology","kind":12,"name":"name","line":315},{"line":316,"kind":13,"containerName":"ontology","name":"$ont"},{"kind":13,"containerName":"ontology","name":"$ont","line":316},{"line":316,"name":"name","containerName":"ontology","kind":12},{"line":316,"name":"$ont","containerName":"ontology","kind":13},{"kind":13,"containerName":"ontology","name":"$ont","line":317},{"line":317,"kind":13,"containerName":"ontology","name":"$ont"},{"line":317,"name":"name","kind":12,"containerName":"ontology"},{"line":317,"name":"$ret","containerName":"ontology","kind":13},{"line":317,"containerName":"ontology","kind":12,"name":"name"},{"line":319,"name":"$ret","kind":13,"containerName":"ontology"},{"line":319,"kind":13,"containerName":"ontology","name":"$self"},{"line":319,"containerName":"ontology","kind":13,"name":"$ont"},{"line":321,"containerName":"ontology","kind":13,"name":"$ret"}],"containerName":"main::","name":"ontology","definition":"sub"},{"line":311,"containerName":"ontology","kind":12,"name":"SUPER"},{"line":319,"name":"SUPER","kind":12,"containerName":"ontology"},{"kind":12,"range":{"end":{"character":9999,"line":347},"start":{"line":338,"character":0}},"line":338,"definition":"sub","containerName":"main::","name":"version","children":[{"line":339,"containerName":"version","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":340,"kind":13,"localvar":"my","containerName":"version","name":"$ret","definition":"my"},{"line":340,"name":"$self","kind":13,"containerName":"version"},{"line":342,"kind":13,"containerName":"version","name":"$self"},{"line":342,"containerName":"version","kind":12,"name":"throw"},{"line":342,"containerName":"version","kind":13,"name":"$self"},{"containerName":"version","kind":12,"name":"veto_change","line":342},{"line":342,"name":"$ret","kind":13,"containerName":"version"},{"name":"$ret","containerName":"version","kind":13,"line":343},{"name":"$ret","containerName":"version","kind":13,"line":343},{"line":344,"name":"$ret","containerName":"version","kind":13},{"name":"$self","containerName":"version","kind":13,"line":344},{"line":346,"name":"$ret","containerName":"version","kind":13}]},{"line":340,"containerName":"version","kind":12,"name":"SUPER"},{"line":344,"name":"SUPER","kind":12,"containerName":"version"},{"line":363,"range":{"end":{"line":372,"character":9999},"start":{"line":363,"character":0}},"kind":12,"definition":"sub","children":[{"line":364,"kind":13,"localvar":"my","containerName":"is_obsolete","name":"$self","definition":"my"},{"name":"$ret","localvar":"my","containerName":"is_obsolete","kind":13,"line":365,"definition":"my"},{"name":"$self","containerName":"is_obsolete","kind":13,"line":365},{"name":"$self","containerName":"is_obsolete","kind":13,"line":367},{"line":367,"name":"throw","containerName":"is_obsolete","kind":12},{"kind":13,"containerName":"is_obsolete","name":"$self","line":367},{"line":367,"kind":12,"containerName":"is_obsolete","name":"veto_change"},{"name":"$ret","kind":13,"containerName":"is_obsolete","line":367},{"line":368,"name":"$ret","kind":13,"containerName":"is_obsolete"},{"line":368,"name":"$ret","kind":13,"containerName":"is_obsolete"},{"line":369,"name":"$ret","kind":13,"containerName":"is_obsolete"},{"line":369,"name":"$self","kind":13,"containerName":"is_obsolete"},{"kind":13,"containerName":"is_obsolete","name":"$ret","line":371}],"name":"is_obsolete","containerName":"main::"},{"kind":12,"containerName":"is_obsolete","name":"SUPER","line":365},{"line":369,"name":"SUPER","containerName":"is_obsolete","kind":12},{"range":{"end":{"line":396,"character":9999},"start":{"line":387,"character":0}},"kind":12,"line":387,"definition":"sub","containerName":"main::","name":"comment","children":[{"definition":"my","line":388,"containerName":"comment","localvar":"my","kind":13,"name":"$self"},{"definition":"my","line":389,"localvar":"my","kind":13,"containerName":"comment","name":"$ret"},{"containerName":"comment","kind":13,"name":"$self","line":389},{"line":391,"name":"$self","containerName":"comment","kind":13},{"line":391,"name":"throw","kind":12,"containerName":"comment"},{"line":391,"name":"$self","kind":13,"containerName":"comment"},{"kind":12,"containerName":"comment","name":"veto_change","line":391},{"line":391,"containerName":"comment","kind":13,"name":"$ret"},{"name":"$ret","kind":13,"containerName":"comment","line":392},{"line":392,"name":"$ret","kind":13,"containerName":"comment"},{"line":393,"kind":13,"containerName":"comment","name":"$ret"},{"name":"$self","containerName":"comment","kind":13,"line":393},{"line":395,"name":"$ret","kind":13,"containerName":"comment"}]},{"kind":12,"containerName":"comment","name":"SUPER","line":389},{"kind":12,"containerName":"comment","name":"SUPER","line":393},{"definition":"sub","detail":"($self,$value,$expected_class)","children":[{"definition":"my","line":406,"name":"$self","containerName":"_check_class","localvar":"my","kind":13},{"kind":13,"containerName":"_check_class","name":"$value","line":406},{"name":"$expected_class","containerName":"_check_class","kind":13,"line":406},{"line":408,"name":"$value","containerName":"_check_class","kind":13},{"line":409,"name":"$self","kind":13,"containerName":"_check_class"},{"name":"throw","kind":12,"containerName":"_check_class","line":409},{"line":411,"name":"$value","kind":13,"containerName":"_check_class"},{"name":"$self","kind":13,"containerName":"_check_class","line":412},{"line":412,"name":"throw","kind":12,"containerName":"_check_class"},{"containerName":"_check_class","kind":13,"name":"$value","line":414},{"line":414,"name":"isa","containerName":"_check_class","kind":12},{"line":414,"kind":13,"containerName":"_check_class","name":"$expected_class"},{"line":415,"kind":13,"containerName":"_check_class","name":"$self"},{"name":"throw","containerName":"_check_class","kind":12,"line":415},{"name":"$value","kind":13,"containerName":"_check_class","line":415}],"name":"_check_class","containerName":"main::","signature":{"label":"_check_class($self,$value,$expected_class)","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$expected_class"}],"documentation":"1;\n# $Id: RelationshipType.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::RelationshipType  \n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::RelationshipType  - a relationship type for an ontology\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis class can be used to model various types of relationships\n(such as \"IS_A\", \"PART_OF\", \"CONTAINS\", \"FOUND_IN\", \"RELATED_TO\").\n\nThis class extends L<Bio::Ontology::Term>, so it essentially is-a\nL<Bio::Ontology::TermI>. In addition, all methods are overridden such\nas to make the object immutable.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::RelationshipType;\nuse strict;\n\n\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant IS_A       => \"IS_A\";\nuse constant CONTAINS   => \"CONTAINS\";\nuse constant FOUND_IN   => \"FOUND_IN\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Ontology::Term);\n\n\n#\n# cache for terms\n#\nmy %term_name_map = ();\n\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   : $IS_A       = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n           $PART_OF    = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n           $RELATED_TO = Bio::Ontology::RelationshipType->get_instance( \"RELATED_TO\" );\n           $CONTAINS   = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n           $FOUND_IN   = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n Function: Factory method to create instances of RelationshipType\n Returns : [Bio::Ontology::RelationshipType]\n Args    : \"IS_A\" or \"PART_OF\" or \"CONTAINS\" or \"FOUND_IN\" or \n           \"RELATED_TO\" [scalar]\n           the ontology [Bio::Ontology::OntologyI] (optional)\n\n\nsub get_instance {\n    my ( $class, $name, $ont ) = @_;\n\n    $class->throw(\"must provide predicate name\") unless $name;\n\n    # is one in the cache?\n    my $reltype = $term_name_map{$name};\n\n    if($reltype &&\n       # check whether ontologies match\n       (($ont && $reltype->ontology() &&\n\t ($ont->name() eq $reltype->ontology->name())) ||\n\t(! ($reltype->ontology() || $ont)))) {\n\t# we're done, return cached type\n\treturn $reltype;\n    }\n    # valid relationship type?\n\n#\n#see the cell ontology.  this code is too strict, even for dag-edit files. -allen\n#\n#    if ( ! (($name eq IS_A) || ($name eq PART_OF) ||\n#\t    ($name eq CONTAINS) || ( $name eq FOUND_IN ))) {\n#        my $msg = \"Found unknown type of relationship: [\" . $name . \"]\\n\";\n#        $msg .= \"Known types are: [\" . IS_A . \"], [\" . PART_OF . \"], [\" . CONTAINS . \"], [\" . FOUND_IN . \"]\";\n#        $class->throw( $msg );\n#    }\n    # if we get here we need to create the rel.type\n    $reltype = $class->new(-name     => $name,\n\t\t\t   -ontology => $ont);\n    # cache it (FIXME possibly overrides one from another ontology)\n    $term_name_map{$name} = $reltype;\n    return $reltype;\n} # get_instance\n\n\n=head2 init\n\n Title   : init()\n Usage   : $type->init();\n Function: Initializes this to all undef and empty lists.\n Returns :\n Args    :\n\n\nsub init {\n    my $self = shift;\n\n    $self->SUPER::init();\n\n    # at this point we don't really need to do anything special for us\n} # init\n\n\n=head2 equals\n\n Title   : equals\n Usage   : if ( $type->equals( $other_type ) ) { ...\n Function: Compares this type to another one, based on string \"eq\" of\n           the \"identifier\" field, if at least one of the two types has\n           the identifier set, or string eq of the name otherwise.\n Returns : true or false\n Args    : [Bio::Ontology::RelationshipType]\n\n\nsub equals {\n    my( $self, $type ) = @_;\n\n    $self->_check_class( $type, \"Bio::Ontology::RelationshipType\" );\n\n    if ( $self->identifier() xor $type->identifier() ) {\n        $self->warn(\"comparing relationship types when only \".\n\t\t    \"one has an identifier will always return false\" );\n    }\n\n    return\n \t($self->identifier() || $type->identifier()) ?\n\t$self->identifier() eq $type->identifier() :\n\t$self->name() eq $type->name();\n\t\n} # equals\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"IS_A\" );\n           or\n           print $term->identifier();\n Function: Set/get for the immutable identifier of this Type.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n    my $ret = $self->SUPER::identifier();\n    if(@_) {\n\t$self->throw($self->veto_change(\"identifier\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::identifier(@_);\n    }\n    return $ret;\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"is a type\" );\n           or\n           print $term->name();\n Function: Set/get for the immutable name of this Type.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n    my $ret = $self->SUPER::name();\n    if(@_) {\n\t$self->throw($self->veto_change(\"name\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::name(@_);\n    }\n    return $ret;\n} # name\n\n\n\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"\" );\n           or\n           print $term->definition();\n Function: Set/get for the immutable definition of this Type.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n    my $ret = $self->SUPER::definition();\n    if(@_) {\n\t$self->veto_change(\"definition\",$ret,$_[0]) \n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::definition(@_);\n    }\n    # let's be nice and return something readable here\n    return $ret if $ret;\n    return $self->name().\" relationship predicate (type)\" if $self->name();\n} # definition\n\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $term->ontology( $top );\n           or\n           $top = $term->ontology();\n Function: Set/get for the ontology this relationship type lives in.\n Returns : The ontology [Bio::Ontology::OntologyI].\n Args    : On set, the ontology [Bio::Ontology::OntologyI] (optional).\n\n\nsub ontology {\n    my $self = shift;\n    my $ret = $self->SUPER::ontology();\n    if(@_) {\n\tmy $ont = shift;\n\tif($ret) {\n\t    $self->throw($self->veto_change(\"ontology\",$ret->name,\n\t\t\t\t\t    $ont ? $ont->name : $ont))\n\t\tunless $ont && ($ont->name() eq $ret->name());\n\t}\n\t$ret = $self->SUPER::ontology($ont,@_);\n    }\n    return $ret;\n} # category\n\n\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for immutable version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n    my $ret = $self->SUPER::version();\n    if(@_) {\n\t$self->throw($self->veto_change(\"version\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::version(@_);\n    }\n    return $ret;\n} # version\n\n\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the immutable obsoleteness of this Type.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete {\n    my $self = shift;\n    my $ret = $self->SUPER::is_obsolete();\n    if(@_) {\n\t$self->throw($self->veto_change(\"is_obsolete\",$ret,$_[0]))\n\t    if $ret && ($ret != $_[0]);\n\t$ret = $self->SUPER::is_obsolete(@_);\n    }\n    return $ret;\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary immutable comment about this Type.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment {\n    my $self = shift;\n    my $ret = $self->SUPER::comment();\n    if(@_) {\n\t$self->throw($self->veto_change(\"comment\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::comment(@_);\n    }\n    return $ret;\n} # comment\n\n=head1 Private methods \n\nMay be overridden in a derived class, but should never be called from\noutside."},"line":405,"kind":12,"range":{"end":{"character":9999,"line":418},"start":{"line":405,"character":0}}},{"range":{"end":{"line":446,"character":9999},"start":{"character":0,"line":438}},"kind":12,"line":438,"signature":{"parameters":[{"label":"$self"},{"label":"$attr"},{"label":"$old"},{"label":"$new"}],"documentation":"1;\n# $Id: RelationshipType.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::RelationshipType  \n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::RelationshipType  - a relationship type for an ontology\n\n=head1 SYNOPSIS\n\n  #\n\n=head1 DESCRIPTION\n\nThis class can be used to model various types of relationships\n(such as \"IS_A\", \"PART_OF\", \"CONTAINS\", \"FOUND_IN\", \"RELATED_TO\").\n\nThis class extends L<Bio::Ontology::Term>, so it essentially is-a\nL<Bio::Ontology::TermI>. In addition, all methods are overridden such\nas to make the object immutable.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::RelationshipType;\nuse strict;\n\n\nuse constant PART_OF    => \"PART_OF\";\nuse constant RELATED_TO => \"RELATED_TO\";\nuse constant IS_A       => \"IS_A\";\nuse constant CONTAINS   => \"CONTAINS\";\nuse constant FOUND_IN   => \"FOUND_IN\";\nuse constant REGULATES   => \"REGULATES\";\nuse constant POSITIVELY_REGULATES   => \"POSITIVELY_REGULATES\";\nuse constant NEGATIVELY_REGULATES   => \"NEGATIVELY_REGULATES\";\n\n\nuse base qw(Bio::Ontology::Term);\n\n\n#\n# cache for terms\n#\nmy %term_name_map = ();\n\n\n=head2 get_instance\n\n Title   : get_instance\n Usage   : $IS_A       = Bio::Ontology::RelationshipType->get_instance( \"IS_A\" );\n           $PART_OF    = Bio::Ontology::RelationshipType->get_instance( \"PART_OF\" );\n           $RELATED_TO = Bio::Ontology::RelationshipType->get_instance( \"RELATED_TO\" );\n           $CONTAINS   = Bio::Ontology::RelationshipType->get_instance( \"CONTAINS\" );\n           $FOUND_IN   = Bio::Ontology::RelationshipType->get_instance( \"FOUND_IN\" );\n Function: Factory method to create instances of RelationshipType\n Returns : [Bio::Ontology::RelationshipType]\n Args    : \"IS_A\" or \"PART_OF\" or \"CONTAINS\" or \"FOUND_IN\" or \n           \"RELATED_TO\" [scalar]\n           the ontology [Bio::Ontology::OntologyI] (optional)\n\n\nsub get_instance {\n    my ( $class, $name, $ont ) = @_;\n\n    $class->throw(\"must provide predicate name\") unless $name;\n\n    # is one in the cache?\n    my $reltype = $term_name_map{$name};\n\n    if($reltype &&\n       # check whether ontologies match\n       (($ont && $reltype->ontology() &&\n\t ($ont->name() eq $reltype->ontology->name())) ||\n\t(! ($reltype->ontology() || $ont)))) {\n\t# we're done, return cached type\n\treturn $reltype;\n    }\n    # valid relationship type?\n\n#\n#see the cell ontology.  this code is too strict, even for dag-edit files. -allen\n#\n#    if ( ! (($name eq IS_A) || ($name eq PART_OF) ||\n#\t    ($name eq CONTAINS) || ( $name eq FOUND_IN ))) {\n#        my $msg = \"Found unknown type of relationship: [\" . $name . \"]\\n\";\n#        $msg .= \"Known types are: [\" . IS_A . \"], [\" . PART_OF . \"], [\" . CONTAINS . \"], [\" . FOUND_IN . \"]\";\n#        $class->throw( $msg );\n#    }\n    # if we get here we need to create the rel.type\n    $reltype = $class->new(-name     => $name,\n\t\t\t   -ontology => $ont);\n    # cache it (FIXME possibly overrides one from another ontology)\n    $term_name_map{$name} = $reltype;\n    return $reltype;\n} # get_instance\n\n\n=head2 init\n\n Title   : init()\n Usage   : $type->init();\n Function: Initializes this to all undef and empty lists.\n Returns :\n Args    :\n\n\nsub init {\n    my $self = shift;\n\n    $self->SUPER::init();\n\n    # at this point we don't really need to do anything special for us\n} # init\n\n\n=head2 equals\n\n Title   : equals\n Usage   : if ( $type->equals( $other_type ) ) { ...\n Function: Compares this type to another one, based on string \"eq\" of\n           the \"identifier\" field, if at least one of the two types has\n           the identifier set, or string eq of the name otherwise.\n Returns : true or false\n Args    : [Bio::Ontology::RelationshipType]\n\n\nsub equals {\n    my( $self, $type ) = @_;\n\n    $self->_check_class( $type, \"Bio::Ontology::RelationshipType\" );\n\n    if ( $self->identifier() xor $type->identifier() ) {\n        $self->warn(\"comparing relationship types when only \".\n\t\t    \"one has an identifier will always return false\" );\n    }\n\n    return\n \t($self->identifier() || $type->identifier()) ?\n\t$self->identifier() eq $type->identifier() :\n\t$self->name() eq $type->name();\n\t\n} # equals\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"IS_A\" );\n           or\n           print $term->identifier();\n Function: Set/get for the immutable identifier of this Type.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n    my $ret = $self->SUPER::identifier();\n    if(@_) {\n\t$self->throw($self->veto_change(\"identifier\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::identifier(@_);\n    }\n    return $ret;\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"is a type\" );\n           or\n           print $term->name();\n Function: Set/get for the immutable name of this Type.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n    my $ret = $self->SUPER::name();\n    if(@_) {\n\t$self->throw($self->veto_change(\"name\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::name(@_);\n    }\n    return $ret;\n} # name\n\n\n\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"\" );\n           or\n           print $term->definition();\n Function: Set/get for the immutable definition of this Type.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n    my $ret = $self->SUPER::definition();\n    if(@_) {\n\t$self->veto_change(\"definition\",$ret,$_[0]) \n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::definition(@_);\n    }\n    # let's be nice and return something readable here\n    return $ret if $ret;\n    return $self->name().\" relationship predicate (type)\" if $self->name();\n} # definition\n\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $term->ontology( $top );\n           or\n           $top = $term->ontology();\n Function: Set/get for the ontology this relationship type lives in.\n Returns : The ontology [Bio::Ontology::OntologyI].\n Args    : On set, the ontology [Bio::Ontology::OntologyI] (optional).\n\n\nsub ontology {\n    my $self = shift;\n    my $ret = $self->SUPER::ontology();\n    if(@_) {\n\tmy $ont = shift;\n\tif($ret) {\n\t    $self->throw($self->veto_change(\"ontology\",$ret->name,\n\t\t\t\t\t    $ont ? $ont->name : $ont))\n\t\tunless $ont && ($ont->name() eq $ret->name());\n\t}\n\t$ret = $self->SUPER::ontology($ont,@_);\n    }\n    return $ret;\n} # category\n\n\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for immutable version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n    my $ret = $self->SUPER::version();\n    if(@_) {\n\t$self->throw($self->veto_change(\"version\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::version(@_);\n    }\n    return $ret;\n} # version\n\n\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the immutable obsoleteness of this Type.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete {\n    my $self = shift;\n    my $ret = $self->SUPER::is_obsolete();\n    if(@_) {\n\t$self->throw($self->veto_change(\"is_obsolete\",$ret,$_[0]))\n\t    if $ret && ($ret != $_[0]);\n\t$ret = $self->SUPER::is_obsolete(@_);\n    }\n    return $ret;\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary immutable comment about this Type.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment {\n    my $self = shift;\n    my $ret = $self->SUPER::comment();\n    if(@_) {\n\t$self->throw($self->veto_change(\"comment\",$ret,$_[0]))\n\t    if $ret && ($ret ne $_[0]);\n\t$ret = $self->SUPER::comment(@_);\n    }\n    return $ret;\n} # comment\n\n=head1 Private methods \n\nMay be overridden in a derived class, but should never be called from\noutside.\n\n\nsub _check_class {\n    my ( $self, $value, $expected_class ) = @_;\n\n    if ( ! defined( $value ) ) {\n        $self->throw( \"Found [undef] where [$expected_class] expected\" );\n    }\n    elsif ( ! ref( $value ) ) {\n        $self->throw( \"Found [scalar] where [$expected_class] expected\" );\n    }\n    elsif ( ! $value->isa( $expected_class ) ) {\n        $self->throw( \"Found [\" . ref( $value ) . \"] where [$expected_class] expected\" );\n    }\n\n} # _check_type\n\n=head2 veto_change\n\n Title   : veto_change\n Usage   :\n Function: Called if an attribute is changed. Setting an attribute is\n           considered a change if it had a value before and the attempt\n           to set it would change the value.\n\n           This method returns the message to be printed in the exception.\n\n Example :\n Returns : A string\n Args    : The name of the attribute that was attempted to change.\n           Optionally, the old value and the new value for reporting\n           purposes only.","label":"veto_change($self,$attr,$old,$new)"},"name":"veto_change","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"veto_change","line":439,"definition":"my"},{"name":"$attr","containerName":"veto_change","kind":13,"line":439},{"containerName":"veto_change","kind":13,"name":"$old","line":439},{"line":439,"name":"$new","containerName":"veto_change","kind":13},{"definition":"my","line":441,"kind":13,"localvar":"my","containerName":"veto_change","name":"$changetype"},{"name":"$old","kind":13,"containerName":"veto_change","line":441},{"kind":13,"containerName":"veto_change","name":"$new","line":441},{"definition":"my","localvar":"my","kind":13,"containerName":"veto_change","name":"$msg","line":442},{"line":442,"name":"$self","containerName":"veto_change","kind":13},{"name":"$msg","containerName":"veto_change","kind":13,"line":444},{"line":444,"containerName":"veto_change","kind":13,"name":"$old"},{"line":444,"containerName":"veto_change","kind":13,"name":"$new"},{"containerName":"veto_change","kind":13,"name":"$msg","line":445}],"detail":"($self,$attr,$old,$new)","definition":"sub"}],"version":5}