{"vars":[{"line":111,"kind":14,"containerName":"main::","name":"TRUE","definition":1},{"kind":12,"containerName":"Bio::Ontology::Ontology::Bio::Ontology::OntologyStore::Bio::Annotation::DBLink::Data::Dumper","name":"strict","line":111},{"definition":1,"name":"FALSE","kind":14,"containerName":"main::","line":112},{"name":"base","kind":2,"containerName":"","line":114},{"children":[{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"new","line":147},{"line":147,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","line":149,"localvar":"my","kind":13,"containerName":"new","name":"$self"},{"line":149,"containerName":"new","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":149},{"line":150,"name":"$identifier","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":151,"containerName":"new","kind":13,"name":"$name"},{"line":152,"containerName":"new","kind":13,"name":"$definition"},{"kind":13,"containerName":"new","name":"$category","line":153},{"line":154,"containerName":"new","kind":13,"name":"$ont"},{"line":155,"kind":13,"containerName":"new","name":"$version"},{"line":156,"name":"$is_obsolete","containerName":"new","kind":13},{"line":157,"containerName":"new","kind":13,"name":"$comment"},{"name":"$dblinks","kind":13,"containerName":"new","line":158},{"line":159,"name":"$dbxrefs","kind":13,"containerName":"new"},{"line":160,"name":"$references","kind":13,"containerName":"new"},{"line":161,"name":"$self","containerName":"new","kind":13},{"line":161,"containerName":"new","kind":12,"name":"_rearrange"},{"name":"@args","kind":13,"containerName":"new","line":173},{"containerName":"new","kind":13,"name":"$self","line":175},{"name":"init","containerName":"new","kind":12,"line":175},{"name":"$identifier","containerName":"new","kind":13,"line":177},{"kind":13,"containerName":"new","name":"$self","line":177},{"containerName":"new","kind":12,"name":"identifier","line":177},{"kind":13,"containerName":"new","name":"$identifier","line":177},{"line":178,"kind":13,"containerName":"new","name":"$name"},{"name":"$self","kind":13,"containerName":"new","line":178},{"name":"name","kind":12,"containerName":"new","line":178},{"line":178,"containerName":"new","kind":13,"name":"$name"},{"line":179,"kind":13,"containerName":"new","name":"$definition"},{"name":"$self","kind":13,"containerName":"new","line":179},{"containerName":"new","kind":12,"name":"definition","line":179},{"line":179,"name":"$definition","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$category","line":180},{"line":180,"name":"$self","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"category","line":180},{"line":180,"containerName":"new","kind":13,"name":"$category"},{"name":"$ont","kind":13,"containerName":"new","line":181},{"line":181,"kind":13,"containerName":"new","name":"$self"},{"name":"ontology","kind":12,"containerName":"new","line":181},{"name":"$ont","containerName":"new","kind":13,"line":181},{"name":"$version","containerName":"new","kind":13,"line":182},{"name":"$self","kind":13,"containerName":"new","line":182},{"line":182,"kind":12,"containerName":"new","name":"version"},{"containerName":"new","kind":13,"name":"$version","line":182},{"name":"$is_obsolete","kind":13,"containerName":"new","line":183},{"kind":13,"containerName":"new","name":"$self","line":183},{"name":"is_obsolete","kind":12,"containerName":"new","line":183},{"line":183,"kind":13,"containerName":"new","name":"$is_obsolete"},{"containerName":"new","kind":13,"name":"$comment","line":184},{"containerName":"new","kind":13,"name":"$self","line":184},{"line":184,"name":"comment","containerName":"new","kind":12},{"name":"$comment","containerName":"new","kind":13,"line":184},{"kind":13,"containerName":"new","name":"$dbxrefs","line":185},{"line":185,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"add_dbxref","line":185},{"line":185,"name":"$dbxrefs","containerName":"new","kind":13},{"line":187,"name":"$dblinks","kind":13,"containerName":"new"},{"line":187,"name":"$self","containerName":"new","kind":13},{"name":"add_dblink","containerName":"new","kind":12,"line":187},{"name":"$dblinks","containerName":"new","kind":13,"line":187},{"containerName":"new","kind":13,"name":"$references","line":188},{"line":188,"kind":13,"containerName":"new","name":"$self"},{"name":"add_reference","kind":12,"containerName":"new","line":188},{"name":"$references","containerName":"new","kind":13,"line":188},{"name":"$self","containerName":"new","kind":13,"line":190}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)","line":145,"kind":12,"range":{"end":{"line":191,"character":9999},"start":{"character":0,"line":145}},"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.","parameters":[{"label":"$class"},{"label":"@args"}]}},{"line":149,"containerName":"new","kind":12,"name":"SUPER"},{"line":195,"kind":12,"range":{"end":{"line":210,"character":9999},"start":{"character":0,"line":195}},"definition":"sub","children":[{"definition":"my","name":"$self","containerName":"init","localvar":"my","kind":13,"line":197},{"line":199,"name":"$self","containerName":"init","kind":13},{"line":199,"containerName":"init","kind":12,"name":"identifier"},{"name":"$self","kind":13,"containerName":"init","line":200},{"line":200,"name":"name","containerName":"init","kind":12},{"line":201,"name":"$self","kind":13,"containerName":"init"},{"name":"comment","containerName":"init","kind":12,"line":201},{"containerName":"init","kind":13,"name":"$self","line":202},{"kind":12,"containerName":"init","name":"definition","line":202},{"line":203,"name":"$self","kind":13,"containerName":"init"},{"name":"ontology","kind":12,"containerName":"init","line":203},{"line":204,"name":"$self","containerName":"init","kind":13},{"name":"is_obsolete","containerName":"init","kind":12,"line":204},{"line":205,"kind":13,"containerName":"init","name":"$self"},{"name":"remove_synonyms","containerName":"init","kind":12,"line":205},{"line":206,"containerName":"init","kind":13,"name":"$self"},{"line":206,"name":"remove_dbxrefs","containerName":"init","kind":12},{"kind":13,"containerName":"init","name":"$self","line":207},{"line":207,"name":"remove_references","containerName":"init","kind":12},{"name":"$self","kind":13,"containerName":"init","line":208},{"name":"remove_secondary_ids","kind":12,"containerName":"init","line":208}],"name":"init","containerName":"main::"},{"range":{"start":{"line":226,"character":0},"end":{"line":231,"character":9999}},"kind":12,"line":226,"definition":"sub","containerName":"main::","name":"identifier","children":[{"localvar":"my","containerName":"identifier","kind":13,"name":"$self","line":227,"definition":"my"},{"name":"$self","kind":13,"containerName":"identifier","line":229},{"line":230,"name":"$self","containerName":"identifier","kind":13}]},{"range":{"start":{"character":0,"line":246},"end":{"character":9999,"line":251}},"kind":12,"line":246,"definition":"sub","containerName":"main::","name":"name","children":[{"line":247,"name":"$self","localvar":"my","containerName":"name","kind":13,"definition":"my"},{"line":249,"kind":13,"containerName":"name","name":"$self"},{"kind":13,"containerName":"name","name":"$self","line":250}]},{"range":{"end":{"line":271,"character":9999},"start":{"line":266,"character":0}},"kind":12,"line":266,"containerName":"main::","name":"definition","children":[{"definition":"my","localvar":"my","containerName":"definition","kind":13,"name":"$self","line":267},{"line":269,"name":"$self","containerName":"definition","kind":13},{"containerName":"definition","kind":13,"name":"$self","line":270}],"definition":"sub"},{"line":294,"range":{"start":{"character":0,"line":294},"end":{"line":310,"character":9999}},"kind":12,"children":[{"name":"$self","localvar":"my","containerName":"ontology","kind":13,"line":295,"definition":"my"},{"definition":"my","name":"$ont","kind":13,"localvar":"my","containerName":"ontology","line":296},{"name":"$ont","kind":13,"containerName":"ontology","line":299},{"line":300,"kind":13,"containerName":"ontology","name":"$ont"},{"line":301,"name":"$ont","kind":13,"containerName":"ontology"},{"name":"new","containerName":"ontology","kind":12,"line":301},{"name":"$ont","containerName":"ontology","kind":13,"line":301},{"line":301,"name":"$ont","containerName":"ontology","kind":13},{"name":"$ont","containerName":"ontology","kind":13,"line":302},{"kind":12,"containerName":"ontology","name":"isa","line":302},{"line":303,"kind":13,"containerName":"ontology","name":"$self"},{"containerName":"ontology","kind":12,"name":"throw","line":303},{"name":"$ont","kind":13,"containerName":"ontology","line":303},{"line":307,"name":"$self","kind":13,"containerName":"ontology"},{"line":307,"name":"$ont","containerName":"ontology","kind":13},{"name":"$self","kind":13,"containerName":"ontology","line":309}],"containerName":"main::","name":"ontology","definition":"sub"},{"line":301,"kind":12,"containerName":"Ontology::Ontology","name":"Bio"},{"definition":"sub","name":"version","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"version","name":"$self","line":325},{"kind":13,"containerName":"version","name":"$self","line":327},{"line":328,"kind":13,"containerName":"version","name":"$self"}],"kind":12,"range":{"start":{"line":324,"character":0},"end":{"character":9999,"line":329}},"line":324},{"definition":"sub","children":[{"containerName":"is_obsolete","localvar":"my","kind":13,"name":"$self","line":344,"definition":"my"},{"containerName":"is_obsolete","kind":13,"name":"$self","line":346},{"containerName":"is_obsolete","kind":13,"name":"$self","line":347}],"name":"is_obsolete","containerName":"main::","line":343,"range":{"start":{"line":343,"character":0},"end":{"line":348,"character":9999}},"kind":12},{"line":363,"range":{"end":{"line":368,"character":9999},"start":{"character":0,"line":363}},"kind":12,"definition":"sub","children":[{"definition":"my","line":364,"name":"$self","localvar":"my","containerName":"comment","kind":13},{"line":366,"containerName":"comment","kind":13,"name":"$self"},{"line":367,"name":"$self","containerName":"comment","kind":13}],"containerName":"main::","name":"comment"},{"range":{"end":{"line":383,"character":9999},"start":{"line":380,"character":0}},"kind":12,"line":380,"containerName":"main::","name":"get_synonyms","children":[{"definition":"my","localvar":"my","containerName":"get_synonyms","kind":13,"name":"$self","line":381},{"name":"$self","containerName":"get_synonyms","kind":13,"line":383}],"definition":"sub"},{"line":383,"kind":13,"containerName":null,"name":"%self"},{"signature":{"label":"add_synonym($self,@values)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].","parameters":[{"label":"$self"},{"label":"@values"}]},"line":400,"kind":12,"range":{"end":{"line":408,"character":9999},"start":{"line":400,"character":0}},"definition":"sub","detail":"($self,@values)","children":[{"definition":"my","line":401,"name":"$self","localvar":"my","containerName":"add_synonym","kind":13},{"name":"@values","containerName":"add_synonym","kind":13,"line":401},{"name":"@values","kind":13,"containerName":"add_synonym","line":403},{"definition":"my","localvar":"my","kind":13,"containerName":"add_synonym","name":"$syn","line":406},{"name":"@values","kind":13,"containerName":"add_synonym","line":406},{"line":407,"kind":13,"containerName":"add_synonym","name":"$syn"},{"name":"$self","containerName":"add_synonym","kind":13,"line":407},{"containerName":"add_synonym","kind":13,"name":"$self","line":408}],"containerName":"main::","name":"add_synonym"},{"containerName":null,"kind":13,"name":"$syn","line":408},{"line":424,"range":{"end":{"character":9999,"line":431},"start":{"character":0,"line":424}},"kind":12,"signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :","parameters":[{"label":"$self"}],"label":"remove_synonyms($self)"},"children":[{"definition":"my","containerName":"remove_synonyms","localvar":"my","kind":13,"name":"$self","line":425},{"line":427,"name":"@a","kind":13,"localvar":"my","containerName":"remove_synonyms","definition":"my"},{"line":427,"kind":13,"containerName":"remove_synonyms","name":"$self"},{"line":427,"name":"get_synonyms","kind":12,"containerName":"remove_synonyms"},{"line":428,"name":"$self","containerName":"remove_synonyms","kind":13},{"line":429,"name":"@a","kind":13,"containerName":"remove_synonyms"}],"containerName":"main::","name":"remove_synonyms","definition":"sub","detail":"($self)"},{"containerName":"main::","name":"get_dblinks","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"get_dblinks","line":448},{"line":448,"name":"$context","containerName":"get_dblinks","kind":13},{"name":"$self","kind":13,"containerName":"get_dblinks","line":449},{"line":449,"name":"deprecated","containerName":"get_dblinks","kind":12},{"line":454,"name":"$self","kind":13,"containerName":"get_dblinks"},{"line":454,"kind":12,"containerName":"get_dblinks","name":"get_dbxrefs"},{"name":"$context","kind":13,"containerName":"get_dblinks","line":454}],"detail":"($self,$context)","definition":"sub","kind":12,"range":{"end":{"line":455,"character":9999},"start":{"line":447,"character":0}},"line":447,"signature":{"label":"get_dblinks($self,$context)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances","parameters":[{"label":"$self"},{"label":"$context"}]}},{"kind":12,"range":{"start":{"character":0,"line":473},"end":{"character":9999,"line":480}},"line":473,"containerName":"main::","name":"get_dbxrefs","children":[{"localvar":"my","containerName":"get_dbxrefs","kind":13,"name":"$self","line":474,"definition":"my"},{"kind":13,"containerName":"get_dbxrefs","name":"$context","line":474},{"line":475,"name":"@dbxrefs","containerName":"get_dbxrefs","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"get_dbxrefs","name":"$context","line":476},{"containerName":"get_dbxrefs","kind":13,"name":"$self","line":477},{"containerName":"get_dbxrefs","kind":13,"name":"$context","line":477},{"line":478,"containerName":"get_dbxrefs","kind":13,"name":"@dbxrefs"},{"name":"$self","kind":13,"containerName":"get_dbxrefs","line":478},{"line":478,"name":"$context","containerName":"get_dbxrefs","kind":13}],"definition":"sub"},{"kind":12,"name":"_dblinks","line":477},{"line":478,"name":"_dblinks","kind":12},{"line":481,"containerName":null,"kind":13,"name":"@dbxrefs"},{"kind":13,"containerName":null,"name":"$_","line":481},{"name":"%self","kind":13,"containerName":null,"line":481},{"name":"_dblinks","kind":12,"line":481},{"name":"@dbxrefs","kind":13,"containerName":null,"line":483},{"line":498,"range":{"start":{"line":498,"character":0},"end":{"character":9999,"line":502}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"get_dblink_context","kind":13,"line":499},{"containerName":"get_dblink_context","kind":13,"name":"$self","line":500},{"kind":12,"containerName":"get_dblink_context","name":"deprecated","line":500},{"line":501,"name":"$self","kind":13,"containerName":"get_dblink_context"},{"name":"get_dbxref_context","kind":12,"containerName":"get_dblink_context","line":501}],"containerName":"main::","name":"get_dblink_context"},{"line":514,"range":{"start":{"character":0,"line":514},"end":{"line":516,"character":9999}},"kind":12,"children":[{"line":515,"name":"$self","localvar":"my","containerName":"get_dbxref_context","kind":13,"definition":"my"},{"line":516,"kind":13,"containerName":"get_dbxref_context","name":"$self"}],"name":"get_dbxref_context","containerName":"main::","definition":"sub"},{"kind":12,"name":"_dblinks","line":516},{"kind":12,"range":{"end":{"line":545,"character":9999},"start":{"character":0,"line":534}},"line":534,"definition":"sub","name":"add_dblink","containerName":"main::","children":[{"definition":"my","line":535,"localvar":"my","kind":13,"containerName":"add_dblink","name":"$self"},{"line":536,"kind":13,"containerName":"add_dblink","name":"$self"},{"name":"deprecated","kind":12,"containerName":"add_dblink","line":536},{"definition":"my","containerName":"add_dblink","localvar":"my","kind":13,"name":"@dbxrefs","line":539},{"definition":"my","containerName":"add_dblink","localvar":"my","kind":13,"name":"$string","line":540},{"line":541,"name":"$db","localvar":"my","kind":13,"containerName":"add_dblink","definition":"my"},{"line":541,"containerName":"add_dblink","kind":13,"name":"$id"},{"line":541,"containerName":"add_dblink","kind":13,"name":"$string"},{"line":542,"containerName":"add_dblink","kind":13,"name":"@dbxrefs"},{"line":542,"name":"new","kind":12,"containerName":"add_dblink"},{"line":542,"name":"$db","kind":13,"containerName":"add_dblink"},{"line":542,"kind":13,"containerName":"add_dblink","name":"$id"},{"kind":13,"containerName":"add_dblink","name":"$self","line":544},{"line":544,"name":"add_dbxref","kind":12,"containerName":"add_dblink"},{"line":544,"containerName":"add_dblink","kind":13,"name":"@dbxrefs"}]},{"kind":12,"containerName":"Annotation::DBLink","name":"Bio","line":542},{"children":[{"line":562,"name":"$self","containerName":"add_dbxref","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":563,"name":"$links","kind":13,"localvar":"my","containerName":"add_dbxref"},{"line":563,"name":"$context","containerName":"add_dbxref","kind":13},{"name":"$self","kind":13,"containerName":"add_dbxref","line":563},{"name":"_rearrange","containerName":"add_dbxref","kind":12,"line":563},{"line":564,"kind":13,"containerName":"add_dbxref","name":"$links"},{"line":565,"kind":13,"containerName":"add_dbxref","name":"$context"},{"line":566,"name":"$self","kind":13,"containerName":"add_dbxref"},{"name":"throw","kind":12,"containerName":"add_dbxref","line":566},{"line":566,"kind":13,"containerName":"add_dbxref","name":"$links"},{"definition":"my","name":"$dbxref","containerName":"add_dbxref","localvar":"my","kind":13,"line":567},{"line":567,"name":"$links","containerName":"add_dbxref","kind":13}],"name":"add_dbxref","containerName":"main::","definition":"sub","line":561,"range":{"end":{"character":9999,"line":567},"start":{"character":0,"line":561}},"kind":12},{"line":568,"name":"$self","kind":13,"containerName":null},{"line":568,"name":"throw","containerName":"main::","kind":12},{"line":568,"name":"$dbxref","kind":13,"containerName":null},{"line":569,"containerName":null,"kind":13,"name":"$dbxref"},{"line":569,"name":"isa","kind":12,"containerName":"main::"},{"line":570,"name":"$self","kind":13,"containerName":null},{"line":570,"containerName":"main::","kind":12,"name":"throw"},{"name":"$context","kind":13,"containerName":null,"line":570},{"line":571,"kind":13,"containerName":null,"name":"%self"},{"line":571,"kind":12,"name":"_dblinks"},{"name":"%context","containerName":null,"kind":13,"line":571},{"name":"%self","containerName":null,"kind":13,"line":572},{"name":"_dblinks","kind":12,"line":572},{"line":572,"kind":13,"containerName":null,"name":"@context"},{"definition":"my","line":574,"localvar":"my","kind":13,"containerName":null,"name":"$linktext"},{"line":574,"name":"$dbxref","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$dbxref","line":574},{"line":574,"name":"display_text","containerName":"main::","kind":12},{"name":"%dbxref","kind":13,"containerName":null,"line":574},{"name":"display_text","kind":12,"containerName":"main::","line":575},{"name":"$linktext","kind":13,"containerName":null,"line":575},{"line":576,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"_dblinks","line":576},{"name":"%context","kind":13,"containerName":null,"line":576},{"name":"$self","kind":13,"containerName":null,"line":578},{"name":"warn","kind":12,"containerName":"main::","line":578},{"name":"%self","kind":13,"containerName":null,"line":580},{"line":580,"kind":12,"name":"_dblinks"},{"containerName":null,"kind":13,"name":"$context","line":580},{"kind":13,"containerName":null,"name":"$dbxref","line":580},{"children":[{"line":598,"containerName":"has_dblink","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$value","containerName":"has_dblink","kind":13,"line":598},{"name":"$self","kind":13,"containerName":"has_dblink","line":599},{"name":"deprecated","kind":12,"containerName":"has_dblink","line":599},{"kind":13,"containerName":"has_dblink","name":"$self","line":600},{"line":600,"kind":12,"containerName":"has_dblink","name":"has_dbxref"},{"name":"$value","containerName":"has_dblink","kind":13,"line":600}],"containerName":"main::","name":"has_dblink","definition":"sub","detail":"($self,$value)","line":597,"kind":12,"range":{"end":{"character":9999,"line":601},"start":{"line":597,"character":0}},"signature":{"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances","parameters":[{"label":"$self"},{"label":"$value"}],"label":"has_dblink($self,$value)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.","label":"has_dbxref($self,$value)"},"line":615,"kind":12,"range":{"end":{"character":9999,"line":623},"start":{"character":0,"line":615}},"definition":"sub","detail":"($self,$value)","children":[{"line":616,"kind":13,"localvar":"my","containerName":"has_dbxref","name":"$self","definition":"my"},{"line":616,"name":"$value","containerName":"has_dbxref","kind":13},{"containerName":"has_dbxref","kind":13,"name":"$value","line":617},{"definition":"my","name":"$context","containerName":"has_dbxref","localvar":"my","kind":13,"line":618},{"line":619,"containerName":"has_dbxref","kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"has_dbxref","line":619},{"containerName":"has_dbxref","kind":13,"name":"$context","line":619},{"line":620,"kind":13,"containerName":"has_dbxref","name":"$context"},{"containerName":"has_dbxref","kind":13,"name":"$self","line":621},{"containerName":"has_dbxref","kind":13,"name":"$context","line":621},{"kind":12,"containerName":"has_dbxref","name":"display_text","line":622},{"containerName":"has_dbxref","kind":13,"name":"$value","line":622},{"line":623,"kind":13,"containerName":"has_dbxref","name":"$self"},{"kind":13,"containerName":"has_dbxref","name":"$context","line":623}],"name":"has_dbxref","containerName":"main::"},{"name":"_dblinks","kind":12,"line":621},{"name":"_dblinks","kind":12,"line":623},{"name":"TRUE","kind":12,"line":625},{"name":"FALSE","kind":12,"line":628},{"children":[{"definition":"my","localvar":"my","containerName":"add_dblink_context","kind":13,"name":"$self","line":647},{"line":647,"name":"$value","containerName":"add_dblink_context","kind":13},{"line":647,"containerName":"add_dblink_context","kind":13,"name":"$context"},{"line":648,"name":"$self","kind":13,"containerName":"add_dblink_context"},{"line":648,"containerName":"add_dblink_context","kind":12,"name":"deprecated"},{"line":650,"name":"$self","kind":13,"containerName":"add_dblink_context"},{"name":"add_dbxref","containerName":"add_dblink_context","kind":12,"line":650},{"name":"$value","containerName":"add_dblink_context","kind":13,"line":650},{"line":650,"name":"$context","containerName":"add_dblink_context","kind":13}],"name":"add_dblink_context","containerName":"main::","definition":"sub","detail":"($self,$value,$context)","line":646,"kind":12,"range":{"start":{"line":646,"character":0},"end":{"line":651,"character":9999}},"signature":{"label":"add_dblink_context($self,$value,$context)","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$context"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.\n\n\nsub has_dbxref {\n    my ( $self, $value ) = @_;\n    return unless defined $value;\n    my $context = \"_default\";\n    $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n    $context ||= '_default';\n    if ( ( $self->{_dblinks}->{$context} ) &&\n        grep { $_->display_text eq $value } \n        @{ $self->{_dblinks}->{$context} } )\n    {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n}\n\n=head2 add_dblink_context\n\n  Title   : add_dblink_context\n  Usage   : $term->add_dblink_context($db, $context);\n  Function: add a dblink with its context\n  Return  : [none]\n  Args    : [arg1] a Bio::Annotation::DBLink instance\n            [arg2] a string for context; if omitted, the\n                   default/context-less one will be used.\n  Note    : deprecated method due to past use of mixed data types; use\n            add_dbxref() instead"}},{"children":[{"name":"$self","containerName":"remove_dblinks","localvar":"my","kind":13,"line":668,"definition":"my"},{"line":668,"name":"$context","containerName":"remove_dblinks","kind":13},{"line":669,"name":"$self","containerName":"remove_dblinks","kind":13},{"line":669,"kind":12,"containerName":"remove_dblinks","name":"deprecated"},{"kind":13,"containerName":"remove_dblinks","name":"$self","line":670},{"line":670,"name":"remove_dbxrefs","kind":12,"containerName":"remove_dblinks"}],"containerName":"main::","name":"remove_dblinks","definition":"sub","detail":"($self,$context)","line":667,"range":{"start":{"character":0,"line":667},"end":{"character":9999,"line":671}},"kind":12,"signature":{"label":"remove_dblinks($self,$context)","documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.\n\n\nsub has_dbxref {\n    my ( $self, $value ) = @_;\n    return unless defined $value;\n    my $context = \"_default\";\n    $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n    $context ||= '_default';\n    if ( ( $self->{_dblinks}->{$context} ) &&\n        grep { $_->display_text eq $value } \n        @{ $self->{_dblinks}->{$context} } )\n    {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n}\n\n=head2 add_dblink_context\n\n  Title   : add_dblink_context\n  Usage   : $term->add_dblink_context($db, $context);\n  Function: add a dblink with its context\n  Return  : [none]\n  Args    : [arg1] a Bio::Annotation::DBLink instance\n            [arg2] a string for context; if omitted, the\n                   default/context-less one will be used.\n  Note    : deprecated method due to past use of mixed data types; use\n            add_dbxref() instead\n\n\nsub add_dblink_context {\n    my ($self, $value, $context) = @_;\n    $self->deprecated(\"Use of simple strings and add_dblink_context() is deprecated; use\\n\n                      Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    return $self->add_dbxref([$value],$context);\n}\n\n=head2 remove_dblinks\n\n Title   : remove_dblinks()\n Usage   : $term->remove_dblinks();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.\n Note    : deprecated method due to past use of mixed data types; use\n           remove_dblinks() instead, which handles both strings and\n           DBLink instances","parameters":[{"label":"$self"},{"label":"$context"}]}},{"children":[{"line":685,"name":"$self","containerName":"remove_dbxrefs","localvar":"my","kind":13,"definition":"my"},{"line":685,"containerName":"remove_dbxrefs","kind":13,"name":"$context"},{"kind":13,"containerName":"remove_dbxrefs","name":"$context","line":686},{"line":686,"name":"$context","kind":13,"containerName":"remove_dbxrefs"},{"line":686,"containerName":"remove_dbxrefs","kind":13,"name":"$context"},{"line":687,"containerName":"remove_dbxrefs","localvar":"my","kind":13,"name":"@old","definition":"my"},{"line":687,"kind":13,"containerName":"remove_dbxrefs","name":"$self"},{"name":"get_dbxrefs","kind":12,"containerName":"remove_dbxrefs","line":687},{"name":"$context","containerName":"remove_dbxrefs","kind":13,"line":687},{"line":688,"kind":13,"containerName":"remove_dbxrefs","name":"$context"},{"containerName":"remove_dbxrefs","kind":13,"name":"$self","line":689},{"name":"$context","kind":13,"containerName":"remove_dbxrefs","line":689},{"line":691,"kind":13,"containerName":"remove_dbxrefs","name":"$self"},{"line":693,"name":"@old","kind":13,"containerName":"remove_dbxrefs"}],"name":"remove_dbxrefs","containerName":"main::","definition":"sub","detail":"($self,$context)","line":684,"range":{"end":{"character":9999,"line":694},"start":{"character":0,"line":684}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$context"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.\n\n\nsub has_dbxref {\n    my ( $self, $value ) = @_;\n    return unless defined $value;\n    my $context = \"_default\";\n    $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n    $context ||= '_default';\n    if ( ( $self->{_dblinks}->{$context} ) &&\n        grep { $_->display_text eq $value } \n        @{ $self->{_dblinks}->{$context} } )\n    {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n}\n\n=head2 add_dblink_context\n\n  Title   : add_dblink_context\n  Usage   : $term->add_dblink_context($db, $context);\n  Function: add a dblink with its context\n  Return  : [none]\n  Args    : [arg1] a Bio::Annotation::DBLink instance\n            [arg2] a string for context; if omitted, the\n                   default/context-less one will be used.\n  Note    : deprecated method due to past use of mixed data types; use\n            add_dbxref() instead\n\n\nsub add_dblink_context {\n    my ($self, $value, $context) = @_;\n    $self->deprecated(\"Use of simple strings and add_dblink_context() is deprecated; use\\n\n                      Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    return $self->add_dbxref([$value],$context);\n}\n\n=head2 remove_dblinks\n\n Title   : remove_dblinks()\n Usage   : $term->remove_dblinks();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.\n Note    : deprecated method due to past use of mixed data types; use\n           remove_dblinks() instead, which handles both strings and\n           DBLink instances\n\n\nsub remove_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"use of remove_dblinks() is deprecated; use remove_dbxrefs() instead\");\n    return $self->remove_dbxrefs(@_);\n} # remove_dblinks\n\n=head2 remove_dbxrefs\n\n Title   : remove_dbxrefs()\n Usage   : $term->remove_dbxrefs();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.","label":"remove_dbxrefs($self,$context)"}},{"name":"_dblinks","kind":12,"line":689},{"kind":12,"name":"_dblinks","line":691},{"containerName":"main::","name":"get_references","children":[{"localvar":"my","containerName":"get_references","kind":13,"name":"$self","line":707,"definition":"my"},{"name":"$self","kind":13,"containerName":"get_references","line":708}],"definition":"sub","range":{"start":{"character":0,"line":706},"end":{"line":708,"character":9999}},"kind":12,"line":706},{"kind":12,"name":"_references","line":708},{"containerName":null,"kind":13,"name":"%self","line":708},{"name":"_references","kind":12,"line":708},{"containerName":"main::","name":"add_reference","children":[{"line":723,"name":"$self","localvar":"my","containerName":"add_reference","kind":13,"definition":"my"},{"line":723,"containerName":"add_reference","kind":13,"name":"@values"},{"line":724,"name":"@values","kind":13,"containerName":"add_reference"},{"line":726,"name":"$reference","containerName":"add_reference","localvar":"my","kind":13,"definition":"my"},{"containerName":"add_reference","kind":13,"name":"@values","line":726},{"name":"$self","kind":13,"containerName":"add_reference","line":727},{"line":727,"containerName":"add_reference","kind":12,"name":"throw"},{"line":727,"kind":13,"containerName":"add_reference","name":"$reference"},{"line":728,"kind":13,"containerName":"add_reference","name":"$reference"},{"line":728,"name":"isa","containerName":"add_reference","kind":12},{"line":729,"name":"$reference","containerName":"add_reference","kind":13},{"line":730,"containerName":"add_reference","kind":13,"name":"$reference"},{"name":"$self","containerName":"add_reference","kind":13,"line":730},{"line":731,"name":"$self","containerName":"add_reference","kind":13}],"detail":"($self,@values)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":722},"end":{"line":731,"character":9999}},"line":722,"signature":{"parameters":[{"label":"$self"},{"label":"@values"}],"documentation":"1;\n# $Id: Term.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Ontology::Term\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Ontology::Term - implementation of the interface for ontology terms\n\n=head1 SYNOPSIS\n\n#get Bio::Ontology::TermI somehow.\n\n  print $term->identifier(), \"\\n\";\n  print $term->name(), \"\\n\";\n  print $term->definition(), \"\\n\";\n  print $term->is_obsolete(), \"\\n\";\n  print $term->comment(), \"\\n\";\n\n  foreach my $synonym ( $term->each_synonym() ) {\n      print $synonym, \"\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis is a simple implementation for ontology terms providing basic\nmethods (it provides no functionality related to graphs). It\nimplements the L<Bio::Ontology::TermI> interface.\n\nThis class also implements L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress:\n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Ontology::Term;\nuse strict;\nuse Bio::Ontology::Ontology;\nuse Bio::Ontology::OntologyStore;\nuse Bio::Annotation::DBLink;\nuse Data::Dumper;\n\nuse constant TRUE    => 1;\nuse constant FALSE   => 0;\n\nuse base qw(Bio::Root::Root Bio::Ontology::TermI Bio::IdentifiableI Bio::DescribableI);\n\n=head2 new\n\n Title   : new\n Usage   : $term = Bio::Ontology::Term->new(\n                -identifier  => \"16847\",\n                -name        => \"1-aminocyclopropane-1-carboxylate synthase\",\n                -definition  => \"Catalysis of ...\",\n                -is_obsolete => 0,\n                -comment     => \"\" );\n Function: Creates a new Bio::Ontology::Term.\n Returns : A new Bio::Ontology::Term object.\n Args    : -identifier            => the identifier of this term [scalar]\n           -name                  => the name of this term [scalar]\n           -definition            => the definition of this term [scalar]\n           -ontology              => the ontology this term lives in\n                                     (a Bio::Ontology::OntologyI object)\n           -version               => version information [scalar]\n           -is_obsolete           => the obsoleteness of this term [0 or 1]\n           -comment               => a comment [scalar]\n           -dblinks               => Bio::Annotation::DBLink objects\n                                     [reference to array]\n           -references            => Bio::Annotation::Reference objects\n                                     [reference to array]\n\nSee L<Bio::Ontology::OntologyI>, L<Bio::Annotation::Reference>,\nL<Bio::Annotation::DBLink>.\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n\n    my $self = $class->SUPER::new( @args );\n    my ( $identifier,\n        $name,\n        $definition,\n        $category,\n        $ont,\n        $version,\n        $is_obsolete,\n        $comment,\n        $dblinks,\n        $dbxrefs,\n        $references)\n        = $self->_rearrange( [\n        qw(IDENTIFIER\n        NAME\n        DEFINITION\n        CATEGORY\n        ONTOLOGY\n        VERSION\n        IS_OBSOLETE\n        COMMENT\n        DBLINKS\n        DBXREFS\n        REFERENCES\n       ) ], @args );\n\n    $self->init();\n\n    defined($identifier)   && $self->identifier( $identifier );\n    defined($name)         && $self->name( $name );\n    defined($definition)   && $self->definition( $definition );\n    defined($category)     && $self->category( $category );\n    defined($ont)          && $self->ontology( $ont );\n    defined($version)      && $self->version( $version );\n    defined($is_obsolete)  && $self->is_obsolete( $is_obsolete );\n    defined($comment)      && $self->comment( $comment  );\n    defined($dbxrefs)      && $self->add_dbxref(-dbxrefs => $dbxrefs);\n    # deprecated methods, allow to pass on to get the dep. notification\n    ref($dblinks)          && $self->add_dblink(@$dblinks);\n    ref($references)       && $self->add_reference(@$references);\n\n    return $self;\n} # new\n\n\n\nsub init {\n\n    my $self = shift;\n\n    $self->identifier(undef);\n    $self->name(undef);\n    $self->comment(undef);\n    $self->definition(undef);\n    $self->ontology(undef);\n    $self->is_obsolete(0);\n    $self->remove_synonyms();\n    $self->remove_dbxrefs();\n    $self->remove_references;\n    $self->remove_secondary_ids();\n\n} # init\n\n\n\n=head2 identifier\n\n Title   : identifier\n Usage   : $term->identifier( \"GO:0003947\" );\n           or\n           print $term->identifier();\n Function: Set/get for the identifier of this Term.\n Returns : The identifier [scalar].\n Args    : The identifier [scalar] (optional).\n\n\nsub identifier {\n    my $self = shift;\n\n    return $self->{'identifier'} = shift if @_;\n    return $self->{'identifier'};\n} # identifier\n\n\n=head2 name\n\n Title   : name\n Usage   : $term->name( \"N-acetylgalactosaminyltransferase\" );\n           or\n           print $term->name();\n Function: Set/get for the name of this Term.\n Returns : The name [scalar].\n Args    : The name [scalar] (optional).\n\n\nsub name {\n    my $self = shift;\n\n    return $self->{'name'} = shift if @_;\n    return $self->{'name'};\n} # name\n\n\n=head2 definition\n\n Title   : definition\n Usage   : $term->definition( \"Catalysis of ...\" );\n           or\n           print $term->definition();\n Function: Set/get for the definition of this Term.\n Returns : The definition [scalar].\n Args    : The definition [scalar] (optional).\n\n\nsub definition {\n    my $self = shift;\n\n    return $self->{'definition'} = shift if @_;\n    return $self->{'definition'};\n} # definition\n\n\n=head2 ontology\n\n Title   : ontology\n Usage   : $ont = $term->ontology();\n           or\n           $term->ontology( $ont );\n Function: Get the ontology this term is in.\n\n           Note that with the ontology in hand you can query for all\n           related terms etc.\n\n Returns : The ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object.\n Args    : On set, the  ontology of this Term as a Bio::Ontology::OntologyI\n           implementing object or a string representing its name.\n\nSee L<Bio::Ontology::OntologyI>.\n\n\nsub ontology {\n    my $self = shift;\n    my $ont;\n\n    if(@_) {\n        $ont = shift;\n        if($ont) {\n            $ont = Bio::Ontology::Ontology->new(-name => $ont) if ! ref($ont);\n            if(! $ont->isa(\"Bio::Ontology::OntologyI\")) {\n                $self->throw(ref($ont).\" does not implement \".\n                             \"Bio::Ontology::OntologyI. Bummer.\");\n            }\n        }\n        return $self->{\"_ontology\"} = $ont;\n    }\n    return $self->{\"_ontology\"};\n} # ontology\n\n=head2 version\n\n Title   : version\n Usage   : $term->version( \"1.00\" );\n           or\n           print $term->version();\n Function: Set/get for version information.\n Returns : The version [scalar].\n Args    : The version [scalar] (optional).\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n} # version\n\n=head2 is_obsolete\n\n Title   : is_obsolete\n Usage   : $term->is_obsolete( 1 );\n           or\n           if ( $term->is_obsolete() )\n Function: Set/get for the obsoleteness of this Term.\n Returns : the obsoleteness [0 or 1].\n Args    : the obsoleteness [0 or 1] (optional).\n\n\nsub is_obsolete{\n    my $self = shift;\n\n    return $self->{'is_obsolete'} = shift if @_;\n    return $self->{'is_obsolete'};\n} # is_obsolete\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $term->comment( \"Consider the term ...\" );\n           or\n           print $term->comment();\n Function: Set/get for an arbitrary comment about this Term.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment{\n    my $self = shift;\n\n    return $self->{'comment'} = shift if @_;\n    return $self->{'comment'};\n} # comment\n\n=head2 get_synonyms\n\n Title   : get_synonyms\n Usage   : @aliases = $term->get_synonyms;\n Function: Returns a list of aliases of this Term.\n Returns : A list of aliases [array of [scalar]].\n Args    :\n\n\nsub get_synonyms {\n    my $self = shift;\n\n    return @{ $self->{ \"_synonyms\" } } if exists($self->{ \"_synonyms\" });\n    return ();\n} # get_synonyms\n\n\n=head2 add_synonym\n\n Title   : add_synonym\n Usage   : $term->add_synonym( @asynonyms );\n           or\n           $term->add_synonym( $synonym );\n Function: Pushes one or more synonyms into the list of synonyms.\n Returns :\n Args    : One synonym [scalar] or a list of synonyms [array of [scalar]].\n\n\nsub add_synonym {\n    my ( $self, @values ) = @_;\n\n    return unless( @values );\n\n    # avoid duplicates\n    foreach my $syn (@values) {\n        next if grep { $_ eq $syn; } @{$self->{ \"_synonyms\" }};\n        push( @{ $self->{ \"_synonyms\" } }, $syn );\n    }\n\n} # add_synonym\n\n\n=head2 remove_synonyms\n\n Title   : remove_synonyms()\n Usage   : $term->remove_synonyms();\n Function: Deletes (and returns) the synonyms of this Term.\n Returns : A list of synonyms [array of [scalar]].\n Args    :\n\n\nsub remove_synonyms {\n    my ( $self ) = @_;\n\n    my @a = $self->get_synonyms();\n    $self->{ \"_synonyms\" } = [];\n    return @a;\n\n} # remove_synonyms\n\n=head2 get_dblinks\n\n Title   : get_dblinks()\n Usage   : @ds = $term->get_dblinks();\n Function: Returns a list of each dblinks of this GO term.\n Returns : A list of dblinks [array of [scalars]].\n Args    : A scalar indicating the context (optional).\n           If omitted, all dblinks will be returned.\n Note    : deprecated method due to past use of mixed data types; use\n           get_dbxrefs() instead, which handles both strings and DBLink\n           instances\n\n\nsub get_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"Use of get_dblinks is deprecated.  Note that prior use\\n\".\n                      \"of this method could return either simple scalar values\\n\".\n                      \"or Bio::Annotation::DBLink instances; only \\n\".\n                      \"Bio::Annotation::DBLink is now supported.\\n \".\n                      \"Use get_dbxrefs() instead\");\n    $self->get_dbxrefs($context);\n} # get_dblinks\n\n=head2 get_dbxrefs\n\n Title   : get_dbxrefs()\n Usage   : @ds = $term->get_dbxrefs();\n Function: Returns a list of each link for this term.\n\n           If an implementor of this interface permits modification of\n           this array property, the class should define at least\n           methods add_dbxref() and remove_dbxrefs(), with obvious\n           functionality.\n\n Returns : A list of L<Bio::Annotation::DBLink> instances\n Args    : [optional] string which specifies context (default : returns all dbxrefs)\n\n\nsub get_dbxrefs {\n    my ($self, $context) = shift;\n    my @dbxrefs;\n    if (defined($context)) {\n        if (exists($self->{_dblinks}->{$context})) {\n            @dbxrefs =  @{$self->{_dblinks}->{$context}};\n        }\n    } else {\n        @dbxrefs = map { @$_ } values %{$self->{_dblinks}} ;\n    }\n    return @dbxrefs;\n} # get_dbxrefs\n\n=head2 get_dblink_context\n\n  Title   : get_dblink_context\n  Usage   : @context = $term->get_dblink_context;\n  Function: Return all context existing in Term\n  Returns : a list of scalar\n  Args    : [none]\n  Note    : deprecated method due to past use of mixed data types; use\n            get_dbxref_context() instead\n\n\nsub get_dblink_context {\n    my $self=shift;\n    $self->deprecated(\"Use of get_dblink_context() is deprecated; use get_dbxref_context() instead\");\n    return $self->get_dbxref_context(@_);\n}\n\n=head2 get_dbxref_context\n\n  Title   : get_dbxref_context\n  Usage   : @context = $term->get_dbxref_context;\n  Function: Return all context strings existing in Term\n  Returns : a list of scalars\n  Args    : [none]\n\n\nsub get_dbxref_context {\n    my $self=shift;\n    return keys %{$self->{_dblinks}};\n}\n\n=head2 add_dblink\n\n Title   : add_dblink\n Usage   : $term->add_dblink( @dbls );\n           or\n           $term->add_dblink( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : One or more L<Bio::Annotation::DBLink> instances\n Note    : deprecated method due to past use of mixed data types; use\n           add_dbxref() instead, which handles both strings and\n           DBLink instances\n\n\nsub add_dblink {\n    my $self = shift;\n    $self->deprecated(\"Use of simple strings and add_dblink() is deprecated; use\\n\".\n                      \"Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    # here we're assuming the data is in a simple DB:ID format\n    my @dbxrefs;\n    for my $string (@_) {\n        my ($db, $id) = split(':',$string);\n        push @dbxrefs, Bio::Annotation::DBLink->new(-database => $db, -primary_id => $id);\n    }\n    return $self->add_dbxref(-dbxrefs => \\@dbxrefs, -context => '_default');\n} # add_dblink\n\n=head2 add_dbxref\n\n Title   : add_dbxref\n Usage   : $term->add_dbxref( @dbls );\n           or\n           $term->add_dbxref( $dbl );\n Function: Pushes one or more dblinks onto the list of dblinks.\n Returns :\n Args    : -dbxrefs : array ref of Bio::Annotation::DBLink instances\n           -context : string designating the context for the DBLink\n                       (default : '_default' - contextless)\n\n\nsub add_dbxref {\n    my $self = shift;\n    my ($links, $context) = $self->_rearrange([qw(DBXREFS CONTEXT)],@_);\n    return unless defined $links;\n    $context ||= '_default';\n    $self->throw(\"DBLinks must be passed as an array reference\") if ref $links ne 'ARRAY';\n    foreach my $dbxref (@{$links}) {\n        $self->throw(\"$dbxref is not a DBLink\") unless ref $dbxref &&\n            $dbxref->isa('Bio::Annotation::DBLink');\n        $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n        if (! exists($self->{_dblinks}->{$context})) {\n            $self->{_dblinks}->{$context} = [];\n        }\n        my $linktext = ref $dbxref ? $dbxref->display_text : $dbxref;\n        if (grep {$_->display_text eq $linktext}\n            @{$self->{_dblinks}->{$context}})\n        {\n            $self->warn(\"DBLink exists in the dblink of $context\");\n        }\n        push @{$self->{_dblinks}->{$context}}, $dbxref;    \n    }\n} # add_dbxref\n\n=head2 has_dblink\n\n  Title   : has_dblink\n  Usage   : $term->has_dblink($dblink);\n  Function: Checks if a DBXref is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier\n  Note    : deprecated method due to past use of mixed data types; use\n            has_dbxref() instead, which handles both strings and\n            DBLink instances\n\n\nsub has_dblink {\n    my ( $self, $value ) = @_;\n    $self->deprecated(\"use of has_dblink() is deprecated; use has_dbxref() instead\");\n    return $self->has_dbxref($value);\n}\n\n=head2 has_dbxref\n\n  Title   : has_dbxref\n  Usage   : $term->has_dbxref($dbxref);\n  Function: Checks if a dbxref string is already existing in the OBOterm object\n  Return  : TRUE/FALSE\n  Args    : [arg1] A DBxref identifier (string).\n            Bio::Annotation::DBLink::display_text() is used for comparison\n            against the string.\n\n\nsub has_dbxref {\n    my ( $self, $value ) = @_;\n    return unless defined $value;\n    my $context = \"_default\";\n    $self->throw(\"'all' is a reserved word for context.\") if $context eq 'all';\n    $context ||= '_default';\n    if ( ( $self->{_dblinks}->{$context} ) &&\n        grep { $_->display_text eq $value } \n        @{ $self->{_dblinks}->{$context} } )\n    {\n        return TRUE;\n    }\n    else {\n        return FALSE;\n    }\n}\n\n=head2 add_dblink_context\n\n  Title   : add_dblink_context\n  Usage   : $term->add_dblink_context($db, $context);\n  Function: add a dblink with its context\n  Return  : [none]\n  Args    : [arg1] a Bio::Annotation::DBLink instance\n            [arg2] a string for context; if omitted, the\n                   default/context-less one will be used.\n  Note    : deprecated method due to past use of mixed data types; use\n            add_dbxref() instead\n\n\nsub add_dblink_context {\n    my ($self, $value, $context) = @_;\n    $self->deprecated(\"Use of simple strings and add_dblink_context() is deprecated; use\\n\n                      Bio::Annotation::DBLink instances and add_dbxref() instead\");\n    return $self->add_dbxref([$value],$context);\n}\n\n=head2 remove_dblinks\n\n Title   : remove_dblinks()\n Usage   : $term->remove_dblinks();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.\n Note    : deprecated method due to past use of mixed data types; use\n           remove_dblinks() instead, which handles both strings and\n           DBLink instances\n\n\nsub remove_dblinks {\n    my ($self, $context) = @_;\n    $self->deprecated(\"use of remove_dblinks() is deprecated; use remove_dbxrefs() instead\");\n    return $self->remove_dbxrefs(@_);\n} # remove_dblinks\n\n=head2 remove_dbxrefs\n\n Title   : remove_dbxrefs()\n Usage   : $term->remove_dbxrefs();\n Function: Deletes (and returns) the definition references of this GO term.\n Returns : A list of definition references [array of [scalars]].\n Args    : Context. If omitted or equal to 'all', all dblinks\n           will be removed.\n\n\nsub remove_dbxrefs {\n    my ($self, $context) = @_;\n    $context = undef if $context && ($context eq \"all\");\n    my @old = $self->get_dbxrefs($context);\n    if (defined($context)) {\n        $self->{_dblinks}->{$context}=[];\n    } else {\n        $self->{_dblinks} = {};\n    }\n    return @old;\n} # remove_dbxrefs\n\n=head2 get_references\n\n  Title   : get_references\n  Usage   : @references = $self->get_references\n  Fuctnion: Returns a list of references\n  Return  : A list of objects\n  Args    : [none]\n\n\nsub get_references {\n    my $self=shift;\n    return @{$self->{_references}} if exists $self->{_references};\n    return ();\n}\n\n=head2 add_reference\n\n  Title   : add_reference\n  Usage   : $self->add_reference($reference);\n            $self->add_reference($reference1, $reference2);\n  Fuctnion: Add one or more references\n  Returns : [none]","label":"add_reference($self,@values)"}},{"line":730,"kind":12,"name":"_references"},{"name":"_references","kind":12,"line":731},{"line":731,"name":"$reference","kind":13,"containerName":null},{"definition":"sub","name":"remove_references","containerName":"main::","children":[{"line":746,"name":"$self","kind":13,"localvar":"my","containerName":"remove_references","definition":"my"},{"definition":"my","name":"@references","localvar":"my","kind":13,"containerName":"remove_references","line":747},{"line":747,"kind":13,"containerName":"remove_references","name":"$self"},{"line":747,"name":"get_references","containerName":"remove_references","kind":12},{"kind":13,"containerName":"remove_references","name":"$self","line":748},{"line":749,"name":"@references","containerName":"remove_references","kind":13}],"kind":12,"range":{"start":{"character":0,"line":745},"end":{"line":750,"character":9999}},"line":745},{"line":748,"kind":12,"name":"_references"},{"kind":12,"range":{"start":{"line":766,"character":0},"end":{"character":9999,"line":769}},"line":766,"definition":"sub","containerName":"main::","name":"get_secondary_ids","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"get_secondary_ids","line":767},{"line":769,"name":"$self","containerName":"get_secondary_ids","kind":13}]},{"containerName":null,"kind":13,"name":"%self","line":769},{"line":786,"range":{"end":{"character":9999,"line":794},"start":{"character":0,"line":786}},"kind":12,"children":[{"kind":13,"localvar":"my","containerName":"add_secondary_id","name":"$self","line":787,"definition":"my"},{"line":792,"name":"$id","localvar":"my","kind":13,"containerName":"add_secondary_id","definition":"my"},{"name":"$id","containerName":"add_secondary_id","kind":13,"line":793},{"line":793,"name":"$self","kind":13,"containerName":"add_secondary_id"},{"line":794,"kind":13,"containerName":"add_secondary_id","name":"$self"}],"containerName":"main::","name":"add_secondary_id","definition":"sub"},{"name":"$id","kind":13,"containerName":null,"line":794},{"line":810,"kind":12,"range":{"start":{"line":810,"character":0},"end":{"line":817,"character":9999}},"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"remove_secondary_ids","line":811,"definition":"my"},{"name":"@a","containerName":"remove_secondary_ids","localvar":"my","kind":13,"line":813,"definition":"my"},{"line":813,"name":"$self","kind":13,"containerName":"remove_secondary_ids"},{"name":"get_secondary_ids","containerName":"remove_secondary_ids","kind":12,"line":813},{"line":814,"containerName":"remove_secondary_ids","kind":13,"name":"$self"},{"line":815,"name":"@a","kind":13,"containerName":"remove_secondary_ids"}],"name":"remove_secondary_ids","containerName":"main::"},{"detail":"($self,$value)","definition":"sub","name":"_is_true_or_false","containerName":"main::","children":[{"line":825,"name":"$self","kind":13,"localvar":"my","containerName":"_is_true_or_false","definition":"my"},{"line":825,"name":"$value","containerName":"_is_true_or_false","kind":13},{"containerName":"_is_true_or_false","kind":13,"name":"$value","line":826},{"line":826,"containerName":"_is_true_or_false","kind":13,"name":"$value"},{"name":"$value","containerName":"_is_true_or_false","kind":13,"line":826},{"line":827,"containerName":"_is_true_or_false","kind":13,"name":"$self"},{"kind":12,"containerName":"_is_true_or_false","name":"throw","line":827},{"line":828,"containerName":"_is_true_or_false","kind":13,"name":"$value"}],"signature":{"label":"_is_true_or_false($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":" Title   :_is_true_or_false\n Function: Checks whether the argument is TRUE or FALSE.\n Returns :\n Args    : The value to be checked."},"range":{"end":{"line":830,"character":9999},"start":{"character":0,"line":824}},"kind":12,"line":824},{"kind":12,"name":"TRUE","line":826},{"kind":12,"name":"FALSE","line":826},{"name":"TRUE","kind":12,"line":828},{"name":"FALSE","kind":12,"line":828},{"line":849,"kind":12,"range":{"end":{"character":9999,"line":851},"start":{"line":849,"character":0}},"definition":"sub","children":[{"line":850,"containerName":"object_id","kind":12,"name":"identifier"}],"name":"object_id","containerName":"main::"},{"range":{"start":{"line":870,"character":0},"end":{"line":878,"character":9999}},"kind":12,"line":870,"name":"authority","containerName":"main::","children":[{"definition":"my","line":871,"containerName":"authority","localvar":"my","kind":13,"name":"$self"},{"definition":"my","line":872,"localvar":"my","containerName":"authority","kind":13,"name":"$ont"},{"name":"$self","kind":13,"containerName":"authority","line":872},{"name":"ontology","containerName":"authority","kind":12,"line":872},{"line":874,"name":"$ont","kind":13,"containerName":"authority"},{"line":874,"name":"authority","kind":12,"containerName":"authority"},{"line":874,"kind":13,"containerName":"authority","name":"$ont"},{"line":875,"kind":13,"containerName":"authority","name":"$self"},{"line":875,"kind":12,"containerName":"authority","name":"throw"}],"definition":"sub"},{"line":899,"kind":12,"range":{"end":{"character":9999,"line":905},"start":{"line":899,"character":0}},"children":[{"definition":"my","line":900,"name":"$self","localvar":"my","containerName":"namespace","kind":13},{"line":902,"containerName":"namespace","kind":13,"name":"$self"},{"name":"ontology","containerName":"namespace","kind":12,"line":902},{"line":903,"name":"$ont","localvar":"my","kind":13,"containerName":"namespace","definition":"my"},{"name":"$self","kind":13,"containerName":"namespace","line":903},{"name":"ontology","containerName":"namespace","kind":12,"line":903},{"line":904,"kind":13,"containerName":"namespace","name":"$ont"},{"line":904,"name":"$ont","kind":13,"containerName":"namespace"},{"line":904,"name":"name","kind":12,"containerName":"namespace"}],"containerName":"main::","name":"namespace","definition":"sub"},{"children":[{"line":924,"name":"name","containerName":"display_name","kind":12}],"containerName":"main::","name":"display_name","definition":"sub","line":923,"kind":12,"range":{"start":{"character":0,"line":923},"end":{"line":925,"character":9999}}},{"range":{"end":{"character":9999,"line":949},"start":{"character":0,"line":947}},"kind":12,"line":947,"containerName":"main::","name":"description","children":[{"name":"definition","kind":12,"containerName":"description","line":948}],"definition":"sub"},{"line":961,"range":{"end":{"character":9999,"line":961},"start":{"line":961,"character":0}},"kind":12,"definition":"sub","children":[{"line":961,"kind":12,"containerName":"each_dblink","name":"throw"}],"name":"each_dblink","containerName":"main::"},{"range":{"end":{"line":962,"character":9999},"start":{"character":0,"line":962}},"kind":12,"line":962,"definition":"sub","containerName":"main::","name":"add_dblinks","children":[{"line":962,"name":"throw","containerName":"add_dblinks","kind":12}]}],"version":5}