{"version":5,"vars":[{"line":116,"name":"vars","kind":2,"containerName":""},{"name":"GenPept","kind":2,"containerName":"Carp::Bio::SeqIO::Bio::Seq::Bio::Root::Version::Bio::DB::EMBL::Bio::DB::GenBank::Bio::DB::SwissProt::Bio::DB::RefSeq::Bio::DB","line":131},{"line":132,"name":"%DBOKAY","kind":13,"containerName":null},{"line":134,"name":"$DBOKAY","kind":13,"containerName":null},{"line":138,"name":"base","containerName":"","kind":2},{"line":140,"name":"@EXPORT","containerName":null,"kind":13},{"line":145,"kind":13,"containerName":null,"name":"@EXPORT_OK"},{"line":145,"name":"@EXPORT","kind":13,"containerName":null},{"definition":"sub","detail":"($filename,$format)","children":[{"line":174,"name":"$filename","kind":13,"localvar":"my","containerName":"read_sequence","definition":"my"},{"name":"$format","kind":13,"containerName":"read_sequence","line":174},{"containerName":"read_sequence","kind":13,"name":"$filename","line":176},{"name":"$seqio","localvar":"my","kind":13,"containerName":"read_sequence","line":180,"definition":"my"},{"kind":13,"containerName":"read_sequence","name":"$format","line":182},{"kind":13,"containerName":"read_sequence","name":"$seqio","line":183},{"containerName":"read_sequence","kind":12,"name":"new","line":183},{"line":183,"kind":13,"containerName":"read_sequence","name":"$filename"},{"name":"$format","containerName":"read_sequence","kind":13,"line":183},{"name":"$seqio","kind":13,"containerName":"read_sequence","line":185},{"name":"new","kind":12,"containerName":"read_sequence","line":185},{"line":185,"kind":13,"containerName":"read_sequence","name":"$filename"},{"localvar":"my","containerName":"read_sequence","kind":13,"name":"$seq","line":188,"definition":"my"},{"name":"$seqio","containerName":"read_sequence","kind":13,"line":188},{"name":"next_seq","kind":12,"containerName":"read_sequence","line":188},{"line":190,"name":"$seq","containerName":"read_sequence","kind":13}],"containerName":"main::","name":"read_sequence","signature":{"label":"read_sequence($filename,$format)","parameters":[{"label":"$filename"},{"label":"$format"}],"documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>."},"line":173,"kind":12,"range":{"start":{"line":173,"character":0},"end":{"line":191,"character":9999}}},{"line":177,"name":"confess","kind":12},{"containerName":"SeqIO","kind":12,"name":"Bio","line":183},{"containerName":"SeqIO","kind":12,"name":"Bio","line":185},{"children":[{"localvar":"my","containerName":"read_all_sequences","kind":13,"name":"$filename","line":217,"definition":"my"},{"line":217,"name":"$format","containerName":"read_all_sequences","kind":13},{"line":219,"name":"$filename","kind":13,"containerName":"read_all_sequences"},{"name":"$seqio","kind":13,"localvar":"my","containerName":"read_all_sequences","line":223,"definition":"my"},{"kind":13,"containerName":"read_all_sequences","name":"$format","line":225},{"name":"$seqio","kind":13,"containerName":"read_all_sequences","line":226},{"name":"new","containerName":"read_all_sequences","kind":12,"line":226},{"name":"$filename","containerName":"read_all_sequences","kind":13,"line":226},{"name":"$format","containerName":"read_all_sequences","kind":13,"line":226},{"name":"$seqio","containerName":"read_all_sequences","kind":13,"line":228},{"line":228,"name":"new","kind":12,"containerName":"read_all_sequences"},{"line":228,"name":"$filename","kind":13,"containerName":"read_all_sequences"},{"line":231,"containerName":"read_all_sequences","localvar":"my","kind":13,"name":"@seq_array","definition":"my"},{"definition":"my","line":233,"localvar":"my","kind":13,"containerName":"read_all_sequences","name":"$seq"},{"line":233,"containerName":"read_all_sequences","kind":13,"name":"$seqio"},{"line":233,"name":"next_seq","containerName":"read_all_sequences","kind":12},{"line":234,"name":"@seq_array","containerName":"read_all_sequences","kind":13},{"kind":13,"containerName":"read_all_sequences","name":"$seq","line":234},{"line":237,"kind":13,"containerName":"read_all_sequences","name":"@seq_array"}],"containerName":"main::","name":"read_all_sequences","definition":"sub","detail":"($filename,$format)","line":216,"range":{"end":{"line":238,"character":9999},"start":{"character":0,"line":216}},"kind":12,"signature":{"documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>.\n\n\nsub read_sequence{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_sequence($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my $seq = $seqio->next_seq();\n\n   return $seq;\n}\n\n\n=head2 read_all_sequences\n\n Title   : read_all_sequences\n Usage   : @seq_object_array = read_all_sequences($filename);\n           @seq_object_array = read_all_sequences($filename,'genbank');\n\n Function: Just as the function above, but reads all the sequences in the\n           file and loads them into an array.\n\n           For very large files, you will run out of memory. When this\n           happens, you've got to use the SeqIO system directly (this is\n           not so hard! Don't worry about it!).\n\n Returns : array of Bio::Seq objects\n\n Args    : two strings, first the filename (any open() string is ok)\n           second the format (which is optional)\n\nSee L<Bio::SeqIO> and L<Bio::Seq> for more information","parameters":[{"label":"$filename"},{"label":"$format"}],"label":"read_all_sequences($filename,$format)"}},{"line":220,"name":"confess","kind":12},{"kind":12,"containerName":"SeqIO","name":"Bio","line":226},{"name":"Bio","kind":12,"containerName":"SeqIO","line":228},{"signature":{"parameters":[{"label":"$filename"},{"label":"$format"},{"label":"@sequence_objects"}],"documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>.\n\n\nsub read_sequence{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_sequence($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my $seq = $seqio->next_seq();\n\n   return $seq;\n}\n\n\n=head2 read_all_sequences\n\n Title   : read_all_sequences\n Usage   : @seq_object_array = read_all_sequences($filename);\n           @seq_object_array = read_all_sequences($filename,'genbank');\n\n Function: Just as the function above, but reads all the sequences in the\n           file and loads them into an array.\n\n           For very large files, you will run out of memory. When this\n           happens, you've got to use the SeqIO system directly (this is\n           not so hard! Don't worry about it!).\n\n Returns : array of Bio::Seq objects\n\n Args    : two strings, first the filename (any open() string is ok)\n           second the format (which is optional)\n\nSee L<Bio::SeqIO> and L<Bio::Seq> for more information\n\n\nsub read_all_sequences{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_all_sequences($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my @seq_array;\n\n   while( my $seq = $seqio->next_seq() ) {\n       push(@seq_array,$seq);\n   }\n\n   return @seq_array;\n}\n\n\n=head2 write_sequence\n\n Title   : write_sequence\n Usage   : write_sequence(\">new_file.gb\",'genbank',$seq)\n           write_sequence(\">new_file.gb\",'genbank',@array_of_sequence_objects)\n\n Function: writes sequences in the specified format\n\n Returns : true\n\n Args    : filename as a string, must provide an open() output file\n           format as a string\n           one or more sequence objects","label":"write_sequence($filename,$format,@sequence_objects)"},"kind":12,"range":{"start":{"line":258,"character":0},"end":{"character":9999,"line":304}},"line":258,"detail":"($filename,$format,@sequence_objects)","definition":"sub","containerName":"main::","name":"write_sequence","children":[{"line":259,"name":"$filename","localvar":"my","kind":13,"containerName":"write_sequence","definition":"my"},{"line":259,"name":"$format","containerName":"write_sequence","kind":13},{"line":259,"containerName":"write_sequence","kind":13,"name":"@sequence_objects"},{"name":"@sequence_objects","containerName":"write_sequence","kind":13,"line":261},{"definition":"my","line":265,"localvar":"my","kind":13,"containerName":"write_sequence","name":"$error"},{"definition":"my","localvar":"my","kind":13,"containerName":"write_sequence","name":"$seqname","line":266},{"line":269,"name":"$filename","containerName":"write_sequence","kind":13},{"name":"$filename","kind":13,"containerName":"write_sequence","line":269},{"line":270,"name":"$filename","containerName":"write_sequence","kind":13},{"line":270,"containerName":"write_sequence","kind":13,"name":"$filename"},{"definition":"my","kind":13,"localvar":"my","containerName":"write_sequence","name":"$seqio","line":273},{"line":273,"kind":12,"containerName":"write_sequence","name":"new"},{"containerName":"write_sequence","kind":13,"name":"$filename","line":273},{"kind":13,"containerName":"write_sequence","name":"$format","line":273},{"line":275,"name":"$seq","containerName":"write_sequence","localvar":"my","kind":13,"definition":"my"},{"containerName":"write_sequence","kind":13,"name":"@sequence_objects","line":275},{"definition":"my","line":276,"containerName":"write_sequence","localvar":"my","kind":13,"name":"$seq_obj"},{"containerName":"write_sequence","kind":13,"name":"$seq","line":278},{"containerName":"write_sequence","kind":13,"name":"$seq","line":279},{"line":283,"kind":13,"containerName":"write_sequence","name":"$error"},{"line":285,"name":"$error","kind":13,"containerName":"write_sequence"},{"name":"$seq_obj","containerName":"write_sequence","kind":13,"line":288},{"line":288,"containerName":"write_sequence","kind":13,"name":"$seq"},{"line":288,"name":"$seqname","containerName":"write_sequence","kind":13},{"name":"$seqname","containerName":"write_sequence","kind":13,"line":289},{"line":294,"containerName":"write_sequence","kind":13,"name":"$seq"},{"line":294,"name":"isa","containerName":"write_sequence","kind":12},{"containerName":"write_sequence","kind":13,"name":"$seq_obj","line":297},{"line":297,"name":"$seq","containerName":"write_sequence","kind":13},{"name":"$seqio","containerName":"write_sequence","kind":13,"line":301},{"name":"write_seq","kind":12,"containerName":"write_sequence","line":301},{"line":301,"name":"$seq_obj","containerName":"write_sequence","kind":13}]},{"line":262,"kind":12,"name":"confess"},{"line":273,"name":"Bio","containerName":"SeqIO","kind":12},{"name":"carp","kind":12,"line":284},{"line":288,"name":"new_sequence","kind":12},{"name":"confess","kind":12,"line":291},{"kind":12,"name":"confess","line":295},{"children":[{"name":"$seq","kind":13,"localvar":"my","containerName":"new_sequence","line":321,"definition":"my"},{"name":"$name","containerName":"new_sequence","kind":13,"line":321},{"containerName":"new_sequence","kind":13,"name":"$accession","line":321},{"line":323,"name":"$seq","kind":13,"containerName":"new_sequence"},{"line":327,"containerName":"new_sequence","kind":13,"name":"$name"},{"name":"$seq_object","kind":13,"localvar":"my","containerName":"new_sequence","line":329,"definition":"my"},{"line":329,"containerName":"new_sequence","kind":12,"name":"new"},{"line":329,"containerName":"new_sequence","kind":13,"name":"$seq"},{"name":"$name","kind":13,"containerName":"new_sequence","line":329},{"containerName":"new_sequence","kind":13,"name":"$accession","line":331},{"line":331,"containerName":"new_sequence","kind":13,"name":"$seq_object"},{"line":331,"name":"accession_number","kind":12,"containerName":"new_sequence"},{"name":"$accession","containerName":"new_sequence","kind":13,"line":331},{"line":333,"name":"$seq_object","containerName":"new_sequence","kind":13}],"name":"new_sequence","containerName":"main::","definition":"sub","detail":"($seq,$name,$accession)","line":320,"range":{"end":{"character":9999,"line":334},"start":{"line":320,"character":0}},"kind":12,"signature":{"label":"new_sequence($seq,$name,$accession)","documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>.\n\n\nsub read_sequence{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_sequence($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my $seq = $seqio->next_seq();\n\n   return $seq;\n}\n\n\n=head2 read_all_sequences\n\n Title   : read_all_sequences\n Usage   : @seq_object_array = read_all_sequences($filename);\n           @seq_object_array = read_all_sequences($filename,'genbank');\n\n Function: Just as the function above, but reads all the sequences in the\n           file and loads them into an array.\n\n           For very large files, you will run out of memory. When this\n           happens, you've got to use the SeqIO system directly (this is\n           not so hard! Don't worry about it!).\n\n Returns : array of Bio::Seq objects\n\n Args    : two strings, first the filename (any open() string is ok)\n           second the format (which is optional)\n\nSee L<Bio::SeqIO> and L<Bio::Seq> for more information\n\n\nsub read_all_sequences{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_all_sequences($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my @seq_array;\n\n   while( my $seq = $seqio->next_seq() ) {\n       push(@seq_array,$seq);\n   }\n\n   return @seq_array;\n}\n\n\n=head2 write_sequence\n\n Title   : write_sequence\n Usage   : write_sequence(\">new_file.gb\",'genbank',$seq)\n           write_sequence(\">new_file.gb\",'genbank',@array_of_sequence_objects)\n\n Function: writes sequences in the specified format\n\n Returns : true\n\n Args    : filename as a string, must provide an open() output file\n           format as a string\n           one or more sequence objects\n\n\n\nsub write_sequence{\n   my ($filename,$format,@sequence_objects) = @_;\n\n   if( scalar(@sequence_objects) == 0 ) {\n       confess(\"write_sequence(filename,format,sequence_object)\");\n   }\n\n   my $error = 0;\n   my $seqname = \"sequence1\";\n\n   # catch users who haven't passed us a filename we can open\n   if( $filename !~ /^\\>/ && $filename !~ /^|/ ) {\n       $filename = \">\".$filename;\n   }\n\n   my $seqio = Bio::SeqIO->new('-file' => $filename, '-format' => $format);\n\n   foreach my $seq ( @sequence_objects ) {\n       my $seq_obj;\n\n       if( !ref $seq ) {\n\t   if( length $seq > 50 ) {\n\t       # odds are this is a sequence as a string, and someone has not figured out\n\t       # how to make objects. Warn him/her and then make a sequence object\n\t       # from this\n\t       if( $error == 0 ) {\n\t\t   carp(\"WARNING: You have put in a long string into write_sequence.\\nI suspect this means that this is the actual sequence\\nIn the future try the\\n  new_sequence method of this module to make a new sequence object.\\nDoing this for you here\\n\");\n\t\t   $error = 1;\n\t       }\n\n\t       $seq_obj = new_sequence($seq,$seqname);\n\t       $seqname++;\n\t   } else {\n\t       confess(\"You have a non object [$seq] passed to write_sequence. It maybe that you want to use new_sequence to make this string into a sequence object?\");\n\t   }\n       } else {\n\t   if( !$seq->isa(\"Bio::SeqI\") ) {\n\t       confess(\"object [$seq] is not a Bio::Seq object; can't write it out\");\n\t   }\n\t   $seq_obj = $seq;\n       }\n\n       # finally... we get to write out the sequence!\n       $seqio->write_seq($seq_obj);\n   }\n   1;\n}\n\n=head2 new_sequence\n\n Title   : new_sequence\n Usage   : $seq_obj = new_sequence(\"GATTACA\", \"kino-enzyme\");\n\n Function: Construct a sequency object from sequence string\n Returns : A Bio::Seq object\n\n Args    : sequence string\n           name string (optional, default \"no-name-for-sequence\")\n           accession - accession number (optional, no default)","parameters":[{"label":"$seq"},{"label":"$name"},{"label":"$accession"}]}},{"line":324,"kind":12,"name":"confess"},{"line":329,"name":"Bio","kind":12,"containerName":"Seq"},{"line":357,"range":{"start":{"character":0,"line":357},"end":{"character":9999,"line":413}},"kind":12,"children":[{"definition":"my","name":"$seq","localvar":"my","kind":13,"containerName":"blast_sequence","line":358},{"line":358,"name":"$verbose","containerName":"blast_sequence","kind":13},{"line":360,"name":"$verbose","containerName":"blast_sequence","kind":13},{"containerName":"blast_sequence","kind":13,"name":"$verbose","line":361},{"line":364,"kind":13,"containerName":"blast_sequence","name":"$seq"},{"line":365,"name":"$seq","containerName":"blast_sequence","kind":13},{"containerName":"blast_sequence","kind":12,"name":"new","line":365},{"containerName":"blast_sequence","kind":13,"name":"$seq","line":365},{"name":"$seq","kind":13,"containerName":"blast_sequence","line":366},{"name":"isa","containerName":"blast_sequence","kind":12,"line":366},{"definition":"my","name":"$prog","localvar":"my","kind":13,"containerName":"blast_sequence","line":372},{"line":373,"localvar":"my","kind":13,"containerName":"blast_sequence","name":"$e_val","definition":"my"},{"definition":"my","name":"@params","kind":13,"localvar":"my","containerName":"blast_sequence","line":375},{"kind":13,"containerName":"blast_sequence","name":"$prog","line":375},{"name":"$e_val","kind":13,"containerName":"blast_sequence","line":376},{"definition":"my","line":379,"containerName":"blast_sequence","localvar":"my","kind":13,"name":"$factory"},{"line":379,"containerName":"blast_sequence","kind":12,"name":"new"},{"line":379,"kind":13,"containerName":"blast_sequence","name":"@params"},{"localvar":"my","kind":13,"containerName":"blast_sequence","name":"$r","line":381,"definition":"my"},{"line":381,"name":"$factory","kind":13,"containerName":"blast_sequence"},{"name":"submit_blast","containerName":"blast_sequence","kind":12,"line":381},{"line":381,"name":"$seq","containerName":"blast_sequence","kind":13},{"line":382,"containerName":"blast_sequence","kind":13,"name":"$verbose"},{"line":383,"name":"$seq","containerName":"blast_sequence","kind":13},{"kind":12,"containerName":"blast_sequence","name":"id","line":383},{"line":387,"kind":13,"localvar":"my","containerName":"blast_sequence","name":"$result","definition":"my"},{"definition":"my","name":"@rids","localvar":"my","kind":13,"containerName":"blast_sequence","line":390},{"name":"$factory","kind":13,"containerName":"blast_sequence","line":390},{"containerName":"blast_sequence","kind":12,"name":"each_rid","line":390},{"name":"$rid","localvar":"my","containerName":"blast_sequence","kind":13,"line":391,"definition":"my"},{"line":391,"name":"@rids","kind":13,"containerName":"blast_sequence"},{"definition":"my","line":392,"name":"$rc","containerName":"blast_sequence","localvar":"my","kind":13},{"name":"$factory","containerName":"blast_sequence","kind":13,"line":392},{"kind":12,"containerName":"blast_sequence","name":"retrieve_blast","line":392},{"name":"$rid","containerName":"blast_sequence","kind":13,"line":392},{"line":393,"kind":13,"containerName":"blast_sequence","name":"$rc"},{"line":394,"name":"$rc","kind":13,"containerName":"blast_sequence"},{"line":395,"containerName":"blast_sequence","kind":13,"name":"$factory"},{"kind":12,"containerName":"blast_sequence","name":"remove_rid","line":395},{"line":395,"kind":13,"containerName":"blast_sequence","name":"$rid"},{"line":397,"name":"$verbose","kind":13,"containerName":"blast_sequence"},{"line":402,"containerName":"blast_sequence","kind":13,"name":"$result"},{"name":"$rc","containerName":"blast_sequence","kind":13,"line":402},{"line":402,"kind":12,"containerName":"blast_sequence","name":"next_result"},{"name":"$factory","containerName":"blast_sequence","kind":13,"line":403},{"line":403,"name":"remove_rid","containerName":"blast_sequence","kind":12},{"kind":13,"containerName":"blast_sequence","name":"$rid","line":403},{"containerName":"blast_sequence","kind":13,"name":"$verbose","line":409},{"line":412,"containerName":"blast_sequence","kind":13,"name":"$result"}],"containerName":"main::","name":"blast_sequence","definition":"sub"},{"name":"Bio","kind":12,"containerName":"Seq","line":365},{"name":"croak","kind":12,"line":367},{"containerName":"Tools::Run::RemoteBlast","kind":12,"name":"Bio","line":372},{"name":"Bio","kind":12,"containerName":"Tools::Run::RemoteBlast","line":379},{"line":389,"name":"LOOP","kind":12},{"kind":12,"name":"LOOP","line":404},{"line":431,"kind":12,"range":{"start":{"character":0,"line":431},"end":{"character":9999,"line":442}},"signature":{"label":"write_blast($filename,$blast)","parameters":[{"label":"$filename"},{"label":"$blast"}],"documentation":"1;\n# $Id: Perl.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Perl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Perl - Functional access to BioPerl for people who don't know objects\n\n=head1 SYNOPSIS\n\n  use Bio::Perl;\n\n  # will guess file format from extension\n  $seq_object = read_sequence($filename);\n\n  # forces genbank format\n  $seq_object = read_sequence($filename,'genbank');\n\n  # reads an array of sequences\n  @seq_object_array = read_all_sequences($filename,'fasta');\n\n  # sequences are Bio::Seq objects, so the following methods work\n  # for more info see Bio::Seq, or do 'perldoc Bio/Seq.pm'\n\n  print \"Sequence name is \",$seq_object->display_id,\"\\n\";\n  print \"Sequence acc  is \",$seq_object->accession_number,\"\\n\";\n  print \"First 5 bases is \",$seq_object->subseq(1,5),\"\\n\";\n\n  # get the whole sequence as a single string\n\n  $sequence_as_a_string = $seq_object->seq();\n\n  # writing sequences\n\n  write_sequence(\">$filename\",'genbank',$seq_object);\n\n  write_sequence(\">$filename\",'genbank',@seq_object_array);\n\n  # making a new sequence from just a string\n\n  $seq_object = new_sequence(\"ATTGGTTTGGGGACCCAATTTGTGTGTTATATGTA\",\n      \"myname\",\"AL12232\");\n\n  # getting a sequence from a database (assumes internet connection)\n\n  $seq_object = get_sequence('swissprot',\"ROA1_HUMAN\");\n\n  $seq_object = get_sequence('embl',\"AI129902\");\n\n  $seq_object = get_sequence('genbank',\"AI129902\");\n\n  # BLAST a sequence (assummes an internet connection)\n\n  $blast_report = blast_sequence($seq_object);\n\n  write_blast(\">blast.out\",$blast_report);\n\n\n=head1 DESCRIPTION\n\nEasy first time access to BioPerl via functions.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n#'\n# Let the code begin...\n\n\npackage Bio::Perl;\nuse vars qw(@EXPORT @EXPORT_OK $DBOKAY);\nuse strict;\nuse Carp;\n\nuse Bio::SeqIO;\nuse Bio::Seq;\nuse Bio::Root::Version '$VERSION';\nBEGIN {\n    eval {\n\trequire Bio::DB::EMBL;\n\trequire Bio::DB::GenBank;\n\trequire Bio::DB::SwissProt;\n\trequire Bio::DB::RefSeq;\n\trequire Bio::DB::GenPept;\n    };\n    if( $@ ) {\n\t$DBOKAY = 0;\n    } else {\n\t$DBOKAY = 1;\n    }\n}\n\nuse base qw(Exporter);\n\n@EXPORT = qw(read_sequence read_all_sequences write_sequence\n\t     new_sequence get_sequence translate translate_as_string\n\t     reverse_complement revcom revcom_as_string\n\t     reverse_complement_as_string blast_sequence write_blast);\n\n@EXPORT_OK = @EXPORT;\n\n\n=head2 read_sequence\n\n Title   : read_sequence\n Usage   : $seq = read_sequence('sequences.fa')\n           $seq = read_sequence($filename,'genbank');\n\n           # pipes are fine\n           $seq = read_sequence(\"my_fetching_program $id |\",'fasta');\n\n Function: Reads the top sequence from the file. If no format is given, it will\n           try to guess the format from the filename. If a format is given, it\n           forces that format. The filename can be any valid perl open() string\n           - in particular, you can put in pipes\n\n Returns : A Bio::Seq object. A quick synopsis:\n           $seq_object->display_id - name of the sequence\n           $seq_object->seq        - sequence as a string\n\n Args    : Two strings, first the filename - any Perl open() string is ok\n           Second string is the format, which is optional\n\nFor more information on Seq objects see L<Bio::Seq>.\n\n\nsub read_sequence{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_sequence($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my $seq = $seqio->next_seq();\n\n   return $seq;\n}\n\n\n=head2 read_all_sequences\n\n Title   : read_all_sequences\n Usage   : @seq_object_array = read_all_sequences($filename);\n           @seq_object_array = read_all_sequences($filename,'genbank');\n\n Function: Just as the function above, but reads all the sequences in the\n           file and loads them into an array.\n\n           For very large files, you will run out of memory. When this\n           happens, you've got to use the SeqIO system directly (this is\n           not so hard! Don't worry about it!).\n\n Returns : array of Bio::Seq objects\n\n Args    : two strings, first the filename (any open() string is ok)\n           second the format (which is optional)\n\nSee L<Bio::SeqIO> and L<Bio::Seq> for more information\n\n\nsub read_all_sequences{\n   my ($filename,$format) = @_;\n\n   if( !defined $filename ) {\n       confess \"read_all_sequences($filename) - usage incorrect\";\n   }\n\n   my $seqio;\n\n   if( defined $format ) {\n       $seqio = Bio::SeqIO->new( '-file' => $filename, '-format' => $format);\n   } else {\n       $seqio = Bio::SeqIO->new( '-file' => $filename);\n   }\n\n   my @seq_array;\n\n   while( my $seq = $seqio->next_seq() ) {\n       push(@seq_array,$seq);\n   }\n\n   return @seq_array;\n}\n\n\n=head2 write_sequence\n\n Title   : write_sequence\n Usage   : write_sequence(\">new_file.gb\",'genbank',$seq)\n           write_sequence(\">new_file.gb\",'genbank',@array_of_sequence_objects)\n\n Function: writes sequences in the specified format\n\n Returns : true\n\n Args    : filename as a string, must provide an open() output file\n           format as a string\n           one or more sequence objects\n\n\n\nsub write_sequence{\n   my ($filename,$format,@sequence_objects) = @_;\n\n   if( scalar(@sequence_objects) == 0 ) {\n       confess(\"write_sequence(filename,format,sequence_object)\");\n   }\n\n   my $error = 0;\n   my $seqname = \"sequence1\";\n\n   # catch users who haven't passed us a filename we can open\n   if( $filename !~ /^\\>/ && $filename !~ /^|/ ) {\n       $filename = \">\".$filename;\n   }\n\n   my $seqio = Bio::SeqIO->new('-file' => $filename, '-format' => $format);\n\n   foreach my $seq ( @sequence_objects ) {\n       my $seq_obj;\n\n       if( !ref $seq ) {\n\t   if( length $seq > 50 ) {\n\t       # odds are this is a sequence as a string, and someone has not figured out\n\t       # how to make objects. Warn him/her and then make a sequence object\n\t       # from this\n\t       if( $error == 0 ) {\n\t\t   carp(\"WARNING: You have put in a long string into write_sequence.\\nI suspect this means that this is the actual sequence\\nIn the future try the\\n  new_sequence method of this module to make a new sequence object.\\nDoing this for you here\\n\");\n\t\t   $error = 1;\n\t       }\n\n\t       $seq_obj = new_sequence($seq,$seqname);\n\t       $seqname++;\n\t   } else {\n\t       confess(\"You have a non object [$seq] passed to write_sequence. It maybe that you want to use new_sequence to make this string into a sequence object?\");\n\t   }\n       } else {\n\t   if( !$seq->isa(\"Bio::SeqI\") ) {\n\t       confess(\"object [$seq] is not a Bio::Seq object; can't write it out\");\n\t   }\n\t   $seq_obj = $seq;\n       }\n\n       # finally... we get to write out the sequence!\n       $seqio->write_seq($seq_obj);\n   }\n   1;\n}\n\n=head2 new_sequence\n\n Title   : new_sequence\n Usage   : $seq_obj = new_sequence(\"GATTACA\", \"kino-enzyme\");\n\n Function: Construct a sequency object from sequence string\n Returns : A Bio::Seq object\n\n Args    : sequence string\n           name string (optional, default \"no-name-for-sequence\")\n           accession - accession number (optional, no default)\n\n\nsub new_sequence{\n   my ($seq,$name,$accession) = @_;\n\n   if( !defined $seq ) {\n       confess(\"new_sequence(sequence_as_string) usage\");\n   }\n\n   $name ||= \"no-name-for-sequence\";\n\n   my $seq_object = Bio::Seq->new( -seq => $seq, -id => $name);\n\n   $accession && $seq_object->accession_number($accession);\n\n   return $seq_object;\n}\n\n=head2 blast_sequence\n\n Title   : blast_sequence\n Usage   : $blast_result = blast_sequence($seq)\n           $blast_result = blast_sequence('MFVEGGTFASEDDDSASAEDE');\n\n Function: If the computer has Internet accessibility, blasts\n           the sequence using the NCBI BLAST server against nrdb.\n\n           It chooses the flavour of BLAST on the basis of the sequence.\n\n           This function uses Bio::Tools::Run::RemoteBlast, which itself\n           use Bio::SearchIO - as soon as you want to know more, check out\n           these modules\n Returns : Bio::Search::Result::GenericResult.pm\n\n Args    : Either a string of protein letters or nucleotides, or a\n           Bio::Seq object\n\n\nsub blast_sequence {\n    my ($seq,$verbose) = shift;\n\n    if( !defined $verbose ) {\n\t$verbose = 1;\n    }\n\n    if( !ref $seq ) {\n\t$seq = Bio::Seq->new( -seq => $seq, -id => 'blast-sequence-temp-id');\n    } elsif ( !$seq->isa('Bio::PrimarySeqI') ) {\n\tcroak(\"[$seq] is an object, but not a Bio::Seq object, cannot be blasted\");\n    }\n\n    require Bio::Tools::Run::RemoteBlast;\n\n    my $prog = 'blastp';\n    my $e_val= '1e-10';\n\n    my @params = ( '-prog' => $prog,\n\t\t   '-expect' => $e_val,\n\t\t   '-readmethod' => 'SearchIO' );\n\n    my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n    my $r = $factory->submit_blast($seq);\n    if( $verbose ) {\n\tprint STDERR \"Submitted Blast for [\".$seq->id.\"] \";\n    }\n    sleep 5;\n\n    my $result;\n\n    LOOP :\n    while( my @rids = $factory->each_rid) {\n\tforeach my $rid ( @rids ) {\n\t    my $rc = $factory->retrieve_blast($rid);\n\t    if( !ref($rc) ) {\n\t\tif( $rc < 0 ) {\n\t\t    $factory->remove_rid($rid);\n\t\t}\n\t\tif( $verbose ) {\n\t\t    print STDERR \".\";\n\t\t}\n\t\tsleep 10;\n\t    } else {\n\t\t$result = $rc->next_result();\n\t\t$factory->remove_rid($rid);\n\t\tlast LOOP;\n\t    }\n\t}\n    }\n\n    if( $verbose ) {\n\tprint STDERR \"\\n\";\n    }\n    return $result;\n}\n\n=head2 write_blast\n\n Title   : write_blast\n Usage   : write_blast($filename,$blast_report);\n\n Function: Writes a BLAST result object (or more formally\n           a SearchIO result object) out to a filename\n           in BLAST-like format\n\n Returns : none\n\n Args    : filename as a string\n           Bio::SearchIO::Results object"},"children":[{"definition":"my","localvar":"my","containerName":"write_blast","kind":13,"name":"$filename","line":432},{"name":"$blast","kind":13,"containerName":"write_blast","line":432},{"kind":13,"containerName":"write_blast","name":"$filename","line":434},{"containerName":"write_blast","kind":13,"name":"$filename","line":434},{"line":435,"kind":13,"containerName":"write_blast","name":"$filename"},{"containerName":"write_blast","kind":13,"name":"$filename","line":435},{"definition":"my","containerName":"write_blast","localvar":"my","kind":13,"name":"$output","line":438},{"name":"new","kind":12,"containerName":"write_blast","line":438},{"line":438,"name":"$filename","kind":13,"containerName":"write_blast"},{"line":440,"kind":13,"containerName":"write_blast","name":"$output"},{"line":440,"name":"write_result","kind":12,"containerName":"write_blast"},{"name":"$blast","containerName":"write_blast","kind":13,"line":440}],"containerName":"main::","name":"write_blast","definition":"sub","detail":"($filename,$blast)"},{"name":"Bio","containerName":"SearchIO","kind":12,"line":438},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$genbank_db","line":466},{"name":"$genpept_db","containerName":null,"localvar":"my","kind":13,"line":467,"definition":"my"},{"name":"$embl_db","localvar":"my","kind":13,"containerName":null,"line":468,"definition":"my"},{"line":469,"localvar":"my","kind":13,"containerName":null,"name":"$swiss_db","definition":"my"},{"name":"$refseq_db","localvar":"my","kind":13,"containerName":null,"line":470,"definition":"my"},{"line":472,"range":{"end":{"character":9999,"line":526},"start":{"character":0,"line":472}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$db_type"},{"label":"$identifier"}],"label":"get_sequence($db_type,$identifier)"},"children":[{"line":473,"localvar":"my","containerName":"get_sequence","kind":13,"name":"$db_type","definition":"my"},{"line":473,"kind":13,"containerName":"get_sequence","name":"$identifier"},{"line":474,"kind":13,"containerName":"get_sequence","name":"$DBOKAY"},{"line":478,"name":"$db_type","containerName":"get_sequence","kind":13},{"line":478,"kind":13,"containerName":"get_sequence","name":"$db_type"},{"definition":"my","line":480,"name":"$db","localvar":"my","containerName":"get_sequence","kind":13},{"line":482,"kind":13,"containerName":"get_sequence","name":"$db_type"},{"line":483,"containerName":"get_sequence","kind":13,"name":"$genbank_db"},{"line":484,"kind":13,"containerName":"get_sequence","name":"$genbank_db"},{"name":"new","kind":12,"containerName":"get_sequence","line":484},{"containerName":"get_sequence","kind":13,"name":"$db","line":486},{"kind":13,"containerName":"get_sequence","name":"$genbank_db","line":486},{"line":488,"name":"$db_type","kind":13,"containerName":"get_sequence"},{"kind":13,"containerName":"get_sequence","name":"$genpept_db","line":489},{"line":490,"name":"$genpept_db","containerName":"get_sequence","kind":13},{"line":490,"name":"new","kind":12,"containerName":"get_sequence"},{"name":"$db","kind":13,"containerName":"get_sequence","line":492},{"line":492,"name":"$genpept_db","containerName":"get_sequence","kind":13},{"line":495,"containerName":"get_sequence","kind":13,"name":"$db_type"},{"containerName":"get_sequence","kind":13,"name":"$swiss_db","line":496},{"line":497,"name":"$swiss_db","kind":13,"containerName":"get_sequence"},{"name":"new","containerName":"get_sequence","kind":12,"line":497},{"containerName":"get_sequence","kind":13,"name":"$db","line":499},{"kind":13,"containerName":"get_sequence","name":"$swiss_db","line":499},{"line":502,"name":"$db_type","containerName":"get_sequence","kind":13},{"line":503,"name":"$embl_db","kind":13,"containerName":"get_sequence"},{"line":504,"kind":13,"containerName":"get_sequence","name":"$embl_db"},{"name":"new","containerName":"get_sequence","kind":12,"line":504},{"line":506,"name":"$db","kind":13,"containerName":"get_sequence"},{"name":"$embl_db","kind":13,"containerName":"get_sequence","line":506},{"line":509,"name":"$db_type","containerName":"get_sequence","kind":13},{"containerName":"get_sequence","kind":13,"name":"$db_type","line":509},{"line":510,"kind":13,"containerName":"get_sequence","name":"$identifier"},{"line":511,"name":"$refseq_db","kind":13,"containerName":"get_sequence"},{"containerName":"get_sequence","kind":13,"name":"$refseq_db","line":512},{"name":"new","containerName":"get_sequence","kind":12,"line":512},{"line":514,"kind":13,"containerName":"get_sequence","name":"$db"},{"name":"$refseq_db","containerName":"get_sequence","kind":13,"line":514},{"line":517,"localvar":"my","kind":13,"containerName":"get_sequence","name":"$seq","definition":"my"},{"name":"$identifier","containerName":"get_sequence","kind":13,"line":519},{"containerName":"get_sequence","kind":13,"name":"$seq","line":520},{"name":"$db","containerName":"get_sequence","kind":13,"line":520},{"name":"get_Seq_by_acc","kind":12,"containerName":"get_sequence","line":520},{"line":520,"kind":13,"containerName":"get_sequence","name":"$identifier"},{"kind":13,"containerName":"get_sequence","name":"$seq","line":522},{"kind":13,"containerName":"get_sequence","name":"$db","line":522},{"line":522,"name":"get_Seq_by_id","containerName":"get_sequence","kind":12},{"line":522,"name":"$identifier","kind":13,"containerName":"get_sequence"},{"line":525,"kind":13,"containerName":"get_sequence","name":"$seq"}],"containerName":"main::","name":"get_sequence","definition":"sub","detail":"($db_type,$identifier)"},{"kind":12,"name":"confess","line":475},{"line":484,"containerName":"DB::GenBank","kind":12,"name":"Bio"},{"line":490,"kind":12,"containerName":"DB::GenPept","name":"Bio"},{"line":497,"name":"Bio","kind":12,"containerName":"DB::SwissProt"},{"line":504,"name":"Bio","containerName":"DB::EMBL","kind":12},{"line":512,"name":"Bio","kind":12,"containerName":"DB::RefSeq"},{"definition":"sub","children":[{"line":544,"name":"$scalar","localvar":"my","kind":13,"containerName":"translate","definition":"my"},{"definition":"my","name":"$obj","kind":13,"localvar":"my","containerName":"translate","line":546},{"name":"$scalar","containerName":"translate","kind":13,"line":548},{"name":"$scalar","containerName":"translate","kind":13,"line":549},{"line":549,"containerName":"translate","kind":12,"name":"isa"},{"kind":13,"containerName":"translate","name":"$obj","line":552},{"name":"$scalar","kind":13,"containerName":"translate","line":552},{"name":"$n","containerName":"translate","localvar":"my","kind":13,"line":559,"definition":"my"},{"line":559,"name":"$scalar","containerName":"translate","kind":13},{"containerName":"translate","kind":13,"name":"$n","line":561},{"line":561,"name":"$scalar","kind":13,"containerName":"translate"},{"line":565,"containerName":"translate","kind":13,"name":"$obj"},{"line":565,"containerName":"translate","kind":12,"name":"new"},{"line":565,"name":"$scalar","kind":13,"containerName":"translate"},{"containerName":"translate","kind":13,"name":"$obj","line":568},{"line":568,"name":"translate","kind":12,"containerName":"translate"}],"containerName":"main::","name":"translate","line":543,"kind":12,"range":{"end":{"line":569,"character":9999},"start":{"line":543,"character":0}}},{"line":550,"kind":12,"name":"confess"},{"name":"confess","kind":12,"line":562},{"line":565,"name":"Bio","kind":12,"containerName":"PrimarySeq"},{"containerName":"main::","name":"translate_as_string","children":[{"line":587,"name":"$scalar","localvar":"my","kind":13,"containerName":"translate_as_string","definition":"my"},{"line":589,"localvar":"my","containerName":"translate_as_string","kind":13,"name":"$obj","definition":"my"},{"kind":13,"containerName":"translate_as_string","name":"$scalar","line":589},{"line":591,"containerName":"translate_as_string","kind":13,"name":"$obj"},{"name":"seq","containerName":"translate_as_string","kind":12,"line":591}],"definition":"sub","kind":12,"range":{"end":{"character":9999,"line":592},"start":{"line":586,"character":0}},"line":586},{"line":589,"kind":12,"containerName":"Perl::translate","name":"Bio"},{"definition":"sub","children":[{"definition":"my","name":"$scalar","containerName":"reverse_complement","localvar":"my","kind":13,"line":611},{"definition":"my","line":613,"name":"$obj","localvar":"my","kind":13,"containerName":"reverse_complement"},{"line":615,"name":"$scalar","containerName":"reverse_complement","kind":13},{"line":616,"name":"$scalar","kind":13,"containerName":"reverse_complement"},{"line":616,"name":"isa","kind":12,"containerName":"reverse_complement"},{"line":619,"containerName":"reverse_complement","kind":13,"name":"$obj"},{"name":"$scalar","kind":13,"containerName":"reverse_complement","line":619},{"definition":"my","line":626,"name":"$n","containerName":"reverse_complement","localvar":"my","kind":13},{"line":626,"name":"$scalar","containerName":"reverse_complement","kind":13},{"line":628,"name":"$n","kind":13,"containerName":"reverse_complement"},{"line":628,"containerName":"reverse_complement","kind":13,"name":"$scalar"},{"line":632,"name":"$obj","kind":13,"containerName":"reverse_complement"},{"name":"new","containerName":"reverse_complement","kind":12,"line":632},{"containerName":"reverse_complement","kind":13,"name":"$scalar","line":632},{"name":"$obj","containerName":"reverse_complement","kind":13,"line":635},{"kind":12,"containerName":"reverse_complement","name":"revcom","line":635}],"name":"reverse_complement","containerName":"main::","line":610,"kind":12,"range":{"start":{"line":610,"character":0},"end":{"line":636,"character":9999}}},{"line":617,"kind":12,"name":"confess"},{"line":629,"name":"confess","kind":12},{"containerName":"PrimarySeq","kind":12,"name":"Bio","line":632},{"definition":"sub","children":[],"name":"revcom","containerName":"main::","line":655,"kind":12,"range":{"start":{"character":0,"line":655},"end":{"line":657,"character":9999}}},{"name":"Bio","containerName":"Perl::reverse_complement","kind":12,"line":656},{"line":674,"range":{"start":{"character":0,"line":674},"end":{"character":9999,"line":680}},"kind":12,"children":[{"line":675,"containerName":"reverse_complement_as_string","localvar":"my","kind":13,"name":"$scalar","definition":"my"},{"localvar":"my","kind":13,"containerName":"reverse_complement_as_string","name":"$obj","line":677,"definition":"my"},{"name":"$scalar","containerName":"reverse_complement_as_string","kind":13,"line":677},{"kind":13,"containerName":"reverse_complement_as_string","name":"$obj","line":679},{"line":679,"name":"seq","containerName":"reverse_complement_as_string","kind":12}],"name":"reverse_complement_as_string","containerName":"main::","definition":"sub"},{"kind":12,"containerName":"Perl::reverse_complement","name":"Bio","line":677},{"line":697,"range":{"end":{"line":703,"character":9999},"start":{"line":697,"character":0}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$scalar","localvar":"my","containerName":"revcom_as_string","kind":13,"line":698},{"line":700,"localvar":"my","kind":13,"containerName":"revcom_as_string","name":"$obj","definition":"my"},{"name":"$scalar","containerName":"revcom_as_string","kind":13,"line":700},{"kind":13,"containerName":"revcom_as_string","name":"$obj","line":702},{"line":702,"containerName":"revcom_as_string","kind":12,"name":"seq"}],"name":"revcom_as_string","containerName":"main::"},{"name":"Bio","containerName":"Perl::reverse_complement","kind":12,"line":700}]}