{"version":5,"vars":[{"line":109,"name":"base","kind":2,"containerName":""},{"range":{"start":{"character":0,"line":132},"end":{"line":156,"character":9999}},"kind":12,"line":132,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment","label":"new($class,@args)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":133,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":133},{"line":135,"name":"$self","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":135},{"kind":13,"containerName":"new","name":"@args","line":135},{"definition":"my","localvar":"my","kind":13,"containerName":"new","name":"$con","line":137},{"line":137,"name":"$desc","kind":13,"containerName":"new"},{"line":137,"name":"$start","containerName":"new","kind":13},{"line":137,"name":"$end","kind":13,"containerName":"new"},{"name":"$unit","containerName":"new","kind":13,"line":137},{"name":"$comment","kind":13,"containerName":"new","line":137},{"name":"$self","kind":13,"containerName":"new","line":138},{"name":"_rearrange","containerName":"new","kind":12,"line":138},{"name":"@args","kind":13,"containerName":"new","line":143},{"containerName":"new","kind":13,"name":"$self","line":145},{"containerName":"new","kind":12,"name":"init","line":145},{"name":"$con","containerName":"new","kind":13,"line":147},{"kind":13,"containerName":"new","name":"$self","line":147},{"line":147,"name":"context","containerName":"new","kind":12},{"line":147,"containerName":"new","kind":13,"name":"$con"},{"line":148,"containerName":"new","kind":13,"name":"$desc"},{"containerName":"new","kind":13,"name":"$self","line":148},{"line":148,"kind":12,"containerName":"new","name":"description"},{"kind":13,"containerName":"new","name":"$desc","line":148},{"line":149,"name":"$start","kind":13,"containerName":"new"},{"line":149,"name":"$self","kind":13,"containerName":"new"},{"name":"start","kind":12,"containerName":"new","line":149},{"line":149,"containerName":"new","kind":13,"name":"$start"},{"name":"$end","kind":13,"containerName":"new","line":150},{"containerName":"new","kind":13,"name":"$self","line":150},{"line":150,"containerName":"new","kind":12,"name":"end"},{"kind":13,"containerName":"new","name":"$end","line":150},{"line":151,"kind":13,"containerName":"new","name":"$unit"},{"kind":13,"containerName":"new","name":"$self","line":151},{"line":151,"name":"unit","kind":12,"containerName":"new"},{"name":"$unit","containerName":"new","kind":13,"line":151},{"name":"$comment","kind":13,"containerName":"new","line":152},{"line":152,"kind":13,"containerName":"new","name":"$self"},{"line":152,"kind":12,"containerName":"new","name":"comment"},{"line":152,"name":"$comment","containerName":"new","kind":13},{"line":154,"containerName":"new","kind":13,"name":"$self"}],"detail":"($class,@args)","definition":"sub"},{"name":"SUPER","kind":12,"containerName":"new","line":135},{"children":[{"line":172,"localvar":"my","kind":13,"containerName":"init","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"init","line":174},{"name":"context","kind":12,"containerName":"init","line":174},{"name":"$self","containerName":"init","kind":13,"line":175},{"line":175,"containerName":"init","kind":12,"name":"description"},{"line":176,"name":"$self","containerName":"init","kind":13},{"kind":12,"containerName":"init","name":"start","line":176},{"line":177,"kind":13,"containerName":"init","name":"$self"},{"containerName":"init","kind":12,"name":"end","line":177},{"name":"$self","containerName":"init","kind":13,"line":178},{"name":"unit","containerName":"init","kind":12,"line":178},{"line":179,"name":"$self","kind":13,"containerName":"init"},{"line":179,"name":"comment","containerName":"init","kind":12}],"containerName":"main::","name":"init","definition":"sub","detail":"($self)","line":171,"range":{"end":{"line":181,"character":9999},"start":{"character":0,"line":171}},"kind":12,"signature":{"label":"init($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :"}},{"kind":12,"range":{"start":{"line":198,"character":0},"end":{"character":9999,"line":207}},"line":198,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).","label":"context($self,$value)"},"containerName":"main::","name":"context","children":[{"definition":"my","line":199,"name":"$self","containerName":"context","localvar":"my","kind":13},{"name":"$value","containerName":"context","kind":13,"line":199},{"line":201,"kind":13,"containerName":"context","name":"$value"},{"containerName":"context","kind":13,"name":"$self","line":202},{"line":202,"name":"$value","kind":13,"containerName":"context"},{"name":"$self","containerName":"context","kind":13,"line":205}],"detail":"($self,$value)","definition":"sub"},{"definition":"sub","detail":"($self,$value)","children":[{"line":225,"containerName":"description","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$value","kind":13,"containerName":"description","line":225},{"line":227,"name":"$value","kind":13,"containerName":"description"},{"line":228,"name":"$self","kind":13,"containerName":"description"},{"name":"$value","containerName":"description","kind":13,"line":228},{"name":"$self","containerName":"description","kind":13,"line":231}],"containerName":"main::","name":"description","signature":{"label":"description($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional)."},"line":224,"range":{"end":{"line":233,"character":9999},"start":{"line":224,"character":0}},"kind":12},{"definition":"sub","detail":"($self,$value)","children":[{"line":251,"localvar":"my","kind":13,"containerName":"start","name":"$self","definition":"my"},{"name":"$value","containerName":"start","kind":13,"line":251},{"name":"$value","kind":13,"containerName":"start","line":253},{"containerName":"start","kind":13,"name":"$self","line":254},{"containerName":"start","kind":13,"name":"$value","line":254},{"containerName":"start","kind":13,"name":"$self","line":257}],"name":"start","containerName":"main::","signature":{"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"start($self,$value)"},"line":250,"kind":12,"range":{"end":{"character":9999,"line":259},"start":{"line":250,"character":0}}},{"containerName":"main::","name":"end","children":[{"definition":"my","localvar":"my","containerName":"end","kind":13,"name":"$self","line":277},{"kind":13,"containerName":"end","name":"$value","line":277},{"line":279,"containerName":"end","kind":13,"name":"$value"},{"name":"$self","containerName":"end","kind":13,"line":280},{"line":280,"name":"$value","kind":13,"containerName":"end"},{"name":"$self","kind":13,"containerName":"end","line":283}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"line":276,"character":0},"end":{"line":285,"character":9999}},"line":276,"signature":{"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).\n\n\nsub start {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_start\" } = $value;\n    }\n   \n    return $self->{ \"_start\" };\n    \n} #  start\n\n\n\n\n=head2 end \n\n Title   : end \n Usage   : $measure->end( 459 );\n           or \n           print $measure->end(); \n Function: Set/get for the end value of this Measure.\n Returns : The end value.\n Args    : The end value (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"end($self,$value)"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).\n\n\nsub start {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_start\" } = $value;\n    }\n   \n    return $self->{ \"_start\" };\n    \n} #  start\n\n\n\n\n=head2 end \n\n Title   : end \n Usage   : $measure->end( 459 );\n           or \n           print $measure->end(); \n Function: Set/get for the end value of this Measure.\n Returns : The end value.\n Args    : The end value (optional).\n\n\nsub end {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_end\" } = $value;\n    }\n   \n    return $self->{ \"_end\" };\n    \n} # end\n\n\n\n\n=head2 unit\n\n Title   : unit\n Usage   : $measure->unit( \"mM\" );\n           or \n           print $measure->unit(); \n Function: Set/get for the unit of this Measure.\n Returns : The unit.\n Args    : The unit (optional).","label":"unit($self,$value)"},"line":302,"kind":12,"range":{"end":{"line":311,"character":9999},"start":{"line":302,"character":0}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":303,"name":"$self","localvar":"my","containerName":"unit","kind":13},{"line":303,"kind":13,"containerName":"unit","name":"$value"},{"name":"$value","kind":13,"containerName":"unit","line":305},{"line":306,"containerName":"unit","kind":13,"name":"$self"},{"containerName":"unit","kind":13,"name":"$value","line":306},{"kind":13,"containerName":"unit","name":"$self","line":309}],"containerName":"main::","name":"unit"},{"kind":12,"range":{"start":{"line":328,"character":0},"end":{"character":9999,"line":337}},"line":328,"signature":{"label":"comment($self,$value)","documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).\n\n\nsub start {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_start\" } = $value;\n    }\n   \n    return $self->{ \"_start\" };\n    \n} #  start\n\n\n\n\n=head2 end \n\n Title   : end \n Usage   : $measure->end( 459 );\n           or \n           print $measure->end(); \n Function: Set/get for the end value of this Measure.\n Returns : The end value.\n Args    : The end value (optional).\n\n\nsub end {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_end\" } = $value;\n    }\n   \n    return $self->{ \"_end\" };\n    \n} # end\n\n\n\n\n=head2 unit\n\n Title   : unit\n Usage   : $measure->unit( \"mM\" );\n           or \n           print $measure->unit(); \n Function: Set/get for the unit of this Measure.\n Returns : The unit.\n Args    : The unit (optional).\n\n\nsub unit {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_unit\" } = $value;\n    }\n   \n    return $self->{ \"_unit\" };\n    \n} # unit\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $measure->comment( \"see also Miller et al\" );\n           or \n           print $measure->comment();\n Function: Set/get for an arbitrary comment about this Measure.\n Returns : A comment.\n Args    : A comment (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"name":"comment","containerName":"main::","children":[{"name":"$self","containerName":"comment","localvar":"my","kind":13,"line":329,"definition":"my"},{"line":329,"name":"$value","kind":13,"containerName":"comment"},{"line":331,"kind":13,"containerName":"comment","name":"$value"},{"line":332,"name":"$self","containerName":"comment","kind":13},{"name":"$value","kind":13,"containerName":"comment","line":332},{"line":335,"containerName":"comment","kind":13,"name":"$self"}],"detail":"($self,$value)","definition":"sub"},{"children":[{"line":353,"name":"$self","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"name":"$s","kind":13,"localvar":"my","containerName":"to_string","line":355,"definition":"my"},{"kind":13,"containerName":"to_string","name":"$s","line":357},{"line":358,"name":"$s","containerName":"to_string","kind":13},{"line":358,"containerName":"to_string","kind":13,"name":"$self"},{"kind":12,"containerName":"to_string","name":"context","line":358},{"name":"$s","containerName":"to_string","kind":13,"line":359},{"kind":13,"containerName":"to_string","name":"$s","line":360},{"name":"$self","kind":13,"containerName":"to_string","line":360},{"line":360,"name":"description","kind":12,"containerName":"to_string"},{"line":361,"name":"$s","kind":13,"containerName":"to_string"},{"line":362,"containerName":"to_string","kind":13,"name":"$s"},{"name":"$self","containerName":"to_string","kind":13,"line":362},{"kind":12,"containerName":"to_string","name":"start","line":362},{"line":363,"name":"$s","kind":13,"containerName":"to_string"},{"line":364,"name":"$s","containerName":"to_string","kind":13},{"line":364,"containerName":"to_string","kind":13,"name":"$self"},{"containerName":"to_string","kind":12,"name":"end","line":364},{"line":365,"name":"$s","containerName":"to_string","kind":13},{"name":"$s","kind":13,"containerName":"to_string","line":366},{"line":366,"name":"$self","kind":13,"containerName":"to_string"},{"name":"unit","containerName":"to_string","kind":12,"line":366},{"line":367,"kind":13,"containerName":"to_string","name":"$s"},{"line":368,"name":"$s","containerName":"to_string","kind":13},{"name":"$self","containerName":"to_string","kind":13,"line":368},{"line":368,"containerName":"to_string","kind":12,"name":"comment"},{"containerName":"to_string","kind":13,"name":"$s","line":370}],"name":"to_string","containerName":"main::","definition":"sub","detail":"($self)","line":352,"kind":12,"range":{"start":{"character":0,"line":352},"end":{"character":9999,"line":372}},"signature":{"label":"to_string($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Measure.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::Measure\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::Measure - Representation of context/value(-range)/unit triplets\n\n=head1 SYNOPSIS\n\n  use Bio::Phenotype::Measure;\n\n  my $measure = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                              -description => \"reduced length in 4(Tas1r3)\",\n                                              -start       => 0,\n                                              -end         => 15,\n                                              -unit        => \"mm\",\n                                              -comment     => \"see also Miller et al\" );\n\n  print $measure->context();\n  print $measure->description();\n  print $measure->start();\n  print $measure->end();\n  print $measure->unit();\n  print $measure->comment();\n\n  print $measure->to_string();\n\n=head1 DESCRIPTION\n\nMeasure is for biochemically defined phenotypes or any other types of measures.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods.\n\n\n\n# Let the code begin...\n\npackage Bio::Phenotype::Measure;\nuse strict;\n\nuse base qw(Bio::Root::Root);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $me = Bio::Phenotype::Measure->new( -context     => \"length\",\n                                                  -description => \"reduced length in 4(Tas1r3)\",\n                                                  -start       => 0,\n                                                  -end         => 15,\n                                                  -unit        => \"mm\",\n                                                  -comment     => \"see Miller also et al\" );                      \n Function: Creates a new Measure object.\n Returns : A new Measure object.\n Args    : -context     => the context\n           -description => a description\n           -start       => the start value\n           -end         => the end value\n           -unit        => the unit\n           -comment     => a comment\n\n\nsub new {\n    my( $class, @args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n\n    my ( $con, $desc, $start, $end, $unit, $comment )\n    = $self->_rearrange( [ qw( CONTEXT\n                               DESCRIPTION\n                               START\n                               END\n                               UNIT\n                               COMMENT ) ], @args );\n\n    $self->init(); \n \n    $con     && $self->context( $con );\n    $desc    && $self->description( $desc );\n    $start   && $self->start( $start );\n    $end     && $self->end( $end );\n    $unit    && $self->unit( $unit );\n    $comment && $self->comment( $comment );\n                           \n    return $self;\n    \n} # new\n\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $measure->init();   \n Function: Initializes this Measure to all \"\".\n Returns : \n Args    :\n\n\nsub init {\n    my( $self ) = @_;\n\n    $self->context( \"\" );\n    $self->description( \"\" );\n    $self->start( \"\" );\n    $self->end( \"\" );\n    $self->unit( \"\" );\n    $self->comment( \"\" );\n  \n} # init\n\n\n\n\n=head2 context\n\n Title   : context\n Usage   : $measure->context( \"Ca-conc\" );\n           or \n           print $measure->context(); \n Function: Set/get for the context of this Measure.\n Returns : The context.\n Args    : The context (optional).\n\n\nsub context {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_context\" } = $value;\n    }\n   \n    return $self->{ \"_context\" };\n    \n} # context\n\n\n\n\n=head2 description\n\n Title   : description\n Usage   : $measure->description( \"reduced in 4(Tas1r3)\" );\n           or \n           print $measure->description(); \n Function: Set/get for the description of this Measure.\n Returns : A description.\n Args    : A description (optional).\n\n\nsub description {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_description\" } = $value;\n    }\n   \n    return $self->{ \"_description\" };\n    \n} # description\n\n\n\n\n=head2 start \n\n Title   : start\n Usage   : $measure->start( 330 );\n           or \n           print $measure->start(); \n Function: Set/get for the start value of this Measure.\n Returns : The start value.\n Args    : The start value (optional).\n\n\nsub start {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_start\" } = $value;\n    }\n   \n    return $self->{ \"_start\" };\n    \n} #  start\n\n\n\n\n=head2 end \n\n Title   : end \n Usage   : $measure->end( 459 );\n           or \n           print $measure->end(); \n Function: Set/get for the end value of this Measure.\n Returns : The end value.\n Args    : The end value (optional).\n\n\nsub end {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_end\" } = $value;\n    }\n   \n    return $self->{ \"_end\" };\n    \n} # end\n\n\n\n\n=head2 unit\n\n Title   : unit\n Usage   : $measure->unit( \"mM\" );\n           or \n           print $measure->unit(); \n Function: Set/get for the unit of this Measure.\n Returns : The unit.\n Args    : The unit (optional).\n\n\nsub unit {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_unit\" } = $value;\n    }\n   \n    return $self->{ \"_unit\" };\n    \n} # unit\n\n\n\n\n=head2 comment\n\n Title   : comment\n Usage   : $measure->comment( \"see also Miller et al\" );\n           or \n           print $measure->comment();\n Function: Set/get for an arbitrary comment about this Measure.\n Returns : A comment.\n Args    : A comment (optional).\n\n\nsub comment {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_comment\" } = $value;\n    }\n   \n    return $self->{ \"_comment\" };\n    \n} # comment\n\n\n\n\n=head2 to_string\n\n Title   : to_string()\n Usage   : print $measure->to_string();\n Function: To string method for Measure objects.\n Returns : A string representations of this Measure.\n Args    :"}}]}