{"vars":[{"definition":1,"line":102,"name":"TRUE","containerName":"main::","kind":14},{"kind":12,"containerName":"Bio::Phenotype::OMIM::MiniMIMentry::Bio::Phenotype::OMIM::OMIMentryAllelicVariant","name":"strict","line":102},{"definition":1,"line":103,"containerName":"main::","kind":14,"name":"FALSE"},{"definition":1,"containerName":"main::","kind":14,"name":"DEFAULT_MIM_NUMER","line":104},{"name":"base","kind":2,"containerName":"","line":106},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"new","name":"$class","line":140,"definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":140},{"line":142,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":142,"name":"$class","kind":13,"containerName":"new"},{"line":142,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":144,"localvar":"my","kind":13,"containerName":"new","name":"$mim_number"},{"name":"$title","containerName":"new","kind":13,"line":145},{"name":"$alternative_titles_and_symbols","containerName":"new","kind":13,"line":146},{"line":147,"name":"$more_than_two_genes","kind":13,"containerName":"new"},{"name":"$is_separate","containerName":"new","kind":13,"line":148},{"line":149,"name":"$description","kind":13,"containerName":"new"},{"line":150,"name":"$mapping_method","kind":13,"containerName":"new"},{"line":151,"name":"$gene_status","kind":13,"containerName":"new"},{"name":"$comment","containerName":"new","kind":13,"line":152},{"containerName":"new","kind":13,"name":"$species","line":153},{"containerName":"new","kind":13,"name":"$created","line":154},{"line":155,"name":"$edited","kind":13,"containerName":"new"},{"line":156,"kind":13,"containerName":"new","name":"$contributors"},{"name":"$additional_references","kind":13,"containerName":"new","line":157},{"containerName":"new","kind":13,"name":"$clinical_symptoms","line":158},{"line":159,"containerName":"new","kind":13,"name":"$miniMIM"},{"line":160,"name":"$self","kind":13,"containerName":"new"},{"line":160,"name":"_rearrange","kind":12,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":175},{"kind":13,"containerName":"new","name":"$self","line":177},{"line":177,"containerName":"new","kind":12,"name":"init"},{"line":179,"name":"$mim_number","containerName":"new","kind":13},{"line":179,"containerName":"new","kind":13,"name":"$self"},{"line":179,"name":"MIM_number","containerName":"new","kind":12},{"line":179,"name":"$mim_number","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$title","line":180},{"line":180,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"title","line":180},{"line":180,"containerName":"new","kind":13,"name":"$title"},{"name":"$alternative_titles_and_symbols","kind":13,"containerName":"new","line":181},{"name":"$self","kind":13,"containerName":"new","line":181},{"kind":12,"containerName":"new","name":"alternative_titles_and_symbols","line":181},{"line":181,"kind":13,"containerName":"new","name":"$alternative_titles_and_symbols"},{"line":182,"name":"$more_than_two_genes","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":182},{"line":182,"name":"more_than_two_genes","containerName":"new","kind":12},{"line":182,"name":"$more_than_two_genes","containerName":"new","kind":13},{"line":183,"kind":13,"containerName":"new","name":"$is_separate"},{"line":183,"containerName":"new","kind":13,"name":"$self"},{"line":183,"kind":12,"containerName":"new","name":"is_separate"},{"kind":13,"containerName":"new","name":"$is_separate","line":183},{"name":"$description","kind":13,"containerName":"new","line":184},{"containerName":"new","kind":13,"name":"$self","line":184},{"line":184,"name":"description","containerName":"new","kind":12},{"line":184,"kind":13,"containerName":"new","name":"$description"},{"line":185,"kind":13,"containerName":"new","name":"$mapping_method"},{"containerName":"new","kind":13,"name":"$self","line":185},{"line":185,"name":"mapping_method","kind":12,"containerName":"new"},{"line":185,"containerName":"new","kind":13,"name":"$mapping_method"},{"line":186,"name":"$gene_status","containerName":"new","kind":13},{"line":186,"name":"$self","kind":13,"containerName":"new"},{"line":186,"containerName":"new","kind":12,"name":"gene_status"},{"name":"$gene_status","containerName":"new","kind":13,"line":186},{"line":187,"containerName":"new","kind":13,"name":"$comment"},{"kind":13,"containerName":"new","name":"$self","line":187},{"line":187,"name":"comment","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"$comment","line":187},{"kind":13,"containerName":"new","name":"$species","line":188},{"line":188,"kind":13,"containerName":"new","name":"$self"},{"name":"species","kind":12,"containerName":"new","line":188},{"kind":13,"containerName":"new","name":"$species","line":188},{"line":189,"name":"$created","kind":13,"containerName":"new"},{"line":189,"containerName":"new","kind":13,"name":"$self"},{"line":189,"name":"created","kind":12,"containerName":"new"},{"line":189,"containerName":"new","kind":13,"name":"$created"},{"line":190,"containerName":"new","kind":13,"name":"$edited"},{"name":"$self","containerName":"new","kind":13,"line":190},{"line":190,"kind":12,"containerName":"new","name":"edited"},{"line":190,"name":"$edited","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$contributors","line":191},{"line":191,"kind":13,"containerName":"new","name":"$self"},{"name":"contributors","kind":12,"containerName":"new","line":191},{"line":191,"name":"$contributors","containerName":"new","kind":13},{"line":192,"containerName":"new","kind":13,"name":"$additional_references"},{"line":192,"name":"$self","containerName":"new","kind":13},{"name":"additional_references","kind":12,"containerName":"new","line":192},{"line":192,"name":"$additional_references","kind":13,"containerName":"new"},{"line":193,"name":"$clinical_symptoms","kind":13,"containerName":"new"},{"line":193,"name":"$self","containerName":"new","kind":13},{"name":"clinical_symptoms_raw","containerName":"new","kind":12,"line":193},{"name":"$clinical_symptoms","kind":13,"containerName":"new","line":193},{"line":194,"name":"$miniMIM","kind":13,"containerName":"new"},{"line":194,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"miniMIM","line":194},{"line":194,"containerName":"new","kind":13,"name":"$miniMIM"},{"line":196,"name":"$self","containerName":"new","kind":13}],"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry","parameters":[{"label":"$class"},{"label":"@args"}]},"kind":12,"range":{"end":{"character":9999,"line":198},"start":{"line":138,"character":0}},"line":138},{"kind":12,"containerName":"new","name":"SUPER","line":142},{"detail":"($self)","definition":"sub","containerName":"main::","name":"init","children":[{"definition":"my","name":"$self","containerName":"init","localvar":"my","kind":13,"line":214},{"line":216,"name":"$self","kind":13,"containerName":"init"},{"line":216,"name":"MIM_number","kind":12,"containerName":"init"},{"line":217,"kind":13,"containerName":"init","name":"$self"},{"line":217,"containerName":"init","kind":12,"name":"title"},{"name":"$self","kind":13,"containerName":"init","line":218},{"line":218,"containerName":"init","kind":12,"name":"alternative_titles_and_symbols"},{"line":219,"name":"$self","containerName":"init","kind":13},{"line":219,"kind":12,"containerName":"init","name":"more_than_two_genes"},{"name":"$self","containerName":"init","kind":13,"line":220},{"kind":12,"containerName":"init","name":"is_separate","line":220},{"name":"$self","kind":13,"containerName":"init","line":221},{"line":221,"name":"description","kind":12,"containerName":"init"},{"containerName":"init","kind":13,"name":"$self","line":222},{"name":"mapping_method","containerName":"init","kind":12,"line":222},{"name":"$self","kind":13,"containerName":"init","line":223},{"kind":12,"containerName":"init","name":"gene_status","line":223},{"name":"$self","containerName":"init","kind":13,"line":224},{"kind":12,"containerName":"init","name":"comment","line":224},{"line":225,"localvar":"my","containerName":"init","kind":13,"name":"$species","definition":"my"},{"line":225,"containerName":"init","kind":12,"name":"new"},{"containerName":"init","kind":13,"name":"$species","line":226},{"line":226,"name":"classification","containerName":"init","kind":12},{"line":227,"name":"$self","kind":13,"containerName":"init"},{"name":"species","kind":12,"containerName":"init","line":227},{"line":227,"name":"$species","kind":13,"containerName":"init"},{"line":228,"containerName":"init","kind":13,"name":"$self"},{"line":228,"name":"created","containerName":"init","kind":12},{"line":229,"kind":13,"containerName":"init","name":"$self"},{"line":229,"kind":12,"containerName":"init","name":"edited"},{"line":230,"containerName":"init","kind":13,"name":"$self"},{"name":"contributors","containerName":"init","kind":12,"line":230},{"containerName":"init","kind":13,"name":"$self","line":231},{"kind":12,"containerName":"init","name":"additional_references","line":231},{"line":232,"name":"$self","kind":13,"containerName":"init"},{"line":232,"kind":12,"containerName":"init","name":"clinical_symptoms"},{"name":"$self","kind":13,"containerName":"init","line":233},{"line":233,"name":"remove_Correlates","containerName":"init","kind":12},{"name":"$self","containerName":"init","kind":13,"line":234},{"name":"remove_References","kind":12,"containerName":"init","line":234},{"name":"$self","containerName":"init","kind":13,"line":235},{"name":"remove_AllelicVariants","kind":12,"containerName":"init","line":235},{"line":236,"kind":13,"containerName":"init","name":"$self"},{"kind":12,"containerName":"init","name":"remove_CytoPositions","line":236},{"name":"$self","containerName":"init","kind":13,"line":237},{"name":"remove_gene_symbols","containerName":"init","kind":12,"line":237},{"line":238,"containerName":"init","kind":13,"name":"$self"},{"containerName":"init","kind":12,"name":"remove_Genotypes","line":238},{"name":"$self","kind":13,"containerName":"init","line":239},{"line":239,"name":"remove_DBLinks","containerName":"init","kind":12},{"containerName":"init","kind":13,"name":"$self","line":240},{"line":240,"containerName":"init","kind":12,"name":"remove_keywords"},{"kind":13,"containerName":"init","name":"$self","line":241},{"line":241,"name":"remove_Variants","kind":12,"containerName":"init"},{"name":"$self","kind":13,"containerName":"init","line":242},{"containerName":"init","kind":12,"name":"remove_Measures","line":242},{"line":243,"name":"$self","containerName":"init","kind":13},{"name":"miniMIM","kind":12,"containerName":"init","line":243},{"line":243,"containerName":"init","kind":12,"name":"new"}],"signature":{"label":"init($self)","documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"kind":12,"range":{"start":{"line":212,"character":0},"end":{"character":9999,"line":245}},"line":212},{"line":216,"name":"DEFAULT_MIM_NUMER","kind":12},{"line":219,"name":"FALSE","kind":12},{"kind":12,"name":"FALSE","line":220},{"line":225,"name":"Bio","kind":12,"containerName":"Species"},{"name":"Bio","kind":12,"containerName":"Phenotype::OMIM::MiniMIMentry","line":243},{"definition":"sub","detail":"($self)","children":[{"line":251,"kind":13,"localvar":"my","containerName":"to_string","name":"$self","definition":"my"},{"definition":"my","name":"$s","localvar":"my","containerName":"to_string","kind":13,"line":253},{"line":255,"name":"$s","kind":13,"containerName":"to_string"},{"containerName":"to_string","kind":13,"name":"$s","line":256},{"line":256,"name":"$self","kind":13,"containerName":"to_string"},{"name":"MIM_number","kind":12,"containerName":"to_string","line":256},{"name":"$s","kind":13,"containerName":"to_string","line":257},{"name":"$s","containerName":"to_string","kind":13,"line":258},{"line":258,"name":"$self","containerName":"to_string","kind":13},{"line":258,"name":"title","kind":12,"containerName":"to_string"},{"line":259,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$s","containerName":"to_string","kind":13,"line":260},{"name":"$self","kind":13,"containerName":"to_string","line":260},{"line":260,"containerName":"to_string","kind":12,"name":"alternative_titles_and_symbols"},{"line":261,"containerName":"to_string","kind":13,"name":"$s"},{"line":262,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$self","containerName":"to_string","kind":13,"line":262},{"containerName":"to_string","kind":12,"name":"more_than_two_genes","line":262},{"name":"$s","containerName":"to_string","kind":13,"line":263},{"line":264,"name":"$s","kind":13,"containerName":"to_string"},{"name":"$self","kind":13,"containerName":"to_string","line":264},{"name":"is_separate","kind":12,"containerName":"to_string","line":264},{"line":265,"name":"$s","containerName":"to_string","kind":13},{"name":"$s","containerName":"to_string","kind":13,"line":266},{"line":266,"name":"$self","kind":13,"containerName":"to_string"},{"line":266,"kind":12,"containerName":"to_string","name":"description"},{"line":267,"name":"$s","containerName":"to_string","kind":13},{"containerName":"to_string","kind":13,"name":"$s","line":268},{"line":268,"kind":13,"containerName":"to_string","name":"$self"},{"line":268,"containerName":"to_string","kind":12,"name":"species"},{"name":"binomial","kind":12,"containerName":"to_string","line":268},{"kind":13,"containerName":"to_string","name":"$s","line":269},{"containerName":"to_string","kind":13,"name":"$s","line":270},{"line":270,"name":"$self","kind":13,"containerName":"to_string"},{"line":270,"containerName":"to_string","kind":12,"name":"clinical_symptoms"},{"name":"$s","kind":13,"containerName":"to_string","line":271},{"kind":13,"containerName":"to_string","name":"$s","line":272},{"containerName":"to_string","kind":13,"name":"$self","line":272},{"line":272,"name":"_array_to_string","containerName":"to_string","kind":12},{"line":272,"name":"$self","containerName":"to_string","kind":13},{"kind":12,"containerName":"to_string","name":"each_AllelicVariant","line":272},{"containerName":"to_string","kind":13,"name":"$s","line":273},{"line":274,"name":"$s","containerName":"to_string","kind":13},{"containerName":"to_string","kind":13,"name":"$self","line":274},{"line":274,"name":"_array_to_string","kind":12,"containerName":"to_string"},{"line":274,"name":"$self","kind":13,"containerName":"to_string"},{"kind":12,"containerName":"to_string","name":"each_CytoPosition","line":274},{"line":275,"name":"$s","kind":13,"containerName":"to_string"},{"name":"$s","kind":13,"containerName":"to_string","line":276},{"kind":13,"containerName":"to_string","name":"$self","line":276},{"line":276,"name":"_array_to_string","containerName":"to_string","kind":12},{"kind":13,"containerName":"to_string","name":"$self","line":276},{"name":"each_gene_symbol","containerName":"to_string","kind":12,"line":276},{"line":277,"name":"$s","containerName":"to_string","kind":13},{"name":"$s","kind":13,"containerName":"to_string","line":278},{"line":278,"kind":13,"containerName":"to_string","name":"$self"},{"line":278,"name":"_array_to_string","kind":12,"containerName":"to_string"},{"line":278,"name":"$self","kind":13,"containerName":"to_string"},{"kind":12,"containerName":"to_string","name":"each_Correlate","line":278},{"line":279,"containerName":"to_string","kind":13,"name":"$s"},{"name":"$s","containerName":"to_string","kind":13,"line":280},{"line":280,"containerName":"to_string","kind":13,"name":"$self"},{"line":280,"name":"_array_to_string","containerName":"to_string","kind":12},{"kind":13,"containerName":"to_string","name":"$self","line":280},{"name":"each_Reference","containerName":"to_string","kind":12,"line":280},{"line":281,"name":"$s","containerName":"to_string","kind":13},{"line":282,"name":"$s","kind":13,"containerName":"to_string"},{"line":282,"containerName":"to_string","kind":13,"name":"$self"},{"kind":12,"containerName":"to_string","name":"additional_references","line":282},{"line":283,"name":"$s","kind":13,"containerName":"to_string"},{"kind":13,"containerName":"to_string","name":"$s","line":284},{"line":284,"containerName":"to_string","kind":13,"name":"$self"},{"containerName":"to_string","kind":12,"name":"mapping_method","line":284},{"kind":13,"containerName":"to_string","name":"$s","line":285},{"kind":13,"containerName":"to_string","name":"$s","line":286},{"line":286,"name":"$self","containerName":"to_string","kind":13},{"kind":12,"containerName":"to_string","name":"gene_status","line":286},{"line":287,"name":"$s","containerName":"to_string","kind":13},{"line":288,"name":"$s","containerName":"to_string","kind":13},{"kind":13,"containerName":"to_string","name":"$self","line":288},{"containerName":"to_string","kind":12,"name":"created","line":288},{"line":289,"name":"$s","containerName":"to_string","kind":13},{"containerName":"to_string","kind":13,"name":"$s","line":290},{"name":"$self","kind":13,"containerName":"to_string","line":290},{"kind":12,"containerName":"to_string","name":"contributors","line":290},{"name":"$s","kind":13,"containerName":"to_string","line":291},{"name":"$s","containerName":"to_string","kind":13,"line":292},{"line":292,"name":"$self","containerName":"to_string","kind":13},{"line":292,"name":"edited","kind":12,"containerName":"to_string"},{"line":293,"kind":13,"containerName":"to_string","name":"$s"},{"line":294,"containerName":"to_string","kind":13,"name":"$s"},{"line":294,"name":"$self","containerName":"to_string","kind":13},{"name":"comment","kind":12,"containerName":"to_string","line":294},{"line":295,"name":"$s","containerName":"to_string","kind":13},{"line":296,"kind":13,"containerName":"to_string","name":"$s"},{"name":"$self","kind":13,"containerName":"to_string","line":296},{"name":"miniMIM","containerName":"to_string","kind":12,"line":296},{"line":296,"kind":12,"containerName":"to_string","name":"to_string"},{"line":297,"containerName":"to_string","kind":13,"name":"$s"}],"name":"to_string","containerName":"main::","signature":{"label":"to_string($self)","documentation":"","parameters":[{"label":"$self"}]},"line":249,"kind":12,"range":{"end":{"line":300,"character":9999},"start":{"character":0,"line":249}}},{"definition":"sub","detail":"($self,$value)","children":[{"line":317,"name":"$self","localvar":"my","containerName":"MIM_number","kind":13,"definition":"my"},{"name":"$value","containerName":"MIM_number","kind":13,"line":317},{"kind":13,"containerName":"MIM_number","name":"$value","line":319},{"line":320,"name":"$value","kind":13,"containerName":"MIM_number"},{"kind":13,"containerName":"MIM_number","name":"$value","line":321},{"kind":13,"containerName":"MIM_number","name":"$value","line":321},{"kind":13,"containerName":"MIM_number","name":"$self","line":322},{"kind":12,"containerName":"MIM_number","name":"throw","line":322},{"containerName":"MIM_number","kind":13,"name":"$self","line":325},{"line":325,"name":"$value","kind":13,"containerName":"MIM_number"},{"line":328,"name":"$self","containerName":"MIM_number","kind":13}],"containerName":"main::","name":"MIM_number","signature":{"label":"MIM_number($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional)."},"line":316,"range":{"end":{"character":9999,"line":330},"start":{"line":316,"character":0}},"kind":12},{"line":321,"kind":12,"name":"DEFAULT_MIM_NUMER"},{"containerName":"main::","name":"title","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"title","line":350,"definition":"my"},{"kind":13,"containerName":"title","name":"$self","line":352},{"line":352,"name":"name","kind":12,"containerName":"title"}],"definition":"sub","kind":12,"range":{"start":{"line":349,"character":0},"end":{"line":354,"character":9999}},"line":349},{"detail":"($self,$value)","definition":"sub","name":"alternative_titles_and_symbols","containerName":"main::","children":[{"line":374,"localvar":"my","containerName":"alternative_titles_and_symbols","kind":13,"name":"$self","definition":"my"},{"name":"$value","kind":13,"containerName":"alternative_titles_and_symbols","line":374},{"line":376,"name":"$value","containerName":"alternative_titles_and_symbols","kind":13},{"line":377,"kind":13,"containerName":"alternative_titles_and_symbols","name":"$self"},{"containerName":"alternative_titles_and_symbols","kind":13,"name":"$value","line":377},{"line":380,"containerName":"alternative_titles_and_symbols","kind":13,"name":"$self"}],"signature":{"documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"alternative_titles_and_symbols($self,$value)"},"range":{"end":{"line":382,"character":9999},"start":{"line":373,"character":0}},"kind":12,"line":373},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"more_than_two_genes","children":[{"definition":"my","line":403,"kind":13,"localvar":"my","containerName":"more_than_two_genes","name":"$self"},{"line":403,"name":"$value","kind":13,"containerName":"more_than_two_genes"},{"kind":13,"containerName":"more_than_two_genes","name":"$value","line":405},{"kind":13,"containerName":"more_than_two_genes","name":"$self","line":406},{"line":406,"containerName":"more_than_two_genes","kind":12,"name":"_is_true_or_false"},{"line":406,"name":"$value","containerName":"more_than_two_genes","kind":13},{"name":"$self","containerName":"more_than_two_genes","kind":13,"line":407},{"kind":13,"containerName":"more_than_two_genes","name":"$value","line":407},{"name":"$self","kind":13,"containerName":"more_than_two_genes","line":410}],"signature":{"label":"more_than_two_genes($self,$value)","documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).\n\n\nsub alternative_titles_and_symbols {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_alternative_titles_and_symbols\" } = $value;\n    }\n\n    return $self->{ \"_alternative_titles_and_symbols\" };\n\n} # alternative_titles_and_symbols\n\n\n\n\n=head2 more_than_two_genes\n\n Title   : more_than_two_genes\n Usage   : $omim->more_than_two_genes( 1 );\n           or\n           print $omim->more_than_two_genes();\n Function: This is true if this phenotype can be caused\n           by mutation in any of two or more genes.\n           In OMIM, this is indicated by a number symbol (#)\n           before an entry number (e.g. #114480 -- BREAST CANCER).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"end":{"character":9999,"line":412},"start":{"line":402,"character":0}},"line":402},{"name":"is_separate","containerName":"main::","children":[{"line":437,"name":"$self","localvar":"my","containerName":"is_separate","kind":13,"definition":"my"},{"containerName":"is_separate","kind":13,"name":"$value","line":437},{"line":439,"containerName":"is_separate","kind":13,"name":"$value"},{"containerName":"is_separate","kind":13,"name":"$self","line":440},{"name":"_is_true_or_false","containerName":"is_separate","kind":12,"line":440},{"line":440,"name":"$value","kind":13,"containerName":"is_separate"},{"kind":13,"containerName":"is_separate","name":"$self","line":441},{"line":441,"name":"$value","containerName":"is_separate","kind":13},{"containerName":"is_separate","kind":13,"name":"$self","line":444}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":436},"end":{"character":9999,"line":446}},"line":436,"signature":{"documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).\n\n\nsub alternative_titles_and_symbols {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_alternative_titles_and_symbols\" } = $value;\n    }\n\n    return $self->{ \"_alternative_titles_and_symbols\" };\n\n} # alternative_titles_and_symbols\n\n\n\n\n=head2 more_than_two_genes\n\n Title   : more_than_two_genes\n Usage   : $omim->more_than_two_genes( 1 );\n           or\n           print $omim->more_than_two_genes();\n Function: This is true if this phenotype can be caused\n           by mutation in any of two or more genes.\n           In OMIM, this is indicated by a number symbol (#)\n           before an entry number (e.g. #114480 -- BREAST CANCER).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub more_than_two_genes {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_more_than_two_genes\" } = $value;\n    }\n\n    return $self->{ \"_more_than_two_genes\" };\n\n} # more_than_two_genes\n\n\n\n\n=head2 is_separate\n\n Title   : is_separate\n Usage   : $omim->is_separate( 1 );\n           or\n           print $omim->is_separate();\n Function: This is true if the phenotype determined by the gene at\n           the given locus is separate from those represented by\n           other entries where \"is_separate\" is true and if the mode\n           of inheritance of the phenotype has been proved\n           (in the judgment of the authors and editors).\n           In OMIM, this is indicated by a asterisk  (*)\n           before an entry number (e.g. *113705 BREAST CANCER,\n           TYPE 1; BRCA1).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).","parameters":[{"label":"$self"},{"label":"$value"}],"label":"is_separate($self,$value)"}},{"line":463,"range":{"start":{"line":463,"character":0},"end":{"character":9999,"line":467}},"kind":12,"children":[{"line":464,"localvar":"my","containerName":"mapping_method","kind":13,"name":"$self","definition":"my"},{"line":465,"name":"$self","containerName":"mapping_method","kind":13},{"line":466,"name":"$self","kind":13,"containerName":"mapping_method"}],"containerName":"main::","name":"mapping_method","definition":"sub"},{"detail":"($self,$value)","definition":"sub","name":"gene_status","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"gene_status","name":"$self","line":491,"definition":"my"},{"name":"$value","kind":13,"containerName":"gene_status","line":491},{"line":493,"containerName":"gene_status","kind":13,"name":"$value"},{"line":505,"name":"$value","containerName":"gene_status","kind":13},{"name":"$value","kind":13,"containerName":"gene_status","line":506},{"kind":13,"containerName":"gene_status","name":"$value","line":507},{"line":508,"kind":13,"containerName":"gene_status","name":"$value"},{"containerName":"gene_status","kind":13,"name":"$value","line":509},{"line":510,"kind":13,"containerName":"gene_status","name":"$value"},{"kind":13,"containerName":"gene_status","name":"$self","line":513},{"name":"$value","kind":13,"containerName":"gene_status","line":513},{"name":"$self","containerName":"gene_status","kind":13,"line":516}],"signature":{"label":"gene_status($self,$value)","documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).\n\n\nsub alternative_titles_and_symbols {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_alternative_titles_and_symbols\" } = $value;\n    }\n\n    return $self->{ \"_alternative_titles_and_symbols\" };\n\n} # alternative_titles_and_symbols\n\n\n\n\n=head2 more_than_two_genes\n\n Title   : more_than_two_genes\n Usage   : $omim->more_than_two_genes( 1 );\n           or\n           print $omim->more_than_two_genes();\n Function: This is true if this phenotype can be caused\n           by mutation in any of two or more genes.\n           In OMIM, this is indicated by a number symbol (#)\n           before an entry number (e.g. #114480 -- BREAST CANCER).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub more_than_two_genes {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_more_than_two_genes\" } = $value;\n    }\n\n    return $self->{ \"_more_than_two_genes\" };\n\n} # more_than_two_genes\n\n\n\n\n=head2 is_separate\n\n Title   : is_separate\n Usage   : $omim->is_separate( 1 );\n           or\n           print $omim->is_separate();\n Function: This is true if the phenotype determined by the gene at\n           the given locus is separate from those represented by\n           other entries where \"is_separate\" is true and if the mode\n           of inheritance of the phenotype has been proved\n           (in the judgment of the authors and editors).\n           In OMIM, this is indicated by a asterisk  (*)\n           before an entry number (e.g. *113705 BREAST CANCER,\n           TYPE 1; BRCA1).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub is_separate {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_is_separate\" } = $value;\n    }\n\n    return $self->{ \"_is_separate\" };\n\n} # is_separate\n\n\n\n\n=head2 mapping_method\n\n Title   : mapping_method\n Usage   : $omim->mapping_method( \"PCR of somatic cell hybrid DNA\" );\n           or\n           print $omim->mapping_method();\n Function: Set/get for the mapping method of this OMIM entry.\n Returns : The mapping method [scalar].\n Args    : The mapping method [scalar] (optional).\n\n\nsub mapping_method {\n    my $self = shift;\n    return $self->{ \"_mapping_method\" } = shift if(@_);\n    return $self->{ \"_mapping_method\" };\n} # mapping_method\n\n=head2 gene_status\n\n Title   : gene_status\n Usage   : $omim->gene_status( \"C\" );\n           or\n           print $omim->gene_status();\n Function: Set/get for the gene status of this OMIM entry.\n           The certainty with which assignment of loci to chromosomes or the linkage\n           between two loci has been established has been graded into the following\n           classes:\n           <L>C = confirmed - observed in at least two laboratories or in several families.\n           <L>P = provisional - based on evidence from one laboratory or one family.\n           <L>I = inconsistent - results of different laboratories disagree.\n           <L>L = limbo - evidence not as strong as that provisional, but included for\n           heuristic reasons. (Same as `tentative'.)\n\n Returns :  [C, P, I, or L].\n Args    :  [C, P, I, or L] (optional).","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"end":{"line":518,"character":9999},"start":{"character":0,"line":490}},"line":490},{"children":[{"line":532,"name":"$self","kind":13,"localvar":"my","containerName":"clinical_symptoms","definition":"my"},{"containerName":"clinical_symptoms","kind":13,"name":"$value","line":532},{"line":534,"name":"$value","kind":13,"containerName":"clinical_symptoms"},{"line":535,"name":"$value","containerName":"clinical_symptoms","kind":13},{"name":"$self","kind":13,"containerName":"clinical_symptoms","line":536},{"line":536,"kind":12,"containerName":"clinical_symptoms","name":"throw"},{"name":"$self","containerName":"clinical_symptoms","kind":13,"line":538},{"name":"$value","containerName":"clinical_symptoms","kind":13,"line":538},{"containerName":"clinical_symptoms","kind":13,"name":"$self","line":541}],"containerName":"main::","name":"clinical_symptoms","definition":"sub","detail":"($self,$value)","line":531,"range":{"end":{"character":9999,"line":543},"start":{"character":0,"line":531}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: OMIMentry.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Phenotype::OMIM::OMIMentry\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Christian M. Zmasek <czmasek-at-burnham.org> or <cmzmasek@yahoo.com>\n#\n# (c) Christian M. Zmasek, czmasek-at-burnham.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Phenotype::OMIM::OMIMentry - represents OMIM (Online Mendelian\nInheritance in Man) database entries\n\n=head1 SYNOPSIS\n\n  $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                               -description         => \"This is ...\",\n                                               -more_than_two_genes => 1 );\n\n=head1 DESCRIPTION\n\nInherits from Bio::Phenotype::PhenotypeI.\nBio::Phenotype::OMIM::OMIMparser parses the flat file representation\nof OMIM (i.e. files \"omim.txt\" and \"genemap\") returning OMIMentry objects. \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the \nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nChristian M. Zmasek\n\nEmail: czmasek-at-burnham.org  or  cmzmasek@yahoo.com\n\nWWW:   http://monochrome-effect.net/\n\nAddress: \n\n  Genomics Institute of the Novartis Research Foundation\n  10675 John Jay Hopkins Drive\n  San Diego, CA 92121\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Phenotype::OMIM::OMIMentry;\nuse strict;\n\nuse Bio::Phenotype::OMIM::MiniMIMentry;\nuse Bio::Phenotype::OMIM::OMIMentryAllelicVariant;\n\nuse constant TRUE              => 1;\nuse constant FALSE             => 0;\nuse constant DEFAULT_MIM_NUMER => 0;\n\nuse base qw(Bio::Phenotype::Phenotype);\n\n\n\n\n=head2 new\n\n Title   : new\n Usage   : $obj = Bio::Phenotype::OMIM::OMIMentry->new( -mim_number          => 200000,\n                                                        -description         => \"This is ...\",\n                                                        -more_than_two_genes => 1 );                      \n Function: Creates a new OMIMentry object.\n Returns : A new OMIMentry object.\n Args    : -mim_number                     => the MIM number\n           -title                          => the title or name\n           -alternative_titles_and_symbols => the \"alternative titles and symbols\"    \n           -more_than_two_genes            => can phenotype can be caused by mutation in any of two or more genes?       \n           -is_separate                    => is this phenotype separate from those represented by other entries  \n           -description                    => the description of this phenotype\n           -mapping_method                 => the mapping method      \n           -gene_status                    => the gene status of this       \n           -comment                        => a comment        \n           -species                        => ref to the the species (human)\n           -created                        => created by whom/when       \n           -edited                         => edited by whom/when    \n           -contributors                   => contributed by whom/when \n           -additional_references          => \"see also\"     \n           -clinical_symptoms              => the clinical symptoms\n           -minimim                        => the Mini MIM associated with this OMIM antry\n\n\nsub new {\n\n    my( $class,@args ) = @_;\n    \n    my $self = $class->SUPER::new( @args );\n   \n    my ( $mim_number,\n         $title,\n         $alternative_titles_and_symbols,     \n         $more_than_two_genes,       \n         $is_separate,    \n         $description,\n         $mapping_method,     \n         $gene_status,       \n         $comment,        \n         $species,\n         $created,       \n         $edited,    \n         $contributors,\n         $additional_references,     \n         $clinical_symptoms, \n         $miniMIM )\n    = $self->_rearrange( [ qw( MIM_NUMBER\n                               TITLE\n                               ALTERNATIVE_TITLES_AND_SYMBOLS\n                               MORE_THAN_TWO_GENES\n                               IS_SEPARATE\n                               DESCRIPTION\n                               MAPPING_METHOD\n                               GENE_STATUS\n                               COMMENT\n                               SPECIES\n                               CREATED\n                               EDITED\n                               CONTRIBUTORS\n                               ADDITIONAL_REFERENCES\n                               CLINICAL_SYMPTOMS\n                               MINIMIM ) ], @args );\n   \n    $self->init(); \n    \n    $mim_number                     && $self->MIM_number( $mim_number );\n    $title                          && $self->title( $title );\n    $alternative_titles_and_symbols && $self->alternative_titles_and_symbols( $alternative_titles_and_symbols );     \n    $more_than_two_genes            && $self->more_than_two_genes( $more_than_two_genes );      \n    $is_separate                    && $self->is_separate( $is_separate );   \n    $description                    && $self->description( $description );\n    $mapping_method                 && $self->mapping_method( $mapping_method );     \n    $gene_status                    && $self->gene_status( $gene_status );       \n    $comment                        && $self->comment( $comment );        \n    $species                        && $self->species( $species );\n    $created                        && $self->created( $created );       \n    $edited                         && $self->edited( $edited );    \n    $contributors                   && $self->contributors( $contributors );\n    $additional_references          && $self->additional_references( $additional_references );     \n    $clinical_symptoms              && $self->clinical_symptoms_raw( $clinical_symptoms );\n    $miniMIM                        && $self->miniMIM( $miniMIM );\n                                                    \n    return $self;\n    \n} # new\n\n\n\n=head2 init\n\n Title   : init()\n Usage   : $obj->init();   \n Function: Initializes this OMIMentry to all \"\" and empty lists.\n Returns : \n Args    :\n\n\nsub init {\n\n    my( $self ) = @_;\n\n    $self->MIM_number( DEFAULT_MIM_NUMER );\n    $self->title( \"\" );\n    $self->alternative_titles_and_symbols( \"\" );\n    $self->more_than_two_genes( FALSE );\n    $self->is_separate( FALSE );\n    $self->description( \"\" );\n    $self->mapping_method( \"\" );\n    $self->gene_status( \"\" );\n    $self->comment( \"\" );\n    my $species = Bio::Species->new();\n    $species->classification( qw( sapiens Homo ) );\n    $self->species( $species );\n    $self->created( \"\" );\n    $self->edited( \"\" );\n    $self->contributors( \"\" );\n    $self->additional_references( \"\" );\n    $self->clinical_symptoms( {} );\n    $self->remove_Correlates();\n    $self->remove_References();\n    $self->remove_AllelicVariants();\n    $self->remove_CytoPositions();\n    $self->remove_gene_symbols();\n    $self->remove_Genotypes();\n    $self->remove_DBLinks();\n    $self->remove_keywords();\n    $self->remove_Variants();\n    $self->remove_Measures();\n    $self->miniMIM( Bio::Phenotype::OMIM::MiniMIMentry->new() );\n  \n} # init\n\n\n\nsub to_string {\n\n    my( $self ) = @_;\n\n    my $s = \"\";\n\n    $s .= \"-- MIM number:\\n\";\n    $s .= $self->MIM_number().\"\\n\\n\";\n    $s .= \"-- Title:\\n\";\n    $s .= $self->title().\"\\n\\n\";\n    $s .= \"-- Alternative Titles and Symbols:\\n\";\n    $s .= $self->alternative_titles_and_symbols().\"\\n\\n\";\n    $s .= \"-- Can be caused by Mutation in any of two or more Genes:\\n\";\n    $s .= $self->more_than_two_genes().\"\\n\\n\";\n    $s .= \"-- Phenotype is separate:\\n\";\n    $s .= $self->is_separate().\"\\n\\n\"; \n    $s .= \"-- Description:\\n\";\n    $s .= $self->description().\"\\n\\n\";\n    $s .= \"-- Species:\\n\";\n    $s .= $self->species()->binomial().\"\\n\\n\";\n    $s .= \"-- Clinical Symptoms:\\n\";\n    $s .= $self->clinical_symptoms().\"\\n\\n\";\n    $s .= \"-- Allelic Variants:\\n\";\n    $s .= $self->_array_to_string( $self->each_AllelicVariant() ).\"\\n\";\n    $s .= \"-- Cyto Positions:\\n\";\n    $s .= $self->_array_to_string( $self->each_CytoPosition() ).\"\\n\";\n    $s .= \"-- Gene Symbols:\\n\";\n    $s .= $self->_array_to_string( $self->each_gene_symbol() ).\"\\n\";\n    $s .= \"-- Correlates:\\n\";\n    $s .= $self->_array_to_string( $self->each_Correlate() ).\"\\n\";\n    $s .= \"-- References:\\n\";\n    $s .= $self->_array_to_string( $self->each_Reference() ).\"\\n\";\n    $s .= \"-- Additional References:\\n\";\n    $s .= $self->additional_references().\"\\n\\n\";\n    $s .= \"-- Mapping Method:\\n\";\n    $s .= $self->mapping_method().\"\\n\\n\";\n    $s .= \"-- Gene status:\\n\";\n    $s .= $self->gene_status().\"\\n\\n\";\n    $s .= \"-- Created:\\n\";\n    $s .= $self->created().\"\\n\\n\";\n    $s .= \"-- Contributors:\\n\";\n    $s .= $self->contributors().\"\\n\\n\";\n    $s .= \"-- Edited:\\n\";\n    $s .= $self->edited().\"\\n\\n\";\n    $s .= \"-- Comment:\\n\";\n    $s .= $self->comment().\"\\n\\n\";\n    $s .= \"-- MiniMIM:\\n\";\n    $s .= $self->miniMIM()->to_string().\"\\n\\n\";\n    return $s;\n    \n\n} # to_string\n\n\n\n=head2 MIM_number\n\n Title   : MIM_number\n Usage   : $omim->MIM_number( \"100050\" );\n           or\n           print $omim->MIM_number();\n Function: Set/get for the MIM number of this OMIM entry.\n Returns : The MIM number [an integer larger than 100000].\n Args    : The MIM number [an integer larger than 100000] (optional).\n\n\nsub MIM_number {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        if ( $value =~ /\\D/\n        || ( $value < 100000 && $value != DEFAULT_MIM_NUMER ) ) {\n            $self->throw( \"Found [$value]\" \n            . \" where [integer larger than 100000] expected\" );\n        }\n        $self->{ \"_MIM_number\" } = $value;\n    }\n\n    return $self->{ \"_MIM_number\" };\n\n} # MIM_number\n\n\n\n\n=head2 title\n\n Title   : title\n Usage   : $omim->title( \"AARSKOG SYNDROME\" );\n           or\n           print $omim->title();\n Function: Set/get for the title or name of this OMIM entry.\n           This method is an alias to the method \"name\" of\n           Bio::Phenotype::PhenotypeI.\n Returns : The title [scalar].\n Args    : The title [scalar] (optional).\n\n\nsub title {\n    my $self = shift;\n    \n    $self->name(@_);\n    \n} # title\n\n\n\n\n=head2 alternative_titles_and_symbols\n\n Title   : alternative_titles_and_symbols\n Usage   : $omim->alternative_titles_and_symbols( \"AORTIC ANEURYSM, ABDOMINAL\" );\n           or\n           print $omim->alternative_titles_and_symbols();\n Function: Set/get for the \"alternative titles and symbols\" of this OMIM entry.\n           Currently, everything after the first line of title (TI) field is\n           considered \"alternative titles and symbols\".\n Returns : \"alternative titles and symbols\" [scalar].\n Args    : \"alternative titles and symbols\" [scalar] (optional).\n\n\nsub alternative_titles_and_symbols {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->{ \"_alternative_titles_and_symbols\" } = $value;\n    }\n\n    return $self->{ \"_alternative_titles_and_symbols\" };\n\n} # alternative_titles_and_symbols\n\n\n\n\n=head2 more_than_two_genes\n\n Title   : more_than_two_genes\n Usage   : $omim->more_than_two_genes( 1 );\n           or\n           print $omim->more_than_two_genes();\n Function: This is true if this phenotype can be caused\n           by mutation in any of two or more genes.\n           In OMIM, this is indicated by a number symbol (#)\n           before an entry number (e.g. #114480 -- BREAST CANCER).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub more_than_two_genes {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_more_than_two_genes\" } = $value;\n    }\n\n    return $self->{ \"_more_than_two_genes\" };\n\n} # more_than_two_genes\n\n\n\n\n=head2 is_separate\n\n Title   : is_separate\n Usage   : $omim->is_separate( 1 );\n           or\n           print $omim->is_separate();\n Function: This is true if the phenotype determined by the gene at\n           the given locus is separate from those represented by\n           other entries where \"is_separate\" is true and if the mode\n           of inheritance of the phenotype has been proved\n           (in the judgment of the authors and editors).\n           In OMIM, this is indicated by a asterisk  (*)\n           before an entry number (e.g. *113705 BREAST CANCER,\n           TYPE 1; BRCA1).\n Returns : [1 or 0].\n Args    : [1 or 0] (optional).\n\n\nsub is_separate {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        $self->_is_true_or_false( $value );\n        $self->{ \"_is_separate\" } = $value;\n    }\n\n    return $self->{ \"_is_separate\" };\n\n} # is_separate\n\n\n\n\n=head2 mapping_method\n\n Title   : mapping_method\n Usage   : $omim->mapping_method( \"PCR of somatic cell hybrid DNA\" );\n           or\n           print $omim->mapping_method();\n Function: Set/get for the mapping method of this OMIM entry.\n Returns : The mapping method [scalar].\n Args    : The mapping method [scalar] (optional).\n\n\nsub mapping_method {\n    my $self = shift;\n    return $self->{ \"_mapping_method\" } = shift if(@_);\n    return $self->{ \"_mapping_method\" };\n} # mapping_method\n\n=head2 gene_status\n\n Title   : gene_status\n Usage   : $omim->gene_status( \"C\" );\n           or\n           print $omim->gene_status();\n Function: Set/get for the gene status of this OMIM entry.\n           The certainty with which assignment of loci to chromosomes or the linkage\n           between two loci has been established has been graded into the following\n           classes:\n           <L>C = confirmed - observed in at least two laboratories or in several families.\n           <L>P = provisional - based on evidence from one laboratory or one family.\n           <L>I = inconsistent - results of different laboratories disagree.\n           <L>L = limbo - evidence not as strong as that provisional, but included for\n           heuristic reasons. (Same as `tentative'.)\n\n Returns :  [C, P, I, or L].\n Args    :  [C, P, I, or L] (optional).\n\n\nsub gene_status {\n    my ( $self, $value ) = @_;\n\n    if ( defined $value ) {\n        #unless ( $value eq \"C\"\n        #      || $value eq \"P\"\n        #      || $value eq \"I\"\n        #      || $value eq \"L\"\n        #      || $value eq \"A\"  # !?\n        #      || $value eq \"H\"  # !?\n        #      || $value eq \"U\"  # !?\n        #      || $value eq \"\" ) {\n        #    $self->throw( \"Found [$value]\" \n        #    . \" where [C, P, I, or L] expected\" );\n        #}\n        unless ( $value eq \"C\"\n              || $value eq \"P\"\n              || $value eq \"I\"\n              || $value eq \"L\"\n              || $value eq \"\" ) {\n            $value = \"\";\n        }\n        \n        $self->{ \"_gene_status\" } = $value;\n    }\n\n    return $self->{ \"_gene_status\" };\n\n} # gene_status\n\n\n=head2 clinical_symptoms\n\n Title   : clinical_symptoms\n Usage   : $omim->clinical_symptoms({});\n Function: Set/get for the clinical symptoms of this OMIM entry.\n Returns : [hash reference].\n Args    : [hash reference]. Suggested not to assign alone. Parser will do.","label":"clinical_symptoms($self,$value)"}},{"line":557,"kind":12,"range":{"start":{"line":557,"character":0},"end":{"line":561,"character":9999}},"definition":"sub","children":[{"line":558,"localvar":"my","kind":13,"containerName":"clinical_symptoms_raw","name":"$self","definition":"my"},{"kind":13,"containerName":"clinical_symptoms_raw","name":"$self","line":559},{"line":560,"name":"$self","containerName":"clinical_symptoms_raw","kind":13}],"containerName":"main::","name":"clinical_symptoms_raw"},{"line":559,"name":"_clinical_symptoms_raw","kind":12},{"line":560,"name":"_clinical_symptoms_raw","kind":12},{"name":"add_clinical_symptoms","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"add_clinical_symptoms","kind":13,"line":576,"definition":"my"},{"name":"$part","kind":13,"containerName":"add_clinical_symptoms","line":576},{"line":576,"kind":13,"containerName":"add_clinical_symptoms","name":"@symptoms"},{"line":577,"name":"$part","containerName":"add_clinical_symptoms","kind":13},{"line":578,"name":"$self","containerName":"add_clinical_symptoms","kind":13},{"line":578,"name":"throw","kind":12,"containerName":"add_clinical_symptoms"},{"line":580,"kind":13,"containerName":"add_clinical_symptoms","name":"$self"},{"containerName":"add_clinical_symptoms","kind":13,"name":"$self","line":580},{"line":581,"kind":13,"containerName":"add_clinical_symptoms","name":"$self"},{"kind":13,"containerName":"add_clinical_symptoms","name":"$part","line":581},{"line":582,"name":"$self","containerName":"add_clinical_symptoms","kind":13},{"name":"$part","containerName":"add_clinical_symptoms","kind":13,"line":582},{"name":"$self","containerName":"add_clinical_symptoms","kind":13,"line":583},{"name":"$part","kind":13,"containerName":"add_clinical_symptoms","line":583}],"detail":"($self,$part,@symptoms)","definition":"sub","range":{"end":{"line":583,"character":9999},"start":{"line":575,"character":0}},"kind":12,"line":575,"signature":{"label":"add_clinical_symptoms($self,$part,@symptoms)","parameters":[{"label":"$self"},{"label":"$part"},{"label":"@symptoms"}],"documentation":""}},{"line":580,"name":"_clinical_symptoms","kind":12},{"kind":12,"name":"_clinical_symptoms","line":580},{"kind":12,"name":"_clinical_symptoms","line":581},{"line":582,"name":"_clinical_symptoms","kind":12},{"name":"_clinical_symptoms","kind":12,"line":583},{"line":583,"name":"@symptoms","kind":13,"containerName":null},{"signature":{"parameters":[{"label":"$self"},{"label":"$organ"}],"documentation":"","label":"query_clinical_symptoms($self,$organ)"},"kind":12,"range":{"start":{"character":0,"line":596},"end":{"line":600,"character":9999}},"line":596,"detail":"($self,$organ)","definition":"sub","containerName":"main::","name":"query_clinical_symptoms","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"query_clinical_symptoms","line":597,"definition":"my"},{"line":597,"name":"$organ","kind":13,"containerName":"query_clinical_symptoms"},{"definition":"my","line":598,"name":"$symptoms","kind":13,"localvar":"my","containerName":"query_clinical_symptoms"},{"line":598,"kind":13,"containerName":"query_clinical_symptoms","name":"$self"},{"line":598,"name":"$organ","kind":13,"containerName":"query_clinical_symptoms"},{"kind":13,"containerName":"query_clinical_symptoms","name":"$symptoms","line":599}]},{"kind":12,"name":"_clinical_symptoms","line":598},{"children":[{"name":"$self","localvar":"my","containerName":"get_clinical_symptom_organs","kind":13,"line":603,"definition":"my"},{"line":604,"name":"$self","kind":13,"containerName":"get_clinical_symptom_organs"}],"name":"get_clinical_symptom_organs","containerName":"main::","definition":"sub","detail":"($self)","line":602,"kind":12,"range":{"end":{"line":604,"character":9999},"start":{"line":602,"character":0}},"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"get_clinical_symptom_organs($self)"}},{"name":"_clinical_symptoms","kind":12,"line":604},{"definition":"sub","containerName":"main::","name":"created","children":[{"line":620,"localvar":"my","containerName":"created","kind":13,"name":"$self","definition":"my"},{"line":621,"name":"$self","kind":13,"containerName":"created"},{"name":"$self","kind":13,"containerName":"created","line":622}],"range":{"start":{"character":0,"line":619},"end":{"character":9999,"line":624}},"kind":12,"line":619},{"line":641,"range":{"end":{"line":646,"character":9999},"start":{"line":641,"character":0}},"kind":12,"children":[{"definition":"my","localvar":"my","containerName":"contributors","kind":13,"name":"$self","line":642},{"name":"$self","kind":13,"containerName":"contributors","line":643},{"kind":13,"containerName":"contributors","name":"$self","line":644}],"containerName":"main::","name":"contributors","definition":"sub"},{"definition":"sub","children":[{"definition":"my","line":664,"localvar":"my","containerName":"edited","kind":13,"name":"$self"},{"line":665,"name":"$self","kind":13,"containerName":"edited"},{"name":"$self","containerName":"edited","kind":13,"line":666}],"name":"edited","containerName":"main::","line":663,"kind":12,"range":{"start":{"line":663,"character":0},"end":{"line":668,"character":9999}}},{"line":686,"kind":12,"range":{"end":{"character":9999,"line":691},"start":{"character":0,"line":686}},"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"additional_references","kind":13,"line":687},{"line":688,"name":"$self","containerName":"additional_references","kind":13},{"line":689,"containerName":"additional_references","kind":13,"name":"$self"}],"name":"additional_references","containerName":"main::"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"miniMIM","children":[{"definition":"my","name":"$self","containerName":"miniMIM","localvar":"my","kind":13,"line":708},{"line":708,"name":"$value","containerName":"miniMIM","kind":13},{"line":710,"name":"$value","containerName":"miniMIM","kind":13},{"name":"$self","kind":13,"containerName":"miniMIM","line":711},{"containerName":"miniMIM","kind":12,"name":"_check_ref_type","line":711},{"line":711,"kind":13,"containerName":"miniMIM","name":"$value"},{"line":712,"name":"$self","kind":13,"containerName":"miniMIM"},{"name":"$value","kind":13,"containerName":"miniMIM","line":712},{"name":"$self","kind":13,"containerName":"miniMIM","line":715}],"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"}],"label":"miniMIM($self,$value)"},"kind":12,"range":{"start":{"line":706,"character":0},"end":{"line":716,"character":9999}},"line":706},{"definition":"sub","detail":"($self)","children":[{"name":"$self","containerName":"each_AllelicVariant","localvar":"my","kind":13,"line":730,"definition":"my"},{"line":732,"name":"$self","containerName":"each_AllelicVariant","kind":13}],"containerName":"main::","name":"each_AllelicVariant","signature":{"label":"each_AllelicVariant($self)","parameters":[{"label":"$self"}],"documentation":""},"line":729,"kind":12,"range":{"start":{"character":0,"line":729},"end":{"character":9999,"line":732}}},{"containerName":null,"kind":13,"name":"%self","line":732},{"kind":12,"range":{"end":{"line":759,"character":9999},"start":{"character":0,"line":750}},"line":750,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@values"}],"label":"add_AllelicVariants($self,@values)"},"name":"add_AllelicVariants","containerName":"main::","children":[{"definition":"my","line":751,"localvar":"my","containerName":"add_AllelicVariants","kind":13,"name":"$self"},{"line":751,"containerName":"add_AllelicVariants","kind":13,"name":"@values"},{"line":753,"kind":13,"containerName":"add_AllelicVariants","name":"@values"},{"definition":"my","line":755,"name":"$value","localvar":"my","containerName":"add_AllelicVariants","kind":13},{"line":755,"name":"@values","kind":13,"containerName":"add_AllelicVariants"},{"line":756,"name":"$self","containerName":"add_AllelicVariants","kind":13},{"line":756,"containerName":"add_AllelicVariants","kind":12,"name":"_check_ref_type"},{"line":756,"name":"$value","containerName":"add_AllelicVariants","kind":13},{"line":759,"kind":13,"containerName":"add_AllelicVariants","name":"$self"}],"detail":"($self,@values)","definition":"sub"},{"line":759,"name":"@values","containerName":null,"kind":13},{"kind":12,"range":{"end":{"line":782,"character":9999},"start":{"character":0,"line":775}},"line":775,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"remove_AllelicVariants($self)"},"name":"remove_AllelicVariants","containerName":"main::","children":[{"localvar":"my","containerName":"remove_AllelicVariants","kind":13,"name":"$self","line":776,"definition":"my"},{"name":"@a","containerName":"remove_AllelicVariants","localvar":"my","kind":13,"line":778,"definition":"my"},{"line":778,"name":"$self","containerName":"remove_AllelicVariants","kind":13},{"containerName":"remove_AllelicVariants","kind":12,"name":"each_AllelicVariant","line":778},{"name":"$self","containerName":"remove_AllelicVariants","kind":13,"line":779},{"line":780,"containerName":"remove_AllelicVariants","kind":13,"name":"@a"}],"detail":"($self)","definition":"sub"},{"range":{"start":{"character":0,"line":789},"end":{"line":814,"character":9999}},"kind":12,"line":789,"signature":{"parameters":[{"label":"$self"},{"label":"@value"}],"documentation":"","label":"_array_to_string($self,@value)"},"containerName":"main::","name":"_array_to_string","children":[{"definition":"my","localvar":"my","containerName":"_array_to_string","kind":13,"name":"$self","line":790},{"name":"@value","containerName":"_array_to_string","kind":13,"line":790},{"localvar":"my","containerName":"_array_to_string","kind":13,"name":"$s","line":792,"definition":"my"},{"definition":"my","line":794,"name":"$i","containerName":"_array_to_string","localvar":"my","kind":13},{"line":794,"kind":13,"containerName":"_array_to_string","name":"$i"},{"line":794,"kind":13,"containerName":"_array_to_string","name":"@value"},{"line":794,"name":"$i","containerName":"_array_to_string","kind":13},{"containerName":"_array_to_string","kind":13,"name":"$value","line":795},{"line":795,"name":"$i","kind":13,"containerName":"_array_to_string"},{"line":796,"containerName":"_array_to_string","kind":13,"name":"$s"},{"line":796,"name":"$i","containerName":"_array_to_string","kind":13},{"line":796,"containerName":"_array_to_string","kind":13,"name":"$value"},{"containerName":"_array_to_string","kind":13,"name":"$i","line":796},{"line":798,"name":"$value","kind":13,"containerName":"_array_to_string"},{"name":"$i","containerName":"_array_to_string","kind":13,"line":798},{"line":798,"name":"isa","containerName":"_array_to_string","kind":12},{"line":799,"name":"$value","containerName":"_array_to_string","kind":13},{"line":799,"containerName":"_array_to_string","kind":13,"name":"$i"},{"containerName":"_array_to_string","kind":12,"name":"isa","line":799},{"containerName":"_array_to_string","kind":13,"name":"$s","line":800},{"line":800,"containerName":"_array_to_string","kind":13,"name":"$i"},{"line":800,"name":"$value","containerName":"_array_to_string","kind":13},{"line":800,"kind":13,"containerName":"_array_to_string","name":"$i"},{"line":800,"containerName":"_array_to_string","kind":12,"name":"to_string"},{"containerName":"_array_to_string","kind":13,"name":"$value","line":802},{"containerName":"_array_to_string","kind":13,"name":"$i","line":802},{"line":802,"kind":12,"containerName":"_array_to_string","name":"isa"},{"line":803,"name":"$s","kind":13,"containerName":"_array_to_string"},{"kind":13,"containerName":"_array_to_string","name":"$i","line":803},{"line":803,"name":"$value","containerName":"_array_to_string","kind":13},{"name":"$i","containerName":"_array_to_string","kind":13,"line":803},{"kind":12,"containerName":"_array_to_string","name":"authors","line":803},{"name":"$s","containerName":"_array_to_string","kind":13,"line":804},{"containerName":"_array_to_string","kind":13,"name":"$value","line":804},{"name":"$i","containerName":"_array_to_string","kind":13,"line":804},{"line":804,"name":"title","kind":12,"containerName":"_array_to_string"},{"line":805,"name":"$s","kind":13,"containerName":"_array_to_string"},{"line":805,"name":"$value","kind":13,"containerName":"_array_to_string"},{"name":"$i","containerName":"_array_to_string","kind":13,"line":805},{"name":"location","kind":12,"containerName":"_array_to_string","line":805},{"line":807,"name":"$value","containerName":"_array_to_string","kind":13},{"kind":13,"containerName":"_array_to_string","name":"$i","line":807},{"line":807,"containerName":"_array_to_string","kind":12,"name":"isa"},{"kind":13,"containerName":"_array_to_string","name":"$s","line":808},{"line":808,"containerName":"_array_to_string","kind":13,"name":"$i"},{"line":808,"name":"$value","kind":13,"containerName":"_array_to_string"},{"name":"$i","containerName":"_array_to_string","kind":13,"line":808},{"line":808,"containerName":"_array_to_string","kind":12,"name":"value"},{"line":812,"name":"$s","containerName":"_array_to_string","kind":13}],"detail":"($self,@value)","definition":"sub"},{"children":[{"definition":"my","localvar":"my","containerName":"_is_true_or_false","kind":13,"name":"$self","line":822},{"line":822,"containerName":"_is_true_or_false","kind":13,"name":"$value"},{"line":823,"name":"$value","containerName":"_is_true_or_false","kind":13},{"line":823,"containerName":"_is_true_or_false","kind":13,"name":"$value"},{"name":"$value","containerName":"_is_true_or_false","kind":13,"line":823},{"containerName":"_is_true_or_false","kind":13,"name":"$self","line":824},{"name":"throw","kind":12,"containerName":"_is_true_or_false","line":824},{"name":"$value","containerName":"_is_true_or_false","kind":13,"line":825}],"name":"_is_true_or_false","containerName":"main::","definition":"sub","detail":"($self,$value)","line":821,"kind":12,"range":{"start":{"character":0,"line":821},"end":{"character":9999,"line":827}},"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"","label":"_is_true_or_false($self,$value)"}},{"kind":12,"name":"TRUE","line":823},{"name":"FALSE","kind":12,"line":823},{"line":825,"kind":12,"name":"TRUE"},{"line":825,"name":"FALSE","kind":12}],"version":5}