{"vars":[{"name":"base","kind":2,"containerName":"","line":63},{"detail":"($pkg,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"line":88,"name":"$pkg","localvar":"my","containerName":"new","kind":13,"definition":"my"},{"line":88,"name":"@args","containerName":"new","kind":13},{"line":90,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"line":90,"containerName":"new","kind":13,"name":"$pkg"},{"containerName":"new","kind":13,"name":"@args","line":90},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$leavesR","line":92},{"line":92,"name":"$numleaves","containerName":"new","kind":13},{"line":92,"containerName":"new","kind":13,"name":"$numhybrids"},{"name":"$self","containerName":"new","kind":13,"line":93},{"kind":12,"containerName":"new","name":"_rearrange","line":93},{"line":95,"containerName":"new","kind":13,"name":"@args"},{"containerName":"new","localvar":"my","kind":13,"name":"@leaves","line":97,"definition":"my"},{"kind":13,"containerName":"new","name":"$leavesR","line":98},{"line":98,"kind":13,"containerName":"new","name":"$numleaves"},{"kind":13,"containerName":"new","name":"@leaves","line":99},{"name":"$numleaves","containerName":"new","kind":13,"line":99},{"name":"$leavesR","kind":13,"containerName":"new","line":100},{"name":"@leaves","containerName":"new","kind":13,"line":100},{"name":"$leavesR","kind":13,"containerName":"new","line":102},{"line":103,"name":"$self","kind":13,"containerName":"new"},{"name":"throw","kind":12,"containerName":"new","line":103},{"line":105,"name":"@leaves","kind":13,"containerName":"new"},{"line":105,"name":"$leavesR","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":106},{"line":106,"kind":13,"containerName":"new","name":"$leavesR"},{"line":108,"kind":13,"containerName":"new","name":"$numleaves"},{"line":108,"kind":13,"containerName":"new","name":"@leaves"},{"kind":13,"containerName":"new","name":"$self","line":109},{"name":"$numleaves","kind":13,"containerName":"new","line":109},{"line":110,"containerName":"new","kind":13,"name":"$numleaves"},{"definition":"my","line":111,"kind":13,"localvar":"my","containerName":"new","name":"@leavesparent"},{"name":"@leaves","containerName":"new","kind":13,"line":111},{"localvar":"my","containerName":"new","kind":13,"name":"$newleaf","line":112,"definition":"my"},{"containerName":"new","kind":13,"name":"@leavesparent","line":112},{"name":"$self","kind":13,"containerName":"new","line":113},{"line":113,"name":"$newleaf","containerName":"new","kind":13},{"line":114,"kind":13,"containerName":"new","name":"$self"},{"line":115,"name":"$pkg","containerName":"new","kind":13},{"line":115,"containerName":"new","kind":13,"name":"@leavesparent"},{"definition":"my","line":116,"name":"$oldnet","localvar":"my","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":116},{"line":116,"name":"next_network","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"$self","line":117},{"kind":13,"containerName":"new","name":"$oldnet","line":117},{"localvar":"my","kind":13,"containerName":"new","name":"@candidates","line":118,"definition":"my"},{"name":"$oldnet","kind":13,"containerName":"new","line":118},{"containerName":"new","kind":12,"name":"nodes","line":118},{"name":"$self","containerName":"new","kind":13,"line":119},{"line":119,"kind":13,"containerName":"new","name":"@candidates"},{"line":121,"containerName":"new","kind":13,"name":"$self"},{"line":123,"kind":13,"containerName":"new","name":"$self"},{"line":123,"kind":13,"containerName":"new","name":"$pkg"}],"signature":{"label":"new($pkg,@args)","documentation":"1;\n# $Id: TreeFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactory - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".","parameters":[{"label":"$pkg"},{"label":"@args"}]},"range":{"start":{"line":87,"character":0},"end":{"line":124,"character":9999}},"kind":12,"line":87},{"line":88,"kind":2,"containerName":"Bio","name":"PhyloNetwork"},{"name":"SUPER","containerName":"new","kind":12,"line":90},{"name":"leaves","kind":12,"line":106},{"name":"numleaves","kind":12,"line":109},{"kind":12,"name":"newleaf","line":113},{"line":114,"kind":12,"name":"parent"},{"line":116,"name":"parent","kind":12},{"line":117,"name":"oldnet","kind":12},{"kind":12,"name":"candidates","line":119},{"line":121,"kind":12,"name":"index"},{"containerName":"main::","name":"next_network","children":[{"kind":13,"localvar":"my","containerName":"next_network","name":"$self","line":137,"definition":"my"},{"name":"$n","localvar":"my","containerName":"next_network","kind":13,"line":139,"definition":"my"},{"line":139,"containerName":"next_network","kind":13,"name":"$self"},{"name":"$self","containerName":"next_network","kind":13,"line":140},{"line":141,"containerName":"next_network","kind":13,"name":"$self"},{"definition":"my","line":142,"localvar":"my","containerName":"next_network","kind":13,"name":"$graph"},{"line":142,"kind":12,"containerName":"next_network","name":"new"},{"name":"$graph","containerName":"next_network","kind":13,"line":143},{"line":143,"containerName":"next_network","kind":12,"name":"add_edges"},{"name":"$self","kind":13,"containerName":"next_network","line":143},{"line":143,"kind":13,"containerName":"next_network","name":"$self"},{"line":144,"kind":13,"localvar":"my","containerName":"next_network","name":"$net","definition":"my"},{"line":144,"kind":12,"containerName":"next_network","name":"new"},{"line":144,"name":"$graph","containerName":"next_network","kind":13},{"name":"$self","kind":13,"containerName":"next_network","line":145},{"line":146,"kind":13,"containerName":"next_network","name":"$net"},{"line":153,"name":"$self","kind":13,"containerName":"next_network"},{"line":153,"kind":13,"containerName":"next_network","name":"$self"},{"definition":"my","line":154,"name":"$oldnet","kind":13,"localvar":"my","containerName":"next_network"},{"line":154,"containerName":"next_network","kind":13,"name":"$self"},{"line":154,"name":"next_network","containerName":"next_network","kind":12},{"line":155,"name":"$oldnet","containerName":"next_network","kind":13},{"line":158,"name":"$self","containerName":"next_network","kind":13},{"name":"$oldnet","containerName":"next_network","kind":13,"line":158},{"definition":"my","localvar":"my","containerName":"next_network","kind":13,"name":"@candidates","line":159},{"name":"$oldnet","containerName":"next_network","kind":13,"line":159},{"containerName":"next_network","kind":12,"name":"nodes","line":159},{"line":160,"name":"$self","kind":13,"containerName":"next_network"},{"line":160,"name":"@candidates","kind":13,"containerName":"next_network"},{"kind":13,"containerName":"next_network","name":"$self","line":161},{"line":163,"name":"$graph","containerName":"next_network","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"next_network","name":"$self","line":163},{"name":"copy","kind":12,"containerName":"next_network","line":163},{"definition":"my","containerName":"next_network","localvar":"my","kind":13,"name":"$u","line":164},{"containerName":"next_network","kind":13,"name":"$self","line":164},{"line":164,"containerName":"next_network","kind":13,"name":"$self"},{"definition":"my","localvar":"my","containerName":"next_network","kind":13,"name":"$w","line":165},{"line":165,"kind":13,"containerName":"next_network","name":"$graph"},{"kind":12,"containerName":"next_network","name":"predecessors","line":165},{"line":165,"containerName":"next_network","kind":13,"name":"$u"},{"line":166,"name":"$graph","kind":13,"containerName":"next_network"},{"line":166,"kind":12,"containerName":"next_network","name":"delete_edge"},{"line":166,"name":"$w","kind":13,"containerName":"next_network"},{"name":"$u","kind":13,"containerName":"next_network","line":166},{"name":"$graph","kind":13,"containerName":"next_network","line":167},{"line":167,"name":"add_edge","kind":12,"containerName":"next_network"},{"line":167,"kind":13,"containerName":"next_network","name":"$w"},{"name":"$graph","kind":13,"containerName":"next_network","line":169},{"line":169,"name":"add_edge","containerName":"next_network","kind":12},{"line":169,"kind":13,"containerName":"next_network","name":"$u"},{"kind":13,"containerName":"next_network","name":"$graph","line":170},{"name":"add_edge","containerName":"next_network","kind":12,"line":170},{"line":170,"name":"$self","containerName":"next_network","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"next_network","name":"$net","line":171},{"line":171,"name":"new","containerName":"next_network","kind":12},{"name":"$graph","containerName":"next_network","kind":13,"line":171},{"line":172,"containerName":"next_network","kind":13,"name":"$self"},{"name":"$net","containerName":"next_network","kind":13,"line":173}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"line":174,"character":9999},"start":{"character":0,"line":136}},"line":136,"signature":{"label":"next_network($self)","documentation":"1;\n# $Id: TreeFactory.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# Module for Bio::PhyloNetwork::TreeFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gabriel Cardona <gabriel(dot)cardona(at)uib(dot)es>\n#\n# Copyright Gabriel Cardona\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PhyloNetwork::TreeFactory - Module to sequentially generate\nPhylogenetic Trees\n\n=head1 SYNOPSIS\n\n use strict;\n use warnings;\n\n use Bio::PhyloNetwork;\n use Bio::PhyloNetwork::TreeFactory;\n\n # Will generate sequentially all the 15 binary phylogetic\n # trees with 4 leaves\n\n my $factory=Bio::PhyloNetwork::TreeFactory->new(-numleaves=>4);\n\n my @nets;\n\n while (my $net=$factory->next_network()) {\n   push @nets,$net;\n   print \"\".(scalar @nets).\": \".$net->eNewick().\"\\n\";\n }\n\n=head1 DESCRIPTION\n\nSequentially builds a (binary) phylogenetic tree each time\nnext_network is called.\n\n=head1 AUTHOR\n\nGabriel Cardona, gabriel(dot)cardona(at)uib(dot)es\n\n=head1 SEE ALSO\n\nL<Bio::PhyloNetwork>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\n\n\npackage Bio::PhyloNetwork::TreeFactory;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root);\n\nuse Bio::PhyloNetwork;\n\n=head2 new\n\n Title   : new\n Usage   : my $factory = new Bio::PhyloNetwork::TreeFactory();\n Function: Creates a new Bio::PhyloNetwork::TreeFactory\n Returns : Bio::PhyloNetwork::RandomFactory\n Args    : -numleaves => integer\n            OR\n           -leaves => reference to an array (of leaves names)\n\nReturns a Bio::PhyloNetwork::TreeFactory object. Such an object will\nsequentially create binary phylogenetic trees\neach time next_network is called.\n\nIf the parameter -leaves=E<gt>\\@leaves is given, then the set of leaves of\nthese networks will be @leaves. If it is given the parameter\n-numleaves=E<gt>$numleaves, then the set of leaves will be \"l1\"...\"l$numleaves\".\n\n\nsub new {\n  my ($pkg,@args)=@_;\n\n  my $self=$pkg->SUPER::new(@args);\n\n  my ($leavesR,$numleaves,$numhybrids)=\n    $self->_rearrange([qw(LEAVES\n\t\t\t  NUMLEAVES\n\t\t\t  NUMHYBRIDS)],@args);\n\n  my @leaves;\n  if ((! defined $leavesR) && (defined $numleaves)) {\n    @leaves=map {\"l$_\"} (1..$numleaves);\n    $leavesR=\\@leaves;\n  }\n  if (! defined $leavesR) {\n    $self->throw(\"No leaves set neither numleaves given\");\n  }\n  @leaves=@$leavesR;\n  $self->{leaves}=$leavesR;\n\n  $numleaves=@leaves;\n  $self->{numleaves}=$numleaves;\n  if ($numleaves > 2) {\n    my @leavesparent=@leaves;\n    my $newleaf=pop @leavesparent;\n    $self->{newleaf}=$newleaf;\n    $self->{parent}=\n      new($pkg,-leaves=>\\@leavesparent);\n    my $oldnet=$self->{parent}->next_network();\n    $self->{oldnet}=$oldnet;\n    my @candidates=$oldnet->nodes();\n    $self->{candidates}=\\@candidates;\n  }\n  $self->{index}=0;\n\n  bless($self,$pkg);\n}\n\n=head2 next_network\n\n Title   : next_network\n Usage   : my $net=$factory->next_network()\n Function: returns a tree\n Returns : Bio::PhyloNetwork\n Args    : none","parameters":[{"label":"$self"}]}},{"line":139,"name":"numleaves","kind":12},{"line":140,"kind":12,"name":"numleaves"},{"kind":12,"name":"index","line":141},{"name":"Graph","containerName":"Directed","kind":12,"line":142},{"kind":12,"name":"leaves","line":143},{"line":143,"kind":12,"name":"leaves"},{"containerName":"PhyloNetwork","kind":12,"name":"Bio","line":144},{"line":145,"name":"index","kind":12},{"name":"index","kind":12,"line":153},{"line":153,"name":"candidates","kind":12},{"line":154,"kind":12,"name":"parent"},{"kind":12,"name":"oldnet","line":158},{"kind":12,"name":"candidates","line":160},{"kind":12,"name":"index","line":161},{"name":"oldnet","kind":12,"line":163},{"line":163,"name":"graph","kind":12},{"line":164,"kind":12,"name":"candidates"},{"name":"index","kind":12,"line":164},{"line":170,"kind":12,"name":"newleaf"},{"name":"Bio","containerName":"PhyloNetwork","kind":12,"line":171},{"line":172,"name":"index","kind":12}],"version":5}