{"vars":[{"kind":2,"containerName":"","name":"Storable","line":310},{"line":312,"name":"vars","kind":2,"containerName":""},{"line":316,"name":"base","kind":2,"containerName":""},{"line":318,"kind":13,"localvar":"my","containerName":null,"name":"$USAGE","definition":"my"},{"line":339,"range":{"end":{"character":9999,"line":377},"start":{"line":339,"character":0}},"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public"},"children":[{"line":340,"name":"$class","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":340},{"definition":"my","line":342,"kind":13,"localvar":"my","containerName":"new","name":"$self"},{"name":"$class","containerName":"new","kind":13,"line":342},{"name":"@args","containerName":"new","kind":13,"line":342},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$haplotype_block","line":343},{"line":344,"kind":13,"containerName":"new","name":"$snp_ids"},{"line":345,"name":"$pattern_freq","kind":13,"containerName":"new"},{"line":345,"name":"$self","kind":13,"containerName":"new"},{"line":345,"name":"_rearrange","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"@args","line":347},{"line":349,"containerName":"new","kind":13,"name":"$haplotype_block"},{"name":"$self","kind":13,"containerName":"new","line":350},{"containerName":"new","kind":12,"name":"haplotype_block","line":350},{"kind":13,"containerName":"new","name":"$haplotype_block","line":350},{"containerName":"new","kind":13,"name":"$self","line":353},{"kind":12,"containerName":"new","name":"throw","line":353},{"name":"$snp_ids","containerName":"new","kind":13,"line":356},{"line":357,"containerName":"new","kind":13,"name":"$self"},{"line":357,"name":"snp_ids","containerName":"new","kind":12},{"kind":13,"containerName":"new","name":"$snp_ids","line":357},{"line":360,"containerName":"new","kind":13,"name":"$self"},{"line":360,"name":"throw","containerName":"new","kind":12},{"name":"$pattern_freq","kind":13,"containerName":"new","line":363},{"name":"$self","containerName":"new","kind":13,"line":364},{"containerName":"new","kind":12,"name":"pattern_freq","line":364},{"line":364,"name":"$pattern_freq","containerName":"new","kind":13},{"line":367,"name":"$self","containerName":"new","kind":13},{"line":367,"name":"throw","containerName":"new","kind":12},{"containerName":"new","kind":13,"name":"$self","line":372},{"line":374,"containerName":"new","kind":13,"name":"$self"},{"line":376,"name":"$self","containerName":"new","kind":13}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"line":342,"name":"SUPER","kind":12,"containerName":"new"},{"kind":12,"name":"_check_input","line":372},{"name":"_do_it","kind":12,"line":374},{"definition":"sub","children":[{"line":391,"name":"$self","localvar":"my","kind":13,"containerName":"haplotype_block","definition":"my"},{"line":392,"name":"$self","kind":13,"containerName":"haplotype_block"},{"line":393,"name":"$self","containerName":"haplotype_block","kind":13}],"name":"haplotype_block","containerName":"main::","line":390,"kind":12,"range":{"start":{"line":390,"character":0},"end":{"character":9999,"line":394}}},{"kind":12,"range":{"end":{"line":411,"character":9999},"start":{"line":407,"character":0}},"line":407,"definition":"sub","name":"snp_ids","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"snp_ids","kind":13,"name":"$self","line":408},{"line":409,"containerName":"snp_ids","kind":13,"name":"$self"},{"line":410,"containerName":"snp_ids","kind":13,"name":"$self"}]},{"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"pattern_freq","name":"$self","line":426},{"name":"$self","containerName":"pattern_freq","kind":13,"line":427},{"kind":13,"containerName":"pattern_freq","name":"$self","line":428}],"containerName":"main::","name":"pattern_freq","line":425,"kind":12,"range":{"end":{"line":429,"character":9999},"start":{"character":0,"line":425}}},{"range":{"end":{"line":451,"character":9999},"start":{"line":443,"character":0}},"kind":12,"line":443,"definition":"sub","containerName":"main::","name":"_check_input","children":[{"line":446,"localvar":"my","containerName":"_check_input","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"_check_input","line":448},{"name":"$self","kind":13,"containerName":"_check_input","line":449}]},{"line":448,"kind":12,"name":"_haplotype_length_error"},{"name":"_population_error","kind":12,"line":449},{"definition":"sub","children":[{"line":470,"localvar":"my","containerName":"_haplotype_length_error","kind":13,"name":"$self","definition":"my"},{"definition":"my","line":472,"name":"$input_block","localvar":"my","kind":13,"containerName":"_haplotype_length_error"},{"containerName":"_haplotype_length_error","kind":13,"name":"$self","line":472},{"line":472,"name":"haplotype_block","kind":12,"containerName":"_haplotype_length_error"},{"definition":"my","name":"$snp_ids","kind":13,"localvar":"my","containerName":"_haplotype_length_error","line":473},{"line":473,"containerName":"_haplotype_length_error","kind":13,"name":"$self"},{"line":473,"name":"snp_ids","containerName":"_haplotype_length_error","kind":12},{"definition":"my","line":479,"containerName":"_haplotype_length_error","localvar":"my","kind":13,"name":"$different_haplotype_length"},{"definition":"my","line":486,"localvar":"my","containerName":"_haplotype_length_error","kind":13,"name":"$snp_number"},{"definition":"my","line":487,"localvar":"my","kind":13,"containerName":"_haplotype_length_error","name":"$number_of_families"},{"kind":13,"containerName":"_haplotype_length_error","name":"$input_block","line":487},{"definition":"my","line":488,"localvar":"my","containerName":"_haplotype_length_error","kind":13,"name":"$h"},{"name":"$h","containerName":"_haplotype_length_error","kind":13,"line":497},{"name":"$h","containerName":"_haplotype_length_error","kind":13,"line":497},{"kind":13,"containerName":"_haplotype_length_error","name":"$input_block","line":497},{"name":"$h","kind":13,"containerName":"_haplotype_length_error","line":497},{"line":498,"name":"$input_block","containerName":"_haplotype_length_error","kind":13},{"name":"$h","containerName":"_haplotype_length_error","kind":13,"line":498},{"line":498,"name":"$snp_number","containerName":"_haplotype_length_error","kind":13},{"line":499,"name":"$different_haplotype_length","kind":13,"containerName":"_haplotype_length_error"},{"name":"$different_haplotype_length","kind":13,"containerName":"_haplotype_length_error","line":505},{"containerName":"_haplotype_length_error","kind":13,"name":"$self","line":506},{"line":506,"name":"throw","containerName":"_haplotype_length_error","kind":12},{"line":507,"name":"$h","containerName":"_haplotype_length_error","kind":13},{"containerName":"_haplotype_length_error","kind":13,"name":"$input_block","line":508},{"name":"$h","containerName":"_haplotype_length_error","kind":13,"line":508},{"kind":13,"containerName":"_haplotype_length_error","name":"$input_block","line":509},{"containerName":"_haplotype_length_error","kind":13,"name":"$h","line":509}],"containerName":"main::","name":"_haplotype_length_error","line":467,"range":{"end":{"character":9999,"line":511},"start":{"line":467,"character":0}},"kind":12},{"line":528,"kind":12,"range":{"start":{"line":528,"character":0},"end":{"character":9999,"line":569}},"children":[{"line":531,"name":"$self","localvar":"my","containerName":"_population_error","kind":13,"definition":"my"},{"definition":"my","line":533,"containerName":"_population_error","localvar":"my","kind":13,"name":"$input_block"},{"line":533,"kind":13,"containerName":"_population_error","name":"$self"},{"containerName":"_population_error","kind":12,"name":"haplotype_block","line":533},{"definition":"my","line":534,"name":"$pop_freq","localvar":"my","kind":13,"containerName":"_population_error"},{"name":"$self","kind":13,"containerName":"_population_error","line":534},{"line":534,"name":"pattern_freq","containerName":"_population_error","kind":12},{"definition":"my","name":"$pop_freq_elements_error","localvar":"my","containerName":"_population_error","kind":13,"line":539},{"definition":"my","name":"$number_of_families","containerName":"_population_error","localvar":"my","kind":13,"line":545},{"name":"$input_block","kind":13,"containerName":"_population_error","line":545},{"line":547,"name":"$pf","localvar":"my","kind":13,"containerName":"_population_error","definition":"my"},{"line":548,"localvar":"my","containerName":"_population_error","kind":13,"name":"$frequency","definition":"my"},{"definition":"my","line":549,"name":"$p_f_length","localvar":"my","containerName":"_population_error","kind":13},{"kind":13,"containerName":"_population_error","name":"$pf","line":562},{"name":"$pf","containerName":"_population_error","kind":13,"line":562},{"name":"$pop_freq","containerName":"_population_error","kind":13,"line":562},{"line":562,"containerName":"_population_error","kind":13,"name":"$pf"},{"line":563,"containerName":"_population_error","kind":13,"name":"$frequency"},{"name":"$pop_freq","kind":13,"containerName":"_population_error","line":563},{"line":563,"containerName":"_population_error","kind":13,"name":"$pf"},{"line":565,"kind":13,"containerName":"_population_error","name":"$pop_freq"},{"kind":13,"containerName":"_population_error","name":"$pf","line":565},{"kind":13,"containerName":"_population_error","name":"$p_f_length","line":566},{"kind":13,"containerName":"_population_error","name":"$pop_freq","line":566},{"line":566,"containerName":"_population_error","kind":13,"name":"$pf"},{"line":567,"name":"$pop_freq_elements_error","kind":13,"containerName":"_population_error"}],"containerName":"main::","name":"_population_error","definition":"sub"},{"line":578,"name":"%frequency","containerName":null,"kind":13},{"line":579,"containerName":null,"kind":13,"name":"$self"},{"line":579,"containerName":"main::","kind":12,"name":"warn"},{"line":583,"kind":13,"containerName":null,"name":"%pop_freq_elements_error"},{"line":584,"kind":13,"containerName":null,"name":"$self"},{"line":584,"name":"throw","kind":12,"containerName":"main::"},{"kind":13,"containerName":null,"name":"$pf","line":585},{"line":595,"name":"$pf","containerName":null,"kind":13},{"name":"%number_of_families","containerName":null,"kind":13,"line":595},{"containerName":null,"kind":13,"name":"$self","line":596},{"line":596,"name":"throw","containerName":"main::","kind":12},{"line":615,"range":{"start":{"character":0,"line":615},"end":{"character":9999,"line":697}},"kind":12,"children":[{"definition":"my","line":618,"localvar":"my","containerName":"_do_it","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"_do_it","line":621},{"kind":13,"containerName":"_do_it","name":"$self","line":622},{"name":"$self","kind":13,"containerName":"_do_it","line":622},{"line":622,"containerName":"_do_it","kind":12,"name":"pattern_freq"},{"kind":13,"containerName":"_do_it","name":"$self","line":623},{"line":624,"name":"$self","kind":13,"containerName":"_do_it"},{"line":625,"kind":13,"containerName":"_do_it","name":"$self"},{"line":626,"name":"$self","containerName":"_do_it","kind":13},{"name":"$self","kind":13,"containerName":"_do_it","line":627},{"line":628,"kind":13,"containerName":"_do_it","name":"$self"},{"line":629,"name":"$self","containerName":"_do_it","kind":13},{"kind":13,"containerName":"_do_it","name":"$self","line":633},{"name":"$self","containerName":"_do_it","kind":13,"line":633},{"line":633,"name":"snp_ids","containerName":"_do_it","kind":12},{"line":634,"name":"$self","kind":13,"containerName":"_do_it"},{"name":"$self","containerName":"_do_it","kind":13,"line":635},{"line":638,"kind":13,"containerName":"_do_it","name":"$self"},{"line":642,"name":"$self","containerName":"_do_it","kind":13},{"line":648,"kind":13,"containerName":"_do_it","name":"$self"},{"line":656,"kind":13,"containerName":"_do_it","name":"$self"},{"name":"$self","kind":13,"containerName":"_do_it","line":672},{"definition":"my","line":696,"name":"@tmp","localvar":"my","containerName":"_do_it","kind":13},{"line":696,"name":"$a","containerName":"_do_it","kind":13},{"name":"$b","containerName":"_do_it","kind":13,"line":696},{"kind":13,"containerName":"_do_it","name":"$self","line":697}],"name":"_do_it","containerName":"main::","definition":"sub"},{"kind":12,"name":"dclone","line":622},{"name":"snp_type","kind":12,"line":633},{"kind":12,"name":"useful_snp","line":633},{"kind":12,"name":"dclone","line":633},{"kind":12,"name":"snp_type","line":634},{"name":"deg_snp","kind":12,"line":634},{"name":"snp_type","kind":12,"line":635},{"name":"silent_snp","kind":12,"line":635},{"kind":12,"name":"_split_haplo","line":638},{"kind":12,"name":"_to_upper_case","line":642},{"name":"w_hap","kind":12,"line":642},{"line":648,"kind":12,"name":"_remove_deg"},{"name":"_rem_silent_snp","kind":12,"line":656},{"line":672,"name":"_find_deg_pattern","kind":12},{"line":697,"name":"deg_pattern","kind":12},{"line":702,"kind":12,"name":"tmp"},{"name":"%self","kind":13,"containerName":null,"line":702},{"line":702,"name":"w_hap","kind":12},{"name":"_keep_these_patterns","kind":12,"line":703},{"line":703,"name":"%self","containerName":null,"kind":13},{"line":703,"name":"w_hap","kind":12},{"line":703,"kind":13,"containerName":null,"name":"@tmp"},{"line":704,"kind":12,"name":"_keep_these_patterns"},{"line":704,"containerName":null,"kind":13,"name":"%self"},{"line":704,"name":"w_pop_freq","kind":12},{"name":"@tmp","kind":13,"containerName":null,"line":704},{"kind":12,"name":"_alleles_number","line":720},{"name":"$self","kind":13,"containerName":null,"line":720},{"line":739,"kind":12,"name":"_convert_to_numbers"},{"line":739,"name":"$self","containerName":null,"kind":13},{"line":747,"name":"_snp_type_code","kind":12},{"containerName":null,"kind":13,"name":"$self","line":747},{"line":754,"name":"_htSNP","kind":12},{"name":"$self","kind":13,"containerName":null,"line":754},{"line":765,"name":"_snp_and_code_summary","kind":12},{"containerName":null,"kind":13,"name":"$self","line":765},{"line":780,"range":{"end":{"line":785,"character":9999},"start":{"character":0,"line":780}},"kind":12,"children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"input_block","line":783},{"line":784,"containerName":"input_block","kind":13,"name":"$self"}],"name":"input_block","containerName":"main::","definition":"sub"},{"line":784,"kind":12,"name":"input_block"},{"line":799,"range":{"start":{"character":0,"line":799},"end":{"character":9999,"line":803}},"kind":12,"children":[{"definition":"my","line":802,"localvar":"my","containerName":"hap_length","kind":13,"name":"$self"},{"line":803,"name":"$self","containerName":"hap_length","kind":13}],"name":"hap_length","containerName":"main::","definition":"sub"},{"range":{"start":{"character":0,"line":819},"end":{"character":9999,"line":824}},"kind":12,"line":819,"definition":"sub","containerName":"main::","name":"pop_freq","children":[{"name":"$self","containerName":"pop_freq","localvar":"my","kind":13,"line":822,"definition":"my"},{"name":"$self","containerName":"pop_freq","kind":13,"line":823}]},{"kind":12,"name":"pop_freq","line":823},{"line":840,"kind":12,"range":{"start":{"line":840,"character":0},"end":{"line":844,"character":9999}},"children":[{"kind":13,"localvar":"my","containerName":"deg_snp","name":"$self","line":842,"definition":"my"},{"line":843,"kind":13,"containerName":"deg_snp","name":"$self"}],"containerName":"main::","name":"deg_snp","definition":"sub"},{"kind":12,"name":"snp_type","line":843},{"line":843,"name":"deg_snp","kind":12},{"line":860,"range":{"end":{"character":9999,"line":864},"start":{"line":860,"character":0}},"kind":12,"definition":"sub","children":[{"localvar":"my","kind":13,"containerName":"snp_type","name":"$self","line":862,"definition":"my"},{"name":"$self","containerName":"snp_type","kind":13,"line":863}],"containerName":"main::","name":"snp_type"},{"kind":12,"name":"snp_type","line":863},{"definition":"sub","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"silent_snp","kind":13,"line":883},{"name":"$self","containerName":"silent_snp","kind":13,"line":884}],"containerName":"main::","name":"silent_snp","line":881,"range":{"end":{"character":9999,"line":885},"start":{"character":0,"line":881}},"kind":12},{"name":"snp_type","kind":12,"line":884},{"kind":12,"name":"silent_snp","line":884},{"definition":"sub","children":[{"definition":"my","line":905,"kind":13,"localvar":"my","containerName":"useful_snp","name":"$self"},{"line":906,"name":"$self","kind":13,"containerName":"useful_snp"}],"containerName":"main::","name":"useful_snp","line":903,"kind":12,"range":{"end":{"line":907,"character":9999},"start":{"line":903,"character":0}}},{"name":"snp_type","kind":12,"line":906},{"line":906,"kind":12,"name":"useful_snp"},{"containerName":"main::","name":"ht_type","children":[{"definition":"my","line":927,"containerName":"ht_type","localvar":"my","kind":13,"name":"$self"},{"line":928,"name":"$self","containerName":"ht_type","kind":13}],"definition":"sub","range":{"end":{"character":9999,"line":929},"start":{"character":0,"line":925}},"kind":12,"line":925},{"line":928,"name":"ht_type","kind":12},{"definition":"sub","containerName":"main::","name":"ht_set","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"ht_set","kind":13,"line":948},{"line":949,"containerName":"ht_set","kind":13,"name":"$self"}],"range":{"start":{"line":946,"character":0},"end":{"character":9999,"line":950}},"kind":12,"line":946},{"name":"w_hap","kind":12,"line":949},{"line":966,"range":{"start":{"character":0,"line":966},"end":{"line":970,"character":9999}},"kind":12,"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"snp_type_code","line":968,"definition":"my"},{"name":"$self","kind":13,"containerName":"snp_type_code","line":969}],"name":"snp_type_code","containerName":"main::"},{"line":969,"kind":12,"name":"snp_type_code"},{"line":988,"range":{"end":{"character":9999,"line":992},"start":{"character":0,"line":988}},"kind":12,"definition":"sub","children":[{"definition":"my","line":990,"containerName":"snp_and_code","localvar":"my","kind":13,"name":"$self"},{"name":"$self","containerName":"snp_and_code","kind":13,"line":991}],"containerName":"main::","name":"snp_and_code"},{"definition":"sub","containerName":"main::","name":"deg_pattern","children":[{"definition":"my","line":1012,"name":"$self","localvar":"my","containerName":"deg_pattern","kind":13},{"line":1014,"kind":13,"containerName":"deg_pattern","name":"$self"}],"kind":12,"range":{"end":{"line":1015,"character":9999},"start":{"character":0,"line":1010}},"line":1010},{"range":{"start":{"character":0,"line":1031},"end":{"character":9999,"line":1035}},"kind":12,"line":1031,"definition":"sub","containerName":"main::","name":"split_hap","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"split_hap","line":1033},{"containerName":"split_hap","kind":13,"name":"$self","line":1034}]},{"line":1049,"range":{"end":{"line":1062,"character":9999},"start":{"line":1049,"character":0}},"kind":12,"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_split_haplo","line":1051},{"line":1053,"localvar":"my","containerName":"_split_haplo","kind":13,"name":"$in","definition":"my"},{"line":1053,"kind":13,"containerName":"_split_haplo","name":"$self"},{"line":1054,"localvar":"my","containerName":"_split_haplo","kind":13,"name":"$out","definition":"my"},{"kind":13,"containerName":"_split_haplo","name":"$self","line":1054},{"line":1057,"kind":13,"containerName":"_split_haplo","name":"$in"},{"kind":13,"containerName":"_split_haplo","name":"$out","line":1058},{"line":1061,"containerName":"_split_haplo","kind":13,"name":"$self"},{"line":1061,"name":"$out","kind":13,"containerName":"_split_haplo"}],"containerName":"main::","name":"_split_haplo","definition":"sub"},{"kind":12,"name":"dclone","line":1061},{"detail":"($arr)","definition":"sub","name":"_to_upper_case","containerName":"main::","children":[{"line":1082,"name":"$arr","localvar":"my","containerName":"_to_upper_case","kind":13,"definition":"my"},{"kind":13,"localvar":"my","containerName":"_to_upper_case","name":"$aref","line":1084,"definition":"my"},{"line":1084,"name":"$arr","containerName":"_to_upper_case","kind":13},{"definition":"my","name":"$value","containerName":"_to_upper_case","localvar":"my","kind":13,"line":1085},{"line":1085,"name":"$aref","containerName":"_to_upper_case","kind":13},{"containerName":"_to_upper_case","kind":13,"name":"$value","line":1086},{"containerName":"_to_upper_case","kind":13,"name":"$value","line":1086}],"signature":{"label":"_to_upper_case($arr)","documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private","parameters":[{"label":"$arr"}]},"kind":12,"range":{"start":{"character":0,"line":1080},"end":{"character":9999,"line":1088}},"line":1080},{"children":[{"line":1108,"name":"$self","kind":13,"localvar":"my","containerName":"_remove_deg","definition":"my"},{"definition":"my","containerName":"_remove_deg","localvar":"my","kind":13,"name":"$hap","line":1110},{"line":1110,"kind":13,"containerName":"_remove_deg","name":"$self"},{"definition":"my","containerName":"_remove_deg","localvar":"my","kind":13,"name":"$snp","line":1111},{"line":1111,"name":"$self","kind":13,"containerName":"_remove_deg"},{"definition":"my","name":"$deg_snp","kind":13,"localvar":"my","containerName":"_remove_deg","line":1112},{"line":1112,"name":"$self","containerName":"_remove_deg","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"_remove_deg","name":"$rem","line":1114},{"line":1117,"containerName":"_remove_deg","kind":13,"name":"$rem"},{"containerName":"_remove_deg","kind":13,"name":"$hap","line":1117},{"name":"$rem","kind":13,"containerName":"_remove_deg","line":1117},{"line":1119,"name":"$rem","kind":13,"containerName":"_remove_deg"},{"line":1122,"containerName":"_remove_deg","kind":13,"name":"$hap"},{"name":"$rem","containerName":"_remove_deg","kind":13,"line":1122},{"name":"$snp","kind":13,"containerName":"_remove_deg","line":1125},{"name":"$deg_snp","kind":13,"containerName":"_remove_deg","line":1125},{"line":1125,"name":"$rem","containerName":"_remove_deg","kind":13}],"name":"_remove_deg","containerName":"main::","definition":"sub","line":1106,"range":{"start":{"line":1106,"character":0},"end":{"character":9999,"line":1127}},"kind":12},{"name":"w_hap","kind":12,"line":1110},{"line":1111,"name":"snp_type","kind":12},{"line":1111,"kind":12,"name":"useful_snp"},{"name":"snp_type","kind":12,"line":1112},{"line":1112,"kind":12,"name":"deg_snp"},{"kind":12,"name":"_find_indet","line":1117},{"name":"_remove_col","kind":12,"line":1122},{"kind":12,"name":"_remove_snp_id","line":1125},{"definition":"sub","containerName":"main::","name":"_rem_silent_snp","children":[{"line":1147,"containerName":"_rem_silent_snp","localvar":"my","kind":13,"name":"$self","definition":"my"},{"definition":"my","name":"$hap","localvar":"my","kind":13,"containerName":"_rem_silent_snp","line":1149},{"line":1149,"kind":13,"containerName":"_rem_silent_snp","name":"$self"},{"line":1150,"kind":13,"localvar":"my","containerName":"_rem_silent_snp","name":"$snp","definition":"my"},{"name":"$self","containerName":"_rem_silent_snp","kind":13,"line":1150},{"definition":"my","name":"$silent_snp","kind":13,"localvar":"my","containerName":"_rem_silent_snp","line":1151},{"line":1151,"containerName":"_rem_silent_snp","kind":13,"name":"$self"},{"definition":"my","localvar":"my","kind":13,"containerName":"_rem_silent_snp","name":"$rem","line":1153},{"line":1156,"containerName":"_rem_silent_snp","kind":13,"name":"$rem"},{"line":1156,"name":"$hap","containerName":"_rem_silent_snp","kind":13},{"containerName":"_rem_silent_snp","kind":13,"name":"$rem","line":1158},{"line":1161,"name":"$hap","containerName":"_rem_silent_snp","kind":13},{"line":1161,"containerName":"_rem_silent_snp","kind":13,"name":"$rem"},{"containerName":"_rem_silent_snp","kind":13,"name":"$snp","line":1164},{"line":1164,"name":"$silent_snp","containerName":"_rem_silent_snp","kind":13},{"containerName":"_rem_silent_snp","kind":13,"name":"$rem","line":1164}],"kind":12,"range":{"start":{"character":0,"line":1145},"end":{"line":1166,"character":9999}},"line":1145},{"line":1149,"kind":12,"name":"w_hap"},{"line":1150,"kind":12,"name":"snp_type"},{"kind":12,"name":"useful_snp","line":1150},{"line":1151,"kind":12,"name":"snp_type"},{"name":"silent_snp","kind":12,"line":1151},{"line":1156,"kind":12,"name":"_find_silent_snps"},{"kind":12,"name":"_remove_col","line":1161},{"line":1164,"name":"_remove_snp_id","kind":12},{"line":1184,"range":{"end":{"line":1192,"character":9999},"start":{"line":1184,"character":0}},"kind":12,"signature":{"label":"_find_silent_snps($arr)","documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :","parameters":[{"label":"$arr"}]},"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_find_silent_snps","name":"$arr","line":1186},{"name":"$list","localvar":"my","kind":13,"containerName":"_find_silent_snps","line":1188,"definition":"my"},{"definition":"my","line":1192,"containerName":"_find_silent_snps","localvar":"my","kind":13,"name":"$colsn"},{"line":1192,"name":"$arr","kind":13,"containerName":"_find_silent_snps"}],"name":"_find_silent_snps","containerName":"main::","definition":"sub","detail":"($arr)"},{"definition":"my","line":1194,"name":"$i","localvar":"my","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$i","line":1194},{"line":1194,"name":"$colsn","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%i","line":1194},{"definition":"my","line":1195,"name":"$different","localvar":"my","containerName":null,"kind":13},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$r","line":1197},{"line":1197,"kind":13,"containerName":null,"name":"%arr"},{"line":1198,"containerName":null,"kind":13,"name":"@arr"},{"name":"$i","containerName":null,"kind":13,"line":1198},{"kind":13,"containerName":null,"name":"@arr","line":1198},{"kind":13,"containerName":null,"name":"@r","line":1198},{"name":"%i","containerName":null,"kind":13,"line":1198},{"name":"$different","containerName":null,"kind":13,"line":1199},{"line":1204,"containerName":null,"kind":13,"name":"%different"},{"kind":13,"containerName":null,"name":"$list","line":1205},{"name":"$i","containerName":null,"kind":13,"line":1205},{"name":"$list","containerName":null,"kind":13,"line":1209},{"signature":{"label":"_find_indet($arr,$list)","parameters":[{"label":"$arr"},{"label":"$list"}],"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal"},"range":{"end":{"line":1249,"character":9999},"start":{"line":1227,"character":0}},"kind":12,"line":1227,"detail":"($arr,$list)","definition":"sub","name":"_find_indet","containerName":"main::","children":[{"definition":"my","name":"$arr","localvar":"my","kind":13,"containerName":"_find_indet","line":1229},{"line":1229,"name":"$list","kind":13,"containerName":"_find_indet"},{"kind":13,"localvar":"my","containerName":"_find_indet","name":"$i","line":1231,"definition":"my"},{"line":1231,"kind":13,"containerName":"_find_indet","name":"$arr"},{"name":"$j","localvar":"my","kind":13,"containerName":"_find_indet","line":1232,"definition":"my"},{"line":1232,"containerName":"_find_indet","kind":13,"name":"$arr"},{"name":"$i","kind":13,"containerName":"_find_indet","line":1232},{"kind":13,"containerName":"_find_indet","name":"$arr","line":1233},{"kind":13,"containerName":"_find_indet","name":"$i","line":1233},{"line":1233,"containerName":"_find_indet","kind":13,"name":"$j"},{"line":1234,"name":"$list","containerName":"_find_indet","kind":13},{"line":1235,"name":"$list","containerName":"_find_indet","kind":13},{"containerName":"_find_indet","kind":13,"name":"$j","line":1235},{"definition":"my","name":"$found","localvar":"my","kind":13,"containerName":"_find_indet","line":1238},{"definition":"my","name":"$k","containerName":"_find_indet","localvar":"my","kind":13,"line":1239},{"name":"$list","containerName":"_find_indet","kind":13,"line":1239},{"name":"$found","kind":13,"containerName":"_find_indet","line":1240},{"line":1240,"name":"$list","containerName":"_find_indet","kind":13},{"name":"$k","kind":13,"containerName":"_find_indet","line":1240},{"name":"$j","containerName":"_find_indet","kind":13,"line":1240},{"line":1241,"containerName":"_find_indet","kind":13,"name":"$found"},{"line":1243,"name":"$found","containerName":"_find_indet","kind":13},{"containerName":"_find_indet","kind":13,"name":"$list","line":1244},{"line":1244,"containerName":"_find_indet","kind":13,"name":"$j"}]},{"line":1251,"name":"%list","kind":13,"containerName":null},{"line":1251,"name":"$a","containerName":null,"kind":13},{"line":1251,"name":"$b","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$list","line":1251},{"line":1253,"name":"$list","containerName":null,"kind":13},{"children":[{"definition":"my","line":1271,"kind":13,"localvar":"my","containerName":"_remove_col","name":"$arr"},{"name":"$rem","containerName":"_remove_col","kind":13,"line":1271},{"definition":"my","localvar":"my","kind":13,"containerName":"_remove_col","name":"$col","line":1273},{"kind":13,"containerName":"_remove_col","name":"$rem","line":1273},{"line":1274,"name":"$_","containerName":"_remove_col","kind":13},{"line":1274,"kind":13,"containerName":"_remove_col","name":"$col"},{"name":"$arr","containerName":"_remove_col","kind":13,"line":1274}],"name":"_remove_col","containerName":"main::","definition":"sub","detail":"($arr,$rem)","line":1269,"range":{"start":{"line":1269,"character":0},"end":{"line":1276,"character":9999}},"kind":12,"signature":{"label":"_remove_col($arr,$rem)","documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal\n\n\n#------------------------\nsub _find_indet{\n#------------------------\n    my ($arr, $list)=@_;\n\n    foreach my $i(0..$#$arr){\n        foreach my $j(0..$#{$arr->[$i]}){\n            unless ($arr->[$i][$j] =~ /[ACTG-]/){\n                if ($#$list<0){\n                    push(@$list,$j);\n                }\n                else{\n                    my $found =0;   # check if already exist the value\n                    foreach my $k(0..$#$list){\n                        $found =1 if ($list->[$k] eq $j);\n                        last if ($found);\n                    }\n                    if(!$found){\n                        push(@$list,$j);\n                    }\n                }\n            }\n        }\n    }\n\n    @$list = sort { $a <=> $b} @$list;\n\n    return $list;\n}\n\n=head2 _remove_col\n\n Title   : _remove_col\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal","parameters":[{"label":"$arr"},{"label":"$rem"}]}},{"signature":{"label":"_remove_snp_id($arr,$removed,$rem_list)","parameters":[{"label":"$arr"},{"label":"$removed"},{"label":"$rem_list"}],"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal\n\n\n#------------------------\nsub _find_indet{\n#------------------------\n    my ($arr, $list)=@_;\n\n    foreach my $i(0..$#$arr){\n        foreach my $j(0..$#{$arr->[$i]}){\n            unless ($arr->[$i][$j] =~ /[ACTG-]/){\n                if ($#$list<0){\n                    push(@$list,$j);\n                }\n                else{\n                    my $found =0;   # check if already exist the value\n                    foreach my $k(0..$#$list){\n                        $found =1 if ($list->[$k] eq $j);\n                        last if ($found);\n                    }\n                    if(!$found){\n                        push(@$list,$j);\n                    }\n                }\n            }\n        }\n    }\n\n    @$list = sort { $a <=> $b} @$list;\n\n    return $list;\n}\n\n=head2 _remove_col\n\n Title   : _remove_col\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_col{\n#------------------------\n    my ($arr,$rem)=@_;\n\n    foreach my $col (reverse @$rem){\n        splice @$_, $col, 1 for @$arr;\n    }\n}\n\n\n=head2 _remove_snp_id\n\n Title   : _remove_snp_id\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal"},"range":{"start":{"character":0,"line":1292},"end":{"line":1297,"character":9999}},"kind":12,"line":1292,"detail":"($arr,$removed,$rem_list)","definition":"sub","name":"_remove_snp_id","containerName":"main::","children":[{"definition":"my","containerName":"_remove_snp_id","localvar":"my","kind":13,"name":"$arr","line":1294},{"name":"$removed","containerName":"_remove_snp_id","kind":13,"line":1294},{"line":1294,"containerName":"_remove_snp_id","kind":13,"name":"$rem_list"},{"name":"$removed","kind":13,"containerName":"_remove_snp_id","line":1296},{"containerName":"_remove_snp_id","kind":13,"name":"$arr","line":1296},{"line":1296,"containerName":"_remove_snp_id","kind":13,"name":"$rem_list"}]},{"range":{"end":{"character":9999,"line":1339},"start":{"line":1312,"character":0}},"kind":12,"line":1312,"definition":"sub","name":"_find_deg_pattern","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"_find_deg_pattern","kind":13,"line":1314,"definition":"my"},{"definition":"my","containerName":"_find_deg_pattern","localvar":"my","kind":13,"name":"$arr","line":1316},{"line":1316,"name":"$self","kind":13,"containerName":"_find_deg_pattern"},{"line":1317,"name":"$list","kind":13,"localvar":"my","containerName":"_find_deg_pattern","definition":"my"},{"containerName":"_find_deg_pattern","kind":13,"name":"$self","line":1317},{"definition":"my","line":1320,"kind":13,"localvar":"my","containerName":"_find_deg_pattern","name":"$i"},{"name":"$arr","containerName":"_find_deg_pattern","kind":13,"line":1320},{"line":1322,"name":"$list","containerName":"_find_deg_pattern","kind":13},{"name":"$i","containerName":"_find_deg_pattern","kind":13,"line":1322},{"line":1323,"name":"$list","containerName":"_find_deg_pattern","kind":13},{"containerName":"_find_deg_pattern","kind":13,"name":"$i","line":1323},{"line":1323,"containerName":"_find_deg_pattern","kind":13,"name":"$i"},{"line":1326,"localvar":"my","containerName":"_find_deg_pattern","kind":13,"name":"$j","definition":"my"},{"line":1326,"name":"$i","containerName":"_find_deg_pattern","kind":13},{"kind":13,"containerName":"_find_deg_pattern","name":"$arr","line":1326},{"definition":"my","name":"$comp","localvar":"my","containerName":"_find_deg_pattern","kind":13,"line":1327},{"line":1327,"containerName":"_find_deg_pattern","kind":13,"name":"$arr"},{"name":"$i","kind":13,"containerName":"_find_deg_pattern","line":1327},{"name":"$arr","containerName":"_find_deg_pattern","kind":13,"line":1327},{"name":"$j","kind":13,"containerName":"_find_deg_pattern","line":1327},{"line":1329,"kind":13,"containerName":"_find_deg_pattern","name":"$comp"},{"definition":"my","kind":13,"localvar":"my","containerName":"_find_deg_pattern","name":"$key","line":1332},{"containerName":"_find_deg_pattern","kind":13,"name":"$list","line":1332},{"line":1332,"containerName":"_find_deg_pattern","kind":13,"name":"$i"},{"name":"$list","containerName":"_find_deg_pattern","kind":13,"line":1334},{"name":"$key","kind":13,"containerName":"_find_deg_pattern","line":1334},{"name":"$j","containerName":"_find_deg_pattern","kind":13,"line":1334}]},{"name":"w_hap","kind":12,"line":1316},{"line":1322,"kind":12,"name":"_is_on_hash"},{"name":"compare_arrays","kind":12,"line":1327},{"line":1332,"name":"_key_for_value","kind":12},{"line":1344,"range":{"end":{"character":9999,"line":1352},"start":{"line":1344,"character":0}},"kind":12,"signature":{"documentation":"","parameters":[{"label":"$hash"},{"label":"$value"}],"label":"_key_for_value($hash,$value)"},"children":[{"definition":"my","name":"$hash","localvar":"my","kind":13,"containerName":"_key_for_value","line":1346},{"name":"$value","kind":13,"containerName":"_key_for_value","line":1346},{"definition":"my","name":"$key","containerName":"_key_for_value","localvar":"my","kind":13,"line":1348},{"line":1348,"containerName":"_key_for_value","kind":13,"name":"$hash"},{"containerName":"_key_for_value","kind":13,"name":"$hash","line":1349},{"line":1349,"name":"$key","kind":13,"containerName":"_key_for_value"},{"line":1349,"name":"$value","containerName":"_key_for_value","kind":13},{"line":1350,"name":"$key","kind":13,"containerName":"_key_for_value"}],"name":"_key_for_value","containerName":"main::","definition":"sub","detail":"($hash,$value)"},{"line":1349,"name":"_is_there","kind":12},{"line":1356,"kind":12,"range":{"start":{"line":1356,"character":0},"end":{"character":9999,"line":1364}},"signature":{"parameters":[{"label":"$hash"},{"label":"$value"}],"documentation":"","label":"_is_on_hash($hash,$value)"},"children":[{"definition":"my","localvar":"my","containerName":"_is_on_hash","kind":13,"name":"$hash","line":1358},{"kind":13,"containerName":"_is_on_hash","name":"$value","line":1358},{"definition":"my","line":1360,"name":"$key","localvar":"my","kind":13,"containerName":"_is_on_hash"},{"containerName":"_is_on_hash","kind":13,"name":"$hash","line":1360},{"line":1361,"containerName":"_is_on_hash","kind":13,"name":"$hash"},{"line":1361,"name":"$key","kind":13,"containerName":"_is_on_hash"},{"line":1361,"containerName":"_is_on_hash","kind":13,"name":"$value"}],"name":"_is_on_hash","containerName":"main::","definition":"sub","detail":"($hash,$value)"},{"line":1361,"kind":12,"name":"_is_there"},{"children":[{"line":1371,"name":"$arr","kind":13,"localvar":"my","containerName":"_is_there","definition":"my"},{"line":1371,"kind":13,"containerName":"_is_there","name":"$value"},{"line":1373,"name":"$el","localvar":"my","kind":13,"containerName":"_is_there","definition":"my"},{"line":1373,"name":"$arr","containerName":"_is_there","kind":13},{"kind":13,"containerName":"_is_there","name":"$el","line":1374}],"name":"_is_there","containerName":"main::","definition":"sub","detail":"($arr,$value)","line":1368,"range":{"end":{"line":1378,"character":9999},"start":{"character":0,"line":1368}},"kind":12,"signature":{"parameters":[{"label":"$arr"},{"label":"$value"}],"documentation":"","label":"_is_there($arr,$value)"}},{"name":"value","kind":12,"line":1374},{"signature":{"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal\n\n\n#------------------------\nsub _find_indet{\n#------------------------\n    my ($arr, $list)=@_;\n\n    foreach my $i(0..$#$arr){\n        foreach my $j(0..$#{$arr->[$i]}){\n            unless ($arr->[$i][$j] =~ /[ACTG-]/){\n                if ($#$list<0){\n                    push(@$list,$j);\n                }\n                else{\n                    my $found =0;   # check if already exist the value\n                    foreach my $k(0..$#$list){\n                        $found =1 if ($list->[$k] eq $j);\n                        last if ($found);\n                    }\n                    if(!$found){\n                        push(@$list,$j);\n                    }\n                }\n            }\n        }\n    }\n\n    @$list = sort { $a <=> $b} @$list;\n\n    return $list;\n}\n\n=head2 _remove_col\n\n Title   : _remove_col\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_col{\n#------------------------\n    my ($arr,$rem)=@_;\n\n    foreach my $col (reverse @$rem){\n        splice @$_, $col, 1 for @$arr;\n    }\n}\n\n\n=head2 _remove_snp_id\n\n Title   : _remove_snp_id\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_snp_id{\n#------------------------\n    my ($arr,$removed,$rem_list)=@_;\n\n    push @$removed, splice @$arr, $_, 1 foreach reverse @$rem_list;\n}\n\n\n=head2 _find_deg_pattern\n\n Title   : _find_deg_pattern\n Usage   :\n Function: create a list with the degenerated patterns\n Returns : @array\n Args    : a ref to AoA\n Status  : public\n\n\n#------------------------\nsub _find_deg_pattern{\n#------------------------\n    my $self  = shift;\n\n    my $arr   = $self ->{w_hap};          # the working haplotype\n    my $list  = $self ->{'deg_pattern'};  # degenerated patterns \n\n    # we have to check all elements\n    foreach my $i(0..$#$arr){\n        # is the element has not been used create a key\n        unless  ( _is_on_hash ($list,\\$i) ) {\n            $list->{$i}=[$i];\n        };\n\n        foreach my $j($i+1..$#$arr){\n            my $comp = compare_arrays($arr->[$i],$arr->[$j]);\n\n            if($comp){\n                # as we have no elements we push this into the list\n                # check for the first element\n                my $key = _key_for_value($list,\\$i);\n\n                push (@{$list->{$key}},$j);\n\n                last;\n            }\n        }\n    }\n\n}\n\n#------------------------\nsub _key_for_value{\n#------------------------\n    my($hash,$value)=@_;\n\n    foreach my $key (keys %$hash){\n        if( _is_there(\\@{$hash->{$key}},$value)){\n            return $key;\n        }\n    }\n}\n\n#------------------------\nsub _is_on_hash{\n#------------------------\n    my($hash,$value)=@_;\n\n    foreach my $key (keys %$hash){\n        if( _is_there(\\@{$hash->{$key}},$value)){\n            return 1;\n        }\n    }\n}\n\n#------------------------\nsub _is_there{\n#------------------------\n\n    my($arr,$value)=@_;\n\n    foreach my $el (@$arr){\n        if ($el eq $$value){\n            return 1;\n        }\n    }\n}\n\n\n=head2 _keep_these_patterns\n\n\n Title   : _keep_these_patterns\n Usage   :\n Function: this is a basic approach, take a LoL and a list,\n           keep just the columns included on the list\n Returns : nothing\n Args    : an AoA and an array\n Status  : public","parameters":[{"label":"$arr"},{"label":"$list"}],"label":"_keep_these_patterns($arr,$list)"},"kind":12,"range":{"end":{"line":1409,"character":9999},"start":{"character":0,"line":1395}},"line":1395,"detail":"($arr,$list)","definition":"sub","name":"_keep_these_patterns","containerName":"main::","children":[{"containerName":"_keep_these_patterns","localvar":"my","kind":13,"name":"$arr","line":1397,"definition":"my"},{"line":1397,"name":"$list","kind":13,"containerName":"_keep_these_patterns"},{"line":1402,"name":"@outValues","localvar":"my","kind":13,"containerName":"_keep_these_patterns","definition":"my"},{"definition":"my","line":1404,"name":"$k","localvar":"my","kind":13,"containerName":"_keep_these_patterns"},{"name":"$list","containerName":"_keep_these_patterns","kind":13,"line":1404},{"line":1405,"containerName":"_keep_these_patterns","kind":13,"name":"@outValues"},{"name":"$arr","kind":13,"containerName":"_keep_these_patterns","line":1405},{"line":1405,"name":"$k","kind":13,"containerName":"_keep_these_patterns"},{"kind":13,"containerName":"_keep_these_patterns","name":"$arr","line":1409},{"name":"@outValues","containerName":"_keep_these_patterns","kind":13,"line":1409}]},{"name":"dclone","kind":12,"line":1409},{"line":1428,"kind":12,"range":{"start":{"line":1428,"character":0},"end":{"line":1436,"character":9999}},"signature":{"label":"compare_arrays($first,$second)","parameters":[{"label":"$first"},{"label":"$second"}],"documentation":"1;\n# module Bio::PopGen::HtSNP.pm\n# cared by Pedro M. Gomez-Fabre <pgf18872-at-gsk-dot-com>\n#\n#\n\n=head1 NAME\n\nBio::PopGen::HtSNP.pm- Select htSNP from a haplotype set\n\n=head1 SYNOPSIS\n\n    use Bio::PopGen::HtSNP;\n\n    my $obj = Bio::PopGen::HtSNP->new($hap,$snp,$pop);\n\n=head1 DESCRIPTION\n\nSelect the minimal set of SNP that contains the full information about\nthe haplotype without redundancies.\n\nTake as input the followin values:\n\n=over 4\n\n* - the haplotype block (array of array).\n\n* - the snp id (array).\n\n* - family information and frequency (array of array).\n\n\nThe final haplotype is generated in a numerical format and the SNP's\nsets can be retrieve from the module.\n\nB<considerations:>\n\n\n- If you force to include a family with indetermination, the SNP's\nwith indetermination will be removed from the analysis, so consider\nbefore to place your data set what do you really want to do.\n\n- If two families have the same information (identical haplotype), one\nof them will be removed and the removed files will be stored classify\nas removed.\n\n- Only are accepted for calculation A, C, G, T and - (as deletion) and\ntheir combinations. Any other value as n or ? will be considered as\ndegenerations due to lack of information.\n\n=head2 RATIONALE\n\nOn a haplotype set is expected that some of the SNP and their\nvariations contribute in the same way to the haplotype. Eliminating\nredundancies will produce a minimal set of SNP's that can be used as\ninput for a taging selection process. On the process SNP's with the\nsame variation are clustered on the same group.\n\nThe idea is that because the tagging haplotype process is\nexponential. All redundant information we could eliminate on the\ntagging process will help to find a quick result.\n\n=head2 CONSTRUCTORS\n\n  my $obj = Bio::PopGen::HtSNP->new\n    (-haplotype_block => \\@haplotype_patterns,\n     -snp_ids         => \\@snp_ids,\n     -pattern_freq    => \\@pattern_name_and_freq);\n\nwhere  $hap, $snp and $pop are in the format:\n\n  my $hap = [\n             'acgt',\n             'agtc',\n             'cgtc'\n            ];                     # haplotype patterns' id\n\n  my $snp = [qw/s1 s2 s3 s4/];     # snps' Id's\n\n  my $pop = [\n             [qw/ uno    0.20/],\n             [qw/ dos    0.20/],\n             [qw/ tres   0.15/],\n            ];                     # haplotype_pattern_id    Frequency\n\n=head2 OBJECT METHODS\n\n    See Below for more detailed summaries.\n\n\n=head1 DETAILS\n\n=head2 How the process is working with one example\n\nLet's begin with one general example of the code.\n\nInput haplotype:\n\n  acgtcca-t\n  cggtagtgc\n  cccccgtgc\n  cgctcgtgc\n\nThe first thing to to is to B<split the haplotype> into characters.\n\n  a       c       g       t       c       c       a       -       t\n  c       g       g       t       a       g       t       g       c\n  c       c       c       c       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n\nNow we have to B<convert> the haplotype to B<Upercase>. This\nwill produce the same SNP if we have input a or A.\n\n  A       C       G       T       C       C       A       -       T\n  C       G       G       T       A       G       T       G       C\n  C       C       C       C       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n\nThe program admit as values any combination of ACTG and - (deletions).\nThe haplotype is B<converted to number>, considering the first variation\nas zero and the alternate value as 1 (see expanded description below).\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n\nOnce we have the haplotype converted to numbers we have to generate the\nsnp type information for the haplotype.\n\n\nB<SNP code = SUM ( value * multiplicity ^ position );>\n\n    where:\n      SUM is the sum of the values for the SNP\n      value is the SNP number code (0 [generally for the mayor allele],\n                                    1 [for the minor allele].\n      position is the position on the block.\n\nFor this example the code is:\n\n  0       0       0       0       0       0       0       0       0\n  1       1       0       0       1       1       1       1       1\n  1       0       1       1       0       1       1       1       1\n  1       1       1       0       0       1       1       1       1\n ------------------------------------------------------------------\n  14      10      12      4       2       14      14      14      14\n\n  14 = 0*2^0 + 1*2^1 + 1*2^2 + 1*2^3\n  12 = 0*2^0 + 1*2^1 + 0*2^2 + 1*2^3\n  ....\n\nOnce we have the families classify. We will B<take> just the SNP's B<not\nredundant>.\n\n  14      10      12      4       2\n\nThis information will be B<passed to the tag module> is you want to tag\nthe htSNP.\n\nWhatever it happens to one SNPs of a class will happen to a SNP of\nthe same class. Therefore you don't need to scan redundancies\n\n=head2 Working with fuzzy data.\n\nThis module is designed to work with fuzzy data. As the source of the\nhaplotype is diverse. The program assume that some haplotypes can be\ngenerated using different values. If there is any indetermination (? or n)\nor any other degenerated value or invalid. The program will take away\nThis SNP and will leave that for a further analysis.\n\nOn a complex situation:\n\n  a       c       g       t       ?       c       a       c       t\n  a       c       g       t       ?       c       a       -       t\n  c       g       ?       t       a       g       ?       g       c\n  c       a       c       t       c       g       t       g       c\n  c       g       c       t       c       g       t       g       c\n  c       g       g       t       a       g       ?       g       c\n  a       c       ?       t       ?       c       a       c       t\n\nOn this haplotype everything is happening. We have a multialelic variance.\nWe have indeterminations. We have deletions and we have even one SNP\nwhich is not a real SNP.\n\nThe buiding process will be the same on this situation.\n\nConvert the haplotype to uppercase.\n\n  A       C       G       T       ?       C       A       C       T\n  A       C       G       T       ?       C       A       -       T\n  C       G       ?       T       A       G       ?       G       C\n  C       A       C       T       C       G       T       G       C\n  C       G       C       T       C       G       T       G       C\n  C       G       G       T       A       G       ?       G       C\n  A       C       ?       T       ?       C       A       C       T\n\nAll columns that present indeterminations will be removed from the analysis\non this Step.\n\nhapotype after remove columns:\n\n  A       C       T       C       C       T\n  A       C       T       C       -       T\n  C       G       T       G       G       C\n  C       A       T       G       G       C\n  C       G       T       G       G       C\n  C       G       T       G       G       C\n  A       C       T       C       C       T\n\nAll changes made on the haplotype matrix, will be also made on the SNP list.\n\n  snp_id_1 snp_id_2 snp_id_4 snp_id_6 snp_id_8 snp_id_9\n\nnow the SNP that is not one SNP will be removed from the analysis.\nSNP with Id snp_id_4 (the one with all T's).\n\n\nbecause of the removing. Some of the families will become the same and will\nbe clustered. A posteriori analysis will diference these families.\nbut because of the indetermination can not be distinguish.\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n  C       G       G       G       C\n  C       G       G       G       C\n  A       C       C       C       T\n\nThe result of the mergering will go like:\n\n  A       C       C       C       T\n  A       C       C       -       T\n  C       G       G       G       C\n  C       A       G       G       C\n\nOnce again the changes made on the families and we merge the frequency (I<to be\nimplemented>)\n\nBefore to convert the haplotype into numbers we consider how many variations\nwe have on the set. On this case the variations are 3.\n\nThe control code will use on this situation base three as mutiplicity\n\n  0       0       0       0       0\n  0       0       0       1       0\n  1       1       1       2       1\n  1       2       1       2       1\n -----------------------------------\n  36      63      36      75      36\n\nAnd the minimal set for this combination is\n\n  0       0       0\n  0       0       1\n  1       1       2\n  1       2       2\n\nB<NOTE:> this second example is a remote example an on normal conditions. This\nconditions makes no sense, but as the haplotypes, can come from many sources\nwe have to be ready for all kind of combinations.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Pedro M. Gomez-Fabre\n\nEmail pgf18872-at-gsk-dot-com\n\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::PopGen::HtSNP;\nuse Data::Dumper;\nuse Storable qw(dclone);\n\nuse vars qw ();\nuse strict;\n\n\nuse base qw(Bio::Root::Root);\n\nmy $USAGE = 'Usage:\n\n    Bio::PopGen::HtSNP->new(-haplotype_block -ids -pattern_freq)\n\n';\n\n=head2 new\n\n Title   : new\n Function: constructor of the class.\n Usage   : $obj-> Bio::PopGen::HtSNP->new(-haplotype_block\n                                          -snp_ids\n                                          -pattern_freq)\n Returns : self hash\n Args    : input haplotype (array of array)\n           snp_ids         (array)\n           pop_freq        (array of array)\n Status  : public\n\n\nsub new {\n    my($class, @args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    my ($haplotype_block,\n        $snp_ids,\n        $pattern_freq    ) = $self->_rearrange([qw(HAPLOTYPE_BLOCK \n                                                   SNP_IDS\n                                                   PATTERN_FREQ)],@args);\n\n    if ($haplotype_block){\n        $self->haplotype_block($haplotype_block);\n    }\n    else{\n        $self->throw(\"Haplotype block has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($snp_ids){\n        $self->snp_ids($snp_ids);\n    }\n    else{\n        $self->throw(\"Array with ids has not been defined.\n                      \\n$USAGE\");\n    }\n    if ($pattern_freq){\n        $self->pattern_freq($pattern_freq);\n    }\n    else{\n        $self->throw(\"Array with pattern id and frequency has not been defined.\n                      \\n$USAGE\");\n    }\n\n    # if the input values are not well formed complained and exit.\n    _check_input($self);\n\n    _do_it($self);\n\n    return $self;\n}\n\n=head2 haplotype_block \n\n Title   : haplotype_block \n Usage   : my $haplotype_block = $HtSNP->haplotype_block();\n Function: Get the haplotype block for a haplotype tagging selection\n Returns : reference of array \n Args    : reference of array with haplotype pattern \n\n\n\nsub haplotype_block{\n    my ($self) =shift;\n    return $self->{'_haplotype_block'} = shift if @_;\n    return $self->{'_haplotype_block'};\n}\n\n=head2 snp_ids \n\n Title   : snp_ids \n Usage   : my $snp_ids = $HtSNP->$snp_ids();\n Function: Get the ids for a haplotype tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\n\nsub snp_ids{\n    my ($self) =shift;\n    return $self->{'_snp_ids'} = shift if @_;\n    return $self->{'_snp_ids'};\n}\n\n\n=head2 pattern_freq\n\n Title   : pattern_freq\n Usage   : my $pattern_freq = $HtSNP->pattern_freq();\n Function: Get the pattern id and frequency  for a haplotype\n           tagging selection\n Returns : reference of array\n Args    : reference of array with SNP ids\n\n\nsub pattern_freq{\n    my ($self) =shift;\n    return $self->{'_pattern_freq'} = shift if @_;\n    return $self->{'_pattern_freq'};\n}\n\n=head2 _check_input\n\n Title   : _check_input\n Usage   : _check_input($self)\n Function: check for errors on the input\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _check_input{\n#------------------------\n\n    my $self = shift;\n\n    _haplotype_length_error($self);\n    _population_error($self);\n\n}\n\n=head2 _haplotype_length_error\n\n Title   : _haplotype_length_error\n Usage   : _haplotype_length_error($self)\n Function: check if the haplotype length is the same that the one on the\n           SNP id list. If not break and exit\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _haplotype_length_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $snp_ids     = $self->snp_ids();\n\n\n    #############################\n    # define error list\n    #############################\n    my $different_haplotype_length = 0;\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n\n    my $snp_number         = scalar @$snp_ids;\n    my $number_of_families = scalar @$input_block;\n    my $h                  = 0; # haplotype position\n\n\n    ############################\n    # haplotype length\n    #\n    # if the length differs from the number of ids\n    ############################\n\n    for ($h=0; $h<$#$input_block+1 ; $h++){\n        if (length $input_block->[$h]  != $snp_number){\n            $different_haplotype_length = 1;\n            last;\n        }\n    }\n\n    # haploytypes does not have the same length\n    if ($different_haplotype_length){\n       $self->throw(\"The number of snp ids is $snp_number and \".\n            \"the length of the family (\". ($h+1) .\") [\".\n             $input_block->[$h].\"] is \".\n             length $input_block->[$h], \"\\n\");\n    }\n}\n\n=head2 _population_error\n\n\n Title   : _population_error\n Usage   : _population_error($self)\n Function: use input_block and pop_freq test if the number of elements\n           match. If doesn't break and quit.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n\n#------------------------\nsub _population_error{\n#------------------------\n\n    my $self = shift;\n\n    my $input_block = $self->haplotype_block();\n    my $pop_freq    = $self->pattern_freq();\n\n    #############################\n    # define error list\n    #############################\n    my $pop_freq_elements_error    = 0;  # matrix bad formed\n\n    ##############################\n    # get parameters used to find\n    # the errors\n    ##############################\n    my $number_of_families = scalar @$input_block;\n\n    my $pf         = 0; # number of elements on population frequency\n    my $frequency  = 0; # population frequency\n    my $p_f_length = 0;\n\n    # check if the pop_freq array is well formed and if the number\n    # of elements fit with the number of families\n\n    #############################\n    # check population frequency\n    #\n    # - population frequency matrix need to be well formed\n    # - get the frequency\n    # - calculate number of families on pop_freq\n    #############################\n\n    for  ($pf=0; $pf<$#$pop_freq+1; $pf++){\n        $frequency += $pop_freq->[$pf]->[1];\n\n        if ( scalar @{$pop_freq->[$pf]} !=2){\n            $p_f_length = scalar @{$pop_freq->[$pf]};\n            $pop_freq_elements_error = 1;\n            last;\n        }\n    }\n\n    ###########################\n    ## error processing\n    ###########################\n\n\n    # The frequency shouldn't be greater than 1\n    if ($frequency >1) {\n        $self->warn(\"The frequency for this set is $frequency (greater than 1)\\n\");\n    }\n\n    # the haplotype matix is not well formed\n    if ($pop_freq_elements_error){\n        $self->throw(\"the frequency matrix is not well formed\\n\".\n             \"\\nThe number of elements for pattern \".($pf+1).\" is \".\n             \"$p_f_length\\n\".\n             \"It should be 2 for pattern \\\"@{$pop_freq->[$pf]}\\\"\\n\".\n             \"\\nFormat should be:\\n\".\n             \"haplotype_id\\t frequency\\n\"\n            );\n    }\n\n    # the size does not fit on pop_freq array\n    #  with the one in haplotype (input_block)\n    if ($pf != $number_of_families) {\n        $self->throw(\"The number of patterns on frequency array ($pf)\\n\".\n             \"does not fit with the number of haplotype patterns on \\n\". \n             \"haplotype array ($number_of_families)\\n\");\n    }\n}\n\n=head2 _do_it\n\n\n Title   : _do_it\n Usage   : _do_it($self)\n Function: Process the input generating the results.\n Returns : self hash\n Args    : self\n Status  : internal\n\n\n#------------------------\nsub _do_it{\n#------------------------\n\n    my $self = shift;\n\n    # first we are goinf to define here all variables we are going to use\n    $self -> {'w_hap'}          = [];\n    $self -> {'w_pop_freq'}     = dclone ( $self ->pattern_freq() );\n    $self -> {'deg_pattern'}    = {};\n    $self -> {'snp_type'}       = {};  # type of snp on the set. see below\n    $self -> {'alleles_number'} = 0;   # number of variations (biallelic,...)\n    $self -> {'snp_type_code'}  = [];\n    $self -> {'ht_type'}        = [];  # store the snp type used on the htSet\n    $self -> {'split_hap'}      = [];\n    $self -> {'snp_and_code'}   = [];\n\n\n    # we classify the SNP under snp_type\n    $self->{snp_type}->{useful_snp} = dclone ( $self ->snp_ids() );\n    $self->{snp_type}->{deg_snp}    = []; # deg snp\n    $self->{snp_type}->{silent_snp} = []; # not a real snp\n\n    # split the haplotype\n    _split_haplo ($self);\n\n    # first we convert to upper case the haplotype\n    # to make A the same as a for comparison\n    _to_upper_case( $self -> {w_hap} );\n\n    #######################################################\n    # check if any SNP has indetermination. If any SNP has\n    # indetermination this value will be removed.\n    #######################################################\n    _remove_deg ( $self );\n\n    #######################################################\n    # depending of the families you use some SNPs can be\n    # silent. This silent SNP's are not used on the\n    # creation of tags and has to be skipped from the\n    # analysis.\n    #######################################################\n    _rem_silent_snp ( $self );\n\n    #######################################################\n    # for the remaining SNP's we have to check if two\n    # families have the same value. If this is true, the families\n    # will produce the same result and therefore we will not find\n    # any pattern. So, the redundant families need to be take\n    # away from the analysis. But also considered for a further\n    # run.\n    #\n    # When we talk about a normal haplotype blocks this situation\n    # makes no sense but if we remove one of the snp because the\n    # degeneration two families can became the same.\n    # these families may be analised on a second round\n    #######################################################\n\n    _find_deg_pattern ( $self );\n\n    #################################################################\n    # if the pattern list length is different to the lenght of the w_hap\n    # we can tell that tow columns have been considered as the same one\n    # and therefore we have to start to remove the values.\n    # remove all columns with degeneration\n    #\n    # For this calculation we don't use the pattern frequency.\n    # All patterns are the same, This selection makes\n    # sense when you have different frequency.\n    #\n    # Note: on this version we don't classify the haplotype by frequency\n    # but if you need to do it. This is the place to do it!!!!\n    #\n    # In reality you don't need to sort the values because you will remove\n    # the values according to their values.\n    #\n    # But as comes from a hash, the order could be different and as a\n    # consequence the code generate on every run of the same set could\n    # differ. That is not important. In fact, does not matter but could\n    # confuse people.\n    #################################################################\n\n    my @tmp =sort { $a <=> $b}\n         keys %{$self -> {deg_pattern}}; # just count the families\n\n    # if the size of the list is different to the size of the degenerated\n    # family. There is degeneration. And the redundancies will be\n    # removed.\n    if($#tmp != $#{$self -> { w_hap } } ){\n        _keep_these_patterns($self->{w_hap}, \\@tmp);\n        _keep_these_patterns($self->{w_pop_freq}, \\@tmp);\n    }\n\n    #################################################################\n    # the steps made before about removing snp and cluster families\n    # are just needed pre-process the haplotype before.\n    #\n    # Now is when the fun starts.\n    #\n    #\n    # once we have the this minimal matrix, we have to calculate the\n    # max multipliticy for the values. The max number of alleles found\n    # on the set. A normal haplotype is biallelic but we can not\n    # reject multiple variations.\n    ##################################################################\n\n    _alleles_number ( $self );\n\n    ##################################################################\n    # Now we have to convert the haplotype into number\n    #\n    # A       C       C       -       T\n    # C       A       G       G       C\n    # A       C       C       C       T\n    # C       G       G       G       C\n    #\n    # one haplotype like this transformed into number produce this result\n    #\n    # 0       0       0       0       0\n    # 1       1       1       1       1\n    # 0       0       0       2       0\n    # 1       2       1       1       1\n    #\n    ##################################################################\n\n    _convert_to_numbers( $self );\n\n    ###################################################################\n    # The next step is to calculate the type of the SNP.\n    # This process is made based on the position of the SNP, the value\n    # and its multiplicity.\n    ###################################################################\n\n    _snp_type_code( $self );\n\n    ###################################################################\n    # now we have all information we need to calculate the haplotype\n    # tagging SNP htSNP\n    ###################################################################\n\n    _htSNP( $self );\n\n    ###################################################################\n    # patch:\n    #\n    # all SNP have a code. but if the SNP is not used this code must\n    # be zero in case of silent SNP. This looks not to informative\n    # because all the information is already there. But this method\n    # compile the full set.\n    ###################################################################\n\n    _snp_and_code_summary( $self );\n}\n\n=head2 input_block\n\n Title   : input_block\n Usage   : $obj->input_block()\n Function: returns input block\n Returns : reference to array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub input_block{\n#------------------------\n\n    my $self = shift;\n    return $self -> {input_block};\n}\n\n=head2 hap_length\n\n Title   : hap_length\n Usage   : $obj->hap_length()\n Function: get numbers of SNP on the haplotype\n Returns : scalar\n Args    : none\n Status  : public\n\n\n#------------------------\nsub hap_length{\n#------------------------\n\n    my $self = shift;\n    return scalar @{$self -> {'_snp_ids'}};\n}\n\n\n=head2 pop_freq\n\n Title   : pop_freq\n Usage   : $obj->pop_freq()\n Function: returns population frequency\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub pop_freq{\n#------------------------\n\n    my $self = shift;\n    return $self -> {pop_freq}\n}\n\n\n=head2 deg_snp\n\n\n Title   : deg_snp\n Usage   : $obj->deg_snp()\n Function: returns snp_removes due to indetermination on their values\n Returns : reference to array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{deg_snp};\n}\n\n\n=head2 snp_type\n\n\n Title   : snp_type\n Usage   : $obj->snp_type()\n Function: returns hash with SNP type\n Returns : reference to hash\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type};\n}\n\n\n=head2 silent_snp\n\n\n Title   : silent_snp\n Usage   : $obj->silent_snp()\n Function: some SNP's are silent (not contibuting to the haplotype)\n           and are not considering for this analysis\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub silent_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{silent_snp};\n}\n\n\n=head2 useful_snp\n\n\n Title   : useful_snp\n Usage   : $obj->useful_snp()\n Function: returns list of SNP's that are can be used as htSNP. Some\n           of them can produce the same information. But this is\n           not considered here.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub useful_snp{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type} ->{useful_snp};\n}\n\n\n=head2 ht_type\n\n\n Title   : ht_type\n Usage   : $obj->ht_type()\n Function: every useful SNP has a numeric code dependending of its\n           value and position. For a better description see\n           description of the module.\n Returns : reference to a array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_type{\n#------------------------\n    my $self = shift;\n    return $self -> {ht_type};\n}\n=head2 ht_set\n\n\n Title   : ht_set\n Usage   : $obj->ht_set()\n Function: returns the minimal haplotype in numerical format. This\n           haplotype contains the maximal information about the\n           haplotype variations but with no redundancies. It's the\n           minimal set that describes the haplotype.\n Returns : reference to an array of arrays\n Args    : none\n Status  : public\n\n\n#------------------------\nsub ht_set{\n#------------------------\n    my $self = shift;\n    return $self -> {w_hap};\n}\n\n=head2 snp_type_code\n\n\n Title   : snp_type_code\n Usage   : $obj->snp_type_code()\n Function: returns the numeric code of the SNPs that need to be\n           tagged that correspond to the SNP's considered in ht_set.\n Returns : reference to an array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_type_code{\n#------------------------\n    my $self = shift;\n    return $self -> {snp_type_code};\n}\n\n=head2 snp_and_code\n\n\n Title   : snp_and_code\n Usage   : $obj->snp_and_code()\n Function: Returns the full list of SNP's and the code associate to\n           them. If the SNP belongs to the group useful_snp it keep\n           this code. If the SNP is silent the code is 0. And if the\n           SNP is degenerated the code is -1.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub snp_and_code{\n#------------------------\n    my $self = shift;\n    return $self -> {'snp_and_code'};\n}\n\n=head2 deg_pattern\n\n\n Title   : deg_pattern\n Usage   : $obj->deg_pattern()\n Function: Returns the a list with the degenerated haplotype.\n           Sometimes due to degeneration some haplotypes looks\n           the same and if we don't remove them it won't find\n           any tag.\n Returns : reference to a hash of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub deg_pattern{\n#------------------------\n    my $self = shift;\n\n    return $self -> {'deg_pattern'};\n}\n\n=head2 split_hap\n\n\n Title   : split_hap\n Usage   : $obj->split_hap()\n Function: simple representation of the haplotype base by base\n           Same information that input haplotype but base based.\n Returns : reference to an array of array\n Args    : none\n Status  : public\n\n\n#------------------------\nsub split_hap{\n#------------------------\n    my $self = shift;\n    return $self -> {'split_hap'};\n}\n\n=head2 _split_haplo\n\n Title   : _split_haplo\n Usage   : _split_haplo($self)\n Function: Take a haplotype and split it into bases\n Returns : self\n Args    : none\n Status  : internal\n\n\n#------------------------\nsub _split_haplo {\n#------------------------\n    my $self = shift;\n\n    my $in  = $self ->{'_haplotype_block'};\n    my $out = $self ->{'w_hap'};\n\n    # split every haplotype and store the result into $out\n    foreach (@$in){\n        push @$out, [split (//,$_)];\n    }\n\n    $self -> {'split_hap'} = dclone ($out);\n}\n\n# internal method to convert the haplotype to uppercase\n\n\n=head2 _to_upper_case\n\n\n Title   : _to_upper_case\n Usage   : _to_upper_case()\n Function: make SNP or in-dels Upper case\n Returns : self\n Args    : an AoA ref\n Status  : private\n\n\n#------------------------\nsub _to_upper_case {\n#------------------------\n    my ($arr) =@_;\n\n    foreach my $aref (@$arr){\n        foreach my $value (@{$aref} ){\n            $value = uc $value;\n        }\n    }\n}\n\n\n=head2 _remove_deg\n\n\n Title   : _remove_deg\n Usage   : _remove_deg()\n Function: when have a indetermination or strange value this SNP\n           is removed\n Returns : haplotype family set and degeneration list\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _remove_deg {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $deg_snp     = $self->{snp_type}->{deg_snp};\n\n    my $rem = [];  # take the position of the array to be removed\n\n    # first we work on the columns we have void values\n    $rem = _find_indet($hap,$rem);  # find degenerated columns\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem); # remove list\n\n        # now remove the values from SNP id\n        _remove_snp_id($snp,$deg_snp,$rem); # remove list\n    }\n}\n\n\n=head2 _rem_silent_snp\n\n\n Title   : _rem_silent_snp\n Usage   : _rem_silent_snp()\n Function: there is the remote possibilty that one SNP won't be a\n           real SNP on this situation we have to remove this SNP,\n           otherwise the program won't find any tag\n Returns : nonthing\n Args    : ref to an AoA and a ref to an array\n Status  : internal\n\n\n#------------------------\nsub _rem_silent_snp {\n#------------------------\n    my $self = shift;\n\n    my $hap         = $self->{w_hap};\n    my $snp         = $self->{snp_type}->{useful_snp};\n    my $silent_snp  = $self->{snp_type}->{silent_snp};\n\n    my $rem = [];   # store the positions to be removed\n\n    #find columns with no variation on the SNP, Real snp?\n    $rem = _find_silent_snps($hap);\n\n    if (@$rem){\n\n        # remove column on haplotype\n        _remove_col($hap,$rem);\n\n        # remove the values from SNP id\n        _remove_snp_id($snp,$silent_snp,$rem);\n    }\n}\n\n\n=head2 _find_silent_snps\n\n\n Title   : _find_silent_snps\n Usage   :\n Function: list of snps that are not SNPs. All values for that\n           SNPs on the set is the same one. Look stupid but can\n           happend and if this happend you will not find any tag\n Returns : nothing\n Args    :\n Status  :\n\n\n#------------------------\nsub _find_silent_snps{\n#------------------------\n    my ($arr)=@_;\n\n    my $list =[]; # no snp list;\n\n    # determine the number of snp by the length of the first row.\n    # we assume that the matrix is squared.\n    my $colsn= @{$arr->[0]};\n\n    for (my $i=0;$i<$colsn;$i++){\n        my $different =0;  # check degeneration\n\n        for my $r (1..$#$arr){\n            if($arr->[0][$i] ne $arr->[$r][$i]){\n                $different =1;\n                last;\n            }\n        }\n\n        if(!$different){\n            push (@$list, $i);\n        }\n    }\n\n    return $list;\n}\n\n\n=head2 _find_indet\n\n\n Title   : _find_indet\n Usage   :\n Function: find column (SNP) with invalid or degenerated values\n           and store this values into the second parameter suplied.\n Returns : nothing\n Args    : ref to AoA and ref to an array\n Status  : internal\n\n\n#------------------------\nsub _find_indet{\n#------------------------\n    my ($arr, $list)=@_;\n\n    foreach my $i(0..$#$arr){\n        foreach my $j(0..$#{$arr->[$i]}){\n            unless ($arr->[$i][$j] =~ /[ACTG-]/){\n                if ($#$list<0){\n                    push(@$list,$j);\n                }\n                else{\n                    my $found =0;   # check if already exist the value\n                    foreach my $k(0..$#$list){\n                        $found =1 if ($list->[$k] eq $j);\n                        last if ($found);\n                    }\n                    if(!$found){\n                        push(@$list,$j);\n                    }\n                }\n            }\n        }\n    }\n\n    @$list = sort { $a <=> $b} @$list;\n\n    return $list;\n}\n\n=head2 _remove_col\n\n Title   : _remove_col\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_col{\n#------------------------\n    my ($arr,$rem)=@_;\n\n    foreach my $col (reverse @$rem){\n        splice @$_, $col, 1 for @$arr;\n    }\n}\n\n\n=head2 _remove_snp_id\n\n Title   : _remove_snp_id\n Usage   :\n Function: remove columns contained on the second array from\n           the first arr\n Returns : nothing\n Args    : array of array reference and array reference\n Status  : internal\n\n\n#------------------------\nsub _remove_snp_id{\n#------------------------\n    my ($arr,$removed,$rem_list)=@_;\n\n    push @$removed, splice @$arr, $_, 1 foreach reverse @$rem_list;\n}\n\n\n=head2 _find_deg_pattern\n\n Title   : _find_deg_pattern\n Usage   :\n Function: create a list with the degenerated patterns\n Returns : @array\n Args    : a ref to AoA\n Status  : public\n\n\n#------------------------\nsub _find_deg_pattern{\n#------------------------\n    my $self  = shift;\n\n    my $arr   = $self ->{w_hap};          # the working haplotype\n    my $list  = $self ->{'deg_pattern'};  # degenerated patterns \n\n    # we have to check all elements\n    foreach my $i(0..$#$arr){\n        # is the element has not been used create a key\n        unless  ( _is_on_hash ($list,\\$i) ) {\n            $list->{$i}=[$i];\n        };\n\n        foreach my $j($i+1..$#$arr){\n            my $comp = compare_arrays($arr->[$i],$arr->[$j]);\n\n            if($comp){\n                # as we have no elements we push this into the list\n                # check for the first element\n                my $key = _key_for_value($list,\\$i);\n\n                push (@{$list->{$key}},$j);\n\n                last;\n            }\n        }\n    }\n\n}\n\n#------------------------\nsub _key_for_value{\n#------------------------\n    my($hash,$value)=@_;\n\n    foreach my $key (keys %$hash){\n        if( _is_there(\\@{$hash->{$key}},$value)){\n            return $key;\n        }\n    }\n}\n\n#------------------------\nsub _is_on_hash{\n#------------------------\n    my($hash,$value)=@_;\n\n    foreach my $key (keys %$hash){\n        if( _is_there(\\@{$hash->{$key}},$value)){\n            return 1;\n        }\n    }\n}\n\n#------------------------\nsub _is_there{\n#------------------------\n\n    my($arr,$value)=@_;\n\n    foreach my $el (@$arr){\n        if ($el eq $$value){\n            return 1;\n        }\n    }\n}\n\n\n=head2 _keep_these_patterns\n\n\n Title   : _keep_these_patterns\n Usage   :\n Function: this is a basic approach, take a LoL and a list,\n           keep just the columns included on the list\n Returns : nothing\n Args    : an AoA and an array\n Status  : public\n\n\n#------------------------\nsub _keep_these_patterns{\n#------------------------\n    my ($arr,$list)=@_;\n\n    # by now we just take one of the repetitions but you can weight\n    # the values by frequency\n\n    my @outValues=();\n\n    foreach my $k (@$list){\n        push @outValues, $arr->[$k];\n    }\n\n    #make arr to hold the new values\n    @$arr= @{dclone(\\@outValues)};\n\n}\n\n\n=head2 compare_arrays\n\n\n Title   : compare_arrays\n Usage   :\n Function: take two arrays and compare their values\n Returns : 1 if the two values are the same\n           0 if the values are different\n Args    : an AoA and an array\n Status  : public"},"children":[{"line":1430,"name":"$first","containerName":"compare_arrays","localvar":"my","kind":13,"definition":"my"},{"line":1430,"kind":13,"containerName":"compare_arrays","name":"$second"},{"kind":13,"containerName":"compare_arrays","name":"$first","line":1431},{"name":"$second","containerName":"compare_arrays","kind":13,"line":1431},{"definition":"my","containerName":"compare_arrays","localvar":"my","kind":13,"name":"$i","line":1432},{"name":"$i","kind":13,"containerName":"compare_arrays","line":1432},{"name":"$first","containerName":"compare_arrays","kind":13,"line":1432},{"kind":13,"containerName":"compare_arrays","name":"$i","line":1432},{"line":1433,"containerName":"compare_arrays","kind":13,"name":"$first"},{"line":1433,"kind":13,"containerName":"compare_arrays","name":"$i"},{"name":"$second","containerName":"compare_arrays","kind":13,"line":1433},{"kind":13,"containerName":"compare_arrays","name":"$i","line":1433}],"name":"compare_arrays","containerName":"main::","definition":"sub","detail":"($first,$second)"},{"kind":12,"range":{"start":{"line":1453,"character":0},"end":{"line":1463,"character":9999}},"line":1453,"containerName":"main::","name":"_convert_to_numbers","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_convert_to_numbers","name":"$self","line":1455},{"definition":"my","line":1457,"name":"$hap_ref","containerName":"_convert_to_numbers","localvar":"my","kind":13},{"line":1457,"name":"$self","kind":13,"containerName":"_convert_to_numbers"},{"line":1458,"containerName":"_convert_to_numbers","localvar":"my","kind":13,"name":"$mm","definition":"my"},{"line":1458,"containerName":"_convert_to_numbers","kind":13,"name":"$self"},{"definition":"my","name":"$length","kind":13,"localvar":"my","containerName":"_convert_to_numbers","line":1463},{"line":1463,"name":"$hap_ref","containerName":"_convert_to_numbers","kind":13}],"definition":"sub"},{"line":1457,"name":"w_hap","kind":12},{"line":1458,"kind":12,"name":"alleles_number"},{"line":1465,"localvar":"my","containerName":null,"kind":13,"name":"$c","definition":"my"},{"containerName":null,"kind":13,"name":"$c","line":1465},{"line":1465,"name":"$length","containerName":null,"kind":13},{"line":1465,"containerName":null,"kind":13,"name":"%c"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@al","line":1467},{"line":1469,"localvar":"my","kind":13,"containerName":null,"name":"$r","definition":"my"},{"name":"%hap_ref","containerName":null,"kind":13,"line":1469},{"containerName":null,"kind":13,"name":"@al","line":1471},{"line":1471,"kind":13,"containerName":null,"name":"@hap_ref"},{"name":"@r","kind":13,"containerName":null,"line":1471},{"line":1471,"containerName":null,"kind":13,"name":"$c"},{"line":1472,"containerName":null,"kind":13,"name":"@al"},{"line":1472,"kind":13,"containerName":null,"name":"@hap_ref"},{"containerName":null,"kind":13,"name":"@r","line":1472},{"name":"$c","containerName":null,"kind":13,"line":1472},{"line":1474,"containerName":null,"kind":13,"name":"@hap_ref"},{"name":"@r","kind":13,"containerName":null,"line":1474},{"line":1474,"name":"$c","kind":13,"containerName":null},{"kind":12,"name":"get_position","line":1474},{"line":1474,"kind":13,"containerName":null,"name":"@al"},{"line":1474,"name":"@hap_ref","kind":13,"containerName":null},{"line":1474,"name":"@r","kind":13,"containerName":null},{"line":1474,"name":"$c","containerName":null,"kind":13},{"kind":12,"range":{"end":{"line":1520,"character":9999},"start":{"line":1512,"character":0}},"line":1512,"containerName":"main::","name":"_snp_type_code","children":[{"name":"$self","localvar":"my","containerName":"_snp_type_code","kind":13,"line":1514,"definition":"my"},{"localvar":"my","kind":13,"containerName":"_snp_type_code","name":"$hap","line":1516,"definition":"my"},{"line":1516,"containerName":"_snp_type_code","kind":13,"name":"$self"},{"definition":"my","kind":13,"localvar":"my","containerName":"_snp_type_code","name":"$arr","line":1517},{"name":"$self","containerName":"_snp_type_code","kind":13,"line":1517},{"definition":"my","name":"$al","localvar":"my","kind":13,"containerName":"_snp_type_code","line":1518},{"line":1518,"name":"$self","kind":13,"containerName":"_snp_type_code"},{"line":1520,"name":"$length","localvar":"my","containerName":"_snp_type_code","kind":13,"definition":"my"},{"line":1520,"name":"$hap","kind":13,"containerName":"_snp_type_code"}],"definition":"sub"},{"line":1516,"kind":12,"name":"w_hap"},{"line":1517,"name":"snp_type_code","kind":12},{"name":"alleles_number","kind":12,"line":1518},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$c","line":1522},{"line":1522,"containerName":null,"kind":13,"name":"$c"},{"containerName":null,"kind":13,"name":"$length","line":1522},{"name":"%c","containerName":null,"kind":13,"line":1522},{"line":1523,"localvar":"my","kind":13,"containerName":null,"name":"$r","definition":"my"},{"line":1523,"name":"%hap","kind":13,"containerName":null},{"line":1524,"name":"@arr","kind":13,"containerName":null},{"line":1524,"name":"$c","containerName":null,"kind":13},{"line":1524,"kind":13,"containerName":null,"name":"@hap"},{"containerName":null,"kind":13,"name":"@r","line":1524},{"name":"$c","containerName":null,"kind":13,"line":1524},{"containerName":null,"kind":13,"name":"$al","line":1524},{"containerName":null,"kind":13,"name":"$r","line":1524},{"name":"get_position","containerName":"main::","children":[{"definition":"my","line":1538,"localvar":"my","kind":13,"containerName":"get_position","name":"$array"},{"containerName":"get_position","kind":13,"name":"$value","line":1538},{"line":1540,"containerName":"get_position","localvar":"my","kind":13,"name":"$i","definition":"my"},{"kind":13,"containerName":"get_position","name":"$array","line":1540},{"line":1541,"kind":13,"containerName":"get_position","name":"$array"},{"containerName":"get_position","kind":13,"name":"$i","line":1541},{"name":"$i","containerName":"get_position","kind":13,"line":1542}],"detail":"($array,$value)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":1535},"end":{"character":9999,"line":1546}},"line":1535,"signature":{"label":"get_position($array,$value)","parameters":[{"label":"$array"},{"label":"$value"}],"documentation":" return the position of an element in one array\n The element is always present on the array"}},{"line":1541,"kind":12,"name":"value"},{"line":1564,"range":{"start":{"character":0,"line":1564},"end":{"character":9999,"line":1571}},"kind":12,"children":[{"definition":"my","line":1567,"name":"$self","kind":13,"localvar":"my","containerName":"_alleles_number"},{"line":1569,"name":"$hap_ref","localvar":"my","kind":13,"containerName":"_alleles_number","definition":"my"},{"line":1569,"name":"$self","kind":13,"containerName":"_alleles_number"},{"definition":"my","name":"$length","localvar":"my","kind":13,"containerName":"_alleles_number","line":1571},{"line":1571,"containerName":"_alleles_number","kind":13,"name":"$hap_ref"}],"name":"_alleles_number","containerName":"main::","definition":"sub"},{"kind":12,"name":"w_hap","line":1569},{"definition":"my","line":1573,"name":"$c","containerName":null,"localvar":"my","kind":13},{"name":"$c","kind":13,"containerName":null,"line":1573},{"line":1573,"name":"$length","containerName":null,"kind":13},{"line":1573,"containerName":null,"kind":13,"name":"%c"},{"kind":13,"localvar":"my","containerName":null,"name":"%alleles","line":1575,"definition":"my"},{"line":1577,"localvar":"my","containerName":null,"kind":13,"name":"$r","definition":"my"},{"line":1577,"containerName":null,"kind":13,"name":"%hap_ref"},{"name":"%alleles","kind":13,"containerName":null,"line":1578},{"line":1578,"name":"@hap_ref","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"@r","line":1578},{"line":1578,"kind":13,"containerName":null,"name":"$c"},{"line":1583,"name":"%self","kind":13,"containerName":null},{"kind":12,"name":"alleles_number","line":1583},{"name":"%alleles","kind":13,"containerName":null,"line":1583},{"containerName":null,"kind":13,"name":"%self","line":1584},{"line":1584,"name":"alleles_number","kind":12},{"name":"%alleles","kind":13,"containerName":null,"line":1584},{"name":"_htSNP","containerName":"main::","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_htSNP","line":1606},{"line":1608,"localvar":"my","kind":13,"containerName":"_htSNP","name":"$hap","definition":"my"},{"containerName":"_htSNP","kind":13,"name":"$self","line":1608},{"localvar":"my","kind":13,"containerName":"_htSNP","name":"$type","line":1609,"definition":"my"},{"kind":13,"containerName":"_htSNP","name":"$self","line":1609},{"name":"$set","kind":13,"localvar":"my","containerName":"_htSNP","line":1610,"definition":"my"},{"name":"$self","containerName":"_htSNP","kind":13,"line":1610},{"containerName":"_htSNP","localvar":"my","kind":13,"name":"$out","line":1611,"definition":"my"},{"definition":"my","line":1613,"name":"$nc","containerName":"_htSNP","localvar":"my","kind":13},{"definition":"my","line":1616,"name":"$c","localvar":"my","kind":13,"containerName":"_htSNP"},{"line":1616,"name":"$type","containerName":"_htSNP","kind":13},{"line":1618,"name":"$exist","localvar":"my","kind":13,"containerName":"_htSNP","definition":"my"},{"line":1621,"name":"$set","kind":13,"containerName":"_htSNP"},{"line":1621,"kind":13,"containerName":"_htSNP","name":"$type"},{"line":1621,"containerName":"_htSNP","kind":13,"name":"$c"},{"kind":13,"containerName":"_htSNP","name":"$set","line":1622},{"kind":13,"containerName":"_htSNP","name":"$type","line":1622},{"containerName":"_htSNP","kind":13,"name":"$c","line":1622},{"containerName":"_htSNP","kind":13,"name":"$exist","line":1624},{"definition":"my","line":1626,"name":"$r","localvar":"my","containerName":"_htSNP","kind":13},{"line":1626,"kind":13,"containerName":"_htSNP","name":"$hap"},{"name":"$out","kind":13,"containerName":"_htSNP","line":1628},{"line":1628,"kind":13,"containerName":"_htSNP","name":"$r"},{"line":1628,"name":"$nc","containerName":"_htSNP","kind":13},{"line":1628,"containerName":"_htSNP","kind":13,"name":"$hap"},{"line":1628,"containerName":"_htSNP","kind":13,"name":"$r"},{"line":1628,"kind":13,"containerName":"_htSNP","name":"$c"},{"name":"$exist","kind":13,"containerName":"_htSNP","line":1632},{"name":"$nc","kind":13,"containerName":"_htSNP","line":1632},{"name":"$hap","containerName":"_htSNP","kind":13,"line":1635},{"kind":13,"containerName":"_htSNP","name":"$out","line":1635}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":1604},"end":{"line":1635,"character":9999}},"line":1604},{"name":"dclone","kind":12,"line":1635},{"line":1658,"range":{"end":{"character":9999,"line":1696},"start":{"character":0,"line":1658}},"kind":12,"definition":"sub","children":[{"definition":"my","line":1660,"kind":13,"localvar":"my","containerName":"_snp_and_code_summary","name":"$self"},{"line":1662,"localvar":"my","containerName":"_snp_and_code_summary","kind":13,"name":"$snp_type_code","definition":"my"},{"line":1662,"kind":13,"containerName":"_snp_and_code_summary","name":"$self"},{"localvar":"my","kind":13,"containerName":"_snp_and_code_summary","name":"$useful_snp","line":1663,"definition":"my"},{"line":1663,"name":"$self","containerName":"_snp_and_code_summary","kind":13},{"definition":"my","containerName":"_snp_and_code_summary","localvar":"my","kind":13,"name":"$silent_snp","line":1664},{"name":"$self","kind":13,"containerName":"_snp_and_code_summary","line":1664},{"definition":"my","line":1665,"name":"$deg_snp","containerName":"_snp_and_code_summary","localvar":"my","kind":13},{"kind":13,"containerName":"_snp_and_code_summary","name":"$self","line":1665},{"name":"$snp_ids","localvar":"my","kind":13,"containerName":"_snp_and_code_summary","line":1666,"definition":"my"},{"kind":13,"containerName":"_snp_and_code_summary","name":"$self","line":1666},{"containerName":"_snp_and_code_summary","kind":12,"name":"snp_ids","line":1666},{"definition":"my","line":1667,"containerName":"_snp_and_code_summary","localvar":"my","kind":13,"name":"$snp_and_code"},{"containerName":"_snp_and_code_summary","kind":13,"name":"$self","line":1667},{"localvar":"my","kind":13,"containerName":"_snp_and_code_summary","name":"$i","line":1672,"definition":"my"},{"name":"$snp_ids","containerName":"_snp_and_code_summary","kind":13,"line":1672},{"definition":"my","name":"$value","kind":13,"localvar":"my","containerName":"_snp_and_code_summary","line":1675},{"localvar":"my","containerName":"_snp_and_code_summary","kind":13,"name":"$j","line":1678,"definition":"my"},{"name":"$useful_snp","containerName":"_snp_and_code_summary","kind":13,"line":1678},{"kind":13,"containerName":"_snp_and_code_summary","name":"$snp_ids","line":1679},{"containerName":"_snp_and_code_summary","kind":13,"name":"$i","line":1679},{"name":"$useful_snp","kind":13,"containerName":"_snp_and_code_summary","line":1679},{"kind":13,"containerName":"_snp_and_code_summary","name":"$j","line":1679},{"line":1680,"containerName":"_snp_and_code_summary","kind":13,"name":"$value"},{"line":1680,"containerName":"_snp_and_code_summary","kind":13,"name":"$snp_type_code"},{"line":1680,"name":"$j","containerName":"_snp_and_code_summary","kind":13},{"name":"$j","containerName":"_snp_and_code_summary","localvar":"my","kind":13,"line":1686,"definition":"my"},{"line":1686,"name":"$deg_snp","kind":13,"containerName":"_snp_and_code_summary"},{"kind":13,"containerName":"_snp_and_code_summary","name":"$snp_ids","line":1687},{"line":1687,"name":"$i","containerName":"_snp_and_code_summary","kind":13},{"line":1687,"name":"$deg_snp","kind":13,"containerName":"_snp_and_code_summary"},{"kind":13,"containerName":"_snp_and_code_summary","name":"$j","line":1687},{"line":1688,"containerName":"_snp_and_code_summary","kind":13,"name":"$value"},{"name":"$snp_ids","containerName":"_snp_and_code_summary","kind":13,"line":1693},{"containerName":"_snp_and_code_summary","kind":13,"name":"$i","line":1693},{"line":1693,"kind":13,"containerName":"_snp_and_code_summary","name":"$value"}],"name":"_snp_and_code_summary","containerName":"main::"}],"version":5}