{"version":5,"vars":[{"definition":"our","kind":13,"containerName":"main::","name":"$CheckISA","line":108},{"containerName":"strict::Bio::PopGen::Marker::Bio::PopGen","kind":2,"name":"Genotype","line":108},{"line":109,"kind":2,"containerName":"","name":"base"},{"kind":12,"range":{"start":{"line":124,"character":0},"end":{"line":148,"character":9999}},"line":124,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)"},"containerName":"main::","name":"new","children":[{"definition":"my","line":125,"containerName":"new","localvar":"my","kind":13,"name":"$class"},{"name":"@args","kind":13,"containerName":"new","line":125},{"definition":"my","line":127,"kind":13,"localvar":"my","containerName":"new","name":"$self"},{"line":127,"containerName":"new","kind":13,"name":"$class"},{"kind":13,"containerName":"new","name":"@args","line":127},{"containerName":"new","kind":13,"name":"$self","line":128},{"localvar":"my","kind":13,"containerName":"new","name":"$name","line":129,"definition":"my"},{"line":129,"containerName":"new","kind":13,"name":"$source"},{"name":"$description","kind":13,"containerName":"new","line":129},{"line":130,"kind":13,"containerName":"new","name":"$inds"},{"containerName":"new","kind":13,"name":"$checkisa","line":130},{"kind":13,"containerName":"new","name":"$self","line":130},{"line":130,"containerName":"new","kind":12,"name":"_rearrange"},{"line":134,"name":"@args","kind":13,"containerName":"new"},{"name":"$inds","kind":13,"containerName":"new","line":135},{"line":136,"name":"$inds","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":137},{"kind":12,"containerName":"new","name":"warn","line":137},{"name":"$self","containerName":"new","kind":13,"line":139},{"name":"add_Individual","containerName":"new","kind":12,"line":139},{"containerName":"new","kind":13,"name":"$inds","line":139},{"kind":13,"containerName":"new","name":"$name","line":143},{"line":143,"containerName":"new","kind":13,"name":"$self"},{"line":143,"name":"name","containerName":"new","kind":12},{"line":143,"name":"$name","kind":13,"containerName":"new"},{"line":144,"name":"$source","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":144},{"line":144,"kind":12,"containerName":"new","name":"source"},{"name":"$source","kind":13,"containerName":"new","line":144},{"containerName":"new","kind":13,"name":"$description","line":145},{"name":"$self","kind":13,"containerName":"new","line":145},{"line":145,"kind":12,"containerName":"new","name":"description"},{"line":145,"kind":13,"containerName":"new","name":"$description"},{"name":"$self","containerName":"new","kind":13,"line":146},{"kind":13,"containerName":"new","name":"$checkisa","line":146},{"line":146,"name":"$checkisa","containerName":"new","kind":13},{"line":146,"name":"$CheckISA","containerName":"new","kind":13},{"line":147,"name":"$self","containerName":"new","kind":13}],"detail":"($class,@args)","definition":"sub"},{"line":127,"name":"SUPER","containerName":"new","kind":12},{"line":162,"kind":12,"range":{"end":{"character":9999,"line":166},"start":{"line":162,"character":0}},"children":[{"definition":"my","line":163,"name":"$self","containerName":"name","localvar":"my","kind":13},{"name":"$self","containerName":"name","kind":13,"line":164},{"name":"$self","containerName":"name","kind":13,"line":165}],"name":"name","containerName":"main::","definition":"sub"},{"name":"description","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"description","kind":13,"line":180,"definition":"my"},{"line":181,"containerName":"description","kind":13,"name":"$self"},{"kind":13,"containerName":"description","name":"$self","line":182}],"definition":"sub","kind":12,"range":{"start":{"character":0,"line":179},"end":{"character":9999,"line":183}},"line":179},{"line":196,"range":{"start":{"line":196,"character":0},"end":{"line":200,"character":9999}},"kind":12,"definition":"sub","children":[{"line":197,"containerName":"source","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"source","name":"$self","line":198},{"name":"$self","kind":13,"containerName":"source","line":199}],"containerName":"main::","name":"source"},{"signature":{"label":"annotation($self,$arg)","documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object","parameters":[{"label":"$self"},{"label":"$arg"}]},"line":212,"range":{"end":{"line":218,"character":9999},"start":{"character":0,"line":212}},"kind":12,"definition":"sub","detail":"($self,$arg)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"annotation","line":213},{"line":213,"name":"$arg","kind":13,"containerName":"annotation"},{"line":214,"name":"$self","containerName":"annotation","kind":13},{"kind":13,"containerName":"annotation","name":"$arg","line":214},{"line":215,"name":"$self","kind":13,"containerName":"annotation"},{"name":"throw","kind":12,"containerName":"annotation","line":215},{"containerName":"annotation","kind":13,"name":"$arg","line":216},{"name":"$arg","kind":13,"containerName":"annotation","line":216},{"containerName":"annotation","kind":12,"name":"isa","line":216},{"name":"$self","containerName":"annotation","kind":13,"line":217},{"kind":13,"containerName":"annotation","name":"$arg","line":217}],"containerName":"main::","name":"annotation"},{"line":214,"name":"_annotation","kind":12},{"kind":12,"name":"_annotation","line":217},{"kind":12,"range":{"end":{"character":9999,"line":265},"start":{"character":0,"line":239}},"line":239,"signature":{"label":"set_Allele_Frequency($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }"},"name":"set_Allele_Frequency","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"set_Allele_Frequency","kind":13,"line":240,"definition":"my"},{"line":240,"containerName":"set_Allele_Frequency","kind":13,"name":"@args"},{"definition":"my","name":"$name","containerName":"set_Allele_Frequency","localvar":"my","kind":13,"line":241},{"containerName":"set_Allele_Frequency","kind":13,"name":"$allele","line":241},{"line":241,"name":"$frequency","containerName":"set_Allele_Frequency","kind":13},{"line":242,"name":"$frequencies","containerName":"set_Allele_Frequency","kind":13},{"line":242,"name":"$self","kind":13,"containerName":"set_Allele_Frequency"},{"line":242,"name":"_rearrange","kind":12,"containerName":"set_Allele_Frequency"},{"containerName":"set_Allele_Frequency","kind":13,"name":"@args","line":246},{"containerName":"set_Allele_Frequency","kind":13,"name":"$frequencies","line":247},{"line":248,"containerName":"set_Allele_Frequency","kind":13,"name":"$frequencies"},{"definition":"my","name":"$markername","kind":13,"localvar":"my","containerName":"set_Allele_Frequency","line":249},{"kind":13,"containerName":"set_Allele_Frequency","name":"$alleles","line":249},{"containerName":"set_Allele_Frequency","kind":13,"name":"$markername","line":250},{"name":"$alleles","containerName":"set_Allele_Frequency","kind":13,"line":250},{"line":250,"name":"$frequencies","containerName":"set_Allele_Frequency","kind":13},{"containerName":"set_Allele_Frequency","kind":13,"name":"$self","line":251},{"line":251,"containerName":"set_Allele_Frequency","kind":13,"name":"$markername"},{"name":"new","containerName":"set_Allele_Frequency","kind":12,"line":252},{"line":252,"name":"$markername","containerName":"set_Allele_Frequency","kind":13},{"line":253,"name":"$alleles","containerName":"set_Allele_Frequency","kind":13},{"line":256,"kind":13,"containerName":"set_Allele_Frequency","name":"$self"},{"kind":12,"containerName":"set_Allele_Frequency","name":"throw","line":256},{"kind":13,"containerName":"set_Allele_Frequency","name":"$self","line":259},{"name":"$name","kind":13,"containerName":"set_Allele_Frequency","line":259},{"containerName":"set_Allele_Frequency","kind":13,"name":"$self","line":260},{"line":260,"name":"$name","containerName":"set_Allele_Frequency","kind":13},{"line":261,"kind":12,"containerName":"set_Allele_Frequency","name":"new"},{"kind":13,"containerName":"set_Allele_Frequency","name":"$name","line":261},{"line":263,"name":"$self","kind":13,"containerName":"set_Allele_Frequency"},{"line":263,"containerName":"set_Allele_Frequency","kind":13,"name":"$name"},{"kind":12,"containerName":"set_Allele_Frequency","name":"add_Allele_Frequency","line":263},{"line":263,"containerName":"set_Allele_Frequency","kind":13,"name":"$allele"},{"line":263,"kind":13,"containerName":"set_Allele_Frequency","name":"$frequency"},{"line":265,"kind":13,"containerName":"set_Allele_Frequency","name":"$self"}],"detail":"($self,@args)","definition":"sub"},{"name":"Bio","kind":12,"containerName":"PopGen::Marker","line":252},{"line":261,"name":"Bio","kind":12,"containerName":"PopGen::Marker"},{"signature":{"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals","parameters":[{"label":"$self"},{"label":"@inds"}],"label":"add_Individual($self,@inds)"},"range":{"start":{"character":0,"line":280},"end":{"line":290,"character":9999}},"kind":12,"line":280,"detail":"($self,@inds)","definition":"sub","containerName":"main::","name":"add_Individual","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"add_Individual","line":281},{"kind":13,"containerName":"add_Individual","name":"@inds","line":281},{"definition":"my","kind":13,"localvar":"my","containerName":"add_Individual","name":"$i","line":282},{"line":282,"kind":13,"containerName":"add_Individual","name":"@inds"},{"containerName":"add_Individual","kind":13,"name":"$i","line":283},{"line":285,"name":"$self","kind":13,"containerName":"add_Individual"},{"containerName":"add_Individual","kind":13,"name":"$i","line":285},{"name":"isa","containerName":"add_Individual","kind":12,"line":285},{"line":286,"name":"$self","kind":13,"containerName":"add_Individual"},{"line":286,"name":"warn","containerName":"add_Individual","kind":12},{"line":290,"name":"$self","containerName":"add_Individual","kind":13}]},{"containerName":null,"kind":13,"name":"@inds","line":290},{"name":"%self","kind":13,"containerName":null,"line":291},{"kind":13,"containerName":null,"name":"%self","line":292},{"line":293,"containerName":null,"kind":13,"name":"%self"},{"definition":"sub","detail":"($self,@names)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"remove_Individuals","line":308,"definition":"my"},{"name":"@names","containerName":"remove_Individuals","kind":13,"line":308},{"kind":13,"localvar":"my","containerName":"remove_Individuals","name":"$i","line":309,"definition":"my"},{"localvar":"my","containerName":"remove_Individuals","kind":13,"name":"%namehash","line":310,"definition":"my"},{"name":"$n","containerName":"remove_Individuals","localvar":"my","kind":13,"line":311,"definition":"my"},{"name":"@names","kind":13,"containerName":"remove_Individuals","line":311},{"line":311,"name":"$namehash","kind":13,"containerName":"remove_Individuals"},{"line":311,"name":"$n","kind":13,"containerName":"remove_Individuals"},{"definition":"my","name":"@tosplice","localvar":"my","containerName":"remove_Individuals","kind":13,"line":312},{"line":313,"name":"$ind","kind":13,"localvar":"my","containerName":"remove_Individuals","definition":"my"},{"line":313,"kind":13,"containerName":"remove_Individuals","name":"$self"}],"containerName":"main::","name":"remove_Individuals","signature":{"label":"remove_Individuals($self,@names)","parameters":[{"label":"$self"},{"label":"@names"}],"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids"},"line":307,"range":{"end":{"character":9999,"line":313},"start":{"line":307,"character":0}},"kind":12},{"name":"@tosplice","containerName":null,"kind":13,"line":314},{"line":314,"containerName":null,"kind":13,"name":"$i"},{"name":"%namehash","kind":13,"containerName":null,"line":314},{"kind":13,"containerName":null,"name":"$ind","line":314},{"kind":12,"containerName":"main::","name":"unique_id","line":314},{"line":315,"name":"$i","kind":13,"containerName":null},{"localvar":"my","containerName":null,"kind":13,"name":"$index","line":317,"definition":"my"},{"name":"@tosplice","kind":13,"containerName":null,"line":317},{"line":318,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$index","line":318},{"line":320,"kind":13,"containerName":null,"name":"%self"},{"line":321,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"containerName":null,"name":"%self","line":322},{"containerName":"main::","name":"get_Individuals","children":[{"line":340,"name":"$self","localvar":"my","containerName":"get_Individuals","kind":13,"definition":"my"},{"name":"@args","containerName":"get_Individuals","kind":13,"line":340},{"definition":"my","name":"@inds","localvar":"my","containerName":"get_Individuals","kind":13,"line":341},{"line":341,"containerName":"get_Individuals","kind":13,"name":"$self"}],"detail":"($self,@args)","definition":"sub","range":{"start":{"character":0,"line":339},"end":{"character":9999,"line":341}},"kind":12,"line":339,"signature":{"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids\n\n\nsub remove_Individuals {\n    my ($self,@names) = @_;\n    my $i = 0;\n    my %namehash; # O(1) lookup will be faster I think\n    foreach my $n ( @names ) { $namehash{$n}++ }\n    my @tosplice;\n    foreach my $ind (  @{$self->{'_individuals'} || []} ) {\n\tunshift @tosplice, $i if( $namehash{$ind->unique_id} );\n\t$i++;\n    }\n    foreach my $index ( @tosplice ) {\n\tsplice(@{$self->{'_individuals'}}, $index,1);\n    }\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of Bio::PopGen::IndividualI objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_Individuals($self,@args)"}},{"line":342,"name":"@inds","containerName":null,"kind":13},{"name":"@args","kind":13,"containerName":null,"line":343},{"definition":"my","line":344,"name":"$id","localvar":"my","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$marker","line":344},{"name":"$self","kind":13,"containerName":null,"line":344},{"line":344,"containerName":"main::","kind":12,"name":"_rearrange"},{"containerName":null,"kind":13,"name":"@args","line":344},{"containerName":null,"kind":13,"name":"%id","line":347},{"kind":13,"containerName":null,"name":"@inds","line":348},{"line":348,"name":"unique_id","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$id","line":348},{"name":"@inds","kind":13,"containerName":null,"line":348},{"line":349,"name":"%marker","containerName":null,"kind":13},{"line":350,"kind":13,"containerName":null,"name":"@inds"},{"line":350,"kind":12,"containerName":"main::","name":"has_Marker"},{"line":350,"name":"$marker","kind":13,"containerName":null},{"line":350,"kind":13,"containerName":null,"name":"@inds"},{"containerName":null,"kind":13,"name":"@inds","line":353},{"line":368,"range":{"start":{"line":368,"character":0},"end":{"character":9999,"line":374}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids\n\n\nsub remove_Individuals {\n    my ($self,@names) = @_;\n    my $i = 0;\n    my %namehash; # O(1) lookup will be faster I think\n    foreach my $n ( @names ) { $namehash{$n}++ }\n    my @tosplice;\n    foreach my $ind (  @{$self->{'_individuals'} || []} ) {\n\tunshift @tosplice, $i if( $namehash{$ind->unique_id} );\n\t$i++;\n    }\n    foreach my $index ( @tosplice ) {\n\tsplice(@{$self->{'_individuals'}}, $index,1);\n    }\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of Bio::PopGen::IndividualI objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\nsub get_Individuals{\n   my ($self,@args) = @_;\n   my @inds = @{$self->{'_individuals'} || []};\n   return unless @inds;\n   if( @args ) { # save a little time here if @args is empty\n       my ($id,$marker) = $self->_rearrange([qw(UNIQUE_ID MARKER)], @args);\n\n       \n       if( defined $id ) { \n\t   @inds = grep { $_->unique_id eq $id } @inds;\n       } elsif (defined $marker) {\n\t   @inds = grep { $_->has_Marker($marker) } @inds;\n       }\n   }\n   return @inds;\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of Bio::PopGen::GenotypeI objects\n Args    : -marker => name of the marker","label":"get_Genotypes($self,@args)"},"children":[{"definition":"my","line":369,"name":"$self","localvar":"my","kind":13,"containerName":"get_Genotypes"},{"name":"@args","containerName":"get_Genotypes","kind":13,"line":369},{"line":370,"kind":13,"localvar":"my","containerName":"get_Genotypes","name":"$name","definition":"my"},{"line":370,"kind":13,"containerName":"get_Genotypes","name":"$self"},{"line":370,"name":"_rearrange","containerName":"get_Genotypes","kind":12},{"line":370,"name":"@args","kind":13,"containerName":"get_Genotypes"},{"line":371,"name":"$name","kind":13,"containerName":"get_Genotypes"},{"line":372,"name":"get_Genotypes","containerName":"get_Genotypes","kind":12},{"name":"$name","containerName":"get_Genotypes","kind":13,"line":372},{"name":"$self","kind":13,"containerName":"get_Genotypes","line":373}],"name":"get_Genotypes","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"kind":13,"containerName":null,"name":"$self","line":375},{"line":375,"name":"warn","containerName":"main::","kind":12},{"detail":"($self,$force)","definition":"sub","containerName":"main::","name":"get_marker_names","children":[{"localvar":"my","kind":13,"containerName":"get_marker_names","name":"$self","line":392,"definition":"my"},{"name":"$force","kind":13,"containerName":"get_marker_names","line":392},{"name":"$self","kind":13,"containerName":"get_marker_names","line":393}],"signature":{"parameters":[{"label":"$self"},{"label":"$force"}],"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids\n\n\nsub remove_Individuals {\n    my ($self,@names) = @_;\n    my $i = 0;\n    my %namehash; # O(1) lookup will be faster I think\n    foreach my $n ( @names ) { $namehash{$n}++ }\n    my @tosplice;\n    foreach my $ind (  @{$self->{'_individuals'} || []} ) {\n\tunshift @tosplice, $i if( $namehash{$ind->unique_id} );\n\t$i++;\n    }\n    foreach my $index ( @tosplice ) {\n\tsplice(@{$self->{'_individuals'}}, $index,1);\n    }\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of Bio::PopGen::IndividualI objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\nsub get_Individuals{\n   my ($self,@args) = @_;\n   my @inds = @{$self->{'_individuals'} || []};\n   return unless @inds;\n   if( @args ) { # save a little time here if @args is empty\n       my ($id,$marker) = $self->_rearrange([qw(UNIQUE_ID MARKER)], @args);\n\n       \n       if( defined $id ) { \n\t   @inds = grep { $_->unique_id eq $id } @inds;\n       } elsif (defined $marker) {\n\t   @inds = grep { $_->has_Marker($marker) } @inds;\n       }\n   }\n   return @inds;\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of Bio::PopGen::GenotypeI objects\n Args    : -marker => name of the marker\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   my ($name) = $self->_rearrange([qw(MARKER)],@args);\n   if( defined $name ) {\n       return grep { defined $_ } map { $_->get_Genotypes(-marker => $name) } \n       @{$self->{'_individuals'} || []}\n   } \n   $self->warn(\"You needed to have provided a valid -marker value\");\n   return ();\n}\n\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $pop->get_marker_names;\n Function: Get the names of the markers\n Returns : Array of strings\n Args    : [optional] boolean flag to ignore internal cache status","label":"get_marker_names($self,$force)"},"range":{"start":{"character":0,"line":391},"end":{"line":393,"character":9999}},"kind":12,"line":391},{"name":"$force","containerName":null,"kind":13,"line":394},{"line":394,"name":"%self","kind":13,"containerName":null},{"line":395,"name":"%unique","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":396,"name":"%n","kind":13,"localvar":"my","containerName":null},{"name":"get_marker_names","containerName":"main::","kind":12,"line":396},{"containerName":null,"kind":13,"name":"$self","line":396},{"name":"get_Individuals","kind":12,"containerName":"main::","line":396},{"containerName":null,"kind":13,"name":"%unique","line":397},{"line":397,"name":"$n","containerName":null,"kind":13},{"kind":13,"localvar":"my","containerName":null,"name":"@nms","line":399,"definition":"my"},{"kind":13,"containerName":null,"name":"%unique","line":399},{"line":400,"containerName":null,"kind":13,"name":"@nms"},{"line":403,"name":"@nms","kind":13,"containerName":null},{"line":404,"name":"@a","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"@b","line":404},{"name":"@nms","kind":13,"containerName":null,"line":405},{"line":407,"containerName":null,"kind":13,"name":"%self"},{"line":407,"name":"@nms","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%self","line":408},{"signature":{"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids\n\n\nsub remove_Individuals {\n    my ($self,@names) = @_;\n    my $i = 0;\n    my %namehash; # O(1) lookup will be faster I think\n    foreach my $n ( @names ) { $namehash{$n}++ }\n    my @tosplice;\n    foreach my $ind (  @{$self->{'_individuals'} || []} ) {\n\tunshift @tosplice, $i if( $namehash{$ind->unique_id} );\n\t$i++;\n    }\n    foreach my $index ( @tosplice ) {\n\tsplice(@{$self->{'_individuals'}}, $index,1);\n    }\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of Bio::PopGen::IndividualI objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\nsub get_Individuals{\n   my ($self,@args) = @_;\n   my @inds = @{$self->{'_individuals'} || []};\n   return unless @inds;\n   if( @args ) { # save a little time here if @args is empty\n       my ($id,$marker) = $self->_rearrange([qw(UNIQUE_ID MARKER)], @args);\n\n       \n       if( defined $id ) { \n\t   @inds = grep { $_->unique_id eq $id } @inds;\n       } elsif (defined $marker) {\n\t   @inds = grep { $_->has_Marker($marker) } @inds;\n       }\n   }\n   return @inds;\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of Bio::PopGen::GenotypeI objects\n Args    : -marker => name of the marker\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   my ($name) = $self->_rearrange([qw(MARKER)],@args);\n   if( defined $name ) {\n       return grep { defined $_ } map { $_->get_Genotypes(-marker => $name) } \n       @{$self->{'_individuals'} || []}\n   } \n   $self->warn(\"You needed to have provided a valid -marker value\");\n   return ();\n}\n\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $pop->get_marker_names;\n Function: Get the names of the markers\n Returns : Array of strings\n Args    : [optional] boolean flag to ignore internal cache status\n\n\n\nsub get_marker_names {\n    my ($self,$force) = @_;\n    return @{$self->{'_cached_markernames'} || []} \n      if( ! $force && defined $self->{'_cached_markernames'});\n    my %unique;\n    foreach my $n ( map { $_->get_marker_names } $self->get_Individuals() ) {\n\t$unique{$n}++;\n    }\n    my @nms = keys %unique;\n    if( $nms[0] =~ /^(Site|Codon)/ ) {\n\t# sort by site or codon number and do it in \n\t# a schwartzian transformation baby!\n\t@nms = map { $_->[1] } \n \t       sort { $a->[0] <=> $b->[0] }\n\t       map { [$_ =~ /^(?:Codon|Site)-(\\d+)/, $_] } @nms;\n    }\n    $self->{'_cached_markernames'} = [ @nms ];\n    return @{$self->{'_cached_markernames'} || []};\n}\n\n\n=head2 get_Marker\n\n Title   : get_Marker\n Usage   : my $marker = $population->get_Marker($name)\n Function: Get a Bio::PopGen::Marker object based on this population\n Returns : Bio::PopGen::MarkerI object\n Args    : name of the marker","parameters":[{"label":"$self"},{"label":"$markername"}],"label":"get_Marker($self,$markername)"},"line":423,"range":{"start":{"line":423,"character":0},"end":{"character":9999,"line":450}},"kind":12,"definition":"sub","detail":"($self,$markername)","children":[{"definition":"my","line":424,"kind":13,"localvar":"my","containerName":"get_Marker","name":"$self"},{"line":424,"name":"$markername","kind":13,"containerName":"get_Marker"},{"line":425,"localvar":"my","containerName":"get_Marker","kind":13,"name":"$marker","definition":"my"},{"line":427,"containerName":"get_Marker","kind":13,"name":"$self"},{"name":"$marker","kind":13,"containerName":"get_Marker","line":428},{"containerName":"get_Marker","kind":13,"name":"$self","line":428},{"name":"$markername","kind":13,"containerName":"get_Marker","line":428},{"definition":"my","line":431,"localvar":"my","containerName":"get_Marker","kind":13,"name":"@genotypes"},{"line":431,"containerName":"get_Marker","kind":13,"name":"$self"},{"line":431,"containerName":"get_Marker","kind":12,"name":"get_Genotypes"},{"line":431,"name":"$markername","containerName":"get_Marker","kind":13},{"name":"$marker","kind":13,"containerName":"get_Marker","line":432},{"name":"new","kind":12,"containerName":"get_Marker","line":432},{"containerName":"get_Marker","kind":13,"name":"$markername","line":432},{"line":434,"containerName":"get_Marker","kind":13,"name":"@genotypes"},{"containerName":"get_Marker","kind":13,"name":"$self","line":435},{"line":435,"kind":12,"containerName":"get_Marker","name":"warn"},{"kind":13,"localvar":"my","containerName":"get_Marker","name":"%alleles","line":437,"definition":"my"},{"definition":"my","line":438,"name":"$count","containerName":"get_Marker","localvar":"my","kind":13},{"line":439,"name":"$al","localvar":"my","kind":13,"containerName":"get_Marker","definition":"my"},{"line":439,"containerName":"get_Marker","kind":12,"name":"get_Alleles"},{"name":"@genotypes","kind":13,"containerName":"get_Marker","line":439},{"containerName":"get_Marker","kind":13,"name":"$count","line":440},{"line":441,"name":"$alleles","containerName":"get_Marker","kind":13},{"line":441,"name":"$al","kind":13,"containerName":"get_Marker"},{"line":443,"kind":13,"localvar":"my","containerName":"get_Marker","name":"$allele","definition":"my"},{"line":443,"containerName":"get_Marker","kind":13,"name":"%alleles"},{"name":"$marker","containerName":"get_Marker","kind":13,"line":444},{"containerName":"get_Marker","kind":12,"name":"add_Allele_Frequency","line":444},{"line":444,"containerName":"get_Marker","kind":13,"name":"$allele"},{"line":444,"name":"$alleles","kind":13,"containerName":"get_Marker"},{"name":"$allele","containerName":"get_Marker","kind":13,"line":444},{"name":"$count","kind":13,"containerName":"get_Marker","line":444},{"name":"$self","containerName":"get_Marker","kind":13,"line":447},{"line":447,"containerName":"get_Marker","kind":13,"name":"$markername"},{"line":447,"kind":13,"containerName":"get_Marker","name":"$marker"},{"line":449,"kind":13,"containerName":"get_Marker","name":"$marker"}],"name":"get_Marker","containerName":"main::"},{"name":"Bio","containerName":"PopGen::Marker","kind":12,"line":432},{"signature":{"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids\n\n\nsub remove_Individuals {\n    my ($self,@names) = @_;\n    my $i = 0;\n    my %namehash; # O(1) lookup will be faster I think\n    foreach my $n ( @names ) { $namehash{$n}++ }\n    my @tosplice;\n    foreach my $ind (  @{$self->{'_individuals'} || []} ) {\n\tunshift @tosplice, $i if( $namehash{$ind->unique_id} );\n\t$i++;\n    }\n    foreach my $index ( @tosplice ) {\n\tsplice(@{$self->{'_individuals'}}, $index,1);\n    }\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of Bio::PopGen::IndividualI objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\nsub get_Individuals{\n   my ($self,@args) = @_;\n   my @inds = @{$self->{'_individuals'} || []};\n   return unless @inds;\n   if( @args ) { # save a little time here if @args is empty\n       my ($id,$marker) = $self->_rearrange([qw(UNIQUE_ID MARKER)], @args);\n\n       \n       if( defined $id ) { \n\t   @inds = grep { $_->unique_id eq $id } @inds;\n       } elsif (defined $marker) {\n\t   @inds = grep { $_->has_Marker($marker) } @inds;\n       }\n   }\n   return @inds;\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of Bio::PopGen::GenotypeI objects\n Args    : -marker => name of the marker\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   my ($name) = $self->_rearrange([qw(MARKER)],@args);\n   if( defined $name ) {\n       return grep { defined $_ } map { $_->get_Genotypes(-marker => $name) } \n       @{$self->{'_individuals'} || []}\n   } \n   $self->warn(\"You needed to have provided a valid -marker value\");\n   return ();\n}\n\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $pop->get_marker_names;\n Function: Get the names of the markers\n Returns : Array of strings\n Args    : [optional] boolean flag to ignore internal cache status\n\n\n\nsub get_marker_names {\n    my ($self,$force) = @_;\n    return @{$self->{'_cached_markernames'} || []} \n      if( ! $force && defined $self->{'_cached_markernames'});\n    my %unique;\n    foreach my $n ( map { $_->get_marker_names } $self->get_Individuals() ) {\n\t$unique{$n}++;\n    }\n    my @nms = keys %unique;\n    if( $nms[0] =~ /^(Site|Codon)/ ) {\n\t# sort by site or codon number and do it in \n\t# a schwartzian transformation baby!\n\t@nms = map { $_->[1] } \n \t       sort { $a->[0] <=> $b->[0] }\n\t       map { [$_ =~ /^(?:Codon|Site)-(\\d+)/, $_] } @nms;\n    }\n    $self->{'_cached_markernames'} = [ @nms ];\n    return @{$self->{'_cached_markernames'} || []};\n}\n\n\n=head2 get_Marker\n\n Title   : get_Marker\n Usage   : my $marker = $population->get_Marker($name)\n Function: Get a Bio::PopGen::Marker object based on this population\n Returns : Bio::PopGen::MarkerI object\n Args    : name of the marker\n\n\n\nsub get_Marker{\n   my ($self,$markername) = @_;\n   my $marker;\n   # setup some caching too\n   if( defined $self->{'_allele_freqs'} &&\n       defined ($marker = $self->{'_allele_freqs'}->{$markername}) ) {\n       # marker is now set to the stored value\n   } else { \n       my @genotypes = $self->get_Genotypes(-marker => $markername);\n       $marker = Bio::PopGen::Marker->new(-name   => $markername);\n\n       if( ! @genotypes ) {\n\t   $self->warn(\"No genotypes for Marker $markername in the population\");\n       } else { \n\t   my %alleles;\n\t   my $count;\n\t   for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t     $count++; \n\t     $alleles{$al}++\n\t   }\n\t   foreach my $allele ( keys %alleles ) {\n\t       $marker->add_Allele_Frequency($allele, $alleles{$allele}/$count);\n\t   }\n       }\n       $self->{'_allele_freqs'}->{$markername} = $marker;\n   }\n   return $marker;\n}\n\n\n=head2 get_number_individuals\n\n Title   : get_number_individuals\n Usage   : my $count = $pop->get_number_individuals;\n Function: Get the count of the number of individuals\n Returns : integer >= 0\n Args    : none","parameters":[{"label":"$self"},{"label":"$markername"}],"label":"get_number_individuals($self,$markername)"},"line":464,"range":{"start":{"line":464,"character":0},"end":{"character":9999,"line":473}},"kind":12,"definition":"sub","detail":"($self,$markername)","children":[{"definition":"my","line":465,"name":"$self","containerName":"get_number_individuals","localvar":"my","kind":13},{"line":465,"name":"$markername","containerName":"get_number_individuals","kind":13},{"kind":13,"containerName":"get_number_individuals","name":"$self","line":467},{"name":"$self","containerName":"get_number_individuals","kind":13,"line":468},{"line":471,"containerName":"get_number_individuals","kind":13,"name":"$markername"},{"name":"$self","containerName":"get_number_individuals","kind":13,"line":472}],"name":"get_number_individuals","containerName":"main::"},{"name":"$number","kind":13,"localvar":"my","containerName":null,"line":474,"definition":"my"},{"line":475,"localvar":"my","kind":13,"containerName":null,"name":"$individual","definition":"my"},{"line":475,"name":"%self","containerName":null,"kind":13},{"line":476,"name":"$number","kind":13,"containerName":null},{"name":"$individual","kind":13,"containerName":null,"line":476},{"line":476,"containerName":"main::","kind":12,"name":"has_Marker"},{"kind":13,"containerName":null,"name":"$markername","line":476},{"containerName":null,"kind":13,"name":"$number","line":478},{"containerName":"main::","name":"set_number_individuals","children":[{"definition":"my","line":501,"name":"$self","localvar":"my","kind":13,"containerName":"set_number_individuals"},{"line":501,"name":"$indcount","kind":13,"containerName":"set_number_individuals"},{"line":502,"name":"$self","containerName":"set_number_individuals","kind":13},{"name":"$indcount","kind":13,"containerName":"set_number_individuals","line":502}],"detail":"($self,$indcount)","definition":"sub","kind":12,"range":{"end":{"line":503,"character":9999},"start":{"line":500,"character":0}},"line":500,"signature":{"label":"set_number_individuals($self,$indcount)","parameters":[{"label":"$self"},{"label":"$indcount"}],"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids\n\n\nsub remove_Individuals {\n    my ($self,@names) = @_;\n    my $i = 0;\n    my %namehash; # O(1) lookup will be faster I think\n    foreach my $n ( @names ) { $namehash{$n}++ }\n    my @tosplice;\n    foreach my $ind (  @{$self->{'_individuals'} || []} ) {\n\tunshift @tosplice, $i if( $namehash{$ind->unique_id} );\n\t$i++;\n    }\n    foreach my $index ( @tosplice ) {\n\tsplice(@{$self->{'_individuals'}}, $index,1);\n    }\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of Bio::PopGen::IndividualI objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\nsub get_Individuals{\n   my ($self,@args) = @_;\n   my @inds = @{$self->{'_individuals'} || []};\n   return unless @inds;\n   if( @args ) { # save a little time here if @args is empty\n       my ($id,$marker) = $self->_rearrange([qw(UNIQUE_ID MARKER)], @args);\n\n       \n       if( defined $id ) { \n\t   @inds = grep { $_->unique_id eq $id } @inds;\n       } elsif (defined $marker) {\n\t   @inds = grep { $_->has_Marker($marker) } @inds;\n       }\n   }\n   return @inds;\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of Bio::PopGen::GenotypeI objects\n Args    : -marker => name of the marker\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   my ($name) = $self->_rearrange([qw(MARKER)],@args);\n   if( defined $name ) {\n       return grep { defined $_ } map { $_->get_Genotypes(-marker => $name) } \n       @{$self->{'_individuals'} || []}\n   } \n   $self->warn(\"You needed to have provided a valid -marker value\");\n   return ();\n}\n\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $pop->get_marker_names;\n Function: Get the names of the markers\n Returns : Array of strings\n Args    : [optional] boolean flag to ignore internal cache status\n\n\n\nsub get_marker_names {\n    my ($self,$force) = @_;\n    return @{$self->{'_cached_markernames'} || []} \n      if( ! $force && defined $self->{'_cached_markernames'});\n    my %unique;\n    foreach my $n ( map { $_->get_marker_names } $self->get_Individuals() ) {\n\t$unique{$n}++;\n    }\n    my @nms = keys %unique;\n    if( $nms[0] =~ /^(Site|Codon)/ ) {\n\t# sort by site or codon number and do it in \n\t# a schwartzian transformation baby!\n\t@nms = map { $_->[1] } \n \t       sort { $a->[0] <=> $b->[0] }\n\t       map { [$_ =~ /^(?:Codon|Site)-(\\d+)/, $_] } @nms;\n    }\n    $self->{'_cached_markernames'} = [ @nms ];\n    return @{$self->{'_cached_markernames'} || []};\n}\n\n\n=head2 get_Marker\n\n Title   : get_Marker\n Usage   : my $marker = $population->get_Marker($name)\n Function: Get a Bio::PopGen::Marker object based on this population\n Returns : Bio::PopGen::MarkerI object\n Args    : name of the marker\n\n\n\nsub get_Marker{\n   my ($self,$markername) = @_;\n   my $marker;\n   # setup some caching too\n   if( defined $self->{'_allele_freqs'} &&\n       defined ($marker = $self->{'_allele_freqs'}->{$markername}) ) {\n       # marker is now set to the stored value\n   } else { \n       my @genotypes = $self->get_Genotypes(-marker => $markername);\n       $marker = Bio::PopGen::Marker->new(-name   => $markername);\n\n       if( ! @genotypes ) {\n\t   $self->warn(\"No genotypes for Marker $markername in the population\");\n       } else { \n\t   my %alleles;\n\t   my $count;\n\t   for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t     $count++; \n\t     $alleles{$al}++\n\t   }\n\t   foreach my $allele ( keys %alleles ) {\n\t       $marker->add_Allele_Frequency($allele, $alleles{$allele}/$count);\n\t   }\n       }\n       $self->{'_allele_freqs'}->{$markername} = $marker;\n   }\n   return $marker;\n}\n\n\n=head2 get_number_individuals\n\n Title   : get_number_individuals\n Usage   : my $count = $pop->get_number_individuals;\n Function: Get the count of the number of individuals\n Returns : integer >= 0\n Args    : none\n\n\n\nsub get_number_individuals{\n   my ($self,$markername) = @_;\n\n   if( $self->{'_forced_set_individuals'} ) {\n       return $self->{'_forced_set_individuals'};\n   }\n\n   unless( defined $markername ) {\n       return scalar @{$self->{'_individuals'} || []};\n   } else { \n       my $number =0;\n       foreach my $individual ( @{$self->{'_individuals'} || []} ) {\n\t   $number++ if( $individual->has_Marker($markername));\n       }\n       return $number;\n   }\n}\n\n=head2 set_number_individuals\n\n Title   : set_number_individuals\n    Usage   : $pop->set_number_individuals($num);\n Function: Fixes the number of individuals, call this with\n           0 to unset.\n           Only use this if you know what you are doing,\n           this is only relavent when you are just adding\n           allele frequency data for a population and want to\n           calculate something like theta\n Returns : none\n Args    : individual count, calling it with undef or 0\n            will reset the value to return a number\n            calculated from the number of individuals\n            stored for this population."}},{"signature":{"label":"get_Frequency_Homozygotes($self,$marker,$allelename)","documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids\n\n\nsub remove_Individuals {\n    my ($self,@names) = @_;\n    my $i = 0;\n    my %namehash; # O(1) lookup will be faster I think\n    foreach my $n ( @names ) { $namehash{$n}++ }\n    my @tosplice;\n    foreach my $ind (  @{$self->{'_individuals'} || []} ) {\n\tunshift @tosplice, $i if( $namehash{$ind->unique_id} );\n\t$i++;\n    }\n    foreach my $index ( @tosplice ) {\n\tsplice(@{$self->{'_individuals'}}, $index,1);\n    }\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of Bio::PopGen::IndividualI objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\nsub get_Individuals{\n   my ($self,@args) = @_;\n   my @inds = @{$self->{'_individuals'} || []};\n   return unless @inds;\n   if( @args ) { # save a little time here if @args is empty\n       my ($id,$marker) = $self->_rearrange([qw(UNIQUE_ID MARKER)], @args);\n\n       \n       if( defined $id ) { \n\t   @inds = grep { $_->unique_id eq $id } @inds;\n       } elsif (defined $marker) {\n\t   @inds = grep { $_->has_Marker($marker) } @inds;\n       }\n   }\n   return @inds;\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of Bio::PopGen::GenotypeI objects\n Args    : -marker => name of the marker\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   my ($name) = $self->_rearrange([qw(MARKER)],@args);\n   if( defined $name ) {\n       return grep { defined $_ } map { $_->get_Genotypes(-marker => $name) } \n       @{$self->{'_individuals'} || []}\n   } \n   $self->warn(\"You needed to have provided a valid -marker value\");\n   return ();\n}\n\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $pop->get_marker_names;\n Function: Get the names of the markers\n Returns : Array of strings\n Args    : [optional] boolean flag to ignore internal cache status\n\n\n\nsub get_marker_names {\n    my ($self,$force) = @_;\n    return @{$self->{'_cached_markernames'} || []} \n      if( ! $force && defined $self->{'_cached_markernames'});\n    my %unique;\n    foreach my $n ( map { $_->get_marker_names } $self->get_Individuals() ) {\n\t$unique{$n}++;\n    }\n    my @nms = keys %unique;\n    if( $nms[0] =~ /^(Site|Codon)/ ) {\n\t# sort by site or codon number and do it in \n\t# a schwartzian transformation baby!\n\t@nms = map { $_->[1] } \n \t       sort { $a->[0] <=> $b->[0] }\n\t       map { [$_ =~ /^(?:Codon|Site)-(\\d+)/, $_] } @nms;\n    }\n    $self->{'_cached_markernames'} = [ @nms ];\n    return @{$self->{'_cached_markernames'} || []};\n}\n\n\n=head2 get_Marker\n\n Title   : get_Marker\n Usage   : my $marker = $population->get_Marker($name)\n Function: Get a Bio::PopGen::Marker object based on this population\n Returns : Bio::PopGen::MarkerI object\n Args    : name of the marker\n\n\n\nsub get_Marker{\n   my ($self,$markername) = @_;\n   my $marker;\n   # setup some caching too\n   if( defined $self->{'_allele_freqs'} &&\n       defined ($marker = $self->{'_allele_freqs'}->{$markername}) ) {\n       # marker is now set to the stored value\n   } else { \n       my @genotypes = $self->get_Genotypes(-marker => $markername);\n       $marker = Bio::PopGen::Marker->new(-name   => $markername);\n\n       if( ! @genotypes ) {\n\t   $self->warn(\"No genotypes for Marker $markername in the population\");\n       } else { \n\t   my %alleles;\n\t   my $count;\n\t   for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t     $count++; \n\t     $alleles{$al}++\n\t   }\n\t   foreach my $allele ( keys %alleles ) {\n\t       $marker->add_Allele_Frequency($allele, $alleles{$allele}/$count);\n\t   }\n       }\n       $self->{'_allele_freqs'}->{$markername} = $marker;\n   }\n   return $marker;\n}\n\n\n=head2 get_number_individuals\n\n Title   : get_number_individuals\n Usage   : my $count = $pop->get_number_individuals;\n Function: Get the count of the number of individuals\n Returns : integer >= 0\n Args    : none\n\n\n\nsub get_number_individuals{\n   my ($self,$markername) = @_;\n\n   if( $self->{'_forced_set_individuals'} ) {\n       return $self->{'_forced_set_individuals'};\n   }\n\n   unless( defined $markername ) {\n       return scalar @{$self->{'_individuals'} || []};\n   } else { \n       my $number =0;\n       foreach my $individual ( @{$self->{'_individuals'} || []} ) {\n\t   $number++ if( $individual->has_Marker($markername));\n       }\n       return $number;\n   }\n}\n\n=head2 set_number_individuals\n\n Title   : set_number_individuals\n    Usage   : $pop->set_number_individuals($num);\n Function: Fixes the number of individuals, call this with\n           0 to unset.\n           Only use this if you know what you are doing,\n           this is only relavent when you are just adding\n           allele frequency data for a population and want to\n           calculate something like theta\n Returns : none\n Args    : individual count, calling it with undef or 0\n            will reset the value to return a number\n            calculated from the number of individuals\n            stored for this population.\n\n\nsub set_number_individuals{\n   my ($self,$indcount) = @_;\n   return $self->{'_forced_set_individuals'} = $indcount;\n}\n\n\n=head2 get_Frequency_Homozygotes\n\n Title   : get_Frequency_Homozygotes\n Usage   : my $freq = $pop->get_Frequency_Homozygotes;\n Function: Calculate the frequency of homozygotes in the population\n Returns : fraction between 0 and 1\n Args    : $markername","parameters":[{"label":"$self"},{"label":"$marker"},{"label":"$allelename"}]},"line":517,"kind":12,"range":{"start":{"character":0,"line":517},"end":{"character":9999,"line":534}},"definition":"sub","detail":"($self,$marker,$allelename)","children":[{"containerName":"get_Frequency_Homozygotes","localvar":"my","kind":13,"name":"$self","line":518,"definition":"my"},{"line":518,"containerName":"get_Frequency_Homozygotes","kind":13,"name":"$marker"},{"line":518,"name":"$allelename","containerName":"get_Frequency_Homozygotes","kind":13},{"line":519,"name":"$homozygote_count","kind":13,"localvar":"my","containerName":"get_Frequency_Homozygotes","definition":"my"},{"line":520,"name":"$marker","containerName":"get_Frequency_Homozygotes","kind":13},{"line":520,"name":"$allelename","kind":13,"containerName":"get_Frequency_Homozygotes"},{"name":"$marker","kind":13,"containerName":"get_Frequency_Homozygotes","line":521},{"name":"$marker","kind":13,"containerName":"get_Frequency_Homozygotes","line":521},{"line":521,"kind":12,"containerName":"get_Frequency_Homozygotes","name":"name"},{"line":521,"name":"$marker","containerName":"get_Frequency_Homozygotes","kind":13},{"kind":13,"containerName":"get_Frequency_Homozygotes","name":"$marker","line":522},{"line":523,"kind":13,"containerName":"get_Frequency_Homozygotes","name":"$self"},{"line":524,"name":"$marker","containerName":"get_Frequency_Homozygotes","kind":13},{"name":"isa","kind":12,"containerName":"get_Frequency_Homozygotes","line":524},{"definition":"my","containerName":"get_Frequency_Homozygotes","localvar":"my","kind":13,"name":"$total","line":525},{"line":525,"kind":13,"containerName":"get_Frequency_Homozygotes","name":"$self"},{"name":"get_number_individuals","containerName":"get_Frequency_Homozygotes","kind":12,"line":525},{"line":525,"name":"$marker","kind":13,"containerName":"get_Frequency_Homozygotes"},{"containerName":"get_Frequency_Homozygotes","localvar":"my","kind":13,"name":"$genotype","line":526,"definition":"my"},{"name":"$self","containerName":"get_Frequency_Homozygotes","kind":13,"line":526},{"name":"get_Genotypes","kind":12,"containerName":"get_Frequency_Homozygotes","line":526},{"name":"$marker","kind":13,"containerName":"get_Frequency_Homozygotes","line":526},{"definition":"my","name":"%alleles","containerName":"get_Frequency_Homozygotes","localvar":"my","kind":13,"line":527},{"line":527,"kind":13,"containerName":"get_Frequency_Homozygotes","name":"$genotype"},{"kind":12,"containerName":"get_Frequency_Homozygotes","name":"get_Alleles","line":527},{"containerName":"get_Frequency_Homozygotes","kind":13,"name":"$alleles","line":529},{"name":"$allelename","kind":13,"containerName":"get_Frequency_Homozygotes","line":529},{"line":530,"name":"$homozygote_count","containerName":"get_Frequency_Homozygotes","kind":13},{"name":"%alleles","kind":13,"containerName":"get_Frequency_Homozygotes","line":530},{"name":"$total","containerName":"get_Frequency_Homozygotes","kind":13,"line":533},{"containerName":"get_Frequency_Homozygotes","kind":13,"name":"$homozygote_count","line":533},{"kind":13,"containerName":"get_Frequency_Homozygotes","name":"$total","line":533}],"name":"get_Frequency_Homozygotes","containerName":"main::"},{"line":547,"range":{"end":{"character":9999,"line":568},"start":{"character":0,"line":547}},"kind":12,"signature":{"documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids\n\n\nsub remove_Individuals {\n    my ($self,@names) = @_;\n    my $i = 0;\n    my %namehash; # O(1) lookup will be faster I think\n    foreach my $n ( @names ) { $namehash{$n}++ }\n    my @tosplice;\n    foreach my $ind (  @{$self->{'_individuals'} || []} ) {\n\tunshift @tosplice, $i if( $namehash{$ind->unique_id} );\n\t$i++;\n    }\n    foreach my $index ( @tosplice ) {\n\tsplice(@{$self->{'_individuals'}}, $index,1);\n    }\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of Bio::PopGen::IndividualI objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\nsub get_Individuals{\n   my ($self,@args) = @_;\n   my @inds = @{$self->{'_individuals'} || []};\n   return unless @inds;\n   if( @args ) { # save a little time here if @args is empty\n       my ($id,$marker) = $self->_rearrange([qw(UNIQUE_ID MARKER)], @args);\n\n       \n       if( defined $id ) { \n\t   @inds = grep { $_->unique_id eq $id } @inds;\n       } elsif (defined $marker) {\n\t   @inds = grep { $_->has_Marker($marker) } @inds;\n       }\n   }\n   return @inds;\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of Bio::PopGen::GenotypeI objects\n Args    : -marker => name of the marker\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   my ($name) = $self->_rearrange([qw(MARKER)],@args);\n   if( defined $name ) {\n       return grep { defined $_ } map { $_->get_Genotypes(-marker => $name) } \n       @{$self->{'_individuals'} || []}\n   } \n   $self->warn(\"You needed to have provided a valid -marker value\");\n   return ();\n}\n\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $pop->get_marker_names;\n Function: Get the names of the markers\n Returns : Array of strings\n Args    : [optional] boolean flag to ignore internal cache status\n\n\n\nsub get_marker_names {\n    my ($self,$force) = @_;\n    return @{$self->{'_cached_markernames'} || []} \n      if( ! $force && defined $self->{'_cached_markernames'});\n    my %unique;\n    foreach my $n ( map { $_->get_marker_names } $self->get_Individuals() ) {\n\t$unique{$n}++;\n    }\n    my @nms = keys %unique;\n    if( $nms[0] =~ /^(Site|Codon)/ ) {\n\t# sort by site or codon number and do it in \n\t# a schwartzian transformation baby!\n\t@nms = map { $_->[1] } \n \t       sort { $a->[0] <=> $b->[0] }\n\t       map { [$_ =~ /^(?:Codon|Site)-(\\d+)/, $_] } @nms;\n    }\n    $self->{'_cached_markernames'} = [ @nms ];\n    return @{$self->{'_cached_markernames'} || []};\n}\n\n\n=head2 get_Marker\n\n Title   : get_Marker\n Usage   : my $marker = $population->get_Marker($name)\n Function: Get a Bio::PopGen::Marker object based on this population\n Returns : Bio::PopGen::MarkerI object\n Args    : name of the marker\n\n\n\nsub get_Marker{\n   my ($self,$markername) = @_;\n   my $marker;\n   # setup some caching too\n   if( defined $self->{'_allele_freqs'} &&\n       defined ($marker = $self->{'_allele_freqs'}->{$markername}) ) {\n       # marker is now set to the stored value\n   } else { \n       my @genotypes = $self->get_Genotypes(-marker => $markername);\n       $marker = Bio::PopGen::Marker->new(-name   => $markername);\n\n       if( ! @genotypes ) {\n\t   $self->warn(\"No genotypes for Marker $markername in the population\");\n       } else { \n\t   my %alleles;\n\t   my $count;\n\t   for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t     $count++; \n\t     $alleles{$al}++\n\t   }\n\t   foreach my $allele ( keys %alleles ) {\n\t       $marker->add_Allele_Frequency($allele, $alleles{$allele}/$count);\n\t   }\n       }\n       $self->{'_allele_freqs'}->{$markername} = $marker;\n   }\n   return $marker;\n}\n\n\n=head2 get_number_individuals\n\n Title   : get_number_individuals\n Usage   : my $count = $pop->get_number_individuals;\n Function: Get the count of the number of individuals\n Returns : integer >= 0\n Args    : none\n\n\n\nsub get_number_individuals{\n   my ($self,$markername) = @_;\n\n   if( $self->{'_forced_set_individuals'} ) {\n       return $self->{'_forced_set_individuals'};\n   }\n\n   unless( defined $markername ) {\n       return scalar @{$self->{'_individuals'} || []};\n   } else { \n       my $number =0;\n       foreach my $individual ( @{$self->{'_individuals'} || []} ) {\n\t   $number++ if( $individual->has_Marker($markername));\n       }\n       return $number;\n   }\n}\n\n=head2 set_number_individuals\n\n Title   : set_number_individuals\n    Usage   : $pop->set_number_individuals($num);\n Function: Fixes the number of individuals, call this with\n           0 to unset.\n           Only use this if you know what you are doing,\n           this is only relavent when you are just adding\n           allele frequency data for a population and want to\n           calculate something like theta\n Returns : none\n Args    : individual count, calling it with undef or 0\n            will reset the value to return a number\n            calculated from the number of individuals\n            stored for this population.\n\n\nsub set_number_individuals{\n   my ($self,$indcount) = @_;\n   return $self->{'_forced_set_individuals'} = $indcount;\n}\n\n\n=head2 get_Frequency_Homozygotes\n\n Title   : get_Frequency_Homozygotes\n Usage   : my $freq = $pop->get_Frequency_Homozygotes;\n Function: Calculate the frequency of homozygotes in the population\n Returns : fraction between 0 and 1\n Args    : $markername\n\n\n\nsub get_Frequency_Homozygotes{\n   my ($self,$marker,$allelename) = @_;\n   my ($homozygote_count) = 0;\n   return 0 if ! defined $marker || ! defined $allelename;\n   $marker = $marker->name if( defined $marker && \n\t\t\t       ref($marker) &&\n\t\t\t       ( $self->{'_checkisa'} ? \n\t\t\t\t $marker->isa('Bio::PopGen::MarkerI') : 1));\n   my $total = $self->get_number_individuals($marker);\n   foreach my $genotype ( $self->get_Genotypes($marker) ) {\n       my %alleles = map { $_ => 1} $genotype->get_Alleles();\n       # what to do for non-diploid situations?\n       if( $alleles{$allelename} ) {\n\t   $homozygote_count++ if( keys %alleles == 1);\n       }\n   }\n   return $total ? $homozygote_count / $total : 0;\n}\n\n=head2 get_Frequency_Heterozygotes\n\n Title   : get_Frequency_Heterozygotes\n Usage   : my $freq = $pop->get_Frequency_Homozygotes;\n Function: Calculate the frequency of homozygotes in the population\n Returns : fraction between 0 and 1\n Args    : $markername","parameters":[{"label":"$self"},{"label":"$marker"},{"label":"$allelename"}],"label":"get_Frequency_Heterozygotes($self,$marker,$allelename)"},"children":[{"definition":"my","localvar":"my","containerName":"get_Frequency_Heterozygotes","kind":13,"name":"$self","line":548},{"kind":13,"containerName":"get_Frequency_Heterozygotes","name":"$marker","line":548},{"name":"$allelename","containerName":"get_Frequency_Heterozygotes","kind":13,"line":548},{"definition":"my","name":"$heterozygote_count","kind":13,"localvar":"my","containerName":"get_Frequency_Heterozygotes","line":549},{"line":550,"containerName":"get_Frequency_Heterozygotes","kind":13,"name":"$marker"},{"name":"$allelename","containerName":"get_Frequency_Heterozygotes","kind":13,"line":550},{"line":551,"name":"$marker","containerName":"get_Frequency_Heterozygotes","kind":13},{"line":551,"kind":13,"containerName":"get_Frequency_Heterozygotes","name":"$marker"},{"name":"name","kind":12,"containerName":"get_Frequency_Heterozygotes","line":551},{"name":"$marker","containerName":"get_Frequency_Heterozygotes","kind":13,"line":551},{"line":551,"containerName":"get_Frequency_Heterozygotes","kind":13,"name":"$marker"},{"name":"$self","containerName":"get_Frequency_Heterozygotes","kind":13,"line":552},{"line":553,"name":"$marker","containerName":"get_Frequency_Heterozygotes","kind":13},{"kind":12,"containerName":"get_Frequency_Heterozygotes","name":"isa","line":553},{"name":"$marker","kind":13,"containerName":"get_Frequency_Heterozygotes","line":554},{"containerName":"get_Frequency_Heterozygotes","kind":13,"name":"$self","line":555},{"line":555,"name":"warn","containerName":"get_Frequency_Heterozygotes","kind":12},{"line":555,"name":"$marker","containerName":"get_Frequency_Heterozygotes","kind":13},{"containerName":"get_Frequency_Heterozygotes","localvar":"my","kind":13,"name":"$total","line":558,"definition":"my"},{"line":558,"name":"$self","kind":13,"containerName":"get_Frequency_Heterozygotes"},{"containerName":"get_Frequency_Heterozygotes","kind":12,"name":"get_number_individuals","line":558},{"line":558,"name":"$marker","kind":13,"containerName":"get_Frequency_Heterozygotes"},{"definition":"my","line":560,"kind":13,"localvar":"my","containerName":"get_Frequency_Heterozygotes","name":"$genotype"},{"line":560,"containerName":"get_Frequency_Heterozygotes","kind":13,"name":"$self"},{"line":560,"kind":12,"containerName":"get_Frequency_Heterozygotes","name":"get_Genotypes"},{"line":560,"kind":13,"containerName":"get_Frequency_Heterozygotes","name":"$marker"},{"definition":"my","kind":13,"localvar":"my","containerName":"get_Frequency_Heterozygotes","name":"%alleles","line":561},{"kind":13,"containerName":"get_Frequency_Heterozygotes","name":"$genotype","line":561},{"containerName":"get_Frequency_Heterozygotes","kind":12,"name":"get_Alleles","line":561},{"line":563,"containerName":"get_Frequency_Heterozygotes","kind":13,"name":"$alleles"},{"line":563,"name":"$allelename","kind":13,"containerName":"get_Frequency_Heterozygotes"},{"containerName":"get_Frequency_Heterozygotes","kind":13,"name":"$heterozygote_count","line":564},{"containerName":"get_Frequency_Heterozygotes","kind":13,"name":"%alleles","line":564},{"line":567,"name":"$total","kind":13,"containerName":"get_Frequency_Heterozygotes"},{"kind":13,"containerName":"get_Frequency_Heterozygotes","name":"$heterozygote_count","line":567},{"kind":13,"containerName":"get_Frequency_Heterozygotes","name":"$total","line":567}],"containerName":"main::","name":"get_Frequency_Heterozygotes","definition":"sub","detail":"($self,$marker,$allelename)"},{"children":[{"definition":"my","localvar":"my","containerName":"haploid_population","kind":13,"name":"$self","line":584},{"line":585,"name":"@inds","kind":13,"localvar":"my","containerName":"haploid_population","definition":"my"},{"name":"@marker_names","localvar":"my","containerName":"haploid_population","kind":13,"line":586,"definition":"my"},{"name":"$self","kind":13,"containerName":"haploid_population","line":586},{"name":"get_marker_names","kind":12,"containerName":"haploid_population","line":586},{"definition":"my","localvar":"my","containerName":"haploid_population","kind":13,"name":"$ind","line":588},{"kind":13,"containerName":"haploid_population","name":"$self","line":588},{"name":"get_Individuals","containerName":"haploid_population","kind":12,"line":588},{"definition":"my","name":"@chromosomes","kind":13,"localvar":"my","containerName":"haploid_population","line":589},{"definition":"my","line":590,"name":"$id","kind":13,"localvar":"my","containerName":"haploid_population"},{"line":590,"name":"$ind","kind":13,"containerName":"haploid_population"},{"line":590,"kind":12,"containerName":"haploid_population","name":"unique_id"},{"definition":"my","containerName":"haploid_population","localvar":"my","kind":13,"name":"$marker_name","line":592},{"line":592,"name":"@marker_names","kind":13,"containerName":"haploid_population"},{"definition":"my","kind":13,"localvar":"my","containerName":"haploid_population","name":"$genotype","line":593},{"line":593,"name":"$ind","containerName":"haploid_population","kind":13},{"line":593,"name":"get_Genotypes","containerName":"haploid_population","kind":12},{"name":"$marker_name","containerName":"haploid_population","kind":13,"line":593},{"definition":"my","name":"$i","kind":13,"localvar":"my","containerName":"haploid_population","line":594},{"line":595,"name":"$allele","localvar":"my","containerName":"haploid_population","kind":13,"definition":"my"},{"kind":13,"containerName":"haploid_population","name":"$genotype","line":595},{"name":"get_Alleles","containerName":"haploid_population","kind":12,"line":595},{"line":596,"name":"$chromosomes","containerName":"haploid_population","kind":13},{"line":596,"name":"$i","containerName":"haploid_population","kind":13},{"containerName":"haploid_population","kind":12,"name":"new","line":597},{"line":597,"kind":13,"containerName":"haploid_population","name":"$marker_name"},{"kind":13,"containerName":"haploid_population","name":"$id","line":598},{"line":599,"name":"$allele","containerName":"haploid_population","kind":13},{"kind":13,"containerName":"haploid_population","name":"$i","line":600},{"definition":"my","line":603,"name":"$chrom","localvar":"my","containerName":"haploid_population","kind":13},{"line":603,"name":"@chromosomes","containerName":"haploid_population","kind":13},{"definition":"my","line":604,"localvar":"my","containerName":"haploid_population","kind":13,"name":"$copyind"},{"kind":13,"containerName":"haploid_population","name":"$ind","line":604},{"kind":12,"containerName":"haploid_population","name":"new","line":604},{"kind":13,"containerName":"haploid_population","name":"$id","line":604},{"kind":13,"containerName":"haploid_population","name":"$chrom","line":605},{"name":"@inds","kind":13,"containerName":"haploid_population","line":606},{"line":606,"kind":13,"containerName":"haploid_population","name":"$ind"}],"containerName":"main::","name":"haploid_population","definition":"sub","detail":"($self)","line":583,"range":{"start":{"character":0,"line":583},"end":{"line":608,"character":9999}},"kind":12,"signature":{"label":"haploid_population($self)","documentation":"1;\n# $Id: Population.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::PopGen::Population\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PopGen::Population - A population of individuals\n\n=head1 SYNOPSIS\n\n  use Bio::PopGen::Population;\n  use Bio::PopGen::Individual;\n  my $population = Bio::PopGen::Population->new();\n  my $ind = Bio::PopGen::Individual->new(-unique_id => 'id');\n  $population->add_Individual($ind);\n\n  for my $ind ( $population->get_Individuals ) {\n    # iterate through the individuals\n  }\n\n  for my $name ( $population->get_marker_names ) {\n    my $marker = $population->get_Marker();\n  }\n\n  my $num_inds = $population->get_number_individuals;\n\n  my $homozygote_f   = $population->get_Frequency_Homozygotes;\n  my $heterozygote_f = $population->get_Frequency_Heterozygotes;\n\n  # make a population haploid by making fake chromosomes through\n  # haplotypes -- ala allele 1 is on chrom 1 and allele 2 is on chrom 2 \n  # the number of individuals created will thus be 2 x number in\n  # population\n  my $happop = $population->haploid_population;\n\n\n=head1 DESCRIPTION\n\nThis is a collection of individuals.  We'll have ways of generating\nL<Bio::PopGen::MarkerI> objects out so we can calculate allele_frequencies\nfor implementing the various statistical tests.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nemail or the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 CONTRIBUTORS\n\nMatthew Hahn, matthew.hahn-at-duke.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PopGen::Population;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::PopGen::Marker;\nuse Bio::PopGen::Genotype;\nour $CheckISA = 1;\nuse base qw(Bio::Root::Root Bio::PopGen::PopulationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::PopGen::Population->new();\n Function: Builds a new Bio::PopGen::Population object \n Returns : an instance of Bio::PopGen::Population\n Args    : -individuals => array ref of individuals (optional)\n           -name        => population name (optional)\n           -source      => a source tag (optional)\n           -description => a short description string of the population (optional)\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  $self->{'_individuals'} = [];\n  my ($name,$source,$description,\n      $inds,$checkisa) = $self->_rearrange([qw(NAME \n\t\t\t\t     SOURCE \n\t\t\t\t     DESCRIPTION\n\t\t\t\t     INDIVIDUALS\n\t\t\t\t     CHECKISA)], @args);\n  if( defined $inds ) {\n      if( ref($inds) !~ /ARRAY/i ) {\n\t  $self->warn(\"Need to provide a value array ref for the -individuals initialization flag\");\n      } else { \n\t  $self->add_Individual(@$inds);\n      }\n  }\n\n  defined $name   && $self->name($name);\n  defined $source && $self->source($source);\n  defined $description && $self->description($description);\n  $self->{'_checkisa'} = defined $checkisa ? $checkisa : $CheckISA;\n  return $self;\n}\n\n\n=head2 name\n\n Title   : name\n Usage   : my $name = $pop->name\n Function: Get the population name\n Returns : string representing population name\n Args    : [optional] string representing population name\n\n\n\nsub name{\n   my $self = shift;\n   return $self->{'_name'} = shift if @_;\n   return $self->{'_name'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $pop->description\n Function: Get the population description\n Returns : string representing population description\n Args    : [optional] string representing population description\n\n\n\nsub description{\n   my $self = shift;\n   return $self->{'_description'} = shift if @_;\n   return $self->{'_description'};\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $pop->source\n Function: Get the population source\n Returns : string representing population source\n Args    : [optional] string representing population source\n\n\n\nsub source{\n   my $self = shift;\n   return $self->{'_source'} = shift if @_;\n   return $self->{'_source'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : my $annotation_collection = $pop->annotation;\n Function: Get/set a Bio::AnnotationCollectionI for this population\n Returns : Bio::AnnotationCollectionI object\n Args    : [optional set] Bio::AnnotationCollectionI object\n\n\nsub annotation{\n   my ($self, $arg) = @_;\n   return $self->{_annotation} unless $arg;\n   $self->throw(\"Bio::AnnotationCollectionI required for argument\") unless\n       ref($arg) && $arg->isa('Bio::AnnotationCollectionI');\n   return $self->{_annotation} = $arg;\n}\n\n=head2 set_Allele_Frequency\n\n Title   : set_Allele_Frequency\n Usage   : $population->set_Allele_Frequency('marker' => { 'allele1' => 0.1});\n Function: Sets an allele frequency for a Marker for this Population\n           This allows the Population to not have individual individual\n           genotypes but rather a set of overall allele frequencies\n Returns : Count of the number of markers\n Args    : -name      => (string) marker name\n           -allele    => (string) allele name\n           -frequency => (double) allele frequency - must be between 0 and 1\n           OR\n\t   -frequencies => { 'marker1' => { 'allele1' => 0.01,\n\t\t\t\t\t    'allele2' => 0.99},\n\t\t\t     'marker2' => ...\n\t\t\t    }\n\n\nsub set_Allele_Frequency {\n   my ($self,@args) = @_;\n   my ($name,$allele, $frequency,\n       $frequencies) = $self->_rearrange([qw(NAME\n\t\t\t\t\t     ALLELE\n\t\t\t\t\t     FREQUENCY\n\t\t\t\t\t     FREQUENCIES\n\t\t\t\t\t     )], @args);\n   if( defined $frequencies ) { # this supercedes the res\n       if( ref($frequencies) =~ /HASH/i ) {\n\t   my ($markername,$alleles);\n\t   while( ($markername,$alleles) = each %$frequencies ) {\n\t       $self->{'_allele_freqs'}->{$markername} = \n\t\t   Bio::PopGen::Marker->new(-name        => $markername,\n\t\t\t\t\t   -allele_freq => $alleles);\n\t   }\n       } else { \n\t   $self->throw(\"Must provide a valid hashref for the -frequencies option\");\n       }\n   } else { \n       unless( defined $self->{'_allele_freqs'}->{$name} ) {\n\t   $self->{'_allele_freqs'}->{$name} = \n\t       Bio::PopGen::Marker->new(-name        => $name);\n       }\n       $self->{'_allele_freqs'}->{$name}->add_Allele_Frequency($allele,$frequency);\n   }\n   return scalar keys %{$self->{'_allele_freqs'}};\n}\n\n\n=head2 add_Individual\n\n Title   : add_Individual\n Usage   : $population->add_Individual(@individuals);\n Function: Add individuals to a population\n Returns : count of the current number in the object \n Args    : Array of Individuals\n\n\n\nsub add_Individual{\n    my ($self,@inds) = @_;\n    foreach my $i ( @inds ) {\n\tnext if ! defined $i;\n\t\n\tunless( $self->{'_checkisa'} ? $i->isa('Bio::PopGen::IndividualI') : 1  ) {\n\t    $self->warn(\"cannot add an individual ($i) which is not a Bio::PopGen::IndividualI\");\n\t    next;\n\t}\n    }\n    push @{$self->{'_individuals'}}, @inds;\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n\n=head2 remove_Individuals\n\n Title   : remove_Individuals\n Usage   : $population->remove_Individuals(@ids);\n Function: Remove individual(s) to a population\n Returns : count of the current number in the object \n Args    : Array of ids\n\n\nsub remove_Individuals {\n    my ($self,@names) = @_;\n    my $i = 0;\n    my %namehash; # O(1) lookup will be faster I think\n    foreach my $n ( @names ) { $namehash{$n}++ }\n    my @tosplice;\n    foreach my $ind (  @{$self->{'_individuals'} || []} ) {\n\tunshift @tosplice, $i if( $namehash{$ind->unique_id} );\n\t$i++;\n    }\n    foreach my $index ( @tosplice ) {\n\tsplice(@{$self->{'_individuals'}}, $index,1);\n    }\n    $self->{'_cached_markernames'} = undef;\n    $self->{'_allele_freqs'} = {};\n    return scalar @{$self->{'_individuals'} || []};\n}\n\n=head2 get_Individuals\n\n Title   : get_Individuals\n Usage   : my @inds = $pop->get_Individuals();\n Function: Return the individuals, alternatively restrict by a criteria\n Returns : Array of Bio::PopGen::IndividualI objects\n Args    : none if want all the individuals OR,\n           -unique_id => To get an individual with a specific id\n           -marker    => To only get individuals which have a genotype specific\n                        for a specific marker name\n\n\n\nsub get_Individuals{\n   my ($self,@args) = @_;\n   my @inds = @{$self->{'_individuals'} || []};\n   return unless @inds;\n   if( @args ) { # save a little time here if @args is empty\n       my ($id,$marker) = $self->_rearrange([qw(UNIQUE_ID MARKER)], @args);\n\n       \n       if( defined $id ) { \n\t   @inds = grep { $_->unique_id eq $id } @inds;\n       } elsif (defined $marker) {\n\t   @inds = grep { $_->has_Marker($marker) } @inds;\n       }\n   }\n   return @inds;\n}\n\n=head2 get_Genotypes\n\n Title   : get_Genotypes\n Usage   : my @genotypes = $pop->get_Genotypes(-marker => $name)\n Function: Get the genotypes for all the individuals for a specific\n           marker name\n Returns : Array of Bio::PopGen::GenotypeI objects\n Args    : -marker => name of the marker\n\n\n\nsub get_Genotypes{\n   my ($self,@args) = @_;\n   my ($name) = $self->_rearrange([qw(MARKER)],@args);\n   if( defined $name ) {\n       return grep { defined $_ } map { $_->get_Genotypes(-marker => $name) } \n       @{$self->{'_individuals'} || []}\n   } \n   $self->warn(\"You needed to have provided a valid -marker value\");\n   return ();\n}\n\n\n=head2 get_marker_names\n\n Title   : get_marker_names\n Usage   : my @names = $pop->get_marker_names;\n Function: Get the names of the markers\n Returns : Array of strings\n Args    : [optional] boolean flag to ignore internal cache status\n\n\n\nsub get_marker_names {\n    my ($self,$force) = @_;\n    return @{$self->{'_cached_markernames'} || []} \n      if( ! $force && defined $self->{'_cached_markernames'});\n    my %unique;\n    foreach my $n ( map { $_->get_marker_names } $self->get_Individuals() ) {\n\t$unique{$n}++;\n    }\n    my @nms = keys %unique;\n    if( $nms[0] =~ /^(Site|Codon)/ ) {\n\t# sort by site or codon number and do it in \n\t# a schwartzian transformation baby!\n\t@nms = map { $_->[1] } \n \t       sort { $a->[0] <=> $b->[0] }\n\t       map { [$_ =~ /^(?:Codon|Site)-(\\d+)/, $_] } @nms;\n    }\n    $self->{'_cached_markernames'} = [ @nms ];\n    return @{$self->{'_cached_markernames'} || []};\n}\n\n\n=head2 get_Marker\n\n Title   : get_Marker\n Usage   : my $marker = $population->get_Marker($name)\n Function: Get a Bio::PopGen::Marker object based on this population\n Returns : Bio::PopGen::MarkerI object\n Args    : name of the marker\n\n\n\nsub get_Marker{\n   my ($self,$markername) = @_;\n   my $marker;\n   # setup some caching too\n   if( defined $self->{'_allele_freqs'} &&\n       defined ($marker = $self->{'_allele_freqs'}->{$markername}) ) {\n       # marker is now set to the stored value\n   } else { \n       my @genotypes = $self->get_Genotypes(-marker => $markername);\n       $marker = Bio::PopGen::Marker->new(-name   => $markername);\n\n       if( ! @genotypes ) {\n\t   $self->warn(\"No genotypes for Marker $markername in the population\");\n       } else { \n\t   my %alleles;\n\t   my $count;\n\t   for my $al ( map { $_->get_Alleles} @genotypes ) {\n\t     $count++; \n\t     $alleles{$al}++\n\t   }\n\t   foreach my $allele ( keys %alleles ) {\n\t       $marker->add_Allele_Frequency($allele, $alleles{$allele}/$count);\n\t   }\n       }\n       $self->{'_allele_freqs'}->{$markername} = $marker;\n   }\n   return $marker;\n}\n\n\n=head2 get_number_individuals\n\n Title   : get_number_individuals\n Usage   : my $count = $pop->get_number_individuals;\n Function: Get the count of the number of individuals\n Returns : integer >= 0\n Args    : none\n\n\n\nsub get_number_individuals{\n   my ($self,$markername) = @_;\n\n   if( $self->{'_forced_set_individuals'} ) {\n       return $self->{'_forced_set_individuals'};\n   }\n\n   unless( defined $markername ) {\n       return scalar @{$self->{'_individuals'} || []};\n   } else { \n       my $number =0;\n       foreach my $individual ( @{$self->{'_individuals'} || []} ) {\n\t   $number++ if( $individual->has_Marker($markername));\n       }\n       return $number;\n   }\n}\n\n=head2 set_number_individuals\n\n Title   : set_number_individuals\n    Usage   : $pop->set_number_individuals($num);\n Function: Fixes the number of individuals, call this with\n           0 to unset.\n           Only use this if you know what you are doing,\n           this is only relavent when you are just adding\n           allele frequency data for a population and want to\n           calculate something like theta\n Returns : none\n Args    : individual count, calling it with undef or 0\n            will reset the value to return a number\n            calculated from the number of individuals\n            stored for this population.\n\n\nsub set_number_individuals{\n   my ($self,$indcount) = @_;\n   return $self->{'_forced_set_individuals'} = $indcount;\n}\n\n\n=head2 get_Frequency_Homozygotes\n\n Title   : get_Frequency_Homozygotes\n Usage   : my $freq = $pop->get_Frequency_Homozygotes;\n Function: Calculate the frequency of homozygotes in the population\n Returns : fraction between 0 and 1\n Args    : $markername\n\n\n\nsub get_Frequency_Homozygotes{\n   my ($self,$marker,$allelename) = @_;\n   my ($homozygote_count) = 0;\n   return 0 if ! defined $marker || ! defined $allelename;\n   $marker = $marker->name if( defined $marker && \n\t\t\t       ref($marker) &&\n\t\t\t       ( $self->{'_checkisa'} ? \n\t\t\t\t $marker->isa('Bio::PopGen::MarkerI') : 1));\n   my $total = $self->get_number_individuals($marker);\n   foreach my $genotype ( $self->get_Genotypes($marker) ) {\n       my %alleles = map { $_ => 1} $genotype->get_Alleles();\n       # what to do for non-diploid situations?\n       if( $alleles{$allelename} ) {\n\t   $homozygote_count++ if( keys %alleles == 1);\n       }\n   }\n   return $total ? $homozygote_count / $total : 0;\n}\n\n=head2 get_Frequency_Heterozygotes\n\n Title   : get_Frequency_Heterozygotes\n Usage   : my $freq = $pop->get_Frequency_Homozygotes;\n Function: Calculate the frequency of homozygotes in the population\n Returns : fraction between 0 and 1\n Args    : $markername\n\n\n\nsub get_Frequency_Heterozygotes{\n   my ($self,$marker,$allelename) = @_;\n   my ($heterozygote_count) = 0;\n   return 0 if ! defined $marker || ! defined $allelename;\n   $marker = $marker->name if( defined $marker && ref($marker) &&\n\t\t\t       ($self->{'_checkisa'} ? \n\t\t\t\t$marker->isa('Bio::PopGen::MarkerI') : 1));\n   if( ref($marker) ) {\n       $self->warn(\"Passed in a \".ref($marker). \" to has_Marker, expecting either a string or a Bio::PopGen::MarkerI\");\n       return 0;\n   }\n   my $total = $self->get_number_individuals($marker);\n\n   foreach my $genotype ( $self->get_Genotypes($marker) ) {\n       my %alleles = map { $_ => 1} $genotype->get_Alleles();\n       # what to do for non-diploid situations?\n       if( $alleles{$allelename} ) {\n\t   $heterozygote_count++ if( keys %alleles == 2);\n       }\n   }\n   return $total ? $heterozygote_count / $total : 0;\n}\n\n=head2 haploid_population\n\n Title   : haploid_population\n Usage   : my $pop = $population->haploid_population;\n Function: Make a new population where all the individuals\n           are haploid - effectively an individual out of each\n           chromosome an individual has.  \n Returns : L<Bio::PopGen::PopulationI>\n Args    : None","parameters":[{"label":"$self"}]}},{"containerName":"PopGen::Genotype","kind":12,"name":"Bio","line":597},{"line":609,"name":"$population","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"kind":13,"containerName":null,"name":"$self","line":609},{"line":609,"name":"new","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"$self","line":609},{"line":609,"name":"name","containerName":"main::","kind":12},{"line":610,"containerName":null,"kind":13,"name":"$self"},{"line":610,"name":"source","kind":12,"containerName":"main::"},{"name":"$self","kind":13,"containerName":null,"line":611},{"line":611,"containerName":"main::","kind":12,"name":"description"},{"name":"@inds","containerName":null,"kind":13,"line":612}]}