{"vars":[{"line":125,"kind":2,"containerName":"","name":"vars"},{"line":128,"name":"$MATCHPATTERN","kind":13,"containerName":null},{"line":128,"name":"strict","kind":2,"containerName":""},{"kind":13,"containerName":null,"name":"$GAP_SYMBOLS","line":129},{"name":"base","kind":2,"containerName":"","line":131},{"definition":"my","line":138,"name":"%valid_type","localvar":"my","containerName":null,"kind":13},{"containerName":"main::","name":"new","children":[{"definition":"my","line":177,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"@args","line":177},{"definition":"my","line":178,"kind":13,"localvar":"my","containerName":"new","name":"$self"},{"line":178,"kind":13,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","kind":13,"line":178},{"definition":"my","name":"$seq","localvar":"my","containerName":"new","kind":13,"line":180},{"line":180,"kind":13,"containerName":"new","name":"$id"},{"line":180,"containerName":"new","kind":13,"name":"$acc"},{"line":180,"kind":13,"containerName":"new","name":"$pid"},{"kind":13,"containerName":"new","name":"$ns","line":180},{"name":"$auth","containerName":"new","kind":13,"line":180},{"line":180,"kind":13,"containerName":"new","name":"$v"},{"kind":13,"containerName":"new","name":"$oid","line":180},{"line":181,"name":"$desc","containerName":"new","kind":13},{"line":181,"containerName":"new","kind":13,"name":"$description"},{"name":"$alphabet","containerName":"new","kind":13,"line":182},{"line":182,"name":"$given_id","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$is_circular","line":182},{"name":"$direct","kind":13,"containerName":"new","line":182},{"line":182,"name":"$ref_to_seq","containerName":"new","kind":13},{"name":"$len","kind":13,"containerName":"new","line":182},{"name":"$nowarnonempty","kind":13,"containerName":"new","line":182},{"line":183,"containerName":"new","kind":13,"name":"$self"},{"name":"_rearrange","containerName":"new","kind":12,"line":183},{"containerName":"new","kind":13,"name":"@args","line":201},{"line":204,"containerName":"new","kind":13,"name":"$self"},{"kind":13,"containerName":"new","name":"$nowarnonempty","line":204},{"containerName":"new","kind":13,"name":"$id","line":206},{"name":"$given_id","containerName":"new","kind":13,"line":206},{"line":207,"kind":13,"containerName":"new","name":"$id"},{"kind":13,"containerName":"new","name":"$given_id","line":207},{"kind":13,"containerName":"new","name":"$self","line":208},{"name":"throw","containerName":"new","kind":12,"line":208},{"line":212,"containerName":"new","kind":13,"name":"$given_id"},{"line":212,"containerName":"new","kind":13,"name":"$id"},{"line":212,"kind":13,"containerName":"new","name":"$given_id"},{"containerName":"new","kind":13,"name":"$len","line":216},{"line":216,"name":"$self","containerName":"new","kind":13},{"name":"length","containerName":"new","kind":12,"line":216},{"line":216,"kind":13,"containerName":"new","name":"$len"},{"name":"$alphabet","kind":13,"containerName":"new","line":220},{"name":"$self","containerName":"new","kind":13,"line":220},{"line":220,"kind":12,"containerName":"new","name":"alphabet"},{"line":220,"containerName":"new","kind":13,"name":"$alphabet"},{"line":225,"containerName":"new","kind":13,"name":"$direct"},{"name":"$ref_to_seq","kind":13,"containerName":"new","line":225},{"line":226,"name":"$self","containerName":"new","kind":13},{"name":"$alphabet","containerName":"new","kind":13,"line":227},{"containerName":"new","kind":13,"name":"$self","line":228},{"name":"_guess_alphabet","kind":12,"containerName":"new","line":228},{"line":233,"name":"$self","kind":13,"containerName":"new"},{"name":"seq","kind":12,"containerName":"new","line":233},{"name":"$seq","kind":13,"containerName":"new","line":233},{"line":233,"containerName":"new","kind":13,"name":"$seq"},{"line":236,"containerName":"new","kind":13,"name":"$id"},{"line":236,"name":"$self","kind":13,"containerName":"new"},{"line":236,"name":"display_id","containerName":"new","kind":12},{"line":236,"kind":13,"containerName":"new","name":"$id"},{"name":"$acc","containerName":"new","kind":13,"line":237},{"name":"$self","containerName":"new","kind":13,"line":237},{"line":237,"name":"accession_number","containerName":"new","kind":12},{"line":237,"kind":13,"containerName":"new","name":"$acc"},{"kind":13,"containerName":"new","name":"$pid","line":238},{"line":238,"name":"$self","kind":13,"containerName":"new"},{"line":238,"name":"primary_id","kind":12,"containerName":"new"},{"name":"$pid","kind":13,"containerName":"new","line":238},{"line":239,"name":"$desc","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":239},{"containerName":"new","kind":12,"name":"desc","line":239},{"name":"$desc","containerName":"new","kind":13,"line":239},{"line":240,"name":"$description","kind":13,"containerName":"new"},{"line":240,"containerName":"new","kind":13,"name":"$self"},{"line":240,"name":"description","kind":12,"containerName":"new"},{"name":"$description","kind":13,"containerName":"new","line":240},{"line":241,"name":"$is_circular","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":241},{"name":"is_circular","kind":12,"containerName":"new","line":241},{"containerName":"new","kind":13,"name":"$is_circular","line":241},{"line":242,"name":"$ns","containerName":"new","kind":13},{"line":242,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"namespace","line":242},{"name":"$ns","containerName":"new","kind":13,"line":242},{"line":243,"name":"$auth","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":243},{"line":243,"name":"authority","kind":12,"containerName":"new"},{"line":243,"name":"$auth","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$v","line":244},{"line":244,"containerName":"new","kind":13,"name":"$self"},{"name":"version","containerName":"new","kind":12,"line":244},{"line":244,"containerName":"new","kind":13,"name":"$v"},{"name":"$oid","kind":13,"containerName":"new","line":245},{"containerName":"new","kind":13,"name":"$self","line":245},{"line":245,"containerName":"new","kind":12,"name":"object_id"},{"kind":13,"containerName":"new","name":"$oid","line":245},{"name":"$self","kind":13,"containerName":"new","line":248}],"detail":"($class,@args)","definition":"sub","range":{"start":{"line":176,"character":0},"end":{"character":9999,"line":249}},"kind":12,"line":176,"signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"}},{"name":"SUPER","containerName":"new","kind":12,"line":178},{"kind":12,"name":"ref_to_seq","line":226},{"kind":12,"range":{"end":{"character":9999,"line":255},"start":{"line":251,"character":0}},"line":251,"definition":"sub","containerName":"main::","name":"direct_seq_set","children":[{"name":"$obj","localvar":"my","containerName":"direct_seq_set","kind":13,"line":252,"definition":"my"},{"name":"$obj","kind":13,"containerName":"direct_seq_set","line":253}]},{"definition":"sub","detail":"($obj,@args)","children":[{"definition":"my","line":273,"name":"$obj","containerName":"seq","localvar":"my","kind":13},{"name":"@args","containerName":"seq","kind":13,"line":273},{"name":"@args","containerName":"seq","kind":13,"line":275},{"name":"$obj","kind":13,"containerName":"seq","line":276},{"definition":"my","line":279,"kind":13,"localvar":"my","containerName":"seq","name":"$value"},{"line":279,"name":"$alphabet","kind":13,"containerName":"seq"},{"line":279,"containerName":"seq","kind":13,"name":"@args"},{"containerName":"seq","kind":13,"name":"@args","line":281},{"line":282,"name":"$value","kind":13,"containerName":"seq"},{"line":282,"name":"$obj","containerName":"seq","kind":13},{"name":"validate_seq","kind":12,"containerName":"seq","line":282},{"containerName":"seq","kind":13,"name":"$value","line":282},{"name":"$obj","containerName":"seq","kind":13,"line":283},{"containerName":"seq","kind":12,"name":"throw","line":283},{"name":"$is_changed_seq","kind":13,"localvar":"my","containerName":"seq","line":290,"definition":"my"},{"name":"$obj","kind":13,"containerName":"seq","line":291},{"kind":13,"containerName":"seq","name":"$value","line":291},{"containerName":"seq","kind":13,"name":"$obj","line":292},{"containerName":"seq","kind":13,"name":"$value","line":292},{"line":294,"name":"$alphabet","kind":13,"containerName":"seq"},{"line":296,"name":"$obj","containerName":"seq","kind":13},{"name":"alphabet","containerName":"seq","kind":12,"line":296},{"line":296,"containerName":"seq","kind":13,"name":"$alphabet"},{"kind":13,"containerName":"seq","name":"$is_changed_seq","line":298},{"line":300,"name":"$obj","kind":13,"containerName":"seq"},{"line":300,"kind":12,"containerName":"seq","name":"alphabet"},{"line":302,"kind":13,"containerName":"seq","name":"$obj"},{"line":302,"name":"_guess_alphabet","kind":12,"containerName":"seq"},{"line":305,"kind":13,"containerName":"seq","name":"$obj"},{"line":305,"name":"length","kind":12,"containerName":"seq"},{"containerName":"seq","kind":13,"name":"$is_changed_seq","line":305},{"kind":13,"containerName":"seq","name":"$obj","line":305},{"name":"$obj","kind":13,"containerName":"seq","line":307}],"containerName":"main::","name":"seq","signature":{"parameters":[{"label":"$obj"},{"label":"@args"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).","label":"seq($obj,@args)"},"line":272,"kind":12,"range":{"start":{"line":272,"character":0},"end":{"line":308,"character":9999}}},{"line":291,"kind":12,"containerName":"length","name":"CORE"},{"definition":"sub","detail":"($self,$seqstr)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"validate_seq","line":334},{"name":"$seqstr","kind":13,"containerName":"validate_seq","line":334},{"kind":13,"containerName":"validate_seq","name":"$seqstr","line":335},{"line":335,"containerName":"validate_seq","kind":13,"name":"$seqstr"},{"kind":13,"containerName":"validate_seq","name":"$self","line":335},{"containerName":"validate_seq","kind":12,"name":"seq","line":335},{"line":336,"kind":13,"containerName":"validate_seq","name":"$seqstr"},{"line":337,"kind":13,"containerName":"validate_seq","name":"$seqstr"},{"name":"$seqstr","kind":13,"containerName":"validate_seq","line":338},{"name":"$self","kind":13,"containerName":"validate_seq","line":339},{"line":339,"name":"warn","kind":12,"containerName":"validate_seq"},{"name":"$seqstr","kind":13,"containerName":"validate_seq","line":340}],"name":"validate_seq","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$seqstr"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.","label":"validate_seq($self,$seqstr)"},"line":333,"range":{"start":{"line":333,"character":0},"end":{"character":9999,"line":344}},"kind":12},{"kind":12,"containerName":"length","name":"CORE","line":337},{"definition":"sub","name":"subseq","containerName":"main::","children":[{"line":367,"name":"$self","localvar":"my","containerName":"subseq","kind":13,"definition":"my"},{"line":368,"containerName":"subseq","localvar":"my","kind":13,"name":"@args","definition":"my"},{"line":369,"localvar":"my","kind":13,"containerName":"subseq","name":"$start","definition":"my"},{"containerName":"subseq","kind":13,"name":"$end","line":369},{"containerName":"subseq","kind":13,"name":"$nogap","line":369},{"line":369,"name":"$replace","containerName":"subseq","kind":13},{"name":"$self","kind":13,"containerName":"subseq","line":369},{"kind":12,"containerName":"subseq","name":"_rearrange","line":369},{"line":372,"name":"@args","kind":13,"containerName":"subseq"},{"line":375,"localvar":"my","kind":13,"containerName":"subseq","name":"$dummy","definition":"my"},{"kind":13,"containerName":"subseq","name":"$replace","line":375},{"name":"$self","kind":13,"containerName":"subseq","line":375},{"line":375,"containerName":"subseq","kind":12,"name":"alphabet"},{"line":375,"name":"$replace","kind":13,"containerName":"subseq"},{"line":377,"name":"$start","kind":13,"containerName":"subseq"},{"name":"$start","kind":13,"containerName":"subseq","line":377},{"line":377,"kind":12,"containerName":"subseq","name":"isa"},{"name":"$loc","localvar":"my","kind":13,"containerName":"subseq","line":378,"definition":"my"},{"line":378,"containerName":"subseq","kind":13,"name":"$start"},{"definition":"my","containerName":"subseq","localvar":"my","kind":13,"name":"$seq","line":379},{"definition":"my","line":380,"name":"$subloc","localvar":"my","kind":13,"containerName":"subseq"},{"line":380,"name":"$loc","kind":13,"containerName":"subseq"},{"name":"each_Location","kind":12,"containerName":"subseq","line":380},{"line":381,"name":"$piece","localvar":"my","kind":13,"containerName":"subseq","definition":"my"},{"name":"$self","containerName":"subseq","kind":13,"line":381},{"line":381,"kind":12,"containerName":"subseq","name":"subseq"},{"name":"$subloc","containerName":"subseq","kind":13,"line":381},{"line":381,"name":"start","containerName":"subseq","kind":12},{"kind":13,"containerName":"subseq","name":"$subloc","line":382},{"line":382,"name":"end","containerName":"subseq","kind":12},{"line":383,"kind":13,"containerName":"subseq","name":"$replace"},{"name":"$nogap","kind":13,"containerName":"subseq","line":384},{"line":385,"name":"$piece","containerName":"subseq","kind":13},{"line":385,"kind":13,"containerName":"subseq","name":"$nogap"},{"name":"$subloc","containerName":"subseq","kind":13,"line":386},{"name":"strand","containerName":"subseq","kind":12,"line":386},{"line":387,"kind":13,"containerName":"subseq","name":"$piece"},{"line":387,"name":"new","kind":12,"containerName":"subseq"},{"line":387,"name":"$piece","kind":13,"containerName":"subseq"},{"line":387,"containerName":"subseq","kind":12,"name":"revcom"},{"line":387,"name":"seq","containerName":"subseq","kind":12},{"kind":13,"containerName":"subseq","name":"$seq","line":389},{"line":389,"name":"$piece","containerName":"subseq","kind":13},{"kind":13,"containerName":"subseq","name":"$seq","line":391},{"name":"$start","containerName":"subseq","kind":13,"line":392},{"name":"$end","kind":13,"containerName":"subseq","line":392},{"line":393,"kind":13,"containerName":"subseq","name":"$start"},{"line":393,"name":"$end","kind":13,"containerName":"subseq"},{"name":"$self","kind":13,"containerName":"subseq","line":394},{"line":394,"name":"throw","kind":12,"containerName":"subseq"},{"name":"$start","kind":13,"containerName":"subseq","line":397},{"name":"$self","kind":13,"containerName":"subseq","line":398},{"name":"throw","kind":12,"containerName":"subseq","line":398},{"line":400,"containerName":"subseq","kind":13,"name":"$end"},{"containerName":"subseq","kind":13,"name":"$self","line":400},{"containerName":"subseq","kind":12,"name":"length","line":400},{"containerName":"subseq","kind":13,"name":"$self","line":401},{"line":401,"kind":12,"containerName":"subseq","name":"throw"},{"kind":13,"containerName":"subseq","name":"$self","line":401},{"containerName":"subseq","kind":12,"name":"length","line":401},{"name":"$start","containerName":"subseq","kind":13,"line":405},{"definition":"my","localvar":"my","containerName":"subseq","kind":13,"name":"@ss_args","line":406},{"definition":"my","line":407,"name":"$seqstr","kind":13,"localvar":"my","containerName":"subseq"},{"kind":13,"containerName":"subseq","name":"@ss_args","line":407},{"line":408,"name":"$seqstr","kind":13,"containerName":"subseq"},{"line":408,"containerName":"subseq","kind":13,"name":"$nogap"},{"line":409,"name":"$seqstr","containerName":"subseq","kind":13},{"line":412,"name":"$self","kind":13,"containerName":"subseq"},{"line":412,"name":"warn","kind":12,"containerName":"subseq"},{"line":412,"name":"$self","containerName":"subseq","kind":13},{"name":"$start","kind":13,"containerName":"subseq","line":412},{"kind":13,"containerName":"subseq","name":"$end","line":412},{"line":412,"name":"$replace","kind":13,"containerName":"subseq"},{"kind":13,"containerName":"subseq","name":"$nogap","line":412}],"range":{"start":{"character":0,"line":366},"end":{"character":9999,"line":415}},"kind":12,"line":366},{"line":375,"containerName":"PrimarySeq","kind":12,"name":"Bio"},{"containerName":"PrimarySeq","kind":12,"name":"Bio","line":387},{"line":444,"kind":12,"range":{"end":{"character":9999,"line":459},"start":{"character":0,"line":444}},"definition":"sub","children":[{"line":445,"localvar":"my","kind":13,"containerName":"length","name":"$self","definition":"my"},{"name":"$len","kind":13,"localvar":"my","containerName":"length","line":446,"definition":"my"},{"containerName":"length","kind":13,"name":"$self","line":446},{"line":446,"name":"seq","containerName":"length","kind":12},{"definition":"my","line":449,"name":"$val","localvar":"my","kind":13,"containerName":"length"},{"line":450,"name":"$val","containerName":"length","kind":13},{"kind":13,"containerName":"length","name":"$len","line":450},{"name":"$len","containerName":"length","kind":13,"line":450},{"line":450,"name":"$val","kind":13,"containerName":"length"},{"name":"$self","kind":13,"containerName":"length","line":451},{"name":"throw","containerName":"length","kind":12,"line":451},{"name":"$val","kind":13,"containerName":"length","line":452},{"name":"$self","containerName":"length","kind":13,"line":454},{"name":"$val","containerName":"length","kind":13,"line":454},{"kind":13,"containerName":"length","name":"$self","line":455},{"containerName":"length","kind":13,"name":"$self","line":456},{"line":458,"kind":13,"containerName":"length","name":"$len"}],"containerName":"main::","name":"length"},{"kind":12,"containerName":"length","name":"CORE","line":446},{"kind":12,"range":{"start":{"line":487,"character":0},"end":{"character":9999,"line":493}},"line":487,"signature":{"label":"display_id($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None"},"containerName":"main::","name":"display_id","children":[{"line":488,"kind":13,"localvar":"my","containerName":"display_id","name":"$obj","definition":"my"},{"kind":13,"containerName":"display_id","name":"$value","line":488},{"containerName":"display_id","kind":13,"name":"$value","line":489},{"line":490,"name":"$obj","kind":13,"containerName":"display_id"},{"kind":13,"containerName":"display_id","name":"$value","line":490},{"line":492,"name":"$obj","kind":13,"containerName":"display_id"}],"detail":"($obj,$value)","definition":"sub"},{"line":519,"kind":12,"range":{"end":{"line":529,"character":9999},"start":{"character":0,"line":519}},"signature":{"parameters":[{"label":"$obj"},{"label":"$acc"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting","label":"accession_number($obj,$acc)"},"children":[{"kind":13,"localvar":"my","containerName":"accession_number","name":"$obj","line":520,"definition":"my"},{"kind":13,"containerName":"accession_number","name":"$acc","line":520},{"name":"$acc","containerName":"accession_number","kind":13,"line":522},{"name":"$obj","kind":13,"containerName":"accession_number","line":523},{"line":523,"name":"$acc","kind":13,"containerName":"accession_number"},{"line":525,"kind":13,"containerName":"accession_number","name":"$acc"},{"line":525,"kind":13,"containerName":"accession_number","name":"$obj"},{"name":"$acc","containerName":"accession_number","kind":13,"line":526},{"kind":13,"containerName":"accession_number","name":"$acc","line":526},{"line":528,"name":"$acc","containerName":"accession_number","kind":13}],"name":"accession_number","containerName":"main::","definition":"sub","detail":"($obj,$acc)"},{"kind":12,"range":{"end":{"character":9999,"line":558},"start":{"line":548,"character":0}},"line":548,"definition":"sub","name":"primary_id","containerName":"main::","children":[{"line":549,"localvar":"my","containerName":"primary_id","kind":13,"name":"$obj","definition":"my"},{"line":552,"name":"$obj","containerName":"primary_id","kind":13},{"line":554,"kind":13,"containerName":"primary_id","name":"$obj"},{"line":557,"containerName":"primary_id","kind":13,"name":"$obj"}]},{"signature":{"label":"alphabet($obj,$value)","documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'","parameters":[{"label":"$obj"},{"label":"$value"}]},"kind":12,"range":{"end":{"line":591,"character":9999},"start":{"character":0,"line":579}},"line":579,"detail":"($obj,$value)","definition":"sub","name":"alphabet","containerName":"main::","children":[{"definition":"my","name":"$obj","containerName":"alphabet","localvar":"my","kind":13,"line":580},{"line":580,"containerName":"alphabet","kind":13,"name":"$value"},{"line":581,"name":"$value","containerName":"alphabet","kind":13},{"line":582,"containerName":"alphabet","kind":13,"name":"$value"},{"name":"$value","containerName":"alphabet","kind":13,"line":582},{"containerName":"alphabet","kind":13,"name":"$valid_type","line":583},{"line":583,"kind":13,"containerName":"alphabet","name":"$value"},{"line":584,"containerName":"alphabet","kind":13,"name":"$obj"},{"containerName":"alphabet","kind":12,"name":"throw","line":584},{"line":585,"containerName":"alphabet","kind":13,"name":"%valid_type"},{"line":588,"name":"$obj","kind":13,"containerName":"alphabet"},{"kind":13,"containerName":"alphabet","name":"$value","line":588},{"line":590,"kind":13,"containerName":"alphabet","name":"$obj"}]},{"line":609,"kind":12,"range":{"end":{"line":614,"character":9999},"start":{"line":609,"character":0}},"children":[{"definition":"my","line":610,"name":"$self","localvar":"my","kind":13,"containerName":"desc"},{"line":612,"containerName":"desc","kind":13,"name":"$self"},{"containerName":"desc","kind":13,"name":"$self","line":613}],"name":"desc","containerName":"main::","definition":"sub"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"can_call_new","children":[{"definition":"my","line":629,"name":"$self","localvar":"my","kind":13,"containerName":"can_call_new"}],"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :","label":"can_call_new($self)"},"kind":12,"range":{"start":{"line":628,"character":0},"end":{"character":9999,"line":632}},"line":628},{"range":{"end":{"line":648,"character":9999},"start":{"character":0,"line":646}},"kind":12,"line":646,"definition":"sub","containerName":"main::","name":"id","children":[{"line":647,"kind":12,"containerName":"id","name":"display_id"}]},{"children":[{"line":661,"kind":13,"localvar":"my","containerName":"is_circular","name":"$self","definition":"my"},{"line":663,"name":"$self","kind":13,"containerName":"is_circular"},{"containerName":"is_circular","kind":13,"name":"$self","line":664}],"containerName":"main::","name":"is_circular","definition":"sub","line":660,"kind":12,"range":{"start":{"line":660,"character":0},"end":{"character":9999,"line":665}}},{"children":[{"line":687,"kind":12,"containerName":"object_id","name":"accession_number"}],"containerName":"main::","name":"object_id","definition":"sub","line":686,"kind":12,"range":{"end":{"line":688,"character":9999},"start":{"character":0,"line":686}}},{"children":[{"definition":"my","line":704,"name":"$self","localvar":"my","kind":13,"containerName":"version"},{"kind":13,"containerName":"version","name":"$value","line":704},{"line":705,"kind":13,"containerName":"version","name":"$value"},{"line":706,"name":"$self","kind":13,"containerName":"version"},{"kind":13,"containerName":"version","name":"$value","line":706},{"line":708,"kind":13,"containerName":"version","name":"$self"}],"containerName":"main::","name":"version","definition":"sub","detail":"($self,$value)","line":703,"kind":12,"range":{"end":{"character":9999,"line":709},"start":{"character":0,"line":703}},"signature":{"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my $self = shift;\n\n    return $self->{'is_circular'} = shift if @_;\n    return $self->{'is_circular'};\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: A string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences.\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: A number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept.\n\n Returns : A number","parameters":[{"label":"$self"},{"label":"$value"}],"label":"version($self,$value)"}},{"signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my $self = shift;\n\n    return $self->{'is_circular'} = shift if @_;\n    return $self->{'is_circular'};\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: A string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences.\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: A number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept.\n\n Returns : A number\n\n\nsub version{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t $self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: A string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org).\n\n Returns : A scalar","label":"authority($obj,$value)"},"range":{"end":{"character":9999,"line":730},"start":{"line":724,"character":0}},"kind":12,"line":724,"detail":"($obj,$value)","definition":"sub","containerName":"main::","name":"authority","children":[{"definition":"my","containerName":"authority","localvar":"my","kind":13,"name":"$obj","line":725},{"line":725,"kind":13,"containerName":"authority","name":"$value"},{"line":726,"containerName":"authority","kind":13,"name":"$value"},{"name":"$obj","kind":13,"containerName":"authority","line":727},{"containerName":"authority","kind":13,"name":"$value","line":727},{"containerName":"authority","kind":13,"name":"$obj","line":729}]},{"detail":"($self,$value)","definition":"sub","name":"namespace","containerName":"main::","children":[{"line":746,"name":"$self","localvar":"my","containerName":"namespace","kind":13,"definition":"my"},{"name":"$value","kind":13,"containerName":"namespace","line":746},{"line":747,"name":"$value","kind":13,"containerName":"namespace"},{"line":748,"name":"$self","containerName":"namespace","kind":13},{"line":748,"name":"$value","containerName":"namespace","kind":13},{"line":750,"name":"$self","kind":13,"containerName":"namespace"}],"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my $self = shift;\n\n    return $self->{'is_circular'} = shift if @_;\n    return $self->{'is_circular'};\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: A string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences.\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: A number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept.\n\n Returns : A number\n\n\nsub version{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t $self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: A string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org).\n\n Returns : A scalar\n\n\nsub authority {\n    my ($obj,$value) = @_;\n    if( defined $value) {\n\t\t $obj->{'authority'} = $value;\n    }\n    return $obj->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection.\n\n Returns : A scalar","label":"namespace($self,$value)"},"range":{"end":{"line":751,"character":9999},"start":{"character":0,"line":745}},"kind":12,"line":745},{"line":774,"range":{"end":{"character":9999,"line":776},"start":{"character":0,"line":774}},"kind":12,"children":[{"line":775,"kind":12,"containerName":"display_name","name":"display_id"}],"containerName":"main::","name":"display_name","definition":"sub"},{"line":794,"kind":12,"range":{"end":{"character":9999,"line":796},"start":{"line":794,"character":0}},"definition":"sub","children":[{"line":795,"containerName":"description","kind":12,"name":"desc"}],"containerName":"main::","name":"description"},{"containerName":"main::","name":"_guess_alphabet","children":[{"name":"$self","containerName":"_guess_alphabet","localvar":"my","kind":13,"line":862,"definition":"my"},{"definition":"my","containerName":"_guess_alphabet","localvar":"my","kind":13,"name":"$type","line":863},{"localvar":"my","kind":13,"containerName":"_guess_alphabet","name":"$str","line":867,"definition":"my"},{"name":"$self","kind":13,"containerName":"_guess_alphabet","line":867},{"name":"seq","containerName":"_guess_alphabet","kind":12,"line":867},{"line":869,"name":"$str","containerName":"_guess_alphabet","kind":13},{"line":871,"localvar":"my","kind":13,"containerName":"_guess_alphabet","name":"$total","definition":"my"},{"containerName":"_guess_alphabet","kind":13,"name":"$str","line":871},{"name":"$total","containerName":"_guess_alphabet","kind":13,"line":872},{"line":873,"name":"$self","containerName":"_guess_alphabet","kind":13},{"line":874,"containerName":"_guess_alphabet","kind":13,"name":"$self"},{"line":874,"name":"warn","containerName":"_guess_alphabet","kind":12},{"kind":13,"localvar":"my","containerName":"_guess_alphabet","name":"$u","line":880,"definition":"my"},{"line":880,"name":"$str","containerName":"_guess_alphabet","kind":13},{"line":884,"containerName":"_guess_alphabet","localvar":"my","kind":13,"name":"$atgc","definition":"my"},{"line":884,"containerName":"_guess_alphabet","kind":13,"name":"$str"},{"name":"$atgc","kind":13,"containerName":"_guess_alphabet","line":886},{"line":886,"name":"$total","kind":13,"containerName":"_guess_alphabet"},{"containerName":"_guess_alphabet","kind":13,"name":"$type","line":887},{"name":"$atgc","kind":13,"containerName":"_guess_alphabet","line":888},{"containerName":"_guess_alphabet","kind":13,"name":"$u","line":888},{"kind":13,"containerName":"_guess_alphabet","name":"$total","line":888},{"containerName":"_guess_alphabet","kind":13,"name":"$type","line":889},{"name":"$type","containerName":"_guess_alphabet","kind":13,"line":891},{"containerName":"_guess_alphabet","kind":13,"name":"$self","line":894},{"line":894,"name":"alphabet","containerName":"_guess_alphabet","kind":12},{"kind":13,"containerName":"_guess_alphabet","name":"$type","line":894},{"line":895,"name":"$type","kind":13,"containerName":"_guess_alphabet"}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":896},"start":{"line":861,"character":0}},"line":861,"signature":{"label":"_guess_alphabet($self)","documentation":"1;\n# $Id: PrimarySeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::PrimarySeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::PrimarySeq - Bioperl lightweight Sequence Object\n\n=head1 SYNOPSIS\n\n  # Bio::SeqIO for file reading, Bio::DB::GenBank for\n  # database reading\n\n  use Bio::Seq;\n  use Bio::SeqIO;\n  use Bio::DB::GenBank;\n\n  # make from memory\n\n  $seqobj = Bio::PrimarySeq->new ( -seq => 'ATGGGGTGGGCGGTGGGTGGTTTG',\n                                   -id  => 'GeneFragment-12',\n                                   -accession_number => 'X78121',\n                                   -alphabet => 'dna',\n                                   -is_circular => 1 );\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \"\\n\";\n\n  # read from file\n\n  $inputstream = Bio::SeqIO->new(-file => \"myseq.fa\",\n                                 -format => 'Fasta');\n  $seqobj = $inputstream->next_seq();\n  print \"Sequence \", $seqobj->id(), \" and desc \", $seqobj->desc, \"\\n\";\n\n  # to get out parts of the sequence.\n\n  print \"Sequence \", $seqobj->id(), \" with accession \",\n    $seqobj->accession_number, \" and desc \", $seqobj->desc, \"\\n\";\n\n  $string  = $seqobj->seq();\n  $string2 = $seqobj->subseq(1,40);\n\n=head1 DESCRIPTION\n\nPrimarySeq is a lightweight Sequence object, storing the sequence, its\nname, a computer-useful unique name, and other fundamental attributes.\nIt does not contain sequence features or other information.  To have a\nsequence with sequence features you should use the Seq object which uses\nthis object.\n\nAlthough new users will use Bio::PrimarySeq a lot, in general you will\nbe using it from the Bio::Seq object. For more information on Bio::Seq\nsee L<Bio::Seq>. For interest you might like to know that\nBio::Seq has-a Bio::PrimarySeq and forwards most of the function calls\nto do with sequence to it (the has-a relationship lets us get out of a\notherwise nasty cyclical reference in Perl which would leak memory).\n\nSequence objects are defined by the Bio::PrimarySeqI interface, and this\nobject is a pure Perl implementation of the interface. If that's\ngibberish to you, don't worry. The take home message is that this\nobject is the bioperl default sequence object, but other people can\nuse their own objects as sequences if they so wish. If you are\ninterested in wrapping your own objects as compliant Bioperl sequence\nobjects, then you should read the Bio::PrimarySeqI documentation\n\nThe documentation of this object is a merge of the Bio::PrimarySeq and\nBio::PrimarySeqI documentation.  This allows all the methods which you can\ncall on sequence objects here.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::PrimarySeq;\nuse vars qw($MATCHPATTERN $GAP_SYMBOLS);\nuse strict;\n\n$MATCHPATTERN = 'A-Za-z\\-\\.\\*\\?=~';\n$GAP_SYMBOLS = '-~';\n\nuse base qw(Bio::Root::Root Bio::PrimarySeqI\n\t    Bio::IdentifiableI Bio::DescribableI);\n\n#\n# setup the allowed values for alphabet()\n#\n\nmy %valid_type = map {$_, 1} qw( dna rna protein );\n\n=head2 new\n\n Title   : new\n Usage   : $seq    = Bio::PrimarySeq->new( -seq => 'ATGGGGGTGGTGGTACCCT',\n                                           -id  => 'human_id',\n\t\t\t\t\t   -accession_number => 'AL000012',\n\t\t\t\t\t   );\n\n Function: Returns a new primary seq object from\n           basic constructors, being a string for the sequence\n           and strings for id and accession_number.\n\n           Note that you can provide an empty sequence string. However, in\n           this case you MUST specify the type of sequence you wish to\n           initialize by the parameter -alphabet. See alphabet() for possible\n           values.\n Returns : a new Bio::PrimarySeq object\n Args    : -seq         => sequence string\n           -display_id  => display id of the sequence (locus name)\n           -accession_number => accession number\n           -primary_id  => primary id (Genbank id)\n           -version     => version number\n           -namespace   => the namespace for the accession\n           -authority   => the authority for the namespace\n           -description => description text\n           -desc        => alias for description\n           -alphabet    => sequence type (alphabet) (dna|rna|protein)\n           -id          => alias for display id\n           -is_circular => boolean field for whether or not sequence is circular\n           -direct      => boolean field for directly setting sequence (requires alphabet also set)\n           -ref_to_seq  => boolean field indicating the sequence is a reference (?!?)\n           -nowarnonempty => boolean field for whether or not to warn when sequence is empty\n\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($seq,$id,$acc,$pid,$ns,$auth,$v,$oid,\n       $desc,$description,\n       $alphabet,$given_id,$is_circular,$direct,$ref_to_seq,$len,$nowarnonempty) =\n\t$self->_rearrange([qw(SEQ\n\t\t\t      DISPLAY_ID\n\t\t\t      ACCESSION_NUMBER\n\t\t\t      PRIMARY_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      OBJECT_ID\n\t\t\t      DESC\n\t\t\t      DESCRIPTION\n\t\t\t      ALPHABET\n\t\t\t      ID\n\t\t\t      IS_CIRCULAR\n\t\t\t      DIRECT\n\t\t\t      REF_TO_SEQ\n\t\t\t      LENGTH\n            NOWARNONEMPTY\n\t\t\t      )],\n\t\t\t  @args);\n  \n    # private var _nowarnonempty, need to be set before calling _guess_alphabet\n    $self->{'_nowarnonempty'} = $nowarnonempty; \n\n    if( defined $id && defined $given_id ) {\n      if( $id ne $given_id ) {\n        $self->throw(\"Provided both id and display_id constructor \".\n            \"functions. [$id] [$given_id]\");\n      }\n    }\n    if( defined $given_id ) { $id = $given_id; }\n\n    # let's set the length before the seq -- if there is one, this length is\n    # going to be invalidated\n    defined $len && $self->length($len);\n\n    # if alphabet is provided we set it first, so that it won't be guessed\n    # when the sequence is set\n    $alphabet && $self->alphabet($alphabet);\n\n    # if there is an alphabet, and direct is passed in, assume the alphabet\n    # and sequence is ok\n    \n    if( $direct && $ref_to_seq) {\n      $self->{'seq'} = $$ref_to_seq;\n        if( ! $alphabet ) {\n          $self->_guess_alphabet();\n        } # else it has been set already above\n    } else {\n\t\t #\tprint STDERR \"DEBUG: setting sequence to [$seq]\\n\";\n\t\t # note: the sequence string may be empty\n\t\t $self->seq($seq) if defined($seq);\n\t }\n\n    defined $id  && $self->display_id($id);\n    $acc         && $self->accession_number($acc);\n    defined $pid && $self->primary_id($pid);\n    $desc        && $self->desc($desc);\n    $description && $self->description($description);\n    $is_circular && $self->is_circular($is_circular);\n    $ns          && $self->namespace($ns);\n    $auth        && $self->authority($auth);\n    defined($v)  && $self->version($v);\n    defined($oid) && $self->object_id($oid);\n\n\n    return $self;\n}\n\nsub direct_seq_set {\n    my $obj = shift;\n    return $obj->{'seq'} = shift if @_;\n    return;\n}\n\n\n=head2 seq\n\n Title   : seq\n Usage   : $string    = $obj->seq()\n Function: Returns the sequence as a string of letters. The\n           case of the letters is left up to the implementer.\n           Suggested cases are upper case for proteins and lower case for\n           DNA sequence (IUPAC standard), but you should not rely on this.\n Returns : A scalar\n Args    : Optionally on set the new value (a string). An optional second\n           argument presets the alphabet (otherwise it will be guessed).\n\n\nsub seq {\n   my ($obj,@args) = @_;\n\n   if( scalar(@args) == 0 ) {\n       return $obj->{'seq'};\n   }\n\n   my ($value,$alphabet) = @args;\n\n   if(@args) {\n       if(defined($value) && (! $obj->validate_seq($value))) {\n\t   $obj->throw(\"Attempting to set the sequence to [$value] \".\n\t\t\t\t\t\t\t\"which does not look healthy\");\n\t\t}\n       # if a sequence was already set we make sure that we re-adjust the\n       # alphabet, otherwise we skip guessing if alphabet is already set\n       # note: if the new seq is empty or undef, we don't consider that a\n       # change (we wouldn't have anything to guess on anyway)\n\t\tmy $is_changed_seq =\n\t\t  exists($obj->{'seq'}) && (CORE::length($value || '') > 0);\n\t\t$obj->{'seq'} = $value;\n       # new alphabet overridden by arguments?\n\t\tif($alphabet) {\n\t   # yes, set it no matter what\n\t\t\t$obj->alphabet($alphabet);\n\t\t} elsif( # if we changed a previous sequence to a new one\n\t\t\t\t  $is_changed_seq ||\n\t\t\t\t  # or if there is no alphabet yet at all\n\t\t\t\t  (! defined($obj->alphabet()))) {\n\t\t\t# we need to guess the (possibly new) alphabet\n\t\t\t$obj->_guess_alphabet();\n\t\t} # else (seq not changed and alphabet was defined) do nothing\n\t\t# if the seq is changed, make sure we unset a possibly set length\n\t\t$obj->length(undef) if $is_changed_seq || $obj->{'seq'};\n   }\n   return $obj->{'seq'};\n}\n\n=head2 validate_seq\n\n Title   : validate_seq\n Usage   : if(! $seq->validate_seq($seq_str) ) {\n                print \"sequence $seq_str is not valid for an object of\n                alphabet \",$seq->alphabet, \"\\n\";\n\t   }\n Function: Validates a given sequence string. A validating sequence string\n           must be accepted by seq(). A string that does not validate will\n           lead to an exception if passed to seq().\n\n           The implementation provided here does not take alphabet() into\n           account. Allowed are all letters (A-Z) and '-','.','*','?','=',\n           and '~'.\n\n Example :\n Returns : 1 if the supplied sequence string is valid for the object, and\n           0 otherwise.\n Args    : The sequence string to be validated.\n\n\n\nsub validate_seq {\n\tmy ($self,$seqstr) = @_;\n\tif( ! defined $seqstr ){ $seqstr = $self->seq(); }\n\treturn 0 unless( defined $seqstr);\n\tif((CORE::length($seqstr) > 0) &&\n\t   ($seqstr !~ /^([$MATCHPATTERN]+)$/)) {\n\t    $self->warn(\"seq doesn't validate, mismatch is \" .\n\t\t\tjoin(\",\",($seqstr =~ /([^$MATCHPATTERN]+)/g)));\n\t\treturn 0;\n\t}\n\treturn 1;\n}\n\n=head2 subseq\n\n Title   : subseq\n Usage   : $substring = $obj->subseq(10,40);\n           $substring = $obj->subseq(10,40,NOGAP)\n           $substring = $obj->subseq(-START=>10,-END=>40,-REPLACE_WITH=>'tga')\n Function: returns the subseq from start to end, where the first sequence\n           character has coordinate 1 number is inclusive, ie 1-2 are the \n           first two characters of the sequence\n Returns : a string\n Args    : integer for start position\n           integer for end position\n                 OR\n           Bio::LocationI location for subseq (strand honored)\n           Specify -NOGAP=>1 to return subseq with gap characters removed\n           Specify -REPLACE_WITH=>$new_subseq to replace the subseq returned\n           with $new_subseq in the sequence object\n\n\nsub subseq {\n   my $self = shift;\n   my @args = @_;\n   my ($start,$end,$nogap,$replace) = $self->_rearrange([qw(START \n                                                            END\n                                                            NOGAP\n                                                            REPLACE_WITH)],@args);\n   \n   # if $replace is specified, have the constructor validate it as seq\n   my $dummy = new Bio::PrimarySeq(-seq=>$replace, -alphabet=>$self->alphabet) if defined($replace);\n\n   if( ref($start) && $start->isa('Bio::LocationI') ) {\n       my $loc = $start;\n       my $seq = \"\";\n       foreach my $subloc ($loc->each_Location()) {\n\t   my $piece = $self->subseq(-START=>$subloc->start(),\n\t\t\t\t     '-END'=>$subloc->end(), \n\t\t\t\t     -REPLACE_WITH=>$replace,\n\t                             -NOGAP=>$nogap);\n\t   $piece =~ s/[$GAP_SYMBOLS]//g if $nogap;\n\t   if($subloc->strand() < 0) {\n\t       $piece = Bio::PrimarySeq->new('-seq' => $piece)->revcom()->seq();\n\t   }\n\t   $seq .= $piece;\n       }\n       return $seq;\n   } elsif(  defined  $start && defined $end ) {\n       if( $start > $end ){\n\t   $self->throw(\"Bad start,end parameters. Start [$start] has to be \".\n\t\t\t\"less than end [$end]\");\n       }\n       if( $start <= 0 ) {\n\t   $self->throw(\"Bad start parameter ($start). Start must be positive.\");\n       }\n       if( $end > $self->length ) {\n\t   $self->throw(\"Bad end parameter ($end). End must be less than the total length of sequence (total=\".$self->length.\")\");\n       }\n\n       # remove one from start, and then length is end-start\n       $start--;\n       my @ss_args = map { eval \"defined $_\"  ? $_ : () } qw( $self->{seq} $start $end-$start $replace);\n       my $seqstr = eval join( '', \"substr(\", join(',',@ss_args), \")\");\n       $seqstr =~ s/[$GAP_SYMBOLS]//g if ($nogap);\n       return $seqstr;\n\n   } else {\n       $self->warn(\"Incorrect parameters to subseq - must be two integers or a Bio::LocationI object. Got:\", $self,$start,$end,$replace,$nogap);\n       return;\n   }\n}\n\n=head2 length\n\n Title   : length\n Usage   : $len = $seq->length();\n Function: Get the length of the sequence in number of symbols (bases\n           or amino acids).\n\n           You can also set this attribute, even to a number that does\n           not match the length of the sequence string. This is useful\n           if you don''t want to set the sequence too, or if you want\n           to free up memory by unsetting the sequence. In the latter\n           case you could do e.g.\n\n               $seq->length($seq->length);\n               $seq->seq(undef);\n\n           Note that if you set the sequence to a value other than\n           undef at any time, the length attribute will be\n           invalidated, and the length of the sequence string will be\n           reported again. Also, we won''t let you lie about the length.\n\n Example :\n Returns : integer representing the length of the sequence.\n Args    : Optionally, the value on set\n\n\nsub length {\n    my $self = shift;\n    my $len = CORE::length($self->seq() || '');\n\n    if(@_) {\n\t\t my $val = shift;\n\t\t if(defined($val) && $len && ($len != $val)) {\n\t\t\t $self->throw(\"You're trying to lie about the length: \".\n\t\t\t\t\t\t\t  \"is $len but you say \".$val);\n\t\t }\n\t\t $self->{'_seq_length'} = $val;\n    } elsif(defined($self->{'_seq_length'})) {\n\t\t return $self->{'_seq_length'};\n    }\n    return $len;\n}\n\n=head2 display_id\n\n Title   : display_id or display_name\n Usage   : $id_string = $obj->display_id();\n Function: returns the display id, aka the common name of the Sequence object.\n\n           The semantics of this is that it is the most likely string to\n           be used as an identifier of the sequence, and likely to have\n           \"human\" readability.  The id is equivalent to the ID field of\n           the GenBank/EMBL databanks and the id field of the\n           Swissprot/sptrembl database. In fasta format, the >(\\S+) is\n           presumed to be the id, though some people overload the id to\n           embed other information. Bioperl does not use any embedded\n           information in the ID field, and people are encouraged to use\n           other mechanisms (accession field for example, or extending\n           the sequence object) to solve this.\n\n           With the new Bio::DescribeableI interface, display_name aliases\n           to this method.\n\n Returns : A string\n Args    : None\n\n\n\nsub display_id {\n   my ($obj,$value) = @_;\n   if( defined $value) {\n      $obj->{'display_id'} = $value;\n\t}\n\treturn $obj->{'display_id'};\n}\n\n=head2 accession_number\n\n Title   : accession_number or object_id\n Usage   : $unique_key = $obj->accession_number;\n Function: Returns the unique biological id for a sequence, commonly\n           called the accession_number. For sequences from established\n           databases, the implementors should try to use the correct\n           accession number. Notice that primary_id() provides the\n           unique id for the implemetation, allowing multiple objects\n           to have the same accession number in a particular implementation.\n\n           For sequences with no accession number, this method should\n           return \"unknown\".\n\n           [Note this method name is likely to change in 1.3]\n\n           With the new Bio::IdentifiableI interface, this is aliased\n           to object_id\n\n Returns : A string\n Args    : A string (optional) for setting\n\n\nsub accession_number {\n    my( $obj, $acc ) = @_;\n\n    if (defined $acc) {\n\t\t $obj->{'accession_number'} = $acc;\n    } else {\n\t\t $acc = $obj->{'accession_number'};\n\t\t $acc = 'unknown' unless defined $acc;\n    }\n    return $acc;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   : $unique_key = $obj->primary_id;\n Function: Returns the unique id for this object in this\n           implementation. This allows implementations to manage their\n           own object ids in a way the implementaiton can control\n           clients can expect one id to map to one object.\n\n           For sequences with no natural primary id, this method\n           should return a stringified memory location.\n\n Returns : A string\n Args    : A string (optional, for setting)\n\n\nsub primary_id {\n    my $obj = shift;\n\n    if(@_) {\n\t\t $obj->{'primary_id'} = shift;\n    }\n    if( ! defined($obj->{'primary_id'}) ) {\n\t\t return \"$obj\";\n    }\n    return $obj->{'primary_id'};\n}\n\n\n=head2 alphabet\n\n Title   : alphabet\n Usage   : if( $obj->alphabet eq 'dna' ) { /Do Something/ }\n Function: Get/Set the alphabet of sequence, one of\n           'dna', 'rna' or 'protein'. This is case sensitive.\n\n           This is not called <type> because this would cause\n           upgrade problems from the 0.5 and earlier Seq objects.\n\n Returns : a string either 'dna','rna','protein'. NB - the object must\n           make a call of the type - if there is no alphabet specified it\n           has to guess.\n Args    : optional string to set : 'dna' | 'rna' | 'protein'\n\n\n\nsub alphabet {\n    my ($obj,$value) = @_;\n    if (defined $value) {\n\t\t $value = lc $value;\n\t\t unless ( $valid_type{$value} ) {\n\t\t\t $obj->throw(\"Alphabet '$value' is not a valid alphabet (\".\n\t\t\t\t\t\t\t join(',', map \"'$_'\", sort keys %valid_type) .\n\t\t\t\t\t\t\t \") lowercase\");\n\t\t }\n\t\t $obj->{'alphabet'} = $value;\n    }\n    return $obj->{'alphabet'};\n}\n\n=head2 desc\n\n Title   : desc or description\n Usage   : $obj->desc($newval)\n Function: Get/set description of the sequence.\n\n           'description' is an alias for this for compliance with the\n           Bio::DescribeableI interface.\n\n Example :\n Returns : value of desc (a string)\n Args    : newvalue (a string or undef, optional)\n\n\n\nsub desc{\n    my $self = shift;\n\n    return $self->{'desc'} = shift if @_;\n    return $self->{'desc'};\n}\n\n=head2 can_call_new\n\n Title   : can_call_new\n Usage   :\n Function:\n Example :\n Returns : true\n Args    :\n\n\n\nsub can_call_new {\n   my ($self) = @_;\n\n   return 1;\n}\n\n=head2 id\n\n Title   : id\n Usage   : $id = $seq->id()\n Function: This is mapped on display_id\n Example :\n Returns :\n Args    :\n\n\n\nsub  id {\n   return shift->display_id(@_);\n}\n\n=head2 is_circular\n\n Title   : is_circular\n Usage   : if( $obj->is_circular) { /Do Something/ }\n Function: Returns true if the molecule is circular\n Returns : Boolean value\n Args    : none\n\n\nsub is_circular{\n    my $self = shift;\n\n    return $self->{'is_circular'} = shift if @_;\n    return $self->{'is_circular'};\n}\n\n\n=head1 Methods for Bio::IdentifiableI compliance\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: A string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences.\n\n           This is aliased to accession_number().\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->accession_number(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: A number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept.\n\n Returns : A number\n\n\nsub version{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t $self->{'_version'} = $value;\n    }\n    return $self->{'_version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: A string which represents the organisation which\n           granted the namespace, written as the DNS name for\n           organisation (eg, wormbase.org).\n\n Returns : A scalar\n\n\nsub authority {\n    my ($obj,$value) = @_;\n    if( defined $value) {\n\t\t $obj->{'authority'} = $value;\n    }\n    return $obj->{'authority'};\n}\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection.\n\n Returns : A scalar\n\n\n\nsub namespace{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t\t $self->{'namespace'} = $value;\n    }\n    return $self->{'namespace'} || \"\";\n}\n\n=head1 Methods for Bio::DescribableI compliance\n\nThis comprises of display_name and description.\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user.\n           The string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking\n           this is a good idea).\n\n           This is aliased to display_id().\n Returns : A scalar\n\n\nsub display_name {\n    return shift->display_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a\n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display.\n\n           This is aliased to desc().\n Returns : A scalar\n\n\nsub description {\n    return shift->desc(@_);\n}\n\n=head1 Methods Inherited from Bio::PrimarySeqI\n\nThese methods are available on Bio::PrimarySeq, although they are\nactually implemented on Bio::PrimarySeqI\n\n=head2 revcom\n\n Title   : revcom\n Usage   : $rev = $seq->revcom()\n Function: Produces a new Bio::SeqI implementing object which\n           is the reversed complement of the sequence. For protein\n           sequences this throws an exception of\n           \"Sequence is a protein. Cannot revcom\".\n\n           The id is the same id as the orginal sequence, and the\n           accession number is also indentical. If someone wants to\n           track that this sequence has be reversed, it needs to\n           define its own extensions.\n\n           To do an inplace edit of an object you can go:\n\n           $seqobj = $seqobj->revcom();\n\n           This of course, causes Perl to handle the garbage\n           collection of the old object, but it is roughly speaking as\n           efficient as an inplace edit.\n\n Returns : A new (fresh) Bio::SeqI object\n Args    : none\n\n\n=head2 trunc\n\n Title   : trunc\n Usage   : $subseq = $myseq->trunc(10,100);\n Function: Provides a truncation of a sequence,\n\n Example :\n Returns : A fresh Bio::SeqI implementing object.\n Args    :\n\n\n\n=head1 Internal methods\n\nThese are internal methods to PrimarySeq\n\n\n=head2 _guess_alphabet\n\n Title   : _guess_alphabet\n Usage   :\n Function: Determines (and sets) the type of sequence: dna, rna, protein\n Example :\n Returns : one of strings 'dna', 'rna' or 'protein'.\n Args    : none","parameters":[{"label":"$self"}]}},{"line":871,"containerName":"length","kind":12,"name":"CORE"},{"line":902,"range":{"start":{"line":902,"character":0},"end":{"character":9999,"line":908}},"kind":12,"children":[{"definition":"my","line":903,"name":"$self","localvar":"my","containerName":"accession","kind":13},{"name":"$self","kind":13,"containerName":"accession","line":905},{"kind":12,"containerName":"accession","name":"warn","line":905},{"kind":13,"containerName":"accession","name":"$self","line":905},{"line":907,"containerName":"accession","kind":13,"name":"$self"},{"name":"accession_number","containerName":"accession","kind":12,"line":907}],"name":"accession","containerName":"main::","definition":"sub"}],"version":5}