{"vars":[{"name":"vars","kind":2,"containerName":"","line":105},{"kind":2,"containerName":"","name":"Carp","line":107},{"line":112,"kind":13,"containerName":null,"name":"$ID"},{"line":112,"name":"Version","kind":2,"containerName":"Bio::Root"},{"line":113,"name":"$DEBUG","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$VERBOSITY","line":114},{"range":{"start":{"character":0,"line":117},"end":{"line":125,"character":9999}},"kind":12,"line":117,"definition":"sub","containerName":"main::","name":"new","children":[{"line":118,"name":"$class","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"definition":"my","line":119,"name":"@args","containerName":"new","localvar":"my","kind":13},{"line":120,"name":"$ENV","containerName":"new","kind":13},{"containerName":"new","kind":12,"name":"new","line":124},{"line":124,"name":"@args","kind":13,"containerName":"new"}]},{"line":121,"kind":12,"name":"carp"},{"line":124,"name":"Bio","containerName":"Root::Root","kind":12},{"containerName":"main::","name":"_initialize","children":[{"definition":"my","line":129,"name":"$self","kind":13,"localvar":"my","containerName":"_initialize"},{"line":129,"containerName":"_initialize","kind":13,"name":"@args"}],"detail":"($self,@args)","definition":"sub","range":{"end":{"character":9999,"line":131},"start":{"line":128,"character":0}},"kind":12,"line":128,"signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":" for backwards compatibility"}},{"signature":{"parameters":[{"label":"$self"},{"label":"$string"}],"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message","label":"throw($self,$string)"},"line":146,"range":{"start":{"line":146,"character":0},"end":{"character":9999,"line":155}},"kind":12,"definition":"sub","detail":"($self,$string)","children":[{"name":"$self","localvar":"my","containerName":"throw","kind":13,"line":147,"definition":"my"},{"line":147,"name":"$string","containerName":"throw","kind":13},{"definition":"my","name":"$std","kind":13,"localvar":"my","containerName":"throw","line":149},{"name":"$self","containerName":"throw","kind":13,"line":149},{"containerName":"throw","kind":12,"name":"stack_trace_dump","line":149},{"containerName":"throw","localvar":"my","kind":13,"name":"$out","line":151,"definition":"my"},{"line":152,"containerName":"throw","kind":13,"name":"$string"},{"line":152,"name":"$std","containerName":"throw","kind":13},{"line":153,"name":"$out","kind":13,"containerName":"throw"}],"name":"throw","containerName":"main::"},{"line":172,"range":{"end":{"line":192,"character":9999},"start":{"line":172,"character":0}},"kind":12,"signature":{"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)","parameters":[{"label":"$self"},{"label":"$string"}],"label":"warn($self,$string)"},"children":[{"definition":"my","line":173,"name":"$self","kind":13,"localvar":"my","containerName":"warn"},{"name":"$string","kind":13,"containerName":"warn","line":173},{"definition":"my","line":175,"name":"$verbose","containerName":"warn","localvar":"my","kind":13},{"kind":13,"containerName":"warn","name":"$self","line":175},{"line":175,"containerName":"warn","kind":12,"name":"verbose"},{"definition":"my","kind":13,"localvar":"my","containerName":"warn","name":"$header","line":177},{"definition":"my","localvar":"my","kind":13,"containerName":"warn","name":"$footer","line":178},{"kind":13,"containerName":"warn","name":"$verbose","line":180},{"line":181,"containerName":"warn","kind":13,"name":"$self"},{"line":181,"kind":12,"containerName":"warn","name":"throw"},{"line":181,"name":"$string","containerName":"warn","kind":13},{"name":"$verbose","containerName":"warn","kind":13,"line":183},{"line":186,"name":"$verbose","kind":13,"containerName":"warn"},{"name":"$header","containerName":"warn","kind":13,"line":187},{"name":"$string","containerName":"warn","kind":13,"line":187},{"name":"$self","containerName":"warn","kind":13,"line":187},{"name":"stack_trace_dump","kind":12,"containerName":"warn","line":187},{"line":187,"kind":13,"containerName":"warn","name":"$footer"},{"kind":13,"containerName":"warn","name":"$header","line":191},{"name":"$string","containerName":"warn","kind":13,"line":191},{"line":191,"name":"$footer","kind":13,"containerName":"warn"}],"containerName":"main::","name":"warn","definition":"sub","detail":"($self,$string)"},{"line":187,"containerName":"warn","kind":12,"name":"CORE"},{"line":191,"name":"CORE","containerName":"warn","kind":12},{"line":244,"kind":12,"range":{"start":{"character":0,"line":244},"end":{"line":267,"character":9999}},"children":[{"definition":"my","line":245,"localvar":"my","containerName":"deprecated","kind":13,"name":"$self"},{"line":246,"name":"$msg","containerName":"deprecated","localvar":"my","kind":13,"definition":"my"},{"line":246,"name":"$version","containerName":"deprecated","kind":13},{"line":246,"name":"$warn_version","kind":13,"containerName":"deprecated"},{"kind":13,"containerName":"deprecated","name":"$throw_version","line":246},{"kind":13,"containerName":"deprecated","name":"$self","line":247},{"kind":12,"containerName":"deprecated","name":"_rearrange","line":247},{"name":"$version","kind":13,"containerName":"deprecated","line":248},{"name":"$throw_version","kind":13,"containerName":"deprecated","line":248},{"line":249,"name":"$v","localvar":"my","containerName":"deprecated","kind":13,"definition":"my"},{"name":"$warn_version","kind":13,"containerName":"deprecated","line":249},{"kind":13,"containerName":"deprecated","name":"$version","line":249},{"line":250,"name":"$v","containerName":"deprecated","kind":13},{"kind":13,"containerName":"deprecated","name":"$self","line":251},{"name":"throw","kind":12,"containerName":"deprecated","line":251},{"line":252,"containerName":"deprecated","kind":13,"name":"$v"},{"line":252,"containerName":"deprecated","kind":13,"name":"$v"},{"line":254,"containerName":"deprecated","kind":13,"name":"$warn_version"},{"line":254,"name":"$Bio","kind":13,"containerName":"deprecated"},{"name":"$warn_version","kind":13,"containerName":"deprecated","line":254},{"containerName":"deprecated","kind":13,"name":"$msg","line":257},{"line":259,"kind":13,"containerName":"deprecated","name":"$version"},{"containerName":"deprecated","kind":13,"name":"$msg","line":260},{"containerName":"deprecated","kind":13,"name":"$Bio","line":261},{"line":261,"containerName":"deprecated","kind":13,"name":"$version"},{"line":262,"containerName":"deprecated","kind":13,"name":"$self"},{"line":262,"kind":12,"containerName":"deprecated","name":"throw"},{"line":262,"containerName":"deprecated","kind":13,"name":"$msg"},{"name":"$self","kind":13,"containerName":"deprecated","line":266},{"containerName":"deprecated","kind":12,"name":"warn","line":266},{"containerName":"deprecated","kind":13,"name":"$msg","line":266}],"name":"deprecated","containerName":"main::","definition":"sub"},{"containerName":"Version::VERSION","kind":12,"name":"Root","line":254},{"line":261,"containerName":"Version::VERSION","kind":12,"name":"Root"},{"signature":{"label":"stack_trace_dump($self)","documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}]},"range":{"end":{"character":9999,"line":297},"start":{"character":0,"line":281}},"kind":12,"line":281,"detail":"($self)","definition":"sub","name":"stack_trace_dump","containerName":"main::","children":[{"definition":"my","line":282,"name":"$self","containerName":"stack_trace_dump","localvar":"my","kind":13},{"name":"@stack","containerName":"stack_trace_dump","localvar":"my","kind":13,"line":284,"definition":"my"},{"line":284,"containerName":"stack_trace_dump","kind":13,"name":"$self"},{"containerName":"stack_trace_dump","kind":12,"name":"stack_trace","line":284},{"kind":13,"containerName":"stack_trace_dump","name":"@stack","line":286},{"line":287,"containerName":"stack_trace_dump","kind":13,"name":"@stack"},{"line":288,"name":"@stack","containerName":"stack_trace_dump","kind":13},{"definition":"my","localvar":"my","containerName":"stack_trace_dump","kind":13,"name":"$out","line":290},{"kind":13,"localvar":"my","containerName":"stack_trace_dump","name":"$module","line":291,"definition":"my"},{"line":291,"kind":13,"containerName":"stack_trace_dump","name":"$function"},{"line":291,"name":"$file","containerName":"stack_trace_dump","kind":13},{"name":"$position","containerName":"stack_trace_dump","kind":13,"line":291},{"definition":"my","line":294,"kind":13,"localvar":"my","containerName":"stack_trace_dump","name":"$stack"},{"kind":13,"containerName":"stack_trace_dump","name":"@stack","line":294},{"line":295,"name":"$module","containerName":"stack_trace_dump","kind":13},{"line":295,"name":"$file","containerName":"stack_trace_dump","kind":13},{"line":295,"containerName":"stack_trace_dump","kind":13,"name":"$position"},{"name":"$function","kind":13,"containerName":"stack_trace_dump","line":295},{"line":295,"name":"$stack","kind":13,"containerName":"stack_trace_dump"},{"containerName":"stack_trace_dump","kind":13,"name":"$out","line":296}]},{"kind":13,"containerName":null,"name":"$out","line":299},{"children":[{"line":316,"name":"$self","containerName":"stack_trace","localvar":"my","kind":13,"definition":"my"},{"name":"$i","localvar":"my","containerName":"stack_trace","kind":13,"line":318,"definition":"my"},{"definition":"my","line":319,"name":"@out","kind":13,"localvar":"my","containerName":"stack_trace"},{"definition":"my","line":320,"name":"$prev","localvar":"my","kind":13,"containerName":"stack_trace"},{"line":321,"localvar":"my","containerName":"stack_trace","kind":13,"name":"@call","definition":"my"},{"line":321,"name":"$i","kind":13,"containerName":"stack_trace"},{"line":324,"name":"$prev","containerName":"stack_trace","kind":13},{"line":324,"name":"$call","kind":13,"containerName":"stack_trace"},{"line":325,"containerName":"stack_trace","kind":13,"name":"@out"},{"name":"$prev","kind":13,"containerName":"stack_trace","line":325},{"name":"$prev","kind":13,"containerName":"stack_trace","line":326},{"line":326,"containerName":"stack_trace","kind":13,"name":"@call"},{"line":328,"name":"$prev","kind":13,"containerName":"stack_trace"},{"line":329,"name":"@out","containerName":"stack_trace","kind":13},{"line":329,"kind":13,"containerName":"stack_trace","name":"$prev"},{"line":330,"name":"@out","kind":13,"containerName":"stack_trace"}],"name":"stack_trace","containerName":"main::","definition":"sub","detail":"($self)","line":315,"range":{"start":{"line":315,"character":0},"end":{"line":331,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub stack_trace_dump{\n   my ($self) = @_;\n\n   my @stack = $self->stack_trace();\n\n   shift @stack;\n   shift @stack;\n   shift @stack;\n\n   my $out;\n   my ($module,$function,$file,$position);\n   \n\n   foreach my $stack ( @stack) {\n       ($module,$file,$position,$function) = @{$stack};\n       $out .= \"STACK $function $file:$position\\n\";\n   }\n\n   return $out;\n}\n\n\n=head2 stack_trace\n\n Title   : stack_trace\n Usage   : @stack_array_ref= $self->stack_trace\n Function: gives an array to a reference of arrays with stack trace info\n           each coming from the caller(stack_number) call\n Returns : array containing a reference of arrays\n Args    : none","label":"stack_trace($self)"}},{"line":404,"range":{"start":{"line":404,"character":0},"end":{"line":417,"character":9999}},"kind":12,"children":[{"line":405,"containerName":"_rearrange","localvar":"my","kind":13,"name":"$dummy","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"_rearrange","name":"$order","line":406},{"line":409,"kind":13,"containerName":"_rearrange","name":"%2"},{"definition":"my","localvar":"my","containerName":"_rearrange","kind":13,"name":"%param","line":410},{"definition":"my","containerName":"_rearrange","localvar":"my","kind":13,"name":"$key","line":412},{"name":"$param","kind":13,"containerName":"_rearrange","line":413},{"name":"$key","kind":13,"containerName":"_rearrange","line":413},{"name":"$order","containerName":"_rearrange","kind":13,"line":415},{"name":"@param","containerName":"_rearrange","kind":13,"line":416},{"line":416,"name":"$order","kind":13,"containerName":"_rearrange"}],"name":"_rearrange","containerName":"main::","definition":"sub"},{"detail":"($self,$args,@own_args)","definition":"sub","name":"_set_from_args","containerName":"main::","children":[{"kind":13,"localvar":"my","containerName":"_set_from_args","name":"$self","line":498,"definition":"my"},{"name":"$args","containerName":"_set_from_args","kind":13,"line":498},{"kind":13,"containerName":"_set_from_args","name":"@own_args","line":498},{"kind":13,"containerName":"_set_from_args","name":"$self","line":499},{"name":"throw","containerName":"_set_from_args","kind":12,"line":499},{"name":"$args","containerName":"_set_from_args","kind":13,"line":499},{"definition":"my","name":"$methods","kind":13,"localvar":"my","containerName":"_set_from_args","line":501},{"line":501,"name":"$force","containerName":"_set_from_args","kind":13},{"name":"$create","containerName":"_set_from_args","kind":13,"line":501},{"name":"$code","containerName":"_set_from_args","kind":13,"line":501},{"name":"$case","kind":13,"containerName":"_set_from_args","line":501},{"line":502,"name":"@own_args","containerName":"_set_from_args","kind":13},{"containerName":"_set_from_args","kind":13,"name":"$methods","line":503},{"line":503,"name":"$force","kind":13,"containerName":"_set_from_args"},{"line":503,"containerName":"_set_from_args","kind":13,"name":"$create"},{"kind":13,"containerName":"_set_from_args","name":"$code","line":503},{"kind":13,"containerName":"_set_from_args","name":"$case","line":503},{"line":504,"containerName":"_set_from_args","kind":13,"name":"$self"},{"name":"_rearrange","containerName":"_set_from_args","kind":12,"line":504},{"name":"@own_args","containerName":"_set_from_args","kind":13,"line":508},{"definition":"my","name":"$default_code","kind":13,"localvar":"my","containerName":"_set_from_args","line":510},{"name":"%method_names","kind":13,"localvar":"my","containerName":"_set_from_args","line":514,"definition":"my"},{"line":515,"containerName":"_set_from_args","localvar":"my","kind":13,"name":"%syns","definition":"my"},{"name":"$methods","containerName":"_set_from_args","kind":13,"line":516},{"definition":"my","line":517,"containerName":"_set_from_args","localvar":"my","kind":13,"name":"@names"},{"name":"$methods","containerName":"_set_from_args","kind":13,"line":518},{"line":519,"kind":13,"containerName":"_set_from_args","name":"@names"},{"line":519,"containerName":"_set_from_args","kind":13,"name":"$methods"},{"line":520,"containerName":"_set_from_args","kind":13,"name":"%syns"},{"line":520,"name":"$methods","kind":13,"containerName":"_set_from_args"}],"signature":{"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub stack_trace_dump{\n   my ($self) = @_;\n\n   my @stack = $self->stack_trace();\n\n   shift @stack;\n   shift @stack;\n   shift @stack;\n\n   my $out;\n   my ($module,$function,$file,$position);\n   \n\n   foreach my $stack ( @stack) {\n       ($module,$file,$position,$function) = @{$stack};\n       $out .= \"STACK $function $file:$position\\n\";\n   }\n\n   return $out;\n}\n\n\n=head2 stack_trace\n\n Title   : stack_trace\n Usage   : @stack_array_ref= $self->stack_trace\n Function: gives an array to a reference of arrays with stack trace info\n           each coming from the caller(stack_number) call\n Returns : array containing a reference of arrays\n Args    : none\n\n\n\nsub stack_trace{\n   my ($self) = @_;\n\n   my $i = 0;\n   my @out = ();\n   my $prev = [];\n   while( my @call = caller($i++)) {\n       # major annoyance that caller puts caller context as\n       # function name. Hence some monkeying around...\n       $prev->[3] = $call[3];\n       push(@out,$prev);\n       $prev = \\@call;\n   }\n   $prev->[3] = 'toplevel';\n   push(@out,$prev);\n   return @out;\n}\n\n\n=head2 _rearrange\n\n Usage     : $object->_rearrange( array_ref, list_of_arguments)\n Purpose   : Rearranges named parameters to requested order.\n Example   : $self->_rearrange([qw(SEQUENCE ID DESC)],@param);\n           : Where @param = (-sequence => $s,\n\t       :                 -desc     => $d,\n\t       :                 -id       => $i);\n Returns   : @params - an array of parameters in the requested order.\n           : The above example would return ($s, $i, $d).\n           : Unspecified parameters will return undef. For example, if\n           :        @param = (-sequence => $s);\n           : the above _rearrange call would return ($s, undef, undef)\n Argument  : $order : a reference to an array which describes the desired\n           :          order of the named parameters.\n           : @param : an array of parameters, either as a list (in\n           :          which case the function simply returns the list),\n           :          or as an associative array with hyphenated tags\n           :          (in which case the function sorts the values \n           :          according to @{$order} and returns that new array.)\n\t       :\t      The tags can be upper, lower, or mixed case\n           :          but they must start with a hyphen (at least the\n           :          first one should be hyphenated.)\n Source    : This function was taken from CGI.pm, written by Dr. Lincoln\n           : Stein, and adapted for use in Bio::Seq by Richard Resnick and\n           : then adapted for use in Bio::Root::Object.pm by Steve Chervitz,\n           : then migrated into Bio::Root::RootI.pm by Ewan Birney.\n Comments  :\n           : Uppercase tags are the norm, \n           : (SAC)\n           : This method may not be appropriate for method calls that are\n           : within in an inner loop if efficiency is a concern.\n           :\n           : Parameters can be specified using any of these formats:\n           :  @param = (-name=>'me', -color=>'blue');\n           :  @param = (-NAME=>'me', -COLOR=>'blue');\n           :  @param = (-Name=>'me', -Color=>'blue');\n           :  @param = ('me', 'blue');\n           : A leading hyphenated argument is used by this function to \n           : indicate that named parameters are being used.\n           : Therefore, the ('me', 'blue') list will be returned as-is.\n           :\n\t       : Note that Perl will confuse unquoted, hyphenated tags as \n           : function calls if there is a function of the same name \n           : in the current namespace:\n           :    -name => 'foo' is interpreted as -&name => 'foo'\n\t       :\n           : For ultimate safety, put single quotes around the tag:\n\t       : ('-name'=>'me', '-color' =>'blue');\n           : This can be a bit cumbersome and I find not as readable\n           : as using all uppercase, which is also fairly safe:\n\t       : (-NAME=>'me', -COLOR =>'blue');\n\t       :\n           : Personal note (SAC): I have found all uppercase tags to\n           : be more managable: it involves less single-quoting,\n           : the key names stand out better, and there are no method naming \n           : conflicts.\n           : The drawbacks are that it's not as easy to type as lowercase,\n           : and lots of uppercase can be hard to read.\n           :\n           : Regardless of the style, it greatly helps to line\n\t       : the parameters up vertically for long/complex lists.\n           :\n           : Note that if @param is a single string that happens to start with\n           : a dash, it will be treated as a hash key and probably fail to\n           : match anything in the array_ref, so not be returned as normally\n           : happens when @param is a simple list and not an associative array.\n\n\nsub _rearrange {\n    my $dummy = shift;\n    my $order = shift;\n    \n    return @_ unless (substr($_[0]||'',0,1) eq '-');\n    push @_,undef unless $#_ %2;\n    my %param;\n    while( @_ ) {\n\t(my $key = shift) =~ tr/a-z\\055/A-Z/d; #deletes all dashes!\n\t$param{$key} = shift;\n    }\n    map { $_ = uc($_) } @$order; # for bug #1343, but is there perf hit here?\n    return @param{@$order};\n}\n\n=head2 _set_from_args\n\n Usage     : $object->_set_from_args(\\%args, -methods => \\@methods)\n Purpose   : Takes a hash of user-supplied args whose keys match method names,\n           : and calls the method supplying it the corresponding value.\n Example   : $self->_set_from_args(\\%args, -methods => [qw(sequence id desc)]);\n           : Where %args = (-sequence    => $s,\n\t       :                -description => $d,\n\t       :                -ID          => $i);\n           :\n           : the above _set_from_args calls the following methods:\n           : $self->sequence($s);\n           : $self->id($i);\n           : ( $self->description($i) is not called because 'description' wasn't\n           :   one of the given methods )\n Argument  : \\%args | \\@args : a hash ref or associative array ref of arguments\n           :                   where keys are any-case strings corresponding to\n           :                   method names but optionally prefixed with\n           :                   hyphens, and values are the values the method\n           :                   should be supplied. If keys contain internal\n           :                   hyphens (eg. to separate multi-word args) they\n           :                   are converted to underscores, since method names\n           :                   cannot contain dashes.\n           : -methods => []  : (optional) only call methods with names in this\n           :                   array ref. Can instead supply a hash ref where\n           :                   keys are method names (of real existing methods\n           :                   unless -create is in effect) and values are array\n           :                   refs of synonyms to allow access to the method\n           :                   using synonyms. If there is only one synonym it\n           :                   can be supplied as a string instead of a single-\n           :                   element array ref\n           : -force => bool  : (optional, default 0) call methods that don't\n           :                   seem to exist, ie. let AUTOLOAD handle them\n           : -create => bool : (optional, default 0) when a method doesn't\n           :                   exist, create it as a simple getter/setter\n           :                   (combined with -methods it would create all the\n           :                   supplied methods that didn't exist, even if not\n           :                   mentioned in the supplied %args)\n           : -code => '' | {}: (optional) when creating methods use the supplied\n           :                   code (a string which will be evaulated as a sub).\n           :                   The default code is a simple get/setter.\n           :                   Alternatively you can supply a hash ref where\n           :                   the keys are method names and the values are\n           :                   code strings. The variable '$method' will be\n           :                   available at evaluation time, so can be used in\n           :                   your code strings. Beware that the strict pragma\n           :                   will be in effect.\n           : -case_sensitive => bool : require case sensitivity on the part of\n           :                           user (ie. a() and A() are two different\n           :                           methods and the user must be careful\n           :                           which they use).\n Comments  :\n           : The \\%args argument will usually be the args received during new()\n           : from the user. The user is allowed to get the case wrong, include\n           : 0 or more than one hyphens as a prefix, and to include hyphens as\n           : multi-word arg separators: '--an-arg' => 1, -an_arg => 1 and\n           : An_Arg => 1 are all equivalent, calling an_arg(1). However, in\n           : documentation users should only be told to use the standard form\n           : -an_arg to avoid confusion. A possible exception to this is a\n           : wrapper module where '--an-arg' is what the user is used to\n           : supplying to the program being wrapped.\n           :\n           : Another issue with wrapper modules is that there may be an\n           : argument that has meaning both to Bioperl and to the program, eg.\n           : -verbose. The recommended way of dealing with this is to leave\n           : -verbose to set the Bioperl verbosity whilst requesting users use\n           : an invented -program_verbose (or similar) to set the program\n           : verbosity. This can be resolved back with\n           : Bio::Tools::Run::WrapperBase's _setparams() method and code along\n           : the lines of:\n           : my %methods = map { $_ => $_ } @LIST_OF_ALL_ALLOWED_PROGRAM_ARGS\n           : delete $methods{'verbose'};\n           : $methods{'program_verbose'} = 'verbose';\n           : my $param_string = $self->_setparams(-methods => \\%methods);\n           : system(\"$exe $param_string\");","parameters":[{"label":"$self"},{"label":"$args"},{"label":"@own_args"}],"label":"_set_from_args($self,$args,@own_args)"},"range":{"end":{"character":9999,"line":521},"start":{"line":497,"character":0}},"kind":12,"line":497},{"line":523,"kind":13,"containerName":null,"name":"@names"},{"line":523,"kind":13,"containerName":null,"name":"$methods"},{"line":524,"containerName":null,"kind":13,"name":"%syns"},{"line":524,"kind":13,"containerName":null,"name":"@names"},{"name":"%method_names","containerName":null,"kind":13,"line":526},{"line":526,"containerName":null,"kind":13,"name":"$case"},{"line":526,"containerName":null,"kind":13,"name":"@names"},{"name":"%orig_args","localvar":"my","kind":13,"containerName":null,"line":530,"definition":"my"},{"kind":13,"containerName":null,"name":"$args","line":530},{"kind":13,"containerName":null,"name":"$args","line":530},{"kind":13,"containerName":null,"name":"$args","line":530},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"%args","line":531},{"definition":"my","line":532,"kind":13,"localvar":"my","containerName":null,"name":"$method"},{"line":532,"containerName":null,"kind":13,"name":"$value"},{"line":532,"name":"%orig_args","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$method","line":533},{"name":"$method","containerName":null,"kind":13,"line":534},{"kind":13,"containerName":null,"name":"%args","line":535},{"line":535,"name":"$method","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$value","line":535},{"name":"%create","kind":13,"containerName":null,"line":539},{"line":540,"kind":13,"containerName":null,"name":"%methods"},{"name":"%syns","kind":13,"containerName":null,"line":541},{"name":"$case","containerName":null,"kind":13,"line":541},{"line":541,"containerName":null,"kind":13,"name":"%args"},{"localvar":"my","kind":13,"containerName":null,"name":"$method","line":544,"definition":"my"},{"line":544,"containerName":null,"kind":13,"name":"%syns"},{"line":545,"kind":13,"containerName":null,"name":"$self"},{"name":"can","kind":12,"containerName":"main::","line":545},{"line":545,"containerName":null,"kind":13,"name":"$method"},{"definition":"my","line":547,"containerName":null,"localvar":"my","kind":13,"name":"$string"},{"kind":13,"containerName":null,"name":"$code","line":547},{"containerName":null,"kind":13,"name":"$default_code","line":547},{"line":548,"name":"$code","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%code","line":548},{"line":549,"kind":13,"containerName":null,"name":"$string"},{"line":549,"name":"%code","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"$method","line":549},{"name":"$default_code","kind":13,"containerName":null,"line":549},{"line":552,"name":"$sub","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":553,"kind":13,"containerName":null,"name":"$self"},{"name":"throw","containerName":"main::","kind":12,"line":553},{"line":555,"kind":12,"name":"strict"},{"containerName":null,"kind":13,"name":"$self","line":556},{"line":556,"name":"$method","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$sub","line":556},{"kind":13,"localvar":"my","containerName":null,"name":"$method","line":561,"definition":"my"},{"kind":13,"containerName":null,"name":"$syn_ref","line":561},{"line":561,"name":"%syns","containerName":null,"kind":13},{"definition":"my","line":562,"localvar":"my","kind":13,"containerName":null,"name":"$method_ref"},{"containerName":null,"kind":13,"name":"$self","line":562},{"name":"can","kind":12,"containerName":"main::","line":562},{"containerName":null,"kind":13,"name":"$method","line":562},{"line":564,"localvar":"my","kind":13,"containerName":null,"name":"$syn","definition":"my"},{"line":564,"name":"ref","kind":12},{"name":"$syn_ref","containerName":null,"kind":13,"line":564},{"line":564,"kind":13,"containerName":null,"name":"@syn_ref"},{"line":564,"kind":13,"containerName":null,"name":"%syn_ref"},{"line":565,"kind":13,"containerName":null,"name":"$syn"},{"line":565,"name":"$method","containerName":null,"kind":13},{"name":"%method_names","kind":13,"containerName":null,"line":566},{"containerName":null,"kind":13,"name":"$case","line":566},{"line":566,"name":"$syn","containerName":null,"kind":13},{"line":566,"name":"$syn","containerName":null,"kind":13},{"line":566,"name":"$syn","kind":13,"containerName":null},{"line":567,"containerName":null,"kind":13,"name":"$self"},{"line":567,"name":"can","kind":12,"containerName":"main::"},{"name":"$syn","kind":13,"containerName":null,"line":567},{"line":568,"kind":12,"name":"strict"},{"line":569,"name":"$self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$syn","line":569},{"line":569,"kind":13,"containerName":null,"name":"$method_ref"},{"definition":"my","line":574,"kind":13,"localvar":"my","containerName":null,"name":"$method"},{"line":574,"name":"$value","containerName":null,"kind":13},{"line":574,"name":"%args","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$method","line":575},{"line":575,"containerName":null,"kind":13,"name":"%method_names"},{"kind":13,"containerName":null,"name":"$case","line":575},{"line":575,"kind":13,"containerName":null,"name":"$method"},{"line":575,"name":"$method","kind":13,"containerName":null},{"name":"$methods","kind":13,"containerName":null,"line":575},{"line":575,"name":"$method","kind":13,"containerName":null},{"name":"$self","kind":13,"containerName":null,"line":576},{"line":576,"name":"can","containerName":"main::","kind":12},{"name":"$method","containerName":null,"kind":13,"line":576},{"name":"$force","kind":13,"containerName":null,"line":576},{"containerName":null,"kind":13,"name":"$self","line":577},{"line":577,"containerName":null,"kind":13,"name":"$method"},{"line":577,"name":"$value","kind":13,"containerName":null},{"definition":"sub","detail":"($self,$order,@param)","children":[{"line":584,"name":"$self","containerName":"_rearrange_old","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_rearrange_old","name":"$order","line":584},{"name":"@param","containerName":"_rearrange_old","kind":13,"line":584},{"line":604,"containerName":"_rearrange_old","kind":13,"name":"@param"},{"line":604,"kind":13,"containerName":"_rearrange_old","name":"$param"},{"containerName":"_rearrange_old","kind":13,"name":"$param","line":604},{"line":613,"kind":13,"localvar":"my","containerName":"_rearrange_old","name":"$i","definition":"my"},{"line":613,"containerName":"_rearrange_old","kind":13,"name":"$i"},{"containerName":"_rearrange_old","kind":13,"name":"@param","line":613},{"line":613,"name":"$i","containerName":"_rearrange_old","kind":13},{"line":614,"kind":13,"containerName":"_rearrange_old","name":"$param"},{"line":614,"name":"$i","kind":13,"containerName":"_rearrange_old"},{"line":615,"name":"$param","kind":13,"containerName":"_rearrange_old"},{"name":"$i","kind":13,"containerName":"_rearrange_old","line":615},{"line":620,"name":"%param","containerName":"_rearrange_old","localvar":"my","kind":13,"definition":"my"},{"name":"@param","containerName":"_rearrange_old","kind":13,"line":620},{"containerName":"_rearrange_old","kind":13,"name":"@param","line":635},{"kind":13,"containerName":"_rearrange_old","name":"$order","line":635}],"containerName":"main::","name":"_rearrange_old","signature":{"label":"_rearrange_old($self,$order,@param)","parameters":[{"label":"$self"},{"label":"$order"},{"label":"@param"}],"documentation":"----------------'"},"line":582,"range":{"end":{"line":635,"character":9999},"start":{"line":582,"character":0}},"kind":12},{"name":"param","kind":12,"line":604},{"children":[{"line":660,"name":"$self","localvar":"my","containerName":"_register_for_cleanup","kind":13,"definition":"my"},{"line":660,"kind":13,"containerName":"_register_for_cleanup","name":"$method"},{"line":661,"containerName":"_register_for_cleanup","kind":13,"name":"$self"},{"line":661,"name":"throw_not_implemented","containerName":"_register_for_cleanup","kind":12}],"name":"_register_for_cleanup","containerName":"main::","definition":"sub","detail":"($self,$method)","line":659,"kind":12,"range":{"start":{"character":0,"line":659},"end":{"line":662,"character":9999}},"signature":{"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub stack_trace_dump{\n   my ($self) = @_;\n\n   my @stack = $self->stack_trace();\n\n   shift @stack;\n   shift @stack;\n   shift @stack;\n\n   my $out;\n   my ($module,$function,$file,$position);\n   \n\n   foreach my $stack ( @stack) {\n       ($module,$file,$position,$function) = @{$stack};\n       $out .= \"STACK $function $file:$position\\n\";\n   }\n\n   return $out;\n}\n\n\n=head2 stack_trace\n\n Title   : stack_trace\n Usage   : @stack_array_ref= $self->stack_trace\n Function: gives an array to a reference of arrays with stack trace info\n           each coming from the caller(stack_number) call\n Returns : array containing a reference of arrays\n Args    : none\n\n\n\nsub stack_trace{\n   my ($self) = @_;\n\n   my $i = 0;\n   my @out = ();\n   my $prev = [];\n   while( my @call = caller($i++)) {\n       # major annoyance that caller puts caller context as\n       # function name. Hence some monkeying around...\n       $prev->[3] = $call[3];\n       push(@out,$prev);\n       $prev = \\@call;\n   }\n   $prev->[3] = 'toplevel';\n   push(@out,$prev);\n   return @out;\n}\n\n\n=head2 _rearrange\n\n Usage     : $object->_rearrange( array_ref, list_of_arguments)\n Purpose   : Rearranges named parameters to requested order.\n Example   : $self->_rearrange([qw(SEQUENCE ID DESC)],@param);\n           : Where @param = (-sequence => $s,\n\t       :                 -desc     => $d,\n\t       :                 -id       => $i);\n Returns   : @params - an array of parameters in the requested order.\n           : The above example would return ($s, $i, $d).\n           : Unspecified parameters will return undef. For example, if\n           :        @param = (-sequence => $s);\n           : the above _rearrange call would return ($s, undef, undef)\n Argument  : $order : a reference to an array which describes the desired\n           :          order of the named parameters.\n           : @param : an array of parameters, either as a list (in\n           :          which case the function simply returns the list),\n           :          or as an associative array with hyphenated tags\n           :          (in which case the function sorts the values \n           :          according to @{$order} and returns that new array.)\n\t       :\t      The tags can be upper, lower, or mixed case\n           :          but they must start with a hyphen (at least the\n           :          first one should be hyphenated.)\n Source    : This function was taken from CGI.pm, written by Dr. Lincoln\n           : Stein, and adapted for use in Bio::Seq by Richard Resnick and\n           : then adapted for use in Bio::Root::Object.pm by Steve Chervitz,\n           : then migrated into Bio::Root::RootI.pm by Ewan Birney.\n Comments  :\n           : Uppercase tags are the norm, \n           : (SAC)\n           : This method may not be appropriate for method calls that are\n           : within in an inner loop if efficiency is a concern.\n           :\n           : Parameters can be specified using any of these formats:\n           :  @param = (-name=>'me', -color=>'blue');\n           :  @param = (-NAME=>'me', -COLOR=>'blue');\n           :  @param = (-Name=>'me', -Color=>'blue');\n           :  @param = ('me', 'blue');\n           : A leading hyphenated argument is used by this function to \n           : indicate that named parameters are being used.\n           : Therefore, the ('me', 'blue') list will be returned as-is.\n           :\n\t       : Note that Perl will confuse unquoted, hyphenated tags as \n           : function calls if there is a function of the same name \n           : in the current namespace:\n           :    -name => 'foo' is interpreted as -&name => 'foo'\n\t       :\n           : For ultimate safety, put single quotes around the tag:\n\t       : ('-name'=>'me', '-color' =>'blue');\n           : This can be a bit cumbersome and I find not as readable\n           : as using all uppercase, which is also fairly safe:\n\t       : (-NAME=>'me', -COLOR =>'blue');\n\t       :\n           : Personal note (SAC): I have found all uppercase tags to\n           : be more managable: it involves less single-quoting,\n           : the key names stand out better, and there are no method naming \n           : conflicts.\n           : The drawbacks are that it's not as easy to type as lowercase,\n           : and lots of uppercase can be hard to read.\n           :\n           : Regardless of the style, it greatly helps to line\n\t       : the parameters up vertically for long/complex lists.\n           :\n           : Note that if @param is a single string that happens to start with\n           : a dash, it will be treated as a hash key and probably fail to\n           : match anything in the array_ref, so not be returned as normally\n           : happens when @param is a simple list and not an associative array.\n\n\nsub _rearrange {\n    my $dummy = shift;\n    my $order = shift;\n    \n    return @_ unless (substr($_[0]||'',0,1) eq '-');\n    push @_,undef unless $#_ %2;\n    my %param;\n    while( @_ ) {\n\t(my $key = shift) =~ tr/a-z\\055/A-Z/d; #deletes all dashes!\n\t$param{$key} = shift;\n    }\n    map { $_ = uc($_) } @$order; # for bug #1343, but is there perf hit here?\n    return @param{@$order};\n}\n\n=head2 _set_from_args\n\n Usage     : $object->_set_from_args(\\%args, -methods => \\@methods)\n Purpose   : Takes a hash of user-supplied args whose keys match method names,\n           : and calls the method supplying it the corresponding value.\n Example   : $self->_set_from_args(\\%args, -methods => [qw(sequence id desc)]);\n           : Where %args = (-sequence    => $s,\n\t       :                -description => $d,\n\t       :                -ID          => $i);\n           :\n           : the above _set_from_args calls the following methods:\n           : $self->sequence($s);\n           : $self->id($i);\n           : ( $self->description($i) is not called because 'description' wasn't\n           :   one of the given methods )\n Argument  : \\%args | \\@args : a hash ref or associative array ref of arguments\n           :                   where keys are any-case strings corresponding to\n           :                   method names but optionally prefixed with\n           :                   hyphens, and values are the values the method\n           :                   should be supplied. If keys contain internal\n           :                   hyphens (eg. to separate multi-word args) they\n           :                   are converted to underscores, since method names\n           :                   cannot contain dashes.\n           : -methods => []  : (optional) only call methods with names in this\n           :                   array ref. Can instead supply a hash ref where\n           :                   keys are method names (of real existing methods\n           :                   unless -create is in effect) and values are array\n           :                   refs of synonyms to allow access to the method\n           :                   using synonyms. If there is only one synonym it\n           :                   can be supplied as a string instead of a single-\n           :                   element array ref\n           : -force => bool  : (optional, default 0) call methods that don't\n           :                   seem to exist, ie. let AUTOLOAD handle them\n           : -create => bool : (optional, default 0) when a method doesn't\n           :                   exist, create it as a simple getter/setter\n           :                   (combined with -methods it would create all the\n           :                   supplied methods that didn't exist, even if not\n           :                   mentioned in the supplied %args)\n           : -code => '' | {}: (optional) when creating methods use the supplied\n           :                   code (a string which will be evaulated as a sub).\n           :                   The default code is a simple get/setter.\n           :                   Alternatively you can supply a hash ref where\n           :                   the keys are method names and the values are\n           :                   code strings. The variable '$method' will be\n           :                   available at evaluation time, so can be used in\n           :                   your code strings. Beware that the strict pragma\n           :                   will be in effect.\n           : -case_sensitive => bool : require case sensitivity on the part of\n           :                           user (ie. a() and A() are two different\n           :                           methods and the user must be careful\n           :                           which they use).\n Comments  :\n           : The \\%args argument will usually be the args received during new()\n           : from the user. The user is allowed to get the case wrong, include\n           : 0 or more than one hyphens as a prefix, and to include hyphens as\n           : multi-word arg separators: '--an-arg' => 1, -an_arg => 1 and\n           : An_Arg => 1 are all equivalent, calling an_arg(1). However, in\n           : documentation users should only be told to use the standard form\n           : -an_arg to avoid confusion. A possible exception to this is a\n           : wrapper module where '--an-arg' is what the user is used to\n           : supplying to the program being wrapped.\n           :\n           : Another issue with wrapper modules is that there may be an\n           : argument that has meaning both to Bioperl and to the program, eg.\n           : -verbose. The recommended way of dealing with this is to leave\n           : -verbose to set the Bioperl verbosity whilst requesting users use\n           : an invented -program_verbose (or similar) to set the program\n           : verbosity. This can be resolved back with\n           : Bio::Tools::Run::WrapperBase's _setparams() method and code along\n           : the lines of:\n           : my %methods = map { $_ => $_ } @LIST_OF_ALL_ALLOWED_PROGRAM_ARGS\n           : delete $methods{'verbose'};\n           : $methods{'program_verbose'} = 'verbose';\n           : my $param_string = $self->_setparams(-methods => \\%methods);\n           : system(\"$exe $param_string\");\n\n\nsub _set_from_args {\n    my ($self, $args, @own_args) = @_;\n    $self->throw(\"a hash/array ref of arguments must be supplied\") unless ref($args);\n    \n    my ($methods, $force, $create, $code, $case);\n    if (@own_args) {\n        ($methods, $force, $create, $code, $case) =\n            $self->_rearrange([qw(METHODS\n                                  FORCE\n                                  CREATE\n                                  CODE\n                                  CASE_SENSITIVE)], @own_args);\n    }\n    my $default_code = 'my $self = shift;\n                        if (@_) { $self->{\\'_\\'.$method} = shift }\n                        return $self->{\\'_\\'.$method};';\n    \n    my %method_names = ();\n    my %syns = ();\n    if ($methods) {\n        my @names;\n        if (ref($methods) eq 'HASH') {\n            @names = keys %{$methods};\n            %syns = %{$methods};\n        }\n        else {\n            @names = @{$methods};\n            %syns = map { $_ => $_ } @names;\n        }\n        %method_names = map { $case ? $_ : lc($_) => $_ } @names;\n    }\n    \n    # deal with hyphens\n    my %orig_args = ref($args) eq 'HASH' ? %{$args} : @{$args};\n    my %args;\n    while (my ($method, $value) = each %orig_args) {\n        $method =~ s/^-+//;\n        $method =~ s/-/_/g;\n        $args{$method} = $value;\n    }\n    \n    # create non-existing methods on request\n    if ($create) {\n        unless ($methods) {\n            %syns = map { $_ => $case ? $_ : lc($_) } keys %args;\n        }\n        \n        foreach my $method (keys %syns) {\n            $self->can($method) && next;\n            \n            my $string = $code || $default_code;\n            if (ref($code) && ref($code) eq 'HASH') {\n                $string = $code->{$method} || $default_code;\n            }\n            \n            my $sub = eval \"sub { $string }\";\n            $self->throw(\"Compilation error for $method : $@\") if $@;\n            \n            no strict 'refs';\n            *{ref($self).'::'.$method} = $sub;\n        }\n    }\n    \n    # create synonyms of existing methods\n    while (my ($method, $syn_ref) = each %syns) {\n        my $method_ref = $self->can($method) || next;\n        \n        foreach my $syn (@{ ref($syn_ref) ? $syn_ref : [$syn_ref] }) {\n            next if $syn eq $method;\n            $method_names{$case ? $syn : lc($syn)} = $syn;\n            next if $self->can($syn);\n            no strict 'refs';\n            *{ref($self).'::'.$syn} = $method_ref;\n        }\n    }\n    \n    # set values for methods\n    while (my ($method, $value) = each %args) {\n        $method = $method_names{$case ? $method : lc($method)} || ($methods ? next : $method);\n        $self->can($method) || next unless $force;\n        $self->$method($value);\n    }\n}\n\n#----------------'\nsub _rearrange_old {\n#----------------\n    my($self,$order,@param) = @_;\n    \n    # JGRG -- This is wrong, because we don't want\n    # to assign empty string to anything, and this\n    # code is actually returning an array 1 less\n    # than the length of @param:\n\n    ## If there are no parameters, we simply wish to return\n    ## an empty array which is the size of the @{$order} array.\n    #return ('') x $#{$order} unless @param;\n    \n    # ...all we need to do is return an empty array:\n    # return unless @param;\n    \n    # If we've got parameters, we need to check to see whether\n    # they are named or simply listed. If they are listed, we\n    # can just return them. \n\n    # The mod test fixes bug where a single string parameter beginning with '-' gets lost.\n    # This tends to happen in error messages such as: $obj->throw(\"-id not defined\")\n    return @param unless (defined($param[0]) && $param[0]=~/^-/o && ($#param % 2));\n\n    # Tester\n#    print \"\\n_rearrange() named parameters:\\n\";\n#    my $i; for ($i=0;$i<@param;$i+=2) { printf \"%20s => %s\\n\", $param[$i],$param[$i+1]; }; <STDIN>;\n\n    # Now we've got to do some work on the named parameters.\n    # The next few lines strip out the '-' characters which\n    # preceed the keys, and capitalizes them.\n    for (my $i=0;$i<@param;$i+=2) {\n\t$param[$i]=~s/^\\-//;\n\t$param[$i]=~tr/a-z/A-Z/;\n    }\n    \n    # Now we'll convert the @params variable into an associative array.\n    # local($^W) = 0;  # prevent \"odd number of elements\" warning with -w.\n    my(%param) = @param;\n    \n    # my(@return_array);\n    \n    # What we intend to do is loop through the @{$order} variable,\n    # and for each value, we use that as a key into our associative\n    # array, pushing the value at that key onto our return array.\n    # my($key);\n    \n    #foreach (@{$order}) {\n\t# my($value) = $param{$key};\n\t# delete $param{$key};\n\t#push(@return_array,$param{$_});\n    #}\n\n    return @param{@{$order}};\n    \n#    print \"\\n_rearrange() after processing:\\n\";\n#    my $i; for ($i=0;$i<@return_array;$i++) { printf \"%20s => %s\\n\", ${$order}[$i], $return_array[$i]; } <STDIN>;\n\n    # return @return_array;\n}\n\n=head2 _register_for_cleanup\n\n Title   : _register_for_cleanup\n Usage   : -- internal --\n Function: Register a method to be called at DESTROY time. This is useful\n           and sometimes essential in the case of multiple inheritance for\n           classes coming second in the sequence of inheritance.\n Returns : \n Args    : a code reference\n\nThe code reference will be invoked with the object as the first\nargument, as per a method.  You may register an unlimited number of\ncleanup methods.","parameters":[{"label":"$self"},{"label":"$method"}],"label":"_register_for_cleanup($self,$method)"}},{"definition":"sub","detail":"($self,$method)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_unregister_for_cleanup","line":677},{"containerName":"_unregister_for_cleanup","kind":13,"name":"$method","line":677},{"line":678,"name":"$self","kind":13,"containerName":"_unregister_for_cleanup"},{"line":678,"containerName":"_unregister_for_cleanup","kind":12,"name":"throw_not_implemented"}],"containerName":"main::","name":"_unregister_for_cleanup","signature":{"parameters":[{"label":"$self"},{"label":"$method"}],"documentation":"1;\n# $Id: RootI.pm 16090 2009-09-15 21:57:56Z cjfields $\n#\n# BioPerl module for Bio::Root::RootI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n# \n# This was refactored to have chained calls to new instead\n# of chained calls to _initialize\n#\n# added debug and deprecated methods --Jason Stajich 2001-10-12\n# \n\n=head1 NAME\n\nBio::Root::RootI - Abstract interface to root object code\n\n=head1 SYNOPSIS\n\n  # any bioperl or bioperl compliant object is a RootI \n  # compliant object\n\n  $obj->throw(\"This is an exception\");\n\n  eval {\n      $obj->throw(\"This is catching an exception\");\n  };\n\n  if( $@ ) {\n      print \"Caught exception\";\n  } else {\n      print \"no exception\";\n  }\n\n  # Using throw_not_implemented() within a RootI-based interface module:\n\n  package Foo;\n  use base qw(Bio::Root::RootI);\n\n  sub foo {\n      my $self = shift;\n      $self->throw_not_implemented;\n  }\n\n\n=head1 DESCRIPTION\n\nThis is just a set of methods which do not assume B<anything> about the object\nthey are on. The methods provide the ability to throw exceptions with nice\nstack traces.\n\nThis is what should be inherited by all Bioperl compliant interfaces, even\nif they are exotic XS/CORBA/Other perl systems.\n\n=head2 Using throw_not_implemented()\n\nThe method L<throw_not_implemented()|throw_not_implemented> should be\ncalled by all methods within interface modules that extend RootI so\nthat if an implementation fails to override them, an exception will be\nthrown.\n\nFor example, say there is an interface module called C<FooI> that\nprovides a method called C<foo()>. Since this method is considered\nabstract within FooI and should be implemented by any module claiming to\nimplement C<FooI>, the C<FooI::foo()> method should consist of the\nfollowing:\n\n    sub foo {\n    \tmy $self = shift;\n    \t$self->throw_not_implemented;\n    }\n\nSo, if an implementer of C<FooI> forgets to implement C<foo()>\nand a user of the implementation calls C<foo()>, a\nL<Bio::Exception::NotImplemented> exception will result.\n\nUnfortunately, failure to implement a method can only be determined at\nrun time (i.e., you can't verify that an implementation is complete by\nrunning C<perl -wc> on it). So it should be standard practice for a test\nof an implementation to check each method and verify that it doesn't\nthrow a L<Bio::Exception::NotImplemented>.\n\n=head1 CONTACT\n\nFunctions originally from Steve Chervitz. Refactored by Ewan\nBirney. Re-refactored by Lincoln Stein. Added to by Sendu Bala.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Root::RootI;\n\nuse vars qw($DEBUG $ID $VERBOSITY);\nuse strict;\nuse Carp 'confess','carp';\n\nuse Bio::Root::Version;\n\nBEGIN { \n    $ID        = 'Bio::Root::RootI';\n    $DEBUG     = 0;\n    $VERBOSITY = 0;\n}\n\nsub new {\n  my $class = shift;\n  my @args = @_;\n  unless ( $ENV{'BIOPERLDEBUG'} ) {\n      carp(\"Use of new in Bio::Root::RootI is deprecated.  Please use Bio::Root::Root instead\");\n  }\n  eval \"require Bio::Root::Root\";\n  return Bio::Root::Root->new(@args);\n}\n\n# for backwards compatibility\nsub _initialize {\n    my($self,@args) = @_;\n    return 1;\n}\n\n\n=head2 throw\n\n Title   : throw\n Usage   : $obj->throw(\"throwing exception message\")\n Function: Throws an exception, which, if not caught with an eval brace\n           will provide a nice stack trace to STDERR with the message\n Returns : nothing\n Args    : A string giving a descriptive error message\n\n\n\nsub throw{\n   my ($self,$string) = @_;\n\n   my $std = $self->stack_trace_dump();\n\n   my $out = \"\\n-------------------- EXCEPTION --------------------\\n\".\n       \"MSG: \".$string.\"\\n\".$std.\"-------------------------------------------\\n\";\n   die $out;\n\n}\n\n=head2 warn\n\n Title   : warn\n Usage   : $object->warn(\"Warning message\");\n Function: Places a warning. What happens now is down to the\n           verbosity of the object  (value of $obj->verbose) \n            verbosity 0 or not set => small warning\n            verbosity -1 => no warning\n            verbosity 1 => warning with stack trace\n            verbosity 2 => converts warnings into throw\n Returns : n/a\n Args    : string (the warning message)\n\n\nsub warn {\n    my ($self,$string) = @_;\n    \n    my $verbose = $self->verbose;\n    \n    my $header = \"\\n--------------------- WARNING ---------------------\\nMSG: \";\n    my $footer =   \"---------------------------------------------------\\n\";\n    \n    if ($verbose >= 2) {\n        $self->throw($string);\n    }\n    elsif ($verbose <= -1) {\n        return;\n    }\n    elsif ($verbose == 1) {\n        CORE::warn $header, $string, \"\\n\", $self->stack_trace_dump, $footer;\n        return;\n    }    \n    \n    CORE::warn $header, $string, \"\\n\", $footer;\n}\n\n=head2 deprecated\n\n Title   : deprecated\n Usage   : $obj->deprecated(\"Method X is deprecated\");\n           $obj->deprecated(\"Method X is deprecated\", 1.007);\n           $obj->deprecated(-message => \"Method X is deprecated\");\n           $obj->deprecated(-message => \"Method X is deprecated\",\n                            -version => 1.007);\n Function: Prints a message about deprecation unless verbose is < 0\n           (which means be quiet)\n Returns : none\n Args    : Message string to print to STDERR\n           Version of BioPerl where use of the method results in an exception\n Notes   : The method can be called two ways, either by positional arguments:\n           \n           $obj->deprecated('This module is deprecated', 1.006);\n           \n           or by named arguments:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -version => 1.006  # throw if $VERSION is >= this version\n                );\n\n           or timed to go off at a certain point:\n           \n           $obj->deprecated(\n                -message => 'use of the method foo() is deprecated, use bar() instead',\n                -warn_version    => 1.006 # warn if $VERSION is >= this version\n                -throw_version   => 1.007 # throw if $VERSION is >= this version\n                );\n           \n           Using the last two named argument versions is suggested and will\n           likely be the only supported way of calling this method in the future\n           Yes, we see the irony of deprecating that particular usage of\n           deprecated().\n           \n           The main difference between usage of the two named argument versions\n           is that by designating a 'warn_version' one indicates the\n           functionality is officially deprecated beginning in a future version\n           of BioPerl (so warnings are issued only after that point), whereas\n           setting either 'version' or 'throw_version' (synonyms) converts the\n           deprecation warning to an exception.\n           \n           For proper comparisons one must use a version in lines with the\n           current versioning scheme for Perl and BioPerl, (i.e. where 1.006000\n           indicates v1.6.0, 5.010000 for v5.10.0, etc.).\n\n\nsub deprecated{\n    my ($self) = shift;\n    my ($msg, $version, $warn_version, $throw_version) =\n        $self->_rearrange([qw(MESSAGE VERSION WARN_VERSION THROW_VERSION)], @_);    \n    $version ||= $throw_version;\n    for my $v ($warn_version, $version) {\n        next unless defined $v;\n        $self->throw('Version must be numerical, such as 1.006000 for v1.6.0, not '.\n                     $v) unless $v =~ /^\\d+\\.\\d+$/;\n    }\n    return if ($warn_version && $Bio::Root::Version::VERSION < $warn_version);\n    # below default insinuates we're deprecating a method and not a full module\n    # but it's the most common use case\n    $msg ||= \"Use of \".(caller(1))[3].\"() is deprecated\";\n    # delegate to either warn or throw based on whether a version is given\n    if ($version) {\n        $msg .= \"\\nTo be removed in $version\";\n        if ($Bio::Root::Version::VERSION >= $version) {\n            $self->throw($msg)\n        } \n    }\n    # passing this on to warn() should deal properly with verbosity issues\n    $self->warn($msg);\n}\n\n=head2 stack_trace_dump\n\n Title   : stack_trace_dump\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub stack_trace_dump{\n   my ($self) = @_;\n\n   my @stack = $self->stack_trace();\n\n   shift @stack;\n   shift @stack;\n   shift @stack;\n\n   my $out;\n   my ($module,$function,$file,$position);\n   \n\n   foreach my $stack ( @stack) {\n       ($module,$file,$position,$function) = @{$stack};\n       $out .= \"STACK $function $file:$position\\n\";\n   }\n\n   return $out;\n}\n\n\n=head2 stack_trace\n\n Title   : stack_trace\n Usage   : @stack_array_ref= $self->stack_trace\n Function: gives an array to a reference of arrays with stack trace info\n           each coming from the caller(stack_number) call\n Returns : array containing a reference of arrays\n Args    : none\n\n\n\nsub stack_trace{\n   my ($self) = @_;\n\n   my $i = 0;\n   my @out = ();\n   my $prev = [];\n   while( my @call = caller($i++)) {\n       # major annoyance that caller puts caller context as\n       # function name. Hence some monkeying around...\n       $prev->[3] = $call[3];\n       push(@out,$prev);\n       $prev = \\@call;\n   }\n   $prev->[3] = 'toplevel';\n   push(@out,$prev);\n   return @out;\n}\n\n\n=head2 _rearrange\n\n Usage     : $object->_rearrange( array_ref, list_of_arguments)\n Purpose   : Rearranges named parameters to requested order.\n Example   : $self->_rearrange([qw(SEQUENCE ID DESC)],@param);\n           : Where @param = (-sequence => $s,\n\t       :                 -desc     => $d,\n\t       :                 -id       => $i);\n Returns   : @params - an array of parameters in the requested order.\n           : The above example would return ($s, $i, $d).\n           : Unspecified parameters will return undef. For example, if\n           :        @param = (-sequence => $s);\n           : the above _rearrange call would return ($s, undef, undef)\n Argument  : $order : a reference to an array which describes the desired\n           :          order of the named parameters.\n           : @param : an array of parameters, either as a list (in\n           :          which case the function simply returns the list),\n           :          or as an associative array with hyphenated tags\n           :          (in which case the function sorts the values \n           :          according to @{$order} and returns that new array.)\n\t       :\t      The tags can be upper, lower, or mixed case\n           :          but they must start with a hyphen (at least the\n           :          first one should be hyphenated.)\n Source    : This function was taken from CGI.pm, written by Dr. Lincoln\n           : Stein, and adapted for use in Bio::Seq by Richard Resnick and\n           : then adapted for use in Bio::Root::Object.pm by Steve Chervitz,\n           : then migrated into Bio::Root::RootI.pm by Ewan Birney.\n Comments  :\n           : Uppercase tags are the norm, \n           : (SAC)\n           : This method may not be appropriate for method calls that are\n           : within in an inner loop if efficiency is a concern.\n           :\n           : Parameters can be specified using any of these formats:\n           :  @param = (-name=>'me', -color=>'blue');\n           :  @param = (-NAME=>'me', -COLOR=>'blue');\n           :  @param = (-Name=>'me', -Color=>'blue');\n           :  @param = ('me', 'blue');\n           : A leading hyphenated argument is used by this function to \n           : indicate that named parameters are being used.\n           : Therefore, the ('me', 'blue') list will be returned as-is.\n           :\n\t       : Note that Perl will confuse unquoted, hyphenated tags as \n           : function calls if there is a function of the same name \n           : in the current namespace:\n           :    -name => 'foo' is interpreted as -&name => 'foo'\n\t       :\n           : For ultimate safety, put single quotes around the tag:\n\t       : ('-name'=>'me', '-color' =>'blue');\n           : This can be a bit cumbersome and I find not as readable\n           : as using all uppercase, which is also fairly safe:\n\t       : (-NAME=>'me', -COLOR =>'blue');\n\t       :\n           : Personal note (SAC): I have found all uppercase tags to\n           : be more managable: it involves less single-quoting,\n           : the key names stand out better, and there are no method naming \n           : conflicts.\n           : The drawbacks are that it's not as easy to type as lowercase,\n           : and lots of uppercase can be hard to read.\n           :\n           : Regardless of the style, it greatly helps to line\n\t       : the parameters up vertically for long/complex lists.\n           :\n           : Note that if @param is a single string that happens to start with\n           : a dash, it will be treated as a hash key and probably fail to\n           : match anything in the array_ref, so not be returned as normally\n           : happens when @param is a simple list and not an associative array.\n\n\nsub _rearrange {\n    my $dummy = shift;\n    my $order = shift;\n    \n    return @_ unless (substr($_[0]||'',0,1) eq '-');\n    push @_,undef unless $#_ %2;\n    my %param;\n    while( @_ ) {\n\t(my $key = shift) =~ tr/a-z\\055/A-Z/d; #deletes all dashes!\n\t$param{$key} = shift;\n    }\n    map { $_ = uc($_) } @$order; # for bug #1343, but is there perf hit here?\n    return @param{@$order};\n}\n\n=head2 _set_from_args\n\n Usage     : $object->_set_from_args(\\%args, -methods => \\@methods)\n Purpose   : Takes a hash of user-supplied args whose keys match method names,\n           : and calls the method supplying it the corresponding value.\n Example   : $self->_set_from_args(\\%args, -methods => [qw(sequence id desc)]);\n           : Where %args = (-sequence    => $s,\n\t       :                -description => $d,\n\t       :                -ID          => $i);\n           :\n           : the above _set_from_args calls the following methods:\n           : $self->sequence($s);\n           : $self->id($i);\n           : ( $self->description($i) is not called because 'description' wasn't\n           :   one of the given methods )\n Argument  : \\%args | \\@args : a hash ref or associative array ref of arguments\n           :                   where keys are any-case strings corresponding to\n           :                   method names but optionally prefixed with\n           :                   hyphens, and values are the values the method\n           :                   should be supplied. If keys contain internal\n           :                   hyphens (eg. to separate multi-word args) they\n           :                   are converted to underscores, since method names\n           :                   cannot contain dashes.\n           : -methods => []  : (optional) only call methods with names in this\n           :                   array ref. Can instead supply a hash ref where\n           :                   keys are method names (of real existing methods\n           :                   unless -create is in effect) and values are array\n           :                   refs of synonyms to allow access to the method\n           :                   using synonyms. If there is only one synonym it\n           :                   can be supplied as a string instead of a single-\n           :                   element array ref\n           : -force => bool  : (optional, default 0) call methods that don't\n           :                   seem to exist, ie. let AUTOLOAD handle them\n           : -create => bool : (optional, default 0) when a method doesn't\n           :                   exist, create it as a simple getter/setter\n           :                   (combined with -methods it would create all the\n           :                   supplied methods that didn't exist, even if not\n           :                   mentioned in the supplied %args)\n           : -code => '' | {}: (optional) when creating methods use the supplied\n           :                   code (a string which will be evaulated as a sub).\n           :                   The default code is a simple get/setter.\n           :                   Alternatively you can supply a hash ref where\n           :                   the keys are method names and the values are\n           :                   code strings. The variable '$method' will be\n           :                   available at evaluation time, so can be used in\n           :                   your code strings. Beware that the strict pragma\n           :                   will be in effect.\n           : -case_sensitive => bool : require case sensitivity on the part of\n           :                           user (ie. a() and A() are two different\n           :                           methods and the user must be careful\n           :                           which they use).\n Comments  :\n           : The \\%args argument will usually be the args received during new()\n           : from the user. The user is allowed to get the case wrong, include\n           : 0 or more than one hyphens as a prefix, and to include hyphens as\n           : multi-word arg separators: '--an-arg' => 1, -an_arg => 1 and\n           : An_Arg => 1 are all equivalent, calling an_arg(1). However, in\n           : documentation users should only be told to use the standard form\n           : -an_arg to avoid confusion. A possible exception to this is a\n           : wrapper module where '--an-arg' is what the user is used to\n           : supplying to the program being wrapped.\n           :\n           : Another issue with wrapper modules is that there may be an\n           : argument that has meaning both to Bioperl and to the program, eg.\n           : -verbose. The recommended way of dealing with this is to leave\n           : -verbose to set the Bioperl verbosity whilst requesting users use\n           : an invented -program_verbose (or similar) to set the program\n           : verbosity. This can be resolved back with\n           : Bio::Tools::Run::WrapperBase's _setparams() method and code along\n           : the lines of:\n           : my %methods = map { $_ => $_ } @LIST_OF_ALL_ALLOWED_PROGRAM_ARGS\n           : delete $methods{'verbose'};\n           : $methods{'program_verbose'} = 'verbose';\n           : my $param_string = $self->_setparams(-methods => \\%methods);\n           : system(\"$exe $param_string\");\n\n\nsub _set_from_args {\n    my ($self, $args, @own_args) = @_;\n    $self->throw(\"a hash/array ref of arguments must be supplied\") unless ref($args);\n    \n    my ($methods, $force, $create, $code, $case);\n    if (@own_args) {\n        ($methods, $force, $create, $code, $case) =\n            $self->_rearrange([qw(METHODS\n                                  FORCE\n                                  CREATE\n                                  CODE\n                                  CASE_SENSITIVE)], @own_args);\n    }\n    my $default_code = 'my $self = shift;\n                        if (@_) { $self->{\\'_\\'.$method} = shift }\n                        return $self->{\\'_\\'.$method};';\n    \n    my %method_names = ();\n    my %syns = ();\n    if ($methods) {\n        my @names;\n        if (ref($methods) eq 'HASH') {\n            @names = keys %{$methods};\n            %syns = %{$methods};\n        }\n        else {\n            @names = @{$methods};\n            %syns = map { $_ => $_ } @names;\n        }\n        %method_names = map { $case ? $_ : lc($_) => $_ } @names;\n    }\n    \n    # deal with hyphens\n    my %orig_args = ref($args) eq 'HASH' ? %{$args} : @{$args};\n    my %args;\n    while (my ($method, $value) = each %orig_args) {\n        $method =~ s/^-+//;\n        $method =~ s/-/_/g;\n        $args{$method} = $value;\n    }\n    \n    # create non-existing methods on request\n    if ($create) {\n        unless ($methods) {\n            %syns = map { $_ => $case ? $_ : lc($_) } keys %args;\n        }\n        \n        foreach my $method (keys %syns) {\n            $self->can($method) && next;\n            \n            my $string = $code || $default_code;\n            if (ref($code) && ref($code) eq 'HASH') {\n                $string = $code->{$method} || $default_code;\n            }\n            \n            my $sub = eval \"sub { $string }\";\n            $self->throw(\"Compilation error for $method : $@\") if $@;\n            \n            no strict 'refs';\n            *{ref($self).'::'.$method} = $sub;\n        }\n    }\n    \n    # create synonyms of existing methods\n    while (my ($method, $syn_ref) = each %syns) {\n        my $method_ref = $self->can($method) || next;\n        \n        foreach my $syn (@{ ref($syn_ref) ? $syn_ref : [$syn_ref] }) {\n            next if $syn eq $method;\n            $method_names{$case ? $syn : lc($syn)} = $syn;\n            next if $self->can($syn);\n            no strict 'refs';\n            *{ref($self).'::'.$syn} = $method_ref;\n        }\n    }\n    \n    # set values for methods\n    while (my ($method, $value) = each %args) {\n        $method = $method_names{$case ? $method : lc($method)} || ($methods ? next : $method);\n        $self->can($method) || next unless $force;\n        $self->$method($value);\n    }\n}\n\n#----------------'\nsub _rearrange_old {\n#----------------\n    my($self,$order,@param) = @_;\n    \n    # JGRG -- This is wrong, because we don't want\n    # to assign empty string to anything, and this\n    # code is actually returning an array 1 less\n    # than the length of @param:\n\n    ## If there are no parameters, we simply wish to return\n    ## an empty array which is the size of the @{$order} array.\n    #return ('') x $#{$order} unless @param;\n    \n    # ...all we need to do is return an empty array:\n    # return unless @param;\n    \n    # If we've got parameters, we need to check to see whether\n    # they are named or simply listed. If they are listed, we\n    # can just return them. \n\n    # The mod test fixes bug where a single string parameter beginning with '-' gets lost.\n    # This tends to happen in error messages such as: $obj->throw(\"-id not defined\")\n    return @param unless (defined($param[0]) && $param[0]=~/^-/o && ($#param % 2));\n\n    # Tester\n#    print \"\\n_rearrange() named parameters:\\n\";\n#    my $i; for ($i=0;$i<@param;$i+=2) { printf \"%20s => %s\\n\", $param[$i],$param[$i+1]; }; <STDIN>;\n\n    # Now we've got to do some work on the named parameters.\n    # The next few lines strip out the '-' characters which\n    # preceed the keys, and capitalizes them.\n    for (my $i=0;$i<@param;$i+=2) {\n\t$param[$i]=~s/^\\-//;\n\t$param[$i]=~tr/a-z/A-Z/;\n    }\n    \n    # Now we'll convert the @params variable into an associative array.\n    # local($^W) = 0;  # prevent \"odd number of elements\" warning with -w.\n    my(%param) = @param;\n    \n    # my(@return_array);\n    \n    # What we intend to do is loop through the @{$order} variable,\n    # and for each value, we use that as a key into our associative\n    # array, pushing the value at that key onto our return array.\n    # my($key);\n    \n    #foreach (@{$order}) {\n\t# my($value) = $param{$key};\n\t# delete $param{$key};\n\t#push(@return_array,$param{$_});\n    #}\n\n    return @param{@{$order}};\n    \n#    print \"\\n_rearrange() after processing:\\n\";\n#    my $i; for ($i=0;$i<@return_array;$i++) { printf \"%20s => %s\\n\", ${$order}[$i], $return_array[$i]; } <STDIN>;\n\n    # return @return_array;\n}\n\n=head2 _register_for_cleanup\n\n Title   : _register_for_cleanup\n Usage   : -- internal --\n Function: Register a method to be called at DESTROY time. This is useful\n           and sometimes essential in the case of multiple inheritance for\n           classes coming second in the sequence of inheritance.\n Returns : \n Args    : a code reference\n\nThe code reference will be invoked with the object as the first\nargument, as per a method.  You may register an unlimited number of\ncleanup methods.\n\n\nsub _register_for_cleanup {\n  my ($self,$method) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 _unregister_for_cleanup\n\n Title   : _unregister_for_cleanup\n Usage   : -- internal --\n Function: Remove a method that has previously been registered to be called\n           at DESTROY time.  If called with a method to be called at DESTROY time.\n           Has no effect if the code reference has not previously been registered.\n Returns : nothing\n Args    : a code reference","label":"_unregister_for_cleanup($self,$method)"},"line":676,"range":{"end":{"line":679,"character":9999},"start":{"character":0,"line":676}},"kind":12},{"line":691,"range":{"start":{"line":691,"character":0},"end":{"line":697,"character":9999}},"kind":12,"children":[{"definition":"my","localvar":"my","containerName":"_cleanup_methods","kind":13,"name":"$self","line":692},{"line":693,"kind":13,"containerName":"_cleanup_methods","name":"$ENV"},{"containerName":"_cleanup_methods","kind":13,"name":"$self","line":693},{"kind":12,"containerName":"_cleanup_methods","name":"verbose","line":693}],"containerName":"main::","name":"_cleanup_methods","definition":"sub"},{"line":694,"name":"carp","kind":12},{"name":"throw_not_implemented","containerName":"main::","children":[{"definition":"my","line":728,"localvar":"my","kind":13,"containerName":"throw_not_implemented","name":"$self"},{"localvar":"my","containerName":"throw_not_implemented","kind":13,"name":"$message","line":736,"definition":"my"},{"line":736,"name":"$self","containerName":"throw_not_implemented","kind":13},{"name":"_not_implemented_msg","kind":12,"containerName":"throw_not_implemented","line":736},{"line":738,"containerName":"throw_not_implemented","kind":13,"name":"$self"},{"line":738,"kind":12,"containerName":"throw_not_implemented","name":"can"},{"line":739,"name":"$self","kind":13,"containerName":"throw_not_implemented"},{"name":"throw","kind":12,"containerName":"throw_not_implemented","line":739},{"line":739,"containerName":"throw_not_implemented","kind":13,"name":"$message"},{"name":"$message","kind":13,"containerName":"throw_not_implemented","line":742}],"definition":"sub","range":{"end":{"character":9999,"line":744},"start":{"line":727,"character":0}},"kind":12,"line":727},{"line":742,"kind":12,"name":"confess"},{"kind":12,"range":{"start":{"character":0,"line":769},"end":{"line":777,"character":9999}},"line":769,"definition":"sub","containerName":"main::","name":"warn_not_implemented","children":[{"kind":13,"localvar":"my","containerName":"warn_not_implemented","name":"$self","line":770,"definition":"my"},{"line":771,"name":"$message","containerName":"warn_not_implemented","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"warn_not_implemented","name":"$self","line":771},{"line":771,"name":"_not_implemented_msg","containerName":"warn_not_implemented","kind":12},{"name":"$self","kind":13,"containerName":"warn_not_implemented","line":772},{"line":772,"containerName":"warn_not_implemented","kind":12,"name":"can"},{"line":773,"name":"$self","kind":13,"containerName":"warn_not_implemented"},{"line":773,"name":"warn","containerName":"warn_not_implemented","kind":12},{"line":773,"name":"$message","containerName":"warn_not_implemented","kind":13},{"line":775,"name":"$message","kind":13,"containerName":"warn_not_implemented"}]},{"line":775,"name":"carp","kind":12},{"kind":12,"range":{"end":{"character":9999,"line":789},"start":{"line":780,"character":0}},"line":780,"name":"_not_implemented_msg","containerName":"main::","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_not_implemented_msg","name":"$self","line":781},{"definition":"my","line":782,"name":"$package","kind":13,"localvar":"my","containerName":"_not_implemented_msg"},{"name":"$self","kind":13,"containerName":"_not_implemented_msg","line":782},{"definition":"my","line":783,"name":"$meth","localvar":"my","kind":13,"containerName":"_not_implemented_msg"},{"definition":"my","localvar":"my","kind":13,"containerName":"_not_implemented_msg","name":"$msg","line":784},{"line":788,"containerName":"_not_implemented_msg","kind":13,"name":"$msg"}],"definition":"sub"}],"version":5}