{"vars":[{"containerName":"","kind":2,"name":"base","line":85},{"line":97,"range":{"end":{"line":107,"character":9999},"start":{"character":0,"line":97}},"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: FastaHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::FastaHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::FastaHSP - HSP object for FASTA specific data\n\n=head1 SYNOPSIS\n\n  # get a FastaHSP from a SearchIO stream\n  my $in = Bio::SearchIO->new(-format => 'fasta', -file => 'filename.fasta');\n\n  while( my $r = $in->next_result) {\n      while( my $hit = $r->next_result ) {\n           while( my $hsp = $hit->next_hsp ) {\n              print \"smith-waterman score (if available): \", \n                    $hsp->sw_score(),\"\\n\";\n           }\n      }\n  }\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::FastaHSP;\nuse strict;\n\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::FastaHSP->new();\n Function: Builds a new Bio::Search::HSP::FastaHSP object \n Returns : Bio::Search::HSP::FastaHSP\n Args    : -swscore => smith-waterman score"},"children":[{"definition":"my","line":98,"name":"$class","localvar":"my","kind":13,"containerName":"new"},{"name":"@args","kind":13,"containerName":"new","line":98},{"line":100,"name":"$self","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":100,"name":"$class","kind":13,"containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":100},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$swscore","line":102},{"name":"$self","kind":13,"containerName":"new","line":102},{"line":102,"containerName":"new","kind":12,"name":"_rearrange"},{"line":102,"name":"@args","kind":13,"containerName":"new"},{"name":"$swscore","containerName":"new","kind":13,"line":104},{"line":104,"name":"$self","kind":13,"containerName":"new"},{"line":104,"name":"sw_score","containerName":"new","kind":12},{"line":104,"kind":13,"containerName":"new","name":"$swscore"},{"line":106,"containerName":"new","kind":13,"name":"$self"}],"name":"new","containerName":"main::","definition":"sub","detail":"($class,@args)"},{"line":100,"name":"SUPER","kind":12,"containerName":"new"},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"sw_score","children":[{"definition":"my","containerName":"sw_score","localvar":"my","kind":13,"name":"$self","line":122},{"line":122,"containerName":"sw_score","kind":13,"name":"$value"},{"line":123,"name":"$value","kind":13,"containerName":"sw_score"},{"line":123,"name":"$self","containerName":"sw_score","kind":13},{"name":"$value","containerName":"sw_score","kind":13,"line":124},{"line":124,"name":"$value","containerName":"sw_score","kind":13},{"name":"$self","kind":13,"containerName":"sw_score","line":125},{"line":125,"name":"$value","containerName":"sw_score","kind":13},{"line":127,"kind":13,"containerName":"sw_score","name":"$self"}],"signature":{"label":"sw_score($self,$value)","documentation":"1;\n# $Id: FastaHSP.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::HSP::FastaHSP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::HSP::FastaHSP - HSP object for FASTA specific data\n\n=head1 SYNOPSIS\n\n  # get a FastaHSP from a SearchIO stream\n  my $in = Bio::SearchIO->new(-format => 'fasta', -file => 'filename.fasta');\n\n  while( my $r = $in->next_result) {\n      while( my $hit = $r->next_result ) {\n           while( my $hsp = $hit->next_hsp ) {\n              print \"smith-waterman score (if available): \", \n                    $hsp->sw_score(),\"\\n\";\n           }\n      }\n  }\n\n=head1 DESCRIPTION\n\nDescribe the object here\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Search::HSP::FastaHSP;\nuse strict;\n\n\nuse base qw(Bio::Search::HSP::GenericHSP);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::HSP::FastaHSP->new();\n Function: Builds a new Bio::Search::HSP::FastaHSP object \n Returns : Bio::Search::HSP::FastaHSP\n Args    : -swscore => smith-waterman score\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  \n  my ($swscore) = $self->_rearrange([qw(SWSCORE)], @args);\n\n  defined $swscore && $self->sw_score($swscore);\n\n  return $self;\n}\n\n\n=head2 sw_score\n\n Title   : sw_score\n Usage   : $obj->sw_score($newval)\n Function: Get/Set Smith-Waterman score\n Returns : value of sw_score\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"end":{"character":9999,"line":128},"start":{"character":0,"line":121}},"line":121},{"definition":"sub","detail":"($self)","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"get_aln","line":132,"definition":"my"},{"definition":"my","line":135,"containerName":"get_aln","localvar":"my","kind":13,"name":"$aln"},{"kind":12,"containerName":"get_aln","name":"new","line":135},{"line":136,"name":"$hs","kind":13,"localvar":"my","containerName":"get_aln","definition":"my"},{"line":136,"containerName":"get_aln","kind":13,"name":"$self"},{"line":136,"containerName":"get_aln","kind":12,"name":"hit_string"},{"definition":"my","line":137,"localvar":"my","kind":13,"containerName":"get_aln","name":"$qs"},{"kind":13,"containerName":"get_aln","name":"$self","line":137},{"kind":12,"containerName":"get_aln","name":"query_string","line":137},{"line":152,"localvar":"my","kind":13,"containerName":"get_aln","name":"$start","definition":"my"},{"containerName":"get_aln","kind":13,"name":"$rest","line":152},{"line":153,"name":"$self","kind":13,"containerName":"get_aln"},{"containerName":"get_aln","kind":12,"name":"homology_string","line":153},{"line":154,"name":"$start","kind":13,"containerName":"get_aln"},{"line":154,"kind":13,"containerName":"get_aln","name":"$rest"},{"name":"$self","containerName":"get_aln","kind":13,"line":156},{"kind":12,"containerName":"get_aln","name":"debug","line":156},{"name":"$self","kind":13,"containerName":"get_aln","line":157},{"line":157,"kind":12,"containerName":"get_aln","name":"debug"},{"line":159,"kind":13,"containerName":"get_aln","name":"$hs"},{"line":159,"name":"$hs","kind":13,"containerName":"get_aln"},{"name":"$start","kind":13,"containerName":"get_aln","line":159},{"name":"$rest","kind":13,"containerName":"get_aln","line":159},{"kind":13,"containerName":"get_aln","name":"$qs","line":160},{"line":160,"name":"$qs","containerName":"get_aln","kind":13},{"line":160,"name":"$start","kind":13,"containerName":"get_aln"},{"name":"$rest","kind":13,"containerName":"get_aln","line":160},{"line":162,"name":"$seqonly","localvar":"my","containerName":"get_aln","kind":13,"definition":"my"},{"kind":13,"containerName":"get_aln","name":"$qs","line":162},{"line":163,"name":"$seqonly","containerName":"get_aln","kind":13},{"definition":"my","containerName":"get_aln","localvar":"my","kind":13,"name":"$q_nm","line":164},{"name":"$s_nm","containerName":"get_aln","kind":13,"line":164},{"name":"$self","kind":13,"containerName":"get_aln","line":164},{"line":164,"name":"query","kind":12,"containerName":"get_aln"},{"containerName":"get_aln","kind":12,"name":"seq_id","line":164},{"line":165,"kind":13,"containerName":"get_aln","name":"$self"},{"line":165,"name":"hit","kind":12,"containerName":"get_aln"},{"containerName":"get_aln","kind":12,"name":"seq_id","line":165},{"containerName":"get_aln","kind":13,"name":"$q_nm","line":166},{"name":"$q_nm","containerName":"get_aln","kind":13,"line":166},{"name":"$q_nm","containerName":"get_aln","kind":13,"line":167},{"line":169,"name":"$s_nm","containerName":"get_aln","kind":13},{"line":169,"containerName":"get_aln","kind":13,"name":"$s_nm"},{"line":170,"kind":13,"containerName":"get_aln","name":"$s_nm"},{"name":"$self","containerName":"get_aln","kind":13,"line":172},{"line":172,"name":"_calculate_seq_positions","containerName":"get_aln","kind":12},{"line":173,"name":"$query","localvar":"my","containerName":"get_aln","kind":13,"definition":"my"},{"line":173,"kind":12,"containerName":"get_aln","name":"new"},{"line":173,"name":"$seqonly","containerName":"get_aln","kind":13},{"line":174,"kind":13,"containerName":"get_aln","name":"$q_nm"},{"line":175,"name":"$self","kind":13,"containerName":"get_aln"},{"line":175,"name":"query","containerName":"get_aln","kind":12},{"line":175,"kind":12,"containerName":"get_aln","name":"start"},{"name":"$self","kind":13,"containerName":"get_aln","line":176},{"line":176,"kind":12,"containerName":"get_aln","name":"query"},{"line":176,"kind":12,"containerName":"get_aln","name":"end"},{"kind":13,"containerName":"get_aln","name":"$self","line":177},{"name":"$self","kind":13,"containerName":"get_aln","line":178},{"containerName":"get_aln","kind":13,"name":"$self","line":179},{"containerName":"get_aln","kind":13,"name":"$self","line":180},{"name":"verbose","kind":12,"containerName":"get_aln","line":181},{"line":182,"name":"$seqonly","containerName":"get_aln","kind":13},{"kind":13,"containerName":"get_aln","name":"$hs","line":182},{"name":"$seqonly","kind":13,"containerName":"get_aln","line":183},{"definition":"my","localvar":"my","kind":13,"containerName":"get_aln","name":"$hit","line":184},{"kind":12,"containerName":"get_aln","name":"new","line":184},{"name":"$seqonly","containerName":"get_aln","kind":13,"line":184},{"line":185,"kind":13,"containerName":"get_aln","name":"$s_nm"},{"name":"$self","kind":13,"containerName":"get_aln","line":186},{"containerName":"get_aln","kind":12,"name":"hit","line":186},{"line":186,"name":"start","kind":12,"containerName":"get_aln"},{"containerName":"get_aln","kind":13,"name":"$self","line":187},{"line":187,"kind":12,"containerName":"get_aln","name":"hit"},{"line":187,"name":"end","kind":12,"containerName":"get_aln"},{"line":188,"kind":13,"containerName":"get_aln","name":"$self"},{"name":"$self","kind":13,"containerName":"get_aln","line":189},{"line":190,"name":"$self","kind":13,"containerName":"get_aln"},{"kind":13,"containerName":"get_aln","name":"$self","line":191},{"line":192,"name":"verbose","kind":12,"containerName":"get_aln"},{"line":193,"kind":13,"containerName":"get_aln","name":"$aln"},{"name":"add_seq","containerName":"get_aln","kind":12,"line":193},{"name":"$query","kind":13,"containerName":"get_aln","line":193},{"line":194,"kind":13,"containerName":"get_aln","name":"$aln"},{"name":"add_seq","containerName":"get_aln","kind":12,"line":194},{"line":194,"name":"$hit","containerName":"get_aln","kind":13},{"line":195,"name":"$aln","kind":13,"containerName":"get_aln"}],"containerName":"main::","name":"get_aln","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"get_aln($self)"},"line":131,"range":{"start":{"line":131,"character":0},"end":{"character":9999,"line":196}},"kind":12},{"kind":12,"containerName":"LocatableSeq::Bio::SimpleAlign","name":"Bio","line":135},{"line":135,"name":"Bio","kind":12,"containerName":"SimpleAlign"},{"line":154,"containerName":"length","kind":12,"name":"CORE"},{"kind":12,"containerName":"length","name":"CORE","line":154},{"line":166,"name":"CORE","containerName":"length","kind":12},{"line":169,"name":"CORE","kind":12,"containerName":"length"},{"line":173,"name":"Bio","kind":12,"containerName":"LocatableSeq"},{"line":177,"name":"seqinds","kind":12},{"line":177,"kind":12,"name":"_frameshiftRes_query"},{"line":178,"kind":12,"name":"seqinds"},{"name":"_frameshiftRes_query","kind":12,"line":178},{"name":"_query_mapping","kind":12,"line":179},{"line":184,"name":"Bio","containerName":"LocatableSeq","kind":12},{"kind":12,"name":"seqinds","line":188},{"line":188,"kind":12,"name":"_frameshiftRes_sbjct"},{"name":"seqinds","kind":12,"line":189},{"name":"_frameshiftRes_sbjct","kind":12,"line":189},{"kind":12,"name":"_hit_mapping","line":190}],"version":5}