{"vars":[{"line":94,"name":"base","kind":2,"containerName":""},{"detail":"($class,@args)","definition":"sub","name":"new","containerName":"main::","children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":115},{"containerName":"new","kind":13,"name":"@args","line":115},{"localvar":"my","containerName":"new","kind":13,"name":"$self","line":116,"definition":"my"},{"line":116,"kind":13,"containerName":"new","name":"$class"},{"line":116,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":118},{"line":118,"name":"_setup","containerName":"new","kind":12},{"line":118,"name":"@args","containerName":"new","kind":13},{"definition":"my","line":120,"name":"$fields","kind":13,"localvar":"my","containerName":"new"},{"line":120,"kind":13,"containerName":"new","name":"$self"},{"line":120,"name":"_fields","containerName":"new","kind":12},{"kind":13,"localvar":"my","containerName":"new","name":"$field","line":121,"definition":"my"},{"line":122,"kind":13,"containerName":"new","name":"$fields"},{"line":122,"name":"$field","kind":13,"containerName":"new"},{"definition":"my","line":125,"name":"$hit_data","containerName":"new","localvar":"my","kind":13},{"name":"$self","containerName":"new","kind":13,"line":125},{"name":"_raw_hit_data","kind":12,"containerName":"new","line":125},{"line":126,"containerName":"new","kind":13,"name":"$hit_data"},{"line":126,"name":"$hit_data","kind":13,"containerName":"new"},{"definition":"my","name":"$field","containerName":"new","localvar":"my","kind":13,"line":127},{"line":128,"kind":13,"containerName":"new","name":"$fields"},{"name":"$field","kind":13,"containerName":"new","line":128},{"line":128,"kind":13,"containerName":"new","name":"$hit_data"}],"signature":{"documentation":"1;\n# $Id: BlastPullHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::BlastPullHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::BlastPullHit - A parser and hit object for BLASTN hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for BLASTN hit output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::BlastPullHit;\n\nuse strict;\n\nuse Bio::Search::HSP::BlastPullHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::BlastNHit->new();\n Function: Builds a new Bio::Search::Hit::BlastNHit object.\n Returns : Bio::Search::Hit::BlastNHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"kind":12,"range":{"start":{"line":114,"character":0},"end":{"character":9999,"line":130}},"line":114},{"name":"SUPER","containerName":"new","kind":12,"line":116},{"containerName":null,"kind":13,"name":"$self","line":132},{"name":"_dependencies","containerName":"main::","kind":12,"line":132},{"kind":12,"name":"name","line":132},{"kind":12,"name":"length","line":133},{"name":"description","kind":12,"line":134},{"line":135,"kind":12,"name":"accession"},{"line":136,"name":"next_hsp","kind":12},{"kind":12,"name":"query_start","line":137},{"line":138,"name":"query_end","kind":12},{"kind":12,"name":"hit_start","line":139},{"name":"hit_end","kind":12,"line":140},{"line":142,"containerName":null,"kind":13,"name":"$self"},{"line":149,"kind":12,"range":{"start":{"line":149,"character":0},"end":{"line":176,"character":9999}},"definition":"sub","children":[{"definition":"my","line":150,"localvar":"my","containerName":"_discover_header","kind":13,"name":"$self"},{"line":151,"kind":13,"containerName":"_discover_header","name":"$self"},{"name":"_chunk_seek","containerName":"_discover_header","kind":12,"line":151},{"line":152,"localvar":"my","kind":13,"containerName":"_discover_header","name":"$header","definition":"my"},{"line":152,"name":"$self","kind":13,"containerName":"_discover_header"},{"line":152,"kind":12,"containerName":"_discover_header","name":"_get_chunk_by_end"},{"kind":13,"containerName":"_discover_header","name":"$header","line":154},{"line":157,"name":"$self","kind":13,"containerName":"_discover_header"},{"line":157,"containerName":"_discover_header","kind":12,"name":"_calculate_accession_from_name"},{"kind":13,"containerName":"_discover_header","name":"$self","line":159},{"line":159,"kind":12,"containerName":"_discover_header","name":"_fields"},{"line":163,"containerName":"_discover_header","kind":13,"name":"$self"},{"line":163,"name":"$self","kind":13,"containerName":"_discover_header"},{"name":"_chunk_tell","kind":12,"containerName":"_discover_header","line":163},{"containerName":"_discover_header","kind":13,"name":"$self","line":165},{"name":"_fields","containerName":"_discover_header","kind":12,"line":165},{"containerName":"_discover_header","kind":13,"name":"$self","line":165},{"name":"_fields","kind":12,"containerName":"_discover_header","line":165},{"name":"$self","kind":13,"containerName":"_discover_header","line":165},{"name":"_fields","kind":12,"containerName":"_discover_header","line":165},{"line":165,"containerName":"_discover_header","kind":13,"name":"$header"},{"line":166,"containerName":"_discover_header","kind":13,"name":"$self"},{"kind":12,"containerName":"_discover_header","name":"_fields","line":166},{"line":167,"name":"$self","kind":13,"containerName":"_discover_header"},{"name":"_fields","kind":12,"containerName":"_discover_header","line":167},{"line":170,"name":"$self","kind":13,"containerName":"_discover_header"},{"name":"_fields","containerName":"_discover_header","kind":12,"line":170},{"name":"$self","containerName":"_discover_header","kind":13,"line":173},{"kind":12,"containerName":"_discover_header","name":"_calculate_accession_from_name","line":173},{"kind":13,"containerName":"_discover_header","name":"$self","line":175},{"containerName":"_discover_header","kind":12,"name":"_fields","line":175}],"containerName":"main::","name":"_discover_header"},{"line":159,"name":"header","kind":12},{"line":163,"kind":12,"name":"_after_header"},{"line":165,"kind":12,"name":"name"},{"name":"description","kind":12,"line":165},{"line":165,"name":"length","kind":12},{"line":166,"name":"description","kind":12},{"kind":12,"name":"description","line":167},{"kind":12,"name":"description","line":170},{"kind":12,"name":"header","line":175},{"range":{"start":{"character":0,"line":178},"end":{"line":191,"character":9999}},"kind":12,"line":178,"definition":"sub","containerName":"main::","name":"_calculate_accession_from_name","children":[{"definition":"my","localvar":"my","containerName":"_calculate_accession_from_name","kind":13,"name":"$self","line":179},{"definition":"my","kind":13,"localvar":"my","containerName":"_calculate_accession_from_name","name":"$name","line":180},{"line":180,"name":"$self","kind":13,"containerName":"_calculate_accession_from_name"},{"line":180,"name":"get_field","containerName":"_calculate_accession_from_name","kind":12},{"line":181,"kind":13,"containerName":"_calculate_accession_from_name","name":"$name"},{"name":"$self","kind":13,"containerName":"_calculate_accession_from_name","line":182},{"line":182,"kind":12,"containerName":"_calculate_accession_from_name","name":"_fields"},{"kind":13,"containerName":"_calculate_accession_from_name","name":"$self","line":184},{"line":184,"containerName":"_calculate_accession_from_name","kind":12,"name":"_fields"},{"line":186,"name":"$self","kind":13,"containerName":"_calculate_accession_from_name"},{"line":186,"name":"_fields","containerName":"_calculate_accession_from_name","kind":12},{"kind":13,"containerName":"_calculate_accession_from_name","name":"$self","line":189},{"line":189,"name":"_fields","containerName":"_calculate_accession_from_name","kind":12},{"line":189,"name":"$name","kind":13,"containerName":"_calculate_accession_from_name"}]},{"kind":12,"name":"accession","line":182},{"name":"name","kind":12,"line":184},{"line":186,"name":"accession","kind":12},{"line":189,"kind":12,"name":"accession"},{"definition":"sub","containerName":"main::","name":"_discover_start_end","children":[{"localvar":"my","containerName":"_discover_start_end","kind":13,"name":"$self","line":194,"definition":"my"},{"definition":"my","localvar":"my","containerName":"_discover_start_end","kind":13,"name":"$q_start","line":196},{"name":"$q_end","containerName":"_discover_start_end","kind":13,"line":196},{"line":196,"name":"$h_start","containerName":"_discover_start_end","kind":13},{"line":196,"kind":13,"containerName":"_discover_start_end","name":"$h_end"},{"definition":"my","localvar":"my","kind":13,"containerName":"_discover_start_end","name":"$hsp","line":197},{"line":197,"name":"$self","kind":13,"containerName":"_discover_start_end"},{"line":197,"kind":12,"containerName":"_discover_start_end","name":"hsps"},{"definition":"my","line":198,"name":"$this_q_start","localvar":"my","kind":13,"containerName":"_discover_start_end"},{"line":198,"name":"$this_h_start","kind":13,"containerName":"_discover_start_end"},{"containerName":"_discover_start_end","kind":13,"name":"$hsp","line":198},{"line":198,"name":"start","kind":12,"containerName":"_discover_start_end"},{"definition":"my","line":199,"name":"$this_q_end","localvar":"my","kind":13,"containerName":"_discover_start_end"},{"name":"$this_h_end","containerName":"_discover_start_end","kind":13,"line":199},{"line":199,"kind":13,"containerName":"_discover_start_end","name":"$hsp"},{"line":199,"name":"end","containerName":"_discover_start_end","kind":12},{"name":"$q_start","containerName":"_discover_start_end","kind":13,"line":201},{"name":"$this_q_start","containerName":"_discover_start_end","kind":13,"line":201},{"containerName":"_discover_start_end","kind":13,"name":"$q_start","line":201},{"line":202,"kind":13,"containerName":"_discover_start_end","name":"$q_start"},{"line":202,"kind":13,"containerName":"_discover_start_end","name":"$this_q_start"},{"name":"$h_start","containerName":"_discover_start_end","kind":13,"line":204},{"kind":13,"containerName":"_discover_start_end","name":"$this_h_start","line":204},{"containerName":"_discover_start_end","kind":13,"name":"$h_start","line":204},{"line":205,"containerName":"_discover_start_end","kind":13,"name":"$h_start"},{"kind":13,"containerName":"_discover_start_end","name":"$this_h_start","line":205},{"line":208,"name":"$q_end","kind":13,"containerName":"_discover_start_end"},{"line":208,"name":"$this_q_end","containerName":"_discover_start_end","kind":13},{"line":208,"name":"$q_end","kind":13,"containerName":"_discover_start_end"},{"line":209,"containerName":"_discover_start_end","kind":13,"name":"$q_end"},{"name":"$this_q_end","kind":13,"containerName":"_discover_start_end","line":209},{"line":211,"containerName":"_discover_start_end","kind":13,"name":"$h_end"},{"kind":13,"containerName":"_discover_start_end","name":"$this_h_end","line":211},{"name":"$h_end","containerName":"_discover_start_end","kind":13,"line":211},{"name":"$h_end","containerName":"_discover_start_end","kind":13,"line":212},{"line":212,"kind":13,"containerName":"_discover_start_end","name":"$this_h_end"},{"line":216,"name":"$self","containerName":"_discover_start_end","kind":13},{"kind":12,"containerName":"_discover_start_end","name":"_fields","line":216},{"line":216,"name":"$q_start","containerName":"_discover_start_end","kind":13},{"line":217,"name":"$self","kind":13,"containerName":"_discover_start_end"},{"line":217,"containerName":"_discover_start_end","kind":12,"name":"_fields"},{"line":217,"name":"$q_end","containerName":"_discover_start_end","kind":13},{"line":218,"name":"$self","kind":13,"containerName":"_discover_start_end"},{"line":218,"name":"_fields","containerName":"_discover_start_end","kind":12},{"line":218,"name":"$h_start","kind":13,"containerName":"_discover_start_end"},{"kind":13,"containerName":"_discover_start_end","name":"$self","line":219},{"kind":12,"containerName":"_discover_start_end","name":"_fields","line":219},{"line":219,"name":"$h_end","kind":13,"containerName":"_discover_start_end"}],"kind":12,"range":{"start":{"line":193,"character":0},"end":{"character":9999,"line":220}},"line":193},{"line":216,"name":"query_start","kind":12},{"line":217,"kind":12,"name":"query_end"},{"name":"hit_start","kind":12,"line":218},{"line":219,"kind":12,"name":"hit_end"},{"name":"_discover_next_hsp","containerName":"main::","children":[{"definition":"my","line":223,"name":"$self","localvar":"my","kind":13,"containerName":"_discover_next_hsp"},{"name":"$self","containerName":"_discover_next_hsp","kind":13,"line":224},{"line":224,"name":"_chunk_seek","kind":12,"containerName":"_discover_next_hsp"},{"line":224,"name":"$self","kind":13,"containerName":"_discover_next_hsp"},{"kind":13,"containerName":"_discover_next_hsp","name":"$self","line":224},{"localvar":"my","containerName":"_discover_next_hsp","kind":13,"name":"$start","line":226,"definition":"my"},{"line":226,"name":"$end","containerName":"_discover_next_hsp","kind":13},{"name":"$self","containerName":"_discover_next_hsp","kind":13,"line":226},{"containerName":"_discover_next_hsp","kind":12,"name":"_find_chunk_by_end","line":226},{"line":227,"containerName":"_discover_next_hsp","kind":13,"name":"$end"},{"kind":13,"containerName":"_discover_next_hsp","name":"$end","line":227},{"name":"$self","kind":13,"containerName":"_discover_next_hsp","line":227},{"line":227,"name":"_chunk_true_start","containerName":"_discover_next_hsp","kind":12},{"name":"$self","kind":13,"containerName":"_discover_next_hsp","line":227},{"name":"_chunk_true_end","kind":12,"containerName":"_discover_next_hsp","line":227},{"kind":13,"containerName":"_discover_next_hsp","name":"$end","line":227},{"name":"$start","containerName":"_discover_next_hsp","kind":13,"line":228},{"line":228,"name":"$self","kind":13,"containerName":"_discover_next_hsp"},{"line":228,"containerName":"_discover_next_hsp","kind":13,"name":"$self"},{"name":"$end","kind":13,"containerName":"_discover_next_hsp","line":229},{"line":229,"name":"$self","kind":13,"containerName":"_discover_next_hsp"},{"name":"_chunk_true_end","containerName":"_discover_next_hsp","kind":12,"line":229},{"line":232,"name":"$end","containerName":"_discover_next_hsp","kind":13},{"kind":13,"containerName":"_discover_next_hsp","name":"$self","line":232},{"containerName":"_discover_next_hsp","kind":12,"name":"_chunk_true_start","line":232},{"name":"$start","containerName":"_discover_next_hsp","kind":13,"line":234},{"name":"$self","kind":13,"containerName":"_discover_next_hsp","line":234},{"line":234,"name":"_chunk_true_start","kind":12,"containerName":"_discover_next_hsp"},{"line":236,"name":"$start","kind":13,"containerName":"_discover_next_hsp"},{"line":236,"containerName":"_discover_next_hsp","kind":13,"name":"$self"},{"name":"_chunk_true_end","containerName":"_discover_next_hsp","kind":12,"line":236},{"kind":13,"containerName":"_discover_next_hsp","name":"$self","line":238},{"kind":13,"containerName":"_discover_next_hsp","name":"$end","line":238},{"line":238,"containerName":"_discover_next_hsp","kind":13,"name":"$self"},{"name":"_chunk_true_start","kind":12,"containerName":"_discover_next_hsp","line":238},{"line":242,"name":"$self","kind":13,"containerName":"_discover_next_hsp"},{"name":"_fields","containerName":"_discover_next_hsp","kind":12,"line":242},{"kind":12,"containerName":"_discover_next_hsp","name":"new","line":242},{"line":242,"containerName":"_discover_next_hsp","kind":13,"name":"$self"},{"line":243,"name":"$self","kind":13,"containerName":"_discover_next_hsp"},{"line":243,"containerName":"_discover_next_hsp","kind":12,"name":"chunk"},{"kind":13,"containerName":"_discover_next_hsp","name":"$start","line":243},{"line":243,"name":"$end","kind":13,"containerName":"_discover_next_hsp"}],"definition":"sub","kind":12,"range":{"start":{"line":222,"character":0},"end":{"line":244,"character":9999}},"line":222},{"name":"_end_of_previous_hsp","kind":12,"line":224},{"line":224,"name":"_after_header","kind":12},{"line":228,"kind":12,"name":"_end_of_previous_hsp"},{"kind":12,"name":"_after_header","line":228},{"line":238,"name":"_end_of_previous_hsp","kind":12},{"kind":12,"name":"next_hsp","line":242},{"containerName":"Search::HSP::BlastPullHSP","kind":12,"name":"Bio","line":242},{"definition":"sub","containerName":"main::","name":"_discover_num_hsps","children":[{"definition":"my","line":247,"localvar":"my","containerName":"_discover_num_hsps","kind":13,"name":"$self"},{"line":248,"name":"$self","containerName":"_discover_num_hsps","kind":13},{"line":248,"kind":12,"containerName":"_discover_num_hsps","name":"_fields"},{"containerName":"_discover_num_hsps","kind":13,"name":"$self","line":248},{"line":248,"containerName":"_discover_num_hsps","kind":12,"name":"hsps"}],"range":{"end":{"character":9999,"line":249},"start":{"line":246,"character":0}},"kind":12,"line":246},{"kind":12,"name":"num_hsps","line":248},{"line":262,"kind":12,"range":{"end":{"line":267,"character":9999},"start":{"line":262,"character":0}},"children":[{"definition":"my","line":263,"localvar":"my","kind":13,"containerName":"next_hsp","name":"$self"},{"localvar":"my","kind":13,"containerName":"next_hsp","name":"$hsp","line":264,"definition":"my"},{"containerName":"next_hsp","kind":13,"name":"$self","line":264},{"line":264,"kind":12,"containerName":"next_hsp","name":"get_field"},{"name":"$self","kind":13,"containerName":"next_hsp","line":265},{"kind":12,"containerName":"next_hsp","name":"_fields","line":265},{"name":"$hsp","containerName":"next_hsp","kind":13,"line":266}],"name":"next_hsp","containerName":"main::","definition":"sub"},{"line":265,"name":"next_hsp","kind":12},{"range":{"end":{"line":289,"character":9999},"start":{"line":279,"character":0}},"kind":12,"line":279,"containerName":"main::","name":"hsps","children":[{"definition":"my","line":280,"name":"$self","kind":13,"localvar":"my","containerName":"hsps"},{"definition":"my","name":"$old","localvar":"my","kind":13,"containerName":"hsps","line":281},{"name":"$self","kind":13,"containerName":"hsps","line":281},{"containerName":"hsps","kind":13,"name":"$self","line":282},{"name":"rewind","kind":12,"containerName":"hsps","line":282},{"definition":"my","name":"@hsps","localvar":"my","kind":13,"containerName":"hsps","line":283},{"definition":"my","name":"$hsp","containerName":"hsps","localvar":"my","kind":13,"line":284},{"containerName":"hsps","kind":13,"name":"$self","line":284},{"kind":12,"containerName":"hsps","name":"next_hsp","line":284},{"kind":13,"containerName":"hsps","name":"@hsps","line":285},{"kind":13,"containerName":"hsps","name":"$hsp","line":285},{"line":287,"name":"$self","kind":13,"containerName":"hsps"},{"line":287,"name":"$old","containerName":"hsps","kind":13},{"line":288,"kind":13,"containerName":"hsps","name":"@hsps"}],"definition":"sub"},{"name":"_end_of_previous_hsp","kind":12,"line":281},{"name":"_end_of_previous_hsp","kind":12,"line":287},{"definition":"sub","detail":"($self,$type)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"hsp","line":310,"definition":"my"},{"line":310,"name":"$type","kind":13,"containerName":"hsp"},{"name":"$type","containerName":"hsp","kind":13,"line":311},{"line":312,"name":"$self","kind":13,"containerName":"hsp"},{"line":312,"name":"throw_not_implemented","kind":12,"containerName":"hsp"}],"name":"hsp","containerName":"main::","signature":{"label":"hsp($self,$type)","parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: BlastPullHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::BlastPullHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::BlastPullHit - A parser and hit object for BLASTN hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'blast_pull',\n\t\t\t\t\t\t\t   -file   => 'result.blast');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for BLASTN hit output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 CONTRIBUTORS\n\nAdditional contributors names and emails here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::BlastPullHit;\n\nuse strict;\n\nuse Bio::Search::HSP::BlastPullHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::BlastNHit->new();\n Function: Builds a new Bio::Search::Hit::BlastNHit object.\n Returns : Bio::Search::Hit::BlastNHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tmy $fields = $self->_fields;\n\tforeach my $field (qw( header start_end )) {\n\t\t$fields->{$field} = undef;\n\t}\n\t\n    my $hit_data = $self->_raw_hit_data;\n\tif ($hit_data && ref($hit_data) eq 'ARRAY') {\n\t\tforeach my $field (qw(name description score significance)) {\n\t\t\t$fields->{$field} = shift(@{$hit_data});\n\t\t}\n\t}\n    \n\t$self->_dependencies( { ( name => 'header',\n\t\t\t\t\t\t\t  length => 'header',\n\t\t\t\t\t\t\t  description => 'header',\n\t\t\t\t\t\t\t  accession => 'header',\n                              next_hsp => 'header',\n                              query_start => 'start_end',\n                              query_end => 'start_end',\n                              hit_start => 'start_end',\n                              hit_end => 'start_end' ) } );\n    \n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all HitI questions\n#\n\nsub _discover_header {\n\tmy $self = shift;\n\t$self->_chunk_seek(0);\n\tmy $header = $self->_get_chunk_by_end(\"\\n Score = \");\n    \n    unless ($header) {\n        # no alignment or other data; all information was in the hit table of\n        # the result\n        $self->_calculate_accession_from_name;\n        \n        $self->_fields->{header} = 1;\n        return;\n    }\n    \n\t$self->{_after_header} = $self->_chunk_tell;\n\t\n    ($self->_fields->{name}, $self->_fields->{description}, $self->_fields->{length}) = $header =~ /^(\\S+)\\s+(\\S.+?)?\\s+Length\\s*=\\s*(\\d+)/sm;\n    if ($self->_fields->{description}) {\n        $self->_fields->{description} =~ s/\\n//g;\n    }\n    else {\n        $self->_fields->{description} = '';\n    }\n\t\n    $self->_calculate_accession_from_name;\n\t\n\t$self->_fields->{header} = 1;\n}\n\nsub _calculate_accession_from_name {\n    my $self = shift;\n    my $name = $self->get_field('name');\n    if ($name =~ /.+?\\|.+?\\|.+?\\|(\\w+)/) {\n        $self->_fields->{accession} = $1;\n    }\n    elsif ($self->_fields->{name} =~ /.+?\\|(\\w+)?\\./) {\n        # old form?\n        $self->_fields->{accession} = $1;\n    }\n    else {\n        $self->_fields->{accession} = $name;\n    }\n}\n\nsub _discover_start_end {\n    my $self = shift;\n    \n    my ($q_start, $q_end, $h_start, $h_end);\n    foreach my $hsp ($self->hsps) {\n        my ($this_q_start, $this_h_start) = $hsp->start;\n        my ($this_q_end, $this_h_end) = $hsp->end;\n        \n        if (! defined $q_start || $this_q_start < $q_start) {\n            $q_start = $this_q_start;\n        }\n        if (! defined $h_start || $this_h_start < $h_start) {\n            $h_start = $this_h_start;\n        }\n        \n        if (! defined $q_end || $this_q_end > $q_end) {\n            $q_end = $this_q_end;\n        }\n        if (! defined $h_end || $this_h_end > $h_end) {\n            $h_end = $this_h_end;\n        }\n    }\n    \n    $self->_fields->{query_start} = $q_start;\n    $self->_fields->{query_end} = $q_end;\n    $self->_fields->{hit_start} = $h_start;\n    $self->_fields->{hit_end} = $h_end;\n}\n\nsub _discover_next_hsp {\n\tmy $self = shift;\n    $self->_chunk_seek($self->{_end_of_previous_hsp} || $self->{_after_header});\n    \n    my ($start, $end) = $self->_find_chunk_by_end(\"\\n Score = \");\n    if ((defined $end && ($end + $self->_chunk_true_start) > $self->_chunk_true_end) || ! $end) {\n\t\t$start = $self->{_end_of_previous_hsp} || $self->{_after_header};\n\t\t$end = $self->_chunk_true_end;\n\t}\n\telse {\n\t\t$end += $self->_chunk_true_start;\n\t}\n\t$start += $self->_chunk_true_start;\n    \n    return if $start >= $self->_chunk_true_end;\n    \n    $self->{_end_of_previous_hsp} = $end - $self->_chunk_true_start;\n    \n    #*** needs to inherit piped_behaviour, and we need to deal with _sequential\n\t#    ourselves\n\t$self->_fields->{next_hsp} = Bio::Search::HSP::BlastPullHSP->new(-parent => $self,\n                                                                    -chunk => [$self->chunk, $start, $end]);\n}\n\nsub _discover_num_hsps {\n    my $self = shift;\n    $self->_fields->{num_hsps} = $self->hsps;\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    my $hsp = $self->get_field('next_hsp');\n\tundef $self->_fields->{next_hsp};\n\treturn $hsp;\n}\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n Example   : @hsps = $hit_object->hsps();\n Returns   : list of L<Bio::Search::HSP::BlastHSP> objects.\n Argument  : none\n\n\nsub hsps {\n    my $self = shift;\n\tmy $old = $self->{_end_of_previous_hsp};\n\t$self->rewind;\n\tmy @hsps;\n\twhile (defined(my $hsp = $self->next_hsp)) {\n\t\tpush(@hsps, $hsp);\n\t}\n\t$self->{_end_of_previous_hsp} = $old;\n\treturn @hsps;\n}\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()"},"line":309,"range":{"end":{"character":9999,"line":313},"start":{"line":309,"character":0}},"kind":12},{"name":"rewind","containerName":"main::","children":[{"definition":"my","line":327,"name":"$self","localvar":"my","kind":13,"containerName":"rewind"},{"name":"$self","containerName":"rewind","kind":13,"line":328}],"definition":"sub","kind":12,"range":{"end":{"line":329,"character":9999},"start":{"character":0,"line":326}},"line":326},{"name":"_end_of_previous_hsp","kind":12,"line":328},{"definition":"sub","containerName":"main::","name":"p","children":[{"name":"significance","containerName":"p","kind":12,"line":333}],"kind":12,"range":{"start":{"character":0,"line":332},"end":{"character":9999,"line":334}},"line":332}],"version":5}