{"version":5,"vars":[{"line":91,"name":"base","containerName":"","kind":2},{"name":"new","containerName":"main::","children":[{"definition":"my","line":113,"name":"$class","localvar":"my","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"@args","line":113},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":114},{"containerName":"new","kind":13,"name":"$class","line":114},{"line":114,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":116},{"name":"_setup","kind":12,"containerName":"new","line":116},{"kind":13,"containerName":"new","name":"@args","line":116},{"line":118,"containerName":"new","localvar":"my","kind":13,"name":"$fields","definition":"my"},{"line":118,"name":"$self","kind":13,"containerName":"new"},{"name":"_fields","containerName":"new","kind":12,"line":118},{"line":119,"name":"$field","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":120,"name":"$fields","containerName":"new","kind":13},{"name":"$field","containerName":"new","kind":13,"line":120},{"definition":"my","name":"$hit_data","kind":13,"localvar":"my","containerName":"new","line":123},{"line":123,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_raw_hit_data","line":123},{"line":124,"containerName":"new","kind":13,"name":"$hit_data"},{"line":124,"containerName":"new","kind":13,"name":"$hit_data"},{"definition":"my","line":125,"containerName":"new","localvar":"my","kind":13,"name":"$field"},{"line":126,"containerName":"new","kind":13,"name":"$fields"},{"line":126,"kind":13,"containerName":"new","name":"$field"},{"name":"$hit_data","containerName":"new","kind":13,"line":126}],"detail":"($class,@args)","definition":"sub","range":{"start":{"character":0,"line":112},"end":{"line":128,"character":9999}},"kind":12,"line":112,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: HmmpfamHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::HmmpfamHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HmmpfamHit - A parser and hit object for hmmpfam hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam hit output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HmmpfamHit;\n\nuse strict;\n\nuse Bio::Search::HSP::HmmpfamHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::HmmpfamHit->new();\n Function: Builds a new Bio::Search::Hit::HmmpfamHit object.\n Returns : Bio::Search::Hit::HmmpfamHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance\n\t\t                                num_hsps rank]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)"}},{"line":114,"containerName":"new","kind":12,"name":"SUPER"},{"name":"%fields","containerName":null,"kind":13,"line":129},{"line":129,"kind":12,"name":"hit_start"},{"line":131,"kind":13,"containerName":null,"name":"$self"},{"kind":12,"containerName":"main::","name":"_fields","line":131},{"kind":12,"name":"accession","line":131},{"line":133,"containerName":null,"kind":13,"name":"$self"},{"line":133,"containerName":"main::","kind":12,"name":"_dependencies"},{"kind":12,"name":"length","line":133},{"line":135,"kind":13,"containerName":null,"name":"$self"},{"definition":"sub","name":"_discover_description","containerName":"main::","children":[],"range":{"start":{"character":0,"line":142},"end":{"character":9999,"line":147}},"kind":12,"line":142},{"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_discover_hsp_data","line":150,"definition":"my"},{"definition":"my","localvar":"my","containerName":"_discover_hsp_data","kind":13,"name":"$hsp_table","line":151},{"containerName":"_discover_hsp_data","kind":13,"name":"$self","line":151},{"line":151,"kind":12,"containerName":"_discover_hsp_data","name":"get_field"},{"line":152,"name":"$hsp_data","containerName":"_discover_hsp_data","localvar":"my","kind":13,"definition":"my"},{"name":"$hsp_table","kind":13,"containerName":"_discover_hsp_data","line":152},{"line":152,"containerName":"_discover_hsp_data","kind":13,"name":"$self"},{"name":"get_field","containerName":"_discover_hsp_data","kind":12,"line":152},{"line":153,"name":"$hsp_data","kind":13,"containerName":"_discover_hsp_data"},{"line":154,"name":"$hsp_data","containerName":"_discover_hsp_data","kind":13},{"line":155,"kind":13,"containerName":"_discover_hsp_data","name":"$self"},{"name":"_fields","containerName":"_discover_hsp_data","kind":12,"line":155},{"name":"$hsp_data","kind":13,"containerName":"_discover_hsp_data","line":155},{"containerName":"_discover_hsp_data","kind":13,"name":"$self","line":159},{"line":159,"kind":12,"containerName":"_discover_hsp_data","name":"_fields"},{"kind":13,"containerName":"_discover_hsp_data","name":"$hsp_data","line":159}],"containerName":"main::","name":"_discover_hsp_data","line":149,"range":{"end":{"line":161,"character":9999},"start":{"line":149,"character":0}},"kind":12},{"name":"hit_length","kind":12,"line":154},{"kind":12,"name":"length","line":155},{"name":"hit_length","kind":12,"line":155},{"name":"hsp_data","kind":12,"line":159},{"kind":12,"name":"hsp_data","line":159},{"definition":"sub","containerName":"main::","name":"_discover_query_start","children":[{"kind":13,"localvar":"my","containerName":"_discover_query_start","name":"$self","line":164,"definition":"my"},{"name":"$hsp_data","containerName":"_discover_query_start","localvar":"my","kind":13,"line":165,"definition":"my"},{"line":165,"name":"$self","kind":13,"containerName":"_discover_query_start"},{"containerName":"_discover_query_start","kind":12,"name":"get_field","line":165},{"definition":"my","localvar":"my","kind":13,"containerName":"_discover_query_start","name":"$this_hsp","line":167},{"line":167,"name":"$a","containerName":"_discover_query_start","kind":13},{"line":167,"name":"$b","containerName":"_discover_query_start","kind":13},{"line":167,"containerName":"_discover_query_start","kind":13,"name":"$hsp_data"}],"range":{"end":{"line":167,"character":9999},"start":{"line":163,"character":0}},"kind":12,"line":163},{"name":"$self","kind":13,"containerName":null,"line":168},{"containerName":"main::","kind":12,"name":"_fields","line":168},{"kind":12,"name":"query_start","line":168},{"line":168,"name":"@this_hsp","kind":13,"containerName":null},{"definition":"sub","children":[{"definition":"my","line":172,"localvar":"my","kind":13,"containerName":"_discover_query_end","name":"$self"},{"line":173,"name":"$hsp_data","containerName":"_discover_query_end","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_discover_query_end","name":"$self","line":173},{"kind":12,"containerName":"_discover_query_end","name":"get_field","line":173},{"line":175,"kind":13,"localvar":"my","containerName":"_discover_query_end","name":"$this_hsp","definition":"my"},{"line":175,"name":"$b","kind":13,"containerName":"_discover_query_end"},{"line":175,"name":"$a","containerName":"_discover_query_end","kind":13},{"kind":13,"containerName":"_discover_query_end","name":"$hsp_data","line":175}],"containerName":"main::","name":"_discover_query_end","line":171,"range":{"start":{"character":0,"line":171},"end":{"line":175,"character":9999}},"kind":12},{"line":176,"name":"$self","kind":13,"containerName":null},{"line":176,"containerName":"main::","kind":12,"name":"_fields"},{"line":176,"kind":12,"name":"query_end"},{"name":"@this_hsp","containerName":null,"kind":13,"line":176},{"line":179,"kind":12,"range":{"end":{"character":9999,"line":183},"start":{"line":179,"character":0}},"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_discover_hit_start","line":180,"definition":"my"},{"definition":"my","line":181,"name":"$hsp_data","containerName":"_discover_hit_start","localvar":"my","kind":13},{"containerName":"_discover_hit_start","kind":13,"name":"$self","line":181},{"line":181,"containerName":"_discover_hit_start","kind":12,"name":"get_field"},{"definition":"my","line":183,"containerName":"_discover_hit_start","localvar":"my","kind":13,"name":"$this_hsp"},{"containerName":"_discover_hit_start","kind":13,"name":"$a","line":183},{"line":183,"name":"$b","kind":13,"containerName":"_discover_hit_start"},{"name":"$hsp_data","containerName":"_discover_hit_start","kind":13,"line":183}],"containerName":"main::","name":"_discover_hit_start"},{"line":184,"name":"$self","kind":13,"containerName":null},{"kind":12,"containerName":"main::","name":"_fields","line":184},{"name":"hit_start","kind":12,"line":184},{"line":184,"name":"@this_hsp","containerName":null,"kind":13},{"definition":"sub","name":"_discover_hit_end","containerName":"main::","children":[{"definition":"my","line":188,"name":"$self","localvar":"my","containerName":"_discover_hit_end","kind":13},{"containerName":"_discover_hit_end","localvar":"my","kind":13,"name":"$hsp_data","line":189,"definition":"my"},{"line":189,"name":"$self","kind":13,"containerName":"_discover_hit_end"},{"line":189,"name":"get_field","containerName":"_discover_hit_end","kind":12},{"definition":"my","line":191,"name":"$this_hsp","containerName":"_discover_hit_end","localvar":"my","kind":13},{"kind":13,"containerName":"_discover_hit_end","name":"$b","line":191},{"line":191,"containerName":"_discover_hit_end","kind":13,"name":"$a"},{"name":"$hsp_data","containerName":"_discover_hit_end","kind":13,"line":191}],"kind":12,"range":{"start":{"character":0,"line":187},"end":{"line":191,"character":9999}},"line":187},{"kind":13,"containerName":null,"name":"$self","line":192},{"line":192,"kind":12,"containerName":"main::","name":"_fields"},{"name":"hit_end","kind":12,"line":192},{"line":192,"containerName":null,"kind":13,"name":"@this_hsp"},{"kind":12,"range":{"end":{"character":9999,"line":206},"start":{"line":195,"character":0}},"line":195,"name":"_discover_next_hsp","containerName":"main::","children":[{"definition":"my","containerName":"_discover_next_hsp","localvar":"my","kind":13,"name":"$self","line":196},{"kind":13,"localvar":"my","containerName":"_discover_next_hsp","name":"$hsp_data","line":197,"definition":"my"},{"line":197,"name":"$self","kind":13,"containerName":"_discover_next_hsp"},{"line":197,"kind":12,"containerName":"_discover_next_hsp","name":"get_field"},{"name":"$self","containerName":"_discover_next_hsp","kind":13,"line":198},{"line":199,"name":"$self","kind":13,"containerName":"_discover_next_hsp"},{"kind":13,"containerName":"_discover_next_hsp","name":"$self","line":201},{"containerName":"_discover_next_hsp","kind":13,"name":"$self","line":203},{"kind":12,"containerName":"_discover_next_hsp","name":"_fields","line":203},{"containerName":"_discover_next_hsp","kind":12,"name":"new","line":203},{"name":"$self","kind":13,"containerName":"_discover_next_hsp","line":203},{"line":204,"kind":13,"containerName":"_discover_next_hsp","name":"$hsp_data"},{"name":"$self","kind":13,"containerName":"_discover_next_hsp","line":204},{"line":206,"name":"$self","containerName":"_discover_next_hsp","kind":13},{"name":"$hsp_data","kind":13,"containerName":"_discover_next_hsp","line":206}],"definition":"sub"},{"line":198,"kind":12,"name":"_next_hsp_index"},{"line":199,"kind":12,"name":"_next_hsp_index"},{"name":"_next_hsp_index","kind":12,"line":201},{"kind":12,"name":"next_hsp","line":203},{"name":"Bio","kind":12,"containerName":"Search::HSP::HmmpfamHSP","line":203},{"name":"_next_hsp_index","kind":12,"line":204},{"line":206,"kind":12,"name":"_next_hsp_index"},{"line":207,"name":"%self","kind":13,"containerName":null},{"name":"_next_hsp_index","kind":12,"line":207},{"definition":"sub","containerName":"main::","name":"next_hsp","children":[{"definition":"my","name":"$self","containerName":"next_hsp","localvar":"my","kind":13,"line":223},{"definition":"my","localvar":"my","kind":13,"containerName":"next_hsp","name":"$hsp","line":224},{"line":224,"name":"$self","containerName":"next_hsp","kind":13},{"line":224,"name":"get_field","kind":12,"containerName":"next_hsp"},{"name":"$self","kind":13,"containerName":"next_hsp","line":225},{"line":225,"kind":12,"containerName":"next_hsp","name":"_fields"},{"line":226,"kind":13,"containerName":"next_hsp","name":"$hsp"}],"range":{"start":{"line":222,"character":0},"end":{"line":227,"character":9999}},"kind":12,"line":222},{"line":225,"kind":12,"name":"next_hsp"},{"line":251,"kind":12,"range":{"end":{"character":9999,"line":261},"start":{"line":251,"character":0}},"definition":"sub","children":[{"localvar":"my","containerName":"hsps","kind":13,"name":"$self","line":252,"definition":"my"},{"line":253,"localvar":"my","kind":13,"containerName":"hsps","name":"$old","definition":"my"},{"line":253,"name":"$self","kind":13,"containerName":"hsps"},{"name":"$self","containerName":"hsps","kind":13,"line":254},{"name":"rewind","kind":12,"containerName":"hsps","line":254},{"line":255,"name":"@hsps","localvar":"my","kind":13,"containerName":"hsps","definition":"my"},{"definition":"my","name":"$hsp","localvar":"my","containerName":"hsps","kind":13,"line":256},{"name":"$self","kind":13,"containerName":"hsps","line":256},{"line":256,"containerName":"hsps","kind":12,"name":"next_hsp"},{"name":"@hsps","kind":13,"containerName":"hsps","line":257},{"line":257,"name":"$hsp","containerName":"hsps","kind":13},{"line":259,"name":"$self","containerName":"hsps","kind":13},{"kind":13,"containerName":"hsps","name":"@hsps","line":259},{"line":259,"kind":13,"containerName":"hsps","name":"$old"},{"line":260,"containerName":"hsps","kind":13,"name":"@hsps"}],"containerName":"main::","name":"hsps"},{"name":"_next_hsp_index","kind":12,"line":253},{"kind":12,"name":"_next_hsp_index","line":259},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"hsp","kind":13,"line":294},{"name":"$type","kind":13,"containerName":"hsp","line":294},{"line":295,"name":"$type","containerName":"hsp","kind":13},{"definition":"my","name":"$hsp_data","localvar":"my","containerName":"hsp","kind":13,"line":296},{"name":"$self","containerName":"hsp","kind":13,"line":296},{"containerName":"hsp","kind":12,"name":"get_field","line":296},{"definition":"my","localvar":"my","containerName":"hsp","kind":13,"name":"$sort","line":298},{"containerName":"hsp","kind":13,"name":"$type","line":299},{"line":300,"name":"$sort","kind":13,"containerName":"hsp"},{"name":"$a","kind":13,"containerName":"hsp","line":300},{"name":"$b","kind":13,"containerName":"hsp","line":300},{"line":302,"name":"$type","kind":13,"containerName":"hsp"},{"name":"$sort","containerName":"hsp","kind":13,"line":303},{"containerName":"hsp","kind":13,"name":"$b","line":303},{"line":303,"name":"$a","kind":13,"containerName":"hsp"},{"line":306,"name":"$self","containerName":"hsp","kind":13},{"line":306,"name":"throw","containerName":"hsp","kind":12},{"line":309,"localvar":"my","kind":13,"containerName":"hsp","name":"$this_hsp","definition":"my"},{"line":309,"name":"$sort","kind":13,"containerName":"hsp"},{"name":"$hsp_data","containerName":"hsp","kind":13,"line":309}],"containerName":"main::","name":"hsp","definition":"sub","detail":"($self,$type)","line":293,"kind":12,"range":{"end":{"character":9999,"line":309},"start":{"character":0,"line":293}},"signature":{"documentation":"1;\n# $Id: HmmpfamHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::HmmpfamHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HmmpfamHit - A parser and hit object for hmmpfam hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam hit output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HmmpfamHit;\n\nuse strict;\n\nuse Bio::Search::HSP::HmmpfamHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::HmmpfamHit->new();\n Function: Builds a new Bio::Search::Hit::HmmpfamHit object.\n Returns : Bio::Search::Hit::HmmpfamHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance\n\t\t                                num_hsps rank]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tmy $fields = $self->_fields;\n\tforeach my $field (qw( next_domain domains hsp_data )) {\n\t\t$fields->{$field} = undef;\n\t}\n\t\n\tmy $hit_data = $self->_raw_hit_data;\n\tif ($hit_data && ref($hit_data) eq 'ARRAY') {\n\t\tforeach my $field (qw(name description score significance num_hsps rank)) {\n\t\t\t$fields->{$field} = shift(@{$hit_data});\n\t\t}\n\t}\n\t$fields->{hit_start} = 1;\n\t\n\tdelete $self->_fields->{accession};\n\t\n\t$self->_dependencies( { ( length => 'hsp_data' ) } );\n\t\n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all HitI questions\n#\n\nsub _discover_description {\n\t# this should be set when this object is created, but if it was undef as is\n\t# possible, this _discover method will be called: just return and keep the\n\t# return value undef\n\treturn;\n}\n\nsub _discover_hsp_data {\n\tmy $self = shift;\n\tmy $hsp_table = $self->get_field('hsp_table');\n\tmy $hsp_data = $hsp_table->{$self->get_field('name')} || undef;\n\tif ($hsp_data) {\n\t\tif (defined $hsp_data->{hit_length}) {\n\t\t\t$self->_fields->{length} = $hsp_data->{hit_length};\n\t\t}\n\t\t\n\t\t# rank query_start query_end hit_start hit_end score evalue\n\t\t$self->_fields->{hsp_data} = $hsp_data->{hsp_data};\n\t}\n}\n\nsub _discover_query_start {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $a->[1] <=> $b->[1] } @{$hsp_data};\n\t$self->_fields->{query_start} = $this_hsp->[1];\n}\n\nsub _discover_query_end {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $b->[2] <=> $a->[2] } @{$hsp_data};\n\t$self->_fields->{query_end} = $this_hsp->[2];\n}\n\nsub _discover_hit_start {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $a->[3] <=> $b->[3] } @{$hsp_data};\n\t$self->_fields->{hit_start} = $this_hsp->[3];\n}\n\nsub _discover_hit_end {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $b->[4] <=> $a->[4] } @{$hsp_data};\n\t$self->_fields->{hit_end} = $this_hsp->[4];\n}\n\nsub _discover_next_hsp {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\tunless (defined $self->{_next_hsp_index}) {\n\t\t$self->{_next_hsp_index} = 0;\n\t}\n\treturn if $self->{_next_hsp_index} == -1;\n\t\n\t$self->_fields->{next_hsp} = Bio::Search::HSP::HmmpfamHSP->new(-parent => $self,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -hsp_data => $hsp_data->[$self->{_next_hsp_index}++]);\n\t\n\tif ($self->{_next_hsp_index} > $#{$hsp_data}) {\n\t\t$self->{_next_hsp_index} = -1;\n\t}\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    my $hsp = $self->get_field('next_hsp');\n\tundef $self->_fields->{next_hsp};\n\treturn $hsp;\n}\n\n=head2 next_domain\n\n Title   : next_domain \n Usage   : my $domain = $hit->next_domain();\n Function: An alias for L<next_hsp()>, this will return the next HSP\n Returns : L<Bio::Search::HSP::HSPI> object\n Args    : none\n\n\n*next_domain = \\&next_hsp;\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n Example   : @hsps = $hit_object->hsps();\n Returns   : list of L<Bio::Search::HSP::BlastHSP> objects.\n Argument  : none\n\n\nsub hsps {\n    my $self = shift;\n\tmy $old = $self->{_next_hsp_index} || 0;\n\t$self->rewind;\n\tmy @hsps;\n\twhile (defined(my $hsp = $self->next_hsp)) {\n\t\tpush(@hsps, $hsp);\n\t}\n\t$self->{_next_hsp_index} =  @hsps > 0 ? $old : -1;\n\treturn @hsps;\n}\n\n=head2 domains\n\n Title   : domains\n Usage   : my @domains = $hit->domains();\n Function: An alias for L<hsps()>, this will return the full list of hsps\n Returns : array of L<Bio::Search::HSP::HSPI> objects\n Args    : none\n\n\n*domains = \\&hsps;\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()","parameters":[{"label":"$self"},{"label":"$type"}],"label":"hsp($self,$type)"}},{"containerName":"Search::HSP::HmmpfamHSP","kind":12,"name":"Bio","line":310},{"containerName":"main::","kind":12,"name":"new","line":310},{"name":"$self","containerName":null,"kind":13,"line":310},{"line":310,"name":"$this_hsp","kind":13,"containerName":null},{"range":{"end":{"character":9999,"line":327},"start":{"character":0,"line":324}},"kind":12,"line":324,"definition":"sub","containerName":"main::","name":"rewind","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"rewind","line":325,"definition":"my"},{"containerName":"rewind","localvar":"my","kind":13,"name":"$hsp_data","line":326,"definition":"my"},{"name":"$self","kind":13,"containerName":"rewind","line":326},{"kind":12,"containerName":"rewind","name":"get_field","line":326},{"line":327,"name":"$self","kind":13,"containerName":"rewind"},{"line":327,"name":"$hsp_data","kind":13,"containerName":"rewind"}]},{"line":327,"kind":12,"name":"_next_hsp_index"},{"line":331,"kind":12,"range":{"end":{"line":333,"character":9999},"start":{"line":331,"character":0}},"children":[{"name":"significance","containerName":"p","kind":12,"line":332}],"containerName":"main::","name":"p","definition":"sub"},{"kind":12,"range":{"start":{"line":352,"character":0},"end":{"line":360,"character":9999}},"line":352,"signature":{"parameters":[{"label":"$self"},{"label":"$type"}],"documentation":"1;\n# $Id: HmmpfamHit.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Search::Hit::HmmpfamHit\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Search::Hit::HmmpfamHit - A parser and hit object for hmmpfam hits\n\n=head1 SYNOPSIS\n\n    # generally we use Bio::SearchIO to build these objects\n    use Bio::SearchIO;\n    my $in = Bio::SearchIO->new(-format => 'hmmer_pull',\n\t\t\t\t\t\t\t   -file   => 'result.hmmer');\n\n    while (my $result = $in->next_result) {\n\t\twhile (my $hit = $result->next_hit) {\n\t\t\tprint $hit->name, \"\\n\";\n\t\t\tprint $hit->score, \"\\n\";\n\t\t\tprint $hit->significance, \"\\n\";\n\n\t\t\twhile (my $hsp = $hit->next_hsp) {\n\t\t\t\t# process HSPI objects\n\t\t\t}\n\t\t}\n    }\n\n=head1 DESCRIPTION\n\nThis object implements a parser for hmmpfam hit output, a program in the HMMER\npackage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Search::Hit::HmmpfamHit;\n\nuse strict;\n\nuse Bio::Search::HSP::HmmpfamHSP;\n\nuse base qw(Bio::Root::Root Bio::Search::Hit::PullHitI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Search::Hit::HmmpfamHit->new();\n Function: Builds a new Bio::Search::Hit::HmmpfamHit object.\n Returns : Bio::Search::Hit::HmmpfamHit\n Args    : -chunk    => [Bio::Root::IO, $start, $end] (required if no -parent)\n           -parent   => Bio::PullParserI object (required if no -chunk)\n           -hit_data => array ref with [name description score significance\n\t\t                                num_hsps rank]\n\n           where the array ref provided to -chunk contains an IO object\n           for a filehandle to something representing the raw data of the\n           hit, and $start and $end define the tell() position within the\n           filehandle that the hit data starts and ends (optional; defaults\n           to start and end of the entire thing described by the filehandle)\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\t\n\t$self->_setup(@args);\n\t\n\tmy $fields = $self->_fields;\n\tforeach my $field (qw( next_domain domains hsp_data )) {\n\t\t$fields->{$field} = undef;\n\t}\n\t\n\tmy $hit_data = $self->_raw_hit_data;\n\tif ($hit_data && ref($hit_data) eq 'ARRAY') {\n\t\tforeach my $field (qw(name description score significance num_hsps rank)) {\n\t\t\t$fields->{$field} = shift(@{$hit_data});\n\t\t}\n\t}\n\t$fields->{hit_start} = 1;\n\t\n\tdelete $self->_fields->{accession};\n\t\n\t$self->_dependencies( { ( length => 'hsp_data' ) } );\n\t\n    return $self;\n}\n\n#\n# PullParserI discovery methods so we can answer all HitI questions\n#\n\nsub _discover_description {\n\t# this should be set when this object is created, but if it was undef as is\n\t# possible, this _discover method will be called: just return and keep the\n\t# return value undef\n\treturn;\n}\n\nsub _discover_hsp_data {\n\tmy $self = shift;\n\tmy $hsp_table = $self->get_field('hsp_table');\n\tmy $hsp_data = $hsp_table->{$self->get_field('name')} || undef;\n\tif ($hsp_data) {\n\t\tif (defined $hsp_data->{hit_length}) {\n\t\t\t$self->_fields->{length} = $hsp_data->{hit_length};\n\t\t}\n\t\t\n\t\t# rank query_start query_end hit_start hit_end score evalue\n\t\t$self->_fields->{hsp_data} = $hsp_data->{hsp_data};\n\t}\n}\n\nsub _discover_query_start {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $a->[1] <=> $b->[1] } @{$hsp_data};\n\t$self->_fields->{query_start} = $this_hsp->[1];\n}\n\nsub _discover_query_end {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $b->[2] <=> $a->[2] } @{$hsp_data};\n\t$self->_fields->{query_end} = $this_hsp->[2];\n}\n\nsub _discover_hit_start {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $a->[3] <=> $b->[3] } @{$hsp_data};\n\t$self->_fields->{hit_start} = $this_hsp->[3];\n}\n\nsub _discover_hit_end {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy ($this_hsp) = sort { $b->[4] <=> $a->[4] } @{$hsp_data};\n\t$self->_fields->{hit_end} = $this_hsp->[4];\n}\n\nsub _discover_next_hsp {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\tunless (defined $self->{_next_hsp_index}) {\n\t\t$self->{_next_hsp_index} = 0;\n\t}\n\treturn if $self->{_next_hsp_index} == -1;\n\t\n\t$self->_fields->{next_hsp} = Bio::Search::HSP::HmmpfamHSP->new(-parent => $self,\n\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  -hsp_data => $hsp_data->[$self->{_next_hsp_index}++]);\n\t\n\tif ($self->{_next_hsp_index} > $#{$hsp_data}) {\n\t\t$self->{_next_hsp_index} = -1;\n\t}\n}\n\n=head2 next_hsp\n\n Title    : next_hsp\n Usage    : while( $hsp = $obj->next_hsp()) { ... }\n Function : Returns the next available High Scoring Pair\n Example  : \n Returns  : L<Bio::Search::HSP::HSPI> object or null if finished\n Args     : none\n\n\nsub next_hsp {\n    my $self = shift;\n    my $hsp = $self->get_field('next_hsp');\n\tundef $self->_fields->{next_hsp};\n\treturn $hsp;\n}\n\n=head2 next_domain\n\n Title   : next_domain \n Usage   : my $domain = $hit->next_domain();\n Function: An alias for L<next_hsp()>, this will return the next HSP\n Returns : L<Bio::Search::HSP::HSPI> object\n Args    : none\n\n\n*next_domain = \\&next_hsp;\n\n=head2 hsps\n\n Usage     : $hit_object->hsps();\n Purpose   : Get a list containing all HSP objects.\n Example   : @hsps = $hit_object->hsps();\n Returns   : list of L<Bio::Search::HSP::BlastHSP> objects.\n Argument  : none\n\n\nsub hsps {\n    my $self = shift;\n\tmy $old = $self->{_next_hsp_index} || 0;\n\t$self->rewind;\n\tmy @hsps;\n\twhile (defined(my $hsp = $self->next_hsp)) {\n\t\tpush(@hsps, $hsp);\n\t}\n\t$self->{_next_hsp_index} =  @hsps > 0 ? $old : -1;\n\treturn @hsps;\n}\n\n=head2 domains\n\n Title   : domains\n Usage   : my @domains = $hit->domains();\n Function: An alias for L<hsps()>, this will return the full list of hsps\n Returns : array of L<Bio::Search::HSP::HSPI> objects\n Args    : none\n\n\n*domains = \\&hsps;\n\n=head2 hsp\n\n Usage     : $hit_object->hsp( [string] );\n Purpose   : Get a single HSPI object for the present HitI object.\n Example   : $hspObj  = $hit_object->hsp;  # same as 'best'\n           : $hspObj  = $hit_object->hsp('best');\n           : $hspObj  = $hit_object->hsp('worst');\n Returns   : Object reference for a L<Bio::Search::HSP::HSPI> object.\n Argument  : String (or no argument).\n           :   No argument (default) = highest scoring HSP (same as 'best').\n           :   'best'  = highest scoring HSP.\n           :   'worst' = lowest scoring HSP.\n Throws    : Exception if an unrecognized argument is used.\n\nSee Also   : L<hsps()|hsps>, L<num_hsps>()\n\n\nsub hsp {\n    my ($self, $type) = @_;\n\t$type ||= 'best';\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t\n\tmy $sort;\n\tif ($type eq 'best') {\n\t\t$sort = sub { $a->[6] <=> $b->[6] };\n\t}\n\telsif ($type eq 'worst') {\n\t\t$sort = sub { $b->[6] <=> $a->[6] };\n\t}\n\telse {\n\t\t$self->throw(\"Unknown arg '$type' given to hsp()\");\n\t}\n\t\n\tmy ($this_hsp) = sort $sort @{$hsp_data};\n\treturn Bio::Search::HSP::HmmpfamHSP->new(-parent => $self, -hsp_data => $this_hsp);\n}\n\n=head2 rewind\n\n Title   : rewind\n Usage   : $result->rewind;\n Function: Allow one to reset the Hit iterator to the beginning, so that\n           next_hit() will subsequently return the first hit and so on.\n Returns : n/a\n Args    : none\n\n\nsub rewind {\n\tmy $self = shift;\n\tmy $hsp_data = $self->get_field('hsp_data') || return;\n\t$self->{_next_hsp_index} = @{$hsp_data} > 0 ? 0 : -1;\n}\n\n# have p() a synonym of significance()\nsub p {\n\treturn shift->significance;\n}\n\n=head2 strand\n\n Usage     : $sbjct->strand( [seq_type] );\n Purpose   : Gets the strand(s) for the query, sbjct, or both sequences.\n           : For hmmpfam, the answers are always 1 (forward strand).\n Example   : $qstrand = $sbjct->strand('query');\n           : $sstrand = $sbjct->strand('hit');\n           : ($qstrand, $sstrand) = $sbjct->strand();\n Returns   : scalar context: integer '1'\n           : array context without args: list of two strings (1, 1)\n           : Array context can be \"induced\" by providing an argument of 'list'\n\t\t   : or 'array'.\n Argument  : In scalar context: seq_type = 'query' or 'hit' or 'sbjct' (default\n           : = 'query') ('sbjct' is synonymous with 'hit')","label":"strand($self,$type)"},"name":"strand","containerName":"main::","children":[{"definition":"my","line":353,"name":"$self","containerName":"strand","localvar":"my","kind":13},{"line":353,"kind":13,"containerName":"strand","name":"$type"},{"line":354,"kind":13,"containerName":"strand","name":"$type"},{"line":355,"kind":13,"containerName":"strand","name":"$type"},{"name":"$type","containerName":"strand","kind":13,"line":355},{"name":"$type","kind":13,"containerName":"strand","line":356},{"name":"$type","kind":13,"containerName":"strand","line":356}],"detail":"($self,$type)","definition":"sub"},{"kind":12,"range":{"start":{"line":375,"character":0},"end":{"line":375,"character":9999}},"line":375,"containerName":"main::","name":"frac_aligned_query","children":[],"definition":"sub"}]}