{"version":5,"vars":[{"line":107,"containerName":"","kind":2,"name":"vars"},{"line":109,"containerName":"","kind":2,"name":"base"},{"kind":13,"containerName":null,"name":"%MODEMAP","line":113},{"line":121,"name":"%MAPPING","containerName":null,"kind":13},{"line":140,"name":"$DEFAULT_BLAST_WRITER_CLASS","kind":13,"containerName":null},{"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"_initialize","children":[{"line":156,"containerName":"_initialize","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"_initialize","name":"@args","line":156},{"line":157,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"@args","kind":13,"containerName":"_initialize","line":157},{"definition":"my","name":"$fmt","kind":13,"localvar":"my","containerName":"_initialize","line":158},{"kind":13,"containerName":"_initialize","name":"$self","line":158},{"name":"_rearrange","kind":12,"containerName":"_initialize","line":158},{"name":"@args","kind":13,"containerName":"_initialize","line":158},{"containerName":"_initialize","kind":13,"name":"$self","line":160},{"line":160,"containerName":"_initialize","kind":12,"name":"throw"},{"name":"$fmt","containerName":"_initialize","kind":13,"line":160},{"line":161,"containerName":"_initialize","kind":13,"name":"$self"},{"kind":12,"containerName":"_initialize","name":"report_format","line":161},{"kind":13,"containerName":"_initialize","name":"$fmt","line":161}],"signature":{"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"range":{"start":{"character":0,"line":155},"end":{"character":9999,"line":163}},"kind":12,"line":155},{"line":157,"containerName":"_initialize","kind":12,"name":"SUPER"},{"range":{"end":{"character":9999,"line":277},"start":{"character":0,"line":175}},"kind":12,"line":175,"signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none"},"name":"next_result","containerName":"main::","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"next_result","line":176,"definition":"my"},{"kind":13,"localvar":"my","containerName":"next_result","name":"$fmt","line":181,"definition":"my"},{"line":181,"kind":13,"containerName":"next_result","name":"$self"},{"kind":12,"containerName":"next_result","name":"report_format","line":181},{"definition":"my","line":182,"name":"$lastquery","kind":13,"localvar":"my","containerName":"next_result"},{"name":"$lasthit","containerName":"next_result","kind":13,"line":182},{"line":183,"name":"$self","kind":13,"containerName":"next_result"},{"line":183,"kind":12,"containerName":"next_result","name":"_readline"},{"line":184,"kind":13,"containerName":"next_result","name":"$fmt"},{"definition":"my","line":189,"name":"$hit","containerName":"next_result","localvar":"my","kind":13},{"line":189,"containerName":"next_result","kind":13,"name":"$strand"},{"line":189,"name":"$query","containerName":"next_result","kind":13},{"name":"$h_start","kind":13,"containerName":"next_result","line":190},{"line":190,"containerName":"next_result","kind":13,"name":"$q_start"},{"line":190,"name":"$h_end","kind":13,"containerName":"next_result"},{"line":190,"kind":13,"containerName":"next_result","name":"$q_end"},{"line":191,"name":"$score","kind":13,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$lastquery","line":192},{"line":193,"name":"$self","containerName":"next_result","kind":13},{"name":"start_element","kind":12,"containerName":"next_result","line":193},{"line":194,"containerName":"next_result","kind":13,"name":"$self"},{"line":194,"kind":12,"containerName":"next_result","name":"element"},{"line":196,"kind":13,"containerName":"next_result","name":"$self"},{"line":196,"name":"element","containerName":"next_result","kind":12},{"name":"$query","containerName":"next_result","kind":13,"line":197},{"kind":13,"containerName":"next_result","name":"$lastquery","line":198},{"kind":13,"containerName":"next_result","name":"$query","line":198},{"name":"$self","containerName":"next_result","kind":13,"line":199},{"kind":12,"containerName":"next_result","name":"_pushback","line":199},{"name":"$self","containerName":"next_result","kind":13,"line":200},{"name":"end_element","kind":12,"containerName":"next_result","line":200},{"name":"$lasthit","containerName":"next_result","kind":13,"line":200},{"name":"$self","containerName":"next_result","kind":13,"line":201},{"line":201,"name":"end_element","kind":12,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$lasthit","line":202},{"containerName":"next_result","kind":13,"name":"$lastquery","line":203},{"name":"$self","kind":13,"containerName":"next_result","line":204},{"containerName":"next_result","kind":12,"name":"end_document","line":204},{"line":207,"containerName":"next_result","kind":13,"name":"$lasthit"},{"line":207,"containerName":"next_result","kind":13,"name":"$lasthit"},{"name":"$hit","kind":13,"containerName":"next_result","line":207},{"name":"$self","containerName":"next_result","kind":13,"line":208},{"line":208,"kind":12,"containerName":"next_result","name":"end_element"},{"kind":13,"containerName":"next_result","name":"$lasthit","line":208},{"containerName":"next_result","kind":13,"name":"$self","line":209},{"kind":12,"containerName":"next_result","name":"start_element","line":209},{"line":210,"name":"$self","containerName":"next_result","kind":13},{"line":210,"name":"element","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$hit","line":211},{"kind":13,"containerName":"next_result","name":"$self","line":213},{"line":213,"containerName":"next_result","kind":12,"name":"start_element"},{"line":214,"kind":13,"containerName":"next_result","name":"$self"},{"line":214,"kind":12,"containerName":"next_result","name":"element"},{"line":215,"name":"$score","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$strand","line":243},{"line":244,"containerName":"next_result","kind":13,"name":"$h_start"},{"kind":13,"containerName":"next_result","name":"$h_end","line":244},{"line":244,"name":"$h_end","kind":13,"containerName":"next_result"},{"kind":13,"containerName":"next_result","name":"$h_start","line":244},{"kind":13,"containerName":"next_result","name":"$q_start","line":245},{"kind":13,"containerName":"next_result","name":"$q_end","line":245},{"name":"$q_end","containerName":"next_result","kind":13,"line":245},{"line":245,"kind":13,"containerName":"next_result","name":"$q_start"},{"name":"$self","kind":13,"containerName":"next_result","line":247},{"line":247,"name":"element","kind":12,"containerName":"next_result"},{"line":248,"kind":13,"containerName":"next_result","name":"$h_start"},{"name":"$self","kind":13,"containerName":"next_result","line":249},{"line":249,"kind":12,"containerName":"next_result","name":"element"},{"line":250,"name":"$h_end","containerName":"next_result","kind":13},{"line":251,"kind":13,"containerName":"next_result","name":"$self"},{"line":251,"name":"element","kind":12,"containerName":"next_result"},{"line":252,"kind":13,"containerName":"next_result","name":"$q_start"},{"name":"$self","containerName":"next_result","kind":13,"line":253},{"line":253,"kind":12,"containerName":"next_result","name":"element"},{"line":254,"name":"$q_end","containerName":"next_result","kind":13},{"line":256,"name":"$numid","containerName":"next_result","localvar":"my","kind":13,"definition":"my"},{"line":256,"containerName":"next_result","kind":13,"name":"$q_end"},{"kind":13,"containerName":"next_result","name":"$q_start","line":256},{"line":256,"kind":13,"containerName":"next_result","name":"$score"},{"kind":13,"containerName":"next_result","name":"$self","line":258},{"line":258,"name":"element","containerName":"next_result","kind":12},{"line":259,"name":"$numid","containerName":"next_result","kind":13},{"line":260,"name":"$self","kind":13,"containerName":"next_result"},{"line":260,"containerName":"next_result","kind":12,"name":"element"},{"line":261,"kind":13,"containerName":"next_result","name":"$numid"},{"line":263,"name":"$self","kind":13,"containerName":"next_result"},{"line":263,"containerName":"next_result","kind":12,"name":"end_element"},{"name":"$lasthit","containerName":"next_result","kind":13,"line":264},{"kind":13,"containerName":"next_result","name":"$hit","line":264},{"name":"$lastquery","kind":13,"containerName":"next_result","line":265},{"line":265,"name":"$query","containerName":"next_result","kind":13},{"line":267,"kind":13,"containerName":"next_result","name":"$self"},{"line":267,"containerName":"next_result","kind":12,"name":"debug"},{"line":271,"name":"$lastquery","kind":13,"containerName":"next_result"},{"line":271,"containerName":"next_result","kind":13,"name":"$fmt"},{"name":"$self","containerName":"next_result","kind":13,"line":272},{"kind":12,"containerName":"next_result","name":"end_element","line":272},{"line":272,"kind":13,"containerName":"next_result","name":"$lasthit"},{"containerName":"next_result","kind":13,"name":"$self","line":273},{"line":273,"kind":12,"containerName":"next_result","name":"end_element"},{"name":"$self","containerName":"next_result","kind":13,"line":274},{"containerName":"next_result","kind":12,"name":"end_document","line":274}],"detail":"($self)","definition":"sub"},{"line":290,"range":{"end":{"character":9999,"line":294},"start":{"character":0,"line":290}},"kind":12,"children":[{"line":291,"containerName":"report_format","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":292,"kind":13,"containerName":"report_format","name":"$self"},{"line":293,"containerName":"report_format","kind":13,"name":"$self"}],"name":"report_format","containerName":"main::","definition":"sub"},{"signature":{"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   \n   local $/ = \"\\n\";\n   local $_;\n\n   my $fmt = $self->report_format;\n   my ($lastquery,$lasthit);\n   while( defined($_ = $self->_readline) ) {\n       if( $fmt == 0 ) {\n\t   if( /^\\'(\\S+)\\'\\=\\=\\'(\\+|\\-)(\\S+)\\'\\s+\n\t       \\((\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\)\\s+\n\t       (\\d+)/ox )\n\t   {\n\t       my ($hit,$strand,$query,\n\t\t   $h_start,$q_start,$h_end,$q_end,\n\t\t   $score) = ($1,$2,$3,$4,$5,$6,$7,$8);\n\t       if( ! defined $lastquery ) {\n\t\t   $self->start_element({'Name' => 'MegaBlastOutput'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_program',\n\t\t\t\t   'Data' => 'MEGABLAST'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_query-def',\n\t\t\t\t   'Data' => $query});\n\t       } elsif( $lastquery ne $query ) {\n\t\t   $self->_pushback($_);\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->end_element({ 'Name' => 'MegaBlastOutput'});\n\t\t   $lasthit = undef;\n\t\t   $lastquery = undef;\n\t\t   return $self->end_document();\n\t       }\n\n\t       if( ! defined $lasthit || $lasthit ne $hit  ) {\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->start_element({'Name' => 'Hit'});\n\t\t   $self->element({'Name' => 'Hit_id',\n\t\t\t\t   'Data' => $hit});\n\t       }\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t       'Data' => $score});\n\n\t       # flip flop start/end if strand is < 0\n\t       # since strandedness is inferred from the query\n\t       # because of the way it is coded all queries will\n\t       # be on the forward strand and hits will be either\n\t       # +/-\n\n\t       # also the NCBI docs state:\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\t\n\t       # and yet when rev strand hits are made I see\n\t       # (MBL 2.2.4)\n\t       # 'Contig634'=='-503384' (1 7941 321 7620) 19\n\t       # so the query is on the rev strand and the\n\t       # subject is on the fwd strand\n\t       # so I am flip-flopping everything when I see a '-'\n\t       if( $strand eq '-' ) {\n\t\t   ($h_start,$h_end) = ( $h_end,$h_start);\n\t\t   ($q_start,$q_end) = ( $q_end,$q_start);\n\t       }\n\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t       'Data' => $h_start});\n\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t       'Data' => $h_end});\n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $q_start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $q_end});\n\t       # might not be quite right -- need to know length of the HSP\n\t       my $numid = (abs($q_end - $q_start) - $score);\n\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => $numid});\n\t       $self->element({'Name' => 'Hsp_positive',\n\t\t\t       'Data' => $numid});\n\n\t       $self->end_element({'Name' => 'Hsp'});\n\t       $lasthit   = $hit;\n\t       $lastquery = $query;\n\t   } else {\n\t       $self->debug(\"Unknown line in fmt0 parsing: $_\");\n\t   }\n       }\n   }\n   if( defined $lastquery && $fmt == 0 ) {\n       $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n       $self->end_element({ 'Name' => 'MegaBlastOutput'});\n       return $self->end_document();\n   }\n   return 0;\n}\n\n=head2 report_format\n\n Title   : report_format\n Usage   : $obj->report_format($newval)\n Function: Get/Set the report_format value\n Returns : value of report_format (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub report_format{\n    my $self = shift;\n    return $self->{'_report_format'} = shift if @_;\n    return $self->{'_report_format'};\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"start_element($self,$data)"},"line":308,"kind":12,"range":{"end":{"character":9999,"line":319},"start":{"character":0,"line":308}},"definition":"sub","detail":"($self,$data)","children":[{"definition":"my","line":309,"name":"$self","containerName":"start_element","localvar":"my","kind":13},{"line":309,"name":"$data","kind":13,"containerName":"start_element"},{"definition":"my","line":311,"name":"$nm","kind":13,"localvar":"my","containerName":"start_element"},{"line":311,"name":"$data","kind":13,"containerName":"start_element"},{"definition":"my","line":312,"name":"$type","localvar":"my","kind":13,"containerName":"start_element"},{"kind":13,"containerName":"start_element","name":"$MODEMAP","line":312},{"line":312,"kind":13,"containerName":"start_element","name":"$nm"},{"kind":13,"containerName":"start_element","name":"$self","line":313},{"line":313,"kind":12,"containerName":"start_element","name":"_mode"},{"name":"$type","kind":13,"containerName":"start_element","line":313},{"line":314,"name":"$self","kind":13,"containerName":"start_element"},{"line":314,"containerName":"start_element","kind":12,"name":"_eventHandler"},{"name":"will_handle","kind":12,"containerName":"start_element","line":314},{"line":314,"kind":13,"containerName":"start_element","name":"$type"},{"line":315,"localvar":"my","kind":13,"containerName":"start_element","name":"$func","definition":"my"},{"kind":13,"containerName":"start_element","name":"$type","line":315},{"line":316,"containerName":"start_element","kind":13,"name":"$self"},{"line":316,"containerName":"start_element","kind":12,"name":"_eventHandler"},{"line":316,"kind":13,"containerName":"start_element","name":"$func"},{"name":"$data","kind":13,"containerName":"start_element","line":316},{"name":"$self","containerName":"start_element","kind":13,"line":318},{"name":"$type","kind":13,"containerName":"start_element","line":318}],"name":"start_element","containerName":"main::"},{"line":321,"name":"%nm","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":322},{"line":323,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"%self","line":324},{"definition":"sub","detail":"($self,$data)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"end_element","line":341},{"line":341,"kind":13,"containerName":"end_element","name":"$data"},{"line":342,"kind":13,"localvar":"my","containerName":"end_element","name":"$nm","definition":"my"},{"line":342,"kind":13,"containerName":"end_element","name":"$data"},{"name":"$rc","kind":13,"localvar":"my","containerName":"end_element","line":343,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"end_element","name":"$type","line":345},{"containerName":"end_element","kind":13,"name":"$MODEMAP","line":345},{"line":345,"kind":13,"containerName":"end_element","name":"$nm"},{"name":"$self","containerName":"end_element","kind":13,"line":346},{"line":346,"kind":12,"containerName":"end_element","name":"_eventHandler"},{"name":"will_handle","containerName":"end_element","kind":12,"line":346},{"containerName":"end_element","kind":13,"name":"$type","line":346},{"definition":"my","kind":13,"localvar":"my","containerName":"end_element","name":"$func","line":347},{"name":"$type","containerName":"end_element","kind":13,"line":347},{"line":348,"name":"$rc","containerName":"end_element","kind":13},{"kind":13,"containerName":"end_element","name":"$self","line":348},{"line":348,"kind":12,"containerName":"end_element","name":"_eventHandler"},{"line":348,"containerName":"end_element","kind":13,"name":"$func"},{"name":"$self","containerName":"end_element","kind":13,"line":348},{"name":"$self","containerName":"end_element","kind":13,"line":349},{"containerName":"end_element","kind":13,"name":"$self","line":351}],"containerName":"main::","name":"end_element","signature":{"label":"end_element($self,$data)","parameters":[{"label":"$self"},{"label":"$data"}],"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   \n   local $/ = \"\\n\";\n   local $_;\n\n   my $fmt = $self->report_format;\n   my ($lastquery,$lasthit);\n   while( defined($_ = $self->_readline) ) {\n       if( $fmt == 0 ) {\n\t   if( /^\\'(\\S+)\\'\\=\\=\\'(\\+|\\-)(\\S+)\\'\\s+\n\t       \\((\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\)\\s+\n\t       (\\d+)/ox )\n\t   {\n\t       my ($hit,$strand,$query,\n\t\t   $h_start,$q_start,$h_end,$q_end,\n\t\t   $score) = ($1,$2,$3,$4,$5,$6,$7,$8);\n\t       if( ! defined $lastquery ) {\n\t\t   $self->start_element({'Name' => 'MegaBlastOutput'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_program',\n\t\t\t\t   'Data' => 'MEGABLAST'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_query-def',\n\t\t\t\t   'Data' => $query});\n\t       } elsif( $lastquery ne $query ) {\n\t\t   $self->_pushback($_);\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->end_element({ 'Name' => 'MegaBlastOutput'});\n\t\t   $lasthit = undef;\n\t\t   $lastquery = undef;\n\t\t   return $self->end_document();\n\t       }\n\n\t       if( ! defined $lasthit || $lasthit ne $hit  ) {\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->start_element({'Name' => 'Hit'});\n\t\t   $self->element({'Name' => 'Hit_id',\n\t\t\t\t   'Data' => $hit});\n\t       }\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t       'Data' => $score});\n\n\t       # flip flop start/end if strand is < 0\n\t       # since strandedness is inferred from the query\n\t       # because of the way it is coded all queries will\n\t       # be on the forward strand and hits will be either\n\t       # +/-\n\n\t       # also the NCBI docs state:\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\t\n\t       # and yet when rev strand hits are made I see\n\t       # (MBL 2.2.4)\n\t       # 'Contig634'=='-503384' (1 7941 321 7620) 19\n\t       # so the query is on the rev strand and the\n\t       # subject is on the fwd strand\n\t       # so I am flip-flopping everything when I see a '-'\n\t       if( $strand eq '-' ) {\n\t\t   ($h_start,$h_end) = ( $h_end,$h_start);\n\t\t   ($q_start,$q_end) = ( $q_end,$q_start);\n\t       }\n\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t       'Data' => $h_start});\n\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t       'Data' => $h_end});\n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $q_start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $q_end});\n\t       # might not be quite right -- need to know length of the HSP\n\t       my $numid = (abs($q_end - $q_start) - $score);\n\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => $numid});\n\t       $self->element({'Name' => 'Hsp_positive',\n\t\t\t       'Data' => $numid});\n\n\t       $self->end_element({'Name' => 'Hsp'});\n\t       $lasthit   = $hit;\n\t       $lastquery = $query;\n\t   } else {\n\t       $self->debug(\"Unknown line in fmt0 parsing: $_\");\n\t   }\n       }\n   }\n   if( defined $lastquery && $fmt == 0 ) {\n       $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n       $self->end_element({ 'Name' => 'MegaBlastOutput'});\n       return $self->end_document();\n   }\n   return 0;\n}\n\n=head2 report_format\n\n Title   : report_format\n Usage   : $obj->report_format($newval)\n Function: Get/Set the report_format value\n Returns : value of report_format (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub report_format{\n    my $self = shift;\n    return $self->{'_report_format'} = shift if @_;\n    return $self->{'_report_format'};\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently do not care about attributes\n    my $nm = $data->{'Name'};\n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\n\tunshift @{$self->{'_elements'}}, $type;\n    }\n\n    if($nm eq 'MegaBlastOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'"},"line":340,"range":{"start":{"line":340,"character":0},"end":{"character":9999,"line":353}},"kind":12},{"kind":13,"containerName":null,"name":"%MAPPING","line":353},{"line":353,"containerName":null,"kind":13,"name":"%nm"},{"name":"%MAPPING","containerName":null,"kind":13,"line":354},{"line":354,"name":"%nm","kind":13,"containerName":null},{"localvar":"my","containerName":null,"kind":13,"name":"$key","line":355,"definition":"my"},{"kind":13,"containerName":null,"name":"%MAPPING","line":355},{"kind":13,"containerName":null,"name":"@nm","line":355},{"line":356,"containerName":null,"kind":13,"name":"%self"},{"line":356,"name":"%key","containerName":null,"kind":13},{"line":356,"kind":13,"containerName":null,"name":"%MAPPING"},{"containerName":null,"kind":13,"name":"%nm","line":356},{"line":356,"name":"$key","kind":13,"containerName":null},{"line":356,"name":"%self","kind":13,"containerName":null},{"name":"%self","containerName":null,"kind":13,"line":358},{"line":358,"name":"%MAPPING","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$nm","line":358},{"line":358,"containerName":null,"kind":13,"name":"%self"},{"name":"$self","kind":13,"containerName":null,"line":361},{"line":361,"name":"warn","containerName":"main::","kind":12},{"containerName":null,"kind":13,"name":"%self","line":363},{"kind":13,"containerName":null,"name":"%self","line":365},{"line":365,"name":"$rc","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$nm","line":365},{"kind":13,"containerName":null,"name":"$rc","line":366},{"kind":12,"range":{"start":{"character":0,"line":381},"end":{"character":9999,"line":386}},"line":381,"signature":{"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   \n   local $/ = \"\\n\";\n   local $_;\n\n   my $fmt = $self->report_format;\n   my ($lastquery,$lasthit);\n   while( defined($_ = $self->_readline) ) {\n       if( $fmt == 0 ) {\n\t   if( /^\\'(\\S+)\\'\\=\\=\\'(\\+|\\-)(\\S+)\\'\\s+\n\t       \\((\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\)\\s+\n\t       (\\d+)/ox )\n\t   {\n\t       my ($hit,$strand,$query,\n\t\t   $h_start,$q_start,$h_end,$q_end,\n\t\t   $score) = ($1,$2,$3,$4,$5,$6,$7,$8);\n\t       if( ! defined $lastquery ) {\n\t\t   $self->start_element({'Name' => 'MegaBlastOutput'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_program',\n\t\t\t\t   'Data' => 'MEGABLAST'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_query-def',\n\t\t\t\t   'Data' => $query});\n\t       } elsif( $lastquery ne $query ) {\n\t\t   $self->_pushback($_);\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->end_element({ 'Name' => 'MegaBlastOutput'});\n\t\t   $lasthit = undef;\n\t\t   $lastquery = undef;\n\t\t   return $self->end_document();\n\t       }\n\n\t       if( ! defined $lasthit || $lasthit ne $hit  ) {\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->start_element({'Name' => 'Hit'});\n\t\t   $self->element({'Name' => 'Hit_id',\n\t\t\t\t   'Data' => $hit});\n\t       }\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t       'Data' => $score});\n\n\t       # flip flop start/end if strand is < 0\n\t       # since strandedness is inferred from the query\n\t       # because of the way it is coded all queries will\n\t       # be on the forward strand and hits will be either\n\t       # +/-\n\n\t       # also the NCBI docs state:\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\t\n\t       # and yet when rev strand hits are made I see\n\t       # (MBL 2.2.4)\n\t       # 'Contig634'=='-503384' (1 7941 321 7620) 19\n\t       # so the query is on the rev strand and the\n\t       # subject is on the fwd strand\n\t       # so I am flip-flopping everything when I see a '-'\n\t       if( $strand eq '-' ) {\n\t\t   ($h_start,$h_end) = ( $h_end,$h_start);\n\t\t   ($q_start,$q_end) = ( $q_end,$q_start);\n\t       }\n\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t       'Data' => $h_start});\n\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t       'Data' => $h_end});\n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $q_start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $q_end});\n\t       # might not be quite right -- need to know length of the HSP\n\t       my $numid = (abs($q_end - $q_start) - $score);\n\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => $numid});\n\t       $self->element({'Name' => 'Hsp_positive',\n\t\t\t       'Data' => $numid});\n\n\t       $self->end_element({'Name' => 'Hsp'});\n\t       $lasthit   = $hit;\n\t       $lastquery = $query;\n\t   } else {\n\t       $self->debug(\"Unknown line in fmt0 parsing: $_\");\n\t   }\n       }\n   }\n   if( defined $lastquery && $fmt == 0 ) {\n       $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n       $self->end_element({ 'Name' => 'MegaBlastOutput'});\n       return $self->end_document();\n   }\n   return 0;\n}\n\n=head2 report_format\n\n Title   : report_format\n Usage   : $obj->report_format($newval)\n Function: Get/Set the report_format value\n Returns : value of report_format (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub report_format{\n    my $self = shift;\n    return $self->{'_report_format'} = shift if @_;\n    return $self->{'_report_format'};\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently do not care about attributes\n    my $nm = $data->{'Name'};\n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\n\tunshift @{$self->{'_elements'}}, $type;\n    }\n\n    if($nm eq 'MegaBlastOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'MegaBlastOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'","parameters":[{"label":"$self"},{"label":"$data"}],"label":"element($self,$data)"},"containerName":"main::","name":"element","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"element","kind":13,"line":382},{"name":"$data","kind":13,"containerName":"element","line":382},{"name":"$self","containerName":"element","kind":13,"line":383},{"line":383,"name":"start_element","kind":12,"containerName":"element"},{"name":"$data","kind":13,"containerName":"element","line":383},{"name":"$self","containerName":"element","kind":13,"line":384},{"line":384,"name":"characters","kind":12,"containerName":"element"},{"kind":13,"containerName":"element","name":"$data","line":384},{"containerName":"element","kind":13,"name":"$self","line":385},{"kind":12,"containerName":"element","name":"end_element","line":385},{"line":385,"name":"$data","kind":13,"containerName":"element"}],"detail":"($self,$data)","definition":"sub"},{"name":"characters","containerName":"main::","children":[{"definition":"my","line":401,"name":"$self","kind":13,"localvar":"my","containerName":"characters"},{"line":401,"name":"$data","kind":13,"containerName":"characters"},{"line":402,"name":"$data","containerName":"characters","kind":13},{"name":"$self","containerName":"characters","kind":13,"line":403},{"line":403,"name":"$data","kind":13,"containerName":"characters"}],"detail":"($self,$data)","definition":"sub","kind":12,"range":{"end":{"line":404,"character":9999},"start":{"line":400,"character":0}},"line":400,"signature":{"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   \n   local $/ = \"\\n\";\n   local $_;\n\n   my $fmt = $self->report_format;\n   my ($lastquery,$lasthit);\n   while( defined($_ = $self->_readline) ) {\n       if( $fmt == 0 ) {\n\t   if( /^\\'(\\S+)\\'\\=\\=\\'(\\+|\\-)(\\S+)\\'\\s+\n\t       \\((\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\)\\s+\n\t       (\\d+)/ox )\n\t   {\n\t       my ($hit,$strand,$query,\n\t\t   $h_start,$q_start,$h_end,$q_end,\n\t\t   $score) = ($1,$2,$3,$4,$5,$6,$7,$8);\n\t       if( ! defined $lastquery ) {\n\t\t   $self->start_element({'Name' => 'MegaBlastOutput'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_program',\n\t\t\t\t   'Data' => 'MEGABLAST'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_query-def',\n\t\t\t\t   'Data' => $query});\n\t       } elsif( $lastquery ne $query ) {\n\t\t   $self->_pushback($_);\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->end_element({ 'Name' => 'MegaBlastOutput'});\n\t\t   $lasthit = undef;\n\t\t   $lastquery = undef;\n\t\t   return $self->end_document();\n\t       }\n\n\t       if( ! defined $lasthit || $lasthit ne $hit  ) {\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->start_element({'Name' => 'Hit'});\n\t\t   $self->element({'Name' => 'Hit_id',\n\t\t\t\t   'Data' => $hit});\n\t       }\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t       'Data' => $score});\n\n\t       # flip flop start/end if strand is < 0\n\t       # since strandedness is inferred from the query\n\t       # because of the way it is coded all queries will\n\t       # be on the forward strand and hits will be either\n\t       # +/-\n\n\t       # also the NCBI docs state:\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\t\n\t       # and yet when rev strand hits are made I see\n\t       # (MBL 2.2.4)\n\t       # 'Contig634'=='-503384' (1 7941 321 7620) 19\n\t       # so the query is on the rev strand and the\n\t       # subject is on the fwd strand\n\t       # so I am flip-flopping everything when I see a '-'\n\t       if( $strand eq '-' ) {\n\t\t   ($h_start,$h_end) = ( $h_end,$h_start);\n\t\t   ($q_start,$q_end) = ( $q_end,$q_start);\n\t       }\n\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t       'Data' => $h_start});\n\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t       'Data' => $h_end});\n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $q_start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $q_end});\n\t       # might not be quite right -- need to know length of the HSP\n\t       my $numid = (abs($q_end - $q_start) - $score);\n\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => $numid});\n\t       $self->element({'Name' => 'Hsp_positive',\n\t\t\t       'Data' => $numid});\n\n\t       $self->end_element({'Name' => 'Hsp'});\n\t       $lasthit   = $hit;\n\t       $lastquery = $query;\n\t   } else {\n\t       $self->debug(\"Unknown line in fmt0 parsing: $_\");\n\t   }\n       }\n   }\n   if( defined $lastquery && $fmt == 0 ) {\n       $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n       $self->end_element({ 'Name' => 'MegaBlastOutput'});\n       return $self->end_document();\n   }\n   return 0;\n}\n\n=head2 report_format\n\n Title   : report_format\n Usage   : $obj->report_format($newval)\n Function: Get/Set the report_format value\n Returns : value of report_format (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub report_format{\n    my $self = shift;\n    return $self->{'_report_format'} = shift if @_;\n    return $self->{'_report_format'};\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently do not care about attributes\n    my $nm = $data->{'Name'};\n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\n\tunshift @{$self->{'_elements'}}, $type;\n    }\n\n    if($nm eq 'MegaBlastOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'MegaBlastOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string","parameters":[{"label":"$self"},{"label":"$data"}],"label":"characters($self,$data)"}},{"children":[{"line":419,"containerName":"_mode","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$value","kind":13,"containerName":"_mode","line":419},{"name":"$value","containerName":"_mode","kind":13,"line":420},{"line":421,"name":"$self","kind":13,"containerName":"_mode"},{"name":"$value","kind":13,"containerName":"_mode","line":421},{"line":423,"containerName":"_mode","kind":13,"name":"$self"}],"name":"_mode","containerName":"main::","definition":"sub","detail":"($self,$value)","line":418,"range":{"start":{"line":418,"character":0},"end":{"line":424,"character":9999}},"kind":12,"signature":{"label":"_mode($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   \n   local $/ = \"\\n\";\n   local $_;\n\n   my $fmt = $self->report_format;\n   my ($lastquery,$lasthit);\n   while( defined($_ = $self->_readline) ) {\n       if( $fmt == 0 ) {\n\t   if( /^\\'(\\S+)\\'\\=\\=\\'(\\+|\\-)(\\S+)\\'\\s+\n\t       \\((\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\)\\s+\n\t       (\\d+)/ox )\n\t   {\n\t       my ($hit,$strand,$query,\n\t\t   $h_start,$q_start,$h_end,$q_end,\n\t\t   $score) = ($1,$2,$3,$4,$5,$6,$7,$8);\n\t       if( ! defined $lastquery ) {\n\t\t   $self->start_element({'Name' => 'MegaBlastOutput'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_program',\n\t\t\t\t   'Data' => 'MEGABLAST'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_query-def',\n\t\t\t\t   'Data' => $query});\n\t       } elsif( $lastquery ne $query ) {\n\t\t   $self->_pushback($_);\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->end_element({ 'Name' => 'MegaBlastOutput'});\n\t\t   $lasthit = undef;\n\t\t   $lastquery = undef;\n\t\t   return $self->end_document();\n\t       }\n\n\t       if( ! defined $lasthit || $lasthit ne $hit  ) {\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->start_element({'Name' => 'Hit'});\n\t\t   $self->element({'Name' => 'Hit_id',\n\t\t\t\t   'Data' => $hit});\n\t       }\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t       'Data' => $score});\n\n\t       # flip flop start/end if strand is < 0\n\t       # since strandedness is inferred from the query\n\t       # because of the way it is coded all queries will\n\t       # be on the forward strand and hits will be either\n\t       # +/-\n\n\t       # also the NCBI docs state:\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\t\n\t       # and yet when rev strand hits are made I see\n\t       # (MBL 2.2.4)\n\t       # 'Contig634'=='-503384' (1 7941 321 7620) 19\n\t       # so the query is on the rev strand and the\n\t       # subject is on the fwd strand\n\t       # so I am flip-flopping everything when I see a '-'\n\t       if( $strand eq '-' ) {\n\t\t   ($h_start,$h_end) = ( $h_end,$h_start);\n\t\t   ($q_start,$q_end) = ( $q_end,$q_start);\n\t       }\n\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t       'Data' => $h_start});\n\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t       'Data' => $h_end});\n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $q_start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $q_end});\n\t       # might not be quite right -- need to know length of the HSP\n\t       my $numid = (abs($q_end - $q_start) - $score);\n\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => $numid});\n\t       $self->element({'Name' => 'Hsp_positive',\n\t\t\t       'Data' => $numid});\n\n\t       $self->end_element({'Name' => 'Hsp'});\n\t       $lasthit   = $hit;\n\t       $lastquery = $query;\n\t   } else {\n\t       $self->debug(\"Unknown line in fmt0 parsing: $_\");\n\t   }\n       }\n   }\n   if( defined $lastquery && $fmt == 0 ) {\n       $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n       $self->end_element({ 'Name' => 'MegaBlastOutput'});\n       return $self->end_document();\n   }\n   return 0;\n}\n\n=head2 report_format\n\n Title   : report_format\n Usage   : $obj->report_format($newval)\n Function: Get/Set the report_format value\n Returns : value of report_format (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub report_format{\n    my $self = shift;\n    return $self->{'_report_format'} = shift if @_;\n    return $self->{'_report_format'};\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently do not care about attributes\n    my $nm = $data->{'Name'};\n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\n\tunshift @{$self->{'_elements'}}, $type;\n    }\n\n    if($nm eq 'MegaBlastOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'MegaBlastOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless defined $data->{'Data'};\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function:\n Example :\n Returns : value of _mode\n Args    : newvalue (optional)"}},{"detail":"($self,$name)","definition":"sub","containerName":"main::","name":"within_element","children":[{"localvar":"my","kind":13,"containerName":"within_element","name":"$self","line":440,"definition":"my"},{"kind":13,"containerName":"within_element","name":"$name","line":440},{"containerName":"within_element","kind":13,"name":"$name","line":441},{"line":442,"kind":13,"containerName":"within_element","name":"$self"},{"name":"$self","kind":13,"containerName":"within_element","line":443}],"signature":{"label":"within_element($self,$name)","parameters":[{"label":"$self"},{"label":"$name"}],"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   \n   local $/ = \"\\n\";\n   local $_;\n\n   my $fmt = $self->report_format;\n   my ($lastquery,$lasthit);\n   while( defined($_ = $self->_readline) ) {\n       if( $fmt == 0 ) {\n\t   if( /^\\'(\\S+)\\'\\=\\=\\'(\\+|\\-)(\\S+)\\'\\s+\n\t       \\((\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\)\\s+\n\t       (\\d+)/ox )\n\t   {\n\t       my ($hit,$strand,$query,\n\t\t   $h_start,$q_start,$h_end,$q_end,\n\t\t   $score) = ($1,$2,$3,$4,$5,$6,$7,$8);\n\t       if( ! defined $lastquery ) {\n\t\t   $self->start_element({'Name' => 'MegaBlastOutput'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_program',\n\t\t\t\t   'Data' => 'MEGABLAST'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_query-def',\n\t\t\t\t   'Data' => $query});\n\t       } elsif( $lastquery ne $query ) {\n\t\t   $self->_pushback($_);\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->end_element({ 'Name' => 'MegaBlastOutput'});\n\t\t   $lasthit = undef;\n\t\t   $lastquery = undef;\n\t\t   return $self->end_document();\n\t       }\n\n\t       if( ! defined $lasthit || $lasthit ne $hit  ) {\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->start_element({'Name' => 'Hit'});\n\t\t   $self->element({'Name' => 'Hit_id',\n\t\t\t\t   'Data' => $hit});\n\t       }\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t       'Data' => $score});\n\n\t       # flip flop start/end if strand is < 0\n\t       # since strandedness is inferred from the query\n\t       # because of the way it is coded all queries will\n\t       # be on the forward strand and hits will be either\n\t       # +/-\n\n\t       # also the NCBI docs state:\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\t\n\t       # and yet when rev strand hits are made I see\n\t       # (MBL 2.2.4)\n\t       # 'Contig634'=='-503384' (1 7941 321 7620) 19\n\t       # so the query is on the rev strand and the\n\t       # subject is on the fwd strand\n\t       # so I am flip-flopping everything when I see a '-'\n\t       if( $strand eq '-' ) {\n\t\t   ($h_start,$h_end) = ( $h_end,$h_start);\n\t\t   ($q_start,$q_end) = ( $q_end,$q_start);\n\t       }\n\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t       'Data' => $h_start});\n\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t       'Data' => $h_end});\n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $q_start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $q_end});\n\t       # might not be quite right -- need to know length of the HSP\n\t       my $numid = (abs($q_end - $q_start) - $score);\n\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => $numid});\n\t       $self->element({'Name' => 'Hsp_positive',\n\t\t\t       'Data' => $numid});\n\n\t       $self->end_element({'Name' => 'Hsp'});\n\t       $lasthit   = $hit;\n\t       $lastquery = $query;\n\t   } else {\n\t       $self->debug(\"Unknown line in fmt0 parsing: $_\");\n\t   }\n       }\n   }\n   if( defined $lastquery && $fmt == 0 ) {\n       $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n       $self->end_element({ 'Name' => 'MegaBlastOutput'});\n       return $self->end_document();\n   }\n   return 0;\n}\n\n=head2 report_format\n\n Title   : report_format\n Usage   : $obj->report_format($newval)\n Function: Get/Set the report_format value\n Returns : value of report_format (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub report_format{\n    my $self = shift;\n    return $self->{'_report_format'} = shift if @_;\n    return $self->{'_report_format'};\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently do not care about attributes\n    my $nm = $data->{'Name'};\n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\n\tunshift @{$self->{'_elements'}}, $type;\n    }\n\n    if($nm eq 'MegaBlastOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'MegaBlastOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless defined $data->{'Data'};\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function:\n Example :\n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name"},"kind":12,"range":{"start":{"line":439,"character":0},"end":{"line":443,"character":9999}},"line":439},{"line":444,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"%name","line":445},{"signature":{"label":"in_element($self,$name)","documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   \n   local $/ = \"\\n\";\n   local $_;\n\n   my $fmt = $self->report_format;\n   my ($lastquery,$lasthit);\n   while( defined($_ = $self->_readline) ) {\n       if( $fmt == 0 ) {\n\t   if( /^\\'(\\S+)\\'\\=\\=\\'(\\+|\\-)(\\S+)\\'\\s+\n\t       \\((\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\)\\s+\n\t       (\\d+)/ox )\n\t   {\n\t       my ($hit,$strand,$query,\n\t\t   $h_start,$q_start,$h_end,$q_end,\n\t\t   $score) = ($1,$2,$3,$4,$5,$6,$7,$8);\n\t       if( ! defined $lastquery ) {\n\t\t   $self->start_element({'Name' => 'MegaBlastOutput'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_program',\n\t\t\t\t   'Data' => 'MEGABLAST'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_query-def',\n\t\t\t\t   'Data' => $query});\n\t       } elsif( $lastquery ne $query ) {\n\t\t   $self->_pushback($_);\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->end_element({ 'Name' => 'MegaBlastOutput'});\n\t\t   $lasthit = undef;\n\t\t   $lastquery = undef;\n\t\t   return $self->end_document();\n\t       }\n\n\t       if( ! defined $lasthit || $lasthit ne $hit  ) {\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->start_element({'Name' => 'Hit'});\n\t\t   $self->element({'Name' => 'Hit_id',\n\t\t\t\t   'Data' => $hit});\n\t       }\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t       'Data' => $score});\n\n\t       # flip flop start/end if strand is < 0\n\t       # since strandedness is inferred from the query\n\t       # because of the way it is coded all queries will\n\t       # be on the forward strand and hits will be either\n\t       # +/-\n\n\t       # also the NCBI docs state:\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\t\n\t       # and yet when rev strand hits are made I see\n\t       # (MBL 2.2.4)\n\t       # 'Contig634'=='-503384' (1 7941 321 7620) 19\n\t       # so the query is on the rev strand and the\n\t       # subject is on the fwd strand\n\t       # so I am flip-flopping everything when I see a '-'\n\t       if( $strand eq '-' ) {\n\t\t   ($h_start,$h_end) = ( $h_end,$h_start);\n\t\t   ($q_start,$q_end) = ( $q_end,$q_start);\n\t       }\n\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t       'Data' => $h_start});\n\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t       'Data' => $h_end});\n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $q_start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $q_end});\n\t       # might not be quite right -- need to know length of the HSP\n\t       my $numid = (abs($q_end - $q_start) - $score);\n\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => $numid});\n\t       $self->element({'Name' => 'Hsp_positive',\n\t\t\t       'Data' => $numid});\n\n\t       $self->end_element({'Name' => 'Hsp'});\n\t       $lasthit   = $hit;\n\t       $lastquery = $query;\n\t   } else {\n\t       $self->debug(\"Unknown line in fmt0 parsing: $_\");\n\t   }\n       }\n   }\n   if( defined $lastquery && $fmt == 0 ) {\n       $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n       $self->end_element({ 'Name' => 'MegaBlastOutput'});\n       return $self->end_document();\n   }\n   return 0;\n}\n\n=head2 report_format\n\n Title   : report_format\n Usage   : $obj->report_format($newval)\n Function: Get/Set the report_format value\n Returns : value of report_format (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub report_format{\n    my $self = shift;\n    return $self->{'_report_format'} = shift if @_;\n    return $self->{'_report_format'};\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently do not care about attributes\n    my $nm = $data->{'Name'};\n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\n\tunshift @{$self->{'_elements'}}, $type;\n    }\n\n    if($nm eq 'MegaBlastOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'MegaBlastOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless defined $data->{'Data'};\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function:\n Example :\n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name","parameters":[{"label":"$self"},{"label":"$name"}]},"line":465,"kind":12,"range":{"end":{"character":9999,"line":469},"start":{"character":0,"line":465}},"definition":"sub","detail":"($self,$name)","children":[{"line":466,"name":"$self","localvar":"my","kind":13,"containerName":"in_element","definition":"my"},{"line":466,"name":"$name","kind":13,"containerName":"in_element"},{"line":467,"kind":13,"containerName":"in_element","name":"$self"},{"name":"$self","containerName":"in_element","kind":13,"line":468},{"line":468,"kind":13,"containerName":"in_element","name":"$name"}],"containerName":"main::","name":"in_element"},{"signature":{"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   \n   local $/ = \"\\n\";\n   local $_;\n\n   my $fmt = $self->report_format;\n   my ($lastquery,$lasthit);\n   while( defined($_ = $self->_readline) ) {\n       if( $fmt == 0 ) {\n\t   if( /^\\'(\\S+)\\'\\=\\=\\'(\\+|\\-)(\\S+)\\'\\s+\n\t       \\((\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\)\\s+\n\t       (\\d+)/ox )\n\t   {\n\t       my ($hit,$strand,$query,\n\t\t   $h_start,$q_start,$h_end,$q_end,\n\t\t   $score) = ($1,$2,$3,$4,$5,$6,$7,$8);\n\t       if( ! defined $lastquery ) {\n\t\t   $self->start_element({'Name' => 'MegaBlastOutput'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_program',\n\t\t\t\t   'Data' => 'MEGABLAST'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_query-def',\n\t\t\t\t   'Data' => $query});\n\t       } elsif( $lastquery ne $query ) {\n\t\t   $self->_pushback($_);\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->end_element({ 'Name' => 'MegaBlastOutput'});\n\t\t   $lasthit = undef;\n\t\t   $lastquery = undef;\n\t\t   return $self->end_document();\n\t       }\n\n\t       if( ! defined $lasthit || $lasthit ne $hit  ) {\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->start_element({'Name' => 'Hit'});\n\t\t   $self->element({'Name' => 'Hit_id',\n\t\t\t\t   'Data' => $hit});\n\t       }\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t       'Data' => $score});\n\n\t       # flip flop start/end if strand is < 0\n\t       # since strandedness is inferred from the query\n\t       # because of the way it is coded all queries will\n\t       # be on the forward strand and hits will be either\n\t       # +/-\n\n\t       # also the NCBI docs state:\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\t\n\t       # and yet when rev strand hits are made I see\n\t       # (MBL 2.2.4)\n\t       # 'Contig634'=='-503384' (1 7941 321 7620) 19\n\t       # so the query is on the rev strand and the\n\t       # subject is on the fwd strand\n\t       # so I am flip-flopping everything when I see a '-'\n\t       if( $strand eq '-' ) {\n\t\t   ($h_start,$h_end) = ( $h_end,$h_start);\n\t\t   ($q_start,$q_end) = ( $q_end,$q_start);\n\t       }\n\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t       'Data' => $h_start});\n\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t       'Data' => $h_end});\n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $q_start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $q_end});\n\t       # might not be quite right -- need to know length of the HSP\n\t       my $numid = (abs($q_end - $q_start) - $score);\n\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => $numid});\n\t       $self->element({'Name' => 'Hsp_positive',\n\t\t\t       'Data' => $numid});\n\n\t       $self->end_element({'Name' => 'Hsp'});\n\t       $lasthit   = $hit;\n\t       $lastquery = $query;\n\t   } else {\n\t       $self->debug(\"Unknown line in fmt0 parsing: $_\");\n\t   }\n       }\n   }\n   if( defined $lastquery && $fmt == 0 ) {\n       $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n       $self->end_element({ 'Name' => 'MegaBlastOutput'});\n       return $self->end_document();\n   }\n   return 0;\n}\n\n=head2 report_format\n\n Title   : report_format\n Usage   : $obj->report_format($newval)\n Function: Get/Set the report_format value\n Returns : value of report_format (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub report_format{\n    my $self = shift;\n    return $self->{'_report_format'} = shift if @_;\n    return $self->{'_report_format'};\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently do not care about attributes\n    my $nm = $data->{'Name'};\n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\n\tunshift @{$self->{'_elements'}}, $type;\n    }\n\n    if($nm eq 'MegaBlastOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'MegaBlastOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless defined $data->{'Data'};\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function:\n Example :\n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none","parameters":[{"label":"$self"}],"label":"start_document($self)"},"kind":12,"range":{"end":{"line":490,"character":9999},"start":{"character":0,"line":483}},"line":483,"detail":"($self)","definition":"sub","containerName":"main::","name":"start_document","children":[{"line":484,"kind":13,"localvar":"my","containerName":"start_document","name":"$self","definition":"my"},{"name":"$self","containerName":"start_document","kind":13,"line":485},{"line":486,"name":"$self","kind":13,"containerName":"start_document"},{"line":487,"name":"$self","kind":13,"containerName":"start_document"},{"line":488,"kind":13,"containerName":"start_document","name":"$self"},{"line":489,"containerName":"start_document","kind":13,"name":"$self"}]},{"line":504,"kind":12,"range":{"start":{"line":504,"character":0},"end":{"line":507,"character":9999}},"signature":{"documentation":"1;\n# $Id: megablast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SearchIO::megablast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SearchIO::megablast - a driver module for Bio::SearchIO to parse\nmegablast reports (format 0)\n\n=head1 SYNOPSIS\n\n# do not use this module directly\n\n  use Bio::SearchIO;\n  # for default format output from megablast\n  my $in = Bio::SearchIO->new(-file   => 'file.mbl',\n                             -format => 'megablast',\n                             -report_format => 0);\n\n  while( my $r = $in->next_result ) {\n    while( my $hit = $r->next_hit ) {\n      while( my $hsp = $hit->next_hsp ) {\n      }\n    }\n  }\n\n=head1 DESCRIPTION\n\nBeware!\n\nBecause of the way megablast report format 0 is coded, realize that score\nmeans # gap characters + # mismatches for a HSP.\n\nThe docs from NCBI regarding FORMAT 0\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\nFORMAT 1 parsing has not been implemented\nFORMAT 2 parsing should work with the SearchIO 'blast' parser\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SearchIO::megablast;\nuse strict;\nuse vars qw(%MAPPING %MODEMAP $DEFAULT_BLAST_WRITER_CLASS);\n\nuse base qw(Bio::SearchIO);\n\nBEGIN {\n    # mapping of MegaBlast terms to Bioperl hash keys\n    %MODEMAP = ('MegaBlastOutput' => 'result',\n\t\t'Hit'         => 'hit',\n\t\t'Hsp'         => 'hsp'\n\t\t);\n\n    # This should really be done more intelligently, like with\n    # XSLT\n\n    %MAPPING =\n\t(\n\t  'Hsp_query-from' => 'HSP-query_start',\n\t  'Hsp_query-to'   => 'HSP-query_end',\n\t  'Hsp_hit-from'   => 'HSP-hit_start',\n\t  'Hsp_hit-to'     => 'HSP-hit_end',\n\t  'Hit_score'      => 'HIT-score',\n\t  'Hsp_score'      => 'HSP-score',\n\t\n\t  'Hsp_identity'   => 'HSP-identical',\n\t  'Hsp_positive'   => 'HSP-conserved',\n\n\t  'Hit_id'         => 'HIT-name',\n\t\n\t  'MegaBlastOutput_program'  => 'RESULT-algorithm_name',\n\t  'MegaBlastOutput_query-def'=> 'RESULT-query_name',\n\t  );\n\n\n    $DEFAULT_BLAST_WRITER_CLASS = 'Bio::Search::Writer::HitTableWriter';\n}\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SearchIO::blast->new();\n Function: Builds a new Bio::SearchIO::blast object\n Returns : Bio::SearchIO::blast\n Args    : -fh/-file => filehandle/filename to BLAST file\n           -format   => 'blast'\n\n\nsub _initialize {\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args);\n    my ($fmt) = $self->_rearrange([qw(REPORT_FORMAT)], @args);\n\n    $self->throw(\"Must provide a value for -report_format when initializing a megablast parser\") unless defined $fmt ;\n    $self->report_format($fmt);\n    return 1;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $hit = $searchio->next_result;\n Function: Returns the next Result from a search\n Returns : Bio::Search::Result::ResultI object\n Args    : none\n\n\nsub next_result{\n   my ($self) = @_;\n   \n   local $/ = \"\\n\";\n   local $_;\n\n   my $fmt = $self->report_format;\n   my ($lastquery,$lasthit);\n   while( defined($_ = $self->_readline) ) {\n       if( $fmt == 0 ) {\n\t   if( /^\\'(\\S+)\\'\\=\\=\\'(\\+|\\-)(\\S+)\\'\\s+\n\t       \\((\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\)\\s+\n\t       (\\d+)/ox )\n\t   {\n\t       my ($hit,$strand,$query,\n\t\t   $h_start,$q_start,$h_end,$q_end,\n\t\t   $score) = ($1,$2,$3,$4,$5,$6,$7,$8);\n\t       if( ! defined $lastquery ) {\n\t\t   $self->start_element({'Name' => 'MegaBlastOutput'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_program',\n\t\t\t\t   'Data' => 'MEGABLAST'});\n\t\t   $self->element({'Name' => 'MegaBlastOutput_query-def',\n\t\t\t\t   'Data' => $query});\n\t       } elsif( $lastquery ne $query ) {\n\t\t   $self->_pushback($_);\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->end_element({ 'Name' => 'MegaBlastOutput'});\n\t\t   $lasthit = undef;\n\t\t   $lastquery = undef;\n\t\t   return $self->end_document();\n\t       }\n\n\t       if( ! defined $lasthit || $lasthit ne $hit  ) {\n\t\t   $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n\t\t   $self->start_element({'Name' => 'Hit'});\n\t\t   $self->element({'Name' => 'Hit_id',\n\t\t\t\t   'Data' => $hit});\n\t       }\n\t       $self->start_element({'Name' => 'Hsp'});\n\t       $self->element({'Name' => 'Hsp_score',\n\t\t\t       'Data' => $score});\n\n\t       # flip flop start/end if strand is < 0\n\t       # since strandedness is inferred from the query\n\t       # because of the way it is coded all queries will\n\t       # be on the forward strand and hits will be either\n\t       # +/-\n\n\t       # also the NCBI docs state:\n#   0: Produce one-line output for each alignment, in the form\n#\n#   'subject-id'=='[+-]query-id' (s_off q_off s_end q_end) score\n#\n#   Here subject(query)-id is a gi number, an accession or some other type of\n#   identifier found in the FASTA definition line of the respective sequence.\n#\n#   + or - corresponds to same or different strand alignment.\n#\n#   Score for non-affine gapping parameters means the total number of\n#   differences (mismatches + gap characters). For affine case it is the\n#   actual (raw) score of the alignment.\n\t\n\t       # and yet when rev strand hits are made I see\n\t       # (MBL 2.2.4)\n\t       # 'Contig634'=='-503384' (1 7941 321 7620) 19\n\t       # so the query is on the rev strand and the\n\t       # subject is on the fwd strand\n\t       # so I am flip-flopping everything when I see a '-'\n\t       if( $strand eq '-' ) {\n\t\t   ($h_start,$h_end) = ( $h_end,$h_start);\n\t\t   ($q_start,$q_end) = ( $q_end,$q_start);\n\t       }\n\t       $self->element({'Name' => 'Hsp_hit-from',\n\t\t\t       'Data' => $h_start});\n\t       $self->element({'Name' => 'Hsp_hit-to',\n\t\t\t       'Data' => $h_end});\n\t       $self->element({'Name' => 'Hsp_query-from',\n\t\t\t       'Data' => $q_start});\n\t       $self->element({'Name' => 'Hsp_query-to',\n\t\t\t       'Data' => $q_end});\n\t       # might not be quite right -- need to know length of the HSP\n\t       my $numid = (abs($q_end - $q_start) - $score);\n\n\t       $self->element({'Name' => 'Hsp_identity',\n\t\t\t       'Data' => $numid});\n\t       $self->element({'Name' => 'Hsp_positive',\n\t\t\t       'Data' => $numid});\n\n\t       $self->end_element({'Name' => 'Hsp'});\n\t       $lasthit   = $hit;\n\t       $lastquery = $query;\n\t   } else {\n\t       $self->debug(\"Unknown line in fmt0 parsing: $_\");\n\t   }\n       }\n   }\n   if( defined $lastquery && $fmt == 0 ) {\n       $self->end_element({'Name' => 'Hit'}) if( defined $lasthit);\n       $self->end_element({ 'Name' => 'MegaBlastOutput'});\n       return $self->end_document();\n   }\n   return 0;\n}\n\n=head2 report_format\n\n Title   : report_format\n Usage   : $obj->report_format($newval)\n Function: Get/Set the report_format value\n Returns : value of report_format (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub report_format{\n    my $self = shift;\n    return $self->{'_report_format'} = shift if @_;\n    return $self->{'_report_format'};\n}\n\n\n=head2 start_element\n\n Title   : start_element\n Usage   : $eventgenerator->start_element\n Function: Handles a start element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub start_element{\n   my ($self,$data) = @_;\n    # we currently do not care about attributes\n    my $nm = $data->{'Name'};\n   if( my $type = $MODEMAP{$nm} ) {\n\t$self->_mode($type);\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"start_%s\",lc $type);\n\t    $self->_eventHandler->$func($data->{'Attributes'});\n\t}\n\tunshift @{$self->{'_elements'}}, $type;\n    }\n\n    if($nm eq 'MegaBlastOutput') {\n\t$self->{'_values'} = {};\n\t$self->{'_result'}= undef;\n\t$self->{'_mode'} = '';\n    }\n\n}\n\n=head2 end_element\n\n Title   : start_element\n Usage   : $eventgenerator->end_element\n Function: Handles an end element event\n Returns : none\n Args    : hashref with at least 2 keys 'Data' and 'Name'\n\n\n\nsub end_element {\n    my ($self,$data) = @_;\n    my $nm = $data->{'Name'};\n    my $rc;\n\n    if( my $type = $MODEMAP{$nm} ) {\n\tif( $self->_eventHandler->will_handle($type) ) {\n\t    my $func = sprintf(\"end_%s\",lc $type);\n\t    $rc = $self->_eventHandler->$func($self->{'_reporttype'},\n\t\t\t\t\t      $self->{'_values'});\n\t}\n\tshift @{$self->{'_elements'}};\n\n    } elsif( $MAPPING{$nm} ) {\n\tif ( ref($MAPPING{$nm}) =~ /hash/i ) {\n\t    my $key = (keys %{$MAPPING{$nm}})[0];\n\t    $self->{'_values'}->{$key}->{$MAPPING{$nm}->{$key}} = $self->{'_last_data'};\n\t} else {\n\t    $self->{'_values'}->{$MAPPING{$nm}} = $self->{'_last_data'};\n\t}\n    } else {\n\t$self->warn( \"unknown nm $nm ignoring\\n\");\n    }\n    $self->{'_last_data'} = ''; # remove read data if we are at\n\t\t\t\t# end of an element\n    $self->{'_result'} = $rc if( $nm eq 'MegaBlastOutput' );\n    return $rc;\n\n}\n\n=head2 element\n\n Title   : element\n Usage   : $eventhandler->element({'Name' => $name, 'Data' => $str});\n Function: Convience method that calls start_element, characters, end_element\n Returns : none\n Args    : Hash ref with the keys 'Name' and 'Data'\n\n\n\nsub element{\n   my ($self,$data) = @_;\n   $self->start_element($data);\n   $self->characters($data);\n   $self->end_element($data);\n}\n\n\n=head2 characters\n\n Title   : characters\n Usage   : $eventgenerator->characters($str)\n Function: Send a character events\n Returns : none\n Args    : string\n\n\n\nsub characters{\n   my ($self,$data) = @_;\n   return unless defined $data->{'Data'};\n   $self->{'_last_data'} = $data->{'Data'};\n}\n\n=head2 _mode\n\n Title   : _mode\n Usage   : $obj->_mode($newval)\n Function:\n Example :\n Returns : value of _mode\n Args    : newvalue (optional)\n\n\n\nsub _mode{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'_mode'} = $value;\n    }\n    return $self->{'_mode'};\n}\n\n=head2 within_element\n\n Title   : within_element\n Usage   : if( $eventgenerator->within_element($element) ) {}\n Function: Test if we are within a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub within_element{\n   my ($self,$name) = @_;\n   return 0 if ( ! defined $name &&\n\t\t ! defined  $self->{'_elements'} ||\n\t\t scalar @{$self->{'_elements'}} == 0) ;\n   foreach (  @{$self->{'_elements'}} ) {\n       if( $_ eq $name  ) {\n\t   return 1;\n       }\n   }\n   return 0;\n}\n\n=head2 in_element\n\n Title   : in_element\n Usage   : if( $eventgenerator->in_element($element) ) {}\n Function: Test if we are in a particular element\n           This is different than 'in' because within can be tested\n           for a whole block.\n Returns : boolean\n Args    : string element name\n\n\n\nsub in_element{\n   my ($self,$name) = @_;\n   return 0 if ! defined $self->{'_elements'}->[0];\n   return ( $self->{'_elements'}->[0] eq $name)\n}\n\n\n=head2 start_document\n\n Title   : start_document\n Usage   : $eventgenerator->start_document\n Function: Handles a start document event\n Returns : none\n Args    : none\n\n\n\nsub start_document{\n    my ($self) = @_;\n    $self->{'_lasttype'} = '';\n    $self->{'_values'} = {};\n    $self->{'_result'}= undef;\n    $self->{'_mode'} = '';\n    $self->{'_elements'} = [];\n}\n\n\n=head2 end_document\n\n Title   : end_document\n Usage   : $eventgenerator->end_document\n Function: Handles an end document event\n Returns : Bio::Search::Result::ResultI object\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"end_document($self,@args)"},"children":[{"definition":"my","line":505,"kind":13,"localvar":"my","containerName":"end_document","name":"$self"},{"name":"@args","kind":13,"containerName":"end_document","line":505},{"line":506,"kind":13,"containerName":"end_document","name":"$self"}],"name":"end_document","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"line":520,"kind":12,"range":{"end":{"character":9999,"line":523},"start":{"character":0,"line":520}},"definition":"sub","children":[{"line":521,"name":"$self","localvar":"my","kind":13,"containerName":"result_count","definition":"my"},{"line":522,"kind":13,"containerName":"result_count","name":"$self"}],"containerName":"main::","name":"result_count"},{"line":525,"range":{"start":{"line":525,"character":0},"end":{"line":525,"character":9999}},"kind":12,"children":[{"containerName":"report_count","kind":12,"name":"result_count","line":525}],"containerName":"main::","name":"report_count","definition":"sub"}]}