{"version":5,"vars":[{"line":151,"containerName":"","kind":2,"name":"base"},{"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects","parameters":[{"label":"$class"},{"label":"@args"}]},"range":{"end":{"line":187,"character":9999},"start":{"line":172,"character":0}},"kind":12,"line":172,"detail":"($class,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"definition":"my","line":173,"name":"$class","kind":13,"localvar":"my","containerName":"new"},{"name":"@args","containerName":"new","kind":13,"line":173},{"name":"$self","containerName":"new","localvar":"my","kind":13,"line":175,"definition":"my"},{"name":"$class","kind":13,"containerName":"new","line":175},{"line":175,"kind":13,"containerName":"new","name":"@args"},{"line":177,"kind":13,"localvar":"my","containerName":"new","name":"$feat","definition":"my"},{"name":"$anncoll","containerName":"new","kind":13,"line":177},{"line":177,"containerName":"new","kind":13,"name":"$fact"},{"name":"$self","containerName":"new","kind":13,"line":178},{"name":"_rearrange","containerName":"new","kind":12,"line":178},{"line":180,"containerName":"new","kind":13,"name":"@args"},{"kind":13,"containerName":"new","name":"$self","line":182},{"line":182,"containerName":"new","kind":12,"name":"feature"},{"kind":13,"containerName":"new","name":"$feat","line":182},{"name":"$feat","containerName":"new","kind":13,"line":182},{"line":183,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"annotation","line":183},{"kind":13,"containerName":"new","name":"$anncoll","line":183},{"line":183,"name":"$feat","kind":13,"containerName":"new"},{"line":184,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"tagvalue_object_factory","line":184},{"name":"$fact","containerName":"new","kind":13,"line":184},{"line":184,"containerName":"new","kind":13,"name":"$fact"},{"line":186,"kind":13,"containerName":"new","name":"$self"}]},{"name":"SUPER","kind":12,"containerName":"new","line":175},{"name":"feature","containerName":"main::","children":[{"definition":"my","line":203,"name":"$self","localvar":"my","kind":13,"containerName":"feature"},{"line":203,"name":"$value","kind":13,"containerName":"feature"},{"name":"$value","kind":13,"containerName":"feature","line":204},{"line":205,"name":"$self","kind":13,"containerName":"feature"},{"line":205,"kind":13,"containerName":"feature","name":"$value"},{"line":207,"kind":13,"containerName":"feature","name":"$self"}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"end":{"line":208,"character":9999},"start":{"line":202,"character":0}},"line":202,"signature":{"label":"feature($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)"}},{"name":"annotation","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"annotation","name":"$self","line":228,"definition":"my"},{"containerName":"annotation","kind":13,"name":"$value","line":228},{"line":230,"containerName":"annotation","kind":13,"name":"$value"},{"line":231,"name":"$self","kind":13,"containerName":"annotation"},{"line":231,"name":"$value","kind":13,"containerName":"annotation"},{"line":233,"name":"$self","containerName":"annotation","kind":13},{"line":234,"kind":13,"containerName":"annotation","name":"$self"},{"name":"feature","containerName":"annotation","kind":12,"line":234},{"line":234,"name":"can","kind":12,"containerName":"annotation"},{"name":"$self","kind":13,"containerName":"annotation","line":235},{"name":"feature","containerName":"annotation","kind":12,"line":235},{"line":235,"name":"annotation","containerName":"annotation","kind":12},{"name":"$self","containerName":"annotation","kind":13,"line":237}],"detail":"($self,$value)","definition":"sub","kind":12,"range":{"start":{"line":227,"character":0},"end":{"character":9999,"line":238}},"line":227,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)","label":"annotation($self,$value)"}},{"kind":12,"range":{"end":{"line":272,"character":9999},"start":{"character":0,"line":254}},"line":254,"signature":{"label":"get_all_annotation_keys($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none"},"containerName":"main::","name":"get_all_annotation_keys","children":[{"definition":"my","line":255,"localvar":"my","containerName":"get_all_annotation_keys","kind":13,"name":"$self"},{"line":256,"name":"@keys","localvar":"my","containerName":"get_all_annotation_keys","kind":13,"definition":"my"},{"line":259,"name":"$self","containerName":"get_all_annotation_keys","kind":13},{"name":"feature","containerName":"get_all_annotation_keys","kind":12,"line":259},{"name":"can","kind":12,"containerName":"get_all_annotation_keys","line":259},{"line":260,"name":"@keys","containerName":"get_all_annotation_keys","kind":13},{"line":260,"containerName":"get_all_annotation_keys","kind":13,"name":"$self"},{"line":260,"name":"feature","kind":12,"containerName":"get_all_annotation_keys"},{"name":"get_all_tags","containerName":"get_all_annotation_keys","kind":12,"line":260},{"name":"@keys","kind":13,"containerName":"get_all_annotation_keys","line":262},{"line":262,"name":"$self","kind":13,"containerName":"get_all_annotation_keys"},{"name":"feature","kind":12,"containerName":"get_all_annotation_keys","line":262},{"line":262,"containerName":"get_all_annotation_keys","kind":12,"name":"all_tags"},{"line":265,"containerName":"get_all_annotation_keys","kind":13,"name":"$self"},{"line":265,"name":"annotation","containerName":"get_all_annotation_keys","kind":12},{"line":266,"kind":13,"containerName":"get_all_annotation_keys","name":"@keys"},{"containerName":"get_all_annotation_keys","kind":13,"name":"$self","line":267},{"containerName":"get_all_annotation_keys","kind":12,"name":"feature","line":267},{"name":"has_tag","kind":12,"containerName":"get_all_annotation_keys","line":267},{"name":"$self","kind":13,"containerName":"get_all_annotation_keys","line":268},{"containerName":"get_all_annotation_keys","kind":12,"name":"annotation","line":268},{"kind":12,"containerName":"get_all_annotation_keys","name":"get_all_annotation_keys","line":268},{"line":271,"name":"@keys","containerName":"get_all_annotation_keys","kind":13}],"detail":"($self)","definition":"sub"},{"signature":{"parameters":[{"label":"$self"},{"label":"@keys"}],"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations","label":"get_Annotations($self,@keys)"},"range":{"start":{"character":0,"line":285},"end":{"line":319,"character":9999}},"kind":12,"line":285,"detail":"($self,@keys)","definition":"sub","name":"get_Annotations","containerName":"main::","children":[{"definition":"my","line":286,"name":"$self","kind":13,"localvar":"my","containerName":"get_Annotations"},{"line":286,"name":"@keys","containerName":"get_Annotations","kind":13},{"line":287,"kind":13,"localvar":"my","containerName":"get_Annotations","name":"@anns","definition":"my"},{"definition":"my","name":"$fact","localvar":"my","kind":13,"containerName":"get_Annotations","line":290},{"line":290,"containerName":"get_Annotations","kind":13,"name":"$self"},{"kind":12,"containerName":"get_Annotations","name":"tagvalue_object_factory","line":290},{"line":293,"kind":13,"containerName":"get_Annotations","name":"@keys"},{"name":"$self","containerName":"get_Annotations","kind":13,"line":293},{"kind":12,"containerName":"get_Annotations","name":"feature","line":293},{"name":"all_tags","kind":12,"containerName":"get_Annotations","line":293},{"line":293,"name":"@keys","containerName":"get_Annotations","kind":13},{"definition":"my","containerName":"get_Annotations","localvar":"my","kind":13,"name":"$key","line":296},{"line":296,"name":"@keys","containerName":"get_Annotations","kind":13},{"containerName":"get_Annotations","kind":13,"name":"$self","line":298},{"line":298,"containerName":"get_Annotations","kind":12,"name":"feature"},{"line":298,"name":"has_tag","kind":12,"containerName":"get_Annotations"},{"line":298,"name":"$key","containerName":"get_Annotations","kind":13},{"localvar":"my","containerName":"get_Annotations","kind":13,"name":"$val","line":300,"definition":"my"},{"line":300,"name":"$self","containerName":"get_Annotations","kind":13},{"kind":12,"containerName":"get_Annotations","name":"feature","line":300},{"containerName":"get_Annotations","kind":12,"name":"get_tag_values","line":300},{"name":"$key","kind":13,"containerName":"get_Annotations","line":300},{"definition":"my","localvar":"my","containerName":"get_Annotations","kind":13,"name":"$ann","line":301},{"line":302,"name":"$fact","containerName":"get_Annotations","kind":13},{"line":303,"name":"$ann","containerName":"get_Annotations","kind":13},{"line":303,"containerName":"get_Annotations","kind":13,"name":"$fact"},{"line":303,"name":"create_object","containerName":"get_Annotations","kind":12},{"containerName":"get_Annotations","kind":13,"name":"$val","line":303},{"line":303,"name":"$key","containerName":"get_Annotations","kind":13},{"name":"$ann","containerName":"get_Annotations","kind":13,"line":305},{"line":305,"name":"new","containerName":"get_Annotations","kind":12},{"kind":13,"containerName":"get_Annotations","name":"$val","line":305},{"kind":13,"containerName":"get_Annotations","name":"$key","line":306},{"containerName":"get_Annotations","kind":13,"name":"@anns","line":308},{"line":308,"name":"$ann","kind":13,"containerName":"get_Annotations"},{"kind":13,"containerName":"get_Annotations","name":"$self","line":313},{"name":"annotation","kind":12,"containerName":"get_Annotations","line":313},{"line":314,"containerName":"get_Annotations","kind":13,"name":"@anns"},{"containerName":"get_Annotations","kind":13,"name":"$self","line":314},{"containerName":"get_Annotations","kind":12,"name":"annotation","line":314},{"containerName":"get_Annotations","kind":12,"name":"get_Annotations","line":314},{"line":314,"kind":13,"containerName":"get_Annotations","name":"@keys"},{"containerName":"get_Annotations","kind":13,"name":"@anns","line":318}]},{"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio","line":305},{"signature":{"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations\n\n\nsub get_Annotations{\n    my ($self, @keys) = @_;\n    my @anns = ();\n\n    # we need a annotation object factory\n    my $fact = $self->tagvalue_object_factory();\n\n    # get all tags if no keys have been provided\n    @keys = $self->feature->all_tags() unless @keys;\n\n    # build object for each value for each tag\n    foreach my $key (@keys) {\n      # protect against keys that aren't tags\n      next unless $self->feature->has_tag($key);\n      # add each tag/value pair as a SimpleValue object\n      foreach my $val ($self->feature()->get_tag_values($key)) {\n       my $ann;\n       if($fact) {\n          $ann = $fact->create_object(-value => $val, -tagname => $key);\n       } else {\n          $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n                                                   -tagname => $key);\n       }\n       push(@anns, $ann);\n      }\n    }\n\n    # add what is in the annotation implementation if any\n    if($self->annotation()) {\n      push(@anns, $self->annotation->get_Annotations(@keys));\n    }\n\n    # done\n    return @anns;\n}\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none","parameters":[{"label":"$self"}],"label":"get_num_of_annotations($self)"},"kind":12,"range":{"start":{"character":0,"line":332},"end":{"line":349,"character":9999}},"line":332,"detail":"($self)","definition":"sub","containerName":"main::","name":"get_num_of_annotations","children":[{"line":333,"name":"$self","containerName":"get_num_of_annotations","localvar":"my","kind":13,"definition":"my"},{"definition":"my","line":336,"name":"$num_anns","kind":13,"localvar":"my","containerName":"get_num_of_annotations"},{"line":338,"name":"$self","containerName":"get_num_of_annotations","kind":13},{"line":338,"containerName":"get_num_of_annotations","kind":12,"name":"feature"},{"line":338,"name":"all_tags","containerName":"get_num_of_annotations","kind":12},{"name":"$num_anns","containerName":"get_num_of_annotations","kind":13,"line":339},{"containerName":"get_num_of_annotations","kind":13,"name":"$self","line":339},{"kind":12,"containerName":"get_num_of_annotations","name":"feature","line":339},{"line":339,"name":"each_tag_value","containerName":"get_num_of_annotations","kind":12},{"kind":13,"containerName":"get_num_of_annotations","name":"$self","line":343},{"line":343,"kind":12,"containerName":"get_num_of_annotations","name":"annotation"},{"kind":13,"containerName":"get_num_of_annotations","name":"$num_anns","line":344},{"line":344,"containerName":"get_num_of_annotations","kind":13,"name":"$self"},{"containerName":"get_num_of_annotations","kind":12,"name":"annotation","line":344},{"line":344,"kind":12,"containerName":"get_num_of_annotations","name":"get_num_of_annotations"},{"line":348,"kind":13,"containerName":"get_num_of_annotations","name":"$num_anns"}]},{"definition":"sub","detail":"($self,$key,$object,$archetype)","children":[{"definition":"my","line":385,"name":"$self","localvar":"my","kind":13,"containerName":"add_Annotation"},{"containerName":"add_Annotation","kind":13,"name":"$key","line":385},{"kind":13,"containerName":"add_Annotation","name":"$object","line":385},{"containerName":"add_Annotation","kind":13,"name":"$archetype","line":385},{"line":388,"containerName":"add_Annotation","kind":13,"name":"$key"},{"line":388,"name":"$key","containerName":"add_Annotation","kind":13},{"name":"isa","kind":12,"containerName":"add_Annotation","line":388},{"name":"$object","kind":13,"containerName":"add_Annotation","line":389},{"name":"$object","kind":13,"containerName":"add_Annotation","line":389},{"containerName":"add_Annotation","kind":13,"name":"$archetype","line":390},{"line":390,"name":"$object","kind":13,"containerName":"add_Annotation"},{"name":"$object","containerName":"add_Annotation","kind":13,"line":390},{"line":391,"name":"$object","containerName":"add_Annotation","kind":13},{"line":391,"kind":13,"containerName":"add_Annotation","name":"$key"},{"line":392,"name":"$key","kind":13,"containerName":"add_Annotation"},{"line":392,"kind":13,"containerName":"add_Annotation","name":"$object"},{"kind":12,"containerName":"add_Annotation","name":"tagname","line":392},{"containerName":"add_Annotation","kind":13,"name":"$key","line":393},{"name":"$key","containerName":"add_Annotation","kind":13,"line":393},{"line":393,"kind":12,"containerName":"add_Annotation","name":"name"},{"line":393,"containerName":"add_Annotation","kind":13,"name":"$key"},{"kind":13,"containerName":"add_Annotation","name":"$key","line":393},{"kind":13,"containerName":"add_Annotation","name":"$self","line":394},{"line":394,"containerName":"add_Annotation","kind":12,"name":"throw"},{"name":"$key","kind":13,"containerName":"add_Annotation","line":395},{"line":398,"containerName":"add_Annotation","kind":13,"name":"$object"},{"line":399,"name":"$self","containerName":"add_Annotation","kind":13},{"name":"throw","kind":12,"containerName":"add_Annotation","line":399},{"containerName":"add_Annotation","kind":13,"name":"$object","line":402},{"name":"$object","containerName":"add_Annotation","kind":13,"line":402},{"line":402,"name":"isa","kind":12,"containerName":"add_Annotation"},{"kind":13,"containerName":"add_Annotation","name":"$self","line":403},{"line":403,"name":"throw","kind":12,"containerName":"add_Annotation"},{"line":409,"name":"$object","kind":13,"containerName":"add_Annotation"},{"line":409,"kind":12,"containerName":"add_Annotation","name":"isa"},{"line":410,"name":"$self","kind":13,"containerName":"add_Annotation"},{"line":410,"kind":12,"containerName":"add_Annotation","name":"feature"},{"name":"can","containerName":"add_Annotation","kind":12,"line":410},{"name":"$self","containerName":"add_Annotation","kind":13,"line":411},{"kind":12,"containerName":"add_Annotation","name":"feature","line":411},{"line":411,"name":"add_tag_value","containerName":"add_Annotation","kind":12},{"containerName":"add_Annotation","kind":13,"name":"$key","line":411},{"name":"$object","containerName":"add_Annotation","kind":13,"line":411},{"name":"value","kind":12,"containerName":"add_Annotation","line":411},{"kind":13,"localvar":"my","containerName":"add_Annotation","name":"$anncoll","line":413,"definition":"my"},{"name":"$self","containerName":"add_Annotation","kind":13,"line":413},{"line":413,"containerName":"add_Annotation","kind":12,"name":"annotation"},{"line":414,"kind":13,"containerName":"add_Annotation","name":"$anncoll"},{"line":415,"name":"$anncoll","kind":13,"containerName":"add_Annotation"},{"name":"new","containerName":"add_Annotation","kind":12,"line":415},{"line":416,"kind":13,"containerName":"add_Annotation","name":"$self"},{"name":"annotation","kind":12,"containerName":"add_Annotation","line":416},{"line":416,"name":"$anncoll","kind":13,"containerName":"add_Annotation"},{"line":418,"name":"$anncoll","containerName":"add_Annotation","kind":13},{"name":"can","containerName":"add_Annotation","kind":12,"line":418},{"name":"$anncoll","containerName":"add_Annotation","kind":13,"line":419},{"line":419,"kind":12,"containerName":"add_Annotation","name":"add_Annotation"},{"line":419,"containerName":"add_Annotation","kind":13,"name":"$key"},{"containerName":"add_Annotation","kind":13,"name":"$object","line":419},{"line":419,"name":"$archetype","kind":13,"containerName":"add_Annotation"},{"line":421,"containerName":"add_Annotation","kind":13,"name":"$self"},{"kind":12,"containerName":"add_Annotation","name":"throw","line":421}],"name":"add_Annotation","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$key"},{"label":"$object"},{"label":"$archetype"}],"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations\n\n\nsub get_Annotations{\n    my ($self, @keys) = @_;\n    my @anns = ();\n\n    # we need a annotation object factory\n    my $fact = $self->tagvalue_object_factory();\n\n    # get all tags if no keys have been provided\n    @keys = $self->feature->all_tags() unless @keys;\n\n    # build object for each value for each tag\n    foreach my $key (@keys) {\n      # protect against keys that aren't tags\n      next unless $self->feature->has_tag($key);\n      # add each tag/value pair as a SimpleValue object\n      foreach my $val ($self->feature()->get_tag_values($key)) {\n       my $ann;\n       if($fact) {\n          $ann = $fact->create_object(-value => $val, -tagname => $key);\n       } else {\n          $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n                                                   -tagname => $key);\n       }\n       push(@anns, $ann);\n      }\n    }\n\n    # add what is in the annotation implementation if any\n    if($self->annotation()) {\n      push(@anns, $self->annotation->get_Annotations(@keys));\n    }\n\n    # done\n    return @anns;\n}\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n  my ($self) = @_;\n\n  # first, count the number of tags on the feature\n  my $num_anns = 0;\n\n  foreach ($self->feature()->all_tags()) {\n\t$num_anns += scalar( $self->feature()->each_tag_value($_));\n  }\n\n  # add from the annotation implementation if any\n  if($self->annotation()) {\n \t$num_anns += $self->annotation()->get_num_of_annotations();\n  }\n\n  # done\n  return $num_anns;\n}\n\n=head1 Implementation specific functions - to allow adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n           This implementation will add all Bio::Annotation::SimpleValue\n           objects to the adapted features as tag/value pairs. Caveat: this\n           may potentially result in information loss if a derived object\n           is supplied.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to","label":"add_Annotation($self,$key,$object,$archetype)"},"line":384,"range":{"start":{"character":0,"line":384},"end":{"character":9999,"line":423}},"kind":12},{"line":415,"containerName":"Annotation::Collection","kind":12,"name":"Bio"},{"definition":"sub","detail":"($self,@keys)","children":[{"localvar":"my","kind":13,"containerName":"remove_Annotations","name":"$self","line":446,"definition":"my"},{"line":446,"name":"@keys","containerName":"remove_Annotations","kind":13},{"containerName":"remove_Annotations","kind":13,"name":"@keys","line":449},{"line":449,"kind":13,"containerName":"remove_Annotations","name":"$self"},{"containerName":"remove_Annotations","kind":12,"name":"get_all_annotation_keys","line":449},{"line":449,"name":"@keys","containerName":"remove_Annotations","kind":13},{"line":451,"kind":13,"localvar":"my","containerName":"remove_Annotations","name":"@anns","definition":"my"},{"line":451,"kind":13,"containerName":"remove_Annotations","name":"$self"},{"kind":12,"containerName":"remove_Annotations","name":"get_Annotations","line":451},{"containerName":"remove_Annotations","kind":13,"name":"@keys","line":451},{"definition":"my","name":"$key","containerName":"remove_Annotations","localvar":"my","kind":13,"line":453},{"line":453,"containerName":"remove_Annotations","kind":13,"name":"@keys"},{"kind":13,"containerName":"remove_Annotations","name":"$self","line":455},{"line":455,"kind":12,"containerName":"remove_Annotations","name":"feature"},{"line":455,"containerName":"remove_Annotations","kind":12,"name":"remove_tag"},{"name":"$key","kind":13,"containerName":"remove_Annotations","line":455},{"line":455,"name":"$self","containerName":"remove_Annotations","kind":13},{"line":455,"containerName":"remove_Annotations","kind":12,"name":"feature"},{"line":455,"kind":12,"containerName":"remove_Annotations","name":"has_tag"},{"line":455,"containerName":"remove_Annotations","kind":13,"name":"$key"},{"containerName":"remove_Annotations","localvar":"my","kind":13,"name":"$anncoll","line":457,"definition":"my"},{"line":457,"name":"$self","kind":13,"containerName":"remove_Annotations"},{"line":457,"name":"annotation","kind":12,"containerName":"remove_Annotations"},{"kind":13,"containerName":"remove_Annotations","name":"$anncoll","line":458},{"line":458,"name":"$anncoll","kind":13,"containerName":"remove_Annotations"},{"line":458,"kind":12,"containerName":"remove_Annotations","name":"can"},{"line":459,"kind":13,"containerName":"remove_Annotations","name":"$anncoll"},{"line":459,"kind":12,"containerName":"remove_Annotations","name":"remove_Annotations"},{"containerName":"remove_Annotations","kind":13,"name":"$key","line":459},{"line":460,"name":"$anncoll","kind":13,"containerName":"remove_Annotations"},{"line":461,"containerName":"remove_Annotations","kind":13,"name":"$self"},{"containerName":"remove_Annotations","kind":12,"name":"warn","line":461},{"kind":13,"containerName":"remove_Annotations","name":"$anncoll","line":461},{"name":"@anns","kind":13,"containerName":"remove_Annotations","line":465}],"containerName":"main::","name":"remove_Annotations","signature":{"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations\n\n\nsub get_Annotations{\n    my ($self, @keys) = @_;\n    my @anns = ();\n\n    # we need a annotation object factory\n    my $fact = $self->tagvalue_object_factory();\n\n    # get all tags if no keys have been provided\n    @keys = $self->feature->all_tags() unless @keys;\n\n    # build object for each value for each tag\n    foreach my $key (@keys) {\n      # protect against keys that aren't tags\n      next unless $self->feature->has_tag($key);\n      # add each tag/value pair as a SimpleValue object\n      foreach my $val ($self->feature()->get_tag_values($key)) {\n       my $ann;\n       if($fact) {\n          $ann = $fact->create_object(-value => $val, -tagname => $key);\n       } else {\n          $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n                                                   -tagname => $key);\n       }\n       push(@anns, $ann);\n      }\n    }\n\n    # add what is in the annotation implementation if any\n    if($self->annotation()) {\n      push(@anns, $self->annotation->get_Annotations(@keys));\n    }\n\n    # done\n    return @anns;\n}\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n  my ($self) = @_;\n\n  # first, count the number of tags on the feature\n  my $num_anns = 0;\n\n  foreach ($self->feature()->all_tags()) {\n\t$num_anns += scalar( $self->feature()->each_tag_value($_));\n  }\n\n  # add from the annotation implementation if any\n  if($self->annotation()) {\n \t$num_anns += $self->annotation()->get_num_of_annotations();\n  }\n\n  # done\n  return $num_anns;\n}\n\n=head1 Implementation specific functions - to allow adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n           This implementation will add all Bio::Annotation::SimpleValue\n           objects to the adapted features as tag/value pairs. Caveat: this\n           may potentially result in information loss if a derived object\n           is supplied.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n    my ($self,$key,$object,$archetype) = @_;\n   \n    # if there's no key we use the tagname() as key\n    if(ref($key) && $key->isa(\"Bio::AnnotationI\") &&\n       (! ($object && ref($object)))) {\n\t$archetype = $object if $object;\n\t$object = $key;\n\t$key = $object->tagname();\n\t$key = $key->name() if $key && ref($key); # OntologyTermI\n\t$self->throw(\"Annotation object must have a tagname if key omitted\")\n\t    unless $key;\n    }\n    \n    if( !defined $object ) {\n\t$self->throw(\"Must have at least key and object in add_Annotation\");\n    }\n    \n    if( ! (ref($object) && $object->isa(\"Bio::AnnotationI\")) ) {\n\t$self->throw(\"object must be a Bio::AnnotationI compliant object, otherwise we wont add it!\");\n    }\n    \n    # ready to add -- if it's a SimpleValue, we add to the feature's tags,\n    # otherwise we'll add to the annotation collection implementation\n\n    if($object->isa(\"Bio::Annotation::SimpleValue\") &&\n       $self->feature()->can('add_tag_value')) {\n\treturn $self->feature()->add_tag_value($key, $object->value());\n    } else {\n\tmy $anncoll = $self->annotation();\n\tif(! $anncoll) {\n\t    $anncoll = Bio::Annotation::Collection->new();\n\t    $self->annotation($anncoll);\n\t}\n\tif($anncoll->can('add_Annotation')) {\n\t    return $anncoll->add_Annotation($key,$object,$archetype);\n\t}\n\t$self->throw(\"Annotation implementation does not allow adding!\");\n    }\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this\n           collection.\n\n           If the key happens to be a tag, then the tag is removed\n           from the feature.\n\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)","parameters":[{"label":"$self"},{"label":"@keys"}],"label":"remove_Annotations($self,@keys)"},"line":445,"range":{"end":{"character":9999,"line":466},"start":{"line":445,"character":0}},"kind":12},{"range":{"start":{"line":492,"character":0},"end":{"character":9999,"line":498}},"kind":12,"line":492,"signature":{"label":"tagvalue_object_factory($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: AnnotationAdaptor.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::AnnotationAdaptor\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n#\n# (c) Hilmar Lapp, hlapp at gmx.net, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::AnnotationAdaptor - integrates SeqFeatureIs annotation\n\n=head1 SYNOPSIS\n\n   use Bio::SeqFeature::Generic;\n   use Bio::SeqFeature::AnnotationAdaptor;\n\n   # obtain a SeqFeatureI implementing object somehow\n   my $feat = Bio::SeqFeature::Generic->new(-start => 10, -end => 20);\n\n   # add tag/value annotation\n   $feat->add_tag_value(\"mytag\", \"value of tag mytag\");\n   $feat->add_tag_value(\"mytag\", \"another value of tag mytag\");\n\n   # Bio::SeqFeature::Generic also provides annotation(), which returns a\n   # Bio::AnnotationCollectionI compliant object\n   $feat->annotation->add_Annotation(\"dbxref\", $dblink);\n\n   # to integrate tag/value annotation with AnnotationCollectionI\n   # annotation, use this adaptor, which also implements \n   # Bio::AnnotationCollectionI\n   my $anncoll = Bio::SeqFeature::AnnotationAdaptor->new(-feature => $feat);\n\n   # this will now return tag/value pairs as \n   # Bio::Annotation::SimpleValue objects\n   my @anns = $anncoll->get_Annotations(\"mytag\");\n   # other added before annotation is available too\n   my @dblinks = $anncoll->get_Annotations(\"dbxref\");\n\n   # also supports transparent adding of tag/value pairs in \n   # Bio::AnnotationI flavor\n   my $tagval = Bio::Annotation::SimpleValue->new(-value => \"some value\",\n                                                  -tagname => \"some tag\");\n   $anncoll->add_Annotation($tagval);\n   # this is now also available from the feature's tag/value system\n   my @vals = $feat->each_tag_value(\"some tag\");\n\n=head1 DESCRIPTION\n\nL<Bio::SeqFeatureI> defines light-weight annotation of features\nthrough tag/value pairs. Conversely, L<Bio::AnnotationCollectionI>\ntogether with L<Bio::AnnotationI> defines an annotation bag, which is\nbetter typed, but more heavy-weight because it contains every single\npiece of annotation as objects. The frequently used base\nimplementation of Bio::SeqFeatureI, Bio::SeqFeature::Generic, defines\nan additional slot for AnnotationCollectionI-compliant annotation.\n\nThis adaptor provides a L<Bio::AnnotationCollectionI> compliant,\nunified, and integrated view on the annotation of L<Bio::SeqFeatureI>\nobjects, including tag/value pairs, and annotation through the\nannotation() method, if the object supports it. Code using this\nadaptor does not need to worry about the different ways of possibly\nannotating a SeqFeatureI object, but can instead assume that it\nstrictly follows the AnnotationCollectionI scheme. The price to pay is\nthat retrieving and adding annotation will always use objects instead\nof light-weight tag/value pairs.\n\nIn other words, this adaptor allows us to keep the best of both\nworlds. If you create tens of thousands of feature objects, and your\nonly annotation is tag/value pairs, you are best off using the\nfeatures' native tag/value system. If you create a smaller number of\nfeatures, but with rich and typed annotation mixed with tag/value\npairs, this adaptor may be for you. Since its implementation is by\ndouble-composition, you only need to create one instance of the\nadaptor. In order to transparently annotate a feature object, set the\nfeature using the feature() method. Every annotation you add will be\nadded to the feature object, and hence will not be lost when you set\nfeature() to the next object.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n#' Let the code begin...\n\n\npackage Bio::SeqFeature::AnnotationAdaptor;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotatableI);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::SeqFeature::AnnotationAdaptor->new();\n Function: Builds a new Bio::SeqFeature::AnnotationAdaptor object \n Returns : an instance of Bio::SeqFeature::AnnotationAdaptor\n Args    : Named parameters\n            -feature    the Bio::SeqFeatureI implementing object to adapt\n                        (mandatory to be passed here, or set via feature()\n                        before calling other methods)\n            -annotation the Bio::AnnotationCollectionI implementing object\n                        for storing richer annotation (this will default to\n                        the $feature->annotation() if it supports it)\n            -tagvalue_factory the object factory to use for creating tag/value\n                        pair representing objects\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n\n  my ($feat,$anncoll,$fact) =\n\t$self->_rearrange([qw(FEATURE\n                          ANNOTATION\n                          TAGVALUE_FACTORY)], @args);\n\n  $self->feature($feat) if $feat;\n  $self->annotation($anncoll) if $feat;\n  $self->tagvalue_object_factory($fact) if $fact;\n\n  return $self;\n}\n\n=head2 feature\n\n Title   : feature\n Usage   : $obj->feature($newval)\n Function: Get/set the feature that this object adapts to an\n           AnnotationCollectionI.\n Example : \n Returns : value of feature (a Bio::SeqFeatureI compliant object)\n Args    : new value (a Bio::SeqFeatureI compliant object, optional)\n\n\n\nsub feature{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'feature'} = $value;\n    }\n    return $self->{'feature'};\n}\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the AnnotationCollectionI implementing object used by\n           this adaptor to store additional annotation that cannot be stored\n           by the SeqFeatureI itself.\n\n           If requested before having been set, the value will default to the\n           annotation object of the feature if it has one.\n Example : \n Returns : value of annotation (a Bio::AnnotationCollectionI compliant object)\n Args    : new value (a Bio::AnnotationCollectionI compliant object, optional)\n\n\n\nsub annotation{\n    my ($self,$value) = @_;\n\n    if( defined $value) {\n        $self->{'annotation'} = $value;\n    }\n    if((! exists($self->{'annotation'})) &&\n       $self->feature()->can('annotation')) {\n        return $self->feature()->annotation();\n    }\n    return $self->{'annotation'};\n}\n\n=head1 AnnotationCollectionI implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n    my ($self) = @_;\n    my @keys = ();\n    \n    # get the tags from the feature object\n    if ($self->feature()->can('get_all_tags')) {\n        push(@keys, $self->feature()->get_all_tags());\n    } else {\n        push(@keys, $self->feature()->all_tags());\n    }\n    # ask the annotation implementation in addition, while avoiding duplicates\n    if($self->annotation()) {\n\tpush(@keys,\n\t     grep { ! $self->feature->has_tag($_); }\n\t          $self->annotation()->get_all_annotation_keys());\n    }\n    # done\n    return @keys;\n}\n\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for a specific key\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : string which is key for annotations\n\n\nsub get_Annotations{\n    my ($self, @keys) = @_;\n    my @anns = ();\n\n    # we need a annotation object factory\n    my $fact = $self->tagvalue_object_factory();\n\n    # get all tags if no keys have been provided\n    @keys = $self->feature->all_tags() unless @keys;\n\n    # build object for each value for each tag\n    foreach my $key (@keys) {\n      # protect against keys that aren't tags\n      next unless $self->feature->has_tag($key);\n      # add each tag/value pair as a SimpleValue object\n      foreach my $val ($self->feature()->get_tag_values($key)) {\n       my $ann;\n       if($fact) {\n          $ann = $fact->create_object(-value => $val, -tagname => $key);\n       } else {\n          $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n                                                   -tagname => $key);\n       }\n       push(@anns, $ann);\n      }\n    }\n\n    # add what is in the annotation implementation if any\n    if($self->annotation()) {\n      push(@anns, $self->annotation->get_Annotations(@keys));\n    }\n\n    # done\n    return @anns;\n}\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n  my ($self) = @_;\n\n  # first, count the number of tags on the feature\n  my $num_anns = 0;\n\n  foreach ($self->feature()->all_tags()) {\n\t$num_anns += scalar( $self->feature()->each_tag_value($_));\n  }\n\n  # add from the annotation implementation if any\n  if($self->annotation()) {\n \t$num_anns += $self->annotation()->get_num_of_annotations();\n  }\n\n  # done\n  return $num_anns;\n}\n\n=head1 Implementation specific functions - to allow adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n           This implementation will add all Bio::Annotation::SimpleValue\n           objects to the adapted features as tag/value pairs. Caveat: this\n           may potentially result in information loss if a derived object\n           is supplied.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n    my ($self,$key,$object,$archetype) = @_;\n   \n    # if there's no key we use the tagname() as key\n    if(ref($key) && $key->isa(\"Bio::AnnotationI\") &&\n       (! ($object && ref($object)))) {\n\t$archetype = $object if $object;\n\t$object = $key;\n\t$key = $object->tagname();\n\t$key = $key->name() if $key && ref($key); # OntologyTermI\n\t$self->throw(\"Annotation object must have a tagname if key omitted\")\n\t    unless $key;\n    }\n    \n    if( !defined $object ) {\n\t$self->throw(\"Must have at least key and object in add_Annotation\");\n    }\n    \n    if( ! (ref($object) && $object->isa(\"Bio::AnnotationI\")) ) {\n\t$self->throw(\"object must be a Bio::AnnotationI compliant object, otherwise we wont add it!\");\n    }\n    \n    # ready to add -- if it's a SimpleValue, we add to the feature's tags,\n    # otherwise we'll add to the annotation collection implementation\n\n    if($object->isa(\"Bio::Annotation::SimpleValue\") &&\n       $self->feature()->can('add_tag_value')) {\n\treturn $self->feature()->add_tag_value($key, $object->value());\n    } else {\n\tmy $anncoll = $self->annotation();\n\tif(! $anncoll) {\n\t    $anncoll = Bio::Annotation::Collection->new();\n\t    $self->annotation($anncoll);\n\t}\n\tif($anncoll->can('add_Annotation')) {\n\t    return $anncoll->add_Annotation($key,$object,$archetype);\n\t}\n\t$self->throw(\"Annotation implementation does not allow adding!\");\n    }\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this\n           collection.\n\n           If the key happens to be a tag, then the tag is removed\n           from the feature.\n\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    # set to all keys if none are supplied\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    # collect existing annotation\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n\t# delete the tag if it is one\n\t$self->feature->remove_tag($key) if $self->feature->has_tag($key);\n\t# and delegate to the annotation implementation \n\tmy $anncoll = $self->annotation();\n\tif($anncoll && $anncoll->can('remove_Annotations')) {\n\t    $anncoll->remove_Annotations($key);\n\t} elsif($anncoll) {\n\t    $self->warn(\"Annotation bundle implementation \".ref($anncoll).\n\t\t\t\" does not allow remove!\");\n\t}\n    }\n    return @anns;\n}\n\n=head1 Additional methods\n\n\n=head2 tagvalue_object_factory\n\n Title   : tagvalue_object_factory\n Usage   : $obj->tagval_object_factory($newval)\n Function: Get/set the object factory to use for creating objects that\n           represent tag/value pairs (e.g.,\n           Bio::Annotation::SimpleValue).\n\n           The object to be created is expected to follow\n           Bio::Annotation::SimpleValue in terms of supported\n           arguments at creation time, and the methods.\n\n Example : \n Returns : A Bio::Factory::ObjectFactoryI compliant object\n Args    : new value (a Bio::Factory::ObjectFactoryI compliant object, \n           optional)"},"name":"tagvalue_object_factory","containerName":"main::","children":[{"line":493,"localvar":"my","containerName":"tagvalue_object_factory","kind":13,"name":"$self","definition":"my"},{"name":"$value","containerName":"tagvalue_object_factory","kind":13,"line":493},{"containerName":"tagvalue_object_factory","kind":13,"name":"$value","line":494},{"line":495,"name":"$self","kind":13,"containerName":"tagvalue_object_factory"},{"containerName":"tagvalue_object_factory","kind":13,"name":"$value","line":495},{"line":497,"kind":13,"containerName":"tagvalue_object_factory","name":"$self"}],"detail":"($self,$value)","definition":"sub"}]}