{"version":5,"vars":[{"name":"base","kind":2,"containerName":"","line":151},{"containerName":"main::","name":"new","children":[{"localvar":"my","containerName":"new","kind":13,"name":"$caller","line":154,"definition":"my"},{"containerName":"new","kind":13,"name":"@args","line":154},{"definition":"my","line":155,"name":"$self","kind":13,"localvar":"my","containerName":"new"},{"containerName":"new","kind":13,"name":"$caller","line":155},{"kind":13,"containerName":"new","name":"@args","line":155},{"line":156,"name":"$self","kind":13,"containerName":"new"},{"name":"_register_for_cleanup","kind":12,"containerName":"new","line":156},{"name":"$self","kind":13,"containerName":"new","line":157},{"line":158,"name":"$self","kind":13,"containerName":"new"},{"line":161,"kind":13,"containerName":"new","name":"$self"},{"name":"set_attributes","containerName":"new","kind":12,"line":161},{"line":161,"kind":13,"containerName":"new","name":"@args"},{"line":164,"containerName":"new","kind":13,"name":"$self"}],"detail":"($caller,@args)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":153},"end":{"line":165,"character":9999}},"line":153,"signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"","label":"new($caller,@args)"}},{"line":155,"name":"SUPER","kind":12,"containerName":"new"},{"line":156,"name":"cleanup_generic","kind":12},{"signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object","parameters":[{"label":"$self"},{"label":"@args"}],"label":"set_attributes($self,@args)"},"range":{"start":{"line":194,"character":0},"end":{"line":243,"character":9999}},"kind":12,"line":194,"detail":"($self,@args)","definition":"sub","containerName":"main::","name":"set_attributes","children":[{"definition":"my","name":"$self","containerName":"set_attributes","localvar":"my","kind":13,"line":195},{"line":195,"containerName":"set_attributes","kind":13,"name":"@args"},{"definition":"my","line":196,"name":"$start","kind":13,"localvar":"my","containerName":"set_attributes"},{"containerName":"set_attributes","kind":13,"name":"$end","line":196},{"name":"$strand","kind":13,"containerName":"set_attributes","line":196},{"name":"$primary_tag","kind":13,"containerName":"set_attributes","line":196},{"line":196,"name":"$source_tag","kind":13,"containerName":"set_attributes"},{"line":196,"kind":13,"containerName":"set_attributes","name":"$primary"},{"line":197,"name":"$source","containerName":"set_attributes","kind":13},{"name":"$frame","containerName":"set_attributes","kind":13,"line":197},{"containerName":"set_attributes","kind":13,"name":"$score","line":197},{"containerName":"set_attributes","kind":13,"name":"$tag","line":197},{"containerName":"set_attributes","kind":13,"name":"$gff_string","line":197},{"kind":13,"containerName":"set_attributes","name":"$gff1_string","line":197},{"line":198,"name":"$seqname","containerName":"set_attributes","kind":13},{"line":198,"name":"$seqid","containerName":"set_attributes","kind":13},{"kind":13,"containerName":"set_attributes","name":"$annot","line":198},{"containerName":"set_attributes","kind":13,"name":"$location","line":198},{"line":198,"kind":13,"containerName":"set_attributes","name":"$display_name"},{"name":"$self","kind":13,"containerName":"set_attributes","line":199},{"name":"_rearrange","containerName":"set_attributes","kind":12,"line":199},{"line":216,"kind":13,"containerName":"set_attributes","name":"@args"},{"name":"$location","kind":13,"containerName":"set_attributes","line":217},{"kind":13,"containerName":"set_attributes","name":"$self","line":217},{"line":217,"name":"location","kind":12,"containerName":"set_attributes"},{"line":217,"name":"$location","kind":13,"containerName":"set_attributes"},{"line":218,"kind":13,"containerName":"set_attributes","name":"$gff_string"},{"name":"$self","kind":13,"containerName":"set_attributes","line":218},{"line":218,"containerName":"set_attributes","kind":12,"name":"_from_gff_string"},{"containerName":"set_attributes","kind":13,"name":"$gff_string","line":218},{"line":219,"kind":13,"containerName":"set_attributes","name":"$gff1_string"},{"line":220,"kind":13,"containerName":"set_attributes","name":"$self"},{"containerName":"set_attributes","kind":12,"name":"gff_format","line":220},{"name":"new","kind":12,"containerName":"set_attributes","line":220},{"kind":13,"containerName":"set_attributes","name":"$self","line":221},{"line":221,"name":"_from_gff_stream","kind":12,"containerName":"set_attributes"},{"line":221,"name":"$gff1_string","containerName":"set_attributes","kind":13},{"kind":13,"containerName":"set_attributes","name":"$primary_tag","line":223},{"name":"$self","containerName":"set_attributes","kind":13,"line":223},{"name":"primary_tag","kind":12,"containerName":"set_attributes","line":223},{"line":223,"containerName":"set_attributes","kind":13,"name":"$primary_tag"},{"name":"$source_tag","containerName":"set_attributes","kind":13,"line":224},{"line":224,"containerName":"set_attributes","kind":13,"name":"$self"},{"line":224,"name":"source_tag","kind":12,"containerName":"set_attributes"},{"containerName":"set_attributes","kind":13,"name":"$source_tag","line":224},{"line":225,"kind":13,"containerName":"set_attributes","name":"$primary"},{"containerName":"set_attributes","kind":13,"name":"$self","line":225},{"containerName":"set_attributes","kind":12,"name":"primary_tag","line":225},{"line":225,"name":"$primary","containerName":"set_attributes","kind":13},{"line":226,"kind":13,"containerName":"set_attributes","name":"$source"},{"line":226,"name":"$self","kind":13,"containerName":"set_attributes"},{"line":226,"name":"source_tag","kind":12,"containerName":"set_attributes"},{"name":"$source","containerName":"set_attributes","kind":13,"line":226},{"line":227,"containerName":"set_attributes","kind":13,"name":"$start"},{"line":227,"name":"$self","containerName":"set_attributes","kind":13},{"kind":12,"containerName":"set_attributes","name":"start","line":227},{"containerName":"set_attributes","kind":13,"name":"$start","line":227},{"kind":13,"containerName":"set_attributes","name":"$end","line":228},{"kind":13,"containerName":"set_attributes","name":"$self","line":228},{"line":228,"name":"end","kind":12,"containerName":"set_attributes"},{"line":228,"kind":13,"containerName":"set_attributes","name":"$end"},{"name":"$strand","containerName":"set_attributes","kind":13,"line":229},{"line":229,"kind":13,"containerName":"set_attributes","name":"$self"},{"line":229,"name":"strand","kind":12,"containerName":"set_attributes"},{"line":229,"kind":13,"containerName":"set_attributes","name":"$strand"},{"name":"$frame","kind":13,"containerName":"set_attributes","line":230},{"name":"$self","containerName":"set_attributes","kind":13,"line":230},{"name":"frame","kind":12,"containerName":"set_attributes","line":230},{"kind":13,"containerName":"set_attributes","name":"$frame","line":230},{"line":231,"name":"$display_name","kind":13,"containerName":"set_attributes"},{"name":"$self","kind":13,"containerName":"set_attributes","line":231},{"containerName":"set_attributes","kind":12,"name":"display_name","line":231},{"line":231,"containerName":"set_attributes","kind":13,"name":"$display_name"},{"line":232,"name":"$score","containerName":"set_attributes","kind":13},{"line":232,"name":"$self","containerName":"set_attributes","kind":13},{"containerName":"set_attributes","kind":12,"name":"score","line":232},{"kind":13,"containerName":"set_attributes","name":"$score","line":232},{"containerName":"set_attributes","kind":13,"name":"$annot","line":233},{"line":233,"containerName":"set_attributes","kind":13,"name":"$self"},{"kind":12,"containerName":"set_attributes","name":"annotation","line":233},{"line":233,"containerName":"set_attributes","kind":13,"name":"$annot"},{"line":234,"kind":13,"containerName":"set_attributes","name":"$seqname"},{"line":235,"kind":13,"containerName":"set_attributes","name":"$self"},{"line":235,"containerName":"set_attributes","kind":12,"name":"warn"},{"kind":13,"containerName":"set_attributes","name":"$seqid","line":236},{"line":236,"name":"$seqname","kind":13,"containerName":"set_attributes"},{"kind":13,"containerName":"set_attributes","name":"$seqid","line":236},{"kind":13,"containerName":"set_attributes","name":"$seqid","line":238},{"name":"$self","kind":13,"containerName":"set_attributes","line":238},{"kind":12,"containerName":"set_attributes","name":"seq_id","line":238},{"kind":13,"containerName":"set_attributes","name":"$seqid","line":238},{"containerName":"set_attributes","kind":13,"name":"$tag","line":239},{"definition":"my","line":240,"containerName":"set_attributes","localvar":"my","kind":13,"name":"$t"},{"line":240,"kind":13,"containerName":"set_attributes","name":"$tag"},{"line":241,"name":"$self","containerName":"set_attributes","kind":13},{"line":241,"containerName":"set_attributes","kind":12,"name":"add_tag_value"},{"line":241,"name":"$t","kind":13,"containerName":"set_attributes"},{"name":"$tag","kind":13,"containerName":"set_attributes","line":241},{"name":"$t","containerName":"set_attributes","kind":13,"line":241},{"name":"$tag","kind":13,"containerName":"set_attributes","line":241},{"containerName":"set_attributes","kind":13,"name":"$t","line":241},{"line":241,"name":"$tag","kind":13,"containerName":"set_attributes"},{"name":"$t","containerName":"set_attributes","kind":13,"line":241}]},{"containerName":"Tools::GFF","kind":12,"name":"Bio","line":220},{"line":241,"kind":12,"containerName":"isa","name":"UNIVERSAL"},{"children":[{"name":"$class","localvar":"my","kind":13,"containerName":"direct_new","line":260,"definition":"my"},{"line":261,"name":"$self","kind":13,"localvar":"my","containerName":"direct_new","definition":"my"},{"line":263,"name":"$self","kind":13,"containerName":"direct_new"},{"name":"$class","containerName":"direct_new","kind":13,"line":263},{"line":265,"name":"$self","containerName":"direct_new","kind":13}],"name":"direct_new","containerName":"main::","definition":"sub","detail":"($class)","line":259,"kind":12,"range":{"start":{"character":0,"line":259},"end":{"character":9999,"line":266}},"signature":{"label":"direct_new($class)","parameters":[{"label":"$class"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none"}},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"location","children":[{"name":"$self","containerName":"location","localvar":"my","kind":13,"line":281,"definition":"my"},{"name":"$value","kind":13,"containerName":"location","line":281},{"line":283,"kind":13,"containerName":"location","name":"$value"},{"name":"$value","kind":13,"containerName":"location","line":284},{"name":"$value","kind":13,"containerName":"location","line":284},{"line":284,"containerName":"location","kind":12,"name":"isa"},{"name":"$self","kind":13,"containerName":"location","line":285},{"line":285,"kind":12,"containerName":"location","name":"throw"},{"kind":13,"containerName":"location","name":"$self","line":288},{"kind":13,"containerName":"location","name":"$value","line":288},{"name":"$self","containerName":"location","kind":13,"line":290},{"containerName":"location","kind":13,"name":"$self","line":292},{"containerName":"location","kind":12,"name":"new","line":292},{"name":"$self","containerName":"location","kind":13,"line":294}],"signature":{"label":"location($self,$value)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"range":{"end":{"line":295,"character":9999},"start":{"line":280,"character":0}},"line":280},{"line":292,"containerName":"Location::Simple","kind":12,"name":"Bio"},{"signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}],"label":"start($self,$value)"},"line":310,"range":{"start":{"character":0,"line":310},"end":{"line":313,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","localvar":"my","containerName":"start","kind":13,"name":"$self","line":311},{"line":311,"name":"$value","kind":13,"containerName":"start"},{"name":"$self","containerName":"start","kind":13,"line":312},{"name":"location","containerName":"start","kind":12,"line":312},{"name":"start","kind":12,"containerName":"start","line":312},{"line":312,"containerName":"start","kind":13,"name":"$value"}],"name":"start","containerName":"main::"},{"signature":{"label":"end($self,$value)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none","parameters":[{"label":"$self"},{"label":"$value"}]},"line":327,"kind":12,"range":{"end":{"line":330,"character":9999},"start":{"character":0,"line":327}},"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":328,"localvar":"my","containerName":"end","kind":13,"name":"$self"},{"containerName":"end","kind":13,"name":"$value","line":328},{"line":329,"name":"$self","containerName":"end","kind":13},{"name":"location","containerName":"end","kind":12,"line":329},{"containerName":"end","kind":12,"name":"end","line":329},{"line":329,"name":"$value","containerName":"end","kind":13}],"name":"end","containerName":"main::"},{"definition":"sub","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"length","name":"$self","line":345},{"kind":13,"containerName":"length","name":"$self","line":346},{"line":346,"name":"end","containerName":"length","kind":12},{"kind":13,"containerName":"length","name":"$self","line":346},{"name":"start","kind":12,"containerName":"length","line":346}],"containerName":"main::","name":"length","line":344,"kind":12,"range":{"start":{"line":344,"character":0},"end":{"character":9999,"line":347}}},{"line":361,"kind":12,"range":{"end":{"character":9999,"line":364},"start":{"character":0,"line":361}},"definition":"sub","children":[{"name":"$self","localvar":"my","containerName":"strand","kind":13,"line":362,"definition":"my"},{"name":"$self","containerName":"strand","kind":13,"line":363},{"kind":12,"containerName":"strand","name":"location","line":363},{"containerName":"strand","kind":12,"name":"strand","line":363}],"name":"strand","containerName":"main::"},{"containerName":"main::","name":"score","children":[{"definition":"my","line":379,"containerName":"score","localvar":"my","kind":13,"name":"$self"},{"definition":"my","name":"$value","kind":13,"localvar":"my","containerName":"score","line":382},{"containerName":"score","kind":13,"name":"$value","line":384},{"line":384,"kind":13,"containerName":"score","name":"$value"},{"line":384,"name":"$value","containerName":"score","kind":13},{"containerName":"score","kind":13,"name":"$value","line":385},{"line":385,"kind":13,"containerName":"score","name":"$value"},{"name":"$self","kind":13,"containerName":"score","line":386},{"name":"throw","kind":12,"containerName":"score","line":386},{"kind":13,"containerName":"score","name":"$value","line":388},{"line":390,"name":"$self","containerName":"score","kind":13},{"line":390,"name":"has_tag","kind":12,"containerName":"score"},{"line":391,"kind":13,"containerName":"score","name":"$self"},{"line":391,"containerName":"score","kind":12,"name":"warn"},{"line":392,"kind":13,"containerName":"score","name":"$self"},{"line":392,"name":"remove_tag","kind":12,"containerName":"score"},{"kind":13,"containerName":"score","name":"$self","line":394},{"name":"add_tag_value","kind":12,"containerName":"score","line":394},{"kind":13,"containerName":"score","name":"$value","line":394},{"definition":"my","line":396,"localvar":"my","kind":13,"containerName":"score","name":"$score"},{"name":"$self","kind":13,"containerName":"score","line":396},{"line":396,"name":"has_tag","containerName":"score","kind":12},{"line":396,"name":"$self","containerName":"score","kind":13},{"kind":12,"containerName":"score","name":"get_tag_values","line":396},{"line":397,"name":"$score","kind":13,"containerName":"score"}],"definition":"sub","kind":12,"range":{"start":{"line":378,"character":0},"end":{"line":398,"character":9999}},"line":378},{"range":{"end":{"line":425,"character":9999},"start":{"line":412,"character":0}},"kind":12,"line":412,"name":"frame","containerName":"main::","children":[{"line":413,"name":"$self","localvar":"my","kind":13,"containerName":"frame","definition":"my"},{"definition":"my","line":416,"name":"$value","localvar":"my","kind":13,"containerName":"frame"},{"containerName":"frame","kind":13,"name":"$value","line":417},{"kind":13,"containerName":"frame","name":"$value","line":418},{"kind":13,"containerName":"frame","name":"$self","line":419},{"kind":12,"containerName":"frame","name":"throw","line":419},{"line":421,"name":"$value","kind":13,"containerName":"frame"},{"name":"$value","containerName":"frame","kind":13,"line":421},{"line":421,"name":"$value","kind":13,"containerName":"frame"},{"containerName":"frame","kind":13,"name":"$self","line":422},{"line":422,"name":"$value","containerName":"frame","kind":13},{"line":424,"name":"$self","kind":13,"containerName":"frame"}],"definition":"sub"},{"definition":"sub","children":[{"line":441,"localvar":"my","containerName":"primary_tag","kind":13,"name":"$self","definition":"my"},{"line":442,"containerName":"primary_tag","kind":13,"name":"$self"},{"line":443,"kind":13,"containerName":"primary_tag","name":"$self"}],"name":"primary_tag","containerName":"main::","line":440,"range":{"end":{"character":9999,"line":444},"start":{"line":440,"character":0}},"kind":12},{"line":459,"range":{"start":{"line":459,"character":0},"end":{"line":463,"character":9999}},"kind":12,"definition":"sub","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"source_tag","name":"$self","line":460},{"line":461,"name":"$self","containerName":"source_tag","kind":13},{"line":462,"name":"$self","containerName":"source_tag","kind":13}],"name":"source_tag","containerName":"main::"},{"signature":{"label":"has_tag($self,$tag)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag","parameters":[{"label":"$self"},{"label":"$tag"}]},"line":477,"kind":12,"range":{"end":{"line":480,"character":9999},"start":{"line":477,"character":0}},"definition":"sub","detail":"($self,$tag)","children":[{"line":478,"name":"$self","kind":13,"localvar":"my","containerName":"has_tag","definition":"my"},{"line":478,"name":"$tag","containerName":"has_tag","kind":13},{"name":"$self","containerName":"has_tag","kind":13,"line":479},{"line":479,"kind":13,"containerName":"has_tag","name":"$tag"}],"name":"has_tag","containerName":"main::"},{"definition":"sub","containerName":"main::","name":"add_tag_value","children":[{"name":"$self","containerName":"add_tag_value","localvar":"my","kind":13,"line":493,"definition":"my"},{"containerName":"add_tag_value","localvar":"my","kind":13,"name":"$tag","line":494,"definition":"my"},{"line":495,"name":"$self","containerName":"add_tag_value","kind":13},{"kind":13,"containerName":"add_tag_value","name":"$tag","line":495},{"name":"$self","kind":13,"containerName":"add_tag_value","line":496},{"kind":13,"containerName":"add_tag_value","name":"$tag","line":496}],"range":{"start":{"line":492,"character":0},"end":{"character":9999,"line":496}},"kind":12,"line":492},{"signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"get_tag_values($self,$tag)"},"line":512,"range":{"end":{"character":9999,"line":519},"start":{"character":0,"line":512}},"kind":12,"definition":"sub","detail":"($self,$tag)","children":[{"definition":"my","line":513,"containerName":"get_tag_values","localvar":"my","kind":13,"name":"$self"},{"containerName":"get_tag_values","kind":13,"name":"$tag","line":513},{"kind":13,"containerName":"get_tag_values","name":"$tag","line":515},{"containerName":"get_tag_values","kind":13,"name":"$self","line":516},{"line":516,"name":"$tag","containerName":"get_tag_values","kind":13},{"line":517,"name":"$self","containerName":"get_tag_values","kind":13},{"line":517,"containerName":"get_tag_values","kind":12,"name":"throw"},{"line":519,"containerName":"get_tag_values","kind":13,"name":"$self"},{"kind":13,"containerName":"get_tag_values","name":"$tag","line":519}],"name":"get_tag_values","containerName":"main::"},{"definition":"sub","detail":"($self,@args)","children":[{"localvar":"my","containerName":"get_all_tags","kind":13,"name":"$self","line":539,"definition":"my"},{"line":539,"kind":13,"containerName":"get_all_tags","name":"@args"},{"name":"$self","kind":13,"containerName":"get_all_tags","line":540}],"containerName":"main::","name":"get_all_tags","signature":{"label":"get_all_tags($self,@args)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js","parameters":[{"label":"$self"},{"label":"@args"}]},"line":538,"kind":12,"range":{"end":{"character":9999,"line":540},"start":{"line":538,"character":0}}},{"definition":"sub","detail":"($self,$tag)","children":[{"name":"$self","localvar":"my","containerName":"remove_tag","kind":13,"line":555,"definition":"my"},{"line":555,"containerName":"remove_tag","kind":13,"name":"$tag"},{"line":557,"name":"$self","kind":13,"containerName":"remove_tag"},{"line":557,"name":"$tag","containerName":"remove_tag","kind":13},{"line":558,"name":"$self","kind":13,"containerName":"remove_tag"},{"kind":12,"containerName":"remove_tag","name":"throw","line":558},{"line":560,"name":"@vals","localvar":"my","containerName":"remove_tag","kind":13,"definition":"my"},{"line":560,"name":"$self","containerName":"remove_tag","kind":13},{"line":560,"name":"$tag","containerName":"remove_tag","kind":13}],"name":"remove_tag","containerName":"main::","signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)","parameters":[{"label":"$self"},{"label":"$tag"}],"label":"remove_tag($self,$tag)"},"line":554,"kind":12,"range":{"end":{"line":560,"character":9999},"start":{"line":554,"character":0}}},{"kind":13,"containerName":null,"name":"%self","line":561},{"kind":13,"containerName":null,"name":"$tag","line":561},{"containerName":null,"kind":13,"name":"@vals","line":562},{"line":579,"kind":12,"range":{"end":{"character":9999,"line":593},"start":{"line":579,"character":0}},"signature":{"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"attach_seq($self,$seq)"},"children":[{"localvar":"my","containerName":"attach_seq","kind":13,"name":"$self","line":580,"definition":"my"},{"line":580,"name":"$seq","kind":13,"containerName":"attach_seq"},{"line":582,"kind":13,"containerName":"attach_seq","name":"$seq"},{"line":582,"containerName":"attach_seq","kind":13,"name":"$seq"},{"line":582,"containerName":"attach_seq","kind":13,"name":"$seq"},{"line":582,"containerName":"attach_seq","kind":12,"name":"isa"},{"line":583,"name":"$self","kind":13,"containerName":"attach_seq"},{"containerName":"attach_seq","kind":12,"name":"throw","line":583},{"line":586,"name":"$self","containerName":"attach_seq","kind":13},{"line":586,"name":"$seq","containerName":"attach_seq","kind":13},{"line":589,"name":"$self","kind":13,"containerName":"attach_seq"},{"name":"sub_SeqFeature","containerName":"attach_seq","kind":12,"line":589},{"containerName":"attach_seq","kind":12,"name":"attach_seq","line":590},{"line":590,"containerName":"attach_seq","kind":13,"name":"$seq"}],"containerName":"main::","name":"attach_seq","definition":"sub","detail":"($self,$seq)"},{"line":608,"range":{"start":{"character":0,"line":608},"end":{"line":635,"character":9999}},"kind":12,"signature":{"label":"seq($self,$arg)","parameters":[{"label":"$self"},{"label":"$arg"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none"},"children":[{"line":609,"containerName":"seq","localvar":"my","kind":13,"name":"$self","definition":"my"},{"kind":13,"containerName":"seq","name":"$arg","line":609},{"containerName":"seq","kind":13,"name":"$arg","line":611},{"line":612,"kind":13,"containerName":"seq","name":"$self"},{"line":612,"kind":12,"containerName":"seq","name":"throw"},{"line":615,"name":"$self","kind":13,"containerName":"seq"},{"line":622,"kind":13,"localvar":"my","containerName":"seq","name":"$seq","definition":"my"},{"name":"$self","kind":13,"containerName":"seq","line":622},{"line":622,"containerName":"seq","kind":12,"name":"trunc"},{"line":622,"containerName":"seq","kind":13,"name":"$self"},{"line":622,"name":"start","containerName":"seq","kind":12},{"line":622,"name":"$self","kind":13,"containerName":"seq"},{"kind":12,"containerName":"seq","name":"end","line":622},{"line":625,"containerName":"seq","kind":13,"name":"$self"},{"kind":12,"containerName":"seq","name":"strand","line":625},{"containerName":"seq","kind":13,"name":"$self","line":626},{"line":626,"kind":12,"containerName":"seq","name":"strand"},{"line":630,"containerName":"seq","kind":13,"name":"$seq"},{"name":"$seq","kind":13,"containerName":"seq","line":630},{"line":630,"name":"revcom","containerName":"seq","kind":12},{"name":"$seq","kind":13,"containerName":"seq","line":634}],"name":"seq","containerName":"main::","definition":"sub","detail":"($self,$arg)"},{"kind":12,"range":{"start":{"character":0,"line":650},"end":{"character":9999,"line":652}},"line":650,"definition":"sub","containerName":"main::","name":"entire_seq","children":[]},{"definition":"sub","name":"seq_id","containerName":"main::","children":[{"definition":"my","line":674,"name":"$obj","kind":13,"localvar":"my","containerName":"seq_id"},{"name":"$obj","containerName":"seq_id","kind":13,"line":675},{"kind":13,"containerName":"seq_id","name":"$obj","line":676}],"kind":12,"range":{"start":{"line":673,"character":0},"end":{"character":9999,"line":677}},"line":673},{"children":[{"definition":"my","containerName":"display_name","localvar":"my","kind":13,"name":"$self","line":691},{"name":"$self","kind":13,"containerName":"display_name","line":692},{"line":693,"name":"$self","containerName":"display_name","kind":13}],"containerName":"main::","name":"display_name","definition":"sub","line":690,"kind":12,"range":{"start":{"character":0,"line":690},"end":{"line":694,"character":9999}}},{"children":[{"name":"$obj","localvar":"my","kind":13,"containerName":"annotation","line":715,"definition":"my"},{"line":715,"name":"$value","containerName":"annotation","kind":13},{"line":719,"name":"$value","kind":13,"containerName":"annotation"},{"kind":13,"containerName":"annotation","name":"$obj","line":719},{"kind":13,"containerName":"annotation","name":"$value","line":720},{"kind":12,"containerName":"annotation","name":"new","line":720},{"line":720,"name":"$value","kind":13,"containerName":"annotation"},{"line":721,"name":"$obj","kind":13,"containerName":"annotation"},{"name":"$value","containerName":"annotation","kind":13,"line":721},{"containerName":"annotation","kind":13,"name":"$obj","line":723}],"name":"annotation","containerName":"main::","definition":"sub","detail":"($obj,$value)","line":714,"kind":12,"range":{"end":{"line":724,"character":9999},"start":{"character":0,"line":714}},"signature":{"label":"annotation($obj,$value)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::Generic->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( defined $self->strand &&\n\t$self->strand == -1 ) {\n\n       # ok. this does not work well (?)\n       #print STDERR \"Before revcom\", $seq->str, \"\\n\";\n       $seq = $seq->revcom;\n       #print STDERR \"After  revcom\", $seq->str, \"\\n\";\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    :\n\n\n\nsub entire_seq {\n   return shift->{'_gsf_seq'};\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    my $obj = shift;\n    return $obj->{'_gsf_seq_id'} = shift if @_;\n    return $obj->{'_gsf_seq_id'};\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $featname = $obj->display_name\n Function: Implements the display_name() method, which is a human-readable\n           name for the feature. \n Returns : value of display_name (a string)\n Args    : Optionally, on set the new value or undef \n\n\nsub display_name{\n    my $self = shift;\n    return $self->{'display_name'} = shift if @_;\n    return $self->{'display_name'};\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n\n Example : \n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)","parameters":[{"label":"$obj"},{"label":"$value"}]}},{"line":720,"kind":12,"containerName":"Annotation::Collection","name":"Bio"},{"children":[],"containerName":"main::","name":"get_SeqFeatures","definition":"sub","line":745,"range":{"end":{"character":9999,"line":746},"start":{"line":745,"character":0}},"kind":12},{"name":"shift","kind":12,"line":746},{"range":{"start":{"line":769,"character":0},"end":{"line":788,"character":9999}},"kind":12,"line":769,"signature":{"parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$expand"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::Generic->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( defined $self->strand &&\n\t$self->strand == -1 ) {\n\n       # ok. this does not work well (?)\n       #print STDERR \"Before revcom\", $seq->str, \"\\n\";\n       $seq = $seq->revcom;\n       #print STDERR \"After  revcom\", $seq->str, \"\\n\";\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    :\n\n\n\nsub entire_seq {\n   return shift->{'_gsf_seq'};\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    my $obj = shift;\n    return $obj->{'_gsf_seq_id'} = shift if @_;\n    return $obj->{'_gsf_seq_id'};\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $featname = $obj->display_name\n Function: Implements the display_name() method, which is a human-readable\n           name for the feature. \n Returns : value of display_name (a string)\n Args    : Optionally, on set the new value or undef \n\n\nsub display_name{\n    my $self = shift;\n    return $self->{'display_name'} = shift if @_;\n    return $self->{'display_name'};\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n\n Example : \n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\n\nsub get_SeqFeatures {\n    return @{ shift->{'_gsf_sub_array'} || []};    \n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: Adds a SeqFeature into the subSeqFeature array.\n           With no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent's start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n\n\n'","label":"add_SeqFeature($self,$feat,$expand)"},"containerName":"main::","name":"add_SeqFeature","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"add_SeqFeature","line":770,"definition":"my"},{"name":"$feat","kind":13,"containerName":"add_SeqFeature","line":770},{"name":"$expand","containerName":"add_SeqFeature","kind":13,"line":770},{"name":"$feat","containerName":"add_SeqFeature","kind":13,"line":771},{"line":772,"name":"$self","kind":13,"containerName":"add_SeqFeature"},{"name":"warn","containerName":"add_SeqFeature","kind":12,"line":772},{"kind":13,"containerName":"add_SeqFeature","name":"$feat","line":775},{"line":775,"kind":12,"containerName":"add_SeqFeature","name":"isa"},{"line":776,"containerName":"add_SeqFeature","kind":13,"name":"$self"},{"line":776,"name":"warn","kind":12,"containerName":"add_SeqFeature"},{"kind":13,"containerName":"add_SeqFeature","name":"$expand","line":779},{"line":779,"kind":13,"containerName":"add_SeqFeature","name":"$expand"},{"name":"$self","containerName":"add_SeqFeature","kind":13,"line":780},{"kind":12,"containerName":"add_SeqFeature","name":"_expand_region","line":780},{"line":780,"name":"$feat","containerName":"add_SeqFeature","kind":13},{"name":"$self","kind":13,"containerName":"add_SeqFeature","line":782},{"kind":12,"containerName":"add_SeqFeature","name":"contains","line":782},{"name":"$feat","kind":13,"containerName":"add_SeqFeature","line":782},{"name":"$self","kind":13,"containerName":"add_SeqFeature","line":783},{"kind":12,"containerName":"add_SeqFeature","name":"throw","line":783},{"line":787,"name":"$self","kind":13,"containerName":"add_SeqFeature"},{"line":787,"name":"$self","kind":13,"containerName":"add_SeqFeature"},{"line":788,"name":"$self","kind":13,"containerName":"add_SeqFeature"}],"detail":"($self,$feat,$expand)","definition":"sub"},{"line":788,"containerName":null,"kind":13,"name":"$feat"},{"containerName":"main::","name":"remove_SeqFeatures","children":[{"definition":"my","line":809,"containerName":"remove_SeqFeatures","localvar":"my","kind":13,"name":"$self"},{"definition":"my","line":811,"containerName":"remove_SeqFeatures","localvar":"my","kind":13,"name":"@subfeats"},{"line":811,"containerName":"remove_SeqFeatures","kind":13,"name":"$self"}],"detail":"($self)","definition":"sub","range":{"end":{"line":811,"character":9999},"start":{"line":808,"character":0}},"kind":12,"line":808,"signature":{"label":"remove_SeqFeatures($self)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::Generic->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( defined $self->strand &&\n\t$self->strand == -1 ) {\n\n       # ok. this does not work well (?)\n       #print STDERR \"Before revcom\", $seq->str, \"\\n\";\n       $seq = $seq->revcom;\n       #print STDERR \"After  revcom\", $seq->str, \"\\n\";\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    :\n\n\n\nsub entire_seq {\n   return shift->{'_gsf_seq'};\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    my $obj = shift;\n    return $obj->{'_gsf_seq_id'} = shift if @_;\n    return $obj->{'_gsf_seq_id'};\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $featname = $obj->display_name\n Function: Implements the display_name() method, which is a human-readable\n           name for the feature. \n Returns : value of display_name (a string)\n Args    : Optionally, on set the new value or undef \n\n\nsub display_name{\n    my $self = shift;\n    return $self->{'display_name'} = shift if @_;\n    return $self->{'display_name'};\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n\n Example : \n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\n\nsub get_SeqFeatures {\n    return @{ shift->{'_gsf_sub_array'} || []};    \n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: Adds a SeqFeature into the subSeqFeature array.\n           With no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent's start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n\n\n\n#'\nsub add_SeqFeature{\n    my ($self,$feat,$expand) = @_;\n    unless( defined $feat ) {\n\t$self->warn(\"Called add_SeqFeature with no feature, ignoring\");\n\treturn;\n    }\n    if ( !$feat->isa('Bio::SeqFeatureI') ) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI. Will add it anyway, but beware...\");\n    }\n\n    if($expand && ($expand eq 'EXPAND')) {\n        $self->_expand_region($feat);\n    } else {\n        if ( !$self->contains($feat) ) {\n            $self->throw(\"$feat is not contained within parent feature, and expansion is not valid\");\n        }\n    }\n\n    $self->{'_gsf_sub_array'} = [] unless exists($self->{'_gsf_sub_array'});\n    push(@{$self->{'_gsf_sub_array'}},$feat);\n\n}\n\n=head2 remove_SeqFeatures\n\n Title   : remove_SeqFeatures\n Usage   : $sf->remove_SeqFeatures\n Function: Removes all SeqFeatures\n\n           If you want to remove only a subset of features then remove that \n           subset from the returned array, and add back the rest.\n Example :\n Returns : The array of Bio::SeqFeatureI implementing features that was\n           deleted.\n Args    : none","parameters":[{"label":"$self"}]}},{"containerName":null,"kind":13,"name":"%self","line":812},{"name":"@subfeats","kind":13,"containerName":null,"line":813},{"children":[{"line":841,"name":"$self","kind":13,"localvar":"my","containerName":"gff_format","definition":"my"},{"name":"$gffio","containerName":"gff_format","kind":13,"line":841},{"kind":13,"containerName":"gff_format","name":"$gffio","line":843},{"containerName":"gff_format","kind":13,"name":"$self","line":844},{"containerName":"gff_format","kind":13,"name":"$self","line":845},{"line":845,"containerName":"gff_format","kind":13,"name":"$gffio"},{"kind":13,"containerName":"gff_format","name":"$Bio","line":847},{"containerName":"gff_format","kind":13,"name":"$gffio","line":847},{"name":"$self","containerName":"gff_format","kind":13,"line":850},{"line":850,"containerName":"gff_format","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"gff_format","line":851},{"line":851,"containerName":"gff_format","kind":13,"name":"$self"},{"line":851,"kind":12,"containerName":"gff_format","name":"_static_gff_formatter"}],"name":"gff_format","containerName":"main::","definition":"sub","detail":"($self,$gffio)","line":840,"kind":12,"range":{"end":{"line":852,"character":9999},"start":{"line":840,"character":0}},"signature":{"label":"gff_format($self,$gffio)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::Generic->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( defined $self->strand &&\n\t$self->strand == -1 ) {\n\n       # ok. this does not work well (?)\n       #print STDERR \"Before revcom\", $seq->str, \"\\n\";\n       $seq = $seq->revcom;\n       #print STDERR \"After  revcom\", $seq->str, \"\\n\";\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    :\n\n\n\nsub entire_seq {\n   return shift->{'_gsf_seq'};\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    my $obj = shift;\n    return $obj->{'_gsf_seq_id'} = shift if @_;\n    return $obj->{'_gsf_seq_id'};\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $featname = $obj->display_name\n Function: Implements the display_name() method, which is a human-readable\n           name for the feature. \n Returns : value of display_name (a string)\n Args    : Optionally, on set the new value or undef \n\n\nsub display_name{\n    my $self = shift;\n    return $self->{'display_name'} = shift if @_;\n    return $self->{'display_name'};\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n\n Example : \n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\n\nsub get_SeqFeatures {\n    return @{ shift->{'_gsf_sub_array'} || []};    \n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: Adds a SeqFeature into the subSeqFeature array.\n           With no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent's start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n\n\n\n#'\nsub add_SeqFeature{\n    my ($self,$feat,$expand) = @_;\n    unless( defined $feat ) {\n\t$self->warn(\"Called add_SeqFeature with no feature, ignoring\");\n\treturn;\n    }\n    if ( !$feat->isa('Bio::SeqFeatureI') ) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI. Will add it anyway, but beware...\");\n    }\n\n    if($expand && ($expand eq 'EXPAND')) {\n        $self->_expand_region($feat);\n    } else {\n        if ( !$self->contains($feat) ) {\n            $self->throw(\"$feat is not contained within parent feature, and expansion is not valid\");\n        }\n    }\n\n    $self->{'_gsf_sub_array'} = [] unless exists($self->{'_gsf_sub_array'});\n    push(@{$self->{'_gsf_sub_array'}},$feat);\n\n}\n\n=head2 remove_SeqFeatures\n\n Title   : remove_SeqFeatures\n Usage   : $sf->remove_SeqFeatures\n Function: Removes all SeqFeatures\n\n           If you want to remove only a subset of features then remove that \n           subset from the returned array, and add back the rest.\n Example :\n Returns : The array of Bio::SeqFeatureI implementing features that was\n           deleted.\n Args    : none\n\n\n\nsub remove_SeqFeatures {\n   my ($self) = @_;\n\n   my @subfeats = @{$self->{'_gsf_sub_array'} || []};\n   $self->{'_gsf_sub_array'} = []; # zap the array implicitly.\n   return @subfeats;\n}\n\n=head1 GFF-related methods\n\n\n=head2 gff_format\n\n Title   : gff_format\n Usage   : # get:\n           $gffio = $feature->gff_format();\n           # set (change the default version of GFF2):\n           $feature->gff_format(Bio::Tools::GFF->new(-gff_version => 1));\n Function: Get/set the GFF format interpreter. This object is supposed to \n           format and parse GFF. See Bio::Tools::GFF for the interface.\n\n           If this method is called as class method, the default for all\n           newly created instances will be changed. Otherwise only this\n           instance will be affected.\n Example : \n Returns : a Bio::Tools::GFF compliant object\n Args    : On set, an instance of Bio::Tools::GFF or a derived object.","parameters":[{"label":"$self"},{"label":"$gffio"}]}},{"name":"SeqFeatureI","kind":12,"containerName":"static_gff_formatter","line":847},{"definition":"sub","detail":"($self,$formatter)","children":[{"line":871,"name":"$self","localvar":"my","kind":13,"containerName":"gff_string","definition":"my"},{"line":871,"containerName":"gff_string","kind":13,"name":"$formatter"},{"line":873,"kind":13,"containerName":"gff_string","name":"$formatter"},{"line":873,"kind":13,"containerName":"gff_string","name":"$self"},{"line":873,"kind":12,"containerName":"gff_string","name":"gff_format"},{"line":873,"kind":13,"containerName":"gff_string","name":"$formatter"},{"line":874,"name":"$formatter","containerName":"gff_string","kind":13},{"line":874,"kind":12,"containerName":"gff_string","name":"gff_string"},{"line":874,"name":"$self","kind":13,"containerName":"gff_string"}],"name":"gff_string","containerName":"main::","signature":{"label":"gff_string($self,$formatter)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::Generic->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( defined $self->strand &&\n\t$self->strand == -1 ) {\n\n       # ok. this does not work well (?)\n       #print STDERR \"Before revcom\", $seq->str, \"\\n\";\n       $seq = $seq->revcom;\n       #print STDERR \"After  revcom\", $seq->str, \"\\n\";\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    :\n\n\n\nsub entire_seq {\n   return shift->{'_gsf_seq'};\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    my $obj = shift;\n    return $obj->{'_gsf_seq_id'} = shift if @_;\n    return $obj->{'_gsf_seq_id'};\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $featname = $obj->display_name\n Function: Implements the display_name() method, which is a human-readable\n           name for the feature. \n Returns : value of display_name (a string)\n Args    : Optionally, on set the new value or undef \n\n\nsub display_name{\n    my $self = shift;\n    return $self->{'display_name'} = shift if @_;\n    return $self->{'display_name'};\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n\n Example : \n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\n\nsub get_SeqFeatures {\n    return @{ shift->{'_gsf_sub_array'} || []};    \n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: Adds a SeqFeature into the subSeqFeature array.\n           With no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent's start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n\n\n\n#'\nsub add_SeqFeature{\n    my ($self,$feat,$expand) = @_;\n    unless( defined $feat ) {\n\t$self->warn(\"Called add_SeqFeature with no feature, ignoring\");\n\treturn;\n    }\n    if ( !$feat->isa('Bio::SeqFeatureI') ) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI. Will add it anyway, but beware...\");\n    }\n\n    if($expand && ($expand eq 'EXPAND')) {\n        $self->_expand_region($feat);\n    } else {\n        if ( !$self->contains($feat) ) {\n            $self->throw(\"$feat is not contained within parent feature, and expansion is not valid\");\n        }\n    }\n\n    $self->{'_gsf_sub_array'} = [] unless exists($self->{'_gsf_sub_array'});\n    push(@{$self->{'_gsf_sub_array'}},$feat);\n\n}\n\n=head2 remove_SeqFeatures\n\n Title   : remove_SeqFeatures\n Usage   : $sf->remove_SeqFeatures\n Function: Removes all SeqFeatures\n\n           If you want to remove only a subset of features then remove that \n           subset from the returned array, and add back the rest.\n Example :\n Returns : The array of Bio::SeqFeatureI implementing features that was\n           deleted.\n Args    : none\n\n\n\nsub remove_SeqFeatures {\n   my ($self) = @_;\n\n   my @subfeats = @{$self->{'_gsf_sub_array'} || []};\n   $self->{'_gsf_sub_array'} = []; # zap the array implicitly.\n   return @subfeats;\n}\n\n=head1 GFF-related methods\n\n\n=head2 gff_format\n\n Title   : gff_format\n Usage   : # get:\n           $gffio = $feature->gff_format();\n           # set (change the default version of GFF2):\n           $feature->gff_format(Bio::Tools::GFF->new(-gff_version => 1));\n Function: Get/set the GFF format interpreter. This object is supposed to \n           format and parse GFF. See Bio::Tools::GFF for the interface.\n\n           If this method is called as class method, the default for all\n           newly created instances will be changed. Otherwise only this\n           instance will be affected.\n Example : \n Returns : a Bio::Tools::GFF compliant object\n Args    : On set, an instance of Bio::Tools::GFF or a derived object.\n\n\n\nsub gff_format {\n    my ($self, $gffio) = @_;\n\n    if(defined($gffio)) {\n        if(ref($self)) {\n            $self->{'_gffio'} = $gffio;\n        } else {\n            $Bio::SeqFeatureI::static_gff_formatter = $gffio;\n        }\n    }\n    return (ref($self) && exists($self->{'_gffio'}) ?\n            $self->{'_gffio'} : $self->_static_gff_formatter);\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           We override this here from Bio::SeqFeatureI in order to use the\n           formatter returned by gff_format().\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().","parameters":[{"label":"$self"},{"label":"$formatter"}]},"line":870,"kind":12,"range":{"start":{"character":0,"line":870},"end":{"character":9999,"line":875}}},{"children":[{"definition":"my","line":894,"localvar":"my","containerName":"slurp_gff_file","kind":13,"name":"$f"},{"line":895,"containerName":"slurp_gff_file","localvar":"my","kind":13,"name":"@out","definition":"my"},{"containerName":"slurp_gff_file","kind":13,"name":"$f","line":896},{"containerName":"slurp_gff_file","kind":12,"name":"throw","line":897},{"line":900,"name":"deprecated","containerName":"slurp_gff_file","kind":12},{"line":905,"name":"$f","containerName":"slurp_gff_file","kind":13},{"definition":"my","line":906,"name":"$sf","containerName":"slurp_gff_file","localvar":"my","kind":13},{"line":906,"name":"new","containerName":"slurp_gff_file","kind":12},{"containerName":"slurp_gff_file","kind":13,"name":"@out","line":907},{"name":"$sf","kind":13,"containerName":"slurp_gff_file","line":907},{"line":910,"containerName":"slurp_gff_file","kind":13,"name":"@out"}],"name":"slurp_gff_file","containerName":"main::","definition":"sub","detail":"($f)","line":893,"kind":12,"range":{"start":{"line":893,"character":0},"end":{"line":911,"character":9999}},"signature":{"label":"slurp_gff_file($f)","documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::Generic->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( defined $self->strand &&\n\t$self->strand == -1 ) {\n\n       # ok. this does not work well (?)\n       #print STDERR \"Before revcom\", $seq->str, \"\\n\";\n       $seq = $seq->revcom;\n       #print STDERR \"After  revcom\", $seq->str, \"\\n\";\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    :\n\n\n\nsub entire_seq {\n   return shift->{'_gsf_seq'};\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    my $obj = shift;\n    return $obj->{'_gsf_seq_id'} = shift if @_;\n    return $obj->{'_gsf_seq_id'};\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $featname = $obj->display_name\n Function: Implements the display_name() method, which is a human-readable\n           name for the feature. \n Returns : value of display_name (a string)\n Args    : Optionally, on set the new value or undef \n\n\nsub display_name{\n    my $self = shift;\n    return $self->{'display_name'} = shift if @_;\n    return $self->{'display_name'};\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n\n Example : \n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\n\nsub get_SeqFeatures {\n    return @{ shift->{'_gsf_sub_array'} || []};    \n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: Adds a SeqFeature into the subSeqFeature array.\n           With no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent's start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n\n\n\n#'\nsub add_SeqFeature{\n    my ($self,$feat,$expand) = @_;\n    unless( defined $feat ) {\n\t$self->warn(\"Called add_SeqFeature with no feature, ignoring\");\n\treturn;\n    }\n    if ( !$feat->isa('Bio::SeqFeatureI') ) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI. Will add it anyway, but beware...\");\n    }\n\n    if($expand && ($expand eq 'EXPAND')) {\n        $self->_expand_region($feat);\n    } else {\n        if ( !$self->contains($feat) ) {\n            $self->throw(\"$feat is not contained within parent feature, and expansion is not valid\");\n        }\n    }\n\n    $self->{'_gsf_sub_array'} = [] unless exists($self->{'_gsf_sub_array'});\n    push(@{$self->{'_gsf_sub_array'}},$feat);\n\n}\n\n=head2 remove_SeqFeatures\n\n Title   : remove_SeqFeatures\n Usage   : $sf->remove_SeqFeatures\n Function: Removes all SeqFeatures\n\n           If you want to remove only a subset of features then remove that \n           subset from the returned array, and add back the rest.\n Example :\n Returns : The array of Bio::SeqFeatureI implementing features that was\n           deleted.\n Args    : none\n\n\n\nsub remove_SeqFeatures {\n   my ($self) = @_;\n\n   my @subfeats = @{$self->{'_gsf_sub_array'} || []};\n   $self->{'_gsf_sub_array'} = []; # zap the array implicitly.\n   return @subfeats;\n}\n\n=head1 GFF-related methods\n\n\n=head2 gff_format\n\n Title   : gff_format\n Usage   : # get:\n           $gffio = $feature->gff_format();\n           # set (change the default version of GFF2):\n           $feature->gff_format(Bio::Tools::GFF->new(-gff_version => 1));\n Function: Get/set the GFF format interpreter. This object is supposed to \n           format and parse GFF. See Bio::Tools::GFF for the interface.\n\n           If this method is called as class method, the default for all\n           newly created instances will be changed. Otherwise only this\n           instance will be affected.\n Example : \n Returns : a Bio::Tools::GFF compliant object\n Args    : On set, an instance of Bio::Tools::GFF or a derived object.\n\n\n\nsub gff_format {\n    my ($self, $gffio) = @_;\n\n    if(defined($gffio)) {\n        if(ref($self)) {\n            $self->{'_gffio'} = $gffio;\n        } else {\n            $Bio::SeqFeatureI::static_gff_formatter = $gffio;\n        }\n    }\n    return (ref($self) && exists($self->{'_gffio'}) ?\n            $self->{'_gffio'} : $self->_static_gff_formatter);\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           We override this here from Bio::SeqFeatureI in order to use the\n           formatter returned by gff_format().\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().\n\n\n\nsub gff_string{\n   my ($self,$formatter) = @_;\n\n   $formatter = $self->gff_format() unless $formatter;\n   return $formatter->gff_string($self);\n}\n\n=head2 slurp_gff_file\n\n Title   : slurp_file\n Usage   : @features = Bio::SeqFeature::Generic::slurp_gff_file(\\*FILE);\n Function: Sneaky function to load an entire file as in memory objects.\n           Beware of big files.\n\n           This method is deprecated. Use Bio::Tools::GFF instead, which can\n           also handle large files.\n\n Example :\n Returns :\n Args    :","parameters":[{"label":"$f"}]}},{"line":897,"name":"Bio","kind":12,"containerName":"Root::Root"},{"line":900,"containerName":"Root::Root","kind":12,"name":"Bio"},{"line":906,"name":"Bio","containerName":"SeqFeature::Generic","kind":12},{"signature":{"label":"_from_gff_string($self,$string)","parameters":[{"label":"$self"},{"label":"$string"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::Generic->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( defined $self->strand &&\n\t$self->strand == -1 ) {\n\n       # ok. this does not work well (?)\n       #print STDERR \"Before revcom\", $seq->str, \"\\n\";\n       $seq = $seq->revcom;\n       #print STDERR \"After  revcom\", $seq->str, \"\\n\";\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    :\n\n\n\nsub entire_seq {\n   return shift->{'_gsf_seq'};\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    my $obj = shift;\n    return $obj->{'_gsf_seq_id'} = shift if @_;\n    return $obj->{'_gsf_seq_id'};\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $featname = $obj->display_name\n Function: Implements the display_name() method, which is a human-readable\n           name for the feature. \n Returns : value of display_name (a string)\n Args    : Optionally, on set the new value or undef \n\n\nsub display_name{\n    my $self = shift;\n    return $self->{'display_name'} = shift if @_;\n    return $self->{'display_name'};\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n\n Example : \n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\n\nsub get_SeqFeatures {\n    return @{ shift->{'_gsf_sub_array'} || []};    \n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: Adds a SeqFeature into the subSeqFeature array.\n           With no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent's start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n\n\n\n#'\nsub add_SeqFeature{\n    my ($self,$feat,$expand) = @_;\n    unless( defined $feat ) {\n\t$self->warn(\"Called add_SeqFeature with no feature, ignoring\");\n\treturn;\n    }\n    if ( !$feat->isa('Bio::SeqFeatureI') ) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI. Will add it anyway, but beware...\");\n    }\n\n    if($expand && ($expand eq 'EXPAND')) {\n        $self->_expand_region($feat);\n    } else {\n        if ( !$self->contains($feat) ) {\n            $self->throw(\"$feat is not contained within parent feature, and expansion is not valid\");\n        }\n    }\n\n    $self->{'_gsf_sub_array'} = [] unless exists($self->{'_gsf_sub_array'});\n    push(@{$self->{'_gsf_sub_array'}},$feat);\n\n}\n\n=head2 remove_SeqFeatures\n\n Title   : remove_SeqFeatures\n Usage   : $sf->remove_SeqFeatures\n Function: Removes all SeqFeatures\n\n           If you want to remove only a subset of features then remove that \n           subset from the returned array, and add back the rest.\n Example :\n Returns : The array of Bio::SeqFeatureI implementing features that was\n           deleted.\n Args    : none\n\n\n\nsub remove_SeqFeatures {\n   my ($self) = @_;\n\n   my @subfeats = @{$self->{'_gsf_sub_array'} || []};\n   $self->{'_gsf_sub_array'} = []; # zap the array implicitly.\n   return @subfeats;\n}\n\n=head1 GFF-related methods\n\n\n=head2 gff_format\n\n Title   : gff_format\n Usage   : # get:\n           $gffio = $feature->gff_format();\n           # set (change the default version of GFF2):\n           $feature->gff_format(Bio::Tools::GFF->new(-gff_version => 1));\n Function: Get/set the GFF format interpreter. This object is supposed to \n           format and parse GFF. See Bio::Tools::GFF for the interface.\n\n           If this method is called as class method, the default for all\n           newly created instances will be changed. Otherwise only this\n           instance will be affected.\n Example : \n Returns : a Bio::Tools::GFF compliant object\n Args    : On set, an instance of Bio::Tools::GFF or a derived object.\n\n\n\nsub gff_format {\n    my ($self, $gffio) = @_;\n\n    if(defined($gffio)) {\n        if(ref($self)) {\n            $self->{'_gffio'} = $gffio;\n        } else {\n            $Bio::SeqFeatureI::static_gff_formatter = $gffio;\n        }\n    }\n    return (ref($self) && exists($self->{'_gffio'}) ?\n            $self->{'_gffio'} : $self->_static_gff_formatter);\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           We override this here from Bio::SeqFeatureI in order to use the\n           formatter returned by gff_format().\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().\n\n\n\nsub gff_string{\n   my ($self,$formatter) = @_;\n\n   $formatter = $self->gff_format() unless $formatter;\n   return $formatter->gff_string($self);\n}\n\n=head2 slurp_gff_file\n\n Title   : slurp_file\n Usage   : @features = Bio::SeqFeature::Generic::slurp_gff_file(\\*FILE);\n Function: Sneaky function to load an entire file as in memory objects.\n           Beware of big files.\n\n           This method is deprecated. Use Bio::Tools::GFF instead, which can\n           also handle large files.\n\n Example :\n Returns :\n Args    :\n\n\nsub slurp_gff_file {\n   my ($f) = @_;\n   my @out;\n   if ( !defined $f ) {\n       Bio::Root::Root->throw(\"Must have a filehandle\");\n   }\n\n   Bio::Root::Root->deprecated( -message => \"deprecated method slurp_gff_file() called in Bio::SeqFeature::Generic. Use Bio::Tools::GFF instead.\",\n                                -warn_version  => '1.005',\n                                -throw_version => '1.007',\n                              );\n\n   while(<$f>) {\n       my $sf = Bio::SeqFeature::Generic->new('-gff_string' => $_);\n       push(@out, $sf);\n   }\n\n   return @out;\n}\n\n=head2 _from_gff_string\n\n Title   : _from_gff_string\n Usage   :\n Function: Set feature properties from GFF string. \n\n           This method uses the object returned by gff_format() for the\n           actual interpretation of the string. Set a different GFF format\n           interpreter first if you need a specific version, like GFF1. (The\n           default is GFF2.)\n Example :\n Returns : \n Args    : a GFF-formatted string"},"kind":12,"range":{"start":{"character":0,"line":930},"end":{"character":9999,"line":934}},"line":930,"detail":"($self,$string)","definition":"sub","containerName":"main::","name":"_from_gff_string","children":[{"definition":"my","name":"$self","containerName":"_from_gff_string","localvar":"my","kind":13,"line":931},{"line":931,"name":"$string","containerName":"_from_gff_string","kind":13},{"name":"$self","kind":13,"containerName":"_from_gff_string","line":933},{"line":933,"name":"gff_format","kind":12,"containerName":"_from_gff_string"},{"name":"from_gff_string","kind":12,"containerName":"_from_gff_string","line":933},{"name":"$self","containerName":"_from_gff_string","kind":13,"line":933},{"name":"$string","containerName":"_from_gff_string","kind":13,"line":933}]},{"kind":12,"range":{"end":{"line":969,"character":9999},"start":{"character":0,"line":952}},"line":952,"signature":{"parameters":[{"label":"$self"},{"label":"$feat"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::Generic->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( defined $self->strand &&\n\t$self->strand == -1 ) {\n\n       # ok. this does not work well (?)\n       #print STDERR \"Before revcom\", $seq->str, \"\\n\";\n       $seq = $seq->revcom;\n       #print STDERR \"After  revcom\", $seq->str, \"\\n\";\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    :\n\n\n\nsub entire_seq {\n   return shift->{'_gsf_seq'};\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    my $obj = shift;\n    return $obj->{'_gsf_seq_id'} = shift if @_;\n    return $obj->{'_gsf_seq_id'};\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $featname = $obj->display_name\n Function: Implements the display_name() method, which is a human-readable\n           name for the feature. \n Returns : value of display_name (a string)\n Args    : Optionally, on set the new value or undef \n\n\nsub display_name{\n    my $self = shift;\n    return $self->{'display_name'} = shift if @_;\n    return $self->{'display_name'};\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n\n Example : \n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\n\nsub get_SeqFeatures {\n    return @{ shift->{'_gsf_sub_array'} || []};    \n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: Adds a SeqFeature into the subSeqFeature array.\n           With no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent's start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n\n\n\n#'\nsub add_SeqFeature{\n    my ($self,$feat,$expand) = @_;\n    unless( defined $feat ) {\n\t$self->warn(\"Called add_SeqFeature with no feature, ignoring\");\n\treturn;\n    }\n    if ( !$feat->isa('Bio::SeqFeatureI') ) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI. Will add it anyway, but beware...\");\n    }\n\n    if($expand && ($expand eq 'EXPAND')) {\n        $self->_expand_region($feat);\n    } else {\n        if ( !$self->contains($feat) ) {\n            $self->throw(\"$feat is not contained within parent feature, and expansion is not valid\");\n        }\n    }\n\n    $self->{'_gsf_sub_array'} = [] unless exists($self->{'_gsf_sub_array'});\n    push(@{$self->{'_gsf_sub_array'}},$feat);\n\n}\n\n=head2 remove_SeqFeatures\n\n Title   : remove_SeqFeatures\n Usage   : $sf->remove_SeqFeatures\n Function: Removes all SeqFeatures\n\n           If you want to remove only a subset of features then remove that \n           subset from the returned array, and add back the rest.\n Example :\n Returns : The array of Bio::SeqFeatureI implementing features that was\n           deleted.\n Args    : none\n\n\n\nsub remove_SeqFeatures {\n   my ($self) = @_;\n\n   my @subfeats = @{$self->{'_gsf_sub_array'} || []};\n   $self->{'_gsf_sub_array'} = []; # zap the array implicitly.\n   return @subfeats;\n}\n\n=head1 GFF-related methods\n\n\n=head2 gff_format\n\n Title   : gff_format\n Usage   : # get:\n           $gffio = $feature->gff_format();\n           # set (change the default version of GFF2):\n           $feature->gff_format(Bio::Tools::GFF->new(-gff_version => 1));\n Function: Get/set the GFF format interpreter. This object is supposed to \n           format and parse GFF. See Bio::Tools::GFF for the interface.\n\n           If this method is called as class method, the default for all\n           newly created instances will be changed. Otherwise only this\n           instance will be affected.\n Example : \n Returns : a Bio::Tools::GFF compliant object\n Args    : On set, an instance of Bio::Tools::GFF or a derived object.\n\n\n\nsub gff_format {\n    my ($self, $gffio) = @_;\n\n    if(defined($gffio)) {\n        if(ref($self)) {\n            $self->{'_gffio'} = $gffio;\n        } else {\n            $Bio::SeqFeatureI::static_gff_formatter = $gffio;\n        }\n    }\n    return (ref($self) && exists($self->{'_gffio'}) ?\n            $self->{'_gffio'} : $self->_static_gff_formatter);\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           We override this here from Bio::SeqFeatureI in order to use the\n           formatter returned by gff_format().\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().\n\n\n\nsub gff_string{\n   my ($self,$formatter) = @_;\n\n   $formatter = $self->gff_format() unless $formatter;\n   return $formatter->gff_string($self);\n}\n\n=head2 slurp_gff_file\n\n Title   : slurp_file\n Usage   : @features = Bio::SeqFeature::Generic::slurp_gff_file(\\*FILE);\n Function: Sneaky function to load an entire file as in memory objects.\n           Beware of big files.\n\n           This method is deprecated. Use Bio::Tools::GFF instead, which can\n           also handle large files.\n\n Example :\n Returns :\n Args    :\n\n\nsub slurp_gff_file {\n   my ($f) = @_;\n   my @out;\n   if ( !defined $f ) {\n       Bio::Root::Root->throw(\"Must have a filehandle\");\n   }\n\n   Bio::Root::Root->deprecated( -message => \"deprecated method slurp_gff_file() called in Bio::SeqFeature::Generic. Use Bio::Tools::GFF instead.\",\n                                -warn_version  => '1.005',\n                                -throw_version => '1.007',\n                              );\n\n   while(<$f>) {\n       my $sf = Bio::SeqFeature::Generic->new('-gff_string' => $_);\n       push(@out, $sf);\n   }\n\n   return @out;\n}\n\n=head2 _from_gff_string\n\n Title   : _from_gff_string\n Usage   :\n Function: Set feature properties from GFF string. \n\n           This method uses the object returned by gff_format() for the\n           actual interpretation of the string. Set a different GFF format\n           interpreter first if you need a specific version, like GFF1. (The\n           default is GFF2.)\n Example :\n Returns : \n Args    : a GFF-formatted string\n\n\n\nsub _from_gff_string {\n   my ($self, $string) = @_;\n\n   $self->gff_format()->from_gff_string($self, $string);\n}\n\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_sub_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.","label":"_expand_region($self,$feat)"},"containerName":"main::","name":"_expand_region","children":[{"line":953,"name":"$self","containerName":"_expand_region","localvar":"my","kind":13,"definition":"my"},{"name":"$feat","containerName":"_expand_region","kind":13,"line":953},{"line":954,"containerName":"_expand_region","kind":13,"name":"$feat"},{"line":954,"name":"isa","containerName":"_expand_region","kind":12},{"name":"$self","kind":13,"containerName":"_expand_region","line":955},{"line":955,"kind":12,"containerName":"_expand_region","name":"warn"},{"line":959,"kind":13,"containerName":"_expand_region","name":"$self"},{"kind":12,"containerName":"_expand_region","name":"location","line":959},{"line":959,"name":"valid_Location","containerName":"_expand_region","kind":12},{"line":960,"kind":13,"containerName":"_expand_region","name":"$self"},{"containerName":"_expand_region","kind":12,"name":"start","line":960},{"line":960,"name":"$feat","containerName":"_expand_region","kind":13},{"line":960,"name":"start","containerName":"_expand_region","kind":12},{"kind":13,"containerName":"_expand_region","name":"$self","line":961},{"line":961,"name":"end","containerName":"_expand_region","kind":12},{"kind":13,"containerName":"_expand_region","name":"$feat","line":961},{"kind":12,"containerName":"_expand_region","name":"end","line":961},{"line":962,"name":"$self","kind":13,"containerName":"_expand_region"},{"name":"strand","kind":12,"containerName":"_expand_region","line":962},{"name":"$feat","containerName":"_expand_region","kind":13,"line":962},{"containerName":"_expand_region","kind":12,"name":"strand","line":962},{"line":962,"kind":13,"containerName":"_expand_region","name":"$self"},{"line":962,"name":"strand","kind":12,"containerName":"_expand_region"},{"definition":"my","line":964,"name":"$start","kind":13,"localvar":"my","containerName":"_expand_region"},{"name":"$end","kind":13,"containerName":"_expand_region","line":964},{"line":964,"containerName":"_expand_region","kind":13,"name":"$strand"},{"line":964,"name":"$self","containerName":"_expand_region","kind":13},{"name":"union","containerName":"_expand_region","kind":12,"line":964},{"containerName":"_expand_region","kind":13,"name":"$feat","line":964},{"line":965,"containerName":"_expand_region","kind":13,"name":"$self"},{"name":"start","containerName":"_expand_region","kind":12,"line":965},{"line":965,"containerName":"_expand_region","kind":13,"name":"$start"},{"line":966,"containerName":"_expand_region","kind":13,"name":"$self"},{"containerName":"_expand_region","kind":12,"name":"end","line":966},{"containerName":"_expand_region","kind":13,"name":"$end","line":966},{"name":"$self","containerName":"_expand_region","kind":13,"line":967},{"name":"strand","containerName":"_expand_region","kind":12,"line":967},{"name":"$strand","containerName":"_expand_region","kind":13,"line":967}],"detail":"($self,$feat)","definition":"sub"},{"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Generic.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::Generic\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::Generic - Generic SeqFeature\n\n=head1 SYNOPSIS\n\n   $feat = Bio::SeqFeature::Generic->new( \n            -start        => 10, \n            -end          => 100,\n            -strand       => -1, \n            -primary      => 'repeat', # -primary_tag is a synonym\n            -source_tag   => 'repeatmasker',\n            -display_name => 'alu family',\n            -score        => 1000,\n            -tag          => { new => 1,\n                               author => 'someone',\n                               sillytag => 'this is silly!' } );\n\n   $feat = Bio::SeqFeature::Generic->new( -gff_string => $string );\n   # if you want explicitly GFF1\n   $feat = Bio::SeqFeature::Generic->new( -gff1_string => $string );\n\n   # add it to an annotated sequence\n\n   $annseq->add_SeqFeature($feat);\n\n=head1 DESCRIPTION\n\nBio::SeqFeature::Generic is a generic implementation for the\nBio::SeqFeatureI interface, providing a simple object to provide all\nthe information for a feature on a sequence.\n\nFor many Features, this is all you will need to use (for example, this\nis fine for Repeats in DNA sequence or Domains in protein\nsequence). For other features, which have more structure, this is a\ngood base class to extend using inheritence to have new things: this\nis what is done in the L<Bio::SeqFeature::Gene>,\nL<Bio::SeqFeature::Transcript> and L<Bio::SeqFeature::Exon>, which provide\nwell coordinated classes to represent genes on DNA sequence (for\nexample, you can get the protein sequence out from a transcript\nclass).\n\nFor many Features, you want to add some piece of information, for\nexample a common one is that this feature is 'new' whereas other\nfeatures are 'old'.  The tag system, which here is implemented using a\nhash can be used here.  You can use the tag system to extend the\nL<Bio::SeqFeature::Generic> programmatically: that is, you know that you have\nread in more information into the tag 'mytag' which you can then\nretrieve. This means you do not need to know how to write inherited\nPerl to provide more complex information on a feature, and/or, if you\ndo know but you do not want to write a new class every time you need\nsome extra piece of information, you can use the tag system to easily\nstore and then retrieve information.\n\nThe tag system can be written in/out of GFF format, and also into EMBL\nformat via the L<Bio::SeqIO> system\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* L<Bio::SeqFeatureI>\n\nNote that this includes implementing Bio::RangeI.\n\n* L<Bio::AnnotatableI>\n\n* L<Bio::FeatureHolderI>\n\nFeatures held by a feature are essentially sub-features.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via \nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEwan Birney E<lt>birney@sanger.ac.ukE<gt>\n\n=head1 DEVELOPERS\n\nThis class has been written with an eye out for inheritance. The fields\nthe actual object hash are:\n\n   _gsf_tag_hash  = reference to a hash for the tags\n   _gsf_sub_array = reference to an array for subfeatures\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::SeqFeature::Generic;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Tools::GFF;\n#use Tie::IxHash;\n\nuse base qw(Bio::Root::Root Bio::SeqFeatureI Bio::FeatureHolderI Bio::AnnotatableI);\n\nsub new {\n    my ( $caller, @args) = @_;\n    my ($self) = $caller->SUPER::new(@args);\n    $self->_register_for_cleanup(\\&cleanup_generic);\n    $self->{'_parse_h'}       = {};\n    $self->{'_gsf_tag_hash'}  = {};\n\n    # bulk-set attributes\n    $self->set_attributes(@args);\n\n    # done - we hope\n    return $self;\n}\n\n=head2 set_attributes\n\n Title   : set_attributes\n Usage   :\n Function: Sets a whole array of parameters at once.\n Example :\n Returns : none\n Args    : Named parameters, in the form as they would otherwise be passed\n           to new(). Currently recognized are:\n\n                    -start          start position\n                    -end            end position\n                    -strand         strand\n                    -primary_tag    primary tag \n                    -primary        (synonym for -primary_tag)\n                    -source         source tag\n                    -frame          frame\n                    -score          score value\n                    -tag            a reference to a tag/value hash\n                    -gff_string     GFF v.2 string to initialize from\n                    -gff1_string    GFF v.1 string to initialize from\n                    -seq_id         the display name of the sequence\n                    -annotation     the AnnotationCollectionI object\n                    -location       the LocationI object\n\n\nsub set_attributes {\n    my ($self,@args) = @_;\n    my ($start, $end, $strand, $primary_tag, $source_tag, $primary, \n\t\t  $source, $frame, $score, $tag, $gff_string, $gff1_string,\n        $seqname, $seqid, $annot, $location,$display_name) =\n            $self->_rearrange([qw(START\n                                  END\n                                  STRAND\n                                  PRIMARY_TAG\n                                  SOURCE_TAG\n                                  PRIMARY\n                                  SOURCE\n                                  FRAME\n                                  SCORE\n                                  TAG\n                                  GFF_STRING\n                                  GFF1_STRING\n                                  SEQNAME\n                                  SEQ_ID\n                                  ANNOTATION\n                                  LOCATION\n                                  DISPLAY_NAME\n                                  )], @args);\n    $location    && $self->location($location);\n    $gff_string  && $self->_from_gff_string($gff_string);\n    $gff1_string  && do {\n        $self->gff_format(Bio::Tools::GFF->new('-gff_version' => 1));\n        $self->_from_gff_stream($gff1_string);\n    };\n    $primary_tag            && $self->primary_tag($primary_tag);\n    $source_tag             && $self->source_tag($source_tag);\n    $primary                && $self->primary_tag($primary);\n    $source                 && $self->source_tag($source);\n    defined $start          && $self->start($start);\n    defined $end            && $self->end($end);\n    defined $strand         && $self->strand($strand);\n    defined $frame          && $self->frame($frame);\n    defined $display_name   && $self->display_name($display_name);\n    defined $score          && $self->score($score);\n    $annot                  && $self->annotation($annot);\n    if($seqname) {\n        $self->warn(\"-seqname is deprecated. Please use -seq_id instead.\");\n        $seqid = $seqname unless $seqid;\n    }\n    $seqid          && $self->seq_id($seqid);\n    $tag            && do {\n        foreach my $t ( keys %$tag ) {\n            $self->add_tag_value($t, UNIVERSAL::isa($tag->{$t}, \"ARRAY\") ? @{$tag->{$t}} : $tag->{$t});\n        }\n    };\n}\n\n\n=head2 direct_new\n\n Title   : direct_new\n Usage   : my $obj = Bio::SeqFeature::Generic->direct_new\n Function: create a blessed hash - for performance improvement in \n           object creation\n Returns : Bio::SeqFeature::Generic object\n Args    : none\n\n\n\nsub direct_new {\n    my ( $class) = @_;\n    my ($self) = {};\n\n    bless $self,$class;\n\n    return $self;\n}\n\n=head2 location\n\n Title   : location\n Usage   : my $location = $seqfeature->location()\n Function: returns a location object suitable for identifying location \n           of feature on sequence or parent feature  \n Returns : Bio::LocationI object\n Args    : [optional] Bio::LocationI object to set the value to.\n\n\n\nsub location {\n    my($self, $value ) = @_;  \n\n    if (defined($value)) {\n        unless (ref($value) and $value->isa('Bio::LocationI')) {\n            $self->throw(\"object $value pretends to be a location but \".\n                         \"does not implement Bio::LocationI\");\n        }\n        $self->{'_location'} = $value;\n    }\n    elsif (! $self->{'_location'}) {\n        # guarantees a real location object is returned every time\n        $self->{'_location'} = Bio::Location::Simple->new();\n    }\n    return $self->{'_location'};\n}\n\n\n=head2 start\n\n Title   : start\n Usage   : $start = $feat->start\n           $feat->start(20)\n Function: Get/set on the start coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub start {\n   my ($self,$value) = @_;\n   return $self->location->start($value);\n}\n\n=head2 end\n\n Title   : end\n Usage   : $end = $feat->end\n           $feat->end($end)\n Function: get/set on the end coordinate of the feature\n Returns : integer\n Args    : none\n\n\n\nsub end {\n   my ($self,$value) = @_;\n   return $self->location->end($value);\n}\n\n=head2 length\n\n Title   : length\n Usage   : my $len = $feature->length\n Function: Get the feature length computed as \n           $feat->end - $feat->start + 1\n Returns : integer\n Args    : none\n\n\n\nsub length {\n   my $self = shift;\n   return $self->end - $self->start() + 1;\n}\n\n=head2 strand\n\n Title   : strand\n Usage   : $strand = $feat->strand()\n           $feat->strand($strand)\n Function: get/set on strand information, being 1,-1 or 0\n Returns : -1,1 or 0\n Args    : none\n\n\n\nsub strand {\n   my $self = shift;\n   return $self->location->strand(@_);\n}\n\n=head2 score\n\n Title   : score\n Usage   : $score = $feat->score()\n           $feat->score($score)\n Function: get/set on score information\n Returns : float\n Args    : none if get, the new value if set\n\n\n\nsub score {\n    my $self = shift;\n\n    if (@_) {\n        my $value = shift;\n\n        if ( defined $value && $value && $value !~ /^[A-Za-z]+$/ &&\n            $value !~ /^[+-]?\\d+\\.?\\d*(e-\\d+)?/ and $value != 0) {\n            $self->throw(-class=>'Bio::Root::BadParameter',\n                    -text=>\"'$value' is not a valid score\",\n                    -value=>$value);\n        }\n        if ($self->has_tag('score')) {\n            $self->warn(\"Removing score value(s)\");\n            $self->remove_tag('score');\n        }\n        $self->add_tag_value('score',$value);\n    }\n    my ($score) = $self->has_tag('score') ? $self->get_tag_values('score') : undef;\n    return $score;\n}\n\n=head2 frame\n\n Title   : frame\n Usage   : $frame = $feat->frame()\n           $feat->frame($frame)\n Function: get/set on frame information\n Returns : 0,1,2, '.'\n Args    : none if get, the new value if set\n\n\n\nsub frame {\n  my $self = shift;\n\n  if ( @_ ) {\n      my $value = shift;\n      if ( defined $value && \n\t   $value !~ /^[0-2.]$/ ) {\n\t  $self->throw(\"'$value' is not a valid frame\");\n      }\n      if( defined $value && $value eq '.' ) { $value = '.' } \n      return $self->{'_gsf_frame'} = $value;\n  }\n  return $self->{'_gsf_frame'};\n}\n\n=head2 primary_tag\n\n Title   : primary_tag\n Usage   : $tag = $feat->primary_tag()\n           $feat->primary_tag('exon')\n Function: get/set on the primary tag for a feature,\n           eg 'exon'\n Returns : a string\n Args    : none\n\n\n\nsub primary_tag {\n    my $self = shift;\n    return $self->{'_primary_tag'} = shift if @_;\n    return $self->{'_primary_tag'};\n}\n\n=head2 source_tag\n\n Title   : source_tag\n Usage   : $tag = $feat->source_tag()\n           $feat->source_tag('genscan');\n Function: Returns the source tag for a feature,\n           eg, 'genscan'\n Returns : a string\n Args    : none\n\n\n\nsub source_tag {\n    my $self = shift;\n    return $self->{'_source_tag'} = shift if @_;\n    return $self->{'_source_tag'};\n}\n\n=head2 has_tag\n\n Title   : has_tag\n Usage   : $value = $self->has_tag('some_tag')\n Function: Tests wether a feature contaings a tag\n Returns : TRUE if the SeqFeature has the tag,\n           and FALSE otherwise.\n Args    : The name of a tag\n\n\n\nsub has_tag {\n    my ($self, $tag) = @_;\n    return exists $self->{'_gsf_tag_hash'}->{$tag};\n}\n\n=head2 add_tag_value\n\n Title   : add_tag_value\n Usage   : $self->add_tag_value('note',\"this is a note\");\n Returns : TRUE on success\n Args    : tag (string) and one or more values (any scalar(s))\n\n\n\nsub add_tag_value {\n    my $self = shift;\n    my $tag = shift;\n    $self->{'_gsf_tag_hash'}->{$tag} ||= [];\n    push(@{$self->{'_gsf_tag_hash'}->{$tag}},@_);\n}\n\n\n=head2 get_tag_values\n\n Title   : get_tag_values\n Usage   : @values = $gsf->get_tag_values('note');\n Function: Returns a list of all the values stored\n           under a particular tag.\n Returns : A list of scalars\n Args    : The name of the tag\n\n\n\nsub get_tag_values {\n   my ($self, $tag) = @_;\n\n   if( ! defined $tag ) { return (); }\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"asking for tag value that does not exist $tag\");\n   }\n   return @{$self->{'_gsf_tag_hash'}->{$tag}};\n}\n\n\n=head2 get_all_tags\n\n Title   : get_all_tags\n Usage   : @tags = $feat->get_all_tags()\n Function: Get a list of all the tags in a feature\n Returns : An array of tag names\n Args    : none\n\n# added a sort so that tags will be returned in a predictable order\n# I still think we should be able to specify a sort function\n# to the object at some point\n# -js\n\n\nsub get_all_tags {\n   my ($self, @args) = @_;   \n   return sort keys %{ $self->{'_gsf_tag_hash'}};\n}\n\n=head2 remove_tag\n\n Title   : remove_tag\n Usage   : $feat->remove_tag('some_tag')\n Function: removes a tag from this feature\n Returns : the array of values for this tag before removing it\n Args    : tag (string)\n\n\n\nsub remove_tag {\n   my ($self, $tag) = @_;\n\n   if ( ! exists $self->{'_gsf_tag_hash'}->{$tag} ) {\n       $self->throw(\"trying to remove a tag that does not exist: $tag\");\n   }\n   my @vals = @{$self->{'_gsf_tag_hash'}->{$tag}};\n   delete $self->{'_gsf_tag_hash'}->{$tag};\n   return @vals;\n}\n\n=head2 attach_seq\n\n Title   : attach_seq\n Usage   : $sf->attach_seq($seq)\n Function: Attaches a Bio::Seq object to this feature. This\n           Bio::Seq object is for the *entire* sequence: ie\n           from 1 to 10000\n Example :\n Returns : TRUE on success\n Args    : a Bio::PrimarySeqI compliant object\n\n\n\nsub attach_seq {\n   my ($self, $seq) = @_;\n\n   if ( ! ($seq && ref($seq) && $seq->isa(\"Bio::PrimarySeqI\")) ) {\n       $self->throw(\"Must attach Bio::PrimarySeqI objects to SeqFeatures\");\n   }\n\n   $self->{'_gsf_seq'} = $seq;\n\n   # attach to sub features if they want it\n   foreach ( $self->sub_SeqFeature() ) {\n       $_->attach_seq($seq);\n   }\n   return 1;\n}\n\n=head2 seq\n\n Title   : seq\n Usage   : $tseq = $sf->seq()\n Function: returns the truncated sequence (if there) for this\n Example :\n Returns : sub seq (a Bio::PrimarySeqI compliant object) on attached sequence\n           bounded by start & end, or undef if there is no sequence attached\n Args    : none\n\n\n\nsub seq {\n   my ($self, $arg) = @_;\n\n   if ( defined $arg ) {\n       $self->throw(\"Calling SeqFeature::Generic->seq with an argument. You probably want attach_seq\");\n   }\n\n   if ( ! exists $self->{'_gsf_seq'} ) {\n       return;\n   }\n\n   # assumming our seq object is sensible, it should not have to yank\n   # the entire sequence out here.\n\n   my $seq = $self->{'_gsf_seq'}->trunc($self->start(), $self->end());\n\n\n   if ( defined $self->strand &&\n\t$self->strand == -1 ) {\n\n       # ok. this does not work well (?)\n       #print STDERR \"Before revcom\", $seq->str, \"\\n\";\n       $seq = $seq->revcom;\n       #print STDERR \"After  revcom\", $seq->str, \"\\n\";\n   }\n\n   return $seq;\n}\n\n=head2 entire_seq\n\n Title   : entire_seq\n Usage   : $whole_seq = $sf->entire_seq()\n Function: gives the entire sequence that this seqfeature is attached to\n Example :\n Returns : a Bio::PrimarySeqI compliant object, or undef if there is no\n           sequence attached\n Args    :\n\n\n\nsub entire_seq {\n   return shift->{'_gsf_seq'};\n}\n\n\n=head2 seq_id\n\n Title   : seq_id\n Usage   : $obj->seq_id($newval)\n Function: There are many cases when you make a feature that you\n           do know the sequence name, but do not know its actual\n           sequence. This is an attribute such that you can store\n           the ID (e.g., display_id) of the sequence.\n\n           This attribute should *not* be used in GFF dumping, as\n           that should come from the collection in which the seq\n           feature was found.\n Returns : value of seq_id\n Args    : newvalue (optional)\n\n\n\nsub seq_id {\n    my $obj = shift;\n    return $obj->{'_gsf_seq_id'} = shift if @_;\n    return $obj->{'_gsf_seq_id'};\n}\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $featname = $obj->display_name\n Function: Implements the display_name() method, which is a human-readable\n           name for the feature. \n Returns : value of display_name (a string)\n Args    : Optionally, on set the new value or undef \n\n\nsub display_name{\n    my $self = shift;\n    return $self->{'display_name'} = shift if @_;\n    return $self->{'display_name'};\n}\n\n=head1 Methods for implementing Bio::AnnotatableI\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($annot_obj)\n Function: Get/set the annotation collection object for annotating this\n           feature.\n\n Example : \n Returns : A Bio::AnnotationCollectionI object\n Args    : newvalue (optional)\n\n\n\nsub annotation {\n    my ($obj,$value) = @_;\n\n    # we are smart if someone references the object and there hasn't been\n    # one set yet\n    if(defined $value || ! defined $obj->{'annotation'} ) {\n        $value = Bio::Annotation::Collection->new() unless ( defined $value );\n        $obj->{'annotation'} = $value;\n    }\n    return $obj->{'annotation'};\n}\n\n=head1 Methods to implement Bio::FeatureHolderI\n\nThis includes methods for retrieving, adding, and removing\nfeatures. Since this is already a feature, features held by this\nfeature holder are essentially sub-features.\n\n\n=head2 get_SeqFeatures\n\n Title   : get_SeqFeatures\n Usage   : @feats = $feat->get_SeqFeatures();\n Function: Returns an array of sub Sequence Features\n Returns : An array\n Args    : none\n\n\n\nsub get_SeqFeatures {\n    return @{ shift->{'_gsf_sub_array'} || []};    \n}\n\n=head2 add_SeqFeature\n\n Title   : add_SeqFeature\n Usage   : $feat->add_SeqFeature($subfeat);\n           $feat->add_SeqFeature($subfeat,'EXPAND')\n Function: Adds a SeqFeature into the subSeqFeature array.\n           With no 'EXPAND' qualifer, subfeat will be tested\n           as to whether it lies inside the parent, and throw\n           an exception if not.\n\n           If EXPAND is used, the parent's start/end/strand will\n           be adjusted so that it grows to accommodate the new\n           subFeature\n Returns : nothing\n Args    : An object which has the SeqFeatureI interface\n\n\n\n#'\nsub add_SeqFeature{\n    my ($self,$feat,$expand) = @_;\n    unless( defined $feat ) {\n\t$self->warn(\"Called add_SeqFeature with no feature, ignoring\");\n\treturn;\n    }\n    if ( !$feat->isa('Bio::SeqFeatureI') ) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI. Will add it anyway, but beware...\");\n    }\n\n    if($expand && ($expand eq 'EXPAND')) {\n        $self->_expand_region($feat);\n    } else {\n        if ( !$self->contains($feat) ) {\n            $self->throw(\"$feat is not contained within parent feature, and expansion is not valid\");\n        }\n    }\n\n    $self->{'_gsf_sub_array'} = [] unless exists($self->{'_gsf_sub_array'});\n    push(@{$self->{'_gsf_sub_array'}},$feat);\n\n}\n\n=head2 remove_SeqFeatures\n\n Title   : remove_SeqFeatures\n Usage   : $sf->remove_SeqFeatures\n Function: Removes all SeqFeatures\n\n           If you want to remove only a subset of features then remove that \n           subset from the returned array, and add back the rest.\n Example :\n Returns : The array of Bio::SeqFeatureI implementing features that was\n           deleted.\n Args    : none\n\n\n\nsub remove_SeqFeatures {\n   my ($self) = @_;\n\n   my @subfeats = @{$self->{'_gsf_sub_array'} || []};\n   $self->{'_gsf_sub_array'} = []; # zap the array implicitly.\n   return @subfeats;\n}\n\n=head1 GFF-related methods\n\n\n=head2 gff_format\n\n Title   : gff_format\n Usage   : # get:\n           $gffio = $feature->gff_format();\n           # set (change the default version of GFF2):\n           $feature->gff_format(Bio::Tools::GFF->new(-gff_version => 1));\n Function: Get/set the GFF format interpreter. This object is supposed to \n           format and parse GFF. See Bio::Tools::GFF for the interface.\n\n           If this method is called as class method, the default for all\n           newly created instances will be changed. Otherwise only this\n           instance will be affected.\n Example : \n Returns : a Bio::Tools::GFF compliant object\n Args    : On set, an instance of Bio::Tools::GFF or a derived object.\n\n\n\nsub gff_format {\n    my ($self, $gffio) = @_;\n\n    if(defined($gffio)) {\n        if(ref($self)) {\n            $self->{'_gffio'} = $gffio;\n        } else {\n            $Bio::SeqFeatureI::static_gff_formatter = $gffio;\n        }\n    }\n    return (ref($self) && exists($self->{'_gffio'}) ?\n            $self->{'_gffio'} : $self->_static_gff_formatter);\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $str = $feat->gff_string;\n           $str = $feat->gff_string($gff_formatter);\n Function: Provides the feature information in GFF format.\n\n           We override this here from Bio::SeqFeatureI in order to use the\n           formatter returned by gff_format().\n\n Returns : A string\n Args    : Optionally, an object implementing gff_string().\n\n\n\nsub gff_string{\n   my ($self,$formatter) = @_;\n\n   $formatter = $self->gff_format() unless $formatter;\n   return $formatter->gff_string($self);\n}\n\n=head2 slurp_gff_file\n\n Title   : slurp_file\n Usage   : @features = Bio::SeqFeature::Generic::slurp_gff_file(\\*FILE);\n Function: Sneaky function to load an entire file as in memory objects.\n           Beware of big files.\n\n           This method is deprecated. Use Bio::Tools::GFF instead, which can\n           also handle large files.\n\n Example :\n Returns :\n Args    :\n\n\nsub slurp_gff_file {\n   my ($f) = @_;\n   my @out;\n   if ( !defined $f ) {\n       Bio::Root::Root->throw(\"Must have a filehandle\");\n   }\n\n   Bio::Root::Root->deprecated( -message => \"deprecated method slurp_gff_file() called in Bio::SeqFeature::Generic. Use Bio::Tools::GFF instead.\",\n                                -warn_version  => '1.005',\n                                -throw_version => '1.007',\n                              );\n\n   while(<$f>) {\n       my $sf = Bio::SeqFeature::Generic->new('-gff_string' => $_);\n       push(@out, $sf);\n   }\n\n   return @out;\n}\n\n=head2 _from_gff_string\n\n Title   : _from_gff_string\n Usage   :\n Function: Set feature properties from GFF string. \n\n           This method uses the object returned by gff_format() for the\n           actual interpretation of the string. Set a different GFF format\n           interpreter first if you need a specific version, like GFF1. (The\n           default is GFF2.)\n Example :\n Returns : \n Args    : a GFF-formatted string\n\n\n\nsub _from_gff_string {\n   my ($self, $string) = @_;\n\n   $self->gff_format()->from_gff_string($self, $string);\n}\n\n\n=head2 _expand_region\n\n Title   : _expand_region\n Usage   : $self->_expand_region($feature);\n Function: Expand the total region covered by this feature to\n           accomodate for the given feature.\n\n           May be called whenever any kind of subfeature is added to this\n           feature. add_sub_SeqFeature() already does this.\n Returns : \n Args    : A Bio::SeqFeatureI implementing object.\n\n\n\nsub _expand_region {\n    my ($self, $feat) = @_;\n    if(! $feat->isa('Bio::SeqFeatureI')) {\n        $self->warn(\"$feat does not implement Bio::SeqFeatureI\");\n    }\n    # if this doesn't have start set - forget it!\n    # changed to reflect sanity checks for LocationI\n    if(!$self->location->valid_Location) {\n        $self->start($feat->start);\n        $self->end($feat->end);\n        $self->strand($feat->strand) unless $self->strand;\n    } else {\n        my ($start,$end,$strand) = $self->union($feat);\n        $self->start($start);\n        $self->end($end);\n        $self->strand($strand);\n    }\n}\n\n=head2 _parse\n\n Title   : _parse\n Usage   :\n Function: Parsing hints\n Example :\n Returns :\n Args    :","label":"_parse($self)"},"line":983,"range":{"end":{"character":9999,"line":986},"start":{"line":983,"character":0}},"kind":12,"definition":"sub","detail":"($self)","children":[{"definition":"my","name":"$self","containerName":"_parse","localvar":"my","kind":13,"line":984},{"line":985,"name":"$self","containerName":"_parse","kind":13}],"containerName":"main::","name":"_parse"},{"kind":12,"range":{"start":{"character":0,"line":1000},"end":{"character":9999,"line":1009}},"line":1000,"definition":"sub","containerName":"main::","name":"_tag_value","children":[{"line":1001,"name":"$self","localvar":"my","kind":13,"containerName":"_tag_value","definition":"my"},{"definition":"my","localvar":"my","containerName":"_tag_value","kind":13,"name":"$tag","line":1002},{"name":"$self","containerName":"_tag_value","kind":13,"line":1004},{"line":1004,"containerName":"_tag_value","kind":12,"name":"has_tag"},{"containerName":"_tag_value","kind":13,"name":"$tag","line":1004},{"line":1005,"name":"$self","containerName":"_tag_value","kind":13},{"name":"remove_tag","containerName":"_tag_value","kind":12,"line":1005},{"line":1005,"containerName":"_tag_value","kind":13,"name":"$tag"},{"name":"$self","containerName":"_tag_value","kind":13,"line":1005},{"name":"has_tag","kind":12,"containerName":"_tag_value","line":1005},{"line":1005,"containerName":"_tag_value","kind":13,"name":"$tag"},{"kind":13,"containerName":"_tag_value","name":"$self","line":1006},{"line":1006,"name":"add_tag_value","kind":12,"containerName":"_tag_value"},{"containerName":"_tag_value","kind":13,"name":"$tag","line":1006},{"name":"$self","containerName":"_tag_value","kind":13,"line":1008},{"name":"get_tag_values","containerName":"_tag_value","kind":12,"line":1008},{"line":1008,"name":"$tag","kind":13,"containerName":"_tag_value"}]},{"kind":12,"range":{"end":{"line":1020,"character":9999},"start":{"character":0,"line":1016}},"line":1016,"definition":"sub","name":"seqname","containerName":"main::","children":[{"localvar":"my","containerName":"seqname","kind":13,"name":"$self","line":1017,"definition":"my"},{"line":1018,"name":"$self","kind":13,"containerName":"seqname"},{"name":"warn","kind":12,"containerName":"seqname","line":1018},{"line":1019,"name":"$self","containerName":"seqname","kind":13},{"line":1019,"kind":12,"containerName":"seqname","name":"seq_id"}]},{"range":{"start":{"line":1022,"character":0},"end":{"character":9999,"line":1026}},"kind":12,"line":1022,"definition":"sub","containerName":"main::","name":"display_id","children":[{"definition":"my","line":1023,"localvar":"my","containerName":"display_id","kind":13,"name":"$self"},{"line":1024,"name":"$self","containerName":"display_id","kind":13},{"kind":12,"containerName":"display_id","name":"warn","line":1024},{"line":1025,"name":"$self","kind":13,"containerName":"display_id"},{"line":1025,"name":"display_name","kind":12,"containerName":"display_id"}]},{"children":[{"name":"get_tag_values","containerName":"each_tag_value","kind":12,"line":1029}],"containerName":"main::","name":"each_tag_value","definition":"sub","line":1029,"range":{"end":{"character":9999,"line":1029},"start":{"character":0,"line":1029}},"kind":12},{"children":[{"name":"get_all_tags","containerName":"all_tags","kind":12,"line":1030}],"name":"all_tags","containerName":"main::","definition":"sub","line":1030,"kind":12,"range":{"end":{"character":9999,"line":1030},"start":{"line":1030,"character":0}}},{"line":1041,"kind":12,"range":{"end":{"line":1043,"character":9999},"start":{"line":1041,"character":0}},"children":[{"line":1042,"name":"$self","localvar":"my","kind":13,"containerName":"cleanup_generic","definition":"my"},{"name":"$f","localvar":"my","kind":13,"containerName":"cleanup_generic","line":1043,"definition":"my"},{"kind":13,"containerName":"cleanup_generic","name":"$self","line":1043}],"containerName":"main::","name":"cleanup_generic","definition":"sub"},{"line":1044,"name":"$f","kind":13,"containerName":null},{"name":"%self","kind":13,"containerName":null,"line":1046},{"definition":"my","containerName":null,"localvar":"my","kind":13,"name":"$t","line":1047},{"line":1047,"name":"%self","kind":13,"containerName":null},{"line":1048,"name":"%self","kind":13,"containerName":null},{"line":1048,"kind":13,"containerName":null,"name":"$t"},{"line":1049,"name":"%self","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$t","line":1049}]}