{"vars":[{"containerName":"","kind":2,"name":"base","line":92},{"definition":"our","line":94,"name":"@ARGNAMES","kind":13,"containerName":"main::"},{"range":{"end":{"character":9999,"line":150},"start":{"line":122,"character":0}},"kind":12,"line":122,"signature":{"label":"new($proto,@args)","parameters":[{"label":"$proto"},{"label":"@args"}],"documentation":"1;\n# $Id: Oligo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SiRNA::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Donald Jackson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SiRNA::Oligo - Perl object for small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::SiRNA::Oligo;\n\n  my $oligo = Bio::SeqFeature::SiRNA::Oligo->\n      new( -seq\t\t=> 'AUGCCGAUUGCAAGUCAGATT',\n\t   -start \t=> 10,\n\t   -end\t\t=> 31,\n\t   -strand\t=> -1,\n\t   -primary\t=> 'SiRNA::Oligo',\n\t   -source_tag\t=> 'Bio::Tools::SiRNA',\n\t   -tag\t\t=> { note => 'A note' }, );\n\n  # normally two complementary Oligos are combined in an SiRNA::Pair\n  # object\n  $pair->antisense($oligo);\n\n\n=head1 DESCRIPTION\n\nObject methods for single SiRNA oligos - inherits\nL<Bio::SeqFeature::Generic>.  Does B<not> include methods for designing\nSiRNAs - see L<Bio::Tools::SiRNA> for that.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::SiRNA>, L<Bio::SeqFeature::SiRNA::Pair>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqFeature::SiRNA::Oligo;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::SeqFeature::Generic);\n\nour @ARGNAMES = qw(SEQ START END STRAND PRIMARY SOURCE_TAG SCORE TAG \n                   SEQ_ID ANNOTATION LOCATION);\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: my $sirna_oligo = Bio::SeqFeature::SiRNA::Oligo->new();\n  Function\t: Create a new SiRNA::Oligo object\n  Returns\t: Bio::Tools::SiRNA object\n  Args    \t: -seq\t\t  sequence of the RNAi oligo.  Should be in RNA alphabet\n                                  except for the final TT overhang.\n                  -start          start position\n \t \t  -end            end position\n \t \t  -strand         strand\n \t \t  -primary        primary tag - defaults to 'SiRNA::Oligo'\n \t \t  -source         source tag\n \t \t  -score          score value\n \t \t  -tag            a reference to a tag/value hash\n \t \t  -seq_id         the display name of the sequence\n \t \t  -annotation     the AnnotationCollectionI object\n \t \t  -location       the LocationI object\n\nCurrently passing arguments in gff_string or gff1_string is not\nsupported.  SiRNA::Oligo objects are typically created by a design\nalgorithm such as Bio::Tools::SiRNA"},"containerName":"main::","name":"new","children":[{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$proto","line":123},{"line":123,"name":"@args","kind":13,"containerName":"new"},{"line":125,"name":"$pkg","localvar":"my","kind":13,"containerName":"new","definition":"my"},{"line":125,"containerName":"new","kind":13,"name":"$proto"},{"kind":13,"containerName":"new","name":"$proto","line":125},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"%args","line":127},{"definition":"my","name":"$self","containerName":"new","localvar":"my","kind":13,"line":129},{"name":"$pkg","containerName":"new","kind":13,"line":129},{"name":"@args","kind":13,"containerName":"new","line":131},{"kind":13,"containerName":"new","name":"@ARGNAMES","line":131},{"name":"$self","containerName":"new","kind":13,"line":131},{"containerName":"new","kind":12,"name":"_rearrange","line":131},{"line":131,"containerName":"new","kind":13,"name":"@ARGNAMES"},{"name":"@args","kind":13,"containerName":"new","line":131},{"line":133,"containerName":"new","kind":13,"name":"$args"},{"name":"$args","containerName":"new","kind":13,"line":135},{"line":135,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"primary_tag","line":135},{"line":135,"containerName":"new","kind":13,"name":"$args"},{"kind":13,"containerName":"new","name":"$args","line":136},{"name":"$self","kind":13,"containerName":"new","line":136},{"line":136,"containerName":"new","kind":12,"name":"source_tag"},{"kind":13,"containerName":"new","name":"$args","line":136},{"name":"$args","containerName":"new","kind":13,"line":137},{"line":137,"name":"$self","kind":13,"containerName":"new"},{"kind":12,"containerName":"new","name":"seqname","line":137},{"name":"$args","kind":13,"containerName":"new","line":137},{"line":138,"name":"$args","containerName":"new","kind":13},{"line":138,"containerName":"new","kind":13,"name":"$self"},{"line":138,"name":"seq","kind":12,"containerName":"new"},{"line":138,"kind":13,"containerName":"new","name":"$args"},{"kind":13,"containerName":"new","name":"$args","line":139},{"line":139,"name":"$self","containerName":"new","kind":13},{"line":139,"name":"annotation","containerName":"new","kind":12},{"line":139,"name":"$args","containerName":"new","kind":13},{"line":140,"kind":13,"containerName":"new","name":"$args"},{"line":140,"containerName":"new","kind":13,"name":"$self"},{"line":140,"kind":12,"containerName":"new","name":"location"},{"name":"$args","kind":13,"containerName":"new","line":140},{"containerName":"new","kind":13,"name":"$args","line":141},{"name":"$self","containerName":"new","kind":13,"line":141},{"line":141,"name":"start","containerName":"new","kind":12},{"name":"$args","containerName":"new","kind":13,"line":141},{"kind":13,"containerName":"new","name":"$args","line":142},{"line":142,"name":"$self","kind":13,"containerName":"new"},{"name":"end","containerName":"new","kind":12,"line":142},{"line":142,"kind":13,"containerName":"new","name":"$args"},{"line":143,"kind":13,"containerName":"new","name":"$args"},{"line":143,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"strand","line":143},{"line":143,"name":"$args","containerName":"new","kind":13},{"line":144,"containerName":"new","kind":13,"name":"$args"},{"kind":13,"containerName":"new","name":"$self","line":144},{"line":144,"containerName":"new","kind":12,"name":"score"},{"line":144,"kind":13,"containerName":"new","name":"$args"},{"kind":13,"containerName":"new","name":"$args","line":146},{"definition":"my","containerName":"new","localvar":"my","kind":13,"name":"$t","line":147},{"name":"$args","kind":13,"containerName":"new","line":147},{"line":148,"name":"$self","kind":13,"containerName":"new"},{"name":"add_tag_value","kind":12,"containerName":"new","line":148},{"line":148,"name":"$t","containerName":"new","kind":13},{"line":148,"name":"$args","kind":13,"containerName":"new"},{"name":"$t","containerName":"new","kind":13,"line":148}],"detail":"($proto,@args)","definition":"sub"},{"name":"SUPER","kind":12,"containerName":"new","line":129},{"line":152,"containerName":null,"kind":13,"name":"$self"},{"signature":{"documentation":"1;\n# $Id: Oligo.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SiRNA::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Donald Jackson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SiRNA::Oligo - Perl object for small inhibitory RNAs.\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::SiRNA::Oligo;\n\n  my $oligo = Bio::SeqFeature::SiRNA::Oligo->\n      new( -seq\t\t=> 'AUGCCGAUUGCAAGUCAGATT',\n\t   -start \t=> 10,\n\t   -end\t\t=> 31,\n\t   -strand\t=> -1,\n\t   -primary\t=> 'SiRNA::Oligo',\n\t   -source_tag\t=> 'Bio::Tools::SiRNA',\n\t   -tag\t\t=> { note => 'A note' }, );\n\n  # normally two complementary Oligos are combined in an SiRNA::Pair\n  # object\n  $pair->antisense($oligo);\n\n\n=head1 DESCRIPTION\n\nObject methods for single SiRNA oligos - inherits\nL<Bio::SeqFeature::Generic>.  Does B<not> include methods for designing\nSiRNAs - see L<Bio::Tools::SiRNA> for that.\n\n=head1 SEE ALSO\n\nL<Bio::Tools::SiRNA>, L<Bio::SeqFeature::SiRNA::Pair>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqFeature::SiRNA::Oligo;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::SeqFeature::Generic);\n\nour @ARGNAMES = qw(SEQ START END STRAND PRIMARY SOURCE_TAG SCORE TAG \n                   SEQ_ID ANNOTATION LOCATION);\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: my $sirna_oligo = Bio::SeqFeature::SiRNA::Oligo->new();\n  Function\t: Create a new SiRNA::Oligo object\n  Returns\t: Bio::Tools::SiRNA object\n  Args    \t: -seq\t\t  sequence of the RNAi oligo.  Should be in RNA alphabet\n                                  except for the final TT overhang.\n                  -start          start position\n \t \t  -end            end position\n \t \t  -strand         strand\n \t \t  -primary        primary tag - defaults to 'SiRNA::Oligo'\n \t \t  -source         source tag\n \t \t  -score          score value\n \t \t  -tag            a reference to a tag/value hash\n \t \t  -seq_id         the display name of the sequence\n \t \t  -annotation     the AnnotationCollectionI object\n \t \t  -location       the LocationI object\n\nCurrently passing arguments in gff_string or gff1_string is not\nsupported.  SiRNA::Oligo objects are typically created by a design\nalgorithm such as Bio::Tools::SiRNA\n\n\nsub new {\n    my ($proto, @args) = @_;\n\n    my $pkg = ref($proto) || $proto;\n\n    my (%args);\n\n    my $self = $pkg->SUPER::new();\n\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    # default primary tag\n    $args{'PRIMARY'} ||= 'SiRNA::Oligo';\n\n    $args{'PRIMARY'}\t\t&& $self->primary_tag($args{'PRIMARY'});\n    $args{'SOURCE_TAG'}\t\t&& $self->source_tag($args{'SOURCE_TAG'});\n    $args{'SEQNAME'}\t\t&& $self->seqname($args{'SEQNAME'});\n    $args{'SEQ'}\t\t&& $self->seq($args{'SEQ'});\n    $args{'ANNOTATION'}\t\t&& $self->annotation($args{'ANNOTATION'});\n    $args{'LOCATION'}\t\t&& $self->location($args{'LOCATION'});\n    defined($args{'START'})\t&& $self->start($args{'START'});\n    defined($args{'END'})\t&& $self->end($args{'END'});\n    defined($args{'STRAND'})\t&& $self->strand($args{'STRAND'});\n    defined($args{'SCORE'})\t&& $self->score($args{'SCORE'});\n\n    if ($args{'TAG'}) {\t\n\tforeach my $t ( keys %{ $args{'TAG'} } ) {\n\t    $self->add_tag_value($t, $args{'TAG'}->{$t});\n\t}\n    }\n\n    return $self;\n}\n\n=head2 seq\n\n  Title\t\t: Seq\n  Usage\t\t: my $oligo_sequence = $sirna_oligo->seq();\n  Purpose\t: Get/set the sequence of the RNAi oligo\n  Returns \t: Sequence for the RNAi oligo\n  Args\t\t: Sequence of the RNAi oligo (optional)\n  Note\t\t: Overloads Bio::SeqFeature::Generic seq method - the oligo and \n                  parent sequences are different. \n                  Note that all but the last 2 nucleotides are RNA (per Tuschl and colleagues).\n                  SiRNA::Pair objects are typically created by a design algorithm such as\n                  Bio::Tools::SiRNA.","parameters":[{"label":"$self"},{"label":"$seq"}],"label":"seq($self,$seq)"},"line":170,"range":{"end":{"line":183,"character":9999},"start":{"character":0,"line":170}},"kind":12,"definition":"sub","detail":"($self,$seq)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"seq","line":171},{"line":171,"name":"$seq","kind":13,"containerName":"seq"},{"name":"$seq","containerName":"seq","kind":13,"line":172},{"line":174,"name":"$seq","containerName":"seq","kind":13},{"line":179,"containerName":"seq","kind":13,"name":"$self"},{"kind":13,"containerName":"seq","name":"$seq","line":179},{"containerName":"seq","kind":13,"name":"$self","line":182}],"name":"seq","containerName":"main::"}],"version":5}