{"vars":[{"line":93,"name":"base","containerName":"","kind":2},{"name":"@ARGNAMES","containerName":"main::","kind":13,"line":98,"definition":"our"},{"signature":{"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SiRNA::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Donald Jackson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SiRNA::Pair - Perl object for small inhibitory RNA\n(SiRNA) oligo pairs\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::SiRNA::Pair;\n  my $pair = Bio::SeqFeature::SiRNA::Pair->\n      new( -sense       => $bio_seqfeature_sirna_oligo, # strand=1\n           -antisense\t=> $bio_seqfeature_sirna_oligo, # strand= -1\n\t   -primary\t=> 'SiRNA::Pair',\n\t   -source_tag \t=> 'Bio::Tools::SiRNA',\n\t   -start\t=> 8,\n\t   -end\t\t=> 31,\n\t   -rank\t=> 1,\n\t   -fxgc\t=> 0.5,\n\t   -tag\t\t=> { note => 'a note' } );\n\n  $target_sequence->add_SeqFeature($pair);\t\t\t\t\t\n\n=head1 DESCRIPTION\n\nObject methods for (complementary) pairs of L<Bio::SeqFeature::SiRNA::Oligo> \nobjects - inherits L<Bio::SeqFeature::Generic>. See that package for information\non inherited methods.\n\nDoes B<not> include methods for designing SiRNAs -- see L<Bio::Tools::SiRNA>\n\n=head1 SEE ALSO\n\nL<Bio::SeqFeature::Oligo>, L<Bio::Tools::SiRNA>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqFeature::SiRNA::Pair;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n# arguments to new().  Taken from Bio::SeqFeature Generic.\n# Omit frame (not relevant), GFF_STRING and GFF1_STRING \n# because I'm not sure how to handle them.  Add RANK, FXGC, SENSE, ANTISENSE\nour @ARGNAMES = qw(RANK FXGC SENSE ANTISENSE START END STRAND PRIMARY SOURCE_TAG\n\t\t   SCORE TAG SEQNAME ANNOTATION LOCATION);\n\n=head1 METHODS\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: my $sirna_pair = Bio::SeqFeature::SiRNA::Pair->new();\n  Purpose\t: Create a new SiRNA::Pair object\n  Returns\t: Bio::Tools::SiRNA object\n  Args\t\t: -start \t10\n                  -end\t\t31\n                  -rank\t\t1 #  'Rank' in Tuschl group's rules\n                  -fxgc\t\t0.5 # GC fraction for target sequence\n\t\t  -primary\t'SiRNA::Pair', # default value\n\t\t  -source_tag\t'Bio::Tools::SiRNA'\n\t\t  -tag\t\t{ note => 'A note' }\n                  -sense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = 1\n                  -antisense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = -1\n);\n\n  Note\t\t: SiRNA::Pair objects are typically created by a design \n                  algorithm such as Bio::Tools::SiRNA","parameters":[{"label":"$proto"},{"label":"@args"}],"label":"new($proto,@args)"},"line":127,"range":{"end":{"line":156,"character":9999},"start":{"line":127,"character":0}},"kind":12,"definition":"sub","detail":"($proto,@args)","children":[{"name":"$proto","localvar":"my","kind":13,"containerName":"new","line":128,"definition":"my"},{"line":128,"name":"@args","kind":13,"containerName":"new"},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$pkg","line":130},{"line":130,"name":"$proto","kind":13,"containerName":"new"},{"line":130,"kind":13,"containerName":"new","name":"$proto"},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$self","line":132},{"name":"$pkg","containerName":"new","kind":13,"line":132},{"line":133,"name":"%args","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"line":134,"name":"@args","containerName":"new","kind":13},{"name":"@ARGNAMES","kind":13,"containerName":"new","line":134},{"line":134,"name":"$self","kind":13,"containerName":"new"},{"name":"_rearrange","kind":12,"containerName":"new","line":134},{"name":"@ARGNAMES","containerName":"new","kind":13,"line":134},{"line":134,"kind":13,"containerName":"new","name":"@args"},{"name":"$args","kind":13,"containerName":"new","line":136},{"kind":13,"containerName":"new","name":"$args","line":138},{"containerName":"new","kind":13,"name":"$self","line":138},{"line":138,"name":"primary_tag","kind":12,"containerName":"new"},{"name":"$args","kind":13,"containerName":"new","line":138},{"line":139,"kind":13,"containerName":"new","name":"$args"},{"kind":13,"containerName":"new","name":"$self","line":139},{"line":139,"kind":12,"containerName":"new","name":"source_tag"},{"line":139,"kind":13,"containerName":"new","name":"$args"},{"containerName":"new","kind":13,"name":"$args","line":140},{"line":140,"name":"$self","containerName":"new","kind":13},{"line":140,"name":"seqname","containerName":"new","kind":12},{"line":140,"kind":13,"containerName":"new","name":"$args"},{"name":"$args","kind":13,"containerName":"new","line":141},{"kind":13,"containerName":"new","name":"$self","line":141},{"line":141,"name":"annotation","containerName":"new","kind":12},{"line":141,"name":"$args","kind":13,"containerName":"new"},{"name":"$args","containerName":"new","kind":13,"line":142},{"name":"$self","containerName":"new","kind":13,"line":142},{"name":"location","containerName":"new","kind":12,"line":142},{"line":142,"name":"$args","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$args","line":143},{"line":143,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","kind":12,"name":"sense","line":143},{"containerName":"new","kind":13,"name":"$args","line":143},{"line":144,"containerName":"new","kind":13,"name":"$args"},{"line":144,"name":"$self","containerName":"new","kind":13},{"line":144,"name":"antisense","kind":12,"containerName":"new"},{"name":"$args","kind":13,"containerName":"new","line":144},{"line":145,"name":"$args","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":145},{"containerName":"new","kind":12,"name":"start","line":145},{"line":145,"name":"$args","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$args","line":146},{"containerName":"new","kind":13,"name":"$self","line":146},{"line":146,"name":"end","containerName":"new","kind":12},{"line":146,"name":"$args","kind":13,"containerName":"new"},{"name":"$args","containerName":"new","kind":13,"line":147},{"kind":13,"containerName":"new","name":"$self","line":147},{"containerName":"new","kind":12,"name":"strand","line":147},{"name":"$args","kind":13,"containerName":"new","line":147},{"line":148,"containerName":"new","kind":13,"name":"$args"},{"kind":13,"containerName":"new","name":"$self","line":148},{"name":"score","kind":12,"containerName":"new","line":148},{"containerName":"new","kind":13,"name":"$args","line":148},{"name":"$args","containerName":"new","kind":13,"line":149},{"line":149,"containerName":"new","kind":13,"name":"$self"},{"kind":12,"containerName":"new","name":"rank","line":149},{"kind":13,"containerName":"new","name":"$args","line":149},{"line":150,"name":"$args","kind":13,"containerName":"new"},{"line":150,"kind":13,"containerName":"new","name":"$self"},{"line":150,"kind":12,"containerName":"new","name":"fxGC"},{"line":150,"name":"$args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$args","line":152},{"definition":"my","name":"$t","containerName":"new","localvar":"my","kind":13,"line":153},{"line":153,"name":"$args","containerName":"new","kind":13},{"name":"$self","kind":13,"containerName":"new","line":154},{"containerName":"new","kind":12,"name":"add_tag_value","line":154},{"line":154,"kind":13,"containerName":"new","name":"$t"},{"line":154,"kind":13,"containerName":"new","name":"$args"},{"line":154,"kind":13,"containerName":"new","name":"$t"}],"name":"new","containerName":"main::"},{"line":132,"kind":12,"containerName":"new","name":"SUPER"},{"name":"$self","containerName":null,"kind":13,"line":159},{"signature":{"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SiRNA::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Donald Jackson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SiRNA::Pair - Perl object for small inhibitory RNA\n(SiRNA) oligo pairs\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::SiRNA::Pair;\n  my $pair = Bio::SeqFeature::SiRNA::Pair->\n      new( -sense       => $bio_seqfeature_sirna_oligo, # strand=1\n           -antisense\t=> $bio_seqfeature_sirna_oligo, # strand= -1\n\t   -primary\t=> 'SiRNA::Pair',\n\t   -source_tag \t=> 'Bio::Tools::SiRNA',\n\t   -start\t=> 8,\n\t   -end\t\t=> 31,\n\t   -rank\t=> 1,\n\t   -fxgc\t=> 0.5,\n\t   -tag\t\t=> { note => 'a note' } );\n\n  $target_sequence->add_SeqFeature($pair);\t\t\t\t\t\n\n=head1 DESCRIPTION\n\nObject methods for (complementary) pairs of L<Bio::SeqFeature::SiRNA::Oligo> \nobjects - inherits L<Bio::SeqFeature::Generic>. See that package for information\non inherited methods.\n\nDoes B<not> include methods for designing SiRNAs -- see L<Bio::Tools::SiRNA>\n\n=head1 SEE ALSO\n\nL<Bio::SeqFeature::Oligo>, L<Bio::Tools::SiRNA>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqFeature::SiRNA::Pair;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n# arguments to new().  Taken from Bio::SeqFeature Generic.\n# Omit frame (not relevant), GFF_STRING and GFF1_STRING \n# because I'm not sure how to handle them.  Add RANK, FXGC, SENSE, ANTISENSE\nour @ARGNAMES = qw(RANK FXGC SENSE ANTISENSE START END STRAND PRIMARY SOURCE_TAG\n\t\t   SCORE TAG SEQNAME ANNOTATION LOCATION);\n\n=head1 METHODS\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: my $sirna_pair = Bio::SeqFeature::SiRNA::Pair->new();\n  Purpose\t: Create a new SiRNA::Pair object\n  Returns\t: Bio::Tools::SiRNA object\n  Args\t\t: -start \t10\n                  -end\t\t31\n                  -rank\t\t1 #  'Rank' in Tuschl group's rules\n                  -fxgc\t\t0.5 # GC fraction for target sequence\n\t\t  -primary\t'SiRNA::Pair', # default value\n\t\t  -source_tag\t'Bio::Tools::SiRNA'\n\t\t  -tag\t\t{ note => 'A note' }\n                  -sense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = 1\n                  -antisense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = -1\n);\n\n  Note\t\t: SiRNA::Pair objects are typically created by a design \n                  algorithm such as Bio::Tools::SiRNA\n\n\nsub new {\n    my ($proto, @args) = @_;\n\n    my $pkg = ref($proto) || $proto;\n\n    my $self = $pkg->SUPER::new();\n    my %args;\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    # default primary tag\n    $args{'PRIMARY'} ||= 'SiRNA::Pair';\n\n    $args{'PRIMARY'}\t\t&& $self->primary_tag($args{'PRIMARY'});\n    $args{'SOURCE_TAG'}\t\t&& $self->source_tag($args{'SOURCE_TAG'});\n    $args{'SEQNAME'}\t\t&& $self->seqname($args{'SEQNAME'});\n    $args{'ANNOTATION'}\t\t&& $self->annotation($args{'ANNOTATION'});\n    $args{'LOCATION'}\t\t&& $self->location($args{'LOCATION'});\n    $args{'SENSE'}\t\t&& $self->sense($args{'SENSE'});\n    $args{'ANTISENSE'}\t\t&& $self->antisense($args{'ANTISENSE'});\n    defined($args{'START'})\t&& $self->start($args{'START'});\n    defined($args{'END'})\t&& $self->end($args{'END'});\n    defined($args{'STRAND'})\t&& $self->strand($args{'STRAND'});\n    defined($args{'SCORE'})\t&& $self->score($args{'SCORE'});\n    defined($args{'RANK'})\t&& $self->rank($args{'RANK'});\n    defined($args{'FXGC'})\t&& $self->fxGC($args{'FXGC'});\n\n    if ($args{'TAG'}) {\t\n\tforeach my $t (keys %{$args{'TAG'}}) {\n\t    $self->add_tag_value($t, $args{'TAG'}->{$t});\n\t}\n    }\n\n\n    return $self;\n}\n\n=head2 rank\n\n  Title\t\t: rank\n  Usage\t\t: my $pair_rank = $sirna_pair->rank()\n  Purpose\t: Get/set the 'quality rank' for this pair.\n                  See Bio::Tools::SiRNA for a description of ranks.\n  Returns\t: scalar\n  Args\t\t: scalar (optional) indicating pair rank","parameters":[{"label":"$self"},{"label":"$rank"}],"label":"rank($self,$rank)"},"line":173,"kind":12,"range":{"end":{"line":191,"character":9999},"start":{"character":0,"line":173}},"definition":"sub","detail":"($self,$rank)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"rank","line":174,"definition":"my"},{"line":174,"kind":13,"containerName":"rank","name":"$rank"},{"name":"$rank","kind":13,"containerName":"rank","line":176},{"line":178,"name":"$self","containerName":"rank","kind":13},{"line":178,"name":"remove_tag","containerName":"rank","kind":12},{"line":178,"name":"$self","containerName":"rank","kind":13},{"line":178,"kind":12,"containerName":"rank","name":"has_tag"},{"line":179,"kind":13,"containerName":"rank","name":"$self"},{"line":179,"kind":12,"containerName":"rank","name":"add_tag_value"},{"name":"$rank","containerName":"rank","kind":13,"line":179},{"line":182,"kind":13,"containerName":"rank","name":"$self"},{"name":"has_tag","containerName":"rank","kind":12,"line":182},{"definition":"my","line":183,"localvar":"my","containerName":"rank","kind":13,"name":"@ranks"},{"line":183,"kind":13,"containerName":"rank","name":"$self"},{"line":183,"name":"each_tag_value","containerName":"rank","kind":12},{"line":184,"name":"@ranks","kind":13,"containerName":"rank"},{"line":187,"containerName":"rank","kind":13,"name":"$self"},{"line":187,"name":"throw","containerName":"rank","kind":12}],"name":"rank","containerName":"main::"},{"signature":{"label":"fxGC($self,$fxGC)","parameters":[{"label":"$self"},{"label":"$fxGC"}],"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SiRNA::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Donald Jackson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SiRNA::Pair - Perl object for small inhibitory RNA\n(SiRNA) oligo pairs\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::SiRNA::Pair;\n  my $pair = Bio::SeqFeature::SiRNA::Pair->\n      new( -sense       => $bio_seqfeature_sirna_oligo, # strand=1\n           -antisense\t=> $bio_seqfeature_sirna_oligo, # strand= -1\n\t   -primary\t=> 'SiRNA::Pair',\n\t   -source_tag \t=> 'Bio::Tools::SiRNA',\n\t   -start\t=> 8,\n\t   -end\t\t=> 31,\n\t   -rank\t=> 1,\n\t   -fxgc\t=> 0.5,\n\t   -tag\t\t=> { note => 'a note' } );\n\n  $target_sequence->add_SeqFeature($pair);\t\t\t\t\t\n\n=head1 DESCRIPTION\n\nObject methods for (complementary) pairs of L<Bio::SeqFeature::SiRNA::Oligo> \nobjects - inherits L<Bio::SeqFeature::Generic>. See that package for information\non inherited methods.\n\nDoes B<not> include methods for designing SiRNAs -- see L<Bio::Tools::SiRNA>\n\n=head1 SEE ALSO\n\nL<Bio::SeqFeature::Oligo>, L<Bio::Tools::SiRNA>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqFeature::SiRNA::Pair;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n# arguments to new().  Taken from Bio::SeqFeature Generic.\n# Omit frame (not relevant), GFF_STRING and GFF1_STRING \n# because I'm not sure how to handle them.  Add RANK, FXGC, SENSE, ANTISENSE\nour @ARGNAMES = qw(RANK FXGC SENSE ANTISENSE START END STRAND PRIMARY SOURCE_TAG\n\t\t   SCORE TAG SEQNAME ANNOTATION LOCATION);\n\n=head1 METHODS\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: my $sirna_pair = Bio::SeqFeature::SiRNA::Pair->new();\n  Purpose\t: Create a new SiRNA::Pair object\n  Returns\t: Bio::Tools::SiRNA object\n  Args\t\t: -start \t10\n                  -end\t\t31\n                  -rank\t\t1 #  'Rank' in Tuschl group's rules\n                  -fxgc\t\t0.5 # GC fraction for target sequence\n\t\t  -primary\t'SiRNA::Pair', # default value\n\t\t  -source_tag\t'Bio::Tools::SiRNA'\n\t\t  -tag\t\t{ note => 'A note' }\n                  -sense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = 1\n                  -antisense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = -1\n);\n\n  Note\t\t: SiRNA::Pair objects are typically created by a design \n                  algorithm such as Bio::Tools::SiRNA\n\n\nsub new {\n    my ($proto, @args) = @_;\n\n    my $pkg = ref($proto) || $proto;\n\n    my $self = $pkg->SUPER::new();\n    my %args;\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    # default primary tag\n    $args{'PRIMARY'} ||= 'SiRNA::Pair';\n\n    $args{'PRIMARY'}\t\t&& $self->primary_tag($args{'PRIMARY'});\n    $args{'SOURCE_TAG'}\t\t&& $self->source_tag($args{'SOURCE_TAG'});\n    $args{'SEQNAME'}\t\t&& $self->seqname($args{'SEQNAME'});\n    $args{'ANNOTATION'}\t\t&& $self->annotation($args{'ANNOTATION'});\n    $args{'LOCATION'}\t\t&& $self->location($args{'LOCATION'});\n    $args{'SENSE'}\t\t&& $self->sense($args{'SENSE'});\n    $args{'ANTISENSE'}\t\t&& $self->antisense($args{'ANTISENSE'});\n    defined($args{'START'})\t&& $self->start($args{'START'});\n    defined($args{'END'})\t&& $self->end($args{'END'});\n    defined($args{'STRAND'})\t&& $self->strand($args{'STRAND'});\n    defined($args{'SCORE'})\t&& $self->score($args{'SCORE'});\n    defined($args{'RANK'})\t&& $self->rank($args{'RANK'});\n    defined($args{'FXGC'})\t&& $self->fxGC($args{'FXGC'});\n\n    if ($args{'TAG'}) {\t\n\tforeach my $t (keys %{$args{'TAG'}}) {\n\t    $self->add_tag_value($t, $args{'TAG'}->{$t});\n\t}\n    }\n\n\n    return $self;\n}\n\n=head2 rank\n\n  Title\t\t: rank\n  Usage\t\t: my $pair_rank = $sirna_pair->rank()\n  Purpose\t: Get/set the 'quality rank' for this pair.\n                  See Bio::Tools::SiRNA for a description of ranks.\n  Returns\t: scalar\n  Args\t\t: scalar (optional) indicating pair rank\n\n\nsub rank {\n    my ($self, $rank) = @_;\n\n    if (defined $rank) {\n\t# first clear out old tags\n\t$self->remove_tag('rank') if ( $self->has_tag('rank') );\n\t$self->add_tag_value('rank', $rank);\n    }\n    else {\n\tif ($self->has_tag('rank')) {\n\t    my @ranks = $self->each_tag_value('rank');\n\t    return shift @ranks;\n\t}\n\telse {\n\t    $self->throw(\"Rank not defined for this Pair\\n\");\n\t    return;\n\t}\n    }\n}\n\n=head2 fxGC\n\n  Title\t\t: fxGC\n  Usage\t\t: my $fxGC = $sirna_pair->fxGC();\n  Purpose \t: Get/set the fraction of GC for this pair - based on TARGET sequence, not oligos.\n  Returns \t: scalar between 0-1\n  Args\t\t: scalar between 0-1 (optional)"},"kind":12,"range":{"start":{"character":0,"line":204},"end":{"character":9999,"line":236}},"line":204,"detail":"($self,$fxGC)","definition":"sub","containerName":"main::","name":"fxGC","children":[{"kind":13,"localvar":"my","containerName":"fxGC","name":"$self","line":205,"definition":"my"},{"name":"$fxGC","containerName":"fxGC","kind":13,"line":205},{"name":"$fxGC","containerName":"fxGC","kind":13,"line":207},{"line":209,"name":"$fxGC","kind":13,"containerName":"fxGC"},{"name":"$self","containerName":"fxGC","kind":13,"line":210},{"containerName":"fxGC","kind":12,"name":"throw","line":210},{"name":"$fxGC","containerName":"fxGC","kind":13,"line":213},{"line":215,"containerName":"fxGC","kind":13,"name":"$fxGC"},{"name":"$fxGC","containerName":"fxGC","kind":13,"line":215},{"name":"$self","containerName":"fxGC","kind":13,"line":216},{"line":216,"kind":12,"containerName":"fxGC","name":"throw"},{"line":219,"name":"$fxGC","kind":13,"containerName":"fxGC"},{"line":223,"containerName":"fxGC","kind":13,"name":"$self"},{"line":223,"containerName":"fxGC","kind":12,"name":"remove_tag"},{"kind":13,"containerName":"fxGC","name":"$self","line":223},{"containerName":"fxGC","kind":12,"name":"has_tag","line":223},{"line":224,"name":"$self","kind":13,"containerName":"fxGC"},{"line":224,"kind":12,"containerName":"fxGC","name":"add_tag_value"},{"line":224,"name":"$fxGC","containerName":"fxGC","kind":13},{"line":225,"name":"$self","kind":13,"containerName":"fxGC"},{"kind":12,"containerName":"fxGC","name":"throw","line":225},{"line":228,"containerName":"fxGC","kind":13,"name":"$self"},{"line":228,"name":"has_tag","kind":12,"containerName":"fxGC"},{"line":229,"name":"@fxGCs","kind":13,"localvar":"my","containerName":"fxGC","definition":"my"},{"name":"$self","containerName":"fxGC","kind":13,"line":229},{"containerName":"fxGC","kind":12,"name":"each_tag_value","line":229},{"line":230,"name":"@fxGCs","containerName":"fxGC","kind":13},{"name":"$self","containerName":"fxGC","kind":13,"line":233},{"line":233,"name":"throw","kind":12,"containerName":"fxGC"}]},{"line":249,"range":{"start":{"line":249,"character":0},"end":{"character":9999,"line":258}},"kind":12,"signature":{"label":"sense($self,$soligo)","documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SiRNA::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Donald Jackson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SiRNA::Pair - Perl object for small inhibitory RNA\n(SiRNA) oligo pairs\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::SiRNA::Pair;\n  my $pair = Bio::SeqFeature::SiRNA::Pair->\n      new( -sense       => $bio_seqfeature_sirna_oligo, # strand=1\n           -antisense\t=> $bio_seqfeature_sirna_oligo, # strand= -1\n\t   -primary\t=> 'SiRNA::Pair',\n\t   -source_tag \t=> 'Bio::Tools::SiRNA',\n\t   -start\t=> 8,\n\t   -end\t\t=> 31,\n\t   -rank\t=> 1,\n\t   -fxgc\t=> 0.5,\n\t   -tag\t\t=> { note => 'a note' } );\n\n  $target_sequence->add_SeqFeature($pair);\t\t\t\t\t\n\n=head1 DESCRIPTION\n\nObject methods for (complementary) pairs of L<Bio::SeqFeature::SiRNA::Oligo> \nobjects - inherits L<Bio::SeqFeature::Generic>. See that package for information\non inherited methods.\n\nDoes B<not> include methods for designing SiRNAs -- see L<Bio::Tools::SiRNA>\n\n=head1 SEE ALSO\n\nL<Bio::SeqFeature::Oligo>, L<Bio::Tools::SiRNA>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqFeature::SiRNA::Pair;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n# arguments to new().  Taken from Bio::SeqFeature Generic.\n# Omit frame (not relevant), GFF_STRING and GFF1_STRING \n# because I'm not sure how to handle them.  Add RANK, FXGC, SENSE, ANTISENSE\nour @ARGNAMES = qw(RANK FXGC SENSE ANTISENSE START END STRAND PRIMARY SOURCE_TAG\n\t\t   SCORE TAG SEQNAME ANNOTATION LOCATION);\n\n=head1 METHODS\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: my $sirna_pair = Bio::SeqFeature::SiRNA::Pair->new();\n  Purpose\t: Create a new SiRNA::Pair object\n  Returns\t: Bio::Tools::SiRNA object\n  Args\t\t: -start \t10\n                  -end\t\t31\n                  -rank\t\t1 #  'Rank' in Tuschl group's rules\n                  -fxgc\t\t0.5 # GC fraction for target sequence\n\t\t  -primary\t'SiRNA::Pair', # default value\n\t\t  -source_tag\t'Bio::Tools::SiRNA'\n\t\t  -tag\t\t{ note => 'A note' }\n                  -sense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = 1\n                  -antisense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = -1\n);\n\n  Note\t\t: SiRNA::Pair objects are typically created by a design \n                  algorithm such as Bio::Tools::SiRNA\n\n\nsub new {\n    my ($proto, @args) = @_;\n\n    my $pkg = ref($proto) || $proto;\n\n    my $self = $pkg->SUPER::new();\n    my %args;\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    # default primary tag\n    $args{'PRIMARY'} ||= 'SiRNA::Pair';\n\n    $args{'PRIMARY'}\t\t&& $self->primary_tag($args{'PRIMARY'});\n    $args{'SOURCE_TAG'}\t\t&& $self->source_tag($args{'SOURCE_TAG'});\n    $args{'SEQNAME'}\t\t&& $self->seqname($args{'SEQNAME'});\n    $args{'ANNOTATION'}\t\t&& $self->annotation($args{'ANNOTATION'});\n    $args{'LOCATION'}\t\t&& $self->location($args{'LOCATION'});\n    $args{'SENSE'}\t\t&& $self->sense($args{'SENSE'});\n    $args{'ANTISENSE'}\t\t&& $self->antisense($args{'ANTISENSE'});\n    defined($args{'START'})\t&& $self->start($args{'START'});\n    defined($args{'END'})\t&& $self->end($args{'END'});\n    defined($args{'STRAND'})\t&& $self->strand($args{'STRAND'});\n    defined($args{'SCORE'})\t&& $self->score($args{'SCORE'});\n    defined($args{'RANK'})\t&& $self->rank($args{'RANK'});\n    defined($args{'FXGC'})\t&& $self->fxGC($args{'FXGC'});\n\n    if ($args{'TAG'}) {\t\n\tforeach my $t (keys %{$args{'TAG'}}) {\n\t    $self->add_tag_value($t, $args{'TAG'}->{$t});\n\t}\n    }\n\n\n    return $self;\n}\n\n=head2 rank\n\n  Title\t\t: rank\n  Usage\t\t: my $pair_rank = $sirna_pair->rank()\n  Purpose\t: Get/set the 'quality rank' for this pair.\n                  See Bio::Tools::SiRNA for a description of ranks.\n  Returns\t: scalar\n  Args\t\t: scalar (optional) indicating pair rank\n\n\nsub rank {\n    my ($self, $rank) = @_;\n\n    if (defined $rank) {\n\t# first clear out old tags\n\t$self->remove_tag('rank') if ( $self->has_tag('rank') );\n\t$self->add_tag_value('rank', $rank);\n    }\n    else {\n\tif ($self->has_tag('rank')) {\n\t    my @ranks = $self->each_tag_value('rank');\n\t    return shift @ranks;\n\t}\n\telse {\n\t    $self->throw(\"Rank not defined for this Pair\\n\");\n\t    return;\n\t}\n    }\n}\n\n=head2 fxGC\n\n  Title\t\t: fxGC\n  Usage\t\t: my $fxGC = $sirna_pair->fxGC();\n  Purpose \t: Get/set the fraction of GC for this pair - based on TARGET sequence, not oligos.\n  Returns \t: scalar between 0-1\n  Args\t\t: scalar between 0-1 (optional)\n\n\n\nsub fxGC {\n    my ($self, $fxGC) = @_;\n\n    if (defined $fxGC) {\n\t# is this an integer?\n\tif ($fxGC =~ /[^.\\d]/) {\n\t    $self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t   -text  => \"Fraction GC must be a number between 0, 1 - NOT <$fxGC>\",\n\t\t\t   -value => $fxGC\n\t\t\t   );\n\t}\n\tif  ( $fxGC < 0 or $fxGC > 1 ) {\n\t    $self->throw( -class => 'Bio::Root::BadParameter',\n\t\t\t  -text  => \"Fraction GC must be a number between 0, 1 - NOT <$fxGC>\",\n\t\t\t   -value => $fxGC\n);\n\t}\n\t    \n\t#  clear out old tags\n\t$self->remove_tag('fxGC') if ( $self->has_tag('fxGC') );\n\t$self->add_tag_value('fxGC', $fxGC)\n\t    or $self->throw(\"Unable to set fxGC\");\n    }\n    else {\n\tif ($self->has_tag('fxGC')) {\n\t    my @fxGCs = $self->each_tag_value('fxGC');\n\t    return shift @fxGCs;\n\t}\n\telse {\n\t    $self->throw(\"FxGC not defined for this Pair\");\n\t}\n    }\n}\n\n=head2 sense\n\n  Title\t\t: sense\n  Usage\t\t: my $sense_oligo = $sirna_pair->sense()\n  Purpose\t: Get/set the SiRNA::Oligo object corresponding to the sense strand\n  Returns \t: Bio::SeqFeature::SiRNA::Oligo object\n  Args\t\t: Bio::SeqFeature::SiRNA::Oligo object","parameters":[{"label":"$self"},{"label":"$soligo"}]},"children":[{"line":250,"localvar":"my","containerName":"sense","kind":13,"name":"$self","definition":"my"},{"containerName":"sense","kind":13,"name":"$soligo","line":250},{"line":252,"containerName":"sense","kind":13,"name":"$soligo"},{"line":253,"kind":13,"containerName":"sense","name":"$self"},{"line":253,"name":"_add_oligo","containerName":"sense","kind":12},{"containerName":"sense","kind":13,"name":"$soligo","line":253},{"line":256,"containerName":"sense","kind":13,"name":"$self"},{"name":"_get_oligo","kind":12,"containerName":"sense","line":256}],"containerName":"main::","name":"sense","definition":"sub","detail":"($self,$soligo)"},{"children":[{"definition":"my","kind":13,"localvar":"my","containerName":"antisense","name":"$self","line":271},{"line":271,"kind":13,"containerName":"antisense","name":"$asoligo"},{"kind":13,"containerName":"antisense","name":"$asoligo","line":273},{"line":274,"name":"$self","kind":13,"containerName":"antisense"},{"containerName":"antisense","kind":12,"name":"_add_oligo","line":274},{"line":274,"name":"$asoligo","kind":13,"containerName":"antisense"},{"line":277,"name":"$self","containerName":"antisense","kind":13},{"line":277,"kind":12,"containerName":"antisense","name":"_get_oligo"}],"containerName":"main::","name":"antisense","definition":"sub","detail":"($self,$asoligo)","line":270,"kind":12,"range":{"end":{"character":9999,"line":279},"start":{"character":0,"line":270}},"signature":{"documentation":"1;\n# $Id: Pair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::SeqFeature::SiRNA::Pair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Donald Jackson, donald.jackson@bms.com\n#\n# Copyright Donald Jackson\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::SeqFeature::SiRNA::Pair - Perl object for small inhibitory RNA\n(SiRNA) oligo pairs\n\n=head1 SYNOPSIS\n\n  use Bio::SeqFeature::SiRNA::Pair;\n  my $pair = Bio::SeqFeature::SiRNA::Pair->\n      new( -sense       => $bio_seqfeature_sirna_oligo, # strand=1\n           -antisense\t=> $bio_seqfeature_sirna_oligo, # strand= -1\n\t   -primary\t=> 'SiRNA::Pair',\n\t   -source_tag \t=> 'Bio::Tools::SiRNA',\n\t   -start\t=> 8,\n\t   -end\t\t=> 31,\n\t   -rank\t=> 1,\n\t   -fxgc\t=> 0.5,\n\t   -tag\t\t=> { note => 'a note' } );\n\n  $target_sequence->add_SeqFeature($pair);\t\t\t\t\t\n\n=head1 DESCRIPTION\n\nObject methods for (complementary) pairs of L<Bio::SeqFeature::SiRNA::Oligo> \nobjects - inherits L<Bio::SeqFeature::Generic>. See that package for information\non inherited methods.\n\nDoes B<not> include methods for designing SiRNAs -- see L<Bio::Tools::SiRNA>\n\n=head1 SEE ALSO\n\nL<Bio::SeqFeature::Oligo>, L<Bio::Tools::SiRNA>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\nDonald Jackson (donald.jackson@bms.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::SeqFeature::SiRNA::Pair;\n\nuse strict;\nuse warnings;\n\nuse base qw(Bio::SeqFeature::Generic);\n\n# arguments to new().  Taken from Bio::SeqFeature Generic.\n# Omit frame (not relevant), GFF_STRING and GFF1_STRING \n# because I'm not sure how to handle them.  Add RANK, FXGC, SENSE, ANTISENSE\nour @ARGNAMES = qw(RANK FXGC SENSE ANTISENSE START END STRAND PRIMARY SOURCE_TAG\n\t\t   SCORE TAG SEQNAME ANNOTATION LOCATION);\n\n=head1 METHODS\n\n=head2 new\n\n  Title\t\t: new\n  Usage\t\t: my $sirna_pair = Bio::SeqFeature::SiRNA::Pair->new();\n  Purpose\t: Create a new SiRNA::Pair object\n  Returns\t: Bio::Tools::SiRNA object\n  Args\t\t: -start \t10\n                  -end\t\t31\n                  -rank\t\t1 #  'Rank' in Tuschl group's rules\n                  -fxgc\t\t0.5 # GC fraction for target sequence\n\t\t  -primary\t'SiRNA::Pair', # default value\n\t\t  -source_tag\t'Bio::Tools::SiRNA'\n\t\t  -tag\t\t{ note => 'A note' }\n                  -sense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = 1\n                  -antisense\ta Bio::SeqFeature::SiRNA::Oligo object\n                                with strand = -1\n);\n\n  Note\t\t: SiRNA::Pair objects are typically created by a design \n                  algorithm such as Bio::Tools::SiRNA\n\n\nsub new {\n    my ($proto, @args) = @_;\n\n    my $pkg = ref($proto) || $proto;\n\n    my $self = $pkg->SUPER::new();\n    my %args;\n    @args{@ARGNAMES} = $self->_rearrange(\\@ARGNAMES, @args); \n    # default primary tag\n    $args{'PRIMARY'} ||= 'SiRNA::Pair';\n\n    $args{'PRIMARY'}\t\t&& $self->primary_tag($args{'PRIMARY'});\n    $args{'SOURCE_TAG'}\t\t&& $self->source_tag($args{'SOURCE_TAG'});\n    $args{'SEQNAME'}\t\t&& $self->seqname($args{'SEQNAME'});\n    $args{'ANNOTATION'}\t\t&& $self->annotation($args{'ANNOTATION'});\n    $args{'LOCATION'}\t\t&& $self->location($args{'LOCATION'});\n    $args{'SENSE'}\t\t&& $self->sense($args{'SENSE'});\n    $args{'ANTISENSE'}\t\t&& $self->antisense($args{'ANTISENSE'});\n    defined($args{'START'})\t&& $self->start($args{'START'});\n    defined($args{'END'})\t&& $self->end($args{'END'});\n    defined($args{'STRAND'})\t&& $self->strand($args{'STRAND'});\n    defined($args{'SCORE'})\t&& $self->score($args{'SCORE'});\n    defined($args{'RANK'})\t&& $self->rank($args{'RANK'});\n    defined($args{'FXGC'})\t&& $self->fxGC($args{'FXGC'});\n\n    if ($args{'TAG'}) {\t\n\tforeach my $t (keys %{$args{'TAG'}}) {\n\t    $self->add_tag_value($t, $args{'TAG'}->{$t});\n\t}\n    }\n\n\n    return $self;\n}\n\n=head2 rank\n\n  Title\t\t: rank\n  Usage\t\t: my $pair_rank = $sirna_pair->rank()\n  Purpose\t: Get/set the 'quality rank' for this pair.\n                  See Bio::Tools::SiRNA for a description of ranks.\n  Returns\t: scalar\n  Args\t\t: scalar (optional) indicating pair rank\n\n\nsub rank {\n    my ($self, $rank) = @_;\n\n    if (defined $rank) {\n\t# first clear out old tags\n\t$self->remove_tag('rank') if ( $self->has_tag('rank') );\n\t$self->add_tag_value('rank', $rank);\n    }\n    else {\n\tif ($self->has_tag('rank')) {\n\t    my @ranks = $self->each_tag_value('rank');\n\t    return shift @ranks;\n\t}\n\telse {\n\t    $self->throw(\"Rank not defined for this Pair\\n\");\n\t    return;\n\t}\n    }\n}\n\n=head2 fxGC\n\n  Title\t\t: fxGC\n  Usage\t\t: my $fxGC = $sirna_pair->fxGC();\n  Purpose \t: Get/set the fraction of GC for this pair - based on TARGET sequence, not oligos.\n  Returns \t: scalar between 0-1\n  Args\t\t: scalar between 0-1 (optional)\n\n\n\nsub fxGC {\n    my ($self, $fxGC) = @_;\n\n    if (defined $fxGC) {\n\t# is this an integer?\n\tif ($fxGC =~ /[^.\\d]/) {\n\t    $self->throw(  -class => 'Bio::Root::BadParameter',\n\t\t\t   -text  => \"Fraction GC must be a number between 0, 1 - NOT <$fxGC>\",\n\t\t\t   -value => $fxGC\n\t\t\t   );\n\t}\n\tif  ( $fxGC < 0 or $fxGC > 1 ) {\n\t    $self->throw( -class => 'Bio::Root::BadParameter',\n\t\t\t  -text  => \"Fraction GC must be a number between 0, 1 - NOT <$fxGC>\",\n\t\t\t   -value => $fxGC\n);\n\t}\n\t    \n\t#  clear out old tags\n\t$self->remove_tag('fxGC') if ( $self->has_tag('fxGC') );\n\t$self->add_tag_value('fxGC', $fxGC)\n\t    or $self->throw(\"Unable to set fxGC\");\n    }\n    else {\n\tif ($self->has_tag('fxGC')) {\n\t    my @fxGCs = $self->each_tag_value('fxGC');\n\t    return shift @fxGCs;\n\t}\n\telse {\n\t    $self->throw(\"FxGC not defined for this Pair\");\n\t}\n    }\n}\n\n=head2 sense\n\n  Title\t\t: sense\n  Usage\t\t: my $sense_oligo = $sirna_pair->sense()\n  Purpose\t: Get/set the SiRNA::Oligo object corresponding to the sense strand\n  Returns \t: Bio::SeqFeature::SiRNA::Oligo object\n  Args\t\t: Bio::SeqFeature::SiRNA::Oligo object\n\n\n\nsub sense {\n    my ($self, $soligo) = @_;\n\n    if ($soligo) {\n\t$self->_add_oligo($soligo, 1) or return;\n    }\n    else {\n\treturn $self->_get_oligo(1);\n    }\n}\n\n=head2 antisense\n\n  Title\t\t: antisense\n  Usage\t\t: my $antisense_oligo = $sirna_pair->antisense()\n  Purpose\t: Get/set the SiRNA::Oligo object corresponding to the antisense strand\n  Returns \t: Bio::SeqFeature::SiRNA::Oligo object\n  Args\t\t: Bio::SeqFeature::SiRNA::Oligo object","parameters":[{"label":"$self"},{"label":"$asoligo"}],"label":"antisense($self,$asoligo)"}},{"line":281,"kind":12,"range":{"end":{"line":291,"character":9999},"start":{"line":281,"character":0}},"signature":{"label":"_add_oligo($self,$oligo,$strand)","documentation":"","parameters":[{"label":"$self"},{"label":"$oligo"},{"label":"$strand"}]},"children":[{"line":282,"name":"$self","kind":13,"localvar":"my","containerName":"_add_oligo","definition":"my"},{"line":282,"name":"$oligo","containerName":"_add_oligo","kind":13},{"containerName":"_add_oligo","kind":13,"name":"$strand","line":282},{"kind":13,"containerName":"_add_oligo","name":"$oligo","line":284},{"name":"isa","kind":12,"containerName":"_add_oligo","line":284},{"name":"$self","kind":13,"containerName":"_add_oligo","line":285},{"line":285,"containerName":"_add_oligo","kind":12,"name":"throw"},{"containerName":"_add_oligo","kind":13,"name":"$oligo","line":289},{"kind":12,"containerName":"_add_oligo","name":"strand","line":289},{"line":289,"containerName":"_add_oligo","kind":13,"name":"$strand"},{"kind":13,"containerName":"_add_oligo","name":"$self","line":290},{"line":290,"kind":12,"containerName":"_add_oligo","name":"add_sub_SeqFeature"},{"line":290,"name":"$oligo","containerName":"_add_oligo","kind":13}],"containerName":"main::","name":"_add_oligo","definition":"sub","detail":"($self,$oligo,$strand)"},{"name":"_get_oligo","containerName":"main::","children":[{"definition":"my","line":294,"localvar":"my","kind":13,"containerName":"_get_oligo","name":"$self"},{"name":"$strand","containerName":"_get_oligo","kind":13,"line":294},{"definition":"my","name":"$feat","containerName":"_get_oligo","localvar":"my","kind":13,"line":295},{"definition":"my","line":297,"name":"@feats","kind":13,"localvar":"my","containerName":"_get_oligo"},{"containerName":"_get_oligo","kind":13,"name":"$self","line":297},{"line":297,"containerName":"_get_oligo","kind":12,"name":"sub_SeqFeature"},{"line":299,"containerName":"_get_oligo","kind":13,"name":"$feat"},{"line":299,"containerName":"_get_oligo","kind":13,"name":"@feats"},{"line":300,"name":"$feat","kind":13,"containerName":"_get_oligo"},{"line":300,"name":"primary_tag","kind":12,"containerName":"_get_oligo"},{"line":301,"kind":13,"containerName":"_get_oligo","name":"$feat"},{"line":301,"name":"strand","kind":12,"containerName":"_get_oligo"},{"line":301,"name":"$strand","kind":13,"containerName":"_get_oligo"},{"name":"$feat","kind":13,"containerName":"_get_oligo","line":302}],"detail":"($self,$strand)","definition":"sub","kind":12,"range":{"start":{"line":293,"character":0},"end":{"line":305,"character":9999}},"line":293,"signature":{"label":"_get_oligo($self,$strand)","parameters":[{"label":"$self"},{"label":"$strand"}],"documentation":""}}],"version":5}