{"vars":[{"containerName":"","kind":2,"name":"base","line":110},{"detail":"($self,@args)","definition":"sub","name":"_initialize","containerName":"main::","children":[{"definition":"my","line":115,"containerName":"_initialize","localvar":"my","kind":13,"name":"$self"},{"name":"@args","kind":13,"containerName":"_initialize","line":115},{"line":116,"name":"$self","kind":13,"containerName":"_initialize"},{"name":"@args","kind":13,"containerName":"_initialize","line":116},{"definition":"my","name":"%tmp","localvar":"my","kind":13,"containerName":"_initialize","line":118},{"containerName":"_initialize","kind":13,"name":"@args","line":118},{"line":119,"kind":13,"containerName":"_initialize","name":"$self"},{"name":"$tmp","kind":13,"containerName":"_initialize","line":119},{"kind":13,"containerName":"_initialize","name":"$self","line":121},{"line":122,"containerName":"_initialize","kind":13,"name":"$self"},{"containerName":"_initialize","kind":12,"name":"_process","line":122},{"name":"$self","kind":13,"containerName":"_initialize","line":125},{"line":129,"name":"$self","kind":13,"containerName":"_initialize"}],"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"kind":12,"range":{"end":{"character":9999,"line":131},"start":{"character":0,"line":113}},"line":113},{"line":116,"containerName":"_initialize","kind":12,"name":"SUPER"},{"signature":{"label":"_process($self)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":183,"character":9999},"start":{"character":0,"line":147}},"line":147,"detail":"($self)","definition":"sub","name":"_process","containerName":"main::","children":[{"definition":"my","line":148,"name":"$self","localvar":"my","kind":13,"containerName":"_process"},{"definition":"my","line":152,"name":"$line","localvar":"my","containerName":"_process","kind":13},{"kind":13,"containerName":"_process","name":"$self","line":152},{"kind":12,"containerName":"_process","name":"_readline","line":152},{"name":"$line","containerName":"_process","kind":13,"line":153},{"name":"$line","containerName":"_process","kind":13,"line":154},{"name":"$line","containerName":"_process","kind":13,"line":156},{"name":"$line","containerName":"_process","kind":13,"line":160},{"name":"$self","containerName":"_process","kind":13,"line":162},{"containerName":"_process","kind":12,"name":"throw","line":162},{"name":"$line","containerName":"_process","kind":13,"line":165},{"kind":13,"containerName":"_process","name":"$self","line":167},{"name":"$self","containerName":"_process","kind":13,"line":167},{"line":167,"kind":12,"containerName":"_process","name":"_process_sciobj"},{"name":"$line","containerName":"_process","kind":13,"line":169}]},{"detail":"($self,$attribute_line)","definition":"sub","name":"_process_sciobj","containerName":"main::","children":[{"name":"$self","localvar":"my","containerName":"_process_sciobj","kind":13,"line":207,"definition":"my"},{"line":207,"name":"$attribute_line","containerName":"_process_sciobj","kind":13},{"definition":"my","name":"$sciobj","containerName":"_process_sciobj","localvar":"my","kind":13,"line":208},{"line":209,"name":"$self","containerName":"_process_sciobj","kind":13},{"name":"_helper_store_attribute_list","kind":12,"containerName":"_process_sciobj","line":209},{"name":"$attribute_line","kind":13,"containerName":"_process_sciobj","line":209},{"kind":13,"containerName":"_process_sciobj","name":"$sciobj","line":209},{"definition":"my","name":"$line","localvar":"my","containerName":"_process_sciobj","kind":13,"line":211},{"line":211,"containerName":"_process_sciobj","kind":13,"name":"$self"},{"line":211,"name":"_readline","kind":12,"containerName":"_process_sciobj"},{"name":"$line","kind":13,"containerName":"_process_sciobj","line":214},{"kind":13,"localvar":"my","containerName":"_process_sciobj","name":"$contig","line":215,"definition":"my"},{"name":"$self","containerName":"_process_sciobj","kind":13,"line":215},{"line":215,"kind":12,"containerName":"_process_sciobj","name":"_process_contig"},{"containerName":"_process_sciobj","kind":13,"name":"$line","line":215},{"line":216,"containerName":"_process_sciobj","kind":13,"name":"$sciobj"},{"name":"$contig","containerName":"_process_sciobj","kind":13,"line":216}],"signature":{"label":"_process_sciobj($self,$attribute_line)","parameters":[{"label":"$self"},{"label":"$attribute_line"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig"},"range":{"start":{"character":0,"line":205},"end":{"character":9999,"line":219}},"kind":12,"line":205},{"line":221,"kind":13,"containerName":null,"name":"$sciobj"},{"line":242,"kind":12,"range":{"start":{"line":242,"character":0},"end":{"character":9999,"line":259}},"signature":{"label":"_process_contig($self,$line,$attribute_line)","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$attribute_line"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order"},"children":[{"definition":"my","localvar":"my","containerName":"_process_contig","kind":13,"name":"$self","line":244},{"name":"$line","containerName":"_process_contig","kind":13,"line":244},{"containerName":"_process_contig","kind":13,"name":"$attribute_line","line":244},{"definition":"my","line":246,"name":"$contig","localvar":"my","containerName":"_process_contig","kind":13},{"name":"$self","containerName":"_process_contig","kind":13,"line":247},{"line":247,"containerName":"_process_contig","kind":12,"name":"_helper_store_attribute_list"},{"line":247,"containerName":"_process_contig","kind":13,"name":"$attribute_line"},{"name":"$contig","kind":13,"containerName":"_process_contig","line":247},{"line":248,"containerName":"_process_contig","kind":13,"name":"$self"},{"name":"_readline","containerName":"_process_contig","kind":12,"line":248},{"line":251,"name":"$self","containerName":"_process_contig","kind":13},{"line":251,"name":"_one_tag","kind":12,"containerName":"_process_contig"},{"containerName":"_process_contig","kind":13,"name":"$line","line":251},{"name":"$contig","containerName":"_process_contig","kind":13,"line":251},{"name":"$self","containerName":"_process_contig","kind":13,"line":255},{"containerName":"_process_contig","kind":12,"name":"_process_fragment_order","line":255},{"line":255,"containerName":"_process_contig","kind":13,"name":"$line"},{"line":255,"kind":13,"containerName":"_process_contig","name":"$contig"},{"kind":13,"containerName":"_process_contig","name":"$contig","line":257}],"name":"_process_contig","containerName":"main::","definition":"sub","detail":"($self,$line,$attribute_line)"},{"name":"line","kind":12,"line":248},{"detail":"($self,$line,$data_structure)","definition":"sub","containerName":"main::","name":"_process_fragment_order","children":[{"definition":"my","containerName":"_process_fragment_order","localvar":"my","kind":13,"name":"$self","line":280},{"kind":13,"containerName":"_process_fragment_order","name":"$line","line":280},{"name":"$data_structure","kind":13,"containerName":"_process_fragment_order","line":280},{"line":286,"kind":13,"localvar":"my","containerName":"_process_fragment_order","name":"$fragment_order","definition":"my"},{"name":"$self","containerName":"_process_fragment_order","kind":13,"line":287},{"line":287,"kind":12,"containerName":"_process_fragment_order","name":"_helper_store_attribute_list"},{"name":"$fragment_order","kind":13,"containerName":"_process_fragment_order","line":287},{"name":"$self","kind":13,"containerName":"_process_fragment_order","line":290},{"line":290,"name":"_readline","containerName":"_process_fragment_order","kind":12},{"name":"$self","kind":13,"containerName":"_process_fragment_order","line":293},{"name":"_process_fragment_orientation","kind":12,"containerName":"_process_fragment_order","line":293},{"containerName":"_process_fragment_order","kind":13,"name":"$line","line":293},{"line":293,"containerName":"_process_fragment_order","kind":13,"name":"$fragment_order"},{"line":296,"name":"$fragment_order","kind":13,"containerName":"_process_fragment_order"}],"signature":{"label":"_process_fragment_order($self,$line,$data_structure)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"}]},"range":{"end":{"character":9999,"line":300},"start":{"line":277,"character":0}},"kind":12,"line":277},{"kind":12,"name":"line","line":284},{"name":"line","kind":12,"line":290},{"line":296,"kind":12,"name":"data_structure"},{"definition":"sub","detail":"($self,$line,$data_structure)","children":[{"definition":"my","line":327,"name":"$self","containerName":"_process_fragment_orientation","localvar":"my","kind":13},{"line":327,"kind":13,"containerName":"_process_fragment_orientation","name":"$line"},{"name":"$data_structure","containerName":"_process_fragment_orientation","kind":13,"line":327},{"definition":"my","containerName":"_process_fragment_orientation","localvar":"my","kind":13,"name":"$count","line":330},{"line":335,"name":"$fragment_orientation","containerName":"_process_fragment_orientation","localvar":"my","kind":13,"definition":"my"},{"name":"$self","kind":13,"containerName":"_process_fragment_orientation","line":336},{"line":336,"name":"_helper_store_attribute_list","kind":12,"containerName":"_process_fragment_orientation"},{"line":336,"kind":13,"containerName":"_process_fragment_orientation","name":"$fragment_orientation"},{"containerName":"_process_fragment_orientation","kind":13,"name":"$self","line":337},{"name":"_readline","kind":12,"containerName":"_process_fragment_orientation","line":337},{"line":342,"name":"$bio_sequence","kind":13,"localvar":"my","containerName":"_process_fragment_orientation","definition":"my"},{"line":342,"name":"$self","kind":13,"containerName":"_process_fragment_orientation"},{"name":"_process_bio_sequence","containerName":"_process_fragment_orientation","kind":12,"line":342},{"kind":13,"containerName":"_process_fragment_orientation","name":"$line","line":342},{"name":"$fragment_orientation","containerName":"_process_fragment_orientation","kind":13,"line":343},{"containerName":"_process_fragment_orientation","kind":13,"name":"$bio_sequence","line":343},{"line":345,"containerName":"_process_fragment_orientation","kind":13,"name":"$fragment_orientation"},{"line":347,"name":"$count","containerName":"_process_fragment_orientation","kind":13}],"name":"_process_fragment_orientation","containerName":"main::","signature":{"label":"_process_fragment_orientation($self,$line,$data_structure)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"}]},"line":324,"kind":12,"range":{"end":{"character":9999,"line":348},"start":{"character":0,"line":324}}},{"name":"line","kind":12,"line":333},{"name":"line","kind":12,"line":337},{"kind":12,"name":"line","line":340},{"line":345,"kind":12,"name":"data_structure"},{"line":351,"containerName":null,"kind":13,"name":"$self"},{"name":"throw","kind":12,"containerName":"main::","line":351},{"kind":13,"containerName":null,"name":"$count","line":352},{"children":[{"line":378,"name":"$self","kind":13,"localvar":"my","containerName":"_process_bio_sequence","definition":"my"},{"name":"$line","containerName":"_process_bio_sequence","kind":13,"line":378},{"line":378,"containerName":"_process_bio_sequence","kind":13,"name":"$attribute_line"},{"definition":"my","containerName":"_process_bio_sequence","localvar":"my","kind":13,"name":"$bio_sequence","line":380},{"line":382,"name":"$self","kind":13,"containerName":"_process_bio_sequence"},{"kind":12,"containerName":"_process_bio_sequence","name":"_helper_store_attribute_list","line":382},{"line":382,"name":"$attribute_line","containerName":"_process_bio_sequence","kind":13},{"kind":13,"containerName":"_process_bio_sequence","name":"$bio_sequence","line":382},{"line":383,"name":"$self","containerName":"_process_bio_sequence","kind":13},{"line":383,"kind":12,"containerName":"_process_bio_sequence","name":"_readline"},{"name":"$self","containerName":"_process_bio_sequence","kind":13,"line":387},{"name":"_one_tag","containerName":"_process_bio_sequence","kind":12,"line":387},{"containerName":"_process_bio_sequence","kind":13,"name":"$line","line":387},{"name":"$bio_sequence","kind":13,"containerName":"_process_bio_sequence","line":387},{"name":"$self","containerName":"_process_bio_sequence","kind":13,"line":391},{"line":391,"kind":12,"containerName":"_process_bio_sequence","name":"_question_mark_tag"},{"name":"$line","containerName":"_process_bio_sequence","kind":13,"line":391},{"name":"$bio_sequence","containerName":"_process_bio_sequence","kind":13,"line":391},{"name":"$self","containerName":"_process_bio_sequence","kind":13,"line":395},{"containerName":"_process_bio_sequence","kind":12,"name":"_question_mark_tag","line":395},{"line":395,"name":"$line","containerName":"_process_bio_sequence","kind":13},{"containerName":"_process_bio_sequence","kind":13,"name":"$bio_sequence","line":395},{"line":399,"name":"$self","containerName":"_process_bio_sequence","kind":13},{"line":399,"containerName":"_process_bio_sequence","kind":12,"name":"_star_tag"},{"name":"$line","kind":13,"containerName":"_process_bio_sequence","line":399},{"name":"$bio_sequence","kind":13,"containerName":"_process_bio_sequence","line":399},{"kind":13,"containerName":"_process_bio_sequence","name":"$self","line":403},{"kind":12,"containerName":"_process_bio_sequence","name":"_question_mark_tag","line":403},{"line":403,"kind":13,"containerName":"_process_bio_sequence","name":"$line"},{"kind":13,"containerName":"_process_bio_sequence","name":"$bio_sequence","line":403},{"line":416,"containerName":"_process_bio_sequence","localvar":"my","kind":13,"name":"$xrefs","definition":"my"},{"line":416,"name":"$self","kind":13,"containerName":"_process_bio_sequence"},{"kind":12,"containerName":"_process_bio_sequence","name":"_process_xrefs","line":416},{"line":416,"name":"$line","kind":13,"containerName":"_process_bio_sequence"},{"containerName":"_process_bio_sequence","kind":13,"name":"$bio_sequence","line":416},{"containerName":"_process_bio_sequence","kind":13,"name":"$bio_sequence","line":417},{"containerName":"_process_bio_sequence","kind":13,"name":"$xrefs","line":417},{"definition":"my","line":423,"name":"$sequence_map","localvar":"my","kind":13,"containerName":"_process_bio_sequence"},{"line":423,"containerName":"_process_bio_sequence","kind":13,"name":"$self"},{"line":423,"name":"_process_sequence_map","kind":12,"containerName":"_process_bio_sequence"},{"line":423,"containerName":"_process_bio_sequence","kind":13,"name":"$line"},{"kind":13,"containerName":"_process_bio_sequence","name":"$bio_sequence","line":424},{"line":424,"name":"$sequence_map","kind":13,"containerName":"_process_bio_sequence"}],"name":"_process_bio_sequence","containerName":"main::","definition":"sub","detail":"($self,$line,$attribute_line)","line":376,"range":{"start":{"character":0,"line":376},"end":{"line":425,"character":9999}},"kind":12,"signature":{"label":"_process_bio_sequence($self,$line,$attribute_line)","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$attribute_line"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map"}},{"line":383,"kind":12,"name":"line"},{"line":415,"name":"line","kind":12},{"line":422,"name":"line","kind":12},{"line":429,"name":"$bio_sequence","containerName":null,"kind":13},{"definition":"sub","detail":"($self,$line)","children":[{"definition":"my","line":448,"kind":13,"localvar":"my","containerName":"_process_xrefs","name":"$self"},{"containerName":"_process_xrefs","kind":13,"name":"$line","line":448},{"line":450,"name":"$xrefs","containerName":"_process_xrefs","localvar":"my","kind":13,"definition":"my"},{"containerName":"_process_xrefs","kind":13,"name":"$self","line":452},{"name":"_readline","containerName":"_process_xrefs","kind":12,"line":452},{"name":"$db_id","localvar":"my","containerName":"_process_xrefs","kind":13,"line":462,"definition":"my"},{"kind":13,"containerName":"_process_xrefs","name":"$self","line":463},{"line":463,"name":"_one_tag","containerName":"_process_xrefs","kind":12},{"name":"$line","kind":13,"containerName":"_process_xrefs","line":463},{"line":463,"name":"$db_id","kind":13,"containerName":"_process_xrefs"},{"name":"$xrefs","containerName":"_process_xrefs","kind":13,"line":464},{"line":464,"name":"$db_id","containerName":"_process_xrefs","kind":13},{"kind":13,"localvar":"my","containerName":"_process_xrefs","name":"$xref","line":468,"definition":"my"},{"line":469,"kind":13,"containerName":"_process_xrefs","name":"$self"},{"containerName":"_process_xrefs","kind":12,"name":"_process_xref","line":469},{"name":"$line","kind":13,"containerName":"_process_xrefs","line":469},{"line":469,"name":"$xref","containerName":"_process_xrefs","kind":13},{"name":"$xrefs","kind":13,"containerName":"_process_xrefs","line":470},{"name":"$xref","containerName":"_process_xrefs","kind":13,"line":470},{"line":474,"containerName":"_process_xrefs","kind":13,"name":"$self"},{"name":"throw","containerName":"_process_xrefs","kind":12,"line":474}],"containerName":"main::","name":"_process_xrefs","signature":{"label":"_process_xrefs($self,$line)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref","parameters":[{"label":"$self"},{"label":"$line"}]},"line":446,"kind":12,"range":{"end":{"line":478,"character":9999},"start":{"character":0,"line":446}}},{"line":452,"kind":12,"name":"line"},{"line":456,"name":"line","kind":12},{"line":458,"kind":12,"name":"line"},{"line":481,"name":"line","kind":12},{"name":"line","kind":12,"line":482},{"name":"$self","kind":13,"containerName":null,"line":482},{"name":"_readline","containerName":"main::","kind":12,"line":482},{"line":483,"name":"%xrefs","kind":13,"containerName":null},{"line":485,"containerName":null,"kind":13,"name":"$self"},{"name":"throw","containerName":"main::","kind":12,"line":485},{"line":492,"name":"$self","containerName":null,"kind":13},{"line":492,"kind":12,"containerName":"main::","name":"throw"},{"detail":"($self,$line,$xref)","definition":"sub","name":"_process_xref","containerName":"main::","children":[{"line":516,"localvar":"my","kind":13,"containerName":"_process_xref","name":"$self","definition":"my"},{"line":516,"name":"$line","containerName":"_process_xref","kind":13},{"line":516,"kind":13,"containerName":"_process_xref","name":"$xref"},{"line":518,"name":"$self","containerName":"_process_xref","kind":13},{"line":518,"name":"_readline","kind":12,"containerName":"_process_xref"},{"line":522,"containerName":"_process_xref","kind":13,"name":"$self"},{"line":522,"name":"_helper_store_attribute_list","kind":12,"containerName":"_process_xref"},{"name":"$xref","containerName":"_process_xref","kind":13,"line":522},{"line":524,"name":"$self","kind":13,"containerName":"_process_xref"},{"containerName":"_process_xref","kind":12,"name":"throw","line":524},{"containerName":"_process_xref","kind":13,"name":"$self","line":529},{"name":"_star_tag","containerName":"_process_xref","kind":12,"line":529},{"line":529,"name":"$line","containerName":"_process_xref","kind":13},{"name":"$xref","containerName":"_process_xref","kind":13,"line":529}],"signature":{"label":"_process_xref($self,$line,$xref)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$xref"}]},"kind":12,"range":{"start":{"line":514,"character":0},"end":{"line":533,"character":9999}},"line":514},{"line":518,"kind":12,"name":"line"},{"kind":12,"name":"line","line":521},{"signature":{"label":"_process_sequence_map($self,$line)","parameters":[{"label":"$self"},{"label":"$line"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations"},"kind":12,"range":{"end":{"line":588,"character":9999},"start":{"character":0,"line":549}},"line":549,"detail":"($self,$line)","definition":"sub","containerName":"main::","name":"_process_sequence_map","children":[{"definition":"my","line":551,"localvar":"my","kind":13,"containerName":"_process_sequence_map","name":"$self"},{"containerName":"_process_sequence_map","kind":13,"name":"$line","line":551},{"definition":"my","name":"$sequence_map","localvar":"my","kind":13,"containerName":"_process_sequence_map","line":553},{"name":"$self","kind":13,"containerName":"_process_sequence_map","line":558},{"name":"_helper_store_attribute_list","containerName":"_process_sequence_map","kind":12,"line":558},{"line":558,"kind":13,"containerName":"_process_sequence_map","name":"$sequence_map"},{"name":"$self","containerName":"_process_sequence_map","kind":13,"line":559},{"name":"_readline","kind":12,"containerName":"_process_sequence_map","line":559},{"name":"$self","containerName":"_process_sequence_map","kind":13,"line":562},{"kind":12,"containerName":"_process_sequence_map","name":"_question_mark_tag","line":562},{"name":"$line","containerName":"_process_sequence_map","kind":13,"line":562},{"line":562,"containerName":"_process_sequence_map","kind":13,"name":"$sequence_map"},{"definition":"my","line":572,"localvar":"my","containerName":"_process_sequence_map","kind":13,"name":"$annotations"},{"line":572,"name":"$self","kind":13,"containerName":"_process_sequence_map"},{"line":572,"kind":12,"containerName":"_process_sequence_map","name":"_process_annotations"},{"line":572,"kind":13,"containerName":"_process_sequence_map","name":"$line"},{"name":"$sequence_map","containerName":"_process_sequence_map","kind":13,"line":573},{"name":"$annotations","containerName":"_process_sequence_map","kind":13,"line":573},{"line":582,"kind":13,"containerName":"_process_sequence_map","name":"$sequence_map"},{"kind":13,"containerName":"_process_sequence_map","name":"$self","line":584},{"name":"throw","kind":12,"containerName":"_process_sequence_map","line":584}]},{"name":"line","kind":12,"line":556},{"line":559,"name":"line","kind":12},{"line":571,"kind":12,"name":"line"},{"line":581,"kind":12,"name":"line"},{"detail":"($self,$line)","definition":"sub","containerName":"main::","name":"_process_annotations","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_process_annotations","line":605},{"kind":13,"containerName":"_process_annotations","name":"$line","line":605},{"definition":"my","line":608,"kind":13,"localvar":"my","containerName":"_process_annotations","name":"$annotations"},{"containerName":"_process_annotations","kind":13,"name":"$self","line":610},{"line":610,"kind":12,"containerName":"_process_annotations","name":"_readline"},{"definition":"my","name":"$count","localvar":"my","containerName":"_process_annotations","kind":13,"line":612},{"containerName":"_process_annotations","localvar":"my","kind":13,"name":"$seq_feature","line":619,"definition":"my"},{"kind":13,"containerName":"_process_annotations","name":"$self","line":619},{"name":"_process_seq_feature","kind":12,"containerName":"_process_annotations","line":619},{"line":619,"name":"$line","containerName":"_process_annotations","kind":13},{"name":"$annotations","containerName":"_process_annotations","kind":13,"line":620},{"line":620,"kind":13,"containerName":"_process_annotations","name":"$seq_feature"},{"kind":13,"containerName":"_process_annotations","name":"$count","line":632}],"signature":{"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature","parameters":[{"label":"$self"},{"label":"$line"}],"label":"_process_annotations($self,$line)"},"range":{"start":{"character":0,"line":603},"end":{"character":9999,"line":634}},"kind":12,"line":603},{"kind":12,"name":"line","line":610},{"kind":12,"name":"line","line":615},{"kind":12,"name":"line","line":617},{"kind":12,"name":"line","line":622},{"name":"line","kind":12,"line":626},{"kind":13,"containerName":null,"name":"$self","line":636},{"line":636,"name":"throw","kind":12,"containerName":"main::"},{"line":636,"name":"$count","kind":13,"containerName":null},{"line":639,"kind":12,"name":"line"},{"kind":12,"name":"line","line":641},{"line":641,"containerName":null,"kind":13,"name":"$self"},{"name":"_readline","kind":12,"containerName":"main::","line":641},{"name":"%annotations","containerName":null,"kind":13,"line":642},{"line":645,"name":"$self","containerName":null,"kind":13},{"containerName":"main::","kind":12,"name":"throw","line":645},{"line":670,"kind":12,"range":{"end":{"character":9999,"line":737},"start":{"line":670,"character":0}},"signature":{"label":"_process_seq_feature($self,$line,$attribute_line)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$attribute_line"}]},"children":[{"definition":"my","line":672,"localvar":"my","containerName":"_process_seq_feature","kind":13,"name":"$self"},{"name":"$line","containerName":"_process_seq_feature","kind":13,"line":672},{"line":672,"name":"$attribute_line","containerName":"_process_seq_feature","kind":13},{"definition":"my","name":"$seq_feature","containerName":"_process_seq_feature","localvar":"my","kind":13,"line":674},{"line":675,"containerName":"_process_seq_feature","kind":13,"name":"$self"},{"kind":12,"containerName":"_process_seq_feature","name":"_helper_store_attribute_list","line":675},{"line":675,"name":"$attribute_line","kind":13,"containerName":"_process_seq_feature"},{"name":"$seq_feature","containerName":"_process_seq_feature","kind":13,"line":675},{"line":678,"name":"$self","containerName":"_process_seq_feature","kind":13},{"line":678,"name":"_readline","containerName":"_process_seq_feature","kind":12},{"line":682,"name":"$self","kind":13,"containerName":"_process_seq_feature"},{"line":682,"name":"_process_classification","containerName":"_process_seq_feature","kind":12},{"line":682,"kind":13,"containerName":"_process_seq_feature","name":"$line"},{"containerName":"_process_seq_feature","kind":13,"name":"$seq_feature","line":682},{"name":"$self","kind":13,"containerName":"_process_seq_feature","line":687},{"line":687,"name":"_question_mark_tag","kind":12,"containerName":"_process_seq_feature"},{"kind":13,"containerName":"_process_seq_feature","name":"$line","line":687},{"line":687,"kind":13,"containerName":"_process_seq_feature","name":"$seq_feature"},{"name":"$self","kind":13,"containerName":"_process_seq_feature","line":692},{"line":692,"kind":12,"containerName":"_process_seq_feature","name":"_one_tag"},{"name":"$line","kind":13,"containerName":"_process_seq_feature","line":692},{"line":692,"kind":13,"containerName":"_process_seq_feature","name":"$seq_feature"},{"kind":13,"containerName":"_process_seq_feature","name":"$self","line":697},{"line":697,"containerName":"_process_seq_feature","kind":12,"name":"_question_mark_tag"},{"line":697,"name":"$line","containerName":"_process_seq_feature","kind":13},{"containerName":"_process_seq_feature","kind":13,"name":"$seq_feature","line":697},{"line":702,"name":"$self","containerName":"_process_seq_feature","kind":13},{"line":702,"name":"_process_evidence","kind":12,"containerName":"_process_seq_feature"},{"line":702,"name":"$line","kind":13,"containerName":"_process_seq_feature"},{"line":702,"name":"$seq_feature","kind":13,"containerName":"_process_seq_feature"},{"line":707,"kind":13,"containerName":"_process_seq_feature","name":"$self"},{"name":"_process_qualifier","containerName":"_process_seq_feature","kind":12,"line":707},{"name":"$line","containerName":"_process_seq_feature","kind":13,"line":707},{"name":"$seq_feature","containerName":"_process_seq_feature","kind":13,"line":707},{"name":"$self","containerName":"_process_seq_feature","kind":13,"line":713},{"kind":12,"containerName":"_process_seq_feature","name":"_process_seq_feature","line":713},{"line":713,"containerName":"_process_seq_feature","kind":13,"name":"$line"},{"kind":13,"containerName":"_process_seq_feature","name":"$self","line":714},{"containerName":"_process_seq_feature","kind":12,"name":"_readline","line":714},{"line":720,"kind":13,"containerName":"_process_seq_feature","name":"$self"},{"line":720,"name":"_process_related_annot","kind":12,"containerName":"_process_seq_feature"},{"name":"$line","kind":13,"containerName":"_process_seq_feature","line":720},{"name":"$self","kind":13,"containerName":"_process_seq_feature","line":721},{"name":"_readline","containerName":"_process_seq_feature","kind":12,"line":721},{"line":728,"name":"$self","containerName":"_process_seq_feature","kind":13},{"line":728,"containerName":"_process_seq_feature","kind":12,"name":"_readline"},{"line":729,"kind":13,"containerName":"_process_seq_feature","name":"$seq_feature"},{"line":733,"name":"$self","kind":13,"containerName":"_process_seq_feature"},{"kind":12,"containerName":"_process_seq_feature","name":"throw","line":733}],"name":"_process_seq_feature","containerName":"main::","definition":"sub","detail":"($self,$line,$attribute_line)"},{"kind":12,"name":"line","line":678},{"line":712,"name":"line","kind":12},{"line":714,"kind":12,"name":"line"},{"line":719,"kind":12,"name":"line"},{"kind":12,"name":"line","line":721},{"kind":12,"name":"line","line":726},{"line":728,"name":"line","kind":12},{"signature":{"label":"_process_qualifier($self,$line,$data_structure)","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag"},"line":754,"range":{"start":{"line":754,"character":0},"end":{"line":760,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$line,$data_structure)","children":[{"line":756,"localvar":"my","kind":13,"containerName":"_process_qualifier","name":"$self","definition":"my"},{"kind":13,"containerName":"_process_qualifier","name":"$line","line":756},{"line":756,"kind":13,"containerName":"_process_qualifier","name":"$data_structure"},{"definition":"my","name":"$qualifier","localvar":"my","containerName":"_process_qualifier","kind":13,"line":758},{"line":759,"name":"$self","containerName":"_process_qualifier","kind":13},{"name":"_star_tag","kind":12,"containerName":"_process_qualifier","line":759},{"containerName":"_process_qualifier","kind":13,"name":"$line","line":759},{"name":"$qualifier","containerName":"_process_qualifier","kind":13,"line":759}],"containerName":"main::","name":"_process_qualifier"},{"line":760,"name":"data_structure","kind":12},{"name":"$qualifier","kind":13,"containerName":null,"line":760},{"signature":{"parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence","label":"_process_classification($self,$line,$data_structure)"},"line":785,"range":{"start":{"line":785,"character":0},"end":{"character":9999,"line":806}},"kind":12,"definition":"sub","detail":"($self,$line,$data_structure)","children":[{"name":"$self","containerName":"_process_classification","localvar":"my","kind":13,"line":787,"definition":"my"},{"line":787,"kind":13,"containerName":"_process_classification","name":"$line"},{"line":787,"containerName":"_process_classification","kind":13,"name":"$data_structure"},{"name":"$classification","localvar":"my","kind":13,"containerName":"_process_classification","line":789,"definition":"my"},{"kind":13,"containerName":"_process_classification","name":"$self","line":793},{"line":793,"kind":12,"containerName":"_process_classification","name":"_helper_store_attribute_list"},{"line":793,"name":"$classification","kind":13,"containerName":"_process_classification"},{"name":"$self","kind":13,"containerName":"_process_classification","line":796},{"name":"_question_mark_tag","kind":12,"containerName":"_process_classification","line":796},{"kind":13,"containerName":"_process_classification","name":"$line","line":796},{"line":796,"name":"$classification","kind":13,"containerName":"_process_classification"},{"kind":13,"containerName":"_process_classification","name":"$self","line":799},{"line":799,"kind":12,"containerName":"_process_classification","name":"_star_tag"},{"line":799,"name":"$line","kind":13,"containerName":"_process_classification"},{"line":799,"containerName":"_process_classification","kind":13,"name":"$classification"},{"line":802,"kind":13,"containerName":"_process_classification","name":"$self"},{"name":"_process_evidence","containerName":"_process_classification","kind":12,"line":802},{"containerName":"_process_classification","kind":13,"name":"$line","line":802},{"containerName":"_process_classification","kind":13,"name":"$classification","line":802}],"containerName":"main::","name":"_process_classification"},{"name":"data_structure","kind":12,"line":789},{"line":791,"kind":12,"name":"line"},{"signature":{"label":"_process_evidence($self,$line,$data_structure)","documentation":"","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"}]},"line":809,"range":{"start":{"line":809,"character":0},"end":{"line":829,"character":9999}},"kind":12,"definition":"sub","detail":"($self,$line,$data_structure)","children":[{"line":811,"name":"$self","localvar":"my","containerName":"_process_evidence","kind":13,"definition":"my"},{"line":811,"kind":13,"containerName":"_process_evidence","name":"$line"},{"name":"$data_structure","containerName":"_process_evidence","kind":13,"line":811},{"line":815,"name":"$self","kind":13,"containerName":"_process_evidence"},{"name":"_readline","kind":12,"containerName":"_process_evidence","line":815},{"definition":"my","line":820,"name":"$element_id","kind":13,"localvar":"my","containerName":"_process_evidence"},{"name":"$self","containerName":"_process_evidence","kind":13,"line":821},{"line":821,"kind":12,"containerName":"_process_evidence","name":"_plus_tag"},{"line":821,"kind":13,"containerName":"_process_evidence","name":"$line"},{"name":"$element_id","containerName":"_process_evidence","kind":13,"line":821},{"line":822,"name":"$element_id","kind":13,"containerName":"_process_evidence"},{"definition":"my","name":"$comp_result","localvar":"my","containerName":"_process_evidence","kind":13,"line":824},{"line":825,"kind":13,"containerName":"_process_evidence","name":"$self"},{"containerName":"_process_evidence","kind":12,"name":"_process_comp_result","line":825},{"line":825,"name":"$line","containerName":"_process_evidence","kind":13},{"line":825,"name":"$comp_result","kind":13,"containerName":"_process_evidence"},{"line":826,"containerName":"_process_evidence","kind":13,"name":"$comp_result"},{"line":828,"name":"$self","containerName":"_process_evidence","kind":13},{"line":828,"kind":12,"containerName":"_process_evidence","name":"_readline"}],"containerName":"main::","name":"_process_evidence"},{"name":"line","kind":12,"line":813},{"line":815,"kind":12,"name":"line"},{"kind":12,"name":"line","line":818},{"line":819,"name":"line","kind":12},{"line":822,"name":"data_structure","kind":12},{"line":823,"kind":12,"name":"line"},{"line":826,"kind":12,"name":"data_structure"},{"line":828,"name":"line","kind":12},{"children":[{"kind":13,"localvar":"my","containerName":"_process_comp_result","name":"$self","line":840,"definition":"my"},{"containerName":"_process_comp_result","kind":13,"name":"$line","line":840},{"name":"$comp_result","containerName":"_process_comp_result","kind":13,"line":840},{"line":840,"kind":13,"containerName":"_process_comp_result","name":"$attribute_line"},{"name":"$self","kind":13,"containerName":"_process_comp_result","line":842},{"name":"_helper_store_attribute_list","containerName":"_process_comp_result","kind":12,"line":842},{"name":"$attribute_line","containerName":"_process_comp_result","kind":13,"line":842},{"line":842,"name":"$comp_result","kind":13,"containerName":"_process_comp_result"},{"line":843,"name":"$self","kind":13,"containerName":"_process_comp_result"},{"name":"_readline","kind":12,"containerName":"_process_comp_result","line":843},{"containerName":"_process_comp_result","kind":13,"name":"$self","line":846},{"line":846,"kind":12,"containerName":"_process_comp_result","name":"_question_mark_tag"},{"name":"$line","kind":13,"containerName":"_process_comp_result","line":846},{"line":846,"name":"$comp_result","containerName":"_process_comp_result","kind":13},{"name":"$self","kind":13,"containerName":"_process_comp_result","line":849},{"line":849,"kind":12,"containerName":"_process_comp_result","name":"_question_mark_tag"},{"name":"$line","containerName":"_process_comp_result","kind":13,"line":849},{"name":"$comp_result","kind":13,"containerName":"_process_comp_result","line":849},{"line":852,"name":"$self","containerName":"_process_comp_result","kind":13},{"line":852,"kind":12,"containerName":"_process_comp_result","name":"_question_mark_tag"},{"kind":13,"containerName":"_process_comp_result","name":"$line","line":852},{"containerName":"_process_comp_result","kind":13,"name":"$comp_result","line":852},{"line":855,"name":"$self","containerName":"_process_comp_result","kind":13},{"line":855,"containerName":"_process_comp_result","kind":12,"name":"_process_query_region"},{"line":855,"name":"$line","containerName":"_process_comp_result","kind":13},{"kind":13,"containerName":"_process_comp_result","name":"$comp_result","line":855},{"name":"$self","containerName":"_process_comp_result","kind":13,"line":858},{"name":"_process_match_region","containerName":"_process_comp_result","kind":12,"line":858},{"kind":13,"containerName":"_process_comp_result","name":"$line","line":858},{"kind":13,"containerName":"_process_comp_result","name":"$comp_result","line":858},{"line":861,"containerName":"_process_comp_result","kind":13,"name":"$self"},{"line":861,"kind":12,"containerName":"_process_comp_result","name":"_star_tag"},{"containerName":"_process_comp_result","kind":13,"name":"$line","line":861},{"line":861,"name":"$comp_result","kind":13,"containerName":"_process_comp_result"},{"kind":13,"containerName":"_process_comp_result","name":"$self","line":864},{"name":"_process_result_group","containerName":"_process_comp_result","kind":12,"line":864},{"line":864,"containerName":"_process_comp_result","kind":13,"name":"$line"},{"line":864,"kind":13,"containerName":"_process_comp_result","name":"$comp_result"},{"name":"$self","containerName":"_process_comp_result","kind":13,"line":867},{"line":867,"name":"_process_related_annot","kind":12,"containerName":"_process_comp_result"},{"name":"$line","containerName":"_process_comp_result","kind":13,"line":867},{"line":867,"name":"$comp_result","containerName":"_process_comp_result","kind":13}],"containerName":"main::","name":"_process_comp_result","definition":"sub","detail":"($self,$line,$comp_result,$attribute_line)","line":837,"kind":12,"range":{"start":{"character":0,"line":837},"end":{"character":9999,"line":869}},"signature":{"label":"_process_comp_result($self,$line,$comp_result,$attribute_line)","documentation":"","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$comp_result"},{"label":"$attribute_line"}]}},{"kind":12,"name":"line","line":843},{"definition":"sub","detail":"($self,$line,$data_structure)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_process_related_annot","line":874,"definition":"my"},{"line":874,"kind":13,"containerName":"_process_related_annot","name":"$line"},{"name":"$data_structure","kind":13,"containerName":"_process_related_annot","line":874},{"definition":"my","name":"$related_annot","localvar":"my","containerName":"_process_related_annot","kind":13,"line":878},{"kind":13,"containerName":"_process_related_annot","name":"$self","line":880},{"line":880,"kind":12,"containerName":"_process_related_annot","name":"_helper_store_attribute_list"},{"line":880,"name":"$related_annot","containerName":"_process_related_annot","kind":13},{"line":881,"name":"$self","containerName":"_process_related_annot","kind":13},{"kind":12,"containerName":"_process_related_annot","name":"_readline","line":881},{"definition":"my","line":884,"name":"$element_id_count","containerName":"_process_related_annot","localvar":"my","kind":13},{"name":"$element_id","localvar":"my","containerName":"_process_related_annot","kind":13,"line":886,"definition":"my"},{"containerName":"_process_related_annot","kind":13,"name":"$self","line":887},{"line":887,"containerName":"_process_related_annot","kind":12,"name":"_helper_store_attribute_list"},{"line":887,"name":"$element_id","kind":13,"containerName":"_process_related_annot"},{"line":888,"name":"$related_annot","kind":13,"containerName":"_process_related_annot"},{"line":888,"name":"$element_id","kind":13,"containerName":"_process_related_annot"},{"name":"$self","kind":13,"containerName":"_process_related_annot","line":889},{"line":889,"name":"_readline","containerName":"_process_related_annot","kind":12},{"name":"$element_id_count","containerName":"_process_related_annot","kind":13,"line":890},{"name":"$element_id_count","kind":13,"containerName":"_process_related_annot","line":893},{"name":"$self","kind":13,"containerName":"_process_related_annot","line":894},{"name":"throw","kind":12,"containerName":"_process_related_annot","line":894},{"line":898,"containerName":"_process_related_annot","kind":13,"name":"$self"},{"kind":12,"containerName":"_process_related_annot","name":"_star_tag","line":898},{"line":898,"name":"$line","kind":13,"containerName":"_process_related_annot"},{"name":"$related_annot","containerName":"_process_related_annot","kind":13,"line":898},{"kind":13,"containerName":"_process_related_annot","name":"$data_structure","line":903}],"name":"_process_related_annot","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"}],"documentation":"","label":"_process_related_annot($self,$line,$data_structure)"},"line":872,"kind":12,"range":{"start":{"line":872,"character":0},"end":{"character":9999,"line":903}}},{"line":876,"kind":12,"name":"line"},{"name":"line","kind":12,"line":881},{"name":"line","kind":12,"line":885},{"kind":12,"name":"line","line":889},{"line":903,"name":"$related_annot","kind":13,"containerName":null},{"kind":12,"name":"line","line":905},{"name":"$self","kind":13,"containerName":null,"line":906},{"line":906,"name":"throw","containerName":"main::","kind":12},{"definition":"sub","detail":"($self,$line,$data_structure)","children":[{"definition":"my","line":917,"name":"$self","localvar":"my","containerName":"_process_result_group","kind":13},{"kind":13,"containerName":"_process_result_group","name":"$line","line":917},{"containerName":"_process_result_group","kind":13,"name":"$data_structure","line":917},{"line":920,"kind":13,"localvar":"my","containerName":"_process_result_group","name":"$result_group","definition":"my"},{"kind":13,"containerName":"_process_result_group","name":"$self","line":921},{"line":921,"name":"_helper_store_attribute_list","kind":12,"containerName":"_process_result_group"},{"containerName":"_process_result_group","kind":13,"name":"$result_group","line":921},{"definition":"my","line":923,"kind":13,"localvar":"my","containerName":"_process_result_group","name":"$count"},{"containerName":"_process_result_group","kind":13,"name":"$self","line":924},{"line":924,"name":"_readline","kind":12,"containerName":"_process_result_group"},{"line":927,"containerName":"_process_result_group","kind":13,"name":"$self"},{"name":"_process_comp_result","kind":12,"containerName":"_process_result_group","line":927},{"line":927,"name":"$line","containerName":"_process_result_group","kind":13},{"line":927,"name":"$result_group","containerName":"_process_result_group","kind":13},{"kind":13,"containerName":"_process_result_group","name":"$self","line":928},{"kind":12,"containerName":"_process_result_group","name":"_readline","line":928},{"name":"$count","containerName":"_process_result_group","kind":13,"line":929},{"name":"$self","kind":13,"containerName":"_process_result_group","line":932},{"line":932,"kind":12,"containerName":"_process_result_group","name":"throw"},{"line":933,"name":"$count","kind":13,"containerName":"_process_result_group"},{"line":937,"name":"$line","kind":13,"containerName":"_process_result_group"},{"name":"$self","kind":13,"containerName":"_process_result_group","line":938},{"name":"_readline","containerName":"_process_result_group","kind":12,"line":938},{"containerName":"_process_result_group","kind":13,"name":"$self","line":940},{"line":940,"containerName":"_process_result_group","kind":12,"name":"throw"}],"containerName":"main::","name":"_process_result_group","signature":{"parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"}],"documentation":"","label":"_process_result_group($self,$line,$data_structure)"},"line":915,"range":{"end":{"line":947,"character":9999},"start":{"character":0,"line":915}},"kind":12},{"kind":12,"name":"line","line":919},{"name":"data_structure","kind":12,"line":920},{"line":924,"kind":12,"name":"line"},{"line":925,"name":"line","kind":12},{"kind":12,"name":"line","line":928},{"line":938,"name":"line","kind":12},{"detail":"($self,$line,$data_structure)","definition":"sub","containerName":"main::","name":"_process_match_region","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"_process_match_region","line":952,"definition":"my"},{"line":952,"name":"$line","kind":13,"containerName":"_process_match_region"},{"line":952,"containerName":"_process_match_region","kind":13,"name":"$data_structure"},{"definition":"my","line":954,"localvar":"my","kind":13,"containerName":"_process_match_region","name":"$match_region"},{"name":"$data_structure","kind":13,"containerName":"_process_match_region","line":954},{"line":958,"containerName":"_process_match_region","kind":13,"name":"$self"},{"line":958,"name":"_helper_store_attribute_line","containerName":"_process_match_region","kind":12},{"line":958,"name":"$match_region","containerName":"_process_match_region","kind":13},{"name":"$self","kind":13,"containerName":"_process_match_region","line":959},{"line":959,"name":"_readline","kind":12,"containerName":"_process_match_region"},{"containerName":"_process_match_region","kind":13,"name":"$self","line":963},{"name":"_question_mark_tag","containerName":"_process_match_region","kind":12,"line":963},{"kind":13,"containerName":"_process_match_region","name":"$line","line":963},{"name":"$match_region","kind":13,"containerName":"_process_match_region","line":963},{"containerName":"_process_match_region","kind":13,"name":"$self","line":965},{"kind":12,"containerName":"_process_match_region","name":"_question_mark_tag","line":965},{"name":"$line","kind":13,"containerName":"_process_match_region","line":965},{"line":965,"name":"$match_region","kind":13,"containerName":"_process_match_region"},{"line":967,"name":"$match_region","containerName":"_process_match_region","kind":13},{"containerName":"_process_match_region","kind":13,"name":"$self","line":967},{"line":967,"name":"_process_bio_sequence","containerName":"_process_match_region","kind":12},{"line":967,"name":"$line","containerName":"_process_match_region","kind":13},{"line":970,"kind":13,"containerName":"_process_match_region","name":"$self"},{"line":970,"name":"_readline","containerName":"_process_match_region","kind":12},{"line":972,"kind":13,"containerName":"_process_match_region","name":"$self"},{"line":972,"name":"_readline","containerName":"_process_match_region","kind":12},{"line":975,"kind":13,"containerName":"_process_match_region","name":"$self"},{"line":975,"name":"throw","kind":12,"containerName":"_process_match_region"}],"signature":{"parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"}],"documentation":"","label":"_process_match_region($self,$line,$data_structure)"},"range":{"start":{"character":0,"line":950},"end":{"character":9999,"line":979}},"kind":12,"line":950},{"kind":12,"name":"line","line":956},{"name":"line","kind":12,"line":959},{"line":962,"name":"line","kind":12},{"line":964,"name":"line","kind":12},{"line":966,"name":"line","kind":12},{"kind":12,"name":"line","line":970},{"line":971,"name":"line","kind":12},{"line":972,"name":"line","kind":12},{"children":[{"line":984,"name":"$self","containerName":"_process_query_region","localvar":"my","kind":13,"definition":"my"},{"line":984,"containerName":"_process_query_region","kind":13,"name":"$line"},{"name":"$data_structure","containerName":"_process_query_region","kind":13,"line":984},{"line":986,"kind":13,"localvar":"my","containerName":"_process_query_region","name":"$query_region","definition":"my"},{"line":986,"name":"$data_structure","containerName":"_process_query_region","kind":13},{"line":988,"name":"$self","kind":13,"containerName":"_process_query_region"},{"containerName":"_process_query_region","kind":12,"name":"_helper_store_attribute_list","line":988},{"line":988,"name":"$query_region","kind":13,"containerName":"_process_query_region"},{"kind":13,"containerName":"_process_query_region","name":"$self","line":989},{"name":"_readline","containerName":"_process_query_region","kind":12,"line":989},{"name":"$self","containerName":"_process_query_region","kind":13,"line":992},{"line":992,"kind":12,"containerName":"_process_query_region","name":"_question_mark_tag"},{"name":"$line","containerName":"_process_query_region","kind":13,"line":992},{"line":992,"kind":13,"containerName":"_process_query_region","name":"$query_region"},{"line":995,"containerName":"_process_query_region","kind":13,"name":"$self"},{"line":995,"kind":12,"containerName":"_process_query_region","name":"_readline"},{"line":998,"kind":13,"containerName":"_process_query_region","name":"$self"},{"line":998,"kind":12,"containerName":"_process_query_region","name":"throw"}],"name":"_process_query_region","containerName":"main::","definition":"sub","detail":"($self,$line,$data_structure)","line":982,"kind":12,"range":{"start":{"line":982,"character":0},"end":{"character":9999,"line":1004}},"signature":{"parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"}],"documentation":"","label":"_process_query_region($self,$line,$data_structure)"}},{"line":987,"kind":12,"name":"line"},{"line":989,"name":"line","kind":12},{"kind":12,"name":"line","line":994},{"kind":12,"name":"line","line":995},{"containerName":"main::","name":"_tag_processing_helper","children":[{"containerName":"_tag_processing_helper","localvar":"my","kind":13,"name":"$self","line":1030,"definition":"my"},{"name":"$attribute_list","containerName":"_tag_processing_helper","kind":13,"line":1030},{"name":"$data_structure","kind":13,"containerName":"_tag_processing_helper","line":1030},{"line":1030,"kind":13,"containerName":"_tag_processing_helper","name":"$tag_name"},{"line":1030,"name":"$tag_value","kind":13,"containerName":"_tag_processing_helper"},{"line":1030,"name":"$caller","kind":13,"containerName":"_tag_processing_helper"},{"line":1034,"containerName":"_tag_processing_helper","kind":13,"name":"$attribute_list"},{"name":"$self","containerName":"_tag_processing_helper","kind":13,"line":1035},{"name":"_helper_store_attribute_list","containerName":"_tag_processing_helper","kind":12,"line":1035},{"line":1035,"kind":13,"containerName":"_tag_processing_helper","name":"$attribute_list"},{"line":1035,"kind":13,"containerName":"_tag_processing_helper","name":"$data_structure"},{"name":"$caller","containerName":"_tag_processing_helper","kind":13,"line":1039},{"kind":13,"containerName":"_tag_processing_helper","name":"$caller","line":1039},{"containerName":"_tag_processing_helper","kind":13,"name":"$tag_name","line":1040},{"kind":13,"containerName":"_tag_processing_helper","name":"$tag_value","line":1040}],"detail":"($self,$attribute_list,$data_structure,$tag_name,$tag_value,$caller)","definition":"sub","range":{"start":{"line":1028,"character":0},"end":{"character":9999,"line":1042}},"kind":12,"line":1028,"signature":{"parameters":[{"label":"$self"},{"label":"$attribute_list"},{"label":"$data_structure"},{"label":"$tag_name"},{"label":"$tag_value"},{"label":"$caller"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list","label":"_tag_processing_helper($self,$attribute_list,$data_structure,$tag_name,$tag_value,$caller)"}},{"kind":12,"name":"data_structure","line":1040},{"name":"data_structure","kind":12,"line":1043},{"name":"$tag_name","containerName":null,"kind":13,"line":1043},{"kind":13,"containerName":null,"name":"$tag_value","line":1043},{"signature":{"label":"_one_tag($self,$line,$data_structure,$tag_name)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"},{"label":"$tag_name"}]},"range":{"start":{"character":0,"line":1066},"end":{"character":9999,"line":1094}},"kind":12,"line":1066,"detail":"($self,$line,$data_structure,$tag_name)","definition":"sub","containerName":"main::","name":"_one_tag","children":[{"line":1068,"localvar":"my","kind":13,"containerName":"_one_tag","name":"$self","definition":"my"},{"line":1068,"name":"$line","kind":13,"containerName":"_one_tag"},{"name":"$data_structure","containerName":"_one_tag","kind":13,"line":1068},{"line":1068,"name":"$tag_name","kind":13,"containerName":"_one_tag"},{"line":1070,"name":"$self","kind":13,"containerName":"_one_tag"},{"name":"throw","containerName":"_one_tag","kind":12,"line":1070},{"containerName":"_one_tag","kind":13,"name":"$self","line":1076},{"kind":12,"containerName":"_one_tag","name":"_tag_processing_helper","line":1076},{"name":"$data_structure","kind":13,"containerName":"_one_tag","line":1076},{"line":1076,"name":"$tag_name","containerName":"_one_tag","kind":13},{"containerName":"_one_tag","kind":13,"name":"$self","line":1084},{"name":"_tag_processing_helper","containerName":"_one_tag","kind":12,"line":1084},{"kind":13,"containerName":"_one_tag","name":"$data_structure","line":1084},{"line":1084,"name":"$tag_name","kind":13,"containerName":"_one_tag"},{"name":"$self","containerName":"_one_tag","kind":13,"line":1087},{"name":"throw","containerName":"_one_tag","kind":12,"line":1087},{"kind":13,"containerName":"_one_tag","name":"$self","line":1090},{"line":1090,"kind":12,"containerName":"_one_tag","name":"_readline"}]},{"line":1071,"name":"line","kind":12},{"line":1074,"kind":12,"name":"line"},{"name":"line","kind":12,"line":1082},{"line":1090,"name":"line","kind":12},{"detail":"($self,$line,$data_structure,$tag_name)","definition":"sub","name":"_question_mark_tag","containerName":"main::","children":[{"definition":"my","line":1115,"containerName":"_question_mark_tag","localvar":"my","kind":13,"name":"$self"},{"kind":13,"containerName":"_question_mark_tag","name":"$line","line":1115},{"line":1115,"kind":13,"containerName":"_question_mark_tag","name":"$data_structure"},{"name":"$tag_name","kind":13,"containerName":"_question_mark_tag","line":1115},{"name":"$self","kind":13,"containerName":"_question_mark_tag","line":1118},{"line":1118,"containerName":"_question_mark_tag","kind":12,"name":"_tag_processing_helper"},{"line":1118,"containerName":"_question_mark_tag","kind":13,"name":"$data_structure"},{"containerName":"_question_mark_tag","kind":13,"name":"$tag_name","line":1118},{"kind":13,"containerName":"_question_mark_tag","name":"$self","line":1119},{"line":1119,"name":"_readline","containerName":"_question_mark_tag","kind":12}],"signature":{"label":"_question_mark_tag($self,$line,$data_structure,$tag_name)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"},{"label":"$tag_name"}]},"range":{"end":{"character":9999,"line":1124},"start":{"line":1113,"character":0}},"kind":12,"line":1113},{"line":1117,"name":"line","kind":12},{"name":"line","kind":12,"line":1119},{"signature":{"label":"_star_tag($self,$line,$data_structure,$tag_name)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper","parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"},{"label":"$tag_name"}]},"line":1142,"kind":12,"range":{"end":{"character":9999,"line":1161},"start":{"line":1142,"character":0}},"definition":"sub","detail":"($self,$line,$data_structure,$tag_name)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"_star_tag","line":1144},{"line":1144,"kind":13,"containerName":"_star_tag","name":"$line"},{"containerName":"_star_tag","kind":13,"name":"$data_structure","line":1144},{"line":1144,"containerName":"_star_tag","kind":13,"name":"$tag_name"},{"name":"$self","kind":13,"containerName":"_star_tag","line":1148},{"containerName":"_star_tag","kind":12,"name":"_tag_processing_helper","line":1149},{"line":1149,"name":"$data_structure","containerName":"_star_tag","kind":13},{"line":1149,"name":"$tag_name","kind":13,"containerName":"_star_tag"},{"line":1152,"containerName":"_star_tag","kind":13,"name":"$self"},{"containerName":"_star_tag","kind":12,"name":"_readline","line":1152}],"name":"_star_tag","containerName":"main::"},{"line":1147,"name":"line","kind":12},{"line":1152,"name":"line","kind":12},{"children":[{"definition":"my","line":1181,"name":"$self","kind":13,"localvar":"my","containerName":"_plus_tag"},{"line":1181,"name":"$line","kind":13,"containerName":"_plus_tag"},{"containerName":"_plus_tag","kind":13,"name":"$data_structure","line":1181},{"line":1181,"name":"$tag_name","kind":13,"containerName":"_plus_tag"},{"line":1187,"kind":13,"containerName":"_plus_tag","name":"$self"},{"kind":12,"containerName":"_plus_tag","name":"_tag_processing_helper","line":1187},{"line":1187,"name":"$data_structure","containerName":"_plus_tag","kind":13},{"line":1187,"name":"$tag_name","kind":13,"containerName":"_plus_tag"},{"line":1195,"name":"$self","containerName":"_plus_tag","kind":13},{"line":1195,"containerName":"_plus_tag","kind":12,"name":"_readline"},{"line":1196,"name":"$self","containerName":"_plus_tag","kind":13},{"line":1196,"name":"_star_tag","containerName":"_plus_tag","kind":12},{"name":"$line","kind":13,"containerName":"_plus_tag","line":1196},{"name":"$data_structure","containerName":"_plus_tag","kind":13,"line":1196},{"line":1196,"name":"$tag_name","kind":13,"containerName":"_plus_tag"},{"line":1200,"kind":13,"containerName":"_plus_tag","name":"$self"},{"line":1200,"name":"throw","kind":12,"containerName":"_plus_tag"}],"containerName":"main::","name":"_plus_tag","definition":"sub","detail":"($self,$line,$data_structure,$tag_name)","line":1179,"range":{"start":{"line":1179,"character":0},"end":{"line":1205,"character":9999}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$line"},{"label":"$data_structure"},{"label":"$tag_name"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _star_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    #print \"tag_name: $tag_name\\n\";\n    while ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper\n            ($1, $data_structure, $tag_name, $2, 'star');\n        # The tag and attribute values are stored within\n        # $$data_structure within the _tag_processing_helper method.\n        $$line = $self->_readline;\n    }\n    #if ($tag_name eq 'qualifier'){\n    #       print \"this one:\\n\";\n    #       print Data::Dumper->Dump([$data_structure]); exit;\n    #}\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _plus_tag\n\n  Title    : _plus_tag\n  Usage    : $self->_plus_tag\n  Function : Handles 'plus' tags (tags that occur one or more times).  tag_name+\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _star_tag","label":"_plus_tag($self,$line,$data_structure,$tag_name)"}},{"name":"line","kind":12,"line":1183},{"name":"line","kind":12,"line":1195},{"signature":{"label":"_helper_store_attribute_list($self,$attribute_line,$data_structure)","parameters":[{"label":"$self"},{"label":"$attribute_line"},{"label":"$data_structure"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _star_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    #print \"tag_name: $tag_name\\n\";\n    while ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper\n            ($1, $data_structure, $tag_name, $2, 'star');\n        # The tag and attribute values are stored within\n        # $$data_structure within the _tag_processing_helper method.\n        $$line = $self->_readline;\n    }\n    #if ($tag_name eq 'qualifier'){\n    #       print \"this one:\\n\";\n    #       print Data::Dumper->Dump([$data_structure]); exit;\n    #}\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _plus_tag\n\n  Title    : _plus_tag\n  Usage    : $self->_plus_tag\n  Function : Handles 'plus' tags (tags that occur one or more times).  tag_name+\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _star_tag\n\n\nsub _plus_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n\n        # Store value of the first occurence of $tag_name.\n        # All subsequent values, if any, will be stored in the method _star_tag.\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'plus');\n\n\n        # If the flow gets within this block, we've already determined\n        # that there's at least one of <$tag_name> Are there more?  To\n        # answer this, we could just treat the tag as a * tag now\n        # (zero or more).  We've already determined that it's NOT\n        # zero, so how many more?  Thus, call _star_tag.\n        $$line = $self->_readline;\n        $self->_star_tag($line, $data_structure, $tag_name);\n\n\n    } else {\n        $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _helper_store_attribute_list\n\n  Title    : _helper_store_attribute_list\n  Usage    : $self->_helper_store_attribute_list\n  Function : A helper method used to store the attributes from\n             the tags into the data structure.\n  Args     : 2 scalars:\n             - scalar holding the attribute values to be parsed.\n             - reference to a data structure to store the data between the 2 tags.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : Many.\n             Method(s) that this method call(s) : None."},"range":{"end":{"line":1240,"character":9999},"start":{"character":0,"line":1223}},"kind":12,"line":1223,"detail":"($self,$attribute_line,$data_structure)","definition":"sub","containerName":"main::","name":"_helper_store_attribute_list","children":[{"definition":"my","line":1225,"name":"$self","localvar":"my","kind":13,"containerName":"_helper_store_attribute_list"},{"containerName":"_helper_store_attribute_list","kind":13,"name":"$attribute_line","line":1225},{"containerName":"_helper_store_attribute_list","kind":13,"name":"$data_structure","line":1225},{"localvar":"my","kind":13,"containerName":"_helper_store_attribute_list","name":"%attribs","line":1227,"definition":"my"},{"line":1227,"name":"$attribute_line","containerName":"_helper_store_attribute_list","kind":13},{"localvar":"my","containerName":"_helper_store_attribute_list","kind":13,"name":"$attribute_list","line":1229,"definition":"my"},{"line":1230,"kind":13,"localvar":"my","containerName":"_helper_store_attribute_list","name":"$key","definition":"my"},{"containerName":"_helper_store_attribute_list","kind":13,"name":"%attribs","line":1230},{"name":"$key","containerName":"_helper_store_attribute_list","kind":13,"line":1233},{"line":1233,"containerName":"_helper_store_attribute_list","kind":13,"name":"$attribs"},{"name":"$key","kind":13,"containerName":"_helper_store_attribute_list","line":1233}]},{"line":1233,"kind":12,"name":"data_structure"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"_store_seqs","children":[{"definition":"my","line":1263,"name":"$self","containerName":"_store_seqs","localvar":"my","kind":13},{"definition":"my","name":"$sciobj","localvar":"my","containerName":"_store_seqs","kind":13,"line":1266},{"line":1266,"name":"$self","containerName":"_store_seqs","kind":13}],"signature":{"label":"_store_seqs($self)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _star_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    #print \"tag_name: $tag_name\\n\";\n    while ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper\n            ($1, $data_structure, $tag_name, $2, 'star');\n        # The tag and attribute values are stored within\n        # $$data_structure within the _tag_processing_helper method.\n        $$line = $self->_readline;\n    }\n    #if ($tag_name eq 'qualifier'){\n    #       print \"this one:\\n\";\n    #       print Data::Dumper->Dump([$data_structure]); exit;\n    #}\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _plus_tag\n\n  Title    : _plus_tag\n  Usage    : $self->_plus_tag\n  Function : Handles 'plus' tags (tags that occur one or more times).  tag_name+\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _star_tag\n\n\nsub _plus_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n\n        # Store value of the first occurence of $tag_name.\n        # All subsequent values, if any, will be stored in the method _star_tag.\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'plus');\n\n\n        # If the flow gets within this block, we've already determined\n        # that there's at least one of <$tag_name> Are there more?  To\n        # answer this, we could just treat the tag as a * tag now\n        # (zero or more).  We've already determined that it's NOT\n        # zero, so how many more?  Thus, call _star_tag.\n        $$line = $self->_readline;\n        $self->_star_tag($line, $data_structure, $tag_name);\n\n\n    } else {\n        $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _helper_store_attribute_list\n\n  Title    : _helper_store_attribute_list\n  Usage    : $self->_helper_store_attribute_list\n  Function : A helper method used to store the attributes from\n             the tags into the data structure.\n  Args     : 2 scalars:\n             - scalar holding the attribute values to be parsed.\n             - reference to a data structure to store the data between the 2 tags.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : Many.\n             Method(s) that this method call(s) : None.\n\n\nsub _helper_store_attribute_list {\n\n    my ($self, $attribute_line, $data_structure) = @_;\n\n    my %attribs = ($attribute_line =~ /(\\w+)\\s*=\\s*\"([^\"]*)\"/g);\n\n    my $attribute_list;\n    for my $key (keys %attribs) {\n        # print \"\\tkey: $key , value: $attribs{$key}\\n\";\n        ###$$data_structure->{$key} = $attribs{$key};           # <- The ORIGINAL.\n        push @{$$data_structure->{$key}}, $attribs{$key};\n        # Now, store them in an array because there may be > 1 tag, thus\n        # > 1 attribute of the same name.\n        # Doing this has made it necessary to change the _store_seqs method.\n        # ie: Change $bio_sequence->{'molecule_type'};\n        # to\n        # $bio_sequence->{'molecule_type'}->[0];\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _store_seqs\n\n  Title    : _store_seqs\n  Usage    : $self->_store_seqs\n  Function : This method is called once in the life time of the script.\n             It stores the data parsed from the agave xml file into\n             the Bio::Seq object.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : next_seq\n             Method(s) that this method calls   : None.","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"character":9999,"line":1266},"start":{"line":1261,"character":0}},"line":1261},{"definition":"my","line":1271,"name":"$contig","containerName":null,"localvar":"my","kind":13},{"line":1271,"kind":13,"containerName":null,"name":"%sciobj"},{"line":1273,"name":"$fragment_order","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":null,"name":"%contig","line":1273},{"line":1275,"localvar":"my","kind":13,"containerName":null,"name":"$fragment_orientation","definition":"my"},{"name":"%fragment_order","containerName":null,"kind":13,"line":1275},{"name":"$bio_sequence","containerName":null,"localvar":"my","kind":13,"line":1278,"definition":"my"},{"line":1278,"name":"%fragment_orientation","kind":13,"containerName":null},{"line":1281,"name":"$sequence","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"name":"%bio_sequence","kind":13,"containerName":null,"line":1281},{"definition":"my","name":"$accession_number","kind":13,"localvar":"my","containerName":null,"line":1282},{"kind":13,"containerName":null,"name":"%bio_sequence","line":1282},{"line":1283,"name":"$organism","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"name":"%bio_sequence","containerName":null,"kind":13,"line":1283},{"kind":13,"localvar":"my","containerName":null,"name":"$description","line":1284,"definition":"my"},{"line":1284,"containerName":null,"kind":13,"name":"%bio_sequence"},{"definition":"my","name":"$molecule_type","kind":13,"localvar":"my","containerName":null,"line":1285},{"line":1285,"name":"%bio_sequence","kind":13,"containerName":null},{"line":1287,"name":"$primary_seq","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"containerName":"PrimarySeq","kind":12,"name":"Bio","line":1287},{"line":1287,"kind":12,"containerName":"main::","name":"new"},{"containerName":null,"kind":13,"name":"$accession_number","line":1288},{"line":1289,"kind":13,"containerName":null,"name":"$molecule_type"},{"line":1290,"name":"$sequence","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"$description","line":1291},{"definition":"my","name":"$seq","kind":13,"localvar":"my","containerName":null,"line":1294},{"name":"Bio","kind":12,"containerName":"Seq","line":1294},{"line":1294,"kind":12,"containerName":"main::","name":"new"},{"name":"$accession_number","kind":13,"containerName":null,"line":1295},{"kind":13,"containerName":null,"name":"$accession_number","line":1296},{"name":"$primary_seq","kind":13,"containerName":null,"line":1297},{"name":"$sequence","containerName":null,"kind":13,"line":1298},{"line":1299,"containerName":null,"kind":13,"name":"$description"},{"containerName":null,"localvar":"my","kind":13,"name":"$organism_name","line":1302,"definition":"my"},{"line":1302,"name":"%bio_sequence","containerName":null,"kind":13},{"kind":12,"name":"organism_name","line":1302},{"line":1303,"name":"%organism_name","containerName":null,"kind":13},{"line":1305,"name":"@classification","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"name":"$organism_name","kind":13,"containerName":null,"line":1305},{"definition":"my","name":"$species","localvar":"my","containerName":null,"kind":13,"line":1306},{"line":1306,"name":"Bio","kind":12,"containerName":"Species"},{"name":"new","containerName":"main::","kind":12,"line":1306},{"line":1307,"name":"$species","containerName":null,"kind":13},{"line":1307,"name":"classification","containerName":"main::","kind":12},{"line":1307,"containerName":null,"kind":13,"name":"@classification"},{"name":"$seq","containerName":null,"kind":13,"line":1308},{"line":1308,"containerName":"main::","kind":12,"name":"species"},{"kind":13,"containerName":null,"name":"$species","line":1308},{"definition":"my","line":1312,"name":"$keywords","localvar":"my","containerName":null,"kind":13},{"containerName":null,"kind":13,"name":"%bio_sequence","line":1312},{"name":"keyword","kind":12,"line":1312},{"name":"%key_to_value","containerName":null,"localvar":"my","kind":13,"line":1313,"definition":"my"},{"line":1315,"localvar":"my","kind":13,"containerName":null,"name":"$keywords","definition":"my"},{"line":1315,"kind":13,"containerName":null,"name":"%keywords"},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"@words","line":1317},{"name":"$keywords","containerName":null,"kind":13,"line":1317},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$i","line":1318},{"name":"$i","kind":13,"containerName":null,"line":1318},{"line":1318,"name":"@words","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%i","line":1318},{"line":1319,"name":"%i","containerName":null,"kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":null,"name":"$j","line":1320},{"name":"$i","kind":13,"containerName":null,"line":1320},{"line":1320,"name":"$j","kind":13,"containerName":null},{"line":1322,"name":"%key_to_value","containerName":null,"kind":13},{"name":"@words","kind":13,"containerName":null,"line":1322},{"line":1322,"containerName":null,"kind":13,"name":"$i"},{"line":1322,"name":"@words","kind":13,"containerName":null},{"line":1322,"name":"$j","kind":13,"containerName":null},{"definition":"my","name":"$reference","containerName":null,"localvar":"my","kind":13,"line":1326},{"line":1326,"name":"Bio","kind":12,"containerName":"Annotation::Reference"},{"kind":12,"containerName":"main::","name":"new","line":1327},{"kind":13,"containerName":null,"name":"%key_to_value","line":1327},{"name":"authors","kind":12,"line":1327},{"line":1328,"name":"%key_to_value","kind":13,"containerName":null},{"kind":12,"name":"title","line":1328},{"line":1329,"name":"%key_to_value","containerName":null,"kind":13},{"kind":12,"name":"database","line":1329},{"line":1330,"kind":13,"containerName":null,"name":"%key_to_value"},{"name":"pubmed","kind":12,"line":1330},{"containerName":null,"kind":13,"name":"$seq","line":1332},{"kind":12,"containerName":"main::","name":"annotation","line":1332},{"line":1332,"kind":12,"containerName":"main::","name":"add_Annotation"},{"line":1332,"kind":13,"containerName":null,"name":"$reference"},{"kind":13,"containerName":null,"name":"%bio_sequence","line":1338},{"definition":"my","line":1340,"kind":13,"localvar":"my","containerName":null,"name":"$sequence_map"},{"line":1340,"kind":13,"containerName":null,"name":"%bio_sequence"},{"line":1344,"kind":13,"localvar":"my","containerName":null,"name":"$label","definition":"my"},{"name":"%sequence_map","kind":13,"containerName":null,"line":1344},{"name":"label","kind":12,"line":1344},{"name":"%sequence_map","containerName":null,"kind":13,"line":1346},{"line":1346,"kind":12,"name":"annotations"},{"containerName":null,"kind":13,"name":"%sequence_map","line":1347},{"line":1347,"kind":12,"name":"annotations"},{"line":1350,"containerName":null,"localvar":"my","kind":13,"name":"$seq_feature","definition":"my"},{"containerName":null,"kind":13,"name":"%sequence_map","line":1350},{"definition":"my","name":"$seq_location","containerName":null,"localvar":"my","kind":13,"line":1353},{"line":1353,"name":"%seq_feature","kind":13,"containerName":null},{"localvar":"my","kind":13,"containerName":null,"name":"$start_coord","line":1354,"definition":"my"},{"line":1354,"containerName":null,"kind":13,"name":"%seq_feature"},{"line":1355,"name":"$feature_type","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":1355,"containerName":null,"kind":13,"name":"%seq_feature"},{"localvar":"my","containerName":null,"kind":13,"name":"$end_coord","line":1356,"definition":"my"},{"name":"%seq_feature","containerName":null,"kind":13,"line":1356},{"definition":"my","line":1357,"name":"$is_on_complement","containerName":null,"localvar":"my","kind":13},{"line":1357,"name":"%seq_feature","containerName":null,"kind":13},{"line":1361,"name":"$feat","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"containerName":"SeqFeature::Generic","kind":12,"name":"Bio","line":1361},{"line":1362,"name":"new","kind":12,"containerName":"main::"},{"line":1363,"kind":13,"containerName":null,"name":"$start_coord"},{"containerName":null,"kind":13,"name":"$end_coord","line":1364},{"kind":13,"containerName":null,"name":"$feature_type","line":1365},{"line":1369,"name":"%seq_feature","kind":13,"containerName":null},{"line":1370,"name":"%seq_feature","kind":13,"containerName":null},{"definition":"my","localvar":"my","containerName":null,"kind":13,"name":"$feature","line":1372},{"containerName":null,"kind":13,"name":"%seq_feature","line":1372},{"definition":"my","line":1374,"name":"$value","kind":13,"localvar":"my","containerName":null},{"kind":13,"containerName":null,"name":"%feature","line":1374},{"line":1375,"name":"$feature_type","containerName":null,"localvar":"my","kind":13,"definition":"my"},{"line":1375,"kind":13,"containerName":null,"name":"%feature"},{"name":"$i","kind":13,"localvar":"my","containerName":null,"line":1377,"definition":"my"},{"name":"$i","containerName":null,"kind":13,"line":1378},{"line":1378,"name":"$value","kind":13,"containerName":null},{"name":"%i","containerName":null,"kind":13,"line":1379},{"line":1380,"kind":13,"containerName":null,"name":"$feat"},{"line":1380,"kind":12,"containerName":"main::","name":"add_tag_value"},{"name":"@feature_type","containerName":null,"kind":13,"line":1381},{"line":1381,"kind":13,"containerName":null,"name":"$i"},{"kind":13,"containerName":null,"name":"@value","line":1381},{"kind":13,"containerName":null,"name":"$i","line":1381},{"name":"$seq","kind":13,"containerName":null,"line":1390},{"kind":12,"containerName":"main::","name":"add_SeqFeature","line":1390},{"line":1390,"containerName":null,"kind":13,"name":"$feat"},{"name":"%self","kind":13,"containerName":null,"line":1405},{"name":"$seq","containerName":null,"kind":13,"line":1405},{"line":1420,"kind":13,"containerName":null,"name":"%self"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"next_seq","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"next_seq","name":"$self","line":1443},{"kind":13,"containerName":"next_seq","name":"$self","line":1447},{"line":1447,"containerName":"next_seq","kind":12,"name":"_store_seqs"},{"containerName":"next_seq","kind":13,"name":"$self","line":1447},{"name":"$self","containerName":"next_seq","kind":13,"line":1449},{"line":1449,"name":"throw","kind":12,"containerName":"next_seq"},{"containerName":"next_seq","kind":13,"name":"$self","line":1450},{"line":1452,"name":"$self","containerName":"next_seq","kind":13}],"signature":{"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _star_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    #print \"tag_name: $tag_name\\n\";\n    while ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper\n            ($1, $data_structure, $tag_name, $2, 'star');\n        # The tag and attribute values are stored within\n        # $$data_structure within the _tag_processing_helper method.\n        $$line = $self->_readline;\n    }\n    #if ($tag_name eq 'qualifier'){\n    #       print \"this one:\\n\";\n    #       print Data::Dumper->Dump([$data_structure]); exit;\n    #}\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _plus_tag\n\n  Title    : _plus_tag\n  Usage    : $self->_plus_tag\n  Function : Handles 'plus' tags (tags that occur one or more times).  tag_name+\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _star_tag\n\n\nsub _plus_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n\n        # Store value of the first occurence of $tag_name.\n        # All subsequent values, if any, will be stored in the method _star_tag.\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'plus');\n\n\n        # If the flow gets within this block, we've already determined\n        # that there's at least one of <$tag_name> Are there more?  To\n        # answer this, we could just treat the tag as a * tag now\n        # (zero or more).  We've already determined that it's NOT\n        # zero, so how many more?  Thus, call _star_tag.\n        $$line = $self->_readline;\n        $self->_star_tag($line, $data_structure, $tag_name);\n\n\n    } else {\n        $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _helper_store_attribute_list\n\n  Title    : _helper_store_attribute_list\n  Usage    : $self->_helper_store_attribute_list\n  Function : A helper method used to store the attributes from\n             the tags into the data structure.\n  Args     : 2 scalars:\n             - scalar holding the attribute values to be parsed.\n             - reference to a data structure to store the data between the 2 tags.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : Many.\n             Method(s) that this method call(s) : None.\n\n\nsub _helper_store_attribute_list {\n\n    my ($self, $attribute_line, $data_structure) = @_;\n\n    my %attribs = ($attribute_line =~ /(\\w+)\\s*=\\s*\"([^\"]*)\"/g);\n\n    my $attribute_list;\n    for my $key (keys %attribs) {\n        # print \"\\tkey: $key , value: $attribs{$key}\\n\";\n        ###$$data_structure->{$key} = $attribs{$key};           # <- The ORIGINAL.\n        push @{$$data_structure->{$key}}, $attribs{$key};\n        # Now, store them in an array because there may be > 1 tag, thus\n        # > 1 attribute of the same name.\n        # Doing this has made it necessary to change the _store_seqs method.\n        # ie: Change $bio_sequence->{'molecule_type'};\n        # to\n        # $bio_sequence->{'molecule_type'}->[0];\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _store_seqs\n\n  Title    : _store_seqs\n  Usage    : $self->_store_seqs\n  Function : This method is called once in the life time of the script.\n             It stores the data parsed from the agave xml file into\n             the Bio::Seq object.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : next_seq\n             Method(s) that this method calls   : None.\n\n\nsub _store_seqs {\n\n    my ($self) = @_;\n\n\n    for my $sciobj (@{$self->{'sciobj'}}) {\n\n        ### $sciobj = $self->{'sciobj'};                # The root node.\n\n\n        for my $contig (@{$sciobj->{'contig'}}) { # Each contig has a fragment order.\n\n            for my $fragment_order (@{$contig->{'fragment_order'}}) { # Each fragment order has a fragment_orientation.\n\n                for my $fragment_orientation (@{$fragment_order->{'fragment_orientation'}}) {\n                    # Each fragment_orientation contain 1 bio sequence.\n\n                    my $bio_sequence = $fragment_orientation->{'bio_sequence'}; # <bio_sequence> contains all the\n                    # interesting stuff:\n\n                    my $sequence         = $bio_sequence->{'sequence'};\n                    my $accession_number = $bio_sequence->{'sequence_id'}->[0]; # also use for primary_id\n                    my $organism         = $bio_sequence->{'organism'};\n                    my $description      = $bio_sequence->{'description'};\n                    my $molecule_type    = $bio_sequence->{'molecule_type'}->[0];\n\n                    my $primary_seq = Bio::PrimarySeq->new(\n                                                           -id       => $accession_number,\n                                                           -alphabet => $molecule_type,\n                                                           -seq      => $sequence,\n                                                           -desc     => $description,\n                                                          );\n\n                    my $seq = Bio::Seq->new (\n                                             -display_id       => $accession_number,\n                                             -accession_number => $accession_number,\n                                             -primary_seq      => $primary_seq,\n                                             -seq              => $sequence,\n                                             -description      => $description,\n                                            );\n\n                    my $organism_name = $bio_sequence->{organism_name}->[0];\n                    if (defined $organism_name) {\n\n                        my @classification = split(' ', $organism_name);\n                        my $species = Bio::Species->new();\n                        $species->classification(@classification);\n                        $seq->species($species);\n                    }\n                    # Pull out the keywords: $keywords is an array ref.\n\n                    my $keywords = $bio_sequence->{keyword};\n                    my %key_to_value;\n\n                    for my $keywords (@$keywords) {\n                        # print \"keywords: $keywords\\n\";\n                        my @words = split(':', $keywords);\n                        for (my $i = 0; $i < scalar @words - 1; $i++) {\n                            if ($i % 2 == 0) {\n                                my $j = $i; $j++;\n                                # print \"$words[$i] , $words[$j]\\n\";\n                                $key_to_value{$words[$i]} = $words[$j];\n                            }\n                        }\n                        # print Data::Dumper->Dump([%key_to_value]);\n                        my $reference = Bio::Annotation::Reference->\n                            new(-authors => $key_to_value{authors},\n                                -title => $key_to_value{title},\n                                -database => $key_to_value{database},\n                                -pubmed => $key_to_value{pubmed},\n                               );\n                        $seq->annotation->add_Annotation('reference', $reference);\n\n                    }           # close for my $keywords\n\n\n                    #  print Data::Dumper->Dump([$bio_sequence]); print \"here\\n\"; exit;\n                    if (defined $bio_sequence->{'sequence_map'}) {\n\n                        for my $sequence_map (@{$bio_sequence->{'sequence_map'}}) {\n\n                            # print Data::Dumper->Dump([$sequence_map]); print \"here\\n\"; exit;\n\n                            my $label = $sequence_map->{label};\n\n                            if (defined $sequence_map->{annotations} &&\n                                ref($sequence_map->{annotations}) eq 'HASH') {\n\n                                # Get the sequence features (ie genes, exons, etc) from this $sequence_map\n                                for my $seq_feature (@{$sequence_map->{'annotations'}->{'seq_feature'}}) {\n\n                                    # print Data::Dumper->Dump([$seq_feature]); exit;\n                                    my $seq_location     = $seq_feature->{'seq_location'};\n                                    my $start_coord      = $seq_feature->{'least_start'}->[0];\n                                    my $feature_type     = $seq_feature->{'feature_type'}->[0];\n                                    my $end_coord        = $seq_feature->{'greatest_end'}->[0];\n                                    my $is_on_complement = $seq_feature->{'is_on_complement'}->[0];\n\n                                    # Specify the coordinates and the tag for this seq feature.\n                                    # print \"Primary Tag for this SeqFeature: $feature_type\\n\";\n                                    my $feat = Bio::SeqFeature::Generic->\n                                        new(\n                                            -start       => $start_coord,\n                                            -end         => $end_coord,\n                                            -primary_tag => $feature_type,\n                                           );\n\n\n                                    if (defined $seq_feature->{'qualifier'} &&\n                                        ref($seq_feature->{'qualifier'}) eq 'ARRAY') {\n\n                                        for my $feature (@{$seq_feature->{'qualifier'}}) {\n\n                                            my $value = $feature->{'qualifier'};\n                                            my $feature_type = $feature->{'qualifier_type'};\n\n                                            for (my $i = 0;\n                                                 $i < scalar @{$value};\n                                                 $i++) {\n                                                $feat->add_tag_value(\n                                                                     $feature_type->[$i] => $value->[$i]\n                                                                    );\n                                            } # close the for loop\n\n                                        }\n\n                                    } # close if (defined $seq_feature->...\n\n\n                                    $seq->add_SeqFeature($feat);\n\n\n                                } # close for my $seq_feature (@{$sequence_map->...\n\n\n                            }   # close if (defined $sequence_map->{annotations} &&\n\n\n                        }       # close for my $sequence_map (@{$bio_sequence->{'sequence_map'}}){\n\n                    }           # close if (defined $bio_sequence->{'sequence_map'}){\n\n\n                    # This is where the Bio::Seq objects are stored:\n                    push @{$self->{'sequence_objects'}}, $seq;\n\n\n                }               # close for my $fragment_orientation\n\n\n            }                   # close for my $fragment_order\n\n\n        }                       # close for my $contig\n\n\n    }                           # close for my $sciobj\n\n    # Flag is set so that we know that the sequence objects are now stored in $self.\n    $self->{'seqs_stored'} = 1;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 next_seq\n\n        Title    : next_seq\n        Usage    : $seq = $stream->next_seq()\n        Function : Returns the next sequence in the stream.\n        Args     : None.\n        Returns  : Bio::Seq object\n\nMethod is called from the script.  Method(s) that this method calls:\n_store_seqs (only once throughout the life time of script execution).","parameters":[{"label":"$self"}],"label":"next_seq($self)"},"kind":12,"range":{"start":{"line":1441,"character":0},"end":{"line":1452,"character":9999}},"line":1441},{"line":1453,"name":"%self","kind":13,"containerName":null},{"definition":"sub","containerName":"main::","name":"next_primary_seq","children":[{"definition":"my","line":1475,"name":"$self","localvar":"my","containerName":"next_primary_seq","kind":13}],"range":{"start":{"character":0,"line":1474},"end":{"line":1477,"character":9999}},"kind":12,"line":1474},{"line":1490,"kind":12,"range":{"end":{"character":9999,"line":1502},"start":{"line":1490,"character":0}},"signature":{"label":"write_seq($self,@seqs)","parameters":[{"label":"$self"},{"label":"@seqs"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _star_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    #print \"tag_name: $tag_name\\n\";\n    while ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper\n            ($1, $data_structure, $tag_name, $2, 'star');\n        # The tag and attribute values are stored within\n        # $$data_structure within the _tag_processing_helper method.\n        $$line = $self->_readline;\n    }\n    #if ($tag_name eq 'qualifier'){\n    #       print \"this one:\\n\";\n    #       print Data::Dumper->Dump([$data_structure]); exit;\n    #}\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _plus_tag\n\n  Title    : _plus_tag\n  Usage    : $self->_plus_tag\n  Function : Handles 'plus' tags (tags that occur one or more times).  tag_name+\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _star_tag\n\n\nsub _plus_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n\n        # Store value of the first occurence of $tag_name.\n        # All subsequent values, if any, will be stored in the method _star_tag.\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'plus');\n\n\n        # If the flow gets within this block, we've already determined\n        # that there's at least one of <$tag_name> Are there more?  To\n        # answer this, we could just treat the tag as a * tag now\n        # (zero or more).  We've already determined that it's NOT\n        # zero, so how many more?  Thus, call _star_tag.\n        $$line = $self->_readline;\n        $self->_star_tag($line, $data_structure, $tag_name);\n\n\n    } else {\n        $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _helper_store_attribute_list\n\n  Title    : _helper_store_attribute_list\n  Usage    : $self->_helper_store_attribute_list\n  Function : A helper method used to store the attributes from\n             the tags into the data structure.\n  Args     : 2 scalars:\n             - scalar holding the attribute values to be parsed.\n             - reference to a data structure to store the data between the 2 tags.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : Many.\n             Method(s) that this method call(s) : None.\n\n\nsub _helper_store_attribute_list {\n\n    my ($self, $attribute_line, $data_structure) = @_;\n\n    my %attribs = ($attribute_line =~ /(\\w+)\\s*=\\s*\"([^\"]*)\"/g);\n\n    my $attribute_list;\n    for my $key (keys %attribs) {\n        # print \"\\tkey: $key , value: $attribs{$key}\\n\";\n        ###$$data_structure->{$key} = $attribs{$key};           # <- The ORIGINAL.\n        push @{$$data_structure->{$key}}, $attribs{$key};\n        # Now, store them in an array because there may be > 1 tag, thus\n        # > 1 attribute of the same name.\n        # Doing this has made it necessary to change the _store_seqs method.\n        # ie: Change $bio_sequence->{'molecule_type'};\n        # to\n        # $bio_sequence->{'molecule_type'}->[0];\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _store_seqs\n\n  Title    : _store_seqs\n  Usage    : $self->_store_seqs\n  Function : This method is called once in the life time of the script.\n             It stores the data parsed from the agave xml file into\n             the Bio::Seq object.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : next_seq\n             Method(s) that this method calls   : None.\n\n\nsub _store_seqs {\n\n    my ($self) = @_;\n\n\n    for my $sciobj (@{$self->{'sciobj'}}) {\n\n        ### $sciobj = $self->{'sciobj'};                # The root node.\n\n\n        for my $contig (@{$sciobj->{'contig'}}) { # Each contig has a fragment order.\n\n            for my $fragment_order (@{$contig->{'fragment_order'}}) { # Each fragment order has a fragment_orientation.\n\n                for my $fragment_orientation (@{$fragment_order->{'fragment_orientation'}}) {\n                    # Each fragment_orientation contain 1 bio sequence.\n\n                    my $bio_sequence = $fragment_orientation->{'bio_sequence'}; # <bio_sequence> contains all the\n                    # interesting stuff:\n\n                    my $sequence         = $bio_sequence->{'sequence'};\n                    my $accession_number = $bio_sequence->{'sequence_id'}->[0]; # also use for primary_id\n                    my $organism         = $bio_sequence->{'organism'};\n                    my $description      = $bio_sequence->{'description'};\n                    my $molecule_type    = $bio_sequence->{'molecule_type'}->[0];\n\n                    my $primary_seq = Bio::PrimarySeq->new(\n                                                           -id       => $accession_number,\n                                                           -alphabet => $molecule_type,\n                                                           -seq      => $sequence,\n                                                           -desc     => $description,\n                                                          );\n\n                    my $seq = Bio::Seq->new (\n                                             -display_id       => $accession_number,\n                                             -accession_number => $accession_number,\n                                             -primary_seq      => $primary_seq,\n                                             -seq              => $sequence,\n                                             -description      => $description,\n                                            );\n\n                    my $organism_name = $bio_sequence->{organism_name}->[0];\n                    if (defined $organism_name) {\n\n                        my @classification = split(' ', $organism_name);\n                        my $species = Bio::Species->new();\n                        $species->classification(@classification);\n                        $seq->species($species);\n                    }\n                    # Pull out the keywords: $keywords is an array ref.\n\n                    my $keywords = $bio_sequence->{keyword};\n                    my %key_to_value;\n\n                    for my $keywords (@$keywords) {\n                        # print \"keywords: $keywords\\n\";\n                        my @words = split(':', $keywords);\n                        for (my $i = 0; $i < scalar @words - 1; $i++) {\n                            if ($i % 2 == 0) {\n                                my $j = $i; $j++;\n                                # print \"$words[$i] , $words[$j]\\n\";\n                                $key_to_value{$words[$i]} = $words[$j];\n                            }\n                        }\n                        # print Data::Dumper->Dump([%key_to_value]);\n                        my $reference = Bio::Annotation::Reference->\n                            new(-authors => $key_to_value{authors},\n                                -title => $key_to_value{title},\n                                -database => $key_to_value{database},\n                                -pubmed => $key_to_value{pubmed},\n                               );\n                        $seq->annotation->add_Annotation('reference', $reference);\n\n                    }           # close for my $keywords\n\n\n                    #  print Data::Dumper->Dump([$bio_sequence]); print \"here\\n\"; exit;\n                    if (defined $bio_sequence->{'sequence_map'}) {\n\n                        for my $sequence_map (@{$bio_sequence->{'sequence_map'}}) {\n\n                            # print Data::Dumper->Dump([$sequence_map]); print \"here\\n\"; exit;\n\n                            my $label = $sequence_map->{label};\n\n                            if (defined $sequence_map->{annotations} &&\n                                ref($sequence_map->{annotations}) eq 'HASH') {\n\n                                # Get the sequence features (ie genes, exons, etc) from this $sequence_map\n                                for my $seq_feature (@{$sequence_map->{'annotations'}->{'seq_feature'}}) {\n\n                                    # print Data::Dumper->Dump([$seq_feature]); exit;\n                                    my $seq_location     = $seq_feature->{'seq_location'};\n                                    my $start_coord      = $seq_feature->{'least_start'}->[0];\n                                    my $feature_type     = $seq_feature->{'feature_type'}->[0];\n                                    my $end_coord        = $seq_feature->{'greatest_end'}->[0];\n                                    my $is_on_complement = $seq_feature->{'is_on_complement'}->[0];\n\n                                    # Specify the coordinates and the tag for this seq feature.\n                                    # print \"Primary Tag for this SeqFeature: $feature_type\\n\";\n                                    my $feat = Bio::SeqFeature::Generic->\n                                        new(\n                                            -start       => $start_coord,\n                                            -end         => $end_coord,\n                                            -primary_tag => $feature_type,\n                                           );\n\n\n                                    if (defined $seq_feature->{'qualifier'} &&\n                                        ref($seq_feature->{'qualifier'}) eq 'ARRAY') {\n\n                                        for my $feature (@{$seq_feature->{'qualifier'}}) {\n\n                                            my $value = $feature->{'qualifier'};\n                                            my $feature_type = $feature->{'qualifier_type'};\n\n                                            for (my $i = 0;\n                                                 $i < scalar @{$value};\n                                                 $i++) {\n                                                $feat->add_tag_value(\n                                                                     $feature_type->[$i] => $value->[$i]\n                                                                    );\n                                            } # close the for loop\n\n                                        }\n\n                                    } # close if (defined $seq_feature->...\n\n\n                                    $seq->add_SeqFeature($feat);\n\n\n                                } # close for my $seq_feature (@{$sequence_map->...\n\n\n                            }   # close if (defined $sequence_map->{annotations} &&\n\n\n                        }       # close for my $sequence_map (@{$bio_sequence->{'sequence_map'}}){\n\n                    }           # close if (defined $bio_sequence->{'sequence_map'}){\n\n\n                    # This is where the Bio::Seq objects are stored:\n                    push @{$self->{'sequence_objects'}}, $seq;\n\n\n                }               # close for my $fragment_orientation\n\n\n            }                   # close for my $fragment_order\n\n\n        }                       # close for my $contig\n\n\n    }                           # close for my $sciobj\n\n    # Flag is set so that we know that the sequence objects are now stored in $self.\n    $self->{'seqs_stored'} = 1;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 next_seq\n\n        Title    : next_seq\n        Usage    : $seq = $stream->next_seq()\n        Function : Returns the next sequence in the stream.\n        Args     : None.\n        Returns  : Bio::Seq object\n\nMethod is called from the script.  Method(s) that this method calls:\n_store_seqs (only once throughout the life time of script execution).\n\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    # convert agave to genbank/fasta/embl whatever.\n\n    $self->_store_seqs if $self->{'seqs_stored'} == 0;\n\n    $self->throw(\"Error: No Bio::Seq objects stored yet!\\n\\n\")\n        if !defined $self->{'sequence_objects'}; # This should never occur...\n\n    if (scalar @{$self->{'sequence_objects'}} > 0) {\n        return shift @{$self->{'sequence_objects'}};\n    } else {\n        # All done.  Nothing more to parse.\n        # print \"returning nothing!\\n\";\n        return 0;\n    }\n\n\n}\n# ==================================================================================\n\n=head2 next_primary_seq\n\n  Title   : next_primary_seq\n  Usage   : $seq = $stream->next_primary_seq()\n  Function: returns the next primary sequence (ie no seq_features) in the stream\n  Returns : Bio::PrimarySeq object\n  Args    : NONE\n\n\nsub next_primary_seq {\n    my $self=shift;\n    return 0;\n}\n# ==================================================================================\n\n=head2 write_seq\n\n  Title   : write_seq\n  Usage   : Not Yet Implemented! $stream->write_seq(@seq)\n  Function: writes the $seq object into the stream\n  Returns : 1 for success and 0 for error\n  Args    : Bio::Seq object"},"children":[{"localvar":"my","containerName":"write_seq","kind":13,"name":"$self","line":1494,"definition":"my"},{"name":"@seqs","kind":13,"containerName":"write_seq","line":1494},{"definition":"my","line":1496,"kind":13,"localvar":"my","containerName":"write_seq","name":"$seq"},{"name":"@seqs","kind":13,"containerName":"write_seq","line":1496},{"line":1497,"name":"$self","containerName":"write_seq","kind":13},{"line":1497,"containerName":"write_seq","kind":12,"name":"_write_each_record"},{"line":1497,"name":"$seq","kind":13,"containerName":"write_seq"}],"name":"write_seq","containerName":"main::","definition":"sub","detail":"($self,@seqs)"},{"line":1515,"range":{"end":{"line":1665,"character":9999},"start":{"line":1515,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$seq"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _star_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    #print \"tag_name: $tag_name\\n\";\n    while ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper\n            ($1, $data_structure, $tag_name, $2, 'star');\n        # The tag and attribute values are stored within\n        # $$data_structure within the _tag_processing_helper method.\n        $$line = $self->_readline;\n    }\n    #if ($tag_name eq 'qualifier'){\n    #       print \"this one:\\n\";\n    #       print Data::Dumper->Dump([$data_structure]); exit;\n    #}\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _plus_tag\n\n  Title    : _plus_tag\n  Usage    : $self->_plus_tag\n  Function : Handles 'plus' tags (tags that occur one or more times).  tag_name+\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _star_tag\n\n\nsub _plus_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n\n        # Store value of the first occurence of $tag_name.\n        # All subsequent values, if any, will be stored in the method _star_tag.\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'plus');\n\n\n        # If the flow gets within this block, we've already determined\n        # that there's at least one of <$tag_name> Are there more?  To\n        # answer this, we could just treat the tag as a * tag now\n        # (zero or more).  We've already determined that it's NOT\n        # zero, so how many more?  Thus, call _star_tag.\n        $$line = $self->_readline;\n        $self->_star_tag($line, $data_structure, $tag_name);\n\n\n    } else {\n        $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _helper_store_attribute_list\n\n  Title    : _helper_store_attribute_list\n  Usage    : $self->_helper_store_attribute_list\n  Function : A helper method used to store the attributes from\n             the tags into the data structure.\n  Args     : 2 scalars:\n             - scalar holding the attribute values to be parsed.\n             - reference to a data structure to store the data between the 2 tags.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : Many.\n             Method(s) that this method call(s) : None.\n\n\nsub _helper_store_attribute_list {\n\n    my ($self, $attribute_line, $data_structure) = @_;\n\n    my %attribs = ($attribute_line =~ /(\\w+)\\s*=\\s*\"([^\"]*)\"/g);\n\n    my $attribute_list;\n    for my $key (keys %attribs) {\n        # print \"\\tkey: $key , value: $attribs{$key}\\n\";\n        ###$$data_structure->{$key} = $attribs{$key};           # <- The ORIGINAL.\n        push @{$$data_structure->{$key}}, $attribs{$key};\n        # Now, store them in an array because there may be > 1 tag, thus\n        # > 1 attribute of the same name.\n        # Doing this has made it necessary to change the _store_seqs method.\n        # ie: Change $bio_sequence->{'molecule_type'};\n        # to\n        # $bio_sequence->{'molecule_type'}->[0];\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _store_seqs\n\n  Title    : _store_seqs\n  Usage    : $self->_store_seqs\n  Function : This method is called once in the life time of the script.\n             It stores the data parsed from the agave xml file into\n             the Bio::Seq object.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : next_seq\n             Method(s) that this method calls   : None.\n\n\nsub _store_seqs {\n\n    my ($self) = @_;\n\n\n    for my $sciobj (@{$self->{'sciobj'}}) {\n\n        ### $sciobj = $self->{'sciobj'};                # The root node.\n\n\n        for my $contig (@{$sciobj->{'contig'}}) { # Each contig has a fragment order.\n\n            for my $fragment_order (@{$contig->{'fragment_order'}}) { # Each fragment order has a fragment_orientation.\n\n                for my $fragment_orientation (@{$fragment_order->{'fragment_orientation'}}) {\n                    # Each fragment_orientation contain 1 bio sequence.\n\n                    my $bio_sequence = $fragment_orientation->{'bio_sequence'}; # <bio_sequence> contains all the\n                    # interesting stuff:\n\n                    my $sequence         = $bio_sequence->{'sequence'};\n                    my $accession_number = $bio_sequence->{'sequence_id'}->[0]; # also use for primary_id\n                    my $organism         = $bio_sequence->{'organism'};\n                    my $description      = $bio_sequence->{'description'};\n                    my $molecule_type    = $bio_sequence->{'molecule_type'}->[0];\n\n                    my $primary_seq = Bio::PrimarySeq->new(\n                                                           -id       => $accession_number,\n                                                           -alphabet => $molecule_type,\n                                                           -seq      => $sequence,\n                                                           -desc     => $description,\n                                                          );\n\n                    my $seq = Bio::Seq->new (\n                                             -display_id       => $accession_number,\n                                             -accession_number => $accession_number,\n                                             -primary_seq      => $primary_seq,\n                                             -seq              => $sequence,\n                                             -description      => $description,\n                                            );\n\n                    my $organism_name = $bio_sequence->{organism_name}->[0];\n                    if (defined $organism_name) {\n\n                        my @classification = split(' ', $organism_name);\n                        my $species = Bio::Species->new();\n                        $species->classification(@classification);\n                        $seq->species($species);\n                    }\n                    # Pull out the keywords: $keywords is an array ref.\n\n                    my $keywords = $bio_sequence->{keyword};\n                    my %key_to_value;\n\n                    for my $keywords (@$keywords) {\n                        # print \"keywords: $keywords\\n\";\n                        my @words = split(':', $keywords);\n                        for (my $i = 0; $i < scalar @words - 1; $i++) {\n                            if ($i % 2 == 0) {\n                                my $j = $i; $j++;\n                                # print \"$words[$i] , $words[$j]\\n\";\n                                $key_to_value{$words[$i]} = $words[$j];\n                            }\n                        }\n                        # print Data::Dumper->Dump([%key_to_value]);\n                        my $reference = Bio::Annotation::Reference->\n                            new(-authors => $key_to_value{authors},\n                                -title => $key_to_value{title},\n                                -database => $key_to_value{database},\n                                -pubmed => $key_to_value{pubmed},\n                               );\n                        $seq->annotation->add_Annotation('reference', $reference);\n\n                    }           # close for my $keywords\n\n\n                    #  print Data::Dumper->Dump([$bio_sequence]); print \"here\\n\"; exit;\n                    if (defined $bio_sequence->{'sequence_map'}) {\n\n                        for my $sequence_map (@{$bio_sequence->{'sequence_map'}}) {\n\n                            # print Data::Dumper->Dump([$sequence_map]); print \"here\\n\"; exit;\n\n                            my $label = $sequence_map->{label};\n\n                            if (defined $sequence_map->{annotations} &&\n                                ref($sequence_map->{annotations}) eq 'HASH') {\n\n                                # Get the sequence features (ie genes, exons, etc) from this $sequence_map\n                                for my $seq_feature (@{$sequence_map->{'annotations'}->{'seq_feature'}}) {\n\n                                    # print Data::Dumper->Dump([$seq_feature]); exit;\n                                    my $seq_location     = $seq_feature->{'seq_location'};\n                                    my $start_coord      = $seq_feature->{'least_start'}->[0];\n                                    my $feature_type     = $seq_feature->{'feature_type'}->[0];\n                                    my $end_coord        = $seq_feature->{'greatest_end'}->[0];\n                                    my $is_on_complement = $seq_feature->{'is_on_complement'}->[0];\n\n                                    # Specify the coordinates and the tag for this seq feature.\n                                    # print \"Primary Tag for this SeqFeature: $feature_type\\n\";\n                                    my $feat = Bio::SeqFeature::Generic->\n                                        new(\n                                            -start       => $start_coord,\n                                            -end         => $end_coord,\n                                            -primary_tag => $feature_type,\n                                           );\n\n\n                                    if (defined $seq_feature->{'qualifier'} &&\n                                        ref($seq_feature->{'qualifier'}) eq 'ARRAY') {\n\n                                        for my $feature (@{$seq_feature->{'qualifier'}}) {\n\n                                            my $value = $feature->{'qualifier'};\n                                            my $feature_type = $feature->{'qualifier_type'};\n\n                                            for (my $i = 0;\n                                                 $i < scalar @{$value};\n                                                 $i++) {\n                                                $feat->add_tag_value(\n                                                                     $feature_type->[$i] => $value->[$i]\n                                                                    );\n                                            } # close the for loop\n\n                                        }\n\n                                    } # close if (defined $seq_feature->...\n\n\n                                    $seq->add_SeqFeature($feat);\n\n\n                                } # close for my $seq_feature (@{$sequence_map->...\n\n\n                            }   # close if (defined $sequence_map->{annotations} &&\n\n\n                        }       # close for my $sequence_map (@{$bio_sequence->{'sequence_map'}}){\n\n                    }           # close if (defined $bio_sequence->{'sequence_map'}){\n\n\n                    # This is where the Bio::Seq objects are stored:\n                    push @{$self->{'sequence_objects'}}, $seq;\n\n\n                }               # close for my $fragment_orientation\n\n\n            }                   # close for my $fragment_order\n\n\n        }                       # close for my $contig\n\n\n    }                           # close for my $sciobj\n\n    # Flag is set so that we know that the sequence objects are now stored in $self.\n    $self->{'seqs_stored'} = 1;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 next_seq\n\n        Title    : next_seq\n        Usage    : $seq = $stream->next_seq()\n        Function : Returns the next sequence in the stream.\n        Args     : None.\n        Returns  : Bio::Seq object\n\nMethod is called from the script.  Method(s) that this method calls:\n_store_seqs (only once throughout the life time of script execution).\n\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    # convert agave to genbank/fasta/embl whatever.\n\n    $self->_store_seqs if $self->{'seqs_stored'} == 0;\n\n    $self->throw(\"Error: No Bio::Seq objects stored yet!\\n\\n\")\n        if !defined $self->{'sequence_objects'}; # This should never occur...\n\n    if (scalar @{$self->{'sequence_objects'}} > 0) {\n        return shift @{$self->{'sequence_objects'}};\n    } else {\n        # All done.  Nothing more to parse.\n        # print \"returning nothing!\\n\";\n        return 0;\n    }\n\n\n}\n# ==================================================================================\n\n=head2 next_primary_seq\n\n  Title   : next_primary_seq\n  Usage   : $seq = $stream->next_primary_seq()\n  Function: returns the next primary sequence (ie no seq_features) in the stream\n  Returns : Bio::PrimarySeq object\n  Args    : NONE\n\n\nsub next_primary_seq {\n    my $self=shift;\n    return 0;\n}\n# ==================================================================================\n\n=head2 write_seq\n\n  Title   : write_seq\n  Usage   : Not Yet Implemented! $stream->write_seq(@seq)\n  Function: writes the $seq object into the stream\n  Returns : 1 for success and 0 for error\n  Args    : Bio::Seq object\n\n\nsub write_seq {\n\n    # Convert the Bio::Seq object(s) to AGAVE xml file.\n\n    my ($self,@seqs) = @_;\n\n    foreach my $seq ( @seqs ) {\n        $self->_write_each_record( $seq ); # where most of the work actually takes place.\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _write_each_record\n\n  Title   : _write_each_record\n  Usage   : $agave->_write_each_record( $seqI )\n  Function: change data into agave format\n  Returns : NONE\n  Args    : Bio::SeqI object","label":"_write_each_record($self,$seq)"},"children":[{"line":1516,"name":"$self","containerName":"_write_each_record","localvar":"my","kind":13,"definition":"my"},{"line":1516,"name":"$seq","containerName":"_write_each_record","kind":13},{"name":"$output","localvar":"my","containerName":"_write_each_record","kind":13,"line":1519,"definition":"my"},{"containerName":"_write_each_record","kind":13,"name":"$self","line":1519},{"kind":13,"localvar":"my","containerName":"_write_each_record","name":"$writer","line":1520,"definition":"my"},{"line":1520,"containerName":"_write_each_record","kind":13,"name":"$output"},{"name":"$writer","kind":13,"containerName":"_write_each_record","line":1525},{"name":"xmlDecl","kind":12,"containerName":"_write_each_record","line":1525},{"line":1526,"kind":13,"containerName":"_write_each_record","name":"$writer"},{"containerName":"_write_each_record","kind":12,"name":"doctype","line":1526},{"kind":13,"containerName":"_write_each_record","name":"$writer","line":1527},{"line":1527,"containerName":"_write_each_record","kind":12,"name":"startTag"},{"containerName":"_write_each_record","kind":13,"name":"$writer","line":1531},{"line":1531,"name":"startTag","kind":12,"containerName":"_write_each_record"},{"name":"$seq","kind":13,"containerName":"_write_each_record","line":1531},{"kind":12,"containerName":"_write_each_record","name":"length","line":1531},{"line":1532,"name":"$annotation","containerName":"_write_each_record","localvar":"my","kind":13,"definition":"my"},{"kind":13,"containerName":"_write_each_record","name":"$seq","line":1532},{"name":"annotation","containerName":"_write_each_record","kind":12,"line":1532},{"name":"$annotation","kind":13,"containerName":"_write_each_record","line":1534},{"containerName":"_write_each_record","kind":12,"name":"get_Annotations","line":1534},{"line":1537,"name":"$dblink","kind":13,"localvar":"my","containerName":"_write_each_record","definition":"my"},{"line":1537,"name":"$annotation","kind":13,"containerName":"_write_each_record"},{"line":1537,"containerName":"_write_each_record","kind":12,"name":"get_Annotations"},{"name":"$writer","kind":13,"containerName":"_write_each_record","line":1539},{"line":1539,"name":"startTag","containerName":"_write_each_record","kind":12},{"name":"$dblink","kind":13,"containerName":"_write_each_record","line":1540},{"line":1540,"name":"primary_id","containerName":"_write_each_record","kind":12},{"line":1541,"kind":13,"containerName":"_write_each_record","name":"$dblink"},{"name":"database","containerName":"_write_each_record","kind":12,"line":1541},{"name":"$writer","containerName":"_write_each_record","kind":13,"line":1543},{"containerName":"_write_each_record","kind":12,"name":"startTag","line":1543},{"kind":13,"containerName":"_write_each_record","name":"$seq","line":1544},{"line":1544,"containerName":"_write_each_record","kind":12,"name":"display_id"},{"line":1547,"containerName":"_write_each_record","kind":13,"name":"$writer"},{"kind":12,"containerName":"_write_each_record","name":"endTag","line":1547},{"line":1550,"name":"$writer","kind":13,"containerName":"_write_each_record"},{"line":1550,"kind":12,"containerName":"_write_each_record","name":"startTag"},{"line":1551,"name":"$writer","kind":13,"containerName":"_write_each_record"},{"name":"startTag","containerName":"_write_each_record","kind":12,"line":1551},{"kind":13,"containerName":"_write_each_record","name":"$writer","line":1555},{"line":1555,"name":"startTag","kind":12,"containerName":"_write_each_record"},{"name":"$seq","containerName":"_write_each_record","kind":13,"line":1556},{"kind":12,"containerName":"_write_each_record","name":"display_id","line":1556},{"name":"$seq","containerName":"_write_each_record","kind":13,"line":1557},{"name":"length","containerName":"_write_each_record","kind":12,"line":1557},{"containerName":"_write_each_record","kind":13,"name":"$self","line":1559},{"line":1559,"name":"alphabet","containerName":"_write_each_record","kind":12},{"line":1567,"kind":13,"containerName":"_write_each_record","name":"$annotation"},{"line":1567,"name":"$seq","containerName":"_write_each_record","kind":13},{"line":1567,"name":"annotation","containerName":"_write_each_record","kind":12},{"line":1569,"name":"$annotation","kind":13,"containerName":"_write_each_record"},{"line":1569,"kind":12,"containerName":"_write_each_record","name":"get_Annotations"},{"name":"$dblink","kind":13,"localvar":"my","containerName":"_write_each_record","line":1572,"definition":"my"},{"line":1572,"name":"$annotation","kind":13,"containerName":"_write_each_record"},{"kind":12,"containerName":"_write_each_record","name":"get_Annotations","line":1572},{"line":1574,"containerName":"_write_each_record","kind":13,"name":"$writer"},{"line":1574,"name":"startTag","kind":12,"containerName":"_write_each_record"},{"name":"$dblink","containerName":"_write_each_record","kind":13,"line":1575},{"name":"primary_id","containerName":"_write_each_record","kind":12,"line":1575},{"line":1576,"name":"$dblink","containerName":"_write_each_record","kind":13},{"containerName":"_write_each_record","kind":12,"name":"database","line":1576},{"containerName":"_write_each_record","kind":13,"name":"$writer","line":1578},{"line":1578,"name":"startTag","kind":12,"containerName":"_write_each_record"},{"kind":13,"containerName":"_write_each_record","name":"$seq","line":1579},{"name":"display_id","kind":12,"containerName":"_write_each_record","line":1579},{"name":"$writer","containerName":"_write_each_record","kind":13,"line":1582},{"line":1582,"kind":12,"containerName":"_write_each_record","name":"endTag"},{"line":1585,"name":"$note","kind":13,"localvar":"my","containerName":"_write_each_record","definition":"my"},{"definition":"my","name":"$comment","containerName":"_write_each_record","localvar":"my","kind":13,"line":1586},{"line":1586,"name":"$annotation","containerName":"_write_each_record","kind":13},{"line":1586,"containerName":"_write_each_record","kind":12,"name":"get_Annotations"},{"kind":13,"containerName":"_write_each_record","name":"$note","line":1590},{"name":"$comment","kind":13,"containerName":"_write_each_record","line":1590},{"line":1590,"kind":12,"containerName":"_write_each_record","name":"text"},{"line":1593,"name":"$writer","containerName":"_write_each_record","kind":13},{"line":1593,"name":"startTag","kind":12,"containerName":"_write_each_record"},{"name":"$writer","kind":13,"containerName":"_write_each_record","line":1594},{"line":1594,"name":"characters","containerName":"_write_each_record","kind":12},{"line":1594,"kind":13,"containerName":"_write_each_record","name":"$note"},{"line":1595,"name":"$writer","containerName":"_write_each_record","kind":13},{"line":1595,"kind":12,"containerName":"_write_each_record","name":"endTag"},{"name":"$writer","kind":13,"containerName":"_write_each_record","line":1598},{"line":1598,"name":"startTag","kind":12,"containerName":"_write_each_record"},{"line":1604,"containerName":"_write_each_record","kind":13,"name":"$writer"},{"line":1604,"kind":12,"containerName":"_write_each_record","name":"characters"},{"name":"$seq","containerName":"_write_each_record","kind":13,"line":1604},{"line":1605,"kind":13,"containerName":"_write_each_record","name":"$writer"},{"containerName":"_write_each_record","kind":12,"name":"endTag","line":1605},{"definition":"my","localvar":"my","kind":13,"containerName":"_write_each_record","name":"$genename","line":1608},{"name":"$annotation","containerName":"_write_each_record","kind":13,"line":1608},{"line":1608,"name":"get_Annotations","containerName":"_write_each_record","kind":12},{"line":1611,"name":"$writer","kind":13,"containerName":"_write_each_record"},{"name":"startTag","containerName":"_write_each_record","kind":12,"line":1611},{"name":"$writer","containerName":"_write_each_record","kind":13,"line":1612},{"line":1612,"name":"characters","kind":12,"containerName":"_write_each_record"},{"line":1612,"kind":13,"containerName":"_write_each_record","name":"$genename"},{"kind":13,"containerName":"_write_each_record","name":"$writer","line":1613},{"name":"endTag","kind":12,"containerName":"_write_each_record","line":1613},{"line":1617,"containerName":"_write_each_record","localvar":"my","kind":13,"name":"$ref","definition":"my"},{"line":1617,"kind":13,"containerName":"_write_each_record","name":"$annotation"},{"line":1617,"name":"get_Annotations","containerName":"_write_each_record","kind":12},{"line":1621,"kind":13,"containerName":"_write_each_record","name":"$writer"},{"line":1621,"name":"startTag","containerName":"_write_each_record","kind":12},{"line":1623,"localvar":"my","containerName":"_write_each_record","kind":13,"name":"$medline","definition":"my"},{"name":"$ref","containerName":"_write_each_record","kind":13,"line":1623},{"line":1623,"kind":12,"containerName":"_write_each_record","name":"medline"},{"definition":"my","name":"$pubmed","localvar":"my","containerName":"_write_each_record","kind":13,"line":1624},{"line":1624,"name":"$ref","kind":13,"containerName":"_write_each_record"},{"name":"pubmed","kind":12,"containerName":"_write_each_record","line":1624},{"kind":13,"localvar":"my","containerName":"_write_each_record","name":"$database","line":1625,"definition":"my"},{"line":1625,"name":"$ref","kind":13,"containerName":"_write_each_record"},{"line":1625,"kind":12,"containerName":"_write_each_record","name":"database"},{"definition":"my","name":"$authors","containerName":"_write_each_record","localvar":"my","kind":13,"line":1626},{"containerName":"_write_each_record","kind":13,"name":"$ref","line":1626},{"line":1626,"name":"authors","containerName":"_write_each_record","kind":12},{"definition":"my","line":1627,"name":"$title","localvar":"my","containerName":"_write_each_record","kind":13},{"line":1627,"containerName":"_write_each_record","kind":13,"name":"$ref"},{"line":1627,"kind":12,"containerName":"_write_each_record","name":"title"},{"kind":13,"containerName":"_write_each_record","name":"$writer","line":1630},{"kind":12,"containerName":"_write_each_record","name":"characters","line":1630},{"line":1633,"name":"$writer","containerName":"_write_each_record","kind":13},{"name":"endTag","kind":12,"containerName":"_write_each_record","line":1633},{"line":1637,"kind":13,"containerName":"_write_each_record","name":"$writer"},{"line":1637,"name":"startTag","kind":12,"containerName":"_write_each_record"},{"containerName":"_write_each_record","kind":13,"name":"$writer","line":1638},{"line":1638,"name":"characters","kind":12,"containerName":"_write_each_record"},{"line":1638,"containerName":"_write_each_record","kind":13,"name":"$seq"},{"name":"seq","containerName":"_write_each_record","kind":12,"line":1638},{"kind":13,"containerName":"_write_each_record","name":"$writer","line":1639},{"name":"endTag","kind":12,"containerName":"_write_each_record","line":1639},{"name":"$writer","kind":13,"containerName":"_write_each_record","line":1642},{"containerName":"_write_each_record","kind":12,"name":"startTag","line":1642},{"definition":"my","name":"$link","kind":13,"localvar":"my","containerName":"_write_each_record","line":1643},{"name":"$annotation","containerName":"_write_each_record","kind":13,"line":1643},{"line":1643,"name":"get_Annotations","kind":12,"containerName":"_write_each_record"},{"containerName":"_write_each_record","kind":13,"name":"$writer","line":1645},{"kind":12,"containerName":"_write_each_record","name":"startTag","line":1645},{"name":"$link","kind":13,"containerName":"_write_each_record","line":1646},{"name":"database","kind":12,"containerName":"_write_each_record","line":1646},{"line":1647,"name":"$link","containerName":"_write_each_record","kind":13},{"kind":12,"containerName":"_write_each_record","name":"primary_id","line":1647},{"line":1648,"name":"$writer","containerName":"_write_each_record","kind":13},{"name":"characters","kind":12,"containerName":"_write_each_record","line":1648},{"line":1648,"name":"$link","containerName":"_write_each_record","kind":13},{"kind":12,"containerName":"_write_each_record","name":"comment","line":1648},{"containerName":"_write_each_record","kind":13,"name":"$writer","line":1649},{"containerName":"_write_each_record","kind":12,"name":"endTag","line":1649},{"name":"$writer","containerName":"_write_each_record","kind":13,"line":1651},{"kind":12,"containerName":"_write_each_record","name":"endTag","line":1651},{"definition":"my","localvar":"my","containerName":"_write_each_record","kind":13,"name":"@feats","line":1656},{"line":1656,"name":"$seq","kind":13,"containerName":"_write_each_record"},{"line":1656,"kind":12,"containerName":"_write_each_record","name":"top_SeqFeatures"},{"definition":"my","line":1658,"kind":13,"localvar":"my","containerName":"_write_each_record","name":"$features"},{"line":1661,"containerName":"_write_each_record","localvar":"my","kind":13,"name":"$maps","definition":"my"},{"definition":"my","line":1662,"name":"$feature","localvar":"my","kind":13,"containerName":"_write_each_record"},{"name":"@feats","kind":13,"containerName":"_write_each_record","line":1662},{"name":"$map_type","localvar":"my","containerName":"_write_each_record","kind":13,"line":1663,"definition":"my"},{"name":"$feature","containerName":"_write_each_record","kind":13,"line":1663},{"name":"source_tag","containerName":"_write_each_record","kind":12,"line":1663},{"kind":13,"containerName":"_write_each_record","name":"$maps","line":1664},{"name":"$map_type","containerName":"_write_each_record","kind":13,"line":1664},{"name":"$feature","containerName":"_write_each_record","kind":13,"line":1664}],"name":"_write_each_record","containerName":"main::","definition":"sub","detail":"($self,$seq)"},{"line":1519,"kind":12,"name":"new"},{"containerName":"File","kind":12,"name":"IO","line":1519},{"kind":12,"name":"new","line":1520},{"kind":12,"containerName":"Writer","name":"XML","line":1520},{"name":"OUTPUT","kind":12,"line":1520},{"line":1521,"kind":12,"name":"NAMESPACES"},{"line":1522,"name":"DATA_MODE","kind":12},{"line":1523,"kind":12,"name":"DATA_INDENT"},{"kind":12,"name":"primary_seq","line":1604},{"line":1604,"name":"desc","kind":12},{"name":"$map_type","kind":13,"localvar":"my","containerName":null,"line":1668,"definition":"my"},{"kind":13,"containerName":null,"name":"%maps","line":1668},{"name":"$writer","kind":13,"containerName":null,"line":1669},{"kind":12,"containerName":"main::","name":"startTag","line":1669},{"name":"$map_type","kind":13,"containerName":null,"line":1670},{"containerName":null,"kind":13,"name":"$writer","line":1671},{"line":1671,"name":"startTag","kind":12,"containerName":"main::"},{"definition":"my","line":1674,"name":"$feature","localvar":"my","containerName":null,"kind":13},{"name":"%maps","containerName":null,"kind":13,"line":1674},{"line":1674,"name":"%map_type","containerName":null,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":1675},{"line":1675,"kind":12,"containerName":"main::","name":"_write_seqfeature"},{"line":1675,"name":"$feature","kind":13,"containerName":null},{"name":"$writer","kind":13,"containerName":null,"line":1675},{"line":1678,"containerName":null,"kind":13,"name":"$writer"},{"name":"endTag","kind":12,"containerName":"main::","line":1678},{"line":1679,"kind":13,"containerName":null,"name":"$writer"},{"name":"endTag","kind":12,"containerName":"main::","line":1679},{"containerName":null,"kind":13,"name":"$writer","line":1682},{"line":1682,"kind":12,"containerName":"main::","name":"endTag"},{"line":1683,"name":"$writer","containerName":null,"kind":13},{"line":1683,"containerName":"main::","kind":12,"name":"endTag"},{"line":1684,"name":"$writer","kind":13,"containerName":null},{"line":1684,"name":"endTag","kind":12,"containerName":"main::"},{"line":1685,"kind":13,"containerName":null,"name":"$writer"},{"line":1685,"name":"endTag","containerName":"main::","kind":12},{"line":1686,"kind":13,"containerName":null,"name":"$writer"},{"name":"endTag","kind":12,"containerName":"main::","line":1686},{"signature":{"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _star_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    #print \"tag_name: $tag_name\\n\";\n    while ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper\n            ($1, $data_structure, $tag_name, $2, 'star');\n        # The tag and attribute values are stored within\n        # $$data_structure within the _tag_processing_helper method.\n        $$line = $self->_readline;\n    }\n    #if ($tag_name eq 'qualifier'){\n    #       print \"this one:\\n\";\n    #       print Data::Dumper->Dump([$data_structure]); exit;\n    #}\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _plus_tag\n\n  Title    : _plus_tag\n  Usage    : $self->_plus_tag\n  Function : Handles 'plus' tags (tags that occur one or more times).  tag_name+\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _star_tag\n\n\nsub _plus_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n\n        # Store value of the first occurence of $tag_name.\n        # All subsequent values, if any, will be stored in the method _star_tag.\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'plus');\n\n\n        # If the flow gets within this block, we've already determined\n        # that there's at least one of <$tag_name> Are there more?  To\n        # answer this, we could just treat the tag as a * tag now\n        # (zero or more).  We've already determined that it's NOT\n        # zero, so how many more?  Thus, call _star_tag.\n        $$line = $self->_readline;\n        $self->_star_tag($line, $data_structure, $tag_name);\n\n\n    } else {\n        $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _helper_store_attribute_list\n\n  Title    : _helper_store_attribute_list\n  Usage    : $self->_helper_store_attribute_list\n  Function : A helper method used to store the attributes from\n             the tags into the data structure.\n  Args     : 2 scalars:\n             - scalar holding the attribute values to be parsed.\n             - reference to a data structure to store the data between the 2 tags.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : Many.\n             Method(s) that this method call(s) : None.\n\n\nsub _helper_store_attribute_list {\n\n    my ($self, $attribute_line, $data_structure) = @_;\n\n    my %attribs = ($attribute_line =~ /(\\w+)\\s*=\\s*\"([^\"]*)\"/g);\n\n    my $attribute_list;\n    for my $key (keys %attribs) {\n        # print \"\\tkey: $key , value: $attribs{$key}\\n\";\n        ###$$data_structure->{$key} = $attribs{$key};           # <- The ORIGINAL.\n        push @{$$data_structure->{$key}}, $attribs{$key};\n        # Now, store them in an array because there may be > 1 tag, thus\n        # > 1 attribute of the same name.\n        # Doing this has made it necessary to change the _store_seqs method.\n        # ie: Change $bio_sequence->{'molecule_type'};\n        # to\n        # $bio_sequence->{'molecule_type'}->[0];\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _store_seqs\n\n  Title    : _store_seqs\n  Usage    : $self->_store_seqs\n  Function : This method is called once in the life time of the script.\n             It stores the data parsed from the agave xml file into\n             the Bio::Seq object.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : next_seq\n             Method(s) that this method calls   : None.\n\n\nsub _store_seqs {\n\n    my ($self) = @_;\n\n\n    for my $sciobj (@{$self->{'sciobj'}}) {\n\n        ### $sciobj = $self->{'sciobj'};                # The root node.\n\n\n        for my $contig (@{$sciobj->{'contig'}}) { # Each contig has a fragment order.\n\n            for my $fragment_order (@{$contig->{'fragment_order'}}) { # Each fragment order has a fragment_orientation.\n\n                for my $fragment_orientation (@{$fragment_order->{'fragment_orientation'}}) {\n                    # Each fragment_orientation contain 1 bio sequence.\n\n                    my $bio_sequence = $fragment_orientation->{'bio_sequence'}; # <bio_sequence> contains all the\n                    # interesting stuff:\n\n                    my $sequence         = $bio_sequence->{'sequence'};\n                    my $accession_number = $bio_sequence->{'sequence_id'}->[0]; # also use for primary_id\n                    my $organism         = $bio_sequence->{'organism'};\n                    my $description      = $bio_sequence->{'description'};\n                    my $molecule_type    = $bio_sequence->{'molecule_type'}->[0];\n\n                    my $primary_seq = Bio::PrimarySeq->new(\n                                                           -id       => $accession_number,\n                                                           -alphabet => $molecule_type,\n                                                           -seq      => $sequence,\n                                                           -desc     => $description,\n                                                          );\n\n                    my $seq = Bio::Seq->new (\n                                             -display_id       => $accession_number,\n                                             -accession_number => $accession_number,\n                                             -primary_seq      => $primary_seq,\n                                             -seq              => $sequence,\n                                             -description      => $description,\n                                            );\n\n                    my $organism_name = $bio_sequence->{organism_name}->[0];\n                    if (defined $organism_name) {\n\n                        my @classification = split(' ', $organism_name);\n                        my $species = Bio::Species->new();\n                        $species->classification(@classification);\n                        $seq->species($species);\n                    }\n                    # Pull out the keywords: $keywords is an array ref.\n\n                    my $keywords = $bio_sequence->{keyword};\n                    my %key_to_value;\n\n                    for my $keywords (@$keywords) {\n                        # print \"keywords: $keywords\\n\";\n                        my @words = split(':', $keywords);\n                        for (my $i = 0; $i < scalar @words - 1; $i++) {\n                            if ($i % 2 == 0) {\n                                my $j = $i; $j++;\n                                # print \"$words[$i] , $words[$j]\\n\";\n                                $key_to_value{$words[$i]} = $words[$j];\n                            }\n                        }\n                        # print Data::Dumper->Dump([%key_to_value]);\n                        my $reference = Bio::Annotation::Reference->\n                            new(-authors => $key_to_value{authors},\n                                -title => $key_to_value{title},\n                                -database => $key_to_value{database},\n                                -pubmed => $key_to_value{pubmed},\n                               );\n                        $seq->annotation->add_Annotation('reference', $reference);\n\n                    }           # close for my $keywords\n\n\n                    #  print Data::Dumper->Dump([$bio_sequence]); print \"here\\n\"; exit;\n                    if (defined $bio_sequence->{'sequence_map'}) {\n\n                        for my $sequence_map (@{$bio_sequence->{'sequence_map'}}) {\n\n                            # print Data::Dumper->Dump([$sequence_map]); print \"here\\n\"; exit;\n\n                            my $label = $sequence_map->{label};\n\n                            if (defined $sequence_map->{annotations} &&\n                                ref($sequence_map->{annotations}) eq 'HASH') {\n\n                                # Get the sequence features (ie genes, exons, etc) from this $sequence_map\n                                for my $seq_feature (@{$sequence_map->{'annotations'}->{'seq_feature'}}) {\n\n                                    # print Data::Dumper->Dump([$seq_feature]); exit;\n                                    my $seq_location     = $seq_feature->{'seq_location'};\n                                    my $start_coord      = $seq_feature->{'least_start'}->[0];\n                                    my $feature_type     = $seq_feature->{'feature_type'}->[0];\n                                    my $end_coord        = $seq_feature->{'greatest_end'}->[0];\n                                    my $is_on_complement = $seq_feature->{'is_on_complement'}->[0];\n\n                                    # Specify the coordinates and the tag for this seq feature.\n                                    # print \"Primary Tag for this SeqFeature: $feature_type\\n\";\n                                    my $feat = Bio::SeqFeature::Generic->\n                                        new(\n                                            -start       => $start_coord,\n                                            -end         => $end_coord,\n                                            -primary_tag => $feature_type,\n                                           );\n\n\n                                    if (defined $seq_feature->{'qualifier'} &&\n                                        ref($seq_feature->{'qualifier'}) eq 'ARRAY') {\n\n                                        for my $feature (@{$seq_feature->{'qualifier'}}) {\n\n                                            my $value = $feature->{'qualifier'};\n                                            my $feature_type = $feature->{'qualifier_type'};\n\n                                            for (my $i = 0;\n                                                 $i < scalar @{$value};\n                                                 $i++) {\n                                                $feat->add_tag_value(\n                                                                     $feature_type->[$i] => $value->[$i]\n                                                                    );\n                                            } # close the for loop\n\n                                        }\n\n                                    } # close if (defined $seq_feature->...\n\n\n                                    $seq->add_SeqFeature($feat);\n\n\n                                } # close for my $seq_feature (@{$sequence_map->...\n\n\n                            }   # close if (defined $sequence_map->{annotations} &&\n\n\n                        }       # close for my $sequence_map (@{$bio_sequence->{'sequence_map'}}){\n\n                    }           # close if (defined $bio_sequence->{'sequence_map'}){\n\n\n                    # This is where the Bio::Seq objects are stored:\n                    push @{$self->{'sequence_objects'}}, $seq;\n\n\n                }               # close for my $fragment_orientation\n\n\n            }                   # close for my $fragment_order\n\n\n        }                       # close for my $contig\n\n\n    }                           # close for my $sciobj\n\n    # Flag is set so that we know that the sequence objects are now stored in $self.\n    $self->{'seqs_stored'} = 1;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 next_seq\n\n        Title    : next_seq\n        Usage    : $seq = $stream->next_seq()\n        Function : Returns the next sequence in the stream.\n        Args     : None.\n        Returns  : Bio::Seq object\n\nMethod is called from the script.  Method(s) that this method calls:\n_store_seqs (only once throughout the life time of script execution).\n\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    # convert agave to genbank/fasta/embl whatever.\n\n    $self->_store_seqs if $self->{'seqs_stored'} == 0;\n\n    $self->throw(\"Error: No Bio::Seq objects stored yet!\\n\\n\")\n        if !defined $self->{'sequence_objects'}; # This should never occur...\n\n    if (scalar @{$self->{'sequence_objects'}} > 0) {\n        return shift @{$self->{'sequence_objects'}};\n    } else {\n        # All done.  Nothing more to parse.\n        # print \"returning nothing!\\n\";\n        return 0;\n    }\n\n\n}\n# ==================================================================================\n\n=head2 next_primary_seq\n\n  Title   : next_primary_seq\n  Usage   : $seq = $stream->next_primary_seq()\n  Function: returns the next primary sequence (ie no seq_features) in the stream\n  Returns : Bio::PrimarySeq object\n  Args    : NONE\n\n\nsub next_primary_seq {\n    my $self=shift;\n    return 0;\n}\n# ==================================================================================\n\n=head2 write_seq\n\n  Title   : write_seq\n  Usage   : Not Yet Implemented! $stream->write_seq(@seq)\n  Function: writes the $seq object into the stream\n  Returns : 1 for success and 0 for error\n  Args    : Bio::Seq object\n\n\nsub write_seq {\n\n    # Convert the Bio::Seq object(s) to AGAVE xml file.\n\n    my ($self,@seqs) = @_;\n\n    foreach my $seq ( @seqs ) {\n        $self->_write_each_record( $seq ); # where most of the work actually takes place.\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _write_each_record\n\n  Title   : _write_each_record\n  Usage   : $agave->_write_each_record( $seqI )\n  Function: change data into agave format\n  Returns : NONE\n  Args    : Bio::SeqI object\n\n\nsub  _write_each_record {\n    my ($self,$seq) = @_;\n\n    # $self->{'file'} =~ s/>//g;\n    my $output = new IO::File(\">\" . $self->{'file'});\n    my $writer = new XML::Writer(OUTPUT => $output,\n                                 NAMESPACES => 0,\n                                 DATA_MODE => 1,\n                                 DATA_INDENT => 2 ) ;\n\n    $writer->xmlDecl(\"UTF-8\");\n    $writer->doctype(\"sciobj\", '', \"sciobj.dtd\");\n    $writer ->startTag('sciobj',\n                       'version', '2',\n                       'release', '2');\n\n    $writer->startTag('contig', 'length', $seq->length);\n    my $annotation = $seq ->annotation;\n    # print \"annotation: $annotation\\n\"; exit;  Bio::Annotation::Collection=HASH(0x8112e6c)\n    if ( $annotation->get_Annotations('dblink') ) {\n        # used to be $annotation->each_DBLink, but Bio::Annotation::Collection::each_DBLink\n        # is now replaced with get_Annotations('dblink')\n        my $dblink = $annotation->get_Annotations('dblink')->[0] ;\n\n        $writer ->startTag('db_id',\n                           'id', $dblink->primary_id ,\n                           'db_code', $dblink->database );\n    } else {\n        $writer ->startTag('db_id',\n                           'id', $seq->display_id ,\n                           'db_code', 'default' );\n    }\n    $writer ->endTag('db_id') ;\n\n\n    $writer->startTag('fragment_order');\n    $writer->startTag('fragment_orientation');\n\n    ##start bio_sequence\n    ####my $organism = $seq->species->genus . \" \" . $seq->species->species;\n    $writer ->startTag('bio_sequence',\n                       'sequence_id', $seq->display_id,\n                       'seq_length', $seq->length,\n                       # 'molecule_type', $seq->moltype, # deprecated\n                       'molecule_type', $self->alphabet,\n                       #'organism_name', $organism\n                      );\n\n    # my $desc = $seq->{primary_seq}->{desc};\n    # print \"desc: $desc\\n\"; exit;\n    # print Data::Dumper->Dump([$seq]);  exit;\n    ##start db_id under bio_sequence\n    $annotation = $seq ->annotation;\n    # print \"annotation: $annotation\\n\"; exit;  Bio::Annotation::Collection=HASH(0x8112e6c)\n    if ( $annotation->get_Annotations('dblink') ) {\n        # used to be $annotation->each_DBLink, but Bio::Annotation::Collection::each_DBLink\n        # is now replaced with get_Annotations('dblink')\n        my $dblink = $annotation->get_Annotations('dblink')->[0] ;\n\n        $writer ->startTag('db_id',\n                           'id', $dblink->primary_id ,\n                           'db_code', $dblink->database );\n    } else {\n        $writer ->startTag('db_id',\n                           'id', $seq->display_id ,\n                           'db_code', 'default' );\n    }\n    $writer ->endTag('db_id') ;\n\n    ##start note\n    my $note = \"\" ;\n    foreach my $comment ( $annotation->get_Annotations('comment') ) {\n        # used to be $annotations->each_Comment(), but that's now been replaced\n        # with get_Annotations()\n        # $comment is a Bio::Annotation::Comment object\n        $note .= $comment->text() . \"\\n\";\n    }\n\n    $writer ->startTag('note');\n    $writer ->characters( $note ) ;\n    $writer ->endTag('note');\n\n    ##start description\n    $writer ->startTag('description');\n\n    # $writer ->characters( $annotation->get_Annotations('description') ) ;\n    # used to be $annotations->each_description(), but that's now been\n    # replaced with get_Annotations.\n    # Simon added this: this is the primary_seq's desc (the DEFINITION tag in a genbank file)\n    $writer->characters($seq->{primary_seq}->{desc});\n    $writer ->endTag('description');\n\n    ##start keywords\n    foreach my $genename ( $annotation->get_Annotations('gene_name') ) {\n        # used to be $annotations->each_gene_name, but that's now been\n        # replaced with get_Annotations()\n        $writer ->startTag('keyword');\n        $writer ->characters( $genename ) ;\n        $writer ->endTag('keyword');\n    }\n\n\n    foreach my $ref ( $annotation->get_Annotations('reference') ) {\n        # used to be $annotation->each_Reference, but\n        # that's now been replaced with get_Annotations('reference');\n        # link is a Bio::Annotation::Reference object\n        $writer ->startTag('keyword');\n        # print Data::Dumper->Dump([$ref]); exit;\n        my $medline  = $ref->medline || 'null';\n        my $pubmed   = $ref->pubmed || 'null';\n        my $database = $ref->database || 'null';\n        my $authors  = $ref->authors || 'null';\n        my $title    = $ref->title || 'null';\n\n\n        $writer ->characters( 'medline:' . \"$medline\" . ':' . 'pubmed:' .\n                              \"$pubmed\" . ':' . 'database:' . \"$database\" .\n                              ':' .'authors:' . \"$authors\" . ':' . 'title:' . \"$title\" ) ;\n        $writer ->endTag('keyword');\n    }\n\n    ## start sequence\n    $writer ->startTag('sequence');\n    $writer ->characters( $seq->seq ) ;\n    $writer ->endTag('sequence');\n\n    ## start xrefs\n    $writer ->startTag('xrefs');\n    foreach my $link ( $annotation->get_Annotations('dblink') ) {\n        # link is a Bio::Annotation::DBLink object\n        $writer ->startTag('db_id',\n                           'db_code', $link->database,\n                           'id', $link->primary_id);\n        $writer ->characters( $link->comment ) ;\n        $writer ->endTag('db_id');\n    }\n    $writer ->endTag('xrefs') ;\n\n    ##start sequence map\n    ##we can not use :  my @feats = $seq->all_SeqFeatures;\n    ##rather, we use top_SeqFeatures() to keep the tree structure\n    my @feats = $seq->top_SeqFeatures ;\n\n    my $features;\n\n    ##now we need cluster top level seqfeature by algorithm\n    my $maps;\n    foreach my $feature (@feats) {\n        my $map_type = $feature ->source_tag;\n        push (@{$maps->{ $map_type }}, $feature);\n    }\n\n    ##now we enter each sequence_map\n    foreach my $map_type (keys  %$maps ) {\n        $writer->startTag('sequence_map',\n                          'label', $map_type );\n        $writer->startTag('annotations');\n        # the original author accidently entered 'annotation' instead of 'annotations'\n\n        foreach my $feature ( @{$maps->{ $map_type }} ) {\n            $self->_write_seqfeature( $feature, $writer ) ;\n        }\n\n        $writer->endTag('annotations');\n        $writer->endTag('sequence_map');\n    }\n\n    $writer->endTag('bio_sequence');\n    $writer->endTag('fragment_orientation');\n    $writer->endTag('fragment_order');\n    $writer->endTag('contig');\n    $writer->endTag('sciobj');\n\n}\n# ==================================================================================\n\n=head2 _write_seqfeature\n\n  Usage   : $agave->_write_each_record( $seqfeature, $write )\n  Function: change seeqfeature data into agave format\n  Returns : NONE\n  Args    : Bio::SeqFeature object and XML::writer object","parameters":[{"label":"$self"},{"label":"$seqf"},{"label":"$writer"}],"label":"_write_seqfeature($self,$seqf,$writer)"},"line":1700,"kind":12,"range":{"end":{"line":1745,"character":9999},"start":{"line":1700,"character":0}},"definition":"sub","detail":"($self,$seqf,$writer)","children":[{"definition":"my","line":1702,"name":"$self","containerName":"_write_seqfeature","localvar":"my","kind":13},{"kind":13,"containerName":"_write_seqfeature","name":"$seqf","line":1702},{"name":"$writer","kind":13,"containerName":"_write_seqfeature","line":1702},{"containerName":"_write_seqfeature","kind":13,"name":"$writer","line":1705},{"line":1705,"name":"startTag","kind":12,"containerName":"_write_seqfeature"},{"line":1706,"name":"$seqf","containerName":"_write_seqfeature","kind":13},{"name":"primary_tag","containerName":"_write_seqfeature","kind":12,"line":1706},{"definition":"my","containerName":"_write_seqfeature","localvar":"my","kind":13,"name":"$strand","line":1708},{"containerName":"_write_seqfeature","kind":13,"name":"$seqf","line":1708},{"line":1708,"containerName":"_write_seqfeature","kind":12,"name":"strand"},{"line":1709,"name":"$strand","kind":13,"containerName":"_write_seqfeature"},{"name":"$strand","kind":13,"containerName":"_write_seqfeature","line":1709},{"kind":13,"localvar":"my","containerName":"_write_seqfeature","name":"$is_on_complement","line":1711,"definition":"my"},{"line":1712,"name":"$strand","containerName":"_write_seqfeature","kind":13},{"line":1713,"kind":13,"containerName":"_write_seqfeature","name":"$is_on_complement"},{"kind":13,"containerName":"_write_seqfeature","name":"$is_on_complement","line":1715},{"name":"$writer","containerName":"_write_seqfeature","kind":13,"line":1719},{"line":1719,"name":"startTag","kind":12,"containerName":"_write_seqfeature"},{"line":1720,"containerName":"_write_seqfeature","kind":13,"name":"$seqf"},{"name":"start","containerName":"_write_seqfeature","kind":12,"line":1720},{"line":1721,"containerName":"_write_seqfeature","kind":13,"name":"$seqf"},{"line":1721,"name":"end","containerName":"_write_seqfeature","kind":12},{"line":1723,"kind":13,"containerName":"_write_seqfeature","name":"$is_on_complement"},{"line":1726,"containerName":"_write_seqfeature","kind":13,"name":"$writer"},{"line":1726,"containerName":"_write_seqfeature","kind":12,"name":"endTag"},{"name":"$tag","kind":13,"localvar":"my","containerName":"_write_seqfeature","line":1729,"definition":"my"},{"kind":13,"containerName":"_write_seqfeature","name":"$seqf","line":1729},{"kind":12,"containerName":"_write_seqfeature","name":"all_tags","line":1729},{"line":1730,"name":"$writer","kind":13,"containerName":"_write_seqfeature"},{"line":1730,"kind":12,"containerName":"_write_seqfeature","name":"startTag"},{"line":1731,"kind":13,"containerName":"_write_seqfeature","name":"$tag"},{"line":1732,"name":"$writer","kind":13,"containerName":"_write_seqfeature"},{"line":1732,"kind":12,"containerName":"_write_seqfeature","name":"characters"},{"line":1732,"kind":13,"containerName":"_write_seqfeature","name":"$seqf"},{"containerName":"_write_seqfeature","kind":12,"name":"each_tag_value","line":1732},{"containerName":"_write_seqfeature","kind":13,"name":"$tag","line":1732},{"line":1733,"name":"$writer","kind":13,"containerName":"_write_seqfeature"},{"name":"endTag","containerName":"_write_seqfeature","kind":12,"line":1733},{"definition":"my","localvar":"my","kind":13,"containerName":"_write_seqfeature","name":"$subfeat","line":1737},{"name":"$seqf","containerName":"_write_seqfeature","kind":13,"line":1737},{"name":"sub_SeqFeature","kind":12,"containerName":"_write_seqfeature","line":1737},{"containerName":"_write_seqfeature","kind":13,"name":"$self","line":1738},{"line":1738,"name":"_write_seqfeature","kind":12,"containerName":"_write_seqfeature"},{"line":1738,"kind":13,"containerName":"_write_seqfeature","name":"$subfeat"},{"kind":13,"containerName":"_write_seqfeature","name":"$writer","line":1738},{"line":1741,"kind":13,"containerName":"_write_seqfeature","name":"$writer"},{"containerName":"_write_seqfeature","kind":12,"name":"endTag","line":1741}],"containerName":"main::","name":"_write_seqfeature"},{"line":1759,"range":{"start":{"line":1759,"character":0},"end":{"line":1767,"character":9999}},"kind":12,"signature":{"label":"_filehandle($obj,$value)","parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _star_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    #print \"tag_name: $tag_name\\n\";\n    while ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper\n            ($1, $data_structure, $tag_name, $2, 'star');\n        # The tag and attribute values are stored within\n        # $$data_structure within the _tag_processing_helper method.\n        $$line = $self->_readline;\n    }\n    #if ($tag_name eq 'qualifier'){\n    #       print \"this one:\\n\";\n    #       print Data::Dumper->Dump([$data_structure]); exit;\n    #}\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _plus_tag\n\n  Title    : _plus_tag\n  Usage    : $self->_plus_tag\n  Function : Handles 'plus' tags (tags that occur one or more times).  tag_name+\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _star_tag\n\n\nsub _plus_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n\n        # Store value of the first occurence of $tag_name.\n        # All subsequent values, if any, will be stored in the method _star_tag.\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'plus');\n\n\n        # If the flow gets within this block, we've already determined\n        # that there's at least one of <$tag_name> Are there more?  To\n        # answer this, we could just treat the tag as a * tag now\n        # (zero or more).  We've already determined that it's NOT\n        # zero, so how many more?  Thus, call _star_tag.\n        $$line = $self->_readline;\n        $self->_star_tag($line, $data_structure, $tag_name);\n\n\n    } else {\n        $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _helper_store_attribute_list\n\n  Title    : _helper_store_attribute_list\n  Usage    : $self->_helper_store_attribute_list\n  Function : A helper method used to store the attributes from\n             the tags into the data structure.\n  Args     : 2 scalars:\n             - scalar holding the attribute values to be parsed.\n             - reference to a data structure to store the data between the 2 tags.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : Many.\n             Method(s) that this method call(s) : None.\n\n\nsub _helper_store_attribute_list {\n\n    my ($self, $attribute_line, $data_structure) = @_;\n\n    my %attribs = ($attribute_line =~ /(\\w+)\\s*=\\s*\"([^\"]*)\"/g);\n\n    my $attribute_list;\n    for my $key (keys %attribs) {\n        # print \"\\tkey: $key , value: $attribs{$key}\\n\";\n        ###$$data_structure->{$key} = $attribs{$key};           # <- The ORIGINAL.\n        push @{$$data_structure->{$key}}, $attribs{$key};\n        # Now, store them in an array because there may be > 1 tag, thus\n        # > 1 attribute of the same name.\n        # Doing this has made it necessary to change the _store_seqs method.\n        # ie: Change $bio_sequence->{'molecule_type'};\n        # to\n        # $bio_sequence->{'molecule_type'}->[0];\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _store_seqs\n\n  Title    : _store_seqs\n  Usage    : $self->_store_seqs\n  Function : This method is called once in the life time of the script.\n             It stores the data parsed from the agave xml file into\n             the Bio::Seq object.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : next_seq\n             Method(s) that this method calls   : None.\n\n\nsub _store_seqs {\n\n    my ($self) = @_;\n\n\n    for my $sciobj (@{$self->{'sciobj'}}) {\n\n        ### $sciobj = $self->{'sciobj'};                # The root node.\n\n\n        for my $contig (@{$sciobj->{'contig'}}) { # Each contig has a fragment order.\n\n            for my $fragment_order (@{$contig->{'fragment_order'}}) { # Each fragment order has a fragment_orientation.\n\n                for my $fragment_orientation (@{$fragment_order->{'fragment_orientation'}}) {\n                    # Each fragment_orientation contain 1 bio sequence.\n\n                    my $bio_sequence = $fragment_orientation->{'bio_sequence'}; # <bio_sequence> contains all the\n                    # interesting stuff:\n\n                    my $sequence         = $bio_sequence->{'sequence'};\n                    my $accession_number = $bio_sequence->{'sequence_id'}->[0]; # also use for primary_id\n                    my $organism         = $bio_sequence->{'organism'};\n                    my $description      = $bio_sequence->{'description'};\n                    my $molecule_type    = $bio_sequence->{'molecule_type'}->[0];\n\n                    my $primary_seq = Bio::PrimarySeq->new(\n                                                           -id       => $accession_number,\n                                                           -alphabet => $molecule_type,\n                                                           -seq      => $sequence,\n                                                           -desc     => $description,\n                                                          );\n\n                    my $seq = Bio::Seq->new (\n                                             -display_id       => $accession_number,\n                                             -accession_number => $accession_number,\n                                             -primary_seq      => $primary_seq,\n                                             -seq              => $sequence,\n                                             -description      => $description,\n                                            );\n\n                    my $organism_name = $bio_sequence->{organism_name}->[0];\n                    if (defined $organism_name) {\n\n                        my @classification = split(' ', $organism_name);\n                        my $species = Bio::Species->new();\n                        $species->classification(@classification);\n                        $seq->species($species);\n                    }\n                    # Pull out the keywords: $keywords is an array ref.\n\n                    my $keywords = $bio_sequence->{keyword};\n                    my %key_to_value;\n\n                    for my $keywords (@$keywords) {\n                        # print \"keywords: $keywords\\n\";\n                        my @words = split(':', $keywords);\n                        for (my $i = 0; $i < scalar @words - 1; $i++) {\n                            if ($i % 2 == 0) {\n                                my $j = $i; $j++;\n                                # print \"$words[$i] , $words[$j]\\n\";\n                                $key_to_value{$words[$i]} = $words[$j];\n                            }\n                        }\n                        # print Data::Dumper->Dump([%key_to_value]);\n                        my $reference = Bio::Annotation::Reference->\n                            new(-authors => $key_to_value{authors},\n                                -title => $key_to_value{title},\n                                -database => $key_to_value{database},\n                                -pubmed => $key_to_value{pubmed},\n                               );\n                        $seq->annotation->add_Annotation('reference', $reference);\n\n                    }           # close for my $keywords\n\n\n                    #  print Data::Dumper->Dump([$bio_sequence]); print \"here\\n\"; exit;\n                    if (defined $bio_sequence->{'sequence_map'}) {\n\n                        for my $sequence_map (@{$bio_sequence->{'sequence_map'}}) {\n\n                            # print Data::Dumper->Dump([$sequence_map]); print \"here\\n\"; exit;\n\n                            my $label = $sequence_map->{label};\n\n                            if (defined $sequence_map->{annotations} &&\n                                ref($sequence_map->{annotations}) eq 'HASH') {\n\n                                # Get the sequence features (ie genes, exons, etc) from this $sequence_map\n                                for my $seq_feature (@{$sequence_map->{'annotations'}->{'seq_feature'}}) {\n\n                                    # print Data::Dumper->Dump([$seq_feature]); exit;\n                                    my $seq_location     = $seq_feature->{'seq_location'};\n                                    my $start_coord      = $seq_feature->{'least_start'}->[0];\n                                    my $feature_type     = $seq_feature->{'feature_type'}->[0];\n                                    my $end_coord        = $seq_feature->{'greatest_end'}->[0];\n                                    my $is_on_complement = $seq_feature->{'is_on_complement'}->[0];\n\n                                    # Specify the coordinates and the tag for this seq feature.\n                                    # print \"Primary Tag for this SeqFeature: $feature_type\\n\";\n                                    my $feat = Bio::SeqFeature::Generic->\n                                        new(\n                                            -start       => $start_coord,\n                                            -end         => $end_coord,\n                                            -primary_tag => $feature_type,\n                                           );\n\n\n                                    if (defined $seq_feature->{'qualifier'} &&\n                                        ref($seq_feature->{'qualifier'}) eq 'ARRAY') {\n\n                                        for my $feature (@{$seq_feature->{'qualifier'}}) {\n\n                                            my $value = $feature->{'qualifier'};\n                                            my $feature_type = $feature->{'qualifier_type'};\n\n                                            for (my $i = 0;\n                                                 $i < scalar @{$value};\n                                                 $i++) {\n                                                $feat->add_tag_value(\n                                                                     $feature_type->[$i] => $value->[$i]\n                                                                    );\n                                            } # close the for loop\n\n                                        }\n\n                                    } # close if (defined $seq_feature->...\n\n\n                                    $seq->add_SeqFeature($feat);\n\n\n                                } # close for my $seq_feature (@{$sequence_map->...\n\n\n                            }   # close if (defined $sequence_map->{annotations} &&\n\n\n                        }       # close for my $sequence_map (@{$bio_sequence->{'sequence_map'}}){\n\n                    }           # close if (defined $bio_sequence->{'sequence_map'}){\n\n\n                    # This is where the Bio::Seq objects are stored:\n                    push @{$self->{'sequence_objects'}}, $seq;\n\n\n                }               # close for my $fragment_orientation\n\n\n            }                   # close for my $fragment_order\n\n\n        }                       # close for my $contig\n\n\n    }                           # close for my $sciobj\n\n    # Flag is set so that we know that the sequence objects are now stored in $self.\n    $self->{'seqs_stored'} = 1;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 next_seq\n\n        Title    : next_seq\n        Usage    : $seq = $stream->next_seq()\n        Function : Returns the next sequence in the stream.\n        Args     : None.\n        Returns  : Bio::Seq object\n\nMethod is called from the script.  Method(s) that this method calls:\n_store_seqs (only once throughout the life time of script execution).\n\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    # convert agave to genbank/fasta/embl whatever.\n\n    $self->_store_seqs if $self->{'seqs_stored'} == 0;\n\n    $self->throw(\"Error: No Bio::Seq objects stored yet!\\n\\n\")\n        if !defined $self->{'sequence_objects'}; # This should never occur...\n\n    if (scalar @{$self->{'sequence_objects'}} > 0) {\n        return shift @{$self->{'sequence_objects'}};\n    } else {\n        # All done.  Nothing more to parse.\n        # print \"returning nothing!\\n\";\n        return 0;\n    }\n\n\n}\n# ==================================================================================\n\n=head2 next_primary_seq\n\n  Title   : next_primary_seq\n  Usage   : $seq = $stream->next_primary_seq()\n  Function: returns the next primary sequence (ie no seq_features) in the stream\n  Returns : Bio::PrimarySeq object\n  Args    : NONE\n\n\nsub next_primary_seq {\n    my $self=shift;\n    return 0;\n}\n# ==================================================================================\n\n=head2 write_seq\n\n  Title   : write_seq\n  Usage   : Not Yet Implemented! $stream->write_seq(@seq)\n  Function: writes the $seq object into the stream\n  Returns : 1 for success and 0 for error\n  Args    : Bio::Seq object\n\n\nsub write_seq {\n\n    # Convert the Bio::Seq object(s) to AGAVE xml file.\n\n    my ($self,@seqs) = @_;\n\n    foreach my $seq ( @seqs ) {\n        $self->_write_each_record( $seq ); # where most of the work actually takes place.\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _write_each_record\n\n  Title   : _write_each_record\n  Usage   : $agave->_write_each_record( $seqI )\n  Function: change data into agave format\n  Returns : NONE\n  Args    : Bio::SeqI object\n\n\nsub  _write_each_record {\n    my ($self,$seq) = @_;\n\n    # $self->{'file'} =~ s/>//g;\n    my $output = new IO::File(\">\" . $self->{'file'});\n    my $writer = new XML::Writer(OUTPUT => $output,\n                                 NAMESPACES => 0,\n                                 DATA_MODE => 1,\n                                 DATA_INDENT => 2 ) ;\n\n    $writer->xmlDecl(\"UTF-8\");\n    $writer->doctype(\"sciobj\", '', \"sciobj.dtd\");\n    $writer ->startTag('sciobj',\n                       'version', '2',\n                       'release', '2');\n\n    $writer->startTag('contig', 'length', $seq->length);\n    my $annotation = $seq ->annotation;\n    # print \"annotation: $annotation\\n\"; exit;  Bio::Annotation::Collection=HASH(0x8112e6c)\n    if ( $annotation->get_Annotations('dblink') ) {\n        # used to be $annotation->each_DBLink, but Bio::Annotation::Collection::each_DBLink\n        # is now replaced with get_Annotations('dblink')\n        my $dblink = $annotation->get_Annotations('dblink')->[0] ;\n\n        $writer ->startTag('db_id',\n                           'id', $dblink->primary_id ,\n                           'db_code', $dblink->database );\n    } else {\n        $writer ->startTag('db_id',\n                           'id', $seq->display_id ,\n                           'db_code', 'default' );\n    }\n    $writer ->endTag('db_id') ;\n\n\n    $writer->startTag('fragment_order');\n    $writer->startTag('fragment_orientation');\n\n    ##start bio_sequence\n    ####my $organism = $seq->species->genus . \" \" . $seq->species->species;\n    $writer ->startTag('bio_sequence',\n                       'sequence_id', $seq->display_id,\n                       'seq_length', $seq->length,\n                       # 'molecule_type', $seq->moltype, # deprecated\n                       'molecule_type', $self->alphabet,\n                       #'organism_name', $organism\n                      );\n\n    # my $desc = $seq->{primary_seq}->{desc};\n    # print \"desc: $desc\\n\"; exit;\n    # print Data::Dumper->Dump([$seq]);  exit;\n    ##start db_id under bio_sequence\n    $annotation = $seq ->annotation;\n    # print \"annotation: $annotation\\n\"; exit;  Bio::Annotation::Collection=HASH(0x8112e6c)\n    if ( $annotation->get_Annotations('dblink') ) {\n        # used to be $annotation->each_DBLink, but Bio::Annotation::Collection::each_DBLink\n        # is now replaced with get_Annotations('dblink')\n        my $dblink = $annotation->get_Annotations('dblink')->[0] ;\n\n        $writer ->startTag('db_id',\n                           'id', $dblink->primary_id ,\n                           'db_code', $dblink->database );\n    } else {\n        $writer ->startTag('db_id',\n                           'id', $seq->display_id ,\n                           'db_code', 'default' );\n    }\n    $writer ->endTag('db_id') ;\n\n    ##start note\n    my $note = \"\" ;\n    foreach my $comment ( $annotation->get_Annotations('comment') ) {\n        # used to be $annotations->each_Comment(), but that's now been replaced\n        # with get_Annotations()\n        # $comment is a Bio::Annotation::Comment object\n        $note .= $comment->text() . \"\\n\";\n    }\n\n    $writer ->startTag('note');\n    $writer ->characters( $note ) ;\n    $writer ->endTag('note');\n\n    ##start description\n    $writer ->startTag('description');\n\n    # $writer ->characters( $annotation->get_Annotations('description') ) ;\n    # used to be $annotations->each_description(), but that's now been\n    # replaced with get_Annotations.\n    # Simon added this: this is the primary_seq's desc (the DEFINITION tag in a genbank file)\n    $writer->characters($seq->{primary_seq}->{desc});\n    $writer ->endTag('description');\n\n    ##start keywords\n    foreach my $genename ( $annotation->get_Annotations('gene_name') ) {\n        # used to be $annotations->each_gene_name, but that's now been\n        # replaced with get_Annotations()\n        $writer ->startTag('keyword');\n        $writer ->characters( $genename ) ;\n        $writer ->endTag('keyword');\n    }\n\n\n    foreach my $ref ( $annotation->get_Annotations('reference') ) {\n        # used to be $annotation->each_Reference, but\n        # that's now been replaced with get_Annotations('reference');\n        # link is a Bio::Annotation::Reference object\n        $writer ->startTag('keyword');\n        # print Data::Dumper->Dump([$ref]); exit;\n        my $medline  = $ref->medline || 'null';\n        my $pubmed   = $ref->pubmed || 'null';\n        my $database = $ref->database || 'null';\n        my $authors  = $ref->authors || 'null';\n        my $title    = $ref->title || 'null';\n\n\n        $writer ->characters( 'medline:' . \"$medline\" . ':' . 'pubmed:' .\n                              \"$pubmed\" . ':' . 'database:' . \"$database\" .\n                              ':' .'authors:' . \"$authors\" . ':' . 'title:' . \"$title\" ) ;\n        $writer ->endTag('keyword');\n    }\n\n    ## start sequence\n    $writer ->startTag('sequence');\n    $writer ->characters( $seq->seq ) ;\n    $writer ->endTag('sequence');\n\n    ## start xrefs\n    $writer ->startTag('xrefs');\n    foreach my $link ( $annotation->get_Annotations('dblink') ) {\n        # link is a Bio::Annotation::DBLink object\n        $writer ->startTag('db_id',\n                           'db_code', $link->database,\n                           'id', $link->primary_id);\n        $writer ->characters( $link->comment ) ;\n        $writer ->endTag('db_id');\n    }\n    $writer ->endTag('xrefs') ;\n\n    ##start sequence map\n    ##we can not use :  my @feats = $seq->all_SeqFeatures;\n    ##rather, we use top_SeqFeatures() to keep the tree structure\n    my @feats = $seq->top_SeqFeatures ;\n\n    my $features;\n\n    ##now we need cluster top level seqfeature by algorithm\n    my $maps;\n    foreach my $feature (@feats) {\n        my $map_type = $feature ->source_tag;\n        push (@{$maps->{ $map_type }}, $feature);\n    }\n\n    ##now we enter each sequence_map\n    foreach my $map_type (keys  %$maps ) {\n        $writer->startTag('sequence_map',\n                          'label', $map_type );\n        $writer->startTag('annotations');\n        # the original author accidently entered 'annotation' instead of 'annotations'\n\n        foreach my $feature ( @{$maps->{ $map_type }} ) {\n            $self->_write_seqfeature( $feature, $writer ) ;\n        }\n\n        $writer->endTag('annotations');\n        $writer->endTag('sequence_map');\n    }\n\n    $writer->endTag('bio_sequence');\n    $writer->endTag('fragment_orientation');\n    $writer->endTag('fragment_order');\n    $writer->endTag('contig');\n    $writer->endTag('sciobj');\n\n}\n# ==================================================================================\n\n=head2 _write_seqfeature\n\n  Usage   : $agave->_write_each_record( $seqfeature, $write )\n  Function: change seeqfeature data into agave format\n  Returns : NONE\n  Args    : Bio::SeqFeature object and XML::writer object\n\n\nsub _write_seqfeature{\n\n    my ($self,$seqf, $writer) = @_;\n\n    ##now enter seq feature\n    $writer ->startTag('seq_feature',\n                       'feature_type', $seqf->primary_tag() );\n\n    my $strand = $seqf->strand();\n    $strand = 0 if !defined $strand;\n    # $strand == 1 ? 'false' : 'true';\n    my $is_on_complement;\n    if ($strand == 1) {\n        $is_on_complement = 'true';\n    } else {\n        $is_on_complement = 'false';\n    }\n\n    # die Data::Dumper->Dump([$seqf]) if !defined $strand;\n    $writer ->startTag('seq_location',\n                       'lease_start', $seqf->start(),\n                       'greatest_end', $seqf->end(),\n                       # 'is_on_complement', $seqf->strand() == 1 ? 'false' : 'true') ;\n                       'is_on_complement' , $is_on_complement);\n    # is_on_complement: is the feature found on the complementary\n    # strand (true) or not (false)?\n    $writer ->endTag('seq_location');\n\n    ##enter qualifier\n    foreach my $tag ( $seqf->all_tags() ) {\n        $writer ->startTag('qualifier',\n                           'qualifier_type', $tag);\n        $writer ->characters( $seqf->each_tag_value($tag) ) ;\n        $writer ->endTag('qualifier');\n    }\n\n    ##now recursively travel the seqFeature\n    foreach my $subfeat ( $seqf->sub_SeqFeature ) {\n        $self->_write_seqfeature( $subfeat, $writer ) ;\n    }\n\n    $writer->endTag('seq_feature');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _filehandle\n\n  Title   : _filehandle\n  Usage   : $obj->_filehandle($newval)\n  Function:\n  Example :\n  Returns : value of _filehandle\n  Args    : newvalue (optional)"},"children":[{"definition":"my","line":1761,"localvar":"my","kind":13,"containerName":"_filehandle","name":"$obj"},{"line":1761,"name":"$value","kind":13,"containerName":"_filehandle"},{"kind":13,"containerName":"_filehandle","name":"$value","line":1762},{"line":1763,"containerName":"_filehandle","kind":13,"name":"$obj"},{"containerName":"_filehandle","kind":13,"name":"$value","line":1763},{"name":"$obj","containerName":"_filehandle","kind":13,"line":1765}],"containerName":"main::","name":"_filehandle","definition":"sub","detail":"($obj,$value)"},{"definition":"sub","detail":"($self,@s)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"throw","line":1784,"definition":"my"},{"line":1784,"kind":13,"containerName":"throw","name":"@s"},{"localvar":"my","containerName":"throw","kind":13,"name":"$string","line":1785,"definition":"my"},{"line":1785,"name":"@s","kind":13,"containerName":"throw"},{"line":1786,"name":"$self","kind":13,"containerName":"throw"},{"line":1786,"kind":13,"containerName":"throw","name":"$string"}],"containerName":"main::","name":"throw","signature":{"label":"throw($self,@s)","documentation":"1;\n# BioPerl module: Bio::SeqIO::agave\n#\n# AGAVE: Architecture for Genomic Annotation, Visualization and Exchange.\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# The original version of the module can be found here:\n# http://www.agavexml.org/\n#\n# ### TODO: live link for this anymore?\n# The DTD for AGAVE XML was once located here (dead link):\n# http://www.lifecde.com/products/agave/schema/v2_3/agave.dtd\n#\n#\n=head1 NAME\n\nBio::SeqIO::agave - AGAVE sequence output stream.\n\n=head1 SYNOPSIS\n\nIt is probably best not to use this object directly, but\nrather go through the SeqIO handler system. Go:\n\n  $in  = Bio::SeqIO->new('-file'   => \"$file_in\",\n                         '-format' => 'EMBL');\n\n  $out = Bio::SeqIO->new('-file'   => \">$file_out\",\n                         '-format' => 'AGAVE');\n\n  while (my $seq = $in->next_seq){\n        $out->write_seq($seq);\n  }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::Seq objects to agave xml file and\nvice-versa.  I (Simon) coded up this module because I needed a parser\nto extract data from AGAVE xml to be utitlized by the GenQuire genome\nannotation system (See http://www.bioinformatics.org/Genquire).\n\n***NOTE*** At the moment, not all of the tags are implemented.  In\ngeneral, I followed the output format for the XEMBL project\nhttp://www.ebi.ac.uk/xembl/\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Simon K. Chan\n\nEmail:\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# ===================\n\n\n# Let the code begin...\npackage Bio::SeqIO::agave;\nuse strict;\n\nuse IO::File;\n\n\nuse Bio::SeqFeature::Generic;\nuse Bio::Seq;\nuse Bio::PrimarySeq;\nuse Bio::Seq::SeqFactory;\nuse Bio::Annotation::Reference;\nuse Bio::Species;\n\nuse XML::Writer;\n\nuse Data::Dumper;\n\nuse base qw(Bio::SeqIO);\n\n# ==================================================================================\nsub _initialize {\n\n    my ($self,@args) = @_;\n    $self->SUPER::_initialize(@args); # Run the constructor of the parent class.\n\n    my %tmp = @args ;\n    $self->{'file'} = $tmp{'-file'};\n\n    if ($self->{'file'} !~ /^>/) {\n        $self->_process;\n        # Parse the thing, but only if it is the input file (ie not\n        # outputing agave file, but reading it).\n        $self->{'parsed'} = 1;\n        # Set the flag to let the code know that the agave xml file\n        # has been parsed.\n    }\n    $self->{'seqs_stored'} = 0;\n\n}\n# ==================================================================================\n\n=head2 _process\n\n  Title    : _process\n  Usage    : $self->_process\n  Function : Parses the agave xml file.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _initialize\n             Method(s) that this method calls   : _process_sciobj\n             FIRST/START sub.\n\n\nsub _process {\n    my ($self) = @_;\n\n    while (1) {\n\n        my $line = $self->_readline;\n        next unless $line;\n        next if $line =~ /^\\s*$/;\n\n        if ($line =~ /<\\?xml version/o) {\n\n            # do nothing\n\n        } elsif ($line =~ /\\<!DOCTYPE (\\w+) SYSTEM \"([\\w\\.]+)\"\\>/) {\n\n            $self->throw(\"Error: This xml file is not in AGAVE format! DOCTYPE: $1 , SYSTEM: $2\\n\\n\")\n                if $1 ne 'sciobj' || $2 ne 'sciobj.dtd';\n\n        } elsif ($line =~ /<sciobj (.*)>/) {\n\n            push @{$self->{'sciobj'}}, $self->_process_sciobj($1);\n\n        } elsif ($line =~ /<\\/sciobj>/) {\n\n            last;               # It is finished.\n\n        } else {\n\n            # throw an error message.  The above conditions should\n            # take care all of the possible options...?\n            # $self->throw(\"Error: Do not recognize this AGAVE xml\n            # line: $line\\n\\n\");\n\n        }\n\n\n    }                           # close while loop\n\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sciobj\n\n  Title    : _process_sciobj\n  Usage    : $self->_process_sciobj\n  Function : Parses the data between the <sciobj></sciobj> tags.\n  Args     : The string that holds the attributes for <sciobj>.\n  Returns  : Data structure holding the values parsed between\n             the <sciobj></sciobj> tags.\n  Note     : Method(s) that call(s) this method : _process\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_contig\n\n\nsub _process_sciobj {\n\n    my ($self, $attribute_line) = @_;\n    my $sciobj;\n    $self->_helper_store_attribute_list($attribute_line, \\$sciobj);\n\n    my $line = $self->_readline;\n\n    # Zero or more <contig>\n    while ($line =~ /<contig\\s?(.*?)\\s?>/) {\n        my $contig = $self->_process_contig(\\$line, $1);\n        push @{$sciobj->{'contig'}}, $contig;\n        # print \"line in _process_sciobj: $line\\n\";\n        # $line changes value within the subs called in this sub (_process_contig).\n    }\n\n    return $sciobj;\n}\n# ==================================================================================\n\n=head2 _process_contig\n\n  Title    : _process_contig\n  Usage    : $self->_process_contig\n  Function : Parses the data between the <contig></contig> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the line to be parsed.\n             - scalar holding the attributes for the <contig> tag\n               to be parsed.\n  Returns  : Data structure holding the values parsed between\n             the <contig></contig> tags.\n  Note     : Method(s) that call(s) this method : _process_sciobj\n             Method(s) that this method calls   :\n             _helper_store_attribute_list, _one_tag , _process_fragment_order\n\n\nsub _process_contig {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $contig;\n    $self->_helper_store_attribute_list($attribute_line, \\$contig);\n    $$line = $self->_readline;\n\n    # One <db_id>:\n    $self->_one_tag($line, \\$contig, 'db_id');\n\n\n    # Zero or more <fragment_order>\n    $self->_process_fragment_order($line, \\$contig);\n\n    return $contig;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_order\n\n  Title    : _process_fragment_order\n  Usage    : $self->_process_fragment_order\n  Function : Parses the data between the <fragment_order></fragment_order> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_order> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_contig\n             Method(s) that this method calls   :\n             _helper_store_attribute_list , _process_fragment_orientation\n\n\nsub _process_fragment_order {\n\n\n    my ($self, $line, $data_structure) = @_;\n    # Because I'm passing a reference to a data structure, I don't need to return it\n    # after values have been added.\n\n    while ($$line =~ /<fragment_order\\s?(.*?)\\s?>/) {\n\n        my $fragment_order;\n        $self->_helper_store_attribute_list($1, \\$fragment_order);\n        # Store the attribute(s) for <fragment_order> into the\n        # $fragment_order data structure.\n        $$line = $self->_readline;\n\n        # One or more <fragment_orientation>\n        $self->_process_fragment_orientation($line, \\$fragment_order);\n        # Don't forget: $line is a reference to a scalar.\n\n        push @{$$data_structure->{'fragment_order'}}, $fragment_order;\n        # Store the data between <fragment_order></fragment_order>\n        # in $$data_structure.\n\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_fragment_orientation\n\n  Title    : _process_fragment_orientation\n  Usage    : $self->_process_fragment_orientation\n  Function : Parses the data between the <fragment_orientation> and\n             </fragment_orientation> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <fragment_orientation> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_fragment_order\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_process_bio_sequence\n\n\nsub _process_fragment_orientation {\n\n\n    my ($self, $line, $data_structure) = @_;\n\n    # counter to determine the number of iterations within this while loop.\n    my $count = 0;\n\n    # One or more <fragment_orientation>\n    while ($$line =~ /<fragment_orientation\\s?(.*?)\\s?>/) {\n\n        my $fragment_orientation;\n        $self->_helper_store_attribute_list($1, \\$fragment_orientation);\n        $$line = $self->_readline;\n\n        # One <bio_sequence>\n        $$line =~ /<bio_sequence\\s?(.*?)\\s?>/;\n        # Process the data between <bio_sequence></bio_sequence>\n        my $bio_sequence = $self->_process_bio_sequence($line, $1);\n        $fragment_orientation->{'bio_sequence'} = $bio_sequence;\n\n        push @{$$data_structure->{'fragment_orientation'}}, $fragment_orientation;\n\n        ++$count;\n    }\n\n\n    $self->throw(\"Error: Missing <fragment_orientation> tag.  Got this: $$line\\n\\n\")\n        if $count == 0;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_bio_sequence\n\n  Title    : _process_bio_sequence\n  Usage    : $self->_process_bio_sequence\n  Function : Parses the data between the <bio_sequence></bio_sequence> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - scalar holding the value of the attributes for <bio_sequence>\n  Returns  : data structure holding the values between <bio_sequence></bio_sequence>\n  Note     : Method(s) that call(s) this method : _process_fragment_orientation\n\nMethod(s) that this method calls : _helper_store_attribute_list ,\n_one_tag , _question_mark_tag , _star_tag , _process_alt_ids ,\n_process_xrefs , _process_sequence_map\n\n\nsub _process_bio_sequence {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $bio_sequence;\n\n    $self->_helper_store_attribute_list($attribute_line, \\$bio_sequence);\n    $$line = $self->_readline;\n\n\n    # One <db_id>.\n    $self->_one_tag($line, \\$bio_sequence, 'db_id');\n\n\n    # Zero or one <note>.\n    $self->_question_mark_tag($line, \\$bio_sequence, 'note');\n\n\n    # Zero or more <description>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'description');\n\n\n    # Zero or more <keyword>\n    $self->_star_tag($line, \\$bio_sequence, 'keyword');\n\n\n    # Zero or one <sequence>\n    $self->_question_mark_tag($line, \\$bio_sequence, 'sequence');\n\n\n    # Zero or one <alt_ids>\n    # NOT IMPLEMENTED!!!!\n    #if ($line =~ /<alt_ids>/){ # NOT DONE YET!\n    #       my $alt_ids;\n    #       $bio_sequence->{'alt_ids'} = $self->_process_alt_ids(\\$alt_ids);\n    #}\n\n\n    # Zero or one <xrefs>\n    if ($$line =~ /<xrefs\\s?(.*?)\\s?>/) {\n        my $xrefs = $self->_process_xrefs($line, \\$bio_sequence);\n        $bio_sequence->{'xrefs'} = $xrefs || 'null';\n    }\n\n\n    # Zero or more <sequence_map>\n    if ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n        my $sequence_map = $self->_process_sequence_map($line);\n        push @{$bio_sequence->{'sequence_map'}}, $sequence_map;\n    }\n\n    # print Data::Dumper->Dump([$bio_sequence]); exit;\n\n    return $bio_sequence;\n\n}\n# ==================================================================================\n\n=head2 _process_xrefs\n\n  Title    : _process_xrefs\n  Usage    : $self->_process_xrefs\n  Function : Parse the data between the <xrefs></xrefs> tags.\n  Args     : reference to a scalar holding the value of the line to be parsed.\n  Return   : Nothing.\n  Note     : Method(s) that call(s) this method: _process_bio_sequence\n             Method(s) that this method calls: _one_tag , _process_xref\n\n\nsub _process_xrefs {\n\n    my ($self, $line) = @_;\n\n    my $xrefs;\n\n    $$line = $self->_readline;\n\n    # One or more <db_id> or <xref> within <xrefs></xrefs>.  Check if\n    # to see if there's at least one.\n    if ($$line =~ /<db_id|xref\\s?(.*?)\\s?>/) {\n\n        while ($$line =~ /<(db_id|xref)\\s?(.*?)\\s?>/) {\n\n            if ($1 eq \"db_id\") {\n\n                my $db_id;\n                $self->_one_tag($line, \\$db_id, 'db_id');\n                push @{$xrefs->{'db_id'}}, $db_id;\n\n            } elsif ($1 eq \"xref\") {\n\n                my $xref;\n                $self->_process_xref($line, \\$xref);\n                push @{$xrefs->{'xref'}}, $xref;\n\n            } else {\n\n                $self->throw(\"Error:  Tag type should be one of db_id or xref!  Got this: $$line\\n\\n\");\n            }\n\n\n        }                       # close while loop\n\n\n        if ($$line =~ /<\\/xrefs>/) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub.\n            return $xrefs;\n        } else {\n            $self->throw(\"Error: Missing </xrefs> tag.  Got this: $$line\\n\\n\");\n        }\n\n\n\n    } else {\n\n        $self->throw(\"Error: Missing <db_id> or <xref> tag.  Got this: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_xref\n\n  Title    : _process_xref\n  Usage    : $self->_process_xref\n  Function : Parses the data between the <xref></xref> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <xref> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_xrefs (note the 's' in 'xrefs')\n             Method(s) that this method calls   : _helper_store_attribute_list , _star_tag\n\n\nsub _process_xref {\n\n    my ($self, $line, $xref) = @_;\n\n    $$line = $self->_readline;\n\n    # One <db_id>\n    if ($$line =~ /<db_id\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, $xref);\n    } else {\n        $self->throw(\"Error:  Missing <db_id> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n    # Zero or more <xref_property>\n    $self->_star_tag($line, $xref, 'xref_propery');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _process_sequence_map\n\n  Title    : _process_sequence_map\n  Usage    : $self->_process_sequence_map\n  Function : Parses the data between the <sequence_map></sequence_map> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_bio_sequence\n             Method(s) that this method calls   : _helper_store_attribute_list ,\n                _question_mark_tag , _process_annotations\n\n\nsub _process_sequence_map {\n\n    my ($self, $line) = @_;\n\n    my $sequence_map;\n\n    # Zero or more <sequence_map>\n    while ($$line =~ /<sequence_map\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$sequence_map) if defined $1;\n        $$line = $self->_readline;\n\n        # Zero or one <note>\n        $self->_question_mark_tag($line, \\$sequence_map, 'note');\n\n        # NOT IMPLEMENTED!!!\n        #if ($$line =~ /<computations\\?(.*?)\\s?>/){\n        #       # $self->_process_computations();\n        #}\n\n\n        # Zero or one <annotations>\n        if ($$line =~ /<annotations\\s?(.*?)\\s?>/) {\n            my $annotations = $self->_process_annotations($line);\n            $sequence_map->{'annotations'} = $annotations;\n        }\n\n\n    }                           # closes the while loop\n\n\n    # Match closing tag:\n    if ($$line =~ /<\\/sequence_map>/) {\n        return $sequence_map;\n    } else {\n        $self->throw(\"Error:  Missing </sequence_map> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_annotations\n\n  Title    : _process_annotations\n  Usage    : $self->_process_annotations\n  Function : Parse the data between the <annotations></annotations> tags.\n  Args     : Reference to scalar holding the line to be parsed.\n  Returns  : Data structure that holds the values that were parsed.\n  Note     : Method(s) that call(s) this method : _process_sequence_map\n             Method(s) that this method calls   : _process_seq_feature\n\n\nsub _process_annotations {\n\n    my ($self, $line) = @_;\n    # ( seq_feature | gene | comp_result )+\n\n    my $annotations;\n\n    $$line = $self->_readline;\n\n    my $count = 0;              # counter to keep track of number of iterations in the loop.\n\n    # One or more of these:\n    while ($$line =~ /<(seq_feature|gene|comp_result)\\s?(.*?)\\s?>/) {\n\n        if ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n\n            my $seq_feature = $self->_process_seq_feature($line, $1);\n            push @{$annotations->{'seq_feature'}}, $seq_feature;\n\n        } elsif ($$line =~ /<gene\\s?(.*?)\\s?>/) {\n\n            # gene\n\n        } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n\n            # comp_result\n\n        }\n\n        ++$count;\n\n    }                           # closes the while loop.\n\n    $self->throw(\"Error:  Missing <seq_feature> tag.  Got: $$line\\n\\n\") if $count == 0;\n\n    # Match closing tag:\n    if ($$line =~ /<\\/annotations/) {\n\n        $$line = $self->_readline; # get the next line to be _processed by the next sub.\n        return $annotations;\n\n    } else {\n        $self->throw(\"Error:  Missing </annotations> tag.  Got this: $$line\\n\\n\");\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _process_seq_feature\n\n  Title    : _process_seq_feature\n  Usage    : $self->_process_seq_feature\n  Function : Parses the data between the <seq_feature></seq_feature> tag.\n  Args     : 2 scalars:\n             - Reference to scalar holding the line to be parsed.\n             - Scalar holding the attributes for <seq_feature>.\n  Returns  : Data structure holding the values parsed.\n  Note     : Method(s) that call(s) this method: _process_annotations\n\nMethod(s) that this method calls: _helper_store_attribute_list ,\n_process_classification , _question_mark_tag , _one_tag ,\n_process_evidence , _process_qualifier , _process_seq_feature ,\n_process_related_annot\n\n\nsub _process_seq_feature {\n\n    my ($self, $line, $attribute_line) = @_;\n\n    my $seq_feature;\n    $self->_helper_store_attribute_list($attribute_line, \\$seq_feature);\n\n\n    $$line = $self->_readline;\n\n\n    # Zero or more <classification>\n    $self->_process_classification($line, \\$seq_feature);\n\n\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, \\$seq_feature, 'note');\n\n\n\n    # One <seq_location>\n    $self->_one_tag($line, \\$seq_feature, 'seq_location');\n\n\n\n    # Zero or one <xrefs>\n    $self->_question_mark_tag($line, \\$seq_feature, 'xrefs');\n\n\n\n    # Zero or one <evidence>\n    $self->_process_evidence($line, \\$seq_feature);\n\n\n\n    # Zero or more <qualifier>\n    $self->_process_qualifier($line, \\$seq_feature);\n\n\n\n    # Zero or more <seq_feature>.  A <seq_feature> tag within a <seq_feature> tag?  Oh, well.  Whatever...\n    while ($$line =~ /<seq_feature\\s?(.*?)\\s?>/) {\n        $self->_process_seq_feature($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Zero or more <related_annot>\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n        $self->_process_related_annot($line, $1);\n        $$line = $self->_readline;\n    }\n\n\n    # Match the closing tag:\n    if ($$line =~ /<\\/seq_feature>/) {\n\n        $$line = $self->_readline; # for the next sub...\n        return $seq_feature;\n\n    } else {\n\n        $self->throw(\"Error.  Missing </seq_feature> tag.  Got this: $$line\\n\");\n\n    }\n\n}\n# ==================================================================================\n\n=head2 _process_qualifier\n\n  Title    : _process_qualifier\n  Usage    : $self->_process_qualifier\n  Function : Parse the data between the <qualifier></qualifier> tags.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the <qualifer> data.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : _process_seq_feature\n             Method(s) that this method calls   : _star_tag\n\n\nsub _process_qualifier {\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $qualifier;\n    $self->_star_tag($line, \\$qualifier, 'qualifier');\n    push @{$$data_structure->{'qualifier'}},$qualifier;\n\n\n    return;\n    # No need to return the data structure since its reference was what was modified.\n\n}\n# ==================================================================================\n\n=head2 _process_classification\n\n  Title   : _process_classification\n  Usage   : $self->_process_classification\n  Function: Parse the data between the <classification></classification> tags.\n  Args    :   2 scalars:\n            - reference to a scalar holding the value of the line to be parsed.\n            - reference to a data structure to store the <qualifer> data.\n  Returns : Nothing.\n  Note    : Method(s) that call(s) this method: _process_seq_feature\n\n  Method(s) that this method calls: _helper_store_attribute_list ,\n  _question_mark_tag , _star_tag, _process_evidence\n\n\nsub _process_classification { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $classification = $$data_structure->{'classification'};\n\n    while ($$line =~ /<classification\\s?(.*?)\\s?>/) {\n\n        $self->_helper_store_attribute_list($1, \\$classification);\n\n        # Zero or one <description>\n        $self->_question_mark_tag($line, \\$classification, 'description');\n\n        # Zero or more <id_alias>\n        $self->_star_tag($line, \\$classification, 'id_alias');\n\n        # Zero or one <evidence>\n        $self->_process_evidence($line, \\$classification);\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_evidence { # NOT done.\n\n    my ($self, $line, $data_structure) = @_;\n\n    if ($$line =~ /<evidence>/) {\n\n        $$line = $self->_readline;\n\n        # One or more <element_id> OR One or more <comp_result>\n        while ($$line =~ /<(element_id|comp_result)\\s?(.*?)\\s?>/) {\n            if ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n                my $element_id;\n                $self->_plus_tag($line, \\$element_id, 'element_id');\n                push @{$$data_structure->{'element_id'}}, $element_id;\n            } elsif ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n                my $comp_result;\n                $self->_process_comp_result($line, \\$comp_result, $1);\n                push @{$$data_structure->{'comp_result'}}, $comp_result;\n            }\n            $$line = $self->_readline;\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_comp_result { # NOT IN USE.\n\n\n    my ($self, $line, $comp_result, $attribute_line) = @_;\n\n    $self->_helper_store_attribute_list($attribute_line, $comp_result);\n    $$line = $self->_readline;\n\n    # Zero or one <note>\n    $self->_question_mark_tag($line, $comp_result, 'note');\n\n    # Zero or one <match_desc>\n    $self->_question_mark_tag($line, $comp_result, 'match_desc');\n\n    # Zero or one <match_align>\n    $self->_question_mark_tag($line, $comp_result, 'match_align');\n\n    # Zero or one <query_region>\n    $self->_process_query_region($line, $comp_result);\n\n    # Zero or one <match_region>\n    $self->_process_match_region($line, $comp_result);\n\n    # Zero or more <result_property>\n    $self->_star_tag($line, $comp_result, 'result_property');\n\n    # Zero or more <result_group>\n    $self->_process_result_group($line, $comp_result);\n\n    # Zero or more <related_annot>\n    $self->_process_related_annot($line, $comp_result);\n\n}\n# ==================================================================================\n\nsub _process_related_annot { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<related_annot\\s?(.*?)\\s?>/) {\n\n        my $related_annot;\n        # Zero or one <related_annot>\n        $self->_helper_store_attribute_list($1, \\$related_annot);\n        $$line = $self->_readline;\n\n        # One or more <element_id>\n        my $element_id_count = 0;\n        while ($$line =~ /<element_id\\s?(.*?)\\s?>/) {\n            my $element_id;\n            $self->_helper_store_attribute_list($1, \\$element_id);\n            push @{$related_annot->{'element_id'}}, $element_id;\n            $$line = $self->_readline;\n            ++$element_id_count;\n        }\n\n        if ($element_id_count == 0) {\n            $self->throw(\"Error.  Missing <element_id> tag.  Got: $$line\");\n        }\n\n        # Zero or more <sci_property>\n        $self->_star_tag($line, \\$related_annot, 'sci_property');\n        # while ($$line =~ /<sci_property\\s?(.*?)\\s?>/){\n        #\n        # }\n\n        push @{$data_structure->{'related_annot'}}, $related_annot;\n\n        unless ($$line =~ /<\\/related_annot>/){\n            $self->throw(\"Error.  Missing </related_tag>. Got: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_result_group { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    while ($$line =~ /<result_group\\s?(.*?)\\s?>/) {\n        my $result_group = $$data_structure->{'result_group'};\n        $self->_helper_store_attribute_list($1, \\$result_group);\n\n        my $count = 0;\n        $$line = $self->_readline;\n        while ($$line =~ /<comp_result\\s?(.*?)\\s?>/) {\n            # one or more <comp_result>\n            $self->_process_comp_result(\\$line, \\$result_group, $1);\n            $$line = $self->_readline;\n            ++$count;\n        }\n\n        $self->throw(\"Error.  No <comp_result></comp_result> tag! Got this: $$line\")\n            if $count == 0;\n\n        # in the last iteration in the inner while loop, $line will\n        # have a value of the closing tag of 'result_group'\n        if ($line =~ /<\\/result_group>/) {\n            $$line = $self->_readline;\n        } else {\n            $self->throw(\"Error.  No </result_tag>!  Got this: $$line\");\n        }\n\n\n    }\n\n\n}\n# ==================================================================================\n\nsub _process_match_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $match_region = $data_structure->{'match_region'};\n\n    if ($$line =~ /<match_region\\s?(.*?)\\s?>(.*?)>/) {\n\n        $self->_helper_store_attribute_line($1, \\$match_region);\n        $$line = $self->_readline;\n\n        # Zero or one db_id | element_id | bio_sequence\n        if ($$line =~ /<db_id\\s?(.*?)\\s?>(.*?)<\\/db_id>/) {\n            $self->_question_mark_tag($line, \\$match_region, 'db_id');\n        } elsif ($$line =~ /<element_id\\s?(.*?)\\s?>/) { # empty...\n            $self->_question_mark_tag($line, \\$match_region, 'element_id');\n        } elsif ($$line =~ /<bio_sequence\\s?(.*?)\\s?>/) {\n            $match_region->{'bio_sequence'} = $self->_process_bio_sequence($line, $1);\n        }\n\n        $$line = $self->_readline;\n        if ($$line =~ /<\\/match_region>/o) {\n            $$line = $self->_readline; # get the next line to be _processed by the next sub\n            return;\n        } else {\n            $self->throw(\"No closing tag </match_region>!  Got this: $$line\\n\");\n        }\n\n    }\n}\n# ==================================================================================\n\nsub _process_query_region { # NOT IN USE.\n\n    my ($self, $line, $data_structure) = @_;\n\n    my $query_region = $data_structure->{'query_region'};\n    if ($$line =~ /<query_region\\s?(.*?)\\s?>/) {\n        $self->_helper_store_attribute_list($1, \\$query_region);\n        $$line = $self->_readline;\n\n        # Zero or one <db_id>\n        $self->_question_mark_tag($line, \\$query_region, 'db_id');\n\n        if ($$line =~ /<\\/query_region>/) {\n            $$line = $self->_readline; # get the next line to _process.\n            return;\n        } else {\n            $self->throw(\"No closing tag </query_region>.  Got this: $$line\\n\");\n        }\n\n    }\n\n\n}\n# ==================================================================================\n\n=head2 _tag_processing_helper\n\n  Title    : _tag_processing_helper\n  Usage    : $self->_tag_processing_helper\n  Function : Stores the tag value within the data structure.\n             Also calls _helper_store_attribute_list to store the \n             attributes and their values in the data structure.\n  Args     : 5 scalars:\n             - Scalar holding the value of the attributes\n             - Reference to a data structure to store the data for <$tag_name>\n             - Scalar holding the tag name.\n             - Scalar holding the value of the tag.\n             - Scalar holding the value of either 'star', 'plus', \n               or 'question mark' which specifies what type of method\n               called this method.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method:\n             Method(s) that this method calls: _helper_store_attribute_list\n\n\nsub _tag_processing_helper {\n\n    my ($self, $attribute_list, $data_structure, $tag_name, $tag_value, $caller) = @_;\n\n    # Add the attributes to the $$data_structure if they exist.\n    # print \"tag_name: $tag_name , attribute_list: $attribute_list\\n\";\n    if (defined $attribute_list) {\n        $self->_helper_store_attribute_list($attribute_list, $data_structure);\n    }\n\n\n    if ($caller eq 'star' || $caller eq 'plus') {\n        push @{$$data_structure->{$tag_name}}, $tag_value;\n        # There's either zero or more tags (*) or one or more (+)\n    } else {\n        $$data_structure->{$tag_name} = $tag_value || 'null';\n        # There's zero or one tag (?)\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _one_tag\n\n  Title    : _one_tag\n  Usage    : $self->_one_tag\n  Function : A method to store data from tags that occurs just once.\n  Args     : 2 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _one_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\")\n        if $$line !~ /\\<$tag_name/; \n    # check to see if $$line is in correct format.\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>(.*?)<\\/$tag_name>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'one');\n        # $1 = attributes $data_structure = to hold the parsed values\n        # # $tag_name = name of the tag $2 = tag value 'one' = lets\n        # _tag_processing_helper know that it was called from the\n        # _one_tag method.\n\n    } elsif ($$line =~ /<$tag_name\\s?(.*?)\\s?\\/?>/) {\n\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, '', 'one');\n\n    } else {\n        $self->throw(\"Error:  Cannot parse this line: $$line\\n\\n\");\n    }\n\n    $$line = $self->_readline;  # get the next line.\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _question_mark_tag\n\n  Title    : _question_mark_tag\n  Usage    : $self->_question_mark_tag\n  Function : Parses values from tags that occurs zero or one time. ie: tag_name?\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\n\nsub _question_mark_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'question mark');\n        $$line = $self->_readline;\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _star_tag\n\n  Title    : _star_tag\n  Usage    : $self->_star_tag\n  Function : Parses values from tags that occur zero or more times. ie: tag_name*\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _tag_processing_helper\n\n\nsub _star_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    #print \"tag_name: $tag_name\\n\";\n    while ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n        $self->_tag_processing_helper\n            ($1, $data_structure, $tag_name, $2, 'star');\n        # The tag and attribute values are stored within\n        # $$data_structure within the _tag_processing_helper method.\n        $$line = $self->_readline;\n    }\n    #if ($tag_name eq 'qualifier'){\n    #       print \"this one:\\n\";\n    #       print Data::Dumper->Dump([$data_structure]); exit;\n    #}\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _plus_tag\n\n  Title    : _plus_tag\n  Usage    : $self->_plus_tag\n  Function : Handles 'plus' tags (tags that occur one or more times).  tag_name+\n  Args     : 3 scalars:\n             - reference to a scalar holding the value of the line to be parsed.\n             - reference to a data structure to store the data for <$tag_name>\n             - scalar holding the name of the tag.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : many.\n             Method(s) that this method calls   : _star_tag\n\n\nsub _plus_tag {\n\n    my ($self, $line, $data_structure, $tag_name) = @_;\n\n    if ($$line =~ /<$tag_name\\s?(.*?)\\s?>(.*?)<\\/$tag_name>/) {\n\n        # Store value of the first occurence of $tag_name.\n        # All subsequent values, if any, will be stored in the method _star_tag.\n        $self->_tag_processing_helper($1, $data_structure, $tag_name, $2, 'plus');\n\n\n        # If the flow gets within this block, we've already determined\n        # that there's at least one of <$tag_name> Are there more?  To\n        # answer this, we could just treat the tag as a * tag now\n        # (zero or more).  We've already determined that it's NOT\n        # zero, so how many more?  Thus, call _star_tag.\n        $$line = $self->_readline;\n        $self->_star_tag($line, $data_structure, $tag_name);\n\n\n    } else {\n        $self->throw(\"Error:  Missing <$tag_name></$tag_name>.  Got: $$line\\n\\n\");\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _helper_store_attribute_list\n\n  Title    : _helper_store_attribute_list\n  Usage    : $self->_helper_store_attribute_list\n  Function : A helper method used to store the attributes from\n             the tags into the data structure.\n  Args     : 2 scalars:\n             - scalar holding the attribute values to be parsed.\n             - reference to a data structure to store the data between the 2 tags.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : Many.\n             Method(s) that this method call(s) : None.\n\n\nsub _helper_store_attribute_list {\n\n    my ($self, $attribute_line, $data_structure) = @_;\n\n    my %attribs = ($attribute_line =~ /(\\w+)\\s*=\\s*\"([^\"]*)\"/g);\n\n    my $attribute_list;\n    for my $key (keys %attribs) {\n        # print \"\\tkey: $key , value: $attribs{$key}\\n\";\n        ###$$data_structure->{$key} = $attribs{$key};           # <- The ORIGINAL.\n        push @{$$data_structure->{$key}}, $attribs{$key};\n        # Now, store them in an array because there may be > 1 tag, thus\n        # > 1 attribute of the same name.\n        # Doing this has made it necessary to change the _store_seqs method.\n        # ie: Change $bio_sequence->{'molecule_type'};\n        # to\n        # $bio_sequence->{'molecule_type'}->[0];\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _store_seqs\n\n  Title    : _store_seqs\n  Usage    : $self->_store_seqs\n  Function : This method is called once in the life time of the script.\n             It stores the data parsed from the agave xml file into\n             the Bio::Seq object.\n  Args     : None.\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method : next_seq\n             Method(s) that this method calls   : None.\n\n\nsub _store_seqs {\n\n    my ($self) = @_;\n\n\n    for my $sciobj (@{$self->{'sciobj'}}) {\n\n        ### $sciobj = $self->{'sciobj'};                # The root node.\n\n\n        for my $contig (@{$sciobj->{'contig'}}) { # Each contig has a fragment order.\n\n            for my $fragment_order (@{$contig->{'fragment_order'}}) { # Each fragment order has a fragment_orientation.\n\n                for my $fragment_orientation (@{$fragment_order->{'fragment_orientation'}}) {\n                    # Each fragment_orientation contain 1 bio sequence.\n\n                    my $bio_sequence = $fragment_orientation->{'bio_sequence'}; # <bio_sequence> contains all the\n                    # interesting stuff:\n\n                    my $sequence         = $bio_sequence->{'sequence'};\n                    my $accession_number = $bio_sequence->{'sequence_id'}->[0]; # also use for primary_id\n                    my $organism         = $bio_sequence->{'organism'};\n                    my $description      = $bio_sequence->{'description'};\n                    my $molecule_type    = $bio_sequence->{'molecule_type'}->[0];\n\n                    my $primary_seq = Bio::PrimarySeq->new(\n                                                           -id       => $accession_number,\n                                                           -alphabet => $molecule_type,\n                                                           -seq      => $sequence,\n                                                           -desc     => $description,\n                                                          );\n\n                    my $seq = Bio::Seq->new (\n                                             -display_id       => $accession_number,\n                                             -accession_number => $accession_number,\n                                             -primary_seq      => $primary_seq,\n                                             -seq              => $sequence,\n                                             -description      => $description,\n                                            );\n\n                    my $organism_name = $bio_sequence->{organism_name}->[0];\n                    if (defined $organism_name) {\n\n                        my @classification = split(' ', $organism_name);\n                        my $species = Bio::Species->new();\n                        $species->classification(@classification);\n                        $seq->species($species);\n                    }\n                    # Pull out the keywords: $keywords is an array ref.\n\n                    my $keywords = $bio_sequence->{keyword};\n                    my %key_to_value;\n\n                    for my $keywords (@$keywords) {\n                        # print \"keywords: $keywords\\n\";\n                        my @words = split(':', $keywords);\n                        for (my $i = 0; $i < scalar @words - 1; $i++) {\n                            if ($i % 2 == 0) {\n                                my $j = $i; $j++;\n                                # print \"$words[$i] , $words[$j]\\n\";\n                                $key_to_value{$words[$i]} = $words[$j];\n                            }\n                        }\n                        # print Data::Dumper->Dump([%key_to_value]);\n                        my $reference = Bio::Annotation::Reference->\n                            new(-authors => $key_to_value{authors},\n                                -title => $key_to_value{title},\n                                -database => $key_to_value{database},\n                                -pubmed => $key_to_value{pubmed},\n                               );\n                        $seq->annotation->add_Annotation('reference', $reference);\n\n                    }           # close for my $keywords\n\n\n                    #  print Data::Dumper->Dump([$bio_sequence]); print \"here\\n\"; exit;\n                    if (defined $bio_sequence->{'sequence_map'}) {\n\n                        for my $sequence_map (@{$bio_sequence->{'sequence_map'}}) {\n\n                            # print Data::Dumper->Dump([$sequence_map]); print \"here\\n\"; exit;\n\n                            my $label = $sequence_map->{label};\n\n                            if (defined $sequence_map->{annotations} &&\n                                ref($sequence_map->{annotations}) eq 'HASH') {\n\n                                # Get the sequence features (ie genes, exons, etc) from this $sequence_map\n                                for my $seq_feature (@{$sequence_map->{'annotations'}->{'seq_feature'}}) {\n\n                                    # print Data::Dumper->Dump([$seq_feature]); exit;\n                                    my $seq_location     = $seq_feature->{'seq_location'};\n                                    my $start_coord      = $seq_feature->{'least_start'}->[0];\n                                    my $feature_type     = $seq_feature->{'feature_type'}->[0];\n                                    my $end_coord        = $seq_feature->{'greatest_end'}->[0];\n                                    my $is_on_complement = $seq_feature->{'is_on_complement'}->[0];\n\n                                    # Specify the coordinates and the tag for this seq feature.\n                                    # print \"Primary Tag for this SeqFeature: $feature_type\\n\";\n                                    my $feat = Bio::SeqFeature::Generic->\n                                        new(\n                                            -start       => $start_coord,\n                                            -end         => $end_coord,\n                                            -primary_tag => $feature_type,\n                                           );\n\n\n                                    if (defined $seq_feature->{'qualifier'} &&\n                                        ref($seq_feature->{'qualifier'}) eq 'ARRAY') {\n\n                                        for my $feature (@{$seq_feature->{'qualifier'}}) {\n\n                                            my $value = $feature->{'qualifier'};\n                                            my $feature_type = $feature->{'qualifier_type'};\n\n                                            for (my $i = 0;\n                                                 $i < scalar @{$value};\n                                                 $i++) {\n                                                $feat->add_tag_value(\n                                                                     $feature_type->[$i] => $value->[$i]\n                                                                    );\n                                            } # close the for loop\n\n                                        }\n\n                                    } # close if (defined $seq_feature->...\n\n\n                                    $seq->add_SeqFeature($feat);\n\n\n                                } # close for my $seq_feature (@{$sequence_map->...\n\n\n                            }   # close if (defined $sequence_map->{annotations} &&\n\n\n                        }       # close for my $sequence_map (@{$bio_sequence->{'sequence_map'}}){\n\n                    }           # close if (defined $bio_sequence->{'sequence_map'}){\n\n\n                    # This is where the Bio::Seq objects are stored:\n                    push @{$self->{'sequence_objects'}}, $seq;\n\n\n                }               # close for my $fragment_orientation\n\n\n            }                   # close for my $fragment_order\n\n\n        }                       # close for my $contig\n\n\n    }                           # close for my $sciobj\n\n    # Flag is set so that we know that the sequence objects are now stored in $self.\n    $self->{'seqs_stored'} = 1;\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 next_seq\n\n        Title    : next_seq\n        Usage    : $seq = $stream->next_seq()\n        Function : Returns the next sequence in the stream.\n        Args     : None.\n        Returns  : Bio::Seq object\n\nMethod is called from the script.  Method(s) that this method calls:\n_store_seqs (only once throughout the life time of script execution).\n\n\n\nsub next_seq {\n\n    my ($self) = @_;\n\n    # convert agave to genbank/fasta/embl whatever.\n\n    $self->_store_seqs if $self->{'seqs_stored'} == 0;\n\n    $self->throw(\"Error: No Bio::Seq objects stored yet!\\n\\n\")\n        if !defined $self->{'sequence_objects'}; # This should never occur...\n\n    if (scalar @{$self->{'sequence_objects'}} > 0) {\n        return shift @{$self->{'sequence_objects'}};\n    } else {\n        # All done.  Nothing more to parse.\n        # print \"returning nothing!\\n\";\n        return 0;\n    }\n\n\n}\n# ==================================================================================\n\n=head2 next_primary_seq\n\n  Title   : next_primary_seq\n  Usage   : $seq = $stream->next_primary_seq()\n  Function: returns the next primary sequence (ie no seq_features) in the stream\n  Returns : Bio::PrimarySeq object\n  Args    : NONE\n\n\nsub next_primary_seq {\n    my $self=shift;\n    return 0;\n}\n# ==================================================================================\n\n=head2 write_seq\n\n  Title   : write_seq\n  Usage   : Not Yet Implemented! $stream->write_seq(@seq)\n  Function: writes the $seq object into the stream\n  Returns : 1 for success and 0 for error\n  Args    : Bio::Seq object\n\n\nsub write_seq {\n\n    # Convert the Bio::Seq object(s) to AGAVE xml file.\n\n    my ($self,@seqs) = @_;\n\n    foreach my $seq ( @seqs ) {\n        $self->_write_each_record( $seq ); # where most of the work actually takes place.\n    }\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _write_each_record\n\n  Title   : _write_each_record\n  Usage   : $agave->_write_each_record( $seqI )\n  Function: change data into agave format\n  Returns : NONE\n  Args    : Bio::SeqI object\n\n\nsub  _write_each_record {\n    my ($self,$seq) = @_;\n\n    # $self->{'file'} =~ s/>//g;\n    my $output = new IO::File(\">\" . $self->{'file'});\n    my $writer = new XML::Writer(OUTPUT => $output,\n                                 NAMESPACES => 0,\n                                 DATA_MODE => 1,\n                                 DATA_INDENT => 2 ) ;\n\n    $writer->xmlDecl(\"UTF-8\");\n    $writer->doctype(\"sciobj\", '', \"sciobj.dtd\");\n    $writer ->startTag('sciobj',\n                       'version', '2',\n                       'release', '2');\n\n    $writer->startTag('contig', 'length', $seq->length);\n    my $annotation = $seq ->annotation;\n    # print \"annotation: $annotation\\n\"; exit;  Bio::Annotation::Collection=HASH(0x8112e6c)\n    if ( $annotation->get_Annotations('dblink') ) {\n        # used to be $annotation->each_DBLink, but Bio::Annotation::Collection::each_DBLink\n        # is now replaced with get_Annotations('dblink')\n        my $dblink = $annotation->get_Annotations('dblink')->[0] ;\n\n        $writer ->startTag('db_id',\n                           'id', $dblink->primary_id ,\n                           'db_code', $dblink->database );\n    } else {\n        $writer ->startTag('db_id',\n                           'id', $seq->display_id ,\n                           'db_code', 'default' );\n    }\n    $writer ->endTag('db_id') ;\n\n\n    $writer->startTag('fragment_order');\n    $writer->startTag('fragment_orientation');\n\n    ##start bio_sequence\n    ####my $organism = $seq->species->genus . \" \" . $seq->species->species;\n    $writer ->startTag('bio_sequence',\n                       'sequence_id', $seq->display_id,\n                       'seq_length', $seq->length,\n                       # 'molecule_type', $seq->moltype, # deprecated\n                       'molecule_type', $self->alphabet,\n                       #'organism_name', $organism\n                      );\n\n    # my $desc = $seq->{primary_seq}->{desc};\n    # print \"desc: $desc\\n\"; exit;\n    # print Data::Dumper->Dump([$seq]);  exit;\n    ##start db_id under bio_sequence\n    $annotation = $seq ->annotation;\n    # print \"annotation: $annotation\\n\"; exit;  Bio::Annotation::Collection=HASH(0x8112e6c)\n    if ( $annotation->get_Annotations('dblink') ) {\n        # used to be $annotation->each_DBLink, but Bio::Annotation::Collection::each_DBLink\n        # is now replaced with get_Annotations('dblink')\n        my $dblink = $annotation->get_Annotations('dblink')->[0] ;\n\n        $writer ->startTag('db_id',\n                           'id', $dblink->primary_id ,\n                           'db_code', $dblink->database );\n    } else {\n        $writer ->startTag('db_id',\n                           'id', $seq->display_id ,\n                           'db_code', 'default' );\n    }\n    $writer ->endTag('db_id') ;\n\n    ##start note\n    my $note = \"\" ;\n    foreach my $comment ( $annotation->get_Annotations('comment') ) {\n        # used to be $annotations->each_Comment(), but that's now been replaced\n        # with get_Annotations()\n        # $comment is a Bio::Annotation::Comment object\n        $note .= $comment->text() . \"\\n\";\n    }\n\n    $writer ->startTag('note');\n    $writer ->characters( $note ) ;\n    $writer ->endTag('note');\n\n    ##start description\n    $writer ->startTag('description');\n\n    # $writer ->characters( $annotation->get_Annotations('description') ) ;\n    # used to be $annotations->each_description(), but that's now been\n    # replaced with get_Annotations.\n    # Simon added this: this is the primary_seq's desc (the DEFINITION tag in a genbank file)\n    $writer->characters($seq->{primary_seq}->{desc});\n    $writer ->endTag('description');\n\n    ##start keywords\n    foreach my $genename ( $annotation->get_Annotations('gene_name') ) {\n        # used to be $annotations->each_gene_name, but that's now been\n        # replaced with get_Annotations()\n        $writer ->startTag('keyword');\n        $writer ->characters( $genename ) ;\n        $writer ->endTag('keyword');\n    }\n\n\n    foreach my $ref ( $annotation->get_Annotations('reference') ) {\n        # used to be $annotation->each_Reference, but\n        # that's now been replaced with get_Annotations('reference');\n        # link is a Bio::Annotation::Reference object\n        $writer ->startTag('keyword');\n        # print Data::Dumper->Dump([$ref]); exit;\n        my $medline  = $ref->medline || 'null';\n        my $pubmed   = $ref->pubmed || 'null';\n        my $database = $ref->database || 'null';\n        my $authors  = $ref->authors || 'null';\n        my $title    = $ref->title || 'null';\n\n\n        $writer ->characters( 'medline:' . \"$medline\" . ':' . 'pubmed:' .\n                              \"$pubmed\" . ':' . 'database:' . \"$database\" .\n                              ':' .'authors:' . \"$authors\" . ':' . 'title:' . \"$title\" ) ;\n        $writer ->endTag('keyword');\n    }\n\n    ## start sequence\n    $writer ->startTag('sequence');\n    $writer ->characters( $seq->seq ) ;\n    $writer ->endTag('sequence');\n\n    ## start xrefs\n    $writer ->startTag('xrefs');\n    foreach my $link ( $annotation->get_Annotations('dblink') ) {\n        # link is a Bio::Annotation::DBLink object\n        $writer ->startTag('db_id',\n                           'db_code', $link->database,\n                           'id', $link->primary_id);\n        $writer ->characters( $link->comment ) ;\n        $writer ->endTag('db_id');\n    }\n    $writer ->endTag('xrefs') ;\n\n    ##start sequence map\n    ##we can not use :  my @feats = $seq->all_SeqFeatures;\n    ##rather, we use top_SeqFeatures() to keep the tree structure\n    my @feats = $seq->top_SeqFeatures ;\n\n    my $features;\n\n    ##now we need cluster top level seqfeature by algorithm\n    my $maps;\n    foreach my $feature (@feats) {\n        my $map_type = $feature ->source_tag;\n        push (@{$maps->{ $map_type }}, $feature);\n    }\n\n    ##now we enter each sequence_map\n    foreach my $map_type (keys  %$maps ) {\n        $writer->startTag('sequence_map',\n                          'label', $map_type );\n        $writer->startTag('annotations');\n        # the original author accidently entered 'annotation' instead of 'annotations'\n\n        foreach my $feature ( @{$maps->{ $map_type }} ) {\n            $self->_write_seqfeature( $feature, $writer ) ;\n        }\n\n        $writer->endTag('annotations');\n        $writer->endTag('sequence_map');\n    }\n\n    $writer->endTag('bio_sequence');\n    $writer->endTag('fragment_orientation');\n    $writer->endTag('fragment_order');\n    $writer->endTag('contig');\n    $writer->endTag('sciobj');\n\n}\n# ==================================================================================\n\n=head2 _write_seqfeature\n\n  Usage   : $agave->_write_each_record( $seqfeature, $write )\n  Function: change seeqfeature data into agave format\n  Returns : NONE\n  Args    : Bio::SeqFeature object and XML::writer object\n\n\nsub _write_seqfeature{\n\n    my ($self,$seqf, $writer) = @_;\n\n    ##now enter seq feature\n    $writer ->startTag('seq_feature',\n                       'feature_type', $seqf->primary_tag() );\n\n    my $strand = $seqf->strand();\n    $strand = 0 if !defined $strand;\n    # $strand == 1 ? 'false' : 'true';\n    my $is_on_complement;\n    if ($strand == 1) {\n        $is_on_complement = 'true';\n    } else {\n        $is_on_complement = 'false';\n    }\n\n    # die Data::Dumper->Dump([$seqf]) if !defined $strand;\n    $writer ->startTag('seq_location',\n                       'lease_start', $seqf->start(),\n                       'greatest_end', $seqf->end(),\n                       # 'is_on_complement', $seqf->strand() == 1 ? 'false' : 'true') ;\n                       'is_on_complement' , $is_on_complement);\n    # is_on_complement: is the feature found on the complementary\n    # strand (true) or not (false)?\n    $writer ->endTag('seq_location');\n\n    ##enter qualifier\n    foreach my $tag ( $seqf->all_tags() ) {\n        $writer ->startTag('qualifier',\n                           'qualifier_type', $tag);\n        $writer ->characters( $seqf->each_tag_value($tag) ) ;\n        $writer ->endTag('qualifier');\n    }\n\n    ##now recursively travel the seqFeature\n    foreach my $subfeat ( $seqf->sub_SeqFeature ) {\n        $self->_write_seqfeature( $subfeat, $writer ) ;\n    }\n\n    $writer->endTag('seq_feature');\n\n    return;\n\n}\n# ==================================================================================\n\n=head2 _filehandle\n\n  Title   : _filehandle\n  Usage   : $obj->_filehandle($newval)\n  Function:\n  Example :\n  Returns : value of _filehandle\n  Args    : newvalue (optional)\n\n\nsub _filehandle{\n\n    my ($obj,$value) = @_;\n    if ( defined $value) {\n        $obj->{'_filehandle'} = $value;\n    }\n    return $obj->{'_filehandle'};\n\n}\n# ==================================================================================\n\n=head2 throw\n\n  Title    : throw\n  Usage    : $self->throw;\n  Function : Throw's error message.  Calls SeqIO's throw method.\n  Args     : Array of string(s), holding error message(s).\n  Returns  : Nothing.\n  Note     : Method(s) that call(s) this method: many.\n             Method(s) that this method calls: Bio::SeqIO's throw method.","parameters":[{"label":"$self"},{"label":"@s"}]},"line":1782,"kind":12,"range":{"end":{"line":1789,"character":9999},"start":{"character":0,"line":1782}}},{"kind":12,"containerName":"throw","name":"SUPER","line":1786}],"version":5}