{"vars":[{"kind":2,"containerName":"","name":"base","line":81},{"range":{"end":{"line":103,"character":9999},"start":{"character":0,"line":94}},"kind":12,"line":94,"signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: DNAAlphabet.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Symbol::DNAAlphabet\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Symbol::DNAAlphabet - A ready made DNA alphabet\n\n=head1 SYNOPSIS\n\n    use Bio::Symbol::DNAAlphabet;\n    my $alpha = Bio::Symbol::DNAAlphabet->new();\n    foreach my $symbol ( $alpha->symbols ) {\n\tprint \"symbol is $symbol\\n\";\n    }\n\n=head1 DESCRIPTION\n\nThis object builds an Alphabet with DNA symbols.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Symbol::DNAAlphabet;\nuse strict;\n\nuse Bio::Symbol::Symbol;\nuse Bio::Tools::IUPAC;\n\nuse base qw(Bio::Symbol::Alphabet);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Symbol::DNAAlphabet->new();\n Function: Builds a new Bio::Symbol::DNAAlphabet object \n Returns : Bio::Symbol::DNAAlphabet\n Args    :","label":"new($class,@args)"},"name":"new","containerName":"main::","children":[{"line":95,"localvar":"my","kind":13,"containerName":"new","name":"$class","definition":"my"},{"line":95,"containerName":"new","kind":13,"name":"@args"},{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"new","line":96},{"line":96,"containerName":"new","kind":13,"name":"$class"},{"line":96,"kind":13,"containerName":"new","name":"@args"},{"line":97,"kind":13,"localvar":"my","containerName":"new","name":"%alphabet","definition":"my"},{"definition":"my","line":98,"containerName":"new","localvar":"my","kind":13,"name":"%symbols"},{"definition":"my","name":"$let","localvar":"my","containerName":"new","kind":13,"line":99},{"line":99,"name":"%alphabet","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$alphabet","line":100},{"line":100,"name":"$let","containerName":"new","kind":13},{"line":100,"name":"$let","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$symbols","line":101},{"line":101,"kind":13,"containerName":"new","name":"$let"},{"name":"new","containerName":"new","kind":12,"line":101},{"line":101,"kind":13,"containerName":"new","name":"$let"},{"kind":13,"containerName":"new","name":"$let","line":102}],"detail":"($class,@args)","definition":"sub"},{"line":96,"kind":12,"containerName":"new","name":"SUPER"},{"containerName":"Tools::IUPAC::iupac_iub","kind":12,"name":"Bio","line":97},{"kind":12,"containerName":"Symbol::Symbol","name":"Bio","line":101},{"line":105,"name":"$let","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"line":105,"name":"%alphabet","kind":13,"containerName":null},{"name":"%symbols","containerName":null,"kind":13,"line":106},{"line":106,"containerName":null,"kind":13,"name":"$let"},{"line":106,"containerName":null,"kind":13,"name":"$let"},{"definition":"my","name":"@subsymbols","localvar":"my","containerName":null,"kind":13,"line":107},{"name":"$sublet","kind":13,"localvar":"my","containerName":null,"line":109,"definition":"my"},{"name":"%alphabet","kind":13,"containerName":null,"line":109},{"line":109,"kind":13,"containerName":null,"name":"%let"},{"line":110,"name":"@subsymbols","kind":13,"containerName":null},{"line":110,"containerName":null,"kind":13,"name":"%symbols"},{"line":110,"name":"$sublet","containerName":null,"kind":13},{"line":112,"name":"$alpha","localvar":"my","containerName":null,"kind":13,"definition":"my"},{"kind":12,"containerName":"Symbol::Alphabet","name":"Bio","line":112},{"line":112,"containerName":"main::","kind":12,"name":"new"},{"line":112,"name":"@subsymbols","kind":13,"containerName":null},{"kind":13,"containerName":null,"name":"%symbols","line":113},{"line":113,"containerName":null,"kind":13,"name":"$let"},{"containerName":"Symbol::Symbol","kind":12,"name":"Bio","line":113},{"line":113,"name":"new","containerName":"main::","kind":12},{"line":113,"kind":13,"containerName":null,"name":"$let"},{"line":114,"name":"$let","kind":13,"containerName":null},{"name":"$alpha","kind":13,"containerName":null,"line":115},{"containerName":null,"kind":13,"name":"@subsymbols","line":116},{"name":"$self","containerName":null,"kind":13,"line":119},{"name":"symbols","kind":12,"containerName":"main::","line":119},{"line":119,"name":"%symbols","kind":13,"containerName":null},{"name":"$self","kind":13,"containerName":null,"line":120}],"version":5}