{"vars":[{"line":96,"name":"base","kind":2,"containerName":""},{"line":127,"range":{"end":{"line":141,"character":9999},"start":{"line":127,"character":0}},"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: EPCR.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EPCR\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EPCR - Parse ePCR output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for ePCR data\n    # assuming ePCR data is already generated in file seq1.epcr\n    # and sequence data is in fasta format in file called seq1.fa\n\n    use Bio::Tools::EPCR;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::EPCR->new(-file => 'seq1.epcr');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add EPCR annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for ePCR data, creating a\nBio::SeqFeatureI for each ePCR hit.  These can be processed or added\nas annotation to an existing Bio::SeqI object for the purposes of\nautomated annotation.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::EPCR;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $epcr = Bio::Tools::EPCR->new(-file => $file,\n\t\t\t\t\t   -primary => $fprimary, \n\t\t\t\t\t   -source => $fsource, \n\t\t\t\t\t   -groupclass => $fgroupclass);\n Function: Initializes a new EPCR parser\n Returns : Bio::Tools::EPCR\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       'sts'.  (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'e-PCR'. (This in turn maps to the GFF 'source'\n                       tag)\n\n             -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'."},"children":[{"localvar":"my","containerName":"new","kind":13,"name":"$class","line":128,"definition":"my"},{"line":128,"containerName":"new","kind":13,"name":"@args"},{"line":130,"localvar":"my","kind":13,"containerName":"new","name":"$self","definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":130},{"line":130,"kind":13,"containerName":"new","name":"@args"},{"line":131,"localvar":"my","containerName":"new","kind":13,"name":"$primary","definition":"my"},{"kind":13,"containerName":"new","name":"$source","line":131},{"kind":13,"containerName":"new","name":"$groupclass","line":132},{"line":132,"containerName":"new","kind":13,"name":"$self"},{"containerName":"new","kind":12,"name":"_rearrange","line":132},{"name":"@args","kind":13,"containerName":"new","line":134},{"line":135,"name":"$self","kind":13,"containerName":"new"},{"name":"primary","containerName":"new","kind":12,"line":135},{"name":"$primary","kind":13,"containerName":"new","line":135},{"line":135,"name":"$primary","kind":13,"containerName":"new"},{"line":136,"name":"$self","containerName":"new","kind":13},{"line":136,"kind":12,"containerName":"new","name":"source"},{"line":136,"name":"$source","containerName":"new","kind":13},{"line":136,"containerName":"new","kind":13,"name":"$source"},{"line":137,"name":"$self","kind":13,"containerName":"new"},{"line":137,"name":"groupclass","containerName":"new","kind":12},{"name":"$groupclass","kind":13,"containerName":"new","line":137},{"line":137,"name":"$groupclass","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"$self","line":139},{"name":"_initialize_io","containerName":"new","kind":12,"line":139},{"name":"@args","containerName":"new","kind":13,"line":139},{"line":140,"name":"$self","kind":13,"containerName":"new"}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"name":"SUPER","kind":12,"containerName":"new","line":130},{"detail":"($self)","definition":"sub","name":"next_feature","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"next_feature","name":"$self","line":157,"definition":"my"},{"definition":"my","line":158,"kind":13,"localvar":"my","containerName":"next_feature","name":"$line"},{"name":"$self","kind":13,"containerName":"next_feature","line":158},{"name":"_readline","kind":12,"containerName":"next_feature","line":158},{"kind":13,"containerName":"next_feature","name":"$line","line":159},{"line":160,"containerName":"next_feature","kind":13,"name":"$line"},{"localvar":"my","kind":13,"containerName":"next_feature","name":"$seqname","line":161,"definition":"my"},{"line":161,"containerName":"next_feature","kind":13,"name":"$location"},{"name":"$mkrname","containerName":"next_feature","kind":13,"line":161},{"name":"$rest","kind":13,"containerName":"next_feature","line":161},{"line":161,"name":"$line","kind":13,"containerName":"next_feature"},{"name":"$start","kind":13,"localvar":"my","containerName":"next_feature","line":163,"definition":"my"},{"name":"$end","containerName":"next_feature","kind":13,"line":163},{"name":"$location","containerName":"next_feature","kind":13,"line":163},{"definition":"my","line":166,"containerName":"next_feature","localvar":"my","kind":13,"name":"$strandsign"},{"kind":13,"containerName":"next_feature","name":"$rest","line":167},{"line":168,"name":"$strandsign","kind":13,"containerName":"next_feature"},{"name":"$rest","containerName":"next_feature","kind":13,"line":168},{"name":"$strandsign","containerName":"next_feature","kind":13,"line":170},{"name":"$strand","containerName":"next_feature","localvar":"my","kind":13,"line":172,"definition":"my"},{"line":172,"kind":13,"containerName":"next_feature","name":"$strandsign"},{"kind":13,"containerName":"next_feature","name":"$strandsign","line":172},{"line":174,"localvar":"my","kind":13,"containerName":"next_feature","name":"$markerfeature","definition":"my"},{"containerName":"next_feature","kind":12,"name":"new","line":174},{"name":"$start","kind":13,"containerName":"next_feature","line":175},{"line":176,"name":"$end","kind":13,"containerName":"next_feature"},{"line":177,"containerName":"next_feature","kind":13,"name":"$strand"},{"line":178,"name":"$self","kind":13,"containerName":"next_feature"},{"name":"source","kind":12,"containerName":"next_feature","line":178},{"kind":13,"containerName":"next_feature","name":"$self","line":179},{"containerName":"next_feature","kind":12,"name":"primary","line":179},{"kind":13,"containerName":"next_feature","name":"$seqname","line":180},{"kind":13,"containerName":"next_feature","name":"$self","line":182},{"line":182,"name":"groupclass","kind":12,"containerName":"next_feature"},{"containerName":"next_feature","kind":13,"name":"$mkrname","line":182},{"line":183,"name":"$rest","containerName":"next_feature","kind":13},{"line":183,"name":"$rest","kind":13,"containerName":"next_feature"},{"line":186,"kind":13,"containerName":"next_feature","name":"$markerfeature"}],"signature":{"label":"next_feature($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: EPCR.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EPCR\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::EPCR - Parse ePCR output and make features\n\n=head1 SYNOPSIS\n\n    # A simple annotation pipeline wrapper for ePCR data\n    # assuming ePCR data is already generated in file seq1.epcr\n    # and sequence data is in fasta format in file called seq1.fa\n\n    use Bio::Tools::EPCR;\n    use Bio::SeqIO;\n    my $parser = Bio::Tools::EPCR->new(-file => 'seq1.epcr');\n    my $seqio = Bio::SeqIO->new(-format => 'fasta', -file => 'seq1.fa');\n    my $seq = $seqio->next_seq || die(\"cannot get a seq object from SeqIO\");\n\n    while( my $feat = $parser->next_feature ) {\n\t# add EPCR annotation to a sequence\n\t$seq->add_SeqFeature($feat);\n    }\n    my $seqout = Bio::SeqIO->new(-format => 'embl');\n    $seqout->write_seq($seq);\n\n\n=head1 DESCRIPTION\n\nThis object serves as a parser for ePCR data, creating a\nBio::SeqFeatureI for each ePCR hit.  These can be processed or added\nas annotation to an existing Bio::SeqI object for the purposes of\nautomated annotation.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::EPCR;\nuse strict;\n\nuse Bio::SeqFeature::FeaturePair;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $epcr = Bio::Tools::EPCR->new(-file => $file,\n\t\t\t\t\t   -primary => $fprimary, \n\t\t\t\t\t   -source => $fsource, \n\t\t\t\t\t   -groupclass => $fgroupclass);\n Function: Initializes a new EPCR parser\n Returns : Bio::Tools::EPCR\n Args    : -fh   => filehandle\n           OR\n           -file => filename\n\n           -primary => a string to be used as the common value for\n                       each features '-primary' tag.  Defaults to\n                       'sts'.  (This in turn maps to the GFF 'type'\n                       tag (aka 'method')).\n\n            -source => a string to be used as the common value for\n                       each features '-source' tag.  Defaults to\n                       'e-PCR'. (This in turn maps to the GFF 'source'\n                       tag)\n\n             -groupclass => a string to be used as the name of the tag\n                           which will hold the sts marker namefirst\n                           attribute.  Defaults to 'name'.\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($primary, $source, \n      $groupclass) = $self->_rearrange([qw(PRIMARY\n\t\t\t\t\t   SOURCE \n\t\t\t\t\t   GROUPCLASS)],@args);\n  $self->primary(defined $primary ? $primary : 'sts');\n  $self->source(defined $source ? $source : 'e-PCR');\n  $self->groupclass(defined $groupclass ? $groupclass : 'name');\n\n  $self->_initialize_io(@args);\n  return $self;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $obj->next_feature();\n Function: Returns the next feature available in the analysis result, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    "},"kind":12,"range":{"start":{"character":0,"line":156},"end":{"character":9999,"line":187}},"line":156},{"line":174,"kind":12,"containerName":"SeqFeature::Generic","name":"Bio"},{"definition":"sub","containerName":"main::","name":"source","children":[{"definition":"my","line":202,"name":"$self","localvar":"my","kind":13,"containerName":"source"},{"name":"$self","containerName":"source","kind":13,"line":203},{"containerName":"source","kind":13,"name":"$self","line":204}],"kind":12,"range":{"end":{"character":9999,"line":205},"start":{"line":201,"character":0}},"line":201},{"kind":12,"range":{"start":{"character":0,"line":219},"end":{"line":223,"character":9999}},"line":219,"definition":"sub","name":"primary","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"primary","kind":13,"name":"$self","line":220},{"line":221,"kind":13,"containerName":"primary","name":"$self"},{"line":222,"name":"$self","containerName":"primary","kind":13}]},{"line":237,"range":{"end":{"line":242,"character":9999},"start":{"character":0,"line":237}},"kind":12,"children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"groupclass","line":238},{"line":240,"name":"$self","kind":13,"containerName":"groupclass"},{"line":241,"kind":13,"containerName":"groupclass","name":"$self"}],"containerName":"main::","name":"groupclass","definition":"sub"}],"version":5}