{"vars":[{"name":"base","kind":2,"containerName":"","line":97},{"definition":"sub","detail":"($self,@args)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_initialize_state","line":100},{"line":100,"kind":13,"containerName":"_initialize_state","name":"@args"},{"name":"$make","localvar":"my","containerName":"_initialize_state","kind":13,"line":103,"definition":"my"},{"name":"$self","kind":13,"containerName":"_initialize_state","line":103},{"kind":13,"containerName":"_initialize_state","name":"@args","line":103},{"line":105,"containerName":"_initialize_state","kind":13,"name":"$self"},{"line":105,"kind":12,"containerName":"_initialize_state","name":"analysis_method"},{"line":106,"kind":13,"containerName":"_initialize_state","name":"$self"},{"name":"analysis_method","containerName":"_initialize_state","kind":12,"line":106}],"name":"_initialize_state","containerName":"main::","signature":{"label":"_initialize_state($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":""},"line":99,"kind":12,"range":{"end":{"line":108,"character":9999},"start":{"line":99,"character":0}}},{"line":103,"name":"SUPER","kind":12,"containerName":"_initialize_state"},{"detail":"($self,$method)","definition":"sub","containerName":"main::","name":"analysis_method","children":[{"localvar":"my","kind":13,"containerName":"analysis_method","name":"$self","line":123,"definition":"my"},{"name":"$method","containerName":"analysis_method","kind":13,"line":123},{"line":124,"name":"$method","containerName":"analysis_method","kind":13},{"name":"$method","kind":13,"containerName":"analysis_method","line":124},{"kind":13,"containerName":"analysis_method","name":"$self","line":125},{"name":"throw","containerName":"analysis_method","kind":12,"line":125},{"line":125,"name":"$self","containerName":"analysis_method","kind":13},{"line":127,"name":"$self","kind":13,"containerName":"analysis_method"},{"line":127,"name":"$method","kind":13,"containerName":"analysis_method"}],"signature":{"documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}],"label":"analysis_method($self,$method)"},"kind":12,"range":{"end":{"line":128,"character":9999},"start":{"character":0,"line":121}},"line":121},{"containerName":"analysis_method","kind":12,"name":"SUPER","line":127},{"containerName":"main::","name":"next_feature","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"next_feature","name":"$self","line":151},{"name":"@args","kind":13,"containerName":"next_feature","line":151},{"name":"$self","containerName":"next_feature","kind":13,"line":155},{"line":155,"containerName":"next_feature","kind":12,"name":"next_prediction"},{"kind":13,"containerName":"next_feature","name":"@args","line":155}],"detail":"($self,@args)","definition":"sub","kind":12,"range":{"start":{"line":150,"character":0},"end":{"line":156,"character":9999}},"line":150,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /estscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($orf = $estscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","label":"next_feature($self,@args)"}},{"definition":"sub","detail":"($self)","children":[{"kind":13,"localvar":"my","containerName":"next_prediction","name":"$self","line":176,"definition":"my"},{"localvar":"my","containerName":"next_prediction","kind":13,"name":"$gene","line":177,"definition":"my"},{"line":177,"kind":13,"containerName":"next_prediction","name":"$seq"},{"line":177,"name":"$cds","containerName":"next_prediction","kind":13},{"name":"$predobj","containerName":"next_prediction","kind":13,"line":177},{"definition":"my","line":178,"containerName":"next_prediction","localvar":"my","kind":13,"name":"$numins"},{"kind":13,"containerName":"next_prediction","name":"$seq","line":182},{"name":"$self","containerName":"next_prediction","kind":13,"line":182},{"name":"_fasta_stream","containerName":"next_prediction","kind":12,"line":182},{"containerName":"next_prediction","kind":12,"name":"next_seq","line":182},{"name":"$seq","kind":13,"containerName":"next_prediction","line":183},{"line":185,"kind":13,"containerName":"next_prediction","name":"$gene"},{"line":185,"kind":12,"containerName":"next_prediction","name":"new"},{"containerName":"next_prediction","kind":13,"name":"$seq","line":188},{"kind":12,"containerName":"next_prediction","name":"desc","line":188},{"containerName":"next_prediction","kind":13,"name":"$self","line":189},{"line":189,"kind":12,"containerName":"next_prediction","name":"throw"},{"line":190,"containerName":"next_prediction","kind":13,"name":"$seq"},{"name":"desc","kind":12,"containerName":"next_prediction","line":190},{"containerName":"next_prediction","kind":13,"name":"$gene","line":191},{"line":191,"kind":12,"containerName":"next_prediction","name":"score"},{"line":192,"name":"$seq","kind":13,"containerName":"next_prediction"},{"line":192,"name":"desc","kind":12,"containerName":"next_prediction"},{"line":194,"containerName":"next_prediction","kind":13,"name":"$seq"},{"kind":12,"containerName":"next_prediction","name":"desc","line":194},{"name":"$desc","kind":13,"localvar":"my","containerName":"next_prediction","line":195,"definition":"my"},{"containerName":"next_prediction","kind":13,"name":"$desc","line":196},{"line":197,"name":"$seq","containerName":"next_prediction","kind":13},{"name":"desc","containerName":"next_prediction","kind":12,"line":197},{"line":197,"name":"$desc","kind":13,"containerName":"next_prediction"},{"line":198,"name":"$gene","kind":13,"containerName":"next_prediction"},{"containerName":"next_prediction","kind":12,"name":"strand","line":198},{"containerName":"next_prediction","kind":13,"name":"$gene","line":200},{"line":200,"containerName":"next_prediction","kind":12,"name":"strand"},{"line":203,"name":"$seq","containerName":"next_prediction","kind":13},{"line":203,"containerName":"next_prediction","kind":12,"name":"desc"},{"line":205,"name":"$seq","containerName":"next_prediction","kind":13},{"kind":12,"containerName":"next_prediction","name":"desc","line":205},{"name":"$predobj","kind":13,"containerName":"next_prediction","line":206},{"name":"new","kind":12,"containerName":"next_prediction","line":206},{"kind":13,"containerName":"next_prediction","name":"$predobj","line":209},{"name":"strand","containerName":"next_prediction","kind":12,"line":209},{"name":"$gene","containerName":"next_prediction","kind":13,"line":209},{"containerName":"next_prediction","kind":12,"name":"strand","line":209},{"name":"$predobj","containerName":"next_prediction","kind":13,"line":210},{"containerName":"next_prediction","kind":12,"name":"score","line":210},{"kind":13,"containerName":"next_prediction","name":"$gene","line":210},{"line":210,"name":"score","containerName":"next_prediction","kind":12},{"line":211,"containerName":"next_prediction","kind":13,"name":"$predobj"},{"line":211,"containerName":"next_prediction","kind":12,"name":"primary_tag"},{"kind":13,"containerName":"next_prediction","name":"$predobj","line":212},{"line":212,"kind":12,"containerName":"next_prediction","name":"seq_id"},{"kind":13,"containerName":"next_prediction","name":"$seq","line":212},{"kind":12,"containerName":"next_prediction","name":"display_id","line":212},{"line":214,"containerName":"next_prediction","kind":13,"name":"$gene"},{"line":214,"name":"add_exon","kind":12,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$predobj","line":214},{"line":216,"name":"$cds","containerName":"next_prediction","kind":13},{"kind":13,"containerName":"next_prediction","name":"$seq","line":216},{"line":216,"kind":12,"containerName":"next_prediction","name":"seq"},{"line":217,"containerName":"next_prediction","kind":13,"name":"$cds"},{"line":218,"containerName":"next_prediction","kind":13,"name":"$cds"},{"name":"new","containerName":"next_prediction","kind":12,"line":218},{"line":218,"name":"$cds","containerName":"next_prediction","kind":13},{"name":"$seq","containerName":"next_prediction","kind":13,"line":219},{"kind":12,"containerName":"next_prediction","name":"display_id","line":219},{"name":"$seq","kind":13,"containerName":"next_prediction","line":220},{"line":220,"containerName":"next_prediction","kind":12,"name":"desc"},{"containerName":"next_prediction","kind":13,"name":"$gene","line":222},{"containerName":"next_prediction","kind":12,"name":"predicted_cds","line":222},{"kind":13,"containerName":"next_prediction","name":"$cds","line":222},{"kind":13,"containerName":"next_prediction","name":"$predobj","line":223},{"line":223,"kind":12,"containerName":"next_prediction","name":"predicted_cds"},{"line":223,"name":"$cds","kind":13,"containerName":"next_prediction"},{"line":224,"name":"$gene","containerName":"next_prediction","kind":13},{"name":"strand","kind":12,"containerName":"next_prediction","line":224},{"line":225,"containerName":"next_prediction","kind":13,"name":"$self"},{"line":225,"name":"warn","kind":12,"containerName":"next_prediction"},{"line":237,"name":"$gene","containerName":"next_prediction","kind":13},{"name":"strand","kind":12,"containerName":"next_prediction","line":237},{"line":238,"name":"$seq","containerName":"next_prediction","kind":13},{"name":"$seq","kind":13,"containerName":"next_prediction","line":238},{"line":238,"kind":12,"containerName":"next_prediction","name":"revcom"},{"definition":"my","name":"$seqstr","localvar":"my","kind":13,"containerName":"next_prediction","line":240},{"kind":13,"containerName":"next_prediction","name":"$seq","line":240},{"kind":12,"containerName":"next_prediction","name":"seq","line":240},{"line":241,"name":"$seqstr","kind":13,"containerName":"next_prediction"},{"definition":"my","line":243,"localvar":"my","containerName":"next_prediction","kind":13,"name":"$utr5"},{"line":245,"name":"$exonseq","containerName":"next_prediction","localvar":"my","kind":13,"definition":"my"},{"name":"$exonseq","kind":13,"containerName":"next_prediction","line":247},{"line":248,"containerName":"next_prediction","kind":13,"name":"$seqstr"},{"line":250,"containerName":"next_prediction","kind":13,"name":"$seqstr"},{"definition":"my","localvar":"my","containerName":"next_prediction","kind":13,"name":"$start","line":253},{"line":253,"name":"$utr5","containerName":"next_prediction","kind":13},{"name":"$predobj","kind":13,"containerName":"next_prediction","line":254},{"line":255,"name":"$start","kind":13,"containerName":"next_prediction"},{"line":255,"name":"$predobj","kind":13,"containerName":"next_prediction"},{"kind":12,"containerName":"next_prediction","name":"end","line":255},{"name":"$numins","kind":13,"containerName":"next_prediction","line":255},{"name":"$cds","containerName":"next_prediction","kind":13,"line":258},{"line":258,"containerName":"next_prediction","kind":13,"name":"$exonseq"},{"name":"$cds","containerName":"next_prediction","kind":13,"line":259},{"line":260,"localvar":"my","containerName":"next_prediction","kind":13,"name":"$end","definition":"my"},{"line":260,"name":"$start","kind":13,"containerName":"next_prediction"},{"line":260,"name":"$cds","containerName":"next_prediction","kind":13},{"line":262,"containerName":"next_prediction","kind":13,"name":"$predobj"},{"name":"new","kind":12,"containerName":"next_prediction","line":262},{"kind":13,"containerName":"next_prediction","name":"$start","line":262},{"name":"$end","kind":13,"containerName":"next_prediction","line":263},{"name":"$predobj","containerName":"next_prediction","kind":13,"line":264},{"line":264,"kind":12,"containerName":"next_prediction","name":"source_tag"},{"line":265,"name":"$predobj","kind":13,"containerName":"next_prediction"},{"name":"primary_tag","containerName":"next_prediction","kind":12,"line":265},{"line":266,"name":"$predobj","kind":13,"containerName":"next_prediction"},{"line":266,"name":"seq_id","kind":12,"containerName":"next_prediction"},{"containerName":"next_prediction","kind":13,"name":"$seq","line":266},{"name":"display_id","containerName":"next_prediction","kind":12,"line":266},{"line":267,"kind":13,"containerName":"next_prediction","name":"$predobj"},{"containerName":"next_prediction","kind":12,"name":"strand","line":267},{"line":267,"name":"$gene","containerName":"next_prediction","kind":13},{"line":267,"name":"strand","containerName":"next_prediction","kind":12},{"kind":13,"containerName":"next_prediction","name":"$predobj","line":268},{"name":"score","kind":12,"containerName":"next_prediction","line":268},{"name":"$gene","containerName":"next_prediction","kind":13,"line":268},{"line":268,"containerName":"next_prediction","kind":12,"name":"score"},{"line":270,"name":"$gene","containerName":"next_prediction","kind":13},{"name":"add_exon","kind":12,"containerName":"next_prediction","line":270},{"kind":13,"containerName":"next_prediction","name":"$predobj","line":270},{"name":"$cds","kind":13,"containerName":"next_prediction","line":272},{"line":272,"name":"$exonseq","kind":13,"containerName":"next_prediction"},{"containerName":"next_prediction","kind":13,"name":"$cds","line":273},{"line":274,"name":"$cds","kind":13,"containerName":"next_prediction"},{"name":"new","kind":12,"containerName":"next_prediction","line":274},{"name":"$cds","containerName":"next_prediction","kind":13,"line":274},{"name":"$seq","kind":13,"containerName":"next_prediction","line":275},{"line":275,"containerName":"next_prediction","kind":12,"name":"display_id"},{"kind":13,"containerName":"next_prediction","name":"$seq","line":276},{"line":276,"name":"desc","kind":12,"containerName":"next_prediction"},{"name":"$gene","kind":13,"containerName":"next_prediction","line":279},{"line":279,"containerName":"next_prediction","kind":12,"name":"predicted_cds"},{"line":279,"kind":13,"containerName":"next_prediction","name":"$cds"},{"kind":13,"containerName":"next_prediction","name":"$gene","line":279},{"line":279,"kind":12,"containerName":"next_prediction","name":"predicted_cds"},{"name":"$predobj","containerName":"next_prediction","kind":13,"line":280},{"line":280,"name":"predicted_cds","containerName":"next_prediction","kind":12},{"containerName":"next_prediction","kind":13,"name":"$cds","line":280},{"name":"$fea","kind":13,"localvar":"my","containerName":"next_prediction","line":283,"definition":"my"},{"name":"$exonseq","containerName":"next_prediction","kind":13,"line":284},{"line":285,"name":"$indel","localvar":"my","containerName":"next_prediction","kind":13,"definition":"my"},{"containerName":"next_prediction","kind":13,"name":"$fea","line":288},{"line":289,"containerName":"next_prediction","kind":13,"name":"$start"},{"containerName":"next_prediction","kind":13,"name":"$fea","line":289},{"line":289,"name":"start","kind":12,"containerName":"next_prediction"},{"kind":13,"containerName":"next_prediction","name":"$numins","line":289},{"kind":13,"containerName":"next_prediction","name":"$start","line":290},{"kind":13,"containerName":"next_prediction","name":"$fea","line":290},{"name":"primary_tag","kind":12,"containerName":"next_prediction","line":290},{"containerName":"next_prediction","kind":13,"name":"$start","line":292},{"line":292,"name":"$predobj","containerName":"next_prediction","kind":13},{"line":292,"name":"start","containerName":"next_prediction","kind":12},{"line":292,"name":"$numins","containerName":"next_prediction","kind":13},{"name":"$start","containerName":"next_prediction","kind":13,"line":295},{"name":"$seq","kind":13,"containerName":"next_prediction","line":295},{"line":295,"name":"seq","containerName":"next_prediction","kind":12},{"line":295,"containerName":"next_prediction","kind":13,"name":"$indel"},{"name":"$start","containerName":"next_prediction","kind":13,"line":295},{"kind":13,"containerName":"next_prediction","name":"$numins","line":295},{"line":296,"kind":13,"containerName":"next_prediction","name":"$fea"},{"line":296,"kind":12,"containerName":"next_prediction","name":"new"},{"line":296,"name":"$start","containerName":"next_prediction","kind":13},{"kind":13,"containerName":"next_prediction","name":"$start","line":297},{"kind":13,"containerName":"next_prediction","name":"$fea","line":298},{"containerName":"next_prediction","kind":12,"name":"source_tag","line":298},{"line":299,"kind":13,"containerName":"next_prediction","name":"$fea"},{"line":299,"kind":12,"containerName":"next_prediction","name":"seq_id"},{"containerName":"next_prediction","kind":13,"name":"$seq","line":299},{"line":299,"name":"display_id","containerName":"next_prediction","kind":12},{"line":300,"kind":13,"containerName":"next_prediction","name":"$fea"},{"line":300,"containerName":"next_prediction","kind":12,"name":"strand"},{"containerName":"next_prediction","kind":13,"name":"$predobj","line":300},{"line":300,"name":"strand","containerName":"next_prediction","kind":12},{"name":"$indel","kind":13,"containerName":"next_prediction","line":301},{"kind":13,"containerName":"next_prediction","name":"$fea","line":306},{"line":306,"containerName":"next_prediction","kind":12,"name":"primary_tag"},{"line":311,"name":"$numins","containerName":"next_prediction","kind":13},{"line":317,"name":"$fea","containerName":"next_prediction","kind":13},{"line":317,"kind":12,"containerName":"next_prediction","name":"primary_tag"},{"kind":13,"containerName":"next_prediction","name":"$fea","line":318},{"name":"add_tag_value","kind":12,"containerName":"next_prediction","line":318},{"line":318,"kind":13,"containerName":"next_prediction","name":"$indel"},{"line":320,"name":"$predobj","containerName":"next_prediction","kind":13},{"name":"add_sub_SeqFeature","kind":12,"containerName":"next_prediction","line":320},{"containerName":"next_prediction","kind":13,"name":"$fea","line":320},{"line":325,"name":"$gene","kind":13,"containerName":"next_prediction"}],"name":"next_prediction","containerName":"main::","signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /estscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($orf = $estscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $estscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           So far, this method DOES NOT work for reverse strand predictions,\n           even though the code looks like.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :","parameters":[{"label":"$self"}]},"line":175,"range":{"end":{"line":326,"character":9999},"start":{"line":175,"character":0}},"kind":12},{"line":185,"kind":12,"containerName":"Tools::Prediction::Gene","name":"Bio"},{"kind":12,"containerName":"Tools::Prediction::Exon","name":"Bio","line":206},{"name":"Bio","kind":12,"containerName":"PrimarySeq","line":218},{"line":253,"name":"CORE","containerName":"length","kind":12},{"line":260,"name":"CORE","containerName":"length","kind":12},{"name":"Bio","kind":12,"containerName":"Tools::Prediction::Exon","line":262},{"containerName":"PrimarySeq","kind":12,"name":"Bio","line":274},{"line":296,"name":"Bio","kind":12,"containerName":"SeqFeature::Generic"},{"children":[{"name":"$self","containerName":"close","localvar":"my","kind":13,"line":341,"definition":"my"},{"line":341,"kind":13,"containerName":"close","name":"@args"},{"name":"$self","kind":13,"containerName":"close","line":343},{"containerName":"close","kind":13,"name":"$self","line":344},{"line":344,"name":"@args","containerName":"close","kind":13}],"containerName":"main::","name":"close","definition":"sub","detail":"($self,@args)","line":340,"range":{"start":{"character":0,"line":340},"end":{"line":345,"character":9999}},"kind":12,"signature":{"documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /estscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($orf = $estscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $estscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           So far, this method DOES NOT work for reverse strand predictions,\n           even though the code looks like.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my ($gene, $seq, $cds, $predobj);\n    my $numins = 0;\n\n    # predictions are in the format of FASTA sequences and can be parsed one\n    # at a time\n    $seq = $self->_fasta_stream()->next_seq();\n    return unless $seq;\n    # there is a new prediction\n    $gene = Bio::Tools::Prediction::Gene->new('-primary' => \"ORFprediction\",\n                                              '-source' => \"ESTScan\");\n    # score starts the description\n    $seq->desc() =~ /^([\\d.]+)\\s*(.*)/ or\n\t$self->throw(\"unexpected format of description: no score in \" .\n\t\t     $seq->desc());\n    $gene->score($1);\n    $seq->desc($2);\n    # strand may end the description\n    if($seq->desc() =~ /(.*)minus strand$/) {\n\tmy $desc = $1;\n\t$desc =~ s/;\\s+$//;\n\t$seq->desc($desc);\n\t$gene->strand(-1);\n    } else {\n\t$gene->strand(1);\n    }\n    # check for the format: default or 'all-in-one' (option -a)\n    if($seq->desc() =~ /^(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*(.*)/) {\n\t# default format\n\t$seq->desc($5);\n\t$predobj = Bio::Tools::Prediction::Exon->new('-source' => \"ESTScan\",\n\t\t\t\t\t\t     '-start' => $3,\n\t\t\t\t\t\t     '-end' => $4);\n\t$predobj->strand($gene->strand());\n\t$predobj->score($gene->score()); # FIXME or $1, or $2 ?\n\t$predobj->primary_tag(\"InternalExon\");\n\t$predobj->seq_id($seq->display_id());\n\t# add to gene structure object\n\t$gene->add_exon($predobj);\n\t# add predicted CDS\n\t$cds = $seq->seq();\n\t$cds =~ s/[a-z]//g; # remove the deletions, but keep the insertions\n\t$cds = Bio::PrimarySeq->new('-seq' => $cds,\n\t\t\t\t    '-display_id' => $seq->display_id(),\n\t\t\t\t    '-desc' => $seq->desc(),\n\t\t\t\t    '-alphabet' => \"dna\");\n\t$gene->predicted_cds($cds);\n\t$predobj->predicted_cds($cds);\n\tif($gene->strand() == -1) {\n\t    $self->warn(\"reverse strand ORF, but unable to reverse coordinates!\");\n\t}\n    } else {\n\t#\n\t# All-in-one format (hopefully). This encodes the following information\n\t# into the sequence:\n\t# 1) untranslated regions: stretches of lower-case letters\n\t# 2) translated regions: stretches of upper-case letters\n\t# 3) insertions in the translated regions: capital X\n\t# 4) deletions in the translated regions: a single lower-case letter\n\t#\n\t# if reverse strand ORF, save a lot of hassle by reversing the sequence\n\tif($gene->strand() == -1) {\n\t    $seq = $seq->revcom();\n\t}\n\tmy $seqstr = $seq->seq();\n\twhile($seqstr =~ /^([a-z]*)([A-Z].*)$/) {\n\t    # leading 5'UTR\n\t    my $utr5 = $1;\n\t    # exon + 3'UTR\n\t    my $exonseq = $2;\n\t    # strip 3'UTR and following exons\n\t    if($exonseq =~ s/([a-z]{2,}.*)$//) {\n\t\t$seqstr = $1;\n\t    } else {\n\t\t$seqstr = \"\";\n\t    }\n\t    # start: take care of yielding the absolute coordinate\n\t    my $start = CORE::length($utr5) + 1;\n\t    if($predobj) {\n\t\t$start += $predobj->end() + $numins;\n\t    }\n\t    # for the end coordinate, we need to subtract the insertions\n\t    $cds = $exonseq;\n\t    $cds =~ s/[X]//g;\n\t    my $end = $start + CORE::length($cds) - 1;\n\t    # construct next exon object\n\t    $predobj = Bio::Tools::Prediction::Exon->new('-start' => $start,\n\t\t\t\t\t\t\t '-end' => $end);\n\t    $predobj->source_tag(\"ESTScan\");\n\t    $predobj->primary_tag(\"InternalExon\");\n\t    $predobj->seq_id($seq->display_id());\n\t    $predobj->strand($gene->strand());\n\t    $predobj->score($gene->score());\n\t    # add the exon to the gene structure object\n\t    $gene->add_exon($predobj);\n\t    # add the predicted CDS\n\t    $cds = $exonseq;\n\t    $cds =~ s/[a-z]//g; # remove the deletions, but keep the insertions\n\t    $cds = Bio::PrimarySeq->new('-seq' => $cds,\n\t\t\t\t\t'-display_id' => $seq->display_id(),\n\t\t\t\t\t'-desc' => $seq->desc(),\n\t\t\t\t\t'-alphabet' => \"dna\");\n\t    # only store the first one in the overall prediction\n\t    $gene->predicted_cds($cds) unless $gene->predicted_cds();\n\t    $predobj->predicted_cds($cds);\n\t    # add the predicted insertions and deletions as subfeatures\n\t    # of the exon\n\t    my $fea = undef;\n\t    while($exonseq =~ /([a-zX])/g) {\n\t\tmy $indel = $1;\n\t\t# start and end: start looking at the position after the\n\t\t# previous feature\n\t\tif($fea) {\n\t\t    $start = $fea->start()+$numins;\n\t\t    $start -= 1 if($fea->primary_tag() eq 'insertion');\n\t\t} else {\n\t\t    $start = $predobj->start()+$numins-1;\n\t\t}\n\t\t#print \"# numins = $numins, indel = $indel, start = $start\\n\";\n\t\t$start = index($seq->seq(), $indel, $start) + 1 - $numins;\n\t\t$fea = Bio::SeqFeature::Generic->new('-start' => $start,\n\t\t\t\t\t\t     '-end' => $start);\n\t\t$fea->source_tag(\"ESTScan\");\n\t\t$fea->seq_id($seq->display_id());\n\t\t$fea->strand($predobj->strand());\n\t\tif($indel eq 'X') {\n\t\t    # an insertion (depends on viewpoint: to get the 'real'\n\t\t    # CDS, a base has to be inserted, i.e., the HMMER model\n\t\t    # inserted a base; however, the sequencing process deleted\n\t\t    # a base that was there).\n\t\t    $fea->primary_tag(\"insertion\");\n\t\t    # we need to count insertions because these are left out\n\t\t    # of any coordinates saved in the objects (which is correct\n\t\t    # because insertions change the original sequence, so\n\t\t    # coordinates wouldn't match)\n\t\t    $numins++;\n\t\t} else {\n\t\t    # a deletion (depends on viewpoint: to get the 'real'\n\t\t    # CDS, a base has to be deleted, i.e., the HMMER model\n\t\t    # deleted a base; however, the sequencing process inserted\n\t\t    # a base that wasn't there).\n\t\t    $fea->primary_tag(\"deletion\");\n\t\t    $fea->add_tag_value('base', $indel);\n\t\t}\n\t\t$predobj->add_sub_SeqFeature($fea);\n\t    }\n\t}\n    }\n    \n    return $gene;\n}\n\n=head2 close\n\n Title   : close\n Usage   : $result->close()\n Function: Closes the file handle associated with this result file.\n           Inherited method, overridden.\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"close($self,@args)"}},{"name":"SUPER","containerName":"close","kind":12,"line":344},{"kind":12,"range":{"start":{"line":362,"character":0},"end":{"character":9999,"line":373}},"line":362,"signature":{"label":"_fasta_stream($self,$stream)","documentation":"1;\n# $Id: ESTScan.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::ESTScan\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp@gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::ESTScan - Results of one ESTScan run\n\n=head1 SYNOPSIS\n\n   $estscan = Bio::Tools::ESTScan->new(-file => 'result.estscan');\n   # filehandle:\n   $estscan = Bio::Tools::ESTScan->new( -fh  => \\*INPUT );\n\n   # parse the results\n   # note: this class is-a Bio::Tools::AnalysisResult which implements\n   # Bio::SeqAnalysisParserI, i.e., $genscan->next_feature() is the same\n   while($gene = $estscan->next_prediction()) {\n       # $gene is an instance of Bio::Tools::Prediction::Gene\n       foreach my $orf ($gene->exons()) {\n\t   # $orf is an instance of Bio::Tools::Prediction::Exon\n\t   $cds_str = $orf->predicted_cds();\n       }\n   }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $estscan->close();\n\n=head1 DESCRIPTION\n\nThe ESTScan module provides a parser for ESTScan coding region prediction\noutput.\n\nThis module inherits off L<Bio::Tools::AnalysisResult> and therefore\nimplements the L<Bio::SeqAnalysisParserI> interface. \nSee L<Bio::SeqAnalysisParserI>.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp@gmx.net (or hilmar.lapp@pharma.novartis.com)\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::ESTScan;\nuse strict;\nuse Symbol;\n\nuse Bio::Root::Root;\nuse Bio::Tools::Prediction::Exon;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\nsub _initialize_state {\n    my ($self,@args) = @_;\n\n    # first call the inherited method!\n    my $make = $self->SUPER::_initialize_state(@args);\n\n    if(! $self->analysis_method()) {\n\t$self->analysis_method('ESTScan');\n    }\n}\n\n=head2 analysis_method\n\n Usage     : $estscan->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n             /estscan/i.\n Returns   : String\n Argument  : n/a\n\n\n#-------------\nsub analysis_method { \n#-------------\n    my ($self, $method) = @_;  \n    if($method && ($method !~ /estscan/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n    return $self->SUPER::analysis_method($method);\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : while($orf = $estscan->next_feature()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           The returned object is actually a SeqFeatureI implementing object.\n           This method is required for classes implementing the\n           SeqAnalysisParserI interface, and is merely an alias for \n           next_prediction() at present.\n\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_feature {\n    my ($self,@args) = @_;\n    # even though next_prediction doesn't expect any args (and this method\n    # does neither), we pass on args in order to be prepared if this changes\n    # ever\n    return $self->next_prediction(@args);\n}\n\n=head2 next_prediction\n\n Title   : next_prediction\n Usage   : while($gene = $estscan->next_prediction()) {\n                  # do something\n           }\n Function: Returns the next gene structure prediction of the ESTScan result\n           file. Call this method repeatedly until FALSE is returned.\n\n           So far, this method DOES NOT work for reverse strand predictions,\n           even though the code looks like.\n Example :\n Returns : A Bio::Tools::Prediction::Gene object.\n Args    :\n\n\nsub next_prediction {\n    my ($self) = @_;\n    my ($gene, $seq, $cds, $predobj);\n    my $numins = 0;\n\n    # predictions are in the format of FASTA sequences and can be parsed one\n    # at a time\n    $seq = $self->_fasta_stream()->next_seq();\n    return unless $seq;\n    # there is a new prediction\n    $gene = Bio::Tools::Prediction::Gene->new('-primary' => \"ORFprediction\",\n                                              '-source' => \"ESTScan\");\n    # score starts the description\n    $seq->desc() =~ /^([\\d.]+)\\s*(.*)/ or\n\t$self->throw(\"unexpected format of description: no score in \" .\n\t\t     $seq->desc());\n    $gene->score($1);\n    $seq->desc($2);\n    # strand may end the description\n    if($seq->desc() =~ /(.*)minus strand$/) {\n\tmy $desc = $1;\n\t$desc =~ s/;\\s+$//;\n\t$seq->desc($desc);\n\t$gene->strand(-1);\n    } else {\n\t$gene->strand(1);\n    }\n    # check for the format: default or 'all-in-one' (option -a)\n    if($seq->desc() =~ /^(\\d+)\\s+(\\d+)\\s+(\\d+)\\s+(\\d+)\\s*(.*)/) {\n\t# default format\n\t$seq->desc($5);\n\t$predobj = Bio::Tools::Prediction::Exon->new('-source' => \"ESTScan\",\n\t\t\t\t\t\t     '-start' => $3,\n\t\t\t\t\t\t     '-end' => $4);\n\t$predobj->strand($gene->strand());\n\t$predobj->score($gene->score()); # FIXME or $1, or $2 ?\n\t$predobj->primary_tag(\"InternalExon\");\n\t$predobj->seq_id($seq->display_id());\n\t# add to gene structure object\n\t$gene->add_exon($predobj);\n\t# add predicted CDS\n\t$cds = $seq->seq();\n\t$cds =~ s/[a-z]//g; # remove the deletions, but keep the insertions\n\t$cds = Bio::PrimarySeq->new('-seq' => $cds,\n\t\t\t\t    '-display_id' => $seq->display_id(),\n\t\t\t\t    '-desc' => $seq->desc(),\n\t\t\t\t    '-alphabet' => \"dna\");\n\t$gene->predicted_cds($cds);\n\t$predobj->predicted_cds($cds);\n\tif($gene->strand() == -1) {\n\t    $self->warn(\"reverse strand ORF, but unable to reverse coordinates!\");\n\t}\n    } else {\n\t#\n\t# All-in-one format (hopefully). This encodes the following information\n\t# into the sequence:\n\t# 1) untranslated regions: stretches of lower-case letters\n\t# 2) translated regions: stretches of upper-case letters\n\t# 3) insertions in the translated regions: capital X\n\t# 4) deletions in the translated regions: a single lower-case letter\n\t#\n\t# if reverse strand ORF, save a lot of hassle by reversing the sequence\n\tif($gene->strand() == -1) {\n\t    $seq = $seq->revcom();\n\t}\n\tmy $seqstr = $seq->seq();\n\twhile($seqstr =~ /^([a-z]*)([A-Z].*)$/) {\n\t    # leading 5'UTR\n\t    my $utr5 = $1;\n\t    # exon + 3'UTR\n\t    my $exonseq = $2;\n\t    # strip 3'UTR and following exons\n\t    if($exonseq =~ s/([a-z]{2,}.*)$//) {\n\t\t$seqstr = $1;\n\t    } else {\n\t\t$seqstr = \"\";\n\t    }\n\t    # start: take care of yielding the absolute coordinate\n\t    my $start = CORE::length($utr5) + 1;\n\t    if($predobj) {\n\t\t$start += $predobj->end() + $numins;\n\t    }\n\t    # for the end coordinate, we need to subtract the insertions\n\t    $cds = $exonseq;\n\t    $cds =~ s/[X]//g;\n\t    my $end = $start + CORE::length($cds) - 1;\n\t    # construct next exon object\n\t    $predobj = Bio::Tools::Prediction::Exon->new('-start' => $start,\n\t\t\t\t\t\t\t '-end' => $end);\n\t    $predobj->source_tag(\"ESTScan\");\n\t    $predobj->primary_tag(\"InternalExon\");\n\t    $predobj->seq_id($seq->display_id());\n\t    $predobj->strand($gene->strand());\n\t    $predobj->score($gene->score());\n\t    # add the exon to the gene structure object\n\t    $gene->add_exon($predobj);\n\t    # add the predicted CDS\n\t    $cds = $exonseq;\n\t    $cds =~ s/[a-z]//g; # remove the deletions, but keep the insertions\n\t    $cds = Bio::PrimarySeq->new('-seq' => $cds,\n\t\t\t\t\t'-display_id' => $seq->display_id(),\n\t\t\t\t\t'-desc' => $seq->desc(),\n\t\t\t\t\t'-alphabet' => \"dna\");\n\t    # only store the first one in the overall prediction\n\t    $gene->predicted_cds($cds) unless $gene->predicted_cds();\n\t    $predobj->predicted_cds($cds);\n\t    # add the predicted insertions and deletions as subfeatures\n\t    # of the exon\n\t    my $fea = undef;\n\t    while($exonseq =~ /([a-zX])/g) {\n\t\tmy $indel = $1;\n\t\t# start and end: start looking at the position after the\n\t\t# previous feature\n\t\tif($fea) {\n\t\t    $start = $fea->start()+$numins;\n\t\t    $start -= 1 if($fea->primary_tag() eq 'insertion');\n\t\t} else {\n\t\t    $start = $predobj->start()+$numins-1;\n\t\t}\n\t\t#print \"# numins = $numins, indel = $indel, start = $start\\n\";\n\t\t$start = index($seq->seq(), $indel, $start) + 1 - $numins;\n\t\t$fea = Bio::SeqFeature::Generic->new('-start' => $start,\n\t\t\t\t\t\t     '-end' => $start);\n\t\t$fea->source_tag(\"ESTScan\");\n\t\t$fea->seq_id($seq->display_id());\n\t\t$fea->strand($predobj->strand());\n\t\tif($indel eq 'X') {\n\t\t    # an insertion (depends on viewpoint: to get the 'real'\n\t\t    # CDS, a base has to be inserted, i.e., the HMMER model\n\t\t    # inserted a base; however, the sequencing process deleted\n\t\t    # a base that was there).\n\t\t    $fea->primary_tag(\"insertion\");\n\t\t    # we need to count insertions because these are left out\n\t\t    # of any coordinates saved in the objects (which is correct\n\t\t    # because insertions change the original sequence, so\n\t\t    # coordinates wouldn't match)\n\t\t    $numins++;\n\t\t} else {\n\t\t    # a deletion (depends on viewpoint: to get the 'real'\n\t\t    # CDS, a base has to be deleted, i.e., the HMMER model\n\t\t    # deleted a base; however, the sequencing process inserted\n\t\t    # a base that wasn't there).\n\t\t    $fea->primary_tag(\"deletion\");\n\t\t    $fea->add_tag_value('base', $indel);\n\t\t}\n\t\t$predobj->add_sub_SeqFeature($fea);\n\t    }\n\t}\n    }\n    \n    return $gene;\n}\n\n=head2 close\n\n Title   : close\n Usage   : $result->close()\n Function: Closes the file handle associated with this result file.\n           Inherited method, overridden.\n Example :\n Returns :\n Args    :\n\n\nsub close {\n   my ($self, @args) = @_;\n\n   delete($self->{'_fastastream'});\n   $self->SUPER::close(@args);\n}\n\n=head2 _fasta_stream\n\n Title   : _fasta_stream\n Usage   : $result->_fasta_stream()\n Function: Gets/Sets the FASTA sequence IO stream for reading the contents of\n           the file associated with this MZEF result object.\n\n           If called for the first time, creates the stream from the filehandle\n           if necessary.\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$stream"}]},"name":"_fasta_stream","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"_fasta_stream","kind":13,"name":"$self","line":363},{"line":363,"name":"$stream","containerName":"_fasta_stream","kind":13},{"name":"$stream","kind":13,"containerName":"_fasta_stream","line":365},{"name":"$self","kind":13,"containerName":"_fasta_stream","line":365},{"kind":13,"containerName":"_fasta_stream","name":"$stream","line":366},{"kind":13,"containerName":"_fasta_stream","name":"$stream","line":367},{"line":367,"containerName":"_fasta_stream","kind":12,"name":"new"},{"name":"$self","containerName":"_fasta_stream","kind":13,"line":367},{"line":367,"containerName":"_fasta_stream","kind":12,"name":"_fh"},{"name":"$self","containerName":"_fasta_stream","kind":13,"line":370},{"line":370,"name":"$stream","kind":13,"containerName":"_fasta_stream"},{"line":372,"containerName":"_fasta_stream","kind":13,"name":"$self"}],"detail":"($self,$stream)","definition":"sub"},{"line":367,"containerName":"SeqIO","kind":12,"name":"Bio"}],"version":5}