{"vars":[{"name":"base","kind":2,"containerName":"","line":140},{"signature":{"label":"_add_data($self,$simple)","parameters":[{"label":"$self"},{"label":"$simple"}],"documentation":"1;\n# $Id: Info.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Info\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n# \n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Info - interface class for storing einfo data\n\n=head1 SYNOPSIS\n\n  #### should not create instance directly; Bio::Tools::EUtilities does this ####\n\n  my $info = Bio::Tools::EUtilities->new(-eutil => 'einfo',\n                                         -file => 'einfo.xml');\n  # can also use '-response' (for HTTP::Response objects) or '-fh' (for filehandles)\n\n  # print available databases (if data is present)\n\n  print join(', ',$info->get_available_databases),\"\\n\";\n\n  # get database info\n\n  my $db = $info->get_database; # in case you forgot...\n  my $desc = $info->get_description;\n  my $nm = $info->get_menu_name;\n  my $ct = $info->get_record_count;\n  my $dt = $info->get_last_update;\n\n  # EUtilDataI interface methods\n\n  my $eutil = $info->eutil;\n  my $type = $info->datatype;\n\n  # iterate through Field and Link objects\n\n  while (my $field = $info->next_Field) {\n      print \"Field code: \",$field->get_field_code,\"\\n\";\n      print \"Field name: \",$field->get_field_name,\"\\n\";\n      print \"Field desc: \",$field->get_field_description,\"\\n\";\n      print \"DB  : \",$field->get_database,\"\\n\";\n      print \"Term ct   : \",$field->get_term_count,\"\\n\";\n      for my $att (qw(is_date is_singletoken is_hierarchy is_hidden is_numerical)) {\n          print \"\\tField $att\\n\" if $field->$att;\n      }\n  }\n\n  my @fields = $info->get_Fields; # grab them all (useful for grep)\n\n  while (my $link = $info->next_LinkInfo) {\n      print \"Link name: \",$link->get_link_name,\"\\n\";\n      print \"Link desc: \",$link->get_link_description,\"\\n\";\n      print \"DBFrom: \",$link->get_dbfrom,\"\\n\"; # same as get_database()\n      print \"DBTo: \",$link->get_dbto,\"\\n\"; # database linked to\n  }\n\n  my @links = $info->get_LinkInfo; # grab them all (useful for grep)\n\n  $info->rewind(); # rewinds all iterators\n  $info->rewind('links'); # rewinds Link iterator\n  $info->rewind('fields'); # rewinds Field iterator\n\n=head1 DESCRIPTION\n\nThis class handles data output (XML) from einfo.\n\neinfo is capable of returning two types of information: 1) a list of all\navailable databases (when called w/o parameters) and 2) information about a\nspecific database. The latter information includes the database description,\nrecord count, and date/time stamp for the last update, among other things. It\nalso includes a list of fields (indices by which record data is stored which can\nbe used in queries) and links (crossrefs between related records in other\ndatabases at NCBI). Data from the latter two are stored in two small subclasses\n(Field and Link) which can be iterated through or retrieved all at once, as\ndemonstrated above. NOTE: Methods described for the Link and Field subclasses\nare unique to those classes (as they retrieve data unique to those data types). \n\nFurther documentation for Link and Field subclass methods is included below.\n\nFor more information on einfo see:\n\n   http://eutils.ncbi.nlm.nih.gov/entrez/query/static/einfo_help.html\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other Bioperl\nmodules. Send your comments and suggestions preferably to one of the Bioperl\nmailing lists. Your participation is much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track the bugs\nand their resolution. Bug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal\nmethods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Info;\n\nuse strict;\nuse warnings;\nuse base qw(Bio::Tools::EUtilities Bio::Tools::EUtilities::EUtilDataI);\n\nuse Bio::Tools::EUtilities::Info::LinkInfo;\nuse Bio::Tools::EUtilities::Info::FieldInfo;\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $info->rewind() # rewinds all (default)\n            $info->rewind('links') # rewinds only links\n Function : 'rewinds' (resets) specified interators (all if no arg)\n Returns  : none\n Args     : [OPTIONAL] String: \n            'all'    - all iterators (default)\n            'linkinfo'  - LinkInfo objects only\n            'fieldinfo' - FieldInfo objects only\n\n private EUtilDataI method"},"kind":12,"range":{"end":{"line":188,"character":9999},"start":{"character":0,"line":162}},"line":162,"detail":"($self,$simple)","definition":"sub","containerName":"main::","name":"_add_data","children":[{"line":163,"name":"$self","localvar":"my","containerName":"_add_data","kind":13,"definition":"my"},{"name":"$simple","containerName":"_add_data","kind":13,"line":163},{"line":164,"containerName":"_add_data","kind":13,"name":"$simple"},{"kind":13,"containerName":"_add_data","name":"$simple","line":165},{"line":166,"name":"$self","containerName":"_add_data","kind":13},{"name":"$simple","kind":13,"containerName":"_add_data","line":166},{"name":"$simple","containerName":"_add_data","kind":13,"line":169},{"name":"$key","localvar":"my","kind":13,"containerName":"_add_data","line":170,"definition":"my"},{"name":"$simple","containerName":"_add_data","kind":13,"line":170},{"definition":"my","line":171,"kind":13,"localvar":"my","containerName":"_add_data","name":"$data"},{"line":172,"name":"$key","containerName":"_add_data","kind":13},{"name":"$simple","kind":13,"containerName":"_add_data","line":172},{"line":172,"kind":13,"containerName":"_add_data","name":"$key"},{"name":"$key","containerName":"_add_data","kind":13,"line":173},{"containerName":"_add_data","kind":13,"name":"$simple","line":173},{"line":173,"name":"$key","kind":13,"containerName":"_add_data"},{"line":174,"kind":13,"containerName":"_add_data","name":"$simple"},{"line":174,"name":"$key","containerName":"_add_data","kind":13},{"containerName":"_add_data","kind":13,"name":"$key","line":175},{"name":"$key","containerName":"_add_data","kind":13,"line":175},{"line":176,"name":"$chunk","containerName":"_add_data","localvar":"my","kind":13,"definition":"my"},{"line":176,"name":"$data","containerName":"_add_data","kind":13},{"kind":13,"containerName":"_add_data","name":"$simple","line":177},{"line":178,"containerName":"_add_data","kind":13,"name":"$chunk"},{"line":178,"kind":13,"containerName":"_add_data","name":"$simple"},{"definition":"my","localvar":"my","kind":13,"containerName":"_add_data","name":"$type","line":180},{"containerName":"_add_data","kind":13,"name":"$key","line":180},{"containerName":"_add_data","localvar":"my","kind":13,"name":"$obj","line":181,"definition":"my"},{"name":"new","kind":12,"containerName":"_add_data","line":181},{"line":183,"containerName":"_add_data","kind":13,"name":"$type"},{"name":"$self","containerName":"_add_data","kind":13,"line":184},{"containerName":"_add_data","kind":12,"name":"verbose","line":184},{"line":185,"name":"$obj","containerName":"_add_data","kind":13},{"containerName":"_add_data","kind":12,"name":"_add_data","line":185},{"name":"$chunk","kind":13,"containerName":"_add_data","line":185},{"name":"$self","containerName":"_add_data","kind":13,"line":186},{"line":186,"name":"$type","containerName":"_add_data","kind":13},{"line":186,"kind":13,"containerName":"_add_data","name":"$obj"}]},{"containerName":"Bio::Tools::EUtilities::Info::LinkInfo::Bio::Tools::EUtilities::Info","kind":2,"name":"FieldInfo","line":163},{"name":"DbList","kind":12,"line":164},{"name":"DbList","kind":12,"line":165},{"line":165,"kind":12,"name":"DbName"},{"line":166,"kind":12,"name":"DbList"},{"line":166,"kind":12,"name":"DbName"},{"kind":12,"name":"DbInfo","line":169},{"kind":12,"name":"DbInfo","line":170},{"name":"DbInfo","kind":12,"line":172},{"kind":12,"name":"Field","line":172},{"line":173,"name":"DbInfo","kind":12},{"kind":12,"name":"Link","line":173},{"name":"DbInfo","kind":12,"line":174},{"name":"DbInfo","kind":12,"line":177},{"kind":12,"name":"DbName","line":177},{"kind":12,"name":"DbFrom","line":178},{"line":178,"kind":12,"name":"DbInfo"},{"line":178,"kind":12,"name":"DbName"},{"line":189,"containerName":null,"kind":13,"name":"%self"},{"name":"$key","kind":13,"containerName":null,"line":189},{"line":189,"containerName":null,"kind":13,"name":"%data"},{"line":193,"kind":13,"containerName":null,"name":"%self"},{"name":"%simple","containerName":null,"kind":13,"line":193},{"line":193,"name":"%simple","containerName":null,"kind":13},{"kind":13,"containerName":null,"name":"$simple","line":193},{"line":208,"range":{"end":{"line":222,"character":9999},"start":{"character":0,"line":208}},"kind":12,"children":[{"definition":"my","line":209,"containerName":"to_string","localvar":"my","kind":13,"name":"$self"},{"containerName":"to_string","localvar":"my","kind":13,"name":"$string","line":210,"definition":"my"},{"line":210,"name":"$self","kind":13,"containerName":"to_string"},{"definition":"my","name":"@dbs","kind":13,"localvar":"my","containerName":"to_string","line":211},{"line":211,"name":"$self","containerName":"to_string","kind":13},{"line":211,"name":"get_databases","containerName":"to_string","kind":12},{"name":"$string","kind":13,"containerName":"to_string","line":212},{"line":213,"name":"$self","kind":13,"containerName":"to_string"},{"line":213,"name":"_text_wrap","kind":12,"containerName":"to_string"},{"line":213,"name":"@dbs","containerName":"to_string","kind":13},{"line":215,"containerName":"to_string","localvar":"my","kind":13,"name":"$fi","definition":"my"},{"line":215,"containerName":"to_string","kind":13,"name":"$self"},{"kind":12,"containerName":"to_string","name":"next_FieldInfo","line":215},{"containerName":"to_string","kind":13,"name":"$string","line":216},{"name":"$fi","kind":13,"containerName":"to_string","line":216},{"containerName":"to_string","kind":12,"name":"to_string","line":216},{"containerName":"to_string","localvar":"my","kind":13,"name":"$li","line":218,"definition":"my"},{"kind":13,"containerName":"to_string","name":"$self","line":218},{"line":218,"name":"next_LinkInfo","containerName":"to_string","kind":12},{"line":219,"kind":13,"containerName":"to_string","name":"$string"},{"line":219,"kind":13,"containerName":"to_string","name":"$li"},{"containerName":"to_string","kind":12,"name":"to_string","line":219},{"line":221,"containerName":"to_string","kind":13,"name":"$string"}],"name":"to_string","containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"to_string","kind":12,"line":211},{"name":"x20","kind":12,"line":213}],"version":5}