{"vars":[{"line":108,"name":"base","kind":2,"containerName":""},{"range":{"start":{"line":120,"character":0},"end":{"line":129,"character":9999}},"kind":12,"line":120,"signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : ","parameters":[{"label":"$class"},{"label":"@args"}]},"name":"new","containerName":"main::","children":[{"definition":"my","line":121,"name":"$class","containerName":"new","localvar":"my","kind":13},{"line":121,"name":"@args","kind":13,"containerName":"new"},{"line":122,"name":"$self","containerName":"new","localvar":"my","kind":13,"definition":"my"},{"name":"$class","containerName":"new","kind":13,"line":122},{"line":122,"name":"@args","containerName":"new","kind":13},{"definition":"my","kind":13,"localvar":"my","containerName":"new","name":"$type","line":123},{"name":"$self","containerName":"new","kind":13,"line":123},{"line":123,"name":"_rearrange","kind":12,"containerName":"new"},{"containerName":"new","kind":13,"name":"@args","line":123},{"line":124,"kind":13,"containerName":"new","name":"$type"},{"containerName":"new","kind":13,"name":"$self","line":125},{"name":"datatype","kind":12,"containerName":"new","line":125},{"line":125,"kind":13,"containerName":"new","name":"$type"},{"kind":13,"containerName":"new","name":"$self","line":126},{"kind":12,"containerName":"new","name":"eutil","line":126},{"kind":13,"containerName":"new","name":"$self","line":127},{"containerName":"new","kind":12,"name":"rewind","line":127},{"line":128,"name":"$self","containerName":"new","kind":13}],"detail":"($class,@args)","definition":"sub"},{"kind":12,"containerName":"new","name":"SUPER","line":122},{"line":144,"range":{"end":{"character":9999,"line":147},"start":{"character":0,"line":144}},"kind":12,"definition":"sub","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"get_ids","line":145},{"line":146,"containerName":"get_ids","kind":13,"name":"$self"}],"containerName":"main::","name":"get_ids"},{"line":159,"range":{"start":{"character":0,"line":159},"end":{"line":162,"character":9999}},"kind":12,"children":[{"line":160,"name":"$self","localvar":"my","kind":13,"containerName":"get_id","definition":"my"},{"line":161,"kind":13,"containerName":"get_id","name":"$self"}],"containerName":"main::","name":"get_id","definition":"sub"},{"kind":12,"range":{"end":{"character":9999,"line":183},"start":{"line":174,"character":0}},"line":174,"name":"next_ListItem","containerName":"main::","children":[{"definition":"my","line":175,"name":"$self","localvar":"my","containerName":"next_ListItem","kind":13},{"line":176,"containerName":"next_ListItem","kind":13,"name":"$self"},{"definition":"my","name":"@lists","kind":13,"localvar":"my","containerName":"next_ListItem","line":177},{"containerName":"next_ListItem","kind":13,"name":"$self","line":177},{"containerName":"next_ListItem","kind":12,"name":"get_ListItems","line":177},{"line":179,"kind":13,"containerName":"next_ListItem","name":"$self"},{"line":179,"containerName":"next_ListItem","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"next_ListItem","line":180},{"kind":13,"containerName":"next_ListItem","name":"@lists","line":180},{"name":"$self","containerName":"next_ListItem","kind":13,"line":182}],"definition":"sub"},{"line":195,"kind":12,"range":{"end":{"line":199,"character":9999},"start":{"character":0,"line":195}},"definition":"sub","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"get_ListItems","line":196,"definition":"my"},{"line":197,"name":"@items","kind":13,"localvar":"my","containerName":"get_ListItems","definition":"my"},{"line":197,"kind":13,"containerName":"get_ListItems","name":"$self"},{"kind":12,"containerName":"get_ListItems","name":"get_type","line":197},{"kind":13,"containerName":"get_ListItems","name":"$self","line":197},{"line":197,"name":"get_subItems","kind":12,"containerName":"get_ListItems"},{"name":"@items","kind":13,"containerName":"get_ListItems","line":198}],"containerName":"main::","name":"get_ListItems"},{"line":211,"range":{"end":{"line":218,"character":9999},"start":{"line":211,"character":0}},"kind":12,"children":[{"line":212,"name":"$self","localvar":"my","containerName":"next_StructureItem","kind":13,"definition":"my"},{"line":213,"kind":13,"containerName":"next_StructureItem","name":"$self"},{"name":"@structs","kind":13,"localvar":"my","containerName":"next_StructureItem","line":214,"definition":"my"},{"line":214,"name":"$self","kind":13,"containerName":"next_StructureItem"},{"line":214,"kind":12,"containerName":"next_StructureItem","name":"get_StructureItems"},{"line":215,"name":"$self","containerName":"next_StructureItem","kind":13},{"line":215,"containerName":"next_StructureItem","kind":13,"name":"@structs"},{"kind":13,"containerName":"next_StructureItem","name":"$self","line":217}],"name":"next_StructureItem","containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","name":"get_StructureItems","children":[{"line":231,"kind":13,"localvar":"my","containerName":"get_StructureItems","name":"$self","definition":"my"},{"definition":"my","line":232,"localvar":"my","kind":13,"containerName":"get_StructureItems","name":"@items"},{"name":"$self","kind":13,"containerName":"get_StructureItems","line":232},{"line":232,"name":"get_type","containerName":"get_StructureItems","kind":12},{"containerName":"get_StructureItems","kind":13,"name":"$self","line":232},{"line":232,"name":"get_subItems","kind":12,"containerName":"get_StructureItems"},{"name":"@items","kind":13,"containerName":"get_StructureItems","line":233}],"range":{"end":{"character":9999,"line":234},"start":{"character":0,"line":230}},"kind":12,"line":230},{"kind":12,"range":{"start":{"character":0,"line":248},"end":{"line":255,"character":9999}},"line":248,"definition":"sub","containerName":"main::","name":"next_subItem","children":[{"definition":"my","line":249,"localvar":"my","containerName":"next_subItem","kind":13,"name":"$self"},{"name":"$self","containerName":"next_subItem","kind":13,"line":250},{"name":"@structs","containerName":"next_subItem","localvar":"my","kind":13,"line":251,"definition":"my"},{"name":"$self","containerName":"next_subItem","kind":13,"line":251},{"line":251,"name":"get_subItems","kind":12,"containerName":"next_subItem"},{"name":"$self","containerName":"next_subItem","kind":13,"line":252},{"line":252,"kind":13,"containerName":"next_subItem","name":"@structs"},{"name":"$self","containerName":"next_subItem","kind":13,"line":254}]},{"children":[{"definition":"my","line":270,"name":"$self","localvar":"my","containerName":"get_subItems","kind":13},{"name":"$self","containerName":"get_subItems","kind":13,"line":271},{"line":271,"name":"$self","containerName":"get_subItems","kind":13}],"containerName":"main::","name":"get_subItems","definition":"sub","line":269,"range":{"end":{"line":271,"character":9999},"start":{"line":269,"character":0}},"kind":12},{"definition":"sub","containerName":"main::","name":"get_name","children":[{"kind":13,"localvar":"my","containerName":"get_name","name":"$self","line":285,"definition":"my"},{"name":"$self","containerName":"get_name","kind":13,"line":286}],"range":{"start":{"character":0,"line":284},"end":{"line":287,"character":9999}},"kind":12,"line":284},{"definition":"sub","children":[{"definition":"my","line":302,"localvar":"my","kind":13,"containerName":"get_type","name":"$self"},{"name":"$self","containerName":"get_type","kind":13,"line":303}],"containerName":"main::","name":"get_type","line":301,"range":{"end":{"character":9999,"line":304},"start":{"character":0,"line":301}},"kind":12},{"kind":12,"range":{"start":{"character":0,"line":316},"end":{"character":9999,"line":319}},"line":316,"containerName":"main::","name":"get_content","children":[{"definition":"my","line":317,"localvar":"my","kind":13,"containerName":"get_content","name":"$self"},{"name":"$self","containerName":"get_content","kind":13,"line":318}],"definition":"sub"},{"containerName":"main::","name":"rewind","children":[{"definition":"my","localvar":"my","kind":13,"containerName":"rewind","name":"$self","line":334},{"containerName":"rewind","kind":13,"name":"$request","line":334},{"line":335,"kind":13,"containerName":"rewind","name":"$request"},{"line":335,"kind":13,"containerName":"rewind","name":"$request"},{"kind":12,"containerName":"rewind","name":"rewind","line":336},{"containerName":"rewind","kind":13,"name":"$self","line":336},{"line":336,"name":"get_ListItems","containerName":"rewind","kind":12},{"name":"$self","containerName":"rewind","kind":13,"line":338},{"name":"$self","kind":13,"containerName":"rewind","line":338},{"name":"$self","containerName":"rewind","kind":13,"line":339},{"kind":13,"containerName":"rewind","name":"$self","line":339}],"detail":"($self,$request)","definition":"sub","kind":12,"range":{"end":{"line":340,"character":9999},"start":{"line":333,"character":0}},"line":333,"signature":{"label":"rewind($self,$request)","documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)","parameters":[{"label":"$self"},{"label":"$request"}]}},{"children":[{"localvar":"my","containerName":"next_Item","kind":13,"name":"$self","line":359,"definition":"my"},{"name":"$request","containerName":"next_Item","kind":13,"line":359},{"name":"$self","containerName":"next_Item","kind":13,"line":360},{"definition":"my","line":362,"name":"@items","kind":13,"localvar":"my","containerName":"next_Item"},{"line":362,"kind":13,"containerName":"next_Item","name":"$request"},{"name":"$request","kind":13,"containerName":"next_Item","line":362},{"name":"$self","containerName":"next_Item","kind":13,"line":363},{"line":363,"name":"get_all_Items","kind":12,"containerName":"next_Item"},{"line":364,"containerName":"next_Item","kind":13,"name":"$self"},{"line":364,"kind":12,"containerName":"next_Item","name":"get_Items"},{"line":365,"name":"$self","containerName":"next_Item","kind":13},{"name":"@items","kind":13,"containerName":"next_Item","line":365},{"line":367,"containerName":"next_Item","kind":13,"name":"$self"}],"name":"next_Item","containerName":"main::","definition":"sub","detail":"($self,$request)","line":358,"range":{"end":{"character":9999,"line":368},"start":{"character":0,"line":358}},"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$request"}],"documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()","label":"next_Item($self,$request)"}},{"children":[{"name":"$self","localvar":"my","kind":13,"containerName":"get_Items","line":381,"definition":"my"},{"line":382,"containerName":"get_Items","kind":13,"name":"$self"},{"name":"$self","containerName":"get_Items","kind":13,"line":382}],"containerName":"main::","name":"get_Items","definition":"sub","line":380,"kind":12,"range":{"end":{"character":9999,"line":382},"start":{"line":380,"character":0}}},{"range":{"start":{"line":407,"character":0},"end":{"line":417,"character":9999}},"kind":12,"line":407,"name":"get_all_Items","containerName":"main::","children":[{"localvar":"my","kind":13,"containerName":"get_all_Items","name":"$self","line":408,"definition":"my"},{"containerName":"get_all_Items","kind":13,"name":"$self","line":409},{"definition":"my","line":410,"localvar":"my","containerName":"get_all_Items","kind":13,"name":"$item"},{"name":"$self","kind":13,"containerName":"get_all_Items","line":410},{"line":410,"kind":12,"containerName":"get_all_Items","name":"get_Items"},{"line":411,"name":"$self","containerName":"get_all_Items","kind":13},{"line":411,"name":"$item","containerName":"get_all_Items","kind":13},{"definition":"my","name":"$ls","containerName":"get_all_Items","localvar":"my","kind":13,"line":412},{"name":"$item","kind":13,"containerName":"get_all_Items","line":412},{"containerName":"get_all_Items","kind":12,"name":"get_ListItems","line":412},{"line":413,"kind":13,"containerName":"get_all_Items","name":"$self"},{"kind":13,"containerName":"get_all_Items","name":"$ls","line":413},{"line":414,"name":"$st","kind":13,"localvar":"my","containerName":"get_all_Items","definition":"my"},{"containerName":"get_all_Items","kind":13,"name":"$ls","line":414},{"kind":12,"containerName":"get_all_Items","name":"get_StructureItems","line":414},{"containerName":"get_all_Items","kind":13,"name":"$self","line":415},{"kind":13,"containerName":"get_all_Items","name":"$st","line":415}],"definition":"sub"},{"line":420,"name":"%self","kind":13,"containerName":null},{"line":433,"range":{"start":{"line":433,"character":0},"end":{"character":9999,"line":439}},"kind":12,"signature":{"label":"get_all_names($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        #my @items = $self->get_Items;\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none"},"children":[{"kind":13,"localvar":"my","containerName":"get_all_names","name":"$self","line":434,"definition":"my"},{"definition":"my","kind":13,"localvar":"my","containerName":"get_all_names","name":"%tmp","line":435},{"definition":"my","name":"@data","containerName":"get_all_names","localvar":"my","kind":13,"line":436},{"kind":13,"containerName":"get_all_names","name":"$tmp","line":436},{"line":437,"name":"get_name","kind":12,"containerName":"get_all_names"},{"line":437,"containerName":"get_all_names","kind":13,"name":"$self"},{"name":"get_all_Items","kind":12,"containerName":"get_all_names","line":437},{"name":"@data","containerName":"get_all_names","kind":13,"line":438}],"containerName":"main::","name":"get_all_names","definition":"sub","detail":"($self)"},{"detail":"($self,$key)","definition":"sub","name":"get_Items_by_name","containerName":"main::","children":[{"definition":"my","line":452,"name":"$self","localvar":"my","kind":13,"containerName":"get_Items_by_name"},{"line":452,"name":"$key","kind":13,"containerName":"get_Items_by_name"},{"name":"$key","kind":13,"containerName":"get_Items_by_name","line":453},{"name":"@data","containerName":"get_Items_by_name","localvar":"my","kind":13,"line":454,"definition":"my"},{"line":454,"containerName":"get_Items_by_name","kind":12,"name":"get_name"},{"line":454,"name":"$key","kind":13,"containerName":"get_Items_by_name"},{"line":455,"containerName":"get_Items_by_name","kind":13,"name":"$self"},{"line":455,"containerName":"get_Items_by_name","kind":12,"name":"get_all_Items"},{"line":456,"containerName":"get_Items_by_name","kind":13,"name":"@data"}],"signature":{"parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        #my @items = $self->get_Items;\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\nsub get_all_names {\n    my ($self) = @_;\n    my %tmp;\n    my @data = grep {!$tmp{$_}++}\n        map {$_->get_name} $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)","label":"get_Items_by_name($self,$key)"},"kind":12,"range":{"end":{"line":457,"character":9999},"start":{"line":451,"character":0}},"line":451},{"children":[{"kind":13,"localvar":"my","containerName":"get_contents_by_name","name":"$self","line":471,"definition":"my"},{"line":471,"kind":13,"containerName":"get_contents_by_name","name":"$key"},{"line":472,"name":"$key","containerName":"get_contents_by_name","kind":13},{"name":"@data","containerName":"get_contents_by_name","localvar":"my","kind":13,"line":473,"definition":"my"},{"name":"get_content","kind":12,"containerName":"get_contents_by_name","line":473},{"line":474,"kind":12,"containerName":"get_contents_by_name","name":"get_name"},{"containerName":"get_contents_by_name","kind":13,"name":"$key","line":474},{"line":475,"name":"$self","containerName":"get_contents_by_name","kind":13},{"line":475,"containerName":"get_contents_by_name","kind":12,"name":"get_all_Items"},{"kind":13,"containerName":"get_contents_by_name","name":"@data","line":476}],"containerName":"main::","name":"get_contents_by_name","definition":"sub","detail":"($self,$key)","line":470,"kind":12,"range":{"end":{"character":9999,"line":477},"start":{"line":470,"character":0}},"signature":{"label":"get_contents_by_name($self,$key)","parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        #my @items = $self->get_Items;\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\nsub get_all_names {\n    my ($self) = @_;\n    my %tmp;\n    my @data = grep {!$tmp{$_}++}\n        map {$_->get_name} $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)\n\n\nsub get_Items_by_name {\n    my ($self, $key) = @_;\n    return unless $key;\n    my @data = grep {$_->get_name eq $key}\n        $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_contents_by_name\n\n Title    : get_contents_by_name\n Usage    : my ($data) = get_contents_by_name('CreateDate')\n Function : Returns content for named Item(s) in DocSum (indicated by\n            passed argument)\n Returns  : array of values (type varies per Item)\n Args     : string (Item name)"}},{"range":{"end":{"line":495,"character":9999},"start":{"line":490,"character":0}},"kind":12,"line":490,"signature":{"label":"get_type_by_name($self,$key)","documentation":"1;\n# $Id: Item.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::EUtilities::Summary::Item\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Chris Fields\n#\n# Copyright Chris Fields\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n#\n# Part of the EUtilities BioPerl package\n\n=head1 NAME\n\nBio::Tools::EUtilities::Summary::Item - simple layered object for DocSum item data\n\n=head1 SYNOPSIS\n\n  # Items can be nested up to three levels at this time. These levels can be\n  # accessed via Item, ListItem, or StructureItem methods:\n\n  while (my $item = $docsum->next_Item) {\n     print \"Name: \",$item->get_name,\"\\n\";\n     print \"Data: \",$item->get_content,\"\\n\";\n     print \"Type: \",$item->get_type,\"\\n\";\n     while (my $ls = $item->next_ListItem) {\n        # do same here\n        while (my $struct = $ls->next_StructureItem) {\n           # do more stuff here\n        }\n     }\n  }\n\n\n=head1 DESCRIPTION\n\nDocSum data, as returned from esummary, normally is a simple list of\nitem-content-content_type groups. However, items can also contain nested data to\nrepresent more complex data (such as structural data). Up to three nested layers\nmay appear in any document summary.\n\nThis class contains methods to access data that can appear in a docsum for any\nindividual item as well as describes methods to traverse the hierarchy of items\npresent in a document summary.\n\nThe unique name for items are accessed via get_name(), the content by\nget_content() (if present), and the data type by get_type(). Items can have\nListItems (Item objects with a datatype() 'list'), which in turn can have\nStructureItems (Item objects with a datatype of 'structure'). Items are\ninitially traversed via a DocSum object using next_Item() or obtained all at\nonce with get_Items(). Similarly, nested Items can be accessed by using\nnext_ListItem/get_ListItems and next_StructureItem/get_StructureItem.  A\nflattened list of items can be accessed with get_all_Items().\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the\nevolution of this and other Bioperl modules. Send\nyour comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation\nis much appreciated.\n\n  bioperl-l@lists.open-bio.org               - General discussion\n  http://www.bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to\nhelp us keep track the bugs and their resolution.\nBug reports can be submitted via the web.\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR Chris Fields\n\nEmail cjfields at bioperl dot org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the\nobject methods. Internal methods are usually\npreceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::EUtilities::Summary::Item;\nuse strict;\nuse warnings;\n\nuse base qw(Bio::Root::Root Bio::Tools::EUtilities::EUtilDataI);\n\n=head2 new\n\n Title    : new\n Usage    : \n Function : \n Returns  : \n Args     : \n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    my ($type) = $self->_rearrange(['DATATYPE'],@args);\n    $type ||= 'item';\n    $self->datatype($type);\n    $self->eutil('esummary');\n    $self->rewind('recursive');\n    return $self;\n}\n\n=head2 get_ids\n\n Title    : get_ids\n Usage    : my ($id) = $item->get_ids;\n Function : returns array or array ref with id\n Returns  : array or array ref\n Args     : none\n Note     : the behavior of this method is to remain consistent with other \n            implementations of get_ids(). To retrieve the single DocSum ID use\n            get_id()\n\n\nsub get_ids {\n    my $self = shift;\n    return ($self->{'_id'});\n}\n\n=head2 get_id\n\n Title    : get_id\n Usage    : my ($id) = $item->get_id;\n Function : returns UID of record\n Returns  : integer\n Args     : none\n\n\nsub get_id {\n    my $self = shift;\n    return $self->{'_id'};\n}\n\n=head2 next_ListItem\n\n Title    : next_ListItem\n Usage    : while (my $ls = $item->next_ListItem) {...}\n Function : iterates through ListItems (nested layer of Item)\n Returns  : single ListItem\n Args     : none\n\n\nsub next_ListItem {\n    my $self = shift;\n    unless ($self->{'_lists_it'}) {\n        my @lists = $self->get_ListItems;\n        # reset the structure iterator (required!)\n        delete $self->{'_structures_it'} if $self->{'_structures_it'};\n        $self->{'_lists_it'} = sub {return shift @lists}\n    }        \n    return $self->{'_lists_it'}->();\n}\n\n=head2 get_ListItems\n\n Title    : get_ListItems\n Usage    : my @ls = $item->get_ListItems\n Function : returns list of, well, List Items\n Returns  : array of List Items\n Args     : none\n\n\nsub get_ListItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'List' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_StructureItem\n\n Title    : next_StructureItem\n Usage    : while (my $struc = $ls->next_StructureItem) {...}\n Function : iterates through StructureItems (nested layer of ListItem)\n Returns  : single StructureItems\n Args     : none\n\n\nsub next_StructureItem {\n    my $self = shift;\n    unless ($self->{'_structures_it'}) {\n        my @structs = $self->get_StructureItems;\n        $self->{'_structures_it'} = sub {return shift @structs}\n    }\n    return $self->{'_structures_it'}->();\n}\n\n=head2 get_StructureItems\n\n Title    : get_StructureItems\n Usage    : my @structs = $ls->get_StructureItems\n Function : returns list of Structure Items\n Returns  : array of StructureItems\n Args     : none\n\n\nsub get_StructureItems {\n    my $self = shift;\n    my @items = $self->get_type eq 'Structure' ? $self->get_subItems : ();\n    return @items;\n}\n\n=head2 next_subItem\n\n Title    : next_subItem\n Usage    : while (my $it = $ls->next_subItem) {...}\n Function : iterates through the next layer of Items\n Returns  : single Item\n Args     : none\n Notes    : unlike next_ListItem and next_StructureItem, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub next_subItem {\n    my $self = shift;\n    unless ($self->{'_subitem_it'}) {\n        my @structs = $self->get_subItems;\n        $self->{'_subitem_it'} = sub {return shift @structs}\n    }\n    return $self->{'_subitem_it'}->();\n}\n\n=head2 get_subItems\n\n Title    : get_subItems\n Usage    : my @items = $ls->get_subItems\n Function : returns list of sub Items\n Returns  : array of Items\n Args     : none\n Notes    : unlike get_ListItems and get_StructureItems, this generically\n            accesses any sub Items (useful for recursive calls, for example)\n\n\nsub get_subItems {\n    my $self = shift;\n    ref $self->{'_items'}  ? return @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_name\n\n Title    : get_name\n Usage    : my $nm = $ls->get_name\n Function : retrieves Item/ListItem/StructureItem name for this Item\n Returns  : string\n Args     : none\n\n\nsub get_name {\n    my $self = shift;\n    return $self->{'_itemname'};\n}\n\n=head2 get_type\n\n Title    : get_type\n Usage    : my $type = $ls->get_type\n Function : retrieves Item/ListItem/StructureItem type \n Returns  : string\n Args     : none\n Note     : this is not the same as the datatype(), which describes the\n            group this Item object belongs to\n\n\nsub get_type {\n    my $self = shift;\n    return $self->{'_itemtype'};\n}\n\n=head2 get_content\n\n Title    : get_content\n Usage    : my $data = $ls->get_content\n Function : retrieves Item/ListItem/StructureItem content (if any)\n Returns  : string\n Args     : none\n\n\nsub get_content {\n    my $self = shift;\n    return $self->{'_itemcontent'};    \n}\n\n=head2 rewind\n\n Title    : rewind\n Usage    : $item->rewind()\n Function : rewinds iterators\n Returns  : none\n Args     : [optional] No arg - only rewinds current layer\n           'all' - rewind all DocSum object layers\n                (Items, ListItems, StructureItems)\n\n\nsub rewind {\n    my ($self, $request) = @_;\n    if ($request && $request eq 'all') {\n        map {$_->rewind()} $self->get_ListItems;\n    }\n    delete $self->{\"_lists_it\"} if $self->{\"_lists_it\"};\n    delete $self->{\"_structures_it\"} if $self->{\"_structures_it\"};\n}\n\n=head1 ItemContainerI methods\n\n\n=head2 next_Item\n\n Title    : next_Item\n Usage    : while (my $item = $docsum->next_Item) {...}\n Function : iterates through Items (nested layer of Item)\n Returns  : single Item\n Args     : [optional] single arg (string)\n            'flatten' - iterates through a flattened list ala\n                          get_all_DocSum_Items()\n\n\nsub next_Item {\n    my ($self, $request) = @_;\n    unless ($self->{\"_items_it\"}) {\n        #my @items = $self->get_Items;\n        my @items = ($request && $request eq 'flatten') ?\n                    $self->get_all_Items :\n                    $self->get_Items ;\n        $self->{\"_items_it\"} = sub {return shift @items}\n    }\n    $self->{'_items_it'}->();\n}\n\n=head2 get_Items\n\n Title    : get_Items\n Usage    : my @items = $docsum->get_Items\n Function : returns list of, well, Items\n Returns  : array of Items\n Args     : none\n\n\nsub get_Items {\n    my $self = shift;\n    return ref $self->{'_items'} ? @{ $self->{'_items'} } : return ();\n}\n\n=head2 get_all_Items\n\n Title    : get_all_Items\n Usage    : my @items = $docsum->get_all_Items\n Function : returns flattened list of all Item objects (Items, ListItems,\n            StructureItems)\n Returns  : array of Items\n Args     : none\n Note     : items are added top-down (similar order to using nested calls)\n            in original list order.\n\n             1         2        7        8\n           Item  -   Item  -  Item  -  Item ...\n                     |\n                    | 3        6\n                 ListItem - ListItem\n                   |\n                  | 4          5\n               Structure - Structure\n\n\nsub get_all_Items {\n    my $self = shift;\n    unless ($self->{'_ordered_items'}) {\n        for my $item ($self->get_Items) {\n            push @{$self->{'_ordered_items'}}, $item;\n            for my $ls ($item->get_ListItems) {\n                push @{$self->{'_ordered_items'}}, $ls;\n                for my $st ($ls->get_StructureItems) {\n                    push @{$self->{'_ordered_items'}}, $st;                \n                } \n            }\n        }\n    }\n    return @{$self->{'_ordered_items'}};\n}\n\n=head2 get_all_names\n\n Title    : get_all_names\n Usage    : my @names = get_all_names()\n Function : Returns an array of names for all Item(s) in DocSum.\n Returns  : array of unique strings\n Args     : none\n\n\nsub get_all_names {\n    my ($self) = @_;\n    my %tmp;\n    my @data = grep {!$tmp{$_}++}\n        map {$_->get_name} $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_Items_by_name\n\n Title    : get_Items_by_name\n Usage    : my @items = get_Items_by_name('CreateDate')\n Function : Returns named Item(s) in DocSum (indicated by passed argument)\n Returns  : array of Item objects\n Args     : string (Item name)\n\n\nsub get_Items_by_name {\n    my ($self, $key) = @_;\n    return unless $key;\n    my @data = grep {$_->get_name eq $key}\n        $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_contents_by_name\n\n Title    : get_contents_by_name\n Usage    : my ($data) = get_contents_by_name('CreateDate')\n Function : Returns content for named Item(s) in DocSum (indicated by\n            passed argument)\n Returns  : array of values (type varies per Item)\n Args     : string (Item name)\n\n\nsub get_contents_by_name {\n    my ($self, $key) = @_;\n    return unless $key;\n    my @data = map {$_->get_content} \n        grep {$_->get_name eq $key}\n        $self->get_all_Items;\n    return @data;\n}\n\n=head2 get_type_by_name\n\n Title    : get_type_by_name\n Usage    : my $data = get_type_by_name('CreateDate')\n Function : Returns data type for named Item in DocSum (indicated by\n            passed argument)\n Returns  : scalar value (string) if present\n Args     : string (Item name)","parameters":[{"label":"$self"},{"label":"$key"}]},"name":"get_type_by_name","containerName":"main::","children":[{"definition":"my","line":491,"localvar":"my","containerName":"get_type_by_name","kind":13,"name":"$self"},{"name":"$key","containerName":"get_type_by_name","kind":13,"line":491},{"kind":13,"containerName":"get_type_by_name","name":"$key","line":492},{"definition":"my","name":"$it","containerName":"get_type_by_name","localvar":"my","kind":13,"line":493},{"line":493,"name":"get_name","containerName":"get_type_by_name","kind":12},{"name":"$key","kind":13,"containerName":"get_type_by_name","line":493},{"name":"$self","containerName":"get_type_by_name","kind":13,"line":493},{"line":493,"kind":12,"containerName":"get_type_by_name","name":"get_all_Items"},{"line":494,"name":"$it","containerName":"get_type_by_name","kind":13},{"name":"get_type","containerName":"get_type_by_name","kind":12,"line":494}],"detail":"($self,$key)","definition":"sub"},{"detail":"($self,$data)","definition":"sub","name":"_add_data","containerName":"main::","children":[{"localvar":"my","containerName":"_add_data","kind":13,"name":"$self","line":500,"definition":"my"},{"line":500,"kind":13,"containerName":"_add_data","name":"$data"},{"line":501,"containerName":"_add_data","kind":13,"name":"$data"},{"line":502,"name":"$objtype","localvar":"my","kind":13,"containerName":"_add_data","definition":"my"},{"containerName":"_add_data","kind":13,"name":"$data","line":502},{"kind":13,"containerName":"_add_data","name":"$self","line":503},{"line":503,"kind":13,"containerName":"_add_data","name":"$data"},{"containerName":"_add_data","kind":13,"name":"$data","line":503},{"definition":"my","containerName":"_add_data","localvar":"my","kind":13,"name":"$sd","line":504},{"line":504,"name":"$data","containerName":"_add_data","kind":13},{"name":"$sd","containerName":"_add_data","kind":13,"line":505},{"line":505,"containerName":"_add_data","kind":13,"name":"$data"},{"line":505,"kind":13,"containerName":"_add_data","name":"$data"},{"definition":"my","name":"$subdoc","containerName":"_add_data","localvar":"my","kind":13,"line":506},{"line":506,"name":"new","containerName":"_add_data","kind":12},{"name":"$objtype","containerName":"_add_data","kind":13,"line":507},{"line":508,"name":"$self","containerName":"_add_data","kind":13},{"containerName":"_add_data","kind":12,"name":"verbose","line":508},{"line":509,"containerName":"_add_data","kind":13,"name":"$subdoc"},{"containerName":"_add_data","kind":12,"name":"_add_data","line":509},{"line":509,"name":"$sd","kind":13,"containerName":"_add_data"},{"name":"$self","containerName":"_add_data","kind":13,"line":510},{"name":"$subdoc","containerName":"_add_data","kind":13,"line":510}],"signature":{"documentation":" private data method","parameters":[{"label":"$self"},{"label":"$data"}],"label":"_add_data($self,$data)"},"kind":12,"range":{"end":{"line":511,"character":9999},"start":{"character":0,"line":499}},"line":499},{"kind":12,"name":"Item","line":501},{"line":502,"name":"Type","kind":12},{"kind":12,"name":"Id","line":503},{"name":"Id","kind":12,"line":503},{"line":504,"name":"Item","kind":12},{"line":505,"name":"Id","kind":12},{"name":"Id","kind":12,"line":505},{"line":505,"name":"Id","kind":12},{"kind":12,"containerName":"Tools::EUtilities::Summary::Item","name":"Bio","line":506},{"line":513,"name":"%nm","kind":13,"localvar":"my","containerName":null,"definition":"my"},{"line":514,"name":"%self","kind":13,"containerName":null},{"containerName":null,"kind":13,"name":"$nm","line":514},{"kind":13,"containerName":null,"name":"%data","line":514},{"line":514,"kind":13,"containerName":null,"name":"$nm"},{"name":"%data","kind":13,"containerName":null,"line":514},{"kind":13,"containerName":null,"name":"$nm","line":514},{"line":516,"name":"%self","kind":13,"containerName":null},{"line":516,"name":"%data","containerName":null,"kind":13},{"kind":12,"name":"Id","line":516},{"kind":13,"containerName":null,"name":"%data","line":516},{"name":"Id","kind":12,"line":516},{"definition":"sub","children":[{"line":534,"kind":13,"localvar":"my","containerName":"to_string","name":"$self","definition":"my"},{"line":535,"localvar":"my","kind":13,"containerName":"to_string","name":"$level","definition":"my"},{"definition":"my","localvar":"my","kind":13,"containerName":"to_string","name":"$pad","line":537},{"line":537,"name":"$level","kind":13,"containerName":"to_string"},{"line":538,"name":"$content","localvar":"my","containerName":"to_string","kind":13,"definition":"my"},{"kind":13,"containerName":"to_string","name":"$self","line":538},{"name":"get_content","containerName":"to_string","kind":12,"line":538},{"line":539,"name":"$string","localvar":"my","kind":13,"containerName":"to_string","definition":"my"},{"containerName":"to_string","kind":13,"name":"$level","line":540},{"name":"$pad","kind":13,"containerName":"to_string","line":541},{"name":"$self","containerName":"to_string","kind":13,"line":541},{"kind":12,"containerName":"to_string","name":"get_name","line":541},{"name":"$self","containerName":"to_string","kind":13,"line":542},{"line":542,"name":"_text_wrap","kind":12,"containerName":"to_string"},{"name":"$pad","containerName":"to_string","kind":13,"line":543},{"line":544,"name":"$content","kind":13,"containerName":"to_string"},{"line":545,"localvar":"my","containerName":"to_string","kind":13,"name":"$sub","definition":"my"},{"name":"$self","kind":13,"containerName":"to_string","line":545},{"containerName":"to_string","kind":12,"name":"get_subItems","line":545},{"line":546,"kind":13,"containerName":"to_string","name":"$string"},{"name":"$sub","containerName":"to_string","kind":13,"line":546},{"kind":12,"containerName":"to_string","name":"to_string","line":546},{"line":546,"containerName":"to_string","kind":13,"name":"$level"},{"name":"$string","containerName":"to_string","kind":13,"line":548}],"name":"to_string","containerName":"main::","line":533,"kind":12,"range":{"end":{"line":549,"character":9999},"start":{"line":533,"character":0}}}],"version":5}