{"vars":[{"kind":2,"containerName":"","name":"vars","line":147},{"line":154,"name":"base","containerName":"","kind":2},{"kind":13,"localvar":"my","containerName":null,"name":"$i","line":156,"definition":"my"},{"line":157,"localvar":"my","kind":13,"containerName":null,"name":"%GFF3_ID_Tags","definition":"my"},{"name":"%i","containerName":null,"kind":13,"line":157},{"definition":"my","name":"$gff3_featureID","kind":13,"localvar":"my","containerName":null,"line":180},{"children":[{"name":"$self","containerName":"_incrementGFF3ID","localvar":"my","kind":13,"line":183,"definition":"my"},{"containerName":"_incrementGFF3ID","kind":13,"name":"$gff3_featureID","line":184}],"containerName":"main::","name":"_incrementGFF3ID","definition":"sub","detail":"($self)","line":182,"kind":12,"range":{"start":{"character":0,"line":182},"end":{"character":9999,"line":185}},"signature":{"label":"_incrementGFF3ID($self)","parameters":[{"label":"$self"}],"documentation":""}},{"definition":"sub","detail":"($class,@args)","children":[{"definition":"my","line":190,"name":"$class","localvar":"my","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"@args","line":190},{"containerName":"new","localvar":"my","kind":13,"name":"$self","line":191,"definition":"my"},{"line":191,"kind":13,"containerName":"new","name":"$class"},{"line":191,"containerName":"new","kind":13,"name":"@args"},{"name":"$gff_version","containerName":"new","localvar":"my","kind":13,"line":193,"definition":"my"},{"name":"$noparse","containerName":"new","kind":13,"line":193},{"line":193,"name":"$self","kind":13,"containerName":"new"},{"line":193,"containerName":"new","kind":12,"name":"_rearrange"},{"line":193,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","kind":13,"name":"$self","line":196},{"line":196,"name":"_initialize_io","containerName":"new","kind":12},{"line":196,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":197},{"name":"_parse_header","containerName":"new","kind":12,"line":197},{"name":"$noparse","containerName":"new","kind":13,"line":197},{"line":199,"name":"$gff_version","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$self","line":200},{"line":200,"name":"gff_version","kind":12,"containerName":"new"},{"line":200,"kind":13,"containerName":"new","name":"$gff_version"},{"line":201,"name":"$self","containerName":"new","kind":13},{"line":201,"name":"throw","containerName":"new","kind":12},{"line":202,"name":"$gff_version","containerName":"new","kind":13},{"line":204,"name":"$self","kind":13,"containerName":"new"},{"kind":13,"containerName":"new","name":"$self","line":205}],"containerName":"main::","name":"new","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"},"line":189,"kind":12,"range":{"start":{"character":0,"line":189},"end":{"character":9999,"line":206}}},{"line":191,"name":"SUPER","kind":12,"containerName":"new"},{"line":221,"range":{"end":{"character":9999,"line":277},"start":{"character":0,"line":221}},"kind":12,"signature":{"label":"_parse_header($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none"},"children":[{"line":222,"name":"$self","containerName":"_parse_header","localvar":"my","kind":13,"definition":"my"},{"line":224,"localvar":"my","kind":13,"containerName":"_parse_header","name":"@unhandled","definition":"my"},{"definition":"my","line":228,"kind":13,"localvar":"my","containerName":"_parse_header","name":"$line"},{"line":228,"containerName":"_parse_header","kind":13,"name":"$self"},{"line":228,"kind":12,"containerName":"_parse_header","name":"_readline"},{"line":229,"containerName":"_parse_header","localvar":"my","kind":13,"name":"$handled","definition":"my"},{"line":231,"name":"$line","containerName":"_parse_header","kind":13},{"definition":"my","name":"$seqid","containerName":"_parse_header","localvar":"my","kind":13,"line":232},{"kind":13,"containerName":"_parse_header","name":"$start","line":232},{"line":232,"kind":13,"containerName":"_parse_header","name":"$end"},{"line":233,"name":"$self","kind":13,"containerName":"_parse_header"},{"containerName":"_parse_header","kind":12,"name":"new","line":234},{"name":"$seqid","containerName":"_parse_header","kind":13,"line":235},{"line":236,"name":"$start","containerName":"_parse_header","kind":13},{"containerName":"_parse_header","kind":13,"name":"$end","line":237},{"line":238,"containerName":"_parse_header","kind":13,"name":"$end"},{"line":238,"kind":13,"containerName":"_parse_header","name":"$start"},{"line":240,"name":"$handled","kind":13,"containerName":"_parse_header"},{"line":241,"containerName":"_parse_header","kind":13,"name":"$line"},{"line":243,"name":"$self","kind":13,"containerName":"_parse_header"},{"line":243,"kind":12,"containerName":"_parse_header","name":"warn"},{"name":"$line","containerName":"_parse_header","kind":13,"line":244},{"name":"$self","kind":13,"containerName":"_parse_header","line":246},{"line":246,"containerName":"_parse_header","kind":12,"name":"warn"},{"kind":13,"containerName":"_parse_header","name":"$line","line":247},{"line":249,"kind":13,"containerName":"_parse_header","name":"$self"},{"name":"warn","kind":12,"containerName":"_parse_header","line":249},{"line":250,"containerName":"_parse_header","kind":13,"name":"$line"},{"line":252,"kind":13,"containerName":"_parse_header","name":"$self"},{"line":252,"name":"warn","containerName":"_parse_header","kind":12},{"line":253,"name":"$line","kind":13,"containerName":"_parse_header"},{"containerName":"_parse_header","kind":13,"name":"$line","line":255},{"kind":13,"containerName":"_parse_header","name":"$self","line":255},{"line":255,"containerName":"_parse_header","kind":12,"name":"_readline"},{"line":256,"name":"$line","containerName":"_parse_header","kind":13},{"line":257,"name":"$self","containerName":"_parse_header","kind":13},{"containerName":"_parse_header","kind":12,"name":"throw","line":257},{"line":262,"containerName":"_parse_header","kind":13,"name":"$line"},{"definition":"my","name":"$seq","containerName":"_parse_header","localvar":"my","kind":13,"line":264},{"line":264,"name":"$self","kind":13,"containerName":"_parse_header"},{"name":"_parse_sequence","kind":12,"containerName":"_parse_header","line":264},{"line":264,"kind":13,"containerName":"_parse_header","name":"$line"},{"line":265,"kind":13,"containerName":"_parse_header","name":"$seq"},{"containerName":"_parse_header","kind":13,"name":"$self","line":266},{"line":266,"name":"_seq_by_id_h","kind":12,"containerName":"_parse_header"},{"name":"$seq","kind":13,"containerName":"_parse_header","line":266},{"containerName":"_parse_header","kind":12,"name":"primary_id","line":266},{"containerName":"_parse_header","kind":13,"name":"$seq","line":266},{"line":271,"containerName":"_parse_header","kind":13,"name":"$handled"},{"line":272,"containerName":"_parse_header","kind":13,"name":"@unhandled"},{"kind":13,"containerName":"_parse_header","name":"$line","line":273},{"line":276,"name":"$line","containerName":"_parse_header","kind":13}],"name":"_parse_header","containerName":"main::","definition":"sub","detail":"($self)"},{"line":233,"kind":12,"containerName":"LocatableSeq","name":"Bio"},{"name":"unescape","kind":12,"line":235},{"line":279,"containerName":null,"localvar":"my","kind":13,"name":"$line","definition":"my"},{"kind":13,"containerName":null,"name":"@unhandled","line":279},{"line":280,"containerName":null,"kind":13,"name":"$self"},{"name":"_pushback","kind":12,"containerName":"main::","line":280},{"name":"$line","kind":13,"containerName":null,"line":280},{"definition":"sub","detail":"($self,$line)","children":[{"definition":"my","line":287,"name":"$self","containerName":"_parse_sequence","localvar":"my","kind":13},{"line":287,"name":"$line","kind":13,"containerName":"_parse_sequence"},{"line":289,"containerName":"_parse_sequence","kind":13,"name":"$line"},{"name":"$seqid","containerName":"_parse_sequence","localvar":"my","kind":13,"line":291,"definition":"my"},{"line":292,"name":"$seqid","kind":13,"containerName":"_parse_sequence"},{"name":"$desc","kind":13,"localvar":"my","containerName":"_parse_sequence","line":293,"definition":"my"},{"line":294,"name":"$seqid","kind":13,"containerName":"_parse_sequence"},{"containerName":"_parse_sequence","kind":13,"name":"$seqid","line":295},{"name":"$desc","containerName":"_parse_sequence","kind":13,"line":295},{"definition":"my","line":297,"localvar":"my","containerName":"_parse_sequence","kind":13,"name":"$res"},{"line":298,"name":"$line","containerName":"_parse_sequence","localvar":"my","kind":13,"definition":"my"},{"line":298,"kind":13,"containerName":"_parse_sequence","name":"$self"},{"line":298,"name":"_readline","containerName":"_parse_sequence","kind":12},{"line":299,"name":"$line","kind":13,"containerName":"_parse_sequence"},{"kind":13,"containerName":"_parse_sequence","name":"$line","line":302},{"line":303,"containerName":"_parse_sequence","kind":13,"name":"$self"},{"name":"_pushback","kind":12,"containerName":"_parse_sequence","line":303},{"line":303,"name":"$line","containerName":"_parse_sequence","kind":13},{"name":"$line","kind":13,"containerName":"_parse_sequence","line":306},{"name":"$res","kind":13,"containerName":"_parse_sequence","line":307},{"kind":13,"containerName":"_parse_sequence","name":"$line","line":307},{"name":"$self","containerName":"_parse_sequence","kind":13,"line":309},{"kind":12,"containerName":"_parse_sequence","name":"ignore_sequence","line":309},{"name":"$seqfactory","containerName":"_parse_sequence","localvar":"my","kind":13,"line":311,"definition":"my"},{"name":"new","kind":12,"containerName":"_parse_sequence","line":311},{"definition":"my","line":312,"kind":13,"localvar":"my","containerName":"_parse_sequence","name":"$seq"},{"line":312,"kind":13,"containerName":"_parse_sequence","name":"$seqfactory"},{"kind":12,"containerName":"_parse_sequence","name":"create","line":312},{"line":312,"name":"$res","containerName":"_parse_sequence","kind":13},{"name":"$seqid","containerName":"_parse_sequence","kind":13,"line":313},{"name":"$desc","containerName":"_parse_sequence","kind":13,"line":314},{"line":315,"name":"$seq","kind":13,"containerName":"_parse_sequence"},{"name":"accession_number","kind":12,"containerName":"_parse_sequence","line":315},{"kind":13,"containerName":"_parse_sequence","name":"$seqid","line":315},{"name":"$self","containerName":"_parse_sequence","kind":13,"line":316},{"line":316,"name":"features_attached_to_seqs","kind":12,"containerName":"_parse_sequence"},{"definition":"my","line":317,"localvar":"my","containerName":"_parse_sequence","kind":13,"name":"@feats"},{"line":318,"containerName":"_parse_sequence","kind":13,"name":"$self"},{"containerName":"_parse_sequence","kind":12,"name":"_feature_idx_by_seq_id","line":318},{"line":318,"name":"$seqid","containerName":"_parse_sequence","kind":13},{"kind":13,"containerName":"_parse_sequence","name":"$seq","line":319},{"name":"add_SeqFeature","kind":12,"containerName":"_parse_sequence","line":319},{"name":"@feats","kind":13,"containerName":"_parse_sequence","line":319},{"line":320,"name":"$self","kind":13,"containerName":"_parse_sequence"},{"kind":12,"containerName":"_parse_sequence","name":"_feature_idx_by_seq_id","line":320},{"line":320,"kind":13,"containerName":"_parse_sequence","name":"$seqid"}],"name":"_parse_sequence","containerName":"main::","signature":{"label":"_parse_sequence($self,$line)","documentation":"","parameters":[{"label":"$self"},{"label":"$line"}]},"line":286,"kind":12,"range":{"start":{"line":286,"character":0},"end":{"character":9999,"line":321}}},{"line":311,"name":"Bio","containerName":"Seq::SeqFactory","kind":12},{"line":322,"kind":13,"containerName":null,"name":"%seq"},{"line":325,"kind":13,"containerName":null,"name":"$self"},{"line":325,"name":"throw","kind":12,"containerName":"main::"},{"signature":{"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}],"label":"next_segment($self,@args)"},"line":344,"kind":12,"range":{"start":{"character":0,"line":344},"end":{"line":346,"character":9999}},"definition":"sub","detail":"($self,@args)","children":[{"name":"$self","localvar":"my","containerName":"next_segment","kind":13,"line":345,"definition":"my"},{"line":345,"containerName":"next_segment","kind":13,"name":"@args"},{"containerName":"next_segment","kind":13,"name":"$self","line":346}],"name":"next_segment","containerName":"main::"},{"containerName":null,"kind":13,"name":"%self","line":346},{"signature":{"label":"next_feature($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    "},"range":{"end":{"character":9999,"line":396},"start":{"character":0,"line":363}},"kind":12,"line":363,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_feature","children":[{"definition":"my","line":364,"name":"$self","kind":13,"localvar":"my","containerName":"next_feature"},{"definition":"my","name":"$gff_string","localvar":"my","containerName":"next_feature","kind":13,"line":366},{"kind":13,"containerName":"next_feature","name":"$gff_string","line":370},{"line":370,"name":"$self","kind":13,"containerName":"next_feature"},{"line":370,"containerName":"next_feature","kind":12,"name":"_readline"},{"line":370,"kind":13,"containerName":"next_feature","name":"$gff_string"},{"name":"$gff_string","kind":13,"containerName":"next_feature","line":371},{"line":374,"name":"$gff_string","containerName":"next_feature","kind":13},{"line":374,"name":"$gff_string","kind":13,"containerName":"next_feature"},{"line":375,"name":"$gff_string","containerName":"next_feature","kind":13},{"line":377,"name":"$gff_string","kind":13,"containerName":"next_feature"},{"line":379,"kind":13,"localvar":"my","containerName":"next_feature","name":"$seq","definition":"my"},{"line":379,"name":"$self","containerName":"next_feature","kind":13},{"line":379,"kind":12,"containerName":"next_feature","name":"_parse_sequence"},{"containerName":"next_feature","kind":13,"name":"$gff_string","line":379},{"name":"$seq","kind":13,"containerName":"next_feature","line":380},{"name":"$self","kind":13,"containerName":"next_feature","line":381},{"containerName":"next_feature","kind":12,"name":"_seq_by_id_h","line":381},{"line":381,"containerName":"next_feature","kind":13,"name":"$seq"},{"line":381,"name":"primary_id","containerName":"next_feature","kind":12},{"name":"$seq","kind":13,"containerName":"next_feature","line":381},{"name":"$gff_string","kind":13,"containerName":"next_feature","line":382},{"name":"$self","kind":13,"containerName":"next_feature","line":382},{"name":"_readline","containerName":"next_feature","kind":12,"line":382},{"name":"$gff_string","kind":13,"containerName":"next_feature","line":383},{"line":388,"containerName":"next_feature","kind":13,"name":"$gff_string"},{"containerName":"next_feature","localvar":"my","kind":13,"name":"$feat","line":390,"definition":"my"},{"name":"new","containerName":"next_feature","kind":12,"line":390},{"name":"$self","kind":13,"containerName":"next_feature","line":391},{"containerName":"next_feature","kind":12,"name":"from_gff_string","line":391},{"line":391,"containerName":"next_feature","kind":13,"name":"$feat"},{"containerName":"next_feature","kind":13,"name":"$gff_string","line":391},{"name":"$self","kind":13,"containerName":"next_feature","line":393},{"line":393,"name":"features_attached_to_seqs","containerName":"next_feature","kind":12},{"name":"$self","kind":13,"containerName":"next_feature","line":394},{"line":394,"kind":12,"containerName":"next_feature","name":"_feature_idx_by_seq_id"},{"containerName":"next_feature","kind":13,"name":"$feat","line":394},{"name":"seq_id","containerName":"next_feature","kind":12,"line":394},{"name":"$feat","kind":13,"containerName":"next_feature","line":395}]},{"containerName":"SeqFeature::Generic","kind":12,"name":"Bio","line":390},{"kind":13,"containerName":null,"name":"$feat","line":398},{"range":{"end":{"line":407,"character":9999},"start":{"character":0,"line":401}},"kind":12,"line":401,"definition":"sub","containerName":"main::","name":"_feature_idx_by_seq_id","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"_feature_idx_by_seq_id","name":"$self","line":402},{"name":"$self","kind":13,"containerName":"_feature_idx_by_seq_id","line":403},{"containerName":"_feature_idx_by_seq_id","kind":13,"name":"$self","line":404},{"line":405,"name":"$self","kind":13,"containerName":"_feature_idx_by_seq_id"},{"name":"$self","containerName":"_feature_idx_by_seq_id","kind":13,"line":406}]},{"line":403,"name":"__feature_idx_by_seq_id","kind":12},{"line":404,"name":"__feature_idx_by_seq_id","kind":12},{"line":405,"name":"__feature_idx_by_seq_id","kind":12},{"line":406,"kind":12,"name":"__feature_idx_by_seq_id"},{"detail":"($self,$feat,$gff_string)","definition":"sub","containerName":"main::","name":"from_gff_string","children":[{"name":"$self","localvar":"my","containerName":"from_gff_string","kind":13,"line":428,"definition":"my"},{"containerName":"from_gff_string","kind":13,"name":"$feat","line":428},{"name":"$gff_string","kind":13,"containerName":"from_gff_string","line":428},{"line":430,"containerName":"from_gff_string","kind":13,"name":"$self"},{"line":430,"name":"gff_version","containerName":"from_gff_string","kind":12},{"line":431,"name":"$self","kind":13,"containerName":"from_gff_string"},{"kind":12,"containerName":"from_gff_string","name":"_from_gff1_string","line":431},{"name":"$feat","containerName":"from_gff_string","kind":13,"line":431},{"line":431,"kind":13,"containerName":"from_gff_string","name":"$gff_string"},{"name":"$self","kind":13,"containerName":"from_gff_string","line":432},{"containerName":"from_gff_string","kind":12,"name":"gff_version","line":432},{"kind":13,"containerName":"from_gff_string","name":"$self","line":433},{"containerName":"from_gff_string","kind":12,"name":"_from_gff3_string","line":433},{"kind":13,"containerName":"from_gff_string","name":"$feat","line":433},{"line":433,"name":"$gff_string","kind":13,"containerName":"from_gff_string"},{"line":435,"name":"$self","kind":13,"containerName":"from_gff_string"},{"name":"_from_gff2_string","containerName":"from_gff_string","kind":12,"line":435},{"kind":13,"containerName":"from_gff_string","name":"$feat","line":435},{"line":435,"name":"$gff_string","containerName":"from_gff_string","kind":13}],"signature":{"label":"from_gff_string($self,$feat,$gff_string)","parameters":[{"label":"$self"},{"label":"$feat"},{"label":"$gff_string"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from"},"kind":12,"range":{"end":{"line":437,"character":9999},"start":{"line":427,"character":0}},"line":427},{"kind":12,"range":{"start":{"character":0,"line":451},"end":{"character":9999,"line":484}},"line":451,"signature":{"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from","parameters":[{"label":"$gff"},{"label":"$feat"},{"label":"$string"}],"label":"_from_gff1_string($gff,$feat,$string)"},"containerName":"main::","name":"_from_gff1_string","children":[{"definition":"my","line":452,"containerName":"_from_gff1_string","localvar":"my","kind":13,"name":"$gff"},{"line":452,"name":"$feat","containerName":"_from_gff1_string","kind":13},{"containerName":"_from_gff1_string","kind":13,"name":"$string","line":452},{"name":"$string","kind":13,"containerName":"_from_gff1_string","line":453},{"definition":"my","name":"$seqname","localvar":"my","containerName":"_from_gff1_string","kind":13,"line":454},{"line":454,"name":"$source","kind":13,"containerName":"_from_gff1_string"},{"kind":13,"containerName":"_from_gff1_string","name":"$primary","line":454},{"line":454,"kind":13,"containerName":"_from_gff1_string","name":"$start"},{"line":454,"containerName":"_from_gff1_string","kind":13,"name":"$end"},{"name":"$score","containerName":"_from_gff1_string","kind":13,"line":454},{"line":455,"name":"$strand","containerName":"_from_gff1_string","kind":13},{"line":455,"name":"$frame","containerName":"_from_gff1_string","kind":13},{"containerName":"_from_gff1_string","kind":13,"name":"@group","line":455},{"containerName":"_from_gff1_string","kind":13,"name":"$string","line":455},{"line":457,"name":"$frame","containerName":"_from_gff1_string","kind":13},{"name":"$feat","containerName":"_from_gff1_string","kind":13,"line":458},{"line":458,"kind":12,"containerName":"_from_gff1_string","name":"throw"},{"line":460,"name":"$frame","kind":13,"containerName":"_from_gff1_string"},{"name":"$frame","kind":13,"containerName":"_from_gff1_string","line":460},{"line":461,"containerName":"_from_gff1_string","kind":13,"name":"$feat"},{"kind":12,"containerName":"_from_gff1_string","name":"seq_id","line":461},{"name":"$seqname","kind":13,"containerName":"_from_gff1_string","line":461},{"line":462,"name":"$feat","kind":13,"containerName":"_from_gff1_string"},{"kind":12,"containerName":"_from_gff1_string","name":"source_tag","line":462},{"containerName":"_from_gff1_string","kind":13,"name":"$source","line":462},{"line":463,"kind":13,"containerName":"_from_gff1_string","name":"$feat"},{"containerName":"_from_gff1_string","kind":12,"name":"primary_tag","line":463},{"line":463,"containerName":"_from_gff1_string","kind":13,"name":"$primary"},{"kind":13,"containerName":"_from_gff1_string","name":"$feat","line":464},{"line":464,"name":"start","containerName":"_from_gff1_string","kind":12},{"line":464,"kind":13,"containerName":"_from_gff1_string","name":"$start"},{"line":465,"name":"$feat","kind":13,"containerName":"_from_gff1_string"},{"line":465,"kind":12,"containerName":"_from_gff1_string","name":"end"},{"line":465,"kind":13,"containerName":"_from_gff1_string","name":"$end"},{"line":466,"kind":13,"containerName":"_from_gff1_string","name":"$feat"},{"name":"frame","kind":12,"containerName":"_from_gff1_string","line":466},{"name":"$frame","containerName":"_from_gff1_string","kind":13,"line":466},{"line":467,"name":"$score","kind":13,"containerName":"_from_gff1_string"},{"line":470,"name":"$feat","containerName":"_from_gff1_string","kind":13},{"line":470,"name":"score","containerName":"_from_gff1_string","kind":12},{"containerName":"_from_gff1_string","kind":13,"name":"$score","line":470},{"line":472,"containerName":"_from_gff1_string","kind":13,"name":"$strand"},{"line":472,"containerName":"_from_gff1_string","kind":13,"name":"$feat"},{"name":"strand","kind":12,"containerName":"_from_gff1_string","line":472},{"line":473,"name":"$strand","containerName":"_from_gff1_string","kind":13},{"name":"$feat","containerName":"_from_gff1_string","kind":13,"line":473},{"line":473,"name":"strand","containerName":"_from_gff1_string","kind":12},{"name":"$strand","containerName":"_from_gff1_string","kind":13,"line":474},{"line":474,"kind":13,"containerName":"_from_gff1_string","name":"$feat"},{"name":"strand","containerName":"_from_gff1_string","kind":12,"line":474},{"line":475,"kind":13,"localvar":"my","containerName":"_from_gff1_string","name":"$g","definition":"my"},{"name":"@group","containerName":"_from_gff1_string","kind":13,"line":475},{"line":476,"containerName":"_from_gff1_string","kind":13,"name":"$g"},{"line":477,"name":"$tag","localvar":"my","kind":13,"containerName":"_from_gff1_string","definition":"my"},{"definition":"my","line":478,"name":"$value","containerName":"_from_gff1_string","localvar":"my","kind":13},{"line":479,"containerName":"_from_gff1_string","kind":13,"name":"$feat"},{"containerName":"_from_gff1_string","kind":12,"name":"add_tag_value","line":479},{"line":481,"kind":13,"containerName":"_from_gff1_string","name":"$feat"},{"containerName":"_from_gff1_string","kind":12,"name":"add_tag_value","line":481},{"kind":13,"containerName":"_from_gff1_string","name":"$g","line":481}],"detail":"($gff,$feat,$string)","definition":"sub"},{"definition":"sub","detail":"($gff,$feat,$string)","children":[{"line":500,"name":"$gff","kind":13,"localvar":"my","containerName":"_from_gff2_string","definition":"my"},{"line":500,"name":"$feat","containerName":"_from_gff2_string","kind":13},{"line":500,"containerName":"_from_gff2_string","kind":13,"name":"$string"},{"name":"$string","containerName":"_from_gff2_string","kind":13,"line":501},{"localvar":"my","containerName":"_from_gff2_string","kind":13,"name":"$seqname","line":513,"definition":"my"},{"line":513,"name":"$source","containerName":"_from_gff2_string","kind":13},{"line":513,"containerName":"_from_gff2_string","kind":13,"name":"$primary"},{"name":"$start","containerName":"_from_gff2_string","kind":13,"line":513},{"line":514,"containerName":"_from_gff2_string","kind":13,"name":"$end"},{"name":"$score","kind":13,"containerName":"_from_gff2_string","line":514},{"kind":13,"containerName":"_from_gff2_string","name":"$strand","line":514},{"line":514,"kind":13,"containerName":"_from_gff2_string","name":"$frame"},{"containerName":"_from_gff2_string","kind":13,"name":"@attribs","line":514},{"name":"$string","kind":13,"containerName":"_from_gff2_string","line":514},{"name":"$attribs","kind":13,"localvar":"my","containerName":"_from_gff2_string","line":515,"definition":"my"},{"line":515,"name":"@attribs","kind":13,"containerName":"_from_gff2_string"},{"line":517,"containerName":"_from_gff2_string","kind":13,"name":"$frame"},{"name":"$feat","kind":13,"containerName":"_from_gff2_string","line":518},{"name":"throw","containerName":"_from_gff2_string","kind":12,"line":518},{"containerName":"_from_gff2_string","kind":13,"name":"$feat","line":520},{"kind":12,"containerName":"_from_gff2_string","name":"seq_id","line":520},{"containerName":"_from_gff2_string","kind":13,"name":"$seqname","line":520},{"name":"$feat","kind":13,"containerName":"_from_gff2_string","line":521},{"kind":12,"containerName":"_from_gff2_string","name":"source_tag","line":521},{"name":"$source","kind":13,"containerName":"_from_gff2_string","line":521},{"line":522,"kind":13,"containerName":"_from_gff2_string","name":"$feat"},{"line":522,"kind":12,"containerName":"_from_gff2_string","name":"primary_tag"},{"line":522,"name":"$primary","kind":13,"containerName":"_from_gff2_string"},{"line":523,"name":"$feat","containerName":"_from_gff2_string","kind":13},{"line":523,"name":"start","kind":12,"containerName":"_from_gff2_string"},{"name":"$start","containerName":"_from_gff2_string","kind":13,"line":523},{"line":524,"kind":13,"containerName":"_from_gff2_string","name":"$feat"},{"line":524,"containerName":"_from_gff2_string","kind":12,"name":"end"},{"line":524,"name":"$end","kind":13,"containerName":"_from_gff2_string"},{"line":525,"containerName":"_from_gff2_string","kind":13,"name":"$feat"},{"name":"frame","containerName":"_from_gff2_string","kind":12,"line":525},{"containerName":"_from_gff2_string","kind":13,"name":"$frame","line":525},{"containerName":"_from_gff2_string","kind":13,"name":"$score","line":526},{"kind":13,"containerName":"_from_gff2_string","name":"$feat","line":529},{"line":529,"kind":12,"containerName":"_from_gff2_string","name":"score"},{"name":"$score","kind":13,"containerName":"_from_gff2_string","line":529},{"kind":13,"containerName":"_from_gff2_string","name":"$strand","line":531},{"name":"$feat","kind":13,"containerName":"_from_gff2_string","line":531},{"line":531,"containerName":"_from_gff2_string","kind":12,"name":"strand"},{"kind":13,"containerName":"_from_gff2_string","name":"$strand","line":532},{"line":532,"kind":13,"containerName":"_from_gff2_string","name":"$feat"},{"line":532,"name":"strand","kind":12,"containerName":"_from_gff2_string"},{"line":533,"name":"$strand","kind":13,"containerName":"_from_gff2_string"},{"name":"$feat","containerName":"_from_gff2_string","kind":13,"line":533},{"line":533,"kind":12,"containerName":"_from_gff2_string","name":"strand"},{"name":"$flag","localvar":"my","containerName":"_from_gff2_string","kind":13,"line":545,"definition":"my"},{"definition":"my","name":"@parsed","containerName":"_from_gff2_string","localvar":"my","kind":13,"line":546},{"definition":"my","line":551,"localvar":"my","kind":13,"containerName":"_from_gff2_string","name":"$a"},{"name":"$attribs","containerName":"_from_gff2_string","kind":13,"line":551},{"containerName":"_from_gff2_string","kind":13,"name":"$a","line":553},{"line":553,"name":"$flag","kind":13,"containerName":"_from_gff2_string"},{"line":553,"kind":13,"containerName":"_from_gff2_string","name":"$flag"},{"line":554,"kind":13,"containerName":"_from_gff2_string","name":"$a"},{"line":554,"name":"$flag","containerName":"_from_gff2_string","kind":13},{"line":554,"containerName":"_from_gff2_string","kind":13,"name":"$a"},{"line":555,"kind":13,"containerName":"_from_gff2_string","name":"$a"},{"line":555,"containerName":"_from_gff2_string","kind":13,"name":"$flag"},{"name":"@parsed","containerName":"_from_gff2_string","kind":13,"line":556},{"containerName":"_from_gff2_string","kind":13,"name":"$a","line":556},{"line":558,"name":"$attribs","containerName":"_from_gff2_string","kind":13},{"line":558,"containerName":"_from_gff2_string","kind":13,"name":"@parsed"},{"definition":"my","line":563,"localvar":"my","containerName":"_from_gff2_string","kind":13,"name":"@key_vals"},{"name":"$attribs","containerName":"_from_gff2_string","kind":13,"line":563},{"definition":"my","line":565,"name":"$pair","kind":13,"localvar":"my","containerName":"_from_gff2_string"},{"kind":13,"containerName":"_from_gff2_string","name":"@key_vals","line":565},{"line":567,"containerName":"_from_gff2_string","kind":13,"name":"$pair"},{"line":570,"name":"$blank","kind":13,"localvar":"my","containerName":"_from_gff2_string","definition":"my"},{"line":570,"name":"$key","kind":13,"containerName":"_from_gff2_string"},{"name":"$values","kind":13,"containerName":"_from_gff2_string","line":570},{"containerName":"_from_gff2_string","kind":13,"name":"$pair","line":570},{"line":573,"kind":13,"containerName":"_from_gff2_string","name":"$values"},{"definition":"my","localvar":"my","containerName":"_from_gff2_string","kind":13,"name":"@values","line":574},{"kind":13,"containerName":"_from_gff2_string","name":"$values","line":577},{"line":580,"name":"@values","containerName":"_from_gff2_string","kind":13},{"definition":"my","line":586,"kind":13,"localvar":"my","containerName":"_from_gff2_string","name":"@othervals"},{"kind":13,"containerName":"_from_gff2_string","name":"$values","line":586},{"definition":"my","name":"$othervalue","kind":13,"localvar":"my","containerName":"_from_gff2_string","line":587},{"kind":13,"containerName":"_from_gff2_string","name":"@othervals","line":587},{"line":590,"kind":13,"containerName":"_from_gff2_string","name":"$othervalue"},{"name":"@values","containerName":"_from_gff2_string","kind":13,"line":590},{"line":590,"kind":13,"containerName":"_from_gff2_string","name":"$othervalue"},{"definition":"my","line":593,"name":"$value","containerName":"_from_gff2_string","localvar":"my","kind":13},{"line":593,"name":"@values","containerName":"_from_gff2_string","kind":13},{"line":594,"name":"$feat","containerName":"_from_gff2_string","kind":13},{"line":594,"containerName":"_from_gff2_string","kind":12,"name":"add_tag_value"},{"name":"$key","containerName":"_from_gff2_string","kind":13,"line":594},{"kind":13,"containerName":"_from_gff2_string","name":"$value","line":594}],"name":"_from_gff2_string","containerName":"main::","signature":{"parameters":[{"label":"$gff"},{"label":"$feat"},{"label":"$string"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from","label":"_from_gff2_string($gff,$feat,$string)"},"line":499,"range":{"start":{"character":0,"line":499},"end":{"character":9999,"line":598}},"kind":12},{"line":555,"name":"last","kind":12},{"line":590,"containerName":"length","kind":12,"name":"CORE"},{"line":601,"kind":12,"range":{"start":{"line":601,"character":0},"end":{"line":637,"character":9999}},"signature":{"label":"_from_gff3_string($gff,$feat,$string)","parameters":[{"label":"$gff"},{"label":"$feat"},{"label":"$string"}],"documentation":""},"children":[{"definition":"my","line":602,"name":"$gff","kind":13,"localvar":"my","containerName":"_from_gff3_string"},{"name":"$feat","containerName":"_from_gff3_string","kind":13,"line":602},{"line":602,"kind":13,"containerName":"_from_gff3_string","name":"$string"},{"name":"$string","kind":13,"containerName":"_from_gff3_string","line":603},{"definition":"my","name":"$seqname","localvar":"my","containerName":"_from_gff3_string","kind":13,"line":609},{"name":"$source","containerName":"_from_gff3_string","kind":13,"line":609},{"line":609,"name":"$primary","kind":13,"containerName":"_from_gff3_string"},{"name":"$start","kind":13,"containerName":"_from_gff3_string","line":609},{"name":"$end","containerName":"_from_gff3_string","kind":13,"line":609},{"line":610,"containerName":"_from_gff3_string","kind":13,"name":"$score"},{"line":610,"name":"$strand","containerName":"_from_gff3_string","kind":13},{"kind":13,"containerName":"_from_gff3_string","name":"$frame","line":610},{"line":610,"kind":13,"containerName":"_from_gff3_string","name":"$groups"},{"line":610,"name":"$string","kind":13,"containerName":"_from_gff3_string"},{"line":612,"name":"$frame","containerName":"_from_gff3_string","kind":13},{"line":613,"containerName":"_from_gff3_string","kind":13,"name":"$feat"},{"line":613,"name":"throw","kind":12,"containerName":"_from_gff3_string"},{"line":615,"containerName":"_from_gff3_string","kind":13,"name":"$feat"},{"containerName":"_from_gff3_string","kind":12,"name":"seq_id","line":615},{"name":"$seqname","containerName":"_from_gff3_string","kind":13,"line":615},{"containerName":"_from_gff3_string","kind":13,"name":"$feat","line":616},{"name":"source_tag","containerName":"_from_gff3_string","kind":12,"line":616},{"name":"$source","containerName":"_from_gff3_string","kind":13,"line":616},{"line":617,"name":"$feat","containerName":"_from_gff3_string","kind":13},{"name":"primary_tag","containerName":"_from_gff3_string","kind":12,"line":617},{"kind":13,"containerName":"_from_gff3_string","name":"$primary","line":617},{"name":"$feat","kind":13,"containerName":"_from_gff3_string","line":618},{"line":618,"kind":12,"containerName":"_from_gff3_string","name":"start"},{"kind":13,"containerName":"_from_gff3_string","name":"$start","line":618},{"containerName":"_from_gff3_string","kind":13,"name":"$feat","line":619},{"line":619,"name":"end","containerName":"_from_gff3_string","kind":12},{"line":619,"containerName":"_from_gff3_string","kind":13,"name":"$end"},{"line":620,"containerName":"_from_gff3_string","kind":13,"name":"$feat"},{"containerName":"_from_gff3_string","kind":12,"name":"frame","line":620},{"name":"$frame","kind":13,"containerName":"_from_gff3_string","line":620},{"name":"$score","kind":13,"containerName":"_from_gff3_string","line":621},{"line":624,"kind":13,"containerName":"_from_gff3_string","name":"$feat"},{"line":624,"containerName":"_from_gff3_string","kind":12,"name":"score"},{"containerName":"_from_gff3_string","kind":13,"name":"$score","line":624},{"name":"$strand","kind":13,"containerName":"_from_gff3_string","line":626},{"line":626,"containerName":"_from_gff3_string","kind":13,"name":"$feat"},{"line":626,"kind":12,"containerName":"_from_gff3_string","name":"strand"},{"line":627,"name":"$strand","containerName":"_from_gff3_string","kind":13},{"name":"$feat","containerName":"_from_gff3_string","kind":13,"line":627},{"line":627,"name":"strand","containerName":"_from_gff3_string","kind":12},{"containerName":"_from_gff3_string","kind":13,"name":"$strand","line":628},{"line":628,"name":"$feat","kind":13,"containerName":"_from_gff3_string"},{"line":628,"kind":12,"containerName":"_from_gff3_string","name":"strand"},{"containerName":"_from_gff3_string","localvar":"my","kind":13,"name":"@groups","line":629,"definition":"my"},{"name":"$groups","containerName":"_from_gff3_string","kind":13,"line":629},{"definition":"my","name":"$group","localvar":"my","containerName":"_from_gff3_string","kind":13,"line":631},{"line":631,"name":"@groups","containerName":"_from_gff3_string","kind":13},{"definition":"my","line":632,"name":"$tag","containerName":"_from_gff3_string","localvar":"my","kind":13},{"kind":13,"containerName":"_from_gff3_string","name":"$value","line":632},{"line":632,"name":"$group","containerName":"_from_gff3_string","kind":13},{"line":633,"containerName":"_from_gff3_string","kind":13,"name":"$tag"},{"line":633,"name":"$tag","containerName":"_from_gff3_string","kind":13},{"definition":"my","name":"@values","localvar":"my","kind":13,"containerName":"_from_gff3_string","line":634},{"line":634,"kind":13,"containerName":"_from_gff3_string","name":"$value"},{"name":"$v","containerName":"_from_gff3_string","localvar":"my","kind":13,"line":635,"definition":"my"},{"line":635,"containerName":"_from_gff3_string","kind":13,"name":"@values"},{"line":635,"kind":13,"containerName":"_from_gff3_string","name":"$feat"},{"containerName":"_from_gff3_string","kind":12,"name":"add_tag_value","line":635},{"name":"$tag","containerName":"_from_gff3_string","kind":13,"line":635},{"line":635,"containerName":"_from_gff3_string","kind":13,"name":"$v"}],"name":"_from_gff3_string","containerName":"main::","definition":"sub","detail":"($gff,$feat,$string)"},{"line":633,"kind":12,"name":"unescape"},{"name":"unescape","kind":12,"line":634},{"children":[{"definition":"my","name":"$v","localvar":"my","containerName":"unescape","kind":13,"line":641},{"line":642,"containerName":"unescape","kind":13,"name":"$v"},{"line":643,"name":"$v","kind":13,"containerName":"unescape"},{"name":"$v","kind":13,"containerName":"unescape","line":644}],"containerName":"main::","name":"unescape","definition":"sub","line":640,"range":{"end":{"character":9999,"line":645},"start":{"line":640,"character":0}},"kind":12},{"signature":{"label":"write_feature($self,@features)","parameters":[{"label":"$self"},{"label":"@features"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized"},"kind":12,"range":{"start":{"character":0,"line":658},"end":{"character":9999,"line":668}},"line":658,"detail":"($self,@features)","definition":"sub","containerName":"main::","name":"write_feature","children":[{"line":659,"name":"$self","localvar":"my","containerName":"write_feature","kind":13,"definition":"my"},{"name":"@features","containerName":"write_feature","kind":13,"line":659},{"line":660,"kind":13,"containerName":"write_feature","name":"@features"},{"line":661,"kind":13,"containerName":"write_feature","name":"$self"},{"kind":13,"containerName":"write_feature","name":"$self","line":661},{"kind":12,"containerName":"write_feature","name":"gff_version","line":661},{"line":662,"containerName":"write_feature","kind":13,"name":"$self"},{"line":662,"name":"_print","containerName":"write_feature","kind":12},{"name":"$self","containerName":"write_feature","kind":13,"line":664},{"definition":"my","name":"$feature","localvar":"my","containerName":"write_feature","kind":13,"line":665},{"line":665,"name":"@features","kind":13,"containerName":"write_feature"},{"name":"$self","kind":13,"containerName":"write_feature","line":666},{"kind":12,"containerName":"write_feature","name":"_print","line":666},{"line":666,"containerName":"write_feature","kind":13,"name":"$self"},{"line":666,"name":"gff_string","containerName":"write_feature","kind":12},{"kind":13,"containerName":"write_feature","name":"$feature","line":666}]},{"kind":12,"range":{"start":{"character":0,"line":685},"end":{"line":697,"character":9999}},"line":685,"signature":{"parameters":[{"label":"$self"},{"label":"$feature"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified","label":"gff_string($self,$feature)"},"containerName":"main::","name":"gff_string","children":[{"definition":"my","line":686,"name":"$self","localvar":"my","containerName":"gff_string","kind":13},{"line":686,"name":"$feature","containerName":"gff_string","kind":13},{"name":"$self","containerName":"gff_string","kind":13,"line":688},{"kind":12,"containerName":"gff_string","name":"gff_version","line":688},{"name":"$self","containerName":"gff_string","kind":13,"line":689},{"containerName":"gff_string","kind":12,"name":"_gff1_string","line":689},{"containerName":"gff_string","kind":13,"name":"$feature","line":689},{"line":690,"name":"$self","kind":13,"containerName":"gff_string"},{"line":690,"kind":12,"containerName":"gff_string","name":"gff_version"},{"line":691,"containerName":"gff_string","kind":13,"name":"$self"},{"line":691,"name":"_gff3_string","kind":12,"containerName":"gff_string"},{"line":691,"containerName":"gff_string","kind":13,"name":"$feature"},{"line":692,"containerName":"gff_string","kind":13,"name":"$self"},{"containerName":"gff_string","kind":12,"name":"gff_version","line":692},{"line":693,"name":"$self","containerName":"gff_string","kind":13},{"containerName":"gff_string","kind":12,"name":"_gff25_string","line":693},{"line":693,"containerName":"gff_string","kind":13,"name":"$feature"},{"line":695,"name":"$self","kind":13,"containerName":"gff_string"},{"kind":12,"containerName":"gff_string","name":"_gff2_string","line":695},{"name":"$feature","kind":13,"containerName":"gff_string","line":695}],"detail":"($self,$feature)","definition":"sub"},{"children":[{"line":711,"name":"$gff","localvar":"my","kind":13,"containerName":"_gff1_string","definition":"my"},{"kind":13,"containerName":"_gff1_string","name":"$feat","line":711},{"definition":"my","line":712,"name":"$str","localvar":"my","kind":13,"containerName":"_gff1_string"},{"line":712,"kind":13,"containerName":"_gff1_string","name":"$score"},{"name":"$frame","kind":13,"containerName":"_gff1_string","line":712},{"line":712,"name":"$name","kind":13,"containerName":"_gff1_string"},{"line":712,"name":"$strand","kind":13,"containerName":"_gff1_string"},{"containerName":"_gff1_string","kind":13,"name":"$feat","line":714},{"name":"can","containerName":"_gff1_string","kind":12,"line":714},{"name":"$score","containerName":"_gff1_string","kind":13,"line":715},{"line":715,"name":"$feat","containerName":"_gff1_string","kind":13},{"line":715,"name":"score","containerName":"_gff1_string","kind":12},{"name":"$score","kind":13,"containerName":"_gff1_string","line":717},{"line":717,"name":"$score","containerName":"_gff1_string","kind":13},{"line":719,"name":"$feat","containerName":"_gff1_string","kind":13},{"name":"can","kind":12,"containerName":"_gff1_string","line":719},{"name":"$frame","kind":13,"containerName":"_gff1_string","line":720},{"line":720,"kind":13,"containerName":"_gff1_string","name":"$feat"},{"name":"frame","containerName":"_gff1_string","kind":12,"line":720},{"line":722,"kind":13,"containerName":"_gff1_string","name":"$frame"},{"containerName":"_gff1_string","kind":13,"name":"$frame","line":722},{"name":"$strand","kind":13,"containerName":"_gff1_string","line":724},{"line":724,"containerName":"_gff1_string","kind":13,"name":"$feat"},{"kind":12,"containerName":"_gff1_string","name":"strand","line":724},{"line":725,"kind":13,"containerName":"_gff1_string","name":"$strand"},{"containerName":"_gff1_string","kind":13,"name":"$strand","line":726},{"containerName":"_gff1_string","kind":13,"name":"$strand","line":727},{"name":"$strand","containerName":"_gff1_string","kind":13,"line":728},{"line":729,"containerName":"_gff1_string","kind":13,"name":"$feat"},{"name":"strand","containerName":"_gff1_string","kind":12,"line":729},{"name":"$strand","containerName":"_gff1_string","kind":13,"line":730},{"line":733,"name":"$feat","containerName":"_gff1_string","kind":13},{"line":733,"name":"can","kind":12,"containerName":"_gff1_string"},{"kind":13,"containerName":"_gff1_string","name":"$name","line":734},{"line":734,"name":"$feat","kind":13,"containerName":"_gff1_string"},{"containerName":"_gff1_string","kind":12,"name":"seq_id","line":734},{"containerName":"_gff1_string","kind":13,"name":"$name","line":735},{"line":737,"containerName":"_gff1_string","kind":13,"name":"$name"},{"name":"$str","kind":13,"containerName":"_gff1_string","line":741},{"line":742,"name":"$name","containerName":"_gff1_string","kind":13},{"containerName":"_gff1_string","kind":13,"name":"$feat","line":743},{"kind":12,"containerName":"_gff1_string","name":"source_tag","line":743},{"line":744,"containerName":"_gff1_string","kind":13,"name":"$feat"},{"name":"primary_tag","kind":12,"containerName":"_gff1_string","line":744},{"kind":13,"containerName":"_gff1_string","name":"$feat","line":745},{"line":745,"kind":12,"containerName":"_gff1_string","name":"start"},{"kind":13,"containerName":"_gff1_string","name":"$feat","line":746},{"containerName":"_gff1_string","kind":12,"name":"end","line":746},{"line":747,"kind":13,"containerName":"_gff1_string","name":"$score"},{"kind":13,"containerName":"_gff1_string","name":"$strand","line":748},{"line":749,"kind":13,"containerName":"_gff1_string","name":"$frame"},{"definition":"my","name":"$tag","localvar":"my","containerName":"_gff1_string","kind":13,"line":751},{"line":751,"containerName":"_gff1_string","kind":13,"name":"$feat"},{"line":751,"containerName":"_gff1_string","kind":12,"name":"all_tags"},{"definition":"my","name":"$value","localvar":"my","kind":13,"containerName":"_gff1_string","line":752},{"line":752,"name":"$feat","kind":13,"containerName":"_gff1_string"},{"line":752,"containerName":"_gff1_string","kind":12,"name":"each_tag_value"},{"line":752,"kind":13,"containerName":"_gff1_string","name":"$tag"},{"line":753,"kind":13,"containerName":"_gff1_string","name":"$str"},{"name":"$value","containerName":"_gff1_string","kind":13,"line":753},{"line":758,"containerName":"_gff1_string","kind":13,"name":"$str"}],"containerName":"main::","name":"_gff1_string","definition":"sub","detail":"($gff,$feat)","line":710,"kind":12,"range":{"end":{"line":759,"character":9999},"start":{"character":0,"line":710}},"signature":{"label":"_gff1_string($gff,$feat)","parameters":[{"label":"$gff"},{"label":"$feat"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified"}},{"detail":"($gff,$origfeat)","definition":"sub","containerName":"main::","name":"_gff2_string","children":[{"line":773,"localvar":"my","kind":13,"containerName":"_gff2_string","name":"$gff","definition":"my"},{"line":773,"name":"$origfeat","kind":13,"containerName":"_gff2_string"},{"definition":"my","localvar":"my","containerName":"_gff2_string","kind":13,"name":"$feat","line":774},{"name":"$origfeat","containerName":"_gff2_string","kind":13,"line":775},{"containerName":"_gff2_string","kind":12,"name":"isa","line":775},{"name":"$feat","kind":13,"containerName":"_gff2_string","line":776},{"line":776,"containerName":"_gff2_string","kind":13,"name":"$origfeat"},{"line":776,"containerName":"_gff2_string","kind":12,"name":"feature2"},{"line":778,"name":"$feat","kind":13,"containerName":"_gff2_string"},{"line":778,"name":"$origfeat","kind":13,"containerName":"_gff2_string"},{"name":"$str1","localvar":"my","kind":13,"containerName":"_gff2_string","line":780,"definition":"my"},{"line":780,"kind":13,"containerName":"_gff2_string","name":"$str2"},{"name":"$score","containerName":"_gff2_string","kind":13,"line":780},{"name":"$frame","kind":13,"containerName":"_gff2_string","line":780},{"line":780,"name":"$name","containerName":"_gff2_string","kind":13},{"kind":13,"containerName":"_gff2_string","name":"$strand","line":780},{"name":"$feat","kind":13,"containerName":"_gff2_string","line":782},{"containerName":"_gff2_string","kind":12,"name":"can","line":782},{"line":783,"name":"$score","containerName":"_gff2_string","kind":13},{"containerName":"_gff2_string","kind":13,"name":"$feat","line":783},{"containerName":"_gff2_string","kind":12,"name":"score","line":783},{"containerName":"_gff2_string","kind":13,"name":"$score","line":785},{"line":785,"containerName":"_gff2_string","kind":13,"name":"$score"},{"containerName":"_gff2_string","kind":13,"name":"$feat","line":787},{"line":787,"name":"can","kind":12,"containerName":"_gff2_string"},{"line":788,"name":"$frame","kind":13,"containerName":"_gff2_string"},{"kind":13,"containerName":"_gff2_string","name":"$feat","line":788},{"line":788,"containerName":"_gff2_string","kind":12,"name":"frame"},{"line":790,"name":"$frame","containerName":"_gff2_string","kind":13},{"line":790,"name":"$frame","containerName":"_gff2_string","kind":13},{"line":792,"kind":13,"containerName":"_gff2_string","name":"$strand"},{"kind":13,"containerName":"_gff2_string","name":"$feat","line":792},{"line":792,"kind":12,"containerName":"_gff2_string","name":"strand"},{"name":"$strand","kind":13,"containerName":"_gff2_string","line":793},{"name":"$strand","containerName":"_gff2_string","kind":13,"line":794},{"line":795,"kind":13,"containerName":"_gff2_string","name":"$strand"},{"line":796,"name":"$strand","kind":13,"containerName":"_gff2_string"},{"name":"$feat","containerName":"_gff2_string","kind":13,"line":797},{"name":"strand","kind":12,"containerName":"_gff2_string","line":797},{"line":798,"name":"$strand","kind":13,"containerName":"_gff2_string"},{"kind":13,"containerName":"_gff2_string","name":"$feat","line":801},{"line":801,"containerName":"_gff2_string","kind":12,"name":"can"},{"name":"$name","containerName":"_gff2_string","kind":13,"line":802},{"line":802,"name":"$feat","containerName":"_gff2_string","kind":13},{"name":"seq_id","containerName":"_gff2_string","kind":12,"line":802},{"kind":13,"containerName":"_gff2_string","name":"$name","line":803},{"name":"$name","kind":13,"containerName":"_gff2_string","line":805},{"line":807,"name":"$str1","kind":13,"containerName":"_gff2_string"},{"containerName":"_gff2_string","kind":13,"name":"$name","line":808},{"line":809,"containerName":"_gff2_string","kind":13,"name":"$feat"},{"line":809,"name":"source_tag","containerName":"_gff2_string","kind":12},{"line":810,"kind":13,"containerName":"_gff2_string","name":"$feat"},{"kind":12,"containerName":"_gff2_string","name":"primary_tag","line":810},{"line":811,"containerName":"_gff2_string","kind":13,"name":"$feat"},{"line":811,"name":"start","containerName":"_gff2_string","kind":12},{"line":812,"name":"$feat","containerName":"_gff2_string","kind":13},{"kind":12,"containerName":"_gff2_string","name":"end","line":812},{"line":813,"kind":13,"containerName":"_gff2_string","name":"$score"},{"line":814,"name":"$strand","containerName":"_gff2_string","kind":13},{"line":815,"kind":13,"containerName":"_gff2_string","name":"$frame"},{"definition":"my","line":828,"localvar":"my","kind":13,"containerName":"_gff2_string","name":"@all_tags"},{"kind":13,"containerName":"_gff2_string","name":"$feat","line":828},{"line":828,"containerName":"_gff2_string","kind":12,"name":"all_tags"},{"name":"@group","localvar":"my","containerName":"_gff2_string","kind":13,"line":829,"definition":"my"},{"name":"@all_tags","containerName":"_gff2_string","kind":13,"line":830},{"line":831,"name":"$tag","containerName":"_gff2_string","localvar":"my","kind":13,"definition":"my"},{"containerName":"_gff2_string","kind":13,"name":"@all_tags","line":831},{"definition":"my","line":832,"containerName":"_gff2_string","localvar":"my","kind":13,"name":"@v"},{"name":"$value","kind":13,"localvar":"my","containerName":"_gff2_string","line":833,"definition":"my"},{"containerName":"_gff2_string","kind":13,"name":"$feat","line":833},{"name":"each_tag_value","kind":12,"containerName":"_gff2_string","line":833},{"name":"$tag","containerName":"_gff2_string","kind":13,"line":833},{"line":834,"kind":13,"containerName":"_gff2_string","name":"$value"},{"name":"$value","containerName":"_gff2_string","kind":13,"line":834},{"line":835,"name":"$value","kind":13,"containerName":"_gff2_string"},{"line":836,"kind":13,"containerName":"_gff2_string","name":"$value"},{"line":837,"name":"$value","containerName":"_gff2_string","kind":13},{"line":839,"containerName":"_gff2_string","kind":13,"name":"$value"},{"line":840,"name":"$value","containerName":"_gff2_string","kind":13},{"name":"$value","containerName":"_gff2_string","kind":13,"line":840},{"name":"@v","containerName":"_gff2_string","kind":13,"line":845},{"line":845,"containerName":"_gff2_string","kind":13,"name":"$value"},{"name":"@group","containerName":"_gff2_string","kind":13,"line":848},{"name":"@v","kind":13,"containerName":"_gff2_string","line":848},{"line":851,"name":"$str2","kind":13,"containerName":"_gff2_string"},{"kind":13,"containerName":"_gff2_string","name":"@group","line":851},{"line":853,"name":"$feat","containerName":"_gff2_string","kind":13},{"name":"has_tag","containerName":"_gff2_string","kind":12,"line":853},{"line":854,"name":"$feat","containerName":"_gff2_string","kind":13},{"kind":12,"containerName":"_gff2_string","name":"has_tag","line":854},{"line":855,"kind":13,"containerName":"_gff2_string","name":"$origfeat"},{"line":855,"name":"isa","kind":12,"containerName":"_gff2_string"},{"line":856,"name":"$str2","kind":13,"containerName":"_gff2_string"},{"containerName":"_gff2_string","kind":13,"name":"$origfeat","line":856},{"line":856,"kind":12,"containerName":"_gff2_string","name":"feature1"},{"line":856,"name":"seq_id","kind":12,"containerName":"_gff2_string"},{"line":857,"name":"$origfeat","containerName":"_gff2_string","kind":13},{"line":857,"kind":12,"containerName":"_gff2_string","name":"feature1"},{"name":"strand","kind":12,"containerName":"_gff2_string","line":857},{"line":858,"kind":13,"containerName":"_gff2_string","name":"$origfeat"},{"line":858,"name":"feature1","containerName":"_gff2_string","kind":12},{"containerName":"_gff2_string","kind":12,"name":"end","line":858},{"name":"$origfeat","containerName":"_gff2_string","kind":13,"line":859},{"name":"feature1","containerName":"_gff2_string","kind":12,"line":859},{"line":859,"kind":12,"containerName":"_gff2_string","name":"start"},{"name":"$origfeat","kind":13,"containerName":"_gff2_string","line":860},{"name":"feature1","kind":12,"containerName":"_gff2_string","line":860},{"line":860,"containerName":"_gff2_string","kind":12,"name":"start"},{"line":861,"containerName":"_gff2_string","kind":13,"name":"$origfeat"},{"name":"feature1","containerName":"_gff2_string","kind":12,"line":861},{"kind":12,"containerName":"_gff2_string","name":"end","line":861},{"name":"$str2","kind":13,"containerName":"_gff2_string","line":862},{"line":862,"name":"$str2","containerName":"_gff2_string","kind":13},{"line":864,"name":"$str1","containerName":"_gff2_string","kind":13},{"name":"$str2","containerName":"_gff2_string","kind":13,"line":864}],"signature":{"label":"_gff2_string($gff,$origfeat)","parameters":[{"label":"$gff"},{"label":"$origfeat"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified"},"range":{"end":{"character":9999,"line":865},"start":{"line":772,"character":0}},"kind":12,"line":772},{"name":"_gff25_string","containerName":"main::","children":[{"name":"$gff","containerName":"_gff25_string","localvar":"my","kind":13,"line":881,"definition":"my"},{"line":881,"name":"$origfeat","kind":13,"containerName":"_gff25_string"},{"name":"$feat","localvar":"my","containerName":"_gff25_string","kind":13,"line":882,"definition":"my"},{"line":883,"containerName":"_gff25_string","kind":13,"name":"$origfeat"},{"kind":12,"containerName":"_gff25_string","name":"isa","line":883},{"line":884,"containerName":"_gff25_string","kind":13,"name":"$feat"},{"name":"$origfeat","containerName":"_gff25_string","kind":13,"line":884},{"line":884,"kind":12,"containerName":"_gff25_string","name":"feature2"},{"line":886,"name":"$feat","kind":13,"containerName":"_gff25_string"},{"name":"$origfeat","kind":13,"containerName":"_gff25_string","line":886},{"name":"$str1","containerName":"_gff25_string","localvar":"my","kind":13,"line":888,"definition":"my"},{"name":"$str2","containerName":"_gff25_string","kind":13,"line":888},{"line":888,"name":"$score","kind":13,"containerName":"_gff25_string"},{"line":888,"containerName":"_gff25_string","kind":13,"name":"$frame"},{"line":888,"name":"$name","kind":13,"containerName":"_gff25_string"},{"name":"$strand","kind":13,"containerName":"_gff25_string","line":888},{"containerName":"_gff25_string","kind":13,"name":"$feat","line":890},{"containerName":"_gff25_string","kind":12,"name":"can","line":890},{"line":891,"containerName":"_gff25_string","kind":13,"name":"$score"},{"line":891,"containerName":"_gff25_string","kind":13,"name":"$feat"},{"line":891,"containerName":"_gff25_string","kind":12,"name":"score"},{"containerName":"_gff25_string","kind":13,"name":"$score","line":893},{"name":"$score","containerName":"_gff25_string","kind":13,"line":893},{"line":895,"kind":13,"containerName":"_gff25_string","name":"$feat"},{"kind":12,"containerName":"_gff25_string","name":"can","line":895},{"kind":13,"containerName":"_gff25_string","name":"$frame","line":896},{"containerName":"_gff25_string","kind":13,"name":"$feat","line":896},{"line":896,"name":"frame","containerName":"_gff25_string","kind":12},{"line":898,"name":"$frame","kind":13,"containerName":"_gff25_string"},{"name":"$frame","kind":13,"containerName":"_gff25_string","line":898},{"kind":13,"containerName":"_gff25_string","name":"$strand","line":900},{"line":900,"containerName":"_gff25_string","kind":13,"name":"$feat"},{"line":900,"name":"strand","containerName":"_gff25_string","kind":12},{"name":"$strand","containerName":"_gff25_string","kind":13,"line":901},{"name":"$strand","containerName":"_gff25_string","kind":13,"line":902},{"name":"$strand","containerName":"_gff25_string","kind":13,"line":903},{"kind":13,"containerName":"_gff25_string","name":"$strand","line":904},{"name":"$feat","kind":13,"containerName":"_gff25_string","line":905},{"line":905,"containerName":"_gff25_string","kind":12,"name":"strand"},{"line":906,"containerName":"_gff25_string","kind":13,"name":"$strand"},{"line":909,"kind":13,"containerName":"_gff25_string","name":"$feat"},{"line":909,"kind":12,"containerName":"_gff25_string","name":"can"},{"line":910,"kind":13,"containerName":"_gff25_string","name":"$name"},{"line":910,"containerName":"_gff25_string","kind":13,"name":"$feat"},{"kind":12,"containerName":"_gff25_string","name":"seq_id","line":910},{"line":911,"name":"$name","kind":13,"containerName":"_gff25_string"},{"containerName":"_gff25_string","kind":13,"name":"$name","line":913},{"line":915,"name":"$str1","kind":13,"containerName":"_gff25_string"},{"kind":13,"containerName":"_gff25_string","name":"$name","line":916},{"kind":13,"containerName":"_gff25_string","name":"$feat","line":917},{"line":917,"name":"source_tag","kind":12,"containerName":"_gff25_string"},{"name":"$feat","containerName":"_gff25_string","kind":13,"line":918},{"line":918,"name":"primary_tag","kind":12,"containerName":"_gff25_string"},{"kind":13,"containerName":"_gff25_string","name":"$feat","line":919},{"line":919,"name":"start","containerName":"_gff25_string","kind":12},{"containerName":"_gff25_string","kind":13,"name":"$feat","line":920},{"line":920,"name":"end","kind":12,"containerName":"_gff25_string"},{"name":"$score","containerName":"_gff25_string","kind":13,"line":921},{"line":922,"containerName":"_gff25_string","kind":13,"name":"$strand"},{"name":"$frame","kind":13,"containerName":"_gff25_string","line":923},{"definition":"my","localvar":"my","kind":13,"containerName":"_gff25_string","name":"@all_tags","line":925},{"line":925,"name":"$feat","containerName":"_gff25_string","kind":13},{"containerName":"_gff25_string","kind":12,"name":"all_tags","line":925},{"line":926,"name":"@group","localvar":"my","containerName":"_gff25_string","kind":13,"definition":"my"},{"name":"@firstgroup","containerName":"_gff25_string","localvar":"my","kind":13,"line":926,"definition":"my"},{"line":927,"containerName":"_gff25_string","kind":13,"name":"@all_tags"},{"line":928,"name":"$tag","containerName":"_gff25_string","localvar":"my","kind":13,"definition":"my"},{"name":"@all_tags","kind":13,"containerName":"_gff25_string","line":928},{"definition":"my","line":929,"name":"@v","localvar":"my","kind":13,"containerName":"_gff25_string"},{"line":930,"name":"$value","localvar":"my","kind":13,"containerName":"_gff25_string","definition":"my"},{"line":930,"kind":13,"containerName":"_gff25_string","name":"$feat"},{"line":930,"containerName":"_gff25_string","kind":12,"name":"each_tag_value"},{"line":930,"name":"$tag","kind":13,"containerName":"_gff25_string"},{"kind":13,"containerName":"_gff25_string","name":"$value","line":931},{"name":"$value","containerName":"_gff25_string","kind":13,"line":931},{"name":"$value","containerName":"_gff25_string","kind":13,"line":932},{"containerName":"_gff25_string","kind":13,"name":"$value","line":933},{"line":934,"containerName":"_gff25_string","kind":13,"name":"$value"},{"name":"$value","containerName":"_gff25_string","kind":13,"line":936},{"line":937,"name":"$value","containerName":"_gff25_string","kind":13},{"line":937,"name":"$value","containerName":"_gff25_string","kind":13},{"name":"@v","kind":13,"containerName":"_gff25_string","line":942},{"line":942,"kind":13,"containerName":"_gff25_string","name":"$value"},{"line":945,"name":"$tag","kind":13,"containerName":"_gff25_string"},{"containerName":"_gff25_string","kind":13,"name":"$tag","line":945},{"name":"@firstgroup","containerName":"_gff25_string","kind":13,"line":946},{"line":946,"kind":13,"containerName":"_gff25_string","name":"@v"},{"kind":13,"containerName":"_gff25_string","name":"@group","line":948},{"kind":13,"containerName":"_gff25_string","name":"@v","line":948},{"containerName":"_gff25_string","kind":13,"name":"$str2","line":952},{"name":"@firstgroup","containerName":"_gff25_string","kind":13,"line":952},{"containerName":"_gff25_string","kind":13,"name":"@group","line":952},{"name":"$feat","containerName":"_gff25_string","kind":13,"line":954},{"name":"has_tag","containerName":"_gff25_string","kind":12,"line":954},{"kind":13,"containerName":"_gff25_string","name":"$feat","line":955},{"kind":12,"containerName":"_gff25_string","name":"has_tag","line":955},{"line":956,"containerName":"_gff25_string","kind":13,"name":"$origfeat"},{"line":956,"name":"isa","containerName":"_gff25_string","kind":12},{"line":957,"kind":13,"containerName":"_gff25_string","name":"$str2"},{"line":957,"kind":13,"containerName":"_gff25_string","name":"$origfeat"},{"name":"feature1","kind":12,"containerName":"_gff25_string","line":957},{"line":957,"name":"seq_id","containerName":"_gff25_string","kind":12},{"kind":13,"containerName":"_gff25_string","name":"$origfeat","line":958},{"line":958,"name":"feature1","kind":12,"containerName":"_gff25_string"},{"line":958,"containerName":"_gff25_string","kind":12,"name":"strand"},{"kind":13,"containerName":"_gff25_string","name":"$origfeat","line":959},{"line":959,"kind":12,"containerName":"_gff25_string","name":"feature1"},{"line":959,"name":"end","kind":12,"containerName":"_gff25_string"},{"name":"$origfeat","kind":13,"containerName":"_gff25_string","line":960},{"line":960,"containerName":"_gff25_string","kind":12,"name":"feature1"},{"line":960,"kind":12,"containerName":"_gff25_string","name":"start"},{"line":961,"kind":13,"containerName":"_gff25_string","name":"$origfeat"},{"line":961,"containerName":"_gff25_string","kind":12,"name":"feature1"},{"line":961,"containerName":"_gff25_string","kind":12,"name":"start"},{"name":"$origfeat","kind":13,"containerName":"_gff25_string","line":962},{"name":"feature1","containerName":"_gff25_string","kind":12,"line":962},{"name":"end","containerName":"_gff25_string","kind":12,"line":962},{"line":963,"name":"$str2","kind":13,"containerName":"_gff25_string"},{"kind":13,"containerName":"_gff25_string","name":"$str2","line":963},{"name":"$str1","containerName":"_gff25_string","kind":13,"line":965},{"line":965,"name":"$str2","containerName":"_gff25_string","kind":13}],"detail":"($gff,$origfeat)","definition":"sub","kind":12,"range":{"start":{"character":0,"line":880},"end":{"character":9999,"line":966}},"line":880,"signature":{"parameters":[{"label":"$gff"},{"label":"$origfeat"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified\n\n\nsub _gff2_string{\n   my ($gff, $origfeat) = @_;\n    my $feat;\n   if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n       $feat = $origfeat->feature2;\n   } else {\n       $feat = $origfeat;\n   }\n   my ($str1, $str2,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n\n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n   $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n   # the routine below is the only modification I made to the original\n   # ->gff_string routine (above) as on November 17th, 2000, the\n   # Sanger webpage describing GFF2 format reads: \"From version 2\n   # onwards, the attribute field must have a tag value structure\n   # following the syntax used within objects in a .ace file,\n   # flattened onto one line by semicolon separators. Tags must be\n   # standard identifiers ([A-Za-z][A-Za-z0-9_]*).  Free text values\n   # must be quoted with double quotes\".\n\n   # MW\n\n   \n   my @all_tags = $feat->all_tags;\n   my @group;\n   if (@all_tags) {  # only play this game if it is worth playing...\n       foreach my $tag ( @all_tags ) {\n\t   my @v;\n\t   foreach my $value ( $feat->each_tag_value($tag) ) {\n \t       unless( defined $value && length($value) ) {\n\t\t   $value = '\"\"';\n\t       } elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t   $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t                         # characters\n\t\t   $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t   $value = '\"' . $value . '\" ';\n\t       }                                 # if the value contains \n\t                                         # anything other than valid \n\t                                         # tag/value characters, then \n\t                                         # quote it\n\t       push @v, $value;\n\t       # for this tag (allowed in GFF2 and .ace format)\n\t   }\n\t   push @group, \"$tag \".join(\" \", @v);\n       }\n   }\n   $str2 .= join(' ; ', @group);\n   # Add Target information for Feature Pairs\n   if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n       ! $feat->has_tag('Group') &&\n       $origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n       $str2 = sprintf(\"Target %s %d %d\", $origfeat->feature1->seq_id,\n\t\t       ( $origfeat->feature1->strand < 0 ? \n\t\t\t ( $origfeat->feature1->end,\n\t\t\t   $origfeat->feature1->start) :\n\t\t\t ( $origfeat->feature1->start,\n\t\t\t   $origfeat->feature1->end) \n\t\t\t )) . ($str2?\" ; \".$str2:\"\");  # need to put Target information before other tag/value pairs - mw\n   }\n   return $str1.\"\\t\".$str2;\n}\n\n\n\n=head2 _gff25_string\n\n Title   : _gff25_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: To get a format of GFF that is peculiar to Gbrowse/Bio::DB::GFF\n Example :\n Returns : A GFF2.5-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2.5-stringified","label":"_gff25_string($gff,$origfeat)"}},{"children":[{"definition":"my","name":"$gff","localvar":"my","containerName":"_gff3_string","kind":13,"line":981},{"kind":13,"containerName":"_gff3_string","name":"$origfeat","line":981},{"definition":"my","name":"$feat","localvar":"my","kind":13,"containerName":"_gff3_string","line":982},{"kind":13,"containerName":"_gff3_string","name":"$origfeat","line":983},{"containerName":"_gff3_string","kind":12,"name":"isa","line":983},{"line":984,"name":"$feat","kind":13,"containerName":"_gff3_string"},{"containerName":"_gff3_string","kind":13,"name":"$origfeat","line":984},{"name":"feature2","kind":12,"containerName":"_gff3_string","line":984},{"line":986,"kind":13,"containerName":"_gff3_string","name":"$feat"},{"line":986,"name":"$origfeat","containerName":"_gff3_string","kind":13},{"localvar":"my","containerName":"_gff3_string","kind":13,"name":"$ID","line":989,"definition":"my"},{"name":"$gff","containerName":"_gff3_string","kind":13,"line":989},{"name":"_incrementGFF3ID","containerName":"_gff3_string","kind":12,"line":989},{"definition":"my","localvar":"my","containerName":"_gff3_string","kind":13,"name":"$score","line":991},{"kind":13,"containerName":"_gff3_string","name":"$frame","line":991},{"kind":13,"containerName":"_gff3_string","name":"$name","line":991},{"kind":13,"containerName":"_gff3_string","name":"$strand","line":991},{"name":"$feat","containerName":"_gff3_string","kind":13,"line":993},{"containerName":"_gff3_string","kind":12,"name":"can","line":993},{"line":994,"name":"$score","kind":13,"containerName":"_gff3_string"},{"line":994,"kind":13,"containerName":"_gff3_string","name":"$feat"},{"line":994,"kind":12,"containerName":"_gff3_string","name":"score"},{"containerName":"_gff3_string","kind":13,"name":"$score","line":996},{"line":996,"containerName":"_gff3_string","kind":13,"name":"$score"},{"line":998,"name":"$feat","containerName":"_gff3_string","kind":13},{"line":998,"name":"can","containerName":"_gff3_string","kind":12},{"kind":13,"containerName":"_gff3_string","name":"$frame","line":999},{"line":999,"containerName":"_gff3_string","kind":13,"name":"$feat"},{"name":"frame","containerName":"_gff3_string","kind":12,"line":999},{"line":1001,"name":"$frame","kind":13,"containerName":"_gff3_string"},{"line":1001,"containerName":"_gff3_string","kind":13,"name":"$frame"},{"line":1003,"containerName":"_gff3_string","kind":13,"name":"$strand"},{"kind":13,"containerName":"_gff3_string","name":"$feat","line":1003},{"name":"strand","kind":12,"containerName":"_gff3_string","line":1003},{"name":"$strand","containerName":"_gff3_string","kind":13,"line":1005},{"name":"$strand","kind":13,"containerName":"_gff3_string","line":1006},{"line":1007,"name":"$strand","kind":13,"containerName":"_gff3_string"},{"name":"$strand","kind":13,"containerName":"_gff3_string","line":1008},{"line":1009,"name":"$feat","kind":13,"containerName":"_gff3_string"},{"line":1009,"containerName":"_gff3_string","kind":12,"name":"strand"},{"name":"$strand","containerName":"_gff3_string","kind":13,"line":1010},{"name":"$feat","containerName":"_gff3_string","kind":13,"line":1013},{"line":1013,"name":"can","containerName":"_gff3_string","kind":12},{"line":1014,"kind":13,"containerName":"_gff3_string","name":"$name"},{"line":1014,"kind":13,"containerName":"_gff3_string","name":"$feat"},{"name":"seq_id","kind":12,"containerName":"_gff3_string","line":1014},{"line":1015,"kind":13,"containerName":"_gff3_string","name":"$name"},{"name":"$name","containerName":"_gff3_string","kind":13,"line":1017},{"name":"@groups","containerName":"_gff3_string","localvar":"my","kind":13,"line":1020,"definition":"my"},{"line":1023,"name":"@all_tags","kind":13,"localvar":"my","containerName":"_gff3_string","definition":"my"},{"containerName":"_gff3_string","kind":13,"name":"$GFF3_ID_Tags","line":1023},{"name":"$feat","containerName":"_gff3_string","kind":13,"line":1023},{"kind":12,"containerName":"_gff3_string","name":"all_tags","line":1023},{"line":1024,"localvar":"my","kind":13,"containerName":"_gff3_string","name":"$t","definition":"my"},{"containerName":"_gff3_string","kind":13,"name":"$GFF3_ID_Tags","line":1024},{"line":1024,"name":"$b","kind":13,"containerName":"_gff3_string"},{"line":1024,"name":"$GFF3_ID_Tags","containerName":"_gff3_string","kind":13},{"line":1024,"kind":13,"containerName":"_gff3_string","name":"$a"},{"name":"%GFF3_ID_Tags","kind":13,"containerName":"_gff3_string","line":1025},{"name":"@all_tags","kind":13,"containerName":"_gff3_string","line":1026},{"name":"$t","kind":13,"containerName":"_gff3_string","line":1026},{"line":1026,"containerName":"_gff3_string","kind":13,"name":"$feat"},{"name":"has_tag","kind":12,"containerName":"_gff3_string","line":1026},{"line":1026,"containerName":"_gff3_string","kind":13,"name":"$t"},{"line":1029,"localvar":"my","kind":13,"containerName":"_gff3_string","name":"$tag","definition":"my"},{"line":1029,"name":"@all_tags","kind":13,"containerName":"_gff3_string"},{"name":"$tag","kind":13,"containerName":"_gff3_string","line":1031},{"containerName":"_gff3_string","kind":13,"name":"$origfeat","line":1031},{"containerName":"_gff3_string","kind":12,"name":"isa","line":1031},{"line":1033,"localvar":"my","containerName":"_gff3_string","kind":13,"name":"$target_id","definition":"my"},{"line":1033,"name":"$b","containerName":"_gff3_string","kind":13},{"line":1033,"containerName":"_gff3_string","kind":13,"name":"$e"},{"name":"$strand","containerName":"_gff3_string","kind":13,"line":1033},{"name":"$feat","kind":13,"containerName":"_gff3_string","line":1033},{"kind":12,"containerName":"_gff3_string","name":"get_tag_values","line":1033},{"name":"$tag","kind":13,"containerName":"_gff3_string","line":1033},{"name":"$e","containerName":"_gff3_string","kind":13,"line":1034},{"containerName":"_gff3_string","kind":13,"name":"$b","line":1034},{"kind":13,"containerName":"_gff3_string","name":"$target_id","line":1034},{"line":1035,"kind":13,"containerName":"_gff3_string","name":"$b"},{"kind":13,"containerName":"_gff3_string","name":"$e","line":1035},{"containerName":"_gff3_string","kind":13,"name":"$e","line":1035},{"line":1035,"containerName":"_gff3_string","kind":13,"name":"$b"},{"containerName":"_gff3_string","kind":13,"name":"$strand","line":1035},{"containerName":"_gff3_string","kind":13,"name":"$strand","line":1035},{"name":"$target_id","kind":13,"containerName":"_gff3_string","line":1036},{"line":1037,"containerName":"_gff3_string","kind":13,"name":"@groups"},{"containerName":"_gff3_string","kind":13,"name":"$target_id","line":1037},{"line":1037,"kind":13,"containerName":"_gff3_string","name":"$b"},{"name":"$e","containerName":"_gff3_string","kind":13,"line":1037},{"line":1041,"containerName":"_gff3_string","localvar":"my","kind":13,"name":"$valuestr","definition":"my"},{"localvar":"my","kind":13,"containerName":"_gff3_string","name":"@v","line":1045,"definition":"my"},{"definition":"my","line":1046,"kind":13,"localvar":"my","containerName":"_gff3_string","name":"$value"},{"line":1046,"kind":13,"containerName":"_gff3_string","name":"$feat"},{"line":1046,"name":"each_tag_value","kind":12,"containerName":"_gff3_string"},{"line":1046,"containerName":"_gff3_string","kind":13,"name":"$tag"},{"name":"$value","containerName":"_gff3_string","kind":13,"line":1047},{"containerName":"_gff3_string","kind":13,"name":"$value","line":1047},{"name":"$value","containerName":"_gff3_string","kind":13,"line":1049},{"name":"$value","kind":13,"containerName":"_gff3_string","line":1050},{"kind":13,"containerName":"_gff3_string","name":"$value","line":1050},{"name":"text","kind":12,"containerName":"_gff3_string","line":1050},{"name":"$value","kind":13,"containerName":"_gff3_string","line":1053},{"name":"$value","containerName":"_gff3_string","kind":13,"line":1054},{"containerName":"_gff3_string","kind":13,"name":"$value","line":1056},{"name":"$value","kind":13,"containerName":"_gff3_string","line":1061},{"line":1066,"kind":13,"containerName":"_gff3_string","name":"$value"},{"line":1068,"name":"@v","kind":13,"containerName":"_gff3_string"},{"line":1068,"containerName":"_gff3_string","kind":13,"name":"$value"},{"line":1071,"name":"$tag","containerName":"_gff3_string","kind":13},{"name":"$tag","kind":13,"containerName":"_gff3_string","line":1071},{"line":1071,"kind":13,"containerName":"_gff3_string","name":"$tag"},{"line":1074,"name":"@groups","containerName":"_gff3_string","kind":13},{"line":1074,"containerName":"_gff3_string","kind":13,"name":"@v"},{"name":"$feat","kind":13,"containerName":"_gff3_string","line":1077},{"name":"has_tag","containerName":"_gff3_string","kind":12,"line":1077},{"kind":13,"containerName":"_gff3_string","name":"$feat","line":1078},{"kind":12,"containerName":"_gff3_string","name":"has_tag","line":1078},{"line":1079,"kind":13,"containerName":"_gff3_string","name":"$origfeat"},{"line":1079,"name":"isa","kind":12,"containerName":"_gff3_string"},{"definition":"my","line":1081,"name":"$target_id","containerName":"_gff3_string","localvar":"my","kind":13},{"line":1081,"name":"$origfeat","containerName":"_gff3_string","kind":13},{"name":"feature1","kind":12,"containerName":"_gff3_string","line":1081},{"line":1081,"name":"seq_id","containerName":"_gff3_string","kind":12},{"name":"$target_id","kind":13,"containerName":"_gff3_string","line":1082},{"line":1084,"name":"@groups","kind":13,"containerName":"_gff3_string"},{"line":1085,"name":"$target_id","containerName":"_gff3_string","kind":13},{"line":1086,"name":"$origfeat","containerName":"_gff3_string","kind":13},{"line":1086,"name":"feature1","containerName":"_gff3_string","kind":12},{"line":1086,"containerName":"_gff3_string","kind":12,"name":"strand"},{"containerName":"_gff3_string","kind":13,"name":"$origfeat","line":1087},{"containerName":"_gff3_string","kind":12,"name":"feature1","line":1087},{"name":"end","containerName":"_gff3_string","kind":12,"line":1087},{"line":1088,"kind":13,"containerName":"_gff3_string","name":"$origfeat"},{"kind":12,"containerName":"_gff3_string","name":"feature1","line":1088},{"name":"start","kind":12,"containerName":"_gff3_string","line":1088},{"line":1089,"containerName":"_gff3_string","kind":13,"name":"$origfeat"},{"name":"feature1","containerName":"_gff3_string","kind":12,"line":1089},{"line":1089,"kind":12,"containerName":"_gff3_string","name":"start"},{"line":1090,"name":"$origfeat","kind":13,"containerName":"_gff3_string"},{"line":1090,"name":"feature1","kind":12,"containerName":"_gff3_string"},{"line":1090,"containerName":"_gff3_string","kind":12,"name":"end"},{"line":1095,"name":"$feat","containerName":"_gff3_string","kind":13},{"line":1095,"name":"can","containerName":"_gff3_string","kind":12},{"containerName":"_gff3_string","kind":13,"name":"$feat","line":1095},{"kind":12,"containerName":"_gff3_string","name":"name","line":1095},{"line":1097,"name":"@groups","containerName":"_gff3_string","kind":13},{"containerName":"_gff3_string","kind":13,"name":"$feat","line":1097},{"line":1097,"kind":12,"containerName":"_gff3_string","name":"name"},{"definition":"my","line":1100,"name":"$gff_string","localvar":"my","containerName":"_gff3_string","kind":13},{"name":"$feat","kind":13,"containerName":"_gff3_string","line":1101},{"line":1101,"name":"location","kind":12,"containerName":"_gff3_string"},{"containerName":"_gff3_string","kind":12,"name":"isa","line":1101},{"definition":"my","name":"@locs","kind":13,"localvar":"my","containerName":"_gff3_string","line":1102},{"kind":13,"containerName":"_gff3_string","name":"$feat","line":1102},{"name":"location","kind":12,"containerName":"_gff3_string","line":1102},{"line":1102,"containerName":"_gff3_string","kind":12,"name":"each_Location"},{"definition":"my","localvar":"my","containerName":"_gff3_string","kind":13,"name":"$loc","line":1103},{"name":"@locs","containerName":"_gff3_string","kind":13,"line":1103},{"kind":13,"containerName":"_gff3_string","name":"$gff_string","line":1104},{"name":"$name","kind":13,"containerName":"_gff3_string","line":1105},{"name":"$feat","kind":13,"containerName":"_gff3_string","line":1106},{"line":1106,"kind":12,"containerName":"_gff3_string","name":"source_tag"},{"name":"$feat","containerName":"_gff3_string","kind":13,"line":1107},{"line":1107,"containerName":"_gff3_string","kind":12,"name":"primary_tag"},{"kind":13,"containerName":"_gff3_string","name":"$loc","line":1108},{"kind":12,"containerName":"_gff3_string","name":"start","line":1108},{"line":1109,"name":"$loc","kind":13,"containerName":"_gff3_string"},{"name":"end","containerName":"_gff3_string","kind":12,"line":1109},{"line":1110,"containerName":"_gff3_string","kind":13,"name":"$score"},{"line":1111,"kind":13,"containerName":"_gff3_string","name":"$strand"},{"line":1112,"name":"$frame","kind":13,"containerName":"_gff3_string"},{"line":1113,"name":"@groups","containerName":"_gff3_string","kind":13},{"containerName":"_gff3_string","kind":13,"name":"$gff_string","line":1115},{"name":"$gff_string","kind":13,"containerName":"_gff3_string","line":1116},{"name":"$gff_string","containerName":"_gff3_string","kind":13,"line":1118},{"line":1119,"name":"$name","kind":13,"containerName":"_gff3_string"},{"kind":13,"containerName":"_gff3_string","name":"$feat","line":1120},{"kind":12,"containerName":"_gff3_string","name":"source_tag","line":1120},{"line":1121,"name":"$feat","kind":13,"containerName":"_gff3_string"},{"line":1121,"name":"primary_tag","containerName":"_gff3_string","kind":12},{"name":"$feat","kind":13,"containerName":"_gff3_string","line":1122},{"line":1122,"name":"start","containerName":"_gff3_string","kind":12},{"line":1123,"name":"$feat","kind":13,"containerName":"_gff3_string"},{"containerName":"_gff3_string","kind":12,"name":"end","line":1123},{"line":1124,"kind":13,"containerName":"_gff3_string","name":"$score"},{"name":"$strand","kind":13,"containerName":"_gff3_string","line":1125},{"name":"$frame","containerName":"_gff3_string","kind":13,"line":1126},{"name":"@groups","containerName":"_gff3_string","kind":13,"line":1127},{"name":"$gff_string","containerName":"_gff3_string","kind":13,"line":1129}],"containerName":"main::","name":"_gff3_string","definition":"sub","detail":"($gff,$origfeat)","line":980,"range":{"end":{"character":9999,"line":1130},"start":{"character":0,"line":980}},"kind":12,"signature":{"label":"_gff3_string($gff,$origfeat)","documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified\n\n\nsub _gff2_string{\n   my ($gff, $origfeat) = @_;\n    my $feat;\n   if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n       $feat = $origfeat->feature2;\n   } else {\n       $feat = $origfeat;\n   }\n   my ($str1, $str2,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n\n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n   $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n   # the routine below is the only modification I made to the original\n   # ->gff_string routine (above) as on November 17th, 2000, the\n   # Sanger webpage describing GFF2 format reads: \"From version 2\n   # onwards, the attribute field must have a tag value structure\n   # following the syntax used within objects in a .ace file,\n   # flattened onto one line by semicolon separators. Tags must be\n   # standard identifiers ([A-Za-z][A-Za-z0-9_]*).  Free text values\n   # must be quoted with double quotes\".\n\n   # MW\n\n   \n   my @all_tags = $feat->all_tags;\n   my @group;\n   if (@all_tags) {  # only play this game if it is worth playing...\n       foreach my $tag ( @all_tags ) {\n\t   my @v;\n\t   foreach my $value ( $feat->each_tag_value($tag) ) {\n \t       unless( defined $value && length($value) ) {\n\t\t   $value = '\"\"';\n\t       } elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t   $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t                         # characters\n\t\t   $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t   $value = '\"' . $value . '\" ';\n\t       }                                 # if the value contains \n\t                                         # anything other than valid \n\t                                         # tag/value characters, then \n\t                                         # quote it\n\t       push @v, $value;\n\t       # for this tag (allowed in GFF2 and .ace format)\n\t   }\n\t   push @group, \"$tag \".join(\" \", @v);\n       }\n   }\n   $str2 .= join(' ; ', @group);\n   # Add Target information for Feature Pairs\n   if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n       ! $feat->has_tag('Group') &&\n       $origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n       $str2 = sprintf(\"Target %s %d %d\", $origfeat->feature1->seq_id,\n\t\t       ( $origfeat->feature1->strand < 0 ? \n\t\t\t ( $origfeat->feature1->end,\n\t\t\t   $origfeat->feature1->start) :\n\t\t\t ( $origfeat->feature1->start,\n\t\t\t   $origfeat->feature1->end) \n\t\t\t )) . ($str2?\" ; \".$str2:\"\");  # need to put Target information before other tag/value pairs - mw\n   }\n   return $str1.\"\\t\".$str2;\n}\n\n\n\n=head2 _gff25_string\n\n Title   : _gff25_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: To get a format of GFF that is peculiar to Gbrowse/Bio::DB::GFF\n Example :\n Returns : A GFF2.5-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2.5-stringified\n\n\nsub _gff25_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n    my ($str1, $str2,$score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n    $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n    my @all_tags = $feat->all_tags;\n    my @group; my @firstgroup;\n    if (@all_tags) {   # only play this game if it is worth playing...\n\tforeach my $tag ( @all_tags ) {\n\t    my @v;\n\t    foreach my $value ( $feat->each_tag_value($tag) ) {\n\t\tunless( defined $value && length($value) ) {\n\t\t    $value = '\"\"';\n\t\t} elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t    $value = '\"' . $value . '\" ';\n\t\t}\t\t# if the value contains \n\t\t# anything other than valid \n\t\t# tag/value characters, then \n\t\t# quote it\n\t\tpush @v, $value;\n\t\t# for this tag (allowed in GFF2 and .ace format)\n\t    }\n\t    if (($tag eq 'Group') || ($tag eq 'Target')){ # hopefully we wont get both...\n\t\tpush @firstgroup, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t    push @group, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t}\n\t}\n\t\t   }\n    $str2 = join(' ; ', (@firstgroup, @group));\n    # Add Target information for Feature Pairs\n    if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\t$str2 = sprintf(\"Target %s ; tstart %d ; tend %d\", $origfeat->feature1->seq_id,\n\t\t\t( $origfeat->feature1->strand < 0 ? \n\t\t\t  ( $origfeat->feature1->end,\n\t\t\t    $origfeat->feature1->start) :\n\t\t\t  ( $origfeat->feature1->start,\n\t\t\t    $origfeat->feature1->end) \n\t\t\t)) . ($str2?\" ; \".$str2:\"\"); # need to put the target info before other tag/value pairs - mw\n    }\n    return $str1 . \"\\t\".  $str2;\n}\n\n\n=head2 _gff3_string\n\n  Title   : _gff3_string\n  Usage   : $gffstr = $gffio->_gff3_string\n  Function: \n  Example :\n  Returns : A GFF3-formatted string representation of the SeqFeature\n  Args    : A Bio::SeqFeatureI implementing object to be GFF3-stringified","parameters":[{"label":"$gff"},{"label":"$origfeat"}]}},{"detail":"($self,$value)","definition":"sub","containerName":"main::","name":"gff_version","children":[{"definition":"my","localvar":"my","containerName":"gff_version","kind":13,"name":"$self","line":1144},{"line":1144,"name":"$value","kind":13,"containerName":"gff_version"},{"line":1145,"name":"$value","kind":13,"containerName":"gff_version"},{"kind":13,"containerName":"gff_version","name":"$value","line":1145},{"line":1146,"name":"$self","kind":13,"containerName":"gff_version"},{"name":"$value","containerName":"gff_version","kind":13,"line":1146},{"line":1148,"name":"$self","containerName":"gff_version","kind":13}],"signature":{"label":"gff_version($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified\n\n\nsub _gff2_string{\n   my ($gff, $origfeat) = @_;\n    my $feat;\n   if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n       $feat = $origfeat->feature2;\n   } else {\n       $feat = $origfeat;\n   }\n   my ($str1, $str2,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n\n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n   $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n   # the routine below is the only modification I made to the original\n   # ->gff_string routine (above) as on November 17th, 2000, the\n   # Sanger webpage describing GFF2 format reads: \"From version 2\n   # onwards, the attribute field must have a tag value structure\n   # following the syntax used within objects in a .ace file,\n   # flattened onto one line by semicolon separators. Tags must be\n   # standard identifiers ([A-Za-z][A-Za-z0-9_]*).  Free text values\n   # must be quoted with double quotes\".\n\n   # MW\n\n   \n   my @all_tags = $feat->all_tags;\n   my @group;\n   if (@all_tags) {  # only play this game if it is worth playing...\n       foreach my $tag ( @all_tags ) {\n\t   my @v;\n\t   foreach my $value ( $feat->each_tag_value($tag) ) {\n \t       unless( defined $value && length($value) ) {\n\t\t   $value = '\"\"';\n\t       } elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t   $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t                         # characters\n\t\t   $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t   $value = '\"' . $value . '\" ';\n\t       }                                 # if the value contains \n\t                                         # anything other than valid \n\t                                         # tag/value characters, then \n\t                                         # quote it\n\t       push @v, $value;\n\t       # for this tag (allowed in GFF2 and .ace format)\n\t   }\n\t   push @group, \"$tag \".join(\" \", @v);\n       }\n   }\n   $str2 .= join(' ; ', @group);\n   # Add Target information for Feature Pairs\n   if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n       ! $feat->has_tag('Group') &&\n       $origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n       $str2 = sprintf(\"Target %s %d %d\", $origfeat->feature1->seq_id,\n\t\t       ( $origfeat->feature1->strand < 0 ? \n\t\t\t ( $origfeat->feature1->end,\n\t\t\t   $origfeat->feature1->start) :\n\t\t\t ( $origfeat->feature1->start,\n\t\t\t   $origfeat->feature1->end) \n\t\t\t )) . ($str2?\" ; \".$str2:\"\");  # need to put Target information before other tag/value pairs - mw\n   }\n   return $str1.\"\\t\".$str2;\n}\n\n\n\n=head2 _gff25_string\n\n Title   : _gff25_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: To get a format of GFF that is peculiar to Gbrowse/Bio::DB::GFF\n Example :\n Returns : A GFF2.5-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2.5-stringified\n\n\nsub _gff25_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n    my ($str1, $str2,$score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n    $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n    my @all_tags = $feat->all_tags;\n    my @group; my @firstgroup;\n    if (@all_tags) {   # only play this game if it is worth playing...\n\tforeach my $tag ( @all_tags ) {\n\t    my @v;\n\t    foreach my $value ( $feat->each_tag_value($tag) ) {\n\t\tunless( defined $value && length($value) ) {\n\t\t    $value = '\"\"';\n\t\t} elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t    $value = '\"' . $value . '\" ';\n\t\t}\t\t# if the value contains \n\t\t# anything other than valid \n\t\t# tag/value characters, then \n\t\t# quote it\n\t\tpush @v, $value;\n\t\t# for this tag (allowed in GFF2 and .ace format)\n\t    }\n\t    if (($tag eq 'Group') || ($tag eq 'Target')){ # hopefully we wont get both...\n\t\tpush @firstgroup, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t    push @group, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t}\n\t}\n\t\t   }\n    $str2 = join(' ; ', (@firstgroup, @group));\n    # Add Target information for Feature Pairs\n    if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\t$str2 = sprintf(\"Target %s ; tstart %d ; tend %d\", $origfeat->feature1->seq_id,\n\t\t\t( $origfeat->feature1->strand < 0 ? \n\t\t\t  ( $origfeat->feature1->end,\n\t\t\t    $origfeat->feature1->start) :\n\t\t\t  ( $origfeat->feature1->start,\n\t\t\t    $origfeat->feature1->end) \n\t\t\t)) . ($str2?\" ; \".$str2:\"\"); # need to put the target info before other tag/value pairs - mw\n    }\n    return $str1 . \"\\t\".  $str2;\n}\n\n\n=head2 _gff3_string\n\n  Title   : _gff3_string\n  Usage   : $gffstr = $gffio->_gff3_string\n  Function: \n  Example :\n  Returns : A GFF3-formatted string representation of the SeqFeature\n  Args    : A Bio::SeqFeatureI implementing object to be GFF3-stringified\n\n\nsub _gff3_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n\n    my $ID = $gff->_incrementGFF3ID();\n\n    my ($score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n\n    my @groups;\n\n    # force leading ID and Parent tags\n    my @all_tags =  grep { ! exists $GFF3_ID_Tags{$_} } $feat->all_tags;\n    for my $t ( sort { $GFF3_ID_Tags{$b} <=> $GFF3_ID_Tags{$a} }\n\t\tkeys %GFF3_ID_Tags ) {\n\tunshift @all_tags, $t if $feat->has_tag($t);\n    }\n\n    for my $tag ( @all_tags ) {\n\t# next if $tag eq 'Target';\n\tif ($tag eq 'Target' && ! $origfeat->isa('Bio::SeqFeature::FeaturePair')){  \n\t    # simple Target,start,stop\n\t    my($target_id, $b,$e,$strand) = $feat->get_tag_values($tag); \n\t    next unless(defined($e) && defined($b) && $target_id);\t\t\t\n\t    ($b,$e)= ($e,$b) if(defined $strand && $strand<0);\n\t    $target_id =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;    \n\t    push @groups, sprintf(\"Target=%s %d %d\", $target_id,$b,$e);\n\t    next;\n\t}\n\n\tmy $valuestr;\t\n\t# a string which will hold one or more values \n\t# for this tag, with quoted free text and \n\t# space-separated individual values.\n\tmy @v;\n\tfor my $value ( $feat->each_tag_value($tag) ) {\t    \n\t    if(  defined $value && length($value) ) { \n\t\t\t\t#$value =~ tr/ /+/;  #spaces are allowed now\n                if ( ref $value eq 'Bio::Annotation::Comment') {\n                    $value = $value->text;\n                }\n\n\t\tif ($value =~ /[^a-zA-Z0-9\\,\\;\\=\\.:\\%\\^\\*\\$\\@\\!\\+\\_\\?\\-]/) {\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\n\t\t    # Unescaped quotes are not allowed in GFF3\n\t\t    #\t\t    $value = '\"' . $value . '\"';\n\t\t}\n\t\t$value =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;\n\t    } else {\n\t\t\t\t# if it is completely empty, \n\t\t\t\t# then just make empty double \n\t\t\t\t# quotes\n\t\t$value = '\"\"';\n\t    }\n\t    push @v, $value;\n\t}\n\t# can we figure out how to improve this?\n\t$tag= lcfirst($tag) unless ($tag \n\t\t\t\t    =~ /^(ID|Name|Alias|Parent|Gap|Target|Derives_from|Note|Dbxref|Ontology_term)$/);\n\n\tpush @groups, \"$tag=\".join(\",\",@v);\n    }\n    # Add Target information for Feature Pairs\n    if( $feat->has_tag('Target') && \n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\n\tmy $target_id = $origfeat->feature1->seq_id;\n\t$target_id =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;    \n\n\tpush @groups, sprintf(\"Target=%s %d %d\", \n\t\t\t      $target_id,\n\t\t\t      ( $origfeat->feature1->strand < 0 ? \n\t\t\t\t( $origfeat->feature1->end,\n\t\t\t\t  $origfeat->feature1->start) :\n\t\t\t\t( $origfeat->feature1->start,\n\t\t\t\t  $origfeat->feature1->end) \n\t\t\t\t));\n    }\n\n    # unshift @groups, \"ID=autogenerated$ID\" unless ($feat->has_tag('ID'));\n    if ( $feat->can('name') && defined($feat->name) ) {\n\t# such as might be for Bio::DB::SeqFeature\n\tunshift @groups, 'Name=' . $feat->name;\n    }\n\n    my $gff_string = \"\";\n    if ($feat->location->isa(\"Bio::Location::SplitLocationI\")) {\n\tmy @locs = $feat->location->each_Location;\n\tforeach my $loc (@locs) {\n\t    $gff_string .= join(\"\\t\",\n\t\t\t\t$name,\n\t\t\t\t$feat->source_tag() || '.',\n\t\t\t\t$feat->primary_tag(),\n\t\t\t\t$loc->start(),\n\t\t\t\t$loc->end(),\n\t\t\t\t$score,\n\t\t\t\t$strand,\n\t\t\t\t$frame,\n\t\t\t\tjoin(';', @groups)) . \"\\n\";\n\t}\n\tchop $gff_string;\n\treturn $gff_string;\n    } else {\n\t$gff_string = join(\"\\t\",\n\t\t\t   $name,\n\t\t\t   $feat->source_tag() || '.',\n\t\t\t   $feat->primary_tag(),\n\t\t\t   $feat->start(),\n\t\t\t   $feat->end(),\n\t\t\t   $score,\n\t\t\t   $strand,\n\t\t\t   $frame, \n\t\t\t   join(';', @groups));\n    }\n    return $gff_string;\n}\n\n=head2 gff_version\n\n  Title   : _gff_version\n  Usage   : $gffversion = $gffio->gff_version\n  Function: \n  Example :\n  Returns : The GFF version this parser will accept and emit.\n  Args    : none"},"kind":12,"range":{"end":{"line":1149,"character":9999},"start":{"line":1143,"character":0}},"line":1143},{"children":[{"definition":"my","name":"$class","localvar":"my","kind":13,"containerName":"newFh","line":1168},{"name":"$self","containerName":"newFh","localvar":"my","kind":13,"line":1169,"definition":"my"},{"name":"$class","containerName":"newFh","kind":13,"line":1169},{"line":1169,"name":"new","containerName":"newFh","kind":12},{"name":"$self","kind":13,"containerName":"newFh","line":1170},{"name":"fh","kind":12,"containerName":"newFh","line":1170}],"containerName":"main::","name":"newFh","definition":"sub","line":1167,"range":{"start":{"character":0,"line":1167},"end":{"line":1171,"character":9999}},"kind":12},{"children":[{"definition":"my","name":"$self","localvar":"my","containerName":"fh","kind":13,"line":1189},{"definition":"my","name":"$class","localvar":"my","containerName":"fh","kind":13,"line":1190},{"name":"$self","kind":13,"containerName":"fh","line":1190},{"line":1190,"name":"$self","kind":13,"containerName":"fh"},{"line":1191,"kind":13,"localvar":"my","containerName":"fh","name":"$s","definition":"my"},{"line":1192,"name":"$class","kind":13,"containerName":"fh"},{"line":1192,"name":"$self","kind":13,"containerName":"fh"},{"line":1193,"name":"$s","kind":13,"containerName":"fh"}],"containerName":"main::","name":"fh","definition":"sub","line":1188,"range":{"start":{"character":0,"line":1188},"end":{"character":9999,"line":1194}},"kind":12},{"line":1192,"containerName":"gensym","kind":12,"name":"Symbol"},{"name":"_seq_by_id_h","containerName":"main::","children":[{"line":1204,"kind":13,"localvar":"my","containerName":"_seq_by_id_h","name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"_seq_by_id_h","line":1206},{"kind":13,"containerName":"_seq_by_id_h","name":"$self","line":1207},{"line":1208,"kind":13,"containerName":"_seq_by_id_h","name":"$self"},{"containerName":"_seq_by_id_h","kind":13,"name":"$self","line":1209}],"definition":"sub","range":{"end":{"character":9999,"line":1210},"start":{"line":1203,"character":0}},"kind":12,"line":1203},{"detail":"($self,@args)","definition":"sub","name":"get_seqs","containerName":"main::","children":[{"definition":"my","localvar":"my","containerName":"get_seqs","kind":13,"name":"$self","line":1224},{"line":1224,"containerName":"get_seqs","kind":13,"name":"@args"},{"containerName":"get_seqs","kind":13,"name":"$self","line":1225},{"kind":12,"containerName":"get_seqs","name":"_seq_by_id_h","line":1225}],"signature":{"label":"get_seqs($self,@args)","documentation":"1;\n# $Id: GFF.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::GFF\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by the Bioperl core team\n#\n# Copyright Matthew Pocock\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::GFF - A Bio::SeqAnalysisParserI compliant GFF format parser\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::GFF;\n\n    # specify input via -fh or -file\n    my $gffio = Bio::Tools::GFF->new(-fh => \\*STDIN, -gff_version => 2);\n    my $feature;\n    # loop over the input stream\n    while($feature = $gffio->next_feature()) {\n        # do something with feature\n    }\n    $gffio->close();\n\n    # you can also obtain a GFF parser as a SeqAnalasisParserI in\n    # HT analysis pipelines (see Bio::SeqAnalysisParserI and\n    # Bio::Factory::SeqAnalysisParserFactory)\n    my $factory = Bio::Factory::SeqAnalysisParserFactory->new();\n    my $parser = $factory->get_parser(-input => \\*STDIN, -method => \"gff\");\n    while($feature = $parser->next_feature()) {\n        # do something with feature\n    }\n\n=head1 DESCRIPTION\n\nThis class provides a simple GFF parser and writer. In the sense of a\nSeqAnalysisParser, it parses an input file or stream into SeqFeatureI\nobjects, but is not in any way specific to a particular analysis\nprogram and the output that program produces.\n\nThat is, if you can get your analysis program spit out GFF, here is\nyour result parser.\n\n=head1 GFF3 AND SEQUENCE DATA\n\nGFF3 supports sequence data; see\n\nhttp://www.sequenceontology.org/gff3.shtml\n\nThere are a number of ways to deal with this -\n\nIf you call\n\n  $gffio->ignore_sequence(1)\n\nprior to parsing the sequence data is ignored; this is useful if you\njust want the features. It avoids the memory overhead in building and\ncaching sequences\n\nAlternatively, you can call either\n\n  $gffio->get_seqs()\n\nOr\n\n  $gffio->seq_id_by_h()\n\nAt the B<end> of parsing to get either a list or hashref of Bio::Seq\nobjects (see the documentation for each of these methods)\n\nNote that these objects will not have the features attached - you have\nto do this yourself, OR call\n\n  $gffio->features_attached_to_seqs(1)\n\nPRIOR to parsing; this will ensure that the Seqs have the features\nattached; ie you will then be able to call\n\n  $seq->get_SeqFeatures();\n\nAnd use Bio::SeqIO methods\n\nNote that auto-attaching the features to seqs will incur a higher\nmemory overhead as the features must be cached until the sequence data\nis found\n\n=head1 TODO\n\nMake a Bio::SeqIO class specifically for GFF3 with sequence data\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Matthew Pocock\n\nEmail mrp-at-sanger.ac.uk\n\n=head1 CONTRIBUTORS \n\nJason Stajich, jason-at-biperl-dot-org\nChris Mungall, cjm-at-fruitfly-dot-org\nSteffen Grossmann [SG], grossman at molgen.mpg.de\nMalcolm Cook, mec-at-stowers-institute.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::GFF;\n\nuse vars qw($HAS_HTML_ENTITIES);\nuse strict;\n\nuse Bio::Seq::SeqFactory;\nuse Bio::LocatableSeq;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::SeqAnalysisParserI Bio::Root::IO);\n\nmy $i = 0;\nmy %GFF3_ID_Tags = map { $_ => $i++ } qw(ID Parent Target);\n\n=head2 new\n\n Title   : new\n Usage   : my $parser = Bio::Tools::GFF->new(-gff_version => 2,\n\t\t\t\t\t    -file        => \"filename.gff\");\n           or\n           my $writer = Bio::Tools::GFF->new(-gff_version => 3,\n\t\t\t\t\t    -file        => \">filename.gff3\");\n Function: Creates a new instance. Recognized named parameters are -file, -fh,\n           and -gff_version.\n Returns : a new object\n Args    : named parameters\n           -gff_version => [1,2,3]\n\n\n\n{   # make a class variable such that we can generate unique ID's over\n    # a session, no matter how many instances of GFF.pm we make\n    # since these have to be unique within the scope of a GFF file.\n    \n    my $gff3_featureID = 0;\n    \n    sub _incrementGFF3ID {\n        my ($self) = @_;\n        return ++ $gff3_featureID;\n    }\n}\n\n\nsub new {\n  my ($class, @args) = @_;\n  my $self = $class->SUPER::new(@args);\n  \n  my ($gff_version, $noparse) = $self->_rearrange([qw(GFF_VERSION NOPARSE)],@args);\n\n  # initialize IO\n  $self->_initialize_io(@args);\n  $self->_parse_header() unless $noparse;\n\n  $gff_version ||= 2;\n  if( ! $self->gff_version($gff_version) )  {\n      $self->throw(\"Can't build a GFF object with the unknown version \".\n\t\t   $gff_version);\n  }\n  $self->{'_first'} = 1;\n  return $self;\n}\n\n=head2 _parse_header\n\n Title   : _parse_header\n Usage   : $gffio->_parse_header()\n Function: used to turn parse GFF header lines.  currently\n           produces Bio::LocatableSeq objects from ##sequence-region\n           lines\n Returns : 1 on success\n Args    : none\n\n\n\nsub _parse_header{\n   my ($self) = @_;\n\n   my @unhandled;\n   local $^W = 0; # hide warnings when we try and parse from a file opened\n                  # for writing - there isn't really a better way to do\n                  # AFAIK - cannot detech if a FH is read or write.\n   while(my $line = $self->_readline()){\n \t my $handled = 0;\n\t next if /^\\s+$/;\n\t if($line =~ /^\\#\\#sequence-region\\s+(\\S+)\\s+(\\S+)\\s+(\\S+)\\s*/){\n\t   my($seqid,$start,$end) = ($1,$2,$3);\n\t   push @{ $self->{'segments'} }, Bio::LocatableSeq->new\n\t       (\n\t\t-id    => unescape($seqid),\n\t\t-start => $start,\n\t\t-end   => $end,\n                -length => ($end - $start + 1),  ## make the length explicit\n\t\t);\n\t   $handled = 1;\n\t } elsif($line =~ /^(\\#\\#feature-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#attribute-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#source-ontology)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#\\#)/) {\n\t   #to be implemented\n\t   $self->warn(\"$1 header tag parsing unimplemented\");\n\t } elsif($line =~ /^(\\#\\#FASTA)/) {\n            # initial ##FASTA is optional - artemis does not use it\n            $line = $self->_readline();\n            if ($line !~ /^\\>(\\S+)/) {\n                $self->throw(\"##FASTA directive must be followed by fasta header, not: $line\");\n            }\n\t } else {\n         }\n         \n         if ($line =~ /^\\>(.*)/) {\n             # seq data can be at header or footer\n             my $seq = $self->_parse_sequence($line);\n             if ($seq) {\n                 $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n             }\n         }\n             \n\n \t if(!$handled){\n\t   push @unhandled, $line\n \t }\n\n\t #looks like the header is over!\n\t last unless $line =~ /^\\#/;\n   }\n\n   foreach my $line (@unhandled){\n\t $self->_pushback($line);\n   }\n\n   return 1;\n}\n\nsub _parse_sequence {\n    my ($self, $line) = @_;\n\n    if ($line =~ /^\\>(.*)/) {\n        \n        my $seqid = $1;\n        $seqid =~ s/\\s+$//;\n        my $desc = '';\n        if ($seqid =~ /(\\S+)\\s+(.*)/) {\n            ($seqid, $desc) = ($1,$2);\n        }\n        my $res = '';\n        while (my $line = $self->_readline) {\n            if ($line =~ /^\\#/) {\n                last;\n            }\n            if ($line =~ /^\\>/) {\n                $self->_pushback($line);\n                last;\n            }\n            $line =~ s/\\s//g;\n            $res .= $line;\n        }\n        return if $self->ignore_sequence;\n\n        my $seqfactory = Bio::Seq::SeqFactory->new('Bio::Seq');\n        my $seq = $seqfactory->create(-seq=>$res, \n                                      -id=>$seqid,\n                                      -desc=>$desc);\n        $seq->accession_number($seqid);\n        if ($self->features_attached_to_seqs) {\n            my @feats = \n              @{$self->_feature_idx_by_seq_id->{$seqid}};\n            $seq->add_SeqFeature($_) foreach @feats;\n            @{$self->_feature_idx_by_seq_id->{$seqid}} = ();\n        }\n        return $seq;\n    }\n    else {\n        $self->throw(\"expected fasta header, not: $line\");\n    }\n}\n\n\n=head2 next_segment\n\n Title   : next_segment\n Usage   : my $seq = $gffio->next_segment;\n Function: Returns a Bio::LocatableSeq object corresponding to a \n           GFF \"##sequence-region\" header line.\n Example :\n Returns : A Bio::LocatableSeq object, or undef if\n           there are no more sequences.\n Args    : none\n\n\n\nsub next_segment{\n   my ($self,@args) = @_;\n   return shift @{ $self->{'segments'} } if defined $self->{'segments'};\n   return;\n}\n\n=head2 next_feature\n\n Title   : next_feature\n Usage   : $seqfeature = $gffio->next_feature();\n Function: Returns the next feature available in the input file or stream, or\n           undef if there are no more features.\n Example :\n Returns : A Bio::SeqFeatureI implementing object, or undef if there are no\n           more features.\n Args    : none    \n\n\nsub next_feature {\n    my ($self) = @_;\n    \n    my $gff_string;\n    \n    # be graceful about empty lines or comments, and make sure we return undef\n    # if the input's consumed\n    while(($gff_string = $self->_readline()) && defined($gff_string)) {\t\n        if ($gff_string =~ /^\\#\\#\\#/) {\n            # all forward refs have been seen; TODO\n        }\n        next if($gff_string =~ /^\\#/ || $gff_string =~ /^\\s*$/ ||\n                $gff_string =~ m{^//});\n\n        while ($gff_string =~ /^\\>(.+)/) {\n            # fasta can be in header or footer\n            my $seq = $self->_parse_sequence($gff_string);\n            if ($seq) {\n                $self->_seq_by_id_h->{$seq->primary_id} = $seq;\n                $gff_string = $self->_readline;\n                last unless $gff_string;\n            }\n        }\n        last; \n    }\n    return unless $gff_string;\n\n    my $feat = Bio::SeqFeature::Generic->new();\n    $self->from_gff_string($feat, $gff_string);\n\n    if ($self->features_attached_to_seqs) {\n        push(@{$self->_feature_idx_by_seq_id->{$feat->seq_id}},\n             $feat);\n    }\n\n    return $feat;\n}\n\nsub _feature_idx_by_seq_id {\n    my $self = shift;\n    $self->{__feature_idx_by_seq_id} = shift if @_;\n    $self->{__feature_idx_by_seq_id} = {}\n      unless $self->{__feature_idx_by_seq_id};\n    return $self->{__feature_idx_by_seq_id};\n}\n\n\n=head2 from_gff_string\n\n Title   : from_gff_string\n Usage   : $gff->from_gff_string($feature, $gff_string);\n Function: Sets properties of a SeqFeatureI object from a GFF-formatted\n           string. Interpretation of the string depends on the version\n           that has been specified at initialization.\n\n           This method is used by next_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub from_gff_string {\n    my ($self, $feat, $gff_string) = @_;\n\n    if($self->gff_version() == 1)  {\n\treturn $self->_from_gff1_string($feat, $gff_string);\n    } elsif( $self->gff_version() == 3 ) {\n\treturn $self->_from_gff3_string($feat, $gff_string);\n    } else {\n\treturn $self->_from_gff2_string($feat, $gff_string);\n    }\n}\n\n=head2 _from_gff1_string\n\n Title   : _from_gff1_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF-formatted string to initialize it from\n\n\nsub _from_gff1_string {\n   my ($gff, $feat, $string) = @_;\n   chomp $string;\n   my ($seqname, $source, $primary, $start, $end, $score, \n       $strand, $frame, @group) = split(/\\t/, $string);\n\n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF to me\");\n   }\n   $frame = 0 unless( $frame =~ /^\\d+$/);\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       #$feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n   foreach my $g ( @group ) {\n       if ( $g =~ /(\\S+)=(\\S+)/ ) {\n\t   my $tag = $1;\n\t   my $value = $2;\n\t   $feat->add_tag_value($1, $2);\n       } else {\n\t   $feat->add_tag_value('group', $g);\n       }\n   }\n}\n\n=head2 _from_gff2_string\n\n Title   : _from_gff2_string\n Usage   :\n Function:\n Example :\n Returns : void\n Args    : A Bio::SeqFeatureI implementing object to be initialized\n           The GFF2-formatted string to initialize it from\n\n\n\nsub _from_gff2_string {\n   my ($gff, $feat, $string) = @_;\n   chomp($string);\n\n   # according to the Sanger website, GFF2 should be single-tab\n   # separated elements, and the free-text at the end should contain\n   # text-translated tab symbols but no \"real\" tabs, so splitting on\n   # \\t is safe, and $attribs gets the entire attributes field to be\n   # parsed later\n   \n   # sendu: but the tag value pair can (should?) be separated by a tab. The\n   # 'no tabs' thing seems to apply only to the free text that is allowed for\n   # the value\n\n   my ($seqname, $source, $primary, $start, \n       $end, $score, $strand, $frame, @attribs) = split(/\\t+/, $string);\n   my $attribs = join ' ', @attribs;\n   \n   if ( !defined $frame ) {\n       $feat->throw(\"[$string] does not look like GFF2 to me\");\n   }\n   $feat->seq_id($seqname);\n   $feat->source_tag($source);\n   $feat->primary_tag($primary);\n   $feat->start($start);\n   $feat->end($end);\n   $feat->frame($frame);\n   if ( $score eq '.' ) {\n       # $feat->score(undef);\n   } else {\n       $feat->score($score);\n   }\n   if ( $strand eq '-' ) { $feat->strand(-1); }\n   if ( $strand eq '+' ) { $feat->strand(1); }\n   if ( $strand eq '.' ) { $feat->strand(0); }\n\n\n   #  <Begin Inefficient Code from Mark Wilkinson> \n   # this routine is necessay to allow the presence of semicolons in\n   # quoted text Semicolons are the delimiting character for new\n   # tag/value attributes.  it is more or less a \"state\" machine, with\n   # the \"quoted\" flag going up and down as we pass thorugh quotes to\n   # distinguish free-text semicolon and hash symbols from GFF control\n   # characters\n   \n   \n   my $flag = 0; # this could be changed to a bit and just be twiddled\n   my @parsed;\n\n   # run through each character one at a time and check it\n   # NOTE: changed to foreach loop which is more efficient in perl\n   # --jasons\n   for my $a ( split //, $attribs ) { \n       # flag up on entering quoted text, down on leaving it\n       if( $a eq '\"') { $flag = ( $flag == 0 ) ? 1:0 }\n       elsif( $a eq ';' && $flag ) { $a = \"INSERT_SEMICOLON_HERE\"}\n       elsif( $a eq '#' && ! $flag ) { last } \n       push @parsed, $a;\n   }\n   $attribs = join \"\", @parsed; # rejoin into a single string\n\n   # <End Inefficient Code>   \n   # Please feel free to fix this and make it more \"perlish\"\n\n   my @key_vals = split /;/, $attribs;   # attributes are semicolon-delimited\n\n   foreach my $pair ( @key_vals ) {\n       # replace semicolons that were removed from free-text above.\n       $pair =~ s/INSERT_SEMICOLON_HERE/;/g;        \n\n       # separate the key from the value\n       my ($blank, $key, $values) = split  /^\\s*([\\w\\d]+)\\s/, $pair; \n\n\n       if( defined $values ) {\n\t   my @values;\n\t   # free text is quoted, so match each free-text block\n\t   # and remove it from the $values string\n\t   while ($values =~ s/\"(.*?)\"//){\n\t       # and push it on to the list of values (tags may have\n\t       # more than one value... and the value may be undef)\t       \n\t       push @values, $1;\n\t   }\n\n\t   # and what is left over should be space-separated\n\t   # non-free-text values\n\n\t   my @othervals = split /\\s+/, $values;  \n\t   foreach my $othervalue(@othervals){\n\t       # get rid of any empty strings which might \n\t       # result from the split\n\t       if (CORE::length($othervalue) > 0) {push @values, $othervalue}  \n\t   }\n\n\t   foreach my $value(@values){\n\t       $feat->add_tag_value($key, $value);\n\t   }\n       }\n   }\n}\n\n\nsub _from_gff3_string {\n    my ($gff, $feat, $string) = @_;\n    chomp($string);\n\n    # according to the now nearly final GFF3 spec, columns should \n    # be tab separated, allowing unescaped spaces to occur in\n    # column 9\n\n    my ($seqname, $source, $primary, $start, $end, \n\t$score, $strand, $frame, $groups) = split(/\\t/, $string);\n    \n    if ( ! defined $frame ) {\n\t$feat->throw(\"[$string] does not look like GFF3 to me\");\n    }\n    $feat->seq_id($seqname);\n    $feat->source_tag($source);\n    $feat->primary_tag($primary);\n    $feat->start($start);\n    $feat->end($end);\n    $feat->frame($frame);\n    if ( $score eq '.' ) {\n\t#$feat->score(undef);\n    } else {\n\t$feat->score($score);\n    }\n    if ( $strand eq '-' ) { $feat->strand(-1); }\n    if ( $strand eq '+' ) { $feat->strand(1); }\n    if ( $strand eq '.' ) { $feat->strand(0); }\n    my @groups = split(/\\s*;\\s*/, $groups);\n\n    for my $group (@groups) {\n\tmy ($tag,$value) = split /=/,$group;\n\t$tag             = unescape($tag);\n\tmy @values       = map {unescape($_)} split /,/,$value;\n\tfor my $v ( @values ) {  $feat->add_tag_value($tag,$v); }\n    }\n}\n\n# taken from Bio::DB::GFF\nsub unescape {\n  my $v = shift;\n  $v =~ tr/+/ /;\n  $v =~ s/%([0-9a-fA-F]{2})/chr hex($1)/ge;\n  return $v;\n}\n\n=head2 write_feature\n\n Title   : write_feature\n Usage   : $gffio->write_feature($feature);\n Function: Writes the specified SeqFeatureI object in GFF format to the stream\n           associated with this instance.\n Returns : none\n Args    : An array of Bio::SeqFeatureI implementing objects to be serialized\n\n\nsub write_feature {\n    my ($self, @features) = @_;\n    return unless @features;\n    if( $self->{'_first'} && $self->gff_version() == 3 ) {\n\t$self->_print(\"##gff-version 3\\n\");\n    }\n    $self->{'_first'} = 0;\n    foreach my $feature ( @features ) {\n\t$self->_print($self->gff_string($feature).\"\\n\");\n    }\n}\n\n=head2 gff_string\n\n Title   : gff_string\n Usage   : $gffstr = $gffio->gff_string($feature);\n Function: Obtain the GFF-formatted representation of a SeqFeatureI object.\n           The formatting depends on the version specified at initialization.\n\n           This method is used by write_feature(). It actually dispatches to\n           one of the version-specific (private) methods.\n Example :\n Returns : A GFF-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub gff_string{\n    my ($self, $feature) = @_;\n\n    if($self->gff_version() == 1) {\n    \treturn $self->_gff1_string($feature);\n    } elsif( $self->gff_version() == 3 ) {\n    \treturn $self->_gff3_string($feature);\n    } elsif( $self->gff_version() == 2.5 ) {\n    \treturn $self->_gff25_string($feature);\n    } else {\n    \treturn $self->_gff2_string($feature);\n    }\n}\n\n=head2 _gff1_string\n\n Title   : _gff1_string\n Usage   : $gffstr = $gffio->_gff1_string\n Function: \n Example :\n Returns : A GFF1-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF-stringified\n\n\nsub _gff1_string{\n   my ($gff, $feat) = @_;\n   my ($str,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n   \n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n\n\n   $str = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n   foreach my $tag ( $feat->all_tags ) {\n       foreach my $value ( $feat->each_tag_value($tag) ) {\n\t   $str .= \" $tag=$value\" if $value;\n       }\n   }\n\n\n   return $str;\n}\n\n=head2 _gff2_string\n\n Title   : _gff2_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: \n Example :\n Returns : A GFF2-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2-stringified\n\n\nsub _gff2_string{\n   my ($gff, $origfeat) = @_;\n    my $feat;\n   if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n       $feat = $origfeat->feature2;\n   } else {\n       $feat = $origfeat;\n   }\n   my ($str1, $str2,$score,$frame,$name,$strand);\n\n   if( $feat->can('score') ) {\n       $score = $feat->score();\n   }\n   $score = '.' unless defined $score;\n\n   if( $feat->can('frame') ) {\n       $frame = $feat->frame();\n   }\n   $frame = '.' unless defined $frame;\n\n   $strand = $feat->strand();\n   if(! $strand) {\n       $strand = \".\";\n   } elsif( $strand == 1 ) {\n       $strand = '+';\n   } elsif ( $feat->strand == -1 ) {\n       $strand = '-';\n   }\n\n   if( $feat->can('seqname') ) {\n       $name = $feat->seq_id();\n       $name ||= 'SEQ';\n   } else {\n       $name = 'SEQ';\n   }\n   $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n   # the routine below is the only modification I made to the original\n   # ->gff_string routine (above) as on November 17th, 2000, the\n   # Sanger webpage describing GFF2 format reads: \"From version 2\n   # onwards, the attribute field must have a tag value structure\n   # following the syntax used within objects in a .ace file,\n   # flattened onto one line by semicolon separators. Tags must be\n   # standard identifiers ([A-Za-z][A-Za-z0-9_]*).  Free text values\n   # must be quoted with double quotes\".\n\n   # MW\n\n   \n   my @all_tags = $feat->all_tags;\n   my @group;\n   if (@all_tags) {  # only play this game if it is worth playing...\n       foreach my $tag ( @all_tags ) {\n\t   my @v;\n\t   foreach my $value ( $feat->each_tag_value($tag) ) {\n \t       unless( defined $value && length($value) ) {\n\t\t   $value = '\"\"';\n\t       } elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t   $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t                         # characters\n\t\t   $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t   $value = '\"' . $value . '\" ';\n\t       }                                 # if the value contains \n\t                                         # anything other than valid \n\t                                         # tag/value characters, then \n\t                                         # quote it\n\t       push @v, $value;\n\t       # for this tag (allowed in GFF2 and .ace format)\n\t   }\n\t   push @group, \"$tag \".join(\" \", @v);\n       }\n   }\n   $str2 .= join(' ; ', @group);\n   # Add Target information for Feature Pairs\n   if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n       ! $feat->has_tag('Group') &&\n       $origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n       $str2 = sprintf(\"Target %s %d %d\", $origfeat->feature1->seq_id,\n\t\t       ( $origfeat->feature1->strand < 0 ? \n\t\t\t ( $origfeat->feature1->end,\n\t\t\t   $origfeat->feature1->start) :\n\t\t\t ( $origfeat->feature1->start,\n\t\t\t   $origfeat->feature1->end) \n\t\t\t )) . ($str2?\" ; \".$str2:\"\");  # need to put Target information before other tag/value pairs - mw\n   }\n   return $str1.\"\\t\".$str2;\n}\n\n\n\n=head2 _gff25_string\n\n Title   : _gff25_string\n Usage   : $gffstr = $gffio->_gff2_string\n Function: To get a format of GFF that is peculiar to Gbrowse/Bio::DB::GFF\n Example :\n Returns : A GFF2.5-formatted string representation of the SeqFeature\n Args    : A Bio::SeqFeatureI implementing object to be GFF2.5-stringified\n\n\nsub _gff25_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n    my ($str1, $str2,$score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n    $str1 = join(\"\\t\",\n                 $name,\n\t\t $feat->source_tag(),\n\t\t $feat->primary_tag(),\n\t\t $feat->start(),\n\t\t $feat->end(),\n\t\t $score,\n\t\t $strand,\n\t\t $frame);\n\n    my @all_tags = $feat->all_tags;\n    my @group; my @firstgroup;\n    if (@all_tags) {   # only play this game if it is worth playing...\n\tforeach my $tag ( @all_tags ) {\n\t    my @v;\n\t    foreach my $value ( $feat->each_tag_value($tag) ) {\n\t\tunless( defined $value && length($value) ) {\n\t\t    $value = '\"\"';\n\t\t} elsif ($value =~ /[^A-Za-z0-9_]/){\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\t\t    $value = '\"' . $value . '\" ';\n\t\t}\t\t# if the value contains \n\t\t# anything other than valid \n\t\t# tag/value characters, then \n\t\t# quote it\n\t\tpush @v, $value;\n\t\t# for this tag (allowed in GFF2 and .ace format)\n\t    }\n\t    if (($tag eq 'Group') || ($tag eq 'Target')){ # hopefully we wont get both...\n\t\tpush @firstgroup, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t    push @group, \"$tag \".join(\" \", @v);\n\t\t\t\t\t\t\t}\n\t}\n\t\t   }\n    $str2 = join(' ; ', (@firstgroup, @group));\n    # Add Target information for Feature Pairs\n    if( ! $feat->has_tag('Target') && # This is a bad hack IMHO\n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\t$str2 = sprintf(\"Target %s ; tstart %d ; tend %d\", $origfeat->feature1->seq_id,\n\t\t\t( $origfeat->feature1->strand < 0 ? \n\t\t\t  ( $origfeat->feature1->end,\n\t\t\t    $origfeat->feature1->start) :\n\t\t\t  ( $origfeat->feature1->start,\n\t\t\t    $origfeat->feature1->end) \n\t\t\t)) . ($str2?\" ; \".$str2:\"\"); # need to put the target info before other tag/value pairs - mw\n    }\n    return $str1 . \"\\t\".  $str2;\n}\n\n\n=head2 _gff3_string\n\n  Title   : _gff3_string\n  Usage   : $gffstr = $gffio->_gff3_string\n  Function: \n  Example :\n  Returns : A GFF3-formatted string representation of the SeqFeature\n  Args    : A Bio::SeqFeatureI implementing object to be GFF3-stringified\n\n\nsub _gff3_string {\n    my ($gff, $origfeat) = @_;\n    my $feat;\n    if ($origfeat->isa('Bio::SeqFeature::FeaturePair')){\n\t$feat = $origfeat->feature2;\n    } else {\n\t$feat = $origfeat;\n    }\n\n    my $ID = $gff->_incrementGFF3ID();\n\n    my ($score,$frame,$name,$strand);\n\n    if( $feat->can('score') ) {\n\t$score = $feat->score();\n    }\n    $score = '.' unless defined $score;\n\n    if( $feat->can('frame') ) {\n\t$frame = $feat->frame();\n    }\n    $frame = '.' unless defined $frame;\n\n    $strand = $feat->strand();\n\n    if(! $strand) {\n\t$strand = \".\";\n    } elsif( $strand == 1 ) {\n\t$strand = '+';\n    } elsif ( $feat->strand == -1 ) {\n\t$strand = '-';\n    }\n\n    if( $feat->can('seqname') ) {\n\t$name = $feat->seq_id();\n\t$name ||= 'SEQ';\n    } else {\n\t$name = 'SEQ';\n    }\n\n    my @groups;\n\n    # force leading ID and Parent tags\n    my @all_tags =  grep { ! exists $GFF3_ID_Tags{$_} } $feat->all_tags;\n    for my $t ( sort { $GFF3_ID_Tags{$b} <=> $GFF3_ID_Tags{$a} }\n\t\tkeys %GFF3_ID_Tags ) {\n\tunshift @all_tags, $t if $feat->has_tag($t);\n    }\n\n    for my $tag ( @all_tags ) {\n\t# next if $tag eq 'Target';\n\tif ($tag eq 'Target' && ! $origfeat->isa('Bio::SeqFeature::FeaturePair')){  \n\t    # simple Target,start,stop\n\t    my($target_id, $b,$e,$strand) = $feat->get_tag_values($tag); \n\t    next unless(defined($e) && defined($b) && $target_id);\t\t\t\n\t    ($b,$e)= ($e,$b) if(defined $strand && $strand<0);\n\t    $target_id =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;    \n\t    push @groups, sprintf(\"Target=%s %d %d\", $target_id,$b,$e);\n\t    next;\n\t}\n\n\tmy $valuestr;\t\n\t# a string which will hold one or more values \n\t# for this tag, with quoted free text and \n\t# space-separated individual values.\n\tmy @v;\n\tfor my $value ( $feat->each_tag_value($tag) ) {\t    \n\t    if(  defined $value && length($value) ) { \n\t\t\t\t#$value =~ tr/ /+/;  #spaces are allowed now\n                if ( ref $value eq 'Bio::Annotation::Comment') {\n                    $value = $value->text;\n                }\n\n\t\tif ($value =~ /[^a-zA-Z0-9\\,\\;\\=\\.:\\%\\^\\*\\$\\@\\!\\+\\_\\?\\-]/) {\n\t\t    $value =~ s/\\t/\\\\t/g; # substitute tab and newline \n\t\t    # characters\n\t\t    $value =~ s/\\n/\\\\n/g; # to their UNIX equivalents\n\n\t\t    # Unescaped quotes are not allowed in GFF3\n\t\t    #\t\t    $value = '\"' . $value . '\"';\n\t\t}\n\t\t$value =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;\n\t    } else {\n\t\t\t\t# if it is completely empty, \n\t\t\t\t# then just make empty double \n\t\t\t\t# quotes\n\t\t$value = '\"\"';\n\t    }\n\t    push @v, $value;\n\t}\n\t# can we figure out how to improve this?\n\t$tag= lcfirst($tag) unless ($tag \n\t\t\t\t    =~ /^(ID|Name|Alias|Parent|Gap|Target|Derives_from|Note|Dbxref|Ontology_term)$/);\n\n\tpush @groups, \"$tag=\".join(\",\",@v);\n    }\n    # Add Target information for Feature Pairs\n    if( $feat->has_tag('Target') && \n\t! $feat->has_tag('Group') &&\n\t$origfeat->isa('Bio::SeqFeature::FeaturePair') ) {\n\n\tmy $target_id = $origfeat->feature1->seq_id;\n\t$target_id =~ s/([\\t\\n\\r%&\\=;,])/sprintf(\"%%%X\",ord($1))/ge;    \n\n\tpush @groups, sprintf(\"Target=%s %d %d\", \n\t\t\t      $target_id,\n\t\t\t      ( $origfeat->feature1->strand < 0 ? \n\t\t\t\t( $origfeat->feature1->end,\n\t\t\t\t  $origfeat->feature1->start) :\n\t\t\t\t( $origfeat->feature1->start,\n\t\t\t\t  $origfeat->feature1->end) \n\t\t\t\t));\n    }\n\n    # unshift @groups, \"ID=autogenerated$ID\" unless ($feat->has_tag('ID'));\n    if ( $feat->can('name') && defined($feat->name) ) {\n\t# such as might be for Bio::DB::SeqFeature\n\tunshift @groups, 'Name=' . $feat->name;\n    }\n\n    my $gff_string = \"\";\n    if ($feat->location->isa(\"Bio::Location::SplitLocationI\")) {\n\tmy @locs = $feat->location->each_Location;\n\tforeach my $loc (@locs) {\n\t    $gff_string .= join(\"\\t\",\n\t\t\t\t$name,\n\t\t\t\t$feat->source_tag() || '.',\n\t\t\t\t$feat->primary_tag(),\n\t\t\t\t$loc->start(),\n\t\t\t\t$loc->end(),\n\t\t\t\t$score,\n\t\t\t\t$strand,\n\t\t\t\t$frame,\n\t\t\t\tjoin(';', @groups)) . \"\\n\";\n\t}\n\tchop $gff_string;\n\treturn $gff_string;\n    } else {\n\t$gff_string = join(\"\\t\",\n\t\t\t   $name,\n\t\t\t   $feat->source_tag() || '.',\n\t\t\t   $feat->primary_tag(),\n\t\t\t   $feat->start(),\n\t\t\t   $feat->end(),\n\t\t\t   $score,\n\t\t\t   $strand,\n\t\t\t   $frame, \n\t\t\t   join(';', @groups));\n    }\n    return $gff_string;\n}\n\n=head2 gff_version\n\n  Title   : _gff_version\n  Usage   : $gffversion = $gffio->gff_version\n  Function: \n  Example :\n  Returns : The GFF version this parser will accept and emit.\n  Args    : none\n\n\nsub gff_version {\n    my ($self, $value) = @_;\n    if(defined $value && grep {$value == $_ } ( 1, 2, 2.5, 3)) {\n\t$self->{'GFF_VERSION'} = $value;\n    }\n    return $self->{'GFF_VERSION'};\n}\n\n# Make filehandles\n\n=head2 newFh\n\n Title   : newFh\n Usage   : $fh = Bio::Tools::GFF->newFh(-file=>$filename,-format=>'Format')\n Function: does a new() followed by an fh()\n Example : $fh = Bio::Tools::GFF->newFh(-file=>$filename,-format=>'Format')\n           $feature = <$fh>;            # read a feature object\n           print $fh $feature;          # write a feature object\n Returns : filehandle tied to the Bio::Tools::GFF class\n Args    :\n\n\n\nsub newFh {\n    my $class = shift;\n    return unless my $self = $class->new(@_);\n    return $self->fh;\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function:\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $feature = <$fh>;    # read a feature object\n           print $fh $feature;  # write a feature object\n Returns : filehandle tied to Bio::Tools::GFF class\n Args    : none\n\n\n\n\nsub fh {\n    my $self = shift;\n    my $class = ref($self) || $self;\n    my $s = Symbol::gensym;\n    tie $$s,$class,$self;\n    return $s;\n}\n\n# This accessor is used for accessing the Bio::Seq objects from a GFF3\n# file; if the file you are using has no sequence data you can ignore\n# this accessor\n\n# This accessor returns a hash reference containing Bio::Seq objects,\n# indexed by Bio::Seq->primary_id\n\nsub _seq_by_id_h {\n    my $self = shift;\n\n    return $self->{'_seq_by_id_h'} = shift if @_;\n    $self->{'_seq_by_id_h'} = {}\n    unless $self->{'_seq_by_id_h'};\n    return $self->{'_seq_by_id_h'};\n}\n\n=head2 get_seqs\n\n Title   : get_seqs\n Usage   :\n Function: Returns all Bio::Seq objects populated by GFF3 file\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"range":{"start":{"line":1223,"character":0},"end":{"line":1225,"character":9999}},"kind":12,"line":1223},{"range":{"end":{"line":1254,"character":9999},"start":{"character":0,"line":1249}},"kind":12,"line":1249,"definition":"sub","containerName":"main::","name":"features_attached_to_seqs","children":[{"definition":"my","line":1250,"name":"$self","containerName":"features_attached_to_seqs","localvar":"my","kind":13},{"name":"$self","kind":13,"containerName":"features_attached_to_seqs","line":1252},{"line":1253,"kind":13,"containerName":"features_attached_to_seqs","name":"$self"}]},{"containerName":"main::","name":"ignore_sequence","children":[{"containerName":"ignore_sequence","localvar":"my","kind":13,"name":"$self","line":1272,"definition":"my"},{"line":1274,"name":"$self","containerName":"ignore_sequence","kind":13},{"kind":13,"containerName":"ignore_sequence","name":"$self","line":1275}],"definition":"sub","range":{"start":{"line":1271,"character":0},"end":{"character":9999,"line":1276}},"kind":12,"line":1271},{"line":1279,"range":{"end":{"character":9999,"line":1282},"start":{"character":0,"line":1279}},"kind":12,"definition":"sub","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"DESTROY","line":1280,"definition":"my"},{"line":1281,"name":"$self","kind":13,"containerName":"DESTROY"},{"line":1281,"name":"close","kind":12,"containerName":"DESTROY"}],"containerName":"main::","name":"DESTROY"},{"name":"TIEHANDLE","containerName":"main::","children":[{"name":"$class","localvar":"my","containerName":"TIEHANDLE","kind":13,"line":1285,"definition":"my"},{"name":"$val","kind":13,"containerName":"TIEHANDLE","line":1285},{"line":1286,"name":"$val","containerName":"TIEHANDLE","kind":13},{"name":"$class","containerName":"TIEHANDLE","kind":13,"line":1286}],"detail":"($class,$val)","definition":"sub","kind":12,"range":{"start":{"line":1284,"character":0},"end":{"character":9999,"line":1287}},"line":1284,"signature":{"label":"TIEHANDLE($class,$val)","documentation":"","parameters":[{"label":"$class"},{"label":"$val"}]}},{"line":1289,"kind":12,"range":{"end":{"character":9999,"line":1295},"start":{"line":1289,"character":0}},"children":[{"line":1290,"name":"$self","kind":13,"localvar":"my","containerName":"READLINE","definition":"my"},{"line":1291,"containerName":"READLINE","kind":13,"name":"$self"},{"line":1291,"containerName":"READLINE","kind":12,"name":"next_feature"},{"localvar":"my","containerName":"READLINE","kind":13,"name":"@list","line":1292,"definition":"my"},{"line":1292,"name":"$obj","kind":13,"containerName":"READLINE"},{"line":1293,"kind":13,"containerName":"READLINE","name":"@list"},{"line":1293,"kind":13,"containerName":"READLINE","name":"$obj"},{"line":1293,"name":"$obj","containerName":"READLINE","kind":13},{"line":1293,"containerName":"READLINE","kind":13,"name":"$self"},{"kind":12,"containerName":"READLINE","name":"next_feature","line":1293},{"name":"@list","containerName":"READLINE","kind":13,"line":1294}],"name":"READLINE","containerName":"main::","definition":"sub"},{"definition":"sub","children":[{"definition":"my","line":1298,"containerName":"PRINT","localvar":"my","kind":13,"name":"$self"},{"name":"$self","kind":13,"containerName":"PRINT","line":1299},{"containerName":"PRINT","kind":12,"name":"write_feature","line":1299}],"name":"PRINT","containerName":"main::","line":1297,"range":{"end":{"line":1300,"character":9999},"start":{"character":0,"line":1297}},"kind":12}],"version":5}