{"vars":[{"containerName":"","kind":2,"name":"base","line":90},{"signature":{"documentation":"1;\n# $Id: Match.pm,v 1.2 2007/06/14 18:01:52 nathan Exp $\n#\n# BioPerl module for Bio::Tools::Match\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Match - Parses output from Transfac's match(TM)\n\n=head1 SYNOPSIS\n\n  use strict;\n\n  use Bio::Tools::Match;\n\n  my $parser = Bio::Tools::Match->new(-file => \"match.out\");\n  \n  while (my $feat = $parser->next_result) {\n    my $start = $feat->start;\n    my $end = $feat->end;\n    my $core_score = $feat->score;\n    my $matrix_score = ($feat->annotation->get_Annotations('matrix_score'))[0]->value;\n    my $matrix_id = ($feat->annotation->get_Annotations('matrix_id'))[0]->value;\n  }\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from Transfac's match(TM) program. It\ndoesn't support the histogram output of match.\n\nEach result is a Bio::SeqFeature::Annotated representing a single matrix match.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Match;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Match->new();\n Function: Builds a new Bio::Tools::Match object\n Returns : Bio::Tools::Match\n Args    : -file (or -fh) should contain the contents of a standard match output","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"line":103,"kind":12,"range":{"start":{"line":103,"character":0},"end":{"character":9999,"line":110}},"definition":"sub","detail":"($class,@args)","children":[{"name":"$class","containerName":"new","localvar":"my","kind":13,"line":104,"definition":"my"},{"line":104,"name":"@args","kind":13,"containerName":"new"},{"kind":13,"localvar":"my","containerName":"new","name":"$self","line":105,"definition":"my"},{"line":105,"name":"$class","containerName":"new","kind":13},{"line":105,"name":"@args","kind":13,"containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":107},{"line":107,"name":"_initialize_io","containerName":"new","kind":12},{"name":"@args","containerName":"new","kind":13,"line":107},{"line":109,"name":"$self","kind":13,"containerName":"new"}],"containerName":"main::","name":"new"},{"kind":12,"containerName":"new","name":"SUPER","line":105},{"detail":"($self)","definition":"sub","name":"next_result","containerName":"main::","children":[{"definition":"my","line":125,"localvar":"my","containerName":"next_result","kind":13,"name":"$self"},{"definition":"my","line":127,"containerName":"next_result","localvar":"my","kind":13,"name":"$line"},{"name":"$self","containerName":"next_result","kind":13,"line":127},{"line":127,"containerName":"next_result","kind":12,"name":"_readline"},{"containerName":"next_result","kind":13,"name":"$self","line":129},{"line":129,"containerName":"next_result","kind":13,"name":"$line"},{"line":130,"containerName":"next_result","kind":13,"name":"$self"},{"line":133,"name":"$line","containerName":"next_result","kind":13},{"line":134,"kind":13,"containerName":"next_result","name":"$line"},{"line":134,"containerName":"next_result","kind":13,"name":"$self"},{"line":134,"kind":12,"containerName":"next_result","name":"_readline"},{"name":"$matrix_id","localvar":"my","kind":13,"containerName":"next_result","line":165,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$start","line":165},{"line":165,"kind":13,"containerName":"next_result","name":"$strand"},{"line":165,"name":"$core_score","kind":13,"containerName":"next_result"},{"line":165,"kind":13,"containerName":"next_result","name":"$matrix_score"},{"containerName":"next_result","kind":13,"name":"$seq","line":165},{"kind":13,"containerName":"next_result","name":"$line","line":165},{"line":166,"localvar":"my","kind":13,"containerName":"next_result","name":"$feat","definition":"my"},{"kind":12,"containerName":"next_result","name":"new","line":166},{"line":167,"name":"$self","containerName":"next_result","kind":13},{"line":168,"containerName":"next_result","kind":13,"name":"$start"},{"containerName":"next_result","kind":13,"name":"$start","line":169},{"kind":13,"containerName":"next_result","name":"$seq","line":169},{"line":171,"containerName":"next_result","kind":13,"name":"$core_score"},{"name":"$sv","localvar":"my","kind":13,"containerName":"next_result","line":174,"definition":"my"},{"name":"new","kind":12,"containerName":"next_result","line":174},{"line":175,"name":"$feat","containerName":"next_result","kind":13},{"containerName":"next_result","kind":12,"name":"annotation","line":175},{"line":175,"name":"add_Annotation","kind":12,"containerName":"next_result"},{"line":175,"name":"$sv","containerName":"next_result","kind":13},{"name":"$sv","kind":13,"containerName":"next_result","line":176},{"line":176,"name":"new","containerName":"next_result","kind":12},{"line":176,"name":"$matrix_score","containerName":"next_result","kind":13},{"name":"$feat","containerName":"next_result","kind":13,"line":177},{"line":177,"name":"annotation","containerName":"next_result","kind":12},{"line":177,"containerName":"next_result","kind":12,"name":"add_Annotation"},{"kind":13,"containerName":"next_result","name":"$sv","line":177},{"line":178,"name":"$sv","kind":13,"containerName":"next_result"},{"line":178,"containerName":"next_result","kind":12,"name":"new"},{"line":178,"containerName":"next_result","kind":13,"name":"$matrix_id"},{"line":179,"name":"$feat","containerName":"next_result","kind":13},{"line":179,"containerName":"next_result","kind":12,"name":"annotation"},{"line":179,"name":"add_Annotation","kind":12,"containerName":"next_result"},{"name":"$sv","kind":13,"containerName":"next_result","line":179},{"line":181,"name":"$feat","containerName":"next_result","kind":13}],"signature":{"label":"next_result($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Match.pm,v 1.2 2007/06/14 18:01:52 nathan Exp $\n#\n# BioPerl module for Bio::Tools::Match\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Match - Parses output from Transfac's match(TM)\n\n=head1 SYNOPSIS\n\n  use strict;\n\n  use Bio::Tools::Match;\n\n  my $parser = Bio::Tools::Match->new(-file => \"match.out\");\n  \n  while (my $feat = $parser->next_result) {\n    my $start = $feat->start;\n    my $end = $feat->end;\n    my $core_score = $feat->score;\n    my $matrix_score = ($feat->annotation->get_Annotations('matrix_score'))[0]->value;\n    my $matrix_id = ($feat->annotation->get_Annotations('matrix_id'))[0]->value;\n  }\n\n=head1 DESCRIPTION\n\nThis module is used to parse the output from Transfac's match(TM) program. It\ndoesn't support the histogram output of match.\n\nEach result is a Bio::SeqFeature::Annotated representing a single matrix match.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Tools::Match;\nuse strict;\n\nuse Bio::SeqFeature::Annotated;\nuse Bio::Annotation::SimpleValue;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::Match->new();\n Function: Builds a new Bio::Tools::Match object\n Returns : Bio::Tools::Match\n Args    : -file (or -fh) should contain the contents of a standard match output\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    $self->_initialize_io(@args);\n    \n    return $self;\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : $result = $obj->next_result();\n Function: Returns the next result available from the input, or undef if there\n           are no more results.\n Returns : Bio::SeqFeature::Annotated object. Features are annotated with tags\n           for 'matrix_score', 'matrix_id' and a 'predicted' tag.\n Args    : none"},"range":{"start":{"character":0,"line":124},"end":{"line":182,"character":9999}},"kind":12,"line":124},{"line":129,"kind":12,"name":"found_seq_id"},{"line":130,"name":"found_seq_id","kind":12},{"name":"Bio","kind":12,"containerName":"SeqFeature::Annotated","line":166},{"line":167,"name":"found_seq_id","kind":12},{"line":174,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"line":176,"name":"Bio","kind":12,"containerName":"Annotation::SimpleValue"},{"line":178,"containerName":"Annotation::SimpleValue","kind":12,"name":"Bio"}],"version":5}