{"vars":[{"containerName":"","kind":2,"name":"vars","line":156},{"containerName":"","kind":2,"name":"base","line":166},{"line":169,"containerName":null,"kind":13,"name":"$MODVERSION"},{"line":169,"name":"$Bio","containerName":null,"kind":13},{"line":170,"name":"$URLBASE","kind":13,"containerName":null},{"name":"Root","kind":12,"containerName":"Version::VERSION","line":170},{"kind":13,"containerName":null,"name":"%PUTPARAMS","line":173},{"containerName":null,"kind":13,"name":"%GETPARAMS","line":211},{"line":239,"kind":13,"containerName":null,"name":"%HEADER"},{"kind":13,"containerName":null,"name":"%RETRIEVALHEADER","line":251},{"line":259,"name":"$RIDLINE","containerName":null,"kind":13},{"signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"","label":"new($caller,@args)"},"kind":12,"range":{"end":{"line":300,"character":9999},"start":{"character":0,"line":262}},"line":262,"detail":"($caller,@args)","definition":"sub","containerName":"main::","name":"new","children":[{"line":263,"localvar":"my","kind":13,"containerName":"new","name":"$caller","definition":"my"},{"name":"@args","containerName":"new","kind":13,"line":263},{"name":"$self","kind":13,"localvar":"my","containerName":"new","line":265,"definition":"my"},{"containerName":"new","kind":13,"name":"$caller","line":265},{"kind":13,"containerName":"new","name":"@args","line":265},{"kind":13,"containerName":"new","name":"$self","line":267},{"name":"_initialize_io","containerName":"new","kind":12,"line":267},{"definition":"my","line":268,"containerName":"new","localvar":"my","kind":13,"name":"$prog"},{"line":268,"kind":13,"containerName":"new","name":"$data"},{"containerName":"new","kind":13,"name":"$readmethod","line":268},{"kind":13,"containerName":"new","name":"$url_base","line":268},{"name":"$self","kind":13,"containerName":"new","line":269},{"name":"_rearrange","containerName":"new","kind":12,"line":269},{"line":270,"name":"@args","containerName":"new","kind":13},{"name":"$self","containerName":"new","kind":13,"line":273},{"line":273,"name":"submit_parameter","containerName":"new","kind":12},{"line":273,"name":"$prog","containerName":"new","kind":13},{"line":273,"name":"$prog","containerName":"new","kind":13},{"kind":13,"containerName":"new","name":"$self","line":274},{"name":"submit_parameter","kind":12,"containerName":"new","line":274},{"kind":13,"containerName":"new","name":"$data","line":274},{"line":274,"containerName":"new","kind":13,"name":"$data"},{"name":"$readmethod","containerName":"new","kind":13,"line":276},{"name":"$readmethod","containerName":"new","kind":13,"line":276},{"containerName":"new","kind":13,"name":"$self","line":277},{"kind":12,"containerName":"new","name":"readmethod","line":277},{"name":"$readmethod","containerName":"new","kind":13,"line":277},{"line":282,"localvar":"my","containerName":"new","kind":13,"name":"@putValues","definition":"my"},{"line":282,"kind":13,"containerName":"new","name":"$self"},{"line":282,"name":"_rearrange","kind":12,"containerName":"new"},{"line":282,"containerName":"new","kind":13,"name":"%PUTPARAMS"},{"line":282,"containerName":"new","kind":13,"name":"@args"},{"line":283,"localvar":"my","containerName":"new","kind":13,"name":"%putNames","definition":"my"},{"line":284,"name":"@putNames","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"%PUTPARAMS","line":284},{"kind":13,"containerName":"new","name":"@putValues","line":284},{"definition":"my","name":"$putName","containerName":"new","localvar":"my","kind":13,"line":285},{"containerName":"new","kind":13,"name":"%putNames","line":285},{"kind":13,"containerName":"new","name":"$self","line":286},{"line":286,"name":"submit_parameter","containerName":"new","kind":12},{"line":286,"name":"$putName","kind":13,"containerName":"new"},{"containerName":"new","kind":13,"name":"$putNames","line":286},{"line":286,"name":"$putName","containerName":"new","kind":13},{"containerName":"new","localvar":"my","kind":13,"name":"@getValues","line":289,"definition":"my"},{"line":289,"name":"$self","kind":13,"containerName":"new"},{"containerName":"new","kind":12,"name":"_rearrange","line":289},{"line":289,"kind":13,"containerName":"new","name":"%GETPARAMS"},{"kind":13,"containerName":"new","name":"@args","line":289},{"line":290,"localvar":"my","containerName":"new","kind":13,"name":"%getNames","definition":"my"},{"line":291,"containerName":"new","kind":13,"name":"@getNames"},{"kind":13,"containerName":"new","name":"%GETPARAMS","line":291},{"name":"@getValues","kind":13,"containerName":"new","line":291},{"definition":"my","localvar":"my","containerName":"new","kind":13,"name":"$getName","line":292},{"name":"%getNames","kind":13,"containerName":"new","line":292},{"kind":13,"containerName":"new","name":"$self","line":293},{"containerName":"new","kind":12,"name":"retrieve_parameter","line":293},{"name":"$getName","containerName":"new","kind":13,"line":293},{"kind":13,"containerName":"new","name":"$getNames","line":293},{"line":293,"kind":13,"containerName":"new","name":"$getName"},{"containerName":"new","kind":13,"name":"$self","line":296},{"name":"$url_base","kind":13,"containerName":"new","line":297},{"name":"$URLBASE","kind":13,"containerName":"new","line":297},{"kind":13,"containerName":"new","name":"$self","line":298},{"containerName":"new","kind":12,"name":"set_url_base","line":298},{"line":298,"containerName":"new","kind":13,"name":"$url_base"},{"name":"$self","kind":13,"containerName":"new","line":299}]},{"name":"SUPER","kind":12,"containerName":"new","line":265},{"signature":{"label":"retrieve_parameter($self,$name,$val)","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$val"}],"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to"},"line":313,"kind":12,"range":{"start":{"character":0,"line":313},"end":{"line":325,"character":9999}},"definition":"sub","detail":"($self,$name,$val)","children":[{"definition":"my","line":314,"kind":13,"localvar":"my","containerName":"retrieve_parameter","name":"$self"},{"line":314,"containerName":"retrieve_parameter","kind":13,"name":"$name"},{"line":314,"name":"$val","containerName":"retrieve_parameter","kind":13},{"kind":13,"containerName":"retrieve_parameter","name":"$name","line":315},{"line":315,"kind":13,"containerName":"retrieve_parameter","name":"$name"},{"name":"$self","kind":13,"containerName":"retrieve_parameter","line":316},{"name":"throw","containerName":"retrieve_parameter","kind":12,"line":316},{"name":"$name","containerName":"retrieve_parameter","kind":13,"line":316},{"line":317,"name":"$GETPARAMS","containerName":"retrieve_parameter","kind":13},{"containerName":"retrieve_parameter","kind":13,"name":"$name","line":317},{"line":318,"kind":13,"containerName":"retrieve_parameter","name":"$val"},{"definition":"my","name":"$regex","localvar":"my","containerName":"retrieve_parameter","kind":13,"line":319},{"line":319,"containerName":"retrieve_parameter","kind":13,"name":"$GETPARAMS"},{"name":"$name","kind":13,"containerName":"retrieve_parameter","line":319},{"line":320,"name":"$val","kind":13,"containerName":"retrieve_parameter"},{"containerName":"retrieve_parameter","kind":13,"name":"$self","line":321},{"containerName":"retrieve_parameter","kind":12,"name":"throw","line":321},{"containerName":"retrieve_parameter","kind":13,"name":"$val","line":321},{"line":321,"name":"$name","containerName":"retrieve_parameter","kind":13},{"line":321,"name":"$regex","containerName":"retrieve_parameter","kind":13},{"containerName":"retrieve_parameter","kind":13,"name":"$RETRIEVALHEADER","line":322},{"kind":13,"containerName":"retrieve_parameter","name":"$name","line":322},{"containerName":"retrieve_parameter","kind":13,"name":"$val","line":322},{"line":324,"name":"$RETRIEVALHEADER","kind":13,"containerName":"retrieve_parameter"},{"line":324,"name":"$name","containerName":"retrieve_parameter","kind":13}],"name":"retrieve_parameter","containerName":"main::"},{"signature":{"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to","parameters":[{"label":"$self"},{"label":"$name"},{"label":"$val"}],"label":"submit_parameter($self,$name,$val)"},"range":{"start":{"line":338,"character":0},"end":{"line":350,"character":9999}},"kind":12,"line":338,"detail":"($self,$name,$val)","definition":"sub","name":"submit_parameter","containerName":"main::","children":[{"definition":"my","line":339,"localvar":"my","kind":13,"containerName":"submit_parameter","name":"$self"},{"containerName":"submit_parameter","kind":13,"name":"$name","line":339},{"name":"$val","kind":13,"containerName":"submit_parameter","line":339},{"containerName":"submit_parameter","kind":13,"name":"$name","line":340},{"kind":13,"containerName":"submit_parameter","name":"$name","line":340},{"name":"$self","kind":13,"containerName":"submit_parameter","line":341},{"containerName":"submit_parameter","kind":12,"name":"throw","line":341},{"line":341,"kind":13,"containerName":"submit_parameter","name":"$name"},{"name":"$PUTPARAMS","kind":13,"containerName":"submit_parameter","line":342},{"containerName":"submit_parameter","kind":13,"name":"$name","line":342},{"line":343,"kind":13,"containerName":"submit_parameter","name":"$val"},{"definition":"my","line":344,"localvar":"my","kind":13,"containerName":"submit_parameter","name":"$regex"},{"line":344,"name":"$PUTPARAMS","kind":13,"containerName":"submit_parameter"},{"kind":13,"containerName":"submit_parameter","name":"$name","line":344},{"line":345,"containerName":"submit_parameter","kind":13,"name":"$val"},{"name":"$self","kind":13,"containerName":"submit_parameter","line":346},{"line":346,"name":"throw","kind":12,"containerName":"submit_parameter"},{"line":346,"containerName":"submit_parameter","kind":13,"name":"$val"},{"kind":13,"containerName":"submit_parameter","name":"$name","line":346},{"line":346,"name":"$regex","containerName":"submit_parameter","kind":13},{"kind":13,"containerName":"submit_parameter","name":"$HEADER","line":347},{"line":347,"containerName":"submit_parameter","kind":13,"name":"$name"},{"kind":13,"containerName":"submit_parameter","name":"$val","line":347},{"line":349,"kind":13,"containerName":"submit_parameter","name":"$HEADER"},{"kind":13,"containerName":"submit_parameter","name":"$name","line":349}]},{"detail":"($self)","definition":"sub","name":"header","containerName":"main::","children":[{"definition":"my","line":363,"containerName":"header","localvar":"my","kind":13,"name":"$self"},{"line":364,"name":"%HEADER","kind":13,"containerName":"header"}],"signature":{"label":"header($self)","documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none","parameters":[{"label":"$self"}]},"range":{"end":{"line":365,"character":9999},"start":{"character":0,"line":362}},"kind":12,"line":362},{"definition":"sub","detail":"($self,$val)","children":[{"definition":"my","kind":13,"localvar":"my","containerName":"readmethod","name":"$self","line":378},{"name":"$val","kind":13,"containerName":"readmethod","line":378},{"line":379,"name":"$val","containerName":"readmethod","kind":13},{"kind":13,"containerName":"readmethod","name":"$val","line":380},{"line":381,"kind":13,"containerName":"readmethod","name":"$self"},{"line":381,"name":"throw","containerName":"readmethod","kind":12},{"name":"$self","containerName":"readmethod","kind":13,"line":383},{"containerName":"readmethod","kind":13,"name":"$val","line":383},{"kind":13,"containerName":"readmethod","name":"$self","line":385}],"containerName":"main::","name":"readmethod","signature":{"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none\n\n\nsub header {\n    my ($self) = @_;\n    return %HEADER;\n}\n\n=head2 readmethod\n\n Title   : readmethod\n Usage   : my $readmethod = $self->readmethod\n Function: Get/Set the method to read the blast report\n Returns : string\n Args    : string [ blast, blasttable, xml ]","parameters":[{"label":"$self"},{"label":"$val"}],"label":"readmethod($self,$val)"},"line":377,"range":{"end":{"line":386,"character":9999},"start":{"line":377,"character":0}},"kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$val"}],"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none\n\n\nsub header {\n    my ($self) = @_;\n    return %HEADER;\n}\n\n=head2 readmethod\n\n Title   : readmethod\n Usage   : my $readmethod = $self->readmethod\n Function: Get/Set the method to read the blast report\n Returns : string\n Args    : string [ blast, blasttable, xml ]\n\n\nsub readmethod {\n    my ($self, $val) = @_;\n    if( defined $val ) {\n        if ($val =~ /bplite/i) {\n            $self->throw(\"Use of Bio::Tools::BPlite is deprecated; use Bio::SearchIO modules instead\");\n        }\n        $self->{'_readmethod'} = $val;\n    }\n    return $self->{'_readmethod'};\n}\n\n\n=head2 program\n\n Title   : program\n Usage   : my $prog = $self->program\n Function: Get/Set the program to run. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ blastp, blastn, blastx, tblastn, tblastx ]","label":"program($self,$val)"},"line":399,"kind":12,"range":{"end":{"line":402,"character":9999},"start":{"line":399,"character":0}},"definition":"sub","detail":"($self,$val)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"program","line":400,"definition":"my"},{"containerName":"program","kind":13,"name":"$val","line":400},{"name":"$self","containerName":"program","kind":13,"line":401},{"line":401,"containerName":"program","kind":12,"name":"submit_parameter"},{"line":401,"kind":13,"containerName":"program","name":"$val"}],"name":"program","containerName":"main::"},{"kind":12,"range":{"end":{"line":418,"character":9999},"start":{"line":415,"character":0}},"line":415,"signature":{"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none\n\n\nsub header {\n    my ($self) = @_;\n    return %HEADER;\n}\n\n=head2 readmethod\n\n Title   : readmethod\n Usage   : my $readmethod = $self->readmethod\n Function: Get/Set the method to read the blast report\n Returns : string\n Args    : string [ blast, blasttable, xml ]\n\n\nsub readmethod {\n    my ($self, $val) = @_;\n    if( defined $val ) {\n        if ($val =~ /bplite/i) {\n            $self->throw(\"Use of Bio::Tools::BPlite is deprecated; use Bio::SearchIO modules instead\");\n        }\n        $self->{'_readmethod'} = $val;\n    }\n    return $self->{'_readmethod'};\n}\n\n\n=head2 program\n\n Title   : program\n Usage   : my $prog = $self->program\n Function: Get/Set the program to run. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ blastp, blastn, blastx, tblastn, tblastx ]\n\n\nsub program {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('PROGRAM',$val);\n}\n\n\n=head2 database\n\n Title   : database\n Usage   : my $db = $self->database\n Function: Get/Set the database to search. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ swissprot, nr, nt, etc... ]","parameters":[{"label":"$self"},{"label":"$val"}],"label":"database($self,$val)"},"name":"database","containerName":"main::","children":[{"definition":"my","line":416,"localvar":"my","kind":13,"containerName":"database","name":"$self"},{"line":416,"name":"$val","containerName":"database","kind":13},{"name":"$self","kind":13,"containerName":"database","line":417},{"name":"submit_parameter","containerName":"database","kind":12,"line":417},{"line":417,"name":"$val","kind":13,"containerName":"database"}],"detail":"($self,$val)","definition":"sub"},{"name":"expect","containerName":"main::","children":[{"line":432,"name":"$self","localvar":"my","containerName":"expect","kind":13,"definition":"my"},{"line":432,"kind":13,"containerName":"expect","name":"$val"},{"containerName":"expect","kind":13,"name":"$self","line":433},{"line":433,"name":"submit_parameter","containerName":"expect","kind":12},{"name":"$val","kind":13,"containerName":"expect","line":433}],"detail":"($self,$val)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":434},"start":{"character":0,"line":431}},"line":431,"signature":{"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none\n\n\nsub header {\n    my ($self) = @_;\n    return %HEADER;\n}\n\n=head2 readmethod\n\n Title   : readmethod\n Usage   : my $readmethod = $self->readmethod\n Function: Get/Set the method to read the blast report\n Returns : string\n Args    : string [ blast, blasttable, xml ]\n\n\nsub readmethod {\n    my ($self, $val) = @_;\n    if( defined $val ) {\n        if ($val =~ /bplite/i) {\n            $self->throw(\"Use of Bio::Tools::BPlite is deprecated; use Bio::SearchIO modules instead\");\n        }\n        $self->{'_readmethod'} = $val;\n    }\n    return $self->{'_readmethod'};\n}\n\n\n=head2 program\n\n Title   : program\n Usage   : my $prog = $self->program\n Function: Get/Set the program to run. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ blastp, blastn, blastx, tblastn, tblastx ]\n\n\nsub program {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('PROGRAM',$val);\n}\n\n\n=head2 database\n\n Title   : database\n Usage   : my $db = $self->database\n Function: Get/Set the database to search. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ swissprot, nr, nt, etc... ]\n\n\nsub database {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('DATABASE',$val);\n}\n\n\n=head2 expect\n\n Title   : expect\n Usage   : my $expect = $self->expect\n Function: Get/Set the E value cutoff. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ '1e-4' ]","parameters":[{"label":"$self"},{"label":"$val"}],"label":"expect($self,$val)"}},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","name":"$self","kind":13,"localvar":"my","containerName":"ua","line":449},{"containerName":"ua","kind":13,"name":"$value","line":449},{"line":450,"name":"$self","kind":13,"containerName":"ua"},{"line":451,"name":"$self","kind":13,"containerName":"ua"},{"name":"new","containerName":"ua","kind":12,"line":451},{"definition":"my","line":452,"localvar":"my","kind":13,"containerName":"ua","name":"$nm"},{"name":"$self","containerName":"ua","kind":13,"line":452},{"line":453,"name":"$nm","containerName":"ua","kind":13},{"line":454,"containerName":"ua","kind":13,"name":"$self"},{"name":"agent","containerName":"ua","kind":12,"line":454},{"line":456,"kind":13,"containerName":"ua","name":"$self"}],"name":"ua","containerName":"main::","signature":{"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none\n\n\nsub header {\n    my ($self) = @_;\n    return %HEADER;\n}\n\n=head2 readmethod\n\n Title   : readmethod\n Usage   : my $readmethod = $self->readmethod\n Function: Get/Set the method to read the blast report\n Returns : string\n Args    : string [ blast, blasttable, xml ]\n\n\nsub readmethod {\n    my ($self, $val) = @_;\n    if( defined $val ) {\n        if ($val =~ /bplite/i) {\n            $self->throw(\"Use of Bio::Tools::BPlite is deprecated; use Bio::SearchIO modules instead\");\n        }\n        $self->{'_readmethod'} = $val;\n    }\n    return $self->{'_readmethod'};\n}\n\n\n=head2 program\n\n Title   : program\n Usage   : my $prog = $self->program\n Function: Get/Set the program to run. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ blastp, blastn, blastx, tblastn, tblastx ]\n\n\nsub program {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('PROGRAM',$val);\n}\n\n\n=head2 database\n\n Title   : database\n Usage   : my $db = $self->database\n Function: Get/Set the database to search. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ swissprot, nr, nt, etc... ]\n\n\nsub database {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('DATABASE',$val);\n}\n\n\n=head2 expect\n\n Title   : expect\n Usage   : my $expect = $self->expect\n Function: Get/Set the E value cutoff. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ '1e-4' ]\n\n\nsub expect {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('EXPECT',$val);\n}\n\n=head2 ua\n\n Title   : ua\n Usage   : my $ua = $self->ua or\n           $self->ua($ua)\n Function: Get/Set a LWP::UserAgent for use\n Returns : reference to LWP::UserAgent Object\n Args    : none\n Comments: Will create a UserAgent if none has been requested before.","parameters":[{"label":"$self"},{"label":"$value"}],"label":"ua($self,$value)"},"line":448,"kind":12,"range":{"end":{"character":9999,"line":457},"start":{"line":448,"character":0}}},{"line":451,"kind":12,"containerName":"UserAgent","name":"LWP"},{"name":"env_proxy","kind":12,"line":451},{"kind":12,"name":"parse_head","line":451},{"signature":{"label":"proxy($self,$protocol,$proxy)","parameters":[{"label":"$self"},{"label":"$protocol"},{"label":"$proxy"}],"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none\n\n\nsub header {\n    my ($self) = @_;\n    return %HEADER;\n}\n\n=head2 readmethod\n\n Title   : readmethod\n Usage   : my $readmethod = $self->readmethod\n Function: Get/Set the method to read the blast report\n Returns : string\n Args    : string [ blast, blasttable, xml ]\n\n\nsub readmethod {\n    my ($self, $val) = @_;\n    if( defined $val ) {\n        if ($val =~ /bplite/i) {\n            $self->throw(\"Use of Bio::Tools::BPlite is deprecated; use Bio::SearchIO modules instead\");\n        }\n        $self->{'_readmethod'} = $val;\n    }\n    return $self->{'_readmethod'};\n}\n\n\n=head2 program\n\n Title   : program\n Usage   : my $prog = $self->program\n Function: Get/Set the program to run. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ blastp, blastn, blastx, tblastn, tblastx ]\n\n\nsub program {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('PROGRAM',$val);\n}\n\n\n=head2 database\n\n Title   : database\n Usage   : my $db = $self->database\n Function: Get/Set the database to search. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ swissprot, nr, nt, etc... ]\n\n\nsub database {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('DATABASE',$val);\n}\n\n\n=head2 expect\n\n Title   : expect\n Usage   : my $expect = $self->expect\n Function: Get/Set the E value cutoff. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ '1e-4' ]\n\n\nsub expect {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('EXPECT',$val);\n}\n\n=head2 ua\n\n Title   : ua\n Usage   : my $ua = $self->ua or\n           $self->ua($ua)\n Function: Get/Set a LWP::UserAgent for use\n Returns : reference to LWP::UserAgent Object\n Args    : none\n Comments: Will create a UserAgent if none has been requested before.\n\n\nsub ua {\n    my ($self, $value) = @_;    \n    if( ! defined $self->{'_ua'} ) {\n\t$self->{'_ua'} = LWP::UserAgent->new(env_proxy => 1, parse_head => 0);\n\tmy $nm = ref($self);\n\t$nm =~ s/::/_/g;\n\t$self->{'_ua'}->agent(\"bioperl-$nm/$MODVERSION\");\n    }\n    return $self->{'_ua'};\n}\n\n=head2 proxy\n\n Title   : proxy\n Usage   : $httpproxy = $db->proxy('http')  or\n           $db->proxy(['http','ftp'], 'http://myproxy' )\n Function: Get/Set a proxy for use of proxy\n Returns : a string indicating the proxy\n Args    : $protocol : an array ref of the protocol(s) to set/get\n           $proxyurl : url of the proxy to use for the specified protocol"},"line":471,"range":{"end":{"line":476,"character":9999},"start":{"character":0,"line":471}},"kind":12,"definition":"sub","detail":"($self,$protocol,$proxy)","children":[{"definition":"my","line":472,"name":"$self","localvar":"my","containerName":"proxy","kind":13},{"kind":13,"containerName":"proxy","name":"$protocol","line":472},{"line":472,"name":"$proxy","kind":13,"containerName":"proxy"},{"kind":13,"containerName":"proxy","name":"$self","line":473},{"line":473,"containerName":"proxy","kind":12,"name":"ua"},{"containerName":"proxy","kind":13,"name":"$protocol","line":474},{"line":474,"name":"$proxy","kind":13,"containerName":"proxy"},{"containerName":"proxy","kind":13,"name":"$self","line":475},{"name":"ua","kind":12,"containerName":"proxy","line":475},{"name":"proxy","kind":12,"containerName":"proxy","line":475},{"line":475,"containerName":"proxy","kind":13,"name":"$protocol"},{"name":"$proxy","kind":13,"containerName":"proxy","line":475}],"containerName":"main::","name":"proxy"},{"signature":{"parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":"","label":"add_rid($self,@vals)"},"range":{"end":{"character":9999,"line":484},"start":{"character":0,"line":478}},"kind":12,"line":478,"detail":"($self,@vals)","definition":"sub","name":"add_rid","containerName":"main::","children":[{"name":"$self","containerName":"add_rid","localvar":"my","kind":13,"line":479,"definition":"my"},{"line":479,"kind":13,"containerName":"add_rid","name":"@vals"},{"name":"@vals","containerName":"add_rid","kind":13,"line":480},{"containerName":"add_rid","kind":13,"name":"$self","line":481},{"line":481,"name":"$self","containerName":"add_rid","kind":13},{"containerName":"add_rid","kind":13,"name":"$self","line":482},{"line":484,"kind":13,"containerName":"add_rid","name":"$self"}]},{"range":{"start":{"line":487,"character":0},"end":{"character":9999,"line":492}},"kind":12,"line":487,"signature":{"parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":"","label":"remove_rid($self,@vals)"},"containerName":"main::","name":"remove_rid","children":[{"definition":"my","line":488,"containerName":"remove_rid","localvar":"my","kind":13,"name":"$self"},{"name":"@vals","containerName":"remove_rid","kind":13,"line":488},{"line":489,"containerName":"remove_rid","kind":13,"name":"@vals"},{"line":490,"kind":13,"containerName":"remove_rid","name":"$self"},{"line":492,"containerName":"remove_rid","kind":13,"name":"$self"}],"detail":"($self,@vals)","definition":"sub"},{"detail":"($self)","definition":"sub","containerName":"main::","name":"each_rid","children":[{"definition":"my","name":"$self","localvar":"my","containerName":"each_rid","kind":13,"line":496},{"definition":"my","line":498,"name":"@sort_rids","localvar":"my","kind":13,"containerName":"each_rid"},{"line":498,"name":"$self","containerName":"each_rid","kind":13},{"name":"$a","kind":13,"containerName":"each_rid","line":498},{"line":498,"kind":13,"containerName":"each_rid","name":"$self"},{"line":498,"name":"$b","kind":13,"containerName":"each_rid"},{"line":498,"name":"$self","kind":13,"containerName":"each_rid"}],"signature":{"label":"each_rid($self)","parameters":[{"label":"$self"}],"documentation":""},"range":{"end":{"line":498,"character":9999},"start":{"character":0,"line":495}},"kind":12,"line":495},{"name":"@sort_rids","kind":13,"containerName":null,"line":499},{"detail":"($self,$input)","definition":"sub","name":"submit_blast","containerName":"main::","children":[{"definition":"my","line":516,"name":"$self","localvar":"my","kind":13,"containerName":"submit_blast"},{"line":516,"name":"$input","containerName":"submit_blast","kind":13},{"definition":"my","localvar":"my","kind":13,"containerName":"submit_blast","name":"@seqs","line":517},{"kind":13,"containerName":"submit_blast","name":"$self","line":517},{"line":517,"name":"_load_input","kind":12,"containerName":"submit_blast"},{"name":"$input","kind":13,"containerName":"submit_blast","line":517},{"line":518,"name":"$url_base","kind":13,"localvar":"my","containerName":"submit_blast","definition":"my"},{"line":518,"name":"$self","kind":13,"containerName":"submit_blast"},{"containerName":"submit_blast","kind":12,"name":"get_url_base","line":518},{"containerName":"submit_blast","kind":13,"name":"@seqs","line":519},{"containerName":"submit_blast","localvar":"my","kind":13,"name":"$tcount","line":520,"definition":"my"},{"definition":"my","line":521,"kind":13,"localvar":"my","containerName":"submit_blast","name":"%header"},{"containerName":"submit_blast","kind":13,"name":"$self","line":521},{"line":521,"containerName":"submit_blast","kind":12,"name":"header"},{"containerName":"submit_blast","kind":13,"name":"$header","line":522},{"line":522,"containerName":"submit_blast","kind":13,"name":"$RETRIEVALHEADER"},{"line":522,"containerName":"submit_blast","kind":13,"name":"%RETRIEVALHEADER"},{"definition":"my","localvar":"my","kind":13,"containerName":"submit_blast","name":"$seq","line":523},{"name":"@seqs","containerName":"submit_blast","kind":13,"line":523},{"name":"$header","containerName":"submit_blast","kind":13,"line":525},{"name":"$seq","containerName":"submit_blast","kind":13,"line":525},{"line":525,"name":"display_id","kind":12,"containerName":"submit_blast"},{"kind":13,"containerName":"submit_blast","name":"$seq","line":525},{"name":"display_id","kind":12,"containerName":"submit_blast","line":525},{"line":526,"kind":13,"containerName":"submit_blast","name":"$seq"},{"containerName":"submit_blast","kind":12,"name":"desc","line":526},{"line":526,"name":"$seq","kind":13,"containerName":"submit_blast"},{"line":526,"containerName":"submit_blast","kind":12,"name":"desc"},{"containerName":"submit_blast","kind":13,"name":"$seq","line":526},{"kind":12,"containerName":"submit_blast","name":"seq","line":526},{"line":527,"localvar":"my","kind":13,"containerName":"submit_blast","name":"$request","definition":"my"},{"line":527,"containerName":"submit_blast","kind":13,"name":"$url_base"},{"kind":13,"containerName":"submit_blast","name":"%header","line":527},{"name":"$self","kind":13,"containerName":"submit_blast","line":528},{"kind":12,"containerName":"submit_blast","name":"warn","line":528},{"name":"$request","containerName":"submit_blast","kind":13,"line":528},{"line":528,"containerName":"submit_blast","kind":12,"name":"as_string"},{"line":528,"name":"$self","kind":13,"containerName":"submit_blast"},{"line":528,"containerName":"submit_blast","kind":12,"name":"verbose"},{"definition":"my","kind":13,"localvar":"my","containerName":"submit_blast","name":"$response","line":529},{"line":529,"containerName":"submit_blast","kind":13,"name":"$self"},{"line":529,"containerName":"submit_blast","kind":12,"name":"ua"},{"line":529,"name":"request","containerName":"submit_blast","kind":12},{"containerName":"submit_blast","kind":13,"name":"$request","line":529},{"line":531,"kind":13,"containerName":"submit_blast","name":"$response"},{"line":531,"kind":12,"containerName":"submit_blast","name":"is_success"},{"definition":"my","line":532,"name":"@subdata","localvar":"my","containerName":"submit_blast","kind":13},{"line":532,"name":"$response","kind":13,"containerName":"submit_blast"},{"line":532,"name":"content","kind":12,"containerName":"submit_blast"},{"definition":"my","line":533,"name":"$count","localvar":"my","kind":13,"containerName":"submit_blast"},{"line":534,"name":"@subdata","containerName":"submit_blast","kind":13},{"line":536,"containerName":"submit_blast","kind":13,"name":"$count"},{"line":537,"kind":13,"containerName":"submit_blast","name":"$self"},{"line":537,"name":"debug","kind":12,"containerName":"submit_blast"},{"name":"$self","containerName":"submit_blast","kind":13,"line":538},{"name":"add_rid","kind":12,"containerName":"submit_blast","line":538},{"name":"$count","kind":13,"containerName":"submit_blast","line":542},{"line":543,"kind":13,"containerName":"submit_blast","name":"$self"},{"containerName":"submit_blast","kind":12,"name":"warn","line":543},{"kind":13,"containerName":"submit_blast","name":"$request","line":543},{"name":"as_string","kind":12,"containerName":"submit_blast","line":543},{"line":544,"name":"$self","kind":13,"containerName":"submit_blast"},{"name":"warn","kind":12,"containerName":"submit_blast","line":544},{"line":544,"name":"@subdata","kind":13,"containerName":"submit_blast"},{"name":"$tcount","kind":13,"containerName":"submit_blast","line":546},{"line":546,"name":"$count","containerName":"submit_blast","kind":13},{"line":549,"containerName":"submit_blast","kind":13,"name":"$self"},{"line":549,"containerName":"submit_blast","kind":12,"name":"warn"},{"line":549,"name":"$request","kind":13,"containerName":"submit_blast"},{"name":"as_string","kind":12,"containerName":"submit_blast","line":549},{"line":550,"kind":13,"containerName":"submit_blast","name":"$response"},{"line":550,"containerName":"submit_blast","kind":12,"name":"error_as_HTML"},{"line":551,"name":"$tcount","containerName":"submit_blast","kind":13},{"line":554,"containerName":"submit_blast","kind":13,"name":"$tcount"}],"signature":{"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none\n\n\nsub header {\n    my ($self) = @_;\n    return %HEADER;\n}\n\n=head2 readmethod\n\n Title   : readmethod\n Usage   : my $readmethod = $self->readmethod\n Function: Get/Set the method to read the blast report\n Returns : string\n Args    : string [ blast, blasttable, xml ]\n\n\nsub readmethod {\n    my ($self, $val) = @_;\n    if( defined $val ) {\n        if ($val =~ /bplite/i) {\n            $self->throw(\"Use of Bio::Tools::BPlite is deprecated; use Bio::SearchIO modules instead\");\n        }\n        $self->{'_readmethod'} = $val;\n    }\n    return $self->{'_readmethod'};\n}\n\n\n=head2 program\n\n Title   : program\n Usage   : my $prog = $self->program\n Function: Get/Set the program to run. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ blastp, blastn, blastx, tblastn, tblastx ]\n\n\nsub program {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('PROGRAM',$val);\n}\n\n\n=head2 database\n\n Title   : database\n Usage   : my $db = $self->database\n Function: Get/Set the database to search. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ swissprot, nr, nt, etc... ]\n\n\nsub database {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('DATABASE',$val);\n}\n\n\n=head2 expect\n\n Title   : expect\n Usage   : my $expect = $self->expect\n Function: Get/Set the E value cutoff. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ '1e-4' ]\n\n\nsub expect {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('EXPECT',$val);\n}\n\n=head2 ua\n\n Title   : ua\n Usage   : my $ua = $self->ua or\n           $self->ua($ua)\n Function: Get/Set a LWP::UserAgent for use\n Returns : reference to LWP::UserAgent Object\n Args    : none\n Comments: Will create a UserAgent if none has been requested before.\n\n\nsub ua {\n    my ($self, $value) = @_;    \n    if( ! defined $self->{'_ua'} ) {\n\t$self->{'_ua'} = LWP::UserAgent->new(env_proxy => 1, parse_head => 0);\n\tmy $nm = ref($self);\n\t$nm =~ s/::/_/g;\n\t$self->{'_ua'}->agent(\"bioperl-$nm/$MODVERSION\");\n    }\n    return $self->{'_ua'};\n}\n\n=head2 proxy\n\n Title   : proxy\n Usage   : $httpproxy = $db->proxy('http')  or\n           $db->proxy(['http','ftp'], 'http://myproxy' )\n Function: Get/Set a proxy for use of proxy\n Returns : a string indicating the proxy\n Args    : $protocol : an array ref of the protocol(s) to set/get\n           $proxyurl : url of the proxy to use for the specified protocol\n\n\nsub proxy {\n    my ($self,$protocol,$proxy) = @_;\n    return if ( !defined $self->ua || !defined $protocol\n\t\t      || !defined $proxy );\n    return $self->ua->proxy($protocol,$proxy);\n}\n\nsub add_rid {\n    my ($self, @vals) = @_;\n    foreach ( @vals ) {\n\t$self->{'_rids'}->{$_} = $self->{'_total_rids'};\n        $self->{'_total_rids'}++; \n    }\n    return scalar keys %{$self->{'_rids'}};\n}\n\nsub remove_rid {\n    my ($self, @vals) = @_;\n    foreach ( @vals ) {\n\tdelete $self->{'_rids'}->{$_};\n    }\n    return scalar keys %{$self->{'_rids'}};\n}\n\nsub each_rid {\n    my ($self) = @_;\n    # sort on key value, a little tricky...\n    my @sort_rids = sort {$self->{'_rids'}->{$a} <=> $self->{'_rids'}->{$b}} keys %{$self->{'_rids'}};\n    return @sort_rids;\n}\n\n=head2 submit_blast\n\n Title   : submit_blast\n Usage   : $self->submit_blast([$seq1,$seq2]);\n Function: Submit blast jobs to ncbi blast queue on sequence(s)\n Returns : Blast report object as defined by $self->readmethod\n Args    : input can be:\n           * sequence object\n           * array ref of sequence objects\n           * filename of file containing fasta formatted sequences","parameters":[{"label":"$self"},{"label":"$input"}],"label":"submit_blast($self,$input)"},"range":{"end":{"character":9999,"line":555},"start":{"line":515,"character":0}},"kind":12,"line":515},{"kind":12,"name":"POST","line":527},{"line":569,"range":{"start":{"line":569,"character":0},"end":{"character":9999,"line":656}},"kind":12,"signature":{"documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none\n\n\nsub header {\n    my ($self) = @_;\n    return %HEADER;\n}\n\n=head2 readmethod\n\n Title   : readmethod\n Usage   : my $readmethod = $self->readmethod\n Function: Get/Set the method to read the blast report\n Returns : string\n Args    : string [ blast, blasttable, xml ]\n\n\nsub readmethod {\n    my ($self, $val) = @_;\n    if( defined $val ) {\n        if ($val =~ /bplite/i) {\n            $self->throw(\"Use of Bio::Tools::BPlite is deprecated; use Bio::SearchIO modules instead\");\n        }\n        $self->{'_readmethod'} = $val;\n    }\n    return $self->{'_readmethod'};\n}\n\n\n=head2 program\n\n Title   : program\n Usage   : my $prog = $self->program\n Function: Get/Set the program to run. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ blastp, blastn, blastx, tblastn, tblastx ]\n\n\nsub program {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('PROGRAM',$val);\n}\n\n\n=head2 database\n\n Title   : database\n Usage   : my $db = $self->database\n Function: Get/Set the database to search. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ swissprot, nr, nt, etc... ]\n\n\nsub database {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('DATABASE',$val);\n}\n\n\n=head2 expect\n\n Title   : expect\n Usage   : my $expect = $self->expect\n Function: Get/Set the E value cutoff. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ '1e-4' ]\n\n\nsub expect {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('EXPECT',$val);\n}\n\n=head2 ua\n\n Title   : ua\n Usage   : my $ua = $self->ua or\n           $self->ua($ua)\n Function: Get/Set a LWP::UserAgent for use\n Returns : reference to LWP::UserAgent Object\n Args    : none\n Comments: Will create a UserAgent if none has been requested before.\n\n\nsub ua {\n    my ($self, $value) = @_;    \n    if( ! defined $self->{'_ua'} ) {\n\t$self->{'_ua'} = LWP::UserAgent->new(env_proxy => 1, parse_head => 0);\n\tmy $nm = ref($self);\n\t$nm =~ s/::/_/g;\n\t$self->{'_ua'}->agent(\"bioperl-$nm/$MODVERSION\");\n    }\n    return $self->{'_ua'};\n}\n\n=head2 proxy\n\n Title   : proxy\n Usage   : $httpproxy = $db->proxy('http')  or\n           $db->proxy(['http','ftp'], 'http://myproxy' )\n Function: Get/Set a proxy for use of proxy\n Returns : a string indicating the proxy\n Args    : $protocol : an array ref of the protocol(s) to set/get\n           $proxyurl : url of the proxy to use for the specified protocol\n\n\nsub proxy {\n    my ($self,$protocol,$proxy) = @_;\n    return if ( !defined $self->ua || !defined $protocol\n\t\t      || !defined $proxy );\n    return $self->ua->proxy($protocol,$proxy);\n}\n\nsub add_rid {\n    my ($self, @vals) = @_;\n    foreach ( @vals ) {\n\t$self->{'_rids'}->{$_} = $self->{'_total_rids'};\n        $self->{'_total_rids'}++; \n    }\n    return scalar keys %{$self->{'_rids'}};\n}\n\nsub remove_rid {\n    my ($self, @vals) = @_;\n    foreach ( @vals ) {\n\tdelete $self->{'_rids'}->{$_};\n    }\n    return scalar keys %{$self->{'_rids'}};\n}\n\nsub each_rid {\n    my ($self) = @_;\n    # sort on key value, a little tricky...\n    my @sort_rids = sort {$self->{'_rids'}->{$a} <=> $self->{'_rids'}->{$b}} keys %{$self->{'_rids'}};\n    return @sort_rids;\n}\n\n=head2 submit_blast\n\n Title   : submit_blast\n Usage   : $self->submit_blast([$seq1,$seq2]);\n Function: Submit blast jobs to ncbi blast queue on sequence(s)\n Returns : Blast report object as defined by $self->readmethod\n Args    : input can be:\n           * sequence object\n           * array ref of sequence objects\n           * filename of file containing fasta formatted sequences\n\n\nsub submit_blast {\n    my ($self, $input) = @_;\n    my @seqs = $self->_load_input($input);\n    my $url_base = $self->get_url_base;\n    return 0 unless ( @seqs );\n    my $tcount = 0;\n    my %header = $self->header;\n    $header{$_} ||= $RETRIEVALHEADER{$_} foreach (keys %RETRIEVALHEADER);    \n    foreach my $seq ( @seqs ) {\n\t#If query has a fasta header, the output has the query line.\n\t$header{'QUERY'} = \">\".(defined $seq->display_id() ? $seq->display_id() : \"\").\n\t\t\" \".(defined $seq->desc() ? $seq->desc() : \"\").\"\\n\".$seq->seq();\n\tmy $request = POST $url_base, [%header];\n\t$self->warn($request->as_string) if ( $self->verbose > 0);\n\tmy $response = $self->ua->request( $request);\n\n\tif( $response->is_success ) {\n\t    my @subdata = split(/\\n/, $response->content );\n\t    my $count = 0;\n\t    foreach ( @subdata ) {\n\t\t\tif( /$RIDLINE/ ) {\n\t\t    \t$count++;\n\t\t    \t$self->debug(\"RID: $1\\n\");\n\t\t    \t$self->add_rid($1);\n\t\t    \tlast;\n\t\t\t}\n\t    }\n\t    if( $count == 0 ) {\n            $self->warn(\"req was \". $request->as_string() . \"\\n\");\n            $self->warn(join('', @subdata));\n\t    }    \t\n\t    $tcount += $count;\n\t} else {\n\t    # should try and be a little more verbose here\n\t    $self->warn(\"req was \". $request->as_string() . \"\\n\" .\n\t\t\t$response->error_as_HTML);\n\t    $tcount = -1;\n\t\t}\n    }\n    return $tcount;\n}\n\n=head2 retrieve_blast\n\n Title   : retrieve_blast\n Usage   : my $blastreport = $blastfactory->retrieve_blast($rid);\n Function: Attempts to retrieve a blast report from remote blast queue\n Returns : -1 on error,\n           0 on 'job not finished',\n           Bio::SearchIO object\n Args    : Remote Blast ID (RID)","parameters":[{"label":"$self"},{"label":"$rid"}],"label":"retrieve_blast($self,$rid)"},"children":[{"line":570,"localvar":"my","kind":13,"containerName":"retrieve_blast","name":"$self","definition":"my"},{"line":570,"name":"$rid","containerName":"retrieve_blast","kind":13},{"kind":13,"localvar":"my","containerName":"retrieve_blast","name":"$fh","line":571,"definition":"my"},{"line":571,"containerName":"retrieve_blast","kind":13,"name":"$tempfile"},{"line":571,"kind":13,"containerName":"retrieve_blast","name":"$self"},{"line":571,"name":"tempfile","containerName":"retrieve_blast","kind":12},{"line":572,"name":"$fh","containerName":"retrieve_blast","kind":13},{"definition":"my","line":573,"name":"$url_base","kind":13,"localvar":"my","containerName":"retrieve_blast"},{"line":573,"containerName":"retrieve_blast","kind":13,"name":"$self"},{"containerName":"retrieve_blast","kind":12,"name":"get_url_base","line":573},{"name":"%hdr","kind":13,"localvar":"my","containerName":"retrieve_blast","line":574,"definition":"my"},{"line":574,"name":"%RETRIEVALHEADER","kind":13,"containerName":"retrieve_blast"},{"line":575,"containerName":"retrieve_blast","kind":13,"name":"$hdr"},{"line":575,"name":"$rid","containerName":"retrieve_blast","kind":13},{"definition":"my","line":576,"name":"$req","localvar":"my","kind":13,"containerName":"retrieve_blast"},{"line":576,"name":"$url_base","kind":13,"containerName":"retrieve_blast"},{"name":"%hdr","kind":13,"containerName":"retrieve_blast","line":576},{"line":577,"containerName":"retrieve_blast","kind":13,"name":"$self"},{"name":"debug","containerName":"retrieve_blast","kind":12,"line":577},{"containerName":"retrieve_blast","kind":13,"name":"$req","line":577},{"name":"as_string","containerName":"retrieve_blast","kind":12,"line":577},{"line":578,"name":"$response","kind":13,"localvar":"my","containerName":"retrieve_blast","definition":"my"},{"line":578,"containerName":"retrieve_blast","kind":13,"name":"$self"},{"line":578,"kind":12,"containerName":"retrieve_blast","name":"ua"},{"name":"request","containerName":"retrieve_blast","kind":12,"line":578},{"line":578,"name":"$req","containerName":"retrieve_blast","kind":13},{"line":578,"containerName":"retrieve_blast","kind":13,"name":"$tempfile"},{"containerName":"retrieve_blast","kind":13,"name":"$response","line":579},{"line":579,"kind":12,"containerName":"retrieve_blast","name":"is_success"},{"line":580,"name":"$self","kind":13,"containerName":"retrieve_blast"},{"kind":12,"containerName":"retrieve_blast","name":"verbose","line":580},{"definition":"my","containerName":"retrieve_blast","localvar":"my","kind":13,"name":"$DEBUG","line":582},{"line":582,"containerName":"retrieve_blast","kind":13,"name":"$tempfile"},{"kind":13,"containerName":"retrieve_blast","name":"$self","line":582},{"kind":12,"containerName":"retrieve_blast","name":"throw","line":582},{"kind":13,"containerName":"retrieve_blast","name":"$DEBUG","line":583},{"line":584,"name":"$DEBUG","containerName":"retrieve_blast","kind":13},{"line":586,"kind":13,"localvar":"my","containerName":"retrieve_blast","name":"$TMP","definition":"my"},{"name":"$tempfile","kind":13,"containerName":"retrieve_blast","line":586},{"line":586,"kind":13,"containerName":"retrieve_blast","name":"$self"},{"name":"throw","kind":12,"containerName":"retrieve_blast","line":586},{"name":"$waiting","localvar":"my","kind":13,"containerName":"retrieve_blast","line":588,"definition":"my"},{"line":589,"kind":13,"localvar":"my","containerName":"retrieve_blast","name":"$s","definition":"my"},{"definition":"my","containerName":"retrieve_blast","localvar":"my","kind":13,"name":"$got_content","line":590},{"definition":"my","localvar":"my","containerName":"retrieve_blast","kind":13,"name":"$is_tabular","line":591},{"definition":"my","line":592,"name":"$line","localvar":"my","kind":13,"containerName":"retrieve_blast"},{"kind":13,"containerName":"retrieve_blast","name":"$TMP","line":592},{"line":593,"containerName":"retrieve_blast","kind":13,"name":"$line"},{"line":594,"name":"$got_content","kind":13,"containerName":"retrieve_blast"},{"name":"$line","kind":13,"containerName":"retrieve_blast","line":596},{"name":"$waiting","kind":13,"containerName":"retrieve_blast","line":597},{"name":"$self","kind":13,"containerName":"retrieve_blast","line":598},{"name":"readmethod","kind":12,"containerName":"retrieve_blast","line":598},{"name":"$line","kind":13,"containerName":"retrieve_blast","line":601},{"kind":13,"containerName":"retrieve_blast","name":"$s","line":602},{"line":603,"kind":13,"containerName":"retrieve_blast","name":"$s"},{"name":"$line","containerName":"retrieve_blast","kind":13,"line":604},{"name":"$status","localvar":"my","kind":13,"containerName":"retrieve_blast","line":605,"definition":"my"},{"containerName":"retrieve_blast","kind":13,"name":"$status","line":606},{"line":607,"name":"$waiting","kind":13,"containerName":"retrieve_blast"},{"kind":13,"containerName":"retrieve_blast","name":"$status","line":608},{"containerName":"retrieve_blast","kind":13,"name":"$TMP","line":609},{"definition":"my","line":610,"name":"$ERR","containerName":"retrieve_blast","localvar":"my","kind":13},{"kind":13,"containerName":"retrieve_blast","name":"$self","line":610},{"line":610,"name":"throw","kind":12,"containerName":"retrieve_blast"},{"containerName":"retrieve_blast","kind":13,"name":"$self","line":611},{"name":"warn","containerName":"retrieve_blast","kind":12,"line":611},{"line":611,"kind":13,"containerName":"retrieve_blast","name":"$ERR"},{"containerName":"retrieve_blast","kind":13,"name":"$ERR","line":612},{"name":"$status","kind":13,"containerName":"retrieve_blast","line":614},{"line":615,"name":"$waiting","kind":13,"containerName":"retrieve_blast"},{"name":"$self","containerName":"retrieve_blast","kind":13,"line":618},{"line":618,"containerName":"retrieve_blast","kind":12,"name":"warn"},{"line":622,"name":"$line","containerName":"retrieve_blast","kind":13},{"name":"$TMP","containerName":"retrieve_blast","kind":13,"line":623},{"definition":"my","line":624,"kind":13,"localvar":"my","containerName":"retrieve_blast","name":"$ERR"},{"name":"$self","containerName":"retrieve_blast","kind":13,"line":624},{"kind":12,"containerName":"retrieve_blast","name":"throw","line":624},{"containerName":"retrieve_blast","kind":13,"name":"$self","line":625},{"line":625,"containerName":"retrieve_blast","kind":12,"name":"warn"},{"name":"$ERR","containerName":"retrieve_blast","kind":13,"line":625},{"line":626,"containerName":"retrieve_blast","kind":13,"name":"$ERR"},{"name":"$TMP","kind":13,"containerName":"retrieve_blast","line":631},{"line":632,"name":"$waiting","kind":13,"containerName":"retrieve_blast"},{"line":633,"name":"$blastobj","localvar":"my","kind":13,"containerName":"retrieve_blast","definition":"my"},{"definition":"my","line":634,"localvar":"my","kind":13,"containerName":"retrieve_blast","name":"$mthd"},{"line":634,"name":"$self","kind":13,"containerName":"retrieve_blast"},{"line":634,"kind":12,"containerName":"retrieve_blast","name":"readmethod"},{"name":"$mthd","kind":13,"containerName":"retrieve_blast","line":635},{"line":635,"name":"$mthd","containerName":"retrieve_blast","kind":13},{"line":636,"kind":13,"containerName":"retrieve_blast","name":"$mthd"},{"name":"$mthd","kind":13,"containerName":"retrieve_blast","line":637},{"line":639,"name":"$blastobj","kind":13,"containerName":"retrieve_blast"},{"name":"new","kind":12,"containerName":"retrieve_blast","line":639},{"line":639,"kind":13,"containerName":"retrieve_blast","name":"$tempfile"},{"line":640,"containerName":"retrieve_blast","kind":13,"name":"$mthd"},{"name":"$self","kind":13,"containerName":"retrieve_blast","line":642},{"line":642,"name":"file","kind":12,"containerName":"retrieve_blast"},{"line":642,"containerName":"retrieve_blast","kind":13,"name":"$tempfile"},{"name":"$blastobj","kind":13,"containerName":"retrieve_blast","line":643},{"containerName":"retrieve_blast","kind":13,"name":"$got_content","line":644},{"line":646,"name":"$self","containerName":"retrieve_blast","kind":13},{"line":646,"name":"warn","kind":12,"containerName":"retrieve_blast"},{"name":"$self","containerName":"retrieve_blast","kind":13,"line":653},{"kind":12,"containerName":"retrieve_blast","name":"warn","line":653},{"name":"$response","containerName":"retrieve_blast","kind":13,"line":653},{"line":653,"kind":12,"containerName":"retrieve_blast","name":"error_as_HTML"}],"containerName":"main::","name":"retrieve_blast","definition":"sub","detail":"($self,$rid)"},{"line":576,"name":"POST","kind":12},{"line":639,"kind":12,"containerName":"SearchIO","name":"Bio"},{"signature":{"label":"save_output($self,$filename)","documentation":"__END__\n# $Id: RemoteBlast.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Tools::Run::RemoteBlast\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# FORMERLY Cared for by Jason Stajich, Mat Wiepert\n#\n# Somewhat cared for by Roger Hall, Chris Fields (when they have time)\n#\n# Copyright Jason Stajich, Bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::Run::RemoteBlast - Object for remote execution of the NCBI Blast\nvia HTTP\n\n=head1 SYNOPSIS\n\n  #Remote-blast \"factory object\" creation and blast-parameter initialization\n\n  use Bio::Tools::Run::RemoteBlast;\n  use strict;\n  my $prog = 'blastp';\n  my $db   = 'swissprot';\n  my $e_val= '1e-10';\n\n  my @params = ( '-prog' => $prog,\n         '-data' => $db,\n         '-expect' => $e_val,\n         '-readmethod' => 'SearchIO' );\n\n  my $factory = Bio::Tools::Run::RemoteBlast->new(@params);\n\n  #change a query paramter\n  $Bio::Tools::Run::RemoteBlast::HEADER{'ENTREZ_QUERY'} = 'Homo sapiens [ORGN]';\n\n  #change a retrieval parameter\n  $Bio::Tools::Run::RemoteBlast::RETRIEVALHEADER{'DESCRIPTIONS'} = 1000;\n\n  #remove a parameter\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n  #$v is just to turn on and off the messages\n  my $v = 1;\n\n  my $str = Bio::SeqIO->new(-file=>'amino.fa' , -format => 'fasta' );\n\n  while (my $input = $str->next_seq()){\n    #Blast a sequence against a database:\n\n    #Alternatively, you could  pass in a file with many\n    #sequences rather than loop through sequence one at a time\n    #Remove the loop starting 'while (my $input = $str->next_seq())'\n    #and swap the two lines below for an example of that.\n    my $r = $factory->submit_blast($input);\n    #my $r = $factory->submit_blast('amino.fa');\n\n    print STDERR \"waiting...\" if( $v > 0 );\n    while ( my @rids = $factory->each_rid ) {\n      foreach my $rid ( @rids ) {\n        my $rc = $factory->retrieve_blast($rid);\n        if( !ref($rc) ) {\n          if( $rc < 0 ) {\n            $factory->remove_rid($rid);\n          }\n          print STDERR \".\" if ( $v > 0 );\n          sleep 5;\n        } else {\n          my $result = $rc->next_result();\n          #save the output\n          my $filename = $result->query_name().\"\\.out\";\n          $factory->save_output($filename);\n          $factory->remove_rid($rid);\n          print \"\\nQuery Name: \", $result->query_name(), \"\\n\";\n          while ( my $hit = $result->next_hit ) {\n            next unless ( $v > 0);\n            print \"\\thit name is \", $hit->name, \"\\n\";\n            while( my $hsp = $hit->next_hsp ) {\n              print \"\\t\\tscore is \", $hsp->score, \"\\n\";\n            }\n          }\n        }\n      }\n    }\n  }\n\n  # This example shows how to change a CGI parameter:\n  $Bio::Tools::Run::RemoteBlast::HEADER{'MATRIX_NAME'} = 'BLOSUM45';\n  $Bio::Tools::Run::RemoteBlast::HEADER{'GAPCOSTS'} = '15 2';\n\n  # And this is how to delete a CGI parameter:\n  delete $Bio::Tools::Run::RemoteBlast::HEADER{'FILTER'};\n\n\n=head1 DESCRIPTION\n\nClass for remote execution of the NCBI Blast via HTTP.\n\nFor a description of the many CGI parameters see:\nhttp://www.ncbi.nlm.nih.gov/BLAST/Doc/urlapi.html\n\nVarious additional options and input formats are available.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.bioperl.org\n\n=head1 AUTHOR \n\nPlease do NOT contact Jason directly about this module.  Please post to\nthe bioperl mailing list (L<FEEDBACK>). If you would like to be the\nofficial maintainer of this module, please volunteer on the list and\nwe will make it official in this POD.\n\nFirst written by Jason Stajich, many others have helped keep it running.\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\npackage Bio::Tools::Run::RemoteBlast;\n\nuse vars qw($AUTOLOAD $URLBASE %HEADER %RETRIEVALHEADER\n\t    $RIDLINE $MODVERSION %PUTPARAMS %GETPARAMS);\nuse strict;\n\nuse Bio::SeqIO;\nuse IO::String;\nuse Bio::SearchIO;\nuse LWP;\nuse HTTP::Request::Common;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\nBEGIN {\n    $MODVERSION = $Bio::Root::Version::VERSION;\n    $URLBASE = 'http://blast.ncbi.nlm.nih.gov/Blast.cgi';\n\n    # In GET/PUTPARAMS the values are regexes which validate the input.\n    %PUTPARAMS = (\n\t'AUTO_FORMAT' \t=> '(Off|(Semi|Full)auto)',\t# Off, Semiauto, Fullauto\n\t'COMPOSITION_BASED_STATISTICS'\t=> '(0|1)',\t# yes, no on NCBI's site, but actually binary 0/1\n\t'DATABASE' \t=>  '.*',\n\t'DB_GENETIC_CODE' => '([1-9]|1[1-6]|2(1|2))',   # 1..16,21,22\n    'DISPLAY_SORT'   => '\\d',\n\t'ENDPOINTS'\t=> '(yes|no)',\t\t\t# yes,no\n\t'ENTREZ_QUERY'\t=> '.*',\n\t'EXPECT'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t'FILTER'\t=> '[LRm]',\t\t\t# L or R or m\n\t'GAPCOSTS'\t=> '-?\\d+(\\.\\d+)\\s+i-?\\d+(\\.\\d+)',\n\t\t\t\t\t# Two space separated float values\n\t'GENETIC_CODE'\t=> '([1-9]|1[1-6]|2(1|2))',\t# 1..16,21,22\n\t'HITLIST_SIZE'\t=> '\\d+',\t\t\t# Positive integer\n\t'I_THRESH'\t=> '-?\\d+(\\.\\d+)([eE]-\\d+)?',\t# float\n\t'LAYOUT'\t=> '(One|Two)Windows?',\t\t# onewindow, twowindows\n\t'LCASE_MASK'\t=> '(yes|no)',\t\t\t# yes, no\n\t'MATRIX_NAME'\t=> '.*',\n\t'NUCL_PENALTY'\t=> '-\\d+',\t\t\t# Negative integer\n\t'NUCL_REWARD'\t=> '-?\\d+',\t\t\t# Integer\n\t'OTHER_ADVANCED' => '.*',\n\t'PERC_IDENT'\t=> '\\d\\d+',\t\t\t# Integer, 0-99 inclusive\n\t'PHI_PATTERN'\t=> '.*',\n\t'PROGRAM'\t=> 't?blast[pnx]',\n\t\t\t\t\t# tblastp, tblastn, tblastx, blastp, blastn, blastx\n\t'QUERY'\t\t=> '.*',\n\t'QUERY_FILE'\t=> '.*',\n\t'QUERY_BELIEVE_DEFLINE'\t=> '(yes|no)',\t\t# yes, no\n\t'QUERY_FROM'\t=> '\\d+',\t\t\t# Positive integer\n\t'QUERY_TO'\t=> '\\d+',\t\t\t# Positive integer\n\t'SEARCHSP_EFF'\t=> '\\d+',\t\t\t# Positive integer\n\t'SERVICE'\t=> '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n    'SHORT_QUERY_ADJUST' => '(true|false)',\n\t'THRESHOLD'\t=> '-?\\d+',\t\t\t# Integer\n\t'UNGAPPED_ALIGNMENT' => '(yes|no)',\t\t# yes, no\n\t'WORD_SIZE'\t=> '\\d+'\t\t\t# Positive integer\n\t\t\t\t\t  );\n    %GETPARAMS = (\n   'ALIGNMENTS'\t=> '\\d+',\t\t\t# Positive integer\n\t'ALIGNMENT_VIEW' =>\n\t\t  '(Pairwise|(Flat)?QueryAnchored(NoIdentities)?|Tabular)',\n\t # Pairwise, QueryAnchored, QueryAnchoredNoIdentities, \n  \t # FlatQueryAnchored, FlatQueryAnchoredNoIdentities, Tabular\n     'DATABASE_SORT' => '\\d',\n\t 'DESCRIPTIONS'\t=> '\\d+',\t\t\t# Positive integer\n\t 'ENTREZ_LINKS_NEW_WINDOW' => '(yes|no)',\t# yes, no\n\t 'EXPECT_LOW'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'EXPECT_HIGH'\t=> '\\d+(\\.\\d+)?([eE]-\\d+)?',\t# Positive double\n\t 'FORMAT_ENTREZ_QUERY' => '',\n\t 'FORMAT_OBJECT'\t=> \n    '(Alignment|Neighbors|PSSM|SearchInfo|TaxBlast(Parent|MultiFrame)?)',\n\t\t\t\t\t# Alignment, Neighbors, PSSM,  SearchInfo \n\t\t\t\t\t# TaxBlast, TaxblastParent, TaxBlastMultiFrame \n\t 'FORMAT_TYPE'\t=> '((HT|X)ML|ASN\\.1|Text)',\n\t\t\t\t\t# HTML, Text, ASN.1, XML\n\t 'NCBI_GI'\t=> '(yes|no)',\t\t\t# yes, no\n     'NEW_VIEW' => '(true|false)',\n\t 'RID' \t\t=>  '.*',\n\t 'RESULTS_FILE' \t=>  '(yes|no)',\t\t\t# yes, no\n\t 'SERVICE' \t=>  '(plain|p[sh]i|(rps|mega)blast)',\n\t\t\t\t\t# plain,psi,phi,rpsblast,megablast\n\t 'SHOW_OVERVIEW' =>  '(yes|no)'\t\t\t# yes, no\n\t\t\t\t\t  );\n\n    # Default values go in here for PUT\n    %HEADER = (\n\t       'CMD'                          => 'Put',\n\t       'FORMAT_OBJECT'                => 'Alignment',\n\t       'COMPOSITION_BASED_STATISTICS' => 'off', \n\t       'DATABASE'\t    \t      => 'nr',\n\t       'EXPECT'\t\t\t      => '1e-3', \n\t       'FILTER'\t\t\t      => 'L', \n\t       'PROGRAM'\t\t      => 'blastp', \n\t       'SERVICE'\t\t      => 'plain' \n\t       );\n    \n    # Default values go in here for GET\n    %RETRIEVALHEADER = (\n\t\t\t'CMD'            => 'Get',\n\t\t\t'ALIGNMENTS'\t => '50',\n\t\t\t'ALIGNMENT_VIEW' => 'Pairwise',\n\t\t\t'DESCRIPTIONS'\t => '100',\n\t\t\t'FORMAT_TYPE'\t => 'Text',\n\t\t\t);\n    \n    $RIDLINE = 'RID\\s+=\\s+(\\S+)';\n}\n\nsub new {\n\tmy ($caller, @args) = @_;\n\t# chained new\n\tmy $self = $caller->SUPER::new(@args);\n\t# so that tempfiles are cleaned up\n\t$self->_initialize_io();\n\tmy ($prog, $data, $readmethod, $url_base) =\n        $self->_rearrange([qw(PROG DATA READMETHOD URL_BASE)],\n\t\t\t\t\t @args);\n\t# Use these two parameters for backward-compatibility. \n\t# Overridden by PROGRAM and DATABASE if supplied.\n\t$self->submit_parameter('PROGRAM',$prog) if $prog;\n\t$self->submit_parameter('DATABASE',$data) if $data;\n\n\t$readmethod = 'SearchIO' unless defined $readmethod;\n\t$self->readmethod($readmethod);\n\n\t# Now read the rest of the parameters and set them all\n\n\t# PUT parameters first\n\tmy @putValues = $self->_rearrange([keys %PUTPARAMS],@args);\n\tmy %putNames;\n\t@putNames{keys %PUTPARAMS} = @putValues;\n\tforeach my $putName (keys %putNames) {\n\t\t$self->submit_parameter($putName,$putNames{$putName});\n\t}\n\t# GET parameters second\n\tmy @getValues = $self->_rearrange([keys %GETPARAMS],@args);\n\tmy %getNames;\n\t@getNames{keys %GETPARAMS} = @getValues;\n\tforeach my $getName (keys %getNames) {\n\t\t$self->retrieve_parameter($getName,$getNames{$getName});\n\t}\n        # private variable to keep track of total rids\n    $self->{'_total_rids'} = 0;\n    $url_base ||= $URLBASE;  # default to regular NCBI BLAST URL\n    $self->set_url_base($url_base);\n\treturn $self;\n}\n\n=head2 retrieve_parameter\n\n Title   : retrieve_parameter\n Usage   : my $db = $self->retrieve_parameter\n Function: Get/Set the named parameter for the retrieve_blast operation.\n Returns : string\n Args    : $name : name of GET parameter\n\t $val : optional value to set the parameter to\n\n\nsub retrieve_parameter {\n\tmy ($self, $name, $val) = @_;\n\t$name = uc($name);\n\t$self->throw($name.\" is not a valid GET parameter.\") unless\n\t  exists $GETPARAMS{$name};\n\tif (defined $val) {\n    \tmy $regex = $GETPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t  $self->throw(\"Value \".$val.\" for GET parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t\t$RETRIEVALHEADER{$name} = $val;\n\t}\n\treturn $RETRIEVALHEADER{$name};\n}\n\n=head2 submit_parameter\n\n Title   : submit_parameter\n Usage   : my $db = $self->submit_parameter\n Function: Get/Set the named parameter for the submit_blast operation.\n Returns : string\n Args    : $name : name of PUT parameter\n    $val : optional value to set the parameter to\n\n\nsub submit_parameter {\n    my ($self, $name, $val) = @_;\n    $name = uc($name);\n    $self->throw($name.\" is not a valid PUT parameter.\") unless\n\texists $PUTPARAMS{$name};\n    if (defined $val) {\n    \tmy $regex = $PUTPARAMS{$name};\n    \t$val =~ m/^$regex$/i or \n\t\t$self->throw(\"Value \".$val.\" for PUT parameter \".$name.\" does not match expression \".$regex.\". Rejecting.\");\n\t$HEADER{$name} = $val;\n    }\n    return $HEADER{$name};\n}\n\n=head2 header\n\n Title   : header\n Usage   : my $header = $self->header\n Function: Get HTTP header for blast query\n Returns : string\n Args    : none\n\n\nsub header {\n    my ($self) = @_;\n    return %HEADER;\n}\n\n=head2 readmethod\n\n Title   : readmethod\n Usage   : my $readmethod = $self->readmethod\n Function: Get/Set the method to read the blast report\n Returns : string\n Args    : string [ blast, blasttable, xml ]\n\n\nsub readmethod {\n    my ($self, $val) = @_;\n    if( defined $val ) {\n        if ($val =~ /bplite/i) {\n            $self->throw(\"Use of Bio::Tools::BPlite is deprecated; use Bio::SearchIO modules instead\");\n        }\n        $self->{'_readmethod'} = $val;\n    }\n    return $self->{'_readmethod'};\n}\n\n\n=head2 program\n\n Title   : program\n Usage   : my $prog = $self->program\n Function: Get/Set the program to run. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ blastp, blastn, blastx, tblastn, tblastx ]\n\n\nsub program {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('PROGRAM',$val);\n}\n\n\n=head2 database\n\n Title   : database\n Usage   : my $db = $self->database\n Function: Get/Set the database to search. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ swissprot, nr, nt, etc... ]\n\n\nsub database {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('DATABASE',$val);\n}\n\n\n=head2 expect\n\n Title   : expect\n Usage   : my $expect = $self->expect\n Function: Get/Set the E value cutoff. Retained for backwards-compatibility.\n Returns : string\n Args    : string [ '1e-4' ]\n\n\nsub expect {\n    my ($self, $val) = @_;\n    return $self->submit_parameter('EXPECT',$val);\n}\n\n=head2 ua\n\n Title   : ua\n Usage   : my $ua = $self->ua or\n           $self->ua($ua)\n Function: Get/Set a LWP::UserAgent for use\n Returns : reference to LWP::UserAgent Object\n Args    : none\n Comments: Will create a UserAgent if none has been requested before.\n\n\nsub ua {\n    my ($self, $value) = @_;    \n    if( ! defined $self->{'_ua'} ) {\n\t$self->{'_ua'} = LWP::UserAgent->new(env_proxy => 1, parse_head => 0);\n\tmy $nm = ref($self);\n\t$nm =~ s/::/_/g;\n\t$self->{'_ua'}->agent(\"bioperl-$nm/$MODVERSION\");\n    }\n    return $self->{'_ua'};\n}\n\n=head2 proxy\n\n Title   : proxy\n Usage   : $httpproxy = $db->proxy('http')  or\n           $db->proxy(['http','ftp'], 'http://myproxy' )\n Function: Get/Set a proxy for use of proxy\n Returns : a string indicating the proxy\n Args    : $protocol : an array ref of the protocol(s) to set/get\n           $proxyurl : url of the proxy to use for the specified protocol\n\n\nsub proxy {\n    my ($self,$protocol,$proxy) = @_;\n    return if ( !defined $self->ua || !defined $protocol\n\t\t      || !defined $proxy );\n    return $self->ua->proxy($protocol,$proxy);\n}\n\nsub add_rid {\n    my ($self, @vals) = @_;\n    foreach ( @vals ) {\n\t$self->{'_rids'}->{$_} = $self->{'_total_rids'};\n        $self->{'_total_rids'}++; \n    }\n    return scalar keys %{$self->{'_rids'}};\n}\n\nsub remove_rid {\n    my ($self, @vals) = @_;\n    foreach ( @vals ) {\n\tdelete $self->{'_rids'}->{$_};\n    }\n    return scalar keys %{$self->{'_rids'}};\n}\n\nsub each_rid {\n    my ($self) = @_;\n    # sort on key value, a little tricky...\n    my @sort_rids = sort {$self->{'_rids'}->{$a} <=> $self->{'_rids'}->{$b}} keys %{$self->{'_rids'}};\n    return @sort_rids;\n}\n\n=head2 submit_blast\n\n Title   : submit_blast\n Usage   : $self->submit_blast([$seq1,$seq2]);\n Function: Submit blast jobs to ncbi blast queue on sequence(s)\n Returns : Blast report object as defined by $self->readmethod\n Args    : input can be:\n           * sequence object\n           * array ref of sequence objects\n           * filename of file containing fasta formatted sequences\n\n\nsub submit_blast {\n    my ($self, $input) = @_;\n    my @seqs = $self->_load_input($input);\n    my $url_base = $self->get_url_base;\n    return 0 unless ( @seqs );\n    my $tcount = 0;\n    my %header = $self->header;\n    $header{$_} ||= $RETRIEVALHEADER{$_} foreach (keys %RETRIEVALHEADER);    \n    foreach my $seq ( @seqs ) {\n\t#If query has a fasta header, the output has the query line.\n\t$header{'QUERY'} = \">\".(defined $seq->display_id() ? $seq->display_id() : \"\").\n\t\t\" \".(defined $seq->desc() ? $seq->desc() : \"\").\"\\n\".$seq->seq();\n\tmy $request = POST $url_base, [%header];\n\t$self->warn($request->as_string) if ( $self->verbose > 0);\n\tmy $response = $self->ua->request( $request);\n\n\tif( $response->is_success ) {\n\t    my @subdata = split(/\\n/, $response->content );\n\t    my $count = 0;\n\t    foreach ( @subdata ) {\n\t\t\tif( /$RIDLINE/ ) {\n\t\t    \t$count++;\n\t\t    \t$self->debug(\"RID: $1\\n\");\n\t\t    \t$self->add_rid($1);\n\t\t    \tlast;\n\t\t\t}\n\t    }\n\t    if( $count == 0 ) {\n            $self->warn(\"req was \". $request->as_string() . \"\\n\");\n            $self->warn(join('', @subdata));\n\t    }    \t\n\t    $tcount += $count;\n\t} else {\n\t    # should try and be a little more verbose here\n\t    $self->warn(\"req was \". $request->as_string() . \"\\n\" .\n\t\t\t$response->error_as_HTML);\n\t    $tcount = -1;\n\t\t}\n    }\n    return $tcount;\n}\n\n=head2 retrieve_blast\n\n Title   : retrieve_blast\n Usage   : my $blastreport = $blastfactory->retrieve_blast($rid);\n Function: Attempts to retrieve a blast report from remote blast queue\n Returns : -1 on error,\n           0 on 'job not finished',\n           Bio::SearchIO object\n Args    : Remote Blast ID (RID)\n\n\nsub retrieve_blast {\n    my($self, $rid) = @_;\n    my ($fh,$tempfile) = $self->tempfile();\n    close $fh;\t\t\t#explicit close\n    my $url_base = $self->get_url_base;\n    my %hdr = %RETRIEVALHEADER;\n    $hdr{'RID'} = $rid;\n    my $req = POST $url_base, [%hdr];\n    $self->debug(\"retrieve request is \" . $req->as_string());\n    my $response = $self->ua->request($req, $tempfile);\n    if( $response->is_success ) {\n    \tif( $self->verbose > 0 ) {\n            #print content of reply if verbose > 1\n            open(my $DEBUG, $tempfile) || $self->throw(\"cannot open $tempfile\");\n            while(<$DEBUG>) { print $_; }\n            close $DEBUG;\n    \t}\n        open(my $TMP, $tempfile) || $self->throw(\"Error opening $tempfile\");\n        ## if proper reply \n        my $waiting = 1;\n        my $s = 0;\n        my $got_content = 0;\n        my $is_tabular = 0;\n        while(my $line = <$TMP>) {\n            if ($line =~ /./) {\n                $got_content = 1;\n            }\n            if($line =~ /<\\?xml version=/ ) { # xml time\n                $waiting = 0;\n                $self->readmethod('blastxml');\n                last;\n            }\n            if($line =~ /QBlastInfoBegin/i ) {\n                $s = 1;\n            } elsif( $s ) {\n                if($line =~ /Status=(WAITING|ERROR|READY)/i ) {\n                    my $status = $1;\n                    if( $status eq 'WAITING' ) {\n                        $waiting = 1;\n                    } elsif( $status eq 'ERROR' ) {\n                        close($TMP);\n                        open(my $ERR, \"<$tempfile\") or $self->throw(\"cannot open file $tempfile\");\n                        $self->warn(join(\"\", <$ERR>));\n                        close $ERR;\n                        return -1;\n                    } elsif( $status eq 'READY' ) {\n                        $waiting = 0;\n                        last;\n                    } else {\n                        $self->warn(\"Unknown status $1:\\n\");\n                        last;\n                    }\n                }\n            } elsif ($line =~ /ERROR/i ) {\n                close($TMP);\n                open(my $ERR, \"<$tempfile\") or $self->throw(\"cannot open file $tempfile\");\n                $self->warn(join(\"\", <$ERR>));\n                close $ERR;\n                return -1;\n            }\n            \n        }\n        close($TMP);\n        if( ! $waiting ) {\n            my $blastobj;\n            my $mthd = $self->readmethod;\n            $mthd = ($mthd =~ /blasttable/i) ? 'blasttable' :\n                    ($mthd =~ /xml/i)        ? 'blastxml'   :\n                    ($mthd =~ /pull/i)       ? 'blast_pull' :\n                    'blast';\n            $blastobj = Bio::SearchIO->new( -file => $tempfile,\n                               -format => $mthd);                    \n            ## store filename in object ##\n            $self->file($tempfile);\n            return $blastobj;\n        } elsif (!$got_content) {\n            # server returned no content, can't be good\n            $self->warn(\"Server failed to return any data\");\n            return -1\n        } else {\t\t# still working\n            return 0;\n        }\n\t\n    } else {\n        $self->warn($response->error_as_HTML);\n        return -1;\n    }\n}\n\n=head2 save_output\n\n Title   : saveoutput\n Usage   : my $saveoutput = $self->save_output($filename)\n Function: Method to save the blast report\n Returns : 1 (throws error otherwise)\n Args    : string [rid, filename]","parameters":[{"label":"$self"},{"label":"$filename"}]},"range":{"end":{"character":9999,"line":693},"start":{"line":668,"character":0}},"kind":12,"line":668,"detail":"($self,$filename)","definition":"sub","containerName":"main::","name":"save_output","children":[{"name":"$self","kind":13,"localvar":"my","containerName":"save_output","line":669,"definition":"my"},{"kind":13,"containerName":"save_output","name":"$filename","line":669},{"containerName":"save_output","kind":13,"name":"$filename","line":670},{"name":"$self","containerName":"save_output","kind":13,"line":671},{"line":671,"kind":12,"containerName":"save_output","name":"throw"},{"definition":"my","localvar":"my","kind":13,"containerName":"save_output","name":"$blastfile","line":673},{"line":673,"containerName":"save_output","kind":13,"name":"$self"},{"line":673,"name":"file","kind":12,"containerName":"save_output"},{"definition":"my","kind":13,"localvar":"my","containerName":"save_output","name":"$TMP","line":675},{"containerName":"save_output","kind":13,"name":"$blastfile","line":675},{"line":675,"name":"$self","containerName":"save_output","kind":13},{"name":"throw","kind":12,"containerName":"save_output","line":675},{"definition":"my","containerName":"save_output","localvar":"my","kind":13,"name":"$SAVEOUT","line":677},{"kind":13,"containerName":"save_output","name":"$filename","line":677},{"containerName":"save_output","kind":13,"name":"$self","line":677},{"line":677,"containerName":"save_output","kind":12,"name":"throw"},{"localvar":"my","containerName":"save_output","kind":13,"name":"$seentop","line":678,"definition":"my"},{"line":679,"kind":13,"containerName":"save_output","name":"$TMP"},{"name":"$seentop","kind":13,"containerName":"save_output","line":685},{"line":687,"containerName":"save_output","kind":13,"name":"$seentop"},{"line":688,"name":"$seentop","kind":13,"containerName":"save_output"},{"name":"$SAVEOUT","containerName":"save_output","kind":13,"line":689}]},{"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$input"}],"label":"_load_input($self,$input)"},"line":695,"kind":12,"range":{"end":{"line":728,"character":9999},"start":{"line":695,"character":0}},"definition":"sub","detail":"($self,$input)","children":[{"name":"$self","localvar":"my","kind":13,"containerName":"_load_input","line":696,"definition":"my"},{"containerName":"_load_input","kind":13,"name":"$input","line":696},{"line":698,"name":"$input","containerName":"_load_input","kind":13},{"containerName":"_load_input","kind":13,"name":"$self","line":699},{"name":"throw","containerName":"_load_input","kind":12,"line":699},{"definition":"my","name":"@seqs","localvar":"my","kind":13,"containerName":"_load_input","line":701},{"line":702,"name":"$input","kind":13,"containerName":"_load_input"},{"name":"$input","containerName":"_load_input","kind":13,"line":703},{"definition":"my","name":"$seqio","localvar":"my","kind":13,"containerName":"_load_input","line":704},{"line":704,"name":"new","kind":12,"containerName":"_load_input"},{"line":705,"containerName":"_load_input","kind":13,"name":"$input"},{"line":706,"containerName":"_load_input","localvar":"my","kind":13,"name":"$seq","definition":"my"},{"line":706,"name":"$seqio","containerName":"_load_input","kind":13},{"line":706,"containerName":"_load_input","kind":12,"name":"next_seq"},{"line":707,"kind":13,"containerName":"_load_input","name":"@seqs"},{"kind":13,"containerName":"_load_input","name":"$seq","line":707},{"line":710,"name":"$self","kind":13,"containerName":"_load_input"},{"line":710,"name":"throw","kind":12,"containerName":"_load_input"},{"kind":13,"containerName":"_load_input","name":"$input","line":712},{"line":713,"name":"$input","containerName":"_load_input","kind":13},{"containerName":"_load_input","kind":12,"name":"isa","line":714},{"line":715,"kind":13,"containerName":"_load_input","name":"@seqs"},{"kind":13,"containerName":"_load_input","name":"$self","line":717},{"name":"warn","containerName":"_load_input","kind":12,"line":717},{"kind":13,"containerName":"_load_input","name":"@seqs","line":721},{"line":722,"kind":13,"containerName":"_load_input","name":"$self"},{"containerName":"_load_input","kind":12,"name":"throw","line":722},{"line":724,"name":"$input","kind":13,"containerName":"_load_input"},{"name":"isa","containerName":"_load_input","kind":12,"line":724},{"name":"@seqs","containerName":"_load_input","kind":13,"line":725},{"line":725,"kind":13,"containerName":"_load_input","name":"$input"},{"line":727,"containerName":"_load_input","kind":13,"name":"@seqs"}],"containerName":"main::","name":"_load_input"},{"kind":12,"containerName":"SeqIO","name":"Bio","line":704},{"name":"set_url_base","containerName":"main::","children":[{"line":743,"containerName":"set_url_base","localvar":"my","kind":13,"name":"$self","definition":"my"},{"name":"$self","kind":13,"containerName":"set_url_base","line":744}],"definition":"sub","kind":12,"range":{"end":{"line":745,"character":9999},"start":{"line":742,"character":0}},"line":742},{"definition":"sub","children":[{"line":758,"name":"$self","kind":13,"localvar":"my","containerName":"get_url_base","definition":"my"},{"name":"$self","kind":13,"containerName":"get_url_base","line":759}],"containerName":"main::","name":"get_url_base","line":757,"kind":12,"range":{"end":{"line":760,"character":9999},"start":{"line":757,"character":0}}}],"version":5}