{"vars":[{"line":98,"containerName":"main::","kind":14,"name":"DEBUG","definition":1},{"line":98,"kind":12,"containerName":"","name":"strict"},{"containerName":"","kind":2,"name":"base","line":101},{"line":113,"range":{"end":{"character":9999,"line":120},"start":{"line":113,"character":0}},"kind":12,"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n\n=head1 NAME\n\nBio::Tools::TandemRepeatsFinder - a parser for Tandem Repeats Finder output\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::TandemRepeatsFinder;\n\n    # create parser\n    my $parser = Bio::Tools::Bio::Tools::TandemRepeatsFinder->new(-file => 'tandem_repeats.out');\n\n    # loop through results\n    while( my $feature = $parser->next_result ) {\n\n        # print the source sequence id, start, end, percent matches, and the consensus sequence\n        my ($percent_matches)    = $feat->get_tag_values('percent_matches');\n        my ($consensus_sequence) = $feat->get_tag_values('consensus_sequence');\n        print $feat->seq_id().\"\\t\".$feat->start().\"\\t\".$feat->end().\"\\t$percent_matches\\t$consensus_sequence\\n\"; \n\n    }\n\n=head1 DESCRIPTION\n\nA parser for Tandem Repeats Finder output.  \nWritten and tested for version 4.00\n\nLocation, seq_id, and score are stored in Bio::SeqFeature::Generic feature.\nAll other data is stored in tags.  The availabale tags are\n\n        period_size\n        copy_number\n        consensus_size\n        percent_matches\n        percent_indels\n        percent_a\n        percent_c\n        percent_g\n        percent_t\n        entropy\n        consensus_sequence\n        repeat_sequence\n        run_parameters\n        sequence_description\n\nThe run_parameters are stored in a hashref with the following key:\n\n        match_weight\n        mismatch_weight\n        indel_weight\n        match_prob\n        indel_prob\n        min_score\n        max_period_size\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Eric Just\n\nEmail e-just@northwestern.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::TandemRepeatsFinder;\nuse strict;\nuse constant DEBUG => 0;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::TandemRepeatsFinder->new();\n Function: Builds a new Bio::Tools::TandemRepeatsFinder object\n Returns : Bio::Tools::TandemRepeatsFinder\n Args    : -fh/-file => $val, for initing input, see Bio::Root::IO"},"children":[{"line":114,"name":"$class","kind":13,"localvar":"my","containerName":"new","definition":"my"},{"line":114,"name":"@args","containerName":"new","kind":13},{"containerName":"new","localvar":"my","kind":13,"name":"$self","line":116,"definition":"my"},{"line":116,"name":"$class","containerName":"new","kind":13},{"containerName":"new","kind":13,"name":"@args","line":116},{"line":117,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"containerName":"new","name":"_initialize_io","line":117},{"line":117,"kind":13,"containerName":"new","name":"@args"},{"line":119,"containerName":"new","kind":13,"name":"$self"}],"containerName":"main::","name":"new","definition":"sub","detail":"($class,@args)"},{"containerName":"new","kind":12,"name":"SUPER","line":116},{"children":[{"name":"$self","containerName":"version","localvar":"my","kind":13,"line":133,"definition":"my"},{"containerName":"version","kind":13,"name":"$value","line":133},{"line":134,"kind":13,"containerName":"version","name":"$value"},{"line":135,"kind":13,"containerName":"version","name":"$self"},{"line":135,"name":"$value","containerName":"version","kind":13},{"line":137,"kind":13,"containerName":"version","name":"$self"}],"containerName":"main::","name":"version","definition":"sub","detail":"($self,$value)","line":132,"kind":12,"range":{"end":{"line":138,"character":9999},"start":{"line":132,"character":0}},"signature":{"label":"version($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n\n=head1 NAME\n\nBio::Tools::TandemRepeatsFinder - a parser for Tandem Repeats Finder output\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::TandemRepeatsFinder;\n\n    # create parser\n    my $parser = Bio::Tools::Bio::Tools::TandemRepeatsFinder->new(-file => 'tandem_repeats.out');\n\n    # loop through results\n    while( my $feature = $parser->next_result ) {\n\n        # print the source sequence id, start, end, percent matches, and the consensus sequence\n        my ($percent_matches)    = $feat->get_tag_values('percent_matches');\n        my ($consensus_sequence) = $feat->get_tag_values('consensus_sequence');\n        print $feat->seq_id().\"\\t\".$feat->start().\"\\t\".$feat->end().\"\\t$percent_matches\\t$consensus_sequence\\n\"; \n\n    }\n\n=head1 DESCRIPTION\n\nA parser for Tandem Repeats Finder output.  \nWritten and tested for version 4.00\n\nLocation, seq_id, and score are stored in Bio::SeqFeature::Generic feature.\nAll other data is stored in tags.  The availabale tags are\n\n        period_size\n        copy_number\n        consensus_size\n        percent_matches\n        percent_indels\n        percent_a\n        percent_c\n        percent_g\n        percent_t\n        entropy\n        consensus_sequence\n        repeat_sequence\n        run_parameters\n        sequence_description\n\nThe run_parameters are stored in a hashref with the following key:\n\n        match_weight\n        mismatch_weight\n        indel_weight\n        match_prob\n        indel_prob\n        min_score\n        max_period_size\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Eric Just\n\nEmail e-just@northwestern.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::TandemRepeatsFinder;\nuse strict;\nuse constant DEBUG => 0;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::TandemRepeatsFinder->new();\n Function: Builds a new Bio::Tools::TandemRepeatsFinder object\n Returns : Bio::Tools::TandemRepeatsFinder\n Args    : -fh/-file => $val, for initing input, see Bio::Root::IO\n\n\nsub new {\n    my ( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n\n    return $self;\n}\n\n=head2 version\n\n Title   : version\n Usage   : $self->version( $version )\n Function: get/set the version of Tandem Repeats finder that was used in analysis\n Returns : value of version of \n Args    : new value (optional)"}},{"definition":"sub","detail":"($self,$value)","children":[{"line":151,"name":"$self","containerName":"_current_seq_id","localvar":"my","kind":13,"definition":"my"},{"name":"$value","containerName":"_current_seq_id","kind":13,"line":151},{"line":152,"name":"$value","kind":13,"containerName":"_current_seq_id"},{"containerName":"_current_seq_id","kind":13,"name":"$self","line":153},{"name":"$value","kind":13,"containerName":"_current_seq_id","line":153},{"line":155,"kind":13,"containerName":"_current_seq_id","name":"$self"}],"containerName":"main::","name":"_current_seq_id","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n\n=head1 NAME\n\nBio::Tools::TandemRepeatsFinder - a parser for Tandem Repeats Finder output\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::TandemRepeatsFinder;\n\n    # create parser\n    my $parser = Bio::Tools::Bio::Tools::TandemRepeatsFinder->new(-file => 'tandem_repeats.out');\n\n    # loop through results\n    while( my $feature = $parser->next_result ) {\n\n        # print the source sequence id, start, end, percent matches, and the consensus sequence\n        my ($percent_matches)    = $feat->get_tag_values('percent_matches');\n        my ($consensus_sequence) = $feat->get_tag_values('consensus_sequence');\n        print $feat->seq_id().\"\\t\".$feat->start().\"\\t\".$feat->end().\"\\t$percent_matches\\t$consensus_sequence\\n\"; \n\n    }\n\n=head1 DESCRIPTION\n\nA parser for Tandem Repeats Finder output.  \nWritten and tested for version 4.00\n\nLocation, seq_id, and score are stored in Bio::SeqFeature::Generic feature.\nAll other data is stored in tags.  The availabale tags are\n\n        period_size\n        copy_number\n        consensus_size\n        percent_matches\n        percent_indels\n        percent_a\n        percent_c\n        percent_g\n        percent_t\n        entropy\n        consensus_sequence\n        repeat_sequence\n        run_parameters\n        sequence_description\n\nThe run_parameters are stored in a hashref with the following key:\n\n        match_weight\n        mismatch_weight\n        indel_weight\n        match_prob\n        indel_prob\n        min_score\n        max_period_size\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Eric Just\n\nEmail e-just@northwestern.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::TandemRepeatsFinder;\nuse strict;\nuse constant DEBUG => 0;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::TandemRepeatsFinder->new();\n Function: Builds a new Bio::Tools::TandemRepeatsFinder object\n Returns : Bio::Tools::TandemRepeatsFinder\n Args    : -fh/-file => $val, for initing input, see Bio::Root::IO\n\n\nsub new {\n    my ( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n\n    return $self;\n}\n\n=head2 version\n\n Title   : version\n Usage   : $self->version( $version )\n Function: get/set the version of Tandem Repeats finder that was used in analysis\n Returns : value of version of \n Args    : new value (optional)\n\n\nsub version {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'version'} = $value;\n    }\n    return $self->{'version'};\n}\n\n=head2 _current_seq_id\n\n Title   : _current_seq_id\n Usage   : $self->_current_seq_id( $current_seq_id )\n Function: get/set the _current_seq_id\n Returns : value of _current_seq_id\n Args    : new value (optional)","label":"_current_seq_id($self,$value)"},"line":150,"range":{"start":{"character":0,"line":150},"end":{"character":9999,"line":156}},"kind":12},{"definition":"sub","detail":"($self,$value)","children":[{"containerName":"_current_seq_description","localvar":"my","kind":13,"name":"$self","line":169,"definition":"my"},{"name":"$value","kind":13,"containerName":"_current_seq_description","line":169},{"kind":13,"containerName":"_current_seq_description","name":"$value","line":170},{"containerName":"_current_seq_description","kind":13,"name":"$self","line":171},{"line":171,"containerName":"_current_seq_description","kind":13,"name":"$value"},{"name":"$self","kind":13,"containerName":"_current_seq_description","line":173}],"name":"_current_seq_description","containerName":"main::","signature":{"documentation":"1;\n\n=head1 NAME\n\nBio::Tools::TandemRepeatsFinder - a parser for Tandem Repeats Finder output\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::TandemRepeatsFinder;\n\n    # create parser\n    my $parser = Bio::Tools::Bio::Tools::TandemRepeatsFinder->new(-file => 'tandem_repeats.out');\n\n    # loop through results\n    while( my $feature = $parser->next_result ) {\n\n        # print the source sequence id, start, end, percent matches, and the consensus sequence\n        my ($percent_matches)    = $feat->get_tag_values('percent_matches');\n        my ($consensus_sequence) = $feat->get_tag_values('consensus_sequence');\n        print $feat->seq_id().\"\\t\".$feat->start().\"\\t\".$feat->end().\"\\t$percent_matches\\t$consensus_sequence\\n\"; \n\n    }\n\n=head1 DESCRIPTION\n\nA parser for Tandem Repeats Finder output.  \nWritten and tested for version 4.00\n\nLocation, seq_id, and score are stored in Bio::SeqFeature::Generic feature.\nAll other data is stored in tags.  The availabale tags are\n\n        period_size\n        copy_number\n        consensus_size\n        percent_matches\n        percent_indels\n        percent_a\n        percent_c\n        percent_g\n        percent_t\n        entropy\n        consensus_sequence\n        repeat_sequence\n        run_parameters\n        sequence_description\n\nThe run_parameters are stored in a hashref with the following key:\n\n        match_weight\n        mismatch_weight\n        indel_weight\n        match_prob\n        indel_prob\n        min_score\n        max_period_size\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Eric Just\n\nEmail e-just@northwestern.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::TandemRepeatsFinder;\nuse strict;\nuse constant DEBUG => 0;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::TandemRepeatsFinder->new();\n Function: Builds a new Bio::Tools::TandemRepeatsFinder object\n Returns : Bio::Tools::TandemRepeatsFinder\n Args    : -fh/-file => $val, for initing input, see Bio::Root::IO\n\n\nsub new {\n    my ( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n\n    return $self;\n}\n\n=head2 version\n\n Title   : version\n Usage   : $self->version( $version )\n Function: get/set the version of Tandem Repeats finder that was used in analysis\n Returns : value of version of \n Args    : new value (optional)\n\n\nsub version {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'version'} = $value;\n    }\n    return $self->{'version'};\n}\n\n=head2 _current_seq_id\n\n Title   : _current_seq_id\n Usage   : $self->_current_seq_id( $current_seq_id )\n Function: get/set the _current_seq_id\n Returns : value of _current_seq_id\n Args    : new value (optional)\n\n\nsub _current_seq_id {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_current_seq_id'} = $value;\n    }\n    return $self->{'_current_seq_id'};\n}\n\n=head2 _current_seq_description\n\n Title   : _current_seq_description\n Usage   : $self->_current_seq_description( $current_seq_id )\n Function: get/set the _current_seq_description\n Returns : value of _current_seq_description\n Args    : new value (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"_current_seq_description($self,$value)"},"line":168,"kind":12,"range":{"end":{"line":174,"character":9999},"start":{"character":0,"line":168}}},{"definition":"sub","detail":"($self,$value)","children":[{"definition":"my","line":195,"localvar":"my","kind":13,"containerName":"_current_parameters","name":"$self"},{"name":"$value","containerName":"_current_parameters","kind":13,"line":195},{"name":"$value","containerName":"_current_parameters","kind":13,"line":196},{"line":197,"name":"$self","kind":13,"containerName":"_current_parameters"},{"line":197,"name":"$value","kind":13,"containerName":"_current_parameters"},{"line":199,"name":"$self","containerName":"_current_parameters","kind":13}],"name":"_current_parameters","containerName":"main::","signature":{"label":"_current_parameters($self,$value)","documentation":"1;\n\n=head1 NAME\n\nBio::Tools::TandemRepeatsFinder - a parser for Tandem Repeats Finder output\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::TandemRepeatsFinder;\n\n    # create parser\n    my $parser = Bio::Tools::Bio::Tools::TandemRepeatsFinder->new(-file => 'tandem_repeats.out');\n\n    # loop through results\n    while( my $feature = $parser->next_result ) {\n\n        # print the source sequence id, start, end, percent matches, and the consensus sequence\n        my ($percent_matches)    = $feat->get_tag_values('percent_matches');\n        my ($consensus_sequence) = $feat->get_tag_values('consensus_sequence');\n        print $feat->seq_id().\"\\t\".$feat->start().\"\\t\".$feat->end().\"\\t$percent_matches\\t$consensus_sequence\\n\"; \n\n    }\n\n=head1 DESCRIPTION\n\nA parser for Tandem Repeats Finder output.  \nWritten and tested for version 4.00\n\nLocation, seq_id, and score are stored in Bio::SeqFeature::Generic feature.\nAll other data is stored in tags.  The availabale tags are\n\n        period_size\n        copy_number\n        consensus_size\n        percent_matches\n        percent_indels\n        percent_a\n        percent_c\n        percent_g\n        percent_t\n        entropy\n        consensus_sequence\n        repeat_sequence\n        run_parameters\n        sequence_description\n\nThe run_parameters are stored in a hashref with the following key:\n\n        match_weight\n        mismatch_weight\n        indel_weight\n        match_prob\n        indel_prob\n        min_score\n        max_period_size\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Eric Just\n\nEmail e-just@northwestern.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::TandemRepeatsFinder;\nuse strict;\nuse constant DEBUG => 0;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::TandemRepeatsFinder->new();\n Function: Builds a new Bio::Tools::TandemRepeatsFinder object\n Returns : Bio::Tools::TandemRepeatsFinder\n Args    : -fh/-file => $val, for initing input, see Bio::Root::IO\n\n\nsub new {\n    my ( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n\n    return $self;\n}\n\n=head2 version\n\n Title   : version\n Usage   : $self->version( $version )\n Function: get/set the version of Tandem Repeats finder that was used in analysis\n Returns : value of version of \n Args    : new value (optional)\n\n\nsub version {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'version'} = $value;\n    }\n    return $self->{'version'};\n}\n\n=head2 _current_seq_id\n\n Title   : _current_seq_id\n Usage   : $self->_current_seq_id( $current_seq_id )\n Function: get/set the _current_seq_id\n Returns : value of _current_seq_id\n Args    : new value (optional)\n\n\nsub _current_seq_id {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_current_seq_id'} = $value;\n    }\n    return $self->{'_current_seq_id'};\n}\n\n=head2 _current_seq_description\n\n Title   : _current_seq_description\n Usage   : $self->_current_seq_description( $current_seq_id )\n Function: get/set the _current_seq_description\n Returns : value of _current_seq_description\n Args    : new value (optional)\n\n\nsub _current_seq_description {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_current_seq_description'} = $value;\n    }\n    return $self->{'_current_seq_description'};\n}\n\n=head2 _current_parameters\n\n Title   : _current_parameters\n Usage   : $self->_current_parameters( $parameters_hashref )\n Function: get/set the _current_parameters\n Returns : hashref representing current parameters parsed from results file\n         : keys are\n               match_weight\n               mismatch_weight\n               indel_weight\n               match_prob\n               indel_prob\n               min_score\n               max_period_size\n Args    : parameters hashref (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"line":194,"range":{"start":{"character":0,"line":194},"end":{"character":9999,"line":200}},"kind":12},{"signature":{"label":"next_result($self)","documentation":"1;\n\n=head1 NAME\n\nBio::Tools::TandemRepeatsFinder - a parser for Tandem Repeats Finder output\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::TandemRepeatsFinder;\n\n    # create parser\n    my $parser = Bio::Tools::Bio::Tools::TandemRepeatsFinder->new(-file => 'tandem_repeats.out');\n\n    # loop through results\n    while( my $feature = $parser->next_result ) {\n\n        # print the source sequence id, start, end, percent matches, and the consensus sequence\n        my ($percent_matches)    = $feat->get_tag_values('percent_matches');\n        my ($consensus_sequence) = $feat->get_tag_values('consensus_sequence');\n        print $feat->seq_id().\"\\t\".$feat->start().\"\\t\".$feat->end().\"\\t$percent_matches\\t$consensus_sequence\\n\"; \n\n    }\n\n=head1 DESCRIPTION\n\nA parser for Tandem Repeats Finder output.  \nWritten and tested for version 4.00\n\nLocation, seq_id, and score are stored in Bio::SeqFeature::Generic feature.\nAll other data is stored in tags.  The availabale tags are\n\n        period_size\n        copy_number\n        consensus_size\n        percent_matches\n        percent_indels\n        percent_a\n        percent_c\n        percent_g\n        percent_t\n        entropy\n        consensus_sequence\n        repeat_sequence\n        run_parameters\n        sequence_description\n\nThe run_parameters are stored in a hashref with the following key:\n\n        match_weight\n        mismatch_weight\n        indel_weight\n        match_prob\n        indel_prob\n        min_score\n        max_period_size\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Eric Just\n\nEmail e-just@northwestern.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::TandemRepeatsFinder;\nuse strict;\nuse constant DEBUG => 0;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::TandemRepeatsFinder->new();\n Function: Builds a new Bio::Tools::TandemRepeatsFinder object\n Returns : Bio::Tools::TandemRepeatsFinder\n Args    : -fh/-file => $val, for initing input, see Bio::Root::IO\n\n\nsub new {\n    my ( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n\n    return $self;\n}\n\n=head2 version\n\n Title   : version\n Usage   : $self->version( $version )\n Function: get/set the version of Tandem Repeats finder that was used in analysis\n Returns : value of version of \n Args    : new value (optional)\n\n\nsub version {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'version'} = $value;\n    }\n    return $self->{'version'};\n}\n\n=head2 _current_seq_id\n\n Title   : _current_seq_id\n Usage   : $self->_current_seq_id( $current_seq_id )\n Function: get/set the _current_seq_id\n Returns : value of _current_seq_id\n Args    : new value (optional)\n\n\nsub _current_seq_id {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_current_seq_id'} = $value;\n    }\n    return $self->{'_current_seq_id'};\n}\n\n=head2 _current_seq_description\n\n Title   : _current_seq_description\n Usage   : $self->_current_seq_description( $current_seq_id )\n Function: get/set the _current_seq_description\n Returns : value of _current_seq_description\n Args    : new value (optional)\n\n\nsub _current_seq_description {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_current_seq_description'} = $value;\n    }\n    return $self->{'_current_seq_description'};\n}\n\n=head2 _current_parameters\n\n Title   : _current_parameters\n Usage   : $self->_current_parameters( $parameters_hashref )\n Function: get/set the _current_parameters\n Returns : hashref representing current parameters parsed from results file\n         : keys are\n               match_weight\n               mismatch_weight\n               indel_weight\n               match_prob\n               indel_prob\n               min_score\n               max_period_size\n Args    : parameters hashref (optional)\n\n\nsub _current_parameters {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_current_parameters'} = $value;\n    }\n    return $self->{'_current_parameters'};\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $r = $trf->next_result()\n Function: Get the next result set from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none","parameters":[{"label":"$self"}]},"range":{"start":{"character":0,"line":212},"end":{"character":9999,"line":269}},"kind":12,"line":212,"detail":"($self)","definition":"sub","containerName":"main::","name":"next_result","children":[{"definition":"my","line":213,"kind":13,"localvar":"my","containerName":"next_result","name":"$self"},{"containerName":"next_result","kind":13,"name":"$self","line":214},{"kind":12,"containerName":"next_result","name":"_readline","line":214},{"name":"$version","kind":13,"localvar":"my","containerName":"next_result","line":218,"definition":"my"},{"line":219,"containerName":"next_result","kind":13,"name":"$self"},{"name":"warn","kind":12,"containerName":"next_result","line":219},{"line":220,"kind":13,"containerName":"next_result","name":"$self"},{"line":220,"name":"warn","containerName":"next_result","kind":12},{"line":221,"name":"$version","kind":13,"containerName":"next_result"},{"name":"$self","kind":13,"containerName":"next_result","line":222},{"line":222,"name":"version","containerName":"next_result","kind":12},{"kind":13,"containerName":"next_result","name":"$version","line":222},{"definition":"my","localvar":"my","kind":13,"containerName":"next_result","name":"$seq_id","line":228},{"kind":13,"localvar":"my","containerName":"next_result","name":"$seq_description","line":229,"definition":"my"},{"kind":13,"containerName":"next_result","name":"$self","line":230},{"name":"warn","containerName":"next_result","kind":12,"line":230},{"line":231,"name":"$self","containerName":"next_result","kind":13},{"line":231,"name":"_current_seq_id","kind":12,"containerName":"next_result"},{"containerName":"next_result","kind":13,"name":"$seq_id","line":231},{"kind":13,"containerName":"next_result","name":"$self","line":232},{"line":232,"name":"_current_seq_description","kind":12,"containerName":"next_result"},{"line":232,"containerName":"next_result","kind":13,"name":"$seq_description"},{"definition":"my","name":"$params","containerName":"next_result","localvar":"my","kind":13,"line":238},{"line":239,"name":"$self","kind":13,"containerName":"next_result"},{"line":239,"name":"warn","containerName":"next_result","kind":12},{"line":241,"containerName":"next_result","localvar":"my","kind":13,"name":"@param_array","definition":"my"},{"containerName":"next_result","kind":13,"name":"$params","line":241},{"definition":"my","line":243,"name":"$param_hash","kind":13,"localvar":"my","containerName":"next_result"},{"line":244,"containerName":"next_result","kind":13,"name":"$param_array"},{"kind":13,"containerName":"next_result","name":"$param_array","line":245},{"kind":13,"containerName":"next_result","name":"$param_array","line":246},{"containerName":"next_result","kind":13,"name":"$param_array","line":247},{"name":"$param_array","containerName":"next_result","kind":13,"line":248},{"line":249,"kind":13,"containerName":"next_result","name":"$param_array"},{"line":250,"name":"$param_array","containerName":"next_result","kind":13},{"line":252,"kind":13,"containerName":"next_result","name":"$self"},{"line":252,"name":"_current_parameters","kind":12,"containerName":"next_result"},{"line":252,"name":"$param_hash","kind":13,"containerName":"next_result"},{"line":261,"kind":13,"containerName":"next_result","name":"$self"},{"line":261,"name":"_create_feature","containerName":"next_result","kind":12},{"line":265,"name":"$self","kind":13,"containerName":"next_result"},{"name":"warn","kind":12,"containerName":"next_result","line":265}]},{"line":219,"kind":12,"name":"DEBUG"},{"line":230,"name":"DEBUG","kind":12},{"line":239,"kind":12,"name":"DEBUG"},{"kind":12,"name":"match_weight","line":244},{"kind":12,"name":"mismatch_weight","line":245},{"line":246,"name":"indel_weight","kind":12},{"line":247,"name":"match_prob","kind":12},{"kind":12,"name":"indel_prob","line":248},{"kind":12,"name":"min_score","line":249},{"line":250,"kind":12,"name":"max_period_size"},{"line":264,"kind":12,"name":"DEBUG"},{"signature":{"documentation":"1;\n\n=head1 NAME\n\nBio::Tools::TandemRepeatsFinder - a parser for Tandem Repeats Finder output\n\n=head1 SYNOPSIS\n\n    use Bio::Tools::TandemRepeatsFinder;\n\n    # create parser\n    my $parser = Bio::Tools::Bio::Tools::TandemRepeatsFinder->new(-file => 'tandem_repeats.out');\n\n    # loop through results\n    while( my $feature = $parser->next_result ) {\n\n        # print the source sequence id, start, end, percent matches, and the consensus sequence\n        my ($percent_matches)    = $feat->get_tag_values('percent_matches');\n        my ($consensus_sequence) = $feat->get_tag_values('consensus_sequence');\n        print $feat->seq_id().\"\\t\".$feat->start().\"\\t\".$feat->end().\"\\t$percent_matches\\t$consensus_sequence\\n\"; \n\n    }\n\n=head1 DESCRIPTION\n\nA parser for Tandem Repeats Finder output.  \nWritten and tested for version 4.00\n\nLocation, seq_id, and score are stored in Bio::SeqFeature::Generic feature.\nAll other data is stored in tags.  The availabale tags are\n\n        period_size\n        copy_number\n        consensus_size\n        percent_matches\n        percent_indels\n        percent_a\n        percent_c\n        percent_g\n        percent_t\n        entropy\n        consensus_sequence\n        repeat_sequence\n        run_parameters\n        sequence_description\n\nThe run_parameters are stored in a hashref with the following key:\n\n        match_weight\n        mismatch_weight\n        indel_weight\n        match_prob\n        indel_prob\n        min_score\n        max_period_size\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Eric Just\n\nEmail e-just@northwestern.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\npackage Bio::Tools::TandemRepeatsFinder;\nuse strict;\nuse constant DEBUG => 0;\nuse Bio::SeqFeature::Generic;\n\nuse base qw(Bio::Root::Root Bio::Root::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Tools::TandemRepeatsFinder->new();\n Function: Builds a new Bio::Tools::TandemRepeatsFinder object\n Returns : Bio::Tools::TandemRepeatsFinder\n Args    : -fh/-file => $val, for initing input, see Bio::Root::IO\n\n\nsub new {\n    my ( $class, @args ) = @_;\n\n    my $self = $class->SUPER::new(@args);\n    $self->_initialize_io(@args);\n\n    return $self;\n}\n\n=head2 version\n\n Title   : version\n Usage   : $self->version( $version )\n Function: get/set the version of Tandem Repeats finder that was used in analysis\n Returns : value of version of \n Args    : new value (optional)\n\n\nsub version {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'version'} = $value;\n    }\n    return $self->{'version'};\n}\n\n=head2 _current_seq_id\n\n Title   : _current_seq_id\n Usage   : $self->_current_seq_id( $current_seq_id )\n Function: get/set the _current_seq_id\n Returns : value of _current_seq_id\n Args    : new value (optional)\n\n\nsub _current_seq_id {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_current_seq_id'} = $value;\n    }\n    return $self->{'_current_seq_id'};\n}\n\n=head2 _current_seq_description\n\n Title   : _current_seq_description\n Usage   : $self->_current_seq_description( $current_seq_id )\n Function: get/set the _current_seq_description\n Returns : value of _current_seq_description\n Args    : new value (optional)\n\n\nsub _current_seq_description {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_current_seq_description'} = $value;\n    }\n    return $self->{'_current_seq_description'};\n}\n\n=head2 _current_parameters\n\n Title   : _current_parameters\n Usage   : $self->_current_parameters( $parameters_hashref )\n Function: get/set the _current_parameters\n Returns : hashref representing current parameters parsed from results file\n         : keys are\n               match_weight\n               mismatch_weight\n               indel_weight\n               match_prob\n               indel_prob\n               min_score\n               max_period_size\n Args    : parameters hashref (optional)\n\n\nsub _current_parameters {\n    my ( $self, $value ) = @_;\n    if ( defined $value ) {\n        $self->{'_current_parameters'} = $value;\n    }\n    return $self->{'_current_parameters'};\n}\n\n=head2 next_result\n\n Title   : next_result\n Usage   : my $r = $trf->next_result()\n Function: Get the next result set from parser data\n Returns : Bio::SeqFeature::Generic\n Args    : none\n\n\nsub next_result {\n    my ($self) = @_;\n    while ( defined( $_ = $self->_readline() ) ) {\n\n        # Parse Version line\n        if (/^Version (.+)/) {\n            my $version = $1;\n            $self->warn(\"parsed version: $version\\n\") if DEBUG;\n            $self->warn( qq{ Bio::Tools::TandemRepeatsFinder was written and tested for Tandem Repeats Masker Version 4.00 output\nYou appear to be using Verion $version.  Use at your own risk.}) if ($version != 4);\n            $self->version($version);\n        }\n\n        # Parse Sequence identifier\n        # i.e. Sequence: DDB0215018 |Masked Chromosomal Sequence| Chr 2f\n        elsif ( /^Sequence: ([^\\s]+)\\s(.+)/ ) {\n            my $seq_id          = $1;\n            my $seq_description = $2;\n            $self->warn(\"parsed sequence_id: $seq_id\\n\") if DEBUG;\n            $self->_current_seq_id($seq_id);\n            $self->_current_seq_description($seq_description);\n        }\n\n        # Parse Parameters\n        # i.e. Parameters: 2 7 7 80 10 50 12\n        elsif (/^Parameters: (.+)/) {\n            my $params = $1;\n            $self->warn(\"parsed parameters: $params\\n\") if DEBUG;\n\n            my @param_array = split /\\s/, $params;\n\n            my $param_hash = {\n                match_weight    => $param_array[0],\n                mismatch_weight => $param_array[1],\n                indel_weight    => $param_array[2],\n                match_prob      => $param_array[3],\n                indel_prob      => $param_array[4],\n                min_score       => $param_array[5],\n                max_period_size => $param_array[6]\n            };\n            $self->_current_parameters($param_hash);\n        }\n\n        # Parse Data\n        # i.e. 13936 13960 12 2.1 12 100 0 50 16 8 52 24 1.70 T TTTTTTTTTT\n        elsif (/^\\d+\\s\\d+\\s\\d+/) {\n\n            # call internal method to create Bio::SeqFeature::Generic\n            # to represent tandem repeat\n            return $self->_create_feature($_);\n        }\n\n        elsif (DEBUG) {\n            $self->warn( \"UNPARSED LINE:\\n\" . $_ );\n        }\n    }\n    return;\n}\n\n=head2 _create_feature\n\n Title   : _create_feature\n Usage   : internal method used by 'next_feature'\n Function: Takes a line from the results file and creates a bioperl object\n Returns : Bio::SeqFeature::Generic\n Args    : none","parameters":[{"label":"$self"},{"label":"$line"}],"label":"_create_feature($self,$line)"},"range":{"end":{"character":9999,"line":325},"start":{"line":281,"character":0}},"kind":12,"line":281,"detail":"($self,$line)","definition":"sub","name":"_create_feature","containerName":"main::","children":[{"line":282,"localvar":"my","kind":13,"containerName":"_create_feature","name":"$self","definition":"my"},{"line":282,"kind":13,"containerName":"_create_feature","name":"$line"},{"definition":"my","line":285,"name":"@element","containerName":"_create_feature","localvar":"my","kind":13},{"name":"$line","kind":13,"containerName":"_create_feature","line":285},{"line":286,"name":"$start","kind":13,"localvar":"my","containerName":"_create_feature","definition":"my"},{"line":287,"kind":13,"containerName":"_create_feature","name":"$end"},{"kind":13,"containerName":"_create_feature","name":"$period_size","line":287},{"kind":13,"containerName":"_create_feature","name":"$copy_number","line":288},{"containerName":"_create_feature","kind":13,"name":"$consensus_size","line":288},{"line":288,"kind":13,"containerName":"_create_feature","name":"$percent_matches"},{"kind":13,"containerName":"_create_feature","name":"$percent_indels","line":289},{"name":"$score","kind":13,"containerName":"_create_feature","line":289},{"name":"$percent_a","containerName":"_create_feature","kind":13,"line":289},{"kind":13,"containerName":"_create_feature","name":"$percent_c","line":290},{"kind":13,"containerName":"_create_feature","name":"$percent_g","line":290},{"name":"$percent_t","containerName":"_create_feature","kind":13,"line":290},{"line":291,"kind":13,"containerName":"_create_feature","name":"$entropy"},{"name":"$consensus_sequence","kind":13,"containerName":"_create_feature","line":291},{"name":"$repeat_sequence","containerName":"_create_feature","kind":13,"line":292},{"line":292,"name":"@element","kind":13,"containerName":"_create_feature"},{"definition":"my","name":"$tags","localvar":"my","kind":13,"containerName":"_create_feature","line":295},{"line":296,"name":"$period_size","kind":13,"containerName":"_create_feature"},{"name":"$copy_number","kind":13,"containerName":"_create_feature","line":297},{"kind":13,"containerName":"_create_feature","name":"$consensus_size","line":298},{"line":299,"containerName":"_create_feature","kind":13,"name":"$percent_matches"},{"name":"$percent_indels","containerName":"_create_feature","kind":13,"line":300},{"name":"$percent_a","kind":13,"containerName":"_create_feature","line":301},{"name":"$percent_c","kind":13,"containerName":"_create_feature","line":302},{"kind":13,"containerName":"_create_feature","name":"$percent_g","line":303},{"name":"$percent_t","containerName":"_create_feature","kind":13,"line":304},{"name":"$entropy","containerName":"_create_feature","kind":13,"line":305},{"name":"$consensus_sequence","containerName":"_create_feature","kind":13,"line":306},{"kind":13,"containerName":"_create_feature","name":"$repeat_sequence","line":307},{"line":308,"containerName":"_create_feature","kind":13,"name":"$self"},{"kind":12,"containerName":"_create_feature","name":"_current_parameters","line":308},{"containerName":"_create_feature","kind":13,"name":"$self","line":309},{"line":309,"name":"_current_seq_description","containerName":"_create_feature","kind":12},{"definition":"my","localvar":"my","kind":13,"containerName":"_create_feature","name":"$feat","line":313},{"line":313,"name":"new","containerName":"_create_feature","kind":12},{"name":"$self","kind":13,"containerName":"_create_feature","line":314},{"line":314,"name":"_current_seq_id","containerName":"_create_feature","kind":12},{"line":315,"name":"$score","kind":13,"containerName":"_create_feature"},{"line":316,"name":"$start","kind":13,"containerName":"_create_feature"},{"kind":13,"containerName":"_create_feature","name":"$end","line":317},{"name":"$tags","containerName":"_create_feature","kind":13,"line":321},{"name":"$feat","containerName":"_create_feature","kind":13,"line":323}]},{"line":296,"kind":12,"name":"period_size"},{"line":297,"kind":12,"name":"copy_number"},{"name":"consensus_size","kind":12,"line":298},{"line":299,"kind":12,"name":"percent_matches"},{"kind":12,"name":"percent_indels","line":300},{"name":"percent_a","kind":12,"line":301},{"line":302,"kind":12,"name":"percent_c"},{"name":"percent_g","kind":12,"line":303},{"kind":12,"name":"percent_t","line":304},{"name":"entropy","kind":12,"line":305},{"name":"consensus_sequence","kind":12,"line":306},{"line":307,"name":"repeat_sequence","kind":12},{"kind":12,"name":"run_parameters","line":308},{"name":"sequence_description","kind":12,"line":309},{"line":313,"name":"Bio","containerName":"SeqFeature::Generic","kind":12}],"version":5}