{"version":5,"vars":[{"line":113,"name":"base","containerName":"","kind":2},{"line":117,"name":"%MAPLOC","localvar":"my","kind":13,"containerName":null,"definition":"my"},{"kind":12,"range":{"end":{"character":9999,"line":145},"start":{"line":136,"character":0}},"line":136,"signature":{"label":"analysis_method($self,$method)","documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a","parameters":[{"label":"$self"},{"label":"$method"}]},"containerName":"main::","name":"analysis_method","children":[{"localvar":"my","containerName":"analysis_method","kind":13,"name":"$self","line":138,"definition":"my"},{"line":138,"name":"$method","containerName":"analysis_method","kind":13},{"line":140,"kind":13,"containerName":"analysis_method","name":"$method"},{"name":"$method","containerName":"analysis_method","kind":13,"line":140},{"line":141,"name":"$self","kind":13,"containerName":"analysis_method"},{"name":"throw","kind":12,"containerName":"analysis_method","line":141},{"line":141,"containerName":"analysis_method","kind":13,"name":"$self"},{"containerName":"analysis_method","kind":13,"name":"$self","line":144},{"line":144,"kind":13,"containerName":"analysis_method","name":"$method"}],"detail":"($self,$method)","definition":"sub"},{"name":"SUPER","kind":12,"containerName":"analysis_method","line":144},{"kind":12,"range":{"end":{"character":9999,"line":168},"start":{"character":0,"line":158}},"line":158,"signature":{"label":"network($self,$net)","parameters":[{"label":"$self"},{"label":"$net"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used"},"name":"network","containerName":"main::","children":[{"line":160,"name":"$self","kind":13,"localvar":"my","containerName":"network","definition":"my"},{"name":"$net","containerName":"network","kind":13,"line":160},{"name":"$net","containerName":"network","kind":13,"line":162},{"name":"$self","kind":13,"containerName":"network","line":163},{"line":163,"name":"$net","kind":13,"containerName":"network"},{"line":166,"kind":13,"containerName":"network","name":"$self"}],"detail":"($self,$net)","definition":"sub"},{"signature":{"parameters":[{"label":"$self"},{"label":"$cleavage"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not","label":"cleavage($self,$cleavage)"},"line":182,"kind":12,"range":{"start":{"character":0,"line":182},"end":{"line":192,"character":9999}},"definition":"sub","detail":"($self,$cleavage)","children":[{"definition":"my","line":184,"localvar":"my","kind":13,"containerName":"cleavage","name":"$self"},{"line":184,"kind":13,"containerName":"cleavage","name":"$cleavage"},{"name":"$cleavage","containerName":"cleavage","kind":13,"line":186},{"line":187,"kind":13,"containerName":"cleavage","name":"$self"},{"name":"$cleavage","kind":13,"containerName":"cleavage","line":187},{"line":190,"name":"$self","kind":13,"containerName":"cleavage"}],"containerName":"main::","name":"cleavage"},{"signature":{"label":"next_prediction($self)","documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a","parameters":[{"label":"$self"}]},"kind":12,"range":{"end":{"line":213,"character":9999},"start":{"line":204,"character":0}},"line":204,"detail":"($self)","definition":"sub","name":"next_prediction","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"next_prediction","localvar":"my","kind":13,"line":206},{"line":208,"name":"$self","kind":13,"containerName":"next_prediction"},{"line":208,"name":"_parsed","containerName":"next_prediction","kind":12},{"name":"$self","kind":13,"containerName":"next_prediction","line":209},{"line":209,"containerName":"next_prediction","kind":12,"name":"_parse_results"},{"line":210,"name":"$self","containerName":"next_prediction","kind":13},{"line":210,"name":"_parsed","containerName":"next_prediction","kind":12},{"line":213,"name":"$self","kind":13,"containerName":"next_prediction"}]},{"detail":"($self,$feat)","definition":"sub","containerName":"main::","name":"create_feature","children":[{"line":229,"containerName":"create_feature","localvar":"my","kind":13,"name":"$self","definition":"my"},{"line":229,"containerName":"create_feature","kind":13,"name":"$feat"},{"name":"$self","kind":13,"containerName":"create_feature","line":231},{"line":231,"name":"throw","kind":12,"containerName":"create_feature"},{"name":"$feat","kind":13,"containerName":"create_feature","line":231},{"containerName":"create_feature","kind":13,"name":"$feat","line":231},{"localvar":"my","containerName":"create_feature","kind":13,"name":"$feature","line":233,"definition":"my"},{"name":"new","containerName":"create_feature","kind":12,"line":233},{"kind":13,"containerName":"create_feature","name":"$feat","line":234},{"name":"$self","kind":13,"containerName":"create_feature","line":235},{"name":"analysis_method","kind":12,"containerName":"create_feature","line":235},{"line":240,"name":"$feat","containerName":"create_feature","kind":13},{"kind":13,"containerName":"create_feature","name":"$feature","line":241},{"line":241,"kind":12,"containerName":"create_feature","name":"start"},{"name":"$feature","containerName":"create_feature","kind":13,"line":242},{"line":242,"name":"end","containerName":"create_feature","kind":12},{"containerName":"create_feature","kind":13,"name":"$feat","line":242},{"line":244,"kind":13,"containerName":"create_feature","name":"$feature"},{"kind":12,"containerName":"create_feature","name":"add_tag_value","line":244},{"line":244,"containerName":"create_feature","kind":13,"name":"$MAPLOC"},{"line":244,"name":"$feat","kind":13,"containerName":"create_feature"},{"name":"$MAPLOC","containerName":"create_feature","kind":13,"line":244},{"line":244,"kind":13,"containerName":"create_feature","name":"$feat"},{"name":"$feature","kind":13,"containerName":"create_feature","line":245},{"name":"add_tag_value","kind":12,"containerName":"create_feature","line":245},{"containerName":"create_feature","kind":13,"name":"$feat","line":245},{"name":"$feat","containerName":"create_feature","kind":13,"line":245},{"line":246,"name":"$feature","containerName":"create_feature","kind":13},{"name":"add_tag_value","containerName":"create_feature","kind":12,"line":246},{"name":"$feat","containerName":"create_feature","kind":13,"line":246},{"line":246,"name":"$feat","containerName":"create_feature","kind":13},{"name":"$feature","kind":13,"containerName":"create_feature","line":247},{"line":247,"name":"add_tag_value","kind":12,"containerName":"create_feature"},{"name":"$feat","kind":13,"containerName":"create_feature","line":247},{"name":"$feat","containerName":"create_feature","kind":13,"line":247},{"kind":13,"containerName":"create_feature","name":"$feature","line":248},{"kind":12,"containerName":"create_feature","name":"add_tag_value","line":248},{"line":248,"name":"$feat","containerName":"create_feature","kind":13},{"line":248,"containerName":"create_feature","kind":13,"name":"$feat"},{"containerName":"create_feature","kind":13,"name":"$feature","line":249},{"line":249,"containerName":"create_feature","kind":12,"name":"add_tag_value"},{"name":"$feat","kind":13,"containerName":"create_feature","line":249},{"kind":13,"containerName":"create_feature","name":"$feat","line":249},{"line":250,"name":"$feature","kind":13,"containerName":"create_feature"},{"line":250,"kind":12,"containerName":"create_feature","name":"add_tag_value"},{"containerName":"create_feature","kind":13,"name":"$feat","line":250},{"line":250,"name":"$feat","kind":13,"containerName":"create_feature"},{"line":252,"name":"$feature","containerName":"create_feature","kind":13},{"name":"add_tag_value","containerName":"create_feature","kind":12,"line":252},{"name":"$self","containerName":"create_feature","kind":13,"line":252},{"name":"network","kind":12,"containerName":"create_feature","line":252},{"line":254,"containerName":"create_feature","kind":13,"name":"$feature"}],"signature":{"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference","parameters":[{"label":"$self"},{"label":"$feat"}],"label":"create_feature($self,$feat)"},"range":{"end":{"line":256,"character":9999},"start":{"character":0,"line":227}},"kind":12,"line":227},{"name":"Bio","kind":12,"containerName":"SeqFeature::Generic","line":233},{"kind":12,"name":"seqid","line":234},{"line":240,"kind":12,"name":"seqlen"},{"line":242,"kind":12,"name":"seqlen"},{"kind":12,"name":"loc","line":244},{"line":244,"kind":12,"name":"loc"},{"kind":12,"name":"cTP","line":245},{"name":"cTP","kind":12,"line":245},{"line":246,"name":"mTP","kind":12},{"kind":12,"name":"mTP","line":246},{"line":247,"name":"SP","kind":12},{"line":247,"kind":12,"name":"SP"},{"kind":12,"name":"other","line":248},{"name":"other","kind":12,"line":248},{"line":249,"kind":12,"name":"RC"},{"line":249,"name":"RC","kind":12},{"kind":12,"name":"TPLen","line":250},{"line":250,"kind":12,"name":"TPLen"},{"line":286,"kind":12,"range":{"end":{"line":303,"character":9999},"start":{"line":286,"character":0}},"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :","label":"_initialize_state($self,@args)"},"children":[{"definition":"my","localvar":"my","kind":13,"containerName":"_initialize_state","name":"$self","line":288},{"kind":13,"containerName":"_initialize_state","name":"@args","line":288},{"line":290,"name":"$self","containerName":"_initialize_state","kind":13},{"line":290,"kind":13,"containerName":"_initialize_state","name":"@args"},{"line":293,"kind":13,"containerName":"_initialize_state","name":"$self"},{"line":294,"kind":13,"containerName":"_initialize_state","name":"$self"},{"kind":13,"containerName":"_initialize_state","name":"$self","line":295},{"name":"$self","containerName":"_initialize_state","kind":13,"line":296},{"line":297,"name":"$self","containerName":"_initialize_state","kind":13},{"containerName":"_initialize_state","kind":13,"name":"$self","line":298},{"name":"$self","kind":13,"containerName":"_initialize_state","line":300},{"containerName":"_initialize_state","kind":12,"name":"analysis_method","line":300}],"name":"_initialize_state","containerName":"main::","definition":"sub","detail":"($self,@args)"},{"name":"SUPER","kind":12,"containerName":"_initialize_state","line":290},{"line":314,"range":{"end":{"character":9999,"line":318},"start":{"line":314,"character":0}},"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a","label":"_predictions($self)"},"children":[{"definition":"my","line":316,"name":"$self","localvar":"my","kind":13,"containerName":"_predictions"},{"line":318,"containerName":"_predictions","kind":13,"name":"$self"}],"name":"_predictions","containerName":"main::","definition":"sub","detail":"($self)"},{"kind":12,"range":{"start":{"line":334,"character":0},"end":{"line":343,"character":9999}},"line":334,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting","label":"_parsed($self,$value)"},"name":"_parsed","containerName":"main::","children":[{"name":"$self","containerName":"_parsed","localvar":"my","kind":13,"line":336,"definition":"my"},{"line":336,"name":"$value","containerName":"_parsed","kind":13},{"line":338,"name":"$value","kind":13,"containerName":"_parsed"},{"line":339,"name":"$self","containerName":"_parsed","kind":13},{"line":339,"kind":13,"containerName":"_parsed","name":"$value"},{"line":342,"name":"$self","containerName":"_parsed","kind":13}],"detail":"($self,$value)","definition":"sub"},{"containerName":"main::","name":"_parse_results","children":[{"definition":"my","line":361,"containerName":"_parse_results","localvar":"my","kind":13,"name":"$self"},{"line":376,"name":"$line","localvar":"my","kind":13,"containerName":"_parse_results","definition":"my"},{"line":376,"containerName":"_parse_results","kind":13,"name":"$self"},{"name":"_readline","kind":12,"containerName":"_parse_results","line":376},{"line":378,"name":"$line","kind":13,"containerName":"_parse_results"},{"containerName":"_parse_results","kind":13,"name":"$self","line":380},{"line":380,"name":"analysis_method_version","containerName":"_parse_results","kind":12},{"kind":13,"containerName":"_parse_results","name":"$line","line":382},{"name":"$self","kind":13,"containerName":"_parse_results","line":384},{"line":384,"name":"cleavage","containerName":"_parse_results","kind":12},{"line":386,"name":"$line","kind":13,"containerName":"_parse_results"},{"containerName":"_parse_results","kind":13,"name":"$self","line":388},{"line":388,"kind":12,"containerName":"_parse_results","name":"network"},{"containerName":"_parse_results","kind":13,"name":"$line","line":390},{"name":"$self","kind":13,"containerName":"_parse_results","line":393},{"line":393,"name":"_readline","containerName":"_parse_results","kind":12},{"localvar":"my","containerName":"_parse_results","kind":13,"name":"$hash","line":395,"definition":"my"},{"line":397,"localvar":"my","containerName":"_parse_results","kind":13,"name":"$line","definition":"my"},{"line":397,"name":"$self","containerName":"_parse_results","kind":13},{"kind":12,"containerName":"_parse_results","name":"_readline","line":397},{"containerName":"_parse_results","kind":13,"name":"$line","line":399},{"line":401,"name":"$hash","containerName":"_parse_results","localvar":"my","kind":13,"definition":"my"},{"containerName":"_parse_results","kind":13,"name":"$self","line":401},{"line":401,"name":"_parse_line","containerName":"_parse_results","kind":12},{"line":401,"name":"$line","kind":13,"containerName":"_parse_results"},{"line":403,"name":"$new_feature","containerName":"_parse_results","localvar":"my","kind":13,"definition":"my"},{"line":403,"name":"$self","containerName":"_parse_results","kind":13},{"line":403,"kind":12,"containerName":"_parse_results","name":"create_feature"},{"containerName":"_parse_results","kind":13,"name":"$hash","line":403},{"kind":13,"containerName":"_parse_results","name":"$self","line":405},{"kind":12,"containerName":"_parse_results","name":"_add_feature","line":405},{"name":"$new_feature","kind":13,"containerName":"_parse_results","line":405}],"detail":"($self)","definition":"sub","kind":12,"range":{"end":{"character":9999,"line":411},"start":{"character":0,"line":359}},"line":359,"signature":{"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting\n\n\nsub _parsed {\n\n    my($self, $value) = @_;\n\n    if(defined($value)){\n\t$self->{'_parsed'} = $value;\n    }\n\n    return $self->{'_parsed'};\n}\n\n\n\n=head2 _parse_results\n\n  Title    : _parse_results\n  Usage    : $self->_parse_results()\n  Function : This method parses a TargetP output\n             For internal use only\n  Example  :\n  Returns  : n/a\n  Arguments: none","parameters":[{"label":"$self"}],"label":"_parse_results($self)"}},{"signature":{"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting\n\n\nsub _parsed {\n\n    my($self, $value) = @_;\n\n    if(defined($value)){\n\t$self->{'_parsed'} = $value;\n    }\n\n    return $self->{'_parsed'};\n}\n\n\n\n=head2 _parse_results\n\n  Title    : _parse_results\n  Usage    : $self->_parse_results()\n  Function : This method parses a TargetP output\n             For internal use only\n  Example  :\n  Returns  : n/a\n  Arguments: none\n\n\nsub _parse_results {\n\n    my($self) = @_;\n\n\n    ### targetp v1.1 prediction results ##################################\n    #Number of query sequences:  11\n    #Cleavage site predictions included.\n    #Using NON-PLANT networks.\n    #\n    #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n    #----------------------------------------------------------------------\n    #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n    #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n    #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n    while(defined(my $line = $self->_readline())){\n\n\tif($line =~ /targetp (v[\\d\\.]+)/){\n\n\t    $self->analysis_method_version($1);\n\n\t}elsif($line =~ /Cleavage site predictions (.*)/){\n\n\t    $self->cleavage($1);\n\n\t}elsif($line =~ /Using (\\S+) networks/){\n\n\t    $self->network($1);\n\n\t}elsif($line =~ /^Name/){\n\n\t    #We skip the next line which is '------------------'\n\t    $self->_readline();\n\n\t    my $hash = { };\n\n\t    while(defined(my $line = $self->_readline())){\n\n\t\tlast if($line =~ /^----/);\n\n\t\tmy $hash = $self->_parse_line($line);\n\n\t\tmy $new_feature = $self->create_feature($hash);\n\t\t\n\t\t$self->_add_feature($new_feature);\n\t    }\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_line\n\n Title    : _parse_line\n Usage    : $self->_parse_line($line)\n Function : This method parses the line result\n            For internal use only\n Example  :\n Returns  : Hash reference\n Arguemnts: line to parse","parameters":[{"label":"$self"},{"label":"$line"}],"label":"_parse_line($self,$line)"},"line":425,"range":{"end":{"line":456,"character":9999},"start":{"character":0,"line":425}},"kind":12,"definition":"sub","detail":"($self,$line)","children":[{"definition":"my","line":427,"name":"$self","localvar":"my","containerName":"_parse_line","kind":13},{"line":427,"containerName":"_parse_line","kind":13,"name":"$line"},{"kind":13,"containerName":"_parse_line","name":"$self","line":429},{"line":429,"kind":12,"containerName":"_parse_line","name":"throw"},{"line":429,"name":"$line","kind":13,"containerName":"_parse_line"},{"definition":"my","localvar":"my","containerName":"_parse_line","kind":13,"name":"$hash","line":431},{"definition":"my","name":"$seqid","localvar":"my","containerName":"_parse_line","kind":13,"line":432},{"containerName":"_parse_line","kind":13,"name":"$seqlen","line":432},{"kind":13,"containerName":"_parse_line","name":"$cTP","line":432},{"line":432,"name":"$mTP","kind":13,"containerName":"_parse_line"},{"kind":13,"containerName":"_parse_line","name":"$SP","line":432},{"containerName":"_parse_line","kind":13,"name":"$other","line":432},{"name":"$loc","containerName":"_parse_line","kind":13,"line":432},{"line":432,"kind":13,"containerName":"_parse_line","name":"$RC"},{"name":"$TPlen","kind":13,"containerName":"_parse_line","line":432},{"line":434,"containerName":"_parse_line","kind":13,"name":"$self"},{"line":434,"kind":12,"containerName":"_parse_line","name":"network"},{"name":"$seqid","kind":13,"containerName":"_parse_line","line":436},{"line":436,"name":"$seqlen","kind":13,"containerName":"_parse_line"},{"line":436,"name":"$mTP","kind":13,"containerName":"_parse_line"},{"name":"$SP","containerName":"_parse_line","kind":13,"line":436},{"line":436,"name":"$other","containerName":"_parse_line","kind":13},{"line":436,"kind":13,"containerName":"_parse_line","name":"$loc"},{"line":436,"kind":13,"containerName":"_parse_line","name":"$RC"},{"line":436,"name":"$TPlen","containerName":"_parse_line","kind":13},{"name":"$line","containerName":"_parse_line","kind":13,"line":436},{"line":440,"name":"$seqid","kind":13,"containerName":"_parse_line"},{"kind":13,"containerName":"_parse_line","name":"$seqlen","line":440},{"line":440,"kind":13,"containerName":"_parse_line","name":"$cTP"},{"line":440,"name":"$mTP","kind":13,"containerName":"_parse_line"},{"line":440,"name":"$SP","containerName":"_parse_line","kind":13},{"kind":13,"containerName":"_parse_line","name":"$other","line":440},{"containerName":"_parse_line","kind":13,"name":"$loc","line":440},{"line":440,"kind":13,"containerName":"_parse_line","name":"$RC"},{"line":440,"name":"$TPlen","kind":13,"containerName":"_parse_line"},{"line":440,"name":"$line","kind":13,"containerName":"_parse_line"},{"line":444,"containerName":"_parse_line","kind":13,"name":"$hash"},{"line":444,"name":"$seqid","containerName":"_parse_line","kind":13},{"line":445,"containerName":"_parse_line","kind":13,"name":"$hash"},{"line":445,"containerName":"_parse_line","kind":13,"name":"$seqlen"},{"containerName":"_parse_line","kind":13,"name":"$hash","line":446},{"line":446,"name":"$cTP","kind":13,"containerName":"_parse_line"},{"line":447,"containerName":"_parse_line","kind":13,"name":"$hash"},{"name":"$mTP","containerName":"_parse_line","kind":13,"line":447},{"line":448,"name":"$hash","containerName":"_parse_line","kind":13},{"containerName":"_parse_line","kind":13,"name":"$SP","line":448},{"line":449,"name":"$hash","kind":13,"containerName":"_parse_line"},{"line":449,"name":"$other","kind":13,"containerName":"_parse_line"},{"kind":13,"containerName":"_parse_line","name":"$hash","line":450},{"line":450,"name":"$loc","containerName":"_parse_line","kind":13},{"line":451,"kind":13,"containerName":"_parse_line","name":"$hash"},{"name":"$RC","containerName":"_parse_line","kind":13,"line":451},{"line":452,"name":"$hash","containerName":"_parse_line","kind":13},{"line":452,"name":"$TPlen","kind":13,"containerName":"_parse_line"},{"line":452,"containerName":"_parse_line","kind":13,"name":"$TPlen"},{"line":452,"name":"$TPlen","kind":13,"containerName":"_parse_line"},{"line":454,"name":"$hash","kind":13,"containerName":"_parse_line"}],"containerName":"main::","name":"_parse_line"},{"kind":12,"name":"seqid","line":444},{"line":445,"kind":12,"name":"seqlen"},{"kind":12,"name":"cTP","line":446},{"line":447,"kind":12,"name":"mTP"},{"line":448,"kind":12,"name":"SP"},{"line":449,"kind":12,"name":"other"},{"name":"loc","kind":12,"line":450},{"name":"RC","kind":12,"line":451},{"kind":12,"name":"TPLen","line":452},{"definition":"sub","detail":"($self,$feature)","children":[{"definition":"my","name":"$self","localvar":"my","kind":13,"containerName":"_add_feature","line":472},{"containerName":"_add_feature","kind":13,"name":"$feature","line":472},{"kind":13,"containerName":"_add_feature","name":"$self","line":474},{"containerName":"_add_feature","kind":12,"name":"throw","line":474},{"line":474,"name":"$feature","containerName":"_add_feature","kind":13},{"line":474,"containerName":"_add_feature","kind":12,"name":"isa"},{"name":"$self","containerName":"_add_feature","kind":13,"line":476}],"name":"_add_feature","containerName":"main::","signature":{"label":"_add_feature($self,$feature)","documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting\n\n\nsub _parsed {\n\n    my($self, $value) = @_;\n\n    if(defined($value)){\n\t$self->{'_parsed'} = $value;\n    }\n\n    return $self->{'_parsed'};\n}\n\n\n\n=head2 _parse_results\n\n  Title    : _parse_results\n  Usage    : $self->_parse_results()\n  Function : This method parses a TargetP output\n             For internal use only\n  Example  :\n  Returns  : n/a\n  Arguments: none\n\n\nsub _parse_results {\n\n    my($self) = @_;\n\n\n    ### targetp v1.1 prediction results ##################################\n    #Number of query sequences:  11\n    #Cleavage site predictions included.\n    #Using NON-PLANT networks.\n    #\n    #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n    #----------------------------------------------------------------------\n    #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n    #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n    #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n    while(defined(my $line = $self->_readline())){\n\n\tif($line =~ /targetp (v[\\d\\.]+)/){\n\n\t    $self->analysis_method_version($1);\n\n\t}elsif($line =~ /Cleavage site predictions (.*)/){\n\n\t    $self->cleavage($1);\n\n\t}elsif($line =~ /Using (\\S+) networks/){\n\n\t    $self->network($1);\n\n\t}elsif($line =~ /^Name/){\n\n\t    #We skip the next line which is '------------------'\n\t    $self->_readline();\n\n\t    my $hash = { };\n\n\t    while(defined(my $line = $self->_readline())){\n\n\t\tlast if($line =~ /^----/);\n\n\t\tmy $hash = $self->_parse_line($line);\n\n\t\tmy $new_feature = $self->create_feature($hash);\n\t\t\n\t\t$self->_add_feature($new_feature);\n\t    }\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_line\n\n Title    : _parse_line\n Usage    : $self->_parse_line($line)\n Function : This method parses the line result\n            For internal use only\n Example  :\n Returns  : Hash reference\n Arguemnts: line to parse\n\n\nsub _parse_line {\n\n    my($self, $line) = @_;\n\n    $self->throw(\"No line to parse given\") unless($line);\n\n    my $hash = { };\n    my ($seqid, $seqlen, $cTP, $mTP, $SP, $other, $loc, $RC, $TPlen);\n\n    if($self->network() eq 'NON-PLANT'){\n\n\t($seqid, $seqlen, $mTP, $SP, $other, $loc, $RC, $TPlen) = split(/\\s+/, $line);\n\n    }else{\n\n\t($seqid, $seqlen, $cTP, $mTP, $SP, $other, $loc, $RC, $TPlen) = split(/\\s+/, $line);\n\n    }\n\n    $hash->{seqid}  = $seqid;\n    $hash->{seqlen} = $seqlen;\n    $hash->{cTP}    = $cTP || undef;\n    $hash->{mTP}    = $mTP;\n    $hash->{SP}     = $SP;\n    $hash->{other}  = $other;\n    $hash->{loc}    = $loc;\n    $hash->{RC}     = $RC;\n    $hash->{TPLen}  = ($TPlen && $TPlen =~ /\\d+/) ? $TPlen : undef;\n\n    return $hash;\n\n}\n\n=head2 _add_feature\n\n Title    : _add_feature\n Usage    : $self->_add_feature($feature)\n Function : This method stores a feature object\n            For internal use only\n Example  :\n Returns  : n/a\n Arguments: Bio::SeqFeature::Generic","parameters":[{"label":"$self"},{"label":"$feature"}]},"line":470,"range":{"end":{"character":9999,"line":476},"start":{"line":470,"character":0}},"kind":12},{"line":476,"containerName":null,"kind":13,"name":"$feature"},{"detail":"($self,$key)","definition":"sub","containerName":"main::","name":"_toString_location","children":[{"line":497,"localvar":"my","kind":13,"containerName":"_toString_location","name":"$self","definition":"my"},{"line":497,"containerName":"_toString_location","kind":13,"name":"$key"},{"name":"$key","kind":13,"containerName":"_toString_location","line":499},{"kind":13,"containerName":"_toString_location","name":"$MAPLOC","line":499},{"name":"$key","kind":13,"containerName":"_toString_location","line":499},{"line":500,"name":"$MAPLOC","containerName":"_toString_location","kind":13},{"name":"$key","containerName":"_toString_location","kind":13,"line":500}],"signature":{"documentation":"1;\n# $Id: TargetP.pm 16147 2009-09-22 01:26:32Z cjfields $\n#\n# Bioperl module for TargetP\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Emmanuel Quevillon <emmanuel.quevillon@versailles.inra.fr>\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Tools::TargetP - Results of one TargetP run\n\n=head1 SYNOPSIS\n\n   use Bio::Tools::TargetP;\n\n   #filename for  TargetP result :\n   $targetp = Bio::Tools::TargetP->new(-file => 'targetp.out');\n\n   # filehandle for TargetP :\n   $targetp = Bio::Tools::TargetP->new( -fh  => \\*INPUT );\n\n   ### targetp v1.1 prediction results ##################################\n   #Number of query sequences:  11\n   #Cleavage site predictions included.\n   #Using NON-PLANT networks.\n   #\n   #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n   #----------------------------------------------------------------------\n   #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n   #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n   #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n\n   # parse the results\n   while($feature = $targetp->next_prediction()) {\n\n           #$feature is a Bio::SeqFeature::Generic object\n           my $method     = $targetp->analysis_method();\n           my $vesion     = $targetp->analysis_method_version() || $feature->source();\n           my $seqid      = $feature->seq_id();\n           # ...\n     }\n\n   # essential if you gave a filename at initialization (otherwise the file\n   # will stay open)\n   $targetp->close();\n\n=head1 DESCRIPTION\n\nTargetP modules will provides parsed informations about protein\nlocalization.  It reads in a targetp output file.  It parses the\nresults, and returns a Bio::SeqFeature::Generic object for each\nseqeunces found to have a subcellular localization\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Emmanuel Quevillon\n\nEmail emmanuel.quevillon@versailles.inra.fr\n\nDescribe contact details here\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Tools::TargetP;\nuse strict;\nuse Bio::Tools::AnalysisResult;\nuse Bio::SeqFeature::Generic;\nuse Data::Dumper;\n\nuse base qw(Bio::Tools::AnalysisResult);\n\n\n#Definition of 'Loc' field according to http://www.cbs.dtu.dk/services/TargetP/output.php\nmy $MAPLOC = {\n\t      'S' => 'Secretory pathway',\n\t      'M' => 'Mitochondrion',\n\t      'C' => 'Chloroplast',\n\t      '_' => 'Any other',\n\t      '*' => 'Unknown',\n\t      '?' => 'Unknown',\n\t     };\n\n\n=head1 analysis_method\n\n Usage     : $self->analysis_method();\n Purpose   : Inherited method. Overridden to ensure that the name matches\n Returns   : String\n Argument  : n/a\n\n\nsub analysis_method {\n\n    my ($self, $method) = @_;\n\n    if($method && ($method !~ /TargetP/i)) {\n\t$self->throw(\"method $method not supported in \" . ref($self));\n    }\n\n    return $self->SUPER::analysis_method($method);\n}\n\n=head1 network\n\n  Title   : network\n  Usage   : $self->network($network)\n  Function: This method Get/Set the network used for the analysis (PLANT or NON-PLANT)\n  Example :\n  Returns : string\n  Arguments: On set, the network used\n\n\nsub network {\n\n    my($self, $net) = @_;\n\n    if(defined($net)){\n\t$self->{'_network'} = $net;\n    }\n\n    return $self->{'_network'};\n\n}\n\n\n=head1 cleavage\n\n  Title    :  cleavage\n  Usage    : $self->cleavage($cleavage)\n  Function : This method Get/Set if SignalP program was used to run TargetP\n  Example  :\n  Returns  : 1 or 0\n  Arguments: On set, the cleavage used or not\n\n\nsub cleavage {\n\n    my($self, $cleavage) = @_;\n\n    if(defined($cleavage)){\n\t$self->{'_cleavage'} = $cleavage =~ /not included/ ? '0' : '1';\n    }\n\n    return $self->{'_cleavage'};\n\n}\n\n\n=head1 next_prediction\n\n  Usage    : $targetp->next_prediction()\n  Purpose  : Returns the next TargetP prediction\n  Returns  : A Bio::SeqFeature::Generic object\n  Arguments: n/a\n\n\nsub next_prediction {\n\n    my($self) = @_;\n\n    unless($self->_parsed()){\n\t$self->_parse_results();\n\t$self->_parsed(1);\n    }\n\n    return shift @{$self->{'_features'}} || undef;\n}\n\n=head1 create_feature\n\n  Title     : create_feature\n  Usage     : $self->create_feature(\\%hash);\n  Function  : This method creates a new Bio::SeqFeature::Generic object\n  Example   : \n  Returns   : Bio::SeqFeature::Generic\n  Arguments : hash reference\n\n\nsub create_feature {\n\n    my($self, $feat) = @_;\n\n    $self->throw(\"Need a reference to hash table\") unless($feat && ref($feat) eq 'HASH');\n\n    my $feature = Bio::SeqFeature::Generic->new(\n\t\t\t\t\t\t-seq_id      => $feat->{seqid},\n\t\t\t\t\t\t-source_tag  => $self->analysis_method(),\n\t\t\t\t\t\t-primary_tag => 'signal_peptide',        #Sequence Ontology compliant\n\t\t\t\t\t\t-strand      => '+',\n\t\t\t\t\t       );\n\n    if(defined($feat->{seqlen})){\n\t$feature->start(1);\n\t$feature->end($feat->{seqlen});\n    }\n    $feature->add_tag_value('location',            $MAPLOC->{$feat->{loc}})   if(exists($MAPLOC->{$feat->{loc}}));\n    $feature->add_tag_value('chloroplastCutOff',   $feat->{cTP})              if(defined($feat->{cTP}));\n    $feature->add_tag_value('mitochondrionCutOff', $feat->{mTP})              if(defined($feat->{mTP}));\n    $feature->add_tag_value('signalPeptideCutOff', $feat->{SP})               if(defined($feat->{SP}));\n    $feature->add_tag_value('otherCutOff',         $feat->{other})            if(defined($feat->{other}));\n    $feature->add_tag_value('reliabilityClass',    $feat->{RC})               if(defined($feat->{RC}));\n    $feature->add_tag_value('signalPeptideLength', $feat->{TPLen})            if(defined($feat->{TPLen}));\n\n    $feature->add_tag_value('network',             $self->network());\n\n    return $feature;\n\n}\n\n\n=head2 PRIVATE METHODS\n\n\n=head2 _initialize_state\n\n Title   : _initialize_state\n Usage   : n/a; usually called by _initialize() itself called by new()\n Function: This method is supposed to reset the state such that any 'history'\n           is lost. State information that does not change during object\n           lifetime is not considered as history, e.g. parent, name, etc shall\n           not be reset. An inheriting object should only be concerned with\n           state information it introduces itself, and for everything else\n           call SUPER::_initialize_state(@args).\n\n           The argument syntax is the same as for new() and _initialize(),\n           i.e., named parameters following the -name=>$value convention.\n           The following parameters are dealt with by the implementation\n           provided here:\n              -INPUT, -FH, -FILE\n           (tags are case-insensitive).\n Example :\n Returns :\n Args    :\n\n\nsub _initialize_state  {\n\n  \tmy ($self,@args,) = @_;\n  \t# first call the inherited method!\n  \t$self->SUPER::_initialize_state(@args);\n\n  \t# our private state variables\n  \t$self->{'_features'}   = [ ];\n  \t$self->{'_parameters'} = undef;\n\t$self->{'_format'}     = undef;\n\t$self->{'_network'}    = undef;\n\t$self->{'_cleavage'}   = undef;\n\t$self->{'_parsed'}     = 0;\n\n  \t$self->analysis_method('TargetP');\n\n\treturn 1;\n}\n\n=head2 _predictions\n\n  Usage    : $targetp->_prediction()\n  Purpose  : Returns the number of TargetP predictions\n  Returns  : A scalar (number)\n  Arguments: n/a\n\n\nsub _predictions {\n\n    my($self) = @_;\n\n    return scalar(@{$self->{'_features'}}) || 0;\n}\n\n\n=head2 _parsed\n\n Title     : _parsed\n Usage     : $targetp->_parsed(1)\n Function  : This method is used to know if the output result is parsed or not\n             For internal use only\n Example   :\n Returns   : 1/0\n Arguments : 1/0 for setting\n\n\nsub _parsed {\n\n    my($self, $value) = @_;\n\n    if(defined($value)){\n\t$self->{'_parsed'} = $value;\n    }\n\n    return $self->{'_parsed'};\n}\n\n\n\n=head2 _parse_results\n\n  Title    : _parse_results\n  Usage    : $self->_parse_results()\n  Function : This method parses a TargetP output\n             For internal use only\n  Example  :\n  Returns  : n/a\n  Arguments: none\n\n\nsub _parse_results {\n\n    my($self) = @_;\n\n\n    ### targetp v1.1 prediction results ##################################\n    #Number of query sequences:  11\n    #Cleavage site predictions included.\n    #Using NON-PLANT networks.\n    #\n    #Name                  Len            mTP     SP  other  Loc  RC  TPlen\n    #----------------------------------------------------------------------\n    #swall|Q9LIP3|C72Y_AR  500          0.245  0.935  0.009   S    2     22\n    #swall|Q52813|AAPQ_RH  400          0.170  0.462  0.577   _    5      -\n    #swall|O86459|AAT_RHI  400          0.346  0.046  0.660   _    4      -\n\n\n    while(defined(my $line = $self->_readline())){\n\n\tif($line =~ /targetp (v[\\d\\.]+)/){\n\n\t    $self->analysis_method_version($1);\n\n\t}elsif($line =~ /Cleavage site predictions (.*)/){\n\n\t    $self->cleavage($1);\n\n\t}elsif($line =~ /Using (\\S+) networks/){\n\n\t    $self->network($1);\n\n\t}elsif($line =~ /^Name/){\n\n\t    #We skip the next line which is '------------------'\n\t    $self->_readline();\n\n\t    my $hash = { };\n\n\t    while(defined(my $line = $self->_readline())){\n\n\t\tlast if($line =~ /^----/);\n\n\t\tmy $hash = $self->_parse_line($line);\n\n\t\tmy $new_feature = $self->create_feature($hash);\n\t\t\n\t\t$self->_add_feature($new_feature);\n\t    }\n\t}\n    }\n\n    return;\n}\n\n=head2 _parse_line\n\n Title    : _parse_line\n Usage    : $self->_parse_line($line)\n Function : This method parses the line result\n            For internal use only\n Example  :\n Returns  : Hash reference\n Arguemnts: line to parse\n\n\nsub _parse_line {\n\n    my($self, $line) = @_;\n\n    $self->throw(\"No line to parse given\") unless($line);\n\n    my $hash = { };\n    my ($seqid, $seqlen, $cTP, $mTP, $SP, $other, $loc, $RC, $TPlen);\n\n    if($self->network() eq 'NON-PLANT'){\n\n\t($seqid, $seqlen, $mTP, $SP, $other, $loc, $RC, $TPlen) = split(/\\s+/, $line);\n\n    }else{\n\n\t($seqid, $seqlen, $cTP, $mTP, $SP, $other, $loc, $RC, $TPlen) = split(/\\s+/, $line);\n\n    }\n\n    $hash->{seqid}  = $seqid;\n    $hash->{seqlen} = $seqlen;\n    $hash->{cTP}    = $cTP || undef;\n    $hash->{mTP}    = $mTP;\n    $hash->{SP}     = $SP;\n    $hash->{other}  = $other;\n    $hash->{loc}    = $loc;\n    $hash->{RC}     = $RC;\n    $hash->{TPLen}  = ($TPlen && $TPlen =~ /\\d+/) ? $TPlen : undef;\n\n    return $hash;\n\n}\n\n=head2 _add_feature\n\n Title    : _add_feature\n Usage    : $self->_add_feature($feature)\n Function : This method stores a feature object\n            For internal use only\n Example  :\n Returns  : n/a\n Arguments: Bio::SeqFeature::Generic\n\n\nsub _add_feature {\n\n    my($self, $feature) = @_;\n\n    $self->throw(\"Need a Bio::SeqFeature::Generic object\") unless $feature->isa(\"Bio::SeqFeature::Generic\");\n\n    push(@{$self->{'_features'}}, $feature);\n\n    return;\n\n}\n\n=head2 _toString_location\n\n Title    : _toString_location\n Usage    : $self->_toString_location($key)\n Function : This method convert the 'one letter code' location to \n            the corresponding definition\n            For internal use only\n Example  :\n Returns  : Location or undef\n Arguments: String","parameters":[{"label":"$self"},{"label":"$key"}],"label":"_toString_location($self,$key)"},"range":{"start":{"line":495,"character":0},"end":{"character":9999,"line":504}},"kind":12,"line":495}]}